<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'es_mx', version '5.0'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Acciones';
$string['active'] = 'Activo';
$string['activeprograms'] = 'Programas activos';
$string['activeprogramslink'] = '<a href="{$a->href}">Programas activos: {$a->count}</a>';
$string['addcourses'] = 'Añadir cursos';
$string['addcourseslist_help'] = 'Uno o más cursos pueden ser seleccionados';
$string['addset'] = 'Añadir conjunto';
$string['addsetorcourse'] = 'Añadir un conjunto o un curso';
$string['afterallocationwindowstarts'] = 'Después del inicio de asignación';
$string['afterduedate'] = 'Después de la fecha esperada';
$string['afterstartdate'] = 'Después de la fecha de inicio';
$string['afteruserallocationdate'] = 'Después de la fecha de asignación de usuario';
$string['allinanyorder'] = 'Todo en cualquier orden';
$string['allinorder'] = 'Todo en orden';
$string['allocateusers'] = 'Asignar usuarios';
$string['allocationdate'] = 'Fecha de asignación';
$string['allocationdateonorafter'] = 'Fecha de asignación en o después de';
$string['allocationenddate'] = 'Fecha de fin de asignación';
$string['allocationenddate_help'] = 'Fecha de fin para asignar usuarios dentro de este programa';
$string['allocationfor'] = 'Asignación para \'{$a}\'';
$string['allocationsource'] = 'Origen de asignación';
$string['allocationstartdate'] = 'Fecha de inicio de asignación';
$string['allocationstartdate_help'] = 'Fecha de inicio para asignar usuarios dentro de este programa';
$string['allocationwindow'] = 'Ventana de asignación';
$string['allowdirectallocation'] = 'Permitir asignación directa';
$string['allowdirectallocation_help'] = 'Permite la asignación directa de usuarios dentro de este programa';
$string['archive'] = 'Archivar';
$string['archived'] = 'Archivado';
$string['archivedconfirmation'] = '¿Está seguro de querer archivar el programa \'{$a}\'? El programa archivado ya no estará disponible para mánagers ni estudiantes y solamente podría ser visto en reportes históricos.';
$string['archivedon'] = 'Archivado en';
$string['archivedprograms'] = 'Programas archivados';
$string['assfirstchildof'] = 'Como el primer hijo de "{$a}"';
$string['associatedcertification'] = 'Certificación asociada';
$string['associatedcertifications'] = 'Certificaciones asociadas';
$string['atleast'] = 'Al menos';
$string['availability'] = 'Disponibilidad';
$string['available'] = 'Disponible';
$string['beforeenddate'] = 'Antes de la fecha de terminación';
$string['calendar'] = 'Horario-Agenda';
$string['calendarduedate'] = 'Fecha esparada para el programa {$a}';
$string['calendarenddate'] = 'Fecha de fin para programa {$a}';
$string['certification'] = 'Certificación';
$string['certificationduedate'] = 'Fecha esperada de certificación';
$string['certificationmsgactive'] = 'La certificación <strong>"{$a->fullname}"</strong> debe estar completada para <strong>{$a->date}</strong>';
$string['certificationmsgcompleted'] = 'La certificación <strong>"{$a->fullname}"</strong> está completada';
$string['certificationmsgcompletedexpired'] = 'La certificación <strong>"{$a->fullname}"</strong> está completada. Expirará e <strong>{$a->date}</strong>';
$string['certificationmsgduedatenotset'] = 'La certificación <strong>"{$a->fullname}"</strong> no tiene fecha esperada configurada';
$string['certificationmsgexpired'] = 'La certificación <strong>"{$a->fullname}"</strong> expiró en <strong>{$a->date}</strong>';
$string['certificationmsgoverdue'] = 'La certificación <strong>"{$a->fullname}"</strong> estaba esperada para <strong>{$a->date}</strong>';
$string['certifications'] = 'Certificaciones';
$string['completeallinanyorder'] = 'Completar todo en cualquier orden';
$string['completeallinorder'] = 'Completar todo en orden';
$string['completeatleast'] = 'Completar al menos';
$string['completed'] = 'Completado';
$string['completedprogramslink'] = '<a href="{$a->href}">Programas completados: {$a->count}</a>';
$string['completion'] = 'Finalización';
$string['completion_help'] = 'Tipo de finalización a aplicar al conjunto';
$string['completionatleast'] = 'Finalización de al menos';
$string['completioncriteria'] = 'Criterio de finalización';
$string['completioncriteriagroup_help'] = 'Por favor seleccione un criterio de finalización para este conjunto específico';
$string['completiondate'] = 'Fecha de finalización';
$string['completiondateonorafter'] = 'Fecha de finalización en o después de';
$string['conditionprogramcompleted'] = 'Programa completado';
$string['conditionprogramcompleteddescription'] = 'Usuarios que tienen estatus de \'Completado\' en programa \'{$a}\'';
$string['conditionprogramnotcompleted'] = 'Programa no completado';
$string['conditionprogramnotcompleteddescription'] = 'Usuarios que no tienen estatus de \'Completado\' en programa \'{$a}\'';
$string['conditionprogramoverdue'] = 'Programa retrasado';
$string['conditionprogramoverduedescription'] = 'Usuarios que tienen estatus de \'Retrasado\' en programa \'{$a}\'';
$string['conditionprogramsuspended'] = 'Programa suspendido';
$string['conditionprogramsuspendeddescription'] = 'Usuarios que tienen estatus de \'Suspendido\' en programa \'{$a}\'';
$string['conditionuserallocated'] = 'Usuarios asignados al programa';
$string['conditionuserallocateddescription'] = 'Usuarios asignados al programa \'{$a}\'';
$string['conditionusernotallocated'] = 'Usuarios no asignados a programa';
$string['conditionusernotallocateddescription'] = 'Usuarios no asignados a programa \'{$a}\'';
$string['confirmdeletecourse'] = '¿Está seguro de querer quitar el curso \'{$a}\' del programa?';
$string['confirmdeleteprogram'] = '¿Está seguro de querer eliminar el programa \'{$a}\' y todos sus datos asociados? Esta acción no puede deshacerse.';
$string['confirmdeleteset'] = '¿Está seguro de querer eliminar el conjunto \'{$a}\' y quitar cualquier curso dentro de él?';
$string['confirmduplicate'] = 'Se hará una copia que incluye el contenido del programa y la agenda, pero que excluye a los usuarios. Será eliminado el campo del número ID.';
$string['confirmresetprogress'] = '¿Está seguro de querer reiniciar el progreso de \'{$a}\'? Al hacerlo así, todos los datos de finalización se perderán. Esta acción podría tardar varios minutos para completarse  y no puede deshacerse.';
$string['containscourse'] = 'Contiene curso';
$string['content'] = 'Contenido';
$string['copy'] = 'Copiar';
$string['course'] = 'Curso';
$string['coursealreadyinset'] = 'El curso ya está dentro de este conjunto';
$string['coursecompletiondisabled'] = 'El seguimiento de la finalización para este curso no está habilitado. Aparecerá en los Tableros de los alumnos como no completado y, como resultado, les hará imposible que completen el programa.';
$string['coursenotavailable'] = 'Curso no disponible';
$string['dateoverriden'] = 'Datos anulados';
$string['datetypeabsolute'] = 'Seleccionar fecha';
$string['datetypenone'] = 'No configurado';
$string['dayssinceallocation'] = 'Días desde asignación';
$string['daystakingprogram'] = 'Días tomando programa';
$string['default'] = 'Predeterminado';
$string['deleteuserallocation'] = 'Eliminar asignación de usuario';
$string['description'] = 'Descripción';
$string['duedate'] = 'Fecha esperada';
$string['duedate_help'] = 'Fecha esperada para este programa';
$string['duplicate'] = 'Duplicar';
$string['dynamic'] = 'Dinámico';
$string['dynamicrules'] = 'Reglas dinámicas';
$string['editprogramname'] = 'Editar nombre del programa';
$string['editsetname'] = 'Editar nombre del conjunto';
$string['enddate'] = 'Fecha de fin';
$string['enddate_help'] = 'Fecha de fin para este programa';
$string['enrol'] = 'Inscribir';
$string['enrolled'] = 'Inscrito';
$string['entityprogram'] = 'Programa';
$string['entityprogramcompletion'] = 'Finalización del usuario';
$string['entityprogramusers'] = 'Asignación de usuario';
$string['errorbasesetnotfound'] = 'Conjunto de base no encontrado';
$string['errorcannotresetprogram'] = 'No se puede reiniciar programa';
$string['errorcantallocateusers'] = 'No se pueden asignar usuarios';
$string['errorcantcreateset'] = 'No se puede crear conjunto';
$string['errorcantdeletenotarchivedprogram'] = 'No se puede eliminar un programa no archivado';
$string['errorcantselfenrol'] = 'No se puede auto-inscribir';
$string['errorcertificationnotfound'] = 'Certificación no encontrada';
$string['errorhelperactionnotallowed'] = 'Acción ayudante no permitida';
$string['errorinvaliddate'] = 'Fecha inválida';
$string['errorinvalidprogram'] = 'Programa no válido';
$string['errorinvalidprogramitemmove'] = 'Movimiento inválido de ítem de programa';
$string['errorloadingprogram_mobile'] = 'Error al cargar programa';
$string['errormissingenrolprogramplugin'] = 'Plugin de inscripción a programa está faltante';
$string['errornopermissionmanageprograms'] = 'Sin permiso para gestionar programas';
$string['errornopermissionmanageusers'] = 'Sin permiso para gestionar usuarios';
$string['errornopermissionviewprograms'] = 'Sin permiso para ver programas';
$string['errornopermissionviewreports'] = 'Sin permiso para ver reportes';
$string['errorprogramnotfound'] = 'Programa no encontrado';
$string['errorreporttypedoesnotexist'] = 'El tipo de reporte no existe';
$string['errorusercantbeallocated'] = 'El usuario no puede ser asignado';
$string['eventcourseadded'] = 'Curso añadido';
$string['eventcourseremoved'] = 'Curso removido';
$string['eventcourseupdated'] = 'Curso actualizado';
$string['eventprogramcompleted'] = 'Programa completado';
$string['eventprogramcreated'] = 'Programa creado';
$string['eventprogramdeleted'] = 'Programa eliminado';
$string['eventprogramupdated'] = 'Programa actualizado';
$string['eventsetcompleted'] = 'Conjunto completado';
$string['eventsetcreated'] = 'Conjunto creado';
$string['eventsetdeleted'] = 'Conjunto eliminado';
$string['eventsetupdated'] = 'Conjunto actualizado';
$string['eventuserallocated'] = 'Usuario asignado';
$string['eventuserdeallocated'] = 'Usuario des-asignado';
$string['futureallocation'] = 'Asignación futura';
$string['hiddenfromlearners'] = 'Oculto de estudiantes';
$string['idnumber'] = 'Número ID';
$string['inprogress'] = 'En progreso';
$string['locked'] = 'Bloqueado';
$string['lockedreasonparent'] = 'No disponible a menos que: El conjunto {$a} está disponible.';
$string['lockedreasonpreviouscourse'] = 'No disponible a menos que: el curso previo {$a} esté marcado como completado.';
$string['lockedreasonpreviousset'] = 'No disponible a menos que: el conjunto previo {$a} esté marcado como completado.';
$string['maincompletion'] = 'Finalización principal';
$string['manual'] = 'Manual';
$string['messageprovider:programcompleted'] = 'Programa completado';
$string['messageprovider:programuserallocated'] = 'Usuario asignado';
$string['messageprovider:programuserdeallocated'] = 'Usuario des-asignado';
$string['missingcourse'] = 'Falta curso';
$string['missingfullname'] = 'Falta nombre del programa.';
$string['missingprogram'] = 'Programa faltante';
$string['missingsetname'] = 'Falta nombre del conjunto';
$string['name'] = 'Nombre';
$string['never'] = 'Nunca';
$string['newnameforset'] = 'Nuevo nombre para \'{$a}\'';
$string['newprogram'] = 'Nuevo programa';
$string['notarchived'] = 'No archivado';
$string['notcompleted'] = 'No completado';
$string['notenrolledprograms_mobile'] = 'Uste dno está inscrito en ningún programa';
$string['notificationsubjectprogramcompleted'] = 'Felicitaciones- \'{$a}\' completado';
$string['notificationsubjectprogramuserallocated'] = 'BienVenido a \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = '\'{$a}\' cerrado';
$string['notset'] = 'No configurado';
$string['notsuspended'] = 'No suspendido';
$string['notvisible'] = 'No visible';
$string['nousersselected'] = 'Usted necesita seleccionar al menos un usuario';
$string['open'] = 'Abierto';
$string['outcomeallocation'] = 'Asignar usuarios a programas';
$string['outcomedeallocation'] = 'Des-asignar usuarios de programas';
$string['outcomedeallocationdescription'] = 'Des-asignar usuarios del programa \'{$a}\'';
$string['overdue'] = 'Retrasado';
$string['overdueprograms'] = 'programas retrasados';
$string['overdueprogramslink'] = '<a href="{$a->href}">Programas retrasados: {$a->count}</a>';
$string['parentname'] = 'Nombre del padre';
$string['pending'] = 'Pendiente';
$string['pendingreasonparent'] = 'Será automáticamente marcado como completado cuando: conjunto {$a} esté disponible.';
$string['pendingreasonpreviouscourse'] = 'Será automáticamente marcado como completado cuando: curso anterior {$a} esté marcado como completado.';
$string['pendingreasonpreviousset'] = 'Será automáticamente marcado como completado cuando: conjunto anterior {$a}  esté marcado como completado.';
$string['pluginname'] = 'Programa';
$string['privacy:metadata:program_set_completion'] = 'Información acerca de la finalización de un conjunto de programa.';
$string['privacy:metadata:program_set_completion:completeddate'] = 'La fecha cuando el usuario completó el conjunto.';
$string['privacy:metadata:program_set_completion:setid'] = 'El conjunto completado.';
$string['privacy:metadata:program_set_completion:timemodified'] = 'La fecha modificada de la finalización del conjunto.';
$string['privacy:metadata:program_set_completion:userid'] = 'El usuario que completó el conjunto.';
$string['privacy:metadata:program_users'] = 'Información acerca de la asignación de programa del usuario.';
$string['privacy:metadata:program_users:allocationtype'] = 'El origen desde donde fue asignado el usuario.';
$string['privacy:metadata:program_users:certificationid'] = 'La certificación asignada a (si fuera aplicable).';
$string['privacy:metadata:program_users:duedate'] = 'Fecha esperada del programa.';
$string['privacy:metadata:program_users:duedatelocked'] = 'Si es que la fecha esperada predeterminada está anulada.';
$string['privacy:metadata:program_users:enddate'] = 'Fecha de fin del programa para este usuario.';
$string['privacy:metadata:program_users:enddatelocked'] = 'Si es que la fecha de fin predeterminada está anulada.';
$string['privacy:metadata:program_users:programid'] = 'El programa asignado a.';
$string['privacy:metadata:program_users:startdate'] = 'Fecha de inicio del programa para este usuario.';
$string['privacy:metadata:program_users:startdatelocked'] = 'Si es que la fecha de inicio predeterminada está anulada.';
$string['privacy:metadata:program_users:status'] = 'Si es que el usuario ha sido suspendido del programa.';
$string['privacy:metadata:program_users:timemodified'] = 'La fecha modificada de la asignación de usuario.';
$string['privacy:metadata:program_users:userid'] = 'La ID del usuario asignado al programa.';
$string['program:allocateuser'] = 'Asignar usuarios a programas';
$string['program:configurecustomfields'] = 'Configurar campos personalizados de programa';
$string['program:edit'] = 'Editar programas';
$string['programdescription'] = 'Descripción del programa';
$string['programdescription_help'] = 'La descripción del programa es mostrada en el Tablero.';
$string['programduedate'] = 'Fecha esperada del programa';
$string['programfullname'] = 'Nombre del programa';
$string['programfullname_help'] = 'El nombre del programa es mostrado en el Tablero y en la lista de programas.';
$string['programidnumber'] = 'Número ID del programa';
$string['programidnumber_help'] = 'El número ID de un programa es usado solamente  cuando se concuerda el programa contra sistemas externos y no es mostrado en ninguna parte en el sitio. Si el programa tiene un nombre de código oficial, puede ser ingresado; en caso contrario el campo puede dejarse vacío.';
$string['programimage'] = 'Imagen del programa';
$string['programimage_help'] = 'La imagen del programa es mostrada en el Tablero';
$string['programname'] = 'Nombre del programa';
$string['programnamewithimage'] = 'Nombre de programa con imagen';
$string['programprogress'] = 'Progreso del programa';
$string['programrules'] = 'Reglas del programa';
$string['programs'] = 'Programas';
$string['programscustomfield'] = 'Campos personalizados de programas';
$string['programsoverview_mobile'] = 'Vista general del programa';
$string['programstatus'] = 'Estatus del programa';
$string['programtags'] = 'Marcas del programa';
$string['programtags_help'] = 'Marcas para este programa';
$string['programvisibility'] = 'Visibilidad del programa';
$string['programvisibility_help'] = 'Esta configuración determina si es que el programa es o no mostrado en el Tablero de un usuario y si es que el usuario puede o no acceder a él.';
$string['progressoverview'] = 'Vista general del progreso';
$string['progresspercent'] = 'Progreso';
$string['progressreport'] = 'Reporte del progreso';
$string['reg_wpprograms'] = 'Número de programas ({$a})';
$string['reportprogramsallocationcompletion'] = 'Asignación y finalización de usuarios del programa';
$string['resetprogress'] = 'Reiniciar programa';
$string['restore'] = 'Restaurar';
$string['review'] = 'Revisar';
$string['scheduleupdatesuccess'] = 'Horario-Agenda actualizado exitosamente';
$string['seecontent_mobile'] = 'Ver contenido';
$string['selectcourses'] = 'Seleccionar cursos';
$string['selectprogramcondition_help'] = 'Seleccionar un programa a ser asociado a esta condición';
$string['selectprogramoutcome_help'] = 'Seleccionar un programa a ser asociado a esta acción';
$string['set'] = 'Conjunto';
$string['setname'] = 'Nombre';
$string['setname_help'] = 'Por favor elija un nombre para el conjunto';
$string['setsandcoursesnotfound_mobile'] = 'No se encontraron cursos o conjuntos';
$string['startdate'] = 'Fecha de inicio';
$string['startdate_help'] = 'Fecha de inicio para este programa';
$string['status'] = 'Estatus';
$string['status_help'] = 'El estatus de suspendido ocultará este programa a este usuario.';
$string['suspended'] = 'Suspendido';
$string['suspendeddateonorafter'] = 'Fecha suspendido en o después de';
$string['tagarea_tool_program'] = 'Programas';
$string['tags'] = 'Marcas';
$string['timecreated'] = 'Creado en';
$string['timemodified'] = 'Última modificaciónen';
$string['timesuspended'] = 'Suspendido en';
$string['type'] = 'Tipo';
$string['userduedate'] = 'Fecha esperada';
$string['userduedate_help'] = 'Seleccionar la fecha esperada del programa para este usuario.';
$string['userenddate'] = 'Fecha de fin';
$string['userenddate_help'] = 'Seleccionar la fecha  cuando este programa no estará visible para este usuario.';
$string['userlist'] = 'Seleccionar usuarios';
$string['userlist_help'] = 'Seleccionar usuarios a asignar a este programa';
$string['users'] = 'Usuarios';
$string['userstartdate'] = 'Fecha de inicio';
$string['userstartdate_help'] = 'Seleccionar la fecha  cuando este usuario podrá iniciar el programa. Esta fecha solamente se aplicará a este usuario.';
$string['visible'] = 'Visible';
