<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'zh_cn', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = '拒绝访问';
$string['accountlocked'] = '您的账户已被锁定，解锁链接已发送到您的邮箱。';
$string['accounts'] = '帐号';
$string['accountunlocked'] = '您的账户已解锁，可以登录。';
$string['addcategory'] = '添加一个分类';
$string['additionalhtml'] = '附加的HTML';
$string['additionalhtml_desc'] = '您可以通过这些设置为每页指定HTML代码。可将HTML代码加入HEAD标签间，紧接在BODY开始标签之后或紧接在标签关闭之前。<br /> 这样您就可以自定义每个页面标题和页脚，或是轻松地把支持服务加入例如Google Analytics页不用考虑采用了什么主题风格。';
$string['additionalhtml_heading'] = '向所有页面插入的HTML代码。';
$string['additionalhtmlfooter'] = '在</body>之前添加';
$string['additionalhtmlfooter_desc'] = '这些内容将被插入每个页面的</body>标签之前，也就是网页的最底部。';
$string['additionalhtmlhead'] = '在HEAD内';
$string['additionalhtmlhead_desc'] = '这些内容将做为HEAD标签的最后一条而被插入到每个页面。';
$string['additionalhtmltopofbody'] = '在<body>标签后面添加';
$string['additionalhtmltopofbody_desc'] = '这些内容将被插入每个页面的<body>标签的后面，也就是网页内容的顶部';
$string['admincategory'] = '类别：{$a}';
$string['adminseesall'] = '管理员可见所有事件';
$string['adminseesallevents'] = '管理员看到所有事件';
$string['adminseesownevents'] = '管理员和其它用户一样';
$string['advancedfeatures'] = '高级特性';
$string['agedigitalconsentverification'] = '上网年龄承诺验证';
$string['agedigitalconsentverification_desc'] = '在为自助注册用户显示注册页面之前，启用对数字年龄的验证。这样可以防止未成年人在未经父母/监护人同意的情况下注册您的网站。<a target=“_blank” href=“{$a}”>支持联系人</a>提供了详细信息以获取更多帮助';
$string['ageofdigitalconsentmap'] = '上网年龄承诺书';
$string['ageofdigitalconsentmap_desc'] = '默认数字承诺年龄，如果任何国家的年龄要求与默认数值不同，可以在此设置。每行写一个年龄，格式: 国家代码, 年龄(用英文逗号分隔)。国家代码位置上的*号为默认年龄。国家代码以国际标准 ISO 3166-2为准。';
$string['allcountrycodes'] = '全部国家代码';
$string['allowattachments'] = '允许附件';
$string['allowbeforeblock'] = '优先处理允许访问列表';
$string['allowbeforeblockdesc'] = '缺省情况，禁止访问IP列表会先被匹配。如果启用此选项，则允许访问IP列表的处理会先于禁止访问列表。';
$string['allowcategorythemes'] = '允许课程分类主题';
$string['allowcohortthemes'] = '允许群组主题';
$string['allowcoursethemes'] = '允许课程主题';
$string['allowedemaildomains'] = '允许的电子邮件域名';
$string['allowediplist'] = '允许访问的IP列表';
$string['allowemailaddresses'] = '允许的邮件域名';
$string['allowemojipicker'] = '表情选取器';
$string['allowframembedding'] = '允许嵌入框架';
$string['allowframembedding_help'] = '如果启用，该网站可以被嵌入到一个外部网站的框架中，推荐使用“以LTI工具发布”的注册插件。否则，出于安全考虑，建议禁用嵌入框架设置。需要注意的是：在移动设备APP中该设置项会被忽略，APP中总是允许嵌入式框架。';
$string['allowguestmymoodle'] = '允许访客访问个人主页';
$string['allowindexing'] = '允许通过搜索引擎的索引';
$string['allowindexing_desc'] = '设定是否允许搜索引擎对网站进行索引。"每处" 允许搜索引擎搜索任何页面，包括登录及注册页面，即设置了强制登录的网站仍会被索引。如想避免因注册页面被搜索到而产生的垃圾邮件，请使用"每处除登录和注册页面"。"无处"将告知搜索引擎不要索引任何页面。 注意此设置仅为网站上的一个标签。是否遵循此规划要视搜索引擎本身。';
$string['allowindexingeverywhere'] = '任何地方';
$string['allowindexingexceptlogin'] = '除登录和注册页面之外的任何地方';
$string['allowindexingnowhere'] = '无处';
$string['allowobjectembed'] = '允许EMBED和OBJECT标记';
$string['allowthemechangeonurl'] = '准许在URL中改变主题';
$string['allowuserblockhiding'] = '允许用户隐藏版块';
$string['allowusermailcharset'] = '允许用户选择字符集';
$string['allowuserswitchrolestheycantassign'] = '允许没有分配角色权限的用户切换角色';
$string['allowuserthemes'] = '允许用户主题';
$string['alternativefullnameformat'] = '备选全名格式';
$string['alternativefullnameformat_desc'] = '此项用于定义拥有全名显示权限的用户如何显示名字（管理员、教师和无编辑权的教师默认具有此权限）。“全名格式”设置可以使用占位符。';
$string['always'] = '总是';
$string['appearance'] = '外观';
$string['aspellpath'] = 'aspell的路径';
$string['asyncbackupdisabled'] = '您的站点当前已配置为使用同步备份。异步备份提供了更好的用户体验，允许用户在备份或还原过程中执行其他操作。从 Moodle 4.5 LTS 开始的所有站点都启用了异步备份。同步备份将从 Moodle LMS 中删除，即 4.5 LTS 之后的版本。';
$string['authentication'] = '身份认证';
$string['authpreventaccountcreation'] = '防止在身份认证时创建账号';
$string['authpreventaccountcreation_help'] = '当认证用户且它在本站还没有账号时，会自动在本站创建账号。如果使用外部数据库（例如LDAP）做认证，但是您希望只允许在本站有账号的用户访问，那么就启用此选项。新账号可以通过手工建立或者上传用户创建。注意，此设置不会影响MNet认证。';
$string['authsettings'] = '管理身份认证';
$string['autolang'] = '语言自动检测';
$string['autolangusercreation'] = '创建帐户时，将用户的浏览器语言设置为其首选语言';
$string['autologinguests'] = '自动登录为访客';
$string['availableto'] = '可用到';
$string['availabletoanyone'] = '任何人都可以访问网站';
$string['availabletoauthenticated'] = '仅限于经过身份验证的用户';
$string['backgroundcolour'] = '透明色';
$string['backup_shortname'] = '在备份文件名中使用课程名';
$string['backup_shortnamehelp'] = '备份文件名中包含课程名。';
$string['backups'] = '备份';
$string['badwordsconfig'] = '输入以逗号(英文半角)分割的禁用词语列表。';
$string['badwordsdefault'] = '如果自定义列表为空，则使用语言包提供的缺省列表。';
$string['badwordslist'] = '自定义黑名单(禁用词)列表';
$string['blockediplist'] = '禁止访问的IP列表';
$string['blockinstances'] = '实例';
$string['blockmultiple'] = '多个';
$string['blockprotect'] = '保护实例';
$string['blockprotect_help'] = '如果您锁定了特定类型的版块，那么别人就不能再添加或删除实例。（当然，你是可以的，只要在编辑前先解锁）

此功能用来保护导航和设置这样的版块，它们如果被偶然删除，会很难再加回来。';
$string['blockprotectblock'] = '保护 {$a} 的实例';
$string['blockprotected'] = '{$a}实例受到保护';
$string['blocksettings'] = '管理版块';
$string['blockunprotectblock'] = '取消保护 {$a} 实例';
$string['blockunprotected'] = '{$a}实例未受保护';
$string['bloglevel'] = '博客可见性';
$string['bookmarkadded'] = '书签已添加。';
$string['bookmarkalreadyexists'] = '您已经为此页设置了书签。';
$string['bookmarkdeleted'] = '删除书签';
$string['bookmarkthispage'] = '将本页加入书签';
$string['cacheapplication'] = '应用程序缓存';
$string['cacheapplicationhelp'] = '缓存的项目能被所有用户共享，期限由指定的TTL决定。';
$string['cachejs'] = '缓存Javascript';
$string['cachejs_help'] = 'JavaScript的缓存和压缩能大大提高页面的加载速度。我们强烈建议正式运营的网站使用它。开发者可能需要禁用此功能。
';
$string['cacherequest'] = '请求缓存';
$string['cacherequesthelp'] = '用户特定缓存。当请求结束时自动过期，主要是用来替代那些我们使用静态存储保存缓存';
$string['cachesession'] = '会话缓存';
$string['cachesessionhelp'] = '用户特定缓存。当用户会话结束时自动过期，主要是用来缓解会话过多或滥用';
$string['cachesettings'] = '缓存设置';
$string['cachetemplates'] = '已缓存的模板';
$string['cachetemplates_help'] = '模板缓存将提高页面加载性能，强烈建议用于生产站点。开发人员可能希望禁用此功能。';
$string['caching'] = '缓存';
$string['calendar_weekend'] = '周末';
$string['calendarexportsalt'] = '日历导出随机种子';
$string['calendarsettings'] = '日历';
$string['calendartype'] = '日历样式';
$string['calendartype_desc'] = '为全站选择一个预设的日历样式。此设定可以被课程设定覆盖，也可以被用户在个人资料中的设定覆盖。';
$string['campaign'] = '活动';
$string['cannotdeletemodfilter'] = '您不能卸载"{$a->filter}"，因为它是"{$a->module}"模块的一部分。';
$string['cannotuninstall'] = '不能卸载{$a}。';
$string['categoryemail'] = '电子邮件';
$string['cfgwwwrootslashwarning'] = 'config.php文件中定义的$CFG->wwwroot不正确。该定义在结尾处包含了"/"字符，请将其删除。';
$string['cfgwwwrootwarning'] = 'config.php 文件中定义的 $CFG->wwwroot 不正确。该定义必须与您用于访问该页面的URL一致。';
$string['change'] = '修改';
$string['checkboxno'] = '否';
$string['checkboxyes'] = '是';
$string['checkupgradepending'] = '升级';
$string['choosefiletoedit'] = '选择要编辑的文件';
$string['cleanup'] = '清理';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = '顺利退出中，请稍等';
$string['cliexitnow'] = '即刻退出中';
$string['cliincorrectvalueerror'] = '错误，将"{$a->option}"的值设为"{$a->value}"是不正确的';
$string['cliincorrectvalueretry'] = '不正确的值，请重试';
$string['clistatusdisabled'] = '状态：禁止';
$string['clistatusenabled'] = '状态：启用';
$string['clistatusenabledlater'] = '状态：CLI 维护模式将会在 {$a} 启用';
$string['clitypevalue'] = '输入值';
$string['clitypevaluedefault'] = '输入值，按回车使用缺省值（{$a}）';
$string['cliunknowoption'] = '未识别的选项：
{$a}
请使用 --help 选项。';
$string['cliupgradecompletenomaintenanceupgrade'] = '在用户流量切换至新代码后清除剩余的缓存文件为：

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

您应该逐个进行这些清除操作，并在各个命令之间保持一段时间间隙，以减少网页服务器的负载峰值。';
$string['cliupgradedefault'] = '新的设置：{$a}';
$string['cliupgradedefaultheading'] = '设置新的默认值';
$string['cliupgradedefaultverbose'] = '新设置：{$ a-> name}，默认值：{$ a-> defaultsetting}';
$string['cliupgradefinished'] = '成功完成命令行升级，从版本{$a->oldversion}到版本{$a->newversion}。';
$string['cliupgrademaintenancenotrequired'] = '此次升级将不会导致用户端进入维护模式';
$string['cliupgrademaintenancerequired'] = '此次升级将导致用户进入维护模式';
$string['cliupgradenoneed'] = '暂无针对{$a}版本的可用更新。不管怎样，欢迎你没事儿来转转！';
$string['cliupgradepending'] = '升级已挂起';
$string['cliupgradesetlock'] = '升级已被锁定为仅限于命令行接口（CLI）执行';
$string['cliupgradeunsetlock'] = '现存的命令行接口执行升级锁已被移除';
$string['cliyesnoprompt'] = '输入y（表示是）或n（表示否）';
$string['close'] = '关闭';
$string['cohort_customfield'] = '群组自定义字段';
$string['commentsperpage'] = '每页显示的评论';
$string['commonactivitysettings'] = '通用设置';
$string['commonfiltersettings'] = '通用过滤设置';
$string['commonsettings'] = '通用设置';
$string['componentinstalled'] = '已安装组件';
$string['computedfromlogs'] = '从{$a}开始的日志中计算得出';
$string['condifmodeditdefaults'] = '创建新的活动或资源时使用的缺省设置值。';
$string['confeditorhidebuttons'] = '请选择HTML编辑器中要隐藏的按钮。';
$string['configallcountrycodes'] = '在很多地方都要使用这个国家/地区列表，例如用户个人资料。如果留空（缺省情况），那么会使用标准英文语言包中的countries.php（它来自ISO 3166-1）。否则，您可以输入用半角逗号分隔的代码列表，例如“GB,FT,ES”。如果要添加新的非标准代码，您必须先在en和您的语言包中添加它们。';
$string['configallowassign'] = '对于左列中的每个角色，请选择他们可以分配给其他人的角色。';
$string['configallowattachments'] = '若启用，从这个网站发送的Email可以加上附件，比如奖章章。';
$string['configallowcategorythemes'] = '如果启用该功能，将可以在类别中使用主题。同时这将影响到所有的子类别和课程，除非子类别和课程中都设置了自己的主题。警告：启用类别主题可能影响系统性能！';
$string['configallowcohortthemes'] = '如果您启用此设置，便可以设置群组级别的主题风格。这会影响仅有一个群组，或是有多个群组但使用同样主题风格的所有用户。';
$string['configallowcoursethemes'] = '如果启用，则允许每个课程设定自己的主题风格。课程的主题风格将覆盖其它位置(网站、用户、分类、分类或URL定义)的设定。';
$string['configallowedemaildomains'] = '列出允许在外发电子邮件的“发件人”部分中显示的电子邮件域名。默认的“空”将对所有外发电子邮件使用“请勿回复”地址。允许使用通配符，例如* .example.com将允许从example.com的任何子域发送电子邮件，但不允许example.com本身发送。需要单独录入。';
$string['configallowemailaddresses'] = '如果您希望将新的email地址限制在一定的域名范围内，把他们列在这里，域名之间以空格隔开。所有其它域名都会被拒绝。要允许域名的所有子域，请在域名前加上前缀“.”；如果希望允许所有子域和根域名本身，则需要将域名添加两次：一次带有前缀“.”，另一侧则不带前缀“.”，例如 .ourcollege.edu.au ourcollege.edu.au。';
$string['configallowemojipicker'] = 'Atto工具栏里的表情(如笑脸)选取器允许用户选择表情加入到站内消息， 和其他文本编辑区里。';
$string['configallowemojipickerincompatible'] = '您当前的数据库设置不支持表情符号存储。点击<a href="https://docs.moodle.org/en/MySQL_full_unicode_support">链接</a>了解如何升级数据库使其完美兼容unicode。';
$string['configallowguestmymoodle'] = '如果打开，游客可以访问个人主页，否则游客将被跳转到网站首页。';
$string['configallowobjectembed'] = '为了安全起见，不允许具有学生角色的用户在 HTML 中使用 EMBED 和 OBJECT 标签将多媒体嵌入文本中，但仍然可以使用多媒体插件过滤器显示多媒体。如果您希望允许这些标记，请启用此选项。';
$string['configallowoverride'] = '允许属于左边角色的用户覆盖竖行中的某些角色';
$string['configallowoverride2'] = '针对左列中的每个角色，请选择他们可以设置覆盖权限的角色。<br />请注意，用户还必须具备 moodle/role:override 或 moodle/role:safeoverride 的能力。';
$string['configallowswitch'] = '对于左列中的每个角色，选择他们可以切换到的角色。<br />用户还必须具有 moodle/role:switchroles 权限。';
$string['configallowthemechangeonurl'] = '如果启用，那么可以用下面办法改变主题：<br />
向任意 Moodle URL添加 ?theme=themename（例如：mymoodlesite.com/?theme=afterburner）或<br />
向任意 Moodle 内部 URL添加 &theme=themename（例如：mymoodlesite.com/course/view.php?id=2&theme=afterburner）。';
$string['configallowuserblockhiding'] = '是否允许用户隐藏/显示此站中各页面两侧的版块？这个功能使用JavaScript和Cookie来记住每一个可折叠版块的状态，它只影响用户自己看到的界面。';
$string['configallowusermailcharset'] = '启用这个选项，网站的所有用户都可以指定用哪种编码给自己发送Email。';
$string['configallowuserswitchrolestheycantassign'] = '默认情况下，用户必须有moodle/role:assign权限才能切换角色。启用这个选项会去掉这一限制，并仅用“允许角色分配”表格来确定“切换角色到”下拉菜单中的内容。我们建议您，在“允许角色分配”表格中，不要允许用户切换到权限更高的角色。';
$string['configallowuserthemes'] = '如果启用，用户就可以设定自己的主题风格。用户的主题风格设定会覆盖网站的设定(但不会覆盖课程设定)。';
$string['configallowview'] = '对于左列中的每个角色，请选择他们可以查看、搜索和筛选的角色。';
$string['configallusersaresitestudents'] = '对于网站首页上的活动，是否应将所有用户视为学生？如果是，则任何拥有平台账号的人都可以作为学生参加这些活动。如果不是，则只有至少是一门课程的参与者的用户才能参加这些活动。只有管理员和特别指定的教师可以作为网站首页活动的教师。';
$string['configauthenticationplugins'] = '请选择您想使用的认证插件，并且按照failthrough的顺序排列。';
$string['configautolang'] = '通过浏览器设置检测缺省语言。如未设置，则使用网站的缺省语言。';
$string['configautolangusercreation'] = '如果启用，当用户的帐户在第一次登录时自动创建（例如使用LDAP或OAuth2身份验证），则用户的浏览器语言将被设置为他们的首选语言。否则，站点的默认语言将设置为用户的首选语言。';
$string['configautologinguests'] = '当访问者进入允许访客访问的课程时，是否自动以访客身份登录？';
$string['configbloglevel'] = '这项设定允许您限制哪个级别的用户可以在本网站浏览博客。注意，这里列出的是能浏览的用户的最大级别，而与发表者和博客类型无关。如果不需要博客功能，您也可以完全禁止它。';
$string['configcalendarcustomexport'] = '允许日历自定义日期范围';
$string['configcalendarexportsalt'] = '此随机文本用来提高日历导出验证令牌的安全性。请注意，如果您修改了这个哈希盐，那么当前所令牌都会失效。';
$string['configcookiesecure'] = '如果当前服务器仅接收 https 连接方式，建议启用发送安全 cookies 功能。如果已启用，请确保 web 服务器不接受 http:// 地址或者设置了到 https:// 地址的永久重定向，同时最好能够在http头当中发送HSTS。当 <em>wwwroot</em> 地址不是以 https:// 开始时，此设置会被忽略。';
$string['configcountry'] = '如果在此处设定一个国家或地区，则他将被用于用户注册时的缺省选择。要强制用户自己选择一个国家或地区，保持此处为空白。';
$string['configcoursegraceperiodafter'] = '在课程结束日期后的这几天内，把课程分类为“进行中”。';
$string['configcoursegraceperiodbefore'] = '在课程开始日期之前的这几天内，把课程分类为“进行中”';
$string['configcourseoverviewfilesext'] = '允许的课程图像文件扩展名的逗号分隔列表。';
$string['configcourseoverviewfileslimit'] = '可以在课程页列表中显示的课程摘要旁边显示的最大文件数。添加的第一个图像文件用作用户仪表板上“课程概述”中的课程图像；任何其他文件仅显示在“课程列表”页面上。';
$string['configcourserequestnotify'] = '输入有新建课程申请时应当被通知的用户。';
$string['configcourserequestnotify2'] = '有新建课程申请时会被通知的用户。只有拥有确认课程申请权限的用户才会被列出。';
$string['configcoursesperpage'] = '输入课程列表中每页显示的课程数。';
$string['configcourseswithsummarieslimit'] = '当课程数量少于这个值时，显示带有摘要的课程列表。而当课程数量超过这个数值时，使用简单的课程列表';
$string['configcronclionly'] = '通过浏览器访问计划任务页可能会匿名用户暴露特权信息。因此推荐只在命令行下运行计划任务，或者为计划任务设置一个远程访问的密码。';
$string['configcronremotepassword'] = '这意味着如果不使用以下URL的格式提供密码，则无法从web浏览器运行cron.php脚本：<pre>https://site.example.com/admin/cron.php?password=opensesame</pre>如果此字段留空，则不需要密码。';
$string['configcurlcache'] = 'cURL缓存有效时间，单位是秒。';
$string['configcustommenuitems'] = '可以在这里配置自定义菜单。每个菜单项独占一行，格式为：菜单文本、链接 URL（可选，不适用于带有子项的顶部菜单项）、工具提示标题（可选）和语言编码或逗号分隔的编码列表 ( 可选，仅用于向指定语言的用户显示该行），以竖线字符分隔。 以连字符开头的行将显示为上一级菜单中的菜单项，而###则作为分隔符。例如：
 <pre>
课程
-所有课程|/course/
-课程搜索|/course/search.php
-###
-常见问题|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
移动应用|https://example.org/app|下载我们的应用
</pre>';
$string['configcustomusermenuitems'] = '你可以配置用户菜单(除注销链接外，都是自动添加的)。每一行由管道字符分开， 包括：(1)由“langstringname，componentname”形式或纯文本形式的字符串组成；(2)一个URL；(3)一个图标或者pix图标(在具有[subfoldername]/[iconname]结构的pix文件夹中，例如i/publish)，或者一个URL。可以在需要的地方添加一行一个或者多个#号作为分隔符。';
$string['configdbsessions'] = '如果启用，该设置将使用数据库来存储有关当前会话的信息。请注意，现在改变这个设置，将使得所有当前用户（包括你）退出登录。如果你正在使用MySQL，请确保在my.cnf（或my.ini文件）中的\'max_allowed_packet\'至少是4M。其他会话驱动可以直接在config.php配置，参阅config-dist.php以获取更多信息。如果你在config.php文件指定了会话驱动，此选项将消失。';
$string['configdebug'] = '如果您打开这个选项，那么PHP的错误报表会增加，页面上会出现更多的警告信息。这只对开发人员有用。';
$string['configdebugdisplay'] = '如果设为on，错误报表将在html页面中显示。这个很实用，但是常会破坏XHTML,JS,COOKIES和HTTP头。如果设为off，系统将自动发送到服务器日志中，允许更好的调试。PHP设置error_log控制那些日志写入到系统日志中。';
$string['configdebugpageinfo'] = '如果您希望在页脚打印页面信息，就启用此设置。';
$string['configdebugvalidators'] = '如果您希望页面底端有到外部检查器的链接，就启用此项。您可能需要建立一个名为<em>w3cvalidator</em>的用户，并赋予它访客权限。这个改动可能会使某些人未经授权就能访问本站，所以不要在正式使用的网站上使用它。';
$string['configdefaulthomepage'] = '用户在登录网站后应该被重定向到哪个页面？该设置还决定了基于经典主题的用户在导航中的第一个链接。';
$string['configdefaultrequestcategory'] = '除非用户选择其他类别，否则能够在系统上下文中请求新课程的用户请求的课程将被置于该类别中。';
$string['configdefaultrequestedcategory'] = '当申请被批准时，课程放到哪个类别中。';
$string['configdefaultuserroleid'] = '对所有已登录用户来说，在网站层，除了其它可能已经指派的角色以外，所有已登录用户都会获得您这里指定的角色的权限。默认为已认证用户角色。注意，除了被特别禁用的权限，此角色和他们所拥有的其它角色不会冲突，这么做只是为了确保所有用户都可以获得在网站层不能分派的一些权限（比如，发表博客、管理自己的日历等等）。';
$string['configdeleteincompleteusers'] = '在此期间之后，任何没有填写名字、姓氏或电子邮件字段的帐户都将被删除。';
$string['configdeleteunconfirmed'] = '对于某些身份验证方法，如基于电子邮件的个人注册，用户必须在一定时间内确认其帐户。在此期间之后，将删除所有未确认的旧帐户。';
$string['configdenyemailaddresses'] = '要拒绝某些域名的email地址，请把他们列在这里。系统会接受所有其它域名的邮件。域名加上“.”前缀会连同子域一起拒收。例如<strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = '禁止更改图像。';
$string['configdisplayloginfailures'] = '向用户显示上一次登录失败的信息。';
$string['configdndallowtextandlinks'] = '打开或关闭拖放文本、链接或文件到课程页面功能。注意，拖放文本到 Firefox或在不同浏览器间拖放是不可靠的，可能导致上传成空内容或混乱的文本。';
$string['configdoclang'] = '语言将被用在文档页面的链接地址';
$string['configdocroot'] = '定义Moodle文档的路径，以便通过每页页脚中的“此页面的文档”链接提供特定于上下文的文档。如果该字段留空，则不会显示链接。';
$string['configdoctonewwindow'] = '如果启用，则指向Moodle文档的链接将显示在新窗口中。';
$string['configduration_high'] = '这个值太高了，不得超过 {$a}。';
$string['configduration_low'] = '这个值太小了，不得低于 {$a}。';
$string['configeditordictionary'] = '如果aspell没有为用户自己语言指定字典，该值将会被使用。';
$string['configeditorfontlist'] = '选择应该出现在编辑器下拉列表中的字体。';
$string['configemailchangeconfirmation'] = '更改Email后需要Email确认。';
$string['configemaildkimselector'] = 'DKIM选择器是任意的，您的DNS记录必须与此匹配。';
$string['configemailfromvia'] = '在发送邮件的"来自"部分加上"系统自动通知"的说明。
这会告知收件人这一邮件来自哪里，且也有助于防止收件人意外回信给一个不处理回信的电子邮件地址。';
$string['configemailheaders'] = '原始邮件头将逐字添加到所有传出的电子邮件中。';
$string['configemailsubjectprefix'] = '所有发送邮件的主题行前加上前缀的文本。';
$string['configenableanalytics'] = '分析模块，例如面向“即将放弃学习的学生”或者“即将到期的学习活动”，此模块能够提供预测生成、洞察提醒、以及包括发送信息给用户等进一步操作的功能。';
$string['configenableblogs'] = '此开关为全站用户提供一个个人博客';
$string['configenablecalendarexport'] = '启用导出或订阅日历。';
$string['configenablecomments'] = '启用评论';
$string['configenablecourserequests'] = '如果启用，有能力申请新课程的用户（moodle/课程：申请）将可以选择申请一个课程。这种能力在任何默认角色中都是不允许的。它可以在系统或类别背景下应用。';
$string['configenablemobilewebservice'] = '为官方 Moodle 应用或其它应用启用移动服务功能。更多信息请访问{$a}。';
$string['configenablerssfeeds'] = '此开关将启用全站的RSS种子，诸如博客、论坛、数据库活动、词汇表等。但您还要为每个模块单独启用RSS种子。';
$string['configenablerssfeedsdisabled'] = '由于RSS种子已经在整个站点关闭了，因此无法使用。要开启它，访问管理中的变量设置。';
$string['configenablerssfeedsdisabled2'] = '目前，RSS订阅在网站层面是禁用的。可以在网站管理的高级功能中启用它们。';
$string['configenablestats'] = '如果选择“是”，则Moodle的cronjob会处理日志并做一些统计。根据您网站流量的不同，所消耗的时间也不同。如果启用这个选项，您就可以看到关于每个课程或整个网站的一些有趣的图表及统计。';
$string['configenabletrusttext'] = '默认情况下，Moodle总会全面清理来自用户的文本，移除任何可能带来安全问题的不良脚本、媒体等。如果您信任某些特定的用户使用这些高级特性的能力，可以通过可信内容系统取消对他们的干涉。为了使此系统有效，您需要首先使此设置有效，然后给指定的Moodle角色授予可信内容权限。由此类用户建立或上传的文本将被标记为可信任的，在显示前不会被清理。';
$string['configenablewebservices'] = 'Web服务允许其他系统（如Moodle应用程序）登录到站点并执行操作。为提高安全性，如果您未使用应用程序或需要通过web服务集成的外部工具/服务，则应禁用该设置。';
$string['configenablewsdocumentation'] = '启用网络服务文档自动生成。用户可以在他的安全密钥页{$a}访问自己的文档。只会显示已启用协议的文档。';
$string['configerrorlevel'] = '选择显示的PHP警告数目。“正常”通常是最佳选择。';
$string['configexportlookahead'] = '在导出时要前瞻的日期';
$string['configexportlookback'] = '在导出时要前瞻的日期';
$string['configextendedusernamechars'] = '如果启用，用户名可以包括除大写字母以外的任何字符。否则，只允许包含小写字母、下划线（_）、连字符（-）、句号（.）和at符号（@）的字母数字字符。';
$string['configextramemorylimit'] = '某些脚本（如搜索、备份、还原或定期执行）需要更多的内存。对于大站点，请设置一个较高的值。';
$string['configfilterall'] = '过滤全部字符串，包括头部、标题、导航栏等等。当使用多语言过滤时，这是非常有用的，否则它只会给您的系统带来额外的负担。';
$string['configfiltermatchoneperpage'] = '自动链接过滤器在过滤内容时，仅在一页中首次匹配到的地方生成链接，而忽略掉后面的。';
$string['configfiltermatchonepertext'] = '自动链接过滤器将仅为页面上每个文本项中找到的第一个匹配文本实例生成单个链接。其他的都被忽略了。如果启用“每页筛选匹配一次”，则此设置无效。';
$string['configfilternavigationwithsystemcontext'] = '过滤的正常使用与使用它的上下文（例如课程上下文）有关，但对于站点导航，使用“内容和标题”过滤时，显式使用站点上下文进行所有过滤可以提高性能。';
$string['configfilteruploadedfiles'] = '使用该设置会让Moodle在显示上传的HTML和文本前用过滤器处理他们。';
$string['configforcelogin'] = '通常情况下，人们可以在不登录网站的情况下阅读网站首页和课程列表（但不是课程）。如果要强制人们在执行任何操作之前先登录网站，则应启用此设置。';
$string['configforceloginforprofiles'] = '启用这个选项会强制访问者在查看用户信息页面时必须以真实(非访客)身份登录。如果您禁用了该选项，那么可能会有用户在个人信息中发布广告（垃圾信息）或其他不和谐的内容，这些全世界都可见。';
$string['configfrontpage'] = '上面选择的项目将显示在网站首页上。';
$string['configfrontpagecourselimit'] = '最大课程数目';
$string['configfrontpagecourselimithelp'] = '在网站首页课程列表中显示的最大课程数。';
$string['configfrontpageloggedin'] = '当用户登录时，上面选择的项目将显示在网站首页上。';
$string['configfullnamedisplay'] = '这个设置决定了姓名在显示时的格式。默认情况下，采用 "language（语言）"，即依赖当前语言包中的 "fullnamedisplay（全名显示）" 字符串来确定显示方式。不同的语言常常有不同的姓名显示习惯。

对于大多数单一语言网站而言，最简单的设置是 "firstname lastname（名 姓）"（在中文网站中则一般选择"语言"），但也可以选择完全隐藏姓氏。

可用的占位符有：firstname、lastname、firstnamephonetic、lastnamephonetic、middlename 和 alternatename（名、姓、名拼音、姓拼音、中间名和别名）。';
$string['configgeoipfile'] = 'GeoIP City二进制数据文件的位置。此文件不是 Moodle 分发的一部分，必须从 <a href=“https://www.maxmind.com/”>MaxMind 中独立获取</a>。您可以购买商业版本或使用免费版本。您需要注册才能下载城市数据库，您可以在 <a href=“https://dev.maxmind.com/geoip/geoip2/geolite2/” >https://dev.maxmind.com/geoip/geoip2/geolite2/</a> 执行此操作。注册并下载文件后，将其解压缩到服务器上的“{$a}”目录中。';
$string['configgetremoteaddrconf'] = '如果您的服务器在一个反向代理后，您可以设定此项以确定哪条 HTTP 头信息包含了访问者的 IP 地址。头信息按顺序读入，第一条出现的将被使用。';
$string['configgradebookroles'] = '此设置允许您控制谁可以出现在成绩单上。用户至少需要在课程中具有这里的一种角色，才会在该课程的成绩单中显示他的成绩。';
$string['configgradeexport'] = '选择用哪种成绩薄导出格式做为主要格式。被选择的插件将设置和使用每个成绩的“最近导出”字段。例如，已导出的记录可以被标记为“新的”或者“已更新的”。如果您不能确定该如何设置，就什么都别选。';
$string['configgradeexportdefault'] = '选择成绩簿导出格式的默认方法';
$string['confighiddenuserfields'] = '选择要对课程教师/管理员以外的其他用户隐藏的用户信息字段。这将增加学生的隐私。按住CTRL键可选择多个字段。';
$string['configidnumber'] = '指定用户是否(a)不需要ID号，(b)要ID号但可留空，(c)必须要ID号。如果给出，它将显示在用户资料中。';
$string['configintro'] = '在此页中您能够设定许多变量，它们让Moodle更好地运行在您的服务器上。不必过多忧虑——默认的设置已能很好地运行，而且您以后也可以回到这里改变设置。';
$string['configintroadmin'] = '在这个页面中，您可以设置您的主管理员帐号，它可以完全控制站点。请确认您为它设定了一个安全的用户名和密码以及一个合法的email地址。您以后可以创建更多的管理员帐号。';
$string['configintrosite'] = '本页允许你配置这个新网站的网站首页和名称。你以后可以在任何时候使用管理菜单回到这里来改变这些设置。';
$string['configiplookup'] = '当您点击诸如日志中的IP地址(例如34.12.222.93),您将会看到一副显示IP地址确切位置的地图。有多种插件可供选择，它们各有优缺点。';
$string['configkeeptagnamecase'] = '如果您希望用户输入的标签保持原有的大小写，请勾选此选项';
$string['configlang'] = '选择全站的缺省语言。用户可以通过语言菜单或个人资料设定自己的语言，从而覆盖这个设置。';
$string['configlanglist'] = '如果保留为空，则网站上安装的所有语言都将显示在语言菜单中。或者，可以通过输入由逗号分隔的语言代码列表来缩短语言菜单，例如en，de，fr。如果需要，可以使用以下格式指定一个不同于语言包名称的语言名称：语言代码|语言名称，例如en_ kids | 英语，de_ kids | 德语。';
$string['configlangmenu'] = '选择要不要在主页、登录页显示通用的语言菜单。这并不影响用户在他们的个人资料中选择偏爱的语言。';
$string['configlangstringcache'] = '将所有语言编译后的字符串缓存在数据目录中。如果您正在翻译Moodle，或在Moodle源码中编辑了字符串，那么您应该关闭此选项。否则，请打开它，来提升性能。';
$string['configlatinexcelexport'] = '选择Excel导出编码方式。';
$string['configlocale'] = '选择全站的区域设置——它会影响所有语言包对显示日期的格式和语言。您的操作系统上必须安装了这种区域设置(比如Linux里的zh_cn.UTF-8或en_US.UTF-8)。大多数情况下，您可以把它留空。';
$string['configlockrequestcategory'] = '启用时，课程用户在系统中将无法在提交新课程的表单中选取类别。这是一种限制课程用户仅在一个目录的环境下发布课程的替代性方法。';
$string['configloglifetime'] = '在此指定保存用户活动日志的时间长短。超出此时间段的日志将被自动删除。最好是将日志保留尽量长的时间，万一需要他们呢？但如果您的服务器非常繁忙且有性能方面的问题，您也许会希望减少保留日志的时间。不建议将天数设为小于30的值，因为这样可能会让统计功能出错。';
$string['configlookahead'] = '向前查看天数';
$string['configmailnewline'] = '在邮件信息中使用的换行符。依据RFC 822bis CRLF是必须的，一些邮件服务器将自动将其从LF转换为CRLF，其他的邮件服务器错误的将其从CRLF转换为CRCRLF。还有一些拒绝LF的邮件（如qmail）。如果有未送达的邮件或者两个换行时，尝试改变这个设置。';
$string['configmaxbytes'] = '这指定了上传至网站的文件的最大尺寸。此设置受PHP设置post_max_size和upload_max_filesize，以及Apache设置LimitRequestBody的限制。反过来，最大字节数限制了在课程或活动层面可以选择的尺寸范围。如果选择 "网站上传限制"，将使用服务器允许的最大尺寸。';
$string['configmaxconsecutiveidentchars'] = '密码中连续相同字符的个数不能超过此值。使用0会禁用这项检查。';
$string['configmaxeditingtime'] = '此参数指定用户在多长时间内可以重新编辑讨论区的贴子。通常30分钟比较合适。';
$string['configmaxevents'] = '向前查找的事件数';
$string['configmaxusersperpage'] = '课程、小组、群、网站服务等设置中，选择用户时显示的最多显示多少个用户。';
$string['configmessaging'] = '如果启用，用户可以向站点的其他用户发送消息。';
$string['configmessagingallowemailoverride'] = '允许用户将电子邮件通知发送到个人资料中的电子邮件地址之外的地址。';
$string['configmessagingallusers'] = '如启用，用户可以在发送消息的人时查看站点上所有用户的列表，以及消息首选项，包括接受来自站点上任何人的消息的选项。如禁用，用户仅能查看其课程中的用户列表，且他们的消息首选项中只有两个选项 - 仅接受来自其联系人的消息，或接受其联系人及其课程中的任何人。';
$string['configmessagingdefaultpressenter'] = '默认情况下，在用户的邮件设置中是否启用了“使用回车键发送”。';
$string['configmessagingdeleteallnotificationsdelay'] = '可删除已读和未读通知以节省空间。通知创建后多长时间后可以删除？';
$string['configmessagingdeletereadnotificationsdelay'] = '可以删除已读的通知，以节约空间。通知被阅读多久后可以被删除？';
$string['configminpassworddigits'] = '密码中至少要包含多少个数字。';
$string['configminpasswordlength'] = '密码中至少要包含多少个字符。';
$string['configminpasswordlower'] = '密码中至少要包含多少小写字母。';
$string['configminpasswordnonalphanum'] = '密码中至少包含多少个非字母和数字的字符。';
$string['configminpasswordupper'] = '密码至少要包含多少个大写字母。';
$string['configmypagelocked'] = '此设置阻止任何非管理员用户对缺省页面的编辑企图';
$string['confignavcourselimit'] = '限制在导航中向用户显示的课程数。';
$string['confignavshowallcourses'] = '此设置决定了已注册课程的用户除了看到 "我的课程"（列出他们所注册的课程）外，是否还能在导航中看到 "课程"（列出所有课程）。';
$string['confignavshowcategories'] = '在导航栏和导航块中显示课程类别。用户当前注册的课程不会出现这种情况；它们仍将列在我的课程下，没有类别。';
$string['confignoreplyaddress'] = '有时电子邮件以用户身份发送(如讨论区帖子)。有时用户不希望别人看到自己的电子邮件地址，在这些情况下，您在此处指定的电子邮件地址将会被使用。';
$string['confignotifyloginfailures'] = '将登录失败的信息发送给这些选中的用户。这需要启用一个内部的日志存储（如标准日志存储）';
$string['confignotifyloginthreshold'] = '如果发送登录失败的通知，对于一个用户或者IP地址而言，多少次登录失败之后发送通知呢？';
$string['confignotloggedinroleid'] = '未登陆的用户将被当作此角色。访客几乎始终是这里的最佳选择，但是您可能希望建立有更多或更少限制的角色。类似于发帖子这样的事情总是要求用户正确登录。';
$string['configopentowebcrawlers'] = '如果使用该设置，Google将能够以访客的身份进入网站。通过Google搜索而来的访问者也可以以访客的身份登陆网站。这个选项仅对允许访客访问的课程有效。';
$string['configoverride'] = '已在config.php中定义';
$string['configpasswordpolicy'] = '如果启用，将根据以下设置中指定的密码策略检查用户密码。启用密码策略不会影响现有用户，除非他们决定或被要求更改密码，或者启用了“登录时检查密码”设置。';
$string['configpasswordpolicycheckonlogin'] = '启用时，用户每次登陆，密码都将根据密码策略进行核对检查。如果检查失败，用户将被要求修改密码。
此功能适用于系统更新密码策略后开启。';
$string['configpasswordresettime'] = '在多长时间之内，用户必须验证重置密码请求，否则过期失效。通常设为30分钟。';
$string['configpathtodu'] = 'du的路径，如/usr/bin/du。如果您设定了这个选项，则那些显示目录内容的脚本在目录中有很多文件时，可以运行得稍快些。';
$string['configpathtophp'] = 'PHP CLI 的路径。通常会是/usr/bin/php。如果输入此项，则可以从管理员Web界面执行cron脚本。';
$string['configperfdebug'] = '如果启用，在标准主题的页脚会显示性能信息。';
$string['configprofileroles'] = '在用户资料和参与者页面中列出的角色。';
$string['configprofilesforenrolledusersonly'] = '为了防止个人信息被盗用，未加入任何课程的用户的信息将是隐藏的。新用户只有加入至少一门课程后，才可以添加个人信息描述。';
$string['configprotectusernames'] = '如果启用，忘记密码表单将不会显示任何提示来允许猜测帐户用户名或电子邮件地址。';
$string['configproxybypass'] = '半角逗号分隔的主机或IP列表。访问它们时不使用代理（例如，192.168.0.0,*.mydomain.com）';
$string['configproxyfixunsafe_help'] = '这试图通过添加 MoodleBot 用户代理并使用代理来修复不通过代理的内部调用。';
$string['configproxyhost'] = '如果此<b>服务器</b>是通过代理服务器(例如防火墙)上网，那么请填入代理的主机名，否则留空。';
$string['configproxylogunsafe_help'] = '这会尝试记录不通过代理并且应该通过的内部调用。';
$string['configproxypassword'] = '通过代理访问internet密码是必须的，如果没有通过代理可以为空（需要PHP cURL扩展支持）。';
$string['configproxyport'] = '如果此服务器需要使用代理计算机，那么在这里提供代理端口。';
$string['configproxytype'] = 'web代理类型（需要PHP5和支持SOCKS5的cURL扩展的支持）';
$string['configproxyuser'] = '通过代理访问internet用户名是必须的，如果没有通过代理可以为空（需要PHP cURL扩展支持）。';
$string['configrecaptchaprivatekey'] = '用于在Moodle服务器和recaptcha服务器之间通信的字符串（密钥）。ReCAPTCHA密钥可以从以下位置获取 <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = '用于在注册表单和站点支持表单中显示reCAPTCHA元素的字符串（站点键）。ReCAPTCHA密钥可以从以下位置获取<a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>。';
$string['configrequestedstudentname'] = '在申请的课程中，用于表示学生(student)的词。';
$string['configrequestedstudentsname'] = '在申请的课程中，用于表示学生的复数形式(students)的词。';
$string['configrequestedteachername'] = '在申请的课程中，用于表示教师(teacher)的词。';
$string['configrequestedteachersname'] = '在申请的课程中，用于表示教师的复数形式(teachers)的词。';
$string['configreverseproxyignore'] = '如果您的服务器位于附加有X-Forwarded-For头的多个反向代理之后，请指定要用逗号分隔的需忽略的反向代理的IP地址或子网列表，以查找用户的正确IP地址。';
$string['configsectioninterface'] = '界面';
$string['configsectionmail'] = '邮件';
$string['configsectionmaintenance'] = '管理';
$string['configsectionmisc'] = '杂项';
$string['configsectionoperatingsystem'] = '操作系统';
$string['configsectionpermissions'] = '权限';
$string['configsectionrequestedcourse'] = '课程申请';
$string['configsectionsecurity'] = '安全';
$string['configsectionstats'] = '统计';
$string['configsectionuser'] = '用户';
$string['configsecureforms'] = '当读取表单的数据时，Moodle可以提供更多的安全级别。如果此选项被激活，系统将检查浏览器的HTTP_REFERER变量是否与当前的表单相符。在一些极个别的情况下，这会带来一些麻烦，譬如用户使用防火墙(如Zonealarm)并配置了从Web信息中删除HTTP_REFERER的时候。其症状是遇到表单就再也无法前进了。如果用户在登录页面上发生错误，或许您应当选在关闭这个选项，尽管这样做会使您的站点进一步暴露在暴力密码攻击之下。如果不知道选什么，那就让它保留“是”吧。';
$string['configservicespage'] = '输入服务和支持页面的 URL，或留空以链接到 moodle.com 上的 Moodle 服务。该链接仅对站点管理员显示。';
$string['configsessioncookie'] = '此选项用来设定 Moodle 会话所使用的 cookie 的名称。这个选项是可选的，仅仅在一种情况下比较有用：一个站点上运行了多个 Moodle 的拷贝，要避免 cookie 发生混乱。';
$string['configsessioncookiedomain'] = '通过此选项可以设置 Moodle cookie 有效的域名。此选项对于定制 Moodle（如认证或选课插件）非常有用，可以让 Moodle 和另一子域名上的应用共享会话信息。<strong>警告：强烈建议您不要修改此选项——错误的设置将会导致包括管理员在内的所有人都无法登录。</strong>';
$string['configsessioncookiepath'] = '如果您希望修改浏览器发送 Moodle cookie 时使用的地址信息，您可以修改这个选项将其指定为您网站的某个目录。否则缺省情况下会使用“/”。';
$string['configsessiontimeout'] = '如果用户登入本站后空闲了很长时间(没有加载新页面)，那么他们将自动登离(会话结束)。该变量指定这个时间有多长。';
$string['configsessiontimeoutwarning'] = '如果登录到此站点的用户长时间处于空闲状态（未加载页面），则会警告他们会话即将结束。此变量指定此时间的长度。';
$string['configsessiontimeoutwarningcheck'] = '会话超时警告必须小于会话超时';
$string['configshowcommentscount'] = '显示评论数量。它会在现实评论链接时增加一次数据库查询';
$string['configshowicalsource'] = '显示iCal事件的来源信息';
$string['configshowsiteparticipantslist'] = '站点中所有的学生和教师将会被列在站点师生名录中。谁可以查看这个列表呢?';
$string['configsitedefaultlicense'] = '默认站点许可证';
$string['configsitedefaultlicensehelp'] = '在本站发布的资源的缺省许可证';
$string['configsitemailcharset'] = '您系统所生成的所有邮件将使用您在此设定的字符集编码。同时，如果您启用下一个选项，那么所有的用户都可以设定自己的邮件所需的字符集。';
$string['configsitemaxcategorydepth'] = '课程分类最大层数';
$string['configsitemaxcategorydepthhelp'] = '这个功能指定了当显示类别或组合列表的时候，子类别扩展的最大深度。更深层级别的类别会显示为链接，用户可以通过AJAX请求来展开它们。';
$string['configslasharguments'] = '“斜杠参数” (使用<em>PATH_INFO</em>)对SCORM包和多文件资源的正确显示来说，是必须的。如果你的服务器不支持“斜杠参数”你将无法配置它，这个设置将被禁用。相关的功能将无法使用。<br />注意：未来的Moodle版本中“斜杠参数”将会是必须的。';
$string['configsmtpauthtype'] = '该项设置了SMTP服务器要使用的加密类型。';
$string['configsmtphosts'] = '填入一个或多个本地SMTP服务器全名(例如“mail.a.com”或“mail.a.com;mail.b.com”)，本系统将用它(们)发送邮件。使用[server]:[port]的形式（例如“mail.a.com:587”）指定一个非标准端口（即25以外的端口）。如果使用安全连接，SSL通常使用465端口，TLS通常使用587端口。有必要的话在下面指定安全协议。如果留空不填，Moodle将使用PHP默认的方法发信。';
$string['configsmtpmaxbulk'] = '每个 SMTP 会话发送的最大消息数。将消息分组可能会加快电子邮件的发送速度。低于 2 的值会强制为每封电子邮件创建新的 SMTP 会话。';
$string['configsmtpoauthservice'] = '选择配置为与 SMTP 服务器通信的 OAuth 2 服务。如果该服务尚不存在，您需要创建它。请注意，您需要将 SMTP Auth Type 设置为 XOAUTH2。';
$string['configsmtpsecure'] = '如果 SMTP 服务器要求使用安全连接，请指定正确的协议类型。';
$string['configsmtpuser'] = '如果您在上面指定了一个SMTP服务器，而且该服务器要求身份认证，那么在此填入用户名和密码。';
$string['configstartwday'] = '星期的开始';
$string['configstatsfirstrun'] = '在这里指定<b>第一次</b>cronjob要进行统计时，应当处理多长时间内的日志。如果您的流量很大，并且是在共享的主机上，最好不要处理太旧的日志，这将会耗费大量的时间并占用相当多的资源。(注意对于此设置，一个月=28天。在生成的统计图和报表中，一个月=日历上的一个月。)';
$string['configstatsmaxruntime'] = '统计工作是很耗时的，因此通过这个选项和下面的选项来设定应当在何时开始执行它以及执行的时间。';
$string['configstatsmaxruntime2'] = '统计工作是很耗时的，因此要指定处理一天的统计的最长时间，在cron的一次运行中处理的最长天数是31天。';
$string['configstatsmaxruntime3'] = '计算一天的统计信息所能使用的最长时间。注意统计信息的计算将会给服务器带来很高的负载，在一次计划任务运行中可计算最多多少天的统计信息可在下面设置。';
$string['configstatsruntimedays'] = '每次执行统计最多计算多少天的数据。如果统计信息是最新的，只会处理最后一天的。请根据服务器的负载来设定这一项的值，如果需要较短的计划任务执行时间，可以设定一个较小的值。';
$string['configstatsruntimestart'] = '执行统计工作的计划任务应当何时开始？如果一台服务器上运行着多个Moodle，推荐您分别选择不同的时间。';
$string['configstatsuserthreshold'] = '此设置指定至少要有多少人选课的课程才会被包含在统计计算中。';
$string['configstrictformsrequired'] = '如果启用，可以阻止用户在表单的必填字段中只输入一个空格或换行。';
$string['configstripalltitletags'] = '取消本设置，容许在活动和资源名中使用HTML标签。';
$string['configsupportavailability'] = '确定谁有权从页脚联系站点支持';
$string['configsupportemail'] = '如果在此网站上配置了SMTP，但未设置支持页，则此电子邮件地址将接收通过支持表单提交的邮件。如果发送失败，将向登录用户显示电子邮件地址。';
$string['configsupportname'] = '通过支持表单或支持页面提供支持的个人或其他实体的名称。';
$string['configsupportpage'] = '输入支持页面的 URL 或留空以链接到联系表单，该链接将显示在站点页脚中。';
$string['configtempdatafoldercleanup'] = '从数据文件夹清除早于指定时间的临时数据文件。';
$string['configthemedesignermode'] = '通常为了提升性能，外观主题的所有图片和CSS都会在浏览器和服务器上缓存很长时间。如果您正在设计主题或编写代码，那么您可以需要关闭这个模式，这样您就能访问到最新的版本。警告：这会使所有用户的访问变慢！另外，您可以可以在主题选择页面手动重置主题缓存。';
$string['configthemelist'] = '此项为空则用户可以使用所有的合法主题风格。如果您希望让可选的主题风格列表短一些，您可以在此指定一些（不要使用空格！）。譬如: standard,orangewhite。';
$string['configtimezone'] = '这是只是用于显示日期的缺省时区——每个用户都可以设定他自己的时区。计划任务和其他服务器设置都基于这个时区。如果此处显示“无效时区”，则您需要修改这个设置';
$string['configuseblogassociations'] = '用户可以将博客与课程或课程活动关联吗？';
$string['configusesitenameforsitepages'] = '如果启用，站点的简称将用于导航中的站点页面节点，而不是字符串“站点页面”。';
$string['configusetags'] = '在站点中启用标签功能吗？';
$string['configvariables'] = '变量';
$string['configverifychangedemail'] = '在修改email地址时也对域名进行限制。如果关闭此选项，则只在创建用户时限制email地址的域名。';
$string['configvisiblecourses'] = '是否显示在隐藏的课程类别中的课程';
$string['configwarning'] = '小心修改这些选项——不合法的值可能导致错误。';
$string['configyuicomboloading'] = '此选项可以用合并文件的方式优化YUI库的加载。为提升性能，正式服务的网站应该开启这个选项。';
$string['confirmation'] = '确认';
$string['confirmationpending'] = '待确认';
$string['confirmcontextlock'] = '{$a->contextname}目前已解冻。冻结将使其成为只读，用户不能进行修改。您确定要继续吗？';
$string['confirmcontextunlock'] = '{$a->contextname}已冻结。解冻它将允许用户进行更改。您确定要继续吗？';
$string['confirmdeletecomments'] = '您确定要删除评论？';
$string['confirmed'] = '已确认';
$string['contactsitesupport'] = '联系站点支持';
$string['contenttypeuninstalling'] = '这些内容  {$a->count} 由 {$a->type}提供支持服务。它们将被删除。确定要继续？';
$string['contextlockappliestoadmin'] = '内容冻结适用于管理员';
$string['contextlockappliestoadmin_desc'] = '如禁用，管理员仍会对任何已冻结内容具有写入权限。';
$string['contextlocking'] = '内容冻结';
$string['contextlocking_desc'] = '此设置为指定的类别，课程，活动或版块设置只读访问权限。';
$string['cookiesecure'] = '只使用安全的 cookies';
$string['country'] = '默认的国家/地区';
$string['course_customfield'] = '课程自定义字段';
$string['coursecolor'] = '颜色{$a}';
$string['coursecolorheading_desc'] = '在课程设置中未设置课程图像的课程都将以带图案的课程卡片显示在我的课程页面上。图案中使用的颜色可以在下面指定。';
$string['coursecolorsettings'] = '课程卡颜色';
$string['coursecontact'] = '课程联系人';
$string['coursecontact_desc'] = '此设置允许您控制谁会出现在课程描述中。用户必须至少是这些角色中的一个，才能被显示在该课程的课程描述中。';
$string['coursecontactduplicates'] = '显示所有课程联系人角色';
$string['coursecontactduplicates_desc'] = '如启用，具有多个所选课程联系人角色的用户将在课程描述中显示其每个角色。否则，它们将仅显示一个角色（在站点管理中的“定义角色”中列出最高者）。';
$string['coursecreationguide'] = 'Moodle课程创建指南';
$string['coursecreationguide_help'] = '该项定义了快速入门指南的路径，其中包含创建课程的短视频和一般提示。当没有课程可展示时，My courses页面会显示指向该指南的链接。只有具有创建课程能力的用户才能看到此链接。';
$string['coursegraceperiodafter'] = '已完成课程的宽限期';
$string['coursegraceperiodbefore'] = '将进行课程的宽限期';
$string['courselistshortnames'] = '显示扩展课程名称';
$string['courselistshortnames_desc'] = '若启用，显示课程列表或者在管理界面标识课程时，同时显示课程简称和全称。实际上，当您启用此项功能时， 会使用“courseextendednamedisplay”语言字符串，所以您可以通过语言自定义更改显示的内容。';
$string['coursemgmt'] = '管理课程和分类';
$string['courseoverview'] = '课程概述';
$string['courserequestnotify'] = '创建课程申请通知';
$string['courserequestnotifyemail'] = '用户 {$a->user} 在 <a href="{$a->link}">{$a->link} 请求了新课程</a>。';
$string['courserequests'] = '申请课程';
$string['courserequestspending'] = '待处理的课程申请';
$string['courses'] = '课程';
$string['coursesperpage'] = '每页课程数';
$string['courseswithsummarieslimit'] = '带有大纲限制的课程';
$string['creatornewroleid'] = '在新课程中课程创建者的角色';
$string['creatornewroleid_help'] = '如果用户还没有获得管理这个新课程的权限，那么该用户就自动使用此角色选课。';
$string['cron'] = '定时任务';
$string['cron_enabled'] = '允许定时任务';
$string['cron_enabled_desc'] = '定时任务通常应该启用，但是此设置允许临时禁用它，例如在服务器重新启动之前。如果禁用，系统将无法启动新的后台任务。请注意，定时任务不应长时间禁用，因为这将阻止重要功能正常工作。';
$string['cron_help'] = 'cron.php维护脚本帮助某些Moodle模块执行定时或周期任务，例如用email发出讨论区新帖子。此脚本必须被定时调用，例如每分钟执行一次。';
$string['cron_keepalive'] = '保持连接';
$string['cron_keepalive_desc'] = '轮询获取额外任务的时间长度。该设置用于确保定期任务（cron）始终在运行。如果您使用专门的任务运行程序，请将其设置为 0。否则，请将其设置为类似于临时任务并发限制的值。避免设置过长的时间。最大时间为 15 分钟。';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Cron仅通过命令行执行';
$string['cronerrorclionly'] = 'Sorry，访问这页的权限已经被管理员禁用！';
$string['cronerrorpassword'] = 'Sorry，要访问该页，您必须输入一个密码！';
$string['croninfrequent'] = 'cron维护脚本的最后两次运行之间有{$a->actual}，它应该每隔{$a->expected}运行一次。我们建议将其配置为更频繁地运行。';
$string['cronremotepassword'] = '访问远程Cron的密码';
$string['cronwarning'] = '<a href="{$a->url}“>admin/cron.php脚本</a>已经{$a->actual}未运行了。它应该每{$a->expected}运行一次。';
$string['cronwarningcli'] = '<code>admin/cli/cron.php</code>脚本尚未为{$a->actual}运行，应该每隔{$a->expected}运行一次。';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> 脚本从未运行，应该每 {$a->expected}运行一次。';
$string['cronwarningneverweb'] = '应该每{$a->expected}运行的 <a href="{$a->url}">admin/cron.php script</a>从未运行过。';
$string['ctyperequired'] = 'Moodle需要ctype PHP扩展，以便改善性能和提高多种语言的兼容性。';
$string['curlcache'] = 'cURL缓存TTL';
$string['curlrequired'] = 'Moodle现在需要PHP的cURL扩展来和Moodle容器通信。';
$string['curlsecurityallowedport'] = 'cURL允许的端口列表';
$string['curlsecurityallowedportsyntax'] = '可以连接到的端口号列表。只有整数才是有效条目。每个条目放一行。如果留空，则允许所有端口。如果设置，几乎所有情况下，443和80应该指定为cURL连接到标准HTTPS和HTTP端口。';
$string['curlsecurityblockedhosts'] = 'cURL屏蔽的主机列表';
$string['curlsecurityblockedhostssyntax'] = '每一条目放一行。有效条目若不是完整的IPv4地址就是IPv6地址（比如192.168.10.1，, 0:0:0:0:0:0:0:1, ::1, fe80::），它会对应一个独立主机；或者是CIDR表示法（例如231.54.211.0/20 or fe80::/64）；或者是一个IP地址的范围（231.3.56.10-20 或 fe80::1111-bbbb）；或者是域名（比如 localhost 或 example.com）；或者是含有通配符的域名（比如 *.example.com 或 *.sub.example.com）。中间不可能有空白行。';
$string['curlsecurityurlblocked'] = '这个URL被屏蔽了。';
$string['curltimeoutkbitrate'] = '计算cURL超时时使用的比特率（Kbps）';
$string['curltimeoutkbitrate_help'] = '此设置用来计算处理大cURL请求时的超时时间。此计算的一部分会使用HTTP的HEAD请求获得文件大小。设为0则不会发出这个请求。';
$string['currenttheme'] = '当前主题';
$string['customcheck'] = '其他检查项';
$string['custommenu'] = '自定义菜单';
$string['custommenuitems'] = '自定义菜单项';
$string['customusermenuitems'] = '用户菜单条目';
$string['datarootsecurityerror'] = '<p><strong>安全警告！</strong></p><p>您的dataroot目录设在错误的位置，导致它向整个Web公开。这意味着世界上的任何人都可以访问到您的私密文件。其中有些文件还可以被黑客利用，以管理员的身份访问您的网站！</p>
<p>您<em>必须</em>将dataroot目录({$a})移动到一个不在web公开目录下的新位置，并相应地更新config.php中的<code>$CFG->dataroot</code>设置。</p>';
$string['datarootsecuritywarning'] = '您的网站设置可能不安全。请确保您的数据根目录（{$a}）不能直接通过网页访问。';
$string['dbprefixtoolong'] = '您网站的数据库前缀（$CFG->prefix）过长（当前 {$a->current} 个字符）。允许的最大字符数为 {$a->maximum}。';
$string['dbsessions'] = '用数据库处理会话信息';
$string['debug'] = '调试信息';
$string['debugall'] = '所有：显示全部可能的PHP调试信息';
$string['debugdeveloper'] = '开发者：针对开发者的额外moodle调试信息';
$string['debugdisplay'] = '显示调试信息';
$string['debugging'] = '调试';
$string['debugminimal'] = '最少：只显示致命的错误';
$string['debugnone'] = '无：不显示任何错误或警告';
$string['debugnormal'] = '标准：显示错误、警告和注意';
$string['debugpageinfo'] = '显示页面信息';
$string['debugsqltrace'] = '显示SQL调用的来源';
$string['debugsqltrace1'] = '只显示一行调用';
$string['debugsqltrace100'] = '显示完整堆栈跟踪';
$string['debugsqltrace2'] = '显示2行堆栈跟踪';
$string['debugsqltrace_desc'] = '如果启用，部分或完整的PHP堆栈跟踪将作为注释添加到SQL中。';
$string['debugstringids'] = '显示语言字符串来源';
$string['debugstringids_desc'] = '如果启用，当?strings=1或&strings=1被附加到页面URL时，将显示语言字符串组件和标识符。';
$string['debugtemplateinfo'] = '显示模板信息';
$string['debugtemplateinfo_desc'] = '如果启用，用于呈现的模板将在页面 HTML 中显示为注释。更改设置后，您需要清除缓存。仅用于临时调试，因为它会产生 HTML 验证错误，并可能破坏页面脚本。它也可能破坏核心功能！';
$string['debugvalidators'] = '显示校验链接';
$string['defaultcity'] = '默认城市';
$string['defaultcity_help'] = '在此输入的城市将成为新建用户的缺省城市。';
$string['defaultformatnotset'] = '检测默认课程格式发现错误。请检查网站设置。';
$string['defaulthomepage'] = '用户的起始页';
$string['defaultrequestcategory'] = '申请课程的默认类别';
$string['defaultsettinginfo'] = '默认：{$a}';
$string['defaultuserroleid'] = '所有用户的默认角色';
$string['deletedplugintypesdetected'] = '检测到一个已删除的插件：‘{$a}’。此插件应该在移除过程中已经被整合或卸载。当前此插件是不被支持的插件类型，所以在此插件被卸载前，安装或者升级不能继续。';
$string['deleteduserx'] = '删除用户 {$a}';
$string['deleteincompleteusers'] = '几天后删除资料不完整的用户';
$string['deleteunconfirmed'] = '之后删除未完全配置好的用户';
$string['deleteuser'] = '删除用户';
$string['density'] = '密度';
$string['denyemailaddresses'] = '禁止的邮件域名';
$string['development'] = '开发';
$string['devicetype'] = '设备类型';
$string['devlibdirpresent'] = '含有开发库的目录，尤其是<em>/vendor</em>和<em>/node_modules</em>，不应出现在公共站点上。有关详细信息，请参阅<a href="{$a-> moreinfourl}">安全概述报告</a>。';
$string['disabled'] = '禁用';
$string['disableplugin'] = '禁用 {$a}';
$string['disableuserimages'] = '禁用用户配置图像';
$string['displayerrorswarning'] = '建议不要在站点中设置PHP的<em>display_errors</em>，因为这可能会暴露敏感资料。';
$string['displayloginfailures'] = '显示登录失败信息';
$string['divertallemails'] = 'Email转发';
$string['divertallemailsdetail'] = '在开发环境中测试电子邮件时用作保护措施，不应在生产中使用。';
$string['divertallemailsexcept'] = 'Email转发例外';
$string['divertallemailsexcept_desc'] = 'Email例外规则列表，用逗号或新行分隔。每个规则都被解释为一个正则表达式。
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = '转发所有邮件';
$string['divertallemailsto_desc'] = '如果设置，则所有电子邮件将被转发到这个单一的电子邮件地址。';
$string['dndallowtextandlinks'] = '拖放上传文本/链接';
$string['doclang'] = '说明文档语言';
$string['docroot'] = 'Moodle Docs文档根目录';
$string['doctonewwindow'] = '在新窗口中打开';
$string['doesnotfit'] = '电子邮件显示设置';
$string['doesnotfitdetail'] = 'Moodle外发的邮件的显示设置。';
$string['download'] = '下载';
$string['downloadcoursecontentallowed'] = '提供下载课程内容功能';
$string['downloadcoursecontentallowed_desc'] = '下载课程内容功能是否可用于课程。如果可用，可以使用“课程编辑”菜单中的“启用下载课程内容”设置启用/禁用课程内容下载（默认设置可在<a href={$a} target="_blank">课程默认设置</a>中设置）。';
$string['durationunits'] = '用户菜单条目';
$string['edithelpdocs'] = '编辑帮助文档';
$string['editlang'] = '<b>修改</b>';
$string['editorbackgroundcolor'] = '背景色';
$string['editordictionary'] = '编辑字典';
$string['editorfontfamily'] = '字体家族';
$string['editorfontlist'] = '字体列表';
$string['editorfontsize'] = '字体大小';
$string['editorhidebuttons'] = '隐藏按钮';
$string['editorkillword'] = 'Word格式过滤器';
$string['editorspelling'] = '编辑拼法';
$string['editorspellinghelp'] = '启动或关闭拼写检查，当启动后，<strong>aspell</strong> 必须在服务器上安装。';
$string['editstrings'] = '编辑单词或短语';
$string['emailchangeconfirmation'] = 'Email变更确认';
$string['emaildkim'] = '域名标识邮件（DKIM）电子邮件签名';
$string['emaildkiminfo'] = '如果同时设置了DKIM选择器，并且在  $CFG->dataroot/dkim/[domain]/[selector].private 中找到了与电子邮件的“发件人”地址域匹配的私有证书文件，则将对电子邮件进行签名。在大多数情况下（例如allowedemaildomains为空），在 <pre>{$a->path}</pre>只需要一个证书。有关更多设置详细信息，请参阅文档n <a href="{$a->docs}">邮件配置</a>.';
$string['emaildkimselector'] = 'DKIM 选择';
$string['emailfromvia'] = '发送信息邮件';
$string['emailheaders'] = 'Email头';
$string['emailsubjectprefix'] = '电子邮件主题前缀文本';
$string['emoticonalt'] = '替代文字';
$string['emoticoncomponent'] = '图片组件';
$string['emoticonimagename'] = '图片名';
$string['emoticons'] = '表情';
$string['emoticons_desc'] = '此表单定义您的网址使用的表情（或笑脸）。如果将某行所有字段都清空，然后保存此表单，可以删除该行。在最后的空行里填写字段，可以注册一个新表情。重置所有字段到缺省值，请点击上面的链接。

* 文字（必须） - 文字会被表情图片替换。它至少要两个字符长。
* 图片名（必须） - 相对于组件pix文件夹的表情图片文件名，不带扩展名。
* 图片组件（必须） - 提供图标的组件。
* 替代文字（可选） - 表情替代文字的字符串ID和组件。';
$string['emoticonsreset'] = '重置表情设置到缺省值';
$string['emoticontext'] = '文字';
$string['emptysettingvalue'] = '为空';
$string['enableanalytics'] = '分析';
$string['enableblogs'] = '启用博客';
$string['enablecalendarexport'] = '启用日历导出';
$string['enablecomments'] = '启用评论';
$string['enablecommunicationsubsystem'] = '启用通信提供程序';
$string['enablecommunicationsubsystem_desc'] = '允许与通信提供程序（例如 Matrix 等）集成，以便教师和学生能更轻松地进行沟通。您可以在<a href="settings.php?section=managecommunicationproviders">插件</a>中管理这些集成。';
$string['enablecourserelativedates'] = '启用课程相关日期';
$string['enablecourserelativedates_desc'] = '允许设置课程以显示课程中相对于用户开始日期的日期。';
$string['enablecourserequests'] = '可以课程申请';
$string['enabled'] = '启用';
$string['enabledashboard'] = '允许仪表盘';
$string['enabledashboard_help'] = '仪表板默认显示时间线、日历和最近访问的项目。您可以为每个人设置不同的默认仪表板，并允许用户自定义自己的仪表板。如果禁用，则需要将“用户起始页”设置为仪表板以外的值。';
$string['enableglobalsearch'] = '启用全局搜索';
$string['enableglobalsearch_desc'] = '如果启用，数据将通过计划任务进行索引和同步。';
$string['enablegravatar'] = '启用Gravatar';
$string['enablegravatar_help'] = '启用后，如果用户未上传头像，Moodle会尝试从Gravatar获取用户头像。';
$string['enablemobilewebservice'] = '为移动设备启用网络服务';
$string['enablepdfexportfont'] = '启用PDF字体';
$string['enablepdfexportfont_desc'] = '如果您的网站有不同语言的课程，并且在生成的 PDF 文件中需要其他字体，您可以在课程设置中提供设置字体的选项。您需要在 config.php 中的 $CFG->pdfexportfont 中指定可用的字体。';
$string['enableplugin'] = '启用 {$a}';
$string['enablerecordcache'] = '启用记录缓存';
$string['enablerssfeeds'] = '启用RSS种子';
$string['enablesearchareas'] = '搜索区域';
$string['enablesharingtomoodlenet'] = '启用向 MoodleNet（出站）的分享';
$string['enablesharingtomoodlenet_desc'] = '允许具有权限的用户将课程内容分享到配置的 MoodleNet 实例。';
$string['enablestats'] = '启用统计';
$string['enabletrusttext'] = '启用可信内容';
$string['enableuserfeedback'] = '启用关于这个软件的反馈';
$string['enableuserfeedback_desc'] = '如果启用，页脚中将显示一个“提供有关此软件的反馈”链接，供用户向Moodle HQ提供有关Moodle软件的反馈。如果设置了“下一个反馈提醒”选项，则在仪表板上也会按指定的间隔向用户显示一个提醒。将“下一个反馈提醒”设置为“从未”将禁用仪表板提醒，同时在页脚中保留“获取关于这个软件的反馈”链接。';
$string['enablewebservices'] = '启用网络服务';
$string['enablewsdocumentation'] = '网络服务文档';
$string['encryptedpassword_edit'] = '键入新值';
$string['encryptedpassword_set'] = '（设置和加密）';
$string['enroladminnewcourse'] = '自动将管理员加入新课程';
$string['enroladminnewcourse_help'] = '当管理员添加新课程时，是否将他们自动选课，并在新课程中分配创建者角色？';
$string['enrolinstancedefaults'] = '选课实例缺省值';
$string['enrolinstancedefaults_desc'] = '新建课程的缺省选课设置。';
$string['enrolmultipleusers'] = '将这些用户加入课程';
$string['entitytasklog'] = '任务日志';
$string['environment'] = '环境';
$string['environmenterrortodo'] = '在继续安装此版本的 Moodle 前，您必需解决上面所列出的所有环境问题（错误）！';
$string['environmenterrorupgrade'] = '警告：在升级此版本的Moodle之前，您应当解决上面列出的所有环境问题（错误）！不解决这些就直接升级的话可能造成严重问题，比如数据丢失。您确定要继续升级吗？';
$string['environmentmariadbwrongdbtype'] = '$CFG->dbtype 错误，您需要在config.php文件中将其从“mysqli”更改为“mariadb”。';
$string['environmentmustfixsetting'] = '必须修改PHP配置。';
$string['environmentok'] = '您的服务器环境满足所有最低需求。';
$string['environmentrecommendcustomcheck'] = '如果该测试失败，表明存在问题';
$string['environmentrecommendinstall'] = '为了最好的效果，应该安装并启用';
$string['environmentrecommendversion'] = '推荐 {$a->needed} 版本，而您的是 {$a->current}';
$string['environmentrequirecustomcheck'] = '该项测试必须通过';
$string['environmentrequireinstall'] = '必须安装并启用';
$string['environmentrequireversion'] = '需要 {$a->needed} 版本，而您的是 {$a->current}';
$string['environmentsettingok'] = '检测到建议设置';
$string['environmentshouldfixcustomcheck'] = '为了最好的结果应当被启用';
$string['environmentshouldfixsetting'] = 'PHP配置应更改。';
$string['environmentxmlerror'] = '读取环境数据时错误({$a->error_code})';
$string['errordeletingconfig'] = '删除插件“{$a}”的配置记录时出错。';
$string['errorsetting'] = '无法保存设置：';
$string['errorwithsettings'] = '无法更新一些设置，因为发生了一个错误。';
$string['eventshandlersinuse'] = '系统中的以下插件正在使用事件 1 API （已弃用的处理程序）：“{$a}”。
请更新它们以使用事件 2 API。请参见 https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers。';
$string['everyonewhocan'] = '所有可以“{$a}”的用户';
$string['exceptions'] = '异常';
$string['execpathnotallowed'] = 'config.php 里禁止设置可执行及本地路径';
$string['experimental'] = '试验性功能';
$string['experimentalsettings'] = '试验性设置';
$string['extendedusernamechars'] = '允许在用户名中使用扩展字符';
$string['extramemorylimit'] = '额外的 PHP 内存限制';
$string['fatalsessionautostart'] = '<p>检测到严重的配置错误，请通知服务器管理员。</p> <p>管理员要更改PHP的设置，Moodle才能正常运行。</p> <p><code> session.auto_start </code>必须被设置为<code>off</code>。</p> <p>此设置通过编辑服务器上<code>php.ini </code>、Apache/IIS的配置或<code>.htaccess </code>“文件来控制。</ p>';
$string['favicon'] = '网站图标';
$string['favicon_desc'] = '网站图标（Favicon）显示在浏览器标签中的页面标题旁边。如果没有提供自定义的图标，将显示 Moodle 的图标。';
$string['feedbacksettings'] = '反馈设置';
$string['fileconversioncleanuptask'] = '清理文件转换的临时记录';
$string['filecreated'] = '新文件已创建';
$string['filescleanupperiod'] = '清理垃圾池文件';
$string['filescleanupperiod_help'] = '删除垃圾池文件的频率。这些是与不再存在的上下文相关联的文件，例如在删除一个进程时。请注意：如果“自动备份设置”中的“包含文件”（备份自动文件）设置被禁用，则此设置可能会导致课程中丢失文件，这些文件将被备份、删除并还原。';
$string['filesizeunits'] = '文件大小单位';
$string['filestoredin'] = '保存文件至文件夹';
$string['filestoredinhelp'] = '文件将保存于此';
$string['filterall'] = '过滤全部字符串';
$string['filtermatchoneperpage'] = '每页只过滤一次';
$string['filtermatchonepertext'] = '每篇只过滤一次';
$string['filternavigationwithsystemcontext'] = '使用系统上下文过滤导航';
$string['filters'] = '过滤器';
$string['filtersettings'] = '管理过滤器';
$string['filtersettingsgeneral'] = '常规过滤设置';
$string['filteruploadedfiles'] = '过滤上传的文件';
$string['forceclean'] = '随地清理内容';
$string['forceclean_desc'] = '添加到站点的内容通常在显示之前进行清理，以删除可能存在安全威胁的任何内容。但是，在某些位置（例如活动描述，页面资源或HTML块）中不会清除内容，以允许添加脚本，媒体，内联框架等。如果启用此设置，则将清除所有内容。这可能导致现有内容不再正确显示。';
$string['forcelogin'] = '用户必须登录';
$string['forceloginforprofileimage'] = '强制用户登录才能查看用户头像';
$string['forceloginforprofileimage_help'] = '如果启用，只有已登录用户才能查看用户的个人头像，并且所有通知邮件都将使用默认头像。';
$string['forceloginforprofiles'] = '用户必须登录后才能查看个人资料';
$string['forcetimezone'] = '强制时区';
$string['formatuninstallwithcourses'] = '共有 {$a->count} 个课程使用 {$a->format}。它们的格式会改成 {$a->defaultformat} (本站的默认格式). 一些格式相关的数据将会丢失。您确定要继续吗？';
$string['frontpage'] = '网站首页';
$string['frontpagebackup'] = '首页网站备份';
$string['frontpagedefaultrole'] = '默认的网站首页角色';
$string['frontpagefilters'] = '网站首页过滤器';
$string['frontpageloggedin'] = '登录后的网站首页项目';
$string['frontpageoverrides'] = '网站首页的许可覆盖率';
$string['frontpagequestions'] = '网站首页问题';
$string['frontpagerestore'] = '网站首页恢复';
$string['frontpageroles'] = '网站首页角色';
$string['frontpagesettings'] = '网站首页设置';
$string['fullnamedisplay'] = '全称格式';
$string['fullnamedisplayprivate'] = '全名格式 - 私人的';
$string['gdrequired'] = 'Moodle 现在需要 GD 扩展来做图片转换。';
$string['generalsettings'] = '一般设置';
$string['geoipdbedition'] = 'GeoIP数据库版本';
$string['geoipdbedition_desc'] = '选择要下载的GeoIP数据库版本。请注意，使用GeoIP2-City数据库需要有效的付费许可证。';
$string['geoipfile'] = 'GeoIP城市数据库';
$string['geoipmaxmindaccid'] = 'MaxMind 账户 ID';
$string['geoipmaxmindaccid_desc'] = '在MaxMind API服务中创建的账户ID。';
$string['geoipmaxmindlicensekey'] = 'MaxMind 许可证密钥';
$string['geoipmaxmindlicensekey_desc'] = '在MaxMind API服务上创建的账户的许可证密钥。';
$string['getremoteaddrconf'] = '被记录的IP地址来源于';
$string['globalsearch'] = '全局搜索';
$string['globalsearchmanage'] = '管理全局搜索';
$string['googlemapkey3'] = 'Google 地图的 API V3 密钥';
$string['googlemapkey3_help'] = '您需要输入一个特殊的 key 以使用 Google 地图来显示 IP 地址查询可视化。您可以从 <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> 获取免费的 key';
$string['gotofirst'] = '转到第一个缺失字符处';
$string['gradebook'] = '成绩单';
$string['gradebookroles'] = '有成绩的角色';
$string['gradeexport'] = '成绩导出的主要方法';
$string['gradeexportdefault'] = '默认成绩导出方法';
$string['gravatardefaulturl'] = 'Gravatar 默认图像 URL';
$string['gravatardefaulturl_help'] = '如果不能够对于指定的用户找到一个图片，Gravatar 将需要一个默认的图像去展示。请对该图片提供一个完整的 URL 地址。如果您置该选项为空，那么 Moodle 将会对于您当前浏览的页面尝试使用最合适的默认图片。请注意 Gravatar 也有一段代码 <a href="https://en.gravatar.com/site/implement/images/#default-image"> 可以用于产生默认图片。';
$string['group_customfield'] = '自定义群组字段';
$string['groupenrolmentkeypolicy'] = '分组选课密码策略';
$string['groupenrolmentkeypolicy_desc'] = '如果启用，将根据上述设置中指定的密码策略检查分组选课密码。';
$string['grouping_customfield'] = '对自定义字段进行分组';
$string['guestroleid'] = '访客的角色';
$string['guestroleid_help'] = '此角色被自动分配给访客用户。它也被临时分配给通过访客选课插件进入课程的未选课用户。';
$string['h5pgetcontenttypestask'] = '从h5p.org下载可用的H5P内容类型';
$string['helpadminseesall'] = '在网站日历中，管理员是查看和筛选所有课程日历中的事件，还是仅查看和筛选注册课程中的事件？无论选择何种选项，管理员都可以通过先导航到课程，然后直接访问课程日历来管理每个课程日历的事件。';
$string['helpcalendarcustomexport'] = '在日历导出中启用自定义的日期范围导出选项。要使设置生效必须启用日历导出功能。';
$string['helpexportlookahead'] = '对于自定义导出选项，日历需要在导出时查找未来多少天内的活动？';
$string['helpexportlookback'] = '对于自定义导出选项，日历需要在导出时查找过去多少天内的活动？';
$string['helpforcetimezone'] = '您可以允许用户选择他自己的时区或者让所有用户只能使用同一时区。';
$string['helpshowicalsource'] = '若启用，通过 iCal 导入的活动将显示订阅名和链接。';
$string['helpsitemaintenance'] = '用于升级和其它需要的工作';
$string['helpstartofweek'] = '在日历中一周的开始是哪一天?';
$string['helpupcominglookahead'] = '缺省情况下，日历系统查找未来几天内的事件？';
$string['helpupcomingmaxevents'] = '缺省情况下，为用户显示最多几个即将发生事件？';
$string['helpweekenddays'] = '一周中的哪些天是“周末”并用不同的颜色显示?';
$string['hiddenuserfields'] = '隐藏用户字段';
$string['hidefromall'] = '隐瞒所有用户';
$string['hidefromnone'] = '因此没有任何人';
$string['hidefromstudents'] = '学生端不可见';
$string['hookcallbacknotcallable'] = '此回调函数不可调用。这可能是因为类或方法不存在，或者该方法不是公共的。';
$string['hookcallbacks'] = '回调函数';
$string['hookcallbacks_help'] = '当钩子(hook)被调度时将被调用的回调函数列表。

显示的顺序是回调函数被调用的顺序。

具有较高优先级的回调函数将在具有较低优先级的回调函数之前被调用。';
$string['hookclassmissing'] = '未知钩子类型';
$string['hookclassmissing_desc'] = '钩子(hook)发现代理返回了一个不存在的类。';
$string['hookconfigoverride'] = '已覆盖';
$string['hookconfigoverride_help'] = '此回调函数的定义已在站点配置文件 config.php 中被覆盖。';
$string['hookdeprecates'] = '已弃用的回调';
$string['hookdescription'] = '描述';
$string['hookdescriptionmissing'] = '没有描述钩子的方法';
$string['hookname'] = '钩子';
$string['hooksoverview'] = '钩子总览';
$string['hookunknown'] = '找不到钩子';
$string['hookunknown_desc'] = '此回调所监听的对象不可用。它可能已被移除或重命名，或者在当前 Moodle 版本中不可用。';
$string['hostname'] = '主机名称';
$string['htmleditor'] = 'HTML 编辑器';
$string['htmleditorsettings'] = 'HTML编辑器设置';
$string['htmlsettings'] = 'HTML设置';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP安全';
$string['iconvrequired'] = '必须安装ICONV扩展';
$string['igbinary322buggyversion'] = '安装在站点上的 php-igbinary 扩展在使用 PHP 7.2 运行时可能会导致问题。 建议您升级到 php-igbinary 3.2.5 或更高版本，或者升级到 PHP 7.3 或更高版本。';
$string['ignore'] = '忽略';
$string['importantupdates_content'] = '<p>计划在2025年4月发布的下一个Moodle 5.0中，聊天和调查活动将从核心Moodle中删除。它们将作为插件在
<a href="https://moodle.org/plugins/">Moodle插件目录</a>.</p>
<p>如果您希望继续在您的网站中使用Chat或Survey，您可以在升级到Moodle 5.0之前将它们作为插件安装。</p>';
$string['importantupdates_title'] = '关于聊天和调查活动的重要更新';
$string['includemoduleuserdata'] = '包括模块用户数据';
$string['incompatibleblocks'] = '不兼容的版块';
$string['incompleteunicodesupport'] = 'MySQL 或 MariaDB 的配置默认使用 “utf8”。这一字符集不支持四字节的字符(它包含某些表情符号)。若尝试使用这些字符，将会在更新记录时导致错误，而且送到数据库的任何信息将会缺失。
请考虑将你的配置更改为“utf8mb4”。详情请参阅文档。';
$string['indexdata'] = '索引数据';
$string['indexinginfo'] = '要对于您网站内容制作索引，建议您采用"全域搜索索引"计划任务。';
$string['installhijacked'] = '很抱歉，只有来自最初IP地址的访问才能结束安装。';
$string['installsessionerror'] = '无法初始化PHP会话。请确认您的浏览器是否接受Cookie。';
$string['intlrecommended'] = 'intl扩展可以增强国际化支持，例如符合区域习惯的排序。';
$string['intlrequired'] = '需要 Intl 扩展改善国际化支持，例如与语言区适应的排序及国际域名。';
$string['invalidagedigitalconsent'] = '未达到数字承诺年龄:  {$a}';
$string['invalidforgottenpasswordurl'] = '忘记密码链接不正确';
$string['invalidsection'] = '无效小节。';
$string['invalidthemepreset'] = '所选的预设文件与此主题不兼容。SCSS编译错误为："{$a}"';
$string['invaliduserchangeme'] = '用户名“changeme”是保留的用户名，您不能用它创建账号。';
$string['ipblocked'] = '本站现在不可访问。';
$string['ipblocker'] = 'IP封禁器';
$string['ipblockersyntax'] = '将每个条目放在一行。有效的条目是完整的IP地址（如 <b>192.168.10.1</b>），它与单个主机相匹配；或部分地址（如<b>192.168</b>），它与任何以这些数字开始的地址相匹配；或CIDR符号（如 <b>231.54.211.0/20</b>）；或一个IP地址范围（如 <b>231.3.56.10-20</b>），该范围适用于地址的最后一部分。不支持文本域名（如 \'example.com\'）。空行和 "#"字符串后面的文字被忽略。';
$string['iplookup'] = 'IP地址查找';
$string['iplookupgeoplugin'] = '<a href=“https://www.geoplugin.com”>geoPlugin</a> 服务目前用于查找地理信息。为了获得更准确的结果，我们建议安装 MaxMind GeoIP City 数据库的本地副本。';
$string['iplookupinfo'] = '免费的在线 NetGeo 服务器用于查找 IP 地址位置。但是，数据库不再维护，并且可能会返回不正确的数据。建议从 MaxMind 安装 GeoIP 数据库的本地副本。<br />
如果提供了 Google Maps API V3 密钥，则会使用 Google 地图显示 IP 地址位置。您需要一个 Google 帐户并申请 Google Maps API 密钥。如果未提供 Google Maps API V3 密钥，则使用 OpenStreetMap 显示 IP 地址位置。';
$string['iplookupmaxmindnote'] = '该产品包括由MaxMind创建的GeoIPCity数据，可通过 <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>获取。';
$string['iscustomadminwarnings'] = '检测到你的网站使用了自定义的管理员目录。此功能已经不受支持并将会在Moodle4.2版本后删除。';
$string['ishttpswarning'] = '已经检测到你的网站没有使用 HTTPS 来增加安全。强烈建议您将您的网站改用HTTPS 以增加安全性，并改进与其他系统的整合。';
$string['keeptagnamecase'] = '保持标签名大小写';
$string['lang'] = '缺省语言';
$string['langcache'] = '缓存语言菜单';
$string['langcache_desc'] = '缓存语言菜单。如果启用缓存语言菜单，那么可用的翻译列表将会被缓存。当您通过内置的语言包管理工具安装或删除语言包时，缓存会自动更新。如果您手动安装一个新的语言包时，您需要使用“清除缓存”来更新已缓存的语言包列表。';
$string['langlist'] = '语言菜单中的语言';
$string['langmenu'] = '显示语言菜单';
$string['langmenuinsecurelayout'] = '在安全布局中显示语言菜单';
$string['langmenuinsecurelayout_desc'] = '如果启用，则用户可以在使用安全布局试答测验或进行其他活动时更改其语言。';
$string['langpackwillbeupdated'] = '注意：在升级期间，Moodle将尝试更新语言包。';
$string['langstringcache'] = '缓存所有语言字符串';
$string['languagesettings'] = '语言设置';
$string['latinexcelexport'] = 'Excel编码方式';
$string['legacyfilesaddallowed'] = '允许在旧版本课程文件中添加';
$string['legacyfilesaddallowed_help'] = '如果课程有旧版本课程文件，则允许在其中添加新文件和文件夹。';
$string['legacyfilesinnewcourses'] = '新课程使用旧版课程文件';
$string['legacyfilesinnewcourses_help'] = '缺省情况下，旧版本课程文件区域只在升级过来的课程中存在。请注意，某些特性，比如单个活动的备份/恢复，和此设置不兼容。';
$string['libcurlwarning'] = '已经检测到 libcurl 没有CURLOPT_PROTOCOL支持，为了安全理由，建议安装一个最新版的 libcurl 。';
$string['licensesettings'] = '许可证设置';
$string['linkadmincategories'] = '链接管理类别';
$string['linkadmincategories_help'] = '如果启用，管理员设置分类链接会显示在导航中，导向管理分类页面。';
$string['loading'] = '正在加载';
$string['localetext'] = '全站的地区设置';
$string['localstringcustomization'] = '本地定制';
$string['location'] = '位置';
$string['locationsettings'] = '位置设置';
$string['locked'] = '已锁定';
$string['lockoutduration'] = '帐号锁定期限';
$string['lockoutduration_desc'] = '到设置的期限锁定的帐号自动解除锁定。';
$string['lockoutemailbody'] = '嗨{$a->firstname}，

您在服务器"{$a->sitename}"上的用户名为 {$a->username}  的帐户
在多次无效登录尝试后被锁定。

要立即解锁帐户，请转到以下地址

{$a->link}

在大多数邮件程序中，这应该显示为蓝色链接
您可以单击它。 如果这不起作用，
然后将地址复制并粘贴到地址中
Web 浏览器窗口顶部的行。

如果您需要帮助，请联系网站管理员，
{$a->admin}';
$string['lockoutemailsubject'] = '你在 {$a} 的账户被锁定';
$string['lockouterrorunlock'] = '提供的帐号解锁信息无效。';
$string['lockoutthreshold'] = '帐号锁定阀值';
$string['lockoutthreshold_desc'] = '设定一个数值，达到多少次登录尝试失败则帐号锁定。这一选项可以防范网络攻击。';
$string['lockoutwindow'] = '帐号锁定监视窗';
$string['lockoutwindow_desc'] = '为帐号锁定阀值设置的监视时间，如果到设置的时间没有失败的尝试，则阀值计数器归零。';
$string['lockrequestcategory'] = '防止类别选择';
$string['log'] = '日志';
$string['logguests'] = '日志包含访客的访问';
$string['logguests_help'] = '此设置启用后，访客账号的行为会被记入日志。高知名度的网站出于性能考虑，可能要禁用此功能。建议正式使用的网站打开此功能。';
$string['logininfoinsecurelayout'] = '在安全布局中显示登录用户';
$string['logininfoinsecurelayout_desc'] = '如果启用，在使用安全布局试答测验或进行其他活动时，登录用户的全名将显示在导航条中。';
$string['loginpageautofocus'] = '登录页面焦点自动移到表单';
$string['loginpageautofocus_help'] = '启用此选项可以让登录页面更方便，但自动移动焦点可能会给无障碍访问带来问题。';
$string['loglifetime'] = '保留多久的日志';
$string['logo'] = '图标';
$string['logo_desc'] = '用于某些主题（如核心主题）用作装饰的完整Logo。这张图片的分辨率可以很高，因为它将被缩小使用（并被缓存以提高性能）。通常情况下，宽度大于高度的Logo会有更好的效果。';
$string['logocompact'] = '小图标';
$string['logocompact_desc'] = '与上述相同的标志的压缩版本，如徽章、盾牌或图标。即使在小尺寸的情况下，图像也应该是清晰的。';
$string['logossettings'] = '图标';
$string['logstorenotrequired'] = '不要求日志存储';
$string['logstoressupported'] = '日志存储支持这份报告';
$string['longtimewarning'] = '<b>注意：这个过程可能需要花费较长时间。</b>';
$string['mailnewline'] = '邮件中的换行符';
$string['maintenancemode'] = '系统维护中';
$string['maintenancemodeisscheduled'] = '网站将在 {$a->min} 分 {$a->sec} 秒后切换到维护模式';
$string['maintenancemodeisscheduledlong'] = '这个站点将在{$a->hour}小时{$a->min}分{$a->sec}秒后被切换到维护模式。';
$string['maintfileopenerror'] = '打开维护文件时发生错误！';
$string['maintinprogress'] = '维护工作进行中...';
$string['managecontextlock'] = '冻结此内容';
$string['managecontextlocklocked'] = '{$a->contextname} 及其下面的内容现已冻结。';
$string['managecontextlockunlocked'] = '{$a->contextname} 及其下面的内容现已解除冻结。';
$string['managecontextunlock'] = '解冻此内容';
$string['managecustomfields'] = '管理自定义字段类型';
$string['manageformats'] = '管理课程格式';
$string['manageformatsgotosettings'] = '能够改变在{$a}中的默认格式';
$string['managelang'] = '管理';
$string['manageqbanks'] = '管理问题库插件';
$string['manageqbehaviours'] = '管理题目行为';
$string['manageqtypes'] = '管理题目类型';
$string['maturity100'] = '测试';
$string['maturity150'] = '待发行';
$string['maturity200'] = '稳定版';
$string['maturity50'] = '内部测试';
$string['maturityallowunstable'] = '提示：您可能需要使用 --allow-unstable 选项来运行这个脚本';
$string['maturitycoreinfo'] = '您的网站正运行不稳定的“{$a}”开发版代码。';
$string['maturitycorewarning'] = '您正要安装或升级的Moodle版本包含不稳定的“{$a}”开发代码，它还不适合在正式网站使用。如果您不想这样，请确认您正在从稳定分支的Moodle代码升级。看Moodle文档了解更多细节。';
$string['maxbytes'] = '上传文件大小的最大值';
$string['maxcharacter'] = '{$a} 字符数上限';
$string['maxconsecutiveidentchars'] = '连续相同字符数';
$string['maxeditingtime'] = '编辑帖子的最大时间';
$string['maxsizeperdownloadcoursefile'] = '每个文件的最大尺寸';
$string['maxsizeperdownloadcoursefile_desc'] = '下载课程内容时每个文件的最大尺寸。超过此大小的文件将从下载中省略。';
$string['maxtimelimit'] = '最长时间限制';
$string['maxtimelimit_desc'] = '限制Moodle没有输出时最长执行时间，以秒为单位。0表示使用Moodle默认限制。如果你前端服务器有设置时间限制，那要将这个值设的比前端的值低一点这样才会将PHP错误记录到日志中。此设置对CLI脚本无效。';
$string['maxusersperpage'] = '每页的最大用户数';
$string['mbstringrecommended'] = '强烈建议安装可选的MBSTRING库，以提高网站性能，特别是当你的网站支持非拉丁语系时。';
$string['mbstringrequired'] = '为了提高站点性能，需要安装MBSTRING库，特别是在您的站点支持非拉丁语言的情况下。';
$string['mediapluginavi'] = '过滤.avi文件';
$string['mediapluginflv'] = '过滤.flv文件';
$string['mediapluginimg'] = '启用自动嵌入链接的图片';
$string['mediapluginmov'] = '过滤.mov文件';
$string['mediapluginmp3'] = '过滤.mp3文件';
$string['mediapluginmpg'] = '过滤.mpg文件';
$string['mediapluginogg'] = '打开.ogg过滤器';
$string['mediapluginogv'] = '启用.ogv过滤器';
$string['mediapluginram'] = '过滤.ram文件';
$string['mediapluginrm'] = '过滤.rm文件';
$string['mediapluginrpm'] = '过滤.rpm文件';
$string['mediapluginwmv'] = '过滤.wmv文件';
$string['mediapluginyoutube'] = '打开YouTube链接过滤器';
$string['messaging'] = '启用消息系统';
$string['messagingallowemailoverride'] = '修改通知邮件';
$string['messagingallusers'] = '允许全站消息发送';
$string['messagingcategory'] = '消息';
$string['messagingdefaultpressenter'] = '默认情况下使用enter发送';
$string['messagingdeleteallnotificationsdelay'] = '删除所有通知';
$string['messagingdeletereadnotificationsdelay'] = '删除已读通知';
$string['messagingssettings'] = '消息设置';
$string['minpassworddigits'] = '数字';
$string['minpasswordlength'] = '密码的长度';
$string['minpasswordlower'] = '小写字母';
$string['minpasswordnonalphanum'] = '非文字数字式字符';
$string['minpasswordupper'] = '大写字母';
$string['misc'] = '杂项';
$string['mlbackendsettings'] = '机器学习后端设置';
$string['mnetrestore_extusers'] = '<strong>注意：</strong> 这个备份文件包含远程Moodle网络的使用者帐号，该帐号将做在处理过程中存储。';
$string['mnetrestore_extusers_admin'] = '<strong>注意：</strong>您选择的备份文件貌似是来自另一个Moodle，且文件中包含远程Moodle网络用户账户。恢复过程将尝试把所有已有用户和Moodle网络主机匹配。所有不匹配的帐号将自动转换为互联网认证帐号（而不是mnet账号）。恢复日志将记录详情。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意：</strong> 这个备份文件来自一个不同的MOODLE站点，而且包括远程Moodle网络中的用户帐号，这个操作可能不支持。如果您确定在Moodle安装的时候已经创建好，或者您确定所有需要Moodle网路中主机已经配置完成，您才可以尝试恢复。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意：</strong>您选择的备份文件貌似是来自另一个Moodle，且文件中包含远程Moodle网络用户账户。您不可以进行这种恢复。请联系网站管理员，或者不带用户信息（模块、文件等）恢复课程。';
$string['mnetrestore_extusers_switchuserauth'] = '远程Moodle网络用户{$a->username}(来自{$a->mnethosturl}) 切换到本地{$a->auth}认证用户';
$string['mobilenotconfiguredwarning'] = 'Moodle 移动应用未启用。';
$string['modassignmentinuse'] = '您的网站仍在使用 Assignment 2.2 插件。在升级之前，您必须进行以下操作：1）备份您想保留的任何 Assignment 2.2 活动并将其恢复为 Assignment 活动；2）从数据库中删除所有的 Assignment 2.2 数据。';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2 子插件可能存在。在升级之前，需要删除 mod/assignment 文件夹及其所有子插件。';
$string['modeditdefaults'] = '活动设置缺省值';
$string['modsettings'] = '管理活动';
$string['modulesecurity'] = '模块安全';
$string['moodlebrandedapp'] = '定制 Moodle 移动应用';
$string['moodlebrandedappreference'] = '另外，也可获取<a href="https://moodle.com/branded-app/">贴牌 Moodle移动应用</a>打造您的的品牌。';
$string['mustenablestats'] = '本网站的统计功能还未开启。';
$string['mycourses'] = '我的课程';
$string['mydashboard'] = '系统缺省个人主页';
$string['mymoodle'] = '个人主页';
$string['mypage'] = '默认个人主页';
$string['mypagelocked'] = '锁定缺省页面';
$string['myprofile'] = '缺省个人资料页';
$string['navadduserpostslinks'] = '添加查看用户帖子的链接';
$string['navadduserpostslinks_help'] = '如果启用，每个用户的导航中都会有两个链接，指向用户在全站或指定课程发起的讨论和发表的帖子。';
$string['navcourselimit'] = '课程限制';
$string['navfilter'] = '筛选自定义菜单';
$string['navfilter_desc'] = '通过设置为应用于 <strong>“内容和标题”</strong>的 Moodle 过滤器处理自定义菜单。这对于启用动态自定义菜单项很有用。';
$string['navigationupgrade'] = '此次升级引入了两个新的导航版块来替换管理、课程、活动和师生名录版块。如果你已经为这些版块设置了某些特殊的权限，那么你应该检查一下是否一切都在按照你想要的方式工作。';
$string['navshowallcourses'] = '显示所有课程';
$string['navshowcategories'] = '显示课程分类';
$string['navshowfrontpagemods'] = '在导航中显示主页活动';
$string['navshowfrontpagemods_help'] = '如果启用，站点首页活动将显示在“站点首面”下的导航上。此设置仅适用于基于经典的主题。';
$string['navshowfullcoursenames'] = '显示课程全名';
$string['navshowfullcoursenames_help'] = '如果启用，导航将使用课程的全称而不是简称';
$string['navshowmycoursecategories'] = '显示我的课程类别';
$string['navshowmycoursecategories_help'] = '如果启用，用户的“我的课程”分支中的课程将在导航块中按类别显示（仅基于经典主题）。';
$string['navsortmycourseshiddenlast'] = '最后整理我的隐藏课程';
$string['navsortmycourseshiddenlast_help'] = '如果启用，任何隐藏课程将列在可见课程之后（对于可以查看隐藏课程的用户）。否则，所有课程，无论其可见性如何，都将根据“排序我的课程”设置列出。';
$string['navsortmycoursessort'] = '导航栏中课程的顺序';
$string['navsortmycoursessort_help'] = '这决定了在 “我的课程” 下是按设定的排序顺序罗列所有的课程（如，在网站管理 > 课程 > 管理课程和分类设定的排序顺序）还是按课程设置的字母顺序排序';
$string['never'] = '从不';
$string['neverdeleteruns'] = '从不删除运行';
$string['newestdocindexed'] = '最近索引的文档';
$string['nobookmarksforuser'] = '您没有任何书签。';
$string['nodatabase'] = '无数据库';
$string['noemaileverwarning'] = '<strong>注意: </strong> 所有外发邮件已被禁用';
$string['nohttpsformobilewarning'] = '建议启用HTTPS并使用有效的证书。Moodle应用总会先尝试安全连接。';
$string['nomissingstrings'] = '没有缺失的字符';
$string['none'] = '无';
$string['nonewsettings'] = '此次升级没有增加新的设置。';
$string['nonexistentbookmark'] = '您请求的书签不存在。';
$string['noreplyaddress'] = '不要回复的地址';
$string['noreplydomain'] = '不要回复和域名';
$string['noreplydomaindetail'] = '设置不要回复地址和配置域名';
$string['noresults'] = '查无结果';
$string['noroles'] = '无角色';
$string['nosupportedlogstore'] = '找不到支持的日志存储';
$string['noteunneededblocks'] = '注意：如果在主题设置“不需要的块”中指定了要显示的块，则不会在课程的“添加块”菜单中列出。';
$string['notifications'] = '通告';
$string['notifyloginfailures'] = '发送登陆失败的Email到';
$string['notifyloginthreshold'] = '邮件通告的下限';
$string['notloggedinroleid'] = '访问者的角色';
$string['numberofmissingstrings'] = '缺失字符数：{$a}';
$string['numberofstrings'] = '字符串总数：{$a->strings}<br />缺失：{$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = '在您网站{$a->siteurl}上有一个OAuth服务{$a->issuer}的刷新凭证已经过期。这将会限制使用到此服务的任何插件的功能。要解决此一问题，请访问OAuth 2服务配置页面，然后在表格列中点击代表该服务的“连接系统帐户”小图标。请确定你每次登录OAuth系统时，都使用相同的服务帐号。';
$string['oauthrefreshtokenexpiredshort'] = '{$a->issuer} 在你的网站 {$a->siteurl} 的 OAuth 刷新凭证已经过期';
$string['onlynoreply'] = '仅当从一个 no-reply 的地址';
$string['opcacherecommended'] = 'PHP字节码缓存提高性能且降低对内存的要求。Moodle完全支持并建议使用OPC缓存扩展';
$string['opensslrecommended'] = '要使用Moodle网络功能，强烈推荐安装OpenSSL库。';
$string['opensslrequired'] = 'Moodle现在需要PHP扩展OpenSSL，以提供更强大的加密服务。';
$string['opentowebcrawlers'] = '向Google开放';
$string['optionalmaintenancemessage'] = '可选维护信息';
$string['order1'] = '第一';
$string['order2'] = '第二';
$string['order3'] = '第三';
$string['order4'] = '第四';
$string['outgoingmailconfig'] = '发送邮件设置';
$string['overridetossl'] = '现在已弃用用于登录的HTTPS。此实例现在被强制为SSL。要解决此警告，请将config.php中的wwwroot更改为https://';
$string['pageinfodebugsummary'] = '本页为: {$a}';
$string['passwordchangelogout'] = '更改密码后自动登出';
$string['passwordchangelogout_desc'] = '如果启用，则当密码修改后，新密码被设定，所有浏览器会话信息将被终止。（这个设置不会影响通过批量用户上传方式修改的密码。）';
$string['passwordchangetokendeletion'] = '更换密码之后移除web服务访问令牌(token)。';
$string['passwordchangetokendeletion_desc'] = '如果启用，当密码更换时用户的所有web服务访问令牌(token)都会被删除。';
$string['passwordpolicy'] = '密码政策';
$string['passwordpolicycheckonlogin'] = '登录时检查密码';
$string['passwordresettime'] = '在多长时间内必须验证重置密码请求';
$string['passwordreuselimit'] = '密码轮换限制';
$string['passwordreuselimit_desc'] = '密码允许重复使用前的用户更改密码次数阀值。以前使用过的密码哈希表被存储在本地数据表。这个选项可能不适用于一些扩展的认证插件。';
$string['pathtodot'] = 'dot的路径';
$string['pathtodot_help'] = '指向点的路径。在Linux上，它类似于/usr/bin/dot。在Windows上，它类似于C:\\Program Files（x86）\\Graphviz2.38\\bin\\dot.exe。在Mac上，它类似于/opt/local/bin/dot。为了能够从DOT文件生成图形，您必须安装DOT可执行文件并指向此处。';
$string['pathtodu'] = 'du的路径';
$string['pathtogs'] = '还原脚本路径';
$string['pathtogs_help'] = '在多数Linux中是 "/usr/bin/gs"。在Windows中它有类似 "c:\\gs\\bin\\gswin32c.exe" 的形式 (确保路径中没有空格。如果需要的话，可以把 "gswin32c.exe" 和 "gsdll32.dll" 复制到一个没有空格的新路径中)';
$string['pathtopdftoppm'] = 'pdftoppm路径';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a>是一个PDF呈现库，其中包含用于将PDF文件转换为PNG的工具pdftoppm。性能通常比使用Ghostscript时更好，特别是对于大型文件。如果可用，pdftoppm将优先于Ghostscript使用。在大多数Linux安装中，路径可以保留为/usr/bin/pdftoppm。否则，您需要安装poppler utils或poppler包，具体取决于您的Linux发行版。在Windows上，它是由Cygwin安装提供的。';
$string['pathtopgdump'] = 'pg_dump 的路径';
$string['pathtopgdumpdesc'] = '只有您的系统上有多个 pg_dump 时您才需要指定这个选项(譬如您您安装了多个版本的 postgresql)。';
$string['pathtopgdumpinvalid'] = 'pg_dump 路径无效──错误的路径或无法执行';
$string['pathtophp'] = 'PHP CLI 的路径';
$string['pathtopsql'] = 'psql 的路径';
$string['pathtopsqldesc'] = '只有您的系统上有多个 psql 时您才需要指定这个选项(譬如您您安装了多个版本的 postgresql)。';
$string['pathtopsqlinvalid'] = '无效的 psql 路径──错误的路径或无法执行';
$string['pathtopython'] = 'Python的路径';
$string['pathtopythondesc'] = '可执行Python二进制文件的路径（Python 2和Python 3都可以接受）。';
$string['pathtosassc'] = 'SassC路径';
$string['pathtosassc_help'] = '指定SassC二进制代码所有目录，此代码用于将用SASS编译器将Moodle的PHP代码转换为 SAssC。更多信息请访问 https://github.com/sass/sassc。';
$string['pcreunicodewarning'] = '强烈建议使用兼容 Unicode 字符的 PCRE PHP扩展。';
$string['perfdebug'] = '性能信息';
$string['perfdebugdeferred'] = '请等待脚本结束以显示性能调试';
$string['performance'] = '性能';
$string['pgcluster'] = 'PostgreSQL 集群';
$string['pgclusterdescription'] = '命令行操作时使用的 PostgreSQL version/cluster 选项。如果您的系统上只有一个 postgresql 服务器或您不对此不确定，请将此选项留空。';
$string['phpfloatproblem'] = '在处理PHP浮点数时遇到不期望的问题 - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = '您的站点已注册。注册信息上次更新{$a}。<br />“网站注册”计划任务可以让你的注册信息保持最新。你也可以在任何时候手动更新你的注册信息。';
$string['pleaserefreshregistrationnewdata'] = '注册信息已发生改变。请点击"更新注册"按钮确认。';
$string['pleaserefreshregistrationunknown'] = '你的站点已注册，但注册数据不存在。请通过“更新注册”按钮更新的你注册信息，或者确认已经启用“站点注册”计划任务使你的注册信息会自动更新。';
$string['plugin'] = '插件';
$string['plugin_disabled'] = '{$a} 已禁用。';
$string['plugin_enabled'] = '{$a} 已启用。';
$string['plugins'] = '插件';
$string['pluginscheck'] = '插件依赖检查';
$string['pluginscheckfailed'] = '{$a->pluginslist}依赖检查失败';
$string['pluginschecktodo'] = '您必须先解决所有插件的需求，然后再继续安装此版本的Moodle！';
$string['pluginsoverview'] = '插件概况';
$string['pluginsoverviewsee'] = '点击 <a href="{$a->url}">插件预览</a>了解更多详细信息';
$string['policysettings'] = '政策设置';
$string['privacy:metadata'] = '管理插件不储存任何私人数据。';
$string['privacyandpolicies'] = '隐私和政策';
$string['privacysettings'] = '隐私设置';
$string['profilecategory'] = '类别';
$string['profilecategoryname'] = '类别名（必填）';
$string['profilecategorynamenotunique'] = '该类别名已经使用';
$string['profilecommonsettings'] = '公共设置';
$string['profileconfirmcategorydeletion'] = '类别中{$a}字段将被移入类别上面或下面。<br />您是否希望删除该类别吗？';
$string['profileconfirmfielddeletion'] = '{$a}用户记录字段将会删除<br />您是否希望删除该字段。';
$string['profilecreatecategory'] = '创建一个新的个人资料类别';
$string['profilecreatefield'] = '创建一个新的配置文件字段';
$string['profilecreatenewcategory'] = '创建一个新的类别';
$string['profilecreatenewfield'] = '创建一个新的“{$a}”个人资料字段';
$string['profiledefaultcategory'] = '其它项';
$string['profiledefaultchecked'] = '使用默认值检查';
$string['profiledefaultdata'] = '默认值';
$string['profiledeletecategory'] = '删除一个类别';
$string['profiledeletefield'] = '删除字段“{$a}”';
$string['profiledescription'] = '字段描述';
$string['profiledscript'] = '这个脚本已经被剖析过';
$string['profiledscriptview'] = '查看此脚本的剖析信息';
$string['profileeditcategory'] = '编辑类别{$a}';
$string['profileeditfield'] = '编辑个人资料字段{$a}';
$string['profilefield'] = '配置文件字段';
$string['profilefieldcolumns'] = '列';
$string['profilefieldispassword'] = '这是密码字段吗？';
$string['profilefieldlink'] = '链接';
$string['profilefieldlink_help'] = '要将文本转换为链接，请输入包含$$的URL，其中$$将替换为文本。例如，要将Twitter ID转换为链接，请输入https://twitter.com/$$。';
$string['profilefieldlinktarget'] = '链接目标';
$string['profilefieldmaxlength'] = '字符限制';
$string['profilefieldmaxlength_help'] = '要在设置“显示用户标识”中使用此字段，限制必须小于等于255个字符。';
$string['profilefieldrows'] = '行';
$string['profilefields'] = '追加管理字段';
$string['profilefieldsize'] = '显示大小';
$string['profileforceunique'] = '数据是唯一吗？';
$string['profileinvaliddata'] = '无效值';
$string['profilelocked'] = '该字段锁定了吗？';
$string['profilemenudefaultnotinoptions'] = '默认值不再选项中';
$string['profilemenunooptions'] = '无菜单选择';
$string['profilemenuoptions'] = '菜单选项（每行一个）';
$string['profilemenutoofewoptions'] = '您必须提供至少两个选项';
$string['profilename'] = '名称';
$string['profilenofieldsdefined'] = '无定义字段';
$string['profilerequired'] = '该字段是否必填';
$string['profileroles'] = '个人资料可见角色';
$string['profilesforenrolledusersonly'] = '只对已选课用户建立个人资料';
$string['profileshortname'] = '简称（必须唯一）';
$string['profileshortnameinvalid'] = '此短名称只能包含字母数字字符（字母和数字）或下划线（_）。';
$string['profileshortnamenotunique'] = '简称已经使用';
$string['profilesignup'] = '在注册页显示？';
$string['profilespecificsettings'] = '细节设置';
$string['profilevisible'] = '该字段对谁可见';
$string['profilevisible_help'] = '* 不可见 - 只有管理员能查看的私人数据
* 用户可见 - 只有管理员和用户能查看的私人数据
* 用户、教师、和管理员可见 - 只有用户、教师和管理员能够查看私人数据(基于课程配置文件)
* 所有人可见';
$string['profilevisibleall'] = '对任何人可见';
$string['profilevisiblenone'] = '不可见';
$string['profilevisibleprivate'] = '对注册用户可见';
$string['profilevisibleteachers'] = '对用户、教师和管理员可见';
$string['profiling'] = '剖析';
$string['profilingallowall'] = '继续剖析';
$string['profilingallowall_help'] = '如果启用此设置，那么，在任何时刻，你可以在任何地方（PGC）使用PROFILEALL参数来激活对Moodle会话生命周期中执行的所有脚本的剖析。类似的，你可以使用PROFILEALLSTOP参数来停止剖析。';
$string['profilingallowme'] = '选择性剖析';
$string['profilingallowme_help'] = '如果启用此设置，那么，你可以选择性地在任何地方（PGC）使用PROFILEME参数，来剖析该脚本。类似的，你可以使用DONTPROFILEME参数阻止剖析。';
$string['profilingautofrec'] = '自动剖析';
$string['profilingautofrec_help'] = '通过配置此参数，一些请求（基于指定的频率（1/N）随机选择）会被选出、自动分析、保存结果以待进一步分析。注意这种分析方式会使用包含/排除设置。设为0会禁用自动分析。';
$string['profilingenabled'] = '启用剖析';
$string['profilingenabled_help'] = '如果您启用了这个设置，那么剖析就是可用的，然后您就可以通过配置下一个选项来定义它的行为。';
$string['profilingexcluded'] = '排除剖析';
$string['profilingexcluded_help'] = '（逗号或换行符分隔、绝对跳过wwwroot、可调用）URL的列表，这些URL将从“Profile these”设置定义的URL中排除。';
$string['profilingimportprefix'] = '个人简历导入前缀';
$string['profilingimportprefix_desc'] = '为更容易检测，所有输入运行的配置信息需要用特殊的值做为前缀';
$string['profilingincluded'] = '剖析这些';
$string['profilingincluded_help'] = '将自动分析的URL列表（逗号或换行符分隔、绝对跳过wwwroot、可调用）。示例：/index.php，/课程/视图.php。还接受任意位置的*wildchar。示例：/mod/forum/*，/mod/*/view.php。';
$string['profilinglifetime'] = '保留剖析运行数据';
$string['profilinglifetime_help'] = '指定您想保留多久旧的剖析运行信息。旧数据会被周期清理。注意，这不包含任意标记为“参考运行”的剖析运行数据。';
$string['profilingslow'] = '设置暂缓页面显示';
$string['profilingslow_help'] = '通过设置秒的最小时间，所有页面都会慢下来。只有相同配置文件的配置文件比现有概要文件慢。设置为0以禁用。请注意，这会遵守排除设置。';
$string['protectusernames'] = '保护用户名';
$string['proxybypass'] = '不使用代理的主机';
$string['proxyfixunsafe'] = '修复未代理的呼叫';
$string['proxyhost'] = '代理主机域名';
$string['proxylogunsafe'] = '记录未代理的呼叫';
$string['proxypassword'] = '代理主机密码';
$string['proxyport'] = '代理端口';
$string['proxytype'] = '代理类型';
$string['proxyuser'] = '代理用户名';
$string['purgecaches'] = '清空所有缓存';
$string['purgecachesconfirm'] = 'Moodle 可以缓存主题、JavaScript、语言字符串、过滤的文本、RSS 提要和其他计算数据。清除缓存将从服务器中删除数据并强制浏览器重新获取数据，因此您可以确保看到的是当前代码生成的最新值。清除缓存没有危险，但您的网站可能会在一段时间内显得较慢，直到服务器和客户端计算新信息并缓存它。';
$string['purgecachesfinished'] = '所有缓存都被清空了。';
$string['purgecachesnoneselected'] = '选择一个或多个要清理的缓存';
$string['purgecachespage'] = '清理缓存';
$string['purgecoursecache'] = '课程';
$string['purgefiltercache'] = '文字过滤';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = '语言字符串';
$string['purgemuc'] = '所有MUC缓存';
$string['purgeothercaches'] = '所有文件和其他缓存';
$string['purgeselectedcaches'] = '清理选中的缓存';
$string['purgeselectedcachesfinished'] = '选中的缓存已清除。';
$string['purgetemplates'] = '模板';
$string['purgethemecache'] = '主题';
$string['query'] = '查询';
$string['question'] = '试题';
$string['questionbehaviours'] = '题目行为';
$string['questioncwqpfscheck'] = '测验中的一个或多个随机问题被设置为从共享和非共享问题的混合类别中选择问题。请参阅 <a href="{$a->reporturl}">随机问题报告</a> 和 <a href="{$a->docsurl}">文档</a>。';
$string['questioncwqpfsok'] = '测验中没有‘随机’试题来至于共享和非共享问题类型中。';
$string['questiontype'] = '题目类型';
$string['questiontypes'] = '题目类型';
$string['quizattemptsupgradedmessage'] = '在Moodle 2.1版本有一个重大升级，数据库的升级可能会延后。升级到Moodle 2.7之前，必须完成这个升级。';
$string['recaptchaprivatekey'] = 'ReCAPTCHA 私钥';
$string['recaptchapublickey'] = 'ReCAPTCHA 公钥';
$string['referrernone'] = '浏览器默认值';
$string['referrerpolicy'] = '推荐人政策';
$string['referrerpolicydesc'] = '设置要包含在站点响应中的引用者策略标头';
$string['register'] = '注册您的网站';
$string['registration'] = '注册';
$string['registration_help'] = '注册后：
*你会收到安全警告
*你可以从你的网站激活移动应用推送通知
*你会为我们的Moodle全球社区统计数据做出贡献';
$string['registrationwarning'] = '切勿错过重要的更新和安全警报。';
$string['registrationwarningcontactadmin'] = '此站点未注册。请让管理员注册网站，这样他们就不会错过重要的更新。';
$string['releasenoteslink'] = '想更多了解此版本的 Moodle，请参考<a target="_new" href="{$a}">发行备忘录</a>。';
$string['rememberuserlicensepref'] = '记住用户许可偏好';
$string['rememberuserlicensepref_help'] = '如果启用，则在文件选择器中上载文件时，将预选用户选择的最后一个许可证。否则，将预选默认站点许可证。';
$string['rememberusername'] = '记住用户名';
$string['rememberusername_desc'] = '如果想在用户登录时用永久 cookie 保存用户名，启用此选项。未经用户同意而使用永久 cookie 可能会引发隐私问题。';
$string['replacefrontsearch'] = '用于主页课程搜索';
$string['reportsmanage'] = '管理报告';
$string['required'] = '要求的';
$string['requiredentrieschanged'] = '注意：升级后，在以下数据库活动中会强制执行“查看前必需的条目”设置：<br/>{$a->text}<br/>';
$string['requiremodintro'] = '必须输入活动描述';
$string['requiremodintro_desc'] = '启用则用户必须为每一个活动输入一段描述信息。';
$string['requires'] = '需要';
$string['resetindentation'] = '重置整个网站的缩进';
$string['resetindentation_help'] = '这将删除之前以 {$a->format} 为网站上的所有课程设置的缩进。';
$string['resetindentation_title'] = '在全站范围内重置缩进？';
$string['resetindentationsuccess'] = '缩进重置';
$string['restorecourse'] = '恢复课程';
$string['restorernewroleid'] = '操作恢复的用户在课程中的角色';
$string['restorernewroleid_help'] = '如果用户还没有管理恢复的课程的权限，那么用户会被自动选课并分配此角色。如果您不期望做恢复的用户能管理所有他恢复的课程，就选择“无”。';
$string['resultfilter'] = '按结果排列';
$string['reverseproxy'] = '反向代理';
$string['reverseproxyignore'] = '忽略反向代理';
$string['riskconfig'] = '用户可以改变网站的设置和行为';
$string['riskconfigshort'] = '配置风险';
$string['riskdataloss'] = '能破坏大量内容或信息的用户';
$string['riskdatalossshort'] = '数据丢失的风险';
$string['riskmanagetrust'] = '用户可以改变其它用户的信任设置';
$string['riskmanagetrustshort'] = '管理信任';
$string['riskpersonal'] = '用户可以获得访问其它用户隐私信息的权力';
$string['riskpersonalshort'] = '隐私风险';
$string['riskspam'] = '用户可以发送垃圾信息给站内用户或其它人';
$string['riskspamshort'] = '垃圾信息风险';
$string['riskxss'] = '用户可以添加允许跨网站描述的（XSS）文件和文本';
$string['riskxssshort'] = 'XSS风险';
$string['roleswithexceptions'] = '{$a->roles}，有以下例外， {$a->exceptions}';
$string['rssglobaldisabled'] = '在网站层面禁用';
$string['save'] = '保存';
$string['savechanges'] = '保存更改';
$string['scssinvalid'] = 'SCSS代码有语法错误，原因为：{$a}';
$string['search'] = '搜索';
$string['searchablecourses'] = '可搜索的课程';
$string['searchallavailablecourses'] = '可搜索课程';
$string['searchallavailablecourses_desc'] = '当搜索大量课程时，搜索引擎在某些情况下可能无法工作。如果你需要限制搜索的数量，可以设置仅搜索已注册的课程。';
$string['searchallavailablecourses_off'] = '仅在注册的课程内搜索';
$string['searchallavailablecourses_on'] = '在该用户可用的所有课程中查找';
$string['searchallavailablecoursesdesc'] = '如果设置为仅在已注册课程中搜索，则仅在用户注册的课程中搜索课程信息（名称和摘要）和课程内容。否则，用户可以访问的所有课程（如启用了来宾访问功能的课程）都将搜索课程信息和课程内容。';
$string['searchalldeleted'] = '所有已建立索引的内容已被删除';
$string['searchalternatesettings'] = '仅查询备用设置';
$string['searchalternatesettings_desc'] = '如果完成这些设置，则可以在“管理全局搜索”页上的“仅查询搜索引擎”选项中为此搜索引擎选择“备用设置”。这只在同一类型的两个搜索引擎之间移动时有用。';
$string['searchareadisabled'] = '搜索功能已禁用';
$string['searchareaenabled'] = '搜索功能已启用';
$string['searchareas'] = '探索范围';
$string['searchbanner'] = '搜索信息';
$string['searchbannerenable'] = '显示搜索信息';
$string['searchbannerenable_desc'] = '如果启用，以下文本将显示在所有用户的搜索屏幕顶部。这可用于在执行搜索引擎维护时通知用户。';
$string['searchdefaultcategory'] = '默认搜索类别';
$string['searchdefaultcategory_desc'] = '默认情况下，将显示所选搜索区域类别的结果。';
$string['searchdeleteindex'] = '删除所有被索引的内容';
$string['searchdisplay'] = '搜索结果显示选项';
$string['searchenablecategories'] = '在不同的类别中显示搜索结果';
$string['searchenablecategories_desc'] = '如已启用，搜索结果将显示在不同的类别中。';
$string['searchengine'] = '搜索引擎';
$string['searchenginealternatesettings'] = '{$a} (备用设置)';
$string['searchenginequeryonly'] = 'Query-only 搜索引擎';
$string['searchenginequeryonly_desc'] = '这个搜索引擎将只用于查询，而不是索引。通过使用此功能，您可以在不同的搜索引擎中重新编制索引，而用户查询将继续在此搜索引擎中工作。';
$string['searchenginequeryonly_none'] = '无（使用主搜索引擎查询）';
$string['searchenginequeryonlysame'] = 'query-only搜索引擎和主搜索引擎不能设置为相同值';
$string['searchhideallcategory'] = '隐藏所有类别';
$string['searchhideallcategory_desc'] = '如果选中，将在搜索结果屏幕上隐藏包含所有结果的类别。';
$string['searchincludeallcourses'] = '包括所有可见的课程';
$string['searchincludeallcourses_desc'] = '如果启用，搜索结果将包括用户可见的课程信息（名称和摘要），即使用户无权访问课程内容。';
$string['searchindexactions'] = '索引操作';
$string['searchindexdeleted'] = '索引已被删除';
$string['searchindextime'] = '索引时间限制';
$string['searchindextime_desc'] = '对大量新增内容进行索引时，计划任务将在此时限到达时停止。下次计划时间到时将继续执行。';
$string['searchindexupdated'] = '搜索引擎内容已更新';
$string['searchindexwhendisabled'] = '禁用时进行索引';
$string['searchindexwhendisabled_desc'] = '即使已禁用搜索，仍允许计划任务进行搜索索引。如果你希望先建立索引再开放搜索功能给学员们，这个功能对会非常有用';
$string['searchinsettings'] = '在设置中查找';
$string['searchlastrun'] = '最后一次执行(时间，文件数，记录数，忽略数)';
$string['searchmanagement'] = '搜索管理';
$string['searchmanagement_desc'] = '在非常大的站点上进行需要很长时间才能重建的搜索索引更改时，这些选项非常有用。';
$string['searchmaxtopresults'] = '成绩排名结果数量';
$string['searchmaxtopresults_desc'] = '要显示的课程内容或者用户搜索结果的最大数量。';
$string['searchnotavailable'] = '搜索不可用';
$string['searchoptions'] = '搜索选项';
$string['searchpartial'] = '（尚未完全索引）';
$string['searchreindexed'] = '所有网站内容已经重新建立索引';
$string['searchreindexindex'] = '重新建立所有网站内容的索引';
$string['searchresults'] = '搜索结果';
$string['searchsetupinfo'] = '搜索设置';
$string['searchteacherroles'] = '教师角色';
$string['searchteacherroles_desc'] = '选择所有使角色在搜索结果中排名更高的用户的角色。';
$string['searchtopresults'] = '最高成绩';
$string['searchupdateindex'] = '更新被索引的内容';
$string['sectionerror'] = '小节错误！';
$string['secureforms'] = '使用额外的表单安全性';
$string['security'] = '安全';
$string['selectsearchengine'] = '选择搜索引擎';
$string['server'] = '服务器';
$string['serverchecks'] = '检查服务器';
$string['serverlimit'] = '服务器限制';
$string['servicespage'] = '服务和支持链接';
$string['sessionautostartwarning'] = '<p>检测到严重的配置错误。请通知服务器管理员。</p><p>为了Moodle的正确运作，需要管理员修改PHP设置。</p><p><code>session.auto_start</code>必须被设为<code>off</code>。</p><p>修改服务器上的<code>php.ini</code>、 Apache/IIS<br />配置或<code>.htaccess</code>文件可以设定它。</p>';
$string['sessioncookie'] = 'Cookie后缀';
$string['sessioncookiedomain'] = 'Cookie 域名';
$string['sessioncookiepath'] = 'Cookie 路径';
$string['sessionhandling'] = '会话处理';
$string['sessiontimeout'] = '超时';
$string['sessiontimeoutwarning'] = '超时警告';
$string['settingdependenton'] = '根据 <strong>{$a}</strong>的值，可以隐藏此设置';
$string['settingfileuploads'] = '很多功能都需要使用文件上传功能，请在PHP配置中启用这个功能。';
$string['settingmaxinputvars'] = '建议PHP设置max_input_vars至少为5000。';
$string['settingmaxinputvarsrequired'] = 'PHP设置最大输入变量必须至少为5000。';
$string['settingmemorylimit'] = '内存不够用，请在PHP设置中设定更高的内存限制。';
$string['settingsafemode'] = 'Moodle和安全模式不完全兼容。请让服务器管理员关闭安全模式。在安全模式下运行Moodle不会获得支持。如果您坚持这么做，那么敬请期待各种问题。';
$string['setupsearchengine'] = '设置搜索引擎';
$string['showcommentscount'] = '显示评论数';
$string['showdetails'] = '显示细节';
$string['showuseridentity'] = '显示用户私人标识';
$string['showuseridentity_desc'] = '在选择或搜索用户时，以及在显示用户列表时，除了全名之外，还可以显示这些字段。这些字段只显示给具有moodle/site:viewuseridentity功能的用户；默认情况下是教师和管理人员。（如果您选择一个或两个机构强制要求的字段，则此选项最有意义。）标有*的字段是自定义用户资料字段。你可以选择这些字段，但目前有一些屏幕上不会出现这些字段。';
$string['simplexmlrequired'] = 'PHP的SimpleXML扩展现在是运行Moodle必须的组件。';
$string['sitemailcharset'] = '字符集';
$string['sitemaintenance'] = '本站正在维护中，目前不能访问。';
$string['sitemaintenancemode'] = '维护模式';
$string['sitemaintenanceoff'] = '维护模式已关闭，网站已经重新正常运行';
$string['sitemaintenanceon'] = '您的网站正处于维护模式(只有管理员可以登录或使用)。';
$string['sitemaintenanceoncli'] = '你的站点当前处理CLI维护模式，不允许WEB访问';
$string['sitemaintenancetitle'] = '{$a}维修中';
$string['sitemaintenancewarning'] = '您的网站目前处于维护模式(只有管理员可以登录)。要让网站回复到正常模式，请<a href="maintenance.php">关闭维护模式</a>。';
$string['sitemaintenancewarning2'] = '您的网站目前处于维护模式（仅管理员可以登录）。要回复到正常模式，请<a href="{$a}">关闭维护模式</a>。';
$string['sitemenubar'] = '网站导航';
$string['sitenameintitle'] = '在页面标题中包含站点名称';
$string['sitenameintitle_help'] = '此设置将在页面标题的末尾附加站点名称。鼓励在页面标题中包含站点名称，因为它将允许用户快速识别他们当前所在的页面，从而提高站点的可访问性。';
$string['sitepolicies'] = '网站安全设置';
$string['sitepolicy'] = '网站协议URL';
$string['sitepolicy_help'] = '所有注册用户在访问网站之前必须查看并同意的网站规则的URL。请注意，只有当网站规则处理程序设置为默认（核心）时，此设置才会生效。';
$string['sitepolicyguest'] = '给访客的网站策略链接';
$string['sitepolicyguest_help'] = '所有访客在访问网站之前必须查看并同意的网站规则的URL。请注意，只有当网站规则处理程序设置为默认（core）时，此设置才会生效。';
$string['sitepolicyhandler'] = '网站政策处理器';
$string['sitepolicyhandler_desc'] = '这决定了如何管理策略和用户协议。默认（核心）处理程序可启用网站策略URL及针对访客的网站策略URL。策略处理程序可以设置站点，隐私和其他策略。它还可以查看用户协议，并在必要时代表未成年人协议。';
$string['sitepolicyhandlercore'] = '默认（核心）';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = '在页面顶部显示一个部分，您可以在其中添加自定义内容。';
$string['sixtyfourbitsrequired'] = '已检测到您的网站未使用 64 位 PHP 版本。在安装此 Moodle 版本之前，您需要升级您的系统（操作系统、PHP 等）。';
$string['sixtyfourbitswarning'] = '已检测到您的网站未使用 64 位 PHP 版本。建议您升级您的网站以确保将来的兼容性。';
$string['slasharguments'] = '使用斜线参数';
$string['slashargumentswarning'] = '建议允许使用带斜线参数。将来会需要。详情请查看文档<a href="https://docs.moodle.org/en/admin/environment/slasharguments">使用带斜线参数</a>。';
$string['smallscreensonly'] = '仅限小屏幕';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP认证类型';
$string['smtpdetail'] = '邮件发送的简单邮件传送协议(SMTP)设置';
$string['smtphosts'] = 'SMTP主机';
$string['smtpmaxbulk'] = 'SMTP会话限制';
$string['smtppass'] = 'SMTP密码';
$string['smtpsecure'] = 'SMTP 安全';
$string['smtpuser'] = 'SMTP用户名';
$string['soaprecommended'] = '网络服务和某些插件需要安装可选的 SOAP 扩展。';
$string['sort_fullname'] = '课程全称';
$string['sort_idnumber'] = '课程ID';
$string['sort_shortname'] = '课程简称';
$string['sort_sortorder'] = '排序';
$string['spellengine'] = '拼写检查引擎';
$string['spelllanguagelist'] = '拼写检查语言列表';
$string['splrequired'] = 'PHP的SPL扩展现在是运行Moodle的必备条件。';
$string['stats'] = '统计';
$string['statsfirstrun'] = '最长的处理间隔';
$string['statsmaxruntime'] = '最长运行时间';
$string['statsmoodleorg'] = '统计数据';
$string['statsruntimedays'] = '最多处理多少天';
$string['statsruntimestart'] = '运行在';
$string['statsuserthreshold'] = '用户限制';
$string['stickyblocks'] = '粘性版块';
$string['stickyblockscourseview'] = '课程页';
$string['stickyblocksduplicatenotice'] = '如果您增加到这的版块已经存在于单独的页面中时，它将会被复制。<br /> 复制的版块能够被编辑除了一些小的版块。';
$string['stickyblocksmymoodle'] = '我的Moodle';
$string['stickyblockspagetype'] = '要配置的页类型';
$string['storedprogressbarcleanuptask'] = '存储的进度条清理任务';
$string['strictformsrequired'] = '严格校验必填字段';
$string['stripalltitletags'] = '删除所有活动名中的HTML标签';
$string['supportandservices'] = '支持和服务';
$string['supportavailability'] = '支持可用性';
$string['supportcontact'] = '技术支持';
$string['supportemail'] = '支持email';
$string['supportemailsubject'] = '站点支持请求-{$a}';
$string['supportname'] = '技术支持';
$string['supportpage'] = '支持链接';
$string['suspenduser'] = '停用用户账号';
$string['swaggerui'] = 'Moodle REST API UI （SwaggerUI）';
$string['switchlang'] = '切换语言目录';
$string['systempaths'] = '系统路径';
$string['tablenosave'] = '在上面表格中所做的修改会被自动保存。';
$string['tablesnosave'] = '在上面表格中所做的修改会被自动保存。';
$string['tabselectedtofront'] = '在有tab的表格中，是否将已选择的标签置于顶层。';
$string['tabselectedtofronttext'] = '把被选择的tab置于顶层';
$string['task_adhoc_concurrency_limit'] = '临时任务并发量限制';
$string['task_adhoc_concurrency_limit_desc'] = '允许同时运行的临时任务运行程序的数量。如果限制很高，则当存在大量临时任务时，计划任务可能无法定期运行。设置为0将完全禁用临时任务的处理。';
$string['task_adhoc_failed_retention'] = '失败的临时任务保留期';
$string['task_adhoc_failed_retention_desc'] = '一旦达到重试限制，失败的临时任务应保留在队列中';
$string['task_adhoc_max_runtime'] = '临时任务运行周期';
$string['task_adhoc_max_runtime_desc'] = '临时任务运行程序在释放之前的时间。建议使用较低的持续时间，因为排队的临时任务数量没有限制。如果此数字太高，并且您有一个较大的临时任务队列，则可能无法定期运行计划任务。';
$string['task_dbreads'] = '数据库读取';
$string['task_dbstats'] = '数据库';
$string['task_dbwrites'] = '数据库写入';
$string['task_duration'] = '持续时间';
$string['task_endtime'] = '结束时间';
$string['task_logmode'] = '当记录到日志时';
$string['task_logmode_all'] = '记录所有作业日志';
$string['task_logmode_desc'] = '你可以选择何时进行任务日志记录。默认情况下，始终捕获日志。你可以完全禁用日志记录，或更改为仅记录失败的任务。';
$string['task_logmode_failonly'] = '仅记录失败作业日志';
$string['task_logmode_none'] = '不记录任何日志';
$string['task_logoutput'] = '任务输出';
$string['task_logretainruns'] = '保留运行';
$string['task_logretainruns_desc'] = '要保留的每个任务的运行次数。此设置与“保留期”设置交互：以先达到者为准。';
$string['task_logretention'] = '保留期';
$string['task_logretention_desc'] = '应该保留日志的最大周期。此设置与“保留运行”设置交互：以先达到的为准';
$string['task_logtostdout'] = '显示日志输出';
$string['task_logtostdout_desc'] = '当作业正在运行并且捕获输出时，捕获的输出是否也应显示为任务运行。';
$string['task_result'] = '结果';
$string['task_result:failed'] = '失败';
$string['task_scheduled_concurrency_limit'] = '计划任务并发限制';
$string['task_scheduled_concurrency_limit_desc'] = '允许同时运行的计划任务运行程序数。如果限制很高，则服务器可能会遇到影响性能的高负载。设置为0将完全禁用对计划任务的处理。';
$string['task_scheduled_max_runtime'] = '计划任务运行器生存期';
$string['task_scheduled_max_runtime_desc'] = '计划任务运行器在释放之前的时间。';
$string['task_starttime'] = '开始时间';
$string['task_stats:dbreads'] = '{$a}读取';
$string['task_stats:dbwrites'] = '{$a}写入';
$string['task_status'] = '任务状态';
$string['task_status_desc'] = '任务"{$a->name}"的状态是{$a->status}。有关详细信息，请参见<a href="{$a->gotourl}">计划任务</a>中的{$a->class}{$a->extradescription}。';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = '日程';
$string['taskadmintitle'] = '任务';
$string['taskanalyticscleanup'] = '分析清理';
$string['taskautomatedbackup'] = '自动备份';
$string['taskautomatedbackup_report'] = '自动备份报告';
$string['taskbackupcleanup'] = '清理备份表、日志和文件';
$string['taskbadgesadhoc'] = '奖章';
$string['taskbadgescron'] = '添加徽章临时任务';
$string['taskbadgesmessagecron'] = '后台处理徽章通知发送';
$string['taskblogcron'] = '同步外部博客';
$string['taskcachecleanup'] = '删除过期缓存';
$string['taskcachecron'] = '后台处理缓存';
$string['taskcalendarcron'] = '发送日历通知';
$string['taskcheckforupdates'] = '检查更新';
$string['taskcompletiondaily'] = '完成标示为已开始';
$string['taskcompletionregular'] = '计算正常完成的数据';
$string['taskcontextcleanup'] = '清理上下文';
$string['taskcreatecontexts'] = '创建丢失的文本';
$string['taskdeleteincompleteusers'] = '删除不完整用户';
$string['taskdeleteunconfirmedusers'] = '删除末确认用户';
$string['taskeventscron'] = '对事件的背景处理';
$string['taskfiletrashcleanup'] = '清除垃圾箱中的文件';
$string['taskglobalsearchindex'] = '全局搜索索引';
$string['taskglobalsearchoptimize'] = '全局搜索索引优化';
$string['taskgradecron'] = '对成绩单的背景处理';
$string['taskgradehistorycleanup'] = '后台处理等级历史表清理';
$string['taskh5pcleanup'] = '未使用的H5P文件清理';
$string['tasklegacycron'] = '对插件进行传统的计划任务处理';
$string['tasklockcleanuptask'] = '清理临时任务元数据';
$string['tasklogcleanup'] = '清理任务日志';
$string['tasklogging'] = '任务日志配置';
$string['tasklogs'] = '任务日志';
$string['taskmessagingcleanup'] = '消息的背景处理';
$string['taskpasswordresetcleanup'] = '清零密码重置尝试记录';
$string['taskplagiarismcron'] = '抄袭插件的后台处理';
$string['taskportfoliocron'] = '后台处理组合插件';
$string['taskprocessing'] = '任务处理';
$string['taskquestioncron'] = '用于清理问题预览的后台处理';
$string['taskquestionstatscleanupcron'] = '清理问题统计信息缓存的后台处理';
$string['taskrefreshsystemtokens'] = '为服务帐号刷新 OAuth 凭证';
$string['taskregistrationcron'] = '网站注册';
$string['tasksendfailedloginnotifications'] = '发送登陆失败通知';
$string['tasksendnewuserpasswords'] = '发送新的用户密码';
$string['tasksessioncleanup'] = '清除旧的会话';
$string['taskstatscron'] = '后台统计进程';
$string['tasktagcron'] = '后台分类进程';
$string['tasktempfilecleanup'] = '删除临时文件';
$string['tasktype'] = '类型';
$string['taskupdategeoip2file'] = '更新 GeoIP 文件';
$string['tempdatafoldercleanup'] = '清除临时数据文件早于';
$string['templates'] = '模板';
$string['testoutgoingmailconf'] = '测试邮件发送的配置';
$string['testoutgoingmailconf_errorcommunications'] = '您的站点无法与邮件服务器通信。请检查您的发送邮件配置。';
$string['testoutgoingmailconf_fromemail'] = '来自用户名或电子邮件地址';
$string['testoutgoingmailconf_fromemail_help'] = '此字段模拟从该用户发送消息，但实际发送的电子邮件中使用的from标头将取决于其他设置，如allowedemaildomains（允许的电子邮件域名）';
$string['testoutgoingmailconf_fromemail_invalid'] = '用户名或电子邮件无效。必须是有效的电子邮件格式或Moodle中的现有用户名。';
$string['testoutgoingmailconf_message'] = '这是一条测试消息，用于确认您已成功配置站点的外发邮件。 发送：{$a}';
$string['testoutgoingmailconf_sendtest'] = '发送测试消息';
$string['testoutgoingmailconf_sentmail'] = '这个站点已经成功发送一个测试消息到邮件服务器<br />从: {$a->fromemail}<br />到: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}：测试消息。 {$a->additional} 发送：{$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = '附加主题';
$string['testoutgoingmailconf_toemail'] = '邮件收件地址';
$string['testoutgoingmaildetail'] = '提示: 在测试之前，请保存您的配置.<br />{$a}';
$string['testsiteupgradewarning'] = '你当前正在使用 {$a} 测试站点，你可以使用命令行工具进行升级。';
$string['themedefinedinconfigphp'] = '由于主题在 config.php 中设置为 {$a}，因此无法更改。';
$string['themedesignermode'] = '主题设计师模式';
$string['themedesignermodewarning'] = '主题设计师模式已启用。在实际使用的网站上它不应该被启用，因为它会明显降低网站的性能。';
$string['themeeditsettingsname'] = '编辑主题设置“{$a}”';
$string['themelist'] = '主题列表';
$string['themeresetcaches'] = '清除主题缓存';
$string['themeselect'] = '更改主题';
$string['themeselector'] = '主题';
$string['themesettingsadvanced'] = '高级主题设置';
$string['themesettingscustom'] = '自定义主题设置';
$string['themesettingsname'] = '主题设置“{$a}”';
$string['themeusagereportname'] = '主题使用情况报告“{$a}”';
$string['therewereerrors'] = '在您的数据中有错误';
$string['thirdpartylibrary'] = '开发库名称';
$string['thirdpartylibrarylocation'] = '位置';
$string['thirdpartylibs'] = '第三方库';
$string['timezone'] = '默认时区';
$string['timezoneforced'] = '站点管理员规定必须这样做';
$string['timezoneinvalid'] = '无效时区 "{$a}"';
$string['timezoneisforcedto'] = '强制所有用户使用';
$string['timezonenotforced'] = '用户可以选择自己的时区';
$string['timezonephpdefault'] = '默认PHP时区 ({$a})';
$string['timezoneserver'] = '服务器时区 ({$a})';
$string['tlswarning'] = '没有检测到可以支持 TLSv1.2 的 PHP/cURL 扩展。有些服务可能无法运行，强烈建议您升级你的TSL库。';
$string['tokenduration'] = '用户创建的令牌有效期';
$string['tokenduration_desc'] = '用户创建的网页服务令牌（如通过手机应用）的有效期限。';
$string['tokenizerrecommended'] = '为了改进Moodle网络功能，建议安装PHP Tokenizer扩展库。';
$string['tools'] = '管理工具';
$string['toolsmanage'] = '管理管理工具';
$string['unattendedoperation'] = '无人值守操作';
$string['unbookmarkthispage'] = '取消收藏此页';
$string['unicoderequired'] = '所有数据必须以 Unicode 格式 （UTF-8） 存储。对于新安装，数据库必须将 UTF-8 作为默认字符集。如果要升级，则需要遵循 UTF-8 迁移过程。';
$string['uninstallplugin'] = '卸载';
$string['unlockaccount'] = '帐号解锁';
$string['unoconvwarning'] = '本系统不支持你所安装的 unoconv 版本，Moodle的作业评分功能需要用到0.7或以上的版本。';
$string['unsupported'] = '不支持';
$string['unsupporteddbfileformat'] = '您的数据库在使用 Antelope 作为文件格式。在MySQL和MariaDB实现完全 UTF-8 支持需要使用  Barracuda 文件格式。请切换至 Barracuda 文件格式。详见以下文档  <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a>';
$string['unsupporteddbfilepertable'] = '为了能完整支持 UTF-8 ，MYSQL 和 MariaDB 两者都需要您把您的 MySQL 配置 \\\'innodb_file_per_table\\\' 为 \\\'ON\\\'。请参考文档以便了解细节。';
$string['unsupporteddblargeprefix'] = '为了能完整支持 UTF-8 ，MYSQL 和 MariaDB 两者都需要您把您的 MySQL 配置 \\\'innodb_file_per_table\\\' 为 \\\'ON\\\'。请参考文档以便了解细节。';
$string['unsupporteddbstorageengine'] = '正在使用的数据库存储引擎已不再被支持';
$string['unsupporteddbtablerowformat'] = '你的数据库含有使用Antelope文件格式的表。建议将这些表转换成Barracuda格式。查看文档 <a href="https://docs.moodle.org/en/cli">命令行管理</a> 获得转换InnoDB表到Barracuda的工具详情。';
$string['unsupportedphpversion7'] = '不支持 PHP 7 及更高版本';
$string['unsupportedphpversion71'] = '不支持PHP 7.1及更高版本';
$string['unsupportedphpversion72'] = '不支持PHP 7.2及更高版本';
$string['unsupportedphpversion73'] = '不支持PHP 7.3 及更高版本';
$string['unsupportedphpversion74'] = '不支持 PHP 版本 7.4 及更高版本';
$string['unsupportedphpversion80'] = '不支持PHP8.0及更高版本';
$string['unsupportedphpversion81'] = '不支持 PHP 8.1 及更高版本。';
$string['unsupportedphpversion82'] = '不支持 PHP 8.2 及更高版本。';
$string['unsupportedphpversion83'] = '不支持 PHP 8.3 及更高版本。';
$string['unsupportedphpversion84'] = '不支持 PHP 版本 8.4 及更高版本。';
$string['unsuspenduser'] = '激活用户账号';
$string['updateaccounts'] = '更新已有帐户';
$string['updateautocheck'] = '自动检查可用更新';
$string['updateautocheck_desc'] = '如果启用，你的网站会自动检查 Moodle 代码和所有附加插件的可用更新。如果有新的更新可用，会发送给网站管理员一个通知。';
$string['updateavailable'] = '有一个新版本的 Moodle 可用！';
$string['updateavailable_moreinfo'] = '更多信息...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '版本 {$a}';
$string['updateavailabledetailslink'] = '去 {$a->url} 查看更多细节';
$string['updateavailableforplugin'] = '您的一些插件有新版本可用！';
$string['updateavailableinstall'] = '安装这一更新';
$string['updateavailableinstallall'] = '安装用的更新({$a})';
$string['updateavailableinstallallhead'] = '安装可用的更新';
$string['updateavailablenot'] = '您的 Moodle 代码是最新的！';
$string['updateavailablerecommendation'] = '强烈建议更新你的站点到最新版本，更新最近的安全和漏洞补丁。';
$string['updatecomponent'] = '更新组件';
$string['updateminmaturity'] = '代码成熟度需求';
$string['updateminmaturity_desc'] = '只有当可用代码至少达到选定的成熟度时，才通知有可用更新。不论此设置如何，没有声明代码成熟度的插件总会被报告更新。';
$string['updatenotificationfooter'] = '您的Moodle站点{$a->siteurl} 配置为自动检查可用更新。您以站点管理员的身份收到此消息。您可以在站点管理/服务器/更新通知中禁止自动检查可用的更新，或通过您的首选项页面自定义此消息的发送。';
$string['updatenotifications'] = '更新通知';
$string['updatenotificationsubject'] = '有 Moodle 的新更新 ({$a->siteurl})';
$string['updatenotifybuilds'] = '有新更新时通知';
$string['updatenotifybuilds_desc'] = '如果启用，当当前版本有新更新时，会报告 Moodle 代码有更新。更新是某个 Moodle 版本的持续改进。它们通常是每周发布一次。如果禁用，只有当更高版本的 Moodle 发布时才会报告有可用的更新。插件更新的检查不受此设置影响。';
$string['upgradeerror'] = '将{$a->plugin}升级到版本{$a->version}出现未知错误。无法继续。';
$string['upgradeforumread'] = '在Moodle 1.5中增加了一项新的功能，它可以跟踪讨论区帖子是否已经阅读。<br />为了使用这个功能，您需要<a href="{$a}">升级您的数据库表</a>。';
$string['upgradeforumreadinfo'] = '在Moodle 1.5中增加了一项新的功能，它可以跟踪论坛帖子是否已经阅读。为了使用这个功能，您需要升级您的表格为已经存在的帖子添加这一信息。如果您的站点很大，这会花费很长的时间(数小时)，并且给数据库服务器带来很大负担，因此最好在夜深人静时再做这个工作。当然，在您的站点升级时，它还是可以继续工作的，用户不会受到任何影响。一旦您开始了这个工作，就必须让它结束(一直开启浏览器)。当然，如果您中途关闭了浏览器：不用担心，重新开始就可以了。<br /><br />您现在要开始升级么？';
$string['upgradekeyreq'] = '需要升级密码';
$string['upgradekeyset'] = '升级密码(若不要设定请保持空白)';
$string['upgradelogs'] = '要获得完整功能，您的旧日志必须升级。<a href="{$a}">更多信息</a>';
$string['upgradelogsinfo'] = '保存日志的方式最近有些变动。为了能查看每个活动的旧日志，它们必须被升级。这个过程所花费的时间取决于您的网站（可能长达几小时），并且会给大规模网站的数据库带来很大的负荷。一旦您开始了这个工作，就必须让它结束(一直开启浏览器)。不用担心——日志升级过程中，其他人仍然可以正常地使用网站。<br /><br />打算现在升级日志吗?';
$string['upgradepluginsfirst'] = '建议首先安装好所有可用的更新。';
$string['upgradepluginsinfo'] = '更新插件';
$string['upgradepluginsinfo_help'] = '您的某些插件有可用的更新。你应该在升级数据库前先全部更新好插件。如果您的网站不支持自动更新，则您必须手动下载并在服务器上安装它。';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = '新设置';
$string['upgradesettingsintro'] = '下面显示的设置是在您上次升级Moodle时添加的。对默认值进行必要的修改，然后点击本页底部的 "保存修改 "按钮。';
$string['upgradestalefiles'] = '检测到混合的 Moodle 版本，升级不能继续';
$string['upgradestalefilesinfo'] = 'Moodle 更新过程已暂停，因为在 Moodle 目录内检测到来自至少两个 Moodle 主版本的 PHP 脚本。

这将可能引发重大问题。如果要继续，您必须保证 Moodle 目录只包含一个版本的 Moodle 文件。

建议您采用如下方法清理您的 Moodle 目录：

* 重命名当前的 Moodle 目录为“moodle_old”
* 创建一个只包含来自标准 Moodle 下载软件包、Moodle CVS 或 GIT 仓库的文件的文件夹
* 从“moodle_old”目录移动 config.php 文件和所有非标准插件到新 Moodle 目录

当您有了纯净的 Moodle 目录，刷新页面继续 Moodle 更新进程。

这个警告一般是由解压标准 Moodle 软件包覆盖到旧版本的 Moodle 引发的。虽然这样做小的升级是可以的，但是一定不要这样升级主版本。

这个警告也可能由使用 GIT 仓库时的一次不完整的校验或更新操作引发的。如果是这样，您可能只需要等待操作完成，或者运行适当的清理命令并且重新执行原操作。

您可以在 <a href="{$a}">{$a}</a> 的升级文档中找到更多信息';
$string['upgradestart'] = '现在升级Moodle数据库';
$string['upgradesure'] = '<p>您的Moodle文件已经被修改了，您正在准备自动升级您的服务器到如下版本:</p>
<p><strong>{$a}</strong></p>
<p>您一旦执行了这个操作就不能再返回到先前的版本了。请注意，此过程会消耗一定的时间。</p>
<p>您确定要将此服务器升级到这个版本么？</p>';
$string['upgradetimedout'] = '升级过程超时，请重新升级。';
$string['upgradingdata'] = '升级数据';
$string['upgradinglogs'] = '升级日志';
$string['upgradingversion'] = '正在升级到新版本';
$string['upwards'] = '以上';
$string['useblogassociations'] = '启用关联';
$string['user'] = '用户';
$string['userbulk'] = '批量处理';
$string['userbulkdownload'] = '导出用户如';
$string['userdefaultpreferences'] = '用户默认偏好';
$string['userfeedbackafterupgrade'] = '每次重大升级后';
$string['userfeedbackencouragement'] = '<p>Moodle 包含一项功能，使用户可以通过 Moodle 总部托管的外部调查站点提供有关 Moodle 软件的反馈。不会将用户身份信息转发到调查站点。</p>
<p>Moodle HQ 努力公开透明地介绍其数据收集方法。因此，我们希望确保您了解并控制此功能。</p>
<p>用户的反馈有助于 Moodle HQ 改进 Moodle 软件。要启用此功能，请转到 <a href=“{$a}”>反馈设置</a>。</p>';
$string['userfeedbacknextreminder'] = '下次反馈提醒';
$string['userfeedbacknextreminder_desc'] = '我们应该在什么时候再次要求用户提供反馈？';
$string['userfeedbackperiodically'] = '定期地';
$string['userfeedbackremindafter'] = '之后显示提醒';
$string['userfeedbackremindafter_desc'] = '在给定的天数后再次提醒用户给予反馈。';
$string['userfiltersdefault'] = '默认的用户过滤';
$string['userfiltersdefault_desc'] = '选择要在“批量用户操作”页面上显示的过滤条件。要选择多个过滤器，请按住 Ctrl 键。未选择的仍可通过“显示更多”链接使用。';
$string['userimagesdisabled'] = '用户头像已禁用';
$string['userlist'] = '浏览用户';
$string['usermanagement'] = '用户管理';
$string['userpolicies'] = '用户策略';
$string['userpreference'] = '用户偏好设置';
$string['userquota'] = '私有文件空间';
$string['userquota_desc'] = '每位用户可以存储私有文件的最大数量';
$string['users'] = '用户';
$string['usesitenameforsitepages'] = '用网站名表示网站页面';
$string['usetags'] = '启用标签功能';
$string['validateemptylineerror'] = '空行无效';
$string['validateerror'] = '此值无效';
$string['validateerrorlist'] = '这些数据无效：{$a}';
$string['validateiperror'] = '这些IP地址无效：{$a}';
$string['verifychangedemail'] = '修改email时也限制域名';
$string['warningcurrentsetting'] = '当前值：{$a} 无效';
$string['warningiconvbuggy'] = '您的 iconv 库不支持 //IGNORE 标识。您需要安装 mbstring 扩展，用来清理包含无效 UTF-8 字符的字符串。';
$string['webproxy'] = 'Web 代理';
$string['webproxyinfo'] = '如果你的Moodle服务器不能直接访问互联网，请填写以下选项。下载环境数据、语言包、RSS订阅、时区等都需要互联网接入。<br /><em>强烈推荐 PHP cURL 扩展。</em>';
$string['xmlrpcwebserviceenabled'] = '检测到您的站点上启用了XML-RPC Web服务协议。此功能依赖于PHP不再维护的PHP XML-RPC扩展。';
$string['yuicomboloading'] = 'YUI合并加载';
$string['ziprequired'] = 'Moodle 需要 PHP Zip 扩展，info-ZIP 命令行程序和 PclZip 库已经不再使用了。';
