<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'zh_cn', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'API 终结点';
$string['action:generate_image:model'] = 'AI 模型';
$string['action:generate_image:model_desc'] = '用于从用户提供文本生成图像的模型。';
$string['action:generate_image:model_help'] = '此模型用于更具用于提示生成图像。';
$string['action:generate_text:endpoint'] = 'API 终结点';
$string['action:generate_text:model'] = 'AI 模型';
$string['action:generate_text:model_desc'] = '用于生成文本回复的模型。';
$string['action:generate_text:model_help'] = '此模型用于生成文本响应。';
$string['action:generate_text:systeminstruction'] = '系统指令';
$string['action:generate_text:systeminstruction_desc'] = '此指令与用户的提示一起发送到 AI 模型。除非绝对需要，否则不建议编辑此指令。';
$string['action:generate_text:systeminstruction_help'] = '此指令会与用户的提示词一并发送至AI模型。除非必要，不建议编辑此指令。';
$string['action:summarise_text:endpoint'] = 'API 终结点';
$string['action:summarise_text:model'] = 'AI 模型';
$string['action:summarise_text:model_desc'] = '用于总结所提供文本的模型。';
$string['action:summarise_text:model_help'] = '此模型用于总结提供的文本。';
$string['action:summarise_text:systeminstruction'] = '系统指令';
$string['action:summarise_text:systeminstruction_desc'] = '此指令与用户的提示一起发送到 AI 模型。除非绝对需要，否则不建议编辑此指令。';
$string['action:summarise_text:systeminstruction_help'] = '此指令会与用户的提示词一并发送至AI模型。除非必要，不建议编辑此指令。';
$string['apikey'] = 'OpenAI API 密钥';
$string['apikey_desc'] = '从 <a href=“https://platform.openai.com/account/api-keys”>OpenAI Platform API keys 获取密钥</a>。';
$string['apikey_help'] = '从 <a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI API keys</a>获得一个键值。';
$string['enableglobalratelimit'] = '设置站点范围的速率限制';
$string['enableglobalratelimit_desc'] = '限制 OpenAI API 提供商每小时可以在整个站点上接收的请求数。';
$string['enableuserratelimit'] = '设置用户速率限制';
$string['enableuserratelimit_desc'] = '限制每个用户每小时可以向 OpenAI API 发出的请求数。';
$string['globalratelimit'] = '站点范围的最大请求数';
$string['globalratelimit_desc'] = '每小时允许的站点范围请求数。';
$string['orgid'] = 'OpenAI 组织 ID';
$string['orgid_desc'] = '从您的 <a href=“https://platform.openai.com/account/org-settings”>OpenAI Platform 账户获取 OpenAI 组织 ID</a>。';
$string['orgid_help'] = '从<a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI 账户</a>获得你的OpenAI组织ID。';
$string['pluginname'] = 'OpenAI API 提供者';
$string['privacy:metadata'] = 'OpenAI API  provider 插件不存储任何个人数据。';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = '此信息将发送到 OpenAI API 以生成响应。您的 OpenAI 帐户设置可能会更改 OpenAI 存储和保留此数据的方式。此插件不会明确将任何用户数据发送到 OpenAI 或存储在 Moodle LMS 中。';
$string['privacy:metadata:aiprovider_openai:model'] = '用于生成响应的模型';
$string['privacy:metadata:aiprovider_openai:numberimages'] = '生成图像时：响应中使用的图像数。';
$string['privacy:metadata:aiprovider_openai:prompttext'] = '用户输入了用于生成响应的文本提示。';
$string['privacy:metadata:aiprovider_openai:responseformat'] = '生成图像的格式';
$string['userratelimit'] = '每个用户的最大请求数';
$string['userratelimit_desc'] = '每个用户每小时允许的请求数';
