<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'via', language 'af', version '5.0'.
 *
 * @package     via
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Qualitedebase'] = 'Swak kwaliteit';
$string['Qualitestandard'] = 'Standaard kwaliteit';
$string['Qualitesuperieure'] = 'Goeie kwaliteit';
$string['STATUS_INVALID'] = 'Die konneksie was onmoontlik, die status is ongeldig.';
$string['absent'] = 'Afwesig';
$string['accessactivity'] = 'Verkry toegang tot jou aktiwiteit:';
$string['activity_deleted'] = 'Die Via-aktiwiteit is direk in die Via-omgewing deur \'n gebruiker uitgewis. Toegang daartoe is dus onmoontlik. Ons raai aan dat jy hierdie aktiwiteit in Moodle uitwis en \'n nuwe skep.';
$string['activitydeletion'] = 'Beperk aktiwiteituitwissing';
$string['activitydeletiondesc'] = 'Indien gemerk, sal aktiwiteite in Moodle uitgewis word, maar nie in Via nie.';
$string['activitydone'] = 'Hierdie aktiwiteit is voltooi.';
$string['activitytemplatebutton'] = 'Sinchroniseer aktiwiteittemplaatwaardes';
$string['activitytemplatedesc'] = 'Die verstek waardes (opnamemodus, wagkamer, multimediaprofiel, ens.) wat op die skepping van \'n nuwe virtuele klas toegepas word, is die waardes wat by verstek in die Via-portaal gestel is. Jy moet aan die portaal koppel en na die Aktiwiteittemplaatafdeling op die linkerkant gaan om die verstek waardes te valideer.';
$string['activitytemplateheader'] = 'Aktiwiteittemplaat';
$string['activitytitle'] = 'Aktiwiteittitel';
$string['activitywaserased'] = 'Kon nie hierdie aktiwiteit op SVI-bediener vind nie. Dit kom voor asof dit uitgevee is.';
$string['add'] = 'Voeg by';
$string['adminid_nosuccess'] = 'Die verskafde Moodle-sleutel is ongeldig.';
$string['adminid_success'] = 'Die Moodle-sleutel is geldig';
$string['adminid_toolow'] = 'Die gebruiker se regte laat nie die skep van aktiwiteite toe nie. Kontak asseblief die administrateur om die regte te vermeerder.';
$string['adminnotrenrolled'] = 'As administrateur kan jy die aktiwiteit binnegaan, al is jy nie daarvoor ingeskryf nie.';
$string['and'] = 'en';
$string['animator'] = 'Animeerder';
$string['animators'] = 'Animeerders';
$string['apiconfig'] = 'API-konfigurasie - Stap 1';
$string['apiid'] = 'Via API-ID (ApiID)';
$string['apiidsetting'] = 'Via API unieke ID';
$string['apiurl'] = 'API se URL';
$string['apiurlsetting'] = 'API se basis-URL';
$string['attending'] = 'Ek sal bywoon';
$string['audiomodelabel'] = 'Oudiotipe vir die konferensie';
$string['audiorecord'] = 'Oudio (MP3)';
$string['audiorecordinfo'] = 'Slegs Oudio';
$string['automatic'] = 'Outomaties';
$string['automaticenrol'] = 'Outomatiese inskrywing';
$string['availabledate'] = 'Beskikbaar vanaf';
$string['awaitingauthorization'] = 'Wag op magtiging (handmatig)';
$string['backup'] = 'Sluit opname-inligting in kursusrugsteune in';
$string['backup_options'] = 'Aktiwiteitrugsteun- en dupliseringsopsies';
$string['backupdesc'] = 'Indien gemerk, sal opname-inligting van \'n aktiwiteit in die nuwe aktiwiteit ingesluit word, wat tydens die kursusrugsteun- en herstelproses geproduseer is. Dokumente word altyd in die proses ingesluit. Die insluit van gebruikerinligting is opsioneel.';
$string['basedon'] = 'Die teenwoordigheidstatus is op {$a} minute gebaseer.';
$string['by'] = 'deur';
$string['cancel'] = 'Kanselleer';
$string['cat_check'] = 'Voeg by';
$string['cat_default'] = 'Stel as verstek';
$string['cat_intro'] = 'Kies die Via-kategorieë wat jy in Moodle beskikbaar wil maak.';
$string['cat_name'] = 'Kategoriename';
$string['categoriesheader'] = 'Kategorieë';
$string['category'] = 'Kies \'n kategorie';
$string['cats_modified'] = 'Die kategorieë is suksesvol gewysig!';
$string['choosecategories'] = 'Konfigureer die kategorieë';
$string['choosehost'] = 'Om \'n nuwe gasheer te kies, voeg eenvoudig \'n nuwe gebruiker by om die bestaande gasheer te vervang. Daar kan slegs een gasheer wees.';
$string['cieid'] = 'Via-ID (CieID)';
$string['cieidsetting'] = 'Maatskappy-ID vir VIA';
$string['config'] = 'Konfigurasie';
$string['configassist'] = 'Opstelassistent';
$string['confirmation'] = 'Deelnemers se bevestigings';
$string['confirmationstatus'] = 'Bevestigingstatus';
$string['confirmdelete'] = 'Is jy seker jy wil hierdie opname permanent uitwis?';
$string['confirmed'] = 'Bywoning is bevestig';
$string['confirmneeded'] = 'Bevestiging van bywoning word vereis';
$string['connectsuccess'] = 'Konneksie aan die API was suksesvol';
$string['conntest'] = 'Konneksietoets';
$string['createdby'] = 'Verslag geskep deur:';
$string['creationdate'] = 'Verslag geskep op:';
$string['date'] = 'Aktiwiteitsdatum';
$string['delete'] = 'Wis uit';
$string['delete_activity'] = 'Wis hierdie aktiwiteit uit';
$string['deleteconfirm'] = 'Wil jy regtig hierdie aktiwiteit uitwis?';
$string['desactivatedMessage'] = 'Hierdie aktiwiteit en sy gepaardgaande rekords of dokumente is uitgewis en is nie meer beskikbaar nie. Verwyder asseblief hierdie aktiwiteit uit die kursus.';
$string['description'] = 'Beskrywing';
$string['df_button_manage'] = 'Bestuur die inhoud';
$string['df_header_download'] = 'Laai af';
$string['df_header_nbpages'] = 'Bladsye';
$string['df_header_size'] = 'Grootte';
$string['df_header_title'] = 'Titel';
$string['df_header_type'] = 'Tipe';
$string['df_nofiles'] = 'Geen inhoud om af te laai nie';
$string['df_type_0'] = 'Nie gekategoriseer';
$string['df_type_1'] = 'JPG-prent';
$string['df_type_10'] = 'AVI-video';
$string['df_type_11'] = 'MPG-video';
$string['df_type_12'] = 'WMV-video';
$string['df_type_13'] = 'MOV-video';
$string['df_type_14'] = 'MP3-oudio';
$string['df_type_15'] = 'WAV-oudio';
$string['df_type_16'] = 'WMA-oudio';
$string['df_type_17'] = 'OGG-oudio';
$string['df_type_18'] = 'Powerpoint-aanbieding';
$string['df_type_19'] = 'URL';
$string['df_type_2'] = 'BMP-prent';
$string['df_type_20'] = 'MP4-dokument';
$string['df_type_21'] = 'Word-dokument';
$string['df_type_22'] = 'Excel-dokument';
$string['df_type_23'] = 'OD-dokument';
$string['df_type_24'] = 'SXW-dokument';
$string['df_type_25'] = 'RTF-dokument';
$string['df_type_26'] = 'WPD-dokument';
$string['df_type_27'] = 'Teksdokument';
$string['df_type_28'] = 'ODS-dokument';
$string['df_type_29'] = 'SXC-dokument';
$string['df_type_3'] = 'PNG-prent';
$string['df_type_30'] = 'CSV-dokument';
$string['df_type_31'] = 'TSV-dokument';
$string['df_type_32'] = 'ODP-dokument';
$string['df_type_33'] = 'SXI-dokument';
$string['df_type_34'] = 'ODG-dokument';
$string['df_type_35'] = 'HTML-skakel';
$string['df_type_36'] = 'Powerpoint-aanbieding';
$string['df_type_37'] = 'Word-dokument';
$string['df_type_38'] = 'Powerpoint-aanbieding';
$string['df_type_39'] = 'Excel-dokument';
$string['df_type_4'] = 'GIF-prent';
$string['df_type_40'] = 'Powerpoint-aanbieding';
$string['df_type_41'] = 'HTM-skakel';
$string['df_type_42'] = 'Powerpoint-aanbieding';
$string['df_type_43'] = 'Witbord';
$string['df_type_44'] = 'Opname';
$string['df_type_45'] = 'M4V-video';
$string['df_type_46'] = 'M4A-oudio';
$string['df_type_47'] = 'MKV-video';
$string['df_type_48'] = 'GIF-volgorde';
$string['df_type_5'] = 'PICT-prent';
$string['df_type_6'] = 'PDF-dokument';
$string['df_type_7'] = 'Prent-TIFF';
$string['df_type_8'] = 'SWF-dokument';
$string['df_type_9'] = 'Flash-video';
$string['displayuserlist'] = 'Vertoon geassosieerde gebruikerslyste vir alles';
$string['displayuserlistdesc'] = 'Indien gemerk, sal alle gebruikers die ander gebruikers, wat met die aktiwiteit en hul bevestigingstatus geassosieer word, kan sien, indien geaktiveer.';
$string['donousewaitingroom'] = 'Moet nie gebruik nie (gedeaktiveer)';
$string['downloadablefiles'] = 'Aflaaibare inhoud';
$string['downloadplaybacks'] = 'Laai Opnames af';
$string['downloadplaybacksdesc'] = 'Indien gemerk, sal gebruikers met wysigingsrolle toegelaat word om Via-opnames af te laai. Voor jy hierdie opsie merk, kontak asseblief SVIesolutions om te bevestig dat jou bediener dit toelaat.';
$string['duplication'] = 'Sluit opname-inligting in aktiwiteitduplisering in';
$string['duplicationdesc'] = 'Indien gemerk, sal opname-inligting uit \'n aktiwiteit in die nuwe aktiwiteit, wat tydens die dupliseringsproses geproduseer is, ingesluit wees. Gebruikerinligting en -dokumente word altyd in hierdie proses ingesluit.';
$string['duration'] = 'Tydsduur (minute)';
$string['durationheader'] = 'Tydsduur';
$string['edit'] = 'Wysig';
$string['editrecord'] = 'Wysig opname';
$string['email_personnalised_options'] = 'Verpersoonlik jou Via-herinnering- en uitnodiging-e-posse';
$string['emailaccesslinkcolor'] = 'Toegangskakelkleur van e-pos';
$string['emailaccesslinkcolor_desc'] = 'Dit sal op die toegangskakel in jou Via-herinnering- en uitnodiging-e-posse toegepas word. Ons raai aan dat jy \'n ander kleur as die ander skakels gebruik, aangesien hierdie belangriker is.';
$string['emailheaderbgcolor'] = 'Agtergrondkleur van e-postitel';
$string['emailheaderbgcolor_desc'] = 'Dit sal op die agtergrond van die Via-herinnering- en uitnodiging-e-posse se titels en agter prente toegepas word.';
$string['emailheadercolor'] = 'Kleur van e-postitel';
$string['emailheadercolor_desc'] = 'Dit sal op die Via-herinnering- en uitnodiging-epostitels toegepas word; die naam van jou moodle.';
$string['emailheaderimage'] = 'E-poshofieprent';
$string['emailheaderimage_desc'] = '\'n Verstek prent is bygevoeg, wat jy te eniger tyd kan oorheers. Die verstek prent se mates is 750 x 98 beeldelemente, en die regterkant van die prent het dieselfde kleur as die "e-poshofieagtergrondkleur" hieronder. BELANGRIK: E-posse ondersteun nie deursigtigheid nie.';
$string['emaillinkcolor'] = 'Skakelkleur';
$string['emaillinkcolor_desc'] = 'Dit sal op die skakels in jou Via-herinnering- en uitnodiging-eposse toegepas word; ons raai aan dat jy dieselfde kleure as jou tema byvoeg.';
$string['emails_alert_address'] = 'E-posse om waarskuwings te stuur';
$string['emails_alert_addressdesc'] = 'E-posadresse vir oorloopwaarskuwings. Indien meer as een, gebruik \'n komma as skeier.';
$string['emailtextcolor'] = 'E-postekskleur';
$string['emailtextcolor_desc'] = 'Dit sal op Via-herinnering- en uitnodiging-e-posse se teks toegepas word, behalwe die skakels en titel.';
$string['enddate'] = 'Eindig op';
$string['enrolmentheader'] = 'Deelnemerinskrywings';
$string['enrolmenttype'] = 'Inskrywingstipe';
$string['enrolmenttype_help'] = 'Outomatiese inskrywing: alle gebruikers wat vir die kursus ingeskryf is, sal by die Via-aktiwiteit gevoeg word.
As \'n student ná die skep van die Via-aktiwiteit bygevoeg word, sal die student met die volgende Cron-sinchronisering bygevoeg word.
As die student die aktiwiteit binnegaan voordat die cron hom/haar ingeskryf het, sal die student bygevoeg word en in die besonderhedeblad
van die aktiwiteit vertoon word. Gebruikers met wysigingsregte in die moodle-kursus sal outomaties as animeerders gesinchroniseer word, maar die lys kan steeds gewysig word.
Handmatige Registrasie: Deelnemers moet uit die lys deelnemers bygevoeg word, deur die deelnemers uit die lys van
"Potensiële deelnemers" (regs) te kies en met die pyltjie by te voeg in &quot;Bestaande deelnemers&quot; (links).
Let wel: In beide invoermodusse word die gebruiker wat die aktiwiteit skep outomaties as gasheer bygevoeg,
maar kan steeds gewysig word. Dit is nie moontlik om meer as een gasheer te hê nie.';
$string['error:ACTIVITYID_EMPTY'] = 'AKTIWITEITID_LEEG - Die Aktiwiteit-ID se waarde is leeg.';
$string['error:ACTIVITYID_INVALID'] = 'AKTIWITEITID_ONGELDIG - Die waarde wat in die Aktiwiteit-ID oorgedra is, is ongeldig.';
$string['error:ACTIVITY_ACCESS_FAILED'] = 'AKTIWITEIT_TOEGANG_MISLUK - Wanneer die gebruiker nie met die aktiwiteit geassosieer word nie, of die aktiwiteit nie meer beskikbaar is nie.';
$string['error:ACTIVITY_DOES_NOT_EXIST'] = 'AKTIWITEIT_BESTAAN_NIE - Moet \'n geldige aktiwiteit voorstel.';
$string['error:ACTIVITY_EXCEED_MAX_USERS'] = 'Maks. aantal gebruikers is bereik';
$string['error:APIID_NOT_FOUND'] = 'APIID_NIE_GEVIND - API-ID bestaan nie. Verifieer asseblief jou verstellings. Sonder \'n geldige API-ID kan jy nie aktiwiteite skep nie!';
$string['error:APPLY_PERIODICITY_INVALID'] = 'PAS_PERIODISITEIT_TOE_ONGELDIG - Die waarde oorgedra moet 0 of 1 wees.';
$string['error:AUTH_FAILED_BAD_APIID'] = 'VALIDASIE_MISLUK_SLEGTE_APIID - Die API-ID is nie goedgekeur nie.';
$string['error:AUTH_FAILED_BAD_CIEID'] = 'VALIDASIE_MISLUK_SWAK_CIEID - Die CIE-ID is nie goedgekeur nie.';
$string['error:AUTH_FAILED_BAD_IP'] = 'VALIDASIE_MISLUK_SWAK_IP - Kontak SVIeSolutions om hierdie IP-adres by die toegelate IP-lys te voeg.';
$string['error:CANNOT_CHANGE_STATE'] = 'KAN_NIE_TOESTAND_VERANDER - Die aktiwiteit het van toestand verander.';
$string['error:CIEID_NOT_FOUND'] = 'CIEID_NIE_GEVIND - CIE-ID bestaan nie. Verifieer asseblief jou verstellings. Sonder \'n geldige CIE-ID kan jy nie aktiwiteite skep nie!';
$string['error:COMPANYNAME_TOO_LONG'] = 'MAATSKAPPYNAAM_TE_LANK - Die maatskappy se naam is langer as die maksimum van 50 karakters.';
$string['error:EMAIL_TOO_LONG'] = 'E-POS_TE_LANK - Die E-poswaarde is langer as die maksimum van 100 karakters.';
$string['error:ERROR_AUTH_BAD_CIEID'] = 'FOUT_VALIDASIE_SWAK_CIEID - Die IP van die roeper is ongeldig.';
$string['error:ERROR_FAILED_EDIT_USER'] = 'FOUT_MISLUK_WYSIG_GEBRUIKER - Fout tydens uitgawe, die gebruiker is nie gewysig nie.';
$string['error:ERROR_LOGIN_NO_SPACE_ALLOWED'] = 'FOUT_INTEKEN_GEEN_SPASIE_TOEGELAAT - Die intekennaam bevat spasies.';
$string['error:FIRSTNAME_TOO_LONG'] = 'VOORNAAM_TE_LANK - Die voornaam oorskry die maksimum van 50 karakters.';
$string['error:FONCTIONTILE_TOO_LONG'] = 'FUNKSIETEëL_TE_LANK - Die funksiewaarde oorskry die maksimum van 50 karakters.';
$string['error:INVALID_ACTIVITYID'] = 'ONGELDIGE_AKTIWITEITID - Die ID-waarde van die aktiwiteit is ongeldig, sinchronisering was onmoontlik.';
$string['error:INVALID_ACTIVITYSTATE'] = 'ONGELDIGE_AKTIWITEITTOESTAND - Die waarde in Aktiwiteittoestand oorgedra is ongeldig.';
$string['error:INVALID_ACTIVITYTYPE'] = 'ONGELDIGE_AKTIWITEITTIPE - Die waarde in Aktiwiteittipe is ongeldig.';
$string['error:INVALID_AUDIOTYPE'] = 'ONGELDIGE_OUTIOTIPE - Die waarde in Oudiotipe oorgedra is ongeldig.';
$string['error:INVALID_CIEID'] = 'ONGELDIGE_CIEID - Die CIE-ID-waarde moet numeries wees.';
$string['error:INVALID_CONFIRMATION_STATUS'] = 'ONGELDIGE_BEVESTIGINGSTATUS - Die waarde in Bevestigingstatus oorgedra is ongeldig.';
$string['error:INVALID_DATE'] = 'ONGELDIGE_DATUM - Datumformaat JJJJ-MM-DD UU:MM:SS.';
$string['error:INVALID_DURATION'] = 'ONGELDIGE_TYDSDUUR - Die TYDSDUUR-waarde moet numeries wees.';
$string['error:INVALID_FRIDAY_VALUE'] = 'ONGELDIGE_VRYDAGWAARDE - Die waarde van die eienskap; Vrydag is ongeldig.';
$string['error:INVALID_GENDER'] = 'ONGELDIGE_GENRE - Die waarde in Genre oorgedra is ongeldig.';
$string['error:INVALID_ISNUMBEREDTITLE'] = 'ONGELDIG_ISGENOMMERDETITEL - Die waarde in IsGenommerdeTitel oorgedra is ongeldig.';
$string['error:INVALID_ISPUBLIC'] = 'ONGELDIG_ISPUBLIEK - Die waarde in ISPUBLIEK oorgedra moet 0 of 1 wees.';
$string['error:INVALID_ISRECORDED'] = 'ONGELDIG_ISOPGENEEM - Die waarde in IsOpgeneem oorgedra is ongeldig.';
$string['error:INVALID_ISREPLAYALLOWED'] = 'ONGELDIG_ISOORSPEELTOEGELAAT - Die waarde in IsOorspeelToegelaat oorgedra is ongeldig.';
$string['error:INVALID_LANGUAGE'] = 'ONGELDIG_TAAL - Die waarde in Taal oorgedra is ongeldig.';
$string['error:INVALID_MAIL_FORMAT'] = 'ONGELDIG_POSFORMAAT - Die e-posformaat is ongeldig.';
$string['error:INVALID_MONDAY_VALUE'] = 'ONGELDIG_MAANDAGWAARDE - Die waarde van die eienskap; Maandag is ongeldig.';
$string['error:INVALID_MONTHLYDAY'] = 'ONGELDIG_MAANDELIKSEDAG - Die waarde MAANDELIKSEDAG is ongeldig.';
$string['error:INVALID_NEEDCONFIRMATION'] = 'ONGELDIG_BENODIGBEVESTIGING - Die waarde in BenodigBevestiging oorgedra is ongeldig.';
$string['error:INVALID_OBJECT_FORMAT'] = 'ONGELDIG_VOORWERPFORMAAT - Die INNERXML van die soap:body is ongeldig.';
$string['error:INVALID_PARTICIPANT_TYPE'] = 'ONGELDIG_DEELNEMERTIPE - Die waarde in Deelnemertipe oorgedra is ongeldig.';
$string['error:INVALID_PERIODICITY_ENDDATE'] = 'ONGELDIG_PERIODISITEIT_EINDDATUM - Datumformaat JJJJ-MM-DD.';
$string['error:INVALID_PERIODICITY_STARTDATE'] = 'ONGELDIG_PERIODISITEIT_AANVANGSDATUM - Datumformaat JJJJ-MM-DD UU:MM:SS.';
$string['error:INVALID_PHONERIGHT'] = 'ONGELDIGE_FOONREGTE - Die konferensiebrug is nie geldig vir hierdie maatskappy nie.';
$string['error:INVALID_PLAYBACK_ID'] = 'ONGELDIGE_TERUGSPEEL_ID - Die terugspeel-ID is ongeldig.';
$string['error:INVALID_PROFILID'] = 'ONGELDIGE_PROFIELID - Die multimediaprofiel is óf ongeldig, of bestaan nie vir hierdie klant nie.';
$string['error:INVALID_RECNOTIFICATION'] = 'ONGELDIGE_OPNAMEKENNISGEWING - Die waarde in TAAL oorgedra is ongeldig.';
$string['error:INVALID_RECORDMODEBEHAVIOR'] = 'ONGELDIGE_OPNAMEMODUSGEDRAG - Die waarde in Rekordmodusgedrag oorgedra is ongeldig.';
$string['error:INVALID_RECORD_TYPE'] = 'ONGELDIGE_OPNAMETIPE - Die opnametipe wat versoek is, is ongeldig.';
$string['error:INVALID_REDIRECT_TYPE'] = 'ONGELDIGE_HERLEITIPE - Die waarde in Herleitipe oorgedra is ongeldig.';
$string['error:INVALID_REMINDERTIME'] = 'ONGELDIGE_HERINNGERINGTYD - Die waarde in Herinneringtyd is ongeldig.';
$string['error:INVALID_ROOMTYPE'] = 'ONGELDIGE_KAMERTIPE - Die waarde in Kamertipe oorgedra is ongeldig.';
$string['error:INVALID_SATURDAY_VALUE'] = 'ONGELDIGE_SATERDAGWAARDE - Die waarde van die eienskap; Saterdag is ongeldig.';
$string['error:INVALID_SOAP_FORMAT'] = 'ONGELDIGE SOAP_FORMAAT - Die SOAP-versoek is nie korrek geïnstasieer nie.';
$string['error:INVALID_STATUS'] = 'ONGELDIGE_STATUS - Die waarde in Status oorgedra is ongeldig.';
$string['error:INVALID_SUNDAY_VALUE'] = 'ONGELDIGE_SONDAGWAARDE - Die waarde van die eienskap; Sondag is ongeldig.';
$string['error:INVALID_THURSDAY_VALUE'] = 'ONGELDIGE_DONDERDAGWAARDE - Die waarde van die eienskap; Donderdag is ongeldig.';
$string['error:INVALID_TIMEZONE'] = 'ONGELDIGE_TYDSONE - Die waarde in TYDSONE oorgedra is ongeldig.';
$string['error:INVALID_TITLE_TOO_LONG'] = 'ONGELDIG_TITEL_TE_LANK - Die titel oorskry die maksimum van 100 karakters.';
$string['error:INVALID_TUESDAY_VALUE'] = 'ONGELDIGE_DINSDAGWAARDE - Die waarde van die eienskap; Dinsdag is ongeldig.';
$string['error:INVALID_USERID'] = 'ONGELDIGE_GEBRUIKERID - Die gebruiker-ID is ongeldig.';
$string['error:INVALID_USERTYPE'] = 'ONGELDIGE_GEBRUIKERTIPE - Die waarde in TAAL oorgedra is ongeldig.';
$string['error:INVALID_USER_RIGHT'] = 'ONGELDIGE_GEBRUIKERREG - Die gebruiker het nie wysiging- of skeppingsregte vir hierdie aktiwiteit nie.';
$string['error:INVALID_WAITINGROOMACCESSMODE'] = 'ONGELDIGE_WAGKAMERTOEGANGSMODUS - Die waarde in WagkamerToegangsmodus oorgedra is ongeldig.';
$string['error:INVALID_WEDNESDAY_VALUE'] = 'ONGELDIGE_WOENSDAGWAARDE - Die waarde van die eienskap; Woensdag is ongeldig.';
$string['error:LASTNAME_TOO_LONG'] = 'VAN_TE_LANK - Die vanwaarde oorskry die maksimum van 50 karakters.';
$string['error:LOGIN_EMPTY'] = 'INTEKENING_LEEG - Die intekenwaarde is leeg.';
$string['error:LOGIN_TOO_LONG'] = 'INTEKENING_TE_LANK - Die intekenwaarde oorskry die maksimum van 15 karakters.';
$string['error:LOGIN_USED'] = 'INTEKENING_GEBRUIK - Die intekenwaarde is reeds gebruik.';
$string['error:PASSWORD_EMPTY'] = 'WAGWOORD_LEEG - Die wagwoordwaarde is leeg.';
$string['error:PASSWORD_TOO_LONG'] = 'WAGWOORD_TE_LANK - Die wagwoord se waarde oorskry die maksimum van 15 karakters.';
$string['error:PERIODICITY_NODE_MISSING'] = 'PERIODISITEITNODUS_ONTBREEK - Die periodisiteitwaarde kon nie oorgedra word nie.';
$string['error:PHONEBUS_TOO_LONG'] = 'FOONWERK_TE_LANK - Die besigheid se telefoonnommerwaarde oorskry die maksimum van 20 karakters.';
$string['error:PHONECEL_TOO_LONG'] = 'FOONSEL_TE_LANK - Die selfoonnommerwaarde oorskry die maksimum van 20 karakters.';
$string['error:PHONEHOME_TOO_LONG'] = 'FOONHUIS_TE_LANK - Die huis se telefoonnommerwaarde oorskry die maksimum van 20 karakters.';
$string['error:PLAYBACK_NOT_PUBLIC'] = 'TERUGSPEEL_NIE_PUBLIEK - Hierdie terugspeel is nie publiek nie.';
$string['error:RECORD_NOT_DOWNLOADABLE'] = 'OPNAME_NIE_AFLAAIBAAR - Die opname kan nie afgelaai word nie.';
$string['error:STATUS_INVALID'] = 'Die konneksie aan die webkonferensiekamer is nie moontlik nie, aangesien jou gebruiker uitgewis of onaktief is.<br/>Kontak asseblief die Via-administrateur of jou instelling om jou Via-gebruiker te heraktiveer.';
$string['error:TITLE_IS_REQUIRED'] = 'TITEL_WORD_VEREIS - \'n Titel word vereis.';
$string['error:TITLE_TOO_LONG'] = 'TITEL_TE_LANK - Die titelwaarde oorskry die maksimum van 100 karakters.';
$string['error:UNABLE_TO_CREATEDATE'] = 'KAN_NIE_DATUM_SKEP - Daar was \'n fout in die skep van die periodisiteitdatums.';
$string['error:URL_ERROR'] = 'URL_FOUT - Die API se url bestaan nie. Verifieer asseblief jou verstellings. Sonder die API se URL kan jy nie aktiwiteite skep nie!';
$string['error:USERID_EMPTY'] = 'GEBRUIKERID_LEEG - Die waarde Gebruiker-ID is ongeldig.';
$string['error:USER_DOES_NOT_EXIST'] = 'GEBRUIKER_BESTAAN_NIE - Die gebruiker is ongeldig.';
$string['error:USER_DOWNLOAD_NOT_ALLOWED'] = 'GEBRUIKER_AFLAAI_NIE_TOEGELAAT - Die gebruiker word nie toegelaat om hierdie opname af te laai nie.';
$string['error:_CANNOT_CHANGE_ISNEWVIA'] = 'KAN_NIE_VERANDER_ISNUWEVIA - Wanneer \'n aktiwiteit binnegegaan is, is dit nie meer moontlik om die weergawe te wysig nie.';
$string['error:_INVALID_PROFILID'] = 'ONGELDIGE_PROFIELID - Die multimediaprofiel is ongeldig of bestaan nie vir hierdie klant nie.';
$string['error:allseatstaken'] = 'Jammer, nie alle beskikbare sitplekke op SVI-bediener is geneem nie. Jy kan nie nou aan hierdie aktiwiteit konnekteer nie. \'n Kennisgewing van hierdie oorloop is reeds aan die administrateurs gestuur. Jy kan ook \'n <a href="mailto:$a->email?subject=Avis de debordement sur VIA">$a->e-pos</a> stuur om hulle in kennis te stel.<br><br>Probeer asseblief later weer konnekteer.';
$string['error:deletefailed'] = 'Die verwydering van alle aktiwiteite het misluk.';
$string['error:disablereviews'] = 'Versperring van hersienmodus het misluk.';
$string['error:resetparticipants'] = 'Die verwydering van alle deelnemers het misluk.';
$string['error_user'] = 'Gebruiker {$a} kon nie by die aktiwiteit gevoeg word nie.';
$string['export'] = 'Besigtig/Voer uit';
$string['finish'] = 'Klaar';
$string['fullvideo'] = 'Volledige video (MP4)';
$string['fullvideoinfo'] = 'Soos gesien in die opname. Resolusie: 1024x768';
$string['gotoactivity'] = 'Toegang';
$string['gotorecording'] = 'Verkry toegang tot die opname';
$string['groupusers'] = 'Gebruikers van geassosieerde groepering: {$a} kan nie uit die aktiwiteit verwyder word nie, maar ander kan bygevoeg word.';
$string['hasconfirmed'] = 'Jy het bevestig dat jy hierdie aktiwiteit sal bywoon.';
$string['hasconfirmednot'] = 'Jy het bevestig dat jy nie hierdie aktiwiteit sal bywoon nie.';
$string['headerduration'] = 'Tydsduur';
$string['hidelist'] = 'Versteek';
$string['highquality'] = 'Goeie kwaliteit';
$string['host'] = 'Gasheer';
$string['host_replace'] = 'Vervang gasheer';
$string['incomplete'] = 'Onvolledig';
$string['inhostabsence'] = 'In afwesigheid van gasheer (outomaties)';
$string['inviteclicktoaccesshtml'] = 'Om na die aktiwiteit te gaan, kliek hierdie skakel hieronder:';
$string['inviteemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Hallo {$a->username},

Moodle nooi jou om deel te neem aan die aktiwiteit &quot; {$a->title} &quot; wat sal plaasvind op {$a->datebegin} tussen {$a->hourbegin} en {$a->hourend}

{$a->invitemsg}

---------------------------------------------------------------------
Aktiwiteitvoorbereiding

Kliek hier vir die opstelassistent: {$a->config}
Kliek hier vir tegniese ondersteuning: {$a->assist}

---------------------------------------------------------------------
Webtoegang

Volg hierdie skakel om na die aktiwiteit te gaan : {$a->activitylink}

---------------------------------------------------------------------

Waarskuwing: Hierdie aktiwiteit kan opgeneem word. Moet asseblief nie hierdie aktiwiteit binnegaan as jy nie opgeneem wil word nie. Hierdie e-pos bevat persoonlike konneksie-inligting. Hierdie inligting moet nie gedeel word nie.';
$string['inviteemailhtml'] = '<p>Hallo {$a->username},</p>
<p>Moodle nooi jou om deel te neem aan die aktiwiteit &laquo; {$a->title} &raquo; wat sal plaasvind op <b>{$a->datebegin}</b> tussen <b>{$a->hourbegin}</b> en <b>{$a->hourend}</b>.</p><p>{$a->invitemsg}</p>';
$string['inviteemailhtmlpermanent'] = '<p>Hallo {$a->username},</p>
<p>{$a->invitemsg}</p>';
$string['inviteemailpermanent'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Hallo {$a->username},

{$a->invitemsg}

---------------------------------------------------------------------
Aktiwiteitvoorbereiding

Kliek hier vir die opstelassistent: {$a->config}
Kliek hier vir tegniese ondersteuning: {$a->assist}

---------------------------------------------------------------------
Webtoegang

Volg hierdie skakel om na die aktiwiteit te gaan : {$a->activitylink}

---------------------------------------------------------------------

Waarskuwing: Hierdie aktiwiteit kan opgeneem word. Moet asseblief nie hierdie aktiwiteit binnegaan as jy nie opgeneem wil word nie. Hierdie e-pos bevat persoonlike konneksie-inligting. Hierdie inligting moet nie gedeel word nie.';
$string['inviteemailsubject'] = 'UITNODIGING: {$a->title}';
$string['invitepreparationhtml'] = 'Aktiwiteitvoorbereiding';
$string['invitessend'] = 'Uitnodigings sal in minder as 15 minute gestuur word.';
$string['invitessent'] = 'Uitnodigings is gestuur.';
$string['invitewarninghtml'] = 'Waarskuwing: Hierdie aktiwiteit kan opgeneem word. Moet asseblief nie hierdie aktiwiteit binnegaan as jy nie opgeneem wil word nie. Hierdie e-pos bevat persoonlike konneksie-inligting. Daardie inligting moet nie gedeel word nie.';
$string['invitewebaccesshtml'] = 'Webtoegang';
$string['ish264'] = 'Aktiveer videomodus vir mobiele toestelle';
$string['ish264_help'] = 'As hierdie boks gemerk is, sal minder doeltreffende video-codec gebruik word en deelnemers wat mobiele toestelle gebruik, sal ander mense se video\'s kan sien. As hierdie boks leeg gelaat word, sal \'n meer doeltreffende video-codec (H264) gebruik word en gebruikers van mobiele toestelle nie ander mense se video\'s kan sien nie, maar net hul eie stemme kan hoor. Hulle sal egter toegang tot alle ander multimediafunksionaliteite (dokumente, annotasies, skermdeel, ens,) behou.';
$string['list_activities'] = 'Lys alle Via-aktiwiteite in hierdie kursus';
$string['lowquality'] = 'Swak kwaliteit';
$string['manageparticipants'] = 'Bestuur gebruikers';
$string['manual'] = 'Per hand';
$string['manualenrol'] = 'Handmatige inskrywing';
$string['mask'] = 'Versteek';
$string['mediumquality'] = 'Medium kwaliteit';
$string['mobilevideo'] = 'Mobiel (MP4)';
$string['mobilevideoinfo'] = 'Geoptimaliseer vir mobiel. Resolusie: 480 x 320';
$string['mode'] = 'Oudiomodus';
$string['modephone'] = 'Slegs telefoonkonferensie';
$string['modevoiceweb'] = 'Stem oor die Web';
$string['modewebphone'] = 'Web en stem oor die foon';
$string['modulename'] = 'Via';
$string['modulename_help'] = 'Die Via-module laat jou gelyktydige vergaderings in \'n virtuele klaskamer skep om regstreeks te deel deur stem en video te gebruik vir: intydse afstandsklasse, vergaderings, werkspanvergaderings, steunonderrig, seminare, ens.

Hierdie hulpmiddel laat toe dat jy subwerksgroepe, annotasies, en skermdeel bestuur, dokumente invoer of aanbied, en om deur stem en/of video te deel.

Die \'Deelnemerinskrywings\'-opsies laat jou toe om deelnemers per hand in te skryf of om hulle outomaties te sinchronieseer volgens hul Moodle-regte, deur die opsie \'Outomatiese inskrywing\' te kies.

Die \'Sessieparameters\' laat jou toe om die opnamemodus te stel wat jy wil hê, en die beskikbaarheid daarvan vir jou leerders, te kies.';
$string['modulenameplural'] = 'Via';
$string['moodle_adminid'] = 'Moodle-admin unieke ID';
$string['moodle_config'] = 'API-konfigurasie - Stap 2';
$string['moodleidsetting'] = 'Unieke admingebruiker vir hierdie moodle';
$string['multimediaquality'] = 'Multimediaprofiele';
$string['multimediaquality_help'] = 'Kies die mediaprofiel om in die aktiwiteit te gebruik vir mediauitruiling (webkamera, mikrofoon en multimediadokumente). Hierdie opsie kan \'n beduidende impak hê op die vloeibaarheid van die uitruilings en die bandbreedte wat vir elke deelnemer vereis word. Oor die algemeen, vir \'n beter ervaring of as jy onseker is, is dit beter om \'n swakker kwaliteit te gebruik om gladde vloeibaarheid te verseker. Dit is moontlik om ander multimediaprofiele volgens jou spesifieke behoeftes te konfigureer (bv. groot videokleinkiekies uitstekend vir gebruik in plaaslike modus). Kontak een van ons Via-kenners vir meer hieroor.';
$string['multiple'] = 'Veelvuldig';
$string['mustaccept'] = 'Merk die boks om die aktiwiteit binne te gaan.';
$string['name'] = 'Naam';
$string['needconfirmation'] = 'Versoek bevestiging van beskikbaarheid';
$string['needconfirmation_help'] = 'Versoek bevestiging van beskikbaarheid';
$string['neverbegin'] = 'Nie gedoen nie';
$string['no_categories'] = 'Daar is geen kategorieë nie, dit moet in die Via-portaal deur \'n administrateur geskep word';
$string['no_default'] = 'Geen verstek kategorie nie.';
$string['noanimators'] = 'Daar is nog geen animeerders vir hierdie aktiwiteit nie.';
$string['nocategories'] = 'Geen kategorieë';
$string['noparticipants'] = 'Daar is nog geen deelnemers vir hierdie aktiwiteit nie.';
$string['noparticipants_help'] = 'Hierdie opsie is slegs met outomatiese inskrywing beskikbaar en verseker dat gebruikers met die studentstatus almal as animeerders in Via bygevoeg word.';
$string['noparticipantscheckbox'] = 'Voeg alle studente as animeerders by';
$string['norecall'] = 'Geen herwinning';
$string['notactivated'] = 'Moet nie opneem nie';
$string['notactivatedfeminin'] = 'Nie geaktiveer nie';
$string['notattending'] = 'Ek sal nie bywoon nie';
$string['notenrolled'] = 'Jy is nie vir hierdie aktiwiteit ingeskryf nie. Kontak asseblief jou onderwyser as jy dink jy behoort toegang te hê.';
$string['noticeclicktoaccesshtml'] = 'Kliek die volgende skakel vir direkte toegang:';
$string['noticeemail'] = 'Hallo {$a->username},

Hierdie is \'n outomatiese boodskap.

Die uitvoer wat jy versoek het, vir opname en &quot;{$a->playbacktitle}&quot; in {$a->type} is sedert {$a->date} gereed.
Jy kan hierdie uitvoer aflaai of dit aan die deelnemer beskikbaar stel deur die besonderhedebladsy van jou aktiwiteit &quot;{$a->activitytitle}&quot;. binne te gaan.

Webtoegang
---------------------------------------------------------------------

Kliek die volgende vir direkte toegang: {$a->activitylink}

---------------------------------------------------------------------';
$string['noticeemailhtml'] = '<p>Hallo {$a->username},</p>
<p>Hierdie is \'n outomatiese boodskap.</p>
<p>Die uitvoer wat jy versoek het vir opname &quot;{$a->playbacktitle}&quot; in {$a->type} is sedert {$a->date} voltooi.<br/>
Jy kan hierdie afvoer aflaai of dit aan die deelnemers beskikbaar stel deur na die besonderhedebladsy van jou aktiwiteit &quot;{$a->activitytitle}&quot; te gaan.</p>';
$string['noticeemailsubject'] = 'WAARSKUWING: uitvoer-Via is gereed';
$string['notificationemail'] = 'Hallo {$a->username},

Hierdie is \'n outomatiese boodskap.

Die gebruiker {$a->userfrom} probeer met jou kontak maak deur aan jou aktiwiteit te konnekteer: &quot;{$a->activitytitle}&quot;

Webtoegang
---------------------------------------------------------------------

Kliek die volgende skakel vir direkte toegang: {$a->activitylink}

---------------------------------------------------------------------';
$string['notificationemailhtml'] = '<p>Hallo {$a->username},</p>
<p>Hierdie is \'n outomatiese boodskap.</p>
<p>Die gebruiker {$a->userfrom} probeer met jou kontak maak deur aan jou aktiwiteit te konnekteer : &quot;{$a->activitytitle}&quot;.</p>';
$string['notificationemailsubject'] = 'WAARSKUWING: aktiwiteitkennisgewing';
$string['notifysuccess_synch1'] = 'Alle gebruikers is suksesvol met Via gesinchroniseer.';
$string['notifysuccess_synch2'] = 'Sekere gebruikers kon nie gesinchroniseer word nie. Valideer asseblief hul inligting en probeer weer.';
$string['notstarted'] = 'Hierdie aktiwiteit het nog nie begin nie.';
$string['nounifiedrecordpermanent'] = 'Verenigde opneemmodus is nie vir \'n permanente aktiwiteit moontlik nie. Kies asseblief \'n ander opsie.';
$string['nousers'] = 'Waarskuwing - Daar is geen gebruikers met hierdie aktiwiteit geassosieer nie!';
$string['oldapiversion'] = 'Jy gebruik \'n API-weergawe wat ouer as {$a} is';
$string['options'] = 'Aktiwiteitopsies';
$string['overview'] = 'Begin op {$a->start} en eindig {$a->end}';
$string['participant'] = 'Deelnemer';
$string['participantmustconfirm'] = 'Deelnemers moet deelname bevestig';
$string['participantmustconfirmdesc'] = 'Indien gemerk, moet deelnemers bevestig of hulle deel van die aktiwiteit gaan wees.';
$string['participants'] = 'Deelnemers';
$string['participants_search'] = 'soek deelnemers';
$string['participantsynchronization'] = 'Sinchroniseer deelnemers se inligting';
$string['participantsynchronizationdesc'] = 'Indien gemerk, sal deelnemers se inligting gesinchroniseer word met dié wat in Moodle geberg is. Die enigste inligting wat nie bygewerk sal word nie is: die intekening, die wagwoord en die gebruikertipe in Via.';
$string['passdate'] = 'Die geselekteerde datum is verby';
$string['permanent'] = 'Permanente aktiwiteit';
$string['permanent_help'] = 'Merk "Permanent" om jou aktiwiteit te alle tye toeganklik te maak. Jy sal dan verplig wees om die wagkamer te gebruik om toegang aan registreerde gebruikers met "deelnemer"-status te beperk.';
$string['permanentactivities'] = 'Permanente aktiwiteite';
$string['permanentactivitiesdesc'] = 'Indien gemerk, sal dit moontlik wees om permanente aktiwiteite te skep.';
$string['personalinvitemsg'] = 'Gepersonaliseerde boodskap (opsioneel):';
$string['playbackSynchronize'] = 'Sinchroniseer terugspeel';
$string['playback_downloaded'] = 'Terugspeel is afgelaai';
$string['playback_viewed'] = 'Terugspeel is besigtig';
$string['playbackaccesstype0'] = 'Sigbaar aan diegene met wysigingsregte';
$string['playbackaccesstype1'] = 'Sigbaar aan diegene wat met die virtuele klas geassosieer word';
$string['playbackaccesstype2'] = 'Sigbaar aan diegene wat met die gedelegeerde aktiwiteit geassosieer word';
$string['playbackaccesstypelbl'] = 'Toegangsregte vir die opname';
$string['playbackheader'] = 'Terugspeel besigtig (u:m:s)';
$string['pluginadministration'] = 'Via-administrasie';
$string['pluginname'] = 'Via - Virtuele klaskamer';
$string['portalaccess'] = 'Via-portaaltoegang';
$string['portalaccessdesc'] = 'Laat gebruikers toegang tot die Via-portaal sonder intekening toe.';
$string['potentialusers'] = 'Potensiële gebruikers';
$string['preparation'] = 'Berei jou aktiwiteit voor';
$string['prepareactivity'] = 'Kliek hier om jou aktiwiteit voor te berei';
$string['presence'] = 'Minimum bywoning word vereis';
$string['presence_help'] = 'Teks moet verander word! Waarde wat ooreenstem met die tyd in minute waarvan die gebruiker die teenwoordigheidstatus vir die aktiwiteit verkry.';
$string['presenceheader'] = 'Aanlyn teenwoordigheid (u:m:s)';
$string['presenceheaderreport'] = 'Aanlyn teenwoordigheid';
$string['presencestatus'] = 'Vertoon teenwoordigheidstatus';
$string['presencestatusdesc'] = 'Indien gemerk, sal \'n nuwe opsie in die aktiwiteit se parameters verskyn, om \'n minimum hoeveelheid tyd te stel wat gebruikers teenwoordig moet wees om as teenwoordig vir \'n aktiwiteit beskou te word. \'n Drukbare weergawe sal ook beskikbaar wees.';
$string['presencetable'] = 'Teenwoordigheidstatus:';
$string['presencewarning'] = 'Belangrik: Die aanlyn teenwoordigheidstatus word bepaal deur die minimum tyd wat vereis word om as teenwoordig vir die aktiwiteit beskou te word. Die status beïnvloed die deelnemer se vorderingstatfie. Dit is moontlik om die status aan te pas deur die &laquo; Minimum bywoning vereis &raquo; waarde in die aktiwiteit se parameters te verander.';
$string['present'] = 'Teenwoordig';
$string['recalloneday'] = 'Een dag voor';
$string['recallonehour'] = 'Een uur voor';
$string['recalloneweek'] = 'Een week voor';
$string['recalltwodays'] = 'Twee dae voor';
$string['recalltwohours'] = 'Twee ure voor';
$string['recentrecordings'] = 'Onlangse opnames';
$string['recordaccept'] = 'Ek aanvaar';
$string['recording'] = 'Opname';
$string['recordingisdownloadable'] = 'Opname kan afgelaai word';
$string['recordingisdownloadableinfo'] = 'Let wel: Jy moet eers die video uitvoer om dit vir aflaai beskikbaar te maak.';
$string['recordingmode'] = 'Opnamemodus';
$string['recordingmode_help'] = 'As jy die opnameopsie vir jou aktiwiteite wil ontsper, is twee modusse beskikbaar: "Verenig" en "Veelvuldig". Die "verenigde" tipe sal \'n enkele, verenigde opname produseer, ongeag die aantal opnames wat tydens die vergadering gemaak is; die "veelvuldige" tipe sal opnames produseer wat apart en gesegmenteer is.';
$string['recordings'] = 'Beskikbare opname(s):';
$string['recordingtitle'] = 'Opnametitel';
$string['recordmodebehavior'] = 'Opname';
$string['recordmodebehavior_help'] = 'Jy kan ook kies om opname outomaties met toegang te laat begin, deur die "Outomaties"-opsie te kies. Kies "Handmatig" as jy nie die opname outomaties wil laat begin nie, dan sal jy die opname self begin deur op die opneem-ikoon in die sinchrone koppelvlak te kliek.';
$string['recordwarning'] = 'Hierdie aktiwiteit kan opgeneem word. Wanneer jy hierdie boks merk, aanvaar jy dat jy opgeneem kan word.';
$string['refused'] = 'Sal nie bywoon nie';
$string['reminderemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Hallo {$a->username},herinnering-e-pos

Moodle nooi jou uit om deel te neem aan die aktiwiteit &quot; {$a->title} &quot; wat sal plaasvind op {$a->datebegin}, tussen {$a->hourbegin} en {$a->hourend}

---------------------------------------------------------------------
Aktiwiteitvoorbereiding

Kliek hier vir die opstelassistent: {$a->config}
Kliek hier vir tegniese ondersteuning: {$a->assist}

---------------------------------------------------------------------
Webtoegang

Volg hierdie skakel om na die aktiwiteit te gaan: {$a->activitylink}

---------------------------------------------------------------------

Waarskuwing: Hierdie aktiwiteit kan opgeneem word. Moet asseblief nie hierdie aktiwiteit binnegaan as jy nie opgeneem wil word nie. Hierdie e-pos bevat persoonlike konneksie-inligting. Daardie inligting moet nie gedeel word nie.';
$string['reminderemailhtml'] = '<p>Hallo {$a->username}herinnering-e-pos-html,</p>
<p>Hierdie is \'n herinnering van \'n aktiwiteit wat binnekort plaasvind:</p>
<p><b>Titel:</b> {$a->title} <br/>
<b>Datum en tyd</b>{$a->activitydate}<br/>
<b>Tydsduur:</b> {$a->duration minutes}</p>';
$string['reminderemailsubject'] = 'HERINNERING: {$a->title}';
$string['replace_host'] = 'Vervang gasheer';
$string['report'] = 'Teenwoordigheidsverslag';
$string['resetdeletemodules'] = 'Wis alle aktiwiteite uit';
$string['resetdisablereviews'] = 'Versper oorsigte vir alle aktiwiteite';
$string['resetparticipants'] = 'Wis alle deelnemers en animeerders uit (werk slegs vir aktiwiteite met handmatige inskrywing)';
$string['return'] = 'Terug';
$string['returnto'] = 'Terug na aktiwiteit';
$string['reviewacitvity'] = 'Maak alle opnames by verstek openbaar';
$string['reviewacitvity_help'] = 'As jy die opnames beskikbaar wil stel, kies ja. Anders sal geen deelnemers die opnames kan sien tensy jy elkeen in die lys merk nie. Let asseblief daarop dat hierdie opsie enige tyd gewysig kan word, selfs wanneer die aktiwiteit geëndig het.';
$string['reviewactivity'] = 'Verstek toegangsregte vir opnames';
$string['reviewactivity_help'] = 'Kies wie die opnames kan sien.';
$string['role'] = 'Rol';
$string['roomtype'] = 'Aktiwiteitstipe';
$string['roomtype_help'] = 'Die "standaard"-tipe is \'n aktiwiteit waarin alle deelnemers gelys is en normaal kan interreageer, afhangend van die toegekende rol. As jy eerder \'n aktiwiteittipe "Webinaar" kies,
sal slegs die gasheer en animeerders die name van die deelnemers kan sien. Daarby sal hulle slegs deur te klets kan interreageer. Laasgenoemde tipe is ideaal vir aktiwiteite wat groot gehore insluit
(meer as 100 deelnemers) of konfidensiële aktiwiteite. Wanneer die "Permanent"-opsie gekies is, sal die aktiwiteit nie meer \'n vasgestelde datum en tyd hê nie.
Alle deelnemers wat met hierdie aktiwiteit geassosieer word, kan dit dan op enige tyd binnegaan. Let asseblief daarop dat slegs die multi-opname-opsie vir hierdie tipe aktiwiteit bekikbaar is.';
$string['roomversion'] = 'Kies die Via-weergawe vir hierdie aktiwiteit';
$string['roomversion_help'] = 'Kies die Via-weergawe vir hierdie aktiwiteit';
$string['save'] = 'Berg';
$string['seminar'] = 'Seminaar';
$string['sendinvitation'] = 'E-posuitnodiging';
$string['sendrecall'] = 'Stuur e-posherroeping';
$string['sendrecall_help'] = 'Laat jou toe om \'n outomatiese herinnering te stel. Jy kan kies om \'n herinnering aan alle deelnemers te stuur, 1 of 2 ure, 1 of 2 dae, of selfs \'n week voor die aktiwiteit. Hulle sal dan \'n herinnering per e-pos ontvang.';
$string['sessionparameters'] = 'Sessieparameters';
$string['show'] = 'Is vertoon';
$string['showlist'] = 'Vertoon';
$string['showparticipants'] = 'Deelnemerslys';
$string['showparticipants_help'] = 'Laat jou kies om die deelnemerslys in die webinaarmodus van Via te vertoon of te versteek.';
$string['standard'] = 'Standaard';
$string['startdate'] = 'Begin op';
$string['submitinvite'] = 'Stuur uitnodigings';
$string['subscribeparticipants'] = 'Deelnemersinskrywing';
$string['synctemplateend'] = 'Die aktiwiteittemplaat is suksesvol gesinchroniseer.';
$string['technicalassist'] = 'Tegniese bystand';
$string['technicalassist_url'] = 'Gebruik \'n gepersonaliseerde tegniese bystand-blad.';
$string['technicalassist_urldesc'] = 'By verstek sal die tegniese bystand-blad die inligting wat in Via verskaf is, vertoon. Jy kan \'n gepersonaliseerde ondersteuningsblad byvoeg deur die URL direk op te roep. Dit kan \'n bladsy wees wat in Moodle of heeltemal \'n ander werf geskep is.';
$string['testadminid'] = 'Toets die moodle-sleutel';
$string['testconnection'] = 'Toets API-konneksie';
$string['timeduration'] = 'Tydsduur:';
$string['title_exists'] = 'Die titel bestaan reeds, probeer asseblief weer.';
$string['typepInscriptionCoordinator'] = 'Koördineerder';
$string['typepInscriptioncollaborator'] = 'medewerker';
$string['typepInscriptionmember'] = 'gebruiker';
$string['typepInscriptionsetting'] = 'Wanneer gebruikers in Via geskep word, word hierdie reg by verstek geskenk.';
$string['unified'] = 'Verenig';
$string['unplanned'] = 'Onbepland';
$string['unplanned_error'] = 'Jy kan slegs jou wysigings berg as dit \'n beplande aktiwiteit is!';
$string['unplanned_text'] = 'Hierdie aktiwiteit is nog nie beplan nie.';
$string['unplannedsettings'] = 'Gebruik onbeplande aktiwiteite';
$string['unplannedsettings_desc'] = 'As hierdie boks gemerk is, sal die herstelde aktiwiteite by verstek "onbeplan" wees. Om dit te aktiveer, moet jy hul parameters wysig en dit aan \'n datum toewys, of hulle as permanent definieer. Ongeag die ander dupliseringsopsies, sal gebruikers en dokumente nie gekopieer word nie.<br />As die boks nie gemerk is nie, sal die herstelde aktiwiteite by verstek tot een maand later gestel word.';
$string['updatethisvia'] = 'Werk hierdie Via by';
$string['userishost'] = 'Hierdie gebruiker is die gasheer, kies \'n nuwe een om aan hierdie gebruiker \'n nuwe rol te gee.';
$string['users_search'] = 'Soek deur potensiële gebruikers';
$string['usersynch'] = 'Gebruikers sal outomaties met die aktiwiteit geassosieer word wanneer hulle koppel. <br />As jy hulle vooraf wil assosieer om hulle aan werkswinkels toe te wys, kliek hier:';
$string['usersynchbtn'] = 'Assosieer alle gebruikers nou';
$string['usersynchwarning'] = 'Wag asseblief, dit kan \'n rukkie neem!';
$string['versionnew'] = 'Gebruik die mees onlangse weergawe van Via';
$string['versionold'] = 'Gebruik Via Weergawe 6';
$string['versions_not_compatible'] = 'Die invoegtoepassing- en Via-weergawes is nie versoenbaar nie. Die invoegtoepassing verg \'n minimum van';
$string['versionscompatible'] = 'Die invoegtoepassing- en Via-weergawes is versoenbaar.';
$string['via:addinstance'] = 'Voeg \'n nuwe Via-aktiwiteit by';
$string['via:manage'] = 'Bestuur Via-aktiwiteite';
$string['via:view'] = 'Besigtig Via-aktiwiteite';
$string['via:viewpresence'] = 'Besigtig Teenwoordigheidsverslae van Via-aktiwiteite';
$string['via_ciesettings_task'] = 'Sinchroniseringsverstellings VIA';
$string['via_mail_task'] = 'Via-posversending';
$string['via_notification_task'] = 'Via-aktiwiteitkennisgewings';
$string['via_typepInscription'] = 'Verstek reg in Via';
$string['via_usersync_task'] = 'Via-Moodle-gebruikersinchronisering';
$string['viaaccessed'] = 'Via binnegegaan';
$string['viaaudiotypes'] = 'Kies oudiomodus wat jy wil behou.';
$string['viacategoriesdesc'] = 'Indien gemerk, kan kategorieë wat in Via geskep is, by die aktiwiteit gevoeg word.';
$string['viausers'] = 'Gebruikers:';
$string['view'] = 'Besigtig';
$string['waitingconfirm'] = 'Wag vir bevestiging';
$string['waitingroomaccessmode'] = 'Wagkamer';
$string['waitingroomaccessmode_help'] = 'Die opsie "Hangende Magtiging" laat die gasheer toe om aan individuele deelnemers toegang te bied terwyl die opsie "In die gasheer se afwesigheid" verseker dat geen gebruiker toegang tot die aktiwiteit het voor die spreker gekonnekteer is nie. Hierdie laaste opsie is veral nuttig wanneer permanente aktiwiteite gebruik word.';
