<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'af', version '5.0'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aksies';
$string['addtocalendar'] = 'Voeg by kalender';
$string['allmeetings'] = 'Alle vergaderings';
$string['allmeetings_desc'] = 'Met hierdie verstelling kan jy beheer of \'n skakel na die Zoom-aktiwiteitindeksblad onderaan elke aktiwiteiteksemplaar-oorsigblad vertoon sal word of nie. Hierdie verstelling affekteer slegs die vertoon van die skakel op die Zoom-aktiwiteitoorsigbladsye. Selfs as jy besluit om nie die skakel daar te laat vertoon nie, sal die gebruiker moontlik steeds in staat wees om die Zoom-aktiwiteitindeksblad deur ander skakels binne die kursus in te gaan.';
$string['allmeetings_disable'] = 'Versper alle vergaderings-skakel';
$string['allmeetings_enable'] = 'Ontsper alle vergaderings-skakel';
$string['alternative_hosts'] = 'Alternatiewe Gashere';
$string['alternative_hosts_desc'] = 'Met hierdie verstelling kan jy beheer of die opsie om alternatiewe gashere te vertoon, aan gebruikers in die aktiwiteiteksemplaarverstellings vertoon word of nie. Twee soorte widgets is beskikbaar: \'n Eenvoudige toevoerveld wat komma-geskeide e-posadresse aanvaar. En \'n gebruikerkieser met outovoltooi, wat maklike seleksie van gebruikers, wat vir die kursus ingeskryf is, \'n Zoom-rekening en \'n rol uit {$a->roles} het, verskaf. Alternatiewe gashere wat moontlik direk in Zoom deur die onderwyser gestel is, maar nie vanuit die Moodle-gebruikerkieser gekies kan word nie, word steeds op die aktiwiteitoorsigblad vertoon en word ook gepreserveer wanneer \'n vergadering vanuit Moodle opgedateer word.';
$string['alternative_hosts_disable'] = 'Versper alternatiewe gashere-opsie';
$string['alternative_hosts_help'] = 'Die alternatiewe gasheer-opsie laat toe dat vergaderings geskeduleer word en ander Zoom-gebruiker(s) ook die vergaderings kan begin. Hierdie gebruikers sal \'n e-pos van Zoom ontvang, wat hulle in kennis stel dat hulle as alternatiewe gasheer bygevoeg is, met \'n skakel om die vergadering te begin.\\n\\nAs toevoerformaat, verskaf asseblief die e-posadres(se) van die alternatiewe gasheer(e). Jy kan veelvuldige e-posse met \'n komma skei (sonder spasies).';
$string['alternative_hosts_inputfield'] = 'Vertoon alternatiewe gashere-opsie as gewone toevoerveld';
$string['alternative_hosts_picker'] = 'Vertoon alternatiewe gashere-opsie as gebruikerkieser met outovoltooiing';
$string['alternative_hosts_picker_help'] = 'Die alternatiewe gasheer-opsie laat toe dat jy vergaderings skeduleer en ander Zoom-gebruiker(s), wat vir hierdie kursus ingeskryf is, om ook die vergadering te begin. Hierdie gebruikers sal \'n e-pos van Zoom ontvang wat hulle in kennis stel dat hulle as alternatiewe gasheer bygevoeg is, met \'n skakel om die vergadering te begin.\\n\\nJy kan een of meer alternatiewe gashere kies, gebaseer op jou vergadering se behoeftes.\\n\\nAs jy nie \'n spesifieke gebruiker in hierdie gebruikerkieser kan vind nie, is hierdie gebruiker óf nie vir hierdie kursus ingeskryf met \'n geskikte rol nie, óf hy beskik nie oor \'n gepaste rekening op Zoom nie.';
$string['alternative_hosts_picker_noneselected'] = 'Geen alternatiewe gasheer is gekies nie';
$string['alternative_hosts_picker_placeholder'] = 'Kies gebruiker(s)';
$string['apiurl'] = 'Zoom API-url';
$string['apiurl_desc'] = '';
$string['audio_both'] = 'Rekenaaroudio en Telefoon';
$string['audio_telephony'] = 'Slegs Telefoon';
$string['audio_voip'] = 'Slegs Rekenaaroudio';
$string['audiodefault'] = 'Oudio verstek';
$string['authentication'] = 'Validering';
$string['autorecording_userdefault'] = 'Gebruik standaard Zoom-gebruikersinstellings';
$string['autorecordingoptionsupdate'] = 'Dateer outomatiese opname-opsies op';
$string['breakoutrooms'] = 'Uitbreek kamers';
$string['cachedef_zoomid'] = 'Die zoom gebruiker-id van die gebruiker';
$string['cachedef_zoommeetingsecurity'] = 'Zoom-vergadering se sekuriteitsverstellings, o.a. vergadering-wagwoordvereistes van die rekening';
$string['calendardescriptionURL'] = 'Vergadering-aansluit-URL: {$a}';
$string['calendardescriptionintro'] = '\\nBeskrywing:\\n{\\$a}';
$string['calendariconalt'] = 'Kalenderikoon';
$string['changehost'] = 'Verander van gasheer';
$string['clickjoin'] = 'Het \'sluit aan by vergadering\'-knoppie gekliek';
$string['clientid'] = 'Zoom kliënt ID';
$string['clientsecret'] = 'Zoom kliënt geheim';
$string['connectionfailed'] = 'Konneksie het misluk:';
$string['connectionok'] = 'Konneksie werk.';
$string['connectionsettings'] = 'Konneksieverstellings';
$string['connectionsettings_desc'] = 'Hierdie verstellings definieer hoe Moodle aan Zoom koppel.';
$string['connectionstatus'] = 'Konneksiestatus';
$string['day'] = 'Dag(e)';
$string['defaultsettings'] = 'Verstek Zoom-verstellings';
$string['defaultsettings_help'] = 'Hierdie verstellings definieer die verstek van alle nuwe Zoom-vergaderings en -webinare.';
$string['deletemeetingrecordings'] = 'Vee vergadering opnames van Moodle uit';
$string['deleteroom'] = 'Verwyder kamer';
$string['displayleadtime'] = 'Vertoon aanlooptyd';
$string['displayleadtime_desc'] = 'Indien ontsper, sal die aanlooptyd aan die gebruikers vertoon word. Op dié manier word gebruikers ingelig dat / wanneer hulle voor die geskdeuleerde aanvangstyd by die vergadering kan aansluit.';
$string['displayleadtime_nohideif'] = 'Let assbelief: Hierdie verstelling word slegs verwerk as die \'{$a}\' verstelling na \'n waarde groter as nul gestel is.';
$string['displaypassword'] = 'Vertoon wagkode';
$string['displaypassword_help'] = 'Indien ontsper, sal die vergadering se wagkode altyd aan nie-gashere vertoon word.';
$string['downloadical'] = 'Laai iCal af';
$string['downloadical_desc'] = 'Met hierdie verstelling kan jy beheer of \'n skakel om \'n iCal-dokument vir die vergaderinge af te laai, op die aktiwiteiteksemplaar-oorsigblad vertoon sal word of nie. Hierdie verstelling affekteer slegs die moontlikheid om \'n iCal-dokument vir derdeparty-kalenderhulpmiddels af te laai. Ongeag hierdie verstelling, sal die Zoom-vergaderingaktiwiteit \'n kalenderinskrywing in die Moodle-kalender invoeg sodra die aanvangsdatum van \'n vergadering gestel word.';
$string['downloadical_disable'] = 'Versper Laai iCal af-skakel';
$string['downloadical_enable'] = 'Ontsper Laai iCal af-skakel';
$string['duration'] = 'Tydsduur (minute)';
$string['encryptiontype'] = 'Enkripsietipe';
$string['encryptiontype_alwaysshow'] = 'Vertoon altyd enkripsietipe-kieser, ongeag of die gebruiker punt-tot-punt-enkripsie kan gebruik of nie.';
$string['encryptiontype_desc'] = 'Met hierdie verstelling kan jy beheer of die opsie om punt-tot-punt-enkripsie bó verbeterde enkripsie aan gebruikers in die aktiwiteiteksemplaarverstellings vertoon word of nie. Hierdie verstelling affekteer slegs die Moodle-aktiwiteit se eksemplaarverstellings. Selfs al sou jy besluit om altyd die opsie te vertoon, sal die gebruiker steeds punt-tot-punt-enkripsie in Zoom benodig om uiteindelik punt-tot-punt-enkripsie te ontsper.';
$string['encryptiontype_disable'] = 'Versper enkripsietipe-kieser';
$string['encryptiontype_showonlyife2epossible'] = 'Vertoon enkripsietipe-kieser slegs as die gebruiker punt-tot-punt-enkripsie kan gebruik';
$string['end_date_option_after'] = 'Na';
$string['end_date_option_by'] = 'By';
$string['end_date_option_occurrences'] = 'Gebeurtenisse';
$string['enddate'] = 'Einddatum';
$string['endtime'] = 'Eindtyd';
$string['err_downloadicaldisabled'] = 'Die aflaai van Zoom-vergadering iCal-dokument is versper.';
$string['err_downloadicalrecurringempty'] = 'Die aflaai van zoom vergadering iCal lêer is nie moontlik vir hierdie vergadering nie, aangesien dit nie ten minste \'n enkele gebeurtenis bevat nie.';
$string['err_downloadicalrecurringnofixed'] = 'Die aflaai van zoom vergadering iCal lêer is nie moontlik vir hierdie vergadering nie, aangesien dit \'n herhalende vergadering is sonder vaste tyd.';
$string['err_duration_nonpositive'] = 'Die tydsduur moet positief wees.';
$string['err_duration_too_long'] = 'Die tydsduur kan nie 150 uur oorskry nie.';
$string['err_end_date'] = 'Herhaling einddatum kan nie in die verlede wees nie';
$string['err_end_date_before_start'] = 'Herhaling einddatum kan nie voor begindatum wees nie';
$string['err_invalid_password'] = 'Wagkode bevat ongeldige karakters.';
$string['err_long_timeframe'] = 'Versoekte tydraamwerk is te lank, resultate van laaste maand in omvang word vertoon.';
$string['err_password'] = 'Wagkode mag slegs die volgende karakters bevat: [a-z A-Z 0-9 @ - _ *]. Maks. 10 karakters.';
$string['err_password_required'] = 'Wagkode word vereis.';
$string['err_repeat_monthly_interval'] = 'Maksimum interval vir maandelikse vergadering is 3 maande';
$string['err_repeat_weekly_interval'] = 'Maksimum interval vir weeklikse vergadering is 12 weke';
$string['err_start_time_past'] = 'Die aanvangsdatum kan nie in die verlede wees nie.';
$string['err_start_time_past_recurring'] = 'Vir herhalende vergaderings is die datumgedeelte van hierdie veld die vroegste moontlike datum vir die volgende vergadering. Hierdie datum moet vandag of in die toekoms wees.';
$string['err_weekly_days'] = 'Kies dag (e) vir die herhalende weeklikse vergadering';
$string['erroraddinstance'] = 'Kon nie \'n nuwe Zoom-vergadering skep nie. Ongeldige opsies gekies vir \'n herhalende vergadering.';
$string['errorwebservice'] = 'Zoom-webdiensfout: {$a}';
$string['errorwebservice_badrequest'] = 'Zoom het \'n slegte versoek ontvang: {$a}';
$string['errorwebservice_notfound'] = 'Die hulpbron bestaan nie';
$string['export'] = 'Voer uit';
$string['externaluser'] = 'Eksterne gebruiker';
$string['firstjoin'] = 'Kan eers aansluit';
$string['firstjoin_desc'] = 'Die vroegste wat \'n gebruiker by \'n geskeduleerde vergadering kan aansluit (minute voor aanvang).';
$string['getmeetingrecordings'] = 'Kry vergadering opnames van Zoom';
$string['getmeetingreports'] = 'Verkry vergaderingverslag van Zoom';
$string['globalsettings'] = 'Globale verstellings';
$string['globalsettings_desc'] = 'Hierdie verstellings is van toepassing op die Zoom-invoegtoepassing in geheel.';
$string['host'] = 'Gasheer';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166">Alternatiewe Gashere</a> kan Zoom-vergaderings begin en die Wagkamer bestuur.';
$string['indicator:cognitivedepth'] = 'Zoom-kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanduider is gebaseer op die kognitiewe diepte wat deur die student in \'n Zoom-aktiwiteit bereik is.';
$string['indicator:socialbreadth'] = 'Zoom-sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanduider is gebaseer op die sosiale breedte wat deur die student in \'n Zoom-aktiwiteit bereik is.';
$string['invalid_status'] = 'Status ongeldig, kontroleer die databasis.';
$string['invalidscheduleuser'] = 'Jy kan nie vir die gespesifiseerde gebruiker skeduleer nie.';
$string['invitation_dialin'] = 'Inbelpatroon';
$string['invitation_dialin_help'] = 'Die regex-patroon om die Zoom-vergadering se inbelnommers te vind.';
$string['invitation_h323'] = 'H.323-boodskappatroon';
$string['invitation_h323_help'] = 'Die regex-patroon om die Zoom-vergadering H.323-inligting te vind. As u uitnodigings nie SIP- of H.323-elemente bevat nie, stel die ooreenstemmende gewone uitdrukkingspatroon op \'n leë string. (Dit geld veral vir bedieners met ontfouting geaktiveer, omdat dit die formaat van spesiale lêertipes soos die iCal-uitvoer kan breek.)';
$string['invitation_icallink'] = 'iCal skakel boodskap patroon';
$string['invitation_icallink_help'] = 'Die regex-patroon om die Zoom-vergadering iCal-skakel te vind.';
$string['invitation_invite'] = 'Uitnodigingsboodskappatroon';
$string['invitation_invite_help'] = 'Die regex-patroon om die Zoom-vergadering se bekendstellingsboodskap te vind';
$string['invitation_joinurl'] = 'Sluit aan-URL-patroon';
$string['invitation_joinurl_help'] = 'Die regex-patroon om die Zoom-vergadering Sluit aan-url te vind.';
$string['invitation_onetapmobile'] = 'Een-tik-mobiele patroon';
$string['invitation_onetapmobile_help'] = 'Die regex-patroon om die Zoom-vergadering een-tik-mobiel se besonderhede te vind.';
$string['invitation_sip'] = 'SIP-patroon';
$string['invitation_sip_help'] = 'Die regex-patroon om die Zoom-vergadering SIP-inligting te vind. As u uitnodigings nie SIP- of H.323-elemente bevat nie, stel die ooreenstemmende gewone uitdrukkingspatroon op \'n leë string. (Dit geld veral vir bedieners met ontfouting geaktiveer, omdat dit die formaat van spesiale lêertipes soos die iCal-uitvoer kan breek.)';
$string['invitationmatchnotfound'] = 'Geen bypassing in Zoom-uitnodiging vir element "{$a->element}" met patroon "{$a->pattern}" gevind nie.';
$string['invitationmodificationfailed'] = 'Fout in regex vir Zoom-uitnodigingelement "{$a->element}" met patroon "{$a->pattern}"';
$string['invitationregex'] = 'Zoom-uitnodiging-regex en -vermoëns';
$string['invitationregex_help'] = 'Definieer die regex-patrone om elke deel van \'n Zoom-uitnodiging te isoleer, sodat die inligting deur die vermoëns beheer kan word.';
$string['invitationregex_nohideif'] = 'Let asseblief: Die regex-patrone sal slegs gebruik word as die \'{$a}\' verstelling ontsper is.';
$string['invitationregexenabled'] = 'Ontsper Zoom-uitnodiging-regex en -vermoëns';
$string['invitationregexenabled_help'] = 'Wanneer ontsper, sal die Zoom-uitnodiging wat in die aktiwiteit vertoon word, in elemente verdeel word deur die volgende regex te gebruik, en vermoëns sal gebruik word om te besluit watter dele om aan elke gebruiker te vertoon. Sien zoom/viewjoinurl en zoom/viewdialin-vermoëns.';
$string['invitationremoveicallink'] = 'Verwyder zoom uitnodiging iCal skakel';
$string['invitationremoveicallink_help'] = 'As dit geaktiveer is, sal die iCal-skakel wat by die zoomvergadering-e-posboodskap ingesluit kan word, gestroop word met behulp van die invitation_icallink regex-patroon.';
$string['invitationremoveinvite'] = 'Verwyder Zoom-uitnodiging uitnodigingsboodskap';
$string['invitationremoveinvite_help'] = 'Indien ontsper, sal die bekendstellingsin in die Zoom-vergadering se e-posboodskap verwyder word deur die invitiation_invite regex-patroon te gebruik.';
$string['join'] = 'Sluit aan';
$string['join_meeting'] = 'Sluit by Vergadering aan';
$string['joinbeforehost'] = 'Sluit voor gasheer by vergadering aan';
$string['joinbeforehostenable'] = 'Laat deelnemers enige tyd aansluit';
$string['joinlink'] = 'Aansluitingskakel';
$string['jointime'] = 'Aansluitingstyd';
$string['leavetime'] = 'Tyd wat vergadering verlaat is';
$string['licenseonjoin'] = 'Kies hierdie opsie as jy wil hê dat die gasheer \'n lisensie ontvang met die begin van die vergadering, <i>asook</i> met die skepping.';
$string['licensesettings'] = 'Lisensieverstellings';
$string['licensesettings_desc'] = 'Hierdie verstellings definieer hoe Moodle jou Zoom-lisensie hanteer.';
$string['licensesnumber'] = 'Aantal lisensies';
$string['lowlicenses'] = 'As jou aantal lisensies dié wat vereis word, oorskry, sal daar \'n PRO-lisensie aan toegeken word deur die status van \'n ander gebruiker te verlaag, met elke nuwe aktiwiteit wat jy vir \'n gebruiker skep. Die opsie is doeltreffend wanneer die aantal aktiewe PRO-lisensies meer as 5 is.';
$string['maskparticipantdata'] = 'Versteek deelnemerdata';
$string['maskparticipantdata_help'] = 'Verhoed dat deelnemerdata in verslae verskyn (nuttig vir werwe wat deelnemerdata versteek, bv. vir HIPAA).';
$string['media'] = 'Media';
$string['meeting_finished'] = 'Voltooi';
$string['meeting_invite'] = 'Foon-/Inbel-inligting';
$string['meeting_invite_hide'] = 'Versteek uitnodiging na vergadering';
$string['meeting_invite_show'] = 'Vertoon uitnodiging na vergadering';
$string['meeting_nonexistent_on_zoom'] = 'Bestaan nie op Zoom nie';
$string['meeting_not_started'] = 'Nie begin nie';
$string['meeting_started'] = 'Aan die gang';
$string['meeting_time'] = 'Aanvangstyd';
$string['meetingcapacitywarning'] = 'Waarskuwing: Vergaderingkapasiteit';
$string['meetingcapacitywarning_desc'] = 'Met hierdie verstelling kan jy \'n waarskuwingskennisgewing vertoon as daar meer aktiewe en ingeskrewe deelnemers in die kursus is as wat die gasheer se Zoom-lisensie se vergaderingkapasiteit is. Die kennisgewing sal aan die gasheer (en alternatiewe gashere) vertoon word op die Zoom-aktiwiteitoorsigblad. Dit sal aanraai dat die gasheer die Zoom-rekeninghouer versoek om \'n groter Zoom-lisensie te kry, indien nodig. Jy kan hierdie boodskap deur Moodle se taaldoelmaking verander.';
$string['meetingcapacitywarning_disable'] = 'Versper Vergaderingkapasiteit waarskuwing';
$string['meetingcapacitywarning_enable'] = 'Ontsper vergaderingkapasiteit waarskuwing';
$string['meetingcapacitywarningbodyalthost'] = 'Die Zoom-lisensie van hierdie vergadering se gasheer, {$a->hostname}, het \'n kapasiteit van <strong>{$a->meetingcapacity} deelnemers</strong>, maar hierdie kursus het <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} ingeskrewe en aktiewe deelnemers</a></strong>.';
$string['meetingcapacitywarningbodyrealhost'] = 'Jou Zoom-lisensie het \'n kapasiteit van <strong><a href="{$a->zoomprofileurl}" target="_blank">{$a->meetingcapacity} deelnemers</a></strong>, maar hierdie kursus het <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} ingeskrewe en aktiewe deelnemers</a></strong>.';
$string['meetingcapacitywarningcontactalthost'] = 'Versoek asseblief die gasheer om die Zoom-rekeninghouer te vra om \'n groter Zoom-lisensie te kry as al hierdie kursusdeelnemers by die vergadering moet aansluit.';
$string['meetingcapacitywarningcontactrealhost'] = 'Versoek asseblief die Zoom-rekeninghouer om \'n groter Zoom-lisensie te kry as al hierdie kursusdeelnemers by die vergadering moet aansluit.';
$string['meetingcapacitywarningheading'] = 'Vergaderingkapasiteit waarskuwing';
$string['meetingparticipantsdeleted'] = 'Vergadering deelnemers gebruikersdata uitgevee.';
$string['meetingrecordingviewsdeleted'] = 'Vergadering opname gebruikersaansig data uitgevee.';
$string['modulename'] = 'Zoom-vergadering';
$string['modulename_help'] = 'Zoom is \'n video- en webkonferensieplatform, wat gemagtigde gebruikers die vermoë gee om aanlyn vergaderings aan te bied.';
$string['modulenameplural'] = 'Zoom-vergaderings';
$string['month'] = 'Maand (e)';
$string['month_day_text'] = 'van die maand';
$string['newmeetings'] = 'Nuwe Vergaderings';
$string['nextoccurrence'] = 'Volgende gebeurtenis';
$string['nomeetinginstances'] = 'Geen sessies vir hierdie vergadering gevind nie.';
$string['nooccurrenceleft'] = 'Die laaste gebeurtenis is reeds verby';
$string['noparticipants'] = 'Geen deelnemers vir hierdie sessie op hierdie tyd gevind nie.';
$string['norecordings'] = 'Geen opnames is tans vir hierdie vergadering gevind nie.';
$string['norooms'] = 'Geen Kamers';
$string['nosessions'] = 'Geen sessies vir \'n gespesifiseerde bestek gevind nie.';
$string['nozooms'] = 'Geen veraderings';
$string['nozoomsfound'] = 'Geen vergaderings vir die gegewe kursus gevind nie.';
$string['occurson'] = 'Kom voor op';
$string['off'] = 'Af';
$string['oldmeetings'] = 'Afgehandelde Vergaderings';
$string['on'] = 'Aan';
$string['option_allow_recording_change'] = 'Laat opname veranderings toe';
$string['option_allow_recording_change_help'] = 'Laat die gebruiker toe om die opname-opstelling tydens die skeppingstyd van aktiwiteit te verander';
$string['option_audio'] = 'Oudio-opsies';
$string['option_audio_help'] = 'Met hierdie opsie kan jy gebruikers toelaat om in te bel deur slegs Telefoon, slegs Rekenaaroudio, of beide, te gebruik.';
$string['option_authenticated_users'] = 'Vereis magtiging om aan te sluit';
$string['option_authenticated_users_help'] = 'Deur hierdie opsie te ontsper word vereis dat alle aanwesiges met hul gemagtigde zoom-rekening inteken om by die vergadering te kan aansluit. Dit hou hoegenaamd <em>nie</em> verband met intekening op Moodle nie.';
$string['option_auto_recording'] = 'Outomatiese opname';
$string['option_auto_recording_help'] = 'As u hierdie opsie aktiveer, sal die vergadering outomaties opgeneem word';
$string['option_encryption_type'] = 'Enkripsie';
$string['option_encryption_type_endtoendencryption'] = 'Punt-tot-punt-enkripsie';
$string['option_encryption_type_enhancedencryption'] = 'Verbeterde enkripsie';
$string['option_encryption_type_help'] = 'Met hierdie opsie beheer jy die vlak van enkripsie en privaatheid van hierdie vergadering.\\n\\n*Verbeterde enkripsie* beteken dat die enkripsiesleutel in die Zoom-wolk geberg word.\\n\\n*Punt-tot-punt-enkripsie* beteken dat die enkripsiesleutel op jou plaaslike toestel geberg word en niemand anders jou enkripsiesleutel kan verkry nie, nie eens Zoom nie.\\n\\nLet asseblief daarop dat, wanneer jy punt-tot-punt-enkripsie ontsper, etlike funksies nie vanuit die vergadering beskikbaar sal wees nie - [Sien besonderhede in die Zoom-dokumentasie](https://support.zoom.us/hc/en-us/articles/360048660871).';
$string['option_host_video'] = 'Gasheervideo';
$string['option_host_video_help'] = 'Deur hierdie opsie te ontsper, sal die gasheer se video ontsper wanneer hy/sy by die vergadering aansluit. Selfs al kies jy \'af\', sal die gasheer die opsie hê om sy/haar video aan te skakel.';
$string['option_jbh'] = 'Sluit voor gasheer aan';
$string['option_jbh_help'] = 'Deur hierdie opsie te ontsper, word aanwesiges toegelaat om by die vergadering aan te sluit voordat die gasheer daar is, of wanneer die gasheer nie die vergadering kan bywoon nie.\\n\\nHierdie opsie is onverenigbaar met die \'Wagkamer\'-opsie, dus sal die kies van een die ander versper.';
$string['option_mute_upon_entry'] = 'Demp deelnemers met ingang';
$string['option_mute_upon_entry_help'] = 'Deur hierdie opsie te ontsper, sal alle deelnemers outomaties gedemp word wanneer hulle by die vergadering aansluit. Deelnemers kan hulself ontdemp nadat hulle by die vergadering aangesluit het.';
$string['option_participants_video'] = 'Deelnemervideo';
$string['option_participants_video_help'] = 'Deur hierdie opsie te ontsper, sal die deelnemers se video ontsper word wanneer hulle by die vergadering aansluit. Selfs al kies jy \'af\', sal die deelnemers die opsie hê om hul video aan te skakel.';
$string['option_proxyhost'] = 'Gebruik proxy';
$string['option_proxyhost_desc'] = 'Die proxy wat hier gestel is as \'<code>&lt;hostname&gt;:&lt;port&gt;</code>\' word slegs vir kommunikasie met Zoom gebruik. Laat leeg om die Moodle verstek proxyverstellings te gebruik. Jy hoef dit slegs te stel as jy nie \'n globale proxy in Moodle wil stel nie.';
$string['option_view_recordings'] = 'Laat opnames besigtig word';
$string['option_waiting_room'] = 'Wagkamer';
$string['option_waiting_room_help'] = 'Deur hierdie opsie te ontsper, word die gasheer toegelaat om te beheer wanneer \'n deelnemer by die vergadering aansluit.\\n\\nHierdie opsie is onverenigbaar met die \'Sluit aan voor gasheer\'-opsie, dus sal die kies van een die ander versper.';
$string['participantdatanotavailable'] = 'Besonderhede is nie beskikbaar nie';
$string['participantdatanotavailable_help'] = 'Deelnemerdata is nie vir hierdie Zoom-sessie beskikbaar nie (bv. weens HIPAA-nakoming).';
$string['participantgroups'] = 'Deelnemers groepe';
$string['participants'] = 'Deelnemers';
$string['password'] = 'Wagkode';
$string['password_allowed_char'] = 'Wagkode mag slegs die volgende karakters bevat: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = '\'n Maksimum van {$a} opeenvolgende karakters (abcd, 1111, 1234, ens.).';
$string['password_length'] = '\'n Minimum van {$a} karakter(s).';
$string['password_letter'] = 'Wagkode moet minstens 1 letter bevat.';
$string['password_lower_upper'] = 'Wagkode moet beide klein- en hoofletters bevat.';
$string['password_max_length'] = '\'n Maksimum van 10 karakters.';
$string['password_number'] = 'Wagkode moet minstens 1 getal bevat.';
$string['password_only_numeric'] = 'Wagkode mag slegs getalle en geen ander karakters bevat nie.';
$string['password_special'] = 'Wagkode moet minstens 1 spesiale karakter bevat (@-_*).';
$string['passwordprotected'] = 'Wagkodebeskermd';
$string['pluginadministration'] = 'Bestuur Zoom-vergadering';
$string['pluginname'] = 'Zoom-vergadering';
$string['privacy:metadata:zoom_breakout_participants'] = 'Die databasis tabel om \'n lys van zoom ontmoetings uitbreek kamers deelnemers te stoor';
$string['privacy:metadata:zoom_breakout_participants:userid'] = 'Die ID van die deelnemer gebruiker';
$string['privacy:metadata:zoom_meeting_details'] = 'Die databasistabel wat inligting oor elke vergaderingeksemplaar berg.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Die naam van die vergadering wat die gebruiker bygewoon het.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Die databasistabel wat inligting oor vergaderingdeelnemers berg.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Hoe lank die deelnemer in die vergadering was';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Die tydstip waarop die deelnemer by die vergadering aangesluit het';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Die tydstip waarop die deelnemer die vergadering verlaat het';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Die naam van die deelnemer';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'Die e-pos van die deelnemer';
$string['privacy:metadata:zoom_meeting_view'] = 'Die databasis tabel om gebruikers op te spoor wat die opnames van die vergadering sien';
$string['privacy:metadata:zoom_meeting_view:userid'] = 'Die ID van die gebruiker wat die opname gekyk het';
$string['recording'] = 'Opname';
$string['recordingadd'] = 'Voeg opname by';
$string['recordingdate'] = 'Opname datum';
$string['recordingdelete'] = 'Is u seker dat u die opname wil uitvee? "{$a}"?';
$string['recordinghide'] = 'Versteek opname (tans sigbaar)';
$string['recordinglink'] = 'Opname skakel';
$string['recordingname'] = 'Titel';
$string['recordingnotfound'] = 'Opname kon nie gevind word nie';
$string['recordingnotvisible'] = 'Opname is nie sigbaar nie. Kontak u stelseladministrateur as u van mening is dat dit \'n fout is';
$string['recordingpasscode'] = 'Opname Wagwoord';
$string['recordings'] = 'Opnames';
$string['recordingshow'] = 'Wys opname (tans versteek)';
$string['recordingshowtoggle'] = 'Wissel Wys Opname';
$string['recordingurl'] = 'Opname URL';
$string['recordingview'] = 'Bekyk Opnames';
$string['recordingvisibility'] = 'Is opnames vir hierdie vergadering standaard sigbaar?';
$string['recordingvisibility_help'] = 'Wanneer nuwe opnames vir hierdie vergadering gehaal word, moet dit by standaard in Moodle sigbaar wees?';
$string['recreatesuccessful'] = 'Vergadering is suksesvol herskep';
$string['recurrence_option_daily'] = 'Daagliks';
$string['recurrence_option_monthly'] = 'Maandeliks';
$string['recurrence_option_no_time'] = 'Geen Vaste Tyd';
$string['recurrence_option_weekly'] = 'Weekliks';
$string['recurrencetype'] = 'Herhaling';
$string['recurringmeeting'] = 'Herhalende vergadering';
$string['recurringmeeting_help'] = 'Deur hierdie opsie te ontsper, sal die vergadering \'n herhalende vergadering sonder \'n einddatum of -tyd gemaak word. Dan kan dit te eniger tyd binnegegaan word.';
$string['recurringmeetingexplanation'] = 'Die vergadering het nie \'n einddatum of -tyd nie.';
$string['recurringmeetinglong'] = 'Herhalende vergadering (vergadering sonder einddatum of -tyd)';
$string['recurringmeetingthisis'] = 'Hierdie is \'n herhalende vergadering';
$string['recycleonjoin'] = 'Herbruik lisensie met aansluiting';
$string['redefinelicenses'] = 'Herdefinieer lisensies';
$string['refreshreports'] = 'Verfris sessieverslae';
$string['repeatinterval'] = 'Herhaal elke';
$string['report'] = 'Verslae';
$string['reportapicalls'] = 'Verslag API-oproepe uitgeput';
$string['requirepasscode'] = 'Vereis vergadering-wagkode';
$string['requirepasscode_help'] = 'Deur hierdie opsie te ontsper, sal vereis dat die gasheer \'n wagkode vir die vergadering stel. Daar sal van aansluitende deelnemers vereis word om dit in te voer voordat hulle by die vergadering aansluit. Deelnemers wat die vergadering deur die Moodle-aktiwiteit ingaan, hoef nie hierdie wagkode in te voer nie.';
$string['resetapicalls'] = 'Herstel die aantal beskikbare API-oproepe';
$string['resetzoomsall'] = 'Vee alle gebruikersgrade uit, teken gebruikersaansigdata op en ontmoeting deelnemers se gebruikersdata.';
$string['room'] = 'Kamer';
$string['roomname'] = 'Kamer naam';
$string['rooms'] = 'Kamers';
$string['schedule'] = 'Skeduleer';
$string['schedulefor'] = 'Skeduleer vergadering vir';
$string['schedulefor_help'] = 'Jy kan vergaderings namens \'n ander gebruiker skeduleer. As voorvereiste moet hierdie gebruiker skeduleringsvoorreg in Zoom aan jou toegewys het. Die gekose gebruiker sal die gasheer van die vergadering wees en sal die een wees wie se Zoom-lisensie vir die vergadering gebruik sal word.';
$string['scheduleforself'] = 'Jouself';
$string['schedulingprivilege'] = 'Skeduleringsvoorreg';
$string['schedulingprivilege_desc'] = 'Met hierdie verstelling kan jy beheer of die skeduleringsvoorregopsie aan gebruikers in die aktiwiteiteksemplaarverstellings vertoon word of nie. Hierdie verstelling affekteer slegs die Moodle-aktiwiteiteksemplaarverstellings. Selfs al sou jy besluit om die opsie te vertoon, moet die skeduleringsvoorreg steeds aan die gebruiker deur \'n ander gebruiker in Zoom toegeken word, om uiteindelik \'n vergadering names die ander gebruiker te kan skeduleer.';
$string['schedulingprivilege_disable'] = 'Versper skeduleringsvoorregopsie';
$string['schedulingprivilege_enable'] = 'Ontsper skeduleringsvoorregopsie';
$string['search:activity'] = 'Zoom - aktiwiteitinligting';
$string['security'] = 'Sekuriteit';
$string['selectionarea'] = 'Geen keuse nie';
$string['sessions'] = 'Sessies';
$string['sessionsreport'] = 'Sessieverslag';
$string['sesskeyinvalid'] = 'Ongeldige sessie opgespoor. Kan nie verder gaan nie.';
$string['setpasscode'] = 'Stel wagkode';
$string['showmedia'] = 'Wys Media-afdeling';
$string['showmedia_help'] = 'As u hierdie opsie aktiveer, sal die Media-afdeling op die vergaderingaktiwiteitsbladsy verskyn.';
$string['showmediaonview'] = 'Wys Media-afdeling op ontmoetingsblad';
$string['showschedule'] = 'Wys Skedule-afdeling';
$string['showschedule_help'] = 'As u hierdie opsie aktiveer, sal die skedule-afdeling op die vergaderingaktiwiteitbladsy verskyn.';
$string['showscheduleonview'] = 'Wys Skedule-afdeling op ontmoetingsblad';
$string['showsecurity'] = 'Wys Sekuriteit afdeling';
$string['showsecurity_help'] = 'As u hierdie opsie aktiveer, sal u die Sekuriteit afdeling op die bladsy vir vergaderingaktiwiteit wys.';
$string['showsecurityonview'] = 'Wys sekuriteit afdeling op vergaderbladsy';
$string['start'] = 'Begin';
$string['start_meeting'] = 'Begin Vergadering';
$string['start_time'] = 'Wanneer';
$string['starthostjoins'] = 'Begin video wanneer gasheer aansluit';
$string['startpartjoins'] = 'Begin video wanneer deelnemer aansluit';
$string['starttime'] = 'Aanvangstyd';
$string['status'] = 'Status';
$string['supplementaryfeaturessettings'] = 'Aanvullende funksieverstellings';
$string['supplementaryfeaturessettings_desc'] = 'Hierdie verstellings beheer of en hoe aanvullende Zoom-funksies aan die gebruikers verskaf word.';
$string['title'] = 'Titel';
$string['topic'] = 'Onderwerp';
$string['trackingfields'] = 'Opsporing velde';
$string['trackingfields_help'] = 'Voer die opsporingsveldnaam (s) / etiket (e) in, geskei deur kommas, om Zoom -aktiwiteite moontlik te maak.';
$string['trackingfields_recommendedvalues'] = 'Aanbeveelde waardes:';
$string['unavailable'] = 'Jy kan nie nou aansluit nie.';
$string['unavailablefinished'] = 'Die vergadering is reeds verby.';
$string['unavailablefirstjoin'] = 'Jy kan op die vroegste {$a->mins} minute voor die geskeduleerde aanvangstyd aansluit.';
$string['unavailablenotstartedyet'] = 'Die vergadering het nog nie begin nie.';
$string['updatemeetings'] = 'Werk vergaderingverstellings van Zoom by';
$string['updatetrackingfields'] = 'Dateer die opsporing van veldinstellings vanaf Zoom op';
$string['usepersonalmeeting'] = 'Gebruiker persoonlike vergadering-ID {$a}';
$string['waitingroom'] = 'Wagkamer';
$string['waitingroomenable'] = 'Ontsper wagkamer';
$string['webinar'] = 'Webinaar';
$string['webinar_already_false'] = '<p><b>Hierdie module is reeds as \'n vergadering gestel, nie as webinaar nie. Jy kan nie hierdie verstelling tokkel ná die vergadering geskep is nie.</b></p>';
$string['webinar_already_true'] = '<p><b>Hierdie module is reeds as \'n webinaar gestel, nie as vergadering nie. Jy kan nie hierdie verstelling tokkel ná die vergadering geskep is nie.</b></p>';
$string['webinar_alwaysshow'] = 'Vertoon altyd webinaaropsie, ongeag of die gebruiker \'n lisensie het om webinare aan te bied.';
$string['webinar_by_default'] = 'Webinaar by verstek';
$string['webinar_by_default_desc'] = 'Skep Zoom-instansie as \'n webinar as standaard.';
$string['webinar_desc'] = 'Met hierdie verstelling kan jy beheer of die opsie om \'n webinaar te skep aan gebruikers tydens die skep van \'n vergadering vertoon word of nie. Hierdie verstelling affekteer slegs die Moodle-aktiwiteiteksemplaarverstellings. Selfs al sou jy besluit om die opsie altyd te vertoon, sal die gebruiker steeds \'n geldige lisensie vir webinare benodig om uiteindelik \'n webinaar te kan aanbied.';
$string['webinar_disable'] = 'Versper webinare';
$string['webinar_help'] = 'Webinare bied aan gashere verbeterde beheer en beweeglikheid vir die aanbied van vergaderings met groter gehore.\\n\\nHierdie opsie is slegs aan vooraf gemagtigde Zoom-rekeninge beskikbaar.';
$string['webinar_showonlyiflicense'] = 'Vertoon webinaaropsie slegs as die gebruiker \'n lisensie het om webinare aan te bied';
$string['webinarthisis'] = 'Hierdie is \'n webinaar';
$string['week'] = 'Week(e)';
$string['weekoption_first'] = 'Eerste';
$string['weekoption_fourth'] = 'Vierde';
$string['weekoption_last'] = 'Laaste';
$string['weekoption_second'] = 'Tweede';
$string['weekoption_third'] = 'Derde';
$string['zoom:addinstance'] = 'Voeg \'n nuwe Zoom-vergadering by';
$string['zoom:eligiblealternativehost'] = 'Kan gekies word as alternatiewe gasheer binne Zoom-vergaderings';
$string['zoom:refreshsessions'] = 'Verfris Zoom-vergaderingverslae';
$string['zoom:view'] = 'Besigtig Zoom-vergaderings';
$string['zoom:viewdialin'] = 'Besigtig Zoom-inskakelinligting';
$string['zoom:viewjoinurl'] = 'Besigtig Zoom-aansluit-url';
$string['zoomerr'] = '\'n Fout het met Zoom voorgekom.';
$string['zoomerr_alternativehostusernotfound'] = 'Gebruiker {$a} is nie op Zoom gevind nie.';
$string['zoomerr_apilimit'] = 'Die maksimum daaglikse koersbeperking vir hierdie API is bereik. Probeer weer om {$a}';
$string['zoomerr_field_missing'] = '{$a} nie gevind nie';
$string['zoomerr_id_missing'] = 'Jy moet \'n kursus_module-ID of eksemplaar-ID spesifiseer';
$string['zoomerr_licensesnumber_missing'] = 'Zoom se hoogste verstelling is gevind, maar lisensienommerverstelling is nie gevind nie';
$string['zoomerr_maxretries'] = 'Het {$a->maxretries} keer probeer om die oproep te maak, maar het misluk: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Hierdie vergadering kan nie op Zoom gevind word nie. Jy kan dit <a href="{$a->recreate}">hier herskep</a> of <a href="{$a->delete}">dit heeltemal uitwis</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Hierdie vergadering kan nie op Zoom gevind word nie. Kontak asseblief die gasheer van die vergadering as jy enige vrae het.';
$string['zoomerr_no_access_token'] = 'Geen toegangsteken is teruggestuur nie';
$string['zoomerr_usernotfound'] = 'Jou rekening op Zoom kon nie gevind word nie. As jy Zoom vir die eerste keer gebruik, moet jy jou Zoom-rekening aktiveer deur in te teken by <a href="{$a}" target="_blank">{$a}</a>. Wanneer jy jou Zoom-rekening geaktiveer het, herlaai hierdie bladsy en gaan voort met die opstel van jou vergadering. Andersins moet jy seker maak dat jou e-pos op Zoom ooreenstem met jou e-pos op hierdie stelsel.';
$string['zoomerr_viewrecordings_off'] = 'View Recordings is afgeskakel, die taak kan nie uitgevoer word nie';
$string['zoomurl'] = 'Zoom-tuisblad-URL';
$string['zoomurl_desc'] = '';
