<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'it', version '5.0'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Azioni';
$string['activityoresourceis'] = 'L\'attività o risorsa è {$a}';
$string['addacondition'] = 'Aggiungi condizione';
$string['addarule'] = 'Aggiungi regola';
$string['addinstructions'] = 'Aggiungi altre informazioni';
$string['additionalresources'] = 'Risorse aggiuntive';
$string['addoninstallationerror'] = 'E\' stato rilevato un problema con l\'addon (local_xp), non sembra sia stato installato correttamente. Un amministratore dovrebbe completare l\'installazione.';
$string['addrulesformhelp'] = 'L\'ultima colonna definisce la quantità di punti esperienza ottenuti quando un criterio è soddisfatto.';
$string['admindefaultrulesintro'] = 'Le seguenti regole verranno utilizzate come default nei corsi dove il blocco è stato aggiunto.';
$string['admindefaultsettingsintro'] = 'Le seguenti impostazioni verranno utilizzate come default nei corsi dove il blocco verrà aggiunto. Alcune impostazioni possono essere bloccate, e in tal caso i loro valori saranno forzatamente utilizzati in tutte le istanze del blocco.';
$string['admindefaultvisualsintro'] = 'Le seguenti impostazioni verranno utilizzate come default nei corsi dove il blocco verrà aggiunto.';
$string['anonymity'] = 'Anonimato';
$string['anonymity_help'] = 'Questa impostazione controlla se i partecipanti possono visualizzare i nomi o gli avatar degli altri.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> i punti esperienza sono ottenuti quando:';
$string['basexp'] = 'Base dell\'algoritmo';
$string['blockappearance'] = 'Aspetto del blocco';
$string['cachedef_filters'] = 'Filtri di livello';
$string['cachedef_ruleevent_eventslist'] = 'Elenco di alcuni eventi';
$string['cannotshowblockconfig'] = 'Le impostazioni dell\'aspetto dovrebbero essere visualizzate qui, ma non è stato possibile trovare il blocco. Per modificare l\'aspetto del blocco, torna indietro [qui] ({$ a}) (o dove hai aggiunto il blocco), attiva la modalità di modifica e segui l\'opzione "Configura" nel menu a tendina del blocco. Se non riesci a trovare il blocco, aggiungilo nuovamente al tuo corso.';
$string['cannotshowblockconfigsys'] = 'Le impostazioni dell\'aspetto dovrebbero essere visualizzate qui, ma non è stato possibile trovare il blocco. Potrebbe mancare la [prima pagina] ({$ a-> fp}) e la [dashboard predefinita] ({$ a-> mysys}) dei tuoi utenti, o essere presente in entrambi. Per modificare le impostazioni da questo punto, assicurati che si visualizzi solo in una di esse.';
$string['changelevelformhelp'] = 'Se si modifica il numero dei livelli, i badge di livello personalizzato saranno temporaneamente disattivati per evitare livelli senza badge. Per modificare il conteggio dei livelli vai alla pagina \'Visualizzazioni\' per ri-abilitare i badge personalizzati una volta salvata questa pagina.';
$string['cheatguard'] = 'Controllo degli imbrogli';
$string['clicktoselectcm'] = 'Click per selezionare un\'attività o una risorsa';
$string['cmselector'] = 'Selettore dei moduli del corso';
$string['coefxp'] = 'Coefficiente dell\'algoritmo';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Introduzione';
$string['configdescription_help'] = 'Breve introduzione visualizzata nel blocco, al di sotto del livello dello studente. Gli studenti hanno la possibilità di ignorare il messaggio, e in questo caso non lo visualizzeranno più.';
$string['configheader'] = 'Impostazioni';
$string['configrecentactivity'] = 'Visualizza le assegnazioni di punti esperienza più recenti';
$string['configrecentactivity_help'] = 'Consente di visualizzare  nel blocco un breve elenco degli eventi recenti che hanno assegnato punti esperienza agli studenti.';
$string['configtitle'] = 'Titolo';
$string['configtitle_help'] = 'Il titolo del blocco.';
$string['congratulationsyouleveledup'] = 'Congratulazioni!';
$string['coolthanks'] = 'Fantastico, grazie!';
$string['courselog'] = 'Log del corso';
$string['coursereport'] = 'Report del corso';
$string['courserules'] = 'Regole del corso';
$string['courseselectedcolon'] = 'Corso selezionato:';
$string['coursesettings'] = 'Impostazioni del corso';
$string['coursevisuals'] = 'Visualizzazioni del corso';
$string['customizelevels'] = 'Personalizzazione livelli';
$string['dangerzone'] = 'Zona di pericolo';
$string['defaultlevels'] = 'Livelli di default';
$string['defaultrules'] = 'Regole di default';
$string['defaultrulesformhelp'] = 'Queste sono le regole di default fornite dal plugin, vengono attribuiti punti esperienza di default e vengono ignorati alcuni eventi ridondanti. Le regole configurate ad hoc hanno la precedenza.';
$string['defaultsettings'] = 'Impostazioni di default';
$string['defaultvisuals'] = 'Visualizzazione di default';
$string['deletecondition'] = 'Elimina condizione';
$string['deleterule'] = 'Elimina una regola';
$string['description'] = 'Descrizione';
$string['difference'] = 'Differenza';
$string['discoverlevelupplus'] = 'Scopri Level up! Plus';
$string['dismissnotice'] = 'Rimuovi notifica';
$string['displayeveryone'] = 'Visualizza tutti';
$string['displaynneighbours'] = 'Visualizza {$a} vicini';
$string['displayoneneigbour'] = 'Visualizza un vicino';
$string['displayparticipantsidentity'] = 'Visualizza l\'identità dei partecipanti';
$string['displayrank'] = 'Visualizza posizione';
$string['displayrelativerank'] = 'Visualizza posizione relativa';
$string['documentation'] = 'Documentazione';
$string['editinstructions'] = 'Modifica le informazioni';
$string['enablecheatguard'] = 'Attiva il controllo degli imbrogli';
$string['enablecheatguard_help'] = 'Il controllo degli imbrogli consente di avere un semplice meccanismo di prevenzione di abusi del sistema da parte degli studenti, come il refresh continuo della stessa pagina o la ripetizione continua della stessa azione.

[Maggiori informazioni](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Abilita la pagina delle informazioni';
$string['enableinfos_help'] = 'Selezionando \'No\', gli studenti non visualizzeranno la pagina delle informazioni.';
$string['enableladder'] = 'Abilita classifica';
$string['enableladder_help'] = 'Selezionando \'No\', gli studenti non visualizzeranno la classifica.';
$string['enablelevelupnotif'] = 'Attiva la notifica di salita di livello';
$string['enablelevelupnotif_help'] = 'Selezionando \'Sì\', gli studenti visualizzano un popup di congratulazioni quando raggiungono un nuovo livello.';
$string['enablelogging'] = 'Abilita l\'identificazione';
$string['enablexpgain'] = 'Abilita guadagno di punti';
$string['enablexpgain_help'] = 'Selezionando \'No\', nessuno otterrà punti esperienza nel corso. E\' Utile per bloccare l\'esperienza ottenuta o per attivarla in un determinato momento.

E\' possibile avere un controllo più preciso tramite il privilegio \'block/xp:earnxp\'.';
$string['entersearchterm'] = 'Inserisci un termine da cercare';
$string['errorcontextcoursemismatchforwholesite'] = 'L\'URL della pagina di questo <em>Level up!</em> non corrisponde all\'attuale configurazione del plugin. L\'attuale configurazione implica che <em>Level up!</em> vada usato \'Per l\'intero sito\', ma questa pagina prevede l\'utilizzo \'Per corso\'. <a href="{$a->nexturl}">Clicca qui</a> per aprire la pagina corretta. Cerca per l\'impostazione di amministrazione \'block_xp_context\' se vuoi cambiare la tua configurazione.';
$string['errorcontextcoursemismatchpercourse'] = 'L\'URL della pagina di questo <em>Level up!</em> non corrisponde all\'attuale configurazione del plugin. L\'attuale configurazione implica che <em>Level up!</em> vada usato \'Per corso\', ma questa pagina prevede l\'utilizzo \'Per l\'intero sito\'. Molto probabilmente deriva da un <em>blocco</em> aggiunto nella dashboard o nella home pur avendo un\'altra configurazione. Dovresti rimuovere il blocco da queste pagine e usarlo solamente all\'interno di corsi singoli.';
$string['errorformvalues'] = 'Sono stati rilevati errori nei valori del modulo, devono essere sisteamti.';
$string['errorlevelsincorrect'] = 'Il numero minimo di livelli è 2';
$string['errornotalllevelsbadgesprovided'] = 'Nessun badge di livello è stato inserito. Mancante: {$a}';
$string['errorunknownevent'] = 'Errore: evento sconosciuto';
$string['errorunknownmodule'] = 'Errore: modulo sconosciuto';
$string['errorxprequiredlowerthanpreviouslevel'] = 'I punti richiesti sono minori o uguali ai punti del livello precedente.';
$string['event_user_leveledup'] = 'L\'utente è salito di livello';
$string['eventis'] = 'L\'evento è {$a}';
$string['eventname'] = 'Nome dell\'evento';
$string['eventproperty'] = 'Proprietà dell\'evento';
$string['eventsrules'] = 'Regole degli eventi';
$string['eventsrules_help'] = 'Questo plugin fa uso degli eventi per attribuire punti alle azioni svolte dagli studenti.
Puoi usare la pagina seguente per aggiungere le tue regole e modificare le esistenti.

Si informa di controllare la pagina _Log_ del plugin per identificare quali eventi sono innescati dagli studenti mentre svolgono attività nel corso.

Risorse aggiuntive:

- [Come sono calcolati i punti esperienza?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Regole di risoluzione del problemi](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Data dell\'evento';
$string['filtermodules'] = 'Moduli del filtro';
$string['for1day'] = 'Per un giorno';
$string['for1month'] = 'Per un mese';
$string['for1week'] = 'Per una settimana';
$string['for3days'] = 'Per 3 giorni';
$string['forever'] = 'Per sempre';
$string['forthewholesite'] = 'Per tutto il sito';
$string['give'] = 'dare';
$string['gotofullladder'] = 'Vai alla classifica completa';
$string['grid'] = 'Griglia';
$string['hideparticipantsidentity'] = 'Nascondi identità dei partecipanti';
$string['hiderank'] = 'Nascondi posizione';
$string['incourses'] = 'Nei corsi';
$string['ineffective'] = 'Inefficace';
$string['infos'] = 'Informazioni';
$string['instructions'] = 'Ulteriori informazioni';
$string['invalidxp'] = 'Valore punti non valido';
$string['keeplogs'] = 'Conserva i log';
$string['ladder'] = 'Classifica';
$string['ladderadditionalcols'] = 'Colonne aggiuntive';
$string['ladderadditionalcols_help'] = 'L\'impostazione definisce quali colonne aggiuntive visualizzare nella classifica. Premere il tasto CTRL o CMD mentre si clicca per selezionare più di una colonna o per deselezionarne una già selezionata.';
$string['ladderempty'] = 'La classifica è al momento vuota, ripassa più tardi!';
$string['level'] = 'Livello';
$string['levelbadges'] = 'Badge di livello';
$string['levelbadgesformhelp'] = 'Nomina i file [level].[file extension], per esempio: 1.png, 2.jpg, etc... La dimensione consigliate dell\'immagine è 100x100.';
$string['levelcount'] = 'Numero di livelli';
$string['leveldesc'] = 'Descrizione del livello';
$string['leveldesc_help'] = 'Una breve descrizione del livello, che è mostrata nella pagina Informazioni vicino al livello stesso. Puoi usarlo per descrivere la ricompensa per gli studenti che raggiungono il livello, per includere le istruzioni necessarie a raggiungere questo livello, per descrivere il livello in modo alternativo (es. _Si narra che soltanto le anime più coraggiose abbiano raggiunto questo livello_), ecc...';
$string['levelname'] = 'Nome del livello';
$string['levelname_help'] = 'Un nome abbreviato da visualizzare al posto del valore di default _Level #1_, _Level #2_, ecc. che viene mostrato spesso. Se fornisci dei nomi per alcuni livelli, ti consigliamo di dare un nome a tutti quanti!';
$string['levels'] = 'Livelli';
$string['levelswillbereset'] = 'Attenzione! Salvando questo modulo verrà ricalcolato il livello di tutti!';
$string['levelup'] = 'Sali di livello!';
$string['levelupplus'] = 'Sali di livello! Plus';
$string['levelx'] = 'Livello #{$a}';
$string['likenotice'] = '<strong>Ti piace questo plugin?</strong> Prenditi un momento per <a href="{$a->moodleorg}" target="_blank"> aggiungerlo ai preferiti</a> on Moodle.org e <a href="{$a->github}" target="_blank">votarlo su GitHub</a>.';
$string['limitparticipants'] = 'Limita visualizzazione partecipanti';
$string['limitparticipants_help'] = 'L\'impostazione controlla chi è visualizzato nella classifica. I vicini sono i partecipanti posizionati sopra o sotto l\'utente corrente. Per esempio, quando scegli \'Visualizza due vicini\', solo i due partecipanti posizionati esattamente sopra e sotto l\'utente corrente nella classifica saranno visualizzati.';
$string['list'] = 'Lista';
$string['logging'] = 'Logging';
$string['manually'] = 'Manualmente';
$string['maxactionspertime'] = 'Numero massimo di azioni permesse in questo intervallo di tempo';
$string['maxactionspertime_help'] = 'Numero massimo di azioni che consentiranno di ottenere punti durante l\'intervallo di tempo dato. Ogni altra azione sarà ignorata.';
$string['movecondition'] = 'Sposta condizione';
$string['moverule'] = 'Sposta regola';
$string['name'] = 'Nome';
$string['navinfos'] = 'Informazioni';
$string['navladder'] = 'Classifica';
$string['navlevels'] = 'Livelli';
$string['navlog'] = 'Log';
$string['navpromo'] = 'Plus';
$string['navreport'] = 'Report';
$string['navrules'] = 'Regole';
$string['navsettings'] = 'Impostazioni';
$string['navvisuals'] = 'Visualizzazione';
$string['nodescription'] = 'Nessuna descrizione';
$string['nologsrecordedyet'] = 'I log non sono ancora stati registrati.';
$string['noname'] = 'Nessun nome';
$string['notesomesettingslocked'] = 'Da notare che alcune impostazioni potrebbero non essere modificabili se sono state bloccate da un amministratore.';
$string['participant'] = 'Partecipante';
$string['participatetolevelup'] = 'Partecipa al corso per ottenere punti esperienza e salire di livello!';
$string['perpagecolon'] = 'Per pagina:';
$string['pickaconditiontype'] = 'Scegli un tipo di condizione';
$string['pluginname'] = 'Sali di livello!';
$string['pluginsoutofsync'] = '_Il plugin non è sincronizzato!_

Questo significa che hai aggiornato _Sali di livello!_ ma non _Sali di livello! Plus_. Anche se noi facciamo del nostro meglio per prevenire problemi, alcune funzionalità potrebbero non funzionare correttamente, compreso lo stesso _Sali di livello!_. Raccomandiamo di aggiornare _Sali di livello! Plus_ all\'ultima version. [Approfondisci] ({$a->url})';
$string['pointsintimelinker'] = 'per';
$string['pointsrequired'] = 'Punti esperienza richiesti';
$string['privacy:metadata:log'] = 'Memorizza log degli eventi';
$string['privacy:metadata:log:eventname'] = 'Il nome dell\'evento';
$string['privacy:metadata:log:time'] = 'La data dell\'evento';
$string['privacy:metadata:log:userid'] = 'L\'utente che ha ottenuto i punti esperienza';
$string['privacy:metadata:log:xp'] = 'I punti esperienza ottenuti per l\'evento';
$string['privacy:metadata:prefintro'] = 'Registra se l\'utente ha ignorato l\'introduzione al blocco';
$string['privacy:metadata:prefladderpagesize'] = 'La dimensione della pagina preferita  dall\'utente durante la visione della classifica';
$string['privacy:metadata:preflevelup'] = 'Registra se l\'utente deve visualizzare la notifica di "Sali di livello!"';
$string['privacy:metadata:prefnotices'] = 'Registra se l\'utente ha chiuso l\'avviso sul supporto';
$string['privacy:metadata:prefseenpromo'] = 'Registra quando l\'utente ha visualizzato la pagina promozionale';
$string['privacy:metadata:xp'] = 'Memorizza i punti e il livello degli utenti';
$string['privacy:metadata:xp:lvl'] = 'Il livello dell\'utente';
$string['privacy:metadata:xp:userid'] = 'L\'utente';
$string['privacy:metadata:xp:xp'] = 'I punti dell\'utente';
$string['privacy:path:addon'] = 'Componente aggiuntivo';
$string['privacy:path:level'] = 'Livello';
$string['privacy:path:logs'] = 'Log';
$string['progress'] = 'Avanzamento';
$string['progressbar'] = 'Barra di avanzamento';
$string['promocheatguard'] = 'Questo controllo degli imbrogli non è progettato per gestire lunghi intervalli di tempo. Per favore considera l\'aggiornamento a _Sali di livello! Plus_ per sbloccare l\'utilizzo di intervalli di tempo maggiori e altre funzionalità.<a href="{$a->url}">Approfondisci qui</a>.';
$string['promocontactintro'] = 'Contattaci per maggiori informazioni. Non mordiamo e rispondiamo in breve tempo!';
$string['promocontactus'] = 'Contattaci';
$string['promoemailusat'] = 'Inviaci un\'email a _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ahia! Non è stato possibile inviare il messaggio...per favore, invia un\'e-mail direttamente a {$a}. Grazie!';
$string['promoifpreferemailusat'] = 'Psst! Se preferisci, invia direttamente un\'e-mail a _{$a}_.';
$string['promointro'] = 'Il componente aggiuntivo di _Sali di livello!_ che sprigiona tutto il suo potenziale!';
$string['promointroinstalled'] = 'L\'add-on _Sali di livello! Plus_ è installato nel tuo sistema e tutte le sue funzionalità sono state attivate.';
$string['promorulesdidyouknow'] = 'Lo sai che con <em>_Sali di livello! Plus_</em> gli studenti possono ricevere punti per il <em>completamento</em> dei <em>corsi</em> e delle <em>attività</em>, o anche ricevere punti in base alle loro <em>valutazioni</em>? <a href="{$a->url}">Approfondisci qui</a>.';
$string['promoyourmessagewassent'] = 'Grazie, il tuo messaggio è stato inviato. Ti risponderemo al più presto.';
$string['property:action'] = 'Azione dell\'evento';
$string['property:component'] = 'Componente dell\'evento';
$string['property:crud'] = 'Evento CRUD';
$string['property:eventname'] = 'Nome dell\'evento';
$string['property:target'] = 'Obiettivo dell\'evento';
$string['rank'] = 'Posizione';
$string['ranking'] = 'Posizionamento';
$string['ranking_help'] = 'La posizione assoluta nella classifica è quella dell\'utente corrente. La posizione relativa è la diffenza dei punti esperienza tra un utente e i suoi vicini.';
$string['reallydeleteuserstate'] = 'Eliminare un utente è utile solamente a rimuoverlo dalla Classifica. In tutti gli altri casi, si consiglia in alternativa d\'impostare i suoi punti a 0. Nota che l\'eliminazione non preclude l\'utente da guadagnare nuovi punti in futuro.

Importante, quando si usa _Sali di livello!_ per l\'intero sito, eliminare gli utenti li farà sparire dal report e in questo caso non sarà possibile assegnare nuovamente punti. Invece, se stai utilizzando _Sali di livello!_ all\'interno di un corso, lo studente continuerà ad apparire nel report fino a quando rimarrà iscritto nel corso.

Vuoi davvero eliminare i punti di questo utente?';
$string['reallyresetallcoursestodefaults'] = 'Desideri ripristinare tutte le regole dei corsi a quelle di default? Questa azione è irreversibile.';
$string['reallyresetcourserulestodefaults'] = 'Desideri ripristinare tutte le regole del corso a quelle di default? Questa azione è irreversibile.';
$string['reallyresetdata'] = 'Azzerare i livelli e i punti esperienza dei partecipanti al corso?';
$string['reallyresetgroupdata'] = 'Azzerare i livelli e i punti esperienza di tutti i membri del gruppo?';
$string['reallyreverttopluginsdefaults'] = 'Azzerare le regole di default riportandole al default suggerito dal plugin? Questa azione è irreversibile.';
$string['recentrewards'] = 'Assegnazioni di punti esperienza recenti';
$string['releasenotes'] = 'Note di rilascio';
$string['reportisempty'] = 'Il report è vuoto, lo studente deve ancora guadagnare punti.';
$string['reportisemptyenrolstudents'] = 'Il report è vuoto, sono stati iscritti studenti a questo corso?';
$string['requires'] = 'Richiede';
$string['resetallcoursestodefaults'] = 'Ripristina tutti i corsi al loro default';
$string['resetallcoursestodefaultsintro'] = 'Clicca il pulsante sottostante per ripristinare tutti i corsi ai default di cui sopra.';
$string['resetcoursedata'] = 'Ripristina i dati del corso';
$string['resetcourserulestodefaults'] = 'Ripristina le regole del corso ai loro default';
$string['resetgroupdata'] = 'Ripristina i dati del gruppo';
$string['reverttopluginsdefaults'] = 'Ripristina le impostazioni predefinite del plug-in';
$string['reverttopluginsdefaultsintro'] = 'Utilizza il pulsante sottostante se si desidera ripristinare le impostazioni predefinite del plugin.';
$string['reward'] = 'Punto esperienza';
$string['rule'] = 'Regole';
$string['rule:contains'] = 'contiene';
$string['rule:eq'] = 'è uguale a';
$string['rule:eqs'] = 'è esattamente uguale a';
$string['rule:gt'] = 'è maggiore di';
$string['rule:gte'] = 'è maggiore o uguale a';
$string['rule:lt'] = 'è minore di';
$string['rule:lte'] = 'è minore o uguale a';
$string['rule:regex'] = 'corrisponde con l\'espressione regolare';
$string['rulecm'] = 'Attività o risorsa';
$string['rulecm_help'] = 'La condizione sarà soddisfatta quando scatterà l\'evento nell\'attività o nella risorsa specificata.';
$string['rulecmdesc'] = 'L\'attività o risorsa è \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'L’attività o la risorsa è: \'{$a->contextname}\' in \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Questa condizione richiede che l\'azione venga svolta in una specifica attività o risorsa.';
$string['ruleevent'] = 'Specifico evento';
$string['ruleeventdesc'] = 'L\'evento è \'{$a->eventname}\\';
$string['ruleeventinfo'] = 'Scegli l\'azione che gli utenti devono svolgere da una lista predefinita di eventi.';
$string['ruleproperty'] = 'Proprietà dell\'evento';
$string['rulepropertydesc'] = 'La proprietà \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Questa condizione è da utilizzare da utenti esperti con una conoscenza tecnica degli eventi e le loro proprietà.';
$string['ruleset'] = 'Imposta le condizioni';
$string['ruleset:all'] = 'Tutte le condizioni sono vere';
$string['ruleset:any'] = 'Almeno una delle condizioni è vera';
$string['ruleset:none'] = 'Nessuna condizione è vera';
$string['rulesetinfo'] = 'Combina condizioni multiple in una.';
$string['rulesformhelp'] = '<p>Questo plugin permette di usare degli eventi per attribuire punti esperienza ad azioni svolte dagli studenti. Puoi usare il modulo sotto per aggiungere le tue regole e visualizzare le regole di default.</p>
<p>Si consiglia di controllare il/i <a href="{$a->log}">log</a> per identificare quali eventi sono attivati quando esegui un\'azione nel corso, e anche per maggiori informazioni sugli eventi: <a href="{$a->list}">elenco di tutti gli eventi</a>, <a href="{$a->doc}">documentatione per gli sviluppatori</a>.</p>
<p>Infine, nota che il plugin ignora sempre:
<ul>
    <li>Le azioni eseguite dall\'amministratore, ospite, utente non autenticato.</li>
    <li>Le azioni eseguite da utenti che non hanno il privilegio <em>block/xp:earnxp</em>.</li>
    <li>Azioni ripetute in un breve intervallo di tempo, per evitare imbrogli.</li>
    <li>Eventi che sono contrassegnati come <em>anonimo</em>, per esempio nel campo del commento anonimo.</li>
    <li>Ed eventi di livello formativo non uguale a <em>Partecipazione</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Cerca e seleziona un corso';
$string['searchandselectmodule'] = 'Cerca e seleziona un\'attività o una risorsa';
$string['send'] = 'Invia';
$string['setpoints'] = 'Imposta punti';
$string['shortcode:xpbadge'] = 'Il badge che corrisponde al livello dell\'utente attuale.';
$string['shortcode:xpiflevel'] = 'Visualizza il contenuto nel momento in cui il livello dell\'utente corrisponde.';
$string['shortcode:xpiflevel_help'] = 'Fare riferimento agli esempi sottostanti per l\'utilizzo degli shortcode. Quando un livello è specificato direttamente, il contenuto sarà visualizzato a prescindere dalle altre regole.
Le regole _maggiore di_ e _minore di_ devono risultare tutte verificate per mostrare il contenuto. Fare quindi attenzione perché si potrebbe avere casi in cui il contenuto non è mai visualizzato!
Notare che i docenti, o altri utenti con autorizzazioni di modifica, vedranno sempre tutto.

```
[xpiflevel 1 3 5]
    Visualizzato se il livello utente è esattamente 1, 3 o 5.
[/xpiflevel]

[xpiflevel >3]
    Visualizzato se il livello utente è maggiore di 3.
[/xpiflevel]

[xpiflevel >=3]
    Visualizzato se il livello utente è maggiore o uguale a 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Visualizzato se il livello utente è maggiore o uguale a 10 E se è strettamente minore di 20
    O esattamente uguale a 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Mai visualizzato perché il livello utente non può mai essere minore o uguale a 10 E
    maggiore o uguale a 20.
[/xpiflevel]
```

Notare che questi shortcode non possono essere utilizzati innestati.';
$string['shortcode:xpladder'] = 'Desideri una parte della classifica.';
$string['shortcode:xpladder_help'] = 'Di base, è visualizzata solo una porzione della classifica intorno alla posizione dell\'utente.

```
[xpladder]
```

Per visualizzare i primi 10 studenti invece dei vicini dell\'utente corrente, impostare il parametro `top`. Si può opzionalmente impostare il numero di utenti da visualizzare.
```
[xpladder top]
[xpladder top=15]
```

Un collegamento alla classifica completa viene normalmente visualizzato sotto la tabella. Se non si vuole mostrare, aggiungere il parametro `hidelink`.

```
[xpladder hidelink]
```

Di base, la tabella non include la colonna dei progressi, che mostra una barra di avanzamento. Se questa colonna è stata selezionata tra le colonne aggiuntive nelle impostazioni della classifica, si può usare il parametro `withprogress` per visualizzala.

```
[xpladder withprogress]
```

Notare che quando in un corso si usano i gruppi, la classifica ipotizzerà quale gruppo visualizzare.';
$string['shortcode:xplevelname'] = 'Visualizza il nome del livello.';
$string['shortcode:xplevelname_help'] = 'Di base il tag visualizza il nome del livello corrente dell\'utente.
In alternativa, si può usare il parametro `level` per visualizzare il nome di uno specifico livello.

```
[xplevelname]
[xplevelname level=5]
```

Se il parametro `level` è impostata ma il livello non esiste, non viene visualizzato nulla.';
$string['shortcode:xpprogressbar'] = 'La barra di avanzamento dell\'utente verso il prossimo livello.';
$string['someoneelse'] = 'Qualcun altro';
$string['somethinghappened'] = 'E\' successo qualcosa';
$string['taskcollectionloggerpurge'] = 'Elimina i log della raccolta';
$string['thankyou'] = 'Grazie!';
$string['timebetweensameactions'] = 'Tempo richiesto tra due azioni identiche';
$string['timebetweensameactions_help'] = 'Il tempo minimo, in secondi, richiesto tra due azioni identiche. Un\'azione è considerata identica se è svolta nello stesso contesto e oggetto, leggere uno stesso messaggio nei forum più di una volta sarà considerata un\'azione identica. Quando questo valore è vuoto o zero, non si applica.';
$string['timeformaxactions'] = 'Intervallo di tempo per numero massimo di azioni';
$string['timeformaxactions_help'] = 'L\'intervallo di tempo (in secondi) durante il quale l\'utente non dovrebbe eccedere il numero massimo di azioni svolte.';
$string['tinytimedays'] = '{$a}g';
$string['tinytimehours'] = '{$a}ora/e';
$string['tinytimeminutes'] = '{$a}min.';
$string['tinytimenow'] = 'adesso';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}sec.';
$string['tinytimeweeks'] = '{$a}sett.';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Totale';
$string['unknowneventa'] = 'Evento sconosciuto ({$a})';
$string['updateandpreview'] = 'Aggiorna e visualizza anteprima';
$string['upgradingplugins'] = 'Aggiornamento dei plugin';
$string['urlaccessdeprecated'] = 'L\'accesso tramite questo URL è obsoleto, si prega di aggiornare i collegamenti.';
$string['usealgo'] = 'Usa algoritmo';
$string['usecustomlevelbadges'] = 'Usa badge di livello personalizzati';
$string['usecustomlevelbadges_help'] = 'Selezionando sì, devi inserire un\'immagine per ogni livello.';
$string['usingalgo'] = 'Tramite algoritmo';
$string['value'] = 'Valore';
$string['valuessaved'] = 'I valori sono stati salvati correttamente.';
$string['viewas'] = 'Vedi come';
$string['viewtheladder'] = 'Visualizza classifica';
$string['visualsintro'] = 'Caricare immagini per personalizzare l\'aspetto dei livelli';
$string['wewillreplyat'] = 'Risponderemo a: _{$a}_.';
$string['when'] = 'Quando';
$string['wherearexpused'] = 'Dove vengono usati i punti esperienza?';
$string['wherearexpused_desc'] = 'Selezionando \'Nel corso\', i punti esperienza ottenuti saranno validi solo nel corso in cui il blocco è aggiunto. Selezionando \'Per l\'intero sito\', un utente "sale di livello" nel sito piuttosto che in uno specifico corso, tutti i punti esperienza ottenuti nel sito saranno ritenuti validi.';
$string['whoops'] = 'Ops!';
$string['xp'] = 'Punti esperienza';
$string['xp:addinstance'] = 'Aggiungi blocco XP';
$string['xp:earnxp'] = 'Ottieni punti esperienza';
$string['xp:manage'] = 'Gestione di i tutti gli aspetti dei punti esperienza';
$string['xp:myaddinstance'] = 'Aggiungi il blocco alla mia dashboard';
$string['xp:view'] = 'Visualizzare blocco e pagina relativa';
$string['xp:viewlogs'] = 'Visualizza i log';
$string['xpgaindisabled'] = 'Ottenimento punti disabilitato';
$string['xprequired'] = 'XP richiesta';
$string['xptogo'] = 'Mancano [[{$a}]]';
$string['youreachedlevel'] = 'Hai raggiunto il livello:';
$string['youreachedlevela'] = 'Hai raggiunto il livello {$a}!';
$string['yourmessage'] = 'Il tuo messaggio';
$string['yourownrules'] = 'Le tue regole';
