<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_tenant', language 'it', version '5.0'.
 *
 * @package     tool_tenant
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountalreadyconfirmedinfo'] = '{$a} account saltati in quanto già confermati';
$string['accountconfirmedfail'] = '{$a} account non trovato/i o che non è stato possibile confermare';
$string['accountconfirmedsuccess'] = '{$a} account confermati';
$string['activateusers'] = 'Attiva utenti';
$string['activateusersintotenant'] = 'Attiva utenti nel tenant...';
$string['activateusersintotenantdescription'] = 'Selezionare il tenant nel quale si desidera assegnare gli utenti. Tutti gli utenti manterranno il proprio ruolo anche nel nuovo tenant, inclusi gli amministratori.';
$string['activateusersintotenantfail'] = 'Non è possibile assegnare {$a->users} a \'{$a->tenant}\'.';
$string['activateusersintotenantsuccess'] = 'Tutti gli utenti sono ora attivi e assegnati a \'{$a->tenant}\'! <a href="{$a->link}">Gestione utenti</a>';
$string['activateusersintotenantsuccesswithfails'] = '{$a->users} utenti sono stati assegnati a \'{$a->tenant}\' e {$a->unsuspended users} utenti) sono ora attivi. <a href="{$a->link}">Gestione utenti</a>';
$string['activetenants'] = 'Tenant attivi';
$string['activeusers'] = 'Attiva account utente';
$string['addtenant'] = 'Nuovo tenant';
$string['adduser'] = 'Nuovo utente';
$string['admin'] = 'Amministratore';
$string['administrators'] = 'Amministratori';
$string['advanced'] = 'Avanzato';
$string['advancedbrandingwarning'] = 'Qualsiasi modifica apportata potrebbe influire sull\'accessibilità del sito e sull\'esperienza dell\'utente.';
$string['allocateusers'] = 'Assegna utenti';
$string['alltenants'] = 'Tutti i tenant';
$string['alltenantsselected'] = 'Utenti in tutti i tenant (compresi quelli futuri)';
$string['allusers'] = 'Tutti gli utenti';
$string['alluserslegacy'] = 'Tutti gli utenti (obsoleto)';
$string['andxmoretenants'] = 'e {$a} altri...';
$string['archive'] = 'Archivio';
$string['archivedon'] = 'Archiviato il';
$string['archivedtenants'] = 'Tenant archiviati';
$string['assigntenantadmins'] = 'Aggiungi agli amministratori del tenant';
$string['authdisabledavailable'] = 'Disabilitato, opzionale';
$string['autheditstatus'] = 'Modifica stato';
$string['authenabledoptional'] = 'Abilitato, opzionale';
$string['authmethod'] = 'Metodo di autenticazione';
$string['authnewstatusfor'] = 'Nuovo stato di {$a}';
$string['authpluginsettings'] = '{$a}. Impostazioni';
$string['authtypeofloginwarning'] = 'Alcuni tenant utilizzano metodi di autenticazione specifici. Per garantire una esperienza consistente agli utilizzatori dell\'app mobile, si raccomanda di cambiare l\'impostazione \'Tipo di login\' da \'Via app\' ad un\'altra opzione nella pagina <a href="{$a}">Autenticazone Mobile</a>.';
$string['availableinalltenants'] = 'Disponibile in tutti i tenant';
$string['basicinformation'] = 'Informazione di base';
$string['brand'] = 'Colore primario';
$string['brand_help'] = 'Il colore utilizzato nella barra di navigazione superiore';
$string['branding'] = 'Personalizzazione';
$string['buttoncolour'] = 'Colore principale del pulsante';
$string['buttoncolour_help'] = 'Colore di sfondo dei pulsanti principali';
$string['cachedef_mytenant'] = 'Informazioni sul tenant attuale';
$string['cachedef_tenants'] = 'Elenco dei tenant';
$string['cannotallocateusertotenant'] = 'Non è possibile assegnare utenti al tenant';
$string['cannotarchivetenant'] = 'None è possibile archiviare il tenant di default';
$string['category'] = 'Categoria di corsi';
$string['category_help'] = 'Agli amministratori del tenant verrà assegnato il ruolo di \'Amministratore del tenant nella categoria di corso\' e potranno creare corsi, assegnare ruoli, eccetera.
A tutti gli utenti del tenant verrà assegnato il ruolo di "Utente del tenant\' in questa categoria.<br><br>Come categoria del tenant è possibile selezionare solamente categorie del livello più alto.<br>
Selezionando \'Nuova categoria\', verrà creata una categoria di corsi con lo stesso nome del tenant.';
$string['categorynameexist'] = 'Esiste già una categoria di nome \'{$a}\' al livello più alto. Per favore selezionare questa categoria oppure cambiare il nome.';
$string['categorynameexistws'] = 'La categoria di nome \'{$a}\' esiste già al livello superiore. Modificare il nome del tenant o crearlo senza categoria.';
$string['categorynotfound'] = 'Categoria non trovata o non è al livello principale';
$string['categorytaken'] = 'Questa categoria è assegnata ad un altro tenant';
$string['changesite'] = 'Cambia sito';
$string['chooseexistingcategory'] = 'Seleziona una categoria esistente';
$string['colours'] = 'Colori';
$string['conditionuserallocateddescription'] = 'Utenti che appartengono al tenant \'{$a}\'';
$string['conditionusernotallocateddescription'] = 'Utenti che non appartengono al tenant \'{$a}\'';
$string['configoverride'] = 'Sovrascrivi';
$string['configureoauth2link'] = 'Configurazione servizi OAuth 2';
$string['configusedefault'] = 'Utilizza default';
$string['confirmaccounts'] = 'Conferma account';
$string['confirmactivateuser'] = 'Sei sicuro di attivare questo utente?';
$string['confirmactivateusers'] = 'Sei sicuro di attivare gli utenti selezionati?';
$string['confirmallocateusers'] = 'Sei sicuro si assegnare gli utenti selezionati al tenant?';
$string['confirmarchivetenant'] = 'Sei sicuro di archiviare il tenant\'{$a}\'? Tutti gli utenti assegnati a questo tenant saranno spostati nel tenant di default.';
$string['confirmarchivetenantwarning'] = 'Gli amministratori del tenant diventeranno utenti normali e il ruolo di amministratore del tenant non verrà ripristinato se il tenant viene ripristinato.';
$string['confirmarchivetenantwithoutusers'] = 'Sei sicuro di archiviare il tenant \'{$a}\'?';
$string['confirmarchivetenantwithusers'] = 'Sei sicuro di archiviare il tenant \'{$a->tenant}\'? {$a->users} utenti assegnati a questo tenant verranno sospesi.';
$string['confirmassigntenantadmins'] = 'Sei sicuro di aggiungere gli utenti selezionati agli amministratori del tenant?';
$string['confirmdeletetenant'] = 'Sei sicuro di eliminare definitivamente il tenant \'{$a}\'? Tutti gli utenti assegnati al tenant verranno eliminati.';
$string['confirmdeleteuser'] = 'Sei sicuro di eliminare questo utente? L\'azione non potrà essere annullata.';
$string['confirmdeleteusers'] = 'Sei sicuro di eliminare gli utenti selezionati? L\'azione non potrà essere annullata.';
$string['confirmresendemailuser'] = 'Sei sicuro di inviare di nuovo l\'email di conferma a questo utente?';
$string['confirmresendemailusers'] = 'Sei sicuro di inviare di nuovo l\'email di conferma agli utenti selezionati? L\'azione non potrà essere annullata.';
$string['confirmrestoretenant'] = 'Sei sicuro ripristinare il tenant \'{$a}\'? Tutti gli utenti assegnati a questo tenant diventeranno attivi.';
$string['confirmsuspenduser'] = 'Sei sicuro di sospendere questo utente?';
$string['confirmsuspendusers'] = 'Sei sicuro di sospendere gli utenti selezionati?';
$string['confirmunassigntenantadmins'] = 'Sei sicuro di eliminare gli utenti selezionati dagli amministratori del tenant?';
$string['confirmunsuspenduser'] = 'Sei sicuro di riattivare questo utente?';
$string['confirmunsuspendusers'] = 'Sei sicuro di riattivare gli utenti selezionati?';
$string['confirmuser'] = 'Conferma utente';
$string['confirmusers'] = 'Conferma utenti';
$string['createnewcategory'] = 'Crea categoria';
$string['current'] = 'Attuale';
$string['currentlysetting'] = 'Attuale: {$a}';
$string['customcss'] = 'SCSS Personalizzato';
$string['defaultdashboardconfiguration'] = 'Configurazione di default della dashboard';
$string['defaultname'] = 'Tenant di default';
$string['defaultsitedashboardpage'] = 'Dashboard di default del sito';
$string['defaulttenantmobileconfig'] = 'Questo è il tenant di default, la sua configurazione sarà utilizzata nell\'app mobile.';
$string['deleteuser'] = 'Elimina utente';
$string['deleteusers'] = 'Elimina utenti';
$string['editdashboard'] = 'Modifica dashboard';
$string['editdashboarddescription'] = 'Modifica dashboard solo per questo tenant';
$string['editdetailsinsharedspace'] = 'Modifica nello Spazio condiviso';
$string['editeachtenantoverride'] = 'Modifica questa impostazione per ogni tenant...';
$string['editeachtenantoverridetitle'] = 'Modifica \'{$a->setting}\' per ogni tenant';
$string['editingdashboard'] = 'Stai modificando la dashboard per \'{$a}\'';
$string['editingsitedashboard'] = 'Stai modificando la dashboard di default derl sito';
$string['editsettingfortenantoverride'] = 'Modifica \'{$a->setting}\' per {$a->tenant}';
$string['editspecifictenantoverride'] = 'Modifica questa impostazione per \'{$a}\'...';
$string['edittenantname'] = 'Modifica nome';
$string['edittenantoverride'] = 'Modifica...';
$string['edituser'] = 'Modifica account utente';
$string['edituserwithname'] = 'Modifica utente \'{$a}\'';
$string['emailsconfirmationresend'] = 'Invia di nuovo email di conferma';
$string['empty'] = 'Vuoto';
$string['enablesharedspace'] = 'Abilita Spazio condiviso';
$string['enrolinseparategroups'] = 'Questo corso potrà essere condiviso con altri tenant. Gli utenti di tenant diversi saranno assegnati a gruppi separati.';
$string['enrolwithoutgroups'] = 'Utenti di altri tenant potranno essere iscritti a questo corso e potranno vedersi tra loro poiché il corso non è impostato a gruppi separati';
$string['errorcannotallocate'] = 'Non è possibile assegnare al tenant';
$string['errorexperimentalmultidomain'] = 'La funzionalità sperimentale \'Domini personalizzati per tenant\' non è più supportata. Modificare la configurazione - vedere <a href="{$a}">Migrazione della configurazione multi-dominio</a>';
$string['errorinvalidtenant'] = 'Tenant \'{$a}\' non valido';
$string['errormultidomainandtenant'] = 'La configurazione multi-tenant non è valida. Modificare la configurazione - vedere <a href="{$a}">Migrazione della configurazione multi-dominio</a>';
$string['errornewcategorytenant'] = 'I parametri \'autocreatecategory\' e \'categoryid\' non possono essere utilizzati insieme';
$string['errornopermissionaddcondition'] = 'Siamo spiacenti, ma al momento non sei autorizzato a visualizzare l\'elenco dei tenant';
$string['errornopermissionallocateusers'] = 'Non sei autorizzato per assegnare gli utenti a questo tenant';
$string['errortenantarchived'] = 'Questo tenant è stato archiviato';
$string['errortenantidnumberunique'] = 'Questo codice identificativo è già utilizzato in un altro tenant';
$string['errortenantnotfound'] = 'Questo tenant non esiste';
$string['errorurlnotavailable'] = 'Deve essere disponibile almeno un URL di login.';
$string['errorwwwroot'] = 'Il dominio personalizzato deve essere un URL valido che inizia con http:// o https:// senza / finale. Non può contenere un percorso né una porta.';
$string['eventtenantcreated'] = 'Creazione tenant';
$string['eventtenantdeleted'] = 'Eliminazione tenant';
$string['eventtenantupdated'] = 'Aggiornamento tenant';
$string['eventtenantusercreated'] = 'Assegnazione utente ad un tenant';
$string['eventtenantuserupdated'] = 'Modifica assegnazione utente ad un tenant';
$string['favicon'] = 'Favicon';
$string['footertext'] = 'Testo del piè di pagina';
$string['forceforalltenants'] = 'Forza su tutti i tenant';
$string['gotosharedspace'] = 'Vai allo Spazio condiviso';
$string['headerlogo'] = 'Logo dell\'intestazione';
$string['headerlogo_help'] = 'Una versione più piccola del logo, ad esempio un emblema, uno scudetto o un\'icona da utilizzare nella barra di navigazione superiore.';
$string['idnumber'] = 'Codice identificativo';
$string['idnumber_help'] = 'Il codice identificativo di un tenant verrà utilizzato solamente per corrispondenza con dati di sistemi esterni o nello strumento caricamento utenti e non sarà visualizzato all\'interno del  sito. E\' possibile utilizzare il codice identificativo ufficiale, in mancanza può essere lasciato vuoto.';
$string['images'] = 'Immagini';
$string['invalidcolour'] = 'Il codice del colore non è nel formato corretto. Per favore utilizzare il formato #000 oppure #000000.';
$string['ismultitenant'] = 'Multi-tenant';
$string['issuernologin'] = 'Questo issuer non può essere utilizzato per autenticarsi';
$string['linkalltenants'] = 'Collega tutti i tenant';
$string['linkalltenantscheckbox'] = 'Reimposta anche la dashbord di tutti gli utenti dei tenant coinvolti';
$string['linkalltenantsdescription'] = 'Questa azione reimposterà tutti i tenant che non sono collegati alla dashboard di defualt del sito e li manterrà collegati a questa pagina.';
$string['linkalltenantsmessage'] = 'Tutti i tenant sono stati collegati correttamente';
$string['linkdashboard'] = 'Rimuovi dashboard personalizzate, utilizza la dashboard di default del sito...';
$string['linkdashboarddescriptionforadmin'] = 'Attualmente, la dashboard del tenant non è sincronizzata con il contenuto definito nella \'Dashboard di default del sito\'. Fare clic su questo pulsante per sincronizzarla nuovamente. In questo modo qualsiasi modifica apportata nella \'Dashboard di default del sito\' influenzerebbe questa dashboard del tenant.<br>L\'azione potrà annullata.';
$string['linkdashboarddialog'] = 'Proseguendo, la dashboard personalizzata verrà rimossa e collegata al contenuto definito in \'Dashboard di default del sito\'. Non ci saranno modifiche alle dashboard degli utenti esistenti. che potranno essere reimpostate manualmente in un secondo momento.<br><br>Le dashboard per i nuovi utenti verranno create a partire dalla \'Dashboard di default del  sito\', gestita dall\'amministratore primario.<br><br>Questa azione potrà essere annullata.';
$string['linkdashboarddialogforadmin'] = 'Proseguendo, questa dashboard del tenant verrà collegata al contenuto definito nella \'Dashboard di default del sito\'. D\'ora in poi, qualsiasi modifica apportata nella \'Dashboard di default del sito\' influenzerà questa dashboard del tenant. <br><br>Non ci saranno modifiche alle dashboard degli utenti esistenti. che potranno essere reimpostate manualmente in un secondo momento.<br><br>Le dashboard per i nuovi utenti verranno create a partire dalla \'Dashboard di default del  sito\', gestita dall\'amministratore primario.<br><br>Questa azione potrà essere annullata.';
$string['linkdashboardmessage'] = 'La dashboard è stata collegata correttamente';
$string['loginbackground'] = 'Immagine di sfondo di login';
$string['loginlogo'] = 'Logo di login';
$string['loginlogo_help'] = 'Un logo da utilizzare come decorazione nella pagina di autenticazione.';
$string['loginurl'] = 'URL di login';
$string['loginurl_help'] = 'All’amministratore del tenant verranno visualizzate URL selezionate che loro potranno passare ai propri utenti affinché il tema del tenant venga visualizzato immediatamente. Se non viene specificato il \'Codice identificativo\', il link non sarà disponibile anche se selezionato. Da notare che durante la creazione del tenant, l\'id del tenant non è disponibile.';
$string['lookingfordifferentsite'] = 'Stai cercando un altro sito?';
$string['management'] = 'Gestione';
$string['managetenants'] = 'Gestione tenant';
$string['migrationcoursecategories'] = 'Categorie di corso, con i gruppi globali e la struttura dei corsi';
$string['migrationcreate'] = 'Crea tenant';
$string['migrationdestinationsummary'] = 'Destinazione: {$a}';
$string['migrationexporterdescription'] = 'Tenant con i relativi elementi';
$string['migrationlogerror'] = 'Non è stato possibile importare il tenant \'{$a}\'';
$string['migrationlogsuccess'] = 'Importato il tenant \'<a href="{$a->url}">{$a->name}</a>\'';
$string['migrationmappingerror'] = 'Alcuni tenant non esistono';
$string['migrationmappingerrorlog'] = 'Non è stato trovato il tenant {$a}';
$string['migrationmerge'] = 'Unisci ad un tenant esistente...';
$string['migrationmerge_help'] = 'Unisce ad un tenant esistetene le informazioni e gli elementi selezionati. Da notare che i dettagli e l\'aspetto, se presenti, saranno sovrascritti.';
$string['migrationmergeselecttenant'] = 'Selezionare il tenant dove unire';
$string['migrationmergetoomany'] = 'Per unire ad in un tenant esistente è possibile selezionare solamente una singola istanza';
$string['migrationselectalltenants'] = 'Seleziona tutti i tenant';
$string['migrationselectexcludingarchived'] = 'Seleziona tutti i tenant (esclusi gli archiviati)';
$string['migrationselectincludingarchived'] = 'Seleziona tutti i tenant (inclusi gli archiviati)';
$string['migrationselectmanually'] = 'Seleziona manualmente i tenant...';
$string['missingtenant'] = 'Tenant mancante';
$string['modurl:tenantdata'] = 'Dati del tenant';
$string['modurl:tenantid'] = 'ID del tenant';
$string['modurl:tenantidnumber'] = 'Codice identificativo del tenant';
$string['movebetweentenants'] = 'Sposta tra tenant';
$string['movetenant'] = 'Sposta tenant \'{$a}\'';
$string['name'] = 'Nome del tenant';
$string['namewithempty'] = 'Nome del tenant (incluso senza tenant)';
$string['navbarcolour'] = 'Colore barra di navigazione';
$string['navbarcolour_help'] = 'Colore di sfondo della barar di navigazione superiore';
$string['newname'] = 'Nuovo tenant \'{$a}\'';
$string['newnamefor'] = 'Nome del tenant \'{$a}\'';
$string['nocategory'] = 'Nessuna categoria';
$string['nomanualassignment'] = 'Questo ruolo non può essere assegnato manualmente in nessun contesto';
$string['notavailablefortenants'] = 'Non disponibile in nessun tenant';
$string['notnow'] = 'Non adesso';
$string['notspecified'] = 'Non specificato';
$string['oauth2_alltenants'] = 'Questo servizio è disponibile a tutti i tenant (inclusi tenanti futuri)';
$string['oauth2_exceptfollowingtenants'] = 'Questo servizio è disponibile a tutti i tenant fatta eccezione per i seguenti';
$string['oauth2_onlyfollowingtenants'] = 'Questo servizio è disponibile solamente ai seguenti tenant';
$string['oauth2_tenantavailability_success'] = 'Disponibilità ai tenant del servizio aggiornata correttamente';
$string['oauth2availableforlogin'] = 'Servizio OAuth 2 disponibile per il login.';
$string['organisationadmintab'] = 'Organzzazione';
$string['outcomeallocation'] = 'Assegna utenti al tenant';
$string['outcomeallocationdescription'] = 'Assegna utenti al tenant \'{$a}\'';
$string['overridesetting_help'] = '**Impostazione multi-tenant**

Se questo sito contiene più di un tenant, il valore stabilito per questa impostazione fungerà da **impostazione predefinita per tutti i tenant**.

Abilitando o disabilitando questa opzione, è possibile consentire o impedire ad altri tenant di ignorare questo valore di impostazione:

* **Abilitato**: Gli amministratori dei tenant possono ignorare questa impostazione nei loro tenant specifico, interessando solo quel tenant.

* **Disabilitato**: Il valore di questa impostazione verrà impostato come predefinito per tutti i tenant e gli amministratori dei tenant non avranno la possibilità di ignorarne il valore nei loro tenant specifici.';
$string['pluginname'] = 'Multi-tenancy';
$string['privacy:metadata:user'] = 'Assegnazione degli utenti al tenant';
$string['privacy:metadata:user:component'] = 'Componente responsabile dell\'assegnazione';
$string['privacy:metadata:user:id'] = 'ID';
$string['privacy:metadata:user:reason'] = 'Motivo dell\'assegnazione';
$string['privacy:metadata:user:tenantid'] = 'Tenant';
$string['privacy:metadata:user:timecreated'] = 'Ora di assegnazione';
$string['privacy:metadata:user:timemodified'] = 'Ora di modifica';
$string['privacy:metadata:user:userid'] = 'Utente';
$string['privacy:metadata:user:usermodified'] = 'Utente che ha modificato il record';
$string['profilecategory_alltenants'] = 'La categoria è disponibile in tutti i tenant (inclusi tenant futuri)';
$string['profilecategory_exceptfollowingtenants'] = 'La categoria è disponibile in tutti i tenant ad eccezione dei seguenti';
$string['profilecategory_onlyfollowingtenants'] = 'La categoria è disponibile solamente nei seguenti tenant';
$string['reg_wpsharedspaceenabled'] = 'Lo spazio condiviso è abilitato ({$a})';
$string['reg_wptenantdomains'] = 'Numero di tenant con domini personalizzati impostati ({$a})';
$string['reg_wptenants'] = 'Numero di tenant ({$a})';
$string['resendemailsentfail'] = 'Utenti non trovati o ai quali non è stato possibile inviare email di conferma: {$a}';
$string['resendemailsentsuccess'] = 'Email di conferma inviata ai seguenti utenti: {$a}';
$string['resendemailuser'] = 'Invia di nuovo email all\'utente';
$string['resetappearance'] = 'Resetta aspetto';
$string['resetdashboard'] = 'Reimposta la dashbord di tutti gli utenti...';
$string['resetdashboarddescription'] = 'Reimposta la dashbord degli utenti di questo tenant';
$string['resetdashboarddialog'] = 'Se si prosegue, la dashboard di tutti gli utenti sarà reimpostata.<br><br>L\'azione non potrà essere annullata.';
$string['resetdashboardmessage'] = 'La dashboard è stata reimpostata correttamente per tutti gli utenti.';
$string['resetlinkeddashboard'] = 'Reimposta dashboard per tutti gli utenti nei tenant collegati...';
$string['resetlinkeddashboarddialog'] = 'Procedendo, la dashboard verrà reimpostata per tutti gli utenti dei tenant collegati.<br><br>Questa azione non potrà essere annullata';
$string['resetlinkeddashboardmessage'] = 'Tutte le dashboard degli utenti sono state reimpostate correttamente.';
$string['resettenantappearance'] = 'Resetta aspetto del tenant';
$string['resettenantappearancecolours'] = 'Resetta tutti i colori personalizzati';
$string['resettenantappearancecss'] = 'Elimina SCSS personalizzato';
$string['resettenantappearancedesc'] = 'Cliccando il pulsante, sarà possibile selezionare gli elementi (immagini, coloro, ecc.) da ripristinare agli standard di accessibilità.';
$string['resettenantappearancefooter'] = 'Elimina testo del piè di pagina';
$string['resettenantappearanceformend'] = 'L\'azione non potrà essere annullata';
$string['resettenantappearanceformintro'] = 'Resetta la configurazione di questo tenant alla configurazione standard accessibile.<br> L\'azione:';
$string['resettenantappearanceimages'] = 'Elimina tutte le immagini caricate (logo, sfondi)';
$string['saml2_alltenants'] = 'Questo IdP è disponibile in tutti i tenant (inclusi tenant futuri)';
$string['saml2_exceptfollowingtenants'] = 'Questo IdP è disponibile in tutti i tenant eccetto i seguenti';
$string['saml2_onlyfollowingtenants'] = 'Questo IdP è disponibile solo nei seguenti tenant';
$string['saml2availableforlogin'] = 'Identity provider SAML2 disponibili per l\'autenticazione.';
$string['seealltenants'] = 'Visualizza tutto';
$string['selecttenant'] = 'Seleziona tenant';
$string['selecttenantoutcome'] = 'Seleziona tenant';
$string['selecttenants'] = 'Seleziona tenant';
$string['selectuser'] = 'Seleziona utente \'{$a}\'';
$string['settingtenantvalue'] = '{$a->tenantname}: <i>{$a->tenantvalue}</i>';
$string['sharedspace'] = 'Spazio condiviso';
$string['sharedspaceconfirmationtext'] = 'Lo Spazio condiviso è in luogo dove condividere elementi e contenuti tra tutti i tenant. Qualsiasi cosa creata nello Spazio Condiviso sarà reso immediatamente disponibile a tutti gli utenti di tutti i tenant se dispongono degli opportuni privilegi.<br/> Una volta abilitato lo Spazio condiviso, non sarà più possibile disabilitarlo<br/> Sei sicuro di attivare lo Spazio condiviso?';
$string['sharedspaceenabledmessage'] = 'Lo Spazio condiviso è stato abilitato correttamente. Per accederlo, utilizzare il cambio tenant nella barra di navigazione.';
$string['showintenantselector'] = 'Visualizza tenant nel selettore login';
$string['showintenantselector_help'] = 'Consente di elencare il tenant nella pagina di login di ciascun tenant come pagina di login alternativa.';
$string['showtenantselector'] = 'Visualizza il selettore tenant nella pagina di login';
$string['showtenantselector_help'] = 'Gli utenti potranno cambiare il tenant nella pagina di login. Ciascun tenant può impostare la propria visibilità in questo elenco.';
$string['siteleveldefault'] = 'Default a livello di sito';
$string['sitelevelsetting'] = 'Utilizza impostazioni a livello di sito';
$string['sitename'] = 'Nome del sito';
$string['sitename_help'] = 'Consente di sovrascrivere il nome di default del sito per gli utenti di questo tenant';
$string['siteshortname'] = 'Nome abbreviato del sito';
$string['siteshortname_help'] = 'Consente di sovrascrivere il nome abbreviato di default del sito,<br> Il nome abbreviato dl sito sarà visualizzato se il campo \'Logo dell\'intestazione\' (presente nella personalizzazione del tenant) viene lasciato vuoto.';
$string['siteshortnamedesc'] = 'Il nome abbreviato dl sito sarà visualizzato se il campo \'Logo dell\'intestazione\' (presente nella personalizzazione del tenant) viene lasciato vuoto.';
$string['siteuserlimit'] = 'Limite utenti del sito';
$string['siteuserlimit_desc'] = 'Il numero massimo di account consentiti nel sito';
$string['siteuserlimitenabled'] = 'Abilita limite utenti del sito';
$string['status'] = 'Stato';
$string['supportavailability'] = 'Disponibilità del supporto';
$string['supportavailabilitydescription'] = 'Per default, la disponibilità del supporto è configurata a livello di sito. Selezionando \'Sostituisci\' è possibile fornire una nuova disponibilità';
$string['supportemail'] = 'Email di supporto';
$string['supportemaildescription'] = 'Per default, l\'email del supporto è configurata a livello di sito. Selezionando \'Sostituisci\' è possibile fornire una nuova email';
$string['supportname'] = 'Nome del supporto';
$string['supportnamedescription'] = 'Per default, il nome del supporto è configurato a livello di sito. Selezionando \'Sostituisci\' è possibile fornire una nuovo nome';
$string['suspendedusers'] = 'Utenti sospesi';
$string['suspenduser'] = 'Sospendi utente';
$string['suspendusers'] = 'Sospendi utenti';
$string['switchedto'] = 'Se passato al tenant \'{$a}\'';
$string['switchtenant'] = 'Cambia tenant';
$string['tenant'] = 'Tenant';
$string['tenant:allocate'] = 'Assegnare utenti a tutti i tenant';
$string['tenant:authconfig'] = 'Modificare impostazioni autenticazione del tenant';
$string['tenant:browseusers'] = 'Visualizzare utenti del tenant';
$string['tenant:manage'] = 'Gestire l\'aggiunta e la modifica di tenant';
$string['tenant:managedashboard'] = 'Gestire le impostazioni della dashboard per il tenant corrente';
$string['tenant:managetheme'] = 'Gestire le impostazioni del tema del tenant corrente';
$string['tenant:managethemeadvanced'] = 'Gestire le impostazioni avanzate del tema per il tenant corrente';
$string['tenant:manageusers'] = 'Aggiungere e modificare utenti del tenant corrente';
$string['tenant:mobileconfig'] = 'Modificare le impostazioni mobile del tenant';
$string['tenantadmin'] = 'Amministratore del tenant';
$string['tenantadminalreadyassigned'] = 'Utenti saltati poiché sono già amministratori del tenant: {$a}';
$string['tenantadminalreadyunassigned'] = 'Utenti saltati poiché non sono amministratori del tenant: {$a}';
$string['tenantadmincapabilitieslimit'] = 'Non sono elencati i privilegi non compatibili con la Multi-tenancy. <a href="{$a}">Maggiori informazioni</a>';
$string['tenantadmindescription'] = 'Il ruolo dell\'amministratore del tenant. Asseganto automaticamente agli amministratori del tenant nel contesto di sistema.';
$string['tenantadministration'] = 'Amministratore del tenant';
$string['tenantadministrator'] = 'Questo utente è un amministratore del tenant';
$string['tenantadmins'] = 'Amministratori del tenant';
$string['tenantarchivedsuccess'] = 'Il tenant \'{$a}\' è stato archiviato. Tutti gli utenti assegnati sono stati sospesi.';
$string['tenantavailability'] = 'Modifica disponibilità del tenant';
$string['tenantavailabilityfor'] = 'Disponibilità del tenant per \'{$a}\'';
$string['tenantcategorycapabilitieslimit'] = 'Sono elencati solamente i privilegi impostabili nel contesto della categoria di corsi';
$string['tenantdeleted'] = 'Il tenant \'{$a}\' è stato eliminato.';
$string['tenantdetails'] = 'Dettagli';
$string['tenantlimit'] = 'Limite di tenant';
$string['tenantlimit_desc'] = 'Il numero massimo di tenant consentiti, sia attivi sia archiviati.';
$string['tenantlimitenabled'] = 'Abilita limite di tenant';
$string['tenantlimitenabled_desc'] = 'Consente di limitare il numero massimo di';
$string['tenantlimitreached'] = 'Raggiunto limite del tenant';
$string['tenantlimitreached1'] = 'La multi-tenancy non è abilitata in questo sito';
$string['tenantlimitreachedmult'] = 'E\' possibile creare solamente {$a} tenant. Da notare che i tenant archiviati sono conteggiati per il calcolo del limite.';
$string['tenantmanager'] = 'Amministratore del tenant nella categoria di corsi';
$string['tenantmanagerdescription'] = 'Il ruolo del secondo amministratore del tenant. Assegnato automaticamente all\'amministratore del tenant nel contesto della categoria di corsi.';
$string['tenantnotfound'] = 'Tenant non trovato';
$string['tenants'] = 'Tenants';
$string['tenantselectorlogo'] = 'Selettore logo del tenant';
$string['tenantselectorlogo_help'] = 'Il logo facilita l\'identificazione di questo tenant nel selettore tenant (se la funzionalità è abilitata). Se non specificata, sarà utilizzato il logo di login.';
$string['tenantsexceptselected'] = 'Utenti di tutti i tenant eccetto dei seguenti';
$string['tenantsexceptselecteddesc'] = 'Utenti di tutti i tenant eccetto dei seguenti: {$a}';
$string['tenantsselected'] = 'Utenti dei seguenti tenant';
$string['tenantsselecteddesc'] = 'Utenti dei seguenti tenant: {$a}';
$string['tenantuser'] = 'Utente del tenant';
$string['tenantuserdescription'] = 'Il ruolo degli utenti del tenant. Assegnato automaticamente agli utenti del tenant nel contesto della loro categoria di corsi.';
$string['tenantuserlimit'] = 'Limite utenti del tenant';
$string['tenantuserlimit_desc'] = 'Numero massimo di account utente consentiti nel tenant.';
$string['tenantuserlimitenabled'] = 'Abilita limite utenti del tenant';
$string['tenantusers'] = 'Utenti del tenant';
$string['themesettingssaved'] = 'Le impostazioni del tema sono state salvate. Prima che le modifiche siano visibili, devono trascorrere diversi minuti.';
$string['toomanytenantstoshow'] = 'Ci sono troppi tenant da visualizzare';
$string['unassigntenantadmins'] = 'Rimuovi dagli amministratori del tenant';
$string['unlinkdashboard'] = 'Crea dashboard personalizzata...';
$string['unlinkdashboardmessage'] = 'La dashboard è stata scollegata correttamente';
$string['unlinkeddashboard'] = 'Scollegata';
$string['unrecognisedaction'] = 'Azione non riconosciuta';
$string['unsuspenduser'] = 'Riattiva utente';
$string['unsuspendusers'] = 'Riattiva utenti';
$string['useractivatedsuccess'] = 'Utente attivato correttamente';
$string['useralreadyconfirmedinfo'] = 'Utenti saltati perché già confermati: {$a}';
$string['userconfirmedfail'] = 'Utenti non trovati o che non è stato possibile confermare: {$a}';
$string['userconfirmedsuccess'] = 'Utenti confermati: {$a}';
$string['userdeletedfail'] = 'Utenti non trovati o che non è stato possibile eliminare: {$a}';
$string['userdeletedsuccess'] = 'Utenti eliminati: {$a}';
$string['usermanagement'] = 'Gestione utenti';
$string['usermovetotenant'] = 'Utenti spostati nel tenant {$a->tenant}: {$a->count}';
$string['usernotmovetotenant'] = 'Utenti che non è stato possibile spostare nel tenant selezionato: {$a->tenant}';
$string['usersactivatedfail'] = 'Utenti non trovati on non attivabili: {$a}';
$string['usersactivatedsuccess'] = 'Utenti attivati: {$a}';
$string['usersallocatedtotenant'] = 'Utenti assegnati a tenant';
$string['usersassignedtenantadminfail'] = 'Utenti che non è stato possibile aggiungere all\'elenco degli amministratori del tenant: {$a}';
$string['usersassignedtenantadminsuccess'] = 'Utenti aggiunti all\'elenco degli amministratori del tenant: {$a}';
$string['userscount'] = 'Utenti';
$string['userslimitreached'] = 'Raggiunto il limtie di account  utente';
$string['usersnotallocatedtotenant'] = 'Utenti non assegnati a tenant';
$string['userssuspendedfail'] = 'Utenti non trovati o che non è stato possibile sospendere: {$a}';
$string['userssuspendedsuccess'] = 'Utenti sospesi: {$a}';
$string['usersunassignedtenantadminfail'] = 'Utenti che non è stato possibile rimuovere dall\'elenco degli amministratori del tenant: {$a}';
$string['usersunassignedtenantadminsuccess'] = 'Utenti rimossi dall\'elenco degli amministratori del tenant: {$a}';
$string['usersunsuspendedfail'] = 'Utenti non trovati o che non è stato possibile riattivare: {$a}';
$string['usersunsuspendedsuccess'] = 'Utenti riattivati: {$a}';
$string['usersuspendedsuccess'] = 'Utente sospeso correttamente';
$string['usertenant'] = 'Tenant dell\'utente';
$string['userunsuspendedsuccess'] = 'Utente riattivato correttamente';
$string['value'] = 'Valore';
$string['wwwroot'] = 'Dominio personalizzato';
$string['wwwroot_help'] = 'Consente di indicare l\'URL che deve essere utilizzato per questo tenant. Prima di farlo, assicurati che il DNS sia già impostato in modo che l\'URL punti allo stesso sito.';
