<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'pl', version '5.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Załączniki do zadań';
$string['activitydate:submissionsdue'] = 'Wymagane do:';
$string['activitydate:submissionsopen'] = 'Otwarcie:';
$string['activitydate:submissionsopened'] = 'Otwarto:';
$string['activityeditor'] = 'Instrukcje dotyczące aktywności';
$string['activityeditor_help'] = 'Czynności, które student ma wykonać w ramach tego zadania. Jest to widoczne tylko na stronie przesyłania zadania, na której studenci edytują i przesyłają swoje zadania.';
$string['activityoverview'] = 'Masz nowe zadanie/zadania wymagające Twojej uwagi.';
$string['addattempt'] = 'Zezwól na kolejną próbę';
$string['addnewattempt'] = 'Dodaj nową wersję pracy';
$string['addnewattempt_help'] = 'Otworzy się strona do przesłania nowej wersji pracy.';
$string['addnewattemptfromprevious'] = 'Dodaj nową wersję pracy na podstawie poprzedniej';
$string['addnewattemptfromprevious_help'] = 'Zawartość poprzednio przesłanej przez Ciebie pracy zostanie skopiowana i będzie można na jej podstawie przesłać nową wersję.';
$string['addnewgroupoverride'] = 'Dodaj wyjątek grupy';
$string['addnewuseroverride'] = 'Dodaj wyjątek użytkownika';
$string['addsubmission'] = 'Dodaj pracę';
$string['addsubmission_help'] = 'Nie przesłałaś/eś  jeszcze zadania.';
$string['allocatedmarker'] = 'Przydzielona osoba oceniająca';
$string['allocatedmarker_help'] = 'Osoba oceniająca przydzielona do tego zadania.';
$string['allowsubmissions'] = 'Pozwól użytkownikom nadal wysyłać rozwiązania tego zadania.';
$string['allowsubmissionsfromdate'] = 'Zezwól na przesyłanie zadań od';
$string['allowsubmissionsfromdate_help'] = 'Jeśli opcja jest włączona, studenci nie będą mogli przesyłać rozwiązań przed wybraną datą. W przeciwnym wypadku studenci będą mogli rozwiązywać zadanie od momentu utworzenia zadania.';
$string['allowsubmissionsshort'] = 'Zezwól na przesyłanie prac';
$string['alwaysshowdescription'] = 'Zawsze udostępniaj opis';
$string['alwaysshowdescription_help'] = 'Jeśli opcja jest wyłączona, opis będzie widoczny dla studentów dopiero po dacie rozpoczęcia przyjmowania prac.';
$string['applytoteam'] = 'Zastosuj oceny i informacje zwrotne dla całej grupy';
$string['assign:addinstance'] = 'Dodaj nowe zadanie';
$string['assign:editothersubmission'] = 'Edytuj zadanie innego studenta';
$string['assign:exportownsubmission'] = 'Eksportuj własne zadania';
$string['assign:grade'] = 'Oceń zadanie';
$string['assign:grantextension'] = 'Przedłużenie terminu oddania';
$string['assign:manageallocations'] = 'Zarządzaj oceniającymi zadania';
$string['assign:managegrades'] = 'Przejrzyj i opublikuj oceny';
$string['assign:manageoverrides'] = 'Zarządzaj wyjątkami zadania';
$string['assign:receivegradernotifications'] = 'Otrzymuj powiadomienia o przesłaniu ocen';
$string['assign:releasegrades'] = 'Wystaw oceny';
$string['assign:revealidentities'] = 'Odkrywanie tożsamości studenckich';
$string['assign:reviewgrades'] = 'Sprawdź oceny';
$string['assign:showhiddengrader'] = 'Zobacz tożsamość ukrytej oceny';
$string['assign:submit'] = 'Zgłoś zadanie';
$string['assign:view'] = 'Zobacz zadanie';
$string['assign:viewblinddetails'] = 'Wyświetlanie tożsamości uczniów, gdy włączone jest anonimowe przesyłanie zadań';
$string['assign:viewgrades'] = 'Podgląd ocen';
$string['assign:viewownsubmissionsummary'] = 'Zobacz podsumowanie własnych zadań';
$string['assignfeedback'] = 'Wtyczka informacji zwrotnych';
$string['assignfeedbackpluginname'] = 'Wtyczka informacji zwrotnych';
$string['assignmentduedigesthtml'] = '<p>Drogi użytkowniku: {$a->firstname},<br>
następujące zadania należy oddać do <strong>{$a->duedate}</strong>.</p>
{$a->digest}';
$string['assignmentduedigestitem'] = '<strong>{$a->assignmentname}</strong> w kursie {$a->coursename}<br/>
<strong>Termin: {$a->duetime}</strong><br/>
<a href="{$a->url}" aria-label="Go to {$a->assignmentname}">Idź do aktywności</a>';
$string['assignmentduedigestsubject'] = 'Masz zadania do oddania za 7 dni';
$string['assignmentduesoonhtml'] = '<p>Drogi użytkowniku: {$a->firstname},<br>
wkrótce mija termin oddania zadania <strong>{$a->assignmentname}</strong> w kursie {$a->coursename}</p>
<p><strong>Termin oddania: {$a->duedate}</strong></br>
<a href="{$a->url}">Otwórz zadanie</a></p>';
$string['assignmentduesoonsubject'] = 'Termin: {$a->duedate}: {$a->assignmentname}';
$string['assignmentisdue'] = 'Termin wykonania minął';
$string['assignmentmail'] = '{$a->grader} przesłał komentarz do Twojego zadania \'{$a->assignment}\'.

Możesz go zobaczyć tutaj: {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} przesłał komentarz do Twojego zadania \'<i>{$a->assignment}</i>\'.<p>
<p>Możesz go zobaczyć <a href="{$a->url}">tutaj</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} przesłał komentarz do Twojego zadania \'{$a->assignment}\'. Możesz go zobaczyć przy przesłanym zadaniu.';
$string['assignmentname'] = 'Nazwa zadania';
$string['assignmentoverduehtml'] = '<p>Cześć {$a->firstname},</p>
<p><strong>{$a->assignmentname}</strong>  w kursie {$a->coursename} miało zostać odesłane do <strong>{$a->duedate}</strong>.</p>
<p>Możesz nadal przesłać swoje zadanie {$a->cutoffsnippet}, ale zostanie one oznaczone jako oddane po terminie.</p>
<p><a href="{$a->url}">Przejdź do aktywności</a></p>';
$string['assignmentoverduesms'] = 'Twoje zadanie {$a->assignmentname} jest spóźnione {$a->duedate}: {$a->url}';
$string['assignmentplugins'] = 'Wtyczki modułu Zadanie';
$string['assignmentsperpage'] = 'Liczba zadań na stronę';
$string['assignsubmission'] = 'Wtyczka modułu Zadanie';
$string['assignsubmissionpluginname'] = 'Wtyczka modułu Zadanie';
$string['assigntimeleft'] = 'Pozostały czas';
$string['attemptheading'] = 'Próba {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Poprzednie próby';
$string['attemptnumber'] = 'Numer próby';
$string['attemptreopenmethod'] = 'Dodatkowe podejścia';
$string['attemptreopenmethod_automatic'] = 'Automatycznie';
$string['attemptreopenmethod_automatic_help'] = 'Po każdej próbie następna jest przyznawana automatycznie.';
$string['attemptreopenmethod_help'] = 'To ustawienie określa, czy student może podejmować dodatkowe próby przy zadaniu. Dla każdej próby ocena i informacje zwrotne są zapisywane i mogą być wyświetlane przez nauczyciela i studenta. Dostępne opcje to:

* Nigdy - możliwa jest tylko jedna próba.
* Ręcznie - nauczyciel może zezwolić na dodatkowe próby.
* Automatycznie do zaliczenia — dodatkowe próby są dozwolone automatycznie, dopóki uczeń nie uzyska oceny do zaliczenia określonej w dzienniku ocen dla tego zadania.';
$string['attemptreopenmethod_manual'] = 'Ręcznie';
$string['attemptreopenmethod_none'] = 'Nigdy';
$string['attemptreopenmethod_untilpass'] = 'Automatycznie do momentu zaliczenia';
$string['attemptreopenmethod_untilpass_help'] = 'Po każdej próbie następna będzie przyznawana automatycznie, aż do momentu uzyskania przez studenta oceny zaliczającej.';
$string['attemptsettings'] = 'Ustawienia próby';
$string['availability'] = 'Dostępność';
$string['back'] = 'Wstecz';
$string['backtoassignment'] = 'Wróć do zadania';
$string['batchoperationaddattempt'] = 'Dodatkowe podejście';
$string['batchoperationconfirmaddattempt'] = 'Zezwolić na kolejną próbę?';
$string['batchoperationconfirmdownloadselected'] = 'Czy pobrać zaznaczone zadania?';
$string['batchoperationconfirmgrantextension'] = 'Czy przedłużenie terminu odnosi się do wszystkich zaznaczonych uczestników?';
$string['batchoperationconfirmlock'] = 'Zablokować wszystkie zaznaczone zadania?';
$string['batchoperationconfirmremovesubmission'] = 'Usunąć zaznaczone zadania?';
$string['batchoperationconfirmreverttodraft'] = 'Zwrócić wybraną odpowiedź do poprawki?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Czy ustawić stan przepływu pracy w ocenianiu dla wszystkich zaznaczonych zadań?';
$string['batchoperationconfirmunlock'] = 'Odblokować wszystkie zaznaczone zadania?';
$string['batchoperationdownloadselected'] = 'Pobierz';
$string['batchoperationgrantextension'] = 'Rozszerz';
$string['batchoperationlock'] = 'Zablokuj';
$string['batchoperationremovesubmission'] = 'Usuń';
$string['batchoperationreverttodraft'] = 'Wróć do wersji roboczej';
$string['batchoperationsdescription'] = 'Z wybranymi ...';
$string['batchoperationunlock'] = 'Odblokuj';
$string['batchsetallocatedmarker'] = 'Ustaw osobę oceniającą dla {$a} wybranych użytkowników.';
$string['batchsetmarkingworkflowstateforusers'] = 'Ustaw stan przepływu pracy w ocenianiu {$a} dla wybranych użytkowników.';
$string['beginassignment'] = 'Rozpocznij zadanie';
$string['blindmarking'] = 'Anonimowe zadanie';
$string['blindmarking_help'] = 'To ustawienie ukrywa tożsamość przesyłającego zadanie przed oceniającym. Nie będzie możliwości zmiany tego ustawienia po przesłaniu pierwszego rozwiązania lub wystawieniu pierwszej oceny.';
$string['blindmarkingenabledwarning'] = 'Dla tej aktywności włączone jest anonimowe ocenianie. Oceny nie będą dodawane do dziennika ocen, dopóki tożsamość uczniów nie zostanie ujawniona w menu oceniania.';
$string['cachedef_overrides'] = 'Informacje o nadpisaniu użytkownika i grupy';
$string['calendardue'] = '{$a} (termin oddania)';
$string['calendargradingdue'] = '{$a} - termin wystawienia ocen';
$string['caneditsubmission'] = 'Możesz edytować swoje zadanie i przesłać je po upływie limitu czasu, ale zostanie ono oznaczone jako spóźnione.';
$string['changefilters'] = 'Zmień filtry';
$string['changeuser'] = 'Zmień użytkownika';
$string['choosegradingaction'] = 'Akcja oceniania';
$string['choosemarker'] = 'Wybierz ...';
$string['chooseoperation'] = 'Wybierz operację';
$string['clickexpandreviewpanel'] = 'Kliknij, aby rozwinąć panel recenzji';
$string['collapsegradepanel'] = 'Zwiń panel ocen';
$string['collapsereviewpanel'] = 'Zwiń panel recenzji';
$string['comment'] = 'Komentarz';
$string['completiondetail:submit'] = 'Prześlij zadanie';
$string['completionsubmit'] = 'Prześlij zadanie';
$string['configshowrecentsubmissions'] = 'Każdy może zobaczyć powiadomienia o przesłanych zadaniach w ostatnich raportach aktywności.';
$string['confirmbatchgradingoperation'] = 'Czy na pewno chcesz wykonać operację "{$a->operation}" dla {$a->count} studentów/a?';
$string['confirmstart'] = 'Masz {$a} na wykonanie tego zadania. Kiedy zaczniesz, stoper zacznie odliczać czas i nie będzie można go zatrzymać.';
$string['confirmsubmission'] = 'Czy na pewno chcesz wysłać swoje zadanie do oceny? Po tej operacji nie będzie już można dokonywać żadnych zmian.';
$string['confirmsubmissionheading'] = 'Potwierdź przesłanie zadania';
$string['conversionexception'] = 'Nie można przekonwertować zadania. Wyjątkiem: {$a}.';
$string['couldnotconvertgrade'] = 'Nie można przekonwertować oceny dla użytkownika {$a}.';
$string['couldnotconvertsubmission'] = 'Nie można przekonwertować zadania dla użytkownika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nie można było utworzyć modułu kursu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nie można było utworzyć instancji Zadania.';
$string['couldnotfindassignmenttoupgrade'] = 'Nie można było znaleźć starej instancji Zadania do ulepszenia.';
$string['crontask'] = 'Przetwarzanie w tle dla modułu zadań';
$string['currentassigngrade'] = 'Aktualna ocena w zadaniu';
$string['currentattempt'] = 'To jest próba nr {$a}.';
$string['currentattemptof'] = 'To jest próba nr {$a->attemptnumber} ( liczba dozwolonych prób: {$a->maxattempts} ).';
$string['currentgrade'] = 'Bieżąca ocena w dzienniku ocen';
$string['cutoffdate'] = 'Ostateczny termin';
$string['cutoffdate_help'] = 'Jeśli jest ustawione, prace nie będą akceptowane po tej dacie bez przedłużenia. Jeśli nie jest ustawione, prace będą zawsze akceptowane.';
$string['cutoffdatecolon'] = 'Ostateczny termin: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Data ostatecznego terminu nie może być wcześniejsza niż data, od której można składać zadania.';
$string['cutoffdatevalidation'] = 'Data ostatecznego terminu nie może być wcześniejsza niż data terminu oddania zadania.';
$string['defaultgradescale'] = 'Skala ocen';
$string['defaultgradescale_help'] = 'Domyślna skala oceniania nowych zadań. Dostępne są tylko standardowe skale.';
$string['defaultgradetype'] = 'Rodzaj oceny';
$string['defaultgradetype_help'] = 'Domyślny typ oceny dla nowych zadań.';
$string['defaultlayout'] = 'Przywróć domyślny układ';
$string['defaultsettings'] = 'Standardowe ustawienia zadania';
$string['defaultsettings_help'] = 'Ten parametr określa domyślne ustawienia dla wszystkich nowych zadań domowych.';
$string['defaultteam'] = 'Domyślna grupa';
$string['deleteallsubmissions'] = 'Wszystkie zadania';
$string['description'] = 'Opis';
$string['disabled'] = 'Wyłączone';
$string['downloadall'] = 'Pobierz wszystkie przesłane zadania';
$string['downloadasfolders'] = 'Pobierz zadania w folderach';
$string['downloadasfolders_help'] = 'Przypisane zadania mogą być pobrane w folderach. Każde zadanie jest wtedy pobierane do osobnego folderu, z zachowaniem struktury podfolderów i niezmienionymi nazwami plików.';
$string['downloadselectedsubmissions'] = 'Pobierz wybrane zadania';
$string['duedate'] = 'Termin wykonania';
$string['duedate_help'] = 'Określa termin oddania prac. Jeśli przesyłanie prac po tym terminie jest zezwolone, prace takie zostaną oznaczone jako spóźnione. Ustaw ostateczny termin przesyłania rozwiązań, aby zapobiec przesyłaniu treści po określonej dacie.';
$string['duedateaftersubmissionvalidation'] = 'Termin wykonania musi przypadać po terminie, od którego można przesyłać pracę.';
$string['duedatecolon'] = 'Termin: {$a}';
$string['duedatereached'] = 'Minął termin oddania tego zadania';
$string['duedatevalidation'] = 'Termin złożenia zadania nie może przypadać wcześniej niż data, od której przyjmowane są odpowiedzi.';
$string['duplicateoverride'] = 'Powiel nadpisanie';
$string['editaction'] = 'Akcje...';
$string['editattemptfeedback'] = 'Edytuj ocenę i komentarz dla próby numer {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Edytujesz komentarz dla poprzedniej próby. To jest próba nr {$a->attemptnumber} z {$a->totalattempts}.';
$string['editingstatus'] = 'Edycja statusu';
$string['editonline'] = 'Edytuj on-line';
$string['editoverride'] = 'Edytuj nadpisanie';
$string['editsubmission'] = 'Edytuj zadanie';
$string['editsubmission_help'] = 'Możesz nadal zmieniać przesłane zadanie.';
$string['editsubmissionother'] = 'Edytuj zadanie dla {$a}';
$string['enabled'] = 'Aktywny';
$string['enabletimelimit'] = 'Włącz zadania na czas';
$string['enabletimelimit_help'] = 'Jeśli ta opcja jest włączona, możesz ustawić limit czasu na stronie ustawień zadania.';
$string['errornosubmissions'] = 'Brak zadań do pobrania';
$string['errorquickgradingvsadvancedgrading'] = 'Oceny nie zostały zapisane, ponieważ zadanie wykorzystuje zaawansowaną metodę oceniania.';
$string['errorrecordmodified'] = 'Oceny nie zostały zapisane, ponieważ ktoś modyfikował któreś rozwiązanie po załadowaniu strony';
$string['eventallsubmissionsdownloaded'] = 'Wszystkie zadania zostały pobrane.';
$string['eventassessablesubmitted'] = 'Zadanie zostało przesłane.';
$string['eventbatchsetmarkerallocationviewed'] = 'Wyświetlono zbiorcze przypisanie osób oceniających';
$string['eventextensiongranted'] = 'Przyznano przedłużenie terminu oddania.';
$string['eventfeedbackupdated'] = 'Zaktualizowano komentarz oceniającego';
$string['eventfeedbackviewed'] = 'Wyświetlono informację zwrotną do zadania';
$string['eventgradingformviewed'] = 'Wyświetlono formularz oceniania';
$string['eventgradingtableviewed'] = 'Wyświetlono tabelę oceniania';
$string['eventidentitiesrevealed'] = 'Ujawniono tożsamości.';
$string['eventmarkerupdated'] = 'Zaktualizowano przydzieloną osobę oceniającą .';
$string['eventoverridecreated'] = 'Utworzono wyjątek zadania';
$string['eventoverridedeleted'] = 'Usunięto wyjątek zadania';
$string['eventoverrideupdated'] = 'Zaktualizowano wyjątek zadania';
$string['eventremovesubmissionformviewed'] = 'Usuń obejrzane potwierdzenie przesłania zadania?';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Wyświetlona strona potwierdzenia ujawnienia tożsamości.';
$string['eventstatementaccepted'] = 'Użytkownik zaakceptował oświadczenie o przesłaniu.';
$string['eventsubmissionconfirmationformviewed'] = 'Wyświetlono formularz potwierdzenia przesłania rozwiązania.';
$string['eventsubmissioncreated'] = 'Utworzono zadanie.';
$string['eventsubmissionduplicated'] = 'Użytkownik zduplikował przesłane rozwiązanie.';
$string['eventsubmissionformviewed'] = 'Wyświetlono formularz przesyłania rozwiązania.';
$string['eventsubmissiongraded'] = 'Praca została oceniona.';
$string['eventsubmissionlocked'] = 'Zadanie zostało zablokowanie dla użytkownika.';
$string['eventsubmissionremoved'] = 'Usunięto zadanie.';
$string['eventsubmissionstatusupdated'] = 'Status pracy został zaktualizowany.';
$string['eventsubmissionstatusviewed'] = 'Wyświetlono status zadania.';
$string['eventsubmissionunlocked'] = 'Zadanie zostało odblokowanie dla użytkownika.';
$string['eventsubmissionupdated'] = 'Zadanie zaktualizowane.';
$string['eventsubmissionviewed'] = 'Zadanie wyświetlone.';
$string['expandreviewpanel'] = 'Rozwiń panel recenzji';
$string['extensionduedate'] = 'Termin przedłużenia';
$string['extensionduedaterange'] = 'Różne między {$a->earliest} i {$a->latest}';
$string['extensionduedatewithout'] = 'Użytkownicy bez aktualnego rozszerzenia: {$a}';
$string['extensionnotafterduedate'] = 'Termin przedłużenia musi być późniejszy niż data oddania';
$string['extensionnotafterfromdate'] = 'Termin przedłużenia musi być późniejszy niż data zezwolenia na przesyłanie rozwiązań';
$string['feedback'] = 'Informacja zwrotna';
$string['feedbackavailableanonhtml'] = 'Masz nowy komentarz dotyczący twojego zadania \'<i>{$a->assignment}</i>\'<br /><br />
Możesz zobaczyć go w dołączonym <a href="{$a->url}">zadaniu</a>.';
$string['feedbackavailableanonsmall'] = 'Nowy komentarz dla zadania {$a->assignment}';
$string['feedbackavailableanontext'] = 'Masz nowy komentarz dotyczący twojego zadania \'{$a->assignment}\'

Możesz go zobaczyć tutaj: {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} przesłał komentarz do wysłanego zadania \'<i>{$a->assignment}</i>\'<br /><br /> Możesz go zobaczyć <a href="{$a->url}">tutaj</a>.';
$string['feedbackavailablesmall'] = '{$a->username} przesłał komentarz do zadania {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} przesłał komentarz do zadania \'{$a->assignment}\' możesz go zobaczyć tutaj: {$a->url}';
$string['feedbackplugin'] = 'Wtyczka informacji zwrotnej';
$string['feedbackpluginforgradebook'] = 'Wtyczka informacji zwrotnej która przeniesie komentarze do dziennika ocen';
$string['feedbackpluginforgradebook_help'] = 'Tylko jedna wtyczka informacji zwrotnej może przenieść komentarze do dziennika ocen';
$string['feedbackplugins'] = 'Wtyczki informacji zwrotnej';
$string['feedbacksettings'] = 'Ustawienia komentarza zwrotnego';
$string['feedbacktypes'] = 'Typy odpowiedzi zwrotnej';
$string['filesubmissions'] = 'Przesłane pliki';
$string['filter'] = 'Filtr';
$string['filterdraft'] = 'Szkic';
$string['filtergrantedextension'] = 'Przedłużony termin';
$string['filternone'] = 'Brak filtru';
$string['filternotsubmitted'] = 'Nie przesłano';
$string['filterrequiregrading'] = 'Wymaga oceny';
$string['filtersubmitted'] = 'Oddane';
$string['fixrescalednullgrades'] = 'To zadanie zawiera kilka błędnych ocen. Możesz <a href="{$a->link}">automatycznie poprawić te oceny</a>. Może to mieć wpływ na wyniki w kursie.';
$string['fixrescalednullgradesconfirm'] = 'Czy na pewno chcesz poprawić błędne oceny? Wszystkie oceny, których to dotyczy, zostaną usunięte. Może to mieć wpływ na wyniki w kursie.';
$string['fixrescalednullgradesdone'] = 'Naprawiono oceny.';
$string['gradeabovemaximum'] = 'Ocena musi być mniejsza lub równa {$a}';
$string['gradeactions'] = 'Akcje ocen';
$string['gradebelowzero'] = 'Ocena musi być większa lub równa zeru.';
$string['gradebreakdown'] = 'Analiza ocen';
$string['gradecanbechanged'] = 'Ocena może być zmieniona';
$string['gradechangessaveddetail'] = 'Zmiany w ocenie oraz infomacji zwrotnej zostały zapisane';
$string['graded'] = 'Ocenione';
$string['gradedby'] = 'Ocenione przez';
$string['gradedfollowupsubmit'] = 'Ocenione - ponownie przesłane';
$string['gradedon'] = 'Ocenione dnia';
$string['gradeitem:submissions'] = 'Przesłane zadania';
$string['gradelocked'] = 'Ta ocena jest zablokowana lub nadpisana w dzienniku ocen';
$string['gradeoutof'] = 'Ocena maksymalna: {$a}';
$string['gradeoutofhelp'] = 'Ocena';
$string['gradeoutofhelp_help'] = 'Wpisz tutaj ocenę za zadanie. Możesz używać liczb dziesiętnych.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} uaktualnił(a) <i>{$a->timeupdated}</i> oddane zadanie <i>\'{$a->assignment}\'</i><br /><br />
Zadanie <a href="{$a->url}">jest dostępne na stronie</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} uaktualnił(a) oddane zadanie {$a->assignment}';
$string['gradersubmissionupdatedtext'] = '{$a->username} uaktualnił(a) {$a->timeupdated} oddane zadanie \'{$a->assignment}\'

Zadanie jest dostępne tutaj:

    {$a->url}';
$string['gradestudent'] = 'Ocena studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Ocena {$a}';
$string['grading'] = 'Ocenianie';
$string['gradingchangessaved'] = 'Zmiana ocen(y) została zapisana';
$string['gradingduedate'] = 'Przypomnij mi o ocenianiu do...';
$string['gradingduedate_help'] = 'Data, do której ocenianie zadania powinno zostać zakończone. Ta data jest wykorzystywana do wyświetlania przypomnienia dla nauczyciela na kokpicie.';
$string['gradingdueduedatevalidation'] = 'Data „Przypomnij mi o ocenianiu do...” nie może być wcześniejsza niż termin przesyłania zadań.';
$string['gradingduefromdatevalidation'] = 'Data opcji "Przypomnij mi o ocenianiu do..." nie może być wcześniejsza niż termin oddania zadania.';
$string['gradingmethodpreview'] = 'Kryteria oceny';
$string['gradingoptions'] = 'Opcje';
$string['gradingstatus'] = 'Stan oceniania';
$string['gradingstudent'] = 'Ocenianie studentów';
$string['gradingsummary'] = 'Podsumowanie';
$string['grantextension'] = 'Przedłuż termin oddania';
$string['grantextensionforusers'] = 'Przedłuż termin oddania zadania dla {$a} studenta(ów)';
$string['groupoverrides'] = 'Wyjątki dla grupy';
$string['groupoverridesdeleted'] = 'Usunięto wyjątki dla grupy';
$string['groupsnone'] = 'Brak grup, do których masz dostęp.';
$string['groupsubmissionsettings'] = 'Ustawienia zadań grupowych';
$string['hiddenuser'] = 'Uczestnik';
$string['hidegrader'] = 'Ukryj tożsamość oceniającego przed uczniami';
$string['hidegrader_help'] = 'Jeśli ta opcja jest włączona, tożsamość użytkownika, który ocenia przesłane zadanie nie jest wyświetlana, więc uczestnicy nie widzą, kto oznaczył ich pracę.

Pamiętaj, że to ustawienie nie ma wpływu na pole komentarzy na stronie oceniania.';
$string['hideshow'] = 'Ukryj/pokaż';
$string['inactiveoverridehelp'] = '* To nadpisanie jest nieaktywne, ponieważ dostęp użytkownika do aktywności jest ograniczony. Może to być spowodowane przypisaniem do grupy lub roli, innymi ograniczeniami dostępu lub ukryciem aktywności.';
$string['indicator:cognitivedepth'] = 'Poznawczość Zadania';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas wykonywania zadania.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Zadania';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął określony procent zaangażowania poznawczego oferowanego przez aktywność Zadanie w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie, Wyświetlenie informacji zwrotnej, Skomentowanie informacji zwrotnej, Ponowne wysłanie po zapoznaniu się z informacją zwrotną)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Pliki instrukcji';
$string['introattachments'] = 'Dodatkowe pliki';
$string['introattachments_help'] = 'Można dodać dodatkowe pliki do wykorzystania w zadaniu, takie jak szablony odpowiedzi.';
$string['invalidfloatforgrade'] = 'Wpisana ocena nie została zrozumiana: {$a}';
$string['invalidgradeforscale'] = 'Wpisana ocena nie mieści się w wybranej skali';
$string['invalidoverrideid'] = 'Niepoprawny identyfikator wyjątku';
$string['lastmodifiedgrade'] = 'Ostatnia aktualizacja (ocena)';
$string['lastmodifiedsubmission'] = 'Ostatnia modyfikacja (przesłane rozwiązanie)';
$string['latesubmissions'] = 'Zadania oddane po terminie';
$string['latesubmissionsaccepted'] = 'Dozwolone aż do {$a}';
$string['loading'] = 'Ładowanie...';
$string['locksubmissionforstudent'] = 'Zablokuj przesyłanie rozwiązań studentowi (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Zablokuj przesyłanie zadań';
$string['manageassignfeedbackplugins'] = 'Zarządzaj wtyczkami informacji zwrotnej w zadaniach domowych';
$string['manageassignsubmissionplugins'] = 'Zarządzaj wtyczkami składania prac';
$string['marker'] = 'Osoba oceniająca';
$string['markerfilter'] = 'Filtr osób oceniających';
$string['markerfilternomarker'] = 'Brak osoby oceniającej';
$string['markingallocation'] = 'Przydział osób oceniających';
$string['markingallocation_help'] = 'Z tej opcji można korzystać tylko przy wlączonym trybie przepływu pracy w ocenianiu.
Osoby oceniające mogą być przydzielone do konkretnego studenta.';
$string['markingworkflow'] = 'Przepływ pracy w ocenianiu';
$string['markingworkflow_help'] = 'Jeśli ta opcja jest włączona, oceny przejdą przez serię etapów przepływu pracy, zanim zostaną udostępnione uczniom. Pozwala to na wiele rund oceniania i pozwala na udostępnienie ocen wszystkim studentom w tym samym czasie.';
$string['markingworkflowstate'] = 'Stan przepływu pracy w ocenianiu';
$string['markingworkflowstate_help'] = 'Możliwe stany w przepływie pracy mogą obejmować (w zależności od Twoich uprawnień):

* Nieocenione - oceniający nie rozpoczął jeszcze procesu oceniania
* W trakcie oceniania - oceniający rozpoczął ocenianie ale jeszcze go nie ukończył
* Ocenianie zakończone - oceniający ukończył ocenianie jednak w każdej chwili może wrócić do trybu oceniania w celu weryfikacji poprawności i naniesienia ewentualnych poprawek
* W trakcie przeglądu - oceniający dokonuje kontroli jakości wystawionej oceny
* Gotowe do publikacji - nauczyciel prowadzący zaakceptował wystawione oceny, ale czeka z publikacją ocen
* Ocena opublikowana - student ma dostęp do ocen/opinii';
$string['markingworkflowstateinmarking'] = 'W trakcie oceniania';
$string['markingworkflowstateinreview'] = 'W trakcie przeglądu';
$string['markingworkflowstatenotmarked'] = 'Nie ocenione';
$string['markingworkflowstatereadyforrelease'] = 'Gotowe do publikacji';
$string['markingworkflowstatereadyforreview'] = 'Ocenianie zakończone';
$string['markingworkflowstatereleased'] = 'Ocena opublikowana';
$string['maxattempts'] = 'Dozwolonych prób';
$string['maxattempts_help'] = 'Maksymalna liczba podejść do zadania. Po przekroczeniu tej liczby student/uczestnik nie ma możliwości ponownego rozwiązania/wysłania zadania.';
$string['maxgrade'] = 'Maksymalna ocena';
$string['maxperpage'] = 'Maksymalna liczba zadań na stronie';
$string['messageprovider:assign_due_digest'] = 'Zadania do wykonania w ciągu 7 dni od powiadomienia';
$string['messageprovider:assign_due_soon'] = 'Powiadomienie o terminie wykonania zadania';
$string['messageprovider:assign_notification'] = 'Powiadomienia o zadaniach';
$string['messageprovider:assign_overdue'] = 'Powiadomienie o zaległych zadaniach';
$string['modulename'] = 'Zadanie';
$string['modulename_help'] = 'Moduł zadania pozwala nauczycielowi na komunikowanie się, zbieranie prac, ocenę i ich komentowanie.

Studenci składają prace w formie plików dowolnego typu (tekstowe, multimedialne, obrazy itd). Prace mogą być składane w postaci tekstu wprowadzanego bezpośrednio w edytorze na stronie. Moduł zadania domowego może być także wykorzystany do przypomnienia studentom o zadaniach z poza systemu Moodle (zadania offline).

Nauczyciel oceniając zadania może zamieścić komentarz, oraz przesłać pliki (np. poprawioną pracę studenta, czy plik audio z komentarzem). Ocena może być wystawiona w skali numerycznej lub innej. Wystawione oceny widoczne są w dzienniku ocen.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Zadania';
$string['moreusers'] = '{$a} więcej ...';
$string['multipleteams'] = 'Członek więcej niż jednej grupy';
$string['multipleteams_desc'] = 'To jest zadanie grupowe. Jesteś członkiem więcej niż jednej grupy. By móc przesłać zadanie musisz być członkiem tylko jednej grupy. Skontaktuj się z nauczycielem w celu zmiany przynależności do grup.';
$string['multipleteamsgrader'] = 'Członek więcej niż jednej grupy, więc nie może przesłać zadania.';
$string['newsubmissions'] = 'Oddane zadania';
$string['nextuser'] = 'Następny użytkownik';
$string['noattempt'] = 'Nie próbowano';
$string['noclose'] = 'Brak daty zamknięcia';
$string['nofiles'] = 'Brak plików.';
$string['nofilters'] = 'Brak filtrów';
$string['nograde'] = 'Brak oceny.';
$string['nogroupoverrides'] = 'Obecnie nie ma nadpisań grup.';
$string['nomoresubmissionsaccepted'] = 'Dozwolone tylko dla uczestników, którym przedłużono termin oddania';
$string['none'] = 'Żaden';
$string['noonlinesubmissions'] = 'To zadanie nie wymaga wysyłania niczego online';
$string['noopen'] = 'Brak daty otwarcia';
$string['nooverridedata'] = 'Musisz zastąpić co najmniej jedno z ustawień zadania';
$string['nosavebutnext'] = 'Następne';
$string['nosubmission'] = 'Żadne rozwiązanie nie zostało przesłane do tego zadania';
$string['nosubmissionyet'] = 'Nie przesłano jeszcze zadania';
$string['noteam'] = 'Nie jesteś członkiem żadnej grupy';
$string['noteam_desc'] = 'To jest zadanie grupowe. Nie jesteś członkiem żadnej grupy, więc nie możesz przesłać rozwiązania. Skontaktuj się z nauczycielem w celu dodania do grupy.';
$string['noteamgrader'] = 'Nie jesteś członkiem żadnej grupy, więc nie może wykonać zadania.';
$string['notgraded'] = 'Nieocenione';
$string['notgradedyet'] = 'Jeszcze nieocenione';
$string['notifications'] = 'Powiadomienia';
$string['notifystudents'] = 'Powiadom studentów';
$string['nouseroverrides'] = 'Obecnie nie ma nadpisań użytkownia.';
$string['nousers'] = 'Brak użytkowników';
$string['nousersselected'] = 'Nie wybrano użytkownika';
$string['numberofdraftsubmissions'] = 'Wersje robocze';
$string['numberofparticipants'] = 'Uczestnicy';
$string['numberofsubmissionsneedgrading'] = 'Wymaga oceny';
$string['numberofsubmissionsneedgradinglabel'] = 'Wymaga oceny: {$a}';
$string['numberofsubmittedassignments'] = 'Nadesłane';
$string['numberofteams'] = 'Grupy';
$string['offline'] = 'Wysyłanie online nie jest wymagane';
$string['open'] = 'Otwarte';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['outof'] = '{$a->current} z {$a->total}';
$string['overdue'] = 'Opóźnienie w przesłaniu: {$a}';
$string['override'] = 'Wyjątki';
$string['overridedeletegroupsure'] = 'Czy na pewno chcesz usunąć nadpisanie dla grupy {$a}?';
$string['overridedeleteusersure'] = 'Czy na pewno chcesz usunąć nadpisanie dla użytkownika {$a}?';
$string['overridegroup'] = 'Wyjątek grupy';
$string['overrides'] = 'Wyjątki';
$string['overrideuser'] = 'Wyjątek użytkownika';
$string['overrideusereventname'] = '{$a->assign} - nadpisanie';
$string['page-mod-assign-view'] = 'Strona główna i strona składania prac w module zadania';
$string['page-mod-assign-x'] = 'Każda strona modułu Zadanie';
$string['paramtimeremaining'] = 'Pozostało {$a}';
$string['participant'] = 'Uczestnik';
$string['pluginadministration'] = 'Administracja Zadaniem';
$string['pluginname'] = 'Zadanie';
$string['preventsubmissionnotingroup'] = 'Wymaga grup do przesłania zadania';
$string['preventsubmissionnotingroup_help'] = 'Jeżeli opcja jest włączona, to użytkownicy, którzy nie są członkami grupy nie będą mogli przesłać zadania.';
$string['preventsubmissions'] = 'Zabroń użytkownikowi wysyłania rozwiązań do zadania';
$string['preventsubmissionsshort'] = 'Zablokuj przesyłanie prac';
$string['previous'] = 'Poprzedni';
$string['previoususer'] = 'Poprzedni użytkownik';
$string['privacy:attemptpath'] = 'próba {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identyfikator używany do anonimowych zadań';
$string['privacy:gradepath'] = 'ocena';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Dane komentarzy dla zadania.';
$string['privacy:metadata:assigngrades'] = 'Przechowuje oceny zadań użytkownika';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtruj podsumowania zadań według przypisanej osoby oceniającej.';
$string['privacy:metadata:assignmentid'] = 'Identyfikator zadania';
$string['privacy:metadata:assignmessageexplanation'] = 'Wiadomości są wysyłane do studentów za pośrednictwem systemu wiadomości.';
$string['privacy:metadata:assignperpage'] = 'Liczba zadań wyświetlanych na stronie.';
$string['privacy:metadata:assignquickgrading'] = 'Ustawienie dotyczące tego, czy stosuje się szybkie ocenianie, czy nie.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Przechowuje informacje przesłane przez użytkownika';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtruj według różnych etapów przepływu pracy.';
$string['privacy:metadata:grader'] = 'Identyfikator użytkownika osoby oceniającej.';
$string['privacy:metadata:groupid'] = 'Identyfikator grupy, której członkiem jest użytkownik.';
$string['privacy:metadata:mailed'] = 'Czy ten użytkownik został już powiadomiony mailowo?';
$string['privacy:metadata:timecreated'] = 'Czas utworzenia';
$string['privacy:metadata:timestarted'] = 'Czas wystartował';
$string['privacy:metadata:userid'] = 'Identyfikator użytkownika';
$string['quickgrading'] = 'Szybkie ocenianie';
$string['quickgrading_help'] = 'Szybkie ocenianie pozwala  wpisywać oceny i wyniki bezpośrednio do tabeli przesłanych rozwiązań. Szybkie  ocenianie  nie jest kompatybilne z zaawansowaną metodą oceniania.';
$string['quickgradingchangessaved'] = 'Zmiana ocen(y) została zapisana';
$string['quickgradingresult'] = 'Szybkie ocenianie';
$string['recordid'] = 'identyfikator';
$string['relativedatessubmissiontimeleft'] = 'Obliczany dla każdego studenta';
$string['removeallgroupoverrides'] = 'Wszystkie wyjątki dla grupy';
$string['removealluseroverrides'] = 'Wszystkie wyjątki dla użytkownika';
$string['removesubmission'] = 'Usuń zadanie';
$string['removesubmissionconfirm'] = 'Czy na pewno chcesz usunąć swoje zadanie?';
$string['removesubmissionconfirmforstudent'] = 'Czy na pewno chcesz usunąć dane zadania dla {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Czy na pewno chcesz usunąć dane zadania dla {$a}? Należy pamiętać, że nie spowoduje to zresetowania limitu czasu studenta. Możesz dać więcej czasu, dodając nadpisanie ograniczenia czasu użytkownika.';
$string['removesubmissionconfirmwithtimelimit'] = 'Czy na pewno chcesz usunąć swoje zadanie? Pamiętaj, że nie spowoduje to zresetowania limitu czasu.';
$string['removesubmissionforstudent'] = 'Usuń zadanie studenta (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Opcja Otwórz ponownie do zaliczenia jest niekompatybilna z anonimowymi zadaniami. Oceny nie są publikowane w dzienniku ocen, dopóki tożsamość studenta nie zostanie ujawniona.';
$string['requireallteammemberssubmit'] = 'Wymaga potwierdzenia przez wszystkich członków grupy';
$string['requireallteammemberssubmit_help'] = 'Jeśli ustawienie jest aktywne, wtedy wszyscy członkowie grupy muszą kliknąć opcję "Zgłoś zadanie". Jeśli ustawienie nie jest aktywne - zadanie będzie uznane jako zgłoszone do oceny, gdy jeden z członków grupy kliknie opcję "Zgłoś zadanie".';
$string['requiresubmissionstatement'] = 'Czy wymagać oświadczenia dot. przesyłanego zadania?';
$string['requiresubmissionstatement_help'] = 'Włączenie tej opcji powoduje, że przy składaniu wszystkich prac (aktywność Zadanie) w całej instalacji Moodla, będzie wymagane złożenie przez studentów oświadczenia. Jeśli opcja jest wyłączona wymuszenie składania oświadczeń może być włączone lub wyłączone przy każdej aktywności "Zadanie".';
$string['revealidentities'] = 'Ujawnij tożsamość studenta';
$string['revealidentitiesconfirm'] = 'Czy na pewno ujawnić tożsamość studenta dla tego zadania? Tej operacji nie będzie można cofnąć. Kiedy tożsamość studenta będzie ujawniona, oceny pojawią się w dzienniku ocen.';
$string['reverttodefaults'] = 'Przywróć domyślne ustawienia zadania';
$string['reverttodraft'] = 'Przywróć status zadania do wersji roboczej';
$string['reverttodraftforgroup'] = 'Przywróć status zadania do wersji roboczej dla grupy {$a}.';
$string['reverttodraftforstudent'] = 'Zwróć odpowiedź do poprawki dla studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Zwróć odpowiedź do poprawki';
$string['reviewed'] = 'Przejrzane';
$string['save'] = 'Zapisz';
$string['saveallquickgradingchanges'] = 'Zapisz wszystkie zmiany w szybkim ocenianiu';
$string['saveandcontinue'] = 'Zapisz i kontynuj';
$string['savechanges'] = 'Zapisz zmiany';
$string['savegradingresult'] = 'Ocena';
$string['savenext'] = 'Zapisz i pokaż kolejne';
$string['saveoverrideandstay'] = 'Zapisz i wprowadź nowy wyjątek';
$string['savingchanges'] = 'Zapisywanie zmian...';
$string['scale'] = 'Skala';
$string['search:activity'] = 'Zadanie - informacje o aktywności';
$string['selectedusers'] = 'Wybrani użytkownicy';
$string['selectlink'] = 'Wybierz ...';
$string['selectuser'] = 'Wybierz {$a}';
$string['sendlatenotifications'] = 'Poinformuj oceniających o zadaniach złożonych po terminie oddania';
$string['sendlatenotifications_help'] = 'Jeśli ta opcja jest włączona, oceniający (zwykle nauczyciele) otrzymują powiadomienie, gdy tylko student prześle zadanie po ustalonym terminie. Formy otrzymywanych powiadomień można dostosować.';
$string['sendnotificationduedatesoon'] = 'Powiadom użytkownika o zbliżającym się terminie oddania zadania';
$string['sendnotificationduedigest'] = 'Powiadom użytkownika o zadaniach, których termin oddania przypada za 7 dni';
$string['sendnotificationoverdue'] = 'Powiadom użytkownika o opóźnionym zadaniu';
$string['sendnotifications'] = 'Zawiadamiaj oceniających o przesłanych zadaniach';
$string['sendnotifications_help'] = 'Jeśli ta opcja jest włączona, oceniający (zazwyczaj nauczyciele) dostaną wiadomość, gdy tylko student złoży zadanie - przed czasem, na czas, bądź po terminie oddania. Formy otrzymywanych powiadomień można dostosować.';
$string['sendstudentnotifications'] = 'Poinformuj studenta';
$string['sendstudentnotifications_help'] = 'Jeżeli opcja jest włączona, studenci otrzymują wiadomość o zmianie oceny lub informacji zwrotnej. Jeśli włączony jest "Przepływ pracy w ocenianiu", powiadomienia nie zostaną rozesłane, dopóki ocena nie zostanie opublikowana ("Released").';
$string['sendstudentnotificationsdefault'] = 'Domyślne ustawienie dla opcji "Poinformuj studenta"';
$string['sendstudentnotificationsdefault_help'] = 'Ustaw wartość domyślną opcji "Poinformuj studenta" na stronie oceniania.';
$string['sendsubmissionreceipts'] = 'Wyślij potwierdzenie studentom po przesłaniu rozwiązania zadania';
$string['sendsubmissionreceipts_help'] = 'Opcja włączy potwierdzenia wysyłane studentom, gdy tylko poprawnie wyślą rozwiązania do zadania';
$string['setmarkerallocationforlog'] = 'Ustaw przypisanie osoby oceniającej : (identyfikator={$a->id}, imię i nazwisko={$a->fullname}, osoba oceniająca={$a->marker}).';
$string['setmarkingallocation'] = 'Ustaw osobę oceniającą';
$string['setmarkingworkflowstate'] = 'Ustaw stan przepływu pracy w ocenianiu';
$string['setmarkingworkflowstateforlog'] = 'Ustaw stan przepływu pracy w ocenianiu : (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Ustawienia zadania';
$string['showrecentsubmissions'] = 'Pokaż ostatnio przesłane zadania';
$string['status'] = 'Status';
$string['submission'] = 'Oddane zadanie';
$string['submissionattachments'] = 'Pokazuj pliki tylko podczas przesyłania';
$string['submissionattachments_help'] = 'Zaznacz, jeśli pliki mają być widoczne tylko na stronie wykonywania / przesyłania zadania. W przeciwnym razie, pliki będą dostępne zarówno na stronie opisu zadania, jak i na stronie wykonywania / przesyłania zadania.';
$string['submissioncopiedhtml'] = '<p>Utworzyłeś kopię poprzednio wysłanego zadania dla \'<i>{$a->assignment}</i>\'.</p>
<p>Możesz zobaczyć stan swojego <a href="{$a->url}">przesłania zadania</a>.</p>';
$string['submissioncopiedsmall'] = 'Skopiowałeś swoją poprzednią pracę przesłaną w ramach {$a->assignment}';
$string['submissioncopiedtext'] = 'Zrobiłeś kopię swojego poprzednio wysłanego zadania dla \'{$a->assignment}
Możesz zobaczyć status przesłanego zadania: {$a->url}';
$string['submissiondrafts'] = 'Wymuś potwierdzanie przesłanego rozwiązania przez studentów';
$string['submissiondrafts_help'] = 'Jeśli aktywne, student musi oznaczyć składaną pracę jako zakończoną, poprzez kliknięcie na przycisk. To pozwoli studentowi na przechowywanie niedokończonej pracy w systemie. Jeśli zmienisz ten parametr z "Nie" na "Tak" po złożeniu prac przez studentów, te prace zostaną potraktowane jako zakończone.';
$string['submissioneditable'] = 'Student może edytować to zadanie';
$string['submissionempty'] = 'Nic nie przesłano';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionmodifiedgroup'] = 'Zadanie zostało zmodyfikowane przez kogoś innego. Proszę opuścić tę stronę i spróbować ponownie.';
$string['submissionnotcopiedinvalidstatus'] = 'Zadanie nie zostało skopiowane, ponieważ zostało wyedytowane od momentu ponownego otwarcia.';
$string['submissionnoteditable'] = 'Student nie może edytować tego zadania';
$string['submissionnotopen'] = 'To zadanie nie jest otwarte do przesyłania';
$string['submissionnotready'] = 'Zadanie nie jest gotowe do przesyłania rozwiązań';
$string['submissionplugins'] = 'Wtyczki przesyłania zadań';
$string['submissionreceipthtml'] = '<p>Przesłałeś (-łaś) rozwiązanie do zadania: \'<i>{$a->assignment}</i>\'.</p>
<p>Możesz zobaczyć status swojej odpowiedzi <a href="{$a->url}">tutaj</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Przesłano rozwiązanie do zadania \'<i>{$a->assignment}</i>\'<br /><br />
Możesz zobaczyć status swojego rozwiązania <a href="{$a->url}">tutaj</a>.';
$string['submissionreceiptothersmall'] = 'Przesłano rozwiązanie do zadania {$a->assignment}';
$string['submissionreceiptothertext'] = 'Przesłano rozwiązanie do zadania \'{$a->assignment}\'

Możesz zobaczyć status swojego rozwiązania tutaj:

    {$a->url}';
$string['submissionreceipts'] = 'Wysyłaj potwierdzenia przesłania rozwiązania';
$string['submissionreceiptsmall'] = 'Przesłano rozwiązanie do zadania  {$a->assignment}';
$string['submissionreceipttext'] = 'Przesłano rozwiązanie do zadania  {$a->assignment}, możesz zobaczyć status swojego rozwiązania tutaj: {$a->url}';
$string['submissions'] = 'Oddane zadania';
$string['submissionsclosed'] = 'Przesyłanie rozwiązań do zadania jest zamknięte';
$string['submissionsettings'] = 'Ustawienia przesyłania zadania';
$string['submissionslocked'] = 'Przesyłanie prac jest zablokowane';
$string['submissionslockedshort'] = 'Przesyłanie prac zablokowane';
$string['submissionstatement'] = 'Oświadczenie dot. przesyłanego zadania';
$string['submissionstatement_help'] = 'Oświadczenie, które każdy student musi zaakceptować, aby przesłać swoje zadanie.';
$string['submissionstatementacceptedlog'] = 'Oświadczenie dot. przysyłanego zadania, złożone przez {$a}';
$string['submissionstatementdefault'] = 'Przekazany materiał jest moją własną pracą, z wyłączeniem treści oznaczonych przeze mnie jako wykorzystujące dzieła innych osób.';
$string['submissionstatementrequired'] = 'Przed przesłaniem musisz wyrazić zgodę na to oświadczenie.';
$string['submissionstatementteamsubmission'] = 'Oświadczenie dot. przesłanego zadania grupowego';
$string['submissionstatementteamsubmission_help'] = 'Oświadczenie, które każdy student musi zaakceptować, aby przesłać zadanie swojej grupy.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Oświadczenie dot. przesłanego zadania grupowego, zatwierdzone przez wszystkich członków grupy';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Oświadczenie, które każdy student musi zaakceptować, aby przesłać zadanie jako członek grupy.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Przekazany materiał jest moją własną pracą jako członka grupy, z wyłączeniem treści oznaczonych przeze mnie jako wykorzystujące dzieła innych osób.';
$string['submissionstatementteamsubmissiondefault'] = 'Przekazany materiał jest pracą mojej grupy, z wyłączeniem treści oznaczonych przez nas jako wykorzystujące dzieła innych osób.';
$string['submissionstatus'] = 'Status przesłanego zadania';
$string['submissionstatus_'] = 'Brak przesłanego zadania';
$string['submissionstatus_draft'] = 'Wersja robocza';
$string['submissionstatus_marked'] = 'Ocenione';
$string['submissionstatus_new'] = 'Brak przesłanego zadania';
$string['submissionstatus_reopened'] = 'Ponownie otwarte';
$string['submissionstatus_submitted'] = 'Przesłane do oceny';
$string['submissionstatusheading'] = 'Status przesłanego zadania';
$string['submissionsummary'] = '{$a->status}. Ostatnio modyfikowane: {$a->timemodified}';
$string['submissionteam'] = 'Grupa';
$string['submissiontypes'] = 'Typy zadań';
$string['submitaction'] = 'Prześlij';
$string['submitassignment'] = 'Zgłoś zadanie';
$string['submitassignment_help'] = 'Po zgłoszeniu tego zadania, nie będzie można wprowadzić zmian.';
$string['submitforgrading'] = 'Prześlij do oceny';
$string['submitted'] = 'Oddane';
$string['submittedearly'] = 'Zadanie zostało przesłane {$a} przed terminem';
$string['submittedlate'] = 'Zadanie zostało przesłane {$a} po terminie';
$string['submittedlateshort'] = '{$a} po terminie';
$string['submittedovertime'] = 'Zadanie zostało przesłane {$a} po upływie terminu';
$string['submittedundertime'] = 'Zadanie zostało przesłane {$a} w terminie';
$string['subplugintype_assignfeedback'] = 'Wtyczka informacji zwrotnej';
$string['subplugintype_assignfeedback_plural'] = 'Wtyczki informacji zwrotnej';
$string['subplugintype_assignsubmission'] = 'Wtyczka przesyłania';
$string['subplugintype_assignsubmission_plural'] = 'Wtyczki przesyłania';
$string['teamname'] = 'Zespół: {$a}';
$string['teamsubmission'] = 'Zadanie realizowane w grupie';
$string['teamsubmission_help'] = 'Jeśli ustawienie jest aktywne, zadanie będzie podzielone na grupy (podział grup jest zgodny z domyślnymi ustawieniami grup w ramach przedmiotu). Zadanie będzie współdzielone przez daną grupę. Każdy członek grupy ma możliwość wglądu w zmiany dokonywane przez pozostałych członków grupy.';
$string['teamsubmissiongroupingid'] = 'Grupa nadrzędna dla grup studenckich';
$string['teamsubmissiongroupingid_help'] = 'To ustawienie pozwala na udostępnienie zadania kilku grupom. Jeśli to ustawienie jest nieaktywne, do zadania będą przypisane grupy ustawione domyślnie w ramach przedmiotu.';
$string['textinstructions'] = 'Instrukcje zadania';
$string['timelimit'] = 'Limit czasu';
$string['timelimit_help'] = 'Jeśli ta opcja jest włączona, limit czasu jest podany na stronie zadania, a podczas zadania wyświetlany jest licznik czasu.';
$string['timelimitnotenabled'] = 'Limit czasu nie jest włączony dla zadania.';
$string['timelimitpassed'] = 'Upłynął limit czasu';
$string['timemodified'] = 'Ostatnio modyfikowane';
$string['timeremaining'] = 'Pozostały czas';
$string['timeremainingcolon'] = 'Pozostały czas: {$a}';
$string['togglezoom'] = 'Powiększ / pomniejsz obszar';
$string['ungroupedusers'] = 'Włączona jest opcja: "Wymaga grup do przesłania zadania"; użytkownicy, którzy nie są członkami żadnej grupy lub są członkami więcej niż jednej grupy nie mogą przesłać zadania.';
$string['ungroupedusersoptional'] = 'Włączona jest opcja: "Zadanie realizowane w grupie"; użytkownicy, którzy nie są członkami żadnej grupy lub są członkami więcej niż jednej grupy będą przesyłać zadania jako członkowie grupy domyślnej.';
$string['unlimitedattempts'] = 'Nieograniczony';
$string['unlimitedattemptsallowed'] = 'Nieograniczone próby są dozwolone.';
$string['unlimitedpages'] = 'Nielimitowany';
$string['unlocksubmissionforstudent'] = 'Pozwól na złożenie pracy studentowi: (id = {$a->id}, imię i nazwisko = {$a->fullname}).';
$string['unlocksubmissions'] = 'Odblokuj przesyłanie zadań';
$string['unsavedchanges'] = 'Niezapisane zmiany';
$string['unsavedchangesquestion'] = 'Istnieją niezapisane zmiany ocen lub komentarzy. Czy chcesz zapisać zmiany i kontynuować?';
$string['updategrade'] = 'Aktualizacja oceny';
$string['updatetable'] = 'Zapisz i zaktualizuj tabelę';
$string['upgradenotimplemented'] = 'Aktualizacja nie zaimplementowana we wtyczce ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Domyślne ustawienia zadania użytkownika';
$string['userextensiondate'] = 'Przedłużono termin oddania do: {$a}';
$string['usergrade'] = 'Ocena użytkownika';
$string['useridlistnotcached'] = 'Nie udało się zapisać zmiany ocen, ponieważ nie było możliwe określenie, dla którego zadania były przeznaczone.';
$string['useroverrides'] = 'Wyjątki dla użytkownika';
$string['useroverridesdeleted'] = 'Usunięto wyjątki dla użytkownika';
$string['usersnone'] = 'Żaden student nie ma dostępu do tego zadania.';
$string['usersubmissioncannotberemoved'] = 'Zadanie {$a} nie może być usunięte.';
$string['userswhoneedtosubmit'] = 'Użytkownicy, którzy muszą potwierdzić zadanie: {$a}';
$string['validmarkingworkflowstates'] = 'Poprawne stany w przepływie pracy w ocenianiu';
$string['viewadifferentattempt'] = 'Wyświetl inne podejście';
$string['viewfeedback'] = 'Wyświetl informację zwrotną';
$string['viewfeedbackforuser'] = 'Wyświetl informację zwrotną dla użytkownika: {$a}';
$string['viewfull'] = 'Zobacz całość';
$string['viewfullgradingpage'] = 'Otwórz stronę oceniania aby zamieścić informację zwrotną';
$string['viewgradebook'] = 'Zobacz dziennik ocen';
$string['viewgrading'] = 'Zobacz wszystkie zadania';
$string['viewgradingformforstudent'] = 'Otwórz stronę oceniania dla studenta: (id = {$a->id}, imię i nazwisko = {$a->fullname}).';
$string['viewownsubmissionform'] = 'Wyświetl swoją stronę składania pracy';
$string['viewownsubmissionstatus'] = 'Wyświetl stronę ze statusem swojej pracy';
$string['viewrevealidentitiesconfirm'] = 'Wyświetl stronę potwierdzenia ujawnienia tożsamości ucznia.';
$string['viewsubmission'] = 'Wyświetl pracę domową';
$string['viewsubmissionforuser'] = 'Wyświetl pracę użytkownika: {$a}';
$string['viewsubmissiongradingtable'] = 'Wyświetl tabelę oceniania prac.';
$string['viewsummary'] = 'Zobacz podsumowanie';
$string['workflowfilter'] = 'Filtr przepływu pracy';
$string['xofy'] = '{$a->x} z {$a->y}';
