<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mediagallery', language 'pl', version '5.0'.
 *
 * @package     mediagallery
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addagallery'] = 'Dodaj galerię';
$string['addanitem'] = 'Dodaj element';
$string['addbulkitems'] = 'Dodaj elementy hurtowo - ZIP';
$string['addfiles'] = 'Dodaj plik(i)';
$string['addsamplegallery'] = 'Dodaj przykładową galerię';
$string['allowcomments'] = 'Zezwól na komentarze';
$string['allowcomments_help'] = 'Pozwól użytkownikom na komentowanie elementów i galerii.';
$string['allowlikes'] = 'Zezwól na polubienia';
$string['allowlikes_help'] = 'Pozwól użytkownikom "polubić" elementy w galerii.';
$string['areagallery'] = 'Galerie';
$string['areaitem'] = 'Elementy';
$string['arealowres'] = 'Niska rozdzielczość';
$string['areathumbnail'] = 'Miniaturki';
$string['assignedit'] = 'Edytuj zadanie';
$string['assignsubmit'] = 'Prześlij zadanie';
$string['assignsubmitted'] = 'Zadanie złożone';
$string['automatic'] = 'Automatycznie';
$string['beingprocessed'] = 'przetwarzanie';
$string['bottom'] = 'Spód';
$string['broadcaster'] = 'Organizator';
$string['broadcaster_help'] = 'Kto nadzorował tę pracę?';
$string['caption'] = 'Nazwa';
$string['caption_help'] = 'Podpis dla tej pozycji w twojej galerii. Ten napis będzie wyświetlany obok tego elementu. Jeśli zdecydujesz się pozostawić to puste miejsce, nazwa pliku (lub url) będzie wyświetlana jako podpis.';
$string['captionposition'] = 'Pozycja podpisu';
$string['carousel'] = 'Karuzela';
$string['choosecontent'] = 'Wybierz plik do przesłania lub adres URL w opcjach poniżej.';
$string['close'] = 'Zamknij';
$string['collection'] = 'Kolekcja';
$string['collection_help'] = 'Zbiór do przeszukania.';
$string['collectionwasdeleted'] = 'Niestety ta kolekcja już nie istnieje i została usunięta z tego kursu.';
$string['collmode'] = 'Tryb zbierania danych';
$string['collmode_help'] = 'To determinuje czy kolekcja będzie wyłącznie w Moodle, czy też będzie połączona z TheBoxem. Po ustawieniu tej wartości nie można jej zmienić.

<ul><li>Standard: w tym trybie kolekcja, jej galerie i przedmioty, są przechowywane wyłącznie w Moodle.</li></ul>';
$string['colltype'] = 'Rodzaj kolekcji';
$string['colltype_help'] = 'Typ kolekcji określa, na jakim poziomie użytkownicy mogą wchodzić w interakcję z kolekcją i jej zawartością.

<ul>
<li>Kolekcja prowadzącego: Tylko użytkownicy, którzy mogą oceniać kolekcję mogą dodawać/edytować zawartość w niej. Jest to głównie używane przez instruktorów do tworzenia przykładowych kolekcji; lub zestawu galerii bez pozwalania użytkownikom na tworzenie swoich własnych.</li>
<li>Współtworzona kolekcja: Pozwala użytkownikom na tworzenie własnych galerii i przedmiotów, ale kolekcja nie może być użyta jako część zadania.</li>
<li>Współtworzona kolekcja: Użytkownicy mogą zobaczyć tylko te galerie, które sami stworzyli lub ich grupa (jeśli są w trybie grupowym). Może być użyta jako część składowa zadania.</li>
<li>Kolekcja zadań recenzowanych przez współuczestników: Użytkownicy mogą przeglądać galerie innych użytkowników/grup i lubić/komentować je, jeśli te funkcje są włączone. Może być użyta jako część zadania.</li></ul>';
$string['colltypeassignment'] = 'Kolekcja jako zadanie';
$string['colltypecontributed'] = 'Współtworzona kolekcja';
$string['colltypeinstructor'] = 'Kolekcja prowadzącego';
$string['colltypepeerreviewed'] = 'Kolekcja zadań recenzowanych przez współuczestników';
$string['colltypesingle'] = 'Pojedyńcza kolekcja';
$string['comments'] = 'Komentarze';
$string['completegallery'] = 'Całkowita galeria';
$string['configdisablestandardgallery'] = 'Uniemożliwia użytkownikom tworzenie standardowych galerii.';
$string['configenablethebox'] = 'Musi to być włączone, aby użytkownicy mogli tworzyć nowe kolekcje i treści oparte na TheBoxie. W przypadku wyłączenia tej opcji, istniejące kolekcje będą wyświetlać komunikat informujący o tym, że dana aktywność jest aktualnie niedostępna. Nie będzie to miało wpływu na standardowe kolekcje.';
$string['configmaxbytes'] = 'Domyślny maksymalny rozmiar pliku elementu dla wszystkich kolekcji nośników w witrynie (z zastrzeżeniem ograniczeń kursu i innych ustawień lokalnych)';
$string['confirmcollectiondelete'] = 'Potwierdź skasowanie kolekcji';
$string['confirmgallerydelete'] = 'Potwierdź skasowanie galerii';
$string['confirmitemdelete'] = 'Potwierdź skasowanie elementu';
$string['content'] = 'Zawartość';
$string['content_help'] = 'Element, który chcesz dodać do swojej galerii.';
$string['contentbulk'] = 'Zawartość';
$string['contentbulk_help'] = 'Można wybrać archiwum ZIP zawierające wiele obrazów, które po załadowaniu zostaną rozpakowane do katalogu obrazów.';
$string['contentbulkheader'] = 'Tutaj możesz załadować archiwum ZIP pełne multimediów. Każdy plik wewnątrz archiwum ZIP zostanie dodany jako pozycja w galerii, więc przed wysłaniem go upewnij się, że tylko pliki, które chcesz przesłać, znajdują się w archiwum. Foldery wewnątrz archiwum są ignorowane.';
$string['contentlinked'] = 'Zawartość';
$string['contentlinked_help'] = 'Po połączeniu elementu z zawartością w theBox, nie można zmienić połączonego pliku.';
$string['contentlinkedinfo'] = 'Ta pozycja jest powiązana z plikiem {$a} w theBox.';
$string['contributable'] = 'Wpółtworzona';
$string['contributable_help'] = 'Kiedy galeria jest współtworzona, pozwala innym użytkownikom na dodawanie treści do Twojej galerii. Będą oni ograniczeni tylko do edycji swoich własnych elementów. Twórca galerii będzie miał możliwość usuwania elementów z galerii.';
$string['copyright'] = 'Prawa autorskie';
$string['copyright_help'] = 'To określa, jaka licencja na prawa autorskie jest ustawiona dla wszystkich elementów, które załadujesz za pomocą tego formularza.';
$string['createdby'] = 'Stworzony przez: {$a}';
$string['creator'] = 'Autor';
$string['datecreated'] = 'Data utworzenia';
$string['deletegallery'] = 'Usuń galerię';
$string['deleteitem'] = 'Usuń element';
$string['deleteitemtype'] = 'Usuń {$a}';
$string['deleteorremovecollection'] = 'Jeśli chcesz usunąć link do kolekcji bez usuwania treści kliknij submit.<br/><br/>

Jeśli chcesz usunąć link do kolekcji i usunąć zawartość w polu tekstowym poniżej, wpisz DELETE i kliknij Wyślij.';
$string['deleteorremovecollectionwarn'] = 'Poprzez usunięcie potwierdzasz, że jesteś:<br/>
- usunięcie tego linku do kolekcji mediów<br/>
- usunięcie kolekcji i/lub wszystkich galerii oraz całej zawartości z TheBox<br/>
- wyłączenie wszystkich linków utworzonych w innych kursach do tej kolekcji lub jej zawartości';
$string['deleteorremovegallery'] = 'Jeśli chcesz usunąć link do galerii bez usuwania treści kliknij w submit.<br/><br/>.

Jeśli chcesz usunąć link do galerii i usunąć treść w polu tekstowym poniżej, wpisz DELETE i kliknij Wyślij';
$string['deleteorremovegallerywarn'] = 'Poprzez usunięcie potwierdzasz, że jesteś:<br/>
- usunięcie tego linku do galerii mediów<br/>
- usunięcie galerii mediów i wszystkich treści z TheBox<br/>
- wyłączenie wszystkich linków utworzonych w innych kursach do tej galerii mediów lub jej zawartości';
$string['deleteorremoveitem'] = 'Jeśli chcesz usunąć element z galerii bez usuwania treści kliknij w submit.<br/><br/>.

Jeśli chcesz usunąć link do galerii i usunąć treść typu DELETE w polu tekstowym poniżej i kliknij przycisk wyślij.';
$string['deleteorremoveitemwarn'] = 'Poprzez usunięcie potwierdzasz, że jesteś:<br/>
- usunięcie tego linku do elementu medialnego<br/>
- usunięcie elementu nośnika z pudełka<br/>
- wyłączenie wszystkich linków utworzonych w innych kursach do tego elementu multimedialnego';
$string['disablestandardgallery'] = 'Wyłączanie standardowych galerii';
$string['displayfullcaption'] = 'Wyświetlanie pełnego tekstu napisów';
$string['download'] = 'Pobierz';
$string['editgallery'] = 'Edytuj galerię';
$string['editgallerysettings'] = 'Edytuj ustawienia galerii';
$string['edititem'] = 'Edytuj element';
$string['edititemtype'] = 'Edytuj {$a}';
$string['editthisgallery'] = 'Edytuj tę galerię';
$string['enablethebox'] = 'Włącz theBOX';
$string['enforcedefaults'] = 'Wymuś ustawienia domyślne';
$string['enforcedefaults_help'] = 'Jeśli jest włączona, wówczas stosowane są ustawione przez instruktora wartości domyślne galerii';
$string['errorchooseimportoption'] = 'Proszę wybrać opcję importu';
$string['errornotyouritem'] = 'Nie możesz edytować tego obiektu medialnego, należy on do innego użytkownika.';
$string['errortheboxunavailable'] = 'Przepraszam, wygląda na to, że theBox jest teraz niedostępny. Proszę spróbować później.';
$string['errortoomanygalleries'] = 'Przepraszam, ty lub twoja grupa przekroczyła maksymalną liczbę galerii dozwoloną w tej kolekcji ({$a}).';
$string['errortoomanyitems'] = 'Przepraszam, ta galeria ma już maksymalną dozwoloną liczbę przedmiotów ({$a}).';
$string['eventcollectiondeleted'] = 'Kolekcja usunięta';
$string['eventgallerycreated'] = 'Galeria utworzona';
$string['eventgallerydeleted'] = 'Galeria skasowana';
$string['eventgalleryupdated'] = 'Galeria zaktualizowana';
$string['eventgalleryviewed'] = 'Galeria obejrzana';
$string['eventitemcreated'] = 'Element stworzony';
$string['eventitemdeleted'] = 'Element skasowany';
$string['eventitemupdated'] = 'Element zaktualizowany';
$string['exifmissing'] = 'Bez tego, pliki jpg/tiff nie mogą być obracane do właściwej orientacji w kolekcjach nośników.';
$string['export'] = 'Eksport';
$string['exportascsv'] = 'Eksport jako CSV';
$string['exportgallery'] = 'Eksportuj galerię';
$string['externalurl'] = 'Zewnętrzny URL';
$string['externalurl_help'] = 'Obecnie obsługiwane są linki do zdjęć i filmów na youtube.';
$string['filename'] = 'Nazwa pliku';
$string['filesize'] = 'Rozmiar pliku';
$string['foundxresults'] = 'Znaleziono wyników: {$a}';
$string['gallery'] = 'Galeria';
$string['galleryfocus'] = 'Skoncentruj na';
$string['galleryfocus_help'] = 'Domyślny skoncentrowanie galerii (określa jakie typy plików są prezentowane jako główne w galerii). Jeśli jest ustawiona jako galeria YouTube, koncentracja jest zablokowana dla Video.';
$string['galleryname'] = 'Nazwa galerii';
$string['gallerythumbnail'] = 'Użyj jako minaturki';
$string['gallerythumbnail_help'] = 'Jeśli zostanie wybrana, miniaturka tego elementu jest używana jako miniaturka dla galerii.';
$string['galleryviewoptions'] = 'Opcje widoku galerii';
$string['galleryviewoptions_help'] = 'Określa opcje widoku galerii, które są dostępne dla studentów.';
$string['gridview'] = 'Widok siatki';
$string['gridviewcolumns'] = 'Liczba kolumn w siatce';
$string['gridviewcolumns_help'] = 'W widoku siatki, liczba wyświetlanych kolumn.';
$string['gridviewrows'] = 'Liczba wierszy w siatce';
$string['gridviewrows_help'] = 'W widoku siatki, liczba wyświetlanych wierszy';
$string['group'] = 'Grupa';
$string['group_help'] = 'Ponieważ jesteś członkiem wielu grup (lub masz uprawnienia do zarządzania grupami w tym kursie), jest to grupa, z którą chcesz powiązać galerię.';
$string['information'] = 'Informacje';
$string['itemdisplay'] = 'Wyświetlanie elementu';
$string['itemdisplay_help'] = 'Umieść ten element na wystawie w galerii (np. na karuzeli).';
$string['like'] = 'Lubię to';
$string['likedby'] = 'Polubione przez';
$string['maxbytes'] = 'Maksymalny rozmiar elementu';
$string['maxgalleries'] = 'Maksymalna liczba galerii na użytkownika/grupę';
$string['maxgalleries_help'] = 'Maksymalna liczba galerii, które użytkownik (lub grupa przy użyciu trybów grupowych) może utworzyć w tej kolekcji.

Uwaga: dla kolekcji Instruktor, jest to zawsze nieograniczona ilość.';
$string['maxgalleriesreached'] = 'Maksymalna liczba dodanych galerii';
$string['maxitems'] = 'Maksymalna liczba elementów na galerię';
$string['maxitems_help'] = 'Maksymalna liczba elementów, które użytkownik może umieścić w galerii w tej kolekcji.

Uwaga: dla kolekcji Instruktor, jest to zawsze nieograniczona ilość.';
$string['maxitemsreached'] = 'Maksymalna liczba dodanych elementów.';
$string['mediagallery'] = 'Kolekcja multimediów';
$string['mediagallery:addinstance'] = 'Dodaj instancję kolekcji multimediów.';
$string['mediagallery:comment'] = 'Komentarz do galerii lub przedmiotu kolekcji medialnej';
$string['mediagallery:grade'] = 'Oceń galerię multimediów';
$string['mediagallery:like'] = 'Możliwość polubienia elementów w kolekcji multimediów.';
$string['mediagallery:manage'] = 'Zarządzanie kolekcją multimediów.';
$string['mediagallery:viewall'] = 'Możliwość przeglądania wszystkich galerii w kolekcji multimediów';
$string['mediagalleryfieldset'] = 'Niestandardowy zestaw przykładowych pól';
$string['mediagalleryname'] = 'Nazwa kolekcji multimediów';
$string['mediagalleryname_help'] = 'Nazwa, którą chcesz nadać swojej kolekcji medialnej.';
$string['mediainformation'] = 'Informacje';
$string['mediasize'] = 'Rozmiar';
$string['mediasizelg'] = 'Duży';
$string['mediasizemd'] = 'Średni';
$string['mediasizesm'] = 'Mały';
$string['mediatype'] = 'Typ mediów';
$string['medium'] = 'Medium';
$string['medium_help'] = 'Medium użyte do stworzenia dzieła (tj. malarstwo, fotografia, dźwięk itp.).';
$string['metainfobulkheader'] = 'Poniższe wartości zostaną wykorzystane jako początkowe metadane dla każdej z dodanych powyżej pozycji';
$string['mode'] = 'Tryb galerii';
$string['mode_help'] = 'Określa to rodzaj zawartości, którą obsługuje galeria. Po ustawieniu, wartość ta nie może być zmieniona.

<ul><li>Standardowe: w tym trybie użytkownicy mogą dodawać dowolne rodzaje treści medialnych, które chcą.</li>
<li>YouTube: w tym trybie do galerii można dodawać tylko filmy z youtube.</li></ul>';
$string['modestandard'] = 'Standardowa';
$string['modethebox'] = 'theBox';
$string['modeyoutube'] = 'YouTube';
$string['modulename'] = 'Kolekcja multimediów';
$string['modulename_help'] = 'Użyj modułu Kolekcja multimediów do tworzenia galerii treści medialnych.

Użytkownicy mogą tworzyć własne galerie obrazów, wideo lub audio samodzielnie lub w grupach.


Przesłane treści będą prezentowane w formacie karuzeli lub siatki jako miniatury. Kliknięcie na którąkolwiek z miniatur powoduje wyostrzenie obrazu i pozwala na przeglądanie galerii. Użytkownicy mogą "polubić" i skomentować zawartość, którą mogą zobaczyć w swoich i innych galeriach.';
$string['modulenameplural'] = 'Kolekcje Multimediów';
$string['moralrights'] = 'Prawa autorskie';
$string['moralrights_help'] = 'Chcesz egzekwować swoje prawa autorskie?

Wybierając tak, wyrażasz zgodę na potencjalne wykorzystanie tego elementu jako próbki pracy.';
$string['noitemsadded'] = 'Do tej galerii nie zostały dodane żadne elementy.';
$string['noitemsfound'] = 'Nie znaleziono elementów';
$string['noitemsselected'] = 'Żadne elementy nie zostały zaznaczone do eksportu';
$string['originalauthor'] = 'Orginalny autor';
$string['originalauthor_help'] = 'Oryginalny autor przedmiotu.';
$string['other'] = 'inne';
$string['otherfiles'] = 'Inne pliki';
$string['others'] = 'Inne';
$string['pluginadministration'] = 'Administracja kolekcją multimediów';
$string['pluginname'] = 'Kolekcja multimediów';
$string['privacy:metadata:core_comments'] = 'Komentarze związane z galeriami kolekcji medialnych lub przedmiotami';
$string['privacy:metadata:core_files'] = 'Tagi związane z galeriami lub przedmiotami multimedialnymi';
$string['privacy:metadata:core_tag'] = 'Tagi związane z galeriami lub przedmiotami multimedialnymi';
$string['privacy:metadata:mediagallery'] = 'Informacje o utworzonych przez użytkownika galeriach multimedialnych.';
$string['privacy:metadata:mediagallery:id'] = 'Identyfikator kolekcji multimediów.';
$string['privacy:metadata:mediagallery:name'] = 'Nazwa kolekcji multimediów.';
$string['privacy:metadata:mediagallery:userid'] = 'Identyfikator użytkownika, który utworzył/zarządza kolekcją multimediów';
$string['privacy:metadata:mediagallery_gallery'] = 'Informacje o utworzonych przez użytkownika galeriach multimedialnych.';
$string['privacy:metadata:mediagallery_gallery:groupid'] = 'Identyfikator grupy, w ramach której stworzyli galerię.';
$string['privacy:metadata:mediagallery_gallery:instanceid'] = 'Identyfikator elementu mediagalerii, dla którego użytkownik przekazuje informację zwrotną.';
$string['privacy:metadata:mediagallery_gallery:name'] = 'Nazwa galerii';
$string['privacy:metadata:mediagallery_gallery:userid'] = 'Identyfikator użytkownika, który stworzył galerię.';
$string['privacy:metadata:mediagallery_item'] = 'Informacje o elementach multimedialnych, które zostały utworzone przez użytkownika.';
$string['privacy:metadata:mediagallery_item:broadcaster'] = 'Nadawca dzieła.';
$string['privacy:metadata:mediagallery_item:caption'] = 'Podpis, który użytkownik nadał elementowi.';
$string['privacy:metadata:mediagallery_item:description'] = 'Opis, który użytkownik nadał elementowi.';
$string['privacy:metadata:mediagallery_item:externalurl'] = 'Ewentualne odniesienie do pozycji zewnętrznej.';
$string['privacy:metadata:mediagallery_item:galleryid'] = 'Identyfikator galerii, do której należy dany element.';
$string['privacy:metadata:mediagallery_item:medium'] = 'Medium użyte do stworzenia dzieła (tj. malarstwo, fotografia, dźwięk itp.).';
$string['privacy:metadata:mediagallery_item:moralrights'] = 'Jeśli użytkownik zastrzegł sobie swoje prawa autorskie do elementu.';
$string['privacy:metadata:mediagallery_item:originalauthor'] = 'Oryginalny autor/twórca dzieła.';
$string['privacy:metadata:mediagallery_item:productiondate'] = 'Data, kiedy utwór został stworzony';
$string['privacy:metadata:mediagallery_item:publisher'] = 'Prowadzący';
$string['privacy:metadata:mediagallery_item:reference'] = 'Odniesienie do kolekcji, do której należy dzieło.';
$string['privacy:metadata:mediagallery_item:timecreated'] = 'Czas utworzenia elementu przez użytkownika.';
$string['privacy:metadata:mediagallery_item:userid'] = 'Identyfikator użytkownika, który stworzył dany element.';
$string['privacy:metadata:mediagallery_userfeedback'] = 'Informacja o opinii użytkownika na temat danej pozycji w galerii medialnej';
$string['privacy:metadata:mediagallery_userfeedback:itemid'] = 'Identyfikator elementu mediagalerii, dla którego użytkownik przekazuje informację zwrotną';
$string['privacy:metadata:mediagallery_userfeedback:liked'] = 'Jeśli użykownik "polubił" daną pozycję.';
$string['privacy:metadata:mediagallery_userfeedback:rating'] = 'Jaką ocenę nadał użytkownik danej pozycji (nie wdrożona).';
$string['privacy:metadata:mediagallery_userfeedback:userid'] = 'Użytkownik, który udzielił informacji zwrotnej.';
$string['privacy:metadata:preference:mediasize'] = 'Jaki rozmiar wyświetlania preferuje użytkownik, aby zobaczyć elementy multimedialne.';
$string['productiondate'] = 'Data wykonania';
$string['productiondate_help'] = 'Data powstania oryginalnego dzieła.';
$string['publisher'] = 'Prowadzący';
$string['publisher_help'] = 'Prowadzący pracy';
$string['readonlyfrom'] = 'Dostępne od';
$string['readonlyto'] = 'Dostępne do';
$string['reference'] = 'Referencje / Przedmiot';
$string['reference_help'] = 'Odniesienie zewnętrzne (jeśli istnieje), z którego pochodzi praca.';
$string['removecollectionconfirm'] = 'Czy na pewno chcesz usunąć link do tej kolekcji?';
$string['removefromcollection'] = 'Usuń z kolekcji';
$string['removefromgallery'] = 'Usuń z galerii';
$string['removegalleryconfirm'] = 'Czy na pewno chcesz usunąć link do tej galerii?';
$string['removeitemconfirm'] = 'Czy na pewno chcesz usunąć link do tego elementu?';
$string['removethecollection'] = 'Usuń/skasuj kolekcję';
$string['restrictavailableinfo'] = 'Aby ograniczyć daty, pomiędzy którymi ta czynność jest dostępna, skorzystaj z poniższej sekcji Ogranicz dostęp.';
$string['sample'] = 'Przykład';
$string['search'] = 'Szukaj';
$string['search_help'] = 'Wprowadź słowa kluczowe do wyszukania';
$string['searchcourseonly'] = 'Tylko ten kurs';
$string['searchcourseonly_help'] = 'Czy chciałeś szukać elementów tylko w galeriach w tym kursie?';
$string['searchdisplayxtoyofzresults'] = 'Znaleziono wyników: {$a->total} Wyświetlanie {$a->from}-{$a->to}:';
$string['searchresults'] = 'Szukaj wyników';
$string['searchtitle'] = 'Wyszukiwanie w kolekcji multimediów';
$string['selection'] = 'Wybór';
$string['settingsavailability'] = 'Dostępność';
$string['settingsdisplay'] = 'Wyświetlanie listy';
$string['settingsgallery'] = 'Domyślne ustawienia galerii';
$string['settingsgallerydisplay'] = 'Wyświetlanie galerii';
$string['settingsvisibility'] = 'Widoczność';
$string['showall'] = 'Pokaż wszystko';
$string['storagereport'] = 'Magazynowanie kolekcji multimediów.';
$string['storagetotalusage'] = 'Całkowite wykorzystanie przestrzeni magazynowej na terenie całego obiektu: {$a}.';
$string['submittedforgrading'] = 'Wgrane do oceny';
$string['synclastcompleted'] = 'Synchronizacja ostatnio zakończona';
$string['syncwiththebox'] = 'Synchronizuj z theBOX';
$string['tags'] = 'Tagi';
$string['theboxisnotenabled'] = 'Niestety, kolekcja ta nie jest obecnie dostępna, ponieważ jest podłączona do TheBoxa, który nie jest obecnie włączony.';
$string['thumbnail'] = 'Miniaturka';
$string['thumbnail_help'] = 'Możesz wybrać obraz, który będzie używany jako miniaturka w galerii dla tego elementu.

Jeśli go nie dostarczysz, zostanie on wygenerowany dla Ciebie z przesłanego zasobu (dla obrazów) lub użytej ikony typu pliku (dla innych plików).';
$string['thumbnailsperpage'] = 'Liczba miniaturek na stronę';
$string['thumbnailsperrow'] = 'Liczba miniaturek w rzędzie';
$string['togglefullscreen'] = 'Przełączanie trybu pełnoekranowego';
$string['togglesidebar'] = 'Przełącznik paska bocznego';
$string['toomany'] = 'Zbyt wiele galerii, proszę usunąć lub zmienić typ kolekcji';
$string['top'] = 'Góra';
$string['typeall'] = 'Wszystkie pliki';
$string['typeaudio'] = 'Audio';
$string['typeimage'] = 'Obrazy';
$string['typevideo'] = 'Video';
$string['unlike'] = 'Cofnij polubienie';
$string['uploader'] = 'Wgrywający';
$string['viewgallery'] = 'Zobacz galerię';
$string['visibleinstructor'] = 'Widoczny dla instruktorów dopiero po';
$string['visibleinstructor_help'] = 'Zdefiniuj galerię jako widoczną dla instruktorów po określonym terminie. Może to być przydatne w celu umożliwienia instruktorom dostępu przed wszystkimi innymi użytkownikami. Prowadzący kursy z odpowiednimi uprawnieniami zawsze będą mogli zobaczyć galerię.';
$string['visibleother'] = 'Widoczny dla wszystkich w kursie po';
$string['visibleother_help'] = 'Zdefiniuj galerię jako widoczną dla innych użytkowników po określonej dacie. Zarządzający kursami z odpowiednimi uprawnieniami zawsze będą mogli zobaczyć galerię.';
$string['you'] = 'Ty';
$string['youmusttypedelete'] = 'Aby potwierdzić usunięcie, należy wpisać DELETE.';
$string['youtubeurl'] = 'Adres URL YouTube';
