<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'hu', version '5.0'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Elfogadás és folytatás';
$string['action'] = 'Művelet';
$string['action_explain_text'] = 'Szövegmagyarázás';
$string['action_explain_text_desc'] = 'A kurzusoldalon található szöveges tartalom elmagyarázása.';
$string['action_explain_text_instruction'] = 'Egy szöveget fog kapni a felhasználótól. A feladat, hogy elmagyarázza a kapott szöveget. Kövesse az alábbi irányelveket:
    1. Részletezés: Fejtse ki a kulcsfontosságú ötleteket és fogalmakat úgy, hogy az értelmezés mélységet kapjon, és ne csupán a szöveg szó szerinti ismétlése történjen!
    2. Egyszerűsítés: Bontsa az összetettebb kifejezéseket vagy gondolatokat egyszerűbb elemekre, hogy azok a szélesebb közönség, köztük a tanulók számára is érthetőek legyenek!
    3. Kontextus adás: Magyarázza el, miért történik valami, hogyan működik, vagy mi a célja. Használjon odaillő példákat vagy hasonlatokat, ahol ezek elősegítik a megértést.
    4. Logikus felépítés: A magyarázat legyen logikusan felépítve, az alapvető gondolatokkal kezdve, mielőtt a részletekre térne.

Fontos utasítások:
    1. A magyarázatot csak egyszerű szövegben küldje vissza.
    2. Ne tartalmazzon semmilyen formázást, üdvözlést vagy közhelyeket.
    3. Koncentráljon az egyértelműségre, tömörségre és hozzáférhetőségre.

Biztosítsa, hogy a magyarázat könnyen olvasható legyen, és hatékonyan közvetítse az eredeti szöveg fő pontjait.';
$string['action_generate_image'] = 'Kép létrehozása';
$string['action_generate_image_desc'] = 'Egy kép létrehozása a leírás alapján.';
$string['action_generate_text'] = 'Szöveg létrehozása';
$string['action_generate_text_desc'] = 'Szöveg létrehozása a leírás alapján.';
$string['action_generate_text_instruction'] = 'Egy szöveget fog kapni a felhasználótól. A feladata, hogy az utasítás alapján szöveget generáljon. Kövesse ezeket az utasításokat:
    1. Az összefoglalót csak egyszerű szövegben adja vissza.
    2. Ne tartalmazzon semmilyen formázást, üdvözletet vagy közhelyeket.';
$string['action_summarise_text'] = 'Összefoglaló';
$string['action_summarise_text_desc'] = 'A kurzus oldal tartalmának összefoglalása.';
$string['action_summarise_text_instruction'] = 'Egy szöveget fog kapni a felhasználótól. A feladat, hogy összefoglalót készítsen ebből a szövegből. Kövesse az alábbi irányelveket:
    1. Tömörítsd össze: Rövidítse le a hosszú szövegrészeket a legfontosabb pontokra.
    2. Egyszerűsítés: Az összetett információk könnyebben érthetővé tétele, különösen a tanulók számára.

Fontos utasítások:
    1. Az összefoglalót csak egyszerű szövegben küldje vissza.
    2. Ne tartalmazzon semmilyen formázást, üdvözlést vagy közhelyeket.
    3. Koncentráljon az egyértelműségre, tömörségre és hozzáférhetőségre.

Biztosítsa, hogy az összefoglaló könnyen olvasható legyen, és hatékonyan közvetítse az eredeti szöveg fő pontjait.';
$string['action_translate_text'] = 'Szöveg fordítása';
$string['action_translate_text_desc'] = 'Fordítsa le a megadott szöveget egyik nyelvről a másikra.';
$string['actionsettingprovider'] = '{$a} művelet beállításai';
$string['actionsettingprovider_desc'] = 'Ezek a beállítások szabályozzák, hogy a(z) {$a->providername} hogyan hajtja végre a(z) {$a->actionname} műveletet.';
$string['actionsettings'] = 'Műveletek beállításai';
$string['actionsettings_desc'] = 'Ezek a beállítások szabályozzák az MI szolgáltató példány műveleteit';
$string['ai'] = 'MI';
$string['aiactionregister'] = 'MI művelet nyilvántartás';
$string['aiplacements'] = 'MI elhelyezés';
$string['aipolicyacceptance'] = 'MI irányelv hozzájárulások';
$string['aipolicyregister'] = 'MI irányelv nyilvántartás';
$string['aiproviders'] = 'MI szolgáltatók';
$string['aireports'] = 'MI jelentések';
$string['aiusage'] = 'MI használat';
$string['aiusagepolicy'] = 'MI felhasználási irányelv';
$string['availableplacements'] = 'Válassza ki, hol álljanak rendelkezésre az MI-műveletek';
$string['availableplacements_desc'] = 'Az elhelyezés határozza meg, hogy hogyan és hol használhatók az MI-akciók az Ön webhelyén! A beállításokon keresztül kiválaszthatja, hogy az egyes helyeken mely műveletek állnak rendelkezésre.';
$string['availableproviders'] = 'Az LMS-hez kapcsolódó MI szolgáltatók kezelése';
$string['availableproviders_desc'] = 'Az MI szolgáltatók MI funkciókhoz való hozzáférést biztosítanak az Ön webhelyéhez olyan „műveleteken” keresztül, mint az összefoglalás vagy a képgenerálás.<br/>
A műveleteket minden egyes szolgáltató beállításaiban kezelheti.';
$string['btninstancecreate'] = 'Példány létrehozása';
$string['btninstanceupdate'] = 'Példány frissítése';
$string['completiontokens'] = 'Kimeneti tokenek';
$string['completiontokens_help'] = 'A kimeneti tokenek azok a szövegegységek, melyeket az MI modell állít elő a bemenetre adott válaszként. A hosszabb válaszok több tokent használnak, mely várhatóan nagyobb költségeket jelent.';
$string['configureprovider'] = 'Szolgáltató példány beállítása';
$string['contentwatermark'] = 'MI által létrehozott';
$string['createnewprovider'] = 'Új szolgáltató példány létrehozása';
$string['dateaccepted'] = 'Hozzájárulás dátuma';
$string['declineaipolicy'] = 'Elutasítás';
$string['enableglobalratelimit'] = 'Portálszintű használati limit beállítása';
$string['enableglobalratelimit_help'] = 'Az egész portál MI szolgáltatóhoz óránként küldhető kéréseinek száma limitált.';
$string['enableuserratelimit'] = 'Felhasználszintű használati limit beállítása';
$string['enableuserratelimit_help'] = 'Az egyes felhasználók MI szolgáltatóhoz óránként küldhető kéréseinek száma limitált.';
$string['error:actionnotfound'] = 'A(z) \'{$a}\' művelet nem támogatott.';
$string['error:providernotfound'] = 'Az MI szolgálgató példány nem található.';
$string['globalratelimit'] = 'A portálszinten küldhető kérések maximuma';
$string['globalratelimit_help'] = 'Az egész portál által óránként engedélyezett kérések száma.';
$string['manageaiplacements'] = 'MI elhelyezések kezelése';
$string['manageaiproviders'] = 'MI szolgáltatók kezelése';
$string['noproviders'] = 'Nem hajtható végre. This action is unavailable. Ehhez a művelethez nincs <a href="{$a}">AI providers</a> konfigurálva.';
$string['placement'] = 'Elhelyezés';
$string['placementactionsettings'] = 'Művelet';
$string['placementactionsettings_desc'] = 'Ehhez az elhelyezéshez rendelkezésre álló MI-akciók.';
$string['placementsettings'] = 'Helyspecifikus beállítások';
$string['placementsettings_desc'] = 'Ezek a beállítások szabályozzák, hogy ez az MI elhelyezés hogyan csatlakozik a MI szolgáltatáshoz, valamint a kapcsolódó műveleteket.';
$string['privacy:metadata:ai_action_explain_text'] = 'A felhasználók által küldött szövegmagyarázós kéréseket tároló táblázat.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'A szövegmagyarázáshoz használt kimeneti tokenek.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Az egyedi hash, mely megadja a model és tartalom állapotát/verzióját.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Az MI modell által a bemeneti prompt alapján ténylegesen létrehozott szöveg.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'A szövegmagyarázathoz használt prompt.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'A szövegmagyarázathoz használt prompt tokenek.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'A válasz azonosítója.';
$string['privacy:metadata:ai_action_generate_image'] = 'A felhasználók által kép előállítás kérést tároló táblázat.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'A létrehozott képek képaránya.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'A létrehozott képek száma.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'A kép létrehozási kérelem.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'A létrehozott képek minősége.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'A létrehozott képek felülvizsgálata.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'A létrehozott képek forrás URL címe.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'A létrehozott képek stílusa.';
$string['privacy:metadata:ai_action_generate_text'] = 'A felhasználók által benyújtott szöveg létrehozási kérelmeket tároló táblázat.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'A szöveg létrehozásához használt kitöltési tokenek.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'A modell és a tartalom állapotát/verzióját jelző egyedi hash.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Az MI modell által létrehozott szöveg.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'A szöveg létrehozás promptja.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'A szöveg létrehozásához használt prompt tokenek.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'A válasz ID azonosítója.';
$string['privacy:metadata:ai_action_register'] = 'A felhasználók által benyújtott műveleti kérelmeket tároló táblázat.';
$string['privacy:metadata:ai_action_register:actionid'] = 'A műveleti kérelem ID azonosítója.';
$string['privacy:metadata:ai_action_register:actionname'] = 'A kérelem műveleti neve.';
$string['privacy:metadata:ai_action_register:model'] = 'A válasz létrehozásához használt modell.';
$string['privacy:metadata:ai_action_register:provider'] = 'A kérelmet feldolgozó szolgáltató neve.';
$string['privacy:metadata:ai_action_register:success'] = 'A műveleti kérelem állapota.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'A kérelem teljesítésének időpontja.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'A kérelem létrehozásának időpontja.';
$string['privacy:metadata:ai_action_register:userid'] = 'A kérelmet benyújtó felhasználó ID azonosítója.';
$string['privacy:metadata:ai_action_summarise_text'] = 'A felhasználók által kért összefoglaló kéréseket tároló táblázat.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'A szöveg összefoglalására használt kiegészítő tokenek.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'A modell és a tartalom állapotát/verzióját jelző egyedi azonosító.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Az MI modell által létrehozott szöveg.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Összefoglaló kérése.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Az összefoglalóhoz használt prompt tokenek.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'A válasz ID azonosítója.';
$string['privacy:metadata:ai_policy_register'] = 'A felhasználók MI-házirend elfogadási állapotát tároló táblázat.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'Annak a kontextusnak az ID azonosítója, amelynek adatai mentésre kerültek.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Az az időpont, amikor a felhasználó elfogadta az MI házirendet.';
$string['privacy:metadata:ai_policy_register:userid'] = 'Annak a felhasználónak az ID azonosítója, akinek az adatait mentette.';
$string['prompttokens'] = 'Prompt tokenek';
$string['prompttokens_help'] = 'A prompt tokenek azok a szövegegységek, melyek az MI modellnek küldött bemenetet építik fel. A hosszabb bemenetek több tokent használnak, mely várhatóan nagyobb költségeket jelent.';
$string['provider'] = 'Szolgáltató';
$string['provideractionsettings'] = 'Műveletek';
$string['provideractionsettings_desc'] = 'Válassza ki és konfigurálja azokat a műveleteket, amelyeket a(z) {$a} elvégezhet az Ön webhelyén.';
$string['providerinstanceactionupdated'] = '{$a} művelet beállításai frissítve';
$string['providerinstancecreated'] = '{$a} MI szolgáltató példány létrehozva.';
$string['providerinstancedelete'] = 'MI szolgáltató példány törlése';
$string['providerinstancedeleteconfirm'] = 'A {$a->name} ({$a->provider}) MI szolgáltató példányt törölni fogja. Biztosan folytatja?';
$string['providerinstancedeleted'] = '{$a} MI szolgáltató példány törölve.';
$string['providerinstancedeletefailed'] = 'A(z) {$a} MI szolgáltató példány nem törölhető. Az vagy használatban van vagy valamilyen adatbázis gond adódott. Ellenőrizze, hogy a szolgáltató aktív-e vagy kérjen segítséget kapcsolatba az adatbázis adminisztrátorától.';
$string['providerinstancedisablefailed'] = 'A(z) {$a} MI szolgáltató példány nem kapcsolható ki. Az vagy használatban van vagy valamilyen adatbázis gond adódott. Ellenőrizze, hogy a szolgáltató aktív-e vagy kérjen segítséget kapcsolatba az adatbázis adminisztrátorától.';
$string['providerinstanceupdated'] = '{$a} MI szolgáltató példány frissítve.';
$string['providermoveddown'] = '{$a} lefelé mozgatva.';
$string['providermovedup'] = '{$a} felfelé mozgatva.';
$string['providername'] = 'Példány neve';
$string['providers'] = 'Szolgáltató';
$string['providersettings'] = 'Beállítások';
$string['providertype'] = 'Válasszon MI szolgáltató segédprogramot';
$string['timegenerated'] = 'Létrehozás ideje';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Üdvözöljük az új MI szolgáltatásban!</strong></h4>
<p>Ez a mesterséges intelligencia (MI) funkció kizárólag külső nagy nyelvi modelleken (LLM) alapul, hogy javítsa a tanulási és tanítási élményt. Mielőtt elkezdené használni ezeket az MI szolgáltatásokat, kérjük, olvassa el ezt a használati szabályzatot.</p>
<h4><strong>Az MI által létrehozott tartalom pontossága</strong></h4>
<p>Az MI hasznos javaslatokat és információkat adhat, de pontossága változó lehet. Mindig duplán ellenőrizze a megadott információkat, hogy megbizonyosodjon arról, hogy azok pontosak, teljesek és megfelelnek a konkrét helyzetnek. </p>
<h4><strong>Hogyan dolgozzuk fel az Ön adatait</strong></h4>
<p>Ez az MI funkció külső nagy nyelvi modelleket (LLM) használ. Ha ezt a funkciót használja, az Ön által megosztott információkat vagy személyes adatokat az adott LLM-ek adatvédelmi irányelvei szerint kezeljük. Javasoljuk, hogy olvassa el az adatvédelmi szabályzatukat, hogy megértse, hogyan kezelik az adatait. Ezen túlmenően a mesterséges intelligencia funkciókkal való interakciókat ezen az oldalon tárolhatják.</p>
<p>Ha kérdései vannak azzal kapcsolatban, hogy az Ön adatainak feldolgozása hogyan történik, kérjük, érdeklődjön tanárainál vagy a tanítással foglalkozó szervezetnél.</p>
<p>A folytatással Ön elismeri, hogy megértette és elfogadja ezt a szabályzatot.</p>';
$string['userratelimit'] = 'A felhasználószintű kérések maximuma';
$string['userratelimit_help'] = 'Egy felhasználónak, egy órában engedélyezett kérések száma.';
