<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_formulas', language 'hu', version '5.0'.
 *
 * @package     qtype_formulas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abserror'] = 'Abszolút hiba';
$string['addmorepartsblanks'] = '{no} db üres válasz hozzáadása';
$string['algebraic_formula'] = 'Algebrai képlet';
$string['answer'] = 'Válasz*';
$string['answer_help'] = '**Kötelező**.
a választól függően számlistának vagy karakterláncnak kell lennie
választott típus. Ha csak egy válasz van, akkor egy szám vagy karakterlánc is lehet
közvetlenül belépett. Felhívjuk figyelmét, hogy a listában szereplő elemek száma
meghatározza az ehhez a részhez tartozó válaszmezők számát.

<pre class="prettyprint">123<br>[1, 0, 0, 1]<br>a<br>[1, a, b]<br>"exp(-a t)"<br>[" vx t","vy t - 0,5 a t^2"]</pre>';
$string['answercombinedunitmulti'] = 'Válasz és mértékegység a {$a->part}. részhez';
$string['answercombinedunitsingle'] = 'Válasz és egység';
$string['answercoordinatemulti'] = '{$a->numanswer} válaszmező a {$a->part}. részhez';
$string['answercoordinatesingle'] = 'Válasz mező {$a->numanswer}';
$string['answermark'] = 'Részpont*';
$string['answermark_help'] = '**Kötelező**.
A rész válaszának jele, amelynek 0-nál nagyobb számnak kell lennie.
  Az egész kérdés alapértelmezett jele az összes részjegyének összege.

Megjegyzés: Ha ennek a résznek a jelölőmezője üresen marad, a rész törlődik a kérdés mentésekor';
$string['answermulti'] = 'Válasz a következőre: {$a->part}';
$string['answerno'] = '{$a}. rész';
$string['answernotunique'] = 'Vannak más helyes válaszok is.';
$string['answernotunique_help'] = 'Ha ez a lehetőség be van jelölve, a tanuló a kísérlet áttekintése során a "Helyes válasz: ..." helyett az "Egy helyes válasz: ..." szöveget fogja látni.';
$string['answersingle'] = 'Válasz';
$string['answertype'] = 'Válasz típusa';
$string['answertype_help'] = 'Négy választípus létezik.

A szám-, numerikus és numerikus képletekre adott válaszok válaszként számot vagy számlistát igényelnek.

Az algebrai képletválaszokhoz egy karakterlánc vagy karakterláncok listája szükséges válaszként.

A különböző választípusok eltérő korlátozásokat írnak elő a válaszok bevitele során, így a tanulók is
tudnia kell, hogyan kell beírni őket. A formátumellenőrzés a kérdéskódban megtörténik
azt is mondd el nekik, amikor gépelnek, ha valami nincs rendben. Kérjük, olvassa el a dokumentációt a részletekért.
';
$string['answertype_link'] = 'https://moodleformulas.org/';
$string['answerunitmulti'] = 'Mértékegység a következőhöz: {$a->part}';
$string['answerunitsingle'] = 'Egység';
$string['checkvarshdr'] = 'Ellenőrizze a változók példányosítását';
$string['choiceno'] = 'Nem';
$string['choiceyes'] = 'Igen';
$string['commonsiunit'] = 'Közös SI mértékegység';
$string['correctansweris'] = 'Az egyik lehetséges helyes válasz: {$a}';
$string['correctfeedback'] = 'Bármilyen helyes válaszért';
$string['correctfeedback_help'] = 'Ez a visszajelzés azoknak a diákoknak lesz látható, akik ezen a részen a maximális pontszámot kapják. Tartalmazhat globális és lokális változókat, amelyeket az értékük vált fel';
$string['correctness'] = 'Osztályozási kritérium*';
$string['correctness_help'] = '**Kötelező**. Választhat relatív hibát vagy abszolút hibát hibával
hatótávolság. A relatív hiba nem használható algebrai választípushoz.

A relatív hiba és az abszolút hiba pontos meghatározását egynél több válaszmező esetén lásd a dokumentációban.';
$string['correctness_link'] = 'https://moodleformulas.org/';
$string['correctnessexpert'] = 'Szakértő';
$string['correctnesssimple'] = 'Egyszerűsített mód';
$string['defaultanswermark'] = 'Az alapértelmezett rész pontszám';
$string['defaultanswermark_desc'] = 'Az új kérdésrészekhez az alapértelmezett rész jelölése';
$string['defaultanswertype'] = 'Alapértelmezett választípus';
$string['defaultanswertype_desc'] = 'Az új kérdésrészek alapértelmezett választípusa';
$string['defaultcorrectness'] = 'Alapértelmezett minősítési feltételek';
$string['defaultcorrectness_desc'] = 'Az új kérdésrészek alapértelmezett értékelési kritériumai';
$string['defaultunitpenalty'] = 'Alapértelmezett egységbüntetés';
$string['defaultunitpenalty_desc'] = 'Alapértelmezett büntetés rossz egységért (0-1)';
$string['error_algebraic_var'] = 'Szintaktikai hiba az algebrai változó meghatározásakor.';
$string['error_answer_missing'] = 'Nincs meghatározva válasz.';
$string['error_answerbox_duplicate'] = 'Minden válaszmező helyőrző csak egyszer használható egy részben.';
$string['error_answertype_mistmatch'] = 'Választípus eltérés: A numerikus választípushoz szám szükséges, az algebrai választípushoz pedig karakterlánc szükséges';
$string['error_criterion'] = 'Az osztályozási szempontot egyetlen számra kell értékelni.';
$string['error_eval_numerical'] = 'Egyes kifejezéseket nem lehet numerikusan kiértékelni.';
$string['error_fixed_range'] = 'Rögzített tartomány szintaktikai hibája.';
$string['error_forbid_char'] = 'A képlet vagy kifejezés tiltott karaktereket vagy operátorokat tartalmaz.';
$string['error_forloop'] = 'Szintaktikai hiba a for ciklusban.';
$string['error_forloop_expression'] = 'A for ciklus kifejezésének listának kell lennie.';
$string['error_forloop_var'] = 'A for ciklus változójában van néhány hiba.';
$string['error_func_param'] = 'Rossz szám vagy rossz típusú paraméterek a(z) {$a}() függvényhez';
$string['error_grading_error'] = 'Osztályozási hiba! Valószínűleg helytelen importfájl vagy adatbázis-sérülés eredménye.';
$string['error_mark'] = 'A válaszpontnak 0-nál nagyobb értéket kell vennie.';
$string['error_no_answer'] = 'Legalább egy válasz szükséges.';
$string['error_placeholder_format'] = 'Rossz helyőrző formátum vagy tiltott karakterek.';
$string['error_placeholder_main_duplicate'] = 'Megkettőzött helyőrző a fő kérdés szövegében.';
$string['error_placeholder_missing'] = 'Ez a helyőrző hiányzik a fő kérdés szövegéből.';
$string['error_placeholder_sub_duplicate'] = 'Ezt a helyőrzőt más részben már meghatározták.';
$string['error_placeholder_too_long'] = 'A szöveg hossza legfeljebb 40 karakter lehet.';
$string['error_question_damaged'] = 'Hiba: A kérdés sérült, a szövegrészletek és a kérdésrészek száma nem egyenlő.';
$string['error_randvars_set_size'] = 'A készletben a generálható elemek számának nagyobbnak kell lennie 1-nél.';
$string['error_randvars_type'] = 'A készlet minden elemének pontosan azonos típusúnak és méretűnek kell lennie.';
$string['error_rule'] = 'Szabályelemzési hiba!';
$string['error_ruleid'] = 'Nincs ilyen szabály az id/name fájlban.';
$string['error_subexpression_empty'] = 'Egy részkifejezés üres.';
$string['error_syntax'] = 'Szintaktikai hiba.';
$string['error_unit'] = 'Egységelemzési hiba!';
$string['error_unitpenalty'] = 'A büntetésnek 0 és 1 közötti számnak kell lennie.';
$string['error_validation_eval'] = 'Próbáld ki az értékelési hibát!';
$string['error_vars_array_index_nonnumeric'] = 'Nem numerikus érték nem használható listaindexként.';
$string['error_vars_array_index_out_of_range'] = 'A lista indexe tartományon kívül esik!!!';
$string['error_vars_array_size'] = 'A lista méretének 1 és 1000 között kell lennie.';
$string['error_vars_array_type'] = 'Ugyanabban a listában az elemnek azonos típusúnak kell lennie, legyen szám vagy karakterlánc.';
$string['error_vars_array_unsubscriptable'] = 'A változó feliratozhatatlan.';
$string['error_vars_bracket_mismatch'] = 'A zárójelek nem egyeznek.';
$string['error_vars_end_separator'] = 'Hiányzik a feladatelválasztó a végéről.';
$string['error_vars_name'] = 'A változónév szintaxisa hibás.';
$string['error_vars_reserved'] = 'A {$a}() függvény le van foglalva, és nem használható változóként.';
$string['error_vars_string'] = 'Hiba! Vagy egy karakterlánc záró dupla idézőjel nélkül, vagy egy nem elfogadott karakter, például a \'.';
$string['error_vars_undefined'] = 'A \'{$a}\' változó nincs meghatározva.';
$string['feedback'] = 'Rész általános visszajelzés';
$string['feedback_help'] = 'Ez a rész visszajelzés minden tanuló számára látható lesz. Tartalmazhat globális és lokális változókat, amelyeket az értékük vált fel';
$string['functiontakesatleasttwo'] = 'A {$a} függvénynek legalább két argumentummal kell rendelkeznie';
$string['functiontakesnoargs'] = 'A {$a} függvény nem vesz fel argumentumokat';
$string['functiontakesonearg'] = 'A {$a} függvénynek pontosan egy argumentumnak kell lennie';
$string['functiontakesoneortwoargs'] = 'A {$a} függvénynek pontosan egy vagy két argumentumnak kell lennie';
$string['functiontakesthreeargs'] = 'The function {$a} must have exactly three arguments';
$string['functiontakestwoargs'] = 'A {$a} függvénynek pontosan két argumentumnak kell lennie';
$string['globalvarshdr'] = 'Változók';
$string['illegalformulasyntax'] = 'Illegális képlet szintaxis, amely a következővel kezdődik: \'{$a}\'';
$string['incorrectfeedback'] = 'Bármilyen helytelen válaszért';
$string['incorrectfeedback_help'] = 'Ez a visszajelzés azoknak a diákoknak lesz látható, akik nem kapnak érdemjegyet ebben a részben. Tartalmazhat globális és lokális változókat, amelyeket az értékük vált fel';
$string['instantiate'] = 'Példányosítás';
$string['mainq'] = 'Fő kérdés';
$string['modelanswer'] = 'Modell válasz';
$string['none'] = 'Egyik sem';
$string['number'] = 'Szám';
$string['number_unit'] = 'Szám és mértékegység';
$string['numdataset'] = 'Adatkészletek száma';
$string['numeric'] = 'Szám';
$string['numeric_unit'] = 'Szám és mértékegységek';
$string['numerical_formula'] = 'Numerikus képlet';
$string['numerical_formula_unit'] = 'Számképlet és mértékegység';
$string['otherrule'] = 'Egyéb szabályok';
$string['otherrule_help'] = 'Itt a kérdés szerzője további konverziós szabályokat határozhat meg más elfogadott alapegységekhez. A speciális felhasználási módokhoz lásd a dokumentációt.';
$string['partiallycorrectfeedback'] = 'Bármilyen részben helyes válaszért';
$string['partiallycorrectfeedback_help'] = 'Ez a visszajelzés azoknak a diákoknak lesz látható, akik nem kapják meg a maximális pontszámot ezen a részen. Tartalmazhat globális és lokális változókat, amelyeket az értékük vált fel';
$string['placeholder'] = 'Helyőrző név';
$string['placeholder_help'] = 'A helyőrző a hely azonosítására szolgál a fő kérdésben
szöveg, amelyet a rész tartalma helyettesít. Ez egy
alfanumerikus karakterek sorozata \'**#**\' előtaggal, például #1, #2a, #2b és #A.

Ha ez a mező üresen marad, akkor a rész a fő kérdés szövegének végére kerül.';
$string['pleaseputananswer'] = 'Kérjük, minden beviteli mezőbe írja be a választ.';
$string['pluginname'] = 'Képletek';
$string['pluginname_help'] = 'A kérdés használatának megkezdéséhez keresse fel a <a href="https://moodleformulas.org/">moodleformulas.org</a> webhelyet.

Ha kérdése van, látogasson el a <a href="https://moodleformulas.org/">moodleformulas.org</a> webhelyre.

Az alábbi szerkesztési űrlapon található lehetőségekért látogasson el a <a href="https://moodleformulas.org/">moodleformulas.org</a> oldalra.

A teljes dokumentációért keresse fel a <a href="https://moodleformulas.org/">moodleformulas.org</a> webhelyet.';
$string['pluginname_link'] = 'question/type/formulas';
$string['pluginnameadding'] = 'Képletkérdés hozzáadása';
$string['pluginnameediting'] = 'Képletkérdés szerkesztése';
$string['pluginnamesummary'] = 'Kérdés típusa véletlenszerű értékekkel és több válasszal
A válaszmezőket bárhol elhelyezhetjük, így különféle struktúrákat, például vektorokat, polinomokat és mátrixokat tartalmazó kérdéseket készíthetünk.
Az egyéb funkciók, például az egységellenőrzés és a több alkatrészre vonatkozó kérdések szintén szorosan integrálva vannak, és könnyen használhatók.';
$string['postunit'] = 'Mértékegység';
$string['postunit_help'] = 'Itt adhatja meg az egységet. Ezt a kérdéstípust kifejezetten SI egységhez tervezték, így an
az üres tér a különböző \'alapegységek\' \'szorzatát\' jelöli, a <tt> ^ </tt> pedig a kitevőket használja.
Ezenkívül a <tt> / </tt> használható inverz kitevőként. Az alapegység bármely permutációját ugyanúgy kezeljük.

A tanulóknak ugyanazt a beviteli formátumot kell használniuk. Például,

<pre class="prettyprint">1 m<br>0,1 m^2<br>20 m s^(-1)<br>400 kg m/s<br>100 kW</pre>';
$string['previewerror'] = 'Nincs elérhető előnézet. Ellenőrizze a valószínűségi változók, a globális változók, az alkatrészek lokális változóinak és válaszainak meghatározását. Eredeti hibaüzenet:';
$string['privacy:metadata'] = 'A Formulas kérdés típusú bővítmény nem tárol semmilyen személyes adatot.';
$string['qtextpreview'] = 'Előnézet';
$string['questiontext'] = 'Kérdés szövege';
$string['questiontext_help'] = 'A normál kérdésszöveg mellett itt globális változókat és helyőrzőket is használhatunk.

A globális változókat az értékük, a helyőrzőket pedig részekkel helyettesítjük.
     Egy egyszerű példa <tt> A, B, C </tt> változókkal és <tt> #1, #2, #3 </tt> helyőrzőkkel:

<pre class="prettyprint">Mi az eredménye {A} + {B}?<br>{#1}<br>Mi az eredménye {A} - {B}?<br>{#2 <br>Mi a {C} / {B} eredménye?<br>{#3}</pre>';
$string['relerror'] = 'Relatív hiba';
$string['renew'] = 'Frissítés';
$string['ruleid'] = 'Alapvető konverziós szabályok';
$string['ruleid_help'] = 'Ez a kérdéstípus beépített mértékegység-átalakító rendszerrel és alapvető átváltási szabályokkal rendelkezik.

Az alap a "Közös SI-egység" szabályai, amelyek átváltják a szabványos mértékegységeket
mint például a hossz mértékegysége, mondjuk km, m, cm és mm. Ennek az opciónak nincs
hatása, ha nem használtak egységet.';
$string['settingusepopup'] = 'Használjon eszköztippeket';
$string['settingusepopup_desc'] = 'Helyes válasz és visszajelzés megjelenítése elemleírásban';
$string['subqoptions'] = 'Egységbeállítások';
$string['subqtext'] = 'Rész szöveg';
$string['subqtext_help'] = 'Itt adható meg a részszöveg és a válaszmezők helye. A válaszmezők helyek meghatározására használható helyőrzők a következők:

<pre class="prettyprint">{_0}<br>{_1}<br>{_2}<br>...<br>{_u}</pre>

A <tt> {_0}, {_1}, {_2} </tt> az értékek különböző beviteli mezői, a <tt> {_u} </tt> pedig az egység beviteli mezője.

Minden hiányzó mező automatikusan hozzáfűződik az alkatrész szövegének végéhez. Speciális eset az, hogy ha a <tt> {_0}, {_u} </tt> egymás után van megadva, és csak egy válaszmező és egység van, azaz <tt> {_0}{_u} </tt>, akkor egyetlen hosszú beviteli válaszmezőben lesz egyesítve mind a válasz, mind az egység számára.';
$string['uniquecorrectansweris'] = 'A helyes válasz: {$a}';
$string['unit'] = 'Mértékegység';
$string['unitpenalty'] = 'Levonás rossz mértékegység esetén (0-1)*';
$string['unitpenalty_help'] = 'Ez az opció adja meg azt az osztályzatot, amellyel meg akarja büntetni a tanulót egy rossz részválaszért.

0 és 1 közötti értéket vesz fel. Ha 1 értéket vesz fel, akkor az egység és a válasz
egyúttal helyesnek kell lennie ahhoz, hogy pontot kapjon. Ez az egység
és a választ egy entitásként kezeljük. Másrészt ha kell
0 érték, a tanulók csak a helyes válaszért kaphatnak teljes pontot, mindegyik véletlenszerű
karakterláncnak nincs hatása a válasz végén.

Ezért ajánlatos az 1-es értéket használni, ha a válaszhoz nincs társított egység.';
$string['unsupportedformulafunction'] = 'A {$a} függvény nem támogatott';
$string['vars1'] = 'Lokális változók';
$string['vars1_help'] = 'Itt ugyanúgy definiálhatunk változókat, mint a globális változókat kérdés szinten. Az itt definiált változók felhasználhatók a rész válaszában vagy visszajelzésében
és láthatóságuk az alkatrészre korlátozódik.';
$string['vars2'] = 'Osztályozási változók';
$string['vars2_help'] = 'Itt minden lokális változó és a tanuló válaszai használhatók. A speciális felhasználási módokhoz lásd a dokumentációt.';
$string['vars2_link'] = 'https://moodleformulas.org/';
$string['varsdata'] = 'Példányosított adatkészletek';
$string['varsglobal'] = 'Globális változók';
$string['varsglobal_help'] = 'Itt adhatók meg képletek a példányos valószínűségi változók manipulálásához
(az összes valószínűségi változó elérhető itt). A matematika teljes listája
funkciókat és operátorokat a dokumentáció tartalmazza.

<pre class="prettyprint">a = 1,11111;<br>b = exp(3);<br>c = A + a + b;<br>d = sin(1,5*pi()) + c;< br>e = kerek(a, 0);<br>f = [0,1,2,3][A];<br>g = ["nulla","egy","kettő" ","három"][A];<br>távolság = sqrt(a*a + b*b);</pre>';
$string['varsglobal_link'] = 'https://moodleformulas.org/';
$string['varsrandom'] = 'Véletlen változók';
$string['varsrandom_help'] = 'Ezekhez a változókhoz minden kísérlet elején új véletlenszerű értékek generálódnak. Az tud
egy elemkészlet meghatározásával történik, amelyek közül választhat:

<pre class="prettyprint">A = {1,2,3};<br>C = {[1,-1], [2,-2], [3,-3]} ;<br>E = {10:100:10, 100, 1000};</pre>

Az elemek lehetnek számok, karakterláncok vagy ezek listája. Egy új próbálkozás kezdetén egy elemet húzunk a halmazból és hozzárendelünk a változóhoz
bal oldalon. Ezenkívül egy számkészlethez használhatja a tartomány jelölését, például 10:100:10 (lásd fent az E példát). </p>';
$string['varsrandom_link'] = 'https://moodleformulas.org/';
$string['varsstatistics'] = 'Statisztika';
$string['yougotnright'] = 'Ennek a kérdésnek {$a->num} részét helyesen válaszolta meg.';
