<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'sk', version '5.0'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Všetci potomkovia sú dokončení';
$string['competencies'] = 'Kompetencie';
$string['competenciesarenotenabled'] = 'Kompetencie nie sú povolené';
$string['competenciessettings'] = 'Nastavenia kompetencií';
$string['competency'] = 'Kompetencia';
$string['competencyframework'] = 'Kompetenčný rámec';
$string['completeplanstask'] = 'Dokončiť študijné plány, ktoré majú termín';
$string['coursecompetencyoutcome_complete'] = 'Dokončiť kompetenciu';
$string['coursecompetencyoutcome_evidence'] = 'Pripojiť evidenciu';
$string['coursecompetencyoutcome_none'] = 'Nerobiť nič';
$string['coursecompetencyoutcome_recommend'] = 'Odoslať na skontrolovanie';
$string['coursemodulecompetencyoutcome_complete'] = 'Dokončiť kompetenciu';
$string['coursemodulecompetencyoutcome_evidence'] = 'Pripojiť evidenciu';
$string['coursemodulecompetencyoutcome_none'] = 'Nerobiť nič';
$string['coursemodulecompetencyoutcome_recommend'] = 'Odoslať na skontrolovanie';
$string['deletecompetencyratings'] = 'Odstrániť hodnotenia kompetencie';
$string['duplicateditemname'] = '{$a} (kópia)';
$string['enablecompetencies'] = 'Povoliť kompetencie';
$string['enablecompetencies_desc'] = '.Kompetenciu umožňujú, aby boli používatelia posudzovaní podľa vzdelávacích plánov';
$string['errorcannotchangeapastduedate'] = 'Dátum splnenia už bolo prekročené a nemôže byť zmenené.';
$string['errorcannotsetduedateinthepast'] = 'Dátum splnenia nemôže byť nastavený v minulosti.';
$string['errorcannotsetduedatetoosoon'] = 'Dátum splnenia je príliš skoro';
$string['errorcompetencyrule'] = 'Pravidlo kompetencie kurzu "{$a}" je neznáme';
$string['errorcoursecompetencyrule'] = 'Pravidlo kompetencie kurzu "{$a}" je neznáme';
$string['errorinvalidcourse'] = 'Neplatný kurz.';
$string['errornocompetency'] = '{$a} kompetencia nemôže byť nájdená';
$string['errorplanstatus'] = 'Neznámy status "{$a}" vzdelávacieho plánu';
$string['errorscalealreadyused'] = 'Stupnicu nie je možné meniť, pretože už je používaná';
$string['errorscaleconfiguration'] = 'Stupnicu je nutné nakonfigurovať výberom východzej a dosiahnuteľnej položky';
$string['errorusercomptencystatus'] = 'Neznámy stav "{$a}" kompetencie používateľa';
$string['eventcompetencycreated'] = 'Kompetencia bola vytvorená';
$string['eventcompetencydeleted'] = 'Kompetencia bola vytvorená.';
$string['eventcompetencyframeworkcreated'] = 'Kompetenčný rámec bol vytvorený.';
$string['eventcompetencyframeworkdeleted'] = 'Kompetenčný rámec bol odstránený.';
$string['eventcompetencyframeworkupdated'] = 'Kompetenčný rámec bol aktualizovaný.';
$string['eventcompetencyframeworkviewed'] = 'Kompetenčný rámec bol zobrazený.';
$string['eventcompetencyupdated'] = 'Kompetencia bola aktualizovaná.';
$string['eventcompetencyviewed'] = 'Kompetencia bola zobrazená.';
$string['eventevidencecreated'] = 'Evidencia bola vytvorená.';
$string['eventplanapproved'] = 'Vzdelávací plán bol schválený.';
$string['eventplancompleted'] = 'Vzdelávací plán bol dokončený.';
$string['eventplancreated'] = 'Vzdelávací plán bol vytvorený.';
$string['eventplandeleted'] = 'Vzdelávací plán bol vymazaný.';
$string['eventplanreopened'] = 'Vzdelávací plán bol znovuotvorený.';
$string['eventplanreviewrequestcancelled'] = 'Žiadosť o revíziu vzdelávacieho plánu bola zrušená.';
$string['eventplanreviewrequested'] = 'Je požadovaná revízia vzdelávacieho plánu.';
$string['eventplanreviewstarted'] = 'Je zahájená revízia vzdelávacieho plánu.';
$string['eventplanreviewstopped'] = 'Revízia vzdelávacieho plánu bola zastavená.';
$string['eventplanunapproved'] = 'Vzdelávací plán nebol schválený.';
$string['eventplanunlinked'] = 'Vzdelávací plán bol odpojený.';
$string['eventplanupdated'] = 'Vzdelávací plán bol aktualizovaný.';
$string['eventplanviewed'] = 'Vzdelávací plán bol zobrazený.';
$string['eventtemplatecreated'] = 'Bola vytvorená šablóna vzdelávacieho plánu.';
$string['eventtemplatedeleted'] = 'Bola odstránená šablóna vzdelávacieho plánu.';
$string['eventtemplateupdated'] = 'Šablóna vzdelávacieho plánu bola aktualizovaná.';
$string['eventtemplateviewed'] = 'Šablóna vzdelávacieho plánu bola zobrazená.';
$string['eventusercompetencyplanviewed'] = 'Kompetenčný plán používateľa bol zobrazený.';
$string['eventusercompetencyrated'] = 'Kompetencie používateľa boli hodnotené.';
$string['eventusercompetencyratedincourse'] = 'Kompetencie používateľa boli hodnotené v kurze.';
$string['eventusercompetencyratedinplan'] = 'Kompetencie používateľa boli hodnotené vo vzdelávacom pláne.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Požiadavka na revíziu kompetencie používateľa bola zrušená.';
$string['eventusercompetencyreviewrequested'] = 'Je požadovaná revízia kompetencie používateľa.';
$string['eventusercompetencyreviewstarted'] = 'Revízia kompetencie používateľa bola zahájená.';
$string['eventusercompetencyreviewstopped'] = 'Revízia kompetencie používateľa bola zastavená.';
$string['eventusercompetencyviewed'] = 'Kompetencia používateľa bola zobrazená.';
$string['eventusercompetencyviewedincourse'] = 'Kompetencia používateľa bola zobrazená v kurze.';
$string['eventusercompetencyviewedinplan'] = 'Kompetencia používateľa bola zobrazená vo vzdelávacom pláne.';
$string['eventuserevidencecreated'] = 'Bola vytvorená evidencia predchádzajúceho štúdia.';
$string['eventuserevidencedeleted'] = 'Evidencia predchádzajúceho štúdia bola vymazaná.';
$string['eventuserevidenceupdated'] = 'Evidencia predchádzajúceho štúdia bola aktualizovaná.';
$string['evidence_competencyrule'] = 'Bolo splnené pravidlo kompetencie.';
$string['evidence_coursecompleted'] = 'Kurz "{$a}" bol dokončený.';
$string['evidence_coursemodulecompleted'] = 'Bola dokončená aktivita "{$a}".';
$string['evidence_courserestored'] = 'Hodnotenie bolo obnovené spolu s "{$a}".';
$string['evidence_evidenceofpriorlearninglinked'] = 'Bola pripojená evidencia predošlého štúdia "{$a}".';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Evidencia predošlého štúdia "{$a}" bola odpojená.';
$string['evidence_manualoverride'] = 'Hodnotenie kompetencie bolo nastavené manuálne.';
$string['evidence_manualoverrideincourse'] = 'Hodnotenie kompetencie bolo nastavené manuálne v kurze "{$a}".';
$string['evidence_manualoverrideinplan'] = 'Hodnotenie kompetencie bolo nastavené manuálne vo vzdelávacom pláne "{$a}".';
$string['invalidevidencedesc'] = 'Neplatný opis evidencie';
$string['invalidgrade'] = 'Neplatné hodnotenie';
$string['invalidplan'] = 'Neplatný vzdelávací plán';
$string['invalidtaxonomy'] = 'Neplatná taxonómia: {$a}';
$string['invalidurl'] = 'Neplatné URL. Presvedčte sa, že začína s "http: //" alebo "https: //".';
$string['nouserplanswithcompetency'] = 'Túto kompetenciu neobsahuje žiaden vzdelávací plán.';
$string['planstatusactive'] = 'Aktívny';
$string['planstatuscomplete'] = 'Dokončené';
$string['planstatusdraft'] = 'Návrh';
$string['planstatusinreview'] = 'V revízii';
$string['planstatuswaitingforreview'] = 'Čaká sa na revíziu';
$string['pointsrequiredaremet'] = 'Ak sú splnené požadované body';
$string['privacy:evidence:action:complete'] = 'Splnenie kompetencie, ak nie je hodnotená';
$string['privacy:evidence:action:log'] = 'Akcia prihlásenia';
$string['privacy:evidence:action:override'] = 'Prepísať hodnotenie kompetencie';
$string['privacy:metadata:competency'] = 'Záznam o kompetenciách';
$string['privacy:metadata:competency_coursecomp'] = 'Záznam o kompetenciách spojených s kurzom';
$string['privacy:metadata:competency_coursecompsetting'] = 'Záznam o nastavení kompetencie v kurze';
$string['privacy:metadata:competency_evidence'] = 'Zápis evidencie ovplyvňujúci stav kompetencie';
$string['privacy:metadata:competency_framework'] = 'Záznam o rámcoch kompetencií';
$string['privacy:metadata:competency_modulecomp'] = 'Záznam o kompetenciách spojených s modulom';
$string['privacy:metadata:competency_plan'] = 'Prehľad študijných plánov';
$string['privacy:metadata:competency_plancomp'] = 'Záznam o kompetenciách v študijnom pláne';
$string['privacy:metadata:competency_relatedcomp'] = 'Záznam o vzťahu medzi kompetenciami';
$string['privacy:metadata:competency_template'] = 'Zápis šablón študijného plánu';
$string['privacy:metadata:competency_templatecohort'] = 'Záznam o globálnych skupinách spojených so šablónou študijného plánu';
$string['privacy:metadata:competency_templatecomp'] = 'Záznam o kompetenciách v šablóne študijného plánu';
$string['privacy:metadata:competency_usercomp'] = 'Záznam o stave kompetencií používateľa';
$string['privacy:metadata:competency_usercompcourse'] = 'Záznam o stave kompetencií používateľa v kurze';
$string['privacy:metadata:competency_usercompplan'] = 'Záznam o stave kompetencií v študijnom pláne';
$string['privacy:metadata:competency_userevidence'] = 'Záznam evidencie predošlého štúdia';
$string['privacy:metadata:competency_userevidencecomp'] = 'Záznam o kompetenciách spojených s evidenciou predošlého štúdia';
$string['privacy:metadata:core_comments'] = 'Komentáre k študijným plánom a kompetenciám';
$string['privacy:metadata:evidence:action'] = 'Typ opatrení vykonaných s evidenciou';
$string['privacy:metadata:evidence:actionuserid'] = 'Používateľ vykonáva akciu';
$string['privacy:metadata:evidence:desca'] = 'Voliteľné parametre opisu predkladanej evidencie';
$string['privacy:metadata:evidence:desccomponent'] = 'Súčasť opisu predkladanej evidencie';
$string['privacy:metadata:evidence:descidentifier'] = 'Identifikátor predkladanej evidencie';
$string['privacy:metadata:evidence:grade'] = 'Známka spojená s evidenciou';
$string['privacy:metadata:evidence:note'] = 'Nelokalizovaná poznámka pripojená k evidencii';
$string['privacy:metadata:evidence:url'] = 'Adresa URL pridružená k evidencii';
$string['privacy:metadata:plan:description'] = 'Opis študijného plnánu';
$string['privacy:metadata:plan:duedate'] = 'Dátum splnenia študijného plánu';
$string['privacy:metadata:plan:name'] = 'Názov študijného plánu';
$string['privacy:metadata:plan:reviewerid'] = 'ID recenzenta študijného plánu';
$string['privacy:metadata:plan:status'] = 'Stav študijného plánu';
$string['privacy:metadata:plan:userid'] = 'ID používateľa, vlastníka študijného plánu';
$string['privacy:metadata:timecreated'] = 'Čas vytvorenia záznamu';
$string['privacy:metadata:timemodified'] = 'Čas úpravy záznamu';
$string['privacy:metadata:usercomp:grade'] = 'Známka udelená pre kompetenciu';
$string['privacy:metadata:usercomp:proficiency'] = 'Či je dosiahnutá kvalifikácia';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID recenzenta';
$string['privacy:metadata:usercomp:status'] = 'Stav kompetencie';
$string['privacy:metadata:usercomp:userid'] = 'ID používateľa, držiteľa kompetencie';
$string['privacy:metadata:userevidence:description'] = 'Opis evidencie';
$string['privacy:metadata:userevidence:name'] = 'Názov evidencie predchádzajúceho štúdia';
$string['privacy:metadata:userevidence:url'] = 'Adresa URL pridružená k evidencii';
$string['privacy:metadata:usermodified'] = 'Používateľ, ktorý záznam vytvoril alebo upravil';
$string['privacy:path:plans'] = 'Učebné plány';
$string['privacy:path:relatedtome'] = 'Súvisiace so mnou';
$string['privacy:path:userevidence'] = 'Evidencia predošlého štúdia';
$string['proficient'] = 'Splnené';
$string['pushcourseratingstouserplans'] = 'Hodnotenie z kurzov vnútiť do individuálnych vzdelávacích plánov';
$string['pushcourseratingstouserplans_desc'] = 'Východzia hodnota nastavenia kurzu pre aktualizáciu individuálnych vzdelávacích plánov, ak sú hodnotené kompetencie kurzu.';
$string['rating'] = 'Hodnotenie';
$string['syncplanscohorts'] = 'Synchronizácia plánov zo šablóny vzdelávacieho plánu globálnych skupín';
$string['taxonomy_behaviour'] = 'Správanie';
$string['taxonomy_competency'] = 'Kompetencia';
$string['taxonomy_concept'] = 'Pojem';
$string['taxonomy_domain'] = 'Oblasť';
$string['taxonomy_indicator'] = 'Indikátor';
$string['taxonomy_level'] = 'Úroveň';
$string['taxonomy_outcome'] = 'Výstup';
$string['taxonomy_practice'] = 'Prax';
$string['taxonomy_proficiency'] = 'Odbornosť';
$string['taxonomy_skill'] = 'Zručnosť';
$string['taxonomy_value'] = 'Hodnota';
$string['usercommentedonacompetency'] = '{$a->fullname} komentoval kompetenciu "{$a->competency}":

{$a->comment}

Viď {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} komentoval kompetenciu "{$a->competency}":</p> <div>{$a->comment}</div> <p>Prezrieť na: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} komentoval kompetenciu "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} komentoval kompetenciu  komentář kompetence.';
$string['usercommentedonaplan'] = '{$a->fullname} komentoval vzdelávací plán "{$a->plan}":

{$a->comment}

Prezrieť na: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} komentoval vzdelávací plán "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Prezrieť na: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} komentoval vzdelávací plán "{$a->plan}":';
$string['usercommentedonaplansubject'] = '{$a} komentár k vzdelávaciemu plánu.';
$string['usercompetencystatus_idle'] = 'Nečinný';
$string['usercompetencystatus_inreview'] = 'V revízii';
$string['usercompetencystatus_waitingforreview'] = 'Čaká sa na revíziu';
$string['userplans'] = 'Vzdelávacie plány';
