<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'ru', version '5.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Действия';
$string['activate'] = 'Включить доступ';
$string['activatesuccess'] = 'Доступ к значку «{$a}» разрешен.';
$string['addalignment'] = 'Добавить внешний навык или стандарт';
$string['addbadge'] = 'Добавить значки';
$string['addbadge_help'] = 'Выберите все значки, которые могут быть добавлены к требованию для этого значка. Удерживайте клавишу CTRL, чтобы выбрать несколько значков.';
$string['addbadgecriteria'] = 'Добавить критерий получения значка';
$string['addcohort'] = 'Добавить глобальную группу';
$string['addcohort_help'] = 'Выберите все глобальные группы, которые могут быть добавлены к требованию для этого значка. Удерживайте клавишу CTRL, чтобы выбрать несколько групп.';
$string['addcompetency'] = 'Добавить компетенцию';
$string['addcompetency_help'] = 'Выберите все компетенции, которые должны быть добавлены к требованию для этого значка. Удерживайте клавишу CTRL, чтобы выбрать несколько компетенций.';
$string['addcourse'] = 'Добавить курсы';
$string['addcourse_help'] = 'Выберите все курсы, которые необходимо пройти для получения этого значка. Удерживайте нажатой клавишу CTRL, чтобы выбрать несколько курсов.';
$string['addcriteria'] = 'Добавить критерии';
$string['addcriteriatext'] = 'Для добавления критерия выберите один из вариантов из раскрывающегося меню.';
$string['addcriterion'] = 'Добавить критерий';
$string['addedtobackpack'] = 'Значок добавлен в коллекцию наград';
$string['addrelated'] = 'Добавить связанный значок';
$string['addtobackpack'] = 'Добавить в коллекцию наград';
$string['adminonly'] = 'Эта страница доступна только администраторам сайта.';
$string['after'] = 'после даты выдачи.';
$string['aggregationmethod'] = 'Метод объединения';
$string['alignment'] = 'Выравнивание';
$string['all'] = 'Все';
$string['allmethod'] = 'Все выбранные режимы';
$string['allmethodactivity'] = 'Все выбранные элементы курса выполнены';
$string['allmethodbadges'] = 'Все выбранные значки были получены';
$string['allmethodcohort'] = 'Членство во всех выбранных глобальных группах';
$string['allmethodcompetencies'] = 'Все выбранные компетенции были подтверждены';
$string['allmethodcourseset'] = 'Все выбранные курсы пройдены';
$string['allmethodmanual'] = 'Все выбранные роли награждают значком';
$string['allmethodprofile'] = 'Все выбранные поля профиля были заполнены';
$string['allowcoursebadges'] = 'Разрешить значки курса';
$string['allowcoursebadges_desc'] = 'Разрешить создавать значки и награждать ими в контексте курса.';
$string['allowexternalbackpack'] = 'Разрешить подключение к внешним коллекциям наград';
$string['allowexternalbackpack_desc'] = 'При включенном параметре пользователи могут подключаться к внешней коллекции наград и делиться своими значками с этого сайта. Пользователи могут также выбрать отображение любых общедоступных значков из своей внешней коллекции наград на странице своего профиля на этом сайте. Рекомендуется оставить эту опцию отключенной, если ваш сайт не доступен из Интернета.';
$string['any'] = 'Любое';
$string['anymethod'] = 'Любое из выбранных условий выполнено';
$string['anymethodactivity'] = 'Любой из выбранных элементов курса выполнен';
$string['anymethodbadges'] = 'Любой из выбранных значков был получен';
$string['anymethodcohort'] = 'Членство в любой из выбранных глобальных групп';
$string['anymethodcompetencies'] = 'Любая из выбранных компетенций была подтверждена';
$string['anymethodcourseset'] = 'Любой из выбранных курсов завершен';
$string['anymethodmanual'] = 'Любая выбранная роль награждает значком';
$string['anymethodprofile'] = 'Любое из выбранных полей профиля было заполнено';
$string['apiversion'] = 'Поддерживаемая версия API';
$string['archivebadge'] = 'Хотите удалить значок «{$a}», но сохранить имеющиеся выданные значки?';
$string['archiveconfirm'] = 'Удалить, но сохранить существующие выданные значки';
$string['archivehelp'] = '<p> Этот параметр означает, что значок будет помечен как «бывший» и больше не будет отображаться в списке значков. Пользователи больше не будут иметь возможности получить этот значок, однако имеющиеся обладатели значка по-прежнему будут в состоянии демонстрировать этот значок на странице своего профиля и передавать его во внешние коллекции. </p><p> Если хотите, чтобы пользователи сохранили доступ к полученным значкам, то важно выбрать этот вариант вместо полного удаления значка. </p>';
$string['attachment'] = 'Прикрепить значок к сообщению';
$string['attachment_help'] = 'Если параметр включен, файл выданного значка будет вложен в электронное письмо получателю для скачивания. Для использования этой возможности вложения должны быть разрешены в «Администрирование > Сервер > Электронная почта > Внешний вид электронной почты: Разрешить вложения».';
$string['award'] = 'Выдать значок';
$string['awardedto'] = 'Награждается {$a}';
$string['awardedtoyou'] = 'Выданные мне';
$string['awardoncron'] = 'Большое количество пользователей награждено значком «{$a->badgename}». Может потребоваться некоторое время, чтобы все награжденные пользователи получили его.';
$string['awards'] = 'Награжденные';
$string['backpackapiurl'] = 'URL API коллекции наград';
$string['backpackavailability'] = 'Доверять внешним значкам';
$string['backpackavailability_help'] = 'Получатели значка должны иметь возможность доказать, что они получили свои значки у Вас. Для этого внешняя служба коллекции наград должна иметь доступ к Вашему сайту, чтобы получить подтверждение о выданных значках. Похоже, что Ваш сайт в настоящее время недоступен, а это значит, Ваши значки (уже выданные или перспективные) не могут быть проверены.

**Почему я вижу это сообщение?**

Такое может быть, если брандмауэр предотвращает доступ пользователей из внешней сети, Ваш сайт защищен паролем, или Вы работаете на локальном сайте,  недоступном из интернета (например, развернутом на локальной машине).

**Является ли это проблемой?**

Вы должны решить эту проблему на любом сайте в промышленной эксплуатации, где планируете выдавать значки, иначе получатели не смогут доказать, что они получили свои значки у Вас. Если сайт пока ещё реально не используется, Вы можете создавать и выпускать на локальном сайте тестовые значки.

**Что делать, если я не могу сделать весь мой сайт общедоступным?**

Единственный URL, необходимый для проверки — это [адрес-вашего-сайта]/badges/assertion.php. Если Вы можете изменить настройки брандмауэра, дав разрешение на внешний доступ к этому файлу, проверка значков будет работать.';
$string['backpackbadgessettings'] = 'Изменить настройки коллекции наград';
$string['backpackbadgessummary'] = 'У вас есть значки (всего {$a->totalbadges}), отображаемые из {$a->totalcollections} коллекции(й).';
$string['backpackcannotsendverification'] = 'Не удалось отправить подтверждение по электронной почте';
$string['backpackconnected'] = 'Коллекция наград подключена';
$string['backpackconnection'] = 'Подключение к коллекции наград';
$string['backpackconnection_connected'] = 'Ваша коллекция наград';
$string['backpackconnection_help'] = 'Храните и делитесь своими значками с этого сайта и отображайте общедоступные значки с других сайтов в своем профиле пользователя.';
$string['backpackconnectioncancelattempt'] = 'Подключиться с помощью другого адреса электронной почты';
$string['backpackconnectionconnect'] = 'Подключиться к коллекции наград';
$string['backpackconnectionnottested'] = 'Соединение не может быть проверено для этой коллекции наград, потому что поддерживаются только коллекции наград Open Badges v2.0.';
$string['backpackconnectionok'] = 'Соединение с коллекцией наград успешно установлено.';
$string['backpackconnectionresendemail'] = 'Отправить сообщение с подтверждением по почте';
$string['backpackconnectionunexpectedmessage'] = 'Коллекция наград вернула ошибку: «{$a}».';
$string['backpackconnectionunexpectedresult'] = 'Не удалось подключиться к Вашей коллекции наград. Поставщик коллекции наград отправил это сообщение: «{$a}».';
$string['backpackdetails'] = 'Настройки коллекций наград';
$string['backpackdisconnected'] = 'Нет соединения с коллекцией наград';
$string['backpackemail_required'] = 'Адрес электронной почты не может быть пустым';
$string['backpackemailverificationpending'] = 'Ожидание верификации';
$string['backpackemailverifyemailbody'] = 'Здравствуйте, {$a->userfirstname}!

Вы почти закончили подключение к своей коллекции наград на сайте «{$a->sitename}».
Чтобы завершить подключение к рюкзаку, подтвердите свой адрес электронной почты с помощью следующей кнопки:

{$a->buttonlink}

Если кнопка не сработает, просто скопируйте этот адрес и вставьте его в адресную строку своего браузера:
{$a->link}

Если вы не пытались подключиться к своей коллекции наград, можете смело игнорировать это письмо.

Для получения дополнительной помощи свяжитесь со службой поддержки вашего сайта,

{$a->админ}';
$string['backpackemailverifyemailsubject'] = '{$a}: подтверждение электронной почты коллекции наград';
$string['backpackemailverifypending'] = 'Письмо с подтверждением отправлено по адресу <strong>{$a}</strong>. Нажмите на ссылку подтверждения в электронном письме, чтобы активировать подключение к коллекции наград.';
$string['backpackemailverifysuccess'] = 'Теперь Вы подключены к своей коллекции наград.';
$string['backpackemailverifytokenmismatch'] = 'Авторизация по ссылке не пройдена. Убедитесь, что вы нажали ссылку в последнем полученном вами электронном письме.';
$string['backpackexporterror'] = 'Не получилось экспортировать значок в коллекцию наград';
$string['backpackexporterrorwithinfo'] = 'Не удается экспортировать значок «{$a->badgename}» в коллекцию. Ошибка: {$a->error}';
$string['backpackimport'] = 'Настройки импорта значка';
$string['backpackimport_help'] = 'После успешного соединения с коллекцией наград, значки из коллекции могут быть отображены на странице «Мои значки» и на странице Вашего профиля.

Здесь Вы можете выбрать наборы значков из вашей коллекции наград, которые хотите отобразить в своем профиле.';
$string['backpackprovider'] = 'Поставщик коллекции наград';
$string['backpacksettings'] = 'Настройки эмитента наград';
$string['backpackweburl'] = 'URL-адрес эмитента наград';
$string['badgedetails'] = 'Подробнее о значке';
$string['badgeimage'] = 'Изображение';
$string['badgeimage_help'] = 'Размер изображения должен быть не менее 300 х 300 пикселей. Оно будет отображаться размером 300 x 300 пикселей на странице значка и 100 x 100 пикселей на странице профиля пользователя.';
$string['badgeimageinfo'] = 'Для достижения наилучших результатов загрузите квадратное изображение размером не менее 300 x 300 пикселей.';
$string['badgeissued'] = 'Значок выдан';
$string['badgeprivacysetting'] = 'Настройки конфиденциальности значков';
$string['badgeprivacysetting_help'] = 'Полученные Вами значки могут отображаться на странице Вашего профиля. Этот параметр позволяет настроить автоматическое отображение новых значков.

Вы также можете настраивать конфиденциальность отдельных значков на странице «Мои значки».';
$string['badgeprivacysetting_str'] = 'Автоматически показывать полученные значки на странице моего профиля';
$string['badges'] = 'Значки';
$string['badgesalt'] = 'Зашумление (salt) для хеширования адреса электронной почты получателя';
$string['badgesalt_desc'] = 'Применение хэшей позволяет службам коллекций наград подтверждать получение значков без необходимости раскрывать адрес электронной почты получателя. В этом параметре следует использовать только цифры и буквы.

Примечание: С целью подтверждения получателя, пожалуйста, избегайте изменения этого параметра после начала выдачи значков.';
$string['badgesdisabled'] = 'Использование значков не разрешено на этом сайте';
$string['badgesearned'] = 'Количество полученных значков: {$a}';
$string['badgesettings'] = 'Настройки значков';
$string['badgestatus_0'] = 'Недоступно';
$string['badgestatus_1'] = 'Доступно';
$string['badgestatus_2'] = 'Недоступно (критерии заблокированы)';
$string['badgestatus_3'] = 'Доступно (критерии заблокированы)';
$string['badgestatus_4'] = 'Архив';
$string['badgestoearn'] = 'Количество доступных значков: {$a}';
$string['badgesview'] = 'Значки курса';
$string['badgetags'] = 'Теги значков';
$string['badgeurl'] = 'Ссылка на выданный значок';
$string['balignment'] = 'Соответствия  ({$a})';
$string['bawards'] = 'Награжденные - ({$a})';
$string['bcriteria'] = 'Критерии';
$string['bdetails'] = 'Редактировать сведения';
$string['bendorsement'] = 'Подтверждение';
$string['bmessage'] = 'Сообщение';
$string['boverview'] = 'Обзор';
$string['brelated'] = 'Связанные значки ({$a})';
$string['bydate'] = 'завершить к';
$string['claim'] = 'Заявка';
$string['claimcomment'] = 'Комментарий подтверждения';
$string['claimid'] = 'URL-адрес заявки';
$string['clearsettings'] = 'Сбросить настройки';
$string['completioninfo'] = 'Этот значок был выдан в связи с выполнением:';
$string['completionnotenabled'] = 'Завершение курса не включено в этом курсе, поэтому оно не может быть внесено в критерий значка. Завершение курса может быть включено в настройках курса.';
$string['configenablebadges'] = 'При включенном параметре разрешено создавать значки и награждать ими пользователей сайта.';
$string['configuremessage'] = 'Сообщение о значке';
$string['connect'] = 'Подключить';
$string['connected'] = 'Подключено';
$string['connecting'] = 'Подключение ...';
$string['contact'] = 'Эл. почта';
$string['contact_help'] = 'Адрес электронной почты эмитента значка.';
$string['copy'] = 'Копировать';
$string['copyof'] = 'Копия {$a}';
$string['course'] = 'Курс: {$a}';
$string['coursebadges'] = 'Значки';
$string['coursebadgesdisabled'] = 'Значки курса не разрешены на этом сайте.';
$string['coursebadgetitle'] = 'Значок курса {$a}';
$string['coursecompletion'] = 'Пользователи должны завершить этот курс.';
$string['create'] = 'Новый значок';
$string['createbutton'] = 'Создать значок';
$string['creatorbody'] = '<p> {$a->user} выполнил(а) все необходимые условия и награжден(а) значком. Посмотреть выданный значок - {$a->link} </p>';
$string['creatorsubject'] = '{$a} награжден(а)!';
$string['criteria_0'] = 'Этот значок присуждается, когда ...';
$string['criteria_1'] = 'Выполнен элемент курса';
$string['criteria_1_help'] = 'Пользователи награждаются значком при выполнении набора элементов курса.';
$string['criteria_2'] = 'Награждение вручную';
$string['criteria_2_help'] = 'Пользователи, которые имеют определенную роль в рамках сайта или курса, могут вручную награждать знаком.';
$string['criteria_3'] = 'Социальное партнерство';
$string['criteria_3_help'] = 'Социальное';
$string['criteria_4'] = 'Курс завершен';
$string['criteria_4_help'] = 'Знаком награждаются пользователи, которые завершили курс. Этот критерий может иметь дополнительные параметры, такие как минимальная оценка и дата окончания курса.';
$string['criteria_5'] = 'Завершение набора курсов';
$string['criteria_5_help'] = 'Знаком награждаются пользователи, которые завершили несколько курсов. Каждый курс может иметь дополнительные параметры, такие как минимальная оценка и дата окончания курса.';
$string['criteria_6'] = 'Заполнение профиля пользователя';
$string['criteria_6_help'] = 'Знаком награждаются пользователи, которые заполнили определенные поля в своем профиле. Вы можете выбрать поля среди списка доступных для пользователей полей профиля (заданных по умолчанию и настраиваемых).';
$string['criteria_7'] = 'Выданные значки';
$string['criteria_7_help'] = 'Разрешить выдавать значок пользователям на основе других значков, которые они получили.';
$string['criteria_8'] = 'Членство в глобальных группах';
$string['criteria_8_help'] = 'Разрешает выдавать значок пользователям на основе членства в глобальной группе.';
$string['criteria_9'] = 'Компетентности';
$string['criteria_9_help'] = 'Позволяет присуждать значок пользователям на основе достигнутых ими компетенций.';
$string['criteria_descr'] = 'Пользователи награждаются этим значком при выполнении следующих условий:';
$string['criteria_descr_0'] = 'Выполните перечисленные требования: (<strong>{$a}</strong>).';
$string['criteria_descr_1'] = '<strong>{$a}</strong> из следующих элементов курса должны быть выполнены:';
$string['criteria_descr_2'] = 'Этим значком могут  награждать пользователи (<strong>{$a}</strong>) со следующими ролями:';
$string['criteria_descr_4'] = 'Пользователи должны завершить курс';
$string['criteria_descr_5'] = '<strong>{$a}</strong> из следующих курсов должны быть завершены:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> из следующих полей профиля должны быть заполнены:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> из следующих значков должны быть получены:';
$string['criteria_descr_8'] = 'Членство в <strong>{$a}</strong> из следующих глобальных групп обязательно:';
$string['criteria_descr_9'] = 'Необходимо выполнить <strong>{$a}</strong>  из следующих компетенций:';
$string['criteria_descr_bydate'] = 'по <em>{$a}</em>';
$string['criteria_descr_grade'] = 'с минимальной оценкой <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Завершение <strong>{$a}</strong> из:';
$string['criteria_descr_short1'] = 'Завершение <strong>{$a}</strong> из:';
$string['criteria_descr_short2'] = 'Награждение от <strong>{$a}</strong> из:';
$string['criteria_descr_short4'] = 'Завершить курс';
$string['criteria_descr_short5'] = 'Завершение <strong>{$a}</strong> из:';
$string['criteria_descr_short6'] = 'Заполнение <strong>{$a}</strong> полей профиля из:';
$string['criteria_descr_short7'] = 'Получено <strong>{$a}</strong> из:';
$string['criteria_descr_short8'] = 'Членство в <strong>{$a}</strong> глобальных группах из:';
$string['criteria_descr_short9'] = 'Завершение <strong>{$a}</strong> из:';
$string['criteria_descr_single_1'] = 'Следующий элемент курса должен быть выполнен:';
$string['criteria_descr_single_2'] = 'Этим значком могут награждать пользователи со следующей ролью:';
$string['criteria_descr_single_4'] = 'Пользователи должны завершить курс';
$string['criteria_descr_single_5'] = 'Следующий курс должен быть закончен:';
$string['criteria_descr_single_6'] = 'Следующее поле профиля пользователя должно быть заполнено:';
$string['criteria_descr_single_7'] = 'Следующий значок должен быть получен:';
$string['criteria_descr_single_8'] = 'Требуется членство в следующей глобальной группе:';
$string['criteria_descr_single_9'] = 'Необходимо выполнить следующие компетенции:';
$string['criteria_descr_single_short1'] = 'Завершено:';
$string['criteria_descr_single_short2'] = 'Награждает:';
$string['criteria_descr_single_short4'] = 'Закончить курс';
$string['criteria_descr_single_short5'] = 'Завершено:';
$string['criteria_descr_single_short6'] = 'Заполнено:';
$string['criteria_descr_single_short7'] = 'Получено:';
$string['criteria_descr_single_short8'] = 'Членство в:';
$string['criteria_descr_single_short9'] = 'Выполнено:';
$string['criteriacreated'] = 'Критерий значка создан';
$string['criteriadeleted'] = 'Критерий значка удален';
$string['criteriasummary'] = 'Описание критерия';
$string['criteriaupdated'] = 'Критерий значка обновлен';
$string['criterror'] = 'Текущие параметры выдачи';
$string['criterror_help'] = 'Эти поля отображают все параметры, которые изначально были добавлены в условия получения этого значка, но теперь не доступны. Рекомендуется снять галочку с таких параметров, чтобы быть уверенным, что в будущем пользователи смогут получить этот значок.';
$string['currentimage'] = 'Текущее изображение';
$string['currentstatus'] = 'Текущий статус:';
$string['dateawarded'] = 'Дата выдачи';
$string['dateearned'] = 'Дата: {$a}';
$string['day'] = 'дн.';
$string['deactivate'] = 'Отключить доступ';
$string['deactivatesuccess'] = 'Доступ к значку «{$a}» отключен.';
$string['defaultissuercontact'] = 'Адрес электронной почты эмитента значка.';
$string['defaultissuercontact_desc'] = 'Адрес электронной почты, связанный с эмитентом значка. В Open Badges v2.0 используется для аутентификации при публикации значков.';
$string['defaultissuername'] = 'Название эмитента значка';
$string['defaultissuername_desc'] = 'Наименование органа, агента или учреждения, выдавшего значок.';
$string['defaultissuerpassword'] = 'Пароль эмитента значка';
$string['defaultissuerpassword_help'] = 'На сайте требуется учетная запись с адресом электронной почты, указанным в настройках почты эмитента значка: Администрирование > Значки > Настройки значков. Пароль для учетной записи должен быть введен здесь.';
$string['delbadge'] = 'Хотите удалить значок «{$a}» и удалить все эти имеющиеся выданные значки?';
$string['delconfirm'] = 'Удалить вместе с имеющимися выданными значками';
$string['delcritconfirm'] = 'Вы уверены, что хотите удалить этот критерий?';
$string['deletehelp'] = '<p>Полное удаление значка означает, что все записи с информацией о нем и критериями будут удалены. Пользователи, которые получили этот значок, больше не будут иметь доступ к нему и не смогут демонстрировать его на странице своего профиля.</p>
<p>Примечание: У пользователей, которые получили этот значок и уже разместили его в своей внешней коллекции, этот значок во внешней коллекции останется. Тем не менее, они не смогут по ссылке на этот веб-сайт получить доступ к страницам, содержащим критерии и подтверждение получения значка.</p>';
$string['delexternalbackpack'] = 'Удалить коллекцию наград сайта';
$string['delexternalbackpackconfirm'] = 'Удалить коллекцию наград сайта «{$a}»?';
$string['delparamconfirm'] = 'Вы уверены, что хотите удалить этот параметр?';
$string['description'] = 'Описание';
$string['descriptioninfo'] = 'Что означает этот значок?';
$string['disconnect'] = 'Отключить';
$string['donotaward'] = 'В настоящее время этот значок не активен, поэтому он не может быть присужден пользователям. Если Вы хотите наградить этим значком, то установите его статус как активный.';
$string['enablebadges'] = 'Включить значки';
$string['endorsement'] = 'Подтверждение';
$string['error:backpackdatainvalid'] = 'Возвращаемые данные из коллекции наград признаны недействительными.';
$string['error:backpackemailnotfound'] = 'Почтовый адрес «{$a}» не связан с коллекцией наград. Вы должны <a href="http://backpack.openbadges.org"> создать коллекцию наград</a> для этой учетной записи или войти с другого адреса электронной почты.';
$string['error:badgeawardnotfound'] = 'Не удалось подтвердить награждение этим значком. Возможно, этот значок был отозван.';
$string['error:badgenotfound'] = 'Значок не найден';
$string['error:cannotact'] = 'Не удалось активировать значок.';
$string['error:cannotawardbadge'] = 'Не удалось наградить пользователя значком.';
$string['error:cannotdeletecriterion'] = 'Этот критерий не может быть удален.';
$string['error:cannotrevokebadge'] = 'Нельзя отменить значок пользователя.';
$string['error:clone'] = 'Не удалось скопировать значок';
$string['error:connectionunknownreason'] = 'Подключение не удалось по неизвестной причине.';
$string['error:duplicatename'] = 'Значок с таким названием уже существует в системе.';
$string['error:externalbadgedoesntexist'] = 'Значок не найден';
$string['error:guestuseraccess'] = 'Вы используете гостевой доступ. Чтобы увидеть значки, нужно войти в систему с учетной записью пользователя.';
$string['error:invalidcriteriatype'] = 'Неверный тип критериев.';
$string['error:invalidexpiredate'] = 'Срок действия должен быть в будущем.';
$string['error:invalidexpireperiod'] = 'Срок действия не может быть отрицательным или равным 0.';
$string['error:invalidparambadge'] = 'Значок не существует.';
$string['error:invalidparamcohort'] = 'Глобальная группа не существует.';
$string['error:noactivities'] = 'В этом курсе нет никаких элементов с заданным критерием выполнения.';
$string['error:nobadges'] = 'В настоящее время нет значков с разрешенным доступом для добавления в качестве критериев. Значок сайта может иметь только другие значки в качестве критерия. Значок курса может иметь другие значки курса или значки сайта в качестве критериев.';
$string['error:nocohorts'] = 'Нет глобальных групп';
$string['error:nocourses'] = 'Завершение курса не включено ни для одного из курсов на этом сайте, поэтому отображать нечего. Завершение курса может быть включен в его настройках.';
$string['error:nogroupslink'] = '<p> Показаны только общедоступные коллекции.  <a href="{$a}" target="_blank" rel="nofollow">Посетите свою коллекцию наград</a>, чтобы создать несколько общедоступных коллекций. </p>';
$string['error:nogroupssummary'] = '<p> В вашей коллекции наград нет общедоступных коллекций значков. </p>';
$string['error:nopermissiontoview'] = 'Вы не имеете разрешения на просмотр получателей значка';
$string['error:nosuchbadge'] = 'Значок с ID {$a} не существует.';
$string['error:nosuchcohort'] = 'Предупреждение: Эта глобальная группа больше не доступна.';
$string['error:nosuchcourse'] = 'Предупреждение: Этот курс больше не доступен.';
$string['error:nosuchfield'] = 'Предупреждение: Данное поле профиля пользователя больше недоступно.';
$string['error:nosuchmod'] = 'Предупреждение: этот элемент курса больше не доступен.';
$string['error:nosuchrole'] = 'Предупреждение: эта роль больше не доступна.';
$string['error:nosuchuser'] = 'Пользователь с этим адресом эл. почты не имеет учетной записи в этой коллекции наград.';
$string['error:notifycoursedate'] = 'Значки, связанные с завершением курса и  выполнением элементов курса не могут быть выданы до даты начала курса ({$a}).';
$string['error:parameter'] = 'Предупреждение: хотя бы один параметр должен быть выбран для обеспечения корректной выдачи значка.';
$string['error:relatedbadgedoesntexist'] = 'Здесь нет общедоступного значка с этим идентификатором';
$string['error:requesterror'] = 'Неудачный запрос на соединение  (код ошибки - {$a}).';
$string['error:requesttimeout'] = 'Время соединения истекло до окончания выполнения запроса.';
$string['error:save'] = 'Не удалось сохранить значок.';
$string['error:userdeleted'] = '{$a->user} (Пользователь больше не существует на сайте {$a->site})';
$string['eventbadgearchived'] = 'Значок заархивирован';
$string['eventbadgeawarded'] = 'Значок выдан';
$string['eventbadgecreated'] = 'Значок создан';
$string['eventbadgecriteriacreated'] = 'Критерии значка созданы';
$string['eventbadgecriteriadeleted'] = 'Критерии значка удалены';
$string['eventbadgecriteriaupdated'] = 'Критерии значка обновлены';
$string['eventbadgedeleted'] = 'Значок удален';
$string['eventbadgedisabled'] = 'Значок отключен';
$string['eventbadgeduplicated'] = 'Значок продублирован';
$string['eventbadgeenabled'] = 'Значок включен';
$string['eventbadgelistingviewed'] = 'Просмотрен список значков';
$string['eventbadgerevoked'] = 'Значок отменен';
$string['eventbadgeupdated'] = 'Значок обновлен';
$string['eventbadgeviewed'] = 'Значок просмотрен';
$string['existingrecipients'] = 'Существующие получатели значка';
$string['existsinbackpack'] = 'Значок уже есть в коллекции наград';
$string['expired'] = 'Не действительные';
$string['expiredate'] = 'Этот значок действителен до {$a}.';
$string['expireddate'] = 'Этот значок действовал до {$a}.';
$string['expiredin'] = 'Срок действия истек {$a}';
$string['expireperiod'] = 'Этот значок действителен в течение {$a} дн. после выдачи.';
$string['expireperiodh'] = 'Этот значок действителен в течение {$a} час. после выдачи.';
$string['expireperiodm'] = 'Этот значок действителен в течение {$a} мин. после выдачи.';
$string['expireperiods'] = 'Этот значок действителен в течение {$a} сек. после выдачи.';
$string['expiresin'] = 'Срок действия истекает {$a}';
$string['expirydate'] = 'Дата окончания срока действия';
$string['expirydate_help'] = 'Необязательно: срок действия значка может истечь в конкретную дату или дата окончания рассчитывается, исходя из даты выдачи значка пользователю.';
$string['externalbackpack_required'] = 'Необходимо указать поставщика коллекции наград.';
$string['externalbadges'] = 'Мои значки с других сайтов';
$string['externalbadges_help'] = 'Здесь отображаются значки из внешних коллекций наград.';
$string['externalbadgesp'] = 'Значки с других сайтов:';
$string['externalconnectto'] = 'Для отображения внешних значков Вам нужно <a href="{$a}">подключиться к коллекции наград</a>.';
$string['fixed'] = 'Фиксированная дата - срок действия значка истекает в следующую дату:';
$string['hidden'] = 'Скрытый';
$string['hiddenbadge'] = 'К сожалению, владелец значка не сделал эту информацию доступной.';
$string['hostedurl'] = 'Внешний URL';
$string['hostedurldescription'] = 'Внешний URL-адрес, на котором размещен значок';
$string['imageauthoremail'] = 'Адрес эл. почты автора изображения';
$string['imageauthoremail_help'] = 'Если указан адрес электронной почты автора изображения значка, то он отображается на странице значка.';
$string['imageauthorname'] = 'Имя автора изображения';
$string['imageauthorname_help'] = 'Если указано, то имя автора изображения значка отображается на странице значка.';
$string['imageauthorurl'] = 'URL-адрес автора изображения';
$string['imageauthorurl_help'] = 'Если указано, то ссылка на веб-сайт автора изображения значка отображается на странице значка. URL должен иметь префикс http: // или https: //.';
$string['imagecaption'] = 'Подпись к изображению';
$string['imagecaption_help'] = 'Указанная подпись к изображению отображается на странице значка.';
$string['includeauthdetails'] = 'Включить данные авторизации в коллекции наград';
$string['invalidurl'] = 'Неверный URL';
$string['issuancedetails'] = 'Срок действия значка';
$string['issuedbadge'] = 'Информация о выданных значках';
$string['issuedby'] = 'Выдан {$a}';
$string['issuedon'] = 'Выдан {$a}';
$string['issuerdetails'] = 'Сведения об эмитенте';
$string['issueremail'] = 'Адрес эл. почты';
$string['issueremail_help'] = 'Контактный адрес электронной почты организации, выдавшей подтверждение.';
$string['issuername'] = 'Наименование эмитента';
$string['issuername_endorsement'] = 'Наименование поручителя';
$string['issuername_endorsement_help'] = 'Наименование подтверждающей организации';
$string['issuername_help'] = 'Наименование органа, агента или учреждения, выдавшего значок.';
$string['issuerurl'] = 'URL-адрес эмитента';
$string['issuerurl_help'] = 'Веб-сайт организации, выдавшей подтверждение. URL-адрес должен иметь префикс http:// или https://.';
$string['language'] = 'Язык';
$string['language_help'] = 'Язык, используемый на странице значка.';
$string['listbackpacks'] = 'Список коллекций наград';
$string['localbadges'] = 'Мои значки с сайта {$a}';
$string['localbadgesh'] = 'Мои значки с этого сайта';
$string['localbadgesh_help'] = 'Все значки, полученные на этом веб-сайте, за завершение курсов, выполнение элементов курсов и других требований.

Вы можете управлять значками в своем профиле, сделав их публичными или личными.

Вы можете скачать все свои значки или каждый из них по отдельности и сохранить на своем компьютере. Скачанные значки могут быть добавлены в Вашу коллекцию наград во внешней службе.';
$string['localbadgesp'] = 'Значки из {$a}:';
$string['localconnectto'] = 'Чтобы обнародовать эти значки за пределами этого сайта, Вам нужно <a href="{$a}">подключиться к коллекции наград</a> .';
$string['loginbackpacktitle'] = '<strong>Войти в свою коллекцию наград</strong>';
$string['makeprivate'] = 'Сделать личным';
$string['makepublic'] = 'Опубликовать';
$string['managebackpacks'] = 'Управление коллекциями наград';
$string['managebadges'] = 'Управление значками';
$string['message'] = 'Текст сообщения';
$string['messagebody'] = '<p> Вы были награждены значком «%badgename%»! </p><p> Более подробную информацию об этом значке можно найти на %badgelink%. </p><p> Вы можете скачать значок со страницы {$a}. </p>';
$string['messagesubject'] = 'Поздравляем! Вы награждены значком!';
$string['method'] = 'Этот критерий считается выполненным, когда ...';
$string['mingrade'] = 'Требуемая минимальная оценка';
$string['month'] = 'Месяц(ев)';
$string['moredetails'] = 'Подробнее';
$string['mybackpack'] = 'Настройки моей коллекции наград';
$string['mybadges'] = 'Мои значки';
$string['namewithlink'] = 'Название со ссылкой';
$string['never'] = 'Никогда - этот значок не имеет срока действия.';
$string['newbackpack'] = 'Добавить новую коллекцию наград';
$string['newbadge'] = 'Добавить новый значок';
$string['newbadgedeprecated'] = 'Вы были перенаправлены со страницы badges/newbadge.php. Обратите внимание, что badges/newbadge.php будет удалена в ближайшем будущем.
<br/>Обновите ссылки и закладки, чтобы использовать текущую страницу badges/edit.php.';
$string['newimage'] = 'Новое изображение';
$string['noalignment'] = 'Этот значок не имеет каких-либо внешних навыков или стандартов.';
$string['noawards'] = 'Этот значок пока никто не получил.';
$string['nobackpack'] = 'Нет службы коллекции наград, связанных с этой учетной записью. <br/>';
$string['nobackpackbadgessummary'] = 'В выбранных вами коллекциях нет значков.';
$string['nobackpackcollectionssummary'] = 'Коллекции значков не выбраны.';
$string['nobackpacks'] = 'Нет доступных коллекций наград.';
$string['nobadges'] = 'В настоящее время для пользователей нет значков, которые они могли бы заработать.';
$string['nocompetencies'] = 'Не выбрано ни одной компетенции.';
$string['nocriteria'] = 'Критерии для получения этого значка еще не установлены.';
$string['noendorsement'] = 'Этот значок не одобрен.';
$string['noexpiry'] = 'У этого значка нет срока действия.';
$string['nomatchingawards'] = 'Пока нет ни одного получателя, который бы заслужил этот значок.';
$string['nomatchingbadges'] = 'Нет соответствующих значков, которые могли бы заслужить пользователи.';
$string['noparamstoadd'] = 'Нет дополнительных требований, которые можно добавить к этим условиям получения значка.';
$string['norelated'] = 'Отсутствуют значки, связанные с этим значком.';
$string['notacceptedrole'] = 'Ваша текущая роль не входит в число ролей, которые могут вручную выдать этот значок. <br/> Посмотреть, кто из пользователей уже получил этот значок, Вы можете на странице {$a} .';
$string['notconnected'] = 'Нет соединения';
$string['notealignment'] = 'Можно указать внешние навыки или стандарты, которым соответствует значок. Любые внешние навыки или стандарты отображаются на странице значка.';
$string['noteendorsement'] = 'Подтверждение от третьей стороны может быть использовано для повышения ценности значка. Например, значок, выданный учителем, может быть подтвержден школой или значок, выданный местным органом, может быть подтвержден национальным органом, присуждающим награды.';
$string['noterelated'] = 'Значки, имеющие взаимосвязь, отмечаются как связанные. Например, значки с одинаковыми критериями, которые отображаются на разных языках, можно отметить как связанные. Все связанные значки отображаются на странице значка.';
$string['nothingtoadd'] = 'Добавить нечего - нет доступных критериев.';
$string['notification'] = 'Сообщение создателю значка';
$string['notification_help'] = 'Эта настройка управляет уведомлениями, отправляемыми создателю значка с сообщением о выдаче значка.

Доступны следующие варианты:

* ** НИКОГДА ** - Не отправлять уведомления.

* ** КАЖДЫЙ РАЗ ** - отправлять уведомление каждый раз при выдаче этого значка.

* ** ЕЖЕДНЕВНО ** - отправлять уведомления раз в день.

* ** ЕЖЕНЕДЕЛЬНО ** - отправлять уведомления раз в неделю.

* ** ЕЖЕМЕСЯЧНО ** - отправлять уведомления раз в месяц.';
$string['notifydaily'] = 'Ежедневно';
$string['notifyevery'] = 'Каждый раз';
$string['notifymonthly'] = 'Ежемесячно';
$string['notifyweekly'] = 'Еженедельно';
$string['numawards'] = 'Пользователи, получившие значок «{$a->badgename}»: <a href="{$a->link}">{$a->count</a>.';
$string['numawardstat'] = 'Пользователи, получившие значок «{$a->badgename}»: {$a->awards}.';
$string['oauth2issuer'] = 'Службы OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Прочая навигация ...';
$string['overallcrit'] = 'из выбранных критериев выполнены.';
$string['password_required'] = 'Пароль не может быть пустым';
$string['potentialrecipients'] = 'Потенциальные получатели значка';
$string['preferences'] = 'Настройки значков';
$string['privacy:metadata:backpack'] = 'Запись коллекции наград пользователя';
$string['privacy:metadata:backpack:backpackuid'] = 'Уникальный идентификатор коллекции наград';
$string['privacy:metadata:backpack:email'] = 'Адрес электронной почты, связанный с коллекцией наград';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID коллекции наград';
$string['privacy:metadata:backpack:userid'] = 'ID пользователя, которому принадлежит коллекция наград';
$string['privacy:metadata:backpackoauth2'] = 'Информация OAuth 2 при подключении пользователя к внешней коллекции наград';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID службы OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Список возможностей подключения коллекции наград';
$string['privacy:metadata:backpackoauth2:token'] = 'Токен подключения к коллекции наград';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID пользователя, подключившегося к коллекции наград';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID пользователя, изменившего подключение';
$string['privacy:metadata:badge'] = 'Коллекция значков';
$string['privacy:metadata:badge:timecreated'] = 'Время, когда значок был создан';
$string['privacy:metadata:badge:timemodified'] = 'Время, когда значок был последний раз изменен';
$string['privacy:metadata:badge:usercreated'] = 'ID пользователя, создавшего значок';
$string['privacy:metadata:badge:usermodified'] = 'ID пользователя, изменившего значок';
$string['privacy:metadata:criteriamet'] = 'Набор критериев, которые были выполнены';
$string['privacy:metadata:criteriamet:datemet'] = 'Дата, когда критерии были выполнены';
$string['privacy:metadata:criteriamet:userid'] = 'ID пользователя, который выполнил критерии';
$string['privacy:metadata:external:backpacks'] = 'Информация, передаваемая при отправке пользователями их значков во внешнюю коллекцию значков';
$string['privacy:metadata:external:backpacks:badge'] = 'Название значка';
$string['privacy:metadata:external:backpacks:description'] = 'Описание значка';
$string['privacy:metadata:external:backpacks:image'] = 'Изображение значка';
$string['privacy:metadata:external:backpacks:issuer'] = 'Некоторая информация об эмитенте значка';
$string['privacy:metadata:external:backpacks:url'] = 'URL Moodle, где можно увидеть информацию о выпущенном значке';
$string['privacy:metadata:issued'] = 'Запись о выданных значках';
$string['privacy:metadata:issued:dateexpire'] = 'Дата, до которой действует выданный значок';
$string['privacy:metadata:issued:dateissued'] = 'Дата выдачи значка';
$string['privacy:metadata:issued:userid'] = 'ID пользователя, которому был выдан значок';
$string['privacy:metadata:manualaward'] = 'Запись о выдаче вручную';
$string['privacy:metadata:manualaward:datemet'] = 'Дата, когда пользователю был выдан значок';
$string['privacy:metadata:manualaward:issuerid'] = 'ID пользователя, выдавшего значок';
$string['privacy:metadata:manualaward:issuerrole'] = 'Роль пользователя, выдавшего значок';
$string['privacy:metadata:manualaward:recipientid'] = 'ID пользователя, которому вручную был выдан значок';
$string['recipient'] = 'Получатель значка';
$string['recipients'] = 'Получатели значка';
$string['recipientvalidationproblem'] = 'Этот пользователь не может быть подтвержден как получатель этого значка.';
$string['relatedbages'] = 'Связанные значки';
$string['relative'] = 'Относительная дата - срок действия значка истекает через некоторое время:';
$string['requiredbadge'] = 'По меньшей мере один значок должен быть добавлен к критерию получения значков.';
$string['requiredcohort'] = 'По меньшей мере одна глобальная группа должна быть добавлена к критерию глобальных групп.';
$string['requiredcompetency'] = 'В критерий компетенции следует добавить хотя бы одну компетенцию.';
$string['requiredcourse'] = 'По меньшей мере один курс должен быть добавлен к критерию завершения нескольких курсов.';
$string['reviewbadge'] = 'Изменения доступа к значку';
$string['reviewconfirm'] = '<p>Это действие сделает значок видимым для пользователей и даст им возможность получить его. </p><p> Вполне возможно, что некоторые пользователи уже выполнили условия получения этого значка и этот значок будет создан сразу после его включения. </p><p> После того, как значок будет выдан хотя бы одному пользователю, он будет <strong>заблокирован</strong> - определенные параметры, включая критерии и настройки истечения больше не могут быть изменены. </p><p> Вы уверены, что хотите разрешить доступ к значку «{$a}»? </p>';
$string['revoke'] = 'Отменить значок';
$string['save'] = 'Сохранить';
$string['searchname'] = 'Поиск по названию';
$string['selectaward'] = 'Пожалуйста, выберите роль, которой Вы хотите разрешить присуждать этот значок:';
$string['selectgroup_end'] = 'Отображены только публичные коллекции. Чтобы опубликовать больше коллекций, <a href="{$a}">посетите свою коллекцию наград</a>.';
$string['selectgroup_start'] = 'Выберите коллекцию из своей коллекции наград для отображения на этом сайте:';
$string['selecting'] = 'С выбранными значками ...';
$string['setup'] = 'Настройка подключения';
$string['sitebackpackdeleted'] = 'Коллекция наград сайта удалена.';
$string['sitebackpacknotdeleted'] = 'Эту коллекцию наград нельзя удалить, потому что она на сайте используется по умолчанию.';
$string['sitebackpackwarning'] = 'Не удалось подключиться к коллекции наград. <br/> <br/> Убедитесь, что в настройках параметра «Адрес эл.почты эмитента значка» указан правильный адрес электронной почты для учетной записи на веб-сайте коллекции наград. <br/> <br/> Убедитесь, что «Пароль эмитента значка» на <a href="{$a->url}"> странице настроек коллекции наград сайта </a> является правильным паролем для учетной записи на сайте коллекции наград. <br/> <br/> Коллекция наград: «{$a->warning}»';
$string['sitebadges'] = 'Значки сайта';
$string['sitebadges_help'] = 'Значками сайта пользователи могут быть награждены только за деятельность на сайте. Она включает в себя завершение нескольких курсов или заполнение профилей пользователей. Значки сайта могут также быть выданы вручную одним пользователем другому.

Значки за деятельность на уровне курса должны быть созданы на уровне курса. Значки курса можно найти в разделе Управление курсом > Значки.';
$string['sitebadgetitle'] = 'Значок сайта {$a}';
$string['status'] = 'Статус значка';
$string['status_help'] = 'Статус значка определяет его поведение в системе:

* ** ДОСТУПЕН ** - означает, что пользователи могут получить этот значок. Когда значок доступен для пользователей, его критерии не могут быть изменены.

* ** НЕ ДОСТУПЕН** - означает, что этот значок не доступен для пользователей и не может быть получен или выдан вручную. Если этот значок никогда не был выдан, то его критерии могут быть изменены.

* ** ЗАБЛОКИРОВАН **- после того, как значок был выдан хотя бы одному пользователю, он автоматически блокируется. Заблокированные значки могут быть получены пользователями, но их критерии не могут быть изменены. Если нужно изменить детали или критерии заблокированного значка, то Вы можете продублировать этот значок и сделать все необходимые изменения.

* Зачем блокируются значки? *

Мы должны быть уверены, что все пользователи выполняют одинаковые условия при получении значка. В настоящее время отсутствует механизм отзыва выданных значков. Если мы позволим в любое время изменять условия получения значков, то пользователи, скорее всего, в конечном итоге получат одинаковые значки за выполнение совершенно разных требований.';
$string['statusmessage_0'] = 'В настоящее время этот значок не доступен для пользователей. Разрешите доступ, если хотите, чтобы пользователи могли получить этот значок.';
$string['statusmessage_1'] = 'В настоящее время этот значок доступен для пользователей. Запретите доступ, чтобы сделать какие-то изменения.';
$string['statusmessage_2'] = 'В настоящее время этот значок не доступен для пользователей и его критерии заблокированы. Разрешите доступ, если хотите, чтобы пользователи могли получить этот значок.';
$string['statusmessage_3'] = 'В настоящее время этот значок доступен для пользователей и его критерии заблокированы.';
$string['statusmessage_4'] = 'Этот значок в настоящее время архивный.';
$string['subject'] = 'Тема письма';
$string['tagarea_badge'] = 'Значки';
$string['tags'] = 'Теги';
$string['targetcode'] = 'Код';
$string['targetcode_help'] = 'Уникальный строковый идентификатор для ссылки на внешний навык или стандарт в его рамках.';
$string['targetdescription'] = 'Описание';
$string['targetdescription_help'] = 'Краткое описание внешнего навыка или стандарта.';
$string['targetframework'] = 'Структура';
$string['targetframework_help'] = 'Название внешнего навыка или стандарта структуры.';
$string['targetname'] = 'Название';
$string['targetname_help'] = 'Внешний навык или стандарт, которым соответствует значок.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Ссылка на страницу с описанием компетенции, навыка или стандарта. URL должен иметь префикс http:// или https://.';
$string['testbackpack'] = 'Проверка коллекции наград «{$a}»';
$string['testsettings'] = 'Настройки тестирования';
$string['type'] = 'Тип';
$string['userbadges'] = 'Значки пользователей';
$string['variablesubstitution'] = 'Замена переменных в сообщениях.';
$string['variablesubstitution_help'] = 'В тему и/или тело сообщения о значке могут быть вставлены определенные переменные.  Они будут заменены реальными значениями при отсылке сообщения. Переменные должны быть вставлены в текст точно так, как показано ниже. Могут быть использованы следующие переменные:

%badgename%
: Будет заменено на полное название значка.

%username%
: Это будет заменено на полное имя получателя значка.

%badgelink%
: Будет заменено на общедоступный URL-адрес с информацией о выданном значке.';
$string['verifyemail'] = 'Подтвердите адрес электронной почты';
$string['version'] = 'Версия';
$string['version_help'] = 'Поле версии может использоваться для отслеживания развития значка. Указанная версия отображается на странице значка.';
$string['viewbadge'] = 'Посмотреть выданные значки';
$string['visible'] = 'Видимый';
$string['warnexpired'] = '(Срок действия этого значка истек!)';
$string['year'] = 'Год(ы)';
