<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'el', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Δεν επιτρέπεται η πρόσβαση';
$string['accountlocked'] = 'Ο λογαριασμός σας είναι κλειδωμένος. Ένας σύνδεσμος ξεκλειδώματος έχει σταλεί μέσω email.';
$string['accounts'] = 'Λογαριασμοί χρηστών';
$string['accountunlocked'] = 'Ο λογαριασμός σας έχει ξεκλειδωθεί. Μπορείτε να συνδεθείτε.';
$string['addcategory'] = 'Προσθήκη κατηγορίας';
$string['additionalhtml'] = 'Επιπρόσθετος (κώδικας) HTML';
$string['additionalhtml_desc'] = 'Αυτές οι ρυθμίσεις σας επιτρέπουν να καθορίσετε την HTML που θέλετε να προσθέσετε σε κάθε σελίδα. Μπορείτε να ορίσετε HTML που θα προστεθεί στην ετικέτα HEAD για τη σελίδα, αμέσως μετά το άνοιγμα της ετικέτας BODY ή αμέσως πριν κλείσει η ετικέτα BODY.<br /> Αυτό σας επιτρέπει να προσθέσετε προσαρμοσμένες κεφαλίδες ή υποσέλιδα σε κάθε σελίδα ή να προσθέστε υποστήριξη για υπηρεσίες όπως το Google Analytics πολύ εύκολα, ανεξάρτητα από το αισθητικό θέμα που επιλέξατε.';
$string['additionalhtml_heading'] = 'Επιπρόσθετος (κώδικας) HTML που θα προστεθεί σε κάθε σελίδα.';
$string['additionalhtmlfooter'] = 'Πριν το κλείσιμο της ετικέτας BODY';
$string['additionalhtmlfooter_desc'] = 'Το περιεχόμενο εδώ θα προστεθεί σε κάθε σελίδα ακριβώς πριν το κλείσιμο της ετικέτας body.';
$string['additionalhtmlhead'] = 'Μέσα στην ετικέτα HEAD';
$string['additionalhtmlhead_desc'] = 'Το περιεχόμενο εδώ θα προστεθεί στο κάτω μέρος της ετικέτας HEAD σε όλες τις σελίδες.';
$string['additionalhtmltopofbody'] = 'Μετά το άνοιγμα της ετικέτας BODY';
$string['additionalhtmltopofbody_desc'] = 'Το περιεχόμενο εδώ θα προστεθεί σε κάθε σελίδα αμέσως μετά την (html) ετικέτα body.';
$string['admincategory'] = 'Κατηγορία: {$a}';
$string['adminseesall'] = 'Οι διαχειριστές τα βλέπουν όλα';
$string['adminseesallevents'] = 'Οι διαχειριστές βλέπουν όλα τα γεγονότα';
$string['adminseesownevents'] = 'Οι διαχειριστές έχουν τα ίδια δικαιώματα με τους άλλους χρήστες';
$string['advancedfeatures'] = 'Προχωρημένα χαρακτηριστικά';
$string['agedigitalconsentverification'] = 'Επαλήθευση ηλικίας ψηφιακής συγκατάθεσης';
$string['agedigitalconsentverification_desc'] = 'Επιτρέπει την επαλήθευση της ηλικίας ψηφιακής συγκατάθεσης πριν εμφανιστεί η σελίδα εγγραφής για αυτο-καταχώρηση χρηστών. Αυτό προστατεύει τον ιστότοπό σας από την εγγραφή ανήλικων χωρίς τη συγκατάθεση των γονέων/κηδεμόνων. <a target="_blank" href="{$a}">Τα στοιχεία επικοινωνίας της υποστήριξης</a> παρέχονται στους ανήλικους για περαιτέρω βοήθεια.';
$string['ageofdigitalconsentmap'] = 'Ηλικία ψηφιακής συγκατάθεσης';
$string['ageofdigitalconsentmap_desc'] = 'Η προεπιλεγμένη ηλικία ψηφιακής συγκατάθεσης, και η ηλικία ψηφιακής συγκατάθεσης σε όποια χώρα διαφέρει από την προεπιλεγμένη, μπορούν να καθοριστούν εδώ. Εισάγετε κάθε ηλικία σε νέα γραμμή με μορφότυπο (γραμμογράφηση): κωδικός χώρας, ηλικία (με διαχωριστικό ένα κόμμα). Η προεπιλεγμένη ηλικία επισημαίνεται με * στη θέση του κωδικού χώρας. Οι κωδικοί χώρας ακολουθούν το πρότυπο ISO 3166-2. (Στην Ε.Ε. ο κανονισμός 2016/679 ορίζει τα 16 ως προεπιλεγμένη και στην Ελλάδα το 2018 ανακοινώθηκε η ηλικία των 15)';
$string['allcountrycodes'] = 'Όλοι οι κωδικοί χωρών';
$string['allowattachments'] = 'Να επιτρέπονται συνημμένα';
$string['allowbeforeblock'] = 'Επεξεργασία επιτρεπόμενης λίστας πρώτα';
$string['allowbeforeblockdesc'] = 'Από προεπιλογή, οι καταχωρήσεις στη λίστα αποκλεισμένων διευθύνσεων IP αντιστοιχίζονται πρώτα. Αν αυτή η επιλογή είναι ενεργοποιημένη, οι καταχωρήσεις στη λίστα επιτρεπόμενων διευθύνσεων IP επεξεργάζονται πριν από τη λίστα των αποκλεισμένων.';
$string['allowcategorythemes'] = 'Να επιτρέπονται αισθητικά θέματα κατηγορίας';
$string['allowcohortthemes'] = 'Επιτρέπονται αισθητικά θέματα συνόλων χρηστών';
$string['allowcoursethemes'] = 'Να επιτρέπονται αισθητικά θέματα μαθήματος';
$string['allowedemaildomains'] = 'Επιτρεπόμενοι τομείς διευθύνσεων ηλε.ταχυδρομείου';
$string['allowediplist'] = 'Λίστα επιτρεπόμενων διευθύνσεων IP';
$string['allowemailaddresses'] = 'Επιτρεπόμενοι τομείς διευθύνσεων ηλε.ταχυδρομείου';
$string['allowemojipicker'] = 'Επιλογέας εμότζι';
$string['allowframembedding'] = 'Να επιτρέπεται ενσωμάτωση πλαισίου';
$string['allowframembedding_help'] = 'Εάν ενεργοποιηθεί, αυτός ο ιστότοπος μπορεί να ενσωματωθεί σε ένα πλαίσιο σε ένα απομακρυσμένο σύστημα, όπως συνιστάται όταν χρησιμοποιείται το πρόσθετο εγγραφών «Δημοσίευση ως εργαλείο LTI». Διαφορετικά, συνιστάται να αφήσετε την ενσωμάτωση πλαισίου απενεργοποιημένη για λόγους ασφαλείας. Παρακαλούμε, σημειώστε επίσης, ότι για την εφαρμογή κινητού, αυτή η ρύθμιση αγνοείται και η ενσωμάτωση πλαισίου επιτρέπεται πάντοτε.';
$string['allowguestmymoodle'] = 'Να επιτρέπεται η πρόσβαση στους επισκέπτες στο Ταμπλό';
$string['allowindexing'] = 'Επιτρέπεται ευρετηρίαση από μηχανές αναζήτησης';
$string['allowindexing_desc'] = 'Αυτό καθορίζει αν θα επιτρέπεται στις μηχανές αναζήτησης να προβάλλουν τον ιστότοπό σας. Το «Παντού» θα επιτρέπει στις μηχανές αναζήτησης να ψάξουν παντού, συμπεριλαμβανομένων των σελίδων σύνδεσης και εγγραφής, πράγμα που σημαίνει ότι οι τοποθεσίες με ενεργοποιημένη την υποχρέωση σύνδεσης εξακολουθούν να ευρετηριάζονται. Για να αποφύγετε τον κίνδυνο ανεπιθύμητης αλληλογραφίας λόγω έκθεσης των σελίδων σύνδεσης και εγγραφής, χρησιμοποιήστε το «Παντού εκτός από τις σελίδες σύνδεσης και εγγραφής». Το «Πουθενά» θα πει στις μηχανές αναζήτησης να μην ευρετηριάσουν καμία σελίδα. Σημειώστε ότι αυτό είναι απλά μια ετικέτα στην κεφαλίδα του ιστοτόπου. Εναπόκειται στη μηχανή αναζήτησης να σεβαστεί την ετικέτα.';
$string['allowindexingeverywhere'] = 'Παντού';
$string['allowindexingexceptlogin'] = 'Παντού εκτός από τις σελίδες σύνδεσης και εγγραφής';
$string['allowindexingnowhere'] = 'Πουθενά';
$string['allowobjectembed'] = 'Να επιτρέπονται οι ετικέτες EMBED και OBJECT';
$string['allowthemechangeonurl'] = 'Να επιτρέπεται αλλαγή θεμάτων στη διεύθυνση URL';
$string['allowuserblockhiding'] = 'Να επιτρέπεται στους χρήστες η σύμπτυξη μπλοκ';
$string['allowusermailcharset'] = 'Να επιτρέπεται οι χρήστες να επιλέγουν σετ χαρακτήρων';
$string['allowuserswitchrolestheycantassign'] = 'Να επιτρέπεται χρήστες χωρίς τη δυνατότητα ανάθεσης ρόλων να αλλάζουν ρόλους';
$string['allowuserthemes'] = 'Να επιτρέπονται αισθητικά θέματα χρηστών';
$string['alternativefullnameformat'] = 'Εναλλακτικός μορφότυπος πλήρους ονόματος';
$string['alternativefullnameformat_desc'] = 'Εδώ ορίζεται πως θα εμφανίζονται τα ονόματα στους χρήστες με τη δυνατότητα viewfullnames (από προεπιλογή, οι χρήστες με ρόλο διευθυντή, διδάσκοντα ή διδάσκοντα χωρίς δικαιώματα επεξεργασίας). Τα δεσμευτικά θέσης που μπορούν να χρησιμοποιηθούν είναι όπως όταν ρυθμίζεται ο «Μορφότυπος πλήρους ονόματος».';
$string['always'] = 'Πάντα';
$string['appearance'] = 'Εμφάνιση';
$string['aspellpath'] = 'Μονοπάτι για το aspell';
$string['authentication'] = 'Αυθεντικοποίηση';
$string['authpreventaccountcreation'] = 'Παρεμπόδιση δημιουργίας λογαριασμού κατά την αυθεντικοποίηση';
$string['authpreventaccountcreation_help'] = 'Όταν ένας χρήστης αυθεντικοποιείται, δημιουργείται αυτόματα ένας λογαριασμός στον ιστότοπο, αν δεν υπάρχει ήδη. Αν χρησιμοποιείται μια εξωτερική βάση δεδομένων, όπως το LDAP, για αυθεντικοποίηση, αλλά επιθυμείτε να περιορίσετε την πρόσβαση στον ιστότοπο μόνο σε χρήστες με υπάρχοντα λογαριασμό, τότε αυτή η επιλογή θα πρέπει να ενεργοποιηθεί. Οι νέοι λογαριασμοί θα πρέπει να δημιουργηθούν με το χέρι ή μέσω του χαρακτηριστικού/λειτουργίας ανεβάσματος χρηστών. Σημειώστε ότι αυτή η ρύθμιση δεν ισχύει για την αυθεντικοποίηση MNet.';
$string['authsettings'] = 'Διαχείριση αυθεντικοποίησης';
$string['autolang'] = 'Αυτόματος εντοπισμός γλώσσας';
$string['autolangusercreation'] = 'Κατά τη δημιουργία λογαριασμού, να ορίζεται η γλώσσα του περιηγητή του χρήστη ως η προτιμώμενη γλώσσα του';
$string['autologinguests'] = 'Αυτόματη σύνδεση επισκεπτών';
$string['availableto'] = 'Διαθέσιμο σε';
$string['availabletoanyone'] = 'Διαθέσιμο σε οποιονδήποτε επισκέπτεται τον ιστότοπο';
$string['backgroundcolour'] = 'Διαφανές χρώμα';
$string['backup_shortname'] = 'Χρήση του ονόματος μαθήματος στο όνομα αρχείου του αντιγράφου ασφαλείας';
$string['backup_shortnamehelp'] = 'Χρησιμοποιήστε το όνομα του μαθήματος ως μέρος του ονόματος του αρχείου του αντιγράφου ασφαλείας.';
$string['backups'] = 'Αντίγραφα ασφαλείας';
$string['badwordsconfig'] = 'Εισαγάγετε τις μη επιτρεπτές λέξεις (χωρισμένες με κόμμα).';
$string['badwordsdefault'] = 'Αν η προσαρμοσμένη λίστα είναι κενή, θα χρησιμοποιηθεί μια προεπιλεγμένη λίστα από το πακέτο γλώσσας.';
$string['badwordslist'] = 'Προσαρμοσμένη λίστα μη επιτρεπτών λέξεων';
$string['blockediplist'] = 'Λίστα απαγορευμένων διευθύνσεων IP';
$string['blockinstances'] = 'Στιγμιότυπα';
$string['blockmultiple'] = 'Πολλαπλά';
$string['blockprotect'] = 'Προστατέψτε περιπτώσεις';
$string['blockprotect_help'] = 'Αν κλειδώσετε ένα συγκεκριμένο τύπο μπλοκ, τότε κανείς δεν θα μπορεί να προσθέσει ή να διαγράψει στιγμιότυπα. (Μπορείτε, βεβαίως, να το ξεκλειδώσετε ξανά αν χρειάζεται να τροποποιήσετε στιγμιότυπα.) <br /> Σκοπός είναι να προστατεύονται τα μπλοκ όπως η πλοήγηση και οι ρυθμίσεις που είναι πολύ δύσκολο να ανακτηθούν αν διαγραφούν κατά λάθος.';
$string['blocksettings'] = 'Διαχείριση μπλοκ';
$string['bloglevel'] = 'Ορατότητα ιστολογίου';
$string['bookmarkadded'] = 'Ο σελιδοδείκτης προστέθηκε.';
$string['bookmarkalreadyexists'] = 'Έχετε ήδη σελιδοδείκτη για αυτή τη σελίδα.';
$string['bookmarkdeleted'] = 'Ο σελιδοδείκτης διαγράφηκε.';
$string['bookmarkthispage'] = 'Προσθήκη σελιδοδείκτη για αυτή τη σελίδα';
$string['cacheapplication'] = 'Κρυφή μνήμη εφαρμογής';
$string['cacheapplicationhelp'] = 'Τα στοιχεία της κρυφής μνήμης είναι κοινόχρηστα μεταξύ όλων των χρηστών και λήγουν μετά από ένα καθορισμένο χρόνο ζωής (TTL).';
$string['cachejs'] = 'Χρήση κρυφής μνήμης για Javascript';
$string['cachejs_help'] = 'Η αποθήκευση σε κρυφή μνήμη και η συμπίεση της Javascript βελτιώνει σημαντικά την ταχύτητα φόρτωσης σελίδας. Συνιστάται ένθερμα στους ιστοτόπους παραγωγής. Οι προγραμματιστές πιθανώς θα θέλουν να απενεργοποιήσουν αυτό το χαρακτηριστικό.';
$string['cacherequest'] = 'Κρυφή μνήμη αιτήματος';
$string['cacherequesthelp'] = 'Κρυφή μνήμη χρήστη που λήγει όταν ολοκληρωθεί η αίτηση. Σχεδιασμένη να αντικαθιστά περιοχές όπου χρησιμοποιούμε τις στατικές αποθηκεύσεις.';
$string['cachesession'] = 'Κρυφή μνήμη συνόδου';
$string['cachesessionhelp'] = 'Ιδιαίτερη κρυφή μνήμη χρήστη που λήγει όταν λήξει η σύνοδος του χρήστη. Σχεδιασμένη για να ελαττώσει τον όγκο/ρυθμό δεδομένων κατά τη σύνοδο.';
$string['cachesettings'] = 'Ρυθμίσεις κρυφής μνήμης';
$string['cachetemplates'] = 'Υποδείγματα σε κρυφή μνήμη';
$string['cachetemplates_help'] = 'Η αποθήκευση υποδειγμάτων σε κρυφή μνήμη θα βελτιώσει την απόδοση φόρτωσης σελίδας και συνιστάται ένθερμα, για ιστοτόπους παραγωγής. Οι προγραμματιστές πιθανώς θα θέλουν να απενεργοποιήσουν αυτό το χαρακτηριστικό.';
$string['caching'] = 'Κρυφή μνήμη';
$string['calendar_weekend'] = 'Ημέρες Σαββατοκύριακου';
$string['calendarexportsalt'] = '«Αλάτι» εξαγωγής ημερολογίου';
$string['calendarsettings'] = 'Ημερολόγιο';
$string['calendartype'] = 'Τύπος Ημερολογίου';
$string['calendartype_desc'] = 'Διαλέξτε έναν προεπιλεγμένο τύπο ημερολογίου για ολόκληρο τον ιστότοπο. Αυτή η ρύθμιση μπορεί να παρακαμφθεί από τις ρυθμίσεις μαθήματος ή από τους χρήστες μέσω του προσωπικού τους προφίλ.';
$string['cannotdeletemodfilter'] = 'Δεν είναι δυνατή η απεγκατάσταση του «{$a->filter}» επειδή είναι κομμάτι του αρθρώματος «{$a->module}».';
$string['cannotuninstall'] = 'Το {$a} δεν μπορεί να απεγκατασταθεί.';
$string['categoryemail'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['cfgwwwrootslashwarning'] = 'Το $CFG->wwwroot είναι μη σωστά ορισμένο στο αρχείο config.php. Περιλαμβάνει έναν χαρακτήρα «/» στο τέλος, το οποίο πρέπει να αφαιρεθεί.';
$string['cfgwwwrootwarning'] = 'Το $CFG->wwwroot είναι μη σωστά ορισμένο στο αρχείο config.php. Θα έπρεπε να ταιριάζει με τη διεύθυνση URL που χρησιμοποιείτε για να προσπελάσετε αυτήν εδώ τη σελίδα.';
$string['change'] = 'αλλαγή';
$string['checkboxno'] = 'Όχι';
$string['checkboxyes'] = 'Ναι';
$string['checkupgradepending'] = 'Αναβάθμιση';
$string['choosefiletoedit'] = 'Επιλέξτε αρχείο για επεξεργασία';
$string['cleanup'] = 'Εκκαθάριση';
$string['clianswerno'] = 'ο';
$string['cliansweryes'] = 'ν';
$string['cliexitgraceful'] = 'Έξοδος ομαλά, παρακαλούμε περιμένετε...';
$string['cliexitnow'] = 'Έξοδος αμέσως ΤΩΡΑ';
$string['cliincorrectvalueerror'] = 'Σφάλμα, λανθασμένη τιμή «{$a->value}» για το «{$a->option}»';
$string['cliincorrectvalueretry'] = 'Λανθασμένη τιμή. Παρακαλούμε προσπαθήστε ξανά.';
$string['clistatusdisabled'] = 'Κατάσταση: Απενεργοποιημένο';
$string['clistatusenabled'] = 'Κατάσταση: Ενεργοποιημένο';
$string['clistatusenabledlater'] = 'Κατάσταση: Η κατάσταση συντήρησης CLI θα ενεργοποιηθεί στις {$a}';
$string['clitypevalue'] = 'πληκτρολογήστε μια τιμή';
$string['clitypevaluedefault'] = 'πληκτρολογήστε μια τιμή· πατήστε Enter για να χρησιμοποιήσετε την προεπιλεγμένη τιμή ({$a})';
$string['cliunknowoption'] = 'Μη αναγνωρίσιμες επιλογές:
 {$a}<br />
Παρακαλούμε χρησιμοποιήστε την επιλογή --help (βοήθεια)';
$string['cliupgradedefault'] = 'Νέες ρυθμίσεις: {$a}';
$string['cliupgradedefaultheading'] = 'Ορισμός νέων προεπιλεγμένων τιμών';
$string['cliupgradedefaultverbose'] = 'Νέα ρύθμιση: {$a->name}, Προεπιλεγμένη τιμή: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Η αναβάθμιση της γραμμής εντολών από {$a->oldversion} σε {$a->newversion} ολοκληρώθηκε με επιτυχία.';
$string['cliupgradenoneed'] = 'Δεν χρειάζεται αναβάθμιση για την εγκατεστημένη έκδοση {$a}. Ευχαριστούμε που ήρθατε ούτως ή άλλως!';
$string['cliupgradepending'] = 'Εκκρεμεί μια ενημέρωση';
$string['cliyesnoprompt'] = 'πατήστε y (σημαίνει yes=ναι) ή πατήστε n (σημαίνει no=όχι)';
$string['close'] = 'Κλείσιμο';
$string['commentsperpage'] = 'Εμφανιζόμενα σχόλια ανά σελίδα';
$string['commonactivitysettings'] = 'Κοινές ρυθμίσεις';
$string['commonfiltersettings'] = 'Κοινές ρυθμίσεις φίλτρων';
$string['commonsettings'] = 'Κοινές ρυθμίσεις';
$string['componentinstalled'] = 'Το στοιχείο λογισμικού εγκαταστάθηκε';
$string['computedfromlogs'] = 'Υπολογισμός βάσει των καταγραφών από {$a}.';
$string['condifmodeditdefaults'] = 'Οι προεπιλεγμένες τιμές χρησιμοποιούνται στη φόρμα ρυθμίσεων όταν δημιουργείται μια νέα δραστηριότητα ή πηγή.';
$string['confeditorhidebuttons'] = 'Επιλέξτε τα εικονίδια που θέλετε να αποκρύψετε από τη γραμμή εργαλείων του επεξεργαστή κειμένου';
$string['configallcountrycodes'] = 'Αυτή είναι η λίστα χωρών που μπορούν να επιλεγούν σε διάφορα σημεία, για παράδειγμα στο προφίλ του χρήστη. Αν είναι κενή (η προεπιλογή) χρησιμοποιείται η λίστα του countries.php στο τυπικό πακέτο Αγγλικής γλώσσας. Αυτή είναι η λίστα από το πρότυπο ISO 3166-1. Διαφορετικά, μπορείτε να ορίσετε μια λίστα κωδικών χωρισμένων με κόμμα, για παράδειγμα «GB,FR,ES». Αν προσθέσετε νέους, μη τυποποιημένους κωδικούς εδώ, θα πρέπει να τους προσθέσετε στο countries.php στο «en» και στο πακέτο της γλώσσας σας.';
$string['configallowassign'] = 'Μπορείτε να επιτρέψετε σε άτομα που έχουν τους ρόλους στην αριστερή πλευρά να αναθέσουν ορισμένους από τους ρόλους σε άλλα άτομα';
$string['configallowattachments'] = 'Αν ενεργοποιηθεί, τα μηνύματα ηλε.ταχυδρομείου που αποστέλλονται από τον ιστότοπο μπορούν να έχουν συνημμένα, όπως π.χ. διακριτικά.';
$string['configallowcategorythemes'] = 'Εάν ενεργοποιήσετε αυτή την επιλογή τότε τα θέματα θα μπορούν να ορίζονται στο επίπεδο κατηγοριών. Αυτό θα επηρεάσει όλες τις υποκατηγορίες και μαθήματα εκτός εάν έχει οριστεί συγκεκριμένο δικό τους αισθητικό θέμα. ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Η ενεργοποίηση αισθητικών θεμάτων κατηγοριών μπορεί να επηρεάσει την απόδοση.';
$string['configallowcohortthemes'] = 'Εάν ενεργοποιηθεί, τότε τα θέματα μπορούν να οριστούν στο επίπεδο ενός συνόλου χρηστών. Αυτό θα επηρεάσει όλους τους χρήστες που ανήκουν σε ένα μόνο σύνολο ή περισσότερα από ένα αλλά με το ίδιο αισθητικό θέμα.';
$string['configallowcoursethemes'] = 'Εάν ενεργοποιηθεί, τότε θα επιτρέπεται στα μαθήματα να ορίσουν τα δικά τους αισθητικά θέματα. Τα θέματα μαθήματος παρακάμπτουν όλες τις άλλες επιλογές αισθητικού θέματος (θέματα ιστοτόπου, χρήστη, συνόλου χρηστών ή θέματα ορισμένα με βάση τη διεύθυνση URL).';
$string['configallowedemaildomains'] = 'Λίστα τομέων ηλε.ταχυδρομείου που επιτρέπεται να αποκαλύπτονται στο πεδίο «Από» των εξερχόμενων μηνυμάτων ηλε.ταχυδρομείου. Η προεπιλογή «Κενό» θα χρησιμοποιήσει τη διεύθυνση Μη-απάντησης για όλα τα εξερχόμενα μηνύματα ηλε.ταχυδρομείου. Η χρήση των μπαλαντέρ επιτρέπεται π.χ. *.paradeigma.com θα επιτρέπει την αποστολή μηνυμάτων ηλε.ταχυδρομείου από κάθε υποτομέα του paradeigma.com, αλλά όχι το ίδιο το paradeigma.com. Αυτό θα απαιτήσει χωριστή καταχώρηση.';
$string['configallowemailaddresses'] = 'Εάν θέλετε να περιορίσετε όλες τις καινούργιες διευθύνσεις ηλε.ταχυδρομείου σε συγκεκριμένους DNS τομείς (domains), εισαγάγετέ τους εδώ χωρισμένους με κενά. Όλοι οι άλλοι τομείς θα απορρίπτονται. Για να επιτρέπονται υποτομείς, βάλτε μια τελεία «.» στην αρχή του τομέα. Για να επιτρέπεται η ρίζα του τομέα καθώς και οι υποτομείς, προσθέστε τον τομέα δύο φορές - μία με την τελεία στην αρχή και μία χωρίς π.χ. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Ο επιλογέας εμότζι (emoji) επιτρέπει στους χρήστες να επιλέγουν εμότζι, όπως φατσούλες, για να τα προσθέτουν σε μηνύματα και άλλες περιοχές κειμένου μέσω ενός πλήκτρου επιλογέα εμότζι στην γραμμή εργαλείων Atto.';
$string['configallowemojipickerincompatible'] = 'Οι τρέχουσες ρυθμίσεις της βάσης δεδομένων σας δεν υποστηρίζουν εμότζι σωστά. Για να ενεργοποιηθεί ο επιλογέας εμότζι, θα χρειαστεί <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">αναβάθμιση της βάσης δεδομένων σας για πλήρη υποστήριξη Unicode</a>.';
$string['configallowguestmymoodle'] = 'Εάν ενεργοποιηθεί, οι επισκέπτες μπορούν να έχουν πρόσβαση στο Ταμπλό, αλλιώς οι επισκέπτες θα μεταφέρονται στην πρώτη σελίδα του ιστοτόπου.';
$string['configallowobjectembed'] = 'Ως προεπιλεγμένο μέτρο ασφαλείας, δεν επιτρέπεται στους κανονικούς χρήστες να ενσωματώσουν πολυμεσικά στοιχεία (όπως flash) μέσα στο κείμενο, χρησιμοποιώντας τις ετικέτες EMBED και OBJECT στην HMTL τους (αν και αυτό μπορεί να γίνει με ασφάλεια χρησιμοποιώντας το φίλτρο των mediaplugins). Αν θέλετε να επιτρέψετε αυτές τις ετικέτες ενεργοποιήστε αυτή την επιλογή.';
$string['configallowoverride'] = 'Να επιτρέπεται σε χρήστες με ρόλο στην αριστερή στήλη παρακάμπτουν ρόλους σε κάθε στήλη';
$string['configallowoverride2'] = 'Επιλέξτε ποιοι ρόλοι μπορούν να παρακαμφθούν από κάθε ρόλο στην αριστερή στήλη.<br />Έχετε υπόψιν πως οι ρυθμίσεις αυτές ισχύουν μόνο για χρήστες που είτε έχουν τη δυνατότητα moodle/role:override ή τη δυνατότητα moodle/role:safeoverride ενεργοποιημένη.';
$string['configallowswitch'] = 'Επιλέξτε τους ρόλους στους οποίους μπορεί να μεταβεί ο χρήστης, βάσει των ρόλων που ήδη έχει. Επιπρόσθετα με την καταχώρηση σε αυτόν τον πίνακα, ο χρήστης πρέπει επίσης να έχει τη δυνατότητα moodle/role:switchroles ώστε να μπορεί να μεταβεί σε άλλο ρόλο.<br />Σημειώστε πως η μετάβαση είναι δυνατή μόνο για ρόλους που έχουν τη δυνατότητα moodle/course:view ενεργοποιημένη ενώ δεν έχουν τη δυνατότητα moodle/site:doanything, συνεπώς κάποιες στήλες σε αυτόν τον πίνακα είναι απενεργοποιημένες.';
$string['configallowthemechangeonurl'] = 'Εάν ενεργοποιηθεί, το αισθητικό θέμα μπορεί να αλλάξει προσθέτοντας απλώς:<br />?theme=themename σε οποιαδήποτε Moodle διεύθυνση URL (π.χ.: mymoodlesite.com/?theme=afterburner) ή <br />&theme=themename σε οποιαδήποτε εσωτερική Moodle διεύθυνση URL (π.χ.: mymoodlesite.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Θέλετε να επιτρέπεται στους χρήστες η σύμπτυξη/ανάπτυξη πλευρικών μπλοκ σε ολόκληρο τον ιστότοπο; Αυτό το χαρακτηριστικό χρησιμοποιεί Javascript και cookies για την αποθήκευση της κατάστασης πριν την σύμπτυξη κάθε μπλοκ, και επηρεάζει μόνο την προσωπική οθόνη του χρήστη.';
$string['configallowusermailcharset'] = 'Εάν ενεργοποιηθεί, οι χρήστες μπορούν να επιλέξουν ένα σετ χαρακτήρων μηνυμάτων ηλε.ταχυδρομείου στις προτιμήσεις ανταλλαγής μηνυμάτων.';
$string['configallowuserswitchrolestheycantassign'] = 'Από προεπιλογή, ο ρόλος moodle/role:assign απαιτείται από τους χρήστες ώστε να αλλάζουν ρόλους. Η ενεργοποίηση αυτής της ρύθμισης αναιρεί αυτή τη συνθήκη και τα αποτελέσματα στους διαθέσιμους ρόλους στο μενού «Αλλαγή ρόλου σε» καθορίζονται από τις ρυθμίσεις στο μενού του πίνακα «Να επιτρέπονται εργασίες ρόλων» και μόνο. Συνιστάται οι ρυθμίσεις στον πίνακα «Να επιτρέπονται εργασίες ρόλων» να μην επιτρέπουν στους χρήστες να μεταβούν σε ένα ρόλο με περισσότερες δυνατότητες από ότι ο ρόλος που ήδη έχουν.';
$string['configallowuserthemes'] = 'Να έχει τη δυνατότητα ο κάθε χρήστης να ορίζει το δικό του αισθητικό θέμα. Το θέμα κάθε χρήστη υπερισχύει του αισθητικού θέματος του συστήματος, αλλά όχι του μαθήματος.';
$string['configallowview'] = 'Επιλέξτε τους ρόλους που θα βλέπει ο χρήστης, θα είναι σε θέση να φιλτράρει κλπ. με βάση τους ρόλους που έχει ήδη.';
$string['configallusersaresitestudents'] = 'Για δραστηριότητες στην πρώτη σελίδα του ιστοτόπου, θα πρέπει ΟΛΟΙ οι χρήστες να θεωρηθούν μαθητές; Αν απαντήσετε «Ναι», τότε οποιοσδήποτε επιβεβαιωμένος λογαριασμός χρήστη θα επιτρέπεται να συμμετέχει ως μαθητής σε αυτές τις δραστηριότητες. Εάν απαντήσετε «Όχι», τότε μόνο οι χρήστες που συμμετέχουν ήδη σε τουλάχιστον ένα μάθημα θα μπορούν να λάβουν μέρος σε αυτές τις δραστηριότητες αρχικής σελίδας. Μόνο οι διαχειριστές και οι ειδικά ορισμένοι διδάσκοντες μπορούν να ενεργούν ως διδάσκοντες για αυτές τις δραστηριότητες αρχικής σελίδας.';
$string['configauthenticationplugins'] = 'Παρακαλούμε επιλέξτε τα πρόσθετα αυθεντικοποίησης που επιθυμείτε να χρησιμοποιήσετε και ταξινομήστε τα κατά σειρά αποτυχίας.';
$string['configautolang'] = 'Εντοπισμός προεπιλεγμένης γλώσσας από τις ρυθμίσεις του περιηγητή. Αν απενεργοποιηθεί, χρησιμοποιείται η προεπιλεγμένη γλώσσα του ιστοτόπου.';
$string['configautolangusercreation'] = 'Εάν ενεργοποιηθεί, όταν ο λογαριασμός ενός χρήστη δημιουργείται αυτόματα, κατά την πρώτη σύνδεση (π.χ. χρησιμοποιώντας αυθεντικοποίηση LDAP ή OAuth 2), η γλώσσα του περιηγητή του χρήστη ορίζεται ως η προτιμώμενη γλώσσα του. Διαφορετικά, ορίζεται ως η προτιμώμενη γλώσσα του χρήστη, η προεπιλεγμένη γλώσσα για τον ιστότοπο.';
$string['configautologinguests'] = 'Οι επισκέπτες να εισάγονται σαν καλεσμένοι όταν εισέρχονται σε μαθήματα με πρόσβαση επισκεπτών;';
$string['configbloglevel'] = 'Η ρύθμιση αυτή σας επιτρέπει να περιορίσετε το επίπεδο εμφάνισης των ιστολογίων χρήστη στον ιστότοπο. Ας σημειωθεί πως ορίζεται το μέγιστο πλαίσιο του ΘΕΑΤΗ και όχι του συγγραφέα ή του είδους της ανάρτησης ιστολογίου. Μπορείτε να απενεργοποιήσετε τα ιστολόγια και εντελώς, αν θέλετε.';
$string['configcalendarcustomexport'] = 'Ενεργοποίηση προσαρμογής του εύρους ημερομηνίας για την εξαγωγή του ημερολογίου';
$string['configcalendarexportsalt'] = 'Το τυχαίο αυτό κείμενο (salt) χρησιμοποιείται για τη βελτίωση της ασφάλειας των κουπονιών αυθεντικοποίησης τα οποία χρησιμοποιούνται για την εξαγωγή ημερολογίων. Παρακαλούμε σημειώστε πως όλα τα τρέχοντα κουπόνια γίνονται μη έγκυρα εάν αλλάξετε αυτό το hash salt (εμπλουτισμός κατατεμαχισμού με μη-μυστική, τυχαία τιμή).';
$string['configcookiesecure'] = 'Εάν ο εξυπηρετητής δέχεται μόνον ασφαλείς συνδέσεις (https), συνιστάται η ενεργοποίηση αποστολής ασφαλών cookies. Σε περίπτωση ενεργοποίησης παρακαλούμε βεβαιωθείτε πως ο εξυπηρετητής δεν δέχεται αιτήματα http:// ή σε μόνιμη ανακατεύθυνση αιτημάτων σε https:// διεύθυνση. Όταν η διεύθυνση <em>wwwroot</em> δεν ξεκινάει με https:// η ρύθμιση αυτή απενεργοποιείται αυτόματα.';
$string['configcountry'] = 'Αν ορίσετε μια χώρα εδώ, τότε αυτή θα είναι η προεπιλεγμένη για όλους τους νέους λογαριασμούς χρηστών. Για να υποχρεώσετε τους χρήστες να επιλέξουν χώρα, αφήστε το κενό.';
$string['configcoursegraceperiodafter'] = 'Ταξινόμηση περασμένων μαθημάτων ως σε εξέλιξη για τόσες ημέρες μετά την λήξη του μαθήματος.';
$string['configcoursegraceperiodbefore'] = 'Ταξινόμηση μελλοντικών μαθημάτων ως σε εξέλιξη για τόσες ημέρες πριν την ημερομηνία έναρξης του μαθήματος.';
$string['configcourseoverviewfilesext'] = 'Μια λίστα διαχωρισμένων με κόμμα επιτρεπόμενων επεκτάσεων, αρχείων εικόνας μαθήματος.';
$string['configcourseoverviewfileslimit'] = 'Ο μέγιστος αριθμός αρχείων που μπορούν να εμφανιστούν δίπλα στην περίληψη του μαθήματος στη λίστα με τα μαθήματα. Το πρώτο αρχείο εικόνας που προστίθεται χρησιμοποιείται ως εικόνα μαθήματος στην επισκόπηση μαθημάτων στο Ταμπλό του κάθε χρήστη. Οποιαδήποτε επιπρόσθετα αρχεία εμφανίζονται μόνο στη σελίδα της λίστας μαθημάτων.';
$string['configcourserequestnotify'] = 'Εισάγετε το «όνομα χρήστη» του χρήστη που θέλετε να ενημερώνεται όταν γίνεται αίτηση δημιουργίας νέου μαθήματος.';
$string['configcourserequestnotify2'] = 'Χρήστες που θα ενημερώνονται όταν γίνεται αίτηση δημιουργίας νέου μαθήματος. Μόνο χρήστες με δικαίωμα έγκρισης αιτήσεων δημιουργίας μαθήματος περιέχονται σε αυτήν εδώ τη λίστα.';
$string['configcoursesperpage'] = 'Εισάγετε τον αριθμό μαθημάτων που θα εμφανίζονται ανά σελίδα στη λίστα μαθημάτων.';
$string['configcourseswithsummarieslimit'] = 'Ο μέγιστος αριθμός μαθημάτων που θα εμφανιστούν σε μια λίστα μαθημάτων, συμπεριλαμβανομένων των περιλήψεων, πριν να επιστρέψετε σε μια απλούστερη λίστα.';
$string['configcronclionly'] = 'Η εκτέλεση της εντολής χρονοπρογραμματισμού cron από περιηγητή μπορεί να εκθέσει ευαίσθητη πληροφορία σε ανώνυμους χρήστες. Έτσι, συνιστάται η εκτέλεση της cron μόνο μέσω γραμμής εντολών ή μέσω κωδικού πρόσβασης της cron για απομακρυσμένη πρόσβαση.';
$string['configcronremotepassword'] = 'Αυτό σημαίνει πως το cron.php δεν μπορεί να εκτελεστεί από έναν περιηγητή ιστού χωρίς την παροχή του κωδικού πρόσβασης χρησιμοποιώντας την παρακάτω μορφή διεύθυνσης URL:<pre> http://istotopos.tomeas.com/admin/cron.php?password=opensesame </pre>Εάν αυτός μείνει κενός, τότε δεν απαιτείται κωδικός πρόσβασης.';
$string['configcurlcache'] = 'Χρόνος ζωής για τη κρυφή μνήμη cURL, σε δευτερόλεπτα.';
$string['configcustommenuitems'] = 'Εδώ μπορεί να ρυθμιστεί ένα προσαρμοσμένο μενού. Πληκτρολογήστε κάθε στοιχείο μενού σε μια ξεχωριστή γραμμή με μορφότυπο: κείμενο μενού, μια διεύθυνση URL συνδέσμου (προαιρετικό, όχι για ανώτερα στοιχεία μενού με υπο-στοιχεία), έναν τίτλο αναδυόμενης συμβουλής εργαλείου (προαιρετικό) και έναν κωδικό γλώσσας ή λίστα με κωδικούς χωρισμένους με κόμματα (προαιρετικά, για την εμφάνιση της γραμμής σε χρήστες της συγκεκριμένης γλώσσας μόνο), χωρισμένα με καθέτους. Οι γραμμές που ξεκινούν με παύλα θα εμφανίζονται ως στοιχεία μενού στο προηγούμενο μενού ανώτατου επιπέδου και το ### δημιουργεί μια διαχωριστική γραμμή. Για παράδειγμα:
<pre>
Courses
-Όλα τα μαθήματα|/course/
-Αναζήτηση μαθήματος|/course/search.php
-###
-Συχνές ερωτήσεις|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Εφαρμογή κινητού|https://someurl.xyz/app|Λήψη της εφαρμογής μας κινητού
</pre>';
$string['configcustomusermenuitems'] = 'Μπορείτε να διαμορφώσετε τα περιεχόμενα του μενού χρήστη (με εξαίρεση τον σύνδεσμο αποσύνδεσης, ο οποίος προστίθεται αυτόματα). Κάθε γραμμή χωρίζεται με χαρακτήρες κάθετης γραμμής και αποτελείται από 1) ένα αλφαριθμητικό με τη μορφή «langstringname, componentname» (όνομα συμβολοσειράς γλώσσας, όνομα στοιχείου) ή ως απλό κείμενο, 2) μια διεύθυνση URL και 3) ένα εικονίδιο είτε ως εικονίδιο pix (στο φάκελο pix με δομή [υποφάκελος]/[όνομαεικονιδίου], π.χ. i/publish) ή ως διεύθυνση URL. Μπορούν να προστεθούν διαχωριστικές γραμμές προσθέτοντας μια γραμμή ενός ή περισσότερων χαρακτήρων # όπου επιθυμείτε.';
$string['configdbsessions'] = 'Αν ενεργοποιηθεί, αυτή η ρύθμιση θα χρησιμοποιήσει την βάση δεδομένων για να αποθηκεύει πληροφορίες για τις τρέχουσες συνόδους. Σημειώστε πως αλλαγή αυτής της ρύθμισης τώρα θα αποσυνδέσει όλους τους τρέχοντες χρήστες (και εσάς). Αν χρησιμοποιείτε MySQL παρακαλούμε βεβαιωθείτε πως η ρύθμιση «max_allowed_packet» στο αρχείο my.cnf (ή στο my.ini) είναι ορισμένη σε 4M τουλάχιστον. Άλλοι οδηγοί συνόδου μπορούν να ρυθμιστούν κατευθείαν στο config.php (δείτε το config-dist.php για περισσότερες πληροφορίες). Αυτή η ρύθμιση εξαφανίζεται αν καθορίσετε οδηγό συνόδου στο αρχείο config.php.';
$string['configdebug'] = 'Εάν ενεργοποιηθεί, το error_reporting της PHP θα αυξηθεί ώστε να εμφανίζονται περισσότερες προειδοποιήσεις. Χρήσιμο μόνο για προγραμματιστές.';
$string['configdebugdisplay'] = 'Εάν ενεργοποιηθεί, η αναφορά σφαλμάτων θα πηγαίνει στη σελίδα HTML. Αυτό είναι μεν πρακτικό αλλά χαλάει τον κώδικα XHTML, JS, cookies και τις επικεφαλίδες HTTP γενικότερα. Εάν απενεργοποιηθεί, η έξοδος της αναφοράς σφαλμάτων θα καταχωρείται στις καταγραφές του εξυπηρετητή, επιτρέποντας καλύτερη αποσφαλμάτωση. Η ρύθμιση της PHP error_log ορίζει που θα είναι αυτές οι καταγραφές.';
$string['configdebugpageinfo'] = 'Ενεργοποιήστε εάν θέλετε να φαίνονται οι πληροφορίες της σελίδας στο υποσέλιδο.';
$string['configdebugvalidators'] = 'Ενεργοποιήστε αν θέλετε να έχετε συνδέσμους σε εξωτερικούς εξυπηρετητές επικύρωσης στο υποσέλιδο της σελίδας. Ίσως χρειαστεί να δημιουργήσετε νέο χρήστη με όνομα χρήστη <em>w3cvalidator</em> και να ενεργοποιήσετε την πρόσβαση επισκέπτη. Αυτές οι αλλαγές ενδέχεται να επιτρέπουν την μη εξουσιοδοτημένη πρόσβαση στον εξυπηρετητή· μην το ενεργοποιήσετε σε παραγωγικούς ιστοτόπους!';
$string['configdefaulthomepage'] = 'Αυτό καθορίζει τον πρώτο σύνδεσμο στην πλοήγηση για τους συνδεδεμένους χρήστες.';
$string['configdefaultrequestcategory'] = 'Τα μαθήματα που δημιουργούνται από χρήστες με δυνατότητα αίτησης δημιουργίας νέων μαθημάτων στο πλαίσιο συμφραζομένων συστήματος, θα τοποθετούνται σε αυτή την κατηγορία, εκτός αν οι χρήστες επιτρέπεται να επιλέγουν διαφορετική κατηγορία.';
$string['configdefaultrequestedcategory'] = 'Προεπιλεγμένη κατηγορία στην οποία θα τοποθετούνται τα μαθήματα που δημιουργούνται μετά από αίτηση.';
$string['configdefaultuserroleid'] = 'Όλοι οι συνδεδεμένοι χρήστες θα έχουν τις δυνατότητες του ρόλου που ορίζεται εδώ, σε επίπεδο ιστοτόπου, ΕΠΙΠΛΕΟΝ όποιου άλλου ρόλου τους έχει δοθεί. Ο προεπιλεγμένος ρόλος είναι του Αυθεντικοποιημένου χρήστη. Σημειώστε ότι αυτός δεν συγκρούεται με άλλους ρόλους που έχουν εκτός αν του απαγορεύσετε δυνατότητες, απλώς επιβεβαιώνει ότι όλοι οι χρήστες θα έχουν δυνατότητες που δεν ανατίθενται σε επίπεδο μαθήματος (π.χ. ανάρτηση σε ιστολόγιο, διαχείριση ημερολογίου χρήστη κλπ.).';
$string['configdeleteincompleteusers'] = 'Μετά από αυτή την περίοδο, οποιοσδήποτε λογαριασμός χωρίς όνομα, επώνυμο ή διεύθυνση ηλε.ταχυδρομείου, θα διαγράφεται.';
$string['configdeleteunconfirmed'] = 'Για ορισμένες μεθόδους αυθεντικοποίησης, όπως η αυτο-καταχώρηση με χρήση ηλε.ταχυδρομείου, οι χρήστες θα πρέπει να επιβεβαιώσουν τον λογαριασμό τους εντός συγκεκριμένης χρονικής περιόδου. Με τη λήξη της περιόδου αυτής, διαγράφονται όλοι οι παλιοί ανεπιβεβαίωτοι λογαριασμοί.';
$string['configdenyemailaddresses'] = 'Για την απαγόρευση διευθύνσεων ηλε.ταχυδρομείου από συγκεκριμένους τομείς εισάγετέ τους εδώ με τον ίδιο τρόπο. Όλα οι υπόλοιποι τομείς θα γίνονται δεκτοί. Για την απαγόρευση υπο-τομέων προσθέστε τους τομείς με «.» στην αρχή π.χ. <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Απενεργοποίηση της δυνατότητας χρηστών να αλλάζουν τις εικόνες στο προφίλ τους.';
$string['configdisplayloginfailures'] = 'Αυτό θα εμφανίζει πληροφορίες στους χρήστες για προηγούμενες αποτυχημένες προσπάθειες σύνδεσης.';
$string['configdndallowtextandlinks'] = 'Ενεργοποιήστε ή απενεργοποιήστε τη μεταφορά & απόθεση κειμένου και συνδέσμων σε μια σελίδα μαθήματος, μαζί με τη μεταφορά & απόθεση αρχείων. Σημειώστε ότι η μεταφορά κειμένου σε Firefox ή μεταξύ διαφορετικών περιηγητών είναι αναξιόπιστη και μπορεί να έχει ως αποτέλεσμα να μην ανέβουν τα δεδομένα ή να ανεβεί κατεστραμμένο κείμενο.';
$string['configdoclang'] = 'Αυτή η γλώσσα θα χρησιμοποιείται σε συνδέσμους για τις σελίδες τεκμηρίωσης.';
$string['configdocroot'] = 'Ορίζει το μονοπάτι προς την Τεκμηρίωση του Moodle (Docs) για την παροχή τεκμηρίωσης για συγκεκριμένα πλαίσια συμφραζομένων, μέσω συνδέσμων «Βοήθεια και τεκμηρίωση» στο υποσέλιδο κάθε σελίδας. Εάν το πεδίο παραμείνει κενό, οι σύνδεσμοι δεν θα εμφανίζονται.';
$string['configdoctonewwindow'] = 'Εάν ενεργοποιηθεί, τότε οι σύνδεσμοι προς το Moodle Docs θα εμφανίζονται σε ένα νέο παράθυρο.';
$string['configeditordictionary'] = 'Αυτή η τιμή θα χρησιμοποιηθεί εάν το aspell δεν έχει λεξικό για τη γλώσσα του χρήστη.';
$string['configeditorfontlist'] = 'Επιλέξτε τις γραμματοσειρές που θα εμφανίζονται στην αναπτυσσόμενη λίστα του επεξεργαστή κειμένου.';
$string['configemailchangeconfirmation'] = 'Απαίτηση επιβεβαίωσης μέσω ηλε.ταχυδρομείου όταν οι χρήστες αλλάζουν τη διεύθυνση του ηλε.ταχυδρομείου τους στο προφίλ τους.';
$string['configemaildkimselector'] = 'Ο επιλογέας DKIM είναι αυθαίρετος και οι εγγραφές σας DNS πρέπει να ταιριάζουν με αυτό.';
$string['configemailfromvia'] = 'Προσθέστε πληροφορίες ενδιάμεσων στο πεδίο «Από» του εξερχόμενου μηνύματος ηλε.ταχυδρομείου. Αυτό πληροφορεί τον παραλήπτη από που ήλθε αυτό το μήνυμα ηλε.ταχυδρομείου και βοηθά επίσης τους παραλήπτες στο να μην απαντήσουν κατά λάθος σε διευθύνσεις ηλε.ταχυδρομείου μη-απάντησης.';
$string['configemailheaders'] = 'Ακατέργαστες κεφαλίδες ηλε.ταχυδρομείου να προστεθούν αυτούσιες σε όλα τα εξερχόμενα μηνύματα ηλε.ταχυδρομείου.';
$string['configemailsubjectprefix'] = 'Κείμενο που θα προστεθεί στην αρχή της γραμμής θέματος όλων των εξερχόμενων μηνυμάτων.';
$string['configenableanalytics'] = 'Μοντέλα αναλυτικής, όπως π.χ. «Μαθητές σε κίνδυνο εγκατάλειψης» ή «Επερχόμενες οφειλόμενες δραστηριότητες», μπορούν να παράγουν προβλέψεις, να στείλουν ειδοποιήσεις ενοράσεων και να προσφέρουν περαιτέρω ενέργειες, όπως π.χ. μηνύματα χρηστών.';
$string['configenableblogs'] = 'Αυτός ο διακόπτης παρέχει σε όλους τους χρήστες του ιστοτόπου το δικό τους ιστολόγιο.';
$string['configenablecalendarexport'] = 'Ενεργοποίηση εξαγωγής εγγραφών σε ημερολόγια.';
$string['configenablecomments'] = 'Ενεργοποίηση σχολίων';
$string['configenablecourserequests'] = 'Εάν ενεργοποιηθεί, οι χρήστες με δυνατότητα να αίτησης νέου μαθήματος (moodle/course:request) θα έχουν την επιλογή να ζητήσουν ένα μάθημα. Αυτή η δυνατότητα δεν επιτρέπεται για κανένα από τους προεπιλεγμένους ρόλους. Μπορεί να εφαρμοστεί στο πλαίσιο συμφραζομένων συστήματος ή κατηγορίας.';
$string['configenablemobilewebservice'] = 'Ενεργοποιεί την υπηρεσία κινητών τηλεφώνων της επίσημης εφαρμογής του Moodle ή άλλης εφαρμογή που ζητείται. Για περισσότερες πληροφορίες, διαβάστε την {$a}';
$string['configenablerssfeeds'] = 'Να επιτρέπονται τροφοδοσίες RSS από τα διάφορα χαρακτηριστικά όλου του ιστοτόπου, όπως ιστολόγια, φόρουμ, δραστηριότητες βάσεων δεδομένων και γλωσσάρια. Σημειώστε ότι πρέπει να ενεργοποιήσετε τις τροφοδοσίες RSS και σε κάθε άρθρωμα δραστηριότητας ξεχωριστά.';
$string['configenablerssfeedsdisabled'] = 'Δεν είναι διαθέσιμο γιατί οι τροφοδοσίες RSS είναι απενεργοποιημένες σε όλο τον ιστότοπο. Για να τις ενεργοποιήσετε, πηγαίνετε στις ρυθμίσεις Μεταβλητών (variables) κάτω από τη Διαμόρφωση διαχειριστή (admin configuration).';
$string['configenablerssfeedsdisabled2'] = 'Οι τροφοδοσίες RSS είναι αυτή τη στιγμή απενεργοποιημένες σε επίπεδο ιστοτόπου. Μπορούν να ενεργοποιηθούν στα «Προχωρημένα χαρακτηριστικά» στη «Διαχείριση ιστοτόπου».';
$string['configenablestats'] = 'Εάν επιλέξετε «ναι» εδώ, η χρονο-προγραμματισμένη μέσω της εντολής cron εργασία του Moodle θα επεξεργαστεί τις καταγραφές και θα συλλέξει στατιστικά. Ανάλογα με την κίνηση στον ιστότοπο, αυτό ίσως απαιτήσει χρόνο. Εάν ενεργοποιηθεί θα δείτε ενδιαφέροντα στατιστικά και γραφήματα για κάθε μάθημα ή με βάση όλο τον ιστότοπο.';
$string['configenabletrusttext'] = 'Από προεπιλογή το Moodle καθαρίζει προσεκτικά το κείμενο των χρηστών για την αφαίρεση πιθανών κακόβουλων δεσμών ενεργειών (script), πολυμέσων κλπ. τα οποία θα μπορούσαν να αποτελέσουν κίνδυνο για την ασφάλεια. Το σύστημα Trusted Content αποτελεί έναν τρόπο για να δώσετε σε συγκεκριμένους χρήστες, τους οποίους εμπιστευόσαστε, τη δυνατότητα να συμπεριλάβουν στα κείμενά τους αυτά τα «Προχωρημένα χαρακτηριστικά» ανενόχλητα. Για να γίνει αυτό απαιτείται η ενεργοποίηση αυτής εδώ της ρύθμισης και κατόπιν η απόδοση στο σύστημα Trusted Content άδειας χρήσης συγκεκριμένου ρόλου του Moodle. Κείμενα που δημιουργούνται ή ανεβαίνουν από αυτούς τους χρήστες θα επισημαίνονται ως έμπιστα και δεν θα καθαρίζονται πριν την εμφάνιση.';
$string['configenablewebservices'] = 'Οι υπηρεσίες ιστού επιτρέπουν σε άλλα συστήματα, όπως η εφαρμογή κινητού, να συνδεθούν σε αυτόν τον ιστότοπο και να εκτελέσουν διάφορες λειτουργίες. Για επιπλέον ασφάλεια, αυτή η ρύθμιση θα πρέπει να απενεργοποιηθεί αν δεν χρησιμοποιείτε την εφαρμογή κινητού, ή εξωτερικό εργαλείο/υπηρεσία που απαιτεί ενσωμάτωση μέσω υπηρεσιών ιστού.';
$string['configenablewsdocumentation'] = 'Ενεργοποίηση αυτόματης δημιουργίας τεκμηρίωσης υπηρεσιών ιστού. Ένας χρήστης μπορεί να έχει πρόσβαση στη δική του τεκμηρίωση στην σελίδα των κλειδιών ασφαλείας του {$a}. Εμφανίζει τεκμηρίωση για τα ενεργοποιημένα πρωτόκολλα μόνο.';
$string['configerrorlevel'] = 'Επιλέξτε το πλήθος των προειδοποιήσεων της ΡΗΡ που θα προβάλλονται. Συνήθως, η επιλογή «Κανονικό» είναι η καλύτερη.';
$string['configexportlookahead'] = 'Ημέρες για να κοιτάξουμε μπροστά κατά τη διάρκεια της εξαγωγής';
$string['configexportlookback'] = 'Ημέρες για να κοιτάξουμε πίσω κατά τη διάρκεια της εξαγωγής';
$string['configextendedusernamechars'] = 'Εάν ενεργοποιηθεί, τα ονόματα χρήστη μπορούν να περιλαμβάνουν οποιουσδήποτε χαρακτήρες εκτός από κεφαλαία γράμματα. Διαφορετικά, επιτρέπονται μόνο αλφαριθμητικοί χαρακτήρες με πεζά γράμματα, κάτω παύλες (_), παύλες (-), τελείες (.) και παπάκια (@).';
$string['configextramemorylimit'] = 'Ορισμένες δέσμες ενεργειών όπως αναζήτησης, δημιουργίας/επαναφοράς αντιγράφων ασφαλείας ή δέσμες χρονοπρογραμματισμού cron απαιτούν περισσότερη μνήμη. Ορίστε υψηλότερες τιμές για μεγαλύτερους ιστοτόπους.';
$string['configfilterall'] = 'Να φιλτράρονται όλες οι συμβολοσειρές, συμπεριλαμβανομένων των κεφαλίδων, τίτλων, μπάρας πλοήγησης κ.ο.κ.. Αυτό είναι χρήσιμο κυρίως όταν χρησιμοποιείται το πολυγλωσσικό φίλτρο, ειδάλλως απλώς θα επιβαρύνει τον ιστότοπο για μικρό όφελος.';
$string['configfiltermatchoneperpage'] = 'Τα αυτόματα φίλτρα συνδέσμων παράγουν μόνο έναν σύνδεσμο για το πρώτο στιγμιότυπο κειμένου που ταιριάζει από την συνολική σελίδα. Όλα τα άλλα αγνοούνται.';
$string['configfiltermatchonepertext'] = 'Τα αυτόματα φίλτρα συνδέσμων παράγουν μόνο έναν σύνδεσμο για το πρώτο στιγμιότυπο κειμένου που ταιριάζει σε κάθε αντικείμενο κειμένου. Όλα τα άλλα αγνοούνται. Αυτή η ρύθμιση αγνοείται εάν η ρύθμιση για ένα ανά σελίδα είναι ενεργοποιημένη.';
$string['configfilteruploadedfiles'] = 'Επεξεργασία όλων των ανεβασμένων αρχείων HTML και αρχείων κειμένου με τα φίλτρα πριν από την εμφάνισή τους, ή μόνο των ανεβασμένων αρχείων HTML ή καθόλου επεξεργασία.';
$string['configforcelogin'] = 'Κανονικά, η πρώτη σελίδα του ιστοτόπου και η λίστα των μαθημάτων (αλλά όχι τα ίδια τα μαθήματα) μπορούν να προσπελαστούν από χρήστες χωρίς σύνδεση στον ιστότοπο. Εάν θέλετε να αναγκάσετε τους χρήστες να συνδεθούν πριν κάνουν ΟΤΙΔΗΠΟΤΕ στον ιστότοπο, τότε αυτή η ρύθμιση πρέπει να ενεργοποιηθεί.';
$string['configforceloginforprofiles'] = 'Αυτή η ρύθμιση επιβάλει στους χρήστες να συνδεθούν ως πραγματικοί (μη επισκέπτες) λογαριασμοί για να μπορούν να δουν το προφίλ κάποιου χρήστη. Αν απενεργοποιήσετε αυτή τη ρύθμιση, ενδέχεται να διαπιστώσετε ότι ορισμένοι χρήστες αναρτούν διαφημίσεις (ανεπιθύμητα μηνύματα) ή άλλο ανάρμοστο περιεχόμενο στο προφίλ τους, το οποίο είναι ορατό σε όλο τον κόσμο.';
$string['configfrontpage'] = 'Τα επιλεγμένα αντικείμενα θα εμφανίζονται στην πρώτη σελίδα του ιστοτόπου.';
$string['configfrontpagecourselimit'] = 'Μέγιστος αριθμός μαθημάτων';
$string['configfrontpagecourselimithelp'] = 'Μέγιστος αριθμός μαθημάτων που θα εμφανίζονται στη λίστα μαθημάτων στην πρώτη σελίδα του ιστοτόπου.';
$string['configfrontpageloggedin'] = 'Τα ανωτέρω επιλεγμένα αντικείμενα θα προβάλλονται στην πρώτη σελίδα του ιστοτόπου όταν συνδέεται ένας χρήστης.';
$string['configfullnamedisplay'] = 'Εδώ ορίζεται πως θα φαίνονται τα ονόματα σε πλήρη εμφάνιση. Η προεπιλεγμένη τιμή «language», παραπέμπει στη συμβολοσειρά «fullnamedisplay» στο πακέτο τρέχουσας γλώσσας. Μερικές γλώσσες έχουν διαφορετικές συμβάσεις εμφάνισης ονομάτων. Για τους περισσότερους μονογλωσσικούς ιστοτόπους η πιο αποδοτική ρύθμιση είναι «firstname lastname» (όνομα επώνυμο), αλλά μπορείτε να επιλέξετε γενικά να μην εμφανίζονται επώνυμα. Τα δεσμευτικά θέσης που μπορούν να χρησιμοποιηθούν είναι: firstname (όνομα), lastname (επώνυμο), firstnamephonetic (όνομα όπως προφέρεται), lastnamephonetic (επώνυμο όπως προφέρεται), middlename (μεσαίο όνομα) και alternatename (εναλλακτικό όνομα).';
$string['configgeoipfile'] = 'Τοποθεσία του δυαδικού (όχι απλού κειμένου) αρχείου δεδομένων του GeoLite2 City.
Το αρχείο αυτό δεν αποτελεί κομμάτι της διανομής του Moodle και πρέπει να αποκτηθεί ξεχωριστά από την <a href="https://www.maxmind.com/">MaxMind</a>.
Μπορείτε είτε να αγοράσετε την εμπορική ή να χρησιμοποιήσετε τη δωρεάν έκδοση.<br />
Θα χρειαστεί να καταχωρηθείτε για να κάνετε λήψη του αρχείου βάσης δεδομένων του City, το οποίο μπορείτε να το κάνετε στην <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/">https://dev.maxmind.com/geoip/geoip2/geolite2/</a>.
Μόλις καταχωρηθείτε και κατεβάσετε το αρχείο, αποσυμπιέστε το στον φάκελο «{$a}» στον εξυπηρετητή σας.';
$string['configgetremoteaddrconf'] = 'Εάν ο εξυπηρετητής σας βρίσκεται πίσω από έναν reverse proxy, μπορείτε να χρησιμοποιήσετε αυτή τη ρύθμιση για να ορίσετε ποιες κεφαλίδες HTTP θα θεωρούνται έμπιστες ώστε να περιέχονται στην απομακρυσμένη διεύθυνση IP. Οι κεφαλίδες διαβάζονται σε σειρά, χρησιμοποιώντας την πρώτη διαθέσιμη.';
$string['configgradebookroles'] = 'Αυτή η ρύθμιση επιτρέπει να ελέγχετε ποιοί θα εμφανίζονται στο βαθμολόγιο. Οι χρήστες θα πρέπει να έχουν τουλάχιστον έναν από αυτούς τους ρόλους στο μάθημα για να εμφανίζονται στο βαθμολόγιο του μαθήματος.';
$string['configgradeexport'] = 'Επιλέξτε ποιοί μορφότυποι αρχείων για εξαγωγή βαθμολογίου αποτελούν τις πρωταρχικές μεθόδους σας για εξαγωγή βαθμών. Τα επιλεγμένα πρόσθετα έπειτα θα ορίσουν ένα πεδίο «last exported» για κάθε βαθμό. Για παράδειγμα, αυτό μπορεί να κάνει κάποιες εγγραφές να εμφανίζονται ως «νέες» ή «ανανεωμένες». Εάν δεν είστε σίγουροι αφήστε όλες τις επιλογές αποεπιλεγμένες.';
$string['confighiddenuserfields'] = 'Επιλογή των πεδίων πληροφοριών μαθητών που θέλετε να αποκρύπτονται από άλλους χρήστες εκτός από διαχειριστές/διδάσκοντες μαθήματος. Αυτό θα αυξήσει την ιδιωτικότητα των μαθητών. Για να επιλέξετε πολλά πεδία πρέπει να κρατήσετε πατημένο το πλήκτρο CTRL.';
$string['configidnumber'] = 'Η επιλογή αυτή καθορίζει εάν (α) θα ζητείται από τους χρήστες αναγνωριστικός αριθμός, (β) θα ζητείται από τους χρήστες αναγνωριστικός αριθμός αλλά θα μπορούν να τον αφήσουν κενό ή (γ) θα ζητείται από τους χρήστες αναγνωριστικός αριθμός αλλά δε θα μπορούν να τον αφήσουν κενό. Αν δοθεί, ο αναγνωριστικός αριθμός των χρηστών εμφανίζεται στο προφίλ τους.';
$string['configintro'] = 'Σε αυτή τη σελίδα μπορείτε να ορίσετε διάφορες μεταβλητές ρυθμίσεων που βοηθούν στην σωστή λειτουργία του Moodle στον εξυπηρετητή σας. Μην ανησυχείτε πολύ για αυτό - οι προεπιλεγμένες ρυθμίσεις συνήθως λειτουργούν ικανοποιητικά και μπορείτε οποιαδήποτε στιγμή να έρθετε εδώ για αλλαγές.';
$string['configintroadmin'] = 'Σε αυτή τη σελίδα μπορείτε να ρυθμίσετε τον λογαριασμό του κύριου διαχειριστή ο οποίος θα έχει τον πλήρη έλεγχο του ιστοτόπου. Επιβεβαιώστε ότι χρησιμοποιείτε ασφαλές όνομα χρήστη και κωδικό πρόσβασης, καθώς και μια έγκυρη διεύθυνση ηλε.ταχυδρομείου. Μπορείτε να δημιουργήσετε περισσότερους λογαριασμούς διαχειριστή στη συνέχεια.';
$string['configintrosite'] = 'Αυτή η σελίδα σας επιτρέπει να ρυθμίσετε το όνομα και την πρώτη σελίδα αυτού του νέου ιστοτόπου. Μπορείτε να επιστρέψετε αργότερα εδώ για την αλλαγή αυτών των ρυθμίσεων οποτεδήποτε χρησιμοποιώντας τα μενού διαχείρισης.';
$string['configiplookup'] = 'Όταν επιλέγετε μια διεύθυνση IP (π.χ. 34.12.222.93), όπως στις καταγραφές, εμφανίζεται ένας χάρτης με την πιθανότερη τοποθεσία της. Υπάρχουν διάφορα εναλλακτικά πρόσθετα για το σκοπό αυτό, το καθένα με τα πλεονεκτήματα και τα μειονεκτήματά του.';
$string['configkeeptagnamecase'] = 'Επιλέξτε αυτή την επιλογή εάν επιθυμείτε τα ονόματα ετικετών να κρατούν την αρχική κεφαλαιοποίηση (κεφαλαία/πεζά) όπως κατά την καταχώρηση από τους χρήστες.';
$string['configlang'] = 'Επιλέξτε μια προεπιλεγμένη γλώσσα για ολόκληρο τον ιστότοπο. Οι χρήστες μπορούν να παρακάμψουν αυτή τη ρύθμιση χρησιμοποιώντας το μενού γλώσσας ή τη ρύθμιση στο προσωπικό τους προφίλ.';
$string['configlanglist'] = 'Αν παραμείνει κενό, στο μενού γλώσσας θα εμφανιστούν όλες οι γλώσσες που είναι εγκατεστημένες στον ιστότοπο. Εναλλακτικά, το μενού γλωσσών μπορεί να συντομευτεί εισάγοντας μια λίστα κωδικών γλώσσας που χωρίζονται με κόμματα π.χ. en, de, fr. Εάν είναι επιθυμητό, ένα διαφορετικό όνομα για τη γλώσσα από το όνομα του πακέτου γλώσσας μπορεί να καθοριστεί χρησιμοποιώντας τη μορφή: κωδικός γλώσσας | όνομα γλώσσας π.χ. en_kids | Αγγλικά, de_kids | Deutsch.';
$string['configlangmenu'] = 'Επιλέξτε αν θέλετε να εμφανίζεται το γενικής χρήσης μενού γλωσσών στην αρχική σελίδα, στη σελίδα εισόδου/σύνδεσης κλπ. Αυτό δεν επηρεάζει την ικανότητα του χρήστη να θέτει την προτιμώμενη γλώσσα στο δικό του προφίλ.';
$string['configlangstringcache'] = 'Αποθηκεύει σε κρυφή μνήμη όλες τις συμβολοσειρές γλώσσας σε μεταγλωττισμένα αρχεία στον κατάλογο δεδομένων. Αν μεταφράζετε το Moodle ή αλλάζετε συμβολοσειρές στον πηγαίο κώδικα του Moodle τότε μπορεί να θέλετε να το απενεργοποιήσετε. Διαφορετικά αφήστε το ενεργό για να δείτε οφέλη στην απόδοση.';
$string['configlatinexcelexport'] = 'Επιλέξτε την κωδικοποίηση για εξαγωγές σε Excel.';
$string['configlocale'] = 'Επιλέξτε τη τοποθεσία του συστήματος - αυτό παρακάμπτει την μορφή και την γλώσσα των ημερομηνιών για όλα τα πακέτα γλώσσας (τα ονόματα των ημερών στο ημερολόγιο δεν επηρεάζονται). Θα πρέπει να έχετε τα δεδομένα αυτής της τοποθεσίας εγκατεστημένα στο σύστημά σας (π.χ. για linux en_US.UTF-8 ή es_ES.UTF-8). Στις περισσότερες περιπτώσεις αυτό το πεδίο πρέπει να μένει κενό.';
$string['configlockrequestcategory'] = 'Αν ενεργοποιηθεί, οι χρήστες με τη δυνατότητα να αιτούνται νέα μαθήματα στο πλαίσιο συμφραζομένων του συστήματος δεν θα μπορούν να επιλέξουν μια κατηγορία στην αίτηση για μια νέα φόρμα μαθημάτων. Ένας εναλλακτικός τρόπος περιορισμού των χρηστών να ζητούν ένα νέο μάθημα μόνο σε μία κατηγορία είναι να εφαρμόζεται η δυνατότητα αίτησης νέων μαθημάτων στο πλαίσιο συμφραζομένων της κατηγορίας.';
$string['configloglifetime'] = 'Εδώ ορίζεται το χρονικό διάστημα που θέλετε να διατηρούνται οι καταγραφές για την δραστηριότητα των χρηστών. Οι καταγραφές πριν από αυτό το διάστημα διαγράφονται αυτόματα. Είναι καλύτερο να διατηρούνται οι καταγραφές όσο το δυνατόν περισσότερο. Αν όμως ο εξυπηρετητής έχει πολύ κίνηση και αντιμετωπίζετε προβλήματα απόδοσης, ίσως να πρέπει να μειώσετε το διάστημα αυτό. Τιμές κάτω από 30 δεν συνιστώνται διότι μπορεί να μην λειτουργήσουν σωστά τα στατιστικά.';
$string['configlookahead'] = 'Μέρες προς προεπισκόπηση';
$string['configmailnewline'] = 'Χαρακτήρες αλλαγής γραμμής που χρησιμοποιούνται σε μηνύματα ηλε.ταχυδρομείου. Το CRLF απαιτείται σύμφωνα με το RFC 822bis, ορισμένοι εξυπηρετητές ηλε.ταχυδρομείου εκτελούν αυτόματη μετατροπή από LF σε CRLF, άλλοι εξυπηρετητές κάνουν λάθος μετατροπή από CRLF σε CRCRLF, ενώ άλλοι απορρίπτουν εντελώς τα μηνύματα με απλό LF (qmail για παράδειγμα). Δοκιμάστε να αλλάξετε αυτή τη ρύθμιση εάν έχετε προβλήματα με αγνοούμενα μηνύματα ή διπλές αλλαγές γραμμής.';
$string['configmaxbytes'] = 'Εδώ ορίζεται το μέγιστο μέγεθος (maxbytes) που μπορούν να έχουν τα ανεβασμένα αρχεία σε όλο τον ιστότοπο. Η ρύθμιση αυτή περιορίζεται από τις ρυθμίσεις της PHP (post_max_size και upload_max_filesize) καθώς και από την ρύθμιση του Apache (LimitRequestBody). Με τη σειρά της, η παράμετρος αυτή (maxbytes) περιορίζει το εύρος των μεγεθών που μπορούν να επιλεγούν σε επίπεδο μαθήματος ή αρθρώματος. Αν επιλεγεί «Όριο εξυπηρετητή», τότε θα χρησιμοποιηθεί το μέγιστο όριο που επιτρέπει ο εξυπηρετητής (Apache).';
$string['configmaxconsecutiveidentchars'] = 'Οι κωδικοί πρόσβασης δεν επιτρέπεται να περιέχουν περισσότερους από αυτόν τον αριθμό διαδοχικών πανομοιότυπων χαρακτήρων. Χρησιμοποιήστε το 0 για να απενεργοποιήσετε αυτόν τον έλεγχο.';
$string['configmaxeditingtime'] = 'Εδώ ορίζεται το χρονικό διάστημα που έχουν οι χρήστες για να επανεπεξεργαστούν αναρτήσεις σε φόρουμ, σχόλια σε γλωσσάρια κλπ. Συνήθως τα 30 λεπτά είναι μια καλή τιμή.';
$string['configmaxevents'] = 'Γεγονότα προς προεπισκόπηση';
$string['configmaxusersperpage'] = 'Ο μέγιστος αριθμός χρηστών που εμφανίζονται κατά την επιλογή χρηστών για μάθημα, σύνολο χρηστών, ομάδα (συμμετεχόντων σε μάθημα), υπηρεσία ιστού κλπ.';
$string['configmessaging'] = 'Αν ενεργοποιηθεί, οι χρήστες μπορούν να στείλουν μηνύματα σε άλλους χρήστες στον ιστότοπο.';
$string['configmessagingallowemailoverride'] = 'Να επιτρέπεται οι χρήστες να λαμβάνουν ειδοποιήσεις με μηνύματα σε μια διεύθυνση ηλε.ταχυδρομείου διαφορετική από τη διεύθυνση στο προφίλ τους.';
$string['configmessagingallusers'] = 'Εάν ενεργοποιηθεί, οι χρήστες μπορούν να δουν τη λίστα όλων των χρηστών του ιστοτόπου όταν επιλέγουν κάποιον για να αποστείλουν μήνυμα και οι προτιμήσεις μηνυμάτων τους περιλαμβάνουν την επιλογή αποδοχής μηνυμάτων από οποιονδήποτε στον ιστότοπο. Εάν απενεργοποιηθεί, οι χρήστες μπορούν να δουν μόνο τη λίστα των χρηστών στα μαθήματά τους και έχουν μόνο δύο επιλογές στις προτιμήσεις μηνυμάτων - να δέχονται μηνύματα μόνο από τις επαφές τους ή τις επαφές τους και οποιονδήποτε στα μαθήματά τους.';
$string['configmessagingdefaultpressenter'] = 'Εάν η «Χρήση του πλήκτρου Enter για τέλος εισόδου & αποστολή» θα είναι ενεργοποιημένη από προεπιλογή στις ρυθμίσεις μηνυμάτων των χρηστών.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Οι αναγνωσμένες και μη αναγνωσμένες ειδοποιήσεις μπορούν να διαγραφούν για εξοικονόμηση χώρου. Πόσο καιρό μετά τη δημιουργία μιας ειδοποίησης μπορεί να διαγραφεί;';
$string['configmessagingdeletereadnotificationsdelay'] = 'Οι αναγνωσμένες ειδοποιήσεις μπορούν να διαγραφούν για εξοικονόμηση χώρου. Μετά από πόσο καιρό μια αναγνωσμένη ειδοποίηση μπορεί να διαγραφεί;';
$string['configminpassworddigits'] = 'Οι κωδικοί πρόσβασης πρέπει να έχουν τουλάχιστον τόσα ψηφία.';
$string['configminpasswordlength'] = 'Οι κωδικοί πρόσβασης πρέπει να έχουν μέγεθος τουλάχιστον τόσους χαρακτήρες.';
$string['configminpasswordlower'] = 'Οι κωδικοί πρόσβασης πρέπει να έχουν τουλάχιστον τόσα πεζά γράμματα.';
$string['configminpasswordnonalphanum'] = 'Οι κωδικοί πρόσβασης πρέπει να έχουν τουλάχιστον τόσους μη αλφαριθμητικούς χαρακτήρες.';
$string['configminpasswordupper'] = 'Οι κωδικοί πρόσβασης πρέπει να έχουν τουλάχιστον τόσα κεφαλαία γράμματα.';
$string['configmypagelocked'] = 'Αυτή η ρύθμιση παρεμποδίζει τους μη-διαχειριστές να τροποποιήσουν την προεπιλεγμένη σελίδα.';
$string['confignavcourselimit'] = 'Περιορίζει τον αριθμό των μαθημάτων που εμφανίζονται στον χρήστη στην πλοήγηση.';
$string['confignavshowallcourses'] = 'Αυτή η ρύθμιση καθορίζει αν οι χρήστες που είναι εγγεγραμμένοι στα μαθήματα μπορούν να δουν το μπλοκ Μαθήματα (λίστα όλων των μαθημάτων) στην πλοήγηση, εκτός από το μπλοκ Τα μαθήματα μου (λίστα των μαθημάτων που είναι εγγεγραμμένοι).';
$string['confignavshowcategories'] = 'Εμφάνιση κατηγοριών μαθημάτων στη γραμμή πλοήγησης και στα μπλοκ πλοήγησης. Αυτό δεν συμβαίνει με τα μαθήματα στα οποία είναι εγγεγραμμένος ο χρήστης. Αυτά εξακολουθούν να εμφανίζονται στο μπλοκ Τα μαθήματα μου χωρίς κατηγορίες.';
$string['confignoreplyaddress'] = 'Μερικές φορές αποστέλλονται μηνύματα ηλε.ταχυδρομείου για λογαριασμό του χρήστη (π.χ. αναρτήσεις σε φόρουμ). Η διεύθυνση ηλε.ταχυδρομείου που ορίζεται εδώ θα χρησιμοποιηθεί ως η διεύθυνση αποστολέα για αυτές τις περιπτώσεις όπου οι παραλήπτες δεν πρέπει να μπορούν να απαντούν απευθείας στον χρήστη (π.χ. όταν ο χρήστης επιλέγει να διατηρήσει την διεύθυνσή του ιδιωτική). Αυτή η ρύθμιση θα χρησιμοποιηθεί επίσης ως η διεύθυνση αποστολέα του φακέλου όταν αποστέλλονται μηνύματα.';
$string['confignotifyloginfailures'] = 'Να αποστέλλονται ειδοποιήσεις για αποτυχημένες προσπάθειες σύνδεσης σε αυτούς τους επιλεγμένους χρήστες. Αυτό απαιτεί να ενεργοποιηθεί μια εσωτερική αποθήκευση καταγραφών (π.χ. Τυπική αποθήκευση καταγραφών).';
$string['confignotifyloginthreshold'] = 'Εάν οι ειδοποιήσεις για εσφαλμένες προσπάθειες σύνδεσης είναι ενεργές, μετά από πόσες προσπάθειες από έναν χρήστη ή από μία IP να αποστέλλονται;';
$string['confignotloggedinroleid'] = 'Οι χρήστες που δεν έχουν συνδεθεί στον ιστότοπο θα αντιμετωπίζονται σαν να έχουν αυτόν τον ρόλο στο πλαίσιο ιστοτόπου. Σχεδόν πάντα προτιμάται ο ρόλος επισκέπτη αλλά ίσως θέλετε να δημιουργήσετε ρόλους περισσότερο ή λιγότερο περιοριστικούς. Ενέργειες όπως η δημιουργία αναρτήσεων απαιτούν κανονική σύνδεση.';
$string['configopentowebcrawlers'] = 'Εάν ενεργοποιηθεί, το Google θα επιτρέπεται να εισέλθει στο σύστημα ως Επισκέπτης. Επιπλέον, άτομα που έρχονται στον ιστότοπό σας μέσω αναζήτησης από το Google, θα εισάγονται αυτόματα ως Επισκέπτες. Σημειώστε ότι αυτό παρέχει διάφανη πρόσβαση στα μαθήματα που ήδη επιτρέπουν πρόσβαση σε επισκέπτες.';
$string['configoverride'] = 'Ορίζεται στο config.php';
$string['configpasswordpolicy'] = 'Αν ενεργοποιηθεί, οι κωδικοί πρόσβασης των χρηστών θα ελέγχονται σε σχέση με την πολιτική κωδικού πρόσβασης όπως καθορίζεται στις παρακάτω ρυθμίσεις. Η ενεργοποίηση της πολιτικής κωδικού πρόσβασης δεν θα επηρεάσει τους υπάρχοντες χρήστες μέχρι να αποφασίσουν ή να χρειαστεί να αλλάξουν τον κωδικό πρόσβασής τους, ή να ενεργοποιηθεί η ρύθμιση «Έλεγχος κωδικού πρόσβασης κατά τη σύνδεση».';
$string['configpasswordpolicycheckonlogin'] = 'Εάν ενεργοποιηθεί, οι κωδικοί πρόσβασης των χρηστών θα ελέγχονται σύμφωνα με την πολιτική κωδικού πρόσβασης κάθε φορά που θα συνδέονται οι χρήστες. Εάν ο έλεγχος αποτύχει, ο χρήστης θα πρέπει να αλλάξει τον κωδικό πρόσβασης πριν προχωρήσει.
Είναι χρήσιμο να ενεργοποιείται αυτή η ρύθμιση, μετά από κάθε ενημέρωση της πολιτικής κωδικού πρόσβασης.';
$string['configpasswordresettime'] = 'Αυτό καθορίζει τον χρόνο που έχουν τα άτομα για να επικυρώσουν ένα αίτημα επαναρχικοποίησης κωδικού πρόσβασης προτού λήξει. Συνήθως 30 λεπτά είναι ένας καλός χρόνος.';
$string['configpathtodu'] = 'Μονοπάτι για το πρόγραμμα du. Πιθανότατα κάτι σαν /usr/bin/du. Αν το συμπληρώσετε, τότε οι σελίδες που παρουσιάζουν τα περιεχόμενα φακέλων θα τρέχουν πολύ πιο γρήγορα για φακέλους με πολλά αρχεία.';
$string['configpathtophp'] = 'Μονοπάτι προς το εκτελέσιμο αρχείο της PHP. Πιθανώς κάτι σαν /usr/bin/php. Εάν εισαγάγετε αυτό, τα σενάρια της εντολής χρονοπρογραμματισμού cron μπορούν να εκτελεστούν μέσω των ιστοσελίδων (διεπαφή ιστού) του διαχειριστή.';
$string['configperfdebug'] = 'Εάν ενεργοποιηθεί, πληροφορίες απόδοσης θα εμφανίζονται στο υποσέλιδο του τυπικού αισθητικού θέματος.';
$string['configprofileroles'] = 'Λίστα ρόλων που είναι ορατοί στα προφίλ χρηστών και τη σελίδα συμμετοχής.';
$string['configprofilesforenrolledusersonly'] = 'Προς παρεμπόδιση κακής χρήσης από spammer, οι περιγραφές των προφίλ χρηστών που δεν έχουν ακόμη εγγραφεί σε κανένα μάθημα είναι κρυφές. Οι νέοι χρήστες πρέπει να εγγράφονται σε τουλάχιστον ένα μάθημα πριν να μπορούν να προσθέσουν περιγραφή στο προφίλ τους.';
$string['configprotectusernames'] = 'Αν ενεργοποιηθεί, η φόρμα υπενθύμισης κωδικού πρόσβασης δεν εμφανίζει υποδείξεις που θα επέτρεπαν σε κάποιον να μαντέψει ονόματα χρηστών ή διευθύνσεις ηλε.ταχυδρομείου.';
$string['configproxybypass'] = 'Λίστα χωρισμένη με κόμματα, (επί μέρους) ονομάτων κεντρικών υπολογιστών (hostnames) ή διευθύνσεων IP που θα μπορούν να παρακάμψουν τον διακομιστή μεσολάβησης (π.χ., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Εάν ο εξυπηρετητής χρειάζεται να χρησιμοποιήσει έναν διακομιστή μεσολάβησης (proxy) (π.χ. ένα firewall) για πρόσβαση στο Διαδίκτυο, τότε εισαγάγετε εδώ το όνομα H/Y (hostname) του διακομιστή . Αλλιώς αφήστε το κενό.';
$string['configproxypassword'] = 'Δώστε εδώ τον κωδικό για την πρόσβαση στο Διαδίκτυο μέσω διακομιστή μεσολάβησης (proxy), αν απαιτείται, ή δώστε κενό σε διαφορετική περίπτωση (απαιτείται η PHP επέκταση cURL).';
$string['configproxyport'] = 'Εάν ο εξυπηρετητής αυτός χρειάζεται να χρησιμοποιήσει έναν διακομιστή μεσολάβησης (proxy), τότε δώστε τη θύρα (port) εδώ.';
$string['configproxytype'] = 'Τύπος του διακομιστή μεσολάβησης (απαιτείται PHP5 και επέκταση cURL για υποστήριξη SOCKS5).';
$string['configproxyuser'] = 'Όνομα χρήστη που χρειάζεται για την πρόσβαση στο Διαδίκτυο μέσω διακομιστή μεσολάβησης, αν απαιτείται. Διαφορετικά μένει κενό (απαιτείται PHP5 και επέκταση cURL για υποστήριξη SOCKS5).';
$string['configrecaptchaprivatekey'] = 'Συμβολοσειρά (ιδιωτικό/μυστικό κλειδί) που χρησιμοποιείται για την επικοινωνία μεταξύ του εξυπηρετητή Moodle και του εξυπηρετητή recaptcha. Κλειδιά ReCAPTCHA μπορείτε να προμηθευτείτε από <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Συμβολοσειρά (δημόσιο κλειδί ιστοτόπου) που χρησιμοποιείται για την εμφάνιση του στοιχείου reCAPTCHA στη φόρμα εγγραφής. Κλειδιά ReCAPTCHA μπορείτε να προμηθευτείτε από <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Λέξη για το μαθητή που χρησιμοποιείται στα ζητούμενα μαθήματα';
$string['configrequestedstudentsname'] = 'Λέξη για τους μαθητές που χρησιμοποιείται στα ζητούμενα μαθήματα';
$string['configrequestedteachername'] = 'Λέξη για τον διδάσκοντα που χρησιμοποιείται στα ζητούμενα μαθήματα';
$string['configrequestedteachersname'] = 'Λέξη για τους διδάσκοντες που χρησιμοποιείται στα ζητούμενα μαθήματα';
$string['configreverseproxyignore'] = 'Εάν ο εξυπηρετητής σας βρίσκεται πίσω από πολλαπλούς αντίστροφους διακομιστές μεσολάβησης που προσαρτώνται στην κεφαλίδα X-Forwarded-For, τότε καθορίστε μια λίστα με διαχωρισμένες με κόμμα διευθύνσεις IP ή υποδίκτυα των αντίστροφων διακομιστών μεσολάβησης που πρέπει να αγνοηθούν, προκειμένου να βρεθεί η σωστή διεύθυνση IP του χρήστη.';
$string['configsectioninterface'] = 'Διεπαφή';
$string['configsectionmail'] = 'Μήνυμα';
$string['configsectionmaintenance'] = 'Συντήρηση';
$string['configsectionmisc'] = 'Διάφορα';
$string['configsectionoperatingsystem'] = 'Λειτουργικό σύστημα';
$string['configsectionpermissions'] = 'Δικαιώματα';
$string['configsectionrequestedcourse'] = 'Αιτήσεις δημιουργίας μαθήματος';
$string['configsectionsecurity'] = 'Ασφάλεια';
$string['configsectionstats'] = 'Στατιστικά';
$string['configsectionuser'] = 'Χρήστης';
$string['configsecureforms'] = 'Το Moodle μπορεί να χρησιμοποιήσει ένα επιπλέον επίπεδο ασφάλειας όταν δέχεται δεδομένα από φόρμες ιστού. Εάν ενεργοποιηθεί, η μεταβλητή HTTP_REFERER του περιηγητή ελέγχεται σε σχέση με τη διεύθυνση της τρέχουσας φόρμας. Σε πολύ λίγες περιπτώσεις αυτό μπορεί να προκαλέσει πρόβλημα σε χρήστες που χρησιμοποιούν firewall (π.χ. Zonealarm) ρυθμισμένο να κόβει το HTTP_REFERER από την κυκλοφορία (δεδομένων) ιστού. Το πρόβλημα είναι να «κολλάει» η φόρμα. Εάν οι χρήστες έχουν πρόβλημα (π.χ. με τη σελίδα σύνδεσης/εισόδου) ίσως είναι καλό να απενεργοποιηθεί αυτή η ρύθμιση, καθιστώντας τη σελίδα όμως περισσότερο ευάλωτη σε brute-force επιθέσεις. Εάν δεν είστε σίγουροι, επιλέξτε «Ναι».';
$string['configsessioncookie'] = 'Αυτή η ρύθμιση προσδιορίζει το όνομα του cookie που χρησιμοποιείται στις συνόδους του Moodle. Είναι προαιρετικό και χρήσιμο μόνο για να μη μπερδεύονται τα cookies όταν υπάρχουν περισσότερα του ενός αντίγραφα του Moodle που εκτελούνται στον ίδιο ιστότοπο.';
$string['configsessioncookiedomain'] = 'Αυτό σας επιτρέπει την αλλαγή του τομέα από όπου τα cookies του Moodle είναι διαθέσιμα. Αυτό είναι χρήσιμο για παραμετροποιήσεις του Moodle (π.χ. πρόσθετα για αυθεντικοποίηση ή εγγραφή) που χρειάζεται να κάνουν κοινή χρήση πληροφοριών για τη σύνοδο του Moodle με μια εφαρμογή ιστού σε έναν άλλο υποτομέα. <strong>ΠΡΟΣΟΧΗ: Συνιστάται ένθερμα, να αφήσετε αυτή τη ρύθμιση στην προεπιλεγμένη επιλογή της (κενή) - μια λανθασμένη τιμή θα παρεμποδίσει κάθε πρόσβαση στο σύστημα.</strong>';
$string['configsessioncookiepath'] = 'Αν θέλετε να αλλάξετε το μέρος όπου οι περιηγητές αποθηκεύουν τα cookies, μπορείτε να αλλάξετε αυτή τη ρύθμιση για να ορίσετε εδώ έναν υποφάκελο του ιστοτόπου σας. Ειδάλλως, το προεπιλεγμένο «/» αρκεί.';
$string['configsessiontimeout'] = 'Εάν οι χρήστες που έχουν μπει στο σύστημα μείνουν ανενεργοί για μεγάλο χρονικό διάστημα (χωρίς να φορτώνουν σελίδες), τότε αυτόματα βγαίνουν από το σύστημα (λήγει η σύνοδος). Η μεταβλητή αυτή ορίζει το χρονικό διάστημα αυτό.';
$string['configsessiontimeoutwarning'] = 'Εάν τα άτομα που έχουν συνδεθεί σε αυτόν τον ιστότοπο είναι αδρανή για μεγάλο χρονικό διάστημα (χωρίς φόρτωση σελίδων), τότε προειδοποιούνται για το ότι η σύνοδός τους πρόκειται να τελειώσει. Αυτή η μεταβλητή καθορίζει πόσο πρέπει να διαρκεί αυτός ο χρόνος.';
$string['configsessiontimeoutwarningcheck'] = 'Το χρονικό όριο προειδοποίησης λήξης συνόδου πρέπει να είναι μικρότερο από το χρονικό όριο λήξης συνόδου';
$string['configshowcommentscount'] = 'Εμφάνιση καταμέτρησης σχολίων, θα κοστίσει ένα ακόμα ερώτημα όταν εμφανίζεται ο σύνδεσμος σχολίων';
$string['configshowicalsource'] = 'Εμφάνιση πληροφοριών πηγής για γεγονότα iCal';
$string['configshowsiteparticipantslist'] = 'Όλοι οι μαθητές και οι διδάσκοντες θα αναγράφονται στη λίστα των συμμετεχόντων. Ποιοί θα έχουν πρόσβαση στην λίστα αυτή;';
$string['configsitedefaultlicense'] = 'Προεπιλεγμένη άδεια ιστοτόπου';
$string['configsitedefaultlicensehelp'] = 'Η προεπιλεγμένη άδεια για τη δημοσίευση περιεχομένου σε αυτόν τον ιστότοπο';
$string['configsitemailcharset'] = 'Αυτή η ρύθμιση καθορίζει το προεπιλεγμένο σύνολο χαρακτήρων (charset) για όλα τα μηνύματα ηλε.ταχυδρομείου που αποστέλλονται από τον ιστότοπο.';
$string['configsitemaxcategorydepth'] = 'Μέγιστο βάθος κατηγορίας';
$string['configsitemaxcategorydepthhelp'] = 'Αυτό καθορίζει το μέγιστο βάθος υποκατηγοριών που αναπτύσσονται κατά την εμφάνιση κατηγοριών ή σύνθετης λίστας. Οι χαμηλότερες υποκατηγορίες θα εμφανίζονται ως σύνδεσμοι και ο χρήστης μπορεί να τα αναπτύσσει με αιτήματα AJAX.';
$string['configslasharguments'] = 'Οι παράμετροι γραμμής εντολών (slash arguments π.χ. dir /a) (με χρήση <em>PATH_INFO</em>) απαιτούνται από πακέτα SCORM και πόρους πολλαπλών αρχείων για να εμφανίζονται σωστά. Αν ο εξυπηρετητής ιστού σας δεν υποστηρίζει παραμέτρους και δεν μπορείτε να τον ρυθμίσετε, αυτή η ρύθμιση μπορεί να απενεργοποιηθεί, παρότι το αποτέλεσμα δεν θα είναι λειτουργικό. <br /> Σημείωση: Η χρήση παραμέτρων θα απαιτείται από μελλοντικές εκδόσεις του Moodle.';
$string['configsmtpauthtype'] = 'Εδώ ορίζεται ο τύπος αυθεντικοποίησης που θα χρησιμοποιηθεί στον εξυπηρετητή smtp.';
$string['configsmtphosts'] = 'Δώστε το πλήρες όνομα ενός ή περισσότερων τοπικών εξυπηρετητών SMTP που πρέπει να χρησιμοποιεί το Moodle για να στέλνει μηνύματα ηλε.ταχυδρομείου (π.χ. «mail.auth.gr» ή «mail.auth.gr;mail.uoa.gr»).
Για να ορίσετε μια μη τυπική θύρα (port) (π.χ. εκτός από τη θύρα 25), μπορείτε να χρησιμοποιήσετε τη σύνταξη [εξυπηρετητής]:[θύρα] (π.χ. «mail.auth.gr:587»). Για ασφαλείς συνδέσεις, η θύρα 465 συνήθως χρησιμοποιείται με SSL, η θύρα 587 συνήθως χρησιμοποιείται με TLS. Ορίστε το πρωτόκολλο ασφαλείας παρακάτω αν απαιτείται. Εάν αφήσετε αυτό το πεδίο κενό, το Moodle θα χρησιμοποιήσει την προεπιλεγμένη μέθοδο αποστολής μηνυμάτων ηλε.ταχυδρομείου της PHP.';
$string['configsmtpmaxbulk'] = 'Μέγιστος αριθμός μηνυμάτων που θα στέλνονται σε κάθε σύνοδο SMTP. Η ομαδοποίηση των μηνυμάτων μπορεί να επιταχύνει την αποστολή. Τιμές μικρότερες από 2 επιβάλλουν τη δημιουργία μιας νέας συνόδου SMTP για κάθε μήνυμα.';
$string['configsmtpsecure'] = 'Αν ο εξυπηρετητής SMTP απαιτεί ασφαλή σύνδεση, καθορίστε τον σωστό τύπο πρωτοκόλλου.';
$string['configsmtpuser'] = 'Εάν παραπάνω έχετε ορίσει ένα εξυπηρετητή SMTP και αυτός απαιτεί αυθεντικοποίηση, τότε εισάγετε όνομα χρήστη και κωδικό πρόσβασης εδώ.';
$string['configstartwday'] = 'Αρχή της εβδομάδας';
$string['configstatsfirstrun'] = 'Εδώ ρυθμίζεται πόσο παλιές θα είναι οι καταγραφές που θα υφίστανται επεξεργασία <b>την πρώτη φορά</b> που η χρονο-προγραμματισμένη μέσω της εντολής cron εργασία δημιουργεί στατιστικά. Εάν υπάρχει πολλή κίνηση στον ιστότοπο και είστε σε κοινόχρηστο κεντρικό Η/Υ, μάλλον δεν είναι καλή ιδέα να πάτε πολύ πίσω, καθώς θα μπορούσε να πάρει πολύ χρόνο για να εκτελεστεί και να απαιτεί αρκετούς πόρους από το σύστημα. (Σημειώστε ότι για αυτή τη ρύθμιση 1 μήνας=28 μέρες. Στα γραφήματα και στις αναφορές που δημιουργούνται, 1 μήνας= 1 ημερολογιακός μήνας.)';
$string['configstatsmaxruntime'] = 'Η επεξεργασία στατιστικών είναι εντατική διαδικασία, χρησιμοποιήστε ένα συνδυασμό από αυτό και το επόμενο πεδίο για να ορίσετε πότε θα εκτελείται και για πόση ώρα.';
$string['configstatsmaxruntime2'] = 'Η επεξεργασία στατιστικών είναι εντατική διαδικασία, χρησιμοποιήστε ένα μέγιστο επιτρεπτό χρόνο για τη συλλογή μιας ημέρας στατιστικών. Ο μέγιστος αριθμός ημερών που επεξεργάζεται μια εκτέλεση της εντολής χρονοπρογραμματισμού cron είναι 31.';
$string['configstatsmaxruntime3'] = 'Ορίστε το μέγιστο επιτρεπτό χρόνο για τον υπολογισμό των στατιστικών για μια ημέρα, έχοντας υπόψιν πως η επεξεργασία των στατιστικών μπορεί να επιφέρει πολύ μεγάλο φόρτο στον εξυπηρετητή. Ο μέγιστος αριθμός ημερών που επεξεργάζεται μια εκτέλεση της εντολής χρονοπρογραμματισμού cron μπορεί να οριστεί παρακάτω.';
$string['configstatsruntimedays'] = 'Ορίστε το μέγιστο αριθμό ημερών που επεξεργάζεται κάθε εκτέλεση στατιστικών. Όταν τα στατιστικά είναι επίκαιρα, θα γίνεται επεξεργασία μόνο μιας ημέρας οπότε ρυθμίστε/προσαρμόστε αυτή την τιμή ανάλογα με το φόρτο του εξυπηρετητή, μειώνοντάς την εάν χρειάζονται μικρότεροι χρόνοι εκτέλεσης της εντολής χρονοπρογραμματισμού cron.';
$string['configstatsruntimestart'] = 'Τι ώρα να ξεκινά την επεξεργασία των στατιστικών η χρονο-προγραμματισμένη μέσω της εντολής cron εργασία; Καθορισμός διαφορετικών ωρών συνιστάται, αν υπάρχουν πολλοί ιστότοποι Moodle στον ίδιο Η/Υ.';
$string['configstatsuserthreshold'] = 'Αυτή η ρύθμιση καθορίζει τον ελάχιστο αριθμό εγγεγραμμένων χρηστών για ένα μάθημα που πρέπει να συμπεριληφθεί στους υπολογισμούς στατιστικών στοιχείων.';
$string['configstrictformsrequired'] = 'Εάν ενεργοποιηθεί, παρεμποδίζονται οι χρήστες από το να εισάγουν ένα κενό διάστημα ή αλλαγή γραμμής μόνο σε υποχρεωτικά πεδία σε φόρμες.';
$string['configstripalltitletags'] = 'Αποεπιλέξτε αυτή τη ρύθμιση για να επιτρέψετε ετικέτες HTML σε ονόματα δραστηριοτήτων και πηγών.';
$string['configsupportemail'] = 'Αυτή η διεύθυνση ηλε.ταχυδρομείου θα δημοσιεύεται σε χρήστες αυτού του ιστοτόπου ως η διεύθυνση επικοινωνίας για γενική βοήθεια (για παράδειγμα, όταν νέοι χρήστες δημιουργούν μόνοι τους, τούς λογαριασμούς τους). Εάν αυτή η διεύθυνση μείνει κενή τότε δε θα προσφέρεται αυτή η χρήσιμη δυνατότητα.';
$string['configsupportname'] = 'Αυτό είναι το όνομα του ατόμου (ή της οντότητας, γενικότερα) που θα παρέχει γενική βοήθεια μέσω της σχετικής διεύθυνσης ηλε.ταχυδρομείου ή ιστοσελίδας.';
$string['configsupportpage'] = 'Αυτή η διεύθυνση ιστού θα δημοσιευτεί στους χρήστες του ιστοτόπου ως σημείο παροχής γενικής βοήθειας (για παράδειγμα, όταν νέοι χρήστες δημιουργούν μόνοι τους, τους ίδιους τους λογαριασμούς τους). Εάν αυτή η διεύθυνση μείνει κενή τότε δε θα προσφέρεται κανένας σχετικός σύνδεσμος.';
$string['configtempdatafoldercleanup'] = 'Αφαίρεση προσωρινών αρχείων δεδομένων από το φάκελο δεδομένων που είναι παλαιότερα από την επιλεγμένη ώρα.';
$string['configthemedesignermode'] = 'Κανονικά, όλες οι εικόνες αισθητικού θέματος και τα φύλλα στυλ αποθηκεύονται σε κρυφή μνήμη στους περιηγητές και στον εξυπηρετητή για ένα μεγάλο χρονικό διάστημα, για λόγους απόδοσης. Αν σχεδιάζετε αισθητικά θέματα ή αναπτύσσετε κώδικα, τότε πιθανότατα θέλετε να ενεργοποιήσετε αυτή τη λειτουργία έτσι ώστε να μην σας εμφανίζονται αποθηκευμένες εκδόσεις. Προειδοποίηση: αυτό θα κάνει τον ιστότοπό σας πιο αργό για όλους τους χρήστες! Εναλλακτικά, μπορείτε επίσης να επαναρχικοποιήσετε την κρυφή μνήμη θεμάτων, μη αυτόματα, από τη σελίδα επιλογής θέματος.';
$string['configthemelist'] = 'Αφήστε το κενό για να επιτρέπεται σε κάθε έγκυρο αισθητικό θέμα να χρησιμοποιείται. Εάν θέλετε να μικρύνετε το μενού των αισθητικών θεμάτων, μπορείτε να ορίσετε μια λίστα ονομάτων διαχωρισμένων με κόμμα εδώ (μην χρησιμοποιήσετε κενά). π.χ. τυπικό,orangewhite.';
$string['configtimezone'] = 'Εδώ βρίσκεται η προεπιλεγμένη ζώνη ώρας για την εμφάνιση ημερομηνιών. Κάθε χρήστης μπορεί να παρακάμψει αυτή τη ρύθμιση μέσα από το προφίλ του. Οι χρονο-προγραμματισμένες μέσω της εντολής cron εργασίες και άλλες ρυθμίσεις του ιστοτόπου καθορίζονται σε αυτή τη ζώνη ώρας. Θα πρέπει να αλλάξετε την ρύθμιση αν εμφανίζεται ως «Μη έγκυρη ζώνη ώρας».';
$string['configuseblogassociations'] = 'Να μπορούν οι χρήστες να οργανώνουν το ιστολόγιό τους συνδέοντας αναρτήσεις με μαθήματα και αρθρώματα μαθημάτων;';
$string['configusesitenameforsitepages'] = 'Εάν ενεργοποιηθεί, το σύντομο όνομα του ιστοτόπου θα χρησιμοποιηθεί για τον κόμβο των σελίδων ιστοτόπων στην πλοήγηση αντί για τη συμβολοσειρά «Σελίδες ιστοτόπου».';
$string['configusetags'] = 'Να ισχύει η λειτουργικότητα ετικετών σε ολόκληρο τον ιστότοπο;';
$string['configvariables'] = 'Μεταβλητές';
$string['configverifychangedemail'] = 'Ενεργοποιεί την επαλήθευση αλλαγμένων διευθύνσεων ηλε.ταχυδρομείου χρησιμοποιώντας τις ρυθμίσεις επιτρεπτών και μη επιτρεπτών τομέων DNS. Εάν αυτή η ρύθμιση είναι απενεργοποιημένη τότε οι τομείς τίθενται σε ισχύ μόνο κατά τη δημιουργία νέου χρήστη.';
$string['configvisiblecourses'] = 'Κανονική εμφάνιση μαθημάτων σε κρυφές κατηγορίες';
$string['configwarning'] = 'Οι τροποποίηση των τιμών αυτών των πεδίων πρέπει να γίνεται με πολλή προσοχή γιατί εσφαλμένες τιμές μπορεί να προκαλέσουν προβλήματα.';
$string['configyuicomboloading'] = 'Αυτές οι επιλογές επιτρέπουν τη βελτιστοποίηση φόρτωσης συνδυασμένων αρχείων για τις βιβλιοθήκες YUI. Αυτή η ρύθμιση θα πρέπει να είναι ενεργοποιημένη σε παραγωγικούς ιστοτόπους για λόγους απόδοσης.';
$string['confirmation'] = 'Επιβεβαίωση';
$string['confirmcontextlock'] = 'Το πλαίσιο «{$a->contextname}» δεν είναι παγωμένο. Το πάγωμα θα το κάνει να είναι μόνο για ανάγνωση και θα παρεμποδίσει τους χρήστες να κάνουν αλλαγές. Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
$string['confirmcontextunlock'] = 'Το πλαίσιο «{$a->contextname}» είναι παγωμένο. Το ξεπάγωμά του θα επιτρέψει στους χρήστες να κάνουν αλλαγές. Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
$string['confirmdeletecomments'] = 'Είστε έτοιμοι να διαγράψετε σχόλια, είστε σίγουροι;';
$string['confirmed'] = 'Επιβεβαιωμένος';
$string['contenttypeuninstalling'] = 'Υπάρχουν {$a->count} περιεχόμενα που υποστηρίζονται από το {$a->type}. Θα διαγραφούν. Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
$string['contextlockappliestoadmin'] = 'Το πάγωμα πλαισίων ισχύει και για τους διαχειριστές';
$string['contextlockappliestoadmin_desc'] = 'Αν απενεργοποιηθεί, οι διαχειριστές συνεχίζουν να έχουν πρόσβαση εγγραφής σε οποιοδήποτε παγωμένο πλαίσιο.';
$string['contextlocking'] = 'Πάγωμα πλαισίων';
$string['contextlocking_desc'] = 'Αυτή η ρύθμιση επιτρέπει την επιλογή πρόσβασης μόνο για ανάγνωση για επιλεγμένες κατηγορίες, μαθήματα, δραστηριότητες ή μπλοκ.';
$string['cookiesecure'] = 'Μόνο ασφαλή cookies';
$string['country'] = 'Προεπιλεγμένη χώρα';
$string['course_customfield'] = 'Προσαρμοσμένα πεδία μαθήματος';
$string['coursecolor'] = 'Χρώμα {$a}';
$string['coursecolorheading_desc'] = 'Οποιαδήποτε μαθήματα χωρίς μια εικόνα μαθήματος ορισμένη στις ρυθμίσεις μαθήματος, εμφανίζονται στο Ταμπλό με μία κάρτα μαθήματος με μοτίβα/σχέδια. Τα χρώματα προς χρήση στο μοτίβο μπορούν να καθοριστούν παρακάτω.';
$string['coursecolorsettings'] = 'Χρώματα καρτών μαθημάτων';
$string['coursecontact'] = 'Διαχειριστές μαθήματος';
$string['coursecontact_desc'] = 'Αυτή η ρύθμιση σάς επιτρέπει να ελέγχετε ποιος θα εμφανίζεται στην περιγραφή του μαθήματος. Οι χρήστες πρέπει να έχουν τουλάχιστον έναν από αυτούς τους ρόλους σε ένα μάθημα για να εμφανίζονται στην περιγραφή του μαθήματος για αυτό το μάθημα.';
$string['coursecontactduplicates'] = 'Εμφάνιση όλων των ρόλων επαφών μαθήματος';
$string['coursecontactduplicates_desc'] = 'Εάν ενεργοποιηθεί, οι χρήστες με περισσότερους από έναν από τους επιλεγμένους ρόλους επαφής για το μάθημα θα εμφανιστούν στην περιγραφή του μαθήματος με κάθε έναν από τους ρόλους τους. Διαφορετικά, θα εμφανίζονται με έναν μόνο ρόλο (όποιον από τους δύο παρατίθεται υψηλότερα στο «Καθορισμός ρόλων» στη Διαχείριση ιστοτόπου).';
$string['coursegraceperiodafter'] = 'Περίοδος χάριτος για περασμένα μαθήματα';
$string['coursegraceperiodbefore'] = 'Περίοδος χάριτος για μελλοντικά μαθήματα';
$string['courselistshortnames'] = 'Εμφάνιση εκτεταμένων ονομάτων μαθημάτων';
$string['courselistshortnames_desc'] = 'Εάν ενεργοποιηθεί, τα σύντομα ονόματα μαθημάτων θα εμφανίζονται επιπρόσθετα μαζί με τα πλήρη ονόματα στις λίστες μαθημάτων. Αν απαιτείται, τα εκτεταμένα ονόματα μαθημάτων μπορούν να προσαρμοστούν με τροποποίηση της συμβολοσειράς γλώσσας «courseextendednamedisplay» χρησιμοποιώντας το χαρακτηριστικό/δυνατότητα προσαρμογής γλώσσας.';
$string['coursemgmt'] = 'Διαχείριση μαθημάτων και κατηγοριών';
$string['courseoverview'] = 'Επισκόπηση μαθημάτων';
$string['courserequestnotify'] = 'Ειδοποίηση δημιουργίας μαθήματος';
$string['courserequestnotifyemail'] = 'Ο χρήστης {$a->user} έχει ζητήσει τη δημιουργία νέου μαθήματος στο {$a->link}';
$string['courserequests'] = 'Αιτήσεις δημιουργίας μαθήματος';
$string['courserequestspending'] = 'Αιτήσεις δημιουργίας μαθήματος που εκκρεμούν';
$string['courses'] = 'Μαθήματα';
$string['coursesperpage'] = 'Μαθήματα ανά σελίδα';
$string['courseswithsummarieslimit'] = 'Μαθήματα με περιορισμό περιλήψεων';
$string['creatornewroleid'] = 'Ρόλος του δημιουργού σε νέα μαθήματα';
$string['creatornewroleid_help'] = 'Αν ο χρήστης δεν έχει ήδη το δικαίωμα να διαχειριστεί το νέο μάθημα, ο χρήστης εγγράφεται αυτόματα χρησιμοποιώντας αυτό το ρόλο.';
$string['cron'] = 'Εντολή χρονοπρογραμματισμού cron';
$string['cron_enabled'] = 'Ενεργοποίηση της εντολής χρονοπρογραμματισμού cron';
$string['cron_enabled_desc'] = 'Η εντολή χρονοπρογραμματισμού cron θα πρέπει κανονικά να είναι ενεργοποιημένη, ωστόσο αυτή η ρύθμιση επιτρέπει να απενεργοποιηθεί προσωρινά, για παράδειγμα πριν από μια επανεκκίνηση του εξυπηρετητή. Εάν απενεργοποιηθεί, δεν επιτρέπεται στο σύστημα να ξεκινήσει νέες εργασίες παρασκηνίου. Σημειώστε ότι η cron δεν πρέπει να απενεργοποιηθεί για μεγάλο χρονικό διάστημα, καθώς αυτό θα αποτρέψει την εκτέλεση σημαντικών λειτουργιών.';
$string['cron_help'] = 'Το σενάριο cron.php εκτελεί ένα πλήθος εργασιών σε διαφορετικά χρονοπρογραμματισμένα διαστήματα, όπως η αποστολή ειδοποιήσεων μέσω ηλε.ταχυδρομείου για αναρτήσεις σε φόρουμ. Το σενάριο θα πρέπει να εκτελείται τακτικά - ιδανικά κάθε λεπτό.';
$string['cron_link'] = '';
$string['cronclionly'] = 'Εκτέλεση της εντολής χρονοπρογραμματισμού cron μόνο μέσω γραμμής εντολών';
$string['cronerrorclionly'] = 'Λυπούμαστε, η πρόσβαση σε αυτή τη σελίδα από το Διαδίκτυο έχει απενεργοποιηθεί από το διαχειριστή.';
$string['cronerrorpassword'] = 'Λυπούμαστε, ο κωδικός πρόσβασης δεν είναι έγκυρος για να προσπελάσετε αυτή τη σελίδα';
$string['croninfrequent'] = 'Πέρασε χρόνος {$a->actual} μεταξύ των δύο τελευταίων εκτελέσεων του σεναρίου συντήρησης cron και θα έπρεπε να εκτελείται κάθε {$a->expected}. Συνιστάται η ρύθμισή του ώστε να εκτελείται πιο συχνά.';
$string['cronremotepassword'] = 'Κωδικός πρόσβασης της εντολής χρονοπρογραμματισμού cron για απομακρυσμένη πρόσβαση';
$string['cronwarning'] = 'Το <a href="{$a->url}">σενάριο admin/cron.php</a> δεν έχει εκτελεστεί για {$a->actual} και θα έπρεπε να εκτελείται κάθε {$a->expected}.';
$string['cronwarningcli'] = 'Το σενάριο <code>admin/cli/cron.php</code> δεν έχει εκτελεστεί για {$a->actual} και θα έπρεπε να εκτελείται κάθε {$a->expected}.';
$string['cronwarningnever'] = 'Το σενάριο <code>admin/cli/cron.php</code> δεν εκτελέστηκε ποτέ και πρέπει να εκτελείται κάθε {$a->expected}.';
$string['cronwarningneverweb'] = 'Το <a href="{$a->url}">σενάριο admin/cron.php</a> δεν εκτελέστηκε ποτέ και πρέπει να εκτελείται κάθε {$a->expected}.';
$string['ctyperequired'] = 'Η επέκταση PHP ctype τώρα απαιτείται από το Moodle, για τη βελτίωση της απόδοσης του ιστοτόπου και την παροχή πολυγλωσσικής συμβατότητας.';
$string['curlcache'] = 'Χρόνος ζωής κρυφής μνήμης cURL';
$string['curlrequired'] = 'Η επέκταση PHP cURL απαιτείται από το Moodle ώστε να είναι δυνατή η επικοινωνία με τα αποθετήρια του Moodle.';
$string['curlsecurityallowedport'] = 'Λίστα επιτρεπόμενων θυρών cURL';
$string['curlsecurityallowedportsyntax'] = 'Λίστα αριθμών θυρών στους οποίους μπορεί να συνδεθεί το cURL. Έγκυρες καταχωρήσεις είναι μόνο ακέραιοι αριθμοί. Εισάγετε κάθε καταχώρηση σε μια νέα γραμμή. Αν μένει κενό, τότε επιτρέπονται όλες οι θύρες. Αν οριστούν, σε όλες σχεδόν τις περιπτώσεις, θα πρέπει να οριστούν οι θύρες 443 και 80 προκειμένου το cURL να συνδεθεί με τις τυπικές θύρες HTTPS και HTTP.';
$string['curlsecurityblockedhosts'] = 'Λίστα μπλοκαρισμένων κεντρικών υπολογιστών cURL';
$string['curlsecurityblockedhostssyntax'] = 'Εισάγετε κάθε καταχώρηση σε μια νέα γραμμή. Έγκυρες καταχωρήσεις είναι:
<ul>
<li>πλήρεις διευθύνσεις IPv4 ή IPv6 (όπως 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) που αντιστοιχούν σε έναν κεντρικό υπολογιστή ή</li>
<li>CIDR (όπως 231.54.211.0/20 ή fe80::/64) ή</li>
<li>ένα εύρος διευθύνσεων IP (όπως 231.3.56.10-20 ή fe80::1111-bbbb) όπου το εύρος ισχύει για την τελευταία ομάδα της διεύθυνσης ή</li>
<li>ονόματα τομέων (όπως localhost ή tomeas.com) ή</li>
<li>μπαλαντέρ ονόματα τομέων (όπως *.tomeas.com ή *.sub.tomeas.com</li>
</ul>
Δεν επιτρέπονται κενές γραμμές.';
$string['curlsecurityurlblocked'] = 'Η διεύθυνση URL έχει μπλοκαριστεί.';
$string['curltimeoutkbitrate'] = 'Ρυθμός μετάδοσης δεδομένων για χρήση κατά τον υπολογισμό των χρονικών ορίων cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Αυτή η ρύθμιση χρησιμοποιείται για τον υπολογισμό ενός κατάλληλου χρονικού ορίου κατά τη διάρκεια μεγάλων αιτημάτων cURL. Ως μέρος αυτού του υπολογισμού γίνεται ένα αίτημα HTTP HEAD για τον προσδιορισμό του μεγέθους του περιεχομένου. Αν οριστεί ως 0 απενεργοποιεί αυτό το αίτημα.';
$string['currenttheme'] = 'Τρέχον αισθητικό θέμα';
$string['customcheck'] = 'Άλλοι έλεγχοι';
$string['custommenu'] = 'Προσαρμοσμένο μενού';
$string['custommenuitems'] = 'Προσαρμοσμένα στοιχεία μενού';
$string['customusermenuitems'] = 'Στοιχεία μενού χρήστη';
$string['datarootsecurityerror'] = '<p><strong>ΠΡΟΕΙΔΟΠΟΙΗΣΗ ΑΣΦΑΛΕΙΑΣ!</strong></p><p>Ο φάκελος σας dataroot βρίσκεται σε λάθος τοποθεσία και είναι εκτεθειμένος στο Διαδίκτυο. Αυτό σημαίνει πως όλα τα ιδιωτικά σας αρχεία είναι διαθέσιμα σε οποιονδήποτε στον κόσμο και ορισμένα από αυτά μπορούν να χρησιμοποιηθούν από κάποιον cracker για την απόκτηση διαχειριστικής πρόσβασης στον ιστότοπό σας!</p>
<p><em>ΠΡΕΠΕΙ</em> να μετακινήσετε το φάκελο dataroot ({$a}) σε νέα τοποθεσία που δεν θα βρίσκεται μέσα στο φάκελο που μοιράζεστε στο Διαδίκτυο και να ανανεώσετε ανάλογα τη ρύθμιση <code>$CFG->dataroot</code> στο αρχείο config.php.</p>';
$string['datarootsecuritywarning'] = 'Οι ρυθμίσεις του ιστοτόπου σας μπορεί να μην είναι ασφαλείς. Παρακαλούμε, βεβαιωθείτε πως ο φάκελος dataroot ({$a}) δεν είναι απ΄ ευθείας προσβάσιμος μέσω ιστού.';
$string['dbsessions'] = 'Να χρησιμοποιείται η βάση δεδομένων για την αποθήκευση των πληροφοριών των συνόδων';
$string['debug'] = 'Μηνύματα αποσφαλμάτωσης';
$string['debugall'] = 'ΟΛΑ: Εμφάνιση όλων των μηνυμάτων αποσφαλμάτωσης της ΡΗΡ';
$string['debugdeveloper'] = 'ΠΡΟΓΡΑΜΜΑΤΙΣΤΗΣ: Εμφάνιση επιπλέον μηνυμάτων αποσφαλμάτωσης της ΡΗΡ';
$string['debugdisplay'] = 'Εμφάνιση μηνυμάτων αποσφαλμάτωσης';
$string['debugging'] = 'Αποσφαλμάτωση';
$string['debugminimal'] = 'ΛΙΓΟΤΕΡΑ: Εμφάνιση μόνο των πολύ σημαντικών σφαλμάτων';
$string['debugnone'] = 'ΚΑΝΕΝΑ: Να μην προβάλλεται κανένα σφάλμα';
$string['debugnormal'] = 'ΚΑΝΟΝΙΚΑ: Να προβάλλονται τα σφάλματα, οι προειδοποιήσεις και οι σημειώσεις';
$string['debugpageinfo'] = 'Εμφάνιση πληροφοριών σελίδας';
$string['debugsqltrace'] = 'Εμφάνιση προέλευσης κλήσεων SQL';
$string['debugsqltrace1'] = 'Εμφάνιση μόνο μιας γραμμής κλήσης';
$string['debugsqltrace100'] = 'Εμφάνιση πλήρους ίχνους στοίβας';
$string['debugsqltrace2'] = 'Εμφάνιση 2 γραμμών ίχνους στοίβας';
$string['debugsqltrace_desc'] = 'Εάν ενεργοποιηθεί, ένα μερικό ή πλήρες ίχνος στοίβας PHP προστίθεται στην SQL ως σχόλιο.';
$string['debugstringids'] = 'Εμφάνιση προέλευσης συμβολοσειρών γλώσσας';
$string['debugstringids_desc'] = 'Αν ενεργοποιηθεί, εμφανίζονται τα στοιχεία λογισμικού και τα αναγνωριστικά των συμβολοσειρών γλώσσας. όταν προστεθούν στη URL διεύθυνση σελίδας ?strings=1 ή &strings=1.
<br />(Αυτή η επιλογή έχει σχεδιαστεί για να βοηθήσει τους μεταφραστές να εντοπίσουν συγκεκριμένη συμβολοσειρά μιας σελίδας.)';
$string['debugvalidators'] = 'Εμφάνιση συνδέσμων επικύρωσης';
$string['defaultcity'] = 'Προεπιλεγμένη πόλη';
$string['defaultcity_help'] = 'Η πόλη που εισάγεται εδώ θα είναι η προεπιλεγμένη πόλη όταν δημιουργούνται νέοι λογαριασμοί χρηστών.';
$string['defaultformatnotset'] = 'Σφάλμα κατά τον καθορισμό της προεπιλεγμένης μορφής μαθήματος. Παρακαλούμε ελέγξτε τις ρυθμίσεις του ιστοτόπου.';
$string['defaulthomepage'] = 'Αρχική σελίδα για χρήστες';
$string['defaultrequestcategory'] = 'Προεπιλεγμένη κατηγορία για αιτήσεις δημιουργίας μαθήματος';
$string['defaultsettinginfo'] = 'Προεπιλογή: {$a}';
$string['defaultuserroleid'] = 'Προεπιλεγμένοι ρόλοι για όλους τους χρήστες';
$string['deleteincompleteusers'] = 'Διαγραφή ελλιπών λογαριασμών χρηστών μετά από';
$string['deleteunconfirmed'] = 'Διαγραφή μη επιβεβαιωμένων χρηστών μετά από';
$string['deleteuser'] = 'Διαγραφή χρήστη';
$string['density'] = 'Πυκνότητα';
$string['denyemailaddresses'] = 'Αποκλεισμένοι τομείς διευθύνσεων ηλε.ταχυδρομείου';
$string['development'] = 'Ανάπτυξη';
$string['devicetype'] = 'Τύπος συσκευής';
$string['devlibdirpresent'] = 'Κατάλογοι με βιβλιοθήκες ανάπτυξης, ειδικά οι <em>/vendor</em> και <em>/node_modules</em>, δεν πρέπει να υπάρχουν σε δημόσιους ιστοτόπους. Για περισσότερες λεπτομέρειες, ανατρέξτε στην αναφορά <a href="{$a->moreinfourl}">επισκόπηση ασφάλειας</a>.';
$string['disabled'] = 'Απενεργοποιημένες';
$string['disableuserimages'] = 'Απενεργοποίηση εικόνων στο προφίλ χρήστη';
$string['displayerrorswarning'] = 'Η ενεργοποίηση της ρύθμισης PHP <em>display_errors</em> δε συνιστάται σε παραγωγικά συστήματα επειδή κάποια μηνύματα μπορεί να αποκαλύψουν ευαίσθητες πληροφορίες σχετικά με τον εξυπηρετητή σας.';
$string['displayloginfailures'] = 'Εμφάνιση αποτυχημένων προσπαθειών σύνδεσης';
$string['divertallemails'] = 'Εκτροπή ηλε.ταχυδρομείου';
$string['divertallemailsdetail'] = 'Χρησιμοποιείται για προστασία σε περιβάλλοντα ανάπτυξης κατά τη δοκιμή μηνυμάτων ηλε.ταχυδρομείου και δεν πρέπει να χρησιμοποιείται στην παραγωγή.';
$string['divertallemailsexcept'] = 'Εξαιρέσεις εκτροπής ηλε.ταχυδρομείου';
$string['divertallemailsexcept_desc'] = 'Μια λίστα κανόνων εξαίρεσης ηλε.ταχυδρομείου διαχωρισμένων είτε με κόμμα είτε με αλλαγή γραμμής. Κάθε κανόνας ερμηνεύεται ως κανονική έκφραση, π.χ. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Εκτροπή όλων των μηνυμάτων ηλε.ταχυδρομείου';
$string['divertallemailsto_desc'] = 'Εάν οριστεί τότε όλα τα μηνύματα ηλε.ταχυδρομείου θα εκτραπούν σε αυτή τη μεμονωμένη διεύθυνση ηλε.ταχυδρομείου.';
$string['dndallowtextandlinks'] = 'Ανέβασμα με μεταφορά & απόθεση κειμένου/συνδέσμων';
$string['doclang'] = 'Γλώσσα για έγγραφα';
$string['docroot'] = 'Φάκελος αρχείων βοήθειας';
$string['doctonewwindow'] = 'Άνοιγμα σε νέο παράθυρο';
$string['doesnotfit'] = 'Ρυθμίσεις εμφάνισης ηλε.ταχυδρομείου';
$string['doesnotfitdetail'] = 'Ρυθμίσεις εμφάνισης για μηνύματα ηλε.ταχυδρομείου που εξέρχονται από το Moodle';
$string['download'] = 'Λήψη';
$string['downloadcoursecontentallowed'] = 'Το χαρακτηριστικό/δυνατότητα λήψης περιεχομένου μαθήματος είναι διαθέσιμο';
$string['downloadcoursecontentallowed_desc'] = 'Εάν το χαρακτηριστικό/δυνατότητα λήψης περιεχομένου μαθήματος είναι διαθέσιμο στα μαθήματα. Όταν είναι διαθέσιμο, οι λήψεις περιεχομένου μαθημάτων μπορούν να ενεργοποιηθούν/απενεργοποιηθούν χρησιμοποιώντας τη ρύθμιση «Ενεργοποίηση λήψης περιεχομένου μαθήματος» στο μενού επεξεργασίας του μαθήματος (η προεπιλογή για αυτό μπορεί να οριστεί σε  <a href={$a} target="_blank">Προεπιλεγμένες ρυθμίσεις μαθήματος</a>).';
$string['durationunits'] = 'μονάδες διάρκειας';
$string['edithelpdocs'] = 'Επεξεργασία των αρχείων βοήθειας';
$string['editlang'] = '<b>Επεξεργασία</b>';
$string['editorbackgroundcolor'] = 'Χρώμα υπόβαθρου';
$string['editordictionary'] = 'Λεξικό επεξεργαστή κειμένου';
$string['editorfontfamily'] = 'Οικογένεια γραμματοσειράς';
$string['editorfontlist'] = 'Λίστα γραμματοσειρών';
$string['editorfontsize'] = 'Μέγεθος γραμματοσειράς';
$string['editorhidebuttons'] = 'Κρυμμένα εικονίδια';
$string['editorkillword'] = 'Φίλτρο εισαγωγής από MS-Word';
$string['editorspelling'] = 'Ορθογραφία επεξεργαστή κειμένου';
$string['editorspellinghelp'] = 'Ενεργοποίηση ή απενεργοποίηση ορθογραφικού ελέγχου. Στην περίπτωση ενεργοποίησης, το <strong>aspell</strong> πρέπει να είναι εγκατεστημένο στον εξυπηρετητή.';
$string['editstrings'] = 'Επεξεργασία λέξεων ή φράσεων';
$string['emailchangeconfirmation'] = 'Επιβεβαίωση αλλαγής διεύθυνσης ηλε.ταχυδρομείου';
$string['emaildkim'] = 'Υπογραφή ηλε.ταχυδρομείου με αναγνώριση μηνυμάτων μέσω κλειδιών τομέα (DKIM)';
$string['emaildkiminfo'] = 'Εάν, και έχει οριστεί ο επιλογέας DKIM και έχει βρεθεί ένα ιδιωτικό αρχείο πιστοποιητικού που ταιριάζει με τον τομέα διεύθυνσης «Από» του μηνύματος ηλε.ταχυδρομείου στο $CFG->dataroot/dkim/[domain]/[selector].private, τότε το μήνυμα θα υπογραφεί. Στις περισσότερες περιπτώσεις (για παράδειγμα, εάν το allowedemaildomains, δηλ. ΕπιτρεπόμενοιΤομείς είναι κενό), απαιτείται μόνο ένα πιστοποιητικό στο <pre>{$a->path}</pre>. Για περισσότερες λεπτομέρειες εγκατάστασης, ανατρέξτε στην τεκμηρίωση για <a href="{$a->docs}">Ρύθμιση ηλε.ταχυδρομείου</a>.';
$string['emaildkimselector'] = 'Επιλογέας DKIM';
$string['emailfromvia'] = 'Πληροφορίες μήνυμα ηλε.ταχυδρομείου μέσω';
$string['emailheaders'] = 'Κεφαλίδες ηλε.ταχυδρομείου';
$string['emailsubjectprefix'] = 'Κείμενο προθέματος του θέματος μηνύματος ηλε.ταχυδρομείου';
$string['emoticonalt'] = 'Εναλλακτικό κείμενο';
$string['emoticoncomponent'] = 'Στοιχείο εικόνας';
$string['emoticonimagename'] = 'Όνομα εικόνας';
$string['emoticons'] = 'Εικονίδια διάθεσης';
$string['emoticons_desc'] = 'Αυτή η φόρμα ορίζει τα εικονίδια διάθεσης (emoticons, φατσούλες, smileys) που χρησιμοποιούνται στον ιστότοπό σας.
Για να αφαιρέσετε μια γραμμή από τον πίνακα, αποθηκεύστε τη φόρμα με μια κενή τιμή σε οποιοδήποτε από τα απαιτούμενα πεδία.
Για να καταχωρήσετε ένα νέο εικονίδιο διάθεσης, συμπληρώστε τα πεδία στην τελευταία κενή γραμμή.
Για να επαναρχικοποιήσετε όλα τα πεδία στις προεπιλεγμένες τιμές, ακολουθήστε τον παραπάνω σύνδεσμο.

* Κείμενο (απαιτείται) - Αυτό το κείμενο θα αντικατασταθεί με την εικόνα του εικονιδίου διάθεσης. Πρέπει να έχει μήκος τουλάχιστον δύο χαρακτήρων.
* Όνομα εικόνας (απαιτείται) - Το όνομα αρχείου εικόνας του εικονιδίου διάθεσης χωρίς την επέκταση, σε σχέση με το φάκελο pix.
* Στοιχείο εικόνας (απαιτείται) - Το στοιχείο που παρέχει το εικονίδιο.
* Εναλλακτικό κείμενο (προαιρετικό) - Αναγνωριστικό συμβολοσειράς και στοιχείο του εναλλακτικού κειμένου του εικονιδίου διάθεσης.';
$string['emoticonsreset'] = 'Επαναρχικοποίηση ρυθμίσεων εικονιδίων διάθεσης στις προεπιλεγμένες τιμές';
$string['emoticontext'] = 'Κείμενο';
$string['emptysettingvalue'] = 'Κενό';
$string['enableanalytics'] = 'Αναλυτική';
$string['enableblogs'] = 'Ενεργοποίηση ιστολογίων';
$string['enablecalendarexport'] = 'Ενεργοποίηση εξαγωγής ημερολογίου';
$string['enablecomments'] = 'Ενεργοποίηση σχολίων';
$string['enablecourserelativedates'] = 'Ενεργοποίηση σχετικών ημερομηνιών μαθημάτων';
$string['enablecourserelativedates_desc'] = 'Να επιτρέπεται η ρύθμιση των μαθημάτων ώστε να εμφανίζονται ημερομηνίες σχετικές με την ημερομηνία έναρξης του χρήστη στο μάθημα.';
$string['enablecourserequests'] = 'Ενεργοποίηση αιτήσεων δημιουργίας μαθήματος';
$string['enabled'] = 'Ενεργοποιημένο';
$string['enableglobalsearch'] = 'Ενεργοποίηση καθολικής αναζήτησης';
$string['enableglobalsearch_desc'] = 'Εάν ενεργοποιηθεί, τα δεδομένα θα ευρετηριαστούν και θα συγχρονιστούν από μια χρονοπρογραμματισμένη εργασία.';
$string['enablegravatar'] = 'Ενεργοποίηση Gravatar';
$string['enablegravatar_help'] = 'Όταν ενεργοποιηθεί, το Moodle θα προσπαθήσει να βρει και να φέρει μια εικόνα προφίλ χρήστη από το Gravatar αν ο χρήστης δεν έχει ανεβάσει μια εικόνα.';
$string['enablemobilewebservice'] = 'Ενεργοποίηση υπηρεσιών ιστού για συσκευές κινητής τηλεφωνίας';
$string['enablerecordcache'] = 'Ενεργοποίηση κρυφής μνήμης εγγραφής';
$string['enablerssfeeds'] = 'Ενεργοποίηση τροφοδοσιών RSS';
$string['enablesearchareas'] = 'Ενεργοποίηση περιοχών αναζήτησης';
$string['enablestats'] = 'Ενεργοποίηση στατιστικών';
$string['enabletrusttext'] = 'Ενεργοποίηση έμπιστου περιεχομένου';
$string['enableuserfeedback'] = 'Ενεργοποίηση ανατροφοδότησης σχετικά με αυτό το λογισμικό';
$string['enableuserfeedback_desc'] = 'Εάν ενεργοποιηθεί, ένας σύνδεσμος «Δώστε ανατροφοδότηση σχετικά με αυτό το λογισμικό» εμφανίζεται στο υποσέλιδο ώστε οι χρήστες να δώσουν ανατροφοδότηση σχετικά με το λογισμικό Moodle στο Moodle HQ. Εάν έχει οριστεί η επιλογή «Υπενθύμιση επόμενης ανατροφοδότησης», εμφανίζεται επίσης στον χρήστη μια υπενθύμιση στο Ταμπλό στο καθορισμένο διάστημα. Η ρύθμιση «Υπενθύμιση επόμενης ανατροφοδότησης» σε «Ποτέ» απενεργοποιεί την υπενθύμιση του Ταμπλό, ενώ αφήνει τον σύνδεσμο «Δώστε ανατροφοδότηση σχετικά με αυτό το λογισμικό» στο υποσέλιδο.';
$string['enablewebservices'] = 'Ενεργοποίηση υπηρεσιών ιστού';
$string['enablewsdocumentation'] = 'Τεκμηρίωση υπηρεσιών ιστού';
$string['encryptedpassword_edit'] = 'Εισαγωγή νέας τιμής';
$string['encryptedpassword_set'] = '(Ορισμένο και κρυπτογραφημένο)';
$string['enroladminnewcourse'] = 'Αυτόματη εγγραφή διαχειριστή σε νέα μαθήματα';
$string['enroladminnewcourse_help'] = 'Όταν ένας διαχειριστής προσθέτει ένα νέο μάθημα, πρέπει να εγγραφεί αυτόματα και να του ανατεθεί ο ρόλος του δημιουργού στο νέο μάθημα;';
$string['enrolinstancedefaults'] = 'Προεπιλογές παραδείγματος εγγραφής';
$string['enrolinstancedefaults_desc'] = 'Προεπιλεγμένες ρυθμίσεις εγγραφής σε νέα μαθήματα.';
$string['enrolmultipleusers'] = 'Εγγραφή χρηστών';
$string['entitytasklog'] = 'Καταγραφές εργασίας';
$string['environment'] = 'Περιβάλλον';
$string['environmenterrortodo'] = 'Πρέπει να λύσετε όλα τα προβλήματα περιβάλλοντος (σφάλματα) που εντοπίστηκαν παραπάνω για να συνεχίσετε την εγκατάσταση του Moodle!';
$string['environmenterrorupgrade'] = 'Προσοχή: Πρέπει να λύσετε όλα τα προβλήματα περιβάλλοντος (σφάλματα) που εντοπίστηκαν παραπάνω για να συνεχίσετε την αναβάθμιση του Moodle! Η αναβάθμιση χωρίς την επιδιόρθωση των απαιτούμενων μπορεί να προκαλέσει καταστροφή δεδομένων. Σίγουρα θέλετε να συνεχίσετε με την αναβάθμιση;';
$string['environmentmariadbwrongdbtype'] = 'Λάθος τύπος βάσης δεδομένων <code>$CFG->dbtype</code>: πρέπει να τον αλλάξετε στο αρχείο <code>config.php</code>, από «<code>mysql</code>» σε «<code>mariadb</code>».';
$string['environmentmustfixsetting'] = 'Η ρύθμιση της PHP πρέπει να αλλαχθεί.';
$string['environmentok'] = 'Το περιβάλλον του εξυπηρετητή ικανοποιεί τις ελάχιστες απαιτήσεις.';
$string['environmentrecommendcustomcheck'] = 'αν αυτή η δοκιμασία αποτύχει, αυτό δείχνει ένα πιθανό πρόβλημα';
$string['environmentrecommendinstall'] = 'προτείνεται να εγκατασταθεί και να ενεργοποιηθεί για καλύτερα αποτελέσματα';
$string['environmentrecommendversion'] = 'συνιστάται η έκδοση {$a->needed} ενώ εσείς έχετε την {$a->current}';
$string['environmentrequirecustomcheck'] = 'αυτή η δοκιμασία πρέπει να είναι επιτυχής';
$string['environmentrequireinstall'] = 'απαιτείται να εγκατασταθεί και να ενεργοποιηθεί';
$string['environmentrequireversion'] = 'απαιτείται η έκδοση {$a->needed} ενώ εσείς έχετε την {$a->current}';
$string['environmentsettingok'] = 'ανιχνεύθηκε η συνιστώμενη ρύθμιση';
$string['environmentshouldfixsetting'] = 'Η ρύθμιση PHP θα έπρεπε να αλλαχθεί.';
$string['environmentxmlerror'] = 'Σφάλμα κατά την ανάγνωση δεδομένων περιβάλλοντος ({$a->error_code})';
$string['errordeletingconfig'] = 'Συνέβη κάποιο σφάλμα κατά τη διαγραφή αρχείων ρυθμίσεων του πρόσθετου «{$a}».';
$string['errorsetting'] = 'Δεν ήταν δυνατή η αποθήκευση της ρύθμισης:';
$string['errorwithsettings'] = 'Ορισμένες ρυθμίσεις δεν άλλαξαν λόγω σφάλματος.';
$string['eventshandlersinuse'] = 'Τα ακόλουθα πρόσθετα στο σύστημά σας χρησιμοποιούν χειριστές (handlers) του Events 1 API: «{$a}» που έχουν καταργηθεί. Παρακαλούμε ενημερώστε τα ώστε να χρησιμοποιούν το Events 2 API. Δείτε https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Οποιοσδήποτε έχει τη δυνατότητα «{$a}»';
$string['exceptions'] = 'εξαιρέσεις';
$string['execpathnotallowed'] = 'Ορισμός εκτελέσιμων και τοπικών διαδρομών απενεργοποιημένος στο config.php';
$string['experimental'] = 'Πειραματικά';
$string['experimentalsettings'] = 'Πειραματικές ρυθμίσεις';
$string['extendedusernamechars'] = 'Να επιτρέπονται εκτεταμένοι (extended) χαρακτήρες στα ονόματα χρηστών';
$string['extramemorylimit'] = 'Έξτρα PHP όριο μνήμης';
$string['fatalsessionautostart'] = '<p>Ανιχνεύθηκε σοβαρό λάθος ρυθμίσεων. Παρακαλούμε ενημερώστε το διαχειριστή του εξυπηρετητή σας.</p><p> Για σωστή λειτουργία, το Moodle απαιτεί ο διαχειριστής να αλλάξει κάποιες ρυθμίσεις της PHP.</p><p>Το <code>session.auto_start</code> πρέπει να είναι <code>off</code>.</p><p>Αυτή η ρύθμιση αλλάζει με επεξεργασία του αρχείου <code>php.ini</code>, ρυθμίσεις στον εξυπηρετητή ιστού Apache/IIS <br />ή του αρχείου <code>.htaccess</code> στον εξυπηρετητή.</p>';
$string['feedbacksettings'] = 'Ρυθμίσεις ανατροφοδότησης';
$string['fileconversioncleanuptask'] = 'Καθαρισμός προσωρινών εγγραφών για μετατροπές αρχείων';
$string['filecreated'] = 'Δημιουργία νέου αρχείου';
$string['filescleanupperiod'] = 'Εκκαθάριση αρχείων δεξαμενής απορριμμάτων';
$string['filescleanupperiod_help'] = 'Πόσο συχνά απομακρύνονται τα αρχεία από την δεξαμενή απορριμμάτων. Αυτά είναι αρχεία που συσχετίζονται με ένα πλαίσιο συμφραζομένων που δεν υπάρχει πια, π.χ. όταν ένα μάθημα διαγράφεται. Παρακαλούμε σημειώστε: Αυτή η ρύθμιση μπορεί να έχει ως αποτέλεσμα να λείπουν αρχεία από ένα μάθημα για το οποίο δημιουργήθηκε αντίγραφο ασφαλείας, διαγράφηκε το αρχικό και μετά έγινε επαναφορά του αντιγράφου, εάν η ρύθμιση «Συμπερίληψη αρχείων» (backup_auto_files) στις «Ρυθμίσεις αυτόματων αντιγράφων ασφαλείας» είναι απενεργοποιημένη.';
$string['filesizeunits'] = 'μονάδες μεγέθους αρχείου';
$string['filestoredin'] = 'Αποθήκευση αρχείου στο φάκελο :';
$string['filestoredinhelp'] = 'Πού θα αποθηκευτεί το αρχείο';
$string['filterall'] = 'Φιλτράρισε όλες τις συμβολοσειρές';
$string['filtermatchoneperpage'] = 'Αντιστοιχία φιλτραρίσματος μία ανά σελίδα';
$string['filtermatchonepertext'] = 'Αντιστοιχία φιλτραρίσματος μία ανά κείμενο';
$string['filters'] = 'Φίλτρα';
$string['filtersettings'] = 'Ρυθμίσεις φίλτρων';
$string['filtersettingsgeneral'] = 'Γενικές ρυθμίσεις φίλτρων';
$string['filteruploadedfiles'] = 'Φιλτράρισε τα ανεβασμένα αρχεία';
$string['forceclean'] = 'Καθαρισμός περιεχομένου παντού';
$string['forceclean_desc'] = 'Το περιεχόμενο που προστέθηκε στον ιστότοπο κανονικά καθαρίζεται πριν προβληθεί, για να αφαιρεθεί οτιδήποτε μπορεί να είναι απειλή για την ασφάλεια. Ωστόσο, το περιεχόμενο δεν καθαρίζεται σε συγκεκριμένα σημεία, όπως περιγραφές δραστηριότητας, πόρους σελίδας ή μπλοκ HTML ώστε να επιτρέπεται η προσθήκη σεναρίων, πολυμέσων, ένθετων πλαισίων κλπ. Εάν αυτή η ρύθμιση είναι ενεργοποιημένη, ΟΛΟ το περιεχόμενο θα καθαριστεί. Αυτό μπορεί να έχει ως αποτέλεσμα το υπάρχον περιεχόμενο να μην εμφανίζεται πλέον σωστά.';
$string['forcelogin'] = 'Υποχρεωτική σύνδεση χρηστών (απαγόρευση guest επισκεπτών)';
$string['forceloginforprofileimage'] = 'Υποχρεωτική σύνδεση χρηστών για να δουν εικόνες χρηστών';
$string['forceloginforprofileimage_help'] = 'Εάν ενεργοποιηθεί, οι χρήστες πρέπει να συνδεθούν για να δουν εικόνες προφίλ χρήστη και η προεπιλεγμένη εικόνα χρήστη θα χρησιμοποιηθεί σε όλες τις ειδοποιήσεις ηλε.ταχυδρομείου.';
$string['forceloginforprofiles'] = 'Υποχρεωτική σύνδεση χρηστών για προφίλ';
$string['forcetimezone'] = 'Υποχρεωτική ζώνη ώρας';
$string['formatuninstallwithcourses'] = 'Υπάρχουν {$a->count} μαθήματα σε μορφή {$a->format}. Η μορφή τους θα αλλάξει σε {$a->defaultformat} (προεπιλεγμένη μορφή για αυτόν τον ιστότοπο). Ενδέχεται να χαθούν ορισμένα δεδομένα για τη συγκεκριμένη μορφή. Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
$string['frontpage'] = 'Πρώτη σελίδα';
$string['frontpagebackup'] = 'Αντίγραφο ασφαλείας πρώτης σελίδας';
$string['frontpagedefaultrole'] = 'Προεπιλεγμένος ρόλος πρώτης σελίδας';
$string['frontpagefilters'] = 'Φίλτρα πρώτης σελίδας';
$string['frontpageloggedin'] = 'Στοιχεία πρώτης σελίδας όταν υπάρχει σύνδεση';
$string['frontpageoverrides'] = 'Παρακάμψεις δικαιωμάτων πρώτης σελίδας';
$string['frontpagequestions'] = 'Ερωτήσεις πρώτης σελίδας';
$string['frontpagerestore'] = 'Επαναφορά πρώτης σελίδας';
$string['frontpageroles'] = 'Ρόλοι πρώτης σελίδας';
$string['frontpagesettings'] = 'Ρυθμίσεις πρώτης σελίδας';
$string['fullnamedisplay'] = 'Μορφότυπος πλήρους ονόματος';
$string['fullnamedisplayprivate'] = 'Μορφότυπος πλήρους ονόματος - ιδιωτικό';
$string['gdrequired'] = 'Η επέκταση GD απαιτείται πλέον από το Moodle για την μετατροπή εικόνας.';
$string['generalsettings'] = 'Γενικές ρυθμίσεις';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Πηγή διευθύνσεων συνδεδεμένων IP';
$string['globalsearch'] = 'Καθολική αναζήτηση';
$string['globalsearchmanage'] = 'Διαχείριση καθολικής αναζήτησης';
$string['googlemapkey3'] = 'Κλειδί Google Maps API V3';
$string['googlemapkey3_help'] = 'Πρέπει να εισάγετε ένα ειδικό κλειδί για να χρησιμοποιήσετε τα Google Maps για απεικόνιση αναζήτησης διεύθυνσης IP. Μπορείτε να λάβετε δωρεάν το κλειδί στη διεύθυνση <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Πήγαινε στην πρώτη συμβολοσειρά που λείπει';
$string['gradebook'] = 'Βαθμολόγιο';
$string['gradebookroles'] = 'Βαθμολογημένοι ρόλοι';
$string['gradeexport'] = 'Μέθοδοι εξαγωγής πρωταρχικών βαθμών';
$string['gravatardefaulturl'] = 'Διεύθυνση URL της προεπιλεγμένης εικόνας Gravatar';
$string['gravatardefaulturl_help'] = 'Το Gravatar χρειάζεται μια προεπιλεγμένη εικόνα για εμφάνιση, αν δεν μπορεί να βρει μια εικόνα για ένα συγκεκριμένο χρήστη. Εισάγετε ένα πλήρες URL για μια εικόνα. Αν αφήσετε αυτή τη ρύθμιση κενή, το Moodle θα προσπαθήσει να χρησιμοποιήσει την πιο κατάλληλη προεπιλεγμένη εικόνα για τη σελίδα που βλέπετε. Σημειώστε, επίσης, ότι το Gravatar έχει μια σειρά από κώδικες που μπορούν να χρησιμοποιηθούν για τη <a href="https://en.gravatar.com/site/implement/images/#default-image">δημιουργία προεπιλεγμένων εικόνων</a>.';
$string['groupenrolmentkeypolicy'] = 'Πολιτική κλειδιού εγγραφής ομάδας';
$string['groupenrolmentkeypolicy_desc'] = 'Αν ενεργοποιηθεί, τα κλειδιά εγγραφής ομάδας θα ελέγχονται σε σχέση με την πολιτική κωδικού πρόσβασης όπως καθορίζεται στις παραπάνω ρυθμίσεις.';
$string['guestroleid'] = 'Ρόλος επισκέπτη';
$string['guestroleid_help'] = 'Ο ρόλος αυτός εκχωρείται αυτόματα στον χρήστη guest (επισκέπτης). Εκχωρείται επίσης προσωρινά στους μη εγγεγραμμένους χρήστες που εισέρχονται στο μάθημα μέσω πρόσθετου εγγραφής επισκεπτών στο μάθημα.';
$string['h5pgetcontenttypestask'] = 'Λήψη διαθέσιμων τύπων περιεχομένου H5P από το h5p.org';
$string['helpadminseesall'] = 'Στο ημερολόγιο του ιστοτόπου, οι διαχειριστές βλέπουν και φιλτράρουν τα γεγονότα από όλα τα ημερολόγια μαθημάτων ή απλά από τα μαθήματα στα οποία είναι εγγεγραμμένοι; Ανεξάρτητα από την επιλογή αυτή, οι διαχειριστές θα είναι πάντοτε σε θέση να διαχειρίζονται τα γεγονότα για κάθε ημερολόγιο μαθημάτων πλοηγούμενοι πρώτα στο μάθημα και μετά με άμεση πρόσβαση στο ημερολόγιο μαθημάτων.';
$string['helpcalendarcustomexport'] = 'Ενεργοποιήστε την επιλογή εξαγωγής προσαρμοσμένου εύρους ημερομηνιών στις εξαγωγές ημερολογίου. Οι εξαγωγές ημερολογίου πρέπει να είναι ενεργοποιημένες πριν από την έναρξη ισχύος.';
$string['helpexportlookahead'] = 'Πόσες μέρες στο μέλλον ψάχνει το ημερολόγιο για γεγονότα κατά την εξαγωγή για την προσαρμοσμένη επιλογή εξαγωγής;';
$string['helpexportlookback'] = 'Πόσες μέρες στο παρελθόν ψάχνει το ημερολόγιο για γεγονότα κατά την εξαγωγή για την προσαρμοσμένη επιλογή εξαγωγής;';
$string['helpforcetimezone'] = 'Μπορείτε να επιτρέψετε στους χρήστες να επιλέξουν μόνοι τους τη ζώνη ώρας τους, ή να επιβάλετε μια υποχρεωτική ζώνη ώρας σε όλους.';
$string['helpshowicalsource'] = 'Εάν ενεργοποιηθεί, το όνομα εγγραφής και ο σύνδεσμος θα εμφανιστούν για γεγονότα που εισήχθησαν στο iCal.';
$string['helpsitemaintenance'] = 'Για αναβαθμίσεις και διάφορες άλλες εργασίες';
$string['helpstartofweek'] = 'Με ποιά ημέρα ξεκινά η εβδομάδα στο ημερολόγιο;';
$string['helpupcominglookahead'] = 'Πόσες μέρες στο μέλλον αναζητά το ημερολόγιο επικείμενα γεγονότα;';
$string['helpupcomingmaxevents'] = 'Μέγιστο πλήθος επικείμενων γεγονότων που θα προβάλλονται στους χρήστες';
$string['helpweekenddays'] = 'Ποιές ημέρες θεωρούνται Σαββατοκύριακο; (εμφανίζονται με διαφορετικό χρώμα)';
$string['hiddenuserfields'] = 'Απόκρυψη πεδίων χρηστών';
$string['hidefromall'] = 'Απόκρυψη από όλους τους χρήστες';
$string['hidefromnone'] = 'Απόκρυψη από κανέναν';
$string['hidefromstudents'] = 'Απόκρυψη από τους μαθητές';
$string['hostname'] = 'Όνομα κεντρικού Η/Υ';
$string['htmleditor'] = 'Επεξεργαστής HTML';
$string['htmleditorsettings'] = 'Ρυθμίσεις επεξεργαστή HTML';
$string['htmlsettings'] = 'Ρυθμίσεις HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Ασφάλεια HTTP';
$string['iconvrequired'] = 'Απαιτείται εγκατάσταση επέκτασης ICONV.';
$string['igbinary322buggyversion'] = 'Η επέκταση php-igbinary που είναι εγκατεστημένη στον ιστότοπο μπορεί να οδηγήσει σε προβλήματα κατά την εκτέλεση με την PHP 7.2. Συνιστάται είτε να κάνετε αναβάθμιση σε php-igbinary 3.2.5 ή μεταγενέστερη, είτε εναλλακτικά να αναβαθμίσετε σε PHP 7.3 ή μεταγενέστερη.';
$string['ignore'] = 'Αγνόηση';
$string['includemoduleuserdata'] = 'Συμπερίληψη των δεδομένων των χρηστών των αρθρωμάτων';
$string['incompatibleblocks'] = 'Μη-συμβατά μπλοκ';
$string['incompleteunicodesupport'] = 'Η τρέχουσα ρύθμιση MySQL ή MariaDB χρησιμοποιεί «utf8». Αυτό το σετ χαρακτήρων δεν υποστηρίζει χαρακτήρες τεσσάρων byte που περιλαμβάνουν κάποια εμότζι. Η προσπάθεια χρήσης αυτών των χαρακτήρων θα οδηγήσει σε σφάλμα κατά την ενημέρωση μιας εγγραφής και θα χαθούν όλες οι πληροφορίες που αποστέλλονται στη βάση δεδομένων. Παρακαλούμε αλλάξτε τις ρυθμίσεις σας στο «utf8mb4». Ανατρέξτε στην τεκμηρίωση για πλήρεις λεπτομέρειες.';
$string['indexdata'] = 'Δεδομένα ευρετηρίου';
$string['indexinginfo'] = 'Ο συνιστώμενος τρόπος για να ευρετηριάσετε τα περιεχόμενα του ιστοτόπου σας είναι να χρησιμοποιήσετε την χρονοπρογραμματισμένη εργασία «Ευρετηρίαση καθολικής αναζήτησης».';
$string['installhijacked'] = 'Η εγκατάσταση θα πρέπει να ολοκληρωθεί μέσω της αρχικής διεύθυνσης IP, λυπούμαστε.';
$string['installsessionerror'] = 'Αδυναμία αρχικοποίησης της συνόδου PHP. Παρακαλούμε, επαληθεύστε ότι ο περιηγητής σας αποδέχεται cookies.';
$string['intlrecommended'] = 'Η επέκταση Intl χρησιμοποιείται για τη βελτίωση της υποστήριξης της διεθνοποίησης, όπως ταξινόμηση λαμβανομένης υπόψιν της γλώσσας.';
$string['intlrequired'] = 'Η επέκταση Intl απαιτείται για τη βελτίωση της υποστήριξης της διεθνοποίησης, όπως ταξινόμηση λαμβανομένης υπόψιν της γλώσσας και διεθνή ονόματα τομέων.';
$string['invalidagedigitalconsent'] = 'Η ηλικία ψηφιακής συγκατάθεσης δεν είναι έγκυρη: {$a}';
$string['invalidforgottenpasswordurl'] = 'Η ξεχασμένη διεύθυνση URL δεν είναι έγκυρη';
$string['invalidsection'] = 'Άκυρη ενότητα.';
$string['invalidthemepreset'] = 'Το επιλεγμένο αρχείο προρύθμισης δεν είναι συμβατό με αυτό το αισθητικό θέμα. Το σφάλμα μεταγλώττισης SCSS ήταν: «{$a}»';
$string['invaliduserchangeme'] = 'Το όνομα χρήστη «changeme» είναι δεσμευμένο. Δεν μπορείτε να δημιουργήσετε λογαριασμό με αυτό.';
$string['ipblocked'] = 'Ο ιστότοπος αυτός δεν είναι διαθέσιμος αυτή τη στιγμή.';
$string['ipblocker'] = 'Αποκλεισμός διεύθυνσης IP';
$string['ipblockersyntax'] = 'Εισάγετε κάθε καταχώρηση σε μια γραμμή. Έγκυρες καταχωρήσεις είναι:
<ul>
<li>είτε πλήρης διεύθυνση IP (όπως <b>192.168.10.1</b>) που αντιστοιχεί σε έναν μόνο κεντρικό υπολογιστή</li>
</li>ή μερική διεύθυνση (όπως <b>192.168</b>) που αντιστοιχεί σε οποιαδήποτε διεύθυνση ξεκινά με αυτούς τους αριθμούς</li>
</li>ή σημειογραφία CIDR (όπως <b>231.54.211.0/20</b>)</li>
</li>ή ένα εύρος διευθύνσεων IP (όπως <b>231.3.56.10-20</b>) όπου το εύρος ισχύει για το τελευταίο τμήμα της διεύθυνσης.
</ul>
Τα ονόματα τομέα κειμένου (όπως «tomeas.com») δεν υποστηρίζονται. Οι κενές γραμμές, και κείμενο μετά από τον χαρακτήρα «#» αγνοούνται.';
$string['iplookup'] = 'Αναζήτηση διεύθυνσης IP';
$string['iplookupgeoplugin'] = 'Η υπηρεσία <a href="https://www.geoplugin.com">geoPlugin</a> χρησιμοποιείται προς το παρόν για αναζήτηση γεωγραφικών πληροφοριών. Για πιο ακριβή αποτελέσματα συνιστάται η εγκατάσταση ενός τοπικού αντιγράφου της βάσης δεδομένων MaxMind GeoLite.';
$string['iplookupinfo'] = 'Προεπιλεγμένα, το Moodle χρησιμοποιεί τον δωρεάν/ελεύθερο εντός σύνδεσης εξυπηρετητή NetGeo (The Internet Geographic Database) για την εύρεση τοποθεσιών διευθύνσεων IP. Δυστυχώς η βάση αυτή δε συντηρείται πλέον και μπορεί να επιστρέψει <em>λανθασμένα</em> δεδομένα. Συνιστάται η εγκατάσταση ενός τοπικού αντιγράφου της δωρεάν/ελεύθερης βάσης δεδομένων GeoLite City από τη MaxMind.<br /> Η τοποθεσία της διεύθυνσης IP προβάλλεται σε έναν απλό χάρτη, χρησιμοποιώντας το Google Maps. Σημειώστε πως χρειάζεται να έχετε ένα λογαριασμό Google και να κάνετε αίτηση για ένα κλειδί Google Maps API ώστε να ενεργοποιήσετε τους διαδραστικούς χάρτες.';
$string['iplookupmaxmindnote'] = 'Αυτό το προϊόν περιλαμβάνει δεδομένα GeoLite2 που δημιουργήθηκαν από την MaxMind και διατίθενται από το <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Διαπιστώθηκε ότι ο ιστότοπός σας χρησιμοποιεί έναν προσαρμοσμένο κατάλογο διαχειριστή. Αυτή η δυνατότητα δεν υποστηρίζεται πλέον και θα καταργηθεί μετά το Moodle 4.2.';
$string['ishttpswarning'] = 'Εντοπίστηκε ότι ο ιστότοπός σας δεν είναι ασφαλής καθώς δεν χρησιμοποιεί HTTPS. Συνιστάται ένθερμα η μετεγκατάσταση (μεταφορά/μετατροπή) του ιστοτόπου σας σε HTTPS για αυξημένη ασφάλεια και βελτιωμένη ολοκλήρωση με άλλα συστήματα.';
$string['keeptagnamecase'] = 'Διατήρηση κεφαλαίων στο όνομα ετικέτας';
$string['lang'] = 'Προεπιλεγμένη γλώσσα';
$string['langcache'] = 'Χρήση κρυφής μνήμης για το μενού γλώσσας';
$string['langcache_desc'] = 'Χρήση κρυφής μνήμης για το μενού γλώσσας. Εάν ενεργοποιηθεί, η λίστα των διαθέσιμων μεταφράσεων βρίσκεται στην κρυφή μνήμη. Η κρυφή μνήμη ανανεώνεται αυτόματα κατά την εγκατάσταση ή διαγραφή ενός γλωσσικού πακέτου μέσω του ενσωματωμένου εργαλείου διαχείρισης γλωσσικών πακέτων. Αν εγκαταστήσετε ένα νέο γλωσσικό πακέτο χειροκίνητα, θα πρέπει να χρησιμοποιήσετε το χαρακτηριστικό/δυνατότητα «Εκκαθάριση όλων των κρυφών μνημών» για να ανανεώσετε την λίστα της κρυφής μνήμης.';
$string['langlist'] = 'Διαθέσιμες γλώσσες στο μενού επιλογής γλώσσας';
$string['langmenu'] = 'Εμφάνιση του μενού επιλογής γλώσσας';
$string['langmenuinsecurelayout'] = 'Εμφάνιση μενού γλωσσών σε ασφαλή διάταξη';
$string['langmenuinsecurelayout_desc'] = 'Εάν ενεργοποιηθεί, ένας χρήστης θα μπορεί να αλλάξει τη γλώσσα του όταν προσπαθεί ένα κουίζ ή άλλη δραστηριότητα χρησιμοποιώντας ασφαλή διάταξη.';
$string['langpackwillbeupdated'] = 'ΣΗΜΕΙΩΣΗ: Το Moodle θα προσπαθήσει να κάνει λήψη ενημερώσεων για το πακέτο γλώσσας κατά την αναβάθμιση.';
$string['langstringcache'] = 'Χρήση κρυφής μνήμης για όλες τις συμβολοσειρές γλώσσας';
$string['languagesettings'] = 'Ρυθμίσεις γλώσσας';
$string['latinexcelexport'] = 'Κωδικοποίηση eExcel';
$string['legacyfilesaddallowed'] = 'Να επιτρέπεται η προσθήκη σε αρχεία μαθήματος παλαιότερου τύπου';
$string['legacyfilesaddallowed_help'] = 'Αν ένα μάθημα έχει αρχεία μαθήματος παλαιότερου τύπου, να επιτρέπεται η προσθήκη νέων αρχείων και φακέλων σε αυτό.';
$string['legacyfilesinnewcourses'] = 'Αρχεία μαθημάτων παλαιότερου τύπου σε νέα μαθήματα';
$string['legacyfilesinnewcourses_help'] = 'Από προεπιλογή, οι περιοχές αρχείων μαθημάτων παλαιότερου τύπου είναι διαθέσιμες μόνο σε αναβαθμισμένα μαθήματα. Παρακαλούμε έχετε υπόψη ότι ορισμένα χαρακτηριστικά όπως δημιουργία και επαναφορά αντιγράφου ασφαλείας δραστηριότητας, δεν είναι συμβατά με αυτή τη ρύθμιση.';
$string['libcurlwarning'] = 'Έχει εντοπιστεί ότι το libcurl δεν υποστηρίζει CURLOPT_PROTOCOL. Συνιστάται για λόγους ασφαλείας η εγκατάσταση ενός ενημερωμένου libcurl.';
$string['licensesettings'] = 'Ρυθμίσεις άδειας';
$string['linkadmincategories'] = 'Κατηγορίες διαχείρισης ως σύνδεσμοι';
$string['linkadmincategories_help'] = 'Εάν ενεργοποιηθεί, οι κατηγορίες διαχειριστικών ρυθμίσεων θα εμφανιστούν ως σύνδεσμοι στην πλοήγηση και θα οδηγούν στις σελίδες κατηγοριών διαχείρισης.';
$string['loading'] = 'Φόρτωση';
$string['localetext'] = 'Τοπικές ρυθμίσεις ιστοτόπου';
$string['localstringcustomization'] = 'Τοπική προσαρμογή συμβολοσειρών';
$string['location'] = 'Τοποθεσία';
$string['locationsettings'] = 'Ρυθμίσεις τοποθεσίας';
$string['locked'] = 'Κλειδωμένο';
$string['lockoutduration'] = 'Διάρκεια κλειδώματος λογαριασμού';
$string['lockoutduration_desc'] = 'Ο κλειδωμένος λογαριασμός ξεκλειδώνει αυτόματα μετά από αυτή τη διάρκεια.';
$string['lockoutemailbody'] = 'Ο λογαριασμός σας με όνομα χρήστη {$a->username} στον ιστότοπο «{$a->sitename}» κλειδώθηκε μετά από πολλές μη έγκυρες προσπάθειες σύνδεσης. <br/> Για να ξεκλειδώσετε τον λογαριασμό αμέσως, μεταβείτε στην ακόλουθη διεύθυνση {$a->link}. Στα περισσότερα προγράμματα ηλε.ταχυδρομείου, αυτό θα πρέπει να εμφανίζεται ως μπλε σύνδεσμος όπου απλά μπορείτε να κάνετε κλικ. Αν αυτό δεν λειτουργήσει, τότε αντιγράψτε και επικολλήστε τη διεύθυνση στη γραμμή διευθύνσεων στο επάνω μέρος του παραθύρου του περιηγητή σας. Αν χρειαστείτε βοήθεια, παρακαλούμε επικοινωνήστε με τον διαχειριστή του ιστοτόπου, {$a->admin}.';
$string['lockoutemailsubject'] = 'Ο λογαριασμός σας στο {$a} έχει κλειδωθεί';
$string['lockouterrorunlock'] = 'Μη έγκυρες πληροφορίες ξεκλειδώματος λογαριασμού.';
$string['lockoutthreshold'] = 'Όριο κλειδώματος λογαριασμού';
$string['lockoutthreshold_desc'] = 'Επιλέξτε τον αριθμό αποτυχημένων προσπαθειών σύνδεσης που θα έχει ως αποτέλεσμα το κλείδωμα λογαριασμού. Αυτό το χαρακτηριστικό/δυνατότητα υπάρχει περίπτωση να χρησιμοποιηθεί καταχρηστικά για επιθέσεις άρνησης παροχής υπηρεσιών.';
$string['lockoutwindow'] = 'Παράθυρο παρατήρησης κλειδώματος λογαριασμού';
$string['lockoutwindow_desc'] = 'Ο χρόνος παρατήρησης για το όριο κλειδώματος, αν δεν υπάρχουν αποτυχημένες προσπάθειες, ο μετρητής ορίου, μετά από αυτό το χρόνο, επαναρχικοποιείται (μηδενίζεται).';
$string['lockrequestcategory'] = 'Παρεμπόδιση επιλογής κατηγορίας';
$string['log'] = 'Καταγραφές';
$string['logguests'] = 'Καταγραφή πρόσβασης επισκέπτη';
$string['logguests_help'] = 'Αυτή η ρύθμιση επιτρέπει την καταγραφή ενεργειών από λογαριασμό επισκέπτη και μη συνδεδεμένους χρήστες. Οι ιστότοποι υψηλού προφίλ μπορεί να θέλουν να απενεργοποιήσουν αυτή την καταγραφή για λόγους απόδοσης. Συνιστάται να διατηρήσετε αυτή τη ρύθμιση ενεργοποιημένη σε παραγωγικούς ιστοτόπους.';
$string['logininfoinsecurelayout'] = 'Εμφάνιση συνδεδεμένου χρήστη σε ασφαλή διάταξη';
$string['logininfoinsecurelayout_desc'] = 'Εάν ενεργοποιηθεί, το πλήρες όνομα του συνδεδεμένου χρήστη θα εμφανίζεται στην μπάρα πλοήγησης κατά την προσπάθεια ενός κουίζ ή άλλης δραστηριότητας χρησιμοποιώντας ασφαλή διάταξη.';
$string['loginpageautofocus'] = 'Φόρμα σελίδας σύνδεσης αυτόματης εστίασης';
$string['loginpageautofocus_help'] = 'Η ενεργοποίηση αυτής της επιλογής βελτιώνει την ευχρηστία της σελίδας σύνδεσης, αλλά η αυτόματη εστίαση σε πεδία μπορεί να θεωρηθεί ως πρόβλημα προσβασιμότητας.';
$string['loglifetime'] = 'Διατήρηση των καταγραφών για';
$string['logo'] = 'Λογότυπο';
$string['logo_desc'] = 'Ένα πλήρες λογότυπο θα χρησιμοποιηθεί ως διακόσμηση από μερικά αισθητικά θέματα (όπως τα βασικά θέματα). Αυτή η εικόνα μπορεί να είναι υψηλής ανάλυσης, επειδή θα μειωθεί κατά τη χρήση (και θα αποθηκευτεί σε κρυφή μνήμη για λόγους απόδοσης). Τα λογότυπα που είναι πιο πλατιά σε σχέση με το ύψος, συνήθως δίνουν καλύτερο αποτέλεσμα. Αποδεκτοί μορφότυποι: PNG και JPG.';
$string['logocompact'] = 'Συμπαγές λογότυπο';
$string['logocompact_desc'] = 'Μια συμπαγής έκδοση (μικρότερη, συμπυκνωμένη, περιεκτική) του ίδιου λογότυπου όπως παραπάνω, όπως ένα έμβλημα, περίβλημα ή εικονίδιο. Η εικόνα θα πρέπει να είναι καθαρή ακόμη και σε μικρά μεγέθη. Αποδεκτές μορφές: PNG και JPG.';
$string['logossettings'] = 'Λογότυπα';
$string['logstorenotrequired'] = 'Δεν απαιτείται αποθήκη καταγραφών';
$string['logstoressupported'] = 'Αποθήκη καταγραφών που υποστηρίζει αυτή την αναφορά';
$string['longtimewarning'] = '<b>Παρακαλούμε σημειώστε πως η διαδικασία αυτή μπορεί να πάρει πολύ χρόνο.</b>';
$string['mailnewline'] = 'Χαρακτήρες εισαγωγής γραμμής στο μήνυμα ηλε.ταχυδρομείου';
$string['maintenancemode'] = 'Σε λειτουργία συντήρησης';
$string['maintenancemodeisscheduled'] = 'Αυτός ο ιστότοπος θα μεταβεί σε λειτουργία συντήρησης σε {$a->min} λεπτά {$a->sec} δευτερόλεπτα';
$string['maintenancemodeisscheduledlong'] = 'Αυτός ο ιστότοπος θα μεταβεί σε λειτουργία συντήρησης σε {$a->hour} ώρες {$a->min} λεπτά {$a->sec} δευτερόλεπτα';
$string['maintfileopenerror'] = 'Σφάλμα κατά το άνοιγμα των αρχείων συντήρησης!';
$string['maintinprogress'] = 'Η συντήρηση είναι σε εξέλιξη';
$string['managecontextlock'] = 'Πάγωμα αυτού του πλαισίου';
$string['managecontextlocklocked'] = 'Το πλαίσιο {$a->contextname} και τα υπο-πλαίσια είναι πλέον παγωμένα.';
$string['managecontextlockunlocked'] = 'Το πλαίσιο «{$a->contextname}» και τα υπο-πλαίσια είναι πλέον ξεπαγωμένα.';
$string['managecontextunlock'] = 'Ξεπαγώστε αυτό το πλαίσιο';
$string['managecustomfields'] = 'Διαχείριση τύπων προσαρμοσμένων πεδίων';
$string['manageformats'] = 'Διαχείριση τύπων μαθήματος';
$string['manageformatsgotosettings'] = 'Η προεπιλεγμένη μορφή μπορεί να αλλάξει σε {$a}';
$string['managelang'] = 'Διαχείριση';
$string['manageqbanks'] = 'Διαχείριση πρόσθετων τράπεζας ερωτήσεων';
$string['manageqbehaviours'] = 'Διαχείριση συμπεριφοράς ερωτήσεων';
$string['manageqtypes'] = 'Διαχείριση τύπων ερωτήσεων';
$string['maturity100'] = 'Βήτα';
$string['maturity150'] = 'Υποψήφια διανομή (υποέκδοση)';
$string['maturity200'] = 'Σταθερή έκδοση';
$string['maturity50'] = 'Άλφα';
$string['maturityallowunstable'] = 'Υπόδειξη: Ίσως θέλετε να εκτελέσετε αυτό το σενάριο με την επιλογή --allow-unstable';
$string['maturitycoreinfo'] = 'Ο ιστότοπός σας εκτελεί επί του παρόντος ασταθή κώδικα ανάπτυξης έκδοσης «{$a}».';
$string['maturitycorewarning'] = 'Η έκδοση του Moodle που πρόκειται να εγκαταστήσετε ή να αναβαθμίσετε περιέχει ασταθή «{$a}» κώδικα ανάπτυξης που δεν είναι κατάλληλος για χρήση στους περισσότερους παραγωγικούς ιστοτόπους. Αν δεν το θέλετε αυτό τότε θα πρέπει να βεβαιωθείτε ότι κάνετε ενημέρωση από ένα ΣΤΑΘΕΡΟ κλάδο του κώδικα του Moodle. Δείτε την τεκμηρίωση στο Moodle Docs για περισσότερες λεπτομέρειες.';
$string['maxbytes'] = 'Μέγιστο μέγεθος ανεβασμένου αρχείου';
$string['maxconsecutiveidentchars'] = 'Συνεχόμενοι όμοιοι χαρακτήρες';
$string['maxeditingtime'] = 'Μέγιστος χρόνος τροποποίησης αναρτήσεων';
$string['maxsizeperdownloadcoursefile'] = 'Μέγιστο μέγεθος ανά αρχείο';
$string['maxsizeperdownloadcoursefile_desc'] = 'Το μέγιστο μέγεθος κάθε αρχείου κατά τη λήψη περιεχομένου μαθήματος. Τα αρχεία που υπερβαίνουν αυτό το μέγεθος θα παραλείπονται από τη λήψη.';
$string['maxtimelimit'] = 'Μέγιστο όριο χρόνου';
$string['maxtimelimit_desc'] = 'Για να περιορίσετε το μέγιστο χρόνο εκτέλεσης PHP που θα επιτρέψει το Moodle χωρίς να εμφανιστεί καμία έξοδος, εισάγετε εδώ μια τιμή σε δευτερόλεπτα. 0 σημαίνει ότι χρησιμοποιούνται οι προεπιλεγμένοι περιορισμοί του Moodle. Αν έχετε έναν εξυπηρετητή προσκηνίου με το δικό του όριο χρόνου, ορίστε αυτή την τιμή χαμηλότερα για να λαμβάνετε τα σφάλματα PHP στις καταγραφές. Δεν ισχύει για δέσμες ενεργειών CLI (γραμμής εντολών).';
$string['maxusersperpage'] = 'Μέγιστος αριθμός χρηστών ανά σελίδα';
$string['mbstringrecommended'] = 'Συνιστάται ιδιαίτερα, η εγκατάσταση της προαιρετικής MBSTRING βιβλιοθήκης, για να βελτιωθεί η απόδοση του συστήματος, ειδικά εάν ο ιστότοπός σας υποστηρίζει γλώσσες με μη-λατινικό αλφάβητο.';
$string['mbstringrequired'] = 'Για να βελτιωθεί η απόδοση του ιστοτόπου, απαιτείται η εγκατάσταση της βιβλιοθήκης MBSTRING, ιδιαίτερα εάν ο ιστότοπός σας υποστηρίζει μη λατινικές γλώσσες.';
$string['mediapluginavi'] = 'Ενεργοποίηση φίλτρου .avi';
$string['mediapluginflv'] = 'Ενεργοποίηση φίλτρου .flv';
$string['mediapluginimg'] = 'Ενεργοποίηση αυτόματης ενσωμάτωσης συνδεδεμένων εικόνων';
$string['mediapluginmov'] = 'Ενεργοποίηση φίλτρου .mov';
$string['mediapluginmp3'] = 'Ενεργοποίηση φίλτρου .mp3';
$string['mediapluginmpg'] = 'Ενεργοποίηση φίλτρου .mpg';
$string['mediapluginogg'] = 'Ενεργοποίηση φίλτρου .ogg';
$string['mediapluginogv'] = 'Ενεργοποίηση φίλτρου .ogv';
$string['mediapluginram'] = 'Ενεργοποίηση φίλτρου .ram';
$string['mediapluginrm'] = 'Ενεργοποίηση φίλτρου .rm';
$string['mediapluginrpm'] = 'Ενεργοποίηση φίλτρου .rpm';
$string['mediapluginwmv'] = 'Ενεργοποίηση φίλτρου .wmv';
$string['mediapluginyoutube'] = 'Ενεργοποίηση φίλτρου συνδέσμων YouTube';
$string['messaging'] = 'Ενεργοποίηση ανταλλαγής μηνυμάτων';
$string['messagingallowemailoverride'] = 'Παράκαμψη διεύθυνσης ηλε.ταχυδρομείου ειδοποίησης';
$string['messagingallusers'] = 'Να επιτρέπεται η ανταλλαγή μηνυμάτων σε επίπεδο ιστοτόπου';
$string['messagingcategory'] = 'Μηνύματα';
$string['messagingdefaultpressenter'] = '«Χρήση του πλήκτρου Enter για τέλος εισόδου & αποστολή», ενεργοποιημένη από προεπιλογή';
$string['messagingdeleteallnotificationsdelay'] = 'Διαγραφή όλων των ειδοποιήσεων';
$string['messagingdeletereadnotificationsdelay'] = 'Διαγραφή αναγνωσμένων ειδοποιήσεων';
$string['messagingssettings'] = 'Ρυθμίσεις μηνυμάτων';
$string['minpassworddigits'] = 'Ψηφία';
$string['minpasswordlength'] = 'Μήκος κωδικού πρόσβασης';
$string['minpasswordlower'] = 'Πεζοί χαρακτήρες';
$string['minpasswordnonalphanum'] = 'Μη αλφαριθμητικοί χαρακτήρες';
$string['minpasswordupper'] = 'Κεφαλαίοι χαρακτήρες';
$string['misc'] = 'Διάφορα';
$string['mlbackendsettings'] = 'Ρυθμίσεις υποστήριξης λειτουργίας μηχανικής μάθησης';
$string['mnetrestore_extusers'] = '<strong>Σημείωση:</strong> Αυτό το αντίγραφο ασφαλείας περιέχει λογαριασμούς χρηστών Moodle Network που θα επαναφερθούν ως κομμάτι της διαδικασίας.';
$string['mnetrestore_extusers_admin'] = '<strong>Σημείωση:</strong> Αυτό το αντίγραφο ασφαλείας φαίνεται να προέρχεται από διαφορετική εγκατάσταση Moodle και περιέχει λογαριασμούς χρηστών Moodle Network. Η διαδικασία επαναφοράς θα προσπαθήσει να ταιριάξει τους κεντρικούς υπολογιστές του Moodle Network για όλους τους χρήστες. Αυτοί που δε θα αντιστοιχιστούν θα μεταφερθούν αυτόματα σε εσωτερική πιστοποίηση (αντί για MNet). Το αρχείο καταγραφής της διαδικασίας επαναφοράς θα περιέχει σχετικές πληροφορίες.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Σημείωση:</strong> Αυτό το αντίγραφο ασφαλείας φαίνεται να προέρχεται από διαφορετική εγκατάσταση Moodle και περιέχει λογαριασμούς χρηστών Moodle Network που μπορεί να μην μπορούν να επαναφερθούν. Η λειτουργία αυτή δεν υποστηρίζεται. Εάν είστε σίγουροι ότι δημιουργήθηκε σε αυτήν εδώ την εγκατάσταση ή μπορείτε να εξασφαλίσετε ότι όλοι οι κεντρικοί Η/Υ στο Moodle Network είναι ρυθμισμένοι, μπορείτε να δοκιμάσετε την επαναφορά.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Σημείωση:</strong> Αυτό το αντίγραφο ασφαλείας φαίνεται να προέρχεται από διαφορετική εγκατάσταση Moodle και περιέχει λογαριασμούς απομακρυσμένων χρηστών Moodle Network. Δεν έχετε τα δικαιώματα για να εκτελέσετε αυτό το είδος επαναφοράς. Επικοινωνήστε με το διαχειριστή του ιστοτόπου ή, εναλλακτικά, επαναφέρετε αυτό το μάθημα χωρίς πληροφορίες χρηστών (αρθρώματα, αρχεία...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Απομακρυσμένος Moodle Network χρήστης {$a->username} (προερχόμενος από {$a->mnethosturl}) μεταφέρθηκε στον τοπικό πιστοποιημένο χρήστη {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'Η εφαρμογή κινητού Moodle δεν είναι ενεργοποιημένη.';
$string['modeditdefaults'] = 'Προεπιλεγμένες τιμές για τις ρυθμίσεις της δραστηριότητας';
$string['modsettings'] = 'Διαχείριση δραστηριοτήτων';
$string['modulesecurity'] = 'Ασφάλεια αρθρώματος';
$string['moodlebrandedapp'] = 'Επώνυμη εφαρμογή κινητού Moodle';
$string['moodlebrandedappreference'] = 'Εναλλακτικά, λάβετε μια <a href="https://moodle.com/branded-app/">Επώνυμη εφαρμογή κινητού Moodle</a> με τη δική σας προσαρμοσμένη επωνυμία.';
$string['mustenablestats'] = 'Τα στατιστικά δεν έχουν ενεργοποιηθεί ακόμα σε αυτόν τον ιστότοπο.';
$string['mydashboard'] = 'Προεπιλεγμένο Ταμπλό συστήματος';
$string['mymoodle'] = 'Ταμπλό';
$string['mypage'] = 'Προεπιλεγμένη σελίδα Ταμπλό';
$string['mypagelocked'] = 'Κλείδωμα προεπιλεγμένης σελίδας';
$string['myprofile'] = 'Προεπιλεγμένη σελίδα προφίλ';
$string['navadduserpostslinks'] = 'Προσθήκη συνδέσμων για την προβολή αναρτήσεων χρήστη';
$string['navadduserpostslinks_help'] = 'Εάν ενεργοποιηθεί, θα προστεθούν δύο σύνδεσμοι στην πλοήγηση κάθε χρήστη για να βλέπει τις συζητήσεις που έχει ξεκινήσει και τις αναρτήσεις που έχει κάνει σε φόρουμ σε ολόκληρο τον ιστότοπο ή σε συγκεκριμένα μαθήματα.';
$string['navcourselimit'] = 'Όριο μαθήματος';
$string['navigationupgrade'] = 'Αυτή η αναβάθμιση εισάγει δύο νέα μπλοκ πλοήγησης που θα αντικαταστήσουν αυτά τα μπλοκ: Διαχείριση, Μαθήματα, Δραστηριότητες και Συμμετέχοντες. Αν είχατε καθορίσει κάποια ειδικά δικαιώματα σε αυτά τα μπλοκ, θα πρέπει να ελέγξετε για να επιβεβαιώσετε ότι όλα συμπεριφέρονται όπως θέλετε.';
$string['navshowallcourses'] = 'Εμφάνιση όλων των μαθημάτων';
$string['navshowcategories'] = 'Εμφάνιση κατηγοριών μαθημάτων';
$string['navshowfrontpagemods'] = 'Εμφάνιση δραστηριοτήτων πρώτης σελίδας στην πλοήγηση';
$string['navshowfrontpagemods_help'] = 'Αν ενεργοποιηθεί, οι δραστηριότητες της πρώτης σελίδας θα εμφανίζονται στην πλοήγηση κάτω από τις Σελίδες ιστοτόπου.';
$string['navshowfullcoursenames'] = 'Εμφάνιση πλήρους ονόματος μαθημάτων';
$string['navshowfullcoursenames_help'] = 'Εάν ενεργοποιηθεί, στην πλοήγηση θα χρησιμοποιούνται τα πλήρη ονόματα μαθημάτων αντί για τα σύντομα.';
$string['navshowmycoursecategories'] = 'Εμφάνιση κατηγοριών μαθημάτων μου';
$string['navshowmycoursecategories_help'] = 'Εάν ενεργοποιηθεί, τα μαθήματα στον κλάδο Τα μαθήματά μου του χρήστη θα εμφανίζονται σε κατηγορίες στο μπλοκ πλοήγησης (μόνο αισθητικά θέματα που βασίζονται στο Κλασσικό).';
$string['navsortmycourseshiddenlast'] = 'Ταξινόμηση των κρυμμένων μαθημάτων μου στο τέλος';
$string['navsortmycourseshiddenlast_help'] = 'Εάν ενεργοποιηθεί, οποιοδήποτε μάθημα σε απόκρυψη θα ταξινομείται μετά από τα ορατά μαθήματα (για χρήστες που μπορούν να δουν μαθήματα σε απόκρυψη). Διαφορετικά, όλα τα μαθήματα, ανεξάρτητα από την ορατότητά τους, θα ταξινομούνται σύμφωνα με την ρύθμιση «Ταξινόμηση των μαθημάτων μου».';
$string['navsortmycoursessort'] = 'Ταξινόμηση των μαθημάτων μου';
$string['navsortmycoursessort_help'] = 'Καθορίζει αν τα μαθήματα εμφανίζονται στο μπλοκ Τα μαθήματά μου ανάλογα με τη σειρά ταξινόμησης (δηλ. η σειρά που έχει οριστεί στη Διαχείριση ιστοτόπου > Μαθήματα> Διαχείριση μαθημάτων και κατηγοριών) ή αλφαβητικά σύμφωνα με τη ρύθμιση μαθημάτων.';
$string['never'] = 'Ποτέ';
$string['neverdeleteruns'] = 'Να μη διαγράφονται οι εκτελέσεις';
$string['newestdocindexed'] = 'Το νεότερο έγγραφο είναι ευρετηριασμένο';
$string['nobookmarksforuser'] = 'Δεν έχετε σελιδοδείκτες.';
$string['nodatabase'] = 'Δεν υπάρχει βάση δεδομένων';
$string['nohttpsformobilewarning'] = 'Συνιστάται η ενεργοποίηση του HTTPS με έγκυρο πιστοποιητικό. Η εφαρμογή Moodle θα προσπαθεί πάντα να χρησιμοποιήσει πρώτα μια ασφαλή σύνδεση.';
$string['nomissingstrings'] = 'Δεν λείπουν αλφαριθμητικά';
$string['none'] = 'Κανένα';
$string['nonewsettings'] = 'Δεν προστέθηκαν καινούργιες ρυθμίσεις κατά την ενημέρωση.';
$string['nonexistentbookmark'] = 'Ο σελιδοδείκτης που ζητήσατε δεν υπάρχει.';
$string['noreplyaddress'] = 'Διεύθυνση μη-απάντησης';
$string['noreplydomain'] = 'Μη-απάντηση και τομέας';
$string['noreplydomaindetail'] = 'Ρυθμίσεις για τη διεύθυνση μη-απάντησης και τους τομείς που ορίστηκαν';
$string['noresults'] = 'Δεν βρέθηκαν αποτελέσματα.';
$string['noroles'] = 'Δεν υπάρχουν ρόλοι';
$string['nosupportedlogstore'] = 'Αδυναμία εύρεσης υποστηριζόμενης αποθήκης καταγραφών';
$string['notifications'] = 'Ειδοποιήσεις';
$string['notifyloginfailures'] = 'Αποστολή μηνύματος ηλε.ταχυδρομείου με τις εσφαλμένες προσπάθειες σύνδεσης, στον';
$string['notifyloginthreshold'] = 'Όριο για ειδοποιήσεις με μήνυμα ηλε.ταχυδρομείου';
$string['notloggedinroleid'] = 'Ρόλος για τους επισκέπτες';
$string['numberofmissingstrings'] = 'Αριθμός αλφαριθμητικών που λείπουν: {$a}';
$string['numberofstrings'] = 'Συνολικός αριθμός συμβολοσειρών: {$a->strings}<br />Λείπουν: {$a->missing} ({$a->missingpercent} %)';
$string['oauthrefreshtokenexpired'] = 'Το κουπόνι ανανέωσης για μία από τις υπηρεσίες του OAuth {$a->issuer} στον ιστότοπό σας {$a->siteurl} έχει λήξει. Αυτό θα περιορίσει τη λειτουργικότητα των πρόσθετων που χρησιμοποιούν αυτή την υπηρεσία. Για να διορθώσετε αυτό το ζήτημα, επισκεφθείτε τη σελίδα ρυθμίσεων υπηρεσιών OAuth 2 και πατήστε στο εικονίδιο «Σύνδεση λογαριασμού συστήματος» στη γραμμή πίνακα για αυτή την υπηρεσία. Επιβεβαιώστε ότι συνδέεστε με τον ίδιο λογαριασμό υπηρεσίας για το σύστημα OAuth κάθε φορά.';
$string['oauthrefreshtokenexpiredshort'] = 'Το κουπόνι ανανέωσης OAuth για τον/την {$a->issuer} στον ιστότοπό σας {$a->siteurl} έληξε.';
$string['onlynoreply'] = 'Μόνο όταν προέρχεται από διεύθυνση μη-απάντησης';
$string['opcacherecommended'] = 'Η χρήση κρυφής μνήμης για PHP opcode βελτιώνει την απόδοση και μειώνει τις απαιτήσεις μνήμης, η επέκταση OPcache συνιστάται και υποστηρίζεται πλήρως.';
$string['opensslrecommended'] = 'Συνιστάται ιδιαίτερα, η εγκατάσταση της προαιρετικής βιβλιοθήκης OpenSSL -- επιτρέπει την λειτουργικότητα δικτύωσης του Moodle.';
$string['opensslrequired'] = 'Η επέκταση OpenSSL της PHP πλέον απαιτείται από το Moodle για την παροχή ισχυρότερων κρυπτογραφικών υπηρεσιών.';
$string['opentowebcrawlers'] = 'Άνοιγμα στις μηχανές αναζήτησης';
$string['optionalmaintenancemessage'] = 'Προαιρετικό μήνυμα συντήρησης';
$string['order1'] = 'Πρώτος/ο/η';
$string['order2'] = 'Δεύτερος/ο/η';
$string['order3'] = 'Τρίτος/ο/η';
$string['order4'] = 'Τέταρτος/ο/η';
$string['outgoingmailconfig'] = 'Ρυθμίσεις εξερχόμενων μηνυμάτων ηλε.ταχυδρομείου';
$string['overridetossl'] = 'Το HTTPS για τις συνδέσεις έχει πλέον καταργηθεί. Αυτό το στιγμιότυπο υποχρεώνεται τώρα να χρησιμοποιήσει SSL. Για να αντιμετωπίσετε αυτή την προειδοποίηση, αλλάξτε το wwwroot σας στο config.php σε https://';
$string['pageinfodebugsummary'] = 'Αυτή η σελίδα είναι: {$a}';
$string['passwordchangelogout'] = 'Αποσύνδεση μετά την αλλαγή κωδικού πρόσβασης';
$string['passwordchangelogout_desc'] = 'Εάν ενεργοποιηθεί, όταν αλλάξει ο κωδικός πρόσβασης, όλες οι σύνοδοι του περιηγητή τερματίζονται, εκτός από εκείνη στην οποία έχει οριστεί ο νέος κωδικός πρόσβασης. (Αυτή η ρύθμιση δεν επηρεάζει τις αλλαγές κωδικού πρόσβασης μέσω μαζικού ανεβάσματος χρηστών.)';
$string['passwordchangetokendeletion'] = 'Διαγραφή κουπονιών πρόσβασης σε υπηρεσίες ιστού αν αλλάξει ο κωδικός πρόσβασης';
$string['passwordchangetokendeletion_desc'] = 'Αν ενεργοποιηθεί, όταν αλλάξει ένας κωδικός πρόσβασης, όλα τα κουπόνια πρόσβασης του χρήστη σε υπηρεσίες ιστού διαγράφονται.';
$string['passwordpolicy'] = 'Πολιτική κωδικού πρόσβασης';
$string['passwordpolicycheckonlogin'] = 'Έλεγχος κωδικού πρόσβασης κατά τη σύνδεση';
$string['passwordresettime'] = 'Μέγιστος χρόνος για επικύρωση αίτησης επαναρχικοποίησης κωδικού';
$string['passwordreuselimit'] = 'Όριο ανακύκλωσης κωδικών';
$string['passwordreuselimit_desc'] = 'Πλήθος διαφορετικών κωδικών που ο χρήστης πρέπει να ορίσει πριν να μπορέσει να ξαναχρησιμοποιήσει τον ίδιο. Hashes (μη αντιστρεπτές αντιστοιχίσεις/συνόψεις) αποθηκεύονται στην τοπική βάση δεδομένων. Αυτό το χαρακτηριστικό ίσως είναι ασύμβατο με κάποια πρόσθετα αυθεντικοποίησης.';
$string['pathtodot'] = 'Μονοπάτι ως το πρόγραμμα dot';
$string['pathtodot_help'] = 'Μονοπάτι ως το πρόγραμμα dot. Πιθανώς κάτι σαν /usr/bin/dot. Για να μπορείτε να δημιουργείτε γραφικά από DOT αρχεία, πρέπει να έχετε εγκατεστημένο το εκτελέσιμο πρόγραμμα dot και εδώ το μονοπάτι του. Σημειώστε πως, προς το παρόν, αυτό χρησιμοποιείται από τις λειτουργίες προφίλ (Ανάπτυξη->Προφίλ) του ίδιου του Moodle.';
$string['pathtodu'] = 'Μονοπάτι για το du';
$string['pathtogs'] = 'Μονοπάτι για ghostscript';
$string['pathtogs_help'] = 'Στις περισσότερες εγκαταστάσεις Linux, αυτό μπορεί να παραμείνει ως «/usr/bin/gs». Στα Windows θα είναι κάτι σαν «c:\\gs\\bin\\gswin32c.exe» (βεβαιωθείτε ότι δεν υπάρχουν κενά στο μονοπάτι - αν είναι αναγκαίο αντιγράψτε τα αρχεία «gswin32c.exe» και «gsdll32.dll» σε ένα νέο φάκελο χωρίς κενά στο πλήρες όνομα του φακέλου)';
$string['pathtopdftoppm'] = 'Μονοπάτι προς το pdftoppm';
$string['pathtopdftoppm_help'] = 'Το <a href="https://poppler.freedesktop.org/">Poppler</a> είναι μια βιβλιοθήκη απόδοσης PDF η οποία συμπεριλαμβάνει το εργαλείο pdftoppm για μετατροπή αρχείων PDF σε PNG. Η απόδοση είναι γενικά καλύτερη από ό,τι όταν χρησιμοποιείτε Ghostscript, ειδικά για μεγάλα αρχεία. Εάν είναι διαθέσιμο, το pdftoppm θα χρησιμοποιείται κατά προτίμηση παρά το Ghostscript. Στις περισσότερες εγκαταστάσεις Linux, το μονοπάτι μπορεί να παραμείνει ως /usr/bin/pdftoppm. Διαφορετικά, πρέπει να εγκαταστήσετε το τα εργαλεία poppler-utils ή το πακέτο poppler, ανάλογα με τη διανομή σας Linux. Στα Windows παρέχεται από εγκαταστάσεις της Cygwin.';
$string['pathtopgdump'] = 'Μονοπάτι για το pg_dump';
$string['pathtopgdumpdesc'] = 'Αυτό το πεδίο απαιτείται εάν έχετε περισσότερα από ένα pg_dump στο σύστημά σας (π.χ. αν έχετε περισσότερες από μία εκδόσεις του postgresql εγκατεστημένες)';
$string['pathtopgdumpinvalid'] = 'Μη έγκυρο μονοπάτι για το pg_dump - είτε λάθος μονοπάτι, είτε μη-εκτελέσιμο αρχείο';
$string['pathtophp'] = 'Μονοπάτι προς το εκτελέσιμο από γραμμή εντολών αρχείο της PHP';
$string['pathtopsql'] = 'Μονοπάτι για το psql';
$string['pathtopsqldesc'] = 'Αυτό το πεδίο απαιτείται εάν έχετε περισσότερα από ένα psql στο σύστημά σας (π.χ. αν έχετε περισσότερες από μία εκδόσεις του postgresql εγκατεστημένες)';
$string['pathtopsqlinvalid'] = 'Μη έγκυρο μονοπάτι για το psql - είτε λάθος μονοπάτι, είτε μη-εκτελέσιμο αρχείο';
$string['pathtopython'] = 'Μονοπάτι για το Python';
$string['pathtopythondesc'] = 'Μονοπάτι για το εκτελέσιμο αρχείο του Python (επιτρέπονται Python 2 ή Python 3)';
$string['pathtosassc'] = 'Μονοπάτι για το SassC';
$string['pathtosassc_help'] = 'Ο καθορισμός της τοποθεσίας του εκτελέσιμου αρχείου του SassC θα μεταβιβάσει την μεταγλώττιση SASS από την υλοποίηση PHP της Moodle στο SassC. Δείτε https://github.com/sass/sassc για περισσότερες πληροφορίες.';
$string['pcreunicodewarning'] = 'Συνιστάται ένθερμα να χρησιμοποιήσετε την επέκταση PCRE PHP που είναι συμβατή με χαρακτήρες Unicode.';
$string['perfdebug'] = 'Πληροφορίες απόδοσης';
$string['performance'] = 'Απόδοση';
$string['pgcluster'] = 'Συστάδα PostgreSQL';
$string['pgclusterdescription'] = 'Παράμετρος PostgreSQL έκδοσης/συστάδας για λειτουργίες από γραμμή εντολών. Εάν έχετε μόνο ένα postgresql στο σύστημά σας ή δεν ξέρετε τι είναι αυτό, αφήστε το κενό.';
$string['phpfloatproblem'] = 'Εντοπίστηκε μη αναμενόμενο πρόβλημα κατά τη διαχείριση PHP float αριθμών - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Ο ιστότοπός σας έχει καταχωρηθεί (στο moodle.org). Τελευταία ενημέρωση της καταχώρησης στις {$a}.
<br /> Η χρονοπρογραμματισμένη εργασία «Καταχώρηση ιστοτόπου» διατηρεί την καταχώρησή σας ενημερωμένη. Μπορείτε επίσης να ενημερώσετε την καταχώρηση μόνος σας οποτεδήποτε.';
$string['pleaserefreshregistrationnewdata'] = 'Οι πληροφορίες καταχώρησης έχουν αλλάξει. Επιβεβαιώστε το χρησιμοποιώντας το πλήκτρο «Ενημέρωση καταχώρησης».';
$string['pleaserefreshregistrationunknown'] = 'Ο ιστότοπός σας έχει καταχωρηθεί αλλά η ημερομηνία καταχώρησης είναι άγνωστη. Παρακαλούμε, ενημερώστε την χρησιμοποιώντας το κουμπί «Ενημέρωση καταχώρησης» ή βεβαιωθείτε ότι είναι ενεργοποιημένη η χρονοπρογραμματισμένη εργασία «Καταχώρηση ιστοτόπου», ώστε να ενημερώνεται αυτόματα.';
$string['plugin'] = 'Πρόσθετο';
$string['plugins'] = 'Πρόσθετα';
$string['pluginscheck'] = 'Έλεγχος εξαρτήσεων πρόσθετων';
$string['pluginscheckfailed'] = 'Αποτυχία ελέγχου εξαρτήσεων για τα πρόσθετα: {$a->pluginslist}';
$string['pluginschecktodo'] = 'Πρέπει να ικανοποιήσετε όλες τις απαιτήσεις των πρόσθετων πριν προσχωρήσετε στην εγκατάσταση αυτής της έκδοσης του Moodle!';
$string['pluginsoverview'] = 'Επισκόπηση πρόσθετων';
$string['pluginsoverviewsee'] = 'Για περισσότερες λεπτομέρειες, ανατρέξτε στη σελίδα <a href="{$a->url}">επισκόπηση πρόσθετων</a>.';
$string['policysettings'] = 'Ρυθμίσεις πολιτικής';
$string['privacy:metadata'] = 'Το πρόσθετο «Διαχείριση» δεν αποθηκεύει κανένα προσωπικό δεδομένο.';
$string['privacyandpolicies'] = 'Απόρρητο και πολιτικές';
$string['privacysettings'] = 'Ρυθμίσεις απορρήτου';
$string['profilecategory'] = 'Κατηγορία';
$string['profilecategoryname'] = 'Όνομα κατηγορίας (πρέπει να είναι μοναδικό)';
$string['profilecategorynamenotunique'] = 'Αυτό το όνομα κατηγορίας χρησιμοποιείται ήδη';
$string['profilecommonsettings'] = 'Κοινές ρυθμίσεις';
$string['profileconfirmcategorydeletion'] = 'Υπάρχουν {$a} πεδία στην κατηγορία αυτή που θα μεταφερθούν στην παραπάνω κατηγορία (ή παρακάτω εάν βρίσκονται ήδη στην ανώτατη κατηγορία).<br />Επιθυμείτε ακόμη να διαγράψετε την κατηγορία;';
$string['profileconfirmfielddeletion'] = 'Υπάρχουν {$a} εγγραφές χρηστών για αυτό το πεδίο που θα διαγραφούν.<br />Επιθυμείτε ακόμη τη διαγραφή του πεδίου;';
$string['profilecreatecategory'] = 'Δημιουργία νέας κατηγορίας προφίλ';
$string['profilecreatefield'] = 'Δημιουργία νέου πεδίου προφίλ';
$string['profilecreatenewcategory'] = 'Δημιουργία νέας κατηγορίας';
$string['profilecreatenewfield'] = 'Δημιουργία νέου «{$a}» πεδίου προφίλ';
$string['profiledefaultcategory'] = 'Άλλα πεδία';
$string['profiledefaultchecked'] = 'Προεπιλεγμένα';
$string['profiledefaultdata'] = 'Προεπιλεγμένη τιμή';
$string['profiledeletecategory'] = 'Διαγραφή μιας κατηγορίας';
$string['profiledeletefield'] = 'Διαγραφή πεδίου «{$a}»';
$string['profiledescription'] = 'Περιγραφή του πεδίου';
$string['profiledscript'] = 'Για αυτό το σενάριο έχει δημιουργηθεί προφίλ απόδοσης';
$string['profiledscriptview'] = 'Δείτε πληροφορίες δημιουργίας προφίλ για αυτό το σενάριο';
$string['profileeditcategory'] = 'Επεξεργασία κατηγορίας: {$a}';
$string['profileeditfield'] = 'Επεξεργασία πεδίου προφίλ: {$a}';
$string['profilefield'] = 'Πεδίο προφίλ';
$string['profilefieldcolumns'] = 'Στήλες';
$string['profilefieldispassword'] = 'Είναι αυτό πεδίο κωδικού πρόσβασης;';
$string['profilefieldlink'] = 'Σύνδεσμος';
$string['profilefieldlink_help'] = 'Για να μετατρέψετε το κείμενο σε έναν σύνδεσμο, καταχωρήστε μια διεύθυνση URL που περιέχει το $$, όπου το $$ θα αντικατασταθεί με το κείμενο. Για παράδειγμα, για να μετατρέψετε ένα αναγνωριστικό Twitter σε έναν σύνδεσμο, πληκτρολογήστε http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Προορισμός συνδέσμου';
$string['profilefieldmaxlength'] = 'Μέγιστο μήκος';
$string['profilefieldrows'] = 'Γραμμές';
$string['profilefields'] = 'Πεδία προφίλ χρήστη';
$string['profilefieldsize'] = 'Μέγεθος προβολής';
$string['profileforceunique'] = 'Θα πρέπει τα δεδομένα να είναι μοναδικά;';
$string['profileinvaliddata'] = 'Μη έγκυρη επιλογή';
$string['profilelocked'] = 'Είναι αυτό το πεδίο κλειδωμένο;';
$string['profilemenudefaultnotinoptions'] = 'Η προεπιλεγμένη τιμή δεν είναι μία από τις επιλογές';
$string['profilemenunooptions'] = 'Δεν παρέχονται επιλογές μενού';
$string['profilemenuoptions'] = 'Επιλογές μενού (μία ανά γραμμή)';
$string['profilemenutoofewoptions'] = 'Πρέπει να παράσχετε τουλάχιστον 2 επιλογές';
$string['profilename'] = 'Όνομα';
$string['profilenofieldsdefined'] = 'Δεν έχουν οριστεί πεδία';
$string['profilerequired'] = 'Είναι αυτό το πεδίο απαραίτητο;';
$string['profileroles'] = 'Ορατοί ρόλοι προφίλ';
$string['profilesforenrolledusersonly'] = 'Προφίλ για εγγεγραμμένους χρήστες μόνο';
$string['profileshortname'] = 'Σύντομο όνομα (πρέπει να είναι μοναδικό)';
$string['profileshortnameinvalid'] = 'Αυτό το σύντομο όνομα μπορεί να περιέχει μόνο αλφαριθμητικούς χαρακτήρες (γράμματα και αριθμούς) ή υπογράμμιση (_).';
$string['profileshortnamenotunique'] = 'Αυτό το σύντομο όνομα χρησιμοποιείται ήδη';
$string['profilesignup'] = 'Εμφάνιση στη σελίδα εγγραφής;';
$string['profilespecificsettings'] = 'Συγκεκριμένες ρυθμίσεις';
$string['profilevisible'] = 'Ποιος θα μπορεί να δει αυτό το πεδίο;';
$string['profilevisible_help'] = '* Μη ορατό - Για ιδιωτικά δεδομένα ορατά μόνο σε διαχειριστές και διευθυντές
* Ορατό στο χρήστη - Για ιδιωτικά δεδομένα που βλέπει μόνο ο χρήστης και οι διαχειριστές
* Ορατό σε χρήστη, διδάσκοντες και διαχειριστές - Για ιδιωτικά δεδομένα που είναι ορατά μόνο στον χρήστη, στους διαχειριστές και στους εκπαιδευτικούς (στο προφίλ του μαθήματος)
* Ορατό σε όλους';
$string['profilevisibleall'] = 'Ορατό σε όλους';
$string['profilevisiblenone'] = 'Μη ορατό';
$string['profilevisibleprivate'] = 'Ορατό στο χρήστη';
$string['profilevisibleteachers'] = 'Ορατό σε χρήστες, διδάσκοντες και διαχειριστές';
$string['profiling'] = 'Δημιουργία προφίλ';
$string['profilingallowall'] = 'Διαρκής δημιουργία προφίλ';
$string['profilingallowall_help'] = 'Εάν ενεργοποιήσετε αυτή τη ρύθμιση, τότε μπορείτε ανά πάσα στιγμή να χρησιμοποιήσετε την παράμετρο PROFILEALL (PGC) για να ενεργοποιήσετε τη δημιουργία προφίλ για όλα τα εκτελούμενα σενάρια κατά τη διάρκεια ζωής της περιόδου λειτουργίας (συνόδου) του Moodle. Ανάλογα, μπορείτε να χρησιμοποιήσετε την παράμετρο PROFILEALLSTOP για να την σταματήσετε.';
$string['profilingallowme'] = 'Επιλεκτική δημιουργία προφίλ';
$string['profilingallowme_help'] = 'Εάν ενεργοποιήσετε αυτή τη ρύθμιση, τότε, επιλεκτικά, μπορείτε να χρησιμοποιήσετε την παράμετρο PROFILEME οπουδήποτε (PGC) και να δημιουργήσετε προφίλ για αυτό το σενάριο. Ανάλογα, μπορείτε να χρησιμοποιήσετε την παράμετρο DONTPROFILEME για να παρεμποδίσετε τη δημιουργία προφίλ';
$string['profilingautofrec'] = 'Αυτόματη δημιουργία προφίλ';
$string['profilingautofrec_help'] = 'Με τη διαμόρφωση αυτής της ρύθμισης, κάποιο αίτημα (τυχαία, βάσει της καθορισμένης συχνότητας - 1 από N) θα επιλεχθεί και θα του δημιουργηθεί προφίλ αυτόματα, αποθηκεύοντας τα αποτελέσματα για περαιτέρω ανάλυση. Σημειώστε ότι αυτός ο τρόπος δημιουργίας προφίλ τηρεί τις ρυθμίσεις Συμπερίληψη/Εξαίρεση. Ορίστε το σε 0 για να απενεργοποιήσετε την αυτόματη δημιουργία προφίλ.';
$string['profilingenabled'] = 'Ενεργοποίηση δημιουργίας προφίλ';
$string['profilingenabled_help'] = 'Αν ενεργοποιήσετε αυτή τη ρύθμιση, τότε η δημιουργία προφίλ θα είναι διαθέσιμη σε αυτόν τον ιστότοπο και θα μπορείτε να ορίσετε τη συμπεριφορά της, διαμορφώνοντας τις επόμενες επιλογές.';
$string['profilingexcluded'] = 'Εξαίρεση δημιουργίας προφίλ';
$string['profilingexcluded_help'] = 'Λίστα με διευθύνσεις URL (διαχωρισμένες με κόμμα, απόλυτες, παραλείποντας δηλ. το μονοπάτι έως και το wwwroot, που να μπορούν να κληθούν) που θα αποκλειστούν από την δημιουργία προφίλ (για να μετρηθεί η απόδοσή τους αυτόματα) από αυτές που ορίζονται στη ρύθμιση «Δημιουργία προφίλ αυτών».';
$string['profilingimportprefix'] = 'Πρόθεμα εισαγωγής δημιουργίας προφίλ';
$string['profilingimportprefix_desc'] = 'Για πιο εύκολο εντοπισμό, όλες οι εκτελέσεις δημιουργίας προφίλ που εισάγονται θα πάρουν ως πρόθεμα την τιμή που καθορίζεται εδώ.';
$string['profilingincluded'] = 'Δημιουργία προφίλ για αυτά';
$string['profilingincluded_help'] = 'Λίστα με διευθύνσεις URL (διαχωρισμένες με κόμμα, απόλυτες παραλείποντας το μονοπάτι έως και το wwwroot, που να μπορούν να κληθούν) που θα αποκλειστούν από την δημιουργία προφίλ (για να μετρηθεί η απόδοσή τους αυτόματα). Παραδείγματα: /index.php, /course/view.php. Επίσης αποδεκτός είναι ο χαρακτήρας μπαλαντέρ * σε οποιαδήποτε θέση. Παραδείγματα: /mod/forum/*, /mod/*/view.php.,,';
$string['profilinglifetime'] = 'Διατήρηση των εκτελέσεων δημιουργίας προφίλ';
$string['profilinglifetime_help'] = 'Καθορίστε το χρονικό διάστημα για το οποίο θέλετε να διατηρείτε πληροφορίες σχετικά με τις παλιές δημιουργίες προφίλ (αυτόματης μέτρησης απόδοσης). Οι παλαιότερες θα διαγράφονται περιοδικά. Σημειώστε ότι αυτό αποκλείει οποιοδήποτε προφίλ που επισημαίνεται ως «Εκτέλεση αναφοράς».';
$string['profilingslow'] = 'Προφίλ αργών σελίδων';
$string['profilingslow_help'] = 'Με τον καθορισμό ελάχιστου χρόνου σε δευτερόλεπτα για όλες τις πιο αργές σελίδες θα δημιουργηθεί προφίλ. Θα διατηρηθούν μόνο τα προφίλ που είναι πιο αργά από ένα υπάρχον προφίλ για το ίδιο σενάριο. Ορίστε το σε 0 για απενεργοποίηση. Σημειώστε ότι αυτό τηρεί τις ρυθμίσεις αποκλεισμού.';
$string['protectusernames'] = 'Προστάτεψε τα ονόματα χρηστών';
$string['proxybypass'] = 'Κεντρικοί υπολογιστές που παρακάμπτουν τον proxy';
$string['proxyhost'] = 'κεντρικός υπολογιστής proxy';
$string['proxypassword'] = 'Κωδικός πρόσβασης διακομιστή μεσολάβησης';
$string['proxyport'] = 'Θύρα διακομιστή μεσολάβησης';
$string['proxytype'] = 'Τύπος διακομιστή μεσολάβησης';
$string['proxyuser'] = 'Όνομα χρήστη διακομιστή μεσολάβησης';
$string['purgecaches'] = 'Εκκαθάριση όλων των κρυφών μνημών';
$string['purgecachesconfirm'] = 'Το Moodle μπορεί να αποθηκεύσει σε κρυφή μνήμη αισθητικά θέματα, σενάρια Javascript, συμβολοσειρές γλώσσας, φιλτραρισμένο κείμενο, τροφοδοσίες RSS και πολλά άλλα κομμάτια υπολογισμένων δεδομένων. Η εκκαθάριση αυτών των κρυφών μνημών θα διαγράψει αυτά τα δεδομένα από τον εξυπηρετητή και θα αναγκάσει τους περιηγητές να ξαναβρούν & να ξαναφέρουν δεδομένα, έτσι ώστε να είστε βέβαιοι ότι βλέπετε τις πιο ενημερωμένες τιμές που παράγει ο τρέχων κώδικας. Δεν υπάρχει κίνδυνος στην εκκαθάριση των κρυφών μνημών, αλλά ο ιστότοπός σας ενδέχεται να εμφανιστεί πιο αργός για λίγο, έως ότου ο εξυπηρετητής και οι πελάτες υπολογίσουν τη νέα πληροφορία και την αποθηκεύσουν στην κρυφή μνήμη.';
$string['purgecachesfinished'] = 'Όλες οι κρυφές μνήμες εκκαθαρίστηκαν.';
$string['purgecachesnoneselected'] = 'Επιλέξτε μία ή περισσότερες κρυφές μνήμες για εκκαθάριση';
$string['purgecachespage'] = 'Εκκαθάριση στις κρυφές μνήμες';
$string['purgefiltercache'] = 'Φίλτρα κειμένου';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Συμβολοσειρές γλωσσών';
$string['purgemuc'] = 'Όλες οι κρυφές μνήμες MUC';
$string['purgeothercaches'] = 'Όλα τα αρχεία και διάφορες κρυφές μνήμες';
$string['purgeselectedcaches'] = 'Εκκαθάριση σε επιλεγμένες προσωρινές μνήμες';
$string['purgeselectedcachesfinished'] = 'Οι επιλεγμένες κρυφές μνήμες εκκαθαρίστηκαν.';
$string['purgetemplates'] = 'Υποδείγματα';
$string['purgethemecache'] = 'Αισθητικά θέματα';
$string['query'] = 'Ερώτημα';
$string['question'] = 'Ερώτηση';
$string['questionbehaviours'] = 'Συμπεριφορά ερωτήσεων';
$string['questioncwqpfscheck'] = 'Μία ή περισσότερες «τυχαίες» ερωτήσεις σε κάποιο κουίζ έχουν ρυθμιστεί ώστε να επιλέγουν ερωτήσεις από ένα μίγμα κοινόχρηστων και μη κατηγοριών ερωτήσεων. Υπάρχει πιο λεπτομερής αναφορά <a href="{$a->reporturl}">εδώ</a> και κοιτάξτε τη σελίδα τεκμηρίωσης Moodle Docs <a href="{$a->docsurl}">εδώ</a>.';
$string['questioncwqpfsok'] = 'Ωραία. Δεν υπάρχουν «τυχαίες» ερωτήσεις στα κουίζ που να έχουν ρυθμιστεί ώστε να επιλέγουν ερωτήσεις από ένα μίγμα κοινόχρηστων και μη κατηγοριών ερωτήσεων.';
$string['questiontype'] = 'Τύπος ερώτησης';
$string['questiontypes'] = 'Τύποι ερωτήσεων';
$string['quizattemptsupgradedmessage'] = 'Στο Moodle 2.1 υπήρξε σημαντική αναβάθμιση στις ερωτήσεις. Ήταν δυνατόν να καθυστερήσουν τμήματα της αναβάθμισης της βάσης δεδομένων για να τρέξουν αργότερα. Πριν από την αναβάθμιση στο Moodle 2.7, αυτή η αναβάθμιση πρέπει να ολοκληρωθεί.';
$string['recaptchaprivatekey'] = 'Ιδιωτικό κλειδί ReCAPTCHA';
$string['recaptchapublickey'] = 'Δημόσιο κλειδί για το ReCAPTCHA';
$string['referrernone'] = 'Προεπιλογή περιηγητή';
$string['referrerpolicy'] = 'Πολιτική παραπομπών';
$string['referrerpolicydesc'] = 'Ορίστε την κεφαλίδα πολιτικής παραπομπών που θα συμπεριλαμβάνεται στις αποκρίσεις από τον ιστότοπό σας.';
$string['register'] = 'Καταχώρηση του ιστοτόπου σας';
$string['registration'] = 'Καταχώρηση';
$string['registration_help'] = 'Κάνοντας καταχώρηση:

* Θα λαμβάνετε επαγρυπνήσεις ασφαλείας
* Μπορείτε να ενεργοποιήσετε τις προωθητικές ενημερώσεις εφαρμογής κινητού από τον ιστότοπό σας
* Συνεισφέρετε στις στατιστικές της παγκόσμιας κοινότητας Moodle';
$string['registrationwarning'] = 'Ο ιστότοπός σας δεν έχει ακόμη καταχωρηθεί.';
$string['registrationwarningcontactadmin'] = 'Ο ιστότοπός σας δεν έχει ακόμη καταχωρηθεί. Παρακαλούμε ειδοποιήστε τον διαχειριστή.';
$string['releasenoteslink'] = 'Για πληροφορίες σχετικά με αυτήν την έκδοση του Moodle, παρακαλούμε δείτε εδώ: <a target="_new" href="{$a}">Σημειώσεις έκδοσης/διανομής</a>';
$string['rememberuserlicensepref'] = 'Απομνημόνευση προτίμησης άδειας χρήσης';
$string['rememberuserlicensepref_help'] = 'Εάν ενεργοποιηθεί, η τελευταία άδεια χρήσης που έχει επιλεγεί από το χρήστη προεπιλέγεται κατά το ανέβασμα ενός αρχείου μέσω του επιλογέα αρχείων. Διαφορετικά, προεπιλέγεται η προεπιλεγμένη άδεια τοποθεσίας του ιστοτόπου.';
$string['rememberusername'] = 'Να αποθηκευτεί το όνομα χρήστη';
$string['rememberusername_desc'] = 'Ενεργοποιήστε εάν θέλετε να αποθηκεύσετε μόνιμα cookies με ονόματα χρήστη κατά τη διάρκεια σύνδεσης χρήστη. Τα μόνιμα cookies μπορεί να θεωρηθούν ζήτημα απορρήτου εάν χρησιμοποιούνται χωρίς συγκατάθεση.';
$string['reportsmanage'] = 'Διαχείριση αναφορών';
$string['required'] = 'Απαιτείται';
$string['requiredentrieschanged'] = 'Σημείωση: Μετά την αναβάθμιση, η ρύθμιση «Απαιτούμενες καταχωρήσεις πριν από την προβολή» θα είναι υποχρεωτική στις ακόλουθες δραστηριότητες βάσης δεδομένων:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Απαιτείται περιγραφή δραστηριότητας';
$string['requiremodintro_desc'] = 'Εάν ενεργοποιηθεί, θα επιβάλλεται οι χρήστες να εισάγουν μια περιγραφή για κάθε δραστηριότητα.';
$string['requires'] = 'Απαιτείται';
$string['restorecourse'] = 'Επαναφορά μαθήματος';
$string['restorernewroleid'] = 'Ρόλος συντηρητή στα μαθήματα';
$string['restorernewroleid_help'] = 'Αν ο χρήστης δεν έχει ήδη δικαίωμα διαχείρισης του μαθήματος που επαναφέρθηκε πρόσφατα, ανατίθεται αυτόματα στο χρήστη αυτός ο ρόλος και εγγράφεται αν είναι απαραίτητο. Επιλέξτε «Καθόλου» αν δεν θέλετε οι συντηρητές να μπορούν να διαχειριστούν κάθε μάθημα που επαναφέρθηκε.';
$string['resultfilter'] = 'Φιλτράρισμα με βάση το αποτέλεσμα';
$string['reverseproxy'] = 'Αντίστροφος διακομιστής μεσολάβησης';
$string['reverseproxyignore'] = 'Αγνόηση αντίστροφων διακομιστών μεσολάβησης';
$string['riskconfig'] = 'Οι χρήστες μπορεί να αλλάξουν τις ρυθμίσεις του ιστοτόπου και τη συμπεριφορά του';
$string['riskconfigshort'] = 'Ρίσκο ρυθμίσεων';
$string['riskdataloss'] = 'Οι χρήστες μπορεί να καταστρέψουν πολύ υλικό ή πληροφορίες';
$string['riskdatalossshort'] = 'Ρίσκο απώλειας δεδομένων';
$string['riskmanagetrust'] = 'Οι χρήστες μπορούν να αλλάξουν τις ρυθμίσεις εμπιστοσύνης των άλλων χρηστών';
$string['riskmanagetrustshort'] = 'Διαχείριση ρυθμίσεων εμπιστοσύνης';
$string['riskpersonal'] = 'Χρήστες θα μπορούσαν να αποκτήσουν πρόσβαση σε ιδιωτικές πληροφορίες άλλων χρηστών';
$string['riskpersonalshort'] = 'Ρίσκο απορρήτου';
$string['riskspam'] = 'Οι χρήστες μπορούν να στείλουν ανεπιθύμητη αλληλογραφία σε άλλους χρήστες';
$string['riskspamshort'] = 'Ρίσκο ανεπιθύμητης αλληλογραφίας';
$string['riskxss'] = 'Οι χρήστες μπορούν να προσθέσουν αρχεία και κείμενα που επιτρέπουν cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS ρίσκο';
$string['roleswithexceptions'] = '{$a->roles} με {$a->exceptions}';
$string['rssglobaldisabled'] = 'Απενεργοποιημένο σε επίπεδο εξυπηρετητή';
$string['save'] = 'Αποθήκευση';
$string['savechanges'] = 'Αποθήκευση αλλαγών';
$string['scssinvalid'] = 'Ο κωδικός SCSS δεν είναι έγκυρος, αποτυγχάνει με: {$a}';
$string['search'] = 'Αναζήτηση';
$string['searchablecourses'] = 'Μαθήματα στα οποία μπορεί να γίνει αναζήτηση';
$string['searchallavailablecourses'] = 'Αναζητήσιμα μαθήματα';
$string['searchallavailablecourses_desc'] = 'Σε ορισμένες περιπτώσεις, η μηχανή αναζήτησης ενδέχεται να μην λειτουργεί όταν γίνεται αναζήτηση σε μεγάλο αριθμό μαθημάτων. Μπορείτε να πραγματοποιείτε αναζητήσεις μόνο στα εγγεγραμμένα μαθήματα αν θέλετε, για να περιορίσετε τον αριθμό των μαθημάτων στα οποία γίνεται η αναζήτηση.';
$string['searchallavailablecourses_off'] = 'Αναζήτηση στα εγγεγραμμένα μαθήματα μόνο';
$string['searchallavailablecourses_on'] = 'Αναζήτηση σε όλα τα μαθήματα που έχει πρόσβαση ο χρήστης';
$string['searchallavailablecoursesdesc'] = 'Εάν ορίσετε να γίνεται αναζήτηση μόνο στα μαθήματα στα οποία έχει γίνει εγγραφή, οι πληροφορίες μαθήματος (όνομα και περίληψη) και το περιεχόμενο μαθήματος θα αναζητηθούν μόνο σε μαθήματα στα οποία είναι εγγεγραμμένος ο χρήστης. Διαφορετικά, θα γίνεται αναζήτηση στις πληροφορίες μαθήματος και στο περιεχόμενο μαθήματος σε όλα τα μαθήματα στα οποία έχει πρόσβαση ο χρήστης, όπως είναι τα μαθήματα με ενεργοποιημένη πρόσβαση επισκεπτών.';
$string['searchalldeleted'] = 'Όλα τα περιεχόμενα με ευρετήριο έχουν διαγραφεί';
$string['searchalternatesettings'] = 'Εναλλακτικές ρυθμίσεις μόνο για ερωτήματα';
$string['searchalternatesettings_desc'] = 'Εάν ολοκληρώσετε αυτές τις ρυθμίσεις, μπορείτε να επιλέξετε «εναλλακτικές ρυθμίσεις» για αυτήν τη μηχανή αναζήτησης στην επιλογή «Μηχανή αναζήτησης μόνο για ερωτήματα» στη σελίδα «Διαχείριση καθολικής αναζήτησης». Αυτό είναι χρήσιμο μόνο όταν μετακινείστε μεταξύ δύο μηχανών αναζήτησης του ίδιου τύπου.';
$string['searchareadisabled'] = 'Η περιοχή αναζήτησης είναι απενεργοποιημένη';
$string['searchareaenabled'] = 'Η περιοχή αναζήτησης είναι ενεργοποιημένη';
$string['searchareas'] = 'Περιοχές αναζήτησης';
$string['searchbanner'] = 'Πληροφορίες αναζήτησης';
$string['searchbannerenable'] = 'Εμφάνιση πληροφοριών αναζήτησης';
$string['searchbannerenable_desc'] = 'Εάν ενεργοποιηθεί, το παρακάτω κείμενο θα εμφανίζεται στο επάνω μέρος της οθόνης αναζήτησης για όλους τους χρήστες. Αυτό μπορεί να χρησιμοποιηθεί για την ενημέρωση των χρηστών όταν πραγματοποιείται συντήρηση μηχανών αναζήτησης.';
$string['searchdefaultcategory'] = 'Προεπιλεγμένη κατηγορία αναζήτησης';
$string['searchdefaultcategory_desc'] = 'Τα αποτελέσματα από την επιλεγμένη κατηγορία περιοχής αναζήτησης θα εμφανιστούν από προεπιλογή.';
$string['searchdeleteindex'] = 'Διαγραφή όλων των περιεχομένων με ευρετήριο';
$string['searchdisplay'] = 'Επιλογές εμφάνισης αποτελεσμάτων αναζήτησης';
$string['searchenablecategories'] = 'Εμφάνιση αποτελεσμάτων σε ξεχωριστές κατηγορίες';
$string['searchenablecategories_desc'] = 'Εάν ενεργοποιηθεί, τα αποτελέσματα αναζήτησης θα εμφανίζονται σε ξεχωριστές κατηγορίες.';
$string['searchengine'] = 'Μηχανή αναζήτησης';
$string['searchenginealternatesettings'] = '{$a} (εναλλακτικές ρυθμίσεις)';
$string['searchenginequeryonly'] = 'Μηχανή αναζήτησης μόνο για ερωτήματα';
$string['searchenginequeryonly_desc'] = 'Αυτή η μηχανή αναζήτησης θα χρησιμοποιηθεί μόνο για υποβολή ερωτημάτων, όχι για ευρετηρίαση. Χρησιμοποιώντας αυτό το χαρακτηριστικό/δυνατότητα μπορείτε να δημιουργήσετε νέα ευρετήρια σε μια διαφορετική μηχανή αναζήτησης, ενώ τα ερωτήματα χρήστη συνεχίζουν να λειτουργούν από αυτήν.';
$string['searchenginequeryonly_none'] = 'Καμία (χρήση κύριας μηχανής αναζήτησης για ερωτήματα)';
$string['searchenginequeryonlysame'] = 'Η μηχανή αναζήτησης μόνο για ερωτήματα και η κύρια μηχανή αναζήτησης δεν μπορούν να οριστούν στην ίδια τιμή.';
$string['searchhideallcategory'] = 'Απόκρυψη της κατηγορίας Όλα τα αποτελέσματα';
$string['searchhideallcategory_desc'] = 'Εάν επιλεχθεί, θα γίνει απόκρυψη της κατηγορίας όλα τα αποτελέσματα από την οθόνη αποτελεσμάτων αναζήτησης.';
$string['searchincludeallcourses'] = 'Συμπερίληψη όλων των ορατών μαθημάτων';
$string['searchincludeallcourses_desc'] = 'Αν ενεργοποιηθεί, τα αποτελέσματα αναζήτησης θα περιλαμβάνουν πληροφορίες μαθήματος (όνομα και περίληψη) για τα μαθήματα που είναι ορατά στον χρήστη, ακόμη και αν δεν έχει ο χρήστης πρόσβαση στα περιεχόμενα των μαθημάτων.';
$string['searchindexactions'] = 'Ενέργειες δεικτοδότησης';
$string['searchindexdeleted'] = 'Το ευρετήριο διαγράφηκε';
$string['searchindextime'] = 'Όριο χρόνου δημιουργίας ευρετηρίου';
$string['searchindextime_desc'] = 'Κατά την δημιουργία ευρετηρίου μεγάλων ποσοτήτων νέου περιεχομένου, η χρονοπρογραμματισμένη εργασία θα σταματήσει μετά την επίτευξη αυτού του χρονικού ορίου. Θα συνεχιστεί την επόμενη φορά που θα εκτελεστεί η εργασία.';
$string['searchindexupdated'] = 'Τα περιεχόμενα της μηχανής αναζήτησης έχουν ενημερωθεί';
$string['searchindexwhendisabled'] = 'Ευρετηρίαση (δημιουργία ευρετηρίου) και όταν η αναζήτηση είναι απενεργοποιημένη';
$string['searchindexwhendisabled_desc'] = 'Επιτρέπει στην χρονοπρογραμματισμένη εργασία να δημιουργήσει το ευρετήριο αναζήτησης ακόμα και όταν η αναζήτηση είναι απενεργοποιημένη. Αυτό είναι χρήσιμο αν θέλετε να δημιουργήσετε το ευρετήριο πριν εμφανιστεί η δυνατότητα αναζήτησης σε μαθητές.';
$string['searchinsettings'] = 'Αναζήτηση στις ρυθμίσεις';
$string['searchlastrun'] = 'Τελευταία εκτέλεση (ώρα, # docs, # εγγραφές, # αγνοήσεις)';
$string['searchmanagement'] = 'Διαχείριση αναζήτησης';
$string['searchmanagement_desc'] = 'Αυτές οι επιλογές είναι χρήσιμες κατά την πραγματοποίηση αλλαγών σε ιστοτόπους με πολύ μεγάλα ευρετήρια αναζήτησης που χρειάζονται πολύ χρόνο για την αναδημιουργία τους.';
$string['searchnotavailable'] = 'Η αναζήτηση δεν είναι διαθέσιμη';
$string['searchoptions'] = 'Επιλογές αναζήτησης';
$string['searchpartial'] = '(δεν έχουν ακόμη πλήρως ευρετηριαστεί)';
$string['searchreindexed'] = 'Όλα τα περιεχόμενα του ιστοτόπου έχουν επανευρετηριαστεί.';
$string['searchreindexindex'] = 'Επανευρετηρίαση (επαναδημιουργία του ευρετηρίου) όλων των περιεχομένων του ιστοτόπου';
$string['searchresults'] = 'Αποτελέσματα αναζήτησης';
$string['searchsetupinfo'] = 'Διαμόρφωση αναζήτησης';
$string['searchupdateindex'] = 'Ενημέρωση ευρετηρίου περιεχομένων';
$string['sectionerror'] = 'Σφάλμα ενότητας!';
$string['secureforms'] = 'Χρήση επιπρόσθετης ασφάλειας στις φόρμες';
$string['security'] = 'Ασφάλεια';
$string['selectsearchengine'] = 'Επιλογή μηχανής αναζήτησης';
$string['server'] = 'Εξυπηρετητής';
$string['serverchecks'] = 'Έλεγχοι εξυπηρετητή';
$string['serverlimit'] = 'Όριο εξυπηρετητή';
$string['sessionautostartwarning'] = '<p>Εντοπίστηκε σοβαρό σφάλμα ρυθμίσεων· ενημερώστε τον διαχειριστή του εξυπηρετητή.</p>
<p>Για να λειτουργεί σωστά, το Moodle απαιτεί ο διαχειριστής να αλλάξει τις ρυθμίσεις PHP.</p>
<p><code>Το session.auto_start</code> πρέπει να ρυθμιστεί σε <code>off</code>.</p>
<p>Αυτή η ρύθμιση ελέγχεται τροποποιώντας το αρχείο <code>php.ini</code>, τις ρυθμίσεις του Apache/IIS ή το αρχείο <code>.htaccess</code> στον εξυπηρετητή.</p>';
$string['sessioncookie'] = 'Όνομα cookie';
$string['sessioncookiedomain'] = 'Τομέας cookie';
$string['sessioncookiepath'] = 'Μονοπάτι cookie';
$string['sessionhandling'] = 'Χειρισμός συνόδου';
$string['sessiontimeout'] = 'Τέλος χρόνου';
$string['sessiontimeoutwarning'] = 'Προειδοποίηση λήξης χρονικού ορίου';
$string['settingdependenton'] = 'Αυτή η ρύθμιση μπορεί να αποκρύπτεται, με βάση την τιμή του <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Απαιτείται ανέβασμα αρχείου για κανονική λειτουργία, παρακαλούμε ενεργοποιήστε το στις ρυθμίσεις της PHP.';
$string['settingmaxinputvars'] = 'Η ρύθμιση PHP max_input_vars συνιστάται να είναι τουλάχιστον 5000.';
$string['settingmaxinputvarsrequired'] = 'Η ρύθμιση PHP max_input_vars πρέπει να είναι τουλάχιστον 5000.';
$string['settingmemorylimit'] = 'Εντοπίστηκε ανεπαρκής μνήμη, παρακαλούμε θέστε υψηλότερα όρια μνήμης στις ρυθμίσεις της PHP.';
$string['settingsafemode'] = 'Το Moodle δεν είναι πλήρως συμβατό με την ασφαλή λειτουργία, παρακαλούμε ζητήστε την απενεργοποίησή της από το διαχειριστή του εξυπηρετητή. Η λειτουργία του Moodle κάτω από ασφαλή λειτουργία δεν υποστηρίζεται, παρακαλούμε αναμένετε διάφορα προβλήματα αν την χρησιμοποιήσετε.';
$string['setupsearchengine'] = 'Ρύθμιση της μηχανής αναζήτησης';
$string['showcommentscount'] = 'Εμφάνιση αριθμού σχολίων';
$string['showdetails'] = 'Εμφάνιση λεπτομερειών';
$string['showuseridentity'] = 'Εμφάνιση ταυτότητας χρήστη';
$string['showuseridentity_desc'] = 'Κατά την επιλογή ή αναζήτηση χρηστών, και κατά την εμφάνιση λιστών χρηστών, τα πεδία αυτά μπορεί να φαίνονται επιπρόσθετα με το πλήρες όνομα τους. Τα πεδία εμφανίζονται μόνο στους χρήστες που έχουν τη δυνατότητα moodle/site:viewuseridentity, από προεπιλογή, διδάσκοντες και διευθυντές. (Αυτή η επιλογή έχει νόημα, αν επιλέξετε ένα ή δύο πεδία που είναι υποχρεωτικά στο ίδρυμά σας.)

Τα πεδία που επισημαίνονται * είναι προσαρμοσμένα πεδία προφίλ χρήστη. Μπορείτε να επιλέξετε αυτά τα πεδία, αλλά προς το παρόν υπάρχουν ορισμένες οθόνες στις οποίες δεν θα εμφανίζονται.';
$string['simplexmlrequired'] = 'Η επέκταση SimpleXML της PHP απαιτείται τώρα από το Moodle.';
$string['sitemailcharset'] = 'Κωδικοποίηση χαρακτήρων';
$string['sitemaintenance'] = 'Πραγματοποιούνται εργασίες συντήρησης στο σύστημα.';
$string['sitemaintenancemode'] = 'Λειτουργία συντήρησης';
$string['sitemaintenanceoff'] = 'Οι εργασίες συντήρησης έχουν τελειώσει και το σύστημα λειτουργεί κανονικά.';
$string['sitemaintenanceon'] = 'Αυτή τη στιγμή εκτελούνται εργασίες συντήρησης στο σύστημα.';
$string['sitemaintenanceoncli'] = 'Ο ιστότοπός σας βρίσκεται αυτή τη στιγμή σε κατάσταση συντήρησης CLI (γραμμή εντολών). Δεν επιτρέπεται η πρόσβαση μέσω ιστού.';
$string['sitemaintenancetitle'] = '{$a} υπό συντήρηση';
$string['sitemaintenancewarning'] = 'Το σύστημα βρίσκεται σε κατάσταση συντήρησης (μόνο οι διαχειριστές μπορούν να εισέλθουν). Για να επιστρέψει το σύστημα σε κανονική λειτουργία: <a href="maintenance.php">απενεργοποιήστε την κατάσταση συντήρησης</a>.';
$string['sitemaintenancewarning2'] = 'Ο ιστότοπός σας βρίσκεται αυτή τη στιγμή σε κατάσταση συντήρησης (επιτρέπονται μόνο διαχειριστές). Για να επαναφέρετε τον ιστότοπο σε κανονική λειτουργία, <a href="{$a}">απενεργοποιήστε την κατάσταση συντήρησης</a>.';
$string['sitemenubar'] = 'Πλοήγηση ιστοτόπου';
$string['sitepolicies'] = 'Ρυθμίσεις ασφαλείας ιστοτόπου';
$string['sitepolicy'] = 'Διεύθυνση URL πολιτικής ιστοτόπου';
$string['sitepolicy_help'] = 'Η διεύθυνση URL της πολιτικής ιστοτόπου που όλοι οι καταχωρημένοι χρήστες πρέπει να δουν και να συμφωνήσουν πριν από την πρόσβαση στον ιστότοπο. Λάβετε υπόψη ότι αυτή η ρύθμιση θα έχει αποτέλεσμα μόνο εάν ως διαχειριστής πολιτικής ιστοτόπου έχει οριστεί ο προεπιλεγμένος (βασικός).';
$string['sitepolicyguest'] = 'Διεύθυνση URL πολιτικής ιστοτόπου για επισκέπτες';
$string['sitepolicyguest_help'] = 'Η διεύθυνση URL της πολιτικής ιστοτόπου που όλοι οι επισκέπτες πρέπει να βλέπουν και να συμφωνούν πριν από την πρόσβαση στον ιστότοπο. Λάβετε υπόψη ότι αυτή η ρύθμιση θα έχει αποτέλεσμα μόνο εάν ο διαχειριστής πολιτικής ιστοτόπου έχει οριστεί ως προεπιλεγμένος (πυρήνας).';
$string['sitepolicyhandler'] = '(Δια)χειριστής πολιτικής ιστοτόπου';
$string['sitepolicyhandler_desc'] = 'Αυτό καθορίζει τον τρόπο διαχείρισης των πολιτικών και των συγκαταθέσεων χρηστών. Ο προεπιλεγμένος χειριστής (βασικός) επιτρέπει τον καθορισμό μιας διεύθυνσης URL πολιτικής ιστοτόπου και μιας διεύθυνσης URL πολιτικής ιστοτόπου για επισκέπτες. Ο (δια)χειριστής πολιτικών επιτρέπει τον ορισμό πολιτικών ιστοτόπου, απορρήτου και άλλων. Παρέχει επίσης τη δυνατότητα να εμφανίζονται οι συναινέσεις των χρηστών και, αν είναι απαραίτητο, να δίνεται συγκατάθεση εκ μέρους ανηλίκων.';
$string['sitepolicyhandlercore'] = 'Προεπιλογή (βασικός)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Εάν επιλεγεί, μια ενότητα θέματος θα εμφανιστεί στην πρώτη σελίδα του ιστοτόπου.';
$string['sixtyfourbitswarning'] = 'Έχει εντοπιστεί ότι ο ιστότοπός σας δεν χρησιμοποιεί έκδοση PHP 64 bit.  Συνιστάται να αναβαθμίσετε τον ιστότοπό σας για να διασφαλίσετε μελλοντική συμβατότητα.';
$string['slasharguments'] = 'Χρήση παραμέτρων γραμμής εντολών';
$string['slashargumentswarning'] = 'Συνιστάται η ενεργοποίηση των παραμέτρων γραμμής εντολών. Στο μέλλον θα απαιτείται. Για περισσότερες λεπτομέρειες, δείτε την τεκμηρίωση <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>(Χρήση παραμέτρων γραμμής εντολών).';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Είδος αυθεντικοποίησης SMTP';
$string['smtpdetail'] = 'Ρυθμίσεις SMTP (απλό πρωτόκολλο μεταφοράς ηλε.ταχυδρομείου) για αποστολή ηλε.αλληλογραφίας';
$string['smtphosts'] = 'Κεντρικοί υπολογιστές SMTP';
$string['smtpmaxbulk'] = 'Όριο συνόδου SMTP';
$string['smtppass'] = 'Κωδικός πρόσβασης SMTP';
$string['smtpsecure'] = 'Ασφάλεια SMTP';
$string['smtpuser'] = 'Όνομα χρήστη SMTP';
$string['soaprecommended'] = 'Η εγκατάσταση της προαιρετικής επέκτασης SOAP είναι χρήσιμη για υπηρεσίες ιστού και για κάποια πρόσθετα.';
$string['sort_fullname'] = 'Πλήρες όνομα μαθήματος';
$string['sort_idnumber'] = 'Αναγνωριστικός αριθμός μαθήματος';
$string['sort_shortname'] = 'Σύντομο όνομα μαθήματος';
$string['sort_sortorder'] = 'Σειρά ταξινόμησης';
$string['spellengine'] = 'Μηχανισμός ελέγχου ορθογραφίας';
$string['spelllanguagelist'] = 'Λίστα γλωσσών με δυνατότητα ελέγχου ορθογραφίας';
$string['splrequired'] = 'Η επέκταση SPL PHP πλέον απαιτείται από το Moodle.';
$string['stats'] = 'Στατιστικά';
$string['statsfirstrun'] = 'Μέγιστος χρόνος επεξεργασίας';
$string['statsmaxruntime'] = 'Μέγιστος χρόνος εκτέλεσης';
$string['statsmoodleorg'] = 'στατιστικά';
$string['statsruntimedays'] = 'Ημέρες προς επεξεργασία';
$string['statsruntimestart'] = 'Εκτέλεση στις';
$string['statsuserthreshold'] = 'Όριο χρήστη';
$string['stickyblocks'] = 'Αυτοκόλλητο μπλοκ';
$string['stickyblockscourseview'] = 'Σελίδα μαθήματος';
$string['stickyblocksduplicatenotice'] = 'Εάν ένα μπλοκ που τοποθετείτε εδώ υπάρχει ήδη σε συγκεκριμένη σελίδα, θα δημιουργήσει αντίγραφο. Μόνο το καρφιτσωμένο μπλοκ θα είναι μη-τροποποιήσιμο, το αντίγραφο μπορείτε να το επεξεργαστείτε.';
$string['stickyblocksmymoodle'] = 'Το Moodle μου';
$string['stickyblockspagetype'] = 'Είδος σελίδας για ρύθμιση.';
$string['strictformsrequired'] = 'Αυστηρή επικύρωση των απαιτούμενων πεδίων';
$string['stripalltitletags'] = 'Αφαίρεση ετικετών HTML από όλα τα ονόματα δραστηριοτήτων';
$string['supportcontact'] = 'Επαφή υποστήριξης';
$string['supportemail'] = 'Υποστήριξη μηνυμάτων ηλε.ταχυδρομείου';
$string['supportname'] = 'Όνομα υποστήριξης';
$string['supportpage'] = 'Υποστήριξη σελίδας';
$string['suspenduser'] = 'Αναστολή λογαριασμού χρήστη';
$string['switchlang'] = 'Αλλαγή φακέλου γλώσσας';
$string['systempaths'] = 'Μονοπάτια συστήματος';
$string['tablenosave'] = 'Οι αλλαγές στον παραπάνω πίνακα αποθηκεύονται αυτόματα.';
$string['tablesnosave'] = 'Οι αλλαγές στον παραπάνω πίνακα αποθηκεύονται αυτόματα.';
$string['tabselectedtofront'] = 'Σε πίνακες με καρτέλες, η γραμμή με την επιλεγμένη καρτέλα να τοποθετούνται μπροστά;';
$string['tabselectedtofronttext'] = 'Φέρε την επιλεγμένη γραμμή καρτέλας μπροστά';
$string['task_adhoc_concurrency_limit'] = 'Όριο ταυτόχρονης εκτέλεσης εργασιών ειδικού σκοπού';
$string['task_adhoc_concurrency_limit_desc'] = 'Ο αριθμός των εκτελεστών εργασιών ειδικού σκοπού (ad hoc, επί τούτω, κατά περίπτωση) που επιτρέπεται να εκτελούνται ταυτόχρονα. Εάν το όριο είναι υψηλό τότε κάποιες χρονοπρογραμματισμένες εργασίες μπορεί να μην εκτελούνται κανονικά όταν υπάρχουν πολλές ειδικού σκοπού εργασίες. Μια ρύθμιση 0 θα απενεργοποιήσει πλήρως την επεξεργασία των εργασιών ειδικού σκοπού.';
$string['task_adhoc_max_runtime'] = 'Διάρκεια ζωής εκτελεστή εργασιών ειδικού σκοπού';
$string['task_adhoc_max_runtime_desc'] = 'Η ηλικία ενός εκτελεστή (runner) εργασίας ειδικού σκοπού πριν απελευθερωθεί. Συνιστάται σύντομη διάρκεια διότι δεν υπάρχει όριο στον αριθμό των εργασιών ειδικού σκοπού που βρίσκονται σε ουρά. Εάν ο αριθμός αυτός είναι υπερβολικά υψηλός και έχετε μια μεγάλη ουρά αναμονής εργασιών ειδικού σκοπού, τότε χρονοπρογραμματισμένες εργασίες ενδέχεται να μην εκτελούνται κανονικά.';
$string['task_dbstats'] = 'Βάση Δεδομένων';
$string['task_duration'] = 'Διάρκεια';
$string['task_logmode'] = 'Πότε να γίνονται καταγραφές';
$string['task_logmode_all'] = 'Αποθηκεύστε τις καταγραφές όλων των εργασιών';
$string['task_logmode_desc'] = 'Μπορείτε να επιλέξετε πότε επιθυμείτε να πραγματοποιηθεί η καταγραφή εργασιών. Από προεπιλογή, οι καταγραφές συλλέγονται πάντα. Μπορείτε να απενεργοποιήσετε τις καταγραφές τελείως ή να τις αλλάξετε για καταγραφή μόνο εργασιών που αποτυγχάνουν.';
$string['task_logmode_failonly'] = 'Αποθηκεύστε μόνο καταγραφές για εργασίες που αποτυγχάνουν';
$string['task_logmode_none'] = 'Να μην καταγράφεται τίποτα';
$string['task_logoutput'] = 'Έξοδος εργασίας';
$string['task_logretainruns'] = 'Διατήρηση εκτελέσεων';
$string['task_logretainruns_desc'] = 'Ο αριθμός των εκτελέσεων κάθε εργασίας προς διατήρηση. Αυτή η ρύθμιση αλληλεπιδρά με τη ρύθμιση «Περίοδος διατήρησης»: θα εφαρμοστεί όποια επιτεύχθηκε πρώτη.';
$string['task_logretention'] = 'Περίοδος διατήρησης';
$string['task_logretention_desc'] = 'Η μέγιστη περίοδος που πρέπει να διατηρούνται οι καταγραφές. Αυτή η ρύθμιση αλληλεπιδρά με τη ρύθμιση «Διατήρηση εκτελέσεων»: θα εφαρμοστεί όποια επιτεύχθηκε πρώτη.';
$string['task_logtostdout'] = 'Εμφάνιση εξόδου καταγραφών';
$string['task_logtostdout_desc'] = 'Όταν εκτελούνται εργασίες και γίνεται σύλληψη της εξόδου, εάν θα πρέπει εκτός από σύλληψη να γίνεται και εμφάνιση κατά τη διάρκεια της εκτέλεσης.';
$string['task_result'] = 'Αποτέλεσμα';
$string['task_result:failed'] = 'Αποτυχία';
$string['task_scheduled_concurrency_limit'] = 'Όριο αριθμού ταυτόχρονων χρονοπρογραμματισμένων εργασιών';
$string['task_scheduled_concurrency_limit_desc'] = 'Ο αριθμός των χρονοπρογραμματισμένων εκτελεστών εργασιών που επιτρέπεται να εκτελούνται ταυτόχρονα. Εάν το όριο είναι υψηλό τότε ο εξυπηρετητής ενδέχεται να παρουσιάσει υψηλό φορτίο το οποίο επηρεάζει την απόδοση. Μια ρύθμιση 0 θα απενεργοποιήσει τελείως την επεξεργασία των χρονοπρογραμματισμένων εργασιών.';
$string['task_scheduled_max_runtime'] = 'Χρονοπρογραμματισμένη διάρκεια ζωής του εκτελεστή εργασιών';
$string['task_scheduled_max_runtime_desc'] = 'Η ηλικία ενός χρονοπρογραμματισμένου εκτελεστή εργασίας προτού απελευθερωθεί.';
$string['task_starttime'] = 'Ώρα έναρξης';
$string['task_stats:dbreads'] = '{$a} αναγνώσεις';
$string['task_stats:dbwrites'] = '{$a} εγγραφές';
$string['task_status'] = 'Κατάσταση εργασίας';
$string['task_status_desc'] = 'Η εργασία <q>{$a->name}</q> είναι <strong>{$a->status}</strong>.<br />Δείτε τις <a href="{$a->gotourl}">λεπτομέρειές</a> της.<br />Κλάση: {$a->class}{$a->extradescription}';
$string['task_type:adhoc'] = 'Ειδικού σκοπού';
$string['task_type:scheduled'] = 'Χρονοπρογραμματισμένα';
$string['taskadmintitle'] = 'Εργασίες';
$string['taskanalyticscleanup'] = 'Καθαρισμός αναλυτικών';
$string['taskautomatedbackup'] = 'Αυτόματη δημιουργία αντιγράφων ασφαλείας';
$string['taskbackupcleanup'] = 'Καθαρισμός αντιγράφων ασφαλείας πινάκων, καταγραφών και αρχείων';
$string['taskbadgescron'] = 'Απονομή διακριτικών';
$string['taskbadgesmessagecron'] = 'Επεξεργασία παρασκηνίου για την αποστολή ειδοποιήσεων διακριτικών';
$string['taskblogcron'] = 'Συγχρονισμός εξωτερικών ιστολογίων';
$string['taskcachecleanup'] = 'Διαγραφή ληγμένων καταχωρήσεων κρυφής μνήμης';
$string['taskcachecron'] = 'Επεξεργασία στο παρασκήνιο για κρυφές μνήμες';
$string['taskcalendarcron'] = 'Αποστολή ειδοποιήσεων ημερολογίου';
$string['taskcheckforupdates'] = 'Έλεγχος για ενημερώσεις';
$string['taskcompletiondaily'] = 'Επισήμανση ολοκλήρωσης ως «Ξεκίνησε»';
$string['taskcompletionregular'] = 'Υπολογισμός κανονικών δεδομένων ολοκλήρωσης';
$string['taskcontextcleanup'] = 'Καθαρισμός συμφραζομένων';
$string['taskcreatecontexts'] = 'Δημιουργία συμφραζομένων που λείπουν';
$string['taskdeleteincompleteusers'] = 'Διαγραφή μη ολοκληρωμένων χρηστών';
$string['taskdeleteunconfirmedusers'] = 'Διαγραφή μη επιβεβαιωμένων χρηστών';
$string['taskeventscron'] = 'Επεξεργασία παρασκηνίου για γεγονότα';
$string['taskfiletrashcleanup'] = 'Εκκαθάριση αρχείων στον κάδο απορριμμάτων';
$string['taskglobalsearchindex'] = 'Ευρετηρίαση καθολικής αναζήτησης';
$string['taskglobalsearchoptimize'] = 'Βελτιστοποίηση ευρετηρίασης καθολικής αναζήτησης';
$string['taskgradecron'] = 'Επεξεργασία παρασκηνίου για βαθμολόγιο';
$string['taskgradehistorycleanup'] = 'Επεξεργασία παρασκηνίου για εκκαθάριση πινάκων ιστορικού βαθμών';
$string['taskh5pcleanup'] = 'Εκκαθάριση αρχείων H5P που δεν χρησιμοποιούνται';
$string['tasklegacycron'] = 'Επεξεργασία της εντολής χρονοπρογραμματισμού cron παλαιότερης έκδοσης για πρόσθετα';
$string['tasklogcleanup'] = 'Καθαρισμός καταγραφών εργασιών';
$string['tasklogging'] = 'Ρυθμίσεις καταγραφών εργασίας';
$string['tasklogs'] = 'Καταγραφές εργασιών';
$string['taskmessagingcleanup'] = 'Επεξεργασία παρασκηνίου για την ανταλλαγή μηνυμάτων';
$string['taskpasswordresetcleanup'] = 'Εκκαθάριση προσπαθειών επαναρχικοποίησης κωδικού πρόσβασης';
$string['taskplagiarismcron'] = 'Επεξεργασία παρασκηνίου για την εντολή χρονοπρογραμματισμού cron παλαιότερης έκδοσης σε πρόσθετα λογοκλοπής';
$string['taskportfoliocron'] = 'Επεξεργασία παρασκηνίου για πρόσθετα χαρτοφυλακίου';
$string['taskprocessing'] = 'Επεξεργασία εργασίας';
$string['taskquestioncron'] = 'Επεξεργασία παρασκηνίου για εκκαθάριση προεπισκοπήσεων ερωτήσεων';
$string['taskquestionstatscleanupcron'] = 'Επεξεργασία παρασκηνίου για εκκαθάριση κρυφής μνήμης στατιστικών των ερωτήσεων';
$string['taskrefreshsystemtokens'] = 'Ανανεώστε τα κουπόνια OAuth για λογαριασμούς υπηρεσίας';
$string['taskregistrationcron'] = 'Καταχώρηση ιστοτόπου';
$string['tasksendfailedloginnotifications'] = 'Αποστολή ειδοποιήσεων αποτυχημένων προσπαθειών σύνδεσης';
$string['tasksendnewuserpasswords'] = 'Αποστολή νέων κωδικών πρόσβασης χρηστών';
$string['tasksessioncleanup'] = 'Ξεκαθάρισμα παλαιών συνόδων';
$string['taskstatscron'] = 'Επεξεργασία παρασκηνίου για στατιστικές';
$string['tasktagcron'] = 'Επεξεργασία παρασκηνίου για ετικέτες';
$string['tasktempfilecleanup'] = 'Διαγραφή παλαιών προσωρινών αρχείων';
$string['tasktype'] = 'Τύπος';
$string['tempdatafoldercleanup'] = 'Εκκαθάριση προσωρινών αρχείων δεδομένων παλαιότερων από';
$string['templates'] = 'Υποδείγματα';
$string['testoutgoingmailconf'] = 'Δοκιμή ρυθμίσεων εξερχόμενης ηλε.αλληλογραφίας';
$string['testoutgoingmailconf_errorcommunications'] = 'Ο ιστότοπός σας δεν μπόρεσε να επικοινωνήσει με τον εξυπηρετητή ηλε.αλληλογραφίας σας. Παρακαλούμε, ελέγξτε τις ρυθμίσεις εξερχόμενης ηλε.αλληλογραφίας σας.';
$string['testoutgoingmailconf_fromemail'] = 'Από το όνομα χρήστη ή τη διεύθυνση ηλεκτρονικού ταχυδρομείου';
$string['testoutgoingmailconf_fromemail_help'] = 'Αυτό το πεδίο προσομοιώνει την αποστολή του μηνύματος από αυτόν τον χρήστη, αλλά η κεφαλίδα Από που χρησιμοποιείται στο πραγματικό μήνυμα ηλε.ταχυδρομείου που θα σταλεί θα εξαρτηθεί από άλλες ρυθμίσεις, όπως επιτρεπόμενοι τομείς διευθύνσεων ηλε.ταχυδρομείου';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Μη έγκυρο όνομα χρήστη ή διεύθυνση ηλε.ταχυδρομείου στο πεδίο Από. Πρέπει να είναι έγκυρη μορφή διεύθυνσης ηλε.ταχυδρομείου ή υπάρχον όνομα χρήστη στο Moodle.';
$string['testoutgoingmailconf_message'] = 'Αυτό είναι ένα δοκιμαστικό μήνυμα προς επιβεβαίωση επιτυχούς ρύθμισης της εξερχόμενης ηλε.αλληλογραφίας του ιστοτόπου σας. Στάλθηκε:{$a}';
$string['testoutgoingmailconf_sendtest'] = 'Αποστολή ενός δοκιμαστικού μηνύματος';
$string['testoutgoingmailconf_sentmail'] = 'Αυτός ο ιστότοπος απέστειλε επιτυχώς ένα δοκιμαστικό μήνυμα στον εξυπηρετητή ηλε.ταχυδρομείου<br />Από: {$a->fromemail}<br />Προς: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: δοκιμαστικό μήνυμα.
{$a->additional} Στάλθηκε: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Πρόσθετο θέμα';
$string['testoutgoingmailconf_toemail'] = 'Διεύθυνση ηλε.ταχυδρομείου παραλήπτη (Προς)';
$string['testoutgoingmaildetail'] = 'Σημείωση: Πριν τις δοκιμές, παρακαλούμε αποθηκεύστε τις ρυθμίσεις σας.<br />{$a}';
$string['testsiteupgradewarning'] = 'Αυτή τη στιγμή χρησιμοποιείτε τον δοκιμαστικό ιστότοπο {$a}. Για να τον αναβαθμίσετε κατάλληλα χρησιμοποιήστε την γραμμή εντολών (εργαλείο CLI).';
$string['themedesignermode'] = 'Κατάσταση λειτουργίας σχεδιασμού αισθητικού θέματος';
$string['themedesignermodewarning'] = 'Η λειτουργία σχεδιασμού αισθητικού θέματος είναι ενεργοποιημένη. Αυτό δεν πρέπει να ενεργοποιείται στους χώρους παραγωγής, καθώς μπορεί να μειώσει σημαντικά την απόδοση.';
$string['themelist'] = 'Λίστα θεμάτων';
$string['themeresetcaches'] = 'Εκκαθάριση κρυφών μνημών αισθητικού θέματος';
$string['themeselect'] = 'Αλλαγή αισθητικού θέματος';
$string['themeselector'] = 'Επιλογή αισθητικού θέματος';
$string['therewereerrors'] = 'Υπήρχαν σφάλματα στα δεδομένα σας';
$string['thirdpartylibrary'] = 'Βιβλιοθήκη';
$string['thirdpartylibrarylocation'] = 'Τοποθεσία';
$string['thirdpartylibs'] = 'Βιβλιοθήκες λογισμικού τρίτων';
$string['timezone'] = 'Προεπιλεγμένη ζώνη ώρας';
$string['timezoneforced'] = 'Αυτή η επιλογή επιβάλλεται από το διαχειριστή ιστοτόπου';
$string['timezoneinvalid'] = 'Άκυρη ζώνη ώρας «{$a}»';
$string['timezoneisforcedto'] = 'Επιβολή χρήσης από όλους τους χρήστες';
$string['timezonenotforced'] = 'Οι χρήστες μπορούν να επιλέξουν τη δική τους ζώνη ώρας';
$string['timezonephpdefault'] = 'Προεπιλεγμένη ζώνη ώρας PHP ({$a})';
$string['timezoneserver'] = 'Ζώνη ώρας εξυπηρετητή ({$a})';
$string['tlswarning'] = 'Δεν ανιχνεύθηκε επέκταση PHP/cURL με υποστήριξη TLSv1.2. Ορισμένες υπηρεσίες ενδέχεται να μην λειτουργούν. Συνιστάται ένθερμα να αναβαθμίσετε τις βιβλιοθήκες TLS.';
$string['tokenduration'] = 'Διάρκεια κουπονιού δημιουργημένου από το χρήστη';
$string['tokenduration_desc'] = 'Το χρονικό διάστημα για το οποίο είναι έγκυρο ένα κουπόνι υπηρεσιών ιστού που δημιουργήθηκε από έναν χρήστη (για παράδειγμα μέσω της εφαρμογής κινητού).';
$string['tokenizerrecommended'] = 'Συνιστάται η εγκατάσταση της προαιρετικής επέκτασης PHP Tokenizer (διαχωριστής λεκτικών μονάδων) -- βελτιώνει τη λειτουργικότητα δικτύωσης του Moodle.';
$string['tools'] = 'Εργαλεία διαχειριστή';
$string['toolsmanage'] = 'Διαχείριση εργαλείων διαχειριστή';
$string['unattendedoperation'] = 'Ανεπίβλεπτη λειτουργία';
$string['unbookmarkthispage'] = 'Διαγραφή σελιδοδείκτη';
$string['unicoderequired'] = 'Απαιτείται η αποθήκευση όλων των δεδομένων σε Unicode (UTF-8). Νέες εγκαταστάσεις πρέπει να εκτελεστούν σε βάσεις δεδομένων που έχουν ως προεπιλεγμένο charset το Unicode. Εάν αναβαθμίζετε, εκτελέστε τη διαδικασία μετεγκατάστασης (μεταφορά/μετατροπή) της UTF-8 (δείτε την σελίδα του Διαχειριστή).';
$string['uninstallplugin'] = 'Απεγκατάσταση';
$string['unlockaccount'] = 'Ξεκλείδωμα λογαριασμού';
$string['unoconvwarning'] = 'Η έκδοση του unoconv (Universal Office Converter: μετατροπέας μορφότυπων εγγράφων) που έχετε εγκαταστήσει δεν υποστηρίζεται.';
$string['unsupported'] = 'Δεν υποστηρίζεται';
$string['unsupporteddbfileformat'] = 'Η βάση δεδομένων σας χρησιμοποιεί το Antelope ως μορφότυπο αρχείου. Η πλήρης υποστήριξη UTF-8 σε MySQL και MariaDB απαιτεί τον μορφότυπο αρχείου Barracuda. Παρακαλούμε, αλλάξτε τον μορφότυπο σε Barracuda. Δείτε την τεκμηρίωση <a href="https://docs.moodle.org/el/admin/environment/custom check/mysql full support unicode">Πλήρης υποστήριξη Unicode για MySQL</a> για λεπτομέρειες.';
$string['unsupporteddbfilepertable'] = 'Για πλήρη υποστήριξη του UTF-8, τόσο η MySQL όσο και η MariaDB απαιτούν να αλλάξετε τη ρύθμιση MySQL «innodb_file_per_table» σε «ON». Ανατρέξτε στην τεκμηρίωση για περισσότερες λεπτομέρειες.';
$string['unsupporteddblargeprefix'] = 'Για την πλήρη υποστήριξη του UTF-8 τόσο η MySQL όσο και η MariaDB σας ζητούν να αλλάξετε τη ρύθμιση MySQL «innodb_large_prefix» σε «ON». Ανατρέξτε στην τεκμηρίωση για περισσότερες λεπτομέρειες.';
$string['unsupporteddbstorageengine'] = 'Ο χρησιμοποιούμενος μηχανισμός αποθήκευσης βάσεων δεδομένων δεν υποστηρίζεται πλέον.';
$string['unsupporteddbtablerowformat'] = 'Η βάση δεδομένων σας έχει πίνακες που χρησιμοποιούν το Antelope ως μορφότυπο αρχείου. Συνιστάται να μετατρέψετε τους πίνακες στο μορφότυπο Barracuda. Ανατρέξτε στην τεκμηρίωση στη <a href="https://docs.moodle.org/en/cli">Διαχείριση μέσω γραμμής εντολών</a> για λεπτομέρειες σχετικά με ένα εργαλείο μετατροπής πινάκων από InnoDB σε Barracuda.';
$string['unsupportedphpversion7'] = 'Η έκδοση 7 της PHP δεν υποστηρίζεται';
$string['unsupportedphpversion71'] = 'Η έκδοση 7.1 της PHP δεν υποστηρίζεται';
$string['unsupportedphpversion72'] = 'Η έκδοση 7.2 της PHP δεν υποστηρίζεται';
$string['unsupportedphpversion73'] = 'Η έκδοση 7.3 της PHP δεν υποστηρίζεται.';
$string['unsupportedphpversion74'] = 'Η έκδοση 7.4 της PHP δεν υποστηρίζεται.';
$string['unsupportedphpversion80'] = 'Η έκδοση PHP 8.0 δεν υποστηρίζεται.';
$string['unsuspenduser'] = 'Ενεργοποίηση λογαριασμού χρήστη';
$string['updateaccounts'] = 'Ανανέωση υπαρχόντων λογαριασμών';
$string['updateautocheck'] = 'Αυτόματος έλεγχος για διαθέσιμες ενημερώσεις';
$string['updateautocheck_desc'] = 'Εάν ενεργοποιηθεί, ο ιστότοπός σας θα ελέγχει αυτόματα για διαθέσιμες ενημερώσεις τόσο για τον κώδικα Moodle όσο και για όλα τα επιπλέον πρόσθετα. Εάν υπάρχει διαθέσιμη μια νέα ενημέρωση, μια ειδοποίηση θα σταλεί στους διαχειριστές ιστοτόπου.';
$string['updateavailable'] = 'Υπάρχει μια νεότερη έκδοση του Moodle διαθέσιμη!';
$string['updateavailable_moreinfo'] = 'Περισσότερες πληροφορίες...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Έκδοση {$a}';
$string['updateavailabledetailslink'] = 'Για περισσότερες λεπτομέρειες, ανατρέξτε στη σελίδα {$a->url}';
$string['updateavailableforplugin'] = 'Υπάρχει νεότερη έκδοση για κάποιο/-α από τα πρόσθετα!';
$string['updateavailableinstall'] = 'Εγκατάσταση αυτής της ενημέρωσης';
$string['updateavailableinstallall'] = 'Εγκατάσταση διαθέσιμων ενημερώσεων ({$a})';
$string['updateavailableinstallallhead'] = 'Εγκατάσταση διαθέσιμων ενημερώσεων';
$string['updateavailablenot'] = 'Ο πηγαίος κώδικας του Moodle σας είναι ενημερωμένος!';
$string['updateavailablerecommendation'] = 'Συνιστάται ένθερμα να ενημερώσετε τον ιστότοπό σας στην τελευταία έκδοση για να αποκτήσετε όλες τις πρόσφατες διορθώσεις ασφάλειας και σφαλμάτων.';
$string['updatecomponent'] = 'Ενημέρωση στοιχείου λογισμικού';
$string['updateminmaturity'] = 'Απαιτούμενη ωριμότητα κώδικα';
$string['updateminmaturity_desc'] = 'Ειδοποίηση για τις διαθέσιμες ενημερώσεις μόνο εάν ο διαθέσιμος κωδικός έχει τουλάχιστον το επιλεγμένο επίπεδο ωριμότητας. Οι ενημερώσεις για τα πρόσθετα που δεν δηλώνουν το επίπεδο ωριμότητας του κώδικα αναφέρονται πάντοτε ανεξάρτητα από αυτή τη ρύθμιση.';
$string['updatenotificationfooter'] = 'Ο ιστότοπός σας Moodle {$a->siteurl} έχει ρυθμιστεί ώστε να ελέγχει αυτόματα για διαθέσιμες ενημερώσεις. Λαμβάνετε αυτό το μήνυμα ως διαχειριστής του ιστοτόπου. Μπορείτε να απενεργοποιήσετε τους αυτόματους ελέγχους για διαθέσιμες ενημερώσεις στις ειδοποιήσεις στη Διαχείριση ιστοτόπου / Εξυπηρετητής / Ενημερώσεις ή να προσαρμόσετε την παράδοση αυτού του μηνύματος μέσω της σελίδας σας προτιμήσεων.';
$string['updatenotifications'] = 'Ειδοποιήσεις ενημερώσεων';
$string['updatenotificationsubject'] = 'Υπάρχουν διαθέσιμες ενημερώσεις για το Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Ειδοποίηση για νέες εσωτερικές εκδόσεις (builds)';
$string['updatenotifybuilds_desc'] = 'Εάν ενεργοποιηθεί, η διαθέσιμη ενημέρωση για τον κώδικα του Moodle ανακοινώνεται επίσης όταν είναι διαθέσιμη μια νέα εσωτερική έκδοση (build). Οι εσωτερικές εκδόσεις είναι συνεχείς βελτιώσεις μιας συγκεκριμένης έκδοσης του Moodle. Γενικά κυκλοφορούν κάθε εβδομάδα. Εάν απενεργοποιηθεί, η διαθέσιμη ενημέρωση θα αναφερθεί μόνο όταν κυκλοφορήσει μια υψηλότερη έκδοση του Moodle. Οι έλεγχοι για τα πρόσθετα δεν επηρεάζονται από αυτή τη ρύθμιση.';
$string['upgradeerror'] = 'Άγνωστο σφάλμα κατά την αναβάθμιση του {$a->plugin} στην έκδοση {$a->version}. Αδυναμία συνέχισης.';
$string['upgradeforumread'] = 'Ένα καινούργιο χαρακτηριστικό/δυνατότητα προστέθηκε στο Moodle 1.5 για την παρακολούθηση διαβασμένων/μη-διαβασμένων αναρτήσεων φόρουμ.<br />Για να χρησιμοποιήσετε αυτή τη λειτουργία πρέπει να <a href="{$a}">ενημερώσετε τους πίνακές σας</a>.';
$string['upgradeforumreadinfo'] = 'Ένα καινούργιο χαρακτηριστικό/δυνατότητα προστέθηκε στο Moodle 1.5 για την παρακολούθηση διαβασμένων/μη-διαβασμένων αναρτήσεων φόρουμ. Για να χρησιμοποιήσετε τη δυνατότητα αυτή πρέπει να ενημερώσετε τους πίνακές σας με όλες τις πληροφορίες παρακολούθησης για υπάρχουσες αναρτήσεις. Ανάλογα με το μέγεθος της σελίδας σας αυτό μπορεί να πάρει αρκετό χρόνο (ώρες) και επιβαρύνει αρκετά την βάση δεδομένων, οπότε καλό είναι να εκτελεστεί σε μια ήσυχη περίοδο. Ωστόσο, η σελίδα θα συνεχίσει να λειτουργεί και οι χρήστες δεν θα επηρεαστούν. Αν ξεκινήσετε τη διαδικασία, αφήστε τη να ολοκληρωθεί (κρατήστε ανοιχτό το παράθυρο του περιηγητή σας). Ωστόσο, εάν σταματήσετε τη διαδικασία μπορείτε να αρχίσετε από την αρχή. Θέλετε να ξεκινήσει η διαδικασία αναβάθμισης τώρα;';
$string['upgradekeyreq'] = 'Απαιτείται κλειδί αναβάθμισης';
$string['upgradekeyset'] = 'Κλειδί αναβάθμισης (αφήστε κενό για να μην το ορίσετε)';
$string['upgradelogs'] = 'Για να έχετε πλήρη λειτουργικότητα, οι παλιές σας καταγραφές πρέπει να αναβαθμιστούν. <a href="{$a}"> Περισσότερες πληροφορίες </a>';
$string['upgradelogsinfo'] = 'Κάποιες αλλαγές έγιναν πρόσφατα στον τρόπο με τον οποίο αποθηκεύονται οι καταγραφές. Για να μπορείτε να δείτε όλες τις παλιές καταγραφές σας ανά δραστηριότητα, πρέπει να αναβαθμίσετε τις παλιές σας καταγραφές. Ανάλογα με το μέγεθος του ιστοτόπου σας αυτό μπορεί να πάρει αρκετό χρόνο (π.χ. ώρες) και για μεγάλους ιστοτόπους επιβαρύνει αρκετά τη βάση δεδομένων. Αν ξεκινήσετε την διαδικασία, αφήστε την να ολοκληρωθεί (κρατώντας ανοιχτό το παράθυρο του περιηγητή σας). Μην ανησυχείτε - ο ιστότοπός σας συνεχίζει να λειτουργεί και οι χρήστες δεν επηρεάζονται όσο οι καταγραφές αναβαθμίζονται. <br /><br /> Θέλετε να αναβαθμίσετε τις καταγραφές σας τώρα;';
$string['upgradepluginsfirst'] = 'Συνιστάται πρώτα να εγκαταστήσετε όλες τις διαθέσιμες ενημερώσεις';
$string['upgradepluginsinfo'] = 'Ενημέρωση πρόσθετων...';
$string['upgradepluginsinfo_help'] = 'Υπάρχουν διαθέσιμες ενημερώσεις για ορισμένα από τα πρόσθετά σας. Θα πρέπει να τα εγκαταστήσετε όλα πριν από την αναβάθμιση της βάσης δεδομένων του Moodle. Αν ο ιστότοπός σας δεν υποστηρίζει την αυτόματη εγκατάσταση/χρήση ενημερώσεων, θα πρέπει να κάνετε λήψη και εγκατάσταση των νέων εκδόσεων των πρόσθετων στον εξυπηρετητή σας χειροκίνητα.';
$string['upgradepluginsinfo_link'] = '';
$string['upgradesettings'] = 'Νέες ρυθμίσεις';
$string['upgradesettingsintro'] = 'Οι παρακάτω ρυθμίσεις προστέθηκαν κατά την τελευταία αναβάθμισή σας του Moodle. Κάντε όσες αλλαγές είναι απαραίτητες στις προεπιλογές και μετά κάντε κλικ στο πλήκτρο «Αποθήκευση αλλαγών» στο κάτω μέρος αυτής της σελίδας.';
$string['upgradestalefiles'] = 'Εντοπίστηκαν μικτές εκδόσεις Moodle· η αναβάθμιση δεν μπορεί να συνεχιστεί';
$string['upgradestalefilesinfo'] = 'Η διαδικασία ενημέρωσης του Moodle έχει τεθεί σε παύση επειδή εντοπίστηκαν σενάρια PHP από τουλάχιστον δύο μεγάλες εκδόσεις του Moodle στον φάκελο Moodle. Αυτό μπορεί να προκαλέσει σημαντικά προβλήματα αργότερα, οπότε για να συνεχίσετε πρέπει να βεβαιωθείτε ότι ο φάκελο Moodle περιέχει μόνο αρχεία για μια μόνο έκδοση του Moodle. Ο συνιστώμενος τρόπος για να καθαρίσετε τον φάκελο Moodle σας είναι ο εξής:

* μετονομάστε τον τρέχοντα φάκελο Moodle σε «moodle_old»
* δημιουργήστε έναν νέο φάκελο Moodle που περιέχει μόνο αρχεία είτε από μια λήψη τυπικού πακέτου Moodle είτε από το χώρο του Moodle στο αποθετήριο Git
* μετακινήστε το αρχικό config.php αρχείο και τυχόν μη τυποποιημένα πρόσθετα από τον φάκελο «moodle_old» στον νέο φάκελο Moodle.

Όταν έχετε πια έναν καθαρό φάκελο Moodle, ανανεώστε αυτή τη σελίδα για να συνεχίσετε τη διαδικασία ενημέρωσης του Moodle.

Αυτή η προειδοποίηση προκαλείται συχνά από την αποσυμπίεση ενός τυπικού πακέτου Moodle σε μια προηγούμενη έκδοση του Moodle. Αν και αυτό είναι εντάξει για δευτερεύουσες αναβαθμίσεις, αποθαρρύνεται έντονα για σημαντικές αναβαθμίσεις του Moodle.

Αυτή η προειδοποίηση μπορεί επίσης να προκληθεί από μη ολοκληρωμένη λειτουργία ελέγχου ή ενημέρωσης από το αποθετήριο Git, οπότε ίσως απλώς χρειαστεί να περιμένετε να ολοκληρωθεί η διαδικασία ή ίσως να εκτελέσετε την κατάλληλη εντολή καθαρισμού και να δοκιμάστε ξανά τη λειτουργία.

Μπορείτε να βρείτε περισσότερες πληροφορίες στην τεκμηρίωση της αναβάθμισης στη διεύθυνση <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Αναβαθμίστε τη βάση δεδομένων του Moodle τώρα';
$string['upgradesure'] = 'Τα αρχεία του Moodle άλλαξαν και πρόκειται να αναβαθμίσετε τον εξυπηρετητή στην έκδοση<br /><br /><strong>{$a}</strong><br /><br />Μόλις το κάνετε δεν μπορείτε να επιστρέψετε.<br /><br />Σίγουρα θέλετε να αναβαθμίσετε τον εξυπηρετητή σε αυτή την έκδοση;';
$string['upgradetimedout'] = 'Η αναβάθμιση ξεπέρασε το μέγιστο χρόνο. Παρακαλούμε επανεκκινήστε την αναβάθμιση.';
$string['upgradingdata'] = 'Αναβάθμιση των δεδομένων';
$string['upgradinglogs'] = 'Αναβάθμιση των καταγραφών...';
$string['upgradingversion'] = 'Αναβάθμιση στην επόμενη έκδοση';
$string['upwards'] = 'προς τα επάνω';
$string['useblogassociations'] = 'Ενεργοποίηση συσχετίσεων';
$string['user'] = 'Χρήστης';
$string['userbulk'] = 'Μαζικές ενέργειες χρήστη';
$string['userbulkdownload'] = 'Εξαγωγή χρηστών ως';
$string['userdefaultpreferences'] = 'Προεπιλεγμένες προτιμήσεις χρήστη';
$string['userfeedbackafterupgrade'] = 'Μετά από κάθε σημαντική αναβάθμιση';
$string['userfeedbackencouragement'] = '<p>Το Moodle 3.9 περιλαμβάνει έναν νέο χαρακτηριστικό που δίνει στους χρήστες την επιλογή να παρέχουν ανατροφοδότηση για το λογισμικό Moodle στο επιτελείο του Moodle HQ μέσω ενός εξωτερικού ιστοτόπου έρευνας που φιλοξενείται από το Moodle HQ. Δεν προωθούνται πληροφορίες αναγνώρισης χρήστη στον ιστότοπο έρευνας.</p>
<p>Το επιτελείο του Moodle HQ προσπαθεί να είναι ανοικτό και διαφανές σχετικά με τις πρακτικές συλλογής δεδομένων του. Έτσι, θέλουμε να βεβαιωθούμε ότι γνωρίζετε και έχετε τον έλεγχο αυτής της λειτουργικότητας.</p>
<p>Η ανατροφοδότηση από τους χρήστες θα βοηθήσει πολύ το επιτελείο του Moodle HQ στη βελτίωση του λογισμικού Moodle. Για να ενεργοποιήσετε αυτήν τη δυνατότητα, παρακαλούμε μεταβείτε στις <a href="{$a}">Ρυθμίσεις ανατροφοδότησης</a>.</p>';
$string['userfeedbacknextreminder'] = 'Υπενθύμιση επόμενης ανατροφοδότησης';
$string['userfeedbacknextreminder_desc'] = 'Πότε πρέπει να ζητήσουμε από τον χρήστη να δώσει ξανά ανατροφοδότηση;';
$string['userfeedbackperiodically'] = 'Περιοδικά';
$string['userfeedbackremindafter'] = 'Εμφάνιση υπενθύμισης μετά';
$string['userfeedbackremindafter_desc'] = 'Υπενθυμίστε στους χρήστες ξανά να δώσουν ανατροφοδότηση μετά από αυτόν τον αριθμό ημερών.';
$string['userfiltersdefault'] = 'Προεπιλεγμένα φίλτρα χρήστη';
$string['userfiltersdefault_desc'] = 'Επιλέξτε τα φίλτρα που θα εμφανίζονται στη σελίδα «Περιήγηση στη λίστα χρηστών» και στη σελίδα «Μαζικές ενέργειες χρηστών». Κρατήστε πατημένο το πλήκτρο Ctrl για να επιλέξετε πολλά στοιχεία. Όσα φίλτρα δεν έχουν επιλεγεί θα είναι διαθέσιμα κάνοντας κλικ στο σύνδεσμο «Εμφάνιση περισσότερων».';
$string['userimagesdisabled'] = 'Οι εικόνες στα προφίλ χρηστών είναι απενεργοποιημένες';
$string['userlist'] = 'Περιήγηση στην λίστα των χρηστών';
$string['usermanagement'] = 'Διαχείριση χρήστη';
$string['userpolicies'] = 'Πολιτικές χρηστών';
$string['userpreference'] = 'Προτίμηση χρήστη';
$string['userquota'] = 'Χώρος ιδιωτικών αρχείων';
$string['userquota_desc'] = 'Η μέγιστη ποσότητα δεδομένων που μπορεί κάθε χρήστης να αποθηκεύσει στην ιδιωτική του περιοχή αρχείων.';
$string['users'] = 'Χρήστες';
$string['usesitenameforsitepages'] = 'Χρησιμοποιήστε το όνομα του δικτυακού τόπου για τις σελίδες';
$string['usetags'] = 'Ενεργοποίηση λειτουργικότητας ετικετών';
$string['validateemptylineerror'] = 'Οι κενές γραμμές δεν είναι έγκυρες';
$string['validateerror'] = 'Αυτή η τιμή δεν είναι έγκυρη';
$string['validateerrorlist'] = 'Αυτές οι καταχωρήσεις δεν είναι έγκυρες: {$a}';
$string['validateiperror'] = 'Αυτές οι διευθύνσεις IP δεν είναι έγκυρες: {$a}';
$string['verifychangedemail'] = 'Περιορισμός τομέων κατά την αλλαγή διευθύνσεων ηλε.ταχυδρομείου';
$string['warningcurrentsetting'] = 'Μη έγκυρη τρέχουσα τιμή: {$a}';
$string['warningiconvbuggy'] = 'Η έκδοση της βιβλιοθήκης σας iconv δεν υποστηρίζει τον τροποποιητή //IGNORE. Θα πρέπει να εγκαταστήσετε την επέκταση mbstring που μπορεί να χρησιμοποιηθεί για τον καθαρισμό συμβολοσειρών που περιέχουν μη έγκυρους UTF-8 χαρακτήρες.';
$string['webproxy'] = 'Διακομιστής μεσολάβησης ιστού';
$string['webproxyinfo'] = 'Συμπληρώστε τις παρακάτω επιλογές εάν ο Moodle εξυπηρετητής σας δεν έχει απευθείας πρόσβαση στο Διαδίκτυο. Η πρόσβαση αυτή απαιτείται για τη λήψη δεδομένων περιβάλλοντος, γλωσσικών πακέτων, τροφοδοσιών RSS, ζωνών ώρας, κλπ.<br /><em>Συνιστάται ιδιαίτερα, η χρήση της PHP επέκτασης cURL.</em>';
$string['yuicomboloading'] = 'Φόρτωση συνδυασμού YUI';
$string['ziprequired'] = 'Η επέκταση Zip PHP τώρα απαιτείται από το Moodle, τα info-ZIP binaries ή PclZip βιβλιοθήκες δε χρησιμοποιούνται πλέον.';
