<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sl', version '5.0'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Sprejmi';
$string['accept_grades'] = 'Sprejmi ocene iz orodja';
$string['accept_grades_admin'] = 'Sprejmi ocene iz orodja';
$string['accept_grades_admin_help'] = 'Določi, ali lahko ponudnik orodja dodaja, posodablja, bere in briše ocene, povezane z elementi tega orodja.

 Nekateri ponudniki orodij podpirajo poročanje ocen nazaj v Moodle na podlagi ukazov znotraj orodja, s čimer ustvarijo bolj celovito izkušnjo.';
$string['accept_grades_help'] = 'Določi, ali lahko ponudnik orodja dodaja, posodablja, bere ali briše ocene, povezane le s tem zunanjim orodjem.

Nekateri ponudniki orodja podpirajo poročanje ocen nazaj v Moodle na podlagi ukazov znotraj orodja, kar zagotavlja bolj celovito izkušnjo.

To nastavitev se lahko povozi v konfiguraciji orodja.';
$string['accepted'] = 'Sprejeto';
$string['action'] = 'Ukaz';
$string['activate'] = 'Vključi';
$string['activatetoadddescription'] = 'Da lahko dodate opis, boste morali prej vključiti to orodje.';
$string['active'] = 'Dejavno';
$string['activity'] = 'Dejavnost';
$string['add_ltiadv'] = 'Dodaj Prednost LTI';
$string['add_ltilegacy'] = 'Dodaj Podedovani LTI';
$string['addnewapp'] = 'Omogoči zunanje aplikacije';
$string['addserver'] = 'Dodaj nov varni strežnik';
$string['addtype'] = 'Dodaj vnaprej konfigurirano orodje';
$string['allow'] = 'Dovoli';
$string['allowsetting'] = 'Dovoli orodju, da shrani 8K nastavitev v Moodlu';
$string['always'] = 'Vedno';
$string['autoaddtype'] = 'Dodaj orodje';
$string['automatic'] = 'Samodejno glede na začetni URL';
$string['baseurl'] = 'Izhodiščni URL/Ime za registracijo orodja';
$string['basiclti'] = 'Učno orodje LTI';
$string['basiclti_base_string'] = 'Niz baz LTI OAuth';
$string['basiclti_endpoint'] = 'Končna točka zagona učnega orodja LTI';
$string['basiclti_in_new_window'] = 'Dejavnost se je odprla v novem oknu';
$string['basiclti_in_new_window_open'] = 'Odpri v novem oknu';
$string['basiclti_parameters'] = 'Parametri zagona učnega orodja LTI';
$string['basicltiactivities'] = 'Dejavnosti učnega orodja LTI';
$string['basicltifieldset'] = 'Vzorčna množica polj po meri';
$string['basicltiintro'] = 'Opis dejavnosti';
$string['basicltiname'] = 'Ime dejavnosti';
$string['basicltisettings'] = 'Osnovne nastavitve učnega orodja LTI (Learning Tool Interoperability)';
$string['cachedef_keyset'] = 'Shrani set ključev informacij orodja v predpomnilnik';
$string['cancel'] = 'Prekliči';
$string['cancelled'] = 'Preklicano';
$string['capabilities'] = 'Zmožnosti';
$string['capabilities_help'] = 'Izberite možnosti, ki jih želite ponuditi ponudniku orodja. Lahko izberete več kot eno možnost.';
$string['capabilitiesrequired'] = 'Za vklop to orodje zahteva dostop do naslednjih podatkov:';
$string['cleanaccesstokens'] = 'Odstranitev poteklih žetonov za vstop z zunanjim orodjem';
$string['click_to_continue'] = '<a href="{$a->link}" target=«_top«>Za nadaljevanje kliknite</a>';
$string['clientidadmin'] = 'ID odjemalca';
$string['clientidadmin_help'] = 'ID odjemalca je enolična vrednost za prepoznavanje orodja. Ustvarjena je samodejno za vsako orodje, ki uporablja Varnostni profil JWT iz LTI različice 1.3 in bi morala biti del podatkov, ki so naprej podani ponudniku orodij, da lahko povezavo konfigurira s svojega konca.';
$string['comment'] = 'Komentar';
$string['configpassword'] = 'Privzeto geslo oddaljenega orodja';
$string['configpreferheight'] = 'Privzeta želena višina';
$string['configpreferwidget'] = 'Nastavi pripomoček za privzeti zagon';
$string['configpreferwidth'] = 'Privzeta želena širina';
$string['configresourceurl'] = 'Privzeti URL vira';
$string['configtoolurl'] = 'Privzeti URL oddaljenega orodja';
$string['configtypes'] = 'Omogoči aplikacije učnega orodja LTI';
$string['configured'] = 'Konfigurirano';
$string['confirmtoolactivation'] = 'Ste prepričani, da želite vključiti to orodje?';
$string['contentitem_deeplinking'] = 'Podpira Deep Linking (Vsebina-Element Sporočilo)';
$string['contentitem_deeplinking_help'] = 'Če je označeno, vam bo možnost \'Izberi vsebino\' na voljo, ko boste dodali zunanje orodje.';
$string['contentitem_multiple_description'] = 'Naslednji elementi bodo dodani vašemu predmetu:';
$string['contentitem_multiple_graded'] = 'Ocenjevana dejavnost (Najvišja ocena: {$a})';
$string['courseactivitiesorresources'] = 'Dejavnosti oziroma viti pri predmetu';
$string['courseexternaltools'] = 'Zunanja orodja LTI';
$string['courseid'] = 'ID številka predmeta';
$string['courseinformation'] = 'Informacije o predmetu';
$string['courselink'] = 'Pojdi na predmet';
$string['coursemisconf'] = 'Predmet je napačno nastavljen';
$string['createdon'] = 'Ustvarjeno dne';
$string['curllibrarymissing'] = 'Za uporabo zunanjega orodja LTI mora biti nameščena knjižnica PHP cURL.';
$string['custom'] = 'Parametri po meri';
$string['custom_help'] = 'Parametri po meri so nastavitve, ki jih uporablja ponudnik orodja. Na primer, parameter po meri lahko uporabite za prikaz določenega vira ponudnika. Vsak parameter morate vnesti na svojo vrstico z uporabo "name=value"; na primer, »chapter=3«.

 To polje lahko varno zapustite nespremenjeno, razen če vas ponudnik orodja usmeri drugače.';
$string['custominstr'] = 'Parametri po meri';
$string['debuglaunch'] = 'Možnost razhroščevanja';
$string['debuglaunchoff'] = 'Navadni zagon';
$string['debuglaunchon'] = 'Razhroščevalni zagon';
$string['default'] = 'Privzeto';
$string['default_launch_container'] = 'Privzeti vsebnik zagona';
$string['default_launch_container_help'] = 'Vsebnik zagona vpliva na prikaz orodja, ko je zagnan iz predmeta. Nekateri vsebniki zagona ponujajo večji zaslon/več prostora orodju, drugi pa ponujajo občutek večje celovitosti v okolju Moodle.

* ** - Uporabi vsebnik zagona, ki ga določa nastavitev orodja.
* ** Vdelava** - Orodje je prikazano znotraj obstoječega Moodle okna, ki je na nek način podoben večini drugih tipov dejavnosti.
* ** Vdelava brez blokad** - Orodje je prikazano znotraj obstoječega Moodle okna z navigacijskimi tipkami na vrhu strani.
* **Novo okno** - Orodje se odpre v novem oknu in zavzame prostor, ki je na voljo
 Odvisno od brskalnika se bo odprl nov zavihek ali pojavno okno.
 Možno je tudi, da bo brskalnik odpiranje novega okna blokiral.';
$string['delegate'] = 'Dodeli učitelju';
$string['delegate_tool'] = 'Kot opredeljevo v Definiciji Deep Linking ali Dodeli učitelju';
$string['delete'] = 'Izbriši';
$string['delete_confirmation'] = 'Ste prepričani, da želite izbrisati vnaprej konfigurirano orodje?';
$string['display_description'] = 'Prikaži opis dejavnosti';
$string['display_description_help'] = 'Če je izbrano, bo opis dejavnosti (naveden zgoraj) prikazan nad vsebino orodja.

Opis lahko uporabite za dodatna navodila uporabnikom orodja.

Opis se ne prikaže, če se orodje zažene v novem oknu.';
$string['display_name'] = 'Ob zagonu prikaži ime dejavnosti';
$string['display_name_help'] = 'Če je izbrano, bo ime dejavnosti (navedeno zgoraj) prikazano nad vsebino orodja.

Možno je, da ponudnik orodja prikaže tudi naslov. Ta opcija lahko prepreči dvojni prikaz imena dejavnosti.

Naslov se ne prikaže, če se orodje zažene v novem oknu.';
$string['donot'] = 'Ne pošlji';
$string['donotaccept'] = 'Ne sprejmi';
$string['donotallow'] = 'Ne dovoli';
$string['duplicateregurl'] = 'URL za registracijo je že v uporabi';
$string['editdescription'] = 'Kliknite tukaj, da orodju dodate opis';
$string['embed'] = 'Vdelaj';
$string['embed_no_blocks'] = 'Vdelaj brez blokad';
$string['enableemailnotification'] = 'Pošlji e-poštna obvestila';
$string['enableemailnotification_help'] = 'Če je omogočeno, bodo udeleženci prejeli obvestilo po e-pošti, ko bodo prispevki orodja ocenjeni.';
$string['enterkeyandsecret'] = 'Vnesite svoj uporabniški ključ in deljeni skriti ključ';
$string['enterkeyandsecret_help'] = 'Če ste prejeli uporabniški ključ in/ali deljen skriti ključ, ju vnesite tukaj';
$string['errorbadurl'] = 'URL ni veljavno orodje URL ali vložek.';
$string['errorincorrectconsumerkey'] = 'Uporabniški ključ ni pravilen.';
$string['errorinvaliddata'] = 'Neveljavni podatki: {$a}';
$string['errorinvalidmediatype'] = 'Neveljaven tip predstavnostne datoteke: {$a}';
$string['errorinvalidresponseformat'] = 'Neveljaven format Vsebine-Elementa odgovora.';
$string['errormisconfig'] = 'Orodje je napačno nastavljeno. Obrnite se na Moodlovega skrbnika, da popravi nastavitve orodja.';
$string['errortooltypenotfound'] = 'Tip orodja LTI ni bil najden.';
$string['existing_window'] = 'Obstoječe okno';
$string['extensions'] = 'Dodatne storitve učnega orodja LTI';
$string['external_tool_type'] = 'Vnaprej konfigurirano orodje';
$string['external_tool_type_help'] = '* **Samodejno, osnovano na orodju URL** - Najboljše orodje za konfiguracijo je izbrano samodejno. Če orodje URL ni prepoznano, boste morali morrda podrobnosti o nastavitvi vnesti ročno.\\.
* **Določeno vnaprej konfigurirano orodje** - Nastavitev za določeno orodje bo uporabljena pri komunikaciji z zunanjimi ponudniki orodij. Če se URL orodja ne pojavi kot pripaden določenemu ponudniku orodja, bo prikazano opozorilo. Vnos URL ni vedno nujen.
* **Nastavitve po meri** - Ključ uporabnika in deljen skrivni ključ lahko pridobite pri ponudniku orodja. Vendar pa ne zahtevajo vsa orodja uporabniškega ključa in delitve skrivnega ključa. V tem primeru lahko polja pustite prazna.

### Prednastavljeno urejanje orodja

 Tri ikone so na voljo glede na prednastavljen spustni meni orodja:

* **Dodaj** - Ustvari nastavitve orodja na ravni predmeta. Zunanji elementi v potem predmetu lahko uporabljajo nastavitve orodja.
* ** Uredi** - Označite orodje za raven predmeta s pustnega menija in potem kliknite to ikono. Podrobnosti nastavljanja orodja lahko spreminjate.
* **Izbriši** - Odstrani izbrano orodje za raven predmeta.';
$string['external_tool_types'] = 'Vnaprej konfigurirana orodja';
$string['failedtoconnect'] = 'Moodlu ni uspelo vzpostaviti komunikacije s sistemom "{$a}"';
$string['failedtocreatetooltype'] = 'Ustvarjanje novega orodja ni bilo uspešno. Prosim, preverite URL in poskusite znova.';
$string['failedtodeletetoolproxy'] = 'Brisanje registracije orodja ni bilo uspešno. Morda boste morali obiskati »Upravljanje registracij zunanjih orodij« in jih izbrisati ročno.';
$string['filter_basiclti_configlink'] = 'Nastavite želena spletna mesta in njihova gesla';
$string['filter_basiclti_password'] = 'Geslo je obvezno';
$string['filterconfig'] = 'Administracija LTI';
$string['filtername'] = 'Učno orodje LTI';
$string['fixexistingconf'] = 'Uporabi obstoječe nastavitve za napačno nastavljen element';
$string['fixnew'] = 'Nova nastavitev';
$string['fixnewconf'] = 'Določi novo nastavitev za napačno nastavljen element';
$string['fixold'] = 'Uporabi obstoječe';
$string['force_ssl'] = 'Vsili SSL';
$string['force_ssl_help'] = 'Izbira te možnosti vsili, da vsak zagon tega ponudnika orodja uporablja SSL.

Poleg tega bodo vsa spletna naročila storitev ponudnika orodja uporabljala SSL.

 Če uporabljate to možnost, potrdite, da spletno mesto Moodla in ponudnik orodja podpirata SSL.';
$string['generaltool'] = 'Splošno orodje';
$string['grading'] = 'Usmerjanje ocen';
$string['icon_url'] = 'URL ikone';
$string['icon_url_help'] = 'URL ikone omogoča spreminjanje ikone, ki se v predmetu pojavlja za to dejavnost. Namesto privzete
ikone LTI, lahko določite ikono, ki sporoča tip dejavnosti.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Kognitivni LTI';
$string['indicator:cognitivedepth_help'] = 'Ta kazalnik temelji na kognitivni globini, ki jo je udeleženec dosegel pri LTI dejavnosti.';
$string['indicator:cognitivedepthdef'] = 'Kognitivni LTI';
$string['indicator:cognitivedepthdef_help'] = 'Sodelujoči je dosegel ta odstotek kognitivnega udejstvovanja, ki ga ponujajo Dejavnosti LTI v tem intervalu analize (Ravni = Brez ogleda, Ogled, Oddaja, Ogled odziva)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialni LTI';
$string['indicator:socialbreadth_help'] = 'Ta kazalnik temelji na kognitivni globini, ki jo je udeleženec dosegel pri LTI dejavnosti.';
$string['indicator:socialbreadthdef'] = 'Socialni LTI';
$string['indicator:socialbreadthdef_help'] = 'Sodelujoči je dosegel ta odstotek družbenega udejstvovanja, ki ga ponujajo Dejavnosti LTI v tem intervalu analize (Ravni = Brez sodelovanja, Sodelujoči sam, Sodelujoči z drugimi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Zaženi URL prijave';
$string['initiatelogin_help'] = 'URL orodja, na katerega se pošiljajo prošnje za zagon prijave. Ta URL je potreben preden se lahko uspešno posreduje sporočilo do orodja.';
$string['invalidid'] = 'ID LTI je nepravilen';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Tip javnega ključa';
$string['keytype_help'] = 'Avtentikacijska metoda uporabljena za potrditev orodja.';
$string['keytype_keyset'] = 'URL nabora ključev';
$string['keytype_rsa'] = 'RSA ključ';
$string['launch_in_moodle'] = 'Zaženi orodje v Moodlu';
$string['launch_in_popup'] = 'Zaženi orodje v pojavnem oknu';
$string['launch_url'] = 'URL orodja';
$string['launch_url_help'] = 'URL orodja prikaže spletno stran zunanjega orodja in lahko vsebuje dodatne informacije, ko na primer ogled vira.
 Če niste prepričani, kaj bi vnesli kot URL orodja, prosim povprašajte ponudnika orodja za več informacij.

 Lahko vnesete URL vložek, če ga imate, in drugi podatki se bodo v obrazec vnesli samodejno.

 Če imate označeno vnaprej konfigurirano orodje, vam morda ne bo treba vnašati URL-ja orodja. Če je povezava do orodja uporabljena samo za zagon orodja ponudnikovega sistema in ne določenega vira, je to precej verjetno.';
$string['launchinpopup'] = 'Zaženi vsebnik';
$string['launchinpopup_help'] = 'Vsebnik zagona vpliva na prikaz orodja, ko je zagnan iz predmeta. Nekateri vsebniki zagona ponujajo večji zaslon/več prostora orodju, drugi pa ponujajo občutek večje celovitosti v okolju Moodle.

* ** - Uporabi vsebnik zagona, ki ga določa nastavitev orodja.
* ** Vdelava** - Orodje je prikazano znotraj obstoječega Moodle okna, ki je na nek način podoben večini drugih tipov dejavnosti.
* ** Vdelava brez blokad** - Orodje je prikazano znotraj obstoječega Moodle okna z navigacijskimi tipkami na vrhu strani.
* **Novo okno** - Orodje se odpre v novem oknu in zavzame prostor, ki je na voljo
 Odvisno od brskalnika se bo odprl nov zavihek ali pojavno okno.
 Možno je tudi, da bo brskalnik odpiranje novega okna blokiral.';
$string['launchoptions'] = 'Možnosti zagona';
$string['lti'] = 'Učno orodje LTI';
$string['lti:addcoursetool'] = 'Dodaj posebne nastavitve orodja za določen predmet';
$string['lti:addinstance'] = 'Dodaj novo zunanje orodje';
$string['lti:addpreconfiguredinstance'] = 'Dodaj vnaprej konfigurirano orodje';
$string['lti:admin'] = 'Ob zagonu orodja bodite administrator';
$string['lti:grade'] = 'Ogled ocen, ki jih je vrnilo zunanje orodje';
$string['lti:manage'] = 'Ob zagonu orodja bodite učitelj';
$string['lti:requesttooladd'] = 'Zahtevaj, da je orodje nastavljeno na skupnem spletišču';
$string['lti:view'] = 'Zaženi dejavnosti zunanjega orodja';
$string['lti_administration'] = 'Uredi vnaprej konfigurirano orodje';
$string['lti_errormsg'] = 'Orodje je javilo napako: "{$a}"';
$string['lti_launch_error'] = 'Prišlo je do napake ob zagonu zunanjega orodja:';
$string['lti_launch_error_tool_request'] = '<p>
Če želite skrbniku poslati prošnjo, da dokonča nastavitev orodja, kliknite <a href="{$a->admin_request_url}" target="_top">sem</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Ta napaka se lahko pojavi, če manjkata uporabniški in skrivni ključ v skupni rabi za ponudnika orodja.</p>
<p>Če imate uporabniški in skrivni ključ v skupni rabi, ju lahko vnesete med urejanjem posameznega zunanjega orodja (poskrbite, da so dodatne možnosti vidne).</p>
<p>Lahko tudi <a href="{$a->course_tool_editor}">ustvarite nastavitev ponudnika orodja na ravni predmeta</a>.</p>';
$string['lti_tool_request_added'] = 'Zahteva za nastavitev orodja je uspešno oddana. Za dokončanje nastavitve orodja se obrnite na skrbnika.';
$string['lti_tool_request_existing'] = 'Nasravitev orodja za domeno orodja je bila že oddana.';
$string['ltisettings'] = 'Nastavitve LTI';
$string['ltiunknownserviceapicall'] = 'Nepoznana storitev učnega orodja LTI klic API.';
$string['ltiversion'] = 'Različica LTI';
$string['ltiversion_help'] = 'Uporabljena različica LTI za podpisovanje sporočil in storitvenih zahtev: LTI 1.0/1.1 in LTI 2.0 uporabljata varnostni profil OAuth 1.0A; LTI 1.3.0 uporablja JWTs.';
$string['main_admin'] = 'Splošna pomoč';
$string['main_admin_help'] = 'Zunanja orodja Moodlovim uporabnikom omogočajo tekočo komunikacijo z viri za učenje, ki gostijo zunaj. Preko posebnega protokola za zagon bo oddaljeno orodje dostopalo do nekaterih splošnih informacij o uporabniku, ki ga zaganja. Na primer, do imena institucije, ID-ja predmeta, e-mail naslova. Orodja, ki so navedena na strani, se delijo na tri kategorije.

* **Vključena** - Te ponudnike orodij je potrdil in nastavil administrator. Uporabljajo se lahko znotraj vsakega predmeta v vsakem elementu Moodle. Če sta vnešena uporabniški ključ in deljenje skritega ključa, se ustvari zaupen odnos med elementom Moodle in oddaljenim orodjem, kar zagotavlja varen komunikacijski kanal.
* **V teku** - Ti ponudniki orodja so prišli zraven preko istega uvoza paketa, vendar pa jih ni nastavil administrator.
 Izvajalci morda še vedno uporabljajo orodja teh ponudnikov, če imajo uporabniški ključ in delijo skriti ključ ali pa noben od njiju ni zahtevan.
* **Zavrnjen** - Ti ponudniki orodij so označeni z zastavico kot tisti, ki jih Moodle ne namerava omogočiti za vse svoje elemente. Izvajalci morda še vedno uporabljajo orodja teh ponudnikov, če imajo uporabniški ključ in delijo skriti ključ ali pa noben od njiju ni zahtevan.';
$string['manage_external_tools'] = 'Upravljanje orodja';
$string['manage_tool_proxies'] = 'Upravljaj zunanje registrirana orodja';
$string['manage_tools'] = 'Upravljaj vnaprej konfigurirana orodja';
$string['manuallyaddtype'] = 'Kot nadomestilo lahko <a href=«{$a}«>orodje nastavite ročno</a>.';
$string['miscellaneous'] = 'Razno';
$string['misconfiguredtools'] = 'Zaznane so posamezne napačne nastavitve orodja';
$string['missingparameterserror'] = 'Stran je napačno nastavljena: "{$a}"';
$string['module_class_type'] = 'Tip modula v Moodlu';
$string['modulename'] = 'Zunanje orodje';
$string['modulename_help'] = 'Modul dejavnosti v zunanjem orodju uporabnikom omogoča interakcijo z učnimi viri in dejavnostmi na drugih spletnih mestih. Na primer, zunanje orodje bi lahko nudilo dostop do novih vrst dejavnosti ali učnih materialov lastnikov.

Da bi ustvarili aktivnost z zunanjim orodjem, mora le-to podpirati LTI (Learning Tools Interoperability) protokol. Izvajalec lahko sam ustvari zunanje orodje ali pa uporabi orodje, ki ga je ustvaril skrbnik spletnega mesta.

Zunanje orodje kot dejavnost se razlikuje od URL vira:

- Zunanje orodje se poveže s kontekstom uporabe: ima informacijo o uporabniku orodja, npr. o ustanovi, predmetu, imenu
- podpira branje in posodabljanje ter brisanje ocen v povezavi z dejavnostjo
- ustvari varno povezavo in zaupno komunikacijo med vašim spletnim mestom in ponudnikom orodja';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Zunanja orodja';
$string['modulenamepluralformatted'] = 'Elementi LTI';
$string['name'] = 'Ime';
$string['never'] = 'Nikoli';
$string['new_window'] = 'Novo okno';
$string['no_lti_configured'] = 'Ni vključenih nastavljenih zunanjih orodij.';
$string['no_lti_pending'] = 'Ni zunanjih orodij na čakanju.';
$string['no_lti_rejected'] = 'Ni zavrnjenih zunanjih orodij.';
$string['no_lti_tools'] = 'Ni nastavljenih zunanjih orodij.';
$string['no_tp_accepted'] = 'Ni bilo sprejeto nobeno zunanje orodje za registracijo.';
$string['no_tp_cancelled'] = 'Ni bilo preklicano nobeno zunanje orodje za registracijo.';
$string['no_tp_configured'] = 'Ni nobenih nastavljenih neregistriranih zunanjih orodij za registracijo.';
$string['no_tp_pending'] = 'Ni zunanjih orodij na čakanju za registracijo.';
$string['no_tp_rejected'] = 'Ni zavrnjenih zunanjih orodi za registracijo.';
$string['noattempts'] = 'Ni poskusov za ta element orodja';
$string['noltis'] = 'Ni posameznih zunanjih elementov orodij';
$string['noprofileservice'] = 'Storitev profila ni najdena';
$string['noservers'] = 'Strežnikov ni mogoče najti';
$string['notypes'] = 'Trenutno v Moodlu ni nameščenih učnih orodij LTI. Za dodajanje kliknite na povezavo Namesti.';
$string['noviewusers'] = 'Ni mogoče najti uporabnikov z dovoljenjem za uporabo orodja';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 zahteva, da je veljaven openssl.cnf konfiguriran in na voljo za spletni strežnik. Kontaktirajte admistratorja spletnega mesta za konfiguracijo in omogočanje openssl za to spletno mesto.';
$string['optionalsettings'] = 'Neobvezne nastavitve';
$string['organization'] = 'Podrobnosti o organizaciji';
$string['organizationdescr'] = 'Opis organizacije';
$string['organizationid_default'] = 'Privzet ID organizacije';
$string['organizationid_default_help'] = 'Privzeta vrednost za uporabo ID organizacije. ID spletnega mesta prepoznava to namestitev Moodla.';
$string['organizationidguid'] = 'ID organizacije';
$string['organizationidguid_help'] = 'Edinstven identifikator za ta Moodle element je bil posredovan orodju kot Element GUID Platforme.

Če to polje ostane prazno, se bo uporabila privzeta vrednost.';
$string['organizationurl'] = 'URL organizacije';
$string['organizationurl_help'] = 'Osnovni URL tega Moodle elementa.

Če to polje ostane prazno, se bo uporabila privzeta vrednost, ki temelji na nastavitvi spletnega mesta.';
$string['pagesize'] = 'Število oddaj na stran';
$string['parameter'] = 'Parametri orodja';
$string['parameter_help'] = 'Parametri orodja so nastavitve, ki se zahtevajo za to, da jih ponudnik orodja sprejme s pooblastilom orodja.';
$string['password'] = 'Skupni skrivni ključ';
$string['password_admin'] = 'Skupni skrivni ključ';
$string['password_admin_help'] = 'Skrivni ključ v skupni rabi je geslo, ki se uporabi za avtentikacijo pri dostopanju do orodja. Ponudnik orodja ga priskrbi
skupaj z uporabniškim ključem.

Orodja, ki ne potrebujejo varne komunikacije od Moodla in ne ponujajo dodatnih storitev (kot je poročanje ocen)
, morda ne potrebujejo skrivnega ključa v skupni rabi.';
$string['password_help'] = 'Za prednastavljena orodja ni potrebno vnesti skrivnega ključa v skupni rabi, saj bo ta
vnešen med postopkom konfiguracije.

To polje se izpolni pri ustvarjanju povezave do ponudnika orodja, ki še ni nastavljen.
Če bo ponudnik orodja uporabljen več kot enkrat v tem predmetu, je smiselno dodati nastavitev orodja predmeta.

Skrivni ključ v skupni rabi je geslo, ki se uporabi za avtentikacijo pri dostopanju do orodja. Ponudnik orodja ga priskrbi
skupaj z uporabniškim ključem od ponudnika orodja.

Orodja, ki ne potrebujejo varne komunikacije od Moodla in ne ponujajo dodatnih storitev (kot je poročanje ocen)
morda ne potrebujejo skrivnega ključa v skupni rabi.';
$string['pending'] = 'V čakanju';
$string['pluginadministration'] = 'Administracija LTI';
$string['pluginname'] = 'Zunanje orodje';
$string['preferheight'] = 'Želena višina';
$string['preferwidget'] = 'Želen zagon pripomočka';
$string['preferwidth'] = 'Želena širina';
$string['press_to_submit'] = 'Pritisni za zagon dejavnosti';
$string['privacy'] = 'Zasebnost';
$string['privacy:metadata:coursefullname'] = 'Polno ime predmeta, do katerega uporabnik dostopa, je LTI Consumer';
$string['privacy:metadata:courseid'] = 'ID predmeta, do katerega uporabnik dostopa, je LTI Consumer';
$string['privacy:metadata:courseidnumber'] = 'ID predmeta, do katerega uporabnik dostopa, je LTI Consumer';
$string['privacy:metadata:courseshortname'] = 'Kratko ime predmeta, do katerega uporabnik dostopa, je LTI Consumer';
$string['privacy:metadata:createdby'] = 'Uporabnik, ki je ustvaril evidenco';
$string['privacy:metadata:email'] = 'E-mail uprorabnika dostopa do LTI Consumer';
$string['privacy:metadata:externalpurpose'] = 'LTI Consumer ponuja informacije o uporabniku in kontekst ponudniku orodja LTI.';
$string['privacy:metadata:firstname'] = 'Ime uporabnika dostopa do LTI Consumer';
$string['privacy:metadata:fullname'] = 'Polno ime uporabnika dostopa do LTI Consumer';
$string['privacy:metadata:lastname'] = 'Priimerk uporabnika dostopa do LTI Consumer';
$string['privacy:metadata:lti_submission'] = 'Oddaja LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Časovna oznaka kaže, kdaj je bila oddana datoteka';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Časovna oznaka kaže, kdaj je bila oddana datoteka spremenjena';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Ocena uporabnika v odstotkih';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Prvotna ocena uporabnika';
$string['privacy:metadata:lti_submission:userid'] = 'ID uporabnika, ki je oddal datoteko v LTI dejavnost';
$string['privacy:metadata:lti_tool_proxies'] = 'Pooblaščenci LTI';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Ime pooblaščenca LTI';
$string['privacy:metadata:lti_types'] = 'Vrste LTI';
$string['privacy:metadata:lti_types:name'] = 'Ime vrste LTI';
$string['privacy:metadata:role'] = 'Vloga uporabnika, ki dostopa do LTI Consumer v predmetu';
$string['privacy:metadata:timecreated'] = 'Čas, ko je bila ustvarjena evidenca';
$string['privacy:metadata:timemodified'] = 'Čas, ko je bil zapis spremenjen';
$string['privacy:metadata:userid'] = 'ID uporabnika, ki dostopa do LTI Consumer';
$string['privacy:metadata:useridnumber'] = 'ID uporabnika, ki dostopa do LTI Consumer';
$string['privacy:metadata:username'] = 'Uporabniško ime uporabnika, ki dostopa do LTI Consumer';
$string['publickey'] = 'Javni ključ';
$string['publickey_help'] = 'Javni ključ (v PEM formatu), ki ga podaja orodje za dovoljevanje potrditev podpisov prihajajočih sporočil in naročil storitev.';
$string['publickeyset'] = 'Javni nabor ključev';
$string['publickeyset_help'] = 'Javni nabor ključev, iz katerega bo spletno mesto pridobilo javni ključ orodja za dovoljevanje potrditev podpisov prihajajočih sporočil in naročil storitev.';
$string['quickgrade'] = 'Dovoli hitro ocenjevanje';
$string['quickgrade_help'] = 'Če je ta možnost omogočena, se lahko na eni strani ocenjuje več orodij. Dodajte ocene in komentarje, nato kliknite na gumb Shrani vse moje pripombe, da shranite vse spremembe za to stran.';
$string['redirect'] = 'Kmalu boste preusmerjeni. Če preusmeritev ne steče samodejno, pritisnite na gumb.';
$string['redirectionuris'] = 'Preusmeritev URI/-jev';
$string['redirectionuris_help'] = 'Seznam URIjev (en na vrstico), ki jih orodje uporablja za ustvarjanje avtorizacijskih zahtev. Vsaj en mora biti registriran preden se sporočilo lahko uspešno pošlje do orodja.';
$string['register'] = 'Registracija';
$string['register_warning'] = 'Stran za registracijo se odpira nekam dolgo. Če se ne odpre, preverite, ali ste vpisali pravilen URL v nastavitvah. Če Moodle uporablja https, preverite ali orodje, ki ga želite povezati, podpira https in ali vi https uporabljate v svojem URL-ju.';
$string['registertype'] = 'Nastavite novo zunanje orodje za registracijo';
$string['registration_options'] = 'Možnosti registracije';
$string['registrationname'] = 'Ime ponudnika orodja';
$string['registrationname_help'] = 'Vnesite ime ponudnika orodja, ki ga registrirate.';
$string['registrationurl'] = 'Registracijski URL';
$string['registrationurl_help'] = 'URL za registracijo mora biti na voljo s strani ponudnika orodja, saj je zahtevana lokacija, kamor se pošlje zahtevo za registracijo.';
$string['reject'] = 'Zavrni';
$string['rejected'] = 'Zavrnjeno';
$string['resource'] = 'Vir';
$string['resourcekey'] = 'Uporabniški ključ';
$string['resourcekey_admin'] = 'Uporabniški ključ';
$string['resourcekey_admin_help'] = 'Uporabniški ključ je uporabniško ime, ki se uporablja za avtentikacijo pri dostopanju do orodja.
Ponudnik orodja ga lahko uporabi za edinstveno identifikacijo Moodlovega spletnega mesta, s katerega uporabniki zaženejo orodje.

Uporabniški ključ priskrbi ponudnik orodja. Metoda pridobitve uporabniškega ključa je odvisna od
ponudnikov orodja. Lahko gre za samodejni postopek ali je treba vzpostaviti dialog s ponudnikom orodja.

Orodja, ki ne potrebujejo varne komunikacije od Moodla in ne ponujajo dodatnih storitev (kot je poročanje ocen)
, morda ne potrebujejo ključa za vir.';
$string['resourcekey_help'] = 'Za prednastavljena orodja ni potrebno vnesti ključa za vir, saj bo uporabniški ključ
vnesen med postopkom konfiguracije.

To polje se izpolni pri ustvarjanju povezave do ponudnika orodja, ki še ni nastavljen.
Če se ponudnik orodja uporablja več kot enkrat v predmetu, je smiselno dodati nastavitve orodja predmeta.

Uporabniški ključ je uporabniško ime, ki se uporablja za avtentikacijo pri dostopu do orodja.
Ponudnik orodja ga lahko uporabi za edinstveno identifikacijo Moodlovega spletnega mesta, s katerega uporabniki zaženejo orodje.

Uporabniški ključ priskrbi ponudnik orodja. Metoda pridobitve uporabniškega ključa je odvisna od
ponudnikov orodja. Lahko gre za samodejni postopek ali je treba vzpostaviti dialog s ponudnikom orodja.

Orodja, ki ne potrebujejo varne komunikacije od Moodla in ne ponujajo dodatnih storitev (kot je poročanje ocen),
 morda ne potrebujejo ključa za vir.';
$string['resourceurl'] = 'URL vira';
$string['return_to_course'] = 'Kliknite na <a href="{$a->link}" target="_top">here</a>, da se vrnete na predmet.';
$string['saveallfeedback'] = 'Shrani vse moje odzive';
$string['search:activity'] = 'Zunanje orodje - informacije o dejavnosti';
$string['secure_icon_url'] = 'Varna URL ikona';
$string['secure_icon_url_help'] = 'Podobno kot pri URL ikonah, vendar se uporablja, ko je vključen varen dostop uporabnika prek SSL. Glavni namen tega polja je
brskalniku preprečiti, da uporabnika opozori, da gre za nevarno sliko.';
$string['secure_launch_url'] = 'Varni URL zagona';
$string['secure_launch_url_help'] = 'Podobno kot pri URL zagona, vendar se uporablja namesto URL zagona, če se zahteva večjo varnost. Moodle bo uporabil
varni URL zagona namesto URL zagona, če se dostopa do Moodlovega spletnega mesta prek SSL ali če je nastavitev orodja
 nastavljena tako, da se vsakič zažene prek SSL.

URL zagona se lahko nastavi na naslov https, da se vsili zagon prek SSL, in to polje lahko ostane prazno.';
$string['selectcontent'] = 'Izberi vsebino';
$string['send'] = 'Pošlji';
$string['services'] = 'Storitve';
$string['services_help'] = 'Izberite možnosti, ki jih želite ponuditi ponudniku orodja. Lahko izberete več kot eno možnost.';
$string['setupoptions'] = 'Nastavi možnosti';
$string['share_email'] = 'Deli uporabnikov e-poštni naslov z orodjem';
$string['share_email_admin'] = 'Deli uporabnikov e-poštni naslov z orodjem';
$string['share_email_admin_help'] = 'Določi, ali se bo e-poštni naslov uporabnika, ki zaganja orodje, delil s ponudnikom orodja.
 Ponudnik orodja lahko potrebuje uporabnikov e-poštni naslov, da razlikuje uporabnike z enakim imenom v uporabniškem vmesniku ali pošilja e-poštna sporočila
uporabnikom na osnovi dejanj znotraj orodja.';
$string['share_email_help'] = 'Določi, ali se bo e-poštni naslov uporabnika, ki zaganja orodje, delil s ponudnikom orodja.
Ponudnik orodja lahko potrebuje uporabnikov e-poštni naslov, da razlikuje uporabnike z enakim imenom ali pošilja e-poštna sporočila
uporabnikom na osnovi dejanja znotraj orodja.

To nastavitev se lahko povozi v nastavitvah orodja.';
$string['share_name'] = 'Deli ime zaganjalca z orodjem';
$string['share_name_admin'] = 'Deli ime zaganjalca z orodjem';
$string['share_name_admin_help'] = 'Določi, ali se bo ime uporabnika, ki zaganja orodja, delilo s ponudnikom orodja.
Ponudnik orodja morda potrebuje uporabniška imena, da znotraj orodja prikaže pomembne informacije.';
$string['share_name_help'] = 'Določi, ali se bo polno ime uporabnika, ki zaganja orodja, delilo s ponudnikom orodja.

Ponudnik orodja lahko potrebuje zaganjačevo ime, da znotraj orodja prikaže pomembne informacije.

To nastavitev se lahko povozi v nastavitev orodja.';
$string['share_roster'] = 'Orodju dovoli, da dostopa do seznama tega predmeta';
$string['share_roster_admin'] = 'Orodje sme dostopati do seznama predmeta';
$string['share_roster_admin_help'] = 'Določi, ali orodje lahko dostopa do seznama uporabnikov, ki so prijavljeni na ta predmet, iz katerega se zaganja orodje.';
$string['share_roster_help'] = 'Določi, ali orodje lahko dostopa do seznama uporabnikov, ki so vpisani v predmete, iz katerih je bil zagnan ta tip orodja.

To nastavitev se lahko povozi v nastavitvah orodja.';
$string['show_in_course_activity_chooser'] = 'Prikaži v meniju za izbiro dejavnosti in kot vnaprej konfigurirano orodje';
$string['show_in_course_lti1'] = 'Uporaba nastavitev orodja';
$string['show_in_course_lti1_help'] = 'To orodje je morda prikazano v meniju za izbiro dejavnosti za izvajalce, da jih izberejo in dodajo predmetu. Namesto tega je morda prikazano v spustnem meniju vnaprej konfiguriranih orodij, ko predmetu dodajate zunanje orodje. Naslednja možnost je nastavitev orodja za izključno uporabo v primeru, ko je vnesen določen URL orodja, ko predmetu dodajate zunanje orodje.';
$string['show_in_course_lti2'] = 'Uporaba nastavitev orodja';
$string['show_in_course_lti2_help'] = 'To orodje se lahko prikaže v meniju za izbiro dejavnosti za izvajalce, da izberejo ali dodajo orodje predmetu ali pa se prikaže v spustnem meniju za vnaprej konfigurirana orodja, ko dodajate zunanje orordju predmetu.';
$string['show_in_course_no'] = 'Ne prikaži; uporabi samo ko je vnesen URL, ki se ujema z orodjem';
$string['show_in_course_preconfigured'] = 'Prikaži kot vnaprej konfigurirano orodje, ko dodajaš zunanje orodje';
$string['sitehost'] = 'Ime gostitelja spletnega mesta';
$string['siteid'] = 'ID spletnega mesta';
$string['size'] = 'Velikost parametrov';
$string['submission'] = 'Prispevek';
$string['submissions'] = 'Prispevki';
$string['submissionsfor'] = 'Prispevki za {$a}';
$string['subplugintype_ltiresource'] = 'Vir LTI storitve';
$string['subplugintype_ltiresource_plural'] = 'Viri LTI storitve';
$string['subplugintype_ltiservice'] = 'LTI storitev';
$string['subplugintype_ltiservice_plural'] = 'LTI storitve';
$string['subplugintype_ltisource'] = 'Vir LTI';
$string['subplugintype_ltisource_plural'] = 'Viri LTI';
$string['successfullycreatedtooltype'] = 'Uspešno ustvarjeno novo orodje!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Uspešno opravljena nastavitev orodja iz izbrane vsebine.';
$string['toggle_debug_data'] = 'Preklopi na razhroščevanje podatkov';
$string['tool_settings'] = 'Nastavitve orodja';
$string['tooldescription'] = 'Opis orodja';
$string['tooldescription_help'] = 'Opis orodja, ki bo prikazan izvajalcem na seznamu dejavnosti.

 Iz opisa mora biti razvidno, čemu je to orodje namenjeno, kaj zmore in podane dodatne informacije, ki koristijo izvajalcu.';
$string['tooldetailsaccesstokenurl'] = 'Dostop do URL žetona';
$string['tooldetailsauthrequesturl'] = 'URL zahteve za preverjanje prisotnosti';
$string['tooldetailsclientid'] = 'ID odjemalca';
$string['tooldetailsdeploymentid'] = 'ID uvajanja';
$string['tooldetailsmailtosubject'] = 'Konfiguracija orodja LTI';
$string['tooldetailsmodalemail'] = 'E-pošta';
$string['tooldetailsmodallink'] = 'Ogled konfiguracijskih podrobnosti';
$string['tooldetailsmodaltitle'] = 'Podrobnosti konfiguracije orodja';
$string['tooldetailsplatformid'] = 'ID platforme';
$string['tooldetailspublickeyseturl'] = 'URL javnega nabora ključev';
$string['toolisbeingused'] = 'Orodje je bilo uporabljeno {$a}-krat';
$string['toolisnotbeingused'] = 'Orodje še ni bilo uporabljeno';
$string['toolproxy'] = 'Registracija zunanjih orodij';
$string['toolproxy_help'] = 'Registracija zunanjih orodij skrbnikom Moodle strani omogoča povezovanje zunanjih orodij preko pridobljenih pooblastil s strani ponudnikov orodij, ki podpira LTI 2.0. URL za registracijo, ki ga da ponudnik je vse, kar je zahtevano za začetek postopka. Zmožnosti in storitve, ki so ponujene ponudniku orodja so označene, ko se nastavlja nova registracija. Registracije orodij, ki so navedene na tej strani, se delijo na štiri kategorije:

* **Nastavljeno** - Ta orodja za registracijo še niso bila nastavljena, vendar pa proces registracije tudi še ni bil začet.
* **V teku** - Proces registracije za ta orodja za registracijo se je začel, vendar pa še ni dokončan. Odprite in shranite nastavitve, da jih pomaknete nazaj v kategorijo Povezani.
* ** Sprejeto** - Ta orodja za registracijo so bila odobrena; viri, navedeni v pooblaščenem vnaprej nastavljenem orodju se bodo prikazali na strani z vnaprej konfiguriranimi orodji skupaj z začetnim statusom V teku.
* **Zavrnjeno** - Ta orodja za registracijo so tista, ki so bila zavrnjena med procesom registracije. Odprite in shranite nastavitve, da jih premaknete nazaj v kategorijo Nastavljeno, tako da se lahko proces registracije ponovno zažene.';
$string['toolproxyregistration'] = 'Registracija zunanjih orodij';
$string['toolregistration'] = 'Registracija zunanjih orodij';
$string['toolsetup'] = 'Konfiguracija zunanjega orodja';
$string['tooltypes'] = 'Orodja';
$string['toolurl'] = 'URL orodja';
$string['toolurl_contentitemselectionrequest'] = 'Izbrana vsebina URL';
$string['toolurl_contentitemselectionrequest_help'] = 'Izbrana vsebina URL bo uporabljena za zagon izbrane vsebine strani s strani ponudnika orodja. Če je prazno, bo uporabljeno URL orodje';
$string['toolurl_help'] = 'URL orodja se uporablja za povezovanje URL-jev s pravimi nastavitvami za določena orodja. Dodajanje predpone https URL-jem je izbirno.

 Poleg tega se osnovni URL uporablja, ko URL orodja ni določen v elementu zunanjega orodja.

 Osnovni URL *tool.com* bi se na primer ujemal z naslednjimi

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

A , osnovni URL *www.tool.com/quizzes* bi se ujemal z naslednjimi:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

A , osnovni URL *quiz.tool.com* bi se ujemal z naslednjimi:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

If Dve različni nastavitvi sta za isto domeno, uporabljena bo najožja.

 Prav tako lahko vstavite URL vložek - če imate enega, bodo podrobnosti o orodju dopolnjene samodejno.';
$string['toolurlplaceholder'] = 'URL orodja ...';
$string['typename'] = 'Ime orodja';
$string['typename_help'] = 'Ime orodja se uporablja za identifikacijo ponudnika orodja znotraj Moodla. Vnešeno ime bo vidno
izvajalcem pri dodajanju zunanjih orodij znotraj predmetov.';
$string['types'] = 'Tipi';
$string['unabletocreatetooltype'] = 'Orodja ni mogoče ustvariti';
$string['unabletofindtooltype'] = 'Ni mogoče najti orodja za {$a->id}';
$string['unknownstate'] = 'Neznano stanje';
$string['update'] = 'Posodobi';
$string['useraccountinformation'] = 'Informacije o uporabniškem računu';
$string['userpersonalinformation'] = 'Osebni podatki o uporabniku';
$string['validurl'] = 'Veljavni URL se mora začeti s http(s)://';
$string['viewsubmissions'] = 'Ogled oddanih datotek in zaslona ocenjevanja';
