<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'es', version '5.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Sobre mí';
$string['actingasrole'] = 'Actualmente está actuando con un rol diferente';
$string['activatetemplateoverride'] = 'Activar anulación de plantilla para \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Cuando se marca, el valor en la configuración \'{$a->setting}\' se usará como la plantilla \'{$a->template}\' si contiene texto.';
$string['activebreadcrumb'] = 'Color de fondo de la ruta de navegación activa';
$string['activebreadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación activa.';
$string['activitiesheading'] = 'Actividades';
$string['alertaccess'] = 'Visibilidad de la Alerta';
$string['alertaccessadmins'] = 'Visible para administradores';
$string['alertaccessdesc'] = 'Establece la visibilidad de la Alerta según su tipo. Nota: Si se usa "Añadir restricción por campo personalizado" necesitrás añadir el campo personalizado de usuario.';
$string['alertaccessglobal'] = 'Visible para todo el mundo';
$string['alertaccessprofile'] = 'Añadir restricción por campo personalizado';
$string['alertaccessusers'] = 'Visible para usuarios';
$string['alertannounce'] = 'Anuncio';
$string['alertannouncedesc'] = 'Muestra un anuncio en la zona de alerta.';
$string['alertbackgroundcolorinfo'] = 'Color de fondo de la información';
$string['alertbackgroundcolorinfodesc'] = 'Color de fondo de los cuadros de información';
$string['alertbackgroundcolorsuccess'] = 'Color de fondo del aviso';
$string['alertbackgroundcolorsuccessdesc'] = 'Color de fondo de los cuadros de avisos';
$string['alertbackgroundcolorwarning'] = 'Color de fondo de la advertencia';
$string['alertbackgroundcolorwarningdesc'] = 'Color de fondo de los cuadros de advertencia';
$string['alertbordercolorinfo'] = 'Color del borde';
$string['alertbordercolorinfodesc'] = 'Color de borde de los cuadros de alerta';
$string['alertbordercolorsuccess'] = 'Color de borde de los avisos';
$string['alertbordercolorsuccessdesc'] = 'Color de borde de los cuadros de avisos';
$string['alertbordercolorwarning'] = 'Color de borde de la advertencia';
$string['alertbordercolorwarningdesc'] = 'Color de borde de los cuadros de advertencia';
$string['alertcolorinfo'] = 'Color de información';
$string['alertcolorinfodesc'] = 'Color del icono de los cuadros de información';
$string['alertcolorsheading'] = 'Personalizar los cuadros de alerta superiores';
$string['alertcolorsuccess'] = 'Color del aviso';
$string['alertcolorsuccessdesc'] = 'Color del icono de los cuadros de avisos';
$string['alertcolorwarning'] = 'Color de advertencia';
$string['alertcolorwarningdesc'] = 'Color del icono de los cuadros de advertencia';
$string['alertcount'] = 'Contador de Alertas';
$string['alertcountdesc'] = 'Número de alertas a crear a continuación.';
$string['alertdesc'] = 'Introduce y personaliza el texto de las Alertas mostradas en la parte superior de la pantalla. Es posible crear más de una para mostrarse a diferentes tipos de usuarios. También existe la opción de mostrar las alertas en la página inicial y en las páginas de los cursos.';
$string['alertdisabled'] = 'Desactivado';
$string['alertdisabledesc'] = 'Desactivar esta alerta.';
$string['alerthiddencourse'] = 'Advertencia de curso oculto';
$string['alerthiddencoursedesc'] = 'Mostrar una alerta en la página del curso si este está oculto';
$string['alerticoninfo'] = 'Icono de información';
$string['alerticoninfodesc'] = 'Establece los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de información. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonsuccess'] = 'Icono de aviso';
$string['alerticonsuccessdesc'] = 'Establece los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de aviso de. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alerticonwarning'] = 'Icono de advertencia';
$string['alerticonwarningdesc'] = 'Establece los<a href="http://fortawesome.github.io/Font-Awesome/icons/"> Iconos de Font Awesome</a> que serán utilizados en los cuadros de advertencia. Introduzca el nombre del icono sin el prefijo fa-.';
$string['alertinfo'] = 'Información';
$string['alertinfodesc'] = 'Muestra información en la zona de alerta.';
$string['alertkeyvalue'] = 'Clave de identificación de la Alerta';
$string['alertkeyvalue_details'] = 'Esta clave identifica la alerta y permite el control de la eliminación de la alerta en la pantalla por parte del usuario. Si se cambia la clave, los usuarios volverán a ver la alerta de nuevo.';
$string['alertprofilefield'] = 'Campo de usuario personalizado Nombre=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['alertsettings'] = 'Alerta {$a}';
$string['alertsettingscourse'] = 'Configuración de las alertas del curso';
$string['alertsettingsgeneral'] = 'Configuración Alertas';
$string['alertsettingsheading'] = 'Personalice la parte superior de alerta. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['alerttext'] = 'Texto de la Alerta';
$string['alerttextdesc'] = 'Introduce el texto a mostrar en la alerta.';
$string['alerttype'] = 'Tipo de Alerta';
$string['alerttypedesc'] = 'Selecciona el tipo de alerta: info (azul), aviso (amarillo) o anuncio (verde)';
$string['alertwarning'] = 'Aviso';
$string['alertwarningdesc'] = 'Muestra un aviso en la zona de alerta.';
$string['analyticscount'] = 'Número de campos de perfil';
$string['analyticscountdesc'] = 'Número de campos personalizados a introducir en el área inferior.';
$string['analyticsprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['analyticsprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['analyticssettings'] = 'Analítica Web';
$string['analyticssettingsdesc'] = 'Puedes configurar múltiples códigos para Google Analytics y enlazarlos con diversos campos personalizados.';
$string['analyticssettingsheading'] = 'Configurar Google Analytics';
$string['analyticstext'] = 'ID de Google Analytics.';
$string['analyticstextdesc'] = 'Introducir la ID de Google Analytics.';
$string['anonymizega'] = 'Anonimizar la IP del usuario';
$string['anonymizegadesc'] = 'Anonimizar la IP del usuario remitido a Google Analytics';
$string['backcolor'] = 'Color de fondo';
$string['backcolordesc'] = 'Establece el color de fondo de la plantilla.';
$string['bcustyle'] = 'Estilo BCU';
$string['blockbackgroundcolor'] = 'Color de fondo de los bloques';
$string['blockbackgroundcolordesc'] = 'Establece el color de fondo de los bloques.';
$string['blockbordercolor'] = 'Color del borde de los bloques';
$string['blockbordercolordesc'] = 'Establece el color del borde de los bloques.';
$string['blockheaderbackgroundcolor'] = 'Color del texto de los encabezados de los bloques';
$string['blockheaderbackgroundcolordesc'] = 'Establece el color del texto de los encabezados de los bloques.';
$string['blockheaderborderbottom'] = 'Grueso del borde inferior de los bloques';
$string['blockheaderborderbottomdesc'] = 'Establece el grosor del borde inferior de los bloques.';
$string['blockheaderborderleft'] = 'Grueso del borde izquierdo de los bloques';
$string['blockheaderborderleftdesc'] = 'Establece el grosor del borde izquierdo de los bloques.';
$string['blockheaderborderright'] = 'Grueso del borde derecho de los bloques';
$string['blockheaderborderrightdesc'] = 'Establece el grosor del borde derecho de los bloques.';
$string['blockheaderbordertop'] = 'Grueso del borde superior de los bloques';
$string['blockheaderbordertopdesc'] = 'Establece el grosor del borde superior de los bloques.';
$string['blockheaderbordertopstyle'] = 'Estilo del borde de los bloques';
$string['blockheaderbordertopstyledesc'] = 'Establece el estilo del borde de los bloques laterales.';
$string['blockheaderbottomradius'] = 'Radio de las esquinas inferiores de los bloques laterales';
$string['blockheaderbottomradiusdesc'] = 'Establece el radio de las esquinas inferiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockheadercolor'] = 'Color de fondo de la cabecera de los bloques';
$string['blockheadercolordesc'] = 'Establece el color de fondo de la cabecera de los bloques.';
$string['blockheadertopradius'] = 'Radio de las esquinas superiores de los bloques laterales';
$string['blockheadertopradiusdesc'] = 'Establece el radio de las esquinas superiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockicons'] = 'Mostrar iconos en los bloques';
$string['blockiconsdesc'] = 'Muestra / Oculta un icono relacionado con el tipo de bloque al lado del encabezamiento.';
$string['blockiconsheadersize'] = 'Tamaño del icono de cabecera de bloque';
$string['blockiconsheadersizedesc'] = 'Fija el tamaño de la fuente del icono que se usa en la cabecera de los bloques de moodle. Seleccione un valor de la lista.';
$string['blocklayoutbuilder'] = 'Creador de regiones para bloques';
$string['blocklayoutbuilderdesc'] = 'A continuación puedes crear tu propia distribución de regiones para los bloques de moodle en la página principal.
Para añadir contenido a estas regiones necesitarás <strong>Activar edición en la página principal de Moodle</strong>.
Entonces podrás arrastras y soltar los bloques en las regiones creadas.';
$string['blocklayoutlayoutcheck'] = 'Comprueba la distribución';
$string['blocklayoutlayoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['blocklayoutlayoutcount1'] = 'Puedes crear un máximo de';
$string['blocklayoutlayoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['blocklayoutlayoutrow'] = 'Filas de regiones para bloques';
$string['blocklayoutlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques de la página principal.';
$string['blockmainborderbottom'] = 'Grueso del borde inferior del bloque central';
$string['blockmainborderbottomdesc'] = 'Establece el grosor del borde inferior del bloque central.';
$string['blockmainborderleft'] = 'Grueso del borde izquierdo del bloque central';
$string['blockmainborderleftdesc'] = 'Establece el grosor del borde izquierdo del bloque central.';
$string['blockmainborderright'] = 'Grueso del borde derecho del bloque central';
$string['blockmainborderrightdesc'] = 'Establece el grosor del borde derecho del bloque central.';
$string['blockmainbordertop'] = 'Grueso del borde superior del bloque central';
$string['blockmainbordertopdesc'] = 'Establece el grosor del borde superior del bloque central.';
$string['blockmainbordertopstyle'] = 'Estilo del borde del bloque central';
$string['blockmainbordertopstyledesc'] = 'Establece el estilo del borde de los bloques centrales.';
$string['blockmainbottomradius'] = 'Radio de las esquinas inferiores de los bloques centrales';
$string['blockmainbottomradiusdesc'] = 'Establece el radio de las esquinas inferiores de los bloques centrales. Valor más alto es igual a efecto redondeado';
$string['blockmaintopradius'] = 'Radio de las esquinas superiores de los bloques centrales';
$string['blockmaintopradiusdesc'] = 'Establece el radio de las esquinas superiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockregionbackground'] = 'Color de fondo de las regiones para bloques';
$string['blockregionbackgrounddesc'] = 'Establece el color de fondo del contenedor del constructor de bloques de la página principal.';
$string['blockside'] = 'Posición de los bloques';
$string['blocksidedesc'] = 'Mostrar los bloques en la columna derecha o izquierda.';
$string['breadcrumb'] = 'Ruta de navegación';
$string['breadcrumbbackgroundcolor'] = 'Color de fondo de la ruta de navegación';
$string['breadcrumbbackgroundcolordesc'] = 'Selecciona el color de fondo de la ruta de navegación';
$string['breadcrumbdisplay'] = 'Visualización de la ruta de navegación';
$string['breadcrumbdisplaydesc'] = 'Establece la visualización de lo que debería estar en el área de la ruta de exploración en un curso';
$string['breadcrumbhome'] = 'Inicio de la ruta de navegación';
$string['breadcrumbhomedesc'] = 'Muestra el inicio de la ruta de navegación como icono o como texto.';
$string['breadcrumbhomeicon'] = 'Icono';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de la ruta de navegación';
$string['breadcrumbseparatordesc'] = 'Establece el icono de  <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> para ser usado como separador de los elementos de laruta de navegación. Introducir el nombre del icono sin el prefijo fa-.';
$string['breadcrumbtextcolor'] = 'Color del texto de la ruta de navegación';
$string['breadcrumbtextcolordesc'] = 'Establece el color del texto de la ruta de navegación.';
$string['breadcrumbtitle'] = 'Nombre del curso en la guía de exploración';
$string['breadcrumbtitledesc'] = 'Establece el modo de visualización del título del curso en la guía de exploración.';
$string['bs4all'] = 'Muy pequeño - Muy grande';
$string['bs4extralarge'] = 'Muy grande únicamente';
$string['bs4large'] = 'Grande - Muy grande';
$string['bs4medium'] = 'Mediano - Muy grande';
$string['bs4none'] = 'Ninguno';
$string['bs4small'] = 'Pequeño - Muy grande';
$string['buttoncolor'] = 'Colores de los botones';
$string['buttoncolorcancel'] = 'Color del botón cancelar';
$string['buttoncolordesc'] = 'El color de los botones principales.';
$string['buttoncolordesccancel'] = 'Color de fondo para el botón cancelar. <br>Escriba el nivel de transparencia en la caja para transparencia.';
$string['buttoncolordescscnd'] = 'Color para los botones secundarios utilizados en todo el sitio';
$string['buttoncolorscnd'] = 'Color del botón secundario';
$string['buttondesc'] = 'Modifica la apariencia de los botones utilizados en este tema.';
$string['buttondropshadow'] = 'Efecto sombra bajo el botón';
$string['buttondropshadowdesc'] = 'Mostrar efecto sombra (sombreado) bajo el botón';
$string['buttonhovercolor'] = 'Color del botón al pasar el cursor por encima.';
$string['buttonhovercolorcancel'] = 'Color del botón "Cancelar" al pasar el cursor por encima.';
$string['buttonhovercolordesc'] = 'Color al que cambia el botón al pasar el cursor por encima.';
$string['buttonhovercolordesccancel'] = 'Color al que cambia el botón "Cancelar" al pasar el cursor por encima.<br/>Escriba el nivel de transparencia en la caja de transparencia.';
$string['buttonhovercolordescscnd'] = 'Color al que cambia el botón secundario al pasar el cursor por encima';
$string['buttonhovercolorscnd'] = 'Color del botón secundario al pasar el cursor por encima';
$string['buttonlogincolor'] = 'Color del botón "Entrar"';
$string['buttonlogincolordesc'] = 'Configura el color del botón "Entrar"';
$string['buttonloginheight'] = 'Establece la altura del botón "Entrar"';
$string['buttonloginheightdesc'] = 'Configura la altura del botón "Entrar". Solo si se utiliza el formulario de entrada en la cabecera.';
$string['buttonloginhovercolor'] = 'Color del botón "Entrar" al pasar el cursor por encima.';
$string['buttonloginhovercolordesc'] = 'Color al que cambia el botón "Entrar" al pasar el cursor por encima';
$string['buttonloginmargintop'] = 'Establece la margen superior del botón "Entrar"';
$string['buttonloginmargintopdesc'] = 'Permite posicionar el botón "Entrar" si se han cambiado los valores indicados anteriormente.';
$string['buttonloginpadding'] = 'Establece la separación del texto del botón "Entrar"';
$string['buttonloginpaddingdesc'] = 'Separación alrededor del texto del botón "Entrar". Número más alto = Botón más grande.';
$string['buttonlogintextcolor'] = 'Color del texto del botón "Entrar"';
$string['buttonlogintextcolordesc'] = 'Configura el color del texto del botón "Entrar"';
$string['buttonradius'] = 'Establece el radio de las esquinas del botón';
$string['buttonradiusdesc'] = '0 = esquinas cuadradas. Un valor más alto es igual a esquinas más redondeadas.';
$string['buttonsettings'] = 'Botones';
$string['buttonsettingsheading'] = 'Personalizar los botones.';
$string['buttontextcolor'] = 'Color del texto de los botones';
$string['buttontextcolorcancel'] = 'Color de texto del botón "Cancelar"';
$string['buttontextcolordesc'] = 'Color del texto de los botones.';
$string['buttontextcolordesccancel'] = 'Color del texto usado en los botones "Cancelar".';
$string['buttontextcolordescscnd'] = 'Color del texto usado en los botones secundarios.';
$string['buttontextcolorscnd'] = 'Color de texto del botón secundario';
$string['categoryhavecustomheader'] = 'Encabezado para la categoría personalizada';
$string['categoryhavecustomheaderdesc'] = 'Seleccione las categorías de nivel superior que tendrán un encabezado personalizado. Para seleccionar más de uno o deseleccionar una categoría, use la tecla \'Ctrl\'. Guarde y actualice la página para actualizarla Nota: Las subcategorías de los seleccionados heredarán los valores de configuración.';
$string['categoryheaderbgimage'] = 'Imágen de fondo para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Establece la imagen de fondo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. El tamaño mínimo es 1600x180px (recomendado 1900x180px). La imagen cubrirá completamente el encabezado.';
$string['categoryheaderbgimagedescchildren'] = 'Establezce la imagen de fondo para el encabezado de la categoría \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. El tamaño mínimo es 1600x180px (recomendado 1900x180px). La imagen cubrirá completamente el encabezado.';
$string['categoryheadercustomcss'] = 'CSS personalizado para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Establece un CSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Esto generará CSS para el selector de tema con el prefijo \'.category-{$a->id}\'. Si el CSS no parece aplicarse, verifique el archivo de registro PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Establece un CSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Esto generará CSS para el selector de tema con el prefijo \'.category-{$a->id}\' y todas sus hijas ids. Si el CSS no parece aplicarse, verifique el archivo de registro PHP.';
$string['categoryheadercustomtitle'] = 'Título personalizado para la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Establece un título personalizado en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Si está en blanco, se le presentará lo que ha sido configurado por los ajustes \'Título del sitio\' y \'Texto del título del sitio\' en páginas que no son del curso o en páginas del curso cuando \'Habilitar encabezado\' está \'desactivado\'. Cuando se llena en páginas vinculadas a categorías que no son del curso, esto reemplazará el título del sitio. Cuando se complete en las páginas del curso, aparecerá sobre el título según lo establecido por la configuración \'Habilitar encabezado\'. Pero en los móviles, cualquier \'título\' solo aparecerá dependiendo de la configuración de \'Título del sitio adaptable\' se encuentra en blanco.';
$string['categoryheadercustomtitledescchildren'] = 'Establece un título personalizado en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Si está en blanco, se le presentará lo que ha sido configurado por los ajustes \'Título del sitio\' y \'Texto del título del sitio\' en páginas que no son del curso o en páginas del curso cuando \'Habilitar encabezado\' está \'desactivado\'. Cuando se llena en páginas vinculadas a categorías que no son del curso, esto reemplazará el título del sitio. Cuando se complete en las páginas del curso, aparecerá sobre el título según lo establecido por la configuración \'Habilitar encabezado\'. Pero en los móviles, cualquier \'título\' solo aparecerá dependiendo de la configuración de \'Título del sitio adaptable\' se encuentra en blanco.';
$string['categoryheaderheader'] = 'Configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderheaderdesc'] = 'Establece la configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderheaderdescchildren'] = 'Establece la configuración para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Logo de la categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Establece el logo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Tamaño recomendado 200px by 80px';
$string['categoryheaderlogodescchildren'] = 'Establece el logo en el encabezado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y su hija \'{$a->children}\'. Tamaño recomendado 200px by 80px.';
$string['categoryheaderssettings'] = 'Encabezaos de categoría';
$string['categoryheaderssettingsdesc'] = 'Establece configuraciones para los encabezados dentro de una categoría.';
$string['categoryheaderssettingsheading'] = 'Cambie el encabezado de una o más categorías de nivel superior e inferiores.';
$string['cdefaulticon'] = 'Icono predeterminado de mis cursos';
$string['cdefaulticondesc'] = 'El icono de Font Awesome 4 sin el prefijo \'fa-\' se utilizará en los cursos cuando aún no tengan un icono. Si está vacío, se utilizará el predeterminado.';
$string['cfrozenicon'] = 'Icono de mis cursos congelados';
$string['cfrozenicondesc'] = 'El icono de Font Awesome 4 sin el prefijo \'fa-\' se utilizará para cursos congelados. Si está vacío, se utilizará el predeterminado.';
$string['chiddenicon'] = 'Icono de mis cursos ocultos';
$string['chiddenicondesc'] = 'El icono de Font Awesome 4 sin el prefijo \'fa-\' se utilizará para cursos ocultos. Si está vacío, se utilizará el predeterminado.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
 <h2>Adaptable</h2>
 <p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
 <h2>Créditos</h2>
 <h3>Acerca de...</h3>
 <p>Adaptable es una plantilla para Moodle, de dos columnas y tipo responsive, altamente personalizable y basada en la popular plantilla BCU.</p>
 <p>Esta plantilla está bajo licencia GPL (GNU General Public License). Puedes encontrar la licencia completa en: <a href="http://www.gnu.org/licenses/">http://www.gnu.org/licenses</a></p>
 <p>Modifícala / Mejórala / Compártela</p>
 <br>
 <p>Esta plantilla ha sido creada por:<br>
 Jeremy Hopkins (Coventry University)<br>
 Fernando Acedo (3-bits.com)<br>
 </p>
 <br>
 <h3>Informar de errores</h3>
 <p>Puedes informar de errores encontrados en esta plantilla a través del foro de moodle o en https://bitbucket.org/covuni/moodle-theme_adaptable/issues</p>
 <br>
 <h3>Documentación</h3>
 <br>
 <br>
 <h3>Demo</h3>
 <p>Puedes ver una demostración del sitio y descargar un archivo de instalación en <a href="http://3-bits.com/demo/adaptable">http://3-bits.com/demo/adaptable</a></p>
 <br>
<p>Traducción es-ES: Fernando Acedo (3-bits.com)</p>
</div>
</div>';
$string['cneveraccessedicon'] = 'Icono de mis cursos nunca accedidos';
$string['cneveraccessedicondesc'] = 'El icono de Font Awesome 4 sin el prefijo \'fa-\' se utilizará para los cursos en los que el usuario está inscrito pero a los que no accede. Si está vacío, se utilizará el predeterminado.';
$string['collapsedtopicscoloursenabled'] = 'Configuración alternativa de color de primer plano y de fondo en los Elementos Colapsados';
$string['collapsedtopicscoloursenableddesc'] = 'Utilice la configuración de color de primer plano y fondo de los Elementos Colapsados en lugar de la configuración de \'sectionheadingcolor\' y \'coursesectionheaderbg\' de Adaptable.';
$string['colordesc'] = 'Puedes seleccionar los colores que desees para ser usados por el tema. Usa la notación HEX estándar. También puedes usar como valores <i>transparent</i> e <i>inherited.</i>';
$string['colorsettings'] = 'Colores';
$string['colorsettingsheading'] = 'Modifica los principales colores utilizados en el tema.';
$string['configtabtitle'] = 'Configuración';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Curso';
$string['courseindexitemcolor'] = 'Color del elemento';
$string['courseindexitemcolordesc'] = 'El color del elemento en el \'Índice del curso\' en un curso.';
$string['courseindexitemhovercolor'] = 'Color del elemento al pasar el ratón encima';
$string['courseindexitemhovercolordesc'] = 'El color del elemento al pasarle el ratón encima en el \'ïndice del curso\' en un curso.';
$string['courseindexpageitembgcolor'] = 'Color del fondo del elemento de página';
$string['courseindexpageitembgcolordesc'] = 'El color del fondo del elemento de página en el \'Índice del curso\' en un curso.';
$string['courseindexpageitemcolor'] = 'Color del elemento de página';
$string['courseindexpageitemcolordesc'] = 'el color del elemento de la página en el \'Índice del curso\' en un curso.';
$string['courseindexsettings'] = 'Índice del curso';
$string['courseindexsettingsdesc'] = 'Personalizar el Índice del Curso.';
$string['courseindexsettingsheading'] = 'Configuraciones del índice del curso';
$string['coursepageactivitybottomblockregionheading'] = 'Región tras el bloque de actividad del curso personalizada';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Una región que aparece tras el bloque de actividades del curso.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar región tras el bloque de actividad en página del curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageblocklayoutbuilder'] = 'Regiones de Bloques de Página de Curso';
$string['coursepageblocklayoutbuilderdesc'] = 'Abajo puede definir su propia distribución de bloques para la página de curso.
Para añadir contenido a esta regiones deberá <strong>habilitar la edición en la página del curso de Moodle</strong>.
¡Entonces podrá arrastrar y soltar bloques en las regiones que haya creado!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Región de bloques en la fila inferior de la página de Curso';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Añade / fija la distribución de una fila de bloques en la página de Curso.';
$string['coursepageblocklayoutlayouttoprow'] = 'Región de bloques en la fila superior de la página de Curso';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Añade / fija la distribución de una fila de bloques en la página de Curso.';
$string['coursepageblockregionsettings'] = 'Constructor de regiones de bloques en la página de Curso';
$string['coursepageblocksenabled'] = 'Habilitar regiones de bloques personalizadas en página de Curso';
$string['coursepageblocksenableddesc'] = 'Puede habilitar / deshabilitar regiones de bloques personalizados (superiores e inferiores) en la página de Curso.
Luego podrá arrastrar y soltar bloques en las regiones que haya creado';
$string['coursepageblocksliderenabled'] = 'Habilitar región de bloque presentaciones personalizado en página de Curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar título del sitio en páginas de curso';
$string['coursepageheaderhidesitetitledesc'] = 'Ocultar título del sitio, logotipo y barra de búsqueda en páginas de curso. Utilice esto junto con el tamaño de cabecera de página para mostrar una cabecera más compacta en páginas relacionadas con cursos.';
$string['coursepagenewssliderblockregionheading'] = 'Región de bloque de noticias personalizado';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Una región de bloque personalizada diseñada para usar con el control deslizante de noticias que forma parte de la IU Adaptable. Esta región aparece encima de las actividades del curso en una página del curso. Para agregar un bloque deslizante de noticias, primero instale el <strong> <a href="https://moodle.org/plugins/block_news_slider"> control deslizante de noticias de UI adaptable </a> </ strong> y configúrelo para que aparezca en la región "región del deslizador de la página del curso" en todas las páginas del curso.';
$string['coursepagesidebarinfooterenabled'] = 'Desplazar barra lateral al pie en páginas de Cursos';
$string['coursepagesidebarinfooterenableddesc'] = 'Distribución ancha de la página de curso desplazando la barra lateral a pie de página.';
$string['coursepagesidebarinfooterenabledsection'] = 'Opciones comunes';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Opciones comunes para la mayoría de los formatos de curso.';
$string['courses'] = 'Cursos';
$string['coursesearch'] = 'Búsqueda de curso';
$string['coursesectionactivityassignbgcolor'] = 'Color de fondo de asignación de actividad';
$string['coursesectionactivityassignbgcolordesc'] = 'Establece el color de fondo de asignación de la actividad. Escriba <strong>transparent</strong> para transparente.';
$string['coursesectionactivityassignleftbordercolor'] = 'Color de visualización del borde izquierdo de asignación de actividad';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionactivitybordercolor'] = 'Color del borde inferior Sección del curso Actividad';
$string['coursesectionactivitybordercolordesc'] = 'Establece el Color del borde inferior';
$string['coursesectionactivityborderstyle'] = 'Estilo del borde inferior de Curso Sección Actividad';
$string['coursesectionactivityborderstyledesc'] = 'Establece estilo del borde inferior de Curso Sección Actividad';
$string['coursesectionactivityborderwidth'] = 'Ancho del borde inferior de curso Sección Actividad';
$string['coursesectionactivityborderwidthdesc'] = 'Establece el ancho del borde que aparece en la parte inferior de una actividad de la sección del curso.';
$string['coursesectionactivitycolors'] = 'Opciones de actividad de la sección del curso';
$string['coursesectionactivityforumbgcolor'] = 'Color de fondo de la actividad del foro';
$string['coursesectionactivityforumbgcolordesc'] = 'Establece el color de fondo de la actividad del foro. Escriba <strong>transparent</strong> para transparente.';
$string['coursesectionactivityforumleftbordercolor'] = 'Color de visualización del borde izquierdo de la actividad del foro';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionactivityheadingcolour'] = 'Curso Sección Actividad Título Color';
$string['coursesectionactivityheadingcolourdesc'] = 'El color de las actividades en las que se puede hacer clic que se muestran en la página de inicio del curso.';
$string['coursesectionactivityiconsize'] = 'Tamaño del icono de la actividad de la sección del curso';
$string['coursesectionactivityiconsizedesc'] = 'Establece el tamaño del icono para actividades / recursos (por ejemplo, un valor de 16px lo establecerá en 16px x 16px)';
$string['coursesectionactivityleftborderwidth'] = 'Ancho del borde izquierdo de la sección de actividades del curso';
$string['coursesectionactivityleftborderwidthdesc'] = 'Establece el ancho del borde que aparece a la izquierda de una actividad de la sección del curso.';
$string['coursesectionactivitymarginbottom'] = 'Intervalo de actividad del margen inferior.';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaciado del margen inferior entre actividades.';
$string['coursesectionactivitymargintop'] = 'Espaciado de actividad del margen superior';
$string['coursesectionactivitymargintopdesc'] = 'Espaciado de margen superior entre actividades';
$string['coursesectionactivityquizbgcolor'] = 'Color de fondo de actividad de prueba';
$string['coursesectionactivityquizbgcolordesc'] = 'Establece el color de fondo de la actividad del cuestionario. Escriba <strong>transparent</strong> para transparente.';
$string['coursesectionactivityquizleftbordercolor'] = 'Actividad de prueba color de visualización del borde izquierdo';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Establece el color del borde izquierdo.';
$string['coursesectionbgcolor'] = 'Antecedentes de la sección del curso';
$string['coursesectionbgcolordesc'] = 'Establece el color de fondo de la sección del curso.';
$string['coursesectionbordercolor'] = 'Color del borde de la sección';
$string['coursesectionbordercolordesc'] = 'Establece el color del borde de la sección del curso.';
$string['coursesectionborderradius'] = 'Radio del borde de la sección';
$string['coursesectionborderradiusdesc'] = 'Establece el radio del borde de las esquinas de la sección del curso.';
$string['coursesectionborderstyle'] = 'Estilo del borde de la sección del curso';
$string['coursesectionborderstyledesc'] = 'Establece el estilo del borde de la sección del curso.';
$string['coursesectionborderwidth'] = 'Grueso del borde de la sección';
$string['coursesectionborderwidthdesc'] = 'Establece el grueso del borde de la sección del curso.';
$string['coursesectionheaderbg'] = 'Color de fondo de la cabecera';
$string['coursesectionheaderbgdesc'] = 'Establece el color de fondo de la cabecera de la sección del curso.';
$string['coursesectionheaderbordercolor'] = 'Color del borde inferior de la cabecera';
$string['coursesectionheaderbordercolordesc'] = 'Establece el color del borde de la cabecera de la sección del curso (sólo se utiliza el borde inferior ya que el contenedor exterior también tiene un borde).';
$string['coursesectionheaderborderradiusbottom'] = 'Radio de las esquinas del borde inferior de la cabecera';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Establece el radio de las esquinas del borde inferior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderradiustop'] = 'Radio de las esquinas del borde superior de la cabecera';
$string['coursesectionheaderborderradiustopdesc'] = 'Establece el radio de las esquinas del borde superior de la cabecera de la sección del curso.';
$string['coursesectionheaderborderstyle'] = 'Estilo del borde inferior de la cabecera';
$string['coursesectionheaderborderstyledesc'] = 'Establece el estilo del borde de la cabecera de la sección del curso (sólo se utiliza el borde inferior ya que el contenedor exterior también tiene un borde).';
$string['coursesectionheaderborderwidth'] = 'Grueso del borde inferior de la cabecera';
$string['coursesectionheaderborderwidthdesc'] = 'Establece el ancho del borde de la cabecera de la sección del curso (sólo se utiliza el borde inferior ya que el contenedor exterior también tiene un borde).';
$string['coursesections'] = 'Secciones del curso';
$string['coursesettings'] = 'Secciones del curso';
$string['coursesettingsdesc'] = 'Personalice algunos de los formatos de curso más utilizados en Moodle para adaptarlos al diseño principal.';
$string['coursesettingsheading'] = 'Configuración de las secciones del curso.';
$string['coursetitlefullname'] = 'Nombre completo del curso';
$string['coursetitlemaxwidth'] = 'Ancho máximo del título del curso';
$string['coursetitlemaxwidthdesc'] = 'Establece el ancho máximo del área donde se muestra el título del curso.';
$string['coursetitleshortname'] = 'Nombre corto / código del curso';
$string['covbkcolor'] = 'Color de fondo en los bloques estilo Coventry';
$string['covbkcolordesc'] = 'Establece el color de superposición de los bloques cuando se ha seleccionado el estilo Coventry.';
$string['coventrystyle'] = 'Estilo Coventry';
$string['covfontcolor'] = 'Color del texto en los bloques estilo Coventry';
$string['covfontcolordesc'] = 'Establece el color del texto en los bloques estilo Coventry.';
$string['covhidebutton'] = 'Mostrar el botón del curso en los bloques estilo Coventry';
$string['covhidebuttondesc'] = 'Muestra / oculta el botón del curso cuando se utiliza el estilo Coventry';
$string['currentcolor'] = 'Color de realce de la sección actual';
$string['currentcolordesc'] = 'Establece el color de realce de la sección actual.';
$string['customcoursesubtitle'] = 'Título del curso personalizado';
$string['customcoursesubtitledesc'] = 'Nombre del campo personalizado del perfil de usuario para el título del curso.';
$string['customcoursetitle'] = 'Título del curso personalizado';
$string['customcoursetitledesc'] = 'Nombre del campo personalizado del perfil de usuario para el título del curso.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Introduce las reglas CSS personalizadas.';
$string['dangericoncolor'] = 'Color del icono de advertencia';
$string['dangericoncolordesc'] = 'Establece el color del icono de advertencia / peligro utilizado principalmente en los campos obligatorios.';
$string['dashblocklayoutbuilder'] = 'Region de Bloques del Tablero de Control';
$string['dashblocklayoutbuilderdesc'] = 'A continuación podrá crear su propio diseño para las regiones de bloques en el tablero de control.
Para agregar contenido a estas regiones necesitará <strong> activar la edición de la página en el panel de control de Moodle. <strong> ¡Entonces podrá comenzar a arrastrar/soltar bloques en las regiones que cree!';
$string['dashblocklayoutlayoutrow'] = 'Fila del tablero de control';
$string['dashblocklayoutlayoutrowdesc'] = 'Agrega/establece el diseño para la fila de bloques en el tablero de control.';
$string['dashblocksabovecontent'] = 'Mostrar el contenido principal anterior';
$string['dashblocksbelowcontent'] = 'Mostrar a continuación el contenido principal';
$string['dashblocksenabled'] = 'Habilitar regiones de bloques personalizadas en el tablero de control.';
$string['dashblocksenableddesc'] = 'Puede habilitar/deshabilitar las regiones de bloques personalizadas en el tablero de control.
A continuación podrá arrastrar y soltar bloques en las regiones que ha creado.';
$string['dashblocksposition'] = 'Posición de región de bloque personalizada';
$string['dashblockspositiondesc'] = 'Cuando las regiones de bloque personalizadas están habilitadas para la página del panel, elija la posición.';
$string['dashboardblockregionsettings'] = 'Constructor de regiones de bloques en el tablero de control';
$string['dashed'] = 'A rayas discontinuas';
$string['defaultzoom'] = 'Zoom predeterminado';
$string['defaultzoomdesc'] = 'El tamaño de pantalla predeterminado cuando se habilita el zoom está desactivado o el usuario no ha hecho ninguna preferencia. Elija entre pantalla completa y ancho fijo.';
$string['dimmedtextcolor'] = 'Color del texto atenuado';
$string['dimmedtextcolordesc'] = 'La clase CSS del texto atenuado (dimmed_text) es usado por Moodle para indicar cuando algo está deshabilitado / no visible. Para configurar ese color en el tema use código hexadecimal HTML.';
$string['disablecustommenu'] = 'Desactivar el menú personalizado de Moodle';
$string['disablecustommenudesc'] = 'Desactiva el menú personalizado de Moodle en la barra de navegación (seguirá funcionando en otras plantillas instaladas)';
$string['disabled'] = 'Desactivado';
$string['disablemenuscoursepages'] = 'Desactivar menús en las páginas de los cursos';
$string['disablemenuscoursepagesdesc'] = 'Activando esta opción los menús solo se mostrarán en las páginas del sitio, la página inicial, el Área Personal, etc. y no se mostrará en las páginas de los cursos.';
$string['discardbuttontext'] = 'Cancelar';
$string['displayeditingbuttontext'] = 'Edición de texto del botón';
$string['displayeditingbuttontextdesc'] = 'Mostrar u ocultar el texto en el botón de edición. Nota: Solo se aplica al botón de edición del curso.';
$string['displaygrades'] = 'Mostrar calificaciones';
$string['displaygradesdesc'] = 'Mostrar el elemento calificaciones en el menú';
$string['displaylogin'] = 'Mostrar';
$string['displayloginbox'] = 'Caja de entrada';
$string['displayloginbutton'] = 'Botón';
$string['displaylogindesc'] = 'Selecciona como mostrar la caja de entrada en la pantalla (cuando se activa aqui abajo)';
$string['displayloginno'] = 'Sin cuadro de inicio de sesión';
$string['displayparticipants'] = 'Mostrar participantes';
$string['displayparticipantsdesc'] = 'Mostrar el elemento Participantes en el menú';
$string['dividingline'] = 'Línea divisora de la cabecera';
$string['dividingline2'] = 'Línea divisora del pie de página';
$string['dividingline2desc'] = 'Establece el color de la línea divisora del pie de página.';
$string['dividinglinedesc'] = 'Establece el color de la línea divisora de la cabecera.';
$string['dotted'] = 'Punteada';
$string['double'] = 'Doble';
$string['editcognocourseupdate'] = 'Mostrar rueda del engrane a usuarios que no tienen permiso de actualizar';
$string['editcognocourseupdatedesc'] = 'Mostrar rueda del engrane a usuarios que no tienen permiso \'moodle/course:update\'  como por ejemplo los profesores sin derecho de edición.';
$string['editfont'] = 'Color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['editfontdesc'] = 'Establece el color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['edithorizontalpadding'] = 'Establece el espaciado horizontal de los botones de edición';
$string['editoffbk'] = 'Color de fondo de los botones de edición y personalización desactivados';
$string['editoffbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están desactivados.';
$string['editonbk'] = 'Color de fondo de los botones de edición y personalización activados';
$string['editonbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están activados.';
$string['editsettingsbutton'] = 'Editar configuración y visualización de botones';
$string['editsettingsbuttondesc'] = 'Configure aquí lo que debe aparecer en la barra de navegación para editar la configuración. Tenga en cuenta que estas opciones no se aplican a las páginas para las que no hay configuraciones relacionadas, como la página del tablero.';
$string['editsettingsbuttonshowbutton'] = 'Mostrar solo el botón de edición. P.ej. Botón "Activar edición" en la página del curso.';
$string['editsettingsbuttonshowcog'] = 'Mostrar solo el icono de configuración de edición (icono de engranaje / rueda dentada).';
$string['editsettingsbuttonshowcogandbutton'] = 'Mostrar icono de configuración de edición y engranaje. Tenga en cuenta que esto ocupa más espacio en la navegación.';
$string['emoticonsize'] = 'Tamaño del emoticono';
$string['emoticonsizedesc'] = 'Establece el ancho y alto de los emoticonos de moodle.';
$string['enableaccesstool'] = 'Herramienta de Accesibilidad';
$string['enableaccesstooldesc'] = 'Mostrar un enlace a la página de preferencias de la "Herramienta de Accesibilidad" de los usuarios - Nota: esto requiere el <a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">Complemento de Herramienta de Accesibilidad</a>';
$string['enablealert'] = 'Activar Alerta {$a}';
$string['enablealertdesc'] = 'Activar la alerta {$a}.';
$string['enablealerts'] = 'Activar / Desactivar Alertas';
$string['enablealertsdesc'] = 'Activar / desactivar alertas en el sitio.';
$string['enablealertstriptags'] = 'Eliminar etiquetas HTML del texto de la Alerta';
$string['enablealertstriptagsdesc'] = 'Si se activa, se eliminarán las etiquetas HTML del texto. Si está desactivado, se permitirá introducir etiquetas HTML por ejemplo para añadir enlaces.';
$string['enableanalytics'] = 'Activar Google Analytics';
$string['enableanalyticsdesc'] = 'Activar Google Analytics en el sitio.';
$string['enableavailablecourses'] = 'Mostrar el texto "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el texto <i>Cursos Disponibles</i> sobre el listado de cursos en la página inicial.';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar el enlace de las insignias del usuario.';
$string['enableblog'] = 'Blogs del usuario';
$string['enableblogdesc'] = 'Mostrar el enlace a los blogs del usuario.';
$string['enablecalendar'] = 'Calendario';
$string['enablecalendardesc'] = 'Mostrar el enlace al calendario del usuario.';
$string['enablecompetencieslink'] = 'Enlace de competencias';
$string['enablecompetencieslinkdesc'] = 'Mostrar el enlace de competencias en el menú \'Este curso\'. Nota: \'core_competency|habilitado\' debe marcarse.';
$string['enablecoursesectionsdesc'] = 'Muestre un submenú en el menú \'Este curso\' que contiene enlaces a cada sección mostrada.';
$string['enabledtabbedprofileeditprofilelink'] = 'Habilitar el enlace de edición de perfil';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Habilite el enlace de edición de perfil con pestañas. Nota: cuando está habilitado, solo se mostrará si el usuario que está viendo tiene permiso para editar el perfil.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Habilitar enlace de preferencias';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Habilite el enlace de preferencias de usuario del perfil con pestañas.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar el enlace para editar el perfil del usuario.';
$string['enableeventsdesc'] = 'Mostrar un enlace al calendario';
$string['enablefeed'] = 'Mis opiniones';
$string['enablefeeddesc'] = 'Mostrar el enlace a la página "Opiniones" - Nota: esta opción requiere el <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> instalado';
$string['enablegrades'] = 'Calificaciones';
$string['enablegradesdesc'] = 'Mostrar el enlace de las calificaciones del usuario.';
$string['enableheading'] = 'Mostrar nombre del curso';
$string['enableheadingdesc'] = 'Establece el modo de visualización del título del curso en la cabecera.';
$string['enablehelp'] = 'Enlace de ayuda \'{$a->number}\\';
$string['enablehelpdesc'] = 'Añade un enlace de ayuda \'{$a->number}\'  en la barra de navegación.';
$string['enablehomedesc'] = 'Mostrar enlace a Inicio';
$string['enablehomeredirect'] = 'Activar redirect=0';
$string['enablehomeredirectdesc'] = 'Activa la opción redirect=0 para redirigir a la página inicial del sitio. Está opción puede utilizarse en sitios que tienen el Área Personal como página inicial por defecto. Desactivada previene redirigir a los usuarios a la página inicial y ser redirigidos al Área Personal';
$string['enablemenus'] = 'Activar Menús';
$string['enablemenusdesc'] = 'Por motivos de rendimiento, se recomienda no activarlo si no se utilizan los menús.';
$string['enablemy'] = 'Panel';
$string['enablemydesc'] = 'Mostrar el enlace a Panel';
$string['enablemysitesdesc'] = 'Mostrar las actividades del curso';
$string['enablemysitesrestriction'] = 'Restrinja el menú desplegable de cursos del usuario a un campo de perfil personalizado';
$string['enablemysitesrestrictiondesc'] = 'Restrinja el menú desplegable con los cursos de un usuario por campo de perfil personalizado. Por ejemplo, usertype = staff';
$string['enablenavbarwhenloggedout'] = 'Habilitar la barra de navegación cuando cierre sesión';
$string['enablenavbarwhenloggedoutdesc'] = 'Muestra la barra de navegación incluso cuando está desconectado. Limitado solo al menú Ayuda y Herramientas.';
$string['enablenote'] = 'Notificaciones';
$string['enablenotedesc'] = 'Mostrar el enlace página de notificaciones.';
$string['enableposts'] = 'Mis entradas';
$string['enablepostsdesc'] = 'Mostrar el enlace a las entradas en los foros realizadas por el usuario.';
$string['enablepref'] = 'Preferencias';
$string['enableprefdesc'] = 'Mostrar el enlace a las preferencias del usuario.';
$string['enableprivatefiles'] = 'Archivos privados';
$string['enableprivatefilesdesc'] = 'Mostrar el enlace a los archivos privados del usuario.';
$string['enableprofile'] = 'Perfil usuario';
$string['enableprofiledesc'] = 'Mostrar el enlace del perfil de usuario.';
$string['enablesavecanceloverlay'] = 'Habilite Guardar / Cancelar superposición en las páginas de configuración';
$string['enablesavecanceloverlaydesc'] = 'Muestre una superposición de botón Guardar / Cancelar en la parte superior de una página de configuración para que sea más fácil guardar la configuración.';
$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar bloques';
$string['enableshowhideblocksdesc'] = 'Permite a los usuarios mostrar / ocultar los bloques laterales.';
$string['enableshowhideblockstext'] = 'Mostrar texto para Mostrar Ocultar bloques';
$string['enableshowhideblockstextdesc'] = 'Muestra el texto al lado del botón.';
$string['enabletabbedprofile'] = 'Habilitar perfil con pestañas';
$string['enabletabbedprofiledesc'] = 'Habilite la funcionalidad de perfil con pestañas.';
$string['enablethiscoursedesc'] = 'Mostrar un menú desplegable con actividades del curso actual.';
$string['enableticker'] = 'Mostrar los anuncios en la página principal';
$string['enabletickerc'] = 'Mostrar la barra de anuncios en las páginas internas';
$string['enabletickercdesc'] = 'Muestra la barra de anuncios en las páginas internas de moodle.';
$string['enabletickerdesc'] = 'Muestra la barra de anuncios en la página principal.';
$string['enabletickermy'] = 'Mostrar la barra de anuncios en Mi Área personal / Panel de control';
$string['enabletickermydesc'] = 'Muestra la barra de anuncios en Mi Área personal / Panel de control.';
$string['enabletoolsmenus'] = 'Activar menús de herramientas';
$string['enabletoolsmenusdesc'] = 'Por razones de rendimiento se recomienda dejarlo desactivado si no se utilizan.';
$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permite a los usuarios cambiar entre pantalla completa o ancho fijo de pantalla.';
$string['enablezoomshowtext'] = 'Mostrar texto para Activar zoom';
$string['enablezoomshowtextdesc'] = 'Muestra el texto al lado del botón.';
$string['events'] = 'Eventos';
$string['expandable'] = 'Expandible';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Carga el archivo favicon.ico que se muestra en la pestaña del navegador.';
$string['fontblockheadercolor'] = 'Color de fuente para el encabezado de los bloques';
$string['fontblockheadercolordesc'] = 'Establece el color de los bloques de Moodle de la fuente de la cabecera, utilice el código hexadecimal html. Tenga en cuenta que esto afecta al color del icono también.';
$string['fontblockheadersize'] = 'Tamaño de fuente para el encabezado de los bloques';
$string['fontblockheadersizedesc'] = 'Establece el tamaño de fuente para el encabezado de los bloques. Seleccione un valor de la lista.';
$string['fontblockheaderweight'] = 'Grosor de fuente para los encabezados de bloques';
$string['fontblockheaderweightdesc'] = 'Establece el grosor de fuente usado en los encabezados de los bloques. Seleccione un valor entre 100 y 900 dependiendo del tipo de fuente seleccionada.';
$string['fontcolor'] = 'Color de la fuente principal';
$string['fontcolordesc'] = 'Establece el color de la fuente principal.';
$string['fontdefault'] = 'Predeterminado';
$string['fontdesc'] = 'Selecciona la fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> para el texto, los encabezamientos y el título. Selecciona también el juego de caracteres a usar (latín está incluido por defecto) e introduce el valor correcto para el grueso de fuente utilizado o no se mostrará.';
$string['fontheadercolor'] = 'Color de la fuente de encabezamientos';
$string['fontheadercolordesc'] = 'Establece el color de la fuente de los encabezamientos utilizados en la plantilla.';
$string['fontheadername'] = 'Fuente encabezamientos';
$string['fontheadernamedesc'] = 'Establece la fuente de los encabezamientos utilizados en la plantilla. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontheaderweight'] = 'Grueso de la fuente de encabezamientos';
$string['fontheaderweightdesc'] = 'Establece el grueso de la fuente de los encabezamientos. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontname'] = 'Fuente principal';
$string['fontnamedesc'] = 'Establece la fuente principal. Selecciona defecto o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontsettings'] = 'Fuentes';
$string['fontsettingsheading'] = 'Establece las fuentes utilizadas por la plantilla.';
$string['fontsize'] = 'Tamaño de la fuente principal';
$string['fontsizedesc'] = 'Selecciona el tamaño de la fuente principal usada en todo el sitio (en porcentaje).';
$string['fontsubset'] = 'Juego de caracteres de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccionar el juego de caracteres de Google Fonts a usar además del latín ya incluido por defecto. Se aplicará a toda las fuentes seleccionadas.';
$string['fonttitlecolor'] = 'Color de la fuente del título del sitio';
$string['fonttitlecolorcourse'] = 'Color de la fuente del título del curso';
$string['fonttitlecolorcoursedesc'] = 'Establece el color de la fuente usada en el título del curso.';
$string['fonttitlecolordesc'] = 'Establece el color de la fuente del título del sitio situado en la cabecera.';
$string['fonttitlename'] = 'Fuente del título del sitio';
$string['fonttitlenamedesc'] = 'Establece la fuente del título del sitio situado en la cabecera. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fonttitlesize'] = 'Tamaño de la fuente del título del sitio';
$string['fonttitlesizedesc'] = 'Tamaño de la fuente del título del sitio situado en la cabecera. Introducir un valor decimal, por ejemplo: 24px';
$string['fonttitleweight'] = 'Grueso de la fuente del título del sitio';
$string['fonttitleweightdesc'] = 'Establece el grueso de la fuente del título del sitio. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontweight'] = 'Grueso de la fuente principal';
$string['fontweightdesc'] = 'Establece el grueso de la fuente principal. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['footerbkcolor'] = 'Color de fondo del pie de página superior';
$string['footerbkcolordesc'] = 'Establece el color de fondo del pie de página superior.';
$string['footerblocksplacement'] = 'Páginas donde mostrar los bloques del pie de página';
$string['footerblocksplacement1'] = 'Todo el sitio';
$string['footerblocksplacement2'] = 'Página Inicial Únicamente';
$string['footerblocksplacement3'] = 'Nunca';
$string['footerblocksplacementdesc'] = 'Definir los lugares donde se deben mostrar los bloques del pie de página. Todo el sitio es la opción por defecto.';
$string['footercontent'] = 'Contenido del bloque del pie de página';
$string['footercontentdesc'] = 'Añade el código HTML del bloque del pie de página (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['footerdesc'] = 'Añade el titulo del bloque del pie de página';
$string['footerheader'] = 'Titulo del bloque del pie de página';
$string['footerlayoutrow'] = 'Creador de regiones para los bloques del pie de página';
$string['footerlayoutrowdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques del pie de página que has utilizado.';
$string['footerlinkcolor'] = 'Color de los enlaces del pie de página';
$string['footerlinkcolordesc'] = 'Establece el color de los enlaces del pie de página.';
$string['footersettings'] = 'Pie de Página';
$string['footersettingsheading'] = 'A continuación puedes crear tu propia distribución de regiones para el pie de página.
Para añadir contenido a estas regiones necesitarás <strong>Activar edición en la página principal de Moodle</strong>.
Entonces podrás arrastras y soltar los bloques en las regiones creadas.';
$string['footertextcolor'] = 'Color de texto del pie de página superior';
$string['footertextcolor2'] = 'Color del texto del pie de página inferior';
$string['footertextcolor2desc'] = 'Establece el color del texto del pie de página inferior.';
$string['footertextcolordesc'] = 'Establece el color de texto en el pie de página superior.';
$string['footnote'] = 'Texto del bloque del pie de página';
$string['footnotedesc'] = 'Añade el código HTML del bloque de pie de página (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['forumbodybackgroundcolor'] = 'Fondo del cuerpo de la publicación del foro';
$string['forumbodybackgroundcolordesc'] = 'Color de fondo para una publicación en el foro';
$string['forumheaderbackgroundcolor'] = 'Fondo del encabezado de la publicación del foro';
$string['forumheaderbackgroundcolordesc'] = 'Color de fondo para una publicación en el foro';
$string['frnt-footer'] = 'Los bloques de esta área solo serán visibles para los administradores.';
$string['frontpageblocksenabled'] = 'Activa las regiones para bloques en la página principal';
$string['frontpageblocksenableddesc'] = 'Activa o desactiva las regiones para bloques de la página principal.
Puedes arrastrar y soltar los bloques en las regiones creadas.';
$string['frontpageblocksettings'] = 'Bloques promocionales';
$string['frontpagecoursesettings'] = 'Cursos';
$string['frontpagedesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagemarketenabled'] = 'Activar los bloques promocionales';
$string['frontpagemarketenableddesc'] = 'Activar los bloques promocionales en la pagina de inicio.';
$string['frontpagemarketoption'] = 'Estilo de los bloques promocionales';
$string['frontpagemarketoptiondesc'] = 'Establecer los bloques promocionales tipo Coventry. Configurar el color de esta opción en la página de colores.';
$string['frontpagenumbertiles'] = 'Cantidad de mosaicos de curso por fila';
$string['frontpagenumbertilesdesc'] = 'Número de mosaicos de curso para mostrar por fila en la lista de cursos de la página principal';
$string['frontpagerenderer'] = 'Bloques de cursos';
$string['frontpagerendererdefaultimage'] = 'Imagen por defecto para los cursos';
$string['frontpagerendererdefaultimagedesc'] = 'Sube la imagen que se utilizará por defecto en los cursos que no dispongan de ella.  (solo se aplica en el estilo "Bloques Superpuestos")';
$string['frontpagerendererdesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagerendereroption1'] = 'Bloques';
$string['frontpagerendereroption2'] = 'Bloques sin incrustar';
$string['frontpagerendereroption3'] = 'Por defecto';
$string['frontpagerendereroption4'] = 'Tipo Coventry';
$string['frontpagesettingsheading'] = 'Página Inicial';
$string['frontpageslidersettings'] = 'Presentación diapositivas';
$string['frontpagetiles1'] = '1 azulejo';
$string['frontpagetiles2'] = '2 azulejos';
$string['frontpagetiles3'] = '3 azulejos';
$string['frontpagetiles4'] = '4 azulejos';
$string['frontpagetiles6'] = '6 azulejos';
$string['frontpageuserblocksenabled'] = 'Habilitar bloque en región costado-post en la Portada para usuarios';
$string['frontpageuserblocksenableddesc'] = 'Usted puede habilitar / deshabilitar la región del bloque costado-post en la Portada para los usuarios. Nota: \'Usuarios\' aquí significa invitados y usuarios autenticados; Administradores siempre verán la región.';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenwidth'] = 'Ancho de pantalla completa';
$string['fullscreenwidthdesc'] = 'Establece el ancho máximo de la pantalla en modo pantalla completa / zoom.';
$string['future'] = 'Futuro';
$string['gdprbutton'] = 'Botón de resumen de retención de datos';
$string['gdprbuttondesc'] = 'Mostrar el botón Resumen de retención de datos en el pie de página.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Puedes añadir múltiples códigos de Google Analytics y enlazarlos a campos de perfíl de usuario.';
$string['googleanalyticssettingsheading'] = 'Configurar Google analytics en tu sitio.';
$string['googlefonts'] = 'Google fonts';
$string['googlefontsdesc'] = 'Habilitar <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> para los nombres de los font que estipule excepto para \'Default\' (Predeterminado).  Cuando esté \'deshabilitado\', usted tiene la oportunidad de servir los fonts usted mismo mediante modificaciones al  CSS / tema o de tenerlos ya instalados en los dispositivos de los usuarios.  Cuando está \'habilitado\' seleccione los subconjuntos necesitados (latin siempre está incluido) e introduzca la ponderación (el peso) correcta o el font no será mostrado.  <b>NOTA: ¡Adaptable está licenciado en GPLv3 y podría contener errores; por favor verifique usted mismo que ha deshabilitado los fonts de Google que no estén siendo usados!</b>';
$string['headerbgimage'] = 'Imagen de fondo';
$string['headerbgimagedesc'] = 'Establezca una imagen de fondo en la cabecera. El tamaño mínimo es 1600 x 180 px (se recomienda 1900 x 180 px). La imagen cubre el encabezado completamente. Puede agregar un color en \'Color de fondo del encabezado superior\' o usar <i> transparente </i> para mostrar la imagen de fondo. En ese caso midifique el color de texto para que se presente correctamente en la imagen.';
$string['headerbkcolor'] = 'Color de fondo de la parte superior de la cabecera';
$string['headerbkcolor2'] = 'Color de fondo de la parte inferior de la cabecera';
$string['headerbkcolor2desc'] = 'Establece el color de fondo del encabezado inferior. Tenga en cuenta que esto también establece el color para el fondo en el estilo de encabezado 2.';
$string['headerbkcolordesc'] = 'Establece el color de fondo de la parte superior de la cabecera.';
$string['headerdesc'] = 'Mostrar Alertas para avisar a los usuarios, controlar la barra de navegación, mostrar el título del sitio o el logo son algunas de las opciones de la cabecera.';
$string['headernavbarhelpheading'] = 'Enlaces de ayuda y opciones';
$string['headernavbarhelpheadingdesc'] = 'Opciones para enlaces del menú de ayuda.';
$string['headernavbarmycoursesheading'] = 'Menú de mis cursos';
$string['headernavbarmycoursesheadingdesc'] = 'Todas las opciones para la opción de menú Mis cursos (Mis sitios) que muestra la lista de cursos del usuario actual';
$string['headernavbarthiscourseheading'] = 'Este menú del curso';
$string['headernavbarthiscourseheadingdesc'] = 'En este menú, el alumno puede acceder directamente a todas las actividades del curso y a la lista de participantes y sus calificaciones.';
$string['headersearchandsocial'] = 'Encabezado búsqueda y social';
$string['headersearchandsocialnone'] = 'Ninguno';
$string['headersearchandsocialsearchheader'] = 'Buscar en encabezado';
$string['headersearchandsocialsearchmobilenav'] = 'Buscar en encabezado y barra de navegación en móviles';
$string['headersearchandsocialsearchnavbar'] = 'Buscar en barra de navegación';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Buscar en barra de navegación, social en encabezado';
$string['headersearchandsocialsocialheader'] = 'Social en encabezado';
$string['headersettings'] = 'Cabecera';
$string['headersettingsheading'] = 'Personalización de la cabecera.';
$string['headerstyle'] = 'Estilo de encabezado';
$string['headerstyle1'] = 'Encabezado 1 (encabezado original de 3 filas)';
$string['headerstyle2'] = 'Encabezado 2 (encabezado de 2 filas)';
$string['headerstyledesc'] = 'Elige el estilo del encabezado. El encabezado 1 se refiere al encabezado adaptable original de 3 filas. El encabezado 2 es un encabezado mínimo de 2 filas. Tenga en cuenta que cuando use el Encabezado 2, para la configuración "Usar cuadro de búsqueda o iconos sociales", esto siempre usará un cuadro de búsqueda.';
$string['headerstyleheading'] = 'Configuración de estilo de encabezado';
$string['headerstyleheadingdesc'] = 'Adaptable admite dos estilos de encabezado, el encabezado original de tres filas y un nuevo encabezado simplificado de dos filas.
Tenga en cuenta que si cambia al encabezado de dos filas, <strong> NO </strong> podrá: <br />
<ol> <li> Mostrar iconos sociales en el encabezado </li> <li> Mostrar el logotipo del sitio en dispositivos móviles </li> </ol>';
$string['headertextcolor'] = 'Color de texto y enlaces de la parte superior de la cabecera';
$string['headertextcolor2'] = 'Color del texto y enlaces de la parte inferior de la cabecera';
$string['headertextcolor2desc'] = 'Establece el color de texto y enlaces de la parte inferior de la cabecera.';
$string['headertextcolordesc'] = 'Establece el color de texto y enlaces de la parte superior de la cabecera.';
$string['help'] = 'Ayuda';
$string['helplinkscount'] = 'Número de enlaces de ayuda';
$string['helplinkscountdesc'] = 'Establezca el número de enlaces de ayuda que desea agregar a la barra de navegación principal.';
$string['helplinktitle'] = 'Titúlo del enlace de ayuda \'{$a->number}\'';
$string['helplinktitledesc'] = 'El título para el enlace de ayuda \'{$a->number}\' en la barra de navegación. Si está vacío el valor predeterminado es \'Ayuda {$a->number}\'.';
$string['helpprofilefield'] = 'Campo personalizado para la ayuda (opcional)';
$string['helpprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['helptarget'] = 'Nueva ventana de ayuda';
$string['helptargetdesc'] = 'Abrir la ayuda en la misma ventana o en una nueva.';
$string['helptitle'] = 'Ayuda {$a->number}';
$string['hiddencourses'] = 'Cursos ocultos';
$string['hiddenfromview'] = 'Oculto a la vista';
$string['hide'] = 'Ocultar';
$string['hidefootersocial'] = 'Mostrar iconos sociales';
$string['hidefootersocialdesc'] = 'Mostrar iconos sociales en el pie de página, después de los bloques.';
$string['hideinforum'] = 'Ocultar Menús de Ayuda y Herramientas en los foros';
$string['hideinforumdesc'] = 'Si se utiliza un ancho fijo de pantalla es posible que los menús salten a la línea inferior. Activando esta opción se ocultan los menús en las páginas de foros.';
$string['home'] = 'Inicio';
$string['homebk'] = 'Imagen de fondo';
$string['homebkdesc'] = 'Carga la imagen de fondo para la plantilla.';
$string['hvpcustomcss'] = 'CSS Personalizado de HP5';
$string['hvpcustomcssdesc'] = 'CSS personalizado para el módulo H5P';
$string['infobox'] = 'Cuadro informativo 1';
$string['infobox2'] = 'Cuadro informativo 2';
$string['infobox2desc'] = 'Añade el código HTML del cuadro informativo 2 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxdesc'] = 'Añade el código HTML del cuadro informativo 1 (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos)';
$string['infoboxfullscreen'] = 'Cuadros informativos a ancho completo';
$string['infoboxfullscreendesc'] = 'Marca está opción para mostrar los cuadros informativos a ancho completo de pantalla.';
$string['infoiconcolor'] = 'Color del icono de ayuda';
$string['infoiconcolordesc'] = 'Establezca el color del icono de información / ayuda utilizado por la información sobre herramientas.';
$string['informationsettingsdesc'] = 'Información sobre el tema Adaptable.';
$string['inprogress'] = 'En progreso';
$string['introboxbackgroundcolor'] = 'Color de fondo de la caja de ingreso';
$string['introboxbackgroundcolordesc'] = 'Color de fondo para el cuadro de introducción (descripción de la actividad resaltada) utilizado en foros y otras actividades';
$string['jssection'] = 'Javascript personalizado';
$string['jssectiondesc'] = 'Introduce el código Javascript personalizado.';
$string['jssectionrestricted'] = 'Sección Javascript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir Javascript solo en la página del Panel';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar el javascript solo en la página del tablero. De lo contrario, esto se muestra en todo el sitio.';
$string['jssectionrestricteddesc'] = 'Agregue código javascript al sitio condicionalmente en función de un campo de perfil personalizado. Este javascript solo aparecerá si se cumple esta condición.';
$string['jssectionrestrictedprofilefield'] = 'Campo de perfil personalizado de la sección Javascript';
$string['jssectionrestrictedprofilefielddesc'] = 'Muestre el javascript arriba SOLAMENTE cuando el usuario coincida con este valor de campo de perfil personalizado, por ejemplo: facultad = fbl.';
$string['jumpto'] = 'Salta a...';
$string['landscape'] = 'Apaisado';
$string['layoutaddcontent'] = 'Añade contenido a los bloques promocionales:';
$string['layoutaddcontentdesc1'] = 'Has configurado';
$string['layoutaddcontentdesc2'] = 'bloques promocionales. Si estás conforme con la distribución añade el contenido de los bloques promocionales.
Si no estás conforme, usa el creador de regiones para bloques promocionales para realizar cambios<br />';
$string['layoutcheck'] = 'Comprueba la distribución';
$string['layoutcheckdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques que has utilizado.';
$string['layoutcount1'] = 'Puedes crear un máximo de';
$string['layoutcount2'] = 'regiones para bloques. Ahora estás usando:';
$string['layoutdesc'] = 'Configuración de la disposición por defecto.';
$string['layoutsettings'] = 'Disposición';
$string['layoutsettingsheading'] = 'Controlar las diferentes disposiciones de la plantilla.';
$string['leftblocks'] = 'Izquierda';
$string['linkcolor'] = 'Color enlace';
$string['linkcolordesc'] = 'Establece el color de los enlaces.';
$string['linkhover'] = 'Color del enlace al pasar el cursor por encima.';
$string['linkhoverdesc'] = 'Establece el color de los enlaces (al pasar el cursor por encima) en el tema, use el código hexadecimal html.';
$string['linksmenu'] = 'Menú de enlaces';
$string['loadingcolor'] = 'Color del cargador';
$string['loadingcolordesc'] = 'Color del cargador situado en la parte superior de la página.';
$string['loginbgimage'] = 'Imagen de fondo';
$string['loginbgimagedesc'] = 'Agregue una imagen de fondo a la página de tamaño completo.';
$string['loginbgopacity'] = 'Encabezado de página de inicio de sesión, barra de navegación, cuadro de inicio de sesión y opacidad de fondo del pie de página cuando hay una imagen de fondo';
$string['loginbgopacitydesc'] = 'Opacidad de fondo de inicio de sesión para el encabezado, barra de navegación, cuadro de inicio de sesión y pie de página cuando hay una imagen de fondo';
$string['loginbgstyle'] = 'Estilo de fondo de inicio de sesión';
$string['loginbgstyledesc'] = 'Seleccione el estilo de la imagen cargada.';
$string['logindesc'] = 'Personalice la página de inicio de sesión agregando un fondo de imagen y textos encima y debajo del cuadro de inicio de sesión.';
$string['loginfooter'] = 'Pie de página de inicio de sesión';
$string['loginfooterdesc'] = 'Mostrar el pie de página de inicio de sesión.';
$string['loginheader'] = 'Encabezado de página de inicio de sesión';
$string['loginheaderdesc'] = 'Mostrar el encabezado de la página de inicio de sesión.';
$string['loginplaceholder'] = 'Usuario';
$string['loginsettings'] = 'Página de inicio de sesión';
$string['loginsettingsheading'] = 'Personaliza la página de inicio de sesión.';
$string['logintextboxbottom'] = 'Cuadro de texto inferior';
$string['logintextboxbottomdesc'] = 'Agregue un texto personalizado debajo del cuadro de inicio de sesión.';
$string['logintextboxtop'] = 'Cuadro de texto superior';
$string['logintextboxtopdesc'] = 'Agregue un texto personalizado sobre el cuadro de inicio de sesión.';
$string['logintextbutton'] = 'Entrar';
$string['logintextbuttonwhenoidc'] = 'Ingreso Invitado/Manual';
$string['logintextmanualbutton'] = 'Ingreso a cuenta de prueba';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Sube el archivo con la imagen del logo (170px x 100px max.). Formatos admitidos: .png, .jpg y .gif';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Establece el color principal del sitio.';
$string['maincoursepage'] = 'Página del curso principal';
$string['market'] = 'Bloque promocional';
$string['marketblockbordercolor'] = 'Color del borde de los bloques promocionales';
$string['marketblockbordercolordesc'] = 'Establece el color del borde de los bloques promocionales.';
$string['marketblocksbackgroundcolor'] = 'Color de fondo de la región de los bloques promocionales.';
$string['marketblocksbackgroundcolordesc'] = 'Establece el color de fondo de la región de los bloques promocionales.';
$string['marketdesc'] = 'Añade el código HTML del bloque promocional (ver el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más ejemplos).';
$string['marketingbuilderdesc'] = 'Utiliza esta opción para ver la distribución creada y comprobar el número de bloques promocionales que has utilizado.';
$string['marketingbuilderheading'] = 'Creador de regiones para bloques promocionales';
$string['marketingdesc'] = 'Dispones de dos cuadros informativos a los que puedes aplicar diferentes estilos. Además puedes activar el creador de regiones
para bloques y decidir cuantos bloques quieres mostrar y su distribución en la página de inicio. Puedes ver la distribución de las diferentes regiones en el archivo  <a href="/adaptable/README.txt" target="_blank">README.txt</a>';
$string['marketingsettings'] = 'Bloques promocionales';
$string['marketingsettingsheading'] = 'Personaliza los bloques promocionales que aparecen en la página de inicio. Ver la distribución <a href="./../theme/adaptable/pix/layout.png" target="_blank">aqui</a>';
$string['marketlayoutrow'] = 'Filas de regiones para bloques promocionales';
$string['marketlayoutrowdesc'] = 'Añade / establece la distribución de filas de las regiones para bloques promocionales de la página principal.';
$string['menubkcolor'] = 'Color de fondo del menú principal';
$string['menubkcolordesc'] = 'Establece el color de fondo del menú principal.';
$string['menubordercolor'] = 'Color de la línea divisoria de la barra de navegación';
$string['menubordercolordesc'] = 'Establece el color de la linea divisoria de la barra de navegación.';
$string['menufontcolor'] = 'Color de texto del menú principal';
$string['menufontcolordesc'] = 'Establece el color del texto del menú principal.';
$string['menufontpadding'] = 'Separación entre los ítems de la barra de navegación';
$string['menufontpaddingdesc'] = 'Establece la separación entre los ítems de la barra de navegación.';
$string['menufontsize'] = 'Tamaño de fuente de la barra de navegación';
$string['menufontsizedesc'] = 'Establece el tamaño de fuente de la barra de navegación.';
$string['menuoverrideprofilefield'] = 'Nombre del campo personalizado';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'El nombre del campo de perfil "list" usado por la anulación por usuario.';
$string['menusdesc'] = '';
$string['menusession'] = 'Almacenar los detalles de acceso en la sesión';
$string['menusessiondesc'] = 'Se aconseja activar esta opción para optimizar el rendimiento en caso de utilizar varios menús. Mantener desactivado para pruebas.';
$string['menusessionttl'] = 'Tiempo (minutos) de almacenamiento del acceso a los menús por sesión';
$string['menusessionttldesc'] = 'Número de minutos antes de reiniciar la sesión.';
$string['menusettings'] = 'Menús de cabecera';
$string['menusettingsheading'] = 'Personaliza los menús de la cabecera superior.';
$string['menusheading'] = 'Configurar Navegación para los menús de la parte superior de la cabecera';
$string['menusheadingvisibility'] = 'Configuración para la visibilidad del menú superior';
$string['menusheadingvisibilitydesc'] = 'La siguiente configuración permite controlar donde mostrar los menús y opcionalmente permitir a los usuarios su personalización.';
$string['menuslinkicon'] = 'Ícono de menú de enlaces';
$string['menuslinkicondesc'] = 'Elija un icono impresionante de fuente personalizada.';
$string['menuslinkright'] = 'Mostrar el menú de enlaces en la parte superior derecha';
$string['menuslinkrightdesc'] = 'Si está seleccionado, se mostrará el enlace a los menús en la parte superior derecha, junto al menú de mensajes';
$string['menustitledesc'] = 'Los menús de herramientas (en la barra de navegación) y los menús superiores (cabecera superior) pueden ser restringidos dependiendo de un campo personalizado del perfil de usuario (opcional). Los menús siguen el formato de los menús estándar de moodle:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Permitir la anulación por usuario';
$string['menuuseroverridedesc'] = 'Esta configuración controla el uso de los menús a través del perfil de usuario. Para usar esta función, se ha de crear un campo personalizado de usuario tipo lista con los siguientes valores:
<pre>1. Sitewide (mostrará el menú en todo el sitio)
2. Homepages Only (mostrará el menú solo en la página principal)
3. Hidden (no se mostrarán los menús)</pre>
NO debes utilizar la opción "Desactivar menús en las páginas de los cursos" junto a los campos de perfil. En su lugar, selecciona  "Homepages Only".

Nota: Los usuarios deberán salir de moodle y volver a entrar para que los cambios hagan efecto. Puede indicarse una nota al crear el campo personalizado.';
$string['messagepopupbackground'] = 'Color de fondo para mensajes emergentes.';
$string['messagepopupbackgrounddesc'] = 'Establezca el color de fondo para los mensajes emergentes.';
$string['messagepopupcolor'] = 'Color de texto para mensajes emergentes.';
$string['messagepopupcolordesc'] = 'Establezca el color de texto para los mensajes emergentes.';
$string['messagingbackgroundcolor'] = 'Color de fondo de la ventana principal de mensajes';
$string['messagingbackgroundcolordesc'] = 'Establezca el color de fondo para la ventana de chat principal de mensajes.';
$string['mobilemenubkcolor'] = 'Color de fondo del menú para móvil';
$string['mobilemenubkcolordesc'] = 'Establece el color de fondo del menú principal en móviles (colapsado)';
$string['moodledocs'] = 'Mostrar enlace a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar un enlace a Moodle Docs en el pie de página.';
$string['more'] = 'Más';
$string['myblogs'] = 'Mis Blogs';
$string['mycoursesmenulimit'] = 'Límite del menú Mis Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajuste el número máximo de cursos que aparecerán en el menú Mis Cursos. 0 mostrará todos los cursos.';
$string['mysites'] = 'Mis Cursos';
$string['mysitesdisabled'] = 'Desactivado';
$string['mysitesexclude'] = 'Mostrar excluyendo los cursos ocultos';
$string['mysitesinclude'] = 'Mostrar incluyendo los cursos ocultos';
$string['mysitesmaxlength'] = 'Longitud máxima del título del curso en "Mis Cursos"';
$string['mysitesmaxlengthdesc'] = 'Ajusta la longitud máxima del título del curso a mostrar en "Mis Cursos". La longitud dependerá del tamaño y de la fuente usada.';
$string['mysitesmenudisplay'] = 'Pantalla del menú Mis cursos';
$string['mysitesmenudisplaydesc'] = 'Elija qué texto mostrar para un elemento del menú y  su comportamiento al pasar el cursor por encima';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar el título completo del curso y el título completo al pasar el cursor por encima.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar el título completo del curso y sin texto al pasar el cursor por encima.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código corto y nombre completo del curso al cursor por encima.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar código corto y sin texto al pasar el cursor por encima.';
$string['mysitessortoverride'] = 'Activar el orden personalizado de "Mis Cursos"';
$string['mysitessortoverridedesc'] = 'Usa campos personalizados o textos (año, edad, ...) para colapsar los cursos en un desplegable.';
$string['mysitessortoverridefield'] = 'Campo personalizado o texto para filtrar "Mis Cursos"';
$string['mysitessortoverridefielddesc'] = 'Lista con delimitación por comas de los campos o textos a comprobar en el nombre corto de curso.';
$string['mysitessortoverridelast'] = 'Hora del último acceso u hora de inicio de la inscripción si nunca se accedió';
$string['mysitessortoverridemyoverview'] = 'Usar lista de mi descripción general';
$string['mysitessortoverrideoff'] = 'Mostrar lista de cursos.';
$string['mysitessortoverrideprofilefields'] = 'Muestra los cursos coincidentes con un campo personalizado en una lista. El resto son mostrados en un submenú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Muestra los cursos coincidentes con un campo de perfil y los cohortes en primer lugar. El resto son mostrados en un submenú.';
$string['mysitessortoverridestrings'] = 'Muestra todos los cursos en los que está matriculado el alumno en una lista. El resto son mostrados en un submenú.';
$string['navbarcachetime'] = 'Caché de la barra de navegación';
$string['navbarcachetimedesc'] = 'El tiempo, en minutos, que se guarda la barra de navegación.';
$string['navbardesc'] = 'Controlar los diferentes elementos a mostrar en la barra de navegación.';
$string['navbardisplayicons'] = 'Mostrar iconos';
$string['navbardisplayiconsdesc'] = 'Mostrar iconos junto a los encabezados del menú principal';
$string['navbardropdownborderradius'] = 'Radio del borde del menú desplegable';
$string['navbardropdownborderradiusdesc'] = 'Controla el radio del borde para los menús desplegables (por ejemplo, esquinas redondeadas).';
$string['navbardropdownhovercolor'] = 'Color del fondo del menú desplegable al pasar el cursor por encima';
$string['navbardropdownhovercolordesc'] = 'Color de fondo del menú desplegable al pasar el cursor el cursor por encima de los elementos del menú.';
$string['navbardropdowntextcolor'] = 'Color del texto del menú desplegable';
$string['navbardropdowntextcolordesc'] = 'Color del texto del elemento del menú desplegable.';
$string['navbardropdowntexthovercolor'] = 'Color del texto del menú desplegable al pasar el cursor por encima.';
$string['navbardropdowntexthovercolordesc'] = 'Color del texto del menú desplegable al pasar el cursor el cursor por encima los elementos del menú.';
$string['navbardropdowntransitiontime'] = 'Tiempo de transición de la barra de navegación';
$string['navbardropdowntransitiontimedesc'] = 'Tiempo de efecto de transición de la barra de navegación en segundos. Proporciona un efecto de animación de desvanecimiento al pasar el cursor por encima de un menú que tiene submenús.';
$string['navbarlinksettingsdesc'] = 'Le permite controlar los enlaces que aparecen en la barra de navegación.';
$string['navbarlinksettingsheading'] = 'Personaliza los enlaces en la barra de navegación';
$string['navbarlinkssettings'] = 'Enlaces de barra de navegación';
$string['navbarsettings'] = 'Barra de navegación';
$string['navbarsettingsheading'] = 'Personalizar la barra de navegación';
$string['navbarstyles'] = 'Estilos de barra de navegación';
$string['navbarstylesdesc'] = 'Le permite controlar los estilos de los elementos que aparecen en la barra de navegación.';
$string['navbarstylesheading'] = 'Personaliza los estilos de la barra de navegación';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenudesc'] = 'Configurar los enlaces mostrados bajo el menú de la cabecera superior.';
$string['newmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['newmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=alumno';
$string['newmenuheading'] = 'Menú superior';
$string['newmenurequirelogin'] = 'Requiere Entrar';
$string['newmenurequirelogindesc'] = 'Si está activado este menú será visible a los usuarios que autenticados';
$string['newmenutitle'] = 'Título menú superior';
$string['newmenutitledefault'] = 'Menú';
$string['newmenutitledesc'] = 'El título del menú aparecerá en la cabecera del sitio';
$string['newstickercount'] = 'Número de barras de anuncios';
$string['newstickercountdesc'] = 'Define barras de anuncios con diferentes reglas de acceso para mostrarlas a diferentes tipos de usuarios.';
$string['nextactivity'] = 'Próxima actividad';
$string['nextsection'] = 'Siguiente sección';
$string['noenrolments'] = 'No hay matriculaciones.';
$string['none'] = 'Ninguno';
$string['normal'] = 'Ancho fijo';
$string['nostyle'] = 'Sin estilo';
$string['onetopicactivetabbackgroundcolor'] = 'Color del fondo de pestaña activa';
$string['onetopicactivetabbackgroundcolordesc'] = 'El Color del fondo de la pestaña activa en un curso de \'Un Tópico\'.';
$string['onetopicactivetabtextcolor'] = 'Color del texto de pestaña activa';
$string['onetopicactivetabtextcolordesc'] = 'El Color del texto de la pestaña activa en un curso de \'Un Tópico\'.';
$string['onetopicdesc'] = 'Personalizar la apariencia de \'<a href="https://moodle.org/plugins/format_onetopic">Formato de Curso de Un Tópico</a>\' si es que se usa en su sitio).';
$string['onetopicheading'] = 'Un Tópico';
$string['originaltemplatepreview'] = 'Vista previa del archivo de tema original/anulado';
$string['originaltemplatesource'] = 'Fuente de archivo de tema original/anulado';
$string['overriddentemplate'] = 'Plantilla anulada {$a}';
$string['overriddentemplatedesc'] = 'Si se establece, el texto aquí se utilizará como plantilla \'{$a}\'.  Para asegurarse de que la vista previa funcione, debe haber un contexto de ejemplo estándar en formato JSON';
$string['overriddentemplatenopreview'] = 'Sin vista previa porque falta el ejemplo JSON';
$string['overriddentemplatepreview'] = 'Configuración de vista previa anulada';
$string['overridetemplate'] = 'Plantilla de anulación: {$a}';
$string['pageheaderalternative'] = 'Alternativo';
$string['pageheaderheight'] = 'Altura de la cabecera';
$string['pageheaderheightdesc'] = 'Establece la altura de la cabecera (incluyendo logo y títulos)';
$string['pageheaderlayout'] = 'Diseño del encabezado de página';
$string['pageheaderlayoutdesc'] = 'El diseño del encabezado de página. Afecta solamente el estilo del encabezado uno. El estilo del encabezado dos no cambia. Nota: \'Alternativo\' está sujeto a cambios imprevistos y todavía está en desarrollo.';
$string['pageheaderlayouttwo'] = 'Encabezado dos, diseño de encabezado de página';
$string['pageheaderlayouttwodesc'] = 'El diseño de encabezado de página para el estilo dos de encabezado.';
$string['pageheadernosearch'] = 'Sin búsqueda';
$string['pageheaderoriginal'] = 'Original';
$string['passwordplaceholder'] = 'Contraseña';
$string['past'] = 'Pasado';
$string['pastcourses'] = 'Cursos anteriores';
$string['people'] = 'Gente';
$string['piwikenabled'] = 'Activado';
$string['piwikenableddesc'] = 'Habilitar el seguimiento de Matomo (antes Piwik) para Moodle.';
$string['piwikimagetrack'] = 'Imagen de rastreo';
$string['piwikimagetrackdesc'] = 'Habilitar el seguimiento de imágenes de Moodle para los navegadores con JavaScript desactivado.';
$string['piwiksettings'] = 'Análisis de Matomo (antes Piwik)';
$string['piwiksettingsdesc'] = 'Generar una URL limpia para rastreo avanzado.';
$string['piwiksettingsheading'] = 'Configurar Matomo (antes Piwik)';
$string['piwiksiteid'] = 'ID del sitio';
$string['piwiksiteiddesc'] = 'Introducir la ID del sitio.';
$string['piwiksiteurl'] = 'URL de Matomo (antes Piwik)';
$string['piwiksiteurldesc'] = 'Introduce la URL donde está instalado Matomo (antes Piwik)sin http(s) ni barra invertida.';
$string['piwiktrackadmin'] = 'Rastreo de administradores';
$string['piwiktrackadmindesc'] = 'Activar el rastreo de administradores (no recomendado)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Retrato';
$string['previousactivity'] = 'Actividad previa';
$string['previoussection'] = 'Sección previa';
$string['printbodyfontsize'] = 'Tamaño del tipo de letra (font) del cuerpo (body)';
$string['printbodyfontsizedesc'] = 'Configurar el tamaño del ipo de letra (font) del cuerpo (body).';
$string['printlineheight'] = 'Altura de línea';
$string['printlineheightdesc'] = 'Configurar la altura de la línea';
$string['printmargin'] = 'Márgen';
$string['printmargindesc'] = 'Configurar el márgen';
$string['printpageorientation'] = 'Orientación de la página';
$string['printpageorientationdesc'] = 'Configurar la orientación de la página a \'Retrato\' o \'Paisaje\'.';
$string['printsettings'] = 'Impresión';
$string['printsettingsdesc'] = 'Establecer la configuración de impresión.';
$string['printsettingsheading'] = 'Configuración de impresión';
$string['properties'] = 'Configuración de importación / exportación';
$string['propertiesdesc'] = 'En esta sección, puede importar / exportar la configuración actual del tema Adaptable (propiedades) en formato JSON. También puede ver todas las configuraciones actuales en esta instalación de Moodle.';
$string['propertiesexport'] = 'Exportar propiedades como una cadena JSON';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Regreso';
$string['propertiessub'] = 'Configuración actual del tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Adicional:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegue la cadena JSON y \'Guardar cambios\'. ¡Advertencia! No valida los valores de configuración y realiza una \'Purga de todas las memorias caché\'.';
$string['putpropertiesfrom'] = 'desde';
$string['putpropertiesheading'] = 'Importar configuraciones de tema';
$string['putpropertiesignorecti'] = 'Ignorando todas las configuraciones de imagen del título del curso.';
$string['putpropertiesignored'] = 'Ignorado';
$string['putpropertiesname'] = 'Importar propiedades';
$string['putpropertiesreportfiles'] = 'Recuerde cargar los siguientes archivos a su configuración:';
$string['putpropertiessettingsreport'] = 'Informe de configuración:';
$string['putpropertiesunchanged'] = 'Sin alterar:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestro';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'Informe:';
$string['putpropertyversion'] = 'versión:';
$string['region-course-bottom-a'] = 'Página del curso región inferior 5';
$string['region-course-bottom-b'] = 'Página del curso región inferior 6';
$string['region-course-bottom-c'] = 'Página del curso, región inferior 7';
$string['region-course-bottom-d'] = 'Página del curso, región inferior 8';
$string['region-course-section-a'] = 'Actividad de la página del curso final región inferior';
$string['region-course-tab-one-a'] = 'Pestaña página del curso región 1';
$string['region-course-tab-two-a'] = 'Pestaña página del curso región 2';
$string['region-course-top-a'] = 'Página principal del curso región 1';
$string['region-course-top-b'] = 'Página superior del curso región 2';
$string['region-course-top-c'] = 'Página superior del curso región 3';
$string['region-course-top-d'] = 'Página superior del curso región 4';
$string['region-frnt-footer'] = 'Pie';
$string['region-frnt-market-a'] = 'Marketing-a';
$string['region-frnt-market-b'] = 'Marketing-b';
$string['region-frnt-market-c'] = 'Marketing-c';
$string['region-frnt-market-d'] = 'Marketing-d';
$string['region-frnt-market-e'] = 'Marketing-e';
$string['region-frnt-market-f'] = 'Marketing-f';
$string['region-frnt-market-g'] = 'Marketing-g';
$string['region-frnt-market-h'] = 'Marketing-h';
$string['region-frnt-market-i'] = 'Marketing-i';
$string['region-frnt-market-j'] = 'Marketing-j';
$string['region-frnt-market-k'] = 'Marketing-k';
$string['region-frnt-market-l'] = 'Marketing-l';
$string['region-frnt-market-m'] = 'Marketing-m';
$string['region-frnt-market-n'] = 'Marketing-n';
$string['region-frnt-market-o'] = 'Marketing-o';
$string['region-frnt-market-p'] = 'Marketing-p';
$string['region-frnt-market-q'] = 'Marketing-q';
$string['region-frnt-market-r'] = 'Marketing-r';
$string['region-frnt-market-s'] = 'Marketing-s';
$string['region-frnt-market-t'] = 'Marketing-t';
$string['region-my-tab-one-a'] = 'Región de pestaña de página del Panel 1';
$string['region-my-tab-two-a'] = 'Pestaña de página del panel región 2';
$string['region-news-slider-a'] = 'Región del control deslizante de la página del curso';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['regionmaincolor'] = 'Color de la región principal';
$string['regionmaincolordesc'] = 'Establece el color de fondo de la región principal.';
$string['rendereroverlaycolor'] = 'Color superpuesto';
$string['rendereroverlaycolordesc'] = 'Establece el color superpuesto sobre el bloque de curso cuando "Bloques Superpuestos" está seleccionado.';
$string['rendereroverlayfontcolor'] = 'Color de texto en la superposición';
$string['rendereroverlayfontcolordesc'] = 'Establece el color de la fuente cuando pasa el cursor por encima del bloque del curso y "Bloques Superpuestos" está activado.';
$string['responsivebreadcrumb'] = 'Ruta de Navegación';
$string['responsivebreadcrumbdesc'] = '¿En qué tamaño de pantallas, le gustaría que se muestre la Ruta de Navegación?';
$string['responsivecoursetitle'] = 'Título del Sitio/Curso';
$string['responsivecoursetitledesc'] = '¿En qué tamaño de pantallas, le gustaría que se mostraran los títulos del Sitio/Curso?';
$string['responsiveheader'] = 'Encabezado principal';
$string['responsiveheaderdesc'] = '¿En qué tamaño de pantallas, le gustaría que se muestre el encabezado principal?<br/>
    Esta configuración solo se aplica si está utilizando el encabezado de 3 filas predeterminado / original.<br/>
    Eliminar el encabezado por completo también eliminará los elementos que contiene:<br/>
    <ul><li>Iconos Social</li><li>Logo</li><li>Título del Sitio/Curso</li></ul>';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = '¿En qué tamaño de pantallas le gustaría que se muestre el logo?';
$string['responsivepagefooter'] = 'Pie de página';
$string['responsivepagefooterdesc'] = '¿En qué tamaño de pantallas, le gustaría que se muestre el Pie de página?';
$string['responsivesectionnav'] = 'Navegación por actividad/sección';
$string['responsivesectionnavdesc'] = 'Mostrar/Ocultar el <strong>texto</strong> para la navegación de la sección actividad "anterior" "siguiente" en pantallas pequeñas.
        De forma predeterminada, ocultamos este texto en pantallas más pequeñas, por lo que solo se muestran los íconos de los enlaces <prev> <siguiente> y no el nombre completo de la sección/actividad.';
$string['responsivesettings'] = 'Diseño Receptivo';
$string['responsivesettingsdesc'] = 'Aquí puede controlar el comportamiento receptivo de su sitio (qué elementos aparecen en pantallas de diferentes tamaños).<br/>
    De forma predeterminada, la mayoría de los elementos no esenciales están ocultos en los dispositivos móviles y se configuran para que aparezcan solo en pantallas más grandes.<br/>
    Puede hacer que los elementos aparezcan en pantallas más pequeñas eligiendo mostrarlos en "pantallas extra pequeñas" o "pantallas pequeñas".<br/>
    Para comprender mejor cómo funcionan estas configuraciones, consulte la documentación de Bootstrap 4:<br/><br/>
    https://getbootstrap.com/docs/4.0/utilities/display/ <br/><br/>';
$string['responsivesettingsheading'] = 'Controle cómo se comporta su sitio en diferentes tamaños de pantalla';
$string['responsiveslider'] = 'Control Deslizante de la página principal';
$string['responsivesliderdesc'] = '¿En qué tamaño de pantallas, le gustaría que se muestre el Control Deslizante de la página principal?';
$string['responsivesocial'] = 'Iconos Sociales';
$string['responsivesocialdesc'] = '¿En qué tamaño de pantallas le gustaría que se muestren los iconos sociales?';
$string['responsivesocialsize'] = 'Establecer el tamaño de fuente de los iconos sociales en dispositivos móviles';
$string['responsivesocialsizedesc'] = 'Para una mejor vista, el tamaño debe ser 5px mayor que el tamaño real deseado.';
$string['responsiveticker'] = 'Noticias';
$string['responsivetickerdesc'] = '¿En qué tamaño de pantallas le gustaría que se muestren las Noticias?';
$string['rightblocks'] = 'Derecha';
$string['savebuttontext'] = 'Guardar cambios';
$string['searchboxpadding'] = 'Cuadro de búsqueda acolchado';
$string['searchboxpaddingdesc'] = 'Establezca el relleno encima del cuadro de búsqueda (si se usa en lugar de los iconos sociales) <br /> Por ejemplo, 5px 10px 5px 10px (arriba, derecha, abajo, izquierda). <br> Puede configurar los iconos sociales debajo de <a href = "./ ../admin/settings.php?section=theme_adaptable_social">Header Social </a> página de configuración.';
$string['sectionheadingcolor'] = 'Color de fondo de la cabecera de sección';
$string['sectionheadingcolordesc'] = 'Establece el color de fondo de la cabecera del tema actual.';
$string['sections'] = 'Secciones';
$string['selectionbackground'] = 'Color de fondo de la selección';
$string['selectionbackgrounddesc'] = 'Establece el color de fondo del texto seleccionado.';
$string['selectiontext'] = 'Color de texto de la selección';
$string['selectiontextdesc'] = 'Establece el color del texto seleccionado';
$string['settingsalertbox'] = 'Alertas';
$string['settingsanalytics'] = 'Estadísticas';
$string['settingsblockicons'] = 'Iconos';
$string['settingsborders'] = 'Bordes';
$string['settingsbreadcrumbcolors'] = 'Colores de la ruta de navegación';
$string['settingscolors'] = 'Colores';
$string['settingscourses'] = 'Cursos';
$string['settingsfonts'] = 'Fuentes';
$string['settingsfootercolors'] = 'Colores del pie de página';
$string['settingsforumheading'] = 'Foro';
$string['settingsheadercolors'] = 'Colores cabecera';
$string['settingsinfoboxcolors'] = 'Colores cuadro informativo principal';
$string['settingsinformation'] = 'Información';
$string['settingsmaincolors'] = 'Colores principales';
$string['settingsmarketingcolors'] = 'Colores bloques moodle';
$string['settingsmessagescolors'] = 'Colores para los mensajes emergentes';
$string['settingsmobilecolors'] = 'Colores móviles';
$string['settingsnavbarcolors'] = 'Colores de la barra de navegación';
$string['settingsoverlaycolors'] = 'Colores bloques cursos';
$string['settingssecondinfoboxcolors'] = 'Colores cuadro informativo secundario';
$string['settingstopicsweeks'] = 'Temas / Semanas';
$string['show'] = 'Mostrar';
$string['showfooterblocks'] = 'Mostrar bloques en el pie de página';
$string['showfooterblocksdesc'] = 'Muestra / Oculta los bloques personalizables del pie de página.';
$string['shownavigationblockoncoursepage'] = 'Mostrar bloque de Navegación en la página del curso';
$string['shownavigationblockoncoursepagedesc'] = 'Configure esto para mostrar el bloque de Navegación en la página del curso';
$string['showusername'] = 'Mostrar nombre de usuario';
$string['showusernamedesc'] = 'Mostrar el nombre de usuario en el menú del usuario en la barra de navegación.';
$string['side-post1'] = 'Barra lateral en pie de página';
$string['sidebaricon'] = 'Muestra/oculta la barra lateral';
$string['sitelinkslabel'] = 'Enlaces del sitio';
$string['sitetitle'] = 'Mostrar título del sitio';
$string['sitetitlecoursesdisabled'] = 'Desactivado - muestra solo el título del curso en las páginas del curso';
$string['sitetitlecoursesenabled'] = 'Activado - muestra el nombre del sitio y el título del cursos en las páginas del curso';
$string['sitetitlecustom'] = 'Usar nombre del sitio personalizado (introducir el texto en el siguiente campo)';
$string['sitetitledefault'] = 'Usar el nombre del sitio Moodle';
$string['sitetitledesc'] = 'Muestra el titulo del sitio moodle por defecto introducido en <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Ajustes de Portada</a> o introduce un texto en la caja inferior. Si se añade una imagen para el logotipo entonces no se mostrará.';
$string['sitetitleoff'] = 'Desactivar el nombre del sitio';
$string['sitetitletext'] = 'Nombre del sitio';
$string['sitetitletextdesc'] = 'El título del sitio se muestra en la cabecera. Puede utilizar cualquier etiqueta para el título, en lugar de la etiqueta p que se añade por defecto cuando se escribe algo en este campo.';
$string['slider2h3bgcolor'] = 'Color de fondo H3 del estilo de presentación 2';
$string['slider2h3bgcolordesc'] = 'Establece el color de fondo de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h3color'] = 'Color del texto H3 del estilo de presentación 2';
$string['slider2h3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4bgcolor'] = 'Color de fondo H4 del estilo de presentación 2';
$string['slider2h4bgcolordesc'] = 'Establece el color de fondo de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slider2h4color'] = 'Color del texto H4 del estilo de presentación 2';
$string['slider2h4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 2.';
$string['slidercaption'] = 'Texto de la diapositiva';
$string['slidercaptiondesc'] = 'Añade un texto a la diapositiva.';
$string['slidercount'] = 'Número de dispositivas';
$string['slidercountdesc'] = 'Establece el número de diapositivas a mostrar en la página principal y <strong>haz clic en Guardar</strong> para introducir la información del resto de campos.';
$string['sliderenabled'] = 'Activar la presentación de diapositivas';
$string['sliderenableddesc'] = 'Activa la presentación de diapositivas en la página principal.';
$string['sliderfullscreen'] = 'Presentación de diapositivas en ancho completo';
$string['sliderfullscreendesc'] = 'Muestra la presentación de diapositivas en todo el ancho de la pantalla.';
$string['sliderh3color'] = 'Color del texto H3 del estilo de presentación 1';
$string['sliderh3colordesc'] = 'Establece el color del texto de la etiqueta H3 cuando se utiliza el estilo de presentación 1.';
$string['sliderh4color'] = 'Color del texto H4 del estilo de presentación 1';
$string['sliderh4colordesc'] = 'Establece el color del texto de la etiqueta H4 cuando se utiliza el estilo de presentación 1.';
$string['sliderimage'] = 'Imagen de la diapositiva';
$string['sliderimagedesc'] = 'Añade una imagen a la diapositiva.';
$string['slidermarginbottom'] = 'Margen inferior de la presentación de diapositivas';
$string['slidermarginbottomdesc'] = 'Establece el margen inferior de la presentación de diapositivas.';
$string['slidermargintop'] = 'Margen superior de la presentación de diapositivas';
$string['slidermargintopdesc'] = 'Establece el margen superior de la presentación de diapositivas.';
$string['slideroption2'] = 'Seleccionar tipo de presentación de diapositivas';
$string['slideroption2a'] = 'Color de fondo de las flechas de la presentación de diapositivas tipo 2';
$string['slideroption2adesc'] = 'Establece el color de fondo de las flechas de la presentación de diapositivas cuando se utiliza el estilo de presentación 2.';
$string['slideroption2color'] = 'Color de fondo de la presentación de diapositivas tipo 2';
$string['slideroption2colordesc'] = 'Establece el color de fondo de la diapositiva cuando se utiliza el estilo de presentación 2.';
$string['slideroption2desc'] = 'Seleccione el tipo de presentación de diapositivas <strong>y pulse Guardar</strong>para mostrar los colores del estilo seleccionado.';
$string['slideroption2submitcolor'] = 'Color de fondo del enlace del estilo de presentación 2';
$string['slideroption2submitcolordesc'] = 'Establece el color de fondo del texto del enlace cuando se utiliza el estilo de presentación 2.';
$string['sliderstyle1'] = 'Pase de diapositivas estilo 1';
$string['sliderstyle2'] = 'Pase de diapositivas estilo 2';
$string['slidersubmitbgcolor'] = 'Color del botón del estilo de presentación 1';
$string['slidersubmitbgcolordesc'] = 'Establece el color del botón cuando se utiliza el estilo de presentación 1.';
$string['slidersubmitcolor'] = 'Color del texto del botón del estilo de presentación 1';
$string['slidersubmitcolordesc'] = 'Establece el color del texto del botón cuando se utiliza el estilo de presentación 1.';
$string['sliderurl'] = 'URL de la diapositiva';
$string['sliderurldesc'] = 'Añade una URL a enlazar desde la diapositiva.';
$string['slideshowdesc'] = 'Sube imágenes, añade enlaces y descripciones en las dispositivas de la presentación de la página de inicio.';
$string['slideshowsettings'] = 'Presentación de diapositivas';
$string['slideshowsettingsheading'] = 'Personaliza la presentación de diapositivas de la página de inicio. Ver el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['slight'] = 'Leve';
$string['socialheading'] = 'Configuración de los iconos de redes sociales';
$string['socialicondesc'] = 'Selecciona el icono de Font Awesome. Por ejemplo: fa-facebook';
$string['socialiconlist'] = 'Lista de iconos sociales';
$string['socialiconlistdesc'] = 'Introducir una lista delimitada por comas para configurar los iconos de redes sociales que necesites usando el formato: url|titulo|icono';
$string['socialpaddingside'] = 'Ajustar el relleno para el lado lateral del icono social';
$string['socialpaddingsidedesc'] = 'Este será el espacio entre el icono y otro elemento o el espacio entre dos iconos. Es decir, el relleno en el icono será este valor dividido por dos. El valor predeterminado sigue las pautas de marca de Instagram.';
$string['socialpaddingtop'] = 'Ajustar la separación debajo los iconos sociales (altera la posición vertical)';
$string['socialpaddingtopdesc'] = 'Este será el mínimo de 15 px (establecido usando el margen) más este valor.';
$string['socialsearchicon'] = 'Buscar en Moodle';
$string['socialsearchicondesc'] = 'Muestra el cuadro de búsqueda al lado de los iconos sociales.';
$string['socialsettings'] = 'Redes sociales';
$string['socialsize'] = 'Configurar tamaño de los iconos sociales';
$string['socialsizedesc'] = 'Para una mejor vista, el tamaño debe ser 5px mayor que el tamaño real deseado.';
$string['socialtarget'] = 'Formato de apertura de la ventana de enlaces sociales';
$string['socialtargetdesc'] = 'Abrir la red social en la misma venta o en una nueva';
$string['socialtitledesc'] = '<pre>Puedes desactivar la búsqueda y activar los iconos de redes sociales en su lugar.
Para configurar los iconos, introduce una lista delimitada en el campo "Lista de iconos sociales".
El formato debe ser:

url|titulo|icono

Ejemplo:

http://localhost/moodle/course/search.php|Buscar en Moodle|fa-search
http://facebook.com/|Facebook|fa-facebook-square
http://twitter.com/|Twitter|fa-twitter-square
http://instagram.com|Instagram|fa-instagram
http://example.com|Mi Web|fa-globe

El listado de iconos se encuentra en: <a href="http://fortawesome.github.io/Font-Awesome/icons">http://fortawesome.github.io/Font-Awesome/icons</a>Font-Awesome</pre>';
$string['solid'] = 'Sólido';
$string['standard'] = 'Estándar';
$string['standardscreenwidth'] = 'Ancho de pantalla estándar.';
$string['standardscreenwidthdesc'] = 'Establece el ancho de la pantalla cuando se cambia a la vista "estándar" (ver también los ajustes relacionados enablezoom y defaultzoom).';
$string['standardview'] = 'Vista estándar';
$string['static'] = 'Estática';
$string['stickynavbar'] = 'Fijar la barra de navegación';
$string['stickynavbardesc'] = 'Fijar la barra de navegación a la parte superior de la página.';
$string['stylecover'] = 'Cubrir';
$string['stylestretch'] = 'Tramo';
$string['tabbedlayoutcoursepage'] = 'Página del curso Diseño tabulado';
$string['tabbedlayoutcoursepagedesc'] = 'Use un diseño con pestañas para la página del curso. Esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite adaptar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutcoursepagelink'] = 'Página del curso Diseño del archivo con fichas Enlace del curso';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Tenga un enlace de pestaña a la página del curso en las pestañas del curso.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Color de pestaña seleccionado para la página del curso';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Elija el color para la pestaña seleccionada actualmente.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Color de pestaña no seleccionado para la página del curso';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Elija el color para cualquier otra pestaña.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Página de inicio del curso Pestaña tiempo de persistencia';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'La pestaña de la página de inicio del curso persiste en la pestaña seleccionada cuando se actualiza durante un período de inactividad. Establecew el período de inactividad aquí. Por ejemplo, configure en 30 para que la primera pestaña se seleccione después de 30 minutos de inactividad';
$string['tabbedlayoutdashboard'] = 'Diseño de pestañas de la página del Panel';
$string['tabbedlayoutdashboarddesc'] = 'Use un diseño con pestañas para la página Panel. Esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite adaptar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutdashboardtab1condition'] = 'Pestaña 1 Restricción de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Agregue una regla de acceso para mostrar la pestaña 1 usando un campo de perfil personalizado, por ejemplo: showtab1 = true';
$string['tabbedlayoutdashboardtab2condition'] = 'Pestaña 2 Restricción de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Agregue una regla de acceso para mostrar la Pestaña 2 usando un campo de perfil personalizado, por ejemplo: showtab2 = true';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Color de pestaña seleccionado para el Panel';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Elija el color para la pestaña seleccionada actualmente.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Color de pestaña no seleccionado para el Panel';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Elija el color para cualquier otra pestaña.';
$string['tabbedlayoutheading'] = 'Diseño con pestañas adaptable';
$string['tabbedlayouttablabelcourse'] = 'Contenido del curso';
$string['tabbedlayouttablabelcourse1'] = 'Pestaña 1';
$string['tabbedlayouttablabelcourse2'] = 'Pestaña 2';
$string['tabbedlayouttablabeldashboard'] = 'Contenido del Panel';
$string['tabbedlayouttablabeldashboard1'] = 'Pestaña 1';
$string['tabbedlayouttablabeldashboard2'] = 'Pestaña 2';
$string['targetnewwindow'] = 'Nueva ventana';
$string['targetsamewindow'] = 'Misma ventana';
$string['templatesheading'] = 'Configuración de plantillas';
$string['templatesheadingdesc'] = 'Anular plantillas';
$string['templatessel'] = 'Plantillas para anular';
$string['templatesseldesc'] = 'Seleccione las plantillas para anular, luego cada una se mostrará en su propia página. Si no se selecciona aquí, la plantilla no se anulará incluso si está habilitada. Para seleccionar ninguno, use la tecla \'Ctrl\'.';
$string['templatessettings'] = 'Plantillas';
$string['themechanges'] = 'Cambios';
$string['themereadme'] = 'Léame';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Anuncios';
$string['tickerdefault'] = 'No hay anuncios para mostrar';
$string['tickerdesc'] = 'Aquí puedes configurar los anuncios de la página de inicio de tu moodle.
    Solo debes introducir una lista tipo HTML e incluir enlaces.
    Nota: No debes añadir etiquetas ul en la lista, solo li. Los editores de Moodle tienden a añadir etiquetas ul en las listas.
    Si no funciona correctamente, cambia a modo HTML y comprueba que solo hay etiquetas li:
    <pre>
    &lt;li&gt;Anuncio 1.....&lt;/li&gt;
    &lt;li&gt;Anuncio 2.....&lt;/li&gt;
    </pre>
    <br>
    Puedes controlar diferentes secciones de anuncios dependiendo de un campo de perfil de usuario personalizado y así mostrar diferentes anuncios a diferentes perfiles.';
$string['tickerfullscreen'] = 'Ancho de pantalla completa';
$string['tickersettings'] = 'Anuncios';
$string['tickersettingsheading'] = 'Configura los anuncios de la página de inicio. Ver posición <a href="./adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['tickertext'] = 'Texto de la barra de anuncios';
$string['tickertextdesc'] = 'Añade el texto a mostrar en la barra de anuncios en formato de lista. Ver el archivo <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertextprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['tickertextprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=alumno"';
$string['tickerwidth'] = 'Ancho de la barra de anuncios';
$string['tickerwidthdesc'] = 'Usa este valor para cambiar el ancho de la barra de anuncios al 100%.';
$string['tilesbordercolor'] = 'Color del borde de los bloques de cursos';
$string['tilesbordercolordesc'] = 'establece el color del borde de los bloques de cursos.';
$string['tilescontactstitle'] = 'Mostrar el rol de los contactos del curso';
$string['tilescontactstitledesc'] = 'Muestra / Oculta el rol del contacto en el curso. Si no se muestra, se mostrará una imagen para cada contacto.';
$string['tilesshowallcontacts'] = 'Mostrar todos los contactos del curso';
$string['tilesshowallcontactsdesc'] = 'Muestra todos los contactos del curso o solo el principal.';
$string['tilesshowcontacts'] = 'Mostrar los contactos del curso';
$string['tilesshowcontactsdesc'] = 'Muestra / Oculta los contactos del curso.';
$string['togglenavigation'] = 'Alternar modo de navegación';
$string['toolsmenu'] = 'Menú de herramientas desplegable';
$string['toolsmenudesc'] = 'Añade un menú desplegable en la barra de navegación.';
$string['toolsmenufield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['toolsmenufielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: usertype=student';
$string['toolsmenuheading'] = 'Menús herramientas (en la barra de navegación)';
$string['toolsmenuheadingdesc'] = 'Puedes configurar los enlaces a mostrar en el menú de herramientas (en la barra de navegación).
 este formato es similar al usado por los menús personalizados de moodle pero permite añadir los iconos Font Awesome:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenuscount'] = 'Número de menús de herramientas';
$string['toolsmenuscountdesc'] = 'Establece el número de menús de herramientas que quieres a la barra de navegación.';
$string['toolsmenutitle'] = 'Título menú de herramientas';
$string['toolsmenutitledefault'] = 'Herramientas';
$string['toolsmenutitledesc'] = 'Añade el título a mostrar en la barra de navegación.';
$string['topicsweeks'] = 'Formato de curso Temas/Semanas';
$string['topicsweeksdesc'] = 'Establecer estilos para el formato de curso Temas/Semanas';
$string['topmenufontsize'] = 'Tamaño fuente menú superior';
$string['topmenufontsizedesc'] = 'Establece el tamaño de la fuente usada en el menú superior.';
$string['topmenuscount'] = 'Número de menús superiores';
$string['topmenuscountdesc'] = 'Establece el número de menús superiores que quieres añadir en la cabecera.';
$string['turngradereditingoff'] = 'Desactivar editor de calificaciones';
$string['turngradereditingon'] = 'Activar editor de calificaciones';
$string['usermenu'] = 'Menú del Usuario';
$string['usernameposition'] = 'Posición del nombre de usuario';
$string['usernamepositiondesc'] = 'Establezca la posición del nombre de usuario, \'Izquierda\' o \'Derecha\'';
$string['usernav'] = 'Barra de usuario';
$string['usernavdesc'] = 'Permite personalizar los elementos que aparecen en el desplegable de navegación del usuario.';
$string['usernavheading'] = 'Personalizar el menu de usuario';
$string['usernodescription'] = 'El usuario aún no ha actualizado su descripción.';
$string['usernointerests'] = 'El usuario aún no ha actualizado sus intereses.';
$string['usersettings'] = 'Perfil del usuario';
$string['usersettingsdesc'] = 'Establecer ajustes para el perfil del usuario.';
$string['usersettingsheading'] = 'Controlar aspectos del perfil del usuario';
$string['versionalpha'] = 'Versión alfa - Casi seguramente contiene errores. ¡ Esta es una versión en desarrollo \'solamente\' para desarrolladores ! ¡ Ni siquiera se le vaya a ocurrir instalarla en un servidor en producción !';
$string['versionbeta'] = 'Versión beta - Probablemente contiene errores. Está lista para probarse por administradores solamente en un servidor de pruebas.';
$string['versioninfo'] = 'Liberación {$a->release}, versión {$a->version} en Moodle {$a->moodle}';
$string['versionrc'] = 'Versión de candidato a liberación . Podría contener errores. Comprobarla completamente en un servidor de prueba antes de considerarla para un servidor en producción.';
$string['versionstable'] = 'Versión estable . Podría contener errores. Comprobar en un servidor de prueba antes de instalarla en su servidor en producción.';
$string['wide'] = 'Pantalla completa';
