<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'sr_lt', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API krajnja tačka';
$string['action:explain_text:model'] = 'AI model';
$string['action:explain_text:model_help'] = 'Model koji se koristi za objašnjenje datog teksta.';
$string['action:explain_text:systeminstruction'] = 'Sistemsko uputstvo';
$string['action:explain_text:systeminstruction_help'] = 'Ovo uputstvo se šalje AI modelu zajedno sa upitom korisnika. Uređivanje ovog uputstva se ne preporučuje osim ako to nije apsolutno neophodno.';
$string['action:generate_image:endpoint'] = 'API krajnja tačka';
$string['action:generate_image:model'] = 'AI model';
$string['action:generate_image:model_desc'] = 'Model koji se koristi za generisanje slika na osnovu korisničkih upita.';
$string['action:generate_image:model_help'] = 'Model koji se koristi za generisanje slika iz korisničkih upita.';
$string['action:generate_text:endpoint'] = 'API krajnja tačka';
$string['action:generate_text:model'] = 'AI model';
$string['action:generate_text:model_desc'] = 'Model koji se koristi za generisanje tekstualnog odgovora.';
$string['action:generate_text:model_help'] = 'Model koji se koristi za generisanje tekstualnog odgovora.';
$string['action:generate_text:systeminstruction'] = 'Sistemsko uputstvo';
$string['action:generate_text:systeminstruction_desc'] = 'Ovo uputstvo se šalje AI modelu zajedno sa upitom korisnika. Uređivanje ovog uputstva se ne preporučuje osim ako je apsolutno neophodno.';
$string['action:generate_text:systeminstruction_help'] = 'Ovo uputstvo se šalje AI modelu zajedno sa upitom korisnika. Uređivanje ovog uputstva se ne preporučuje osim ako to nije apsolutno neophodno.';
$string['action:summarise_text:endpoint'] = 'API krajnja tačka';
$string['action:summarise_text:model'] = 'AI model';
$string['action:summarise_text:model_desc'] = 'Model koji se koristi za rezimiranje datog teksta.';
$string['action:summarise_text:model_help'] = 'Model koji se koristi za sumiranje datog teksta.';
$string['action:summarise_text:systeminstruction'] = 'Sistemsko uputstvo';
$string['action:summarise_text:systeminstruction_desc'] = 'Ovo uputstvo se šalje AI modelu zajedno sa upitom korisnika. Uređivanje ovog uputstva se ne preporučuje osim ako je apsolutno neophodno.';
$string['action:summarise_text:systeminstruction_help'] = 'Ovo uputstvo se šalje AI modelu zajedno sa upitom korisnika. Uređivanje ovog uputstva se ne preporučuje osim ako to nije apsolutno neophodno.';
$string['apikey'] = 'OpenAI API ključ';
$string['apikey_desc'] = 'Preuzmite ključ sa <a href="https://platform.openai.com/account/api-keys">OpenAI platforme API ključeva</a>.';
$string['apikey_help'] = 'Preuzmite svoj ključ iz svojih <a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI API ključeva</a>.';
$string['custom_model_name'] = 'Naziv prilagođenog modela';
$string['enableglobalratelimit'] = 'Podesite ograničenje korišćenja AI servisa na nivou sajta';
$string['enableglobalratelimit_desc'] = 'Ograničite broj zahteva koje OpenAI API provajder može da prima na celom sajtu svakog sata.';
$string['enableuserratelimit'] = 'Podesite ograničenje korišćenja od strane pojedinačnog korisnika';
$string['enableuserratelimit_desc'] = 'Ograničite broj zahteva koje svaki korisnik može uputi svakog sata OpenAI API provajderu.';
$string['extraparams'] = 'Dodatni parametri';
$string['extraparams_help'] = 'Ovde se mogu konfigurisati dodatni parametri. Podržavamo JSON format. Na primer:
<pre>
{
    "temperature": 0.5,
    "max_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Maksimalan broj zahteva na nivou sajta';
$string['globalratelimit_desc'] = 'Broj dozvoljenih zahteva na nivou sajta po satu.';
$string['invalidjson'] = 'NMeispravan JSON string';
$string['orgid'] = 'ID oznaka OpenAI organizacije';
$string['orgid_desc'] = 'Preuzmite ID oznaku OpenAI organizacije sa svog <a href="https://platform.openai.com/account/org-settings">OpenAI naloga</a>';
$string['orgid_help'] = 'Preuzmite ID oznaku svoje OpenAI organizacije sa vašeg <a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI naloga </a>.';
$string['pluginname'] = 'OpenAI API provajder';
$string['privacy:metadata'] = 'Dodatak za provajdera OpenAI API ne čuva nikakve lične podatke.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Ove informacije se šalju OpenAI API-ju kako bi se generisao odgovor. Podešavanja vašeg OpenAI naloga mogu da promene način na koji OpenAI pohranjuje i čuva ove podatke. Ovaj dodatak ne šalje eksplicitno korisničke podatke u OpenAI niti ih čuva u Moodle LMS-u.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Model koji se koristi za generisanje odgovora.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Broj slika korišćenih u odgovoru, prilikom generisanja slika.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Tekstualni upit unet od strane korisnika koji se koristi za generisanje odgovora.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Format odgovora, prilikom generisanja slika.';
$string['settings'] = 'Podešavanja';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Kazna za učestalost određuje koliko često se reči ponavljaju. Što je kazna veća, to se reči u generisanom tekstu ređe ponavljaju.';
$string['settings_help'] = 'Možete da prilagodite dolenavedena podešavanja kako biste prilagodili način na koji se zahtevi šalju u OpenAI servisu.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Maksimalan broj tokena koji se generiše u odgovoru';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Kazna za prisustvo podstiče model da koristi nove reči povećavajući verovatnoću da izabere reči koje ranije nije koristio. Veća vrednost čini generisani tekst raznovrsnijim, dok niža vrednost omogućava više ponavljanja.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (”uzorkovanje nukleusa”) određuje koliko mogućih reči treba uzeti u obzir. Visoka vrednost (npr. 0.9) znači da model razmatra više reči, što generisani tekst čini raznovrsnijim.';
$string['userratelimit'] = 'Maksimalan broj zahteva po korisniku';
$string['userratelimit_desc'] = 'Broj dozvoljenih zahteva po satu, po jednom korisniku.';
