<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sr_lt', version '5.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Akcije';
$string['activate'] = 'Omogući pristup';
$string['activatesuccess'] = 'Pristup bedžu \'{$a}\' je uspešno omogućen';
$string['addalignment'] = 'Dodaj eksternu veštinu ili standard';
$string['addbadge'] = 'Dodaj bedževe';
$string['addbadge_help'] = 'Izaberite sve bedževe koje treba dodati kao uslov za dobijanje ovog bedža. Držite CTRL taster kako biste izabrali više stavki.';
$string['addbadgecriteria'] = 'Dodaj kriterijum za bedž';
$string['addcohort'] = 'Dodaj kohortu';
$string['addcohort_help'] = 'Izaberite sve kohorte koje treba dodati kao uslov za dobijanje ovog bedža. Držite CTRL taster kako biste izabrali više stavki.';
$string['addcompetency'] = 'Dodaj kompetenciju';
$string['addcompetency_help'] = 'Izaberite sve kompetencije koje treba dodati kao uslov za dobijanje ovog bedža. Držite CTRL taster kako biste izabrali više stavki.';
$string['addcourse'] = 'Dodaj kurseve';
$string['addcourse_help'] = 'Izaberite sve kurseve koji treba dodati u uslove za dobijanje ovog bedža. Držite taster CTRL da biste odabrali više kurseva.';
$string['addcriteria'] = 'Dodaj kriterijum';
$string['addcriteriatext'] = 'Da biste započeli dodavanje kriterijuma izaberite jednu od opcija iz padajućeg menija.';
$string['addcriterion'] = 'Dodaj kriterijum';
$string['addedtobackpack'] = 'Bedž dodat u album';
$string['addrelated'] = 'Dodajte povezani bedž';
$string['addtobackpack'] = 'Dodaj u album';
$string['adminonly'] = 'Ova stranica je ograničena samo na administratore sajta.';
$string['after'] = 'nakon datuma izdavanja.';
$string['aggregationmethod'] = 'Metod sumiranja';
$string['alignment'] = 'Poravnanje';
$string['all'] = 'Svi';
$string['allmethod'] = 'Svi izabrani uslovi si ispunjeni';
$string['allmethodactivity'] = 'Sve izabrane aktivnosti se završe';
$string['allmethodbadges'] = 'Svi izabrani bedževi su osvojeni';
$string['allmethodcohort'] = 'Članstvo u svim izabranim kohortama';
$string['allmethodcompetencies'] = 'Sve izabrane kompetencije su završene';
$string['allmethodcourseset'] = 'Svi izabrani kursevi su završeni';
$string['allmethodmanual'] = 'Sve izabrane uloge dodele bedž';
$string['allmethodprofile'] = 'Sva izabrana polja profila su kompletirana';
$string['allowcoursebadges'] = 'Omogući bedževe na kursu';
$string['allowcoursebadges_desc'] = 'Dozvolite da se bedževi kreiraju i dodeljuju u kontekstu kursa.';
$string['allowexternalbackpack'] = 'Veza sa eksternim albumima';
$string['allowexternalbackpack_desc'] = 'Ako je ova opcija omogućena, korisnici mogu da se povežu sa eksternim albumom i podele/prikažu svoje bedževa sa ovog sajta. Korisnici takođe mogu izabrati da na stranici svog profila, na ovom sajtu, prikažu bilo koju javnu kolekciju bedževa iz svojih eksternih albuma. Preporučuje se da ostavite ovu opciju onemogućenu ako vašem sajtu nije moguće pristupiti sa interneta.';
$string['any'] = 'Bilo koja/e/i/u';
$string['anymethod'] = 'Bilo koji od izabranih uslova je ispunjen';
$string['anymethodactivity'] = 'Bilo koja od izabranih aktivnosti se završi';
$string['anymethodbadges'] = 'Bilo koji od izabranih bedževa je osvojen';
$string['anymethodcohort'] = 'Članstvo u bilo kojoj od izabranih kohorti';
$string['anymethodcompetencies'] = 'Bilo koja od izabranih kompetencija je završena';
$string['anymethodcourseset'] = 'Bilo koji od izabranih kurseva je završen';
$string['anymethodmanual'] = 'Bilo koja od izabranih uloga dodeli bedž';
$string['anymethodprofile'] = 'Bilo koje od izabranih polja profila je popunjeno.';
$string['apiversion'] = 'API verzija je podržana';
$string['archivebadge'] = 'Da li želite da obrišete bedž \'{$a}\', a da pri tome zadržite sve postojeće, do sada izdate, bedževe?';
$string['archiveconfirm'] = 'Obriši i zadrži postojeće, do sada izdate bedževe';
$string['archivehelp'] = '<p>Ova opcija znači da će bedž biti označen kao "povučen" i da se više neće pojavljivati na spisku bedževa. Korisnici više neće moći da osvoje ovaj bedž, ali će svi oni koji su ga već dobili moći da prikazuju bedž na svojoj stranici profila, kao i da ga prebace u svoje eksterne albume bedževa. </p>
<p>Ukoliko želite da vaši korisnici zadrže pristup osvojenim bedževima važno je da izaberete ovu opciju umesto potpunog brisanja bedževa</p>';
$string['attachment'] = 'Priloži bedž uz poruku';
$string['attachment_help'] = 'Ako je ova opcija omogućena, izdati bedž biće priložen uz e-poruku dobitniku, kako bi on mogao da je preuzme. Da biste mogli da koristite ovu opciju, dodavanje datoteka uz e-poruke mora biti omogućeno u podešavanjima sajta – Administracija sajta / Server / E-pošta / Konfiguracija odlazne pošte.';
$string['award'] = 'Dodeli bedž';
$string['awardedto'] = 'Dodeljeno korisniku  {$a}';
$string['awardedtoyou'] = 'Bedževi izdati meni';
$string['awardoncron'] = 'Velikom broju korisnika je dodeljen bedž \'{$a->badgename}\'. Biće potrebno neko vreme da svi korisnici dobiju ovaj bedž.';
$string['awards'] = 'Dobitnici bedža';
$string['backpackapiurl'] = 'URL adresa API-ja za album bedževa';
$string['backpackavailability'] = 'Eksterna provera bedža';
$string['backpackavailability_help'] = 'Kako bi dobitnici bedževa mogli da dokažu da su svoje bedževe dobili od vas, potrebno je da eksterni album ima mogućnost pristupa vašem sajtu i proveri bedževa koje ste izdali. Izgleda da vaš sajt trenutno nije dostupan, što znači da bedževi koje ste već izdali ili će tek biti izdati, ne mogu biti provereni.

**Zašto vidim ovu poruku?**

Postoji mogućnost da vaš zaštitni zid sprečava pristup korisnicima izvan vaše mreže, da je vaš sajt zaštićen lozinkom, ili da se sajt nalazi na računaru koji nije dostupan na internetu (kao što su lokalni računari koji služe za testiranje i razvoj).

**Da li ovo predstavlja problem?**

Ovaj problem treba rešiti na svakom produkcionom serveru/sajtu na kojem se planira izdavanje bedževa, inače dobitnici neće moći da dokažu da su dobili svoje bedževe od vas. Ako vaš sajt još nije aktivan, možete da kreirate i izdate probne bedževe dok je sajt dostupan, a pre nego što ga stavite u funkciju.

**Šta ako ne mogu čitav svoj sajt da učinim javno dostupnim?**

Jedina URL adresa koja je neophodna za proveru je [url-vašeg-sajta]/badges/assertion.php, tako da, ukoliko ste u mogućnosti da promenite podešavanja vašeg zaštitnog zida i omogućite pristup ovoj datoteci, provera bedževa će i dalje funkcionisati bez problema.';
$string['backpackbadgessettings'] = 'Promenite podešavanja albuma';
$string['backpackbadgessummary'] = 'Imate {$a->totalbadges} bedž(ev)a iz {$a->totalcollections} kolekcije/a.';
$string['backpackcannotsendverification'] = 'Nije moguće poslati e-poruku za potvrdu';
$string['backpackconnected'] = 'Uspostavljena je veza sa albumom';
$string['backpackconnection'] = 'Povežite se sa albumom';
$string['backpackconnection_connected'] = 'Vaš album sa bedževima';
$string['backpackconnection_help'] = 'Sačuvajte i podelite svoje bedževe sa ovog sajta i prikažite javne bedževe sa drugih veb sajtova na svom korisničkom profilu.';
$string['backpackconnectioncancelattempt'] = 'Poveži se pomoću druge e-adrese';
$string['backpackconnectionconnect'] = 'Poveži se sa albumom';
$string['backpackconnectionnottested'] = 'Veza se ne može testirati za ovaj album, pošto ga podržavaju samo Open Badges v2.0 albumi.';
$string['backpackconnectionok'] = 'Veza sa albumom je uspešno uspostavljena';
$string['backpackconnectionresendemail'] = 'Pošalji ponovo e-poruku za potvrdu';
$string['backpackconnectionunexpectedmessage'] = 'Album je vratio grešku: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Došlo je do problema prilikom povezivanja sa albumom. Vaš provajder albuma bedževa šalje ovu poruku: \'{$a}\'.';
$string['backpackdetails'] = 'Podešavanja albuma bedževa';
$string['backpackdisconnected'] = 'Veza sa albumom je prekinuta';
$string['backpackemail_required'] = 'Polje za adresu e-pošte ne može biti prazno';
$string['backpackemailverificationpending'] = 'Potvrda na čekanju';
$string['backpackemailverifyemailbody'] = 'Poštovana/i {$a->userfirstname},

Skoro ste završili sa povezivanjem sa svojim albumom sa bedževima na \'{$ a->sitename}\'.

Da biste završili povezivanje sa albumom, potvrdite svoju adresu e-pošte pomoću sledećeg dugmeta:

{$a->buttonlink}

Ako dugme ne radi, možete da prekopirate sledeću URL adresu u svoj veb čitač:
{$a->link}

Ako niste pokušali da se povežete sa svojim albumom sa bedževima, možete bezbedno da ignorišete ovu poruku e-pošte.

Za bilo kakvu dodatnu pomoć, molimo vas da se kontaktirate podršku za vaš veb sajt,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Album bedževa - potvrda e-adrese';
$string['backpackemailverifypending'] = 'Poslali smo e-poruku na <strong>{$a}</strong>. Kliknite na link za potvrdu u e-poruci kako biste aktivirali vezu sa svojim albumom bedževa.';
$string['backpackemailverifysuccess'] = 'Sada ste povezani sa svojim albumom bedževa.';
$string['backpackemailverifytokenmismatch'] = 'Token u linku na koji ste kliknuli se ne poklapa sa sačuvanim tokenom. Proverite da li ste kliknuli na link koji se nalazi u najnovijoj poruci koju ste dobili.';
$string['backpackexporterror'] = 'Nije moguće eksportovati bedž u album';
$string['backpackexporterrorwithinfo'] = 'Nije moguće eksportovati bedž "{$a->badgename}" u album. Greška: {$a->error}';
$string['backpackimport'] = 'Podešavanja za uvoz bedževa';
$string['backpackimport_help'] = 'Nakon što se veza sa albumom bedževa uspešno uspostavi, bedževi iz vašeg albuma mogu da se prikažu na vašoj stranici sa bedževima, kao i na stranici vašeg profila.

Ovde možete da izaberete kolekcije bedževa iz svog albuma koje želite da prikažete u svom profilu.';
$string['backpackprovider'] = 'Provajder albuma';
$string['backpacksettings'] = 'Podešavanja albuma';
$string['backpackweburl'] = 'URL adresa albuma';
$string['badgedetails'] = 'Podaci o bedžu';
$string['badgeimage'] = 'Slika';
$string['badgeimage_help'] = 'Veličina slike treba da bude najmanje 300 x 300 piksela. Biće prikazan kao 300 x 300 piksela na stranici sa bedžom i 100 x 100 piksela na stranici korisničkog profila.';
$string['badgeimageinfo'] = 'Za najbolje rezultate, postavite sliku u obliku kvadrata, minimalne veličine 300 x 300 piksela.';
$string['badgeissued'] = 'Bedž izdat';
$string['badgeprivacysetting'] = 'Podešavanja privatnosti bedževa';
$string['badgeprivacysetting_help'] = 'Bedževi koje ste osvojili mogu biti prikazani na vašoj stranici profila. Ovo podešavanje vam omogućava da podesite vidljivost novoosvojenih bedževa.

Podešavanja privatnosti pojedinačnih bedževa i dalje možete da kontrolišete na svojoj stranici sa bedževima';
$string['badgeprivacysetting_str'] = 'Automatski prikaži bedževe koje sam osvojio/la na stranici mog profila';
$string['badges'] = 'Bedževi';
$string['badgesalt'] = 'Nasumični string (salt) za heširanje e-adresa dobitnika bedževa';
$string['badgesalt_desc'] = 'Korišćenje heš fukncije omogućava albumima da potvrde nosioce bedževa bez otkrivanja njihovih e-adresa. Ovo podešavanje treba da koristi samo brojeve i slova.

Napomena: Radi uspešne provere primalaca molimo izbegavajte izmene ovog podešavanja jednom kad ste počeli sa izdavanjem bedževa.';
$string['badgesdisabled'] = 'Bedževi nisu omogućeni na ovom sajtu';
$string['badgesearned'] = 'Broj osvojenih bedževa: {$a}';
$string['badgesettings'] = 'Podešavanja bedževa';
$string['badgestatus_0'] = 'Nije dostupan';
$string['badgestatus_1'] = 'Dostupan';
$string['badgestatus_2'] = 'Nije dostupan (kriterijumi zaključani)';
$string['badgestatus_3'] = 'Dostupan (kriterijumi zaključani)';
$string['badgestatus_4'] = 'Arhiviran';
$string['badgestoearn'] = 'Broj dostupnih bedževa: {$a}';
$string['badgesview'] = 'Bedževi kursa';
$string['badgetags'] = 'Oznake bedža';
$string['badgeurl'] = 'Link za izdati bedž';
$string['balignment'] = 'Poravnanja ({$a})';
$string['bawards'] = 'Dobitnici ({$a})';
$string['bcriteria'] = 'Kriterijum';
$string['bdetails'] = 'Uredi podatke';
$string['bendorsement'] = 'Potvrda';
$string['bmessage'] = 'Poruka';
$string['boverview'] = 'Pregled';
$string['brelated'] = 'Povezani bedževi ({$a})';
$string['bydate'] = 'završiti do';
$string['claim'] = 'Zahtev';
$string['claimcomment'] = 'Komentar potvrde';
$string['claimid'] = 'URL adresa zahteva';
$string['clearsettings'] = 'Ukloni podešavanja';
$string['completioninfo'] = 'Ovaj bedž je izdat za završetak:';
$string['completionnotenabled'] = 'Praćenje završetka nije omogućen za ovaj kurs, tako da on ne može biti uključen u kriterijume za dobijanje bedža.Praćenje završetka kursa može se omogućiti u podešavanjima kursa.';
$string['configenablebadges'] = 'Ako je omogućeno, ova funkcija vam daje mogućnost da kreirate bedževe i da ih dodeljujete korisnicima sajta.';
$string['configuremessage'] = 'Poruka o bedžu';
$string['connect'] = 'Uspostavi vezu';
$string['connected'] = 'Veza uspostavljena';
$string['connecting'] = 'Povezivanje ...';
$string['contact'] = 'E-adresa izdavača bedža';
$string['contact_help'] = 'E-adresa izdavača bedža.';
$string['copy'] = 'Kopiraj';
$string['copyof'] = 'Kopija {$a}';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Bedževi';
$string['coursebadgesdisabled'] = 'Bedževi kursa nisu omogućeni na ovom sajtu.';
$string['coursebadgetitle'] = 'Bedž kursa {$a}';
$string['coursecompletion'] = 'Polaznici moraju da završe ovaj kurs.';
$string['create'] = 'Novi bedž';
$string['createbutton'] = 'Kreiraj bedž';
$string['creatorbody'] = '<p>{$a->user} je ispunio/la sve uslove i osvojio/la je bedž. Pogledajte izdati bedž na {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' je nagrađen/a!';
$string['criteria_0'] = 'Ovaj bedž se dodeljuje kada...';
$string['criteria_1'] = 'Završetak aktivnosti';
$string['criteria_1_help'] = 'Omogućava da bedž bude dodeljen korisnicima na osnovu završetka skupa aktivnosti u okviru kursa.';
$string['criteria_2'] = 'Ručno izdavanja od strane uloge';
$string['criteria_2_help'] = 'Omogućava da bedž bude ručno dodeljen korisnicima od strane korisnika sa odgovarajućom ulogom u okviru sajta ili kursa.';
$string['criteria_3'] = 'Društveno učešće';
$string['criteria_3_help'] = 'Društveno';
$string['criteria_4'] = 'Završetak kursa';
$string['criteria_4_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su završili kurs. Ovaj kriterijum može imati dodatne parametre, kao što su minimalna ocena i datum završetka kursa.';
$string['criteria_5'] = 'Završetak skupa kurseva';
$string['criteria_5_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su završili skup kurseva. Svaki kurs može imati dodatne parametre, kao što su minimalna ocena i datum završetka kursa.';
$string['criteria_6'] = 'Popunjavanje profila';
$string['criteria_6_help'] = 'Omogućava da bedž bude dodeljen korisnicima koji su popunili određena polja u svom profilu. Možete da izaberete standardna i prilagođena polja profila koja su dostupna korisnicima.';
$string['criteria_7'] = 'Dodeljeni bedževi';
$string['criteria_7_help'] = 'Omogućava da bedž bude dodeljen korisnicima na osnovu drugih bedževa koje su osvojili.';
$string['criteria_8'] = 'Članstvo u kohorti';
$string['criteria_8_help'] = 'Omogućava da bedž bude dodeljen korisnicima na osnovu članstva u kohorti.';
$string['criteria_9'] = 'Kompetencije';
$string['criteria_9_help'] = 'Omogućava dodeljivanje bedža korisnicima na osnovu kompetencija koje su završili.';
$string['criteria_descr'] = 'Korisnicima se ovaj bedž dodeljuje kada ispune sledeći uslov:';
$string['criteria_descr_0'] = 'Ispunite <strong>{$a}</strong> od navedenih uslova.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> od sledećih aktivnosti je završena:';
$string['criteria_descr_2'] = 'Ovaj bedž mora da bude dodeljen od strane korisnika koji ima <strong>{$a}</strong> od sledećih uloga:';
$string['criteria_descr_4'] = 'Polaznici moraju da završe kurs';
$string['criteria_descr_5'] = '<strong>{$a}</strong> od sledećih kurseva mora da bude završen:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> od sledećih polja korisničkog profila mora da budu popunjena:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> od sledećih bedževa mora biti osvojen:';
$string['criteria_descr_8'] = 'Potrebno je članstvo u <strong>{$a}</strong> od sledećih kohorti:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> od sledećih kompetencija mora(ju) biti završena/e/o:';
$string['criteria_descr_bydate'] = 'do <em>{$a}</em>';
$string['criteria_descr_grade'] = 'sa minimalnom ocenom <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short1'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short2'] = 'Bedž je dodelio <strong>{$a}</strong> od:';
$string['criteria_descr_short4'] = 'Završiti kurs';
$string['criteria_descr_short5'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short6'] = 'Završi <strong>{$a}</strong> od:';
$string['criteria_descr_short7'] = 'Završite <strong>{$a}</strong> od:';
$string['criteria_descr_short8'] = 'Članstvo u kohorti u <strong>{$a}</strong> od:';
$string['criteria_descr_short9'] = 'Završene <strong>{$a}</strong> od:';
$string['criteria_descr_single_1'] = 'Sledeća aktivnost mora biti završena:';
$string['criteria_descr_single_2'] = 'Ovaj bedž mora da dodeli korisnik sa sledećom ulogom:';
$string['criteria_descr_single_4'] = 'Polaznici moraju da završe kurs';
$string['criteria_descr_single_5'] = 'Sledeći kurs mora da bude završen:';
$string['criteria_descr_single_6'] = 'Sledeće polje korisničkog profila mora da bude popunjeno:';
$string['criteria_descr_single_7'] = 'Sledeći bedž mora biti osvojen:';
$string['criteria_descr_single_8'] = 'Potrebno je članstvo u sledećoj kohorti:';
$string['criteria_descr_single_9'] = 'Sledeće kompetencije moraju biti završene:';
$string['criteria_descr_single_short1'] = 'Završiti:';
$string['criteria_descr_single_short2'] = 'Dodelio/la:';
$string['criteria_descr_single_short4'] = 'Završiti kurs';
$string['criteria_descr_single_short5'] = 'Završiti:';
$string['criteria_descr_single_short6'] = 'Završiti:';
$string['criteria_descr_single_short7'] = 'Završeno:';
$string['criteria_descr_single_short8'] = 'Članstvo u:';
$string['criteria_descr_single_short9'] = 'Završene:';
$string['criteriacreated'] = 'Kriterijumi za bedž uspešno su kreirani';
$string['criteriadeleted'] = 'Kriterijumi za bedž uspešno su obrisani';
$string['criteriasummary'] = 'Rezime kriterijuma';
$string['criteriaupdated'] = 'Kriterijumi za bedž uspešno su ažurirani';
$string['criterror'] = 'Trenutni parametri za izdavanje bedža';
$string['criterror_help'] = 'Ovaj skup polja prikazuje sve parametre koji su inicajlno dodati među uslove za ovaj bedž. Preporučuje se da isključite takve parametre kako bi osigurali da polaznici mogu u budućnosti da dobiju ovaj bedž.';
$string['currentimage'] = 'Trenutna slika';
$string['currentstatus'] = 'Trenutni status:';
$string['dateawarded'] = 'Datum izdavanja';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dan(i)';
$string['deactivate'] = 'Onemogući pristup';
$string['deactivatesuccess'] = 'Pristup bedžu \'{$a}\' je uspešno onemogućen.';
$string['defaultissuercontact'] = 'E-adresa izdavača bedža';
$string['defaultissuercontact_desc'] = 'Adresa e-pošte povezana sa izdavačem bedža. Za Open Badges v2.0 album, ovo se koristi za proveru identiteta prilikom objavljivanja bedža u albumu.';
$string['defaultissuername'] = 'Ime/naziv izdavača bedža';
$string['defaultissuername_desc'] = 'Ime osobe nadležne za izdavanje bedževa.';
$string['defaultissuerpassword'] = 'Lozinka izdavača bedža';
$string['defaultissuerpassword_help'] = 'Potreban je nalog na veb sajtu albuma sa e-adresom koja je navedena u podešavanju "E-adresa izdavača bedža", koje se nalazi na stranici Administracija sajta / Bedževi / Podešavanja bedževa. Ovde treba uneti lozinku za nalog.';
$string['delbadge'] = 'Da li želite da obrišete bedž \'{$a}\' i uklonite sve postojeće, do sada izdate, bedževe?';
$string['delconfirm'] = 'Obriši i ukloni postojeće, do sada izdate bedževe';
$string['delcritconfirm'] = 'Da li ste sigurni da želite da obrišete ovaj kriterijum?';
$string['deletehelp'] = '<p>Potpuno brisanje bedževa znači da će svi podaci o bedžu kao i kriterijumi za njegovo dobijanje biti trajno uklonjeni. Korisnici koji su osvojili ovaj bedž više neće moći da mu pristupaju, niti da ga prikazuju na svojim stranicama profila.</p>
<p>Napomena: korisnici koji su već osvojili ovaj bedž i prebacili ga u svoje eksterne albume bedževa i dalje ga imati u tim albumima. Međutim, oni više neće moći da pristupe kriterijumima za osvajanje bedža niti stranicama  na ovom sajtu sa kojima je bedž u eksternom albumu povezan. </p>';
$string['delexternalbackpack'] = 'Izbriši sajt sa albumom';
$string['delexternalbackpackconfirm'] = 'Obrišite sajt sa albumom \'{$a}\'?';
$string['delparamconfirm'] = 'Da li ste sigurni da želite da obrišete ovaj parametar?';
$string['description'] = 'Opis';
$string['descriptioninfo'] = 'Šta ovaj bedž predstavlja?';
$string['disconnect'] = 'Prekini vezu';
$string['donotaward'] = 'Trenutno, ovaj bedž nije aktivan, tako da ne može biti dodeljen polaznicima. Ako želite da dodelite ovaj bedž aktivirajte njegov status.';
$string['enablebadges'] = 'Omogući bedževe';
$string['endorsement'] = 'Potvrda';
$string['error:backpackdatainvalid'] = 'Podaci dobijeni od albuma bedževa bili su neispravni';
$string['error:backpackemailnotfound'] = 'E-adresa \'{$a}\' nije povezana sa albumom bedževa. Potrebno je da <a href="http://backpack.openbadges.org">kreirate album</a> za taj nalog ili da se prijavite sa drugom e-adresom.';
$string['error:badgeawardnotfound'] = 'Nije moguće potvrditi ovaj dodeljeni bedž. Postoji mogućnost da je bedž oduzet.';
$string['error:badgenotfound'] = 'Bedž nije pronađen';
$string['error:cannotact'] = 'Nije moguće aktivirati bedž.';
$string['error:cannotawardbadge'] = 'Nije moguće dodeliti bedž korisniku';
$string['error:cannotdeletecriterion'] = 'Ovaj kriterijum je obrisan';
$string['error:cannotrevokebadge'] = 'Nije moguće oduzeti bedž korisniku.';
$string['error:clone'] = 'Nije moguće klonirati bedž.';
$string['error:connectionunknownreason'] = 'Povezivanje je bilo neuspešno iz nepoznatog razloga';
$string['error:duplicatename'] = 'Bedž sa takvim nazivom već postoji u sistemu';
$string['error:externalbadgedoesntexist'] = 'Bedž nije pronađen';
$string['error:guestuseraccess'] = 'Trenutno pristupate sistemu kao gost. Da biste videli bedževe potrebno ja da se prijavite pomoću svog korisničkog naloga..';
$string['error:invalidcriteriatype'] = 'Nevažeći tip kriterijum';
$string['error:invalidexpiredate'] = 'Datum isteka mora da bude u budućnosti.';
$string['error:invalidexpireperiod'] = 'Datum isteka ne može biti negativan ili jednak 0.';
$string['error:invalidparambadge'] = 'Bedž ne postoji';
$string['error:invalidparamcohort'] = 'Kohorta ne postoji.';
$string['error:noactivities'] = 'Na ovom kursu ne postoje aktivnosti sa omogućenim kriterijumom za završetak.';
$string['error:nobadges'] = 'Trenutno ne postoje bedževi sa omogućenim pristupom koji se mogu dodati kao kriterijumi. Bedž na nivou sajta može, kao kriterijume, imati samo druge bedževa na nivou sajta. Bedž na nivou kursa može, kao kriterijume, imati druge bedževa na nivou kursa ili na nivou sajta.';
$string['error:nocohorts'] = 'Nema kohorti';
$string['error:nocourses'] = 'Praćenje završetka kursa nije omogućeno ni za jedan od kurseva na ovom sajtu, tako da nema kursa koji bi mogao biti prikazan. Praćenje završetka kursa može se omogućiti u podešavanjima kursa.';
$string['error:nogroupslink'] = '<p>Prikazane su samo javne kolekcije. <a href="{$a}" target="_blank" rel="nofollow">. Posetite svoj album</a> kako biste kreirali javne kolekcije bedževa.</p>';
$string['error:nogroupssummary'] = '<p>U vašem albumu nema javnih kolekcija bedževa. </p>';
$string['error:nopermissiontoview'] = 'Nemate ovlašćenja da vidite dobitnike bedževa';
$string['error:nosuchbadge'] = 'Bedž sa id brojem {$a} ne postoji.';
$string['error:nosuchcohort'] = 'Upozorenje: ova kohorta više nije dostupna.';
$string['error:nosuchcourse'] = 'Upozorenje! Ova aktivnost više nije dostupna.';
$string['error:nosuchfield'] = 'Upozorenje! Ovo korisničko polje više nije dostupno.';
$string['error:nosuchmod'] = 'Upozorenje! Ova aktivnost više nije dostupna.';
$string['error:nosuchrole'] = 'Upozorenje! Ova uloga više nije dostupna.';
$string['error:nosuchuser'] = 'Korisnik sa ovom e-adresom nema nalog kod tekućeg provajdera albuma bedževa.';
$string['error:notifycoursedate'] = 'Bedževi povezani sa  završetkom kursa i aktivnosti neće biti izdati do datuma početka kursa ({$a}).';
$string['error:parameter'] = 'Upozorenje: Najmanje jedan parametar treba da bude izabran kako bi se obezbedio ispravan proces izdavanja bedževa.';
$string['error:relatedbadgedoesntexist'] = 'Ne postoji javni bedž sa ovim identifikatorom';
$string['error:requesterror'] = 'Zahtev za uspostavu veze nije uspeo (kôd greške {$a}).';
$string['error:requesttimeout'] = 'Zahtev za uspostavu veze je istekao pre nego što je mogao da se završi.';
$string['error:save'] = 'Nije moguće sačuvati bedž.';
$string['error:userdeleted'] = '{$a->user} (Ovaj korisnik više ne postoji na sajtu {$a->site})';
$string['eventbadgearchived'] = 'Bedž je arhiviran';
$string['eventbadgeawarded'] = 'Bedž dodeljen';
$string['eventbadgecreated'] = 'Bedž je kreiran';
$string['eventbadgecriteriacreated'] = 'Kriterijumi za bedž su kreirani';
$string['eventbadgecriteriadeleted'] = 'Kriterijumi za bedž su obrisani';
$string['eventbadgecriteriaupdated'] = 'Kriterijumi za bedž su ažurirani';
$string['eventbadgedeleted'] = 'Bedž je obrisan';
$string['eventbadgedisabled'] = 'Bedž je onemogućen';
$string['eventbadgeduplicated'] = 'Napravljen je duplikat bedža';
$string['eventbadgeenabled'] = 'Bedž je omogućen';
$string['eventbadgelistingviewed'] = 'Spisak bedževa prikazan';
$string['eventbadgerevoked'] = 'Bedž oduzet';
$string['eventbadgeupdated'] = 'Bedž je ažuriran';
$string['eventbadgeviewed'] = 'Bedž prikazan';
$string['existingrecipients'] = 'Postojeći dobitnici bedža';
$string['existsinbackpack'] = 'Bedž već postoji u  albumu';
$string['expired'] = 'Isteklo';
$string['expiredate'] = 'Ovaj bedž ističe {$a}.';
$string['expireddate'] = 'Ovaj bedž je istekao {$a}.';
$string['expiredin'] = 'Istekao {$a}';
$string['expireperiod'] = 'Ovaj bedž ističe {$a} dan(a) nakon što je izdat.';
$string['expireperiodh'] = 'Ovaj bedž ističe {$a} čas(ov)a nakon što je izdat.';
$string['expireperiodm'] = 'Ovaj bedž ističe {$a} minut(a) nakon što je izdat.';
$string['expireperiods'] = 'Ovaj bedž ističe {$a} sekundu/e/i nakon što je izdat.';
$string['expiresin'] = 'Ističe {$a}';
$string['expirydate'] = 'Datum isteka';
$string['expirydate_help'] = 'Opciono, bedževi mogu isteći određenog datuma, ili se datum može izračunati na osnovu datuma kada je bedž izdat korisniku.';
$string['externalbackpack_required'] = 'Polje za provajdera albuma ne može biti prazno';
$string['externalbadges'] = 'Moji bedževi sa drugih sajtova';
$string['externalbadges_help'] = 'Ovde su prikazani bedževi uz vaših eksternih albuma.';
$string['externalbadgesp'] = 'Bedževi sa drugih sajtova';
$string['externalconnectto'] = 'Da biste prikazali eksterne bedževe potrebno je da <a href="{$a}">uspostavite vezu sa albumom</a>.';
$string['fixed'] = 'Fiksni datum: ovaj bedž ističe sledećeg datuma';
$string['hidden'] = 'Sakriveno';
$string['hiddenbadge'] = 'Nažalost, vlasnik bedža nije učinio ove informacije dostupnim.';
$string['hostedurl'] = 'Eksterna URL adresa';
$string['hostedurldescription'] = 'Eksterna URL adresa na kojoj se bedž hostuje';
$string['imageauthoremail'] = 'Adresa e-pošte autora slike bedža';
$string['imageauthoremail_help'] = 'Ako je navedena, adresa e-pošte autora slike bedža prikazuje se na stranici bedža.';
$string['imageauthorname'] = 'Ime autora slike bedža';
$string['imageauthorname_help'] = 'Ako je navedeno, ime autora slike bedža prikazuje se na stranici bedža.';
$string['imageauthorurl'] = 'URL adresa autora slike bedža';
$string['imageauthorurl_help'] = 'Ako je naveden, link ka veb sajtu autora slike bedža prikazuje se na stranici bedža. URL adresa treba da ima prefiks http:// ili https://.';
$string['imagecaption'] = 'Potpis ispod slike';
$string['imagecaption_help'] = 'Ako je naveden, potpis ispod slike prikazuje se na stranici bedža.';
$string['includeauthdetails'] = 'Uključite podatke za proveru identiteta sa albumom';
$string['invalidurl'] = 'Neispravna URL adresa';
$string['issuancedetails'] = 'Bedž ističe';
$string['issuedbadge'] = 'Informacije o izdataom bedžu';
$string['issuedby'] = 'Izdaje {$a}';
$string['issuedon'] = 'Izdato {$a}';
$string['issuerdetails'] = 'Podaci o izdavaču';
$string['issueremail'] = 'Adresa e-pošte';
$string['issueremail_help'] = 'Kontakt adresa e-pošte organizacije koja izdaje potvrdu.';
$string['issuername'] = 'Ime/naziv izdavača bedža';
$string['issuername_endorsement'] = 'Naziv izdavača potvrde';
$string['issuername_endorsement_help'] = 'Naziv organizacije koja je izdaje potvrdu.';
$string['issuername_help'] = 'Ime osobe/naziv institucije nadležne za izdavanje bedževa.';
$string['issuerurl'] = 'URL adresa izdavača';
$string['issuerurl_help'] = 'Veb sajt organizacije koja izdaje potvrdu.';
$string['language'] = 'Jezik';
$string['language_help'] = 'Jezik koji se koristi na stranici bedža.';
$string['listbackpacks'] = 'Spisak albuma';
$string['localbadges'] = 'Moji bedževi sa veb sajta {$a}';
$string['localbadgesh'] = 'Moji bedževi sa ovoga sajta';
$string['localbadgesh_help'] = 'Svi bedževi u okviru ovog sajta, dobijeni na osnovu završetka kurseva i aktivnosti unutar kurseva, kao i ispunjavanjem drugih uslova.

Ovde možete upravljati svojim bedževima tako što ćete ih učiniti javnim ili privatnim za svoj stranicu profila.

Možete da preuzmete sve svoje bedževe ili svaki bedž zasebno, i sačuvate ih na svom kompjuteru. Preuzete bedževi možete da dodajete u svoje eksterne albume bedževa.';
$string['localbadgesp'] = 'Bedževi sa {$a}:';
$string['localconnectto'] = 'Da biste delili bedževe van ovog sajta potrebno je da <a href="{$a}">uspostavite vezu sa albumom</a>.';
$string['loginbackpacktitle'] = '<strong>Prijavite se na svoj album</strong>';
$string['makeprivate'] = 'Učini privatnim';
$string['makepublic'] = 'Učini javnim';
$string['managebackpacks'] = 'Upravljanje albumima';
$string['managebadges'] = 'Upravljanje bedževima';
$string['message'] = 'Telo poruke';
$string['messagebody'] = '<p>Dodeljen vam je bedž "%badgename%"!</p>
<p>Više informacija o ovom bedžu možete naći na stranici %badgelink%.</p>
<p>Bedžom možete upravljati i preuzeti ga sa svoje stranice {$a}.</p>';
$string['messagesubject'] = 'Čestitamo! Osvojili ste bedž!';
$string['method'] = 'Ovaj kriterijum je ispunjen kada...';
$string['mingrade'] = 'Neophodna je minimalna ocena';
$string['month'] = 'Mesec(i)';
$string['moredetails'] = 'Više informacija';
$string['mybackpack'] = 'Podešavanja mog albuma bedževa';
$string['mybadges'] = 'Moji bedževi';
$string['namewithlink'] = 'Naziv sa linkom';
$string['never'] = 'Nikad: ovaj bedž ne ističe';
$string['newbackpack'] = 'Dodaj novi album';
$string['newbadge'] = 'Dodaj novi bedž';
$string['newbadgedeprecated'] = 'Preusmereni ste sa badges/newbadge.php. Imajte na umu da će badges/newbadge.php biti uklonjen u bliskoj budućnosti.
<br/>Ažurirajte linkove i obeleživače kako biste mogli da koristite trenutnu stranicu badges/edit.php.';
$string['newimage'] = 'Nova slika';
$string['noalignment'] = 'Ovaj bedž nema navedene eksterne veštine ili standarde.';
$string['noawards'] = 'Ovaj bedž još niko nije dobio.';
$string['nobackpack'] = 'Ne postoji album bedževa koji je povezan sa ovim nalogom.<br/>';
$string['nobackpackbadgessummary'] = 'Nema bedževa u kolekcijama koje ste izabrali.';
$string['nobackpackcollectionssummary'] = 'Nije izabrana nijedna kolekcija bedževa.';
$string['nobackpacks'] = 'Nema dostupnih albuma';
$string['nobadges'] = 'Trenutno nema dostupnih bedževa koje korisnici mogu da osvoje.';
$string['nocompetencies'] = 'Nisu izabrane kompetencije.';
$string['nocriteria'] = 'Kriterijumi za ovaj bedž još nisu podešeni';
$string['noendorsement'] = 'Ovaj bedž nema potvrdu';
$string['noexpiry'] = 'Ovaj bedž nema datum isteka';
$string['nomatchingawards'] = 'Još uvek nema korisnika koji su osvojili ovaj bedž.';
$string['nomatchingbadges'] = 'Ne postoje odgovarajući bedževi koje bi korisnici mogli da osvoje.';
$string['noparamstoadd'] = 'Nema dodatnih parametara dostupnih za dodavanje uslova za dobijanje ovog bedža';
$string['norelated'] = 'Ova bedž nema povezanih bedževa.';
$string['notacceptedrole'] = 'Vaša trenutna uloga se ne nalazi među ulogama koje mogu ručno da izdaju ovaj bedž.<br/>
Ako želite da vidite korisnike koji su već osvojili ovaj bedž , možete da posetite stranicu {$a}.';
$string['notconnected'] = 'Veza nije uspostavljena';
$string['notealignment'] = 'Eksterne veštine ili standardi koje pokriva bedž mogu biti navedeni. Sve eksterne veštine ili standardi prikazani su na stranici bedža.';
$string['noteendorsement'] = 'Potvrda treće strane može se koristiti za dodavanje vriednosti bedžu. Na primer, bedž koji je izdao nastavnik može biti potvrđena od strane škole, ili bedž koji izdaje lokalno telo za nagrade može biti potvrđen od strane nacionalnog tela za dodelu nagrada.';
$string['noterelated'] = 'Bedževi sa vezom mogu biti označeni kao povezani. Na primer, bedževi sa istim kriterijumima koji su prikazani na različitim jezicima mogu biti označeni kao povezani. Svi povezani bedževi prikazuju se na stranici bedža.';
$string['nothingtoadd'] = 'Ne postoje dostupni kriterijumi za dodavanje.';
$string['notification'] = 'Obavesti kreatora bedža';
$string['notification_help'] = 'Ovo podešavanje upravlja obaveštenjima koja se šalju kreatorima bedževa kako bi znali da je bedž izdata.

Dostupne su sledeće opcije:

* **NIKAD** – Obaveštenja se ne šalju.

* **SVAKI PUT** – Obaveštenje se šalje svaki puta kada je bedž dodeljen.

* **DNEVNO** – Obaveštenje se šalje jednom dnevno.

* **SEDMIČNO** – Obaveštenje se šalje jednom sedmično.

* **MESEČNO** – Obaveštenje se šalje jednom mesečno.';
$string['notifydaily'] = 'Dnevno';
$string['notifyevery'] = 'Svaki put';
$string['notifymonthly'] = 'Mesečno';
$string['notifyweekly'] = 'Sedmično';
$string['numawards'] = 'Broj korisnika kojima je dodeljen bedž \'{$a->badgename}\': <a href="{$a->link}">{$a->count}</a>.';
$string['numawardstat'] = 'Korisnici kojima je dodeljen bedž \'{$a->badgename}\': {$a->awards}.';
$string['oauth2issuer'] = 'OAuth 2 servisi';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Druga navigacija ...';
$string['overallcrit'] = 'od izabranih kriterijuma su ispunjeni';
$string['password_required'] = 'Polje za lozinku ne može biti prazno';
$string['potentialrecipients'] = 'Potencijalni dobitnici bedževa';
$string['preferences'] = 'Parametri bedža';
$string['privacy:metadata:backpack'] = 'Zapis korisnikove kolekcije bedževa';
$string['privacy:metadata:backpack:backpackuid'] = 'Jedinstveni identifikator kolekcije bedževa';
$string['privacy:metadata:backpack:email'] = 'Adresa elektronske pošte vezana za kolekciju bedževa';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID oznaka albuma';
$string['privacy:metadata:backpack:userid'] = 'Identifikator korisnika čiji ja je kolekcija bedževa';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 informacije kada se korisnik povezuje sa spoljnim albumom';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID oznaka OAuth 2 servisa';
$string['privacy:metadata:backpackoauth2:scope'] = 'Spisak opsega za povezivanja sa albumom';
$string['privacy:metadata:backpackoauth2:token'] = 'Token veze sa albumom';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID oznaka korisnika koji se povezuje sa albumom';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID oznaka korisnika koji je izmenio vezu.';
$string['privacy:metadata:badge'] = 'Kolekcija bedževa';
$string['privacy:metadata:badge:timecreated'] = 'Vreme kreiranja bedževa';
$string['privacy:metadata:badge:timemodified'] = 'Vreme kada je bedž poslednji put izmenjen';
$string['privacy:metadata:badge:usercreated'] = 'Identifikator korisnika koji je kreirao bedž';
$string['privacy:metadata:badge:usermodified'] = 'ID oznaka korisnika koji je izmenio bedž';
$string['privacy:metadata:criteriamet'] = 'Skup kriterijuma koji su zadovoljeni';
$string['privacy:metadata:criteriamet:datemet'] = 'Datum kad su kriterijumi zadovoljeni';
$string['privacy:metadata:criteriamet:userid'] = 'Identifikator korisnika koji je zadovoljio kriterijume';
$string['privacy:metadata:external:backpacks'] = 'Informacije koje se dele kad korisnici predaju svoje bedževe u eksternu kolekciju bedževa';
$string['privacy:metadata:external:backpacks:badge'] = 'Naziv bedža';
$string['privacy:metadata:external:backpacks:description'] = 'Opis bedža';
$string['privacy:metadata:external:backpacks:image'] = 'Slika bedža';
$string['privacy:metadata:external:backpacks:issuer'] = 'Neke informacije o izdavaču';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle URL na kom se mogu videti informacije o izdatom bedžu';
$string['privacy:metadata:issued'] = 'Zapis o dodeljenim bedževima';
$string['privacy:metadata:issued:dateexpire'] = 'Datum kada ističe bedž';
$string['privacy:metadata:issued:dateissued'] = 'Datum dodele bedža';
$string['privacy:metadata:issued:userid'] = 'Identifikator korisnika kojem je dodeljen bedž';
$string['privacy:metadata:manualaward'] = 'Zapis o ručnim dodelama bedževa';
$string['privacy:metadata:manualaward:datemet'] = 'Datum kada je korisniku dodeljen bedž';
$string['privacy:metadata:manualaward:issuerid'] = 'Identifikator korisnika koji dodeljuje bedž';
$string['privacy:metadata:manualaward:issuerrole'] = 'Uloga korisnika koji dodeljuje bedž';
$string['privacy:metadata:manualaward:recipientid'] = 'Identifikator korisnika kome je ručno dodeljen bedž';
$string['recipient'] = 'Dobitnik bedža';
$string['recipients'] = 'Dobitnici bedža';
$string['recipientvalidationproblem'] = 'Ovaj korisnik ne može biti potvrđen kao primalac ovog bedža.';
$string['relatedbages'] = 'Povezani bedževi';
$string['relative'] = 'Relativni datum: ovaj bedž ističe nakon određenog vremenskog perioda:';
$string['requiredbadge'] = 'Treba dodati najmanje jedan bedž kao kriterijum.';
$string['requiredcohort'] = 'Kriterijumu za kohorte potrebno je dodati barem jednu kohortu.';
$string['requiredcompetency'] = 'Najmanje jednu kompetenciju treba dodati kriterijumu kompetencije.';
$string['requiredcourse'] = 'Najmanje jedan kurs treba dodati u kriterijum za skup kurseva.';
$string['reviewbadge'] = 'Promene u pristup bedžu';
$string['reviewconfirm'] = '<p>Ovo će učiniti da vaš bedž bude vidljiv korisnicima i omogućiti im da ga osvoje.</p>

<p>Postoji mogućnost da neki korisnici već ispunjavaju kriterijume za dobijanje ovog bedža. Njima će bedž biti dodeljen odmah nakon što ga učinite dostupnim.</p>

<p>Jednom kada je bedž dodeljen on će biti <strong>zaključan</strong> - određena podešavanja, uključujući kriterijume i vreme isteka, više neće moći da se menjaju.</p>

<p>Da li ste sigutni da želite da omogućite pristup bedžu \'{$a}\'?</p>';
$string['revoke'] = 'Oduzmi bedž';
$string['save'] = 'Sačuvaj';
$string['searchname'] = 'Pretraži po imenu';
$string['selectaward'] = 'Izaberite ulogu koju želite da koristite za dodeljivanje ovog bedža:';
$string['selectgroup_end'] = 'Prikazane su samo javne kolekcije. <a href="{$a}">Posetite svoj album</a> kako biste kreirali više javnih kolekcija bedževa.';
$string['selectgroup_start'] = 'Izaberite kolekcije bedževa iz svog albuma za prikaz na ovom sajtu:';
$string['selecting'] = 'Sa izabranim bedževima...';
$string['setup'] = 'Podesi vezu';
$string['sitebackpackdeleted'] = 'Album sajta je obrisan.';
$string['sitebackpacknotdeleted'] = 'Ovaj album nije moguće obrisati, jer je to trenutno podrazumevani album sajta.';
$string['sitebackpackwarning'] = 'Nije moguće povezati se sa albumom bedževa. <br/><br/>Proverite da li je u podešavanju "E-adresa izdavača bedža" uneta ispravna e-adresa za nalog na veb sajtu albuma. <br/><br/>Proverite da li je "Lozinka izdavača bedža" na <a href="{$a->url}">stranici za podešavanje albuma</a>, ispravna za nalog na veb sajtu albuma. <br/><br/>Album je poslao sledeće upozorenje: "{$a->warning}"';
$string['sitebadges'] = 'Bedževi sajta';
$string['sitebadges_help'] = 'Bedževi na nivou sajta se mogu dodeliti korisnicima samo za aktivnosti koji su vezi sa sajtom. Ovo uključuje završetak skupa kurseva ili delova korisničkih profila. Bedževi sajta mogu se, takođe, ručno dodeliti od strane jednog korisnika drugom korisniku.

Bedževi za kurseve moraju da se kreiraju na nivou kursa. Bedževi kursa mogu da se pronađu pod Administracija kursa> Bedževi.';
$string['sitebadgetitle'] = '{$a} bedž';
$string['status'] = 'Status bedža';
$string['status_help'] = 'Status bedža određuje njegova ponašanje u sistemu

* **DOSTUPAN** – znači da korisnici mogu da zarade ovaj bedž. Dok je bedž dostupan korisnicima, kriterijum za njegovo dobijanje ne mogu da se menjaju.

* **NIJE DOSTUPAN** – znači da bedž nije dostupan korisnicima i da ne može biti dobijen ili ručno dodeljen. Ako ovaj bedž prethodno uopšte nije izdavan, kriterijumi za njegovo dobijanje mogu da se menjaju.

Jednom kada je bedž dodeljen barem jednom korisniku, on automatski postaje **ZAKLjUČAN**. Korisnici i dalje mogu dobijaju zaključane bedževe, ali kriterijumi za dobijanje tih bedževa više ne mogu da se menjaju. Ako želite da menjate podatke ili kriterijume zaključanog bedža, možete napraviti njegovu kopiju i uneti sve neophodne promene.

*Zašto zaključavamo bedževe?*

Želimo da se uverimo da su svi korisnici ispunili iste uslove za dobijanje bedža. Trenutno, nije moguće da se bedž opozove. Ukoliko bismo dozvolili da se uslovi za dobijanje bedža menjaju u svakom trenutku, to bi na kraju, najverovatnije, dovelo do toga da imamo korisnike koji su isti bedž dobili za ispunjavanje potpuno različitih uslova.';
$string['statusmessage_0'] = 'Ovaj bedž trenutno nije dostupan korisnicima. Omogućite pristuo ako želite da korisnici osvoje ovaj bedž.';
$string['statusmessage_1'] = 'Ovaj bedž je trenutno dostupan korisnicima. Onemogućite pristup kako biste napravili promene.';
$string['statusmessage_2'] = 'Ovaj bedž trenutno nije dostupan korisnicima. a njegovi kriterijum su zaključani. Omogućite pristup ako želite da korisnici osvoje ovaj bedž.';
$string['statusmessage_3'] = 'Ovaj bedž je trenutno dostupan korisnicima, a njegovi kriterijumi su zaključani.';
$string['statusmessage_4'] = 'Ovaj bedž je trenutno arhiviran.';
$string['subject'] = 'Tema poruke';
$string['tagarea_badge'] = 'Bedževi';
$string['tags'] = 'Oznake';
$string['targetcode'] = 'Kôd';
$string['targetcode_help'] = 'Jedinstveni identifikacioni kôd za referenciranje eksterne veštine ili standarda unutar njihovog okvira.';
$string['targetdescription'] = 'Opis';
$string['targetdescription_help'] = 'Kratak opis eksterne veštine ili standarda.';
$string['targetframework'] = 'Okvir';
$string['targetframework_help'] = 'Naziv okvira eksterne veštine ili standarda.';
$string['targetname'] = 'Naziv';
$string['targetname_help'] = 'Eksterna veština ili standard koji pokriva bedž.';
$string['targeturl'] = 'URL adresa';
$string['targeturl_help'] = 'Link ka stranici koja opisuje eksternu veštinu ili standard. URL adresa treba da ima prefiks http:// ili https://.';
$string['testbackpack'] = 'Test album bedževa \'{$a}\'';
$string['testsettings'] = 'Test podešavanja';
$string['type'] = 'Tip';
$string['userbadges'] = 'Bedževi korisnika';
$string['variablesubstitution'] = 'Zamena promenljivih u porukama.';
$string['variablesubstitution_help'] = 'U poruku o bedžu, mogu da se umetnu određene promenljive u temu i/ili telo poruke, tako da, kada se šalje poruka, promenljive budu zamenjene sa realnim vrednostima. Promenljive treba umetnuti u tekst tačno onako kako je dole prikazano. Mogu se koristiti sledeće promenljive:

%badgename%
: Ovo će biti zamenjeno punim nazivom bedža.

%username%
: Ovo će biti zamenjeno imenom i prezimenom dobitnika bedža.

%badgelink%
: Ovo će biti zamenjeno javnom URL adresom sa informacijama o izdatom bedžu.';
$string['verifyemail'] = 'Potvrdite e-adresu';
$string['version'] = 'Verzija';
$string['version_help'] = 'Polje verzije se može koristiti za praćenje razvoja bedža. Ako je navedena, verzija bedža prikazuje se na stranici bedža.';
$string['viewbadge'] = 'Pogledaj izdate bedževe';
$string['visible'] = 'Vidljivo';
$string['warnexpired'] = '(Ovaj bedž je istekao!)';
$string['year'] = 'Godina(e)';
