<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_almondb', language 'sr_lt', version '5.0'.
 *
 * @package     theme_almondb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Napredna podešavanja';
$string['almondbpage'] = 'Info stranice';
$string['almondbpagecaption'] = 'Natpis stranice';
$string['almondbpagecaptiondesc'] = 'Dodajte natpis za svoju stranicu';
$string['almondbpagecaptionsimple'] = 'Natpis stranice';
$string['almondbpagecaptionsimpledesc'] = 'Dodajte natpis za svoju stranicu';
$string['almondbpagecount'] = 'Broj stranica';
$string['almondbpagecountdesc'] = 'Izaberite koliko stranica želite da dodate <strong>zatim kliknite na dugme SAČUVAJ</strong> kako biste učitali polja za unos podešavanja.';
$string['almondbpagecountsimple'] = 'Broj stranica';
$string['almondbpagecountsimpledesc'] = 'Izaberite koliko stranica želite da dodate <strong>zatim kliknite na dugme SAČUVAJ</strong> kako biste učitali polja za unos podešavanja.';
$string['almondbpagecss'] = 'CSS stilovi stranice';
$string['almondbpagecssdesc'] = 'Dodajte CSS za svoju stranicu';
$string['almondbpagecsslink'] = 'Link CSS stilova stranicе';
$string['almondbpagecsslinkdesc'] = 'Dodajte link CSS stilove za vašu stranicu,
            Example : "https://www.example.com/abc.css"';
$string['almondbpagedesign'] = 'Dizajn stranice';
$string['almondbpagedesigndesc'] = 'Izaberite dizajn stranice koji želite da dodate. Možete brzo da kreirate svoje stranice koristeći jednostavan dizajn.
                                Kod jednostavnog dizajna koristite samo sliku i deo podnaslova.';
$string['almondbpageenabled'] = 'Omogući almondbpage';
$string['almondbpageenableddesc'] = 'Omogućite almondbpage na vrhu vaše početne stranice';
$string['almondbpageenabledsimple'] = 'Omogući almondbpage';
$string['almondbpageenabledsimpledesc'] = 'Omogućite almondbpage na vrhu vaše početne stranice';
$string['almondbpageend'] = '--*/*--';
$string['almondbpageenddesc'] = '--*/*--';
$string['almondbpagefooter'] = 'Podnožje stranice';
$string['almondbpagefooterdesc'] = 'Dodajte podnožje na info stranicu';
$string['almondbpagefootersimple'] = 'Podnožje stranice';
$string['almondbpagefootersimpledesc'] = 'Dodajte podnožje na info stranicu';
$string['almondbpageheader'] = 'Zaglavlje stranice';
$string['almondbpageheaderdesc'] = 'Dodajte zaglavlje na info stranicu';
$string['almondbpageheadersimple'] = 'Zaglavlje stranice';
$string['almondbpageheadersimpledesc'] = 'Dodajte zaglavlje na info stranicu';
$string['almondbpageheading'] = ': Napredna Podešavanja Stranice';
$string['almondbpageheadingdesc'] = 'Ovo kreira do šest info stranica za promociju važnih elemenata vašeg sajta.';
$string['almondbpageheadingsimple'] = '! Jednostavna Podešavanja Stranice';
$string['almondbpageheadingsimpledesc'] = 'Ovo kreira do šest info stranica za promociju važnih elemenata vašeg sajta.';
$string['almondbpageimage'] = 'Slika stranice';
$string['almondbpageimagedesc'] = 'Dodajte sliku za svoju stranicu.';
$string['almondbpageimagesimple'] = 'Slika stranice';
$string['almondbpageimagesimpledesc'] = 'Dodajte sliku za svoju stranicu.';
$string['almondbpageimglink'] = 'Link ka direktorijumu sa slikama';
$string['almondbpageimglinkdesc'] = 'Dodajte link ka direktorijumu sa slikama za svoju stranicu i kopirajte slike koje koristite u HTML kôdu u ovaj direktorijum.
        Ako popunite polje za direktorijum sa slikama, nemojte u HTML stranice unositi putanju slike.
            samo napišite nešto poput demo-1.png (ilir jpg).
            Пример: http://www.exaple.com/img/, (img src= demo-1.jpg).';
$string['almondbpageimgpositionsimple'] = 'Pozicija slike stranice';
$string['almondbpageimgpositionsimpledesc'] = 'Gde će se postavljena slika nalaziti na stranici.';
$string['almondbpagenavbar'] = 'Navigaciona traka stranice';
$string['almondbpagenavbardesc'] = 'Додајте навигациону траку на инфо страницу';
$string['almondbpageno'] = '! Stranica-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Unesite podešavanja za stranicu {$a->almondbpage}. <b><i>LINK STRANICA: www.yoursite/local/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagenosimple'] = '! Stranica-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Unesite podešavanja za stranicu {$a->almondbpage}. <b><i>LINK STRANICA: www.yoursite/local/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagenotfound'] = 'Stranica nije pronađena, proverite URL adresu';
$string['almondbpagestart'] = 'Podešavanja info stranice';
$string['almondbpagestartdesc'] = '--*/*--';
$string['almondbpagetitle'] = 'Naslov stranice';
$string['almondbpagetitledesc'] = 'Dodajte naslov stranice.';
$string['almondbpagetitlesimple'] = 'Naslov stranice';
$string['almondbpagetitlesimpledesc'] = 'Dodajte naslov stranice.';
$string['backcolor'] = 'Боја позадине';
$string['backcolor_desc'] = 'Boja pozadine';
$string['backgroundimage'] = 'Pozadinska slika';
$string['backgroundimage_desc'] = 'Slika koja će biti prikazana kao pozadina sajta. Pozadinska slika koju ovde postavite zameniće sliku u vašim datotekama sa predefinisanim podešavanjima teme.';
$string['block01button'] = 'Dugme bloka 1';
$string['block01buttondesc'] = 'Dodajte dugme za svoj blok 1';
$string['block01buttonlink'] = 'URL adresa bloka 1';
$string['block01buttonlinkdesc'] = 'Dodajte URL adresu za svoj blok 1';
$string['block01caption'] = 'Natpis bloka 1';
$string['block01captiondefault'] = '<h2 class="white">Izabrane Premijum Teme</h2><br>
<p class="white">Teme su dizajnirane tako da ne remete standardni izgled Moodlea, pa će vam olakšati rad. Pogledajte neke od glavnih karakteristika tema.</p>';
$string['block01captiondesc'] = 'Dodajte natpis za svoj blok 1';
$string['block01color'] = 'Boja pozadine bloka 1';
$string['block01colordesc'] = 'Dodajte boju pozadine za blok 1';
$string['block01enabled'] = 'Omogućite blok 1';
$string['block01enableddesc'] = 'Omogućite ili onemogućite blok 1 na vašoj početnoj stranici';
$string['block01info'] = ': Block-1 TITLE BOX';
$string['block01infodesc'] = 'NASLOVNI BLOK - Unesite podešavanja za blok 1';
$string['block02button'] = 'Dugme bloka {$a->block}';
$string['block02buttondesc'] = 'Dodajte dugme za svoj blok';
$string['block02buttonlink'] = 'URL adresa bloka {$a->block}';
$string['block02buttonlinkdesc'] = 'Dodajte URL adresu za svoj blok';
$string['block02caption'] = 'Natpis bloka {$a->block}';
$string['block02captiondefault'] = 'Uživajte u našim besplatnim onlajn kursevima,
gde god da ste i kad god želite. Pristupite sadržaju kursa na mobilnom uređaju, tabletu ili desktopu računaru.';
$string['block02captiondesc'] = 'Dodajte natpis za svoj blok';
$string['block02count'] = 'Blok -2 Broj';
$string['block02countdesc'] = 'Izaberite broj blokova i pritisnite dugme "Sačuvaj promene"';
$string['block02enabled'] = 'Omogućite blok 2';
$string['block02enableddesc'] = 'Omogućite ili onemogućite blok 2 na vašoj početnoj stranici';
$string['block02icon'] = 'Ikonica bloka {$a->block}';
$string['block02icondefault'] = '--*/*--';
$string['block02icondefault1'] = 'core:i/report';
$string['block02icondefault2'] = 'core:i/settings';
$string['block02icondefault3'] = 'core:i/stats';
$string['block02icondefault4'] = 'core:i/notifications';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Kliknite da biste videli ikonice</a>';
$string['block02imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block02info'] = '! Blok -2 BLOK IKONICA';
$string['block02infodesc'] = 'BLOK IKONICA - Unesite podešavanja za blok 2';
$string['block02title'] = 'Naslov bloka {$ a-> block}';
$string['block02titledefault'] = 'Najbolji investicioni savetnici';
$string['block02titledesc'] = 'Dodajte naslov za svoj blok';
$string['block03caption'] = 'Natpis bloka 3 {$a->block}';
$string['block03captiondefault'] = 'Vestibulum non diam quis nisl dignissim posuere a vulputate urna nunc velit';
$string['block03captiondesc'] = 'Dodajte natpis za svoj blok 3';
$string['block03design'] = 'Dizajn bloka 3';
$string['block03designdesc'] = 'Izaberite dizajn bloka 3 koji želite da dodate';
$string['block03enabled'] = 'Omogućite blok 3';
$string['block03enableddesc'] = 'Omogućite ili onemogućite blok 3 na vašoj početnoj stranici';
$string['block03header'] = 'Zaglavlje bloka 3';
$string['block03headerdefault'] = 'Mi smo THEMES ALMOND';
$string['block03headerdesc'] = 'Zaglavlje bloka 3';
$string['block03icon'] = 'Ikonica bloka 3';
$string['block03icondefault'] = 'core:i/categoryevent';
$string['block03icondefault1'] = 'core:t/download';
$string['block03icondefault2'] = 'core:a/setting';
$string['block03icondefault3'] = 'core:docs';
$string['block03icondefault4'] = 'core:i/duration';
$string['block03icondefault5'] = 'core:i/checked';
$string['block03icondefault6'] = 'core:e/visual_aid';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Kliknite da biste videli ikonice</a>';
$string['block03info'] = '! Blok -3 FUNKCIJE';
$string['block03infodesc'] = 'FUNKCIJE - Унесите подешавања за блок 3';
$string['block03link'] = 'URL adresa bloka 3 {$a->block}';
$string['block03linkdesc'] = 'Dodajte URL adresu za svoj blok 3';
$string['block03title'] = 'Наслов блока 3 {$a->block}';
$string['block03titledefault'] = 'Prilagodljivi dizajn';
$string['block03titledesc'] = 'Dodajte naslov za svoj blok 3';
$string['block04button'] = 'Tekst dugmeta bloka 4';
$string['block04buttondefault'] = 'Prikaži sve kurseve';
$string['block04buttondesc'] = 'Tekst dugmeta bloka 4';
$string['block04buttonlink'] = 'Link dugmeta bloka 4';
$string['block04buttonlinkdefault'] = 'course/index.php';
$string['block04buttonlinkdesc'] = 'Link dugmeta bloka 4';
$string['block04caption'] = 'Natpis bloka 4 {$a->block}';
$string['block04captiondesc'] = 'Dodajte natpis za svoj blok 4';
$string['block04design'] = 'Dizajn bloka 4';
$string['block04designdesc'] = 'Izaberite dizajn bloka 4 koji želite da dodate';
$string['block04enabled'] = 'Omogućite blok 4';
$string['block04enableddesc'] = 'Omogućite ili onemogućite blok 4 na vašoj početnoj stranici';
$string['block04header'] = 'Zaglavlje bloka 4';
$string['block04headerdefault'] = 'NAJNOVIJI PROJEKTI';
$string['block04headerdesc'] = 'Zaglavlje bloka 4';
$string['block04imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block04info'] = '! Blok -4 NAJNOVIJE';
$string['block04infodesc'] = 'NAJNOVIJE - Unesite podešavanja za blok 4';
$string['block04link'] = 'URL adresa bloka 4 {$a->block}';
$string['block04linkdesc'] = 'Dodajte URL adresu za svoj blok 4';
$string['block04title'] = 'Naslov bloka 4 {$a->block}';
$string['block04titledesc'] = 'Dodajte naslov za svoj blok 4';
$string['block05caption'] = 'Natpis bloka 5 {$a->block}';
$string['block05captiondesc'] = 'Dodajte natpis za svoj blok 5';
$string['block05design'] = 'Dizajn bloka 5';
$string['block05designdesc'] = 'Izaberite dizajn bloka 5 koji želite da dodate';
$string['block05enabled'] = 'Omogućite blok 5';
$string['block05enableddesc'] = 'Omogućite ili onemogućite blok 5 na vašoj početnoj stranici';
$string['block05header'] = 'Zaglavlje bloka 5';
$string['block05headerdefault'] = 'ZAŠTO IZABRATI NAS';
$string['block05headerdesc'] = 'Zaglavlje bloka 5';
$string['block05icon'] = 'Ikonica bloka 5 {$a->block}';
$string['block05icondefault'] = 'core:i/categoryevent';
$string['block05icondefault1'] = 'core:i/settings';
$string['block05icondefault2'] = 'core:i/hide';
$string['block05icondefault3'] = 'core:i/bullhorn';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Kliknite da biste videli ikonice</a>';
$string['block05imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block05info'] = '! Blok -5 ZAŠTO MI';
$string['block05infodesc'] = 'ZAŠTO MI - Unesite podešavanja za blok 5';
$string['block05link'] = 'URL adresa bloka 5 {$a->block}';
$string['block05linkdesc'] = 'Dodajte URL adresu za svoj blok 5';
$string['block05title'] = 'Naslov bloka 5 {$a->block}';
$string['block05titledesc'] = 'Dodajte naslov za svoj blok 5';
$string['block06button'] = 'URL adresa bloka 6';
$string['block06buttondesc'] = 'Dodajte URL adresu za svoj blok 6';
$string['block06buttonlink'] = 'URL adresa bloka 6';
$string['block06buttonlinkdesc'] = 'Dodajte URL adresu za svoj blok 6';
$string['block06caption'] = 'Natpis bloka 6';
$string['block06captiondefault'] = 'Dodajte podrazumevani natpis za svoj blok 6';
$string['block06captiondesc'] = 'Dodajte natpis za svoj blok 6';
$string['block06color'] = 'Boja pozadine bloka 6';
$string['block06colordesc'] = 'Dodajte boju pozadine za blok 6';
$string['block06design'] = 'Dizajn bloka 6';
$string['block06designdesc'] = 'Izaberite dizajn bloka 6 koji želite da dodate';
$string['block06enabled'] = 'Omogućite blok 6';
$string['block06enableddesc'] = 'Omogućite ili onemogućite blok 6 na vašoj početnoj stranici';
$string['block06header'] = 'Zaglavlje bloka 6';
$string['block06headerdefault'] = 'RAD SA NAMA';
$string['block06headerdesc'] = 'Zaglavlje bloka 6';
$string['block06imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block06info'] = '! Blok 6 RAD SA NAMA';
$string['block06infodesc'] = 'RAD SA NAMA - Unesite podešavanja za blok 6';
$string['block07button'] = 'URL adresa bloka 7';
$string['block07buttondesc'] = 'Dodajte URL adresu za svoj blok 7';
$string['block07buttonlink'] = 'URL adresa bloka 7';
$string['block07buttonlinkdesc'] = 'Dodajte URL adresu za svoj blok 7';
$string['block07count'] = 'Blok 7 broj';
$string['block07countdefault'] = '8';
$string['block07countdesc'] = 'Broj kurseva za prikaz';
$string['block07design'] = 'Dizajn bloka 7';
$string['block07designdesc'] = 'Izaberite dizajn bloka 7 koji želite da dodate';
$string['block07enabled'] = 'Omogućite blok 7';
$string['block07enableddesc'] = 'Omogućite ili onemogućite blok 7 na vašoj početnoj stranici';
$string['block07enrol'] = 'Besplatno';
$string['block07header'] = 'Zaglavlje bloka 7';
$string['block07headerdefault'] = 'DOSTUPNI KURSEVI';
$string['block07headerdesc'] = 'Zaglavlje bloka 7';
$string['block07info'] = '! Blok -7 DOSTUPNI KURSOVI';
$string['block07infodesc'] = 'DOSTUPNI KURSEVI - Unesite postavke za blok 7';
$string['block07priceshow'] = 'Prikaži cenu upisa kursa';
$string['block07priceshowdesc'] = 'Omogući /onemogući cenu upisa na kurs';
$string['block07studentrole'] = 'Blok 7 uloga polaznika';
$string['block07studentroledesc'] = 'Izaberite ulogu polaznika';
$string['block07teacherenabled'] = 'BLOK 7 Angažovani predavači';
$string['block07teacherenableddesc'] = 'Prikažite predavače?';
$string['block07teacherrole'] = 'Blok 7 uloga predavača';
$string['block07teacherroledesc'] = 'Izaberite ulogu predavača';
$string['block07title'] = 'Naslov bloka 7';
$string['block07titledefault'] = 'kratkinaziv';
$string['block07titledesc'] = 'Tip naslova kursa';
$string['block07tooltipcategory'] = 'Kategorija';
$string['block07tooltipenrolled'] = 'Upisani studenti';
$string['block07tooltiplastdate'] = 'Datum poslednje izmene';
$string['block08caption'] = 'Natpis bloka 8';
$string['block08captiondefault'] = 'Nastavljamo da služimo sa našim predavačkim osobljem. Upoznajte naše predavače.';
$string['block08captiondesc'] = 'Natpis bloka 8';
$string['block08count'] = 'Blok 8 broj';
$string['block08countdefault'] = '8';
$string['block08countdesc'] = 'Broj predavača za prikaz';
$string['block08description'] = 'Opis blokA 8';
$string['block08descriptiondesc'] = 'Prikaži opis korisnika na stranici.';
$string['block08design'] = 'Dizajn bloka 8';
$string['block08designdesc'] = 'Izaberite dizajn bloka 8 koji želite da dodate';
$string['block08enabled'] = 'Omogućite blok 8';
$string['block08enableddesc'] = 'Omogućite ili onemogućite blok 8 na vašoj početnoj stranici';
$string['block08header'] = 'Zaglavlje bloka 8';
$string['block08headerdefault'] = 'PREDAVAČI';
$string['block08headerdesc'] = 'Zaglavlje bloka 8';
$string['block08info'] = '! Blok -8 PREDAVAČ';
$string['block08infodesc'] = 'PREDAVAČI – Unesite podešavanja za blok 8';
$string['block08showrole'] = 'Blok 8 Prikaz uloga';
$string['block08showroledesc'] = 'Uloge korisnika koje se prikazuju u bloku 8';
$string['block08studentrole'] = 'Blok 8 Uloga poleznika';
$string['block08studentroledesc'] = 'Uloga polaznika';
$string['block08tooltipcourse'] = 'Ukupan broj kurseva predavača';
$string['block08tooltipstudents'] = 'Ukupan broj polaznika predavača';
$string['block08total'] = 'Blok 8 Ukupno';
$string['block08totaldesc'] = 'Prikaži ukupan broj kurseva i studenata';
$string['block09background'] = 'Pozadina bloka 9';
$string['block09backgrounddesc'] = 'Izaberite boju pozadine ili pozadinsku sliku bloka 9';
$string['block09boxshadow'] = 'Blok 9 Senka okvira';
$string['block09boxshadowdesc'] = 'Izaberite da li omogućiti senku oko okvira kategorija u bloku 9';
$string['block09caption'] = 'Natpis bloka 9';
$string['block09captiondefault'] = 'Spisak registrovanih kategorija';
$string['block09captiondesc'] = 'Natpis bloka 9';
$string['block09count'] = 'Blok 9 broj';
$string['block09countdefault'] = '8';
$string['block09countdesc'] = 'Broj kategorija prikaza';
$string['block09ctgid'] = 'Blok 9 ID - oznaka kategorije';
$string['block09ctgiddesc'] = 'Blok 9 - izabrane ID oznake kategorija (npr: ID = 1 ili ID = 2 ili ID = 3): ako je polje prazno biće prikazane sve kategorija';
$string['block09design'] = 'Dizajn bloka 9';
$string['block09designdesc'] = 'Izaberite dizajn bloka 9 koji želite da dodate';
$string['block09enabled'] = 'Omogućite blok 9';
$string['block09enableddesc'] = 'Omogućite ili onemogućite blok 9 na vašoj početnoj stranici';
$string['block09header'] = 'Zaglavlje bloka 9';
$string['block09headerdefault'] = 'Dostupne kategorije';
$string['block09headerdesc'] = 'Opis zaglavlja bloka 9';
$string['block09info'] = '! Blok -9 KATEGORIJE';
$string['block09infodesc'] = 'KATEGORIJE - unesite podešavanja za blok 9';
$string['block10caption'] = 'Natpis bloka {$a->block}';
$string['block10captiondesc'] = 'Dodajte natpis za svoj blok';
$string['block10count'] = 'Blok-10 Broj';
$string['block10countdesc'] = 'Izaberite broj blokova i pritisnite dugme "Sačuvaj promene"';
$string['block10design'] = 'Dizajn bloka 10';
$string['block10designdesc'] = 'Izaberite dizajn bloka 10 koji želite da dodate';
$string['block10enabled'] = 'Omogućite blok 10';
$string['block10enableddesc'] = 'Omogućite ili onemogućite blok 10 na vašoj početnoj stranici';
$string['block10header'] = 'Zaglavlje bloka 10';
$string['block10headerdefault'] = 'SVEDOČANSTVA';
$string['block10headerdesc'] = 'Zaglavlje bloka 10';
$string['block10imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block10info'] = '! Blok -10 SVEDOČANSTVA';
$string['block10infodesc'] = 'SVEDOČANSTVA - Unesite podešavanja za blok 10';
$string['block10job'] = 'Blok 10 - posao {$a->block}';
$string['block10jobdesc'] = 'Blok 10 - posao';
$string['block10link'] = 'Blok URL adresa {$a->block}';
$string['block10linkdesc'] = 'Dodajte URL adresu za svoj blok';
$string['block10name'] = 'Blok 10 - naziv {$a->block}';
$string['block10namedesc'] = 'Blok 10 - naziv';
$string['block11caption'] = 'Natpis bloka 11';
$string['block11captiondefault'] = 'Dobrodošli na Almondb blog članke.';
$string['block11captiondesc'] = 'Natpis bloka 11';
$string['block11count'] = 'Blok-11 Broj';
$string['block11countdesc'] = 'Izaberite broj blogova koji će biti prikazan';
$string['block11design'] = 'Dizajn bloka 11';
$string['block11designdesc'] = 'Izaberite dizajn bloka 11 koji želite da dodate';
$string['block11enabled'] = 'Omogućite blok 11';
$string['block11enableddesc'] = 'Omogućite ili onemogućite blok 11 na vašoj početnoj stranici';
$string['block11header'] = 'Zaglavlje bloka 11';
$string['block11headerdefault'] = 'ALMOND BLOG';
$string['block11headerdesc'] = 'Zaglavlje bloka 11';
$string['block11info'] = '! Blok -11 BLOG ČLANAK';
$string['block11infodesc'] = 'BLOG ČLANAK - Unesite podešavanja za blok 11';
$string['block12info'] = '! Blok -12 Prazan';
$string['block13info'] = '! Blok -13 Prazan';
$string['block14info'] = '! Blok -14 Prazan';
$string['block15info'] = '! Blok -15 Prazan';
$string['block16info'] = '! Blok -16 Prazan';
$string['block17info'] = '! Blok -17 Prazan';
$string['block18caption'] = 'Natpis bloka 18';
$string['block18captiondesc'] = 'Natpis bloka 18';
$string['block18css'] = 'Block 18 CSS';
$string['block18cssdesc'] = 'Blok 18 - dodajte CSS za svoj blok';
$string['block18csslink'] = 'Blok 18 - link za CSS';
$string['block18csslinkdesc'] = 'Blok 18 - dodajte link za CSS link za svoj blok';
$string['block18enabled'] = 'Omogućite blok 18';
$string['block18enableddesc'] = 'Omogućite ili onemogućite blok 18 na vašoj početnoj stranici';
$string['block18info'] = '! Blok-18 HTML BLOK';
$string['block18infodesc'] = 'HTML BLOK - Unesite podešavanja za blok 18';
$string['block18title'] = 'Naslov bloka 18';
$string['block18titledesc'] = 'Izaberite dizajn bloka 18 koji želite da dodate';
$string['block19caption'] = 'Natpis bloka 19';
$string['block19captiondefault'] = 'Davno je utvrđena činjenica da će čitalac biti ometen čitljivim sadržajem stranice kada pogleda njen izgled.';
$string['block19captiondesc'] = 'Natpis bloka 19';
$string['block19design'] = 'Dizajn bloka 19';
$string['block19designdesc'] = 'Izaberite dizajn bloka 19 koji želite da dodate';
$string['block19enabled'] = 'Omogućite blok 19';
$string['block19enableddesc'] = 'Omogućite ili onemogućite blok 19 na vašoj početnoj stranici';
$string['block19header'] = 'Zaglavlje bloka 19';
$string['block19headerdefault'] = 'NAŠI PARTNERI';
$string['block19headerdesc'] = 'Zaglavlje bloka 19';
$string['block19headerenabled'] = 'Omogućite zaglavlje bloka 19';
$string['block19headerenableddesc'] = 'Omogućite /onemogućite zaglavlje bloka 19';
$string['block19imgdesc'] = 'Dodajte sliku za svoj blok';
$string['block19info'] = '! Blok -19 BRENDOVI';
$string['block19infodesc'] = 'BRENDOVI - Unesite podešavanja za blok 19';
$string['block19link'] = 'URL adresa slike bloka 19 {$a->block}';
$string['block19linkdesc'] = 'Dodajte URL adresu slike za svoj blok 19';
$string['block20col1caption'] = 'Natpis kolone 1 u bloku 20';
$string['block20col1captiondefault'] = 'Davno je utvrđena činjenica da će čitalac biti ometen čitljivim sadržajem stranice kada pogleda njen izgled.';
$string['block20col1captiondesc'] = 'Natpis kolone 1 u bloku 20';
$string['block20col1header'] = 'Zaglavlje kolone 1 u bloku 20';
$string['block20col1headerdesc'] = 'Zaglavlje kolone 1 u bloku 20';
$string['block20col2header'] = 'Zaglavlje kolone 2 u bloku 20';
$string['block20col2headerdesc'] = 'Unesite zaglavlje kolone 2 u bloku 20';
$string['block20col2link'] = 'Link kolone 2 u bloku 20';
$string['block20col2linkdefault'] = 'O nama|https://themesalmond.com
                                    Naša priča |https://moodle.org/support
                                    Pravila i uslovi|https://moodle.org/
Razvoj
                                    Pravila o privatnosti |http://docs.moodle.org|Moodle Docs
                                    Мапа сајта|http://docs.moodle.org/en|
Dokumentacija na engleskom|en
                                    Moodle.com|http://moodle.com/';
$string['block20col2linkdesc'] = 'Region linkova kolone 2 u bloku 20';
$string['block20col3header'] = 'Zaglavlje kolone 3 u bloku 20';
$string['block20col3headerdesc'] = 'Unesite zaglavlje kolone 3 u bloku 20';
$string['block20col3link'] = 'Linkovi kolone 3 u bloku 20';
$string['block20col3linkdefault'] = 'O nama|https://themesalmond.com
                                    Naša priča |https://moodle.org/support
                                    Pravila i uslovi|https://moodle.org/
Razvoj
                                    Pravila o privatnosti |http://docs.moodle.org|Moodle Docs
                                    Мапа сајта|http://docs.moodle.org/en|
Dokumentacija na engleskom|en
                                    Moodle.com|http://moodle.com/';
$string['block20col3linkdesc'] = 'Region linkova kolone 3 u bloku 20';
$string['block20col4caption'] = 'Natpis kolone 4 u bloku 20';
$string['block20col4captiondefault'] = '<p>Adresa<p>';
$string['block20col4captiondesc'] = 'Unesite natpis kolone 4 u bloku 20';
$string['block20col4header'] = 'Zaglavlje kolone 4 u bloku 20';
$string['block20col4headerdesc'] = 'Unesite zaglavlje kolone 4 u bloku20';
$string['block20copyright'] = 'Blok 20 Autorska prava';
$string['block20copyrightdesc'] = 'Blok 20 Autorska prava';
$string['block20enabled'] = 'Omogućite blok 20';
$string['block20enableddesc'] = 'Omogućite ili onemogućite blok 20 na vašoj početnoj stranici';
$string['block20info'] = '! Blok -20 PODNOŽJE';
$string['block20infodesc'] = 'PODNOŽJE - Unesite podešavanja za blok 20';
$string['block20logo'] = 'Izaberite logotip bloka 20';
$string['block20logodesc'] = 'Izbor logotipa bloka 20';
$string['block20moodle'] = 'Omogućite dugme na naslovnoj stranici';
$string['block20moodledesc'] = 'Omogućite ili onemogućite blok 20 na Moodle originalnj naslovnoj stranici';
$string['block20social'] = 'Blok 20 linkovi društvenih mreža';
$string['block20socialdefault'] = '<ul>
<li><a href="#" target="_blank"><i class="fa fa-facebook-f"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-linkedin"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-instagram"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
</ul>';
$string['block20socialdesc'] = 'Blok 20 linkovi društvenih mreža';
$string['brandcolor'] = 'Brend boja';
$string['brandcolor_desc'] = 'Boja pozadine';
$string['button'] = 'Dugme';
$string['buttonlink'] = 'https://themesalmond.com/';
$string['choosereadme'] = 'Almondb je moderna veoma prilagodljiva tema';
$string['configtitle'] = 'Almondb';
$string['coursesection'] = 'Sekcije kursa';
$string['coursesummary'] = 'Rezime kursa';
$string['dashboardnavchoice'] = 'Navigacija na kontrolnom panelu';
$string['dashboardnavchoicedesc'] = 'Izaberite navigaciju na kontrolnom panelu koja će biti prikazana';
$string['div'] = '</div>';
$string['divdiv'] = '</div></div></div>';
$string['footerbackgroundcolor'] = 'Boja pozadine podnožja';
$string['footerbackgroundcolordesc'] = 'Možete promeniti boju pozadine podnožja';
$string['footerselect'] = 'Kontrolni panel podnožja';
$string['footerselectdesc'] = 'Izaberite stil obrasca kontrolnog panela u podnožju';
$string['frontpagealmondb'] = 'Naslovna stranica';
$string['frontpagechoice'] = 'Izaberite naslovnu stranicu';
$string['frontpagechoicedesc'] = 'Izaberite naslovnu stranicu koja će biti prikazana';
$string['frontpagecolor'] = 'Izaberite podrazumevanu boju naslovne stranice';
$string['frontpagecolordesc'] = '<div class="row pb-3">
                                    <div class="col p-1 text-center" style="background-color:#4272d7;"> 1-#4272d7</div>
                                    <div class="col p-1 text-center" style="background-color:#f98012;"> 2-#f98012</div>
                                    <div class="col p-1 text-center" style="background-color:#fa4251;"> 3-#fa4251</div>
                                    <div class="col p-1 text-center" style="background-color:#c45e28;"> 4-#c45e28</div>
                                    <div class="col p-1 text-center" style="background-color:#63c76a;"> 5-#63c76a</div>
                                    <div class="col p-1 text-center" style="background-color:#024E64;"> 6-#024E64</div>
                                </div>';
$string['frontpagedesc'] = 'Izaberite naslovnu stranicu koja će biti prikazana';
$string['frontpageend'] = '--*/*--';
$string['frontpageenddesc'] = '--*/*--';
$string['frontpageheading'] = '! Izbor naslovne stranice';
$string['frontpageheading1'] = '! Насловна страница СЕКЦИЈЕ';
$string['frontpagenav'] = 'Izbor zaglavlja naslovne stranice';
$string['frontpagenavchoice'] = 'Navigacija na naslovnoj stranici';
$string['frontpagenavchoicedesc'] = 'Izaberite navigaciju na naslovnoj stranici koja će biti prikazana';
$string['frontpagenavdesc'] = 'Izaberite zaglavlje naslovne stranice koje će biti prikazano';
$string['frontpagenavlightdark'] = 'Kontrast navigacione trake na naslovnoj stranici';
$string['frontpagenavlightdarkdesc'] = 'Ako ste iznad izabrali tamnu boju, izaberite "navbar-dark".';
$string['frontpagenavlink'] = 'Linkovi u navigaciji na naslovnoj stranici';
$string['frontpagenavlinkdefault'] = 'Kursevi
-Svi kursevi|/course/
-Pretraga kurseva|/course/search.php|_blank
Blokovi
-Naslovni blok |#block01
-Blok ikonica |#block02
-Funkcije|#block03
-Najnovije|#block04
-Zašto mi|#block05
-Rad sa nama|#block06
-Kurs|#block07
-Predavač|#block08
-Kategorija|#block09
-Svedočanstva |#block10|_self
-Članci bloga |#block11|_self
-HTML blok|#block18|_self
-Brendovi|#block19
-Podnožje|#block20
Predavači|#block08
Blog|/blog/
Dokumentacija|https://themesalmond.com/documents/|_blank';
$string['frontpagenavlinkdesc'] = 'Unesite linkove za navigacionu traku na naslovnoj stranici';
$string['frontpagesection1_1'] = 'Sekcija 1';
$string['frontpagesection1_10'] = 'Sekcija 10';
$string['frontpagesection1_2'] = 'Sekcija 2';
$string['frontpagesection1_3'] = 'Sekcija 3';
$string['frontpagesection1_4'] = 'Sekcija 4';
$string['frontpagesection1_5'] = 'Sekcija 5';
$string['frontpagesection1_6'] = 'Sekcija 6';
$string['frontpagesection1_7'] = 'Sekcija 7';
$string['frontpagesection1_8'] = 'Sekcija 8';
$string['frontpagesection1_9'] = 'Sekcija 9';
$string['frontpagesectiondesc1_1'] = 'Sekcija naslovne stranice 1';
$string['frontpagesectiondesc1_10'] = 'Sekcija naslovne stranice 10';
$string['frontpagesectiondesc1_2'] = 'Sekcija naslovne stranice 2';
$string['frontpagesectiondesc1_3'] = 'Sekcija naslovne stranice 3';
$string['frontpagesectiondesc1_4'] = 'Sekcija naslovne stranice 4';
$string['frontpagesectiondesc1_5'] = 'Sekcija naslovne stranice 5';
$string['frontpagesectiondesc1_6'] = 'Sekcija naslovne stranice 6';
$string['frontpagesectiondesc1_7'] = 'Sekcija naslovne stranice 7';
$string['frontpagesectiondesc1_8'] = 'Sekcija naslovne stranice 8';
$string['frontpagesectiondesc1_9'] = 'Sekcija naslovne stranice 9';
$string['generalsettings'] = 'Opšta podešavanja';
$string['header3phone'] = 'Broj telefona';
$string['header3phonedesc'] = 'Kontakt telefon koji se prikazuje na traci za navigaciju.';
$string['headerlogo'] = 'Izaberite logotip navigacione trake';
$string['headerlogodesc'] = 'Izaberite prikaz logotipa navigacione trake na naslovnoj stranici';
$string['imgloginbackground'] = 'Pozadinska slike stranice za prijavu na sistem';
$string['imgloginbackground_desc'] = 'Pozadinska slike stranice za prijavu na sistem';
$string['loggedinnot'] = 'prijava.';
$string['loginbackgroundimage'] = 'Pozadinska slika stranice za prijavu';
$string['loginbackgroundimage_desc'] = 'Slika koja će biti prikazana kao pozadina stranice za prijavu na sistem.';
$string['loginposition'] = 'Pozicija obrasca za prijavu';
$string['loginpositiondesc'] = 'Izaberite poziciju obrasca za prijavu na ekranu';
$string['navbarcolor'] = 'Boja pozadine navigacione trake';
$string['navbarcolor_desc'] = 'Boja pozadine navigacione trake';
$string['navbarcontainer'] = 'Kontejner navigacijske trake';
$string['navbarcontainerdesc'] = 'Možete ubaciti traku za navigaciju unutar kontejnera';
$string['pluginname'] = 'Almondb';
$string['preset'] = 'Predefinisana podešavanja teme';
$string['preset_desc'] = 'Izaberite skup predefinisanih podešavanja kako biste sveobuhvatno promenili izgled teme.';
$string['presetfiles'] = 'Dodatne datoteke sa predefinisanim podešavanjima teme.';
$string['presetfiles_desc'] = 'Datoteke sa predefinisanim podešavanjima mogu u velikoj meri da izmene izgled teme. Za više informacije o tome kako da kreirate svoje predefinisane datoteke i podelite ih sa drugima pogledajte <a href="https://docs.moodle.org/dev/almondb_Presets">Almondb  predefinisane datoteke </a>. Pogledajte, takođe, <a href="https://archive.moodle.net/almondb">Repozitorijum predefinisanih datoteka</a> za podešavanja koje su drugi korisnici podelili.';
$string['privacy:drawerblockclosed'] = 'Trenutni parametar za fioku sa blokovima je: zatvoreno';
$string['privacy:drawerblockopen'] = 'Trenutni parametar za fioku sa blokovima je: otvoreno';
$string['privacy:drawerindexclosed'] = 'Trenutni parametar za fioku sa indeksom kursa je: zatvoreno';
$string['privacy:drawerindexopen'] = 'Trenutni parametar za fioku sa indeksom kursa je: otvoreno';
$string['privacy:metadata'] = 'Tema Almondb ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['privacy:metadata:preference:draweropenblock'] = 'Korisnički parametar za sakrivanje ili prikazivanje fioke sa blokovima.';
$string['privacy:metadata:preference:draweropenindex'] = 'Korisnički parametar za sakrivanje ili prikazivanje fioke sa indeksom kursa.';
$string['privacy:metadata:preference:draweropennav'] = 'Korisnički parametar za skrivanje ili prikazivanje navigacione fioke sa menijem';
$string['rawscss'] = 'Neobrađen SCSS';
$string['rawscss_desc'] = 'Upotrebite ovo polje kako biste dodali SCSS ili CSS kôd koji će biti dodat na kraj skupa stilova.';
$string['rawscsspre'] = 'Neobrađen inicijalni SCSS';
$string['rawscsspre_desc'] = 'U ovo polje možete da unesete inicijalni SCSS kôd, koji će biti dodata na početak, pre bilo čega drugog. Najčešće ćete koristiti ovo podešavanje za definisanje promenljivih.';
$string['region-side-pre'] = 'Desno';
$string['sitecolor'] = 'Izaberite boju naslovne stranice';
$string['sitecolor-1'] = '#4272d7';
$string['sitecolor-2'] = '#f98012';
$string['sitecolor-3'] = '#fa4251';
$string['sitecolor-4'] = '#c45e28';
$string['sitecolor-5'] = '#63c76a';
$string['sitecolor-6'] = '#024E64';
$string['sitecolor_desc'] = 'Možete odabrati boju koju želite, osim podrazumevane';
$string['slideno'] = '! Slajd-{$a->slide}';
$string['slidenodesc'] = 'Unesite podešavanja za slajd {$a->slide}.';
$string['sliderbutton'] = 'Dugme na slajdu';
$string['sliderbuttondesc'] = 'Unesite link teksta dugmeta na slajdu, koristeći bilo jezički ključ ili tekst. Npr: lang:display ili Display';
$string['sliderbuttonurl'] = 'Link dugmeta na slajdu';
$string['sliderbuttonurldesc'] = 'Unesite odredište linka dugmeta na slajdu';
$string['slidercaption'] = 'Natpis slajda';
$string['slidercaptiondesc'] = 'Dodajte natpis za svoj slajd';
$string['slidercount'] = 'Slajd-šou -  broj';
$string['slidercountdesc'] = 'Izaberite koliko slajdova želite da dodate <strong>zatim kliknite na dugme SAČUVAJ</strong> kako bi se učitala polja za unos podešavanja.';
$string['sliderdesign'] = 'Slajd-šou dizajn';
$string['sliderdesigndesc'] = 'Izaberite dizajn slajda koji želite da dodate';
$string['sliderenabled'] = 'Omogućite slajd-šou';
$string['sliderenableddesc'] = 'Omogućite slajd-šou na vrhu početne stranice';
$string['sliderimage'] = 'Slika slajda';
$string['sliderimageblock02img'] = 'Slika bloka {$a->block}';
$string['sliderimageblock04img'] = 'Slika bloka {$a->block}';
$string['sliderimageblock05img'] = 'Slika bloka';
$string['sliderimageblock06img'] = 'Slika bloka';
$string['sliderimageblock10img'] = 'Slika bloka {$a->block}';
$string['sliderimageblock19img'] = 'Slika bloka 19 {$a->block}';
$string['sliderimagedesc'] = 'Dodajte sliku za svoj slajd. Preporučena veličina je 1500 k 540 piksela ili veća.';
$string['slideropacity'] = 'Projekcija slajdova - neprozirnost';
$string['slideropacitydesc'] = 'Neprozirnost boje na naslovnoj stranici za slajd-šou';
$string['slidershowheight'] = 'Visina slajd-šou prezentacije';
$string['slidershowheight_desc'] = 'Podesite visinu slajd-šou prezentacije na početnoj stranici sajta.';
$string['slidertitle'] = 'Naslov slajda';
$string['slidertitledesc'] = 'Dodajte naslov slajda.';
$string['slideshow'] = 'Slajd-šou';
$string['slideshowend'] = '--*/*--';
$string['slideshowenddesc'] = '--*/*--';
$string['slideshowheading'] = ': Slajd-šou na početnoj stranici';
$string['slideshowheadingdesc'] = 'Ovo kreira slajd-šou od maksimalno šest slajdova za promovisanje važnih elemenat vašeg sajta. Slajd -šou je prilagodljivog dizajna, što znači da se visina slike prilagođava veličini ekrana. Ako nijedna slika nije izabrana za slajd, koriste se podrazumevane slike u direktorijumu pix.';
$string['slideshowstart'] = 'Podešavanja za slajd-šou na početnoj stranici';
$string['slideshowstartdesc'] = '--*/*--';
$string['theme_almondb_frontpageblock'] = 'Blok';
$string['theme_almondb_frontpageblockdesc'] = 'Podešavanje HTML blokova na početnoj stranici';
$string['theme_almondb_frontpageblockend'] = '--*/*--';
$string['theme_almondb_frontpageblockenddesc'] = '--*/*--';
$string['theme_almondb_frontpageblockheading'] = 'Blokovi naslovne stranice';
$string['themesettings'] = 'Podešavanja teme';
$string['totop'] = 'Idi na vrh';
$string['unaddableblocks'] = 'Nepotrebni blokovi';
$string['unaddableblocks_desc'] = 'Navedeni blokovi nisu potrebni kada koristite ovu temu i neće biti navedeni u meniju \'Dodaj blok\'.';
$string['underline'] = '<div style="margin-bottom: 10px; border-bottom:3px solid blue;width:100%;"></div><br>';
