<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'organizer', language 'eu', version '5.0'.
 *
 * @package     organizer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absolutedeadline'] = 'Izen-emateko epearen amaiera';
$string['absolutedeadline_help'] = 'Aktibatu, definitzeko ikasleek zein unetik aurrera ezingo duten ekintzarik burutu';
$string['actionlink_print'] = 'inprimatu';
$string['addappointment'] = 'Gehitu hitzordua';
$string['addslots_placesinfo'] = 'Ekintza honek {$a->numplaces} toki berriak sortuko ditu, guztira {$a->totalplaces} hainbat toki posible osatuz  {$a->numstudents} ikasleentzat.';
$string['addslots_placesinfo_group'] = 'Ekintza honek {$a->numplaces} toki berriak sortuko ditu, guztira {$a->totalplaces} hainbat toki posible osatuz  {$a->numgroups} taldeentzat.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Egun honetatik aurrera erabilgarri egongo da xehetasun eta izen-emate antolatzailea <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Izen-ematearen hasiera';
$string['allowsubmissionsfromdate_help'] = 'Aukeratu antolatzaile hau une jakin batetik aurrera ikasleentzat erabilgarri jartzeko.';
$string['allowsubmissionsfromdatesummary'] = 'Antolatzaile honek hauen izen-emateak onartzen ditu <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Erakutsi beti azalpena';
$string['alwaysshowdescription_help'] = 'Aktibatu ezean, ikasleek soilik "izen-ematearen hasiera-datan" ikusi ahal izango dute zereginaren azalpena.';
$string['applicant'] = 'Honek esan nahi du pertsona honek erregistratu duela taldea';
$string['appointmentcomments'] = 'Iruzkinak';
$string['appointmentcomments_help'] = 'Hemen gehitu daiteke zereginen gaineko informazio osagarria.';
$string['appointmentdatetime'] = 'Data & denbora';
$string['atlocation'] = 'hemen';
$string['availability'] = 'Eskuragarritasuna';
$string['availablefrom'] = 'Balizko-erabilpenak honetarako';
$string['availablefrom_help'] = 'Ezarri ikasleek ordutegi hauek aukeratzeko denbora-epea. Bestela, sakatu "hemendik aurrera" berehalako izen-ematea gaitzeko.';
$string['availablegrouplist'] = 'Talde erabilgarriak';
$string['back'] = 'Atzera';
$string['btn_add'] = 'Gehitu tarte gehiago';
$string['btn_comment'] = 'Editatu iruzkina';
$string['btn_delete'] = 'Ezabatu aukeratutako tarteak';
$string['btn_edit'] = 'Editatu aukeratutako tarteak';
$string['btn_eval'] = 'Kalifikatu aukeratutako tarteak';
$string['btn_eval_short'] = 'Kalifikatu';
$string['btn_print'] = 'Inprimatu aukeratutako tarteak';
$string['btn_queue'] = 'Jarri ilaran';
$string['btn_reeval'] = 'Ebaluatu berriro';
$string['btn_register'] = 'Izena eman';
$string['btn_remind'] = 'Bidali oharpena';
$string['btn_reregister'] = 'Izena eman berriro';
$string['btn_save'] = 'Gorde iruzkina';
$string['btn_send'] = 'Bidali';
$string['btn_unqueue'] = 'Kendu ilaratik';
$string['btn_unregister'] = 'Ezeztatu izen-ematea';
$string['can_reregister'] = 'Berriro izena-eman dezakezu beste hitzordu baterako.';
$string['cannot_eval'] = 'Ezin da ebaluatu, ikasleak badu';
$string['changegradewarning'] = 'Antolatzaileak kalifikatu egin ditu hitzorduak, eta kalifikazioa aldatzeak ez ditu automatikoki berriro kalkulatuko jada badiren kalifikazioak. Berriro kalifikatu behar dituzu dauden hitzorduak, kalifikazioa aldatu nahi baduzu.';
$string['collision'] = 'Erne! Ekitaldi hauek talka egiten dute:';
$string['configabsolutedeadline'] = 'Egungo data eta ordua dira, data eta ordu aukeratzailearen lehenetsitako konpentsazio-baloreak.';
$string['configahead'] = 'aurrera';
$string['configday'] = 'eguna';
$string['configdays'] = 'eguna';
$string['configdigest'] = 'Bidali irakaslearen hurrengo eguneko hitzordu-laburpena.';
$string['configdigest_label'] = 'Bidali onartutako hitzorduak tutoreari';
$string['configdontsend'] = 'Ez bidali';
$string['configemailteachers'] = 'Bidali posta elektroniko bidezko jakinarazpenak irakasleari izen-emateen egoeraren inguruko aldaketekin.';
$string['configemailteachers_label'] = 'Bidali posta elektroniko bidezko jakinarazpenak irakasleei';
$string['confighour'] = 'ordua';
$string['confighours'] = 'orduak';
$string['configintro'] = 'Antolatzaile berrien ezarpenetan erabiliko dira balioak definitzeko hemen erabilitako balio lehenetsiak.';
$string['configlocationlink'] = 'Bilatzaile baten lotura erabiltzen da kokapena erakusteko. Jarri $searchstring kontsultatu nahi duzun URLan.';
$string['configmaximumgrade'] = 'Ezarri antolatzaile berria sortzerakoan erabiliko den kalifikazio-eremuaren lehenetsitako balioa.  Horixe izango da ikasle bati hitzorduarengatik esleituko zaion kalifikaziorik handiena.';
$string['configminute'] = 'minutua';
$string['configminutes'] = 'minutuak';
$string['configmonth'] = 'hilabetea';
$string['configmonths'] = 'hilabeteak';
$string['confignever'] = 'Inoiz ez';
$string['configrelativedeadline'] = 'Erabiltzaileak hitzorduaren aurretik oharpenak jasotzeko lehenetsitako denbora.';
$string['configrequiremodintro'] = 'Aukera hau desgaitu ez badituzu ikasleak jarduera bakoitzaren deskribapena idaztera behartu nahi.';
$string['configweek'] = 'astea';
$string['configweeks'] = 'asteak';
$string['configyear'] = 'urtea';
$string['confirm_conflicts'] = 'Ziur zaude ez duzula talka hau kontuan hartu nahi eta, beraz, denbora-tartea sortu nahi duzula?';
$string['confirm_delete'] = 'Ezabatu';
$string['confirm_organizer_remind_all'] = 'Bidali';
$string['create'] = 'Sortu';
$string['createsubmit'] = 'Sortu denbora-tarteak';
$string['datapreviewtitle'] = 'Datuen Aurreikuspena';
$string['datapreviewtitle_help'] = 'Klikatu [+] or [-] inprimatzeko aurreikuspenean zutabeak ezkutatu edo erakusteko.';
$string['datetemplate'] = '%d.%m.%Y';
$string['day'] = 'eguna';
$string['day_0'] = 'Astelehena';
$string['day_1'] = 'Asteartea';
$string['day_2'] = 'Asteazkena';
$string['day_3'] = 'Osteguna';
$string['day_4'] = 'Ostirala';
$string['day_5'] = 'Larunbata';
$string['day_6'] = 'Igandea';
$string['day_pl'] = 'egunak';
$string['delete_organizer_grades'] = 'Antolatzaile guztien kalifikazioak ezabatzen';
$string['deleteheader'] = 'Tarte hauek ezabatzen:';
$string['deletekeep'] = 'Bertan behera utzi dira hitzordu hauek. Jakinarazi zaie izena emandako ikasleei, eta tarteak ezabatu egin dira:';
$string['deletenoslots'] = 'Ez da aukeratu ezaba daitekeen tarterik';
$string['deleteorganizergrades'] = 'Ezabatu kalifikazioak kalifikazio-liburutik';
$string['downloadfile'] = 'Igo fitxategia';
$string['duedate'] = 'Epea';
$string['duedateerror'] = 'Ezin da ezarri erabateko epe-muga erabilgarritasun-data baino lehenago!';
$string['duration'] = 'Iraupena';
$string['duration_help'] = 'Definitu hitzorduen iraupena. Ezarritako iraupenaren araberako tarteetan banatuko dira definitutako epeak. Gainerako denbora ez da erabiliko (adibidez, denbora markoa 40 minutukoa bada eta 15 minutuko iraupena ezartzen bada,  erabili gabeko 10 minutuko bi tarte agertuko dira).';
$string['edit_submit'] = 'Gauzatu aldaketak';
$string['emailteachers'] = 'Bidali posta elektroniko bidezko jakinarazpenak irakasleei';
$string['emailteachers_help'] = 'Spama saihesteko helburuarekin, denbora-tarte bateko ikaslearen lehen izen-ematearen irakaslearentzako jakinarazpenak ezabatu egiten dira. Aukeratu hau antolatzaileak irakasleentzako posta elektroniko bidezko jakinarazpenak gaitzeko. Kontuan hartu, beti bidaltzen direla izen-ematea bertan behera uztearen eta tarteen aldatzearen jakinarazpenak.';
$string['err_availablefromearly'] = 'Ezin da data hau hasiera-data baino beranduago ezarri!';
$string['err_availablefromlate'] = 'Ezin da data hau amaiera-data baino beranduago ezarri!';
$string['err_availablepastdeadline'] = 'Tarte hau ezin da erabilgarri egon  epe-muga honetatik aurrera ({$a->deadline})!';
$string['err_collision'] = 'Marko honek talka egiten du beste marko hauekin:';
$string['err_comments'] = 'Azalpena idatzi behar duzu!';
$string['err_enddate'] = 'Amaiera-data ezin da hasiera-data baino lehenago ezarri!';
$string['err_fromto'] = 'Amaiera-ordua ezin da hasiera-ordua baino lehenago ezarri!';
$string['err_fullminute'] = 'Iraupena minutu osokoa izan behar du.';
$string['err_fullminutegap'] = 'Tartea minutu osokoa izan behar du.';
$string['err_isgrouporganizer_app'] = 'Ezin da talde-modua aldatu  badaudelako programatutako hitzorduak antolatzaile honetan!';
$string['err_location'] = 'Sartu kokapena!';
$string['err_noslots'] = 'Ez duzu aukeratu tarterik!';
$string['err_posint'] = 'Zenbaki oso bat sartu behar duzu!';
$string['err_startdate'] = 'Ezin da hasiera-data gaurko dataren aurretik ezarri ({$a->now})!';
$string['eval_attended'] = 'Artatua';
$string['eval_feedback'] = 'Feedback';
$string['eval_grade'] = 'Kalifikazioa';
$string['eval_header'] = 'Aukeratu denbora-tarteak';
$string['eval_no_participants'] = 'Tarte honek ez du partehartzailerik';
$string['eval_not_occured'] = 'Tarte hau ez da oraindik burutu';
$string['eval_notify_newappointment:student:fullmessage'] = 'Kaixo, {$a->receivername}:

Ebaluatua izan da, ikastaro honen baitan {$a->courseid} {$a->coursefullname}, honekin {$a->sendername} data {$a->date} ordua {$a->time} hemen {$a->location} zenuen hitzordua.

Ikastaroko irakasleek aukera ematen dizute berriro izena ematea antolatzailean {$a->organizername} libre egon daitekeen beste tarte batean.

Moodle Mezularitza-sistema';
$string['eval_notify_newappointment:student:group:fullmessage'] = 'Kaixo, {$a->receivername}:

Ebaluatua izan da, ikastaro honen baitan {$a->courseid} {$a->coursefullname}, talde honekin {$a->sendername} data {$a->date} ordua {$a->time} hemen {$a->location} zenuen hitzordua.

Ikastaroko irakasleek aukera ematen dizute berriro izena ematea antolatzailean {$a->organizername} libre egon daitekeen beste tarte batean.

Moodle Mezularitza-sistema';
$string['eval_notify_newappointment:student:group:smallmessage'] = 'Ebaluatua izan da data {$a->date} ordu {$a->time} leku {$a->location} honetako talde-hitzordua.';
$string['eval_notify_newappointment:student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] -
Ebaluatutako hitzordua';
$string['eval_notify_newappointment:student:smallmessage'] = 'Ebaluatua izan da data {$a->date} ordu {$a->time} leku {$a->location} honetako hitzordua.';
$string['eval_notify_newappointment:student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Ebaluatutako hitzordua';
$string['evaluate'] = 'Ebaluatu';
$string['eventappointmentadded'] = 'Ikasleen izenak eman tarte baterako.';
$string['eventappointmentcommented'] = 'iruzkinak egin dizkiote hitzorduari.';
$string['eventappointmentevaluated'] = 'Ebaluatua izan da hitzordua.';
$string['eventappointmentlistprinted'] = 'Hitzorduen zerrenda inprimatua.';
$string['eventappointmentremindersent'] = 'Hitzorduaren oharpena bidali.';
$string['eventappointmentremoved'] = 'Ikasleak';
$string['eventappwith:group'] = 'Talde-hitzordua';
$string['eventappwith:single'] = 'Hitzordua';
$string['eventnoparticipants'] = 'ez dago partaiderik';
$string['eventqueueadded'] = 'Itxaron-zerrendara gehitua';
$string['eventqueueremoved'] = 'Itxaron-zerrendatik kendua';
$string['eventregistrationsviewed'] = 'Matrikulazio-fitxaren ikusaldiak.';
$string['eventslotcreated'] = 'Tarte berriak sortu dira.';
$string['eventslotdeleted'] = 'Tartea ezabatu da.';
$string['eventslotupdated'] = 'Tartea eguneratu da.';
$string['eventslotviewed'] = 'Tarteen ikusaldiak.';
$string['eventteacheranonymous'] = 'irakasle anonimoa';
$string['eventtemplate'] = '{$a->courselink} / {$a->organizerlink}: {$a->appwith} {$a->with} {$a->participants}<br />lekua: {$a->location}<br />';
$string['eventtemplatecomment'] = 'Iruzkina:<br />{$a}<br />';
$string['eventtitle'] = '{$a->coursename} / {$a->organizername}: {$a->appwith}';
$string['eventwith'] = 'honekin';
$string['eventwithout'] = 'honekin';
$string['exportsettings'] = 'Esportatu ezarpenak';
$string['font_medium'] = 'ertaina';
$string['font_small'] = 'txikia';
$string['format'] = 'Formatua';
$string['format_csv_comma'] = 'CSV (;)';
$string['format_csv_tab'] = 'CSV (tab)';
$string['format_ods'] = 'ODS';
$string['format_pdf'] = 'PDF';
$string['format_xls'] = 'XLS';
$string['format_xlsx'] = 'XLSX';
$string['fulldatelongtemplate'] = '%A %d. %B %Y';
$string['fulldatetemplate'] = '%a %d.%m.%Y';
$string['fulldatetimelongtemplate'] = '%A %d. %B %Y %H:%M';
$string['fulldatetimetemplate'] = '%a %d.%m.%Y %H:%M';
$string['fullname_template'] = '{$a->firstname} {$a->lastname}';
$string['gap'] = 'Hutsunea';
$string['gap_help'] = 'Bi hitzorduen arteko hutsunea neurtu.';
$string['grade'] = 'Gehieneko kalifikazioa';
$string['grade_help'] = 'Definitu, kalifikatu daitekeen edozein hitzordutan, ezar daitekeen puntuaziorik handiena.';
$string['group_registration_notify:student:queue:group:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} taldea gehitu duzu {$a->groupname} aukerako tarteen zerrendaren zain, data {$a->date} ordu {$a->time} lekua  {$a->location}.

Moodle Mezularitza-sistema';
$string['group_registration_notify:student:queue:group:smallmessage'] = '{$a->sendername} taldea gehitu duzu {$a->groupname} aukerako tarteen zerrendaren zain, data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:queue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Taldea itxaron-zerrendan dago';
$string['group_registration_notify:student:register:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} taldea erregistratu duzu {$a->groupname} denbora-tarte honetarako: data {$a->date} ordua {$a->time} lekua {$a->location}.

Moodle Mezularitza-sistema';
$string['group_registration_notify:student:register:group:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} taldea erregistratu duzu {$a->groupname} denbora-tarte honetarako: data {$a->date} ordua {$a->time} lekua {$a->location}. Moodle Mezularitza-sistema';
$string['group_registration_notify:student:register:group:smallmessage'] = '{$a->sendername} taldea erregistratu duzu {$a->groupname} denbora tarte honetarako;  data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:register:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Taldea erregistratu  da';
$string['group_registration_notify:student:register:smallmessage'] = '{$a->sendername} taldea erregistratu duzu {$a->groupname} denbora tarte honetarako;  data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:register:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Taldea erregistratu da';
$string['group_registration_notify:student:reregister:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} berriro erregistratu duzu taldea {$a->groupname} denbora-tarte berrirako; data {$a->date} ordua {$a->time} lekua {$a->location}.

Moodle Mezularitza-sistema';
$string['group_registration_notify:student:reregister:group:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} berriro erregistratu duzu taldea {$a->groupname} denbora-tarte berrirako; data {$a->date} ordua {$a->time} lekua {$a->location}.

Moodle Mezularitza-sistema';
$string['group_registration_notify:student:reregister:group:smallmessage'] = '{$a->sendername} taldea erregistratu duzu berriro {$a->groupname} denbora-tarte berrirakoa: data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:reregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Talde berriro erregistratu da';
$string['group_registration_notify:student:reregister:smallmessage'] = '{$a->sendername} taldea erregistratu duzu berriro {$a->groupname} denbora-tarte berrirako; data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:reregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Taldea berriro erregistratu da';
$string['group_registration_notify:student:unqueue:group:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} taldea ezabatu duzu {$a->groupname} denbora-tarteen itxaron-zerrendatik: data {$a->date} ordua {$a->time} lekua {$a->location}.

Moodle Messaging System';
$string['group_registration_notify:student:unqueue:group:smallmessage'] = '{$a->sendername} taldea ezabatu duzu {$a->groupname} from the waiting list of the time slot on {$a->date} at {$a->time}.';
$string['group_registration_notify:student:unqueue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Taldea ezabatu da itxaron-zerrendatik';
$string['group_registration_notify:student:unregister:fullmessage'] = 'Kaixo, {$a->receivername}:

Ikastaro honen baitan {$a->courseid} {$a->coursefullname}, {$a->sendername} {$a->groupname} taldearen izen-ematea  deuseztatu duzu denbora-tarte honetarako: data {$a->date} ordua {$a->time} lekua {$a->location}.

Moodle Mezularitza-sistema';
$string['group_registration_notify:student:unregister:group:smallmessage'] = '{$a->sendername} taldearen erregistroa deuseztatu duzu {$a->groupname} denbora-tarte honetarako: data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:unregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Talde-erregistroa deuseztua';
$string['group_registration_notify:student:unregister:smallmessage'] = '{$a->sendername} taldearen erregistroa deuseztatu duzu {$a->groupname} denbora-tarte honetarako: data {$a->date} ordua {$a->time}.';
$string['group_registration_notify:student:unregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Talde-erregistroa desuseztatu da';
$string['group_slot_available'] = 'Tarte erabilgarria';
$string['group_slot_full'] = 'Hartutako tartea';
$string['groupoptions'] = 'Talde-ezarpenak';
$string['grouppicker'] = 'Talde-hautzailea';
$string['groupwarning'] = 'Egiaztatu behean taldearen aukerak!';
$string['headerfooter'] = 'Inprimatu goiburua/orri-oina';
$string['headerfooter_help'] = 'Markatua badago inprimatu goiburua/orri-oina';
$string['hidecalendar'] = 'Ezkutatu egutegia';
$string['hidecalendar_help'] = 'Markatu egutegia ezkutatzeko antolatzaile honetan';
$string['hour'] = 'hr';
$string['hour_pl'] = 'hrs';
$string['id'] = 'ID';
$string['img_title_evaluated'] = 'Ebaluatutako tartea';
$string['img_title_no_participants'] = 'Tarteak ez du partehartzailerik';
$string['img_title_past_deadline'] = 'Tarteak gainditu du epe-muga';
$string['img_title_pending'] = 'Tartea ebaluazioaren zain dago';
$string['infobox_app_countdown'] = 'Hitzordurako falta den denbora: {$a->days} egun, {$a->hours} ordu, {$a->minutes} minutu, {$a->seconds} segundo';
$string['infobox_app_occured'] = 'Hitzordua dagoeneko gertatu da.';
$string['infobox_deadline_countdown'] = 'Epe-mugarako falta den denbora: {$a->days} egunak, {$a->hours} orduak, {$a->minutes} minutuak, {$a->seconds} segundoak';
$string['infobox_deadline_passed'] = 'Igaro da erregistratzeko epe-muga. Ezin duzu izen-ematea aldatu.';
$string['infobox_deadlines_title'] = 'Epe-muga';
$string['infobox_description_title'] = 'Antolatzaile';
$string['infobox_feedback_title'] = 'Feedback';
$string['infobox_group'] = 'Nire taldea: {$a->groupname}';
$string['infobox_messages_title'] = 'Systema-mezuak';
$string['infobox_messaging_title'] = 'Mezularitza-aukerak';
$string['infobox_mycomments_title'] = 'Nire iruzkinak';
$string['infobox_myslot_noslot'] = 'Une honetan ez zaude inongo tartean erregistratua';
$string['infobox_myslot_title'] = 'Nire tartea';
$string['infobox_organizer_expired'] = 'This organizer expired on {$a->date} at {$a->time}';
$string['infobox_organizer_expires'] = 'Antolatzaile hau iraungiko da: data {$a->date} ordua {$a->time}.';
$string['infobox_organizer_never_expires'] = 'Antolatzaile hau ez da iraungiko';
$string['infobox_showfreeslots'] = 'Erakutsi tarte libreak bakarrik';
$string['infobox_showmyslotsonly'] = 'Erakutsi nire tarteak bakarrik';
$string['infobox_showslots'] = 'Erakutsi iragandako tarteak';
$string['infobox_slotoverview_title'] = 'Tarteen ikuspegi orokorra';
$string['infobox_title'] = 'Infobox';
$string['introeditor_error'] = 'Azalpena eman behar du antolatzaileak!';
$string['invalidgrouping'] = 'Talde-multzo baliagarria aukeratu behar duzu!';
$string['isgrouporganizer'] = 'Talde-hitzorduak';
$string['isgrouporganizer_help'] = 'Aukeratu hau antolatzaile hau banakako erabiltzaileen arabera antolatu nahi baduzu (taldeen ordez). Kontuan hartu ez baduzu aukeratzen lagun bat baino gehiagok izena eman ahal izango dutela hitzordu berean.';
$string['location'] = 'Kokapena';
$string['location_help'] = 'Idatzi hitzorduak gertatuko diren kokapenen izenak';
$string['locationlink'] = 'Kokapenaren link URL';
$string['locationlink_help'] = 'Idatzi hemen nahi duzun kokapenari erreferentzia egingo dion web orriaren helbide osoa. Helbideak, kokapen horretara iristeko ezinbesteko informazioa eduki behar du gutxienez. Idatzi helbide osoa, mesedez (http:// barne)';
$string['locationlinkenable'] = 'kokapen-info autolink';
$string['maillink'] = 'Antolatzailea erabilgarri dago <a href="{$a}">here</a>.';
$string['maxparticipants'] = 'Gehieneko parte-hartzaileak';
$string['maxparticipants_help'] = 'Definitu tarte hauetan izena eman dezaketen ikasleen gehieneko kopurua. Taldea bada antolatzailea, bat izango da aukera bakarra.';
$string['message_autogenerated2'] = 'Mezu automatikoa';
$string['message_custommessage'] = 'Mezu pertsonalizatua';
$string['message_custommessage_help'] = 'Erabili atal hau  mezu automatikoari testu pertsonalizatua gehitzeko.';
$string['message_error_slot_full_group'] = 'Denbora-tarte hau hartuta dago!';
$string['message_error_slot_full_single'] = 'Denbora-tarte honek ez du leku librerik!';
$string['message_error_unknown_unqueue'] = 'Ezin da ezabatu itxaron-zerrendako sarrera! Errore ezezaguna.';
$string['message_error_unknown_unregister'] = 'Ezin da ezabatu zure izen-ematea! Errore ezezaguna.';
$string['message_info_reminders_sent_pl'] = '{$a->count} oharpenak bidali dira.';
$string['message_info_reminders_sent_sg'] = '{$a->count} oharpena bidalia.';
$string['message_info_slots_added_pl'] = '{$a->count} tarte berriak gehitu dira.';
$string['message_info_slots_added_sg'] = '{$a->count} tarte berria gehitu da.';
$string['message_warning_no_slots_added'] = 'Ez da tarte berririk gehitu!';
$string['message_warning_no_slots_selected'] = 'Lehenik eta behin, aukeratu tarte bat!';
$string['messageprovider:test'] = 'Antolatzaileko Proba-mezua';
$string['messages_all'] = 'Izen-emate guztiak, berriro izena emandakoak, izen-ematea bertan behera utzitakoak';
$string['messages_none'] = 'Ez dago izen-ematearen jakinarazpenik';
$string['messages_re_unreg'] = 'Berriro izena emandakoak eta izen-ematea bertan behera utzitakoak soilik';
$string['min'] = 'min';
$string['min_pl'] = 'mins';
$string['modformwarningplural'] = 'Eremu hauek ezin dira editatu antolatzailean dagoeneko burutu diren hitzorduei dagozkielako!';
$string['modformwarningsingular'] = 'Eremu hau ezin da editatu antolatzailean dagoeneko burutu diren hitzorduei dagokielako!';
$string['modulename'] = 'Antolatzailea';
$string['modulename_help'] = 'Gaitu antolatzaileak irakasleek ikasleekin hitzorduak egiteko, eta ikasleek izena eman dezaketen denbora-tarteak sortzeko. ikasleek ien';
$string['modulenameplural'] = 'Antolatzaileak';
$string['multimember'] = 'Erabilzaileek ezin dute talde-multzo bereko talde bat baino gehiagoko kide izan!';
$string['multimemberspecific'] = 'Erabiltzailea {$a->username} {$a->idnumber} talde bat baino gehiagoko kide da! ({$a->groups})';
$string['multipleappointmentenddate'] = 'Amaiera-data';
$string['multipleappointmentstartdate'] = 'Hasiera-data';
$string['mymoodle_attended'] = '{$a->attended}/{$a->total} ikasleek hitzordu bat burutu dute';
$string['mymoodle_attended_group'] = '{$a->attended}/{$a->total} taldeek hitzordu bat burutu dute';
$string['mymoodle_attended_group_short'] = '{$a->attended}/{$a->total} bete duten taldeak';
$string['mymoodle_attended_short'] = '{$a->attended}/{$a->total} bete duten ikasleak';
$string['mymoodle_completed_app'] = 'Zure hitzordua burutu duzu eguna {$a->date} ordua {$a->time}';
$string['mymoodle_completed_app_group'] = 'Zure taldea {$a->groupname} hitzordura agertu da data {$a->date} ordua {$a->time}';
$string['mymoodle_missed_app'] = 'Ez zara hitzordura agertu, eguna  {$a->date} ordua {$a->time}';
$string['mymoodle_missed_app_group'] = 'Zure taldea {$a->groupname} ez da hitzordura agertu, data {$a->date} ordua {$a->time}';
$string['mymoodle_next_slot'] = 'Hurrengo tartea, data {$a->date} ordua {$a->time}';
$string['mymoodle_no_reg_slot'] = 'Ez duzu izena eman inongo denbora-tartean';
$string['mymoodle_no_reg_slot_group'] = 'Zure taldeak {$a->groupname} ez du izena eman inongo denbora-tartean';
$string['mymoodle_no_slots'] = 'Ez dago beste tarterik';
$string['mymoodle_organizer_expired'] = 'Antolatzaile hau iraungi egin da, data {$a->date} ordua {$a->time}. Jada ezingo duzu erabili';
$string['mymoodle_organizer_expires'] = 'Antolatzaile hau iraungiko da, data {$a->date} ordua {$a->time}';
$string['mymoodle_pending_app'] = 'Oraindik ebaluatu gabe daude zure hiztorduak';
$string['mymoodle_pending_app_group'] = 'Oraindik ebaluatu gabe dago zure taldearen  {$a->groupname} hitzordua';
$string['mymoodle_registered'] = '{$a->registered}/{$a->total} ikasleek izena eman dute hitzorduren batean';
$string['mymoodle_registered_group'] = '{$a->registered}/{$a->total} taldeek izena eman dute hitzorduren batean';
$string['mymoodle_registered_group_short'] = '{$a->registered}/{$a->total} izena emandako taldeak';
$string['mymoodle_registered_short'] = '{$a->registered}/{$a->total} izena emandako ikasleak';
$string['mymoodle_upcoming_app'] = 'Zure hitzordua burutuko da, eguna  {$a->date} ordua {$a->time} lekua {$a->location}';
$string['mymoodle_upcoming_app_group'] = 'Zure taldearen hitzordua burutuko da, eguna  {$a->date} ordua {$a->time} lekua {$a->location}';
$string['newslot'] = 'Beste tarte bat';
$string['no_due_my_slots'] = 'Iraungi dira zure denbora-tarte guztiak antolatzaile honetarako';
$string['no_due_slots'] = 'Iraungi dira antolatzaile honetan sortutako denbora-tarte guztiak';
$string['no_my_slots'] = 'Ez duzu tarterik sortu antolatzaile honetan';
$string['no_slots'] = 'Ez da sortu denbora-tarterik antolatzaile honetan';
$string['no_slots_defined'] = 'Une honetan ez dago hitzordu-tarte erabilgarririk';
$string['no_slots_defined_teacher'] = 'Ez dago hitzordu-tarterik agerian une honetan. Klikatu<a href="{$a->link}">here</a> baten bat sortzeko.';
$string['nogroup'] = 'Talderik ez';
$string['noparticipants'] = 'Partehartzailerik ez';
$string['noslots'] = 'Ez dago tarterik';
$string['notificationtime'] = 'Hitzordu erlatiboaren oharpena';
$string['notificationtime_help'] = 'Definitu  hartutako hitzorduaren aurreko zein unetan jasoko den oharpena.';
$string['numentries'] = 'Erakutsi sarrerak orrialdeko';
$string['numentries_help'] = 'Partehartzaile askok izena eman badu zure ikastaroan, aukeratu "ezin-hobea" testu-tamaina eta orientazioaren arabera sarerra zerrenda optimizatzeko.';
$string['organizer'] = 'Antolatzailea';
$string['organizer:addinstance'] = 'Gehitu antolatzaile berria';
$string['organizer:addslots'] = 'Gehitu denbora-tarte berriak';
$string['organizer:comment'] = 'Gehitu iruzkinak';
$string['organizer:deleteslots'] = 'Ezabatu badiren denbora-tarteak';
$string['organizer:editslots'] = 'Editatu badiren denbora-tarteak';
$string['organizer:evalslots'] = 'Kalifikatu osatutako denbora-tarteak';
$string['organizer:printslots'] = 'Inprimatu badiren denbora-tarteak';
$string['organizer:receivemessagesstudent'] = 'Jaso ikasleei bidalitako mezuak';
$string['organizer:receivemessagesteacher'] = 'Jaso irakasleei bidalitako mezuak';
$string['organizer:register'] = 'Izena eman denbora-tarte baterako';
$string['organizer:sendreminders'] = 'Bidali izen-ematearen oharpena ikasleei';
$string['organizer:unregister'] = 'Bertan behera utzi denbora-tarte baterako izen-ematea';
$string['organizer:viewallslots'] = 'Ikusi denbora-tarte guztiak irakasle gisara';
$string['organizer:viewmyslots'] = 'Ikusi denbora-tarte hauek irakasle gisara';
$string['organizer:viewregistrations'] = 'Ikusi ikasleen izen-emateen egoera';
$string['organizer:viewstudentview'] = 'Ikusi denbora-tarte guztiak ikasle gisara';
$string['organizer_remind_all_no_recepients'] = 'Ez dago jasotzaile baliagarririk.';
$string['organizer_remind_all_recepients_pl'] = 'Mezu hauek {$a->count} bidali zaizkie hurrengo hartzaileei:';
$string['organizer_remind_all_recepients_sg'] = 'Mezu hauek {$a->count} bidali zaizkie hurrengo hartzaileei:';
$string['organizer_remind_all_title'] = 'Bidali oharpena';
$string['organizercommon'] = 'Antolatu ezarpenak';
$string['organizername'] = 'Antolatzailearen izena';
$string['orientationlandscape'] = 'paisaia';
$string['orientationportrait'] = 'erretratua';
$string['otherheader'] = 'Bestelakoa';
$string['pageorientation'] = 'Orri-orientazioa';
$string['pdf_notactive'] = 'Ez dago erabilgarri';
$string['pdfsettings'] = 'PDF ezarpenak';
$string['places_inqueue'] = '{$a->inqueue} bilaketa-zerrendan';
$string['places_inqueue_withposition'] = '{$a->queueposition}. itxaron-zerrendako posizioa';
$string['places_taken_pl'] = '{$a->numtakenplaces}/{$a->totalplaces} hartu lekuak';
$string['places_taken_sg'] = '{$a->numtakenplaces}/{$a->totalplaces} hartu lekua';
$string['pluginadministration'] = 'Antolatzailearen administrazioa';
$string['pluginname'] = 'Antolatzailea';
$string['print_return'] = 'Itzuli tareen ikuspegi orokorrera';
$string['printout'] = 'Inprimatu';
$string['printpreview'] = 'Inprimatu aurreikuspena (lehen 10 sarrerak)';
$string['printsubmit'] = 'Zabaldu taula inprimagarria';
$string['queue'] = 'Itxaron-ilarak';
$string['queue_help'] = 'Erabiltzaileek denbora-tarte batean izena emateko erabil dezaketen itxaron-ilara kopurua, nahiz eta erabiltzaile-kopurua gainditu.
Erabiltzaileak itxaron-ilarara gehituko dira eta tarte bat esleituko zaie (ordenean), tarte eskuragarri bat sortu bezain laster.';
$string['recipientname'] = '&lt;recipient name&gt;';
$string['reg_status'] = 'Izen-ematearen egoera';
$string['reg_status_not_registered'] = 'Ez duzu izenik eman';
$string['reg_status_organizer_expired'] = 'Iraungitako antolatzailea';
$string['reg_status_registered'] = 'Izena emanda';
$string['reg_status_slot_attended'] = 'Artatua';
$string['reg_status_slot_available'] = 'Tarte erabilgarria';
$string['reg_status_slot_expired'] = 'Iraungitako tartea';
$string['reg_status_slot_full'] = 'Huts-egindako tartea';
$string['reg_status_slot_not_attended'] = 'Ez zen agertu';
$string['reg_status_slot_past_deadline'] = 'Tarteak epe-muga gainditu du';
$string['reg_status_slot_pending'] = 'Ebaluazioaren zain dagoen tartea';
$string['relative_deadline_before'] = 'Hitz-orduaren aurretik';
$string['relative_deadline_now'] = 'Hemendik aurrera';
$string['relativedeadline'] = 'Epe-muga erlatiboa';
$string['relativedeadline_help'] = 'Ezarri tarte jakin baterako epe-muga zehaztutako denboraren aurretik. Ikasleeek ezingo dute izena eman edo izen-ematea aldatu, behin epea amaituta.';
$string['remindall_desc'] = 'Bidali jakinarazpena inongo hitzordurik ez duten iaksle guztiei';
$string['requiremodintro'] = 'Beharrezkoa du jarduera-deskribapena';
$string['reset_organizer_all'] = 'Ezabatu tarteak, hitzorduak eta haiei lotutako ekitaldiak';
$string['resetorganizerall'] = 'Ezabatu antolatzaileko data guztiak ( tarteak & hitzorduak)';
$string['reviewsubmit'] = 'Berrikusi denbora-tarteak';
$string['rewievslotsheader'] = 'Berrikusi denbora-tarteak';
$string['sec'] = 'sec';
$string['sec_pl'] = 'secs';
$string['select_all_slots'] = 'Aukeratu tarte ikusgarri guztiak';
$string['selectedgrouplist'] = 'Aukeratu taldeak';
$string['slot_anonymous'] = 'Tarte anonimoa';
$string['slot_slotvisible'] = 'Kideak bakarrik ikus daitezke haien tartea bada';
$string['slot_visible'] = 'Tarte-kideak beti ikusgarri';
$string['slotdetails'] = 'Tarte-xehetasunak';
$string['slotfrom'] = 'hemendik';
$string['slotperiodendtime'] = 'Amaiera-data';
$string['slotperiodheader'] = 'Sortu tarteak epe honetarako';
$string['slotperiodheader_help'] = 'Zehaztu eguneroko denbora-markoetan (atalak) aplikatuko diren hasiera eta amaiera-datak.';
$string['slotperiodstarttime'] = 'Hasiera-data';
$string['slottimeframesheader'] = 'Denbora-tarte jakinak';
$string['slottimeframesheader_help'] = 'Atal honek aukera emango dizu denbora-markoak aste-egunaren arabera definitzeko. Marko horiek aurretik zehaztutako ezaugarrien araberako hitzordu-tarteekin osatuko dira. Marko bana, gehienez, eguneko. Denbora-marko bat astelehenarekin aukeratzen bada, handik aurrerako astelehen guztietarako denbora-tarteak sortuko ditu, hasiera eta amaiera-daten artean (biak barne).';
$string['slotto'] = 'Honentzat';
$string['status_no_entries'] = 'Antolatzaile honek ez dio inongo ikasleri izena eman';
$string['stroptimal'] = 'Ezinhobea';
$string['studentcomment_title'] = 'Ikasle-iruzkinak';
$string['taballapp'] = 'Hitzorduak';
$string['tabstatus'] = 'Izen-ematearen egoera';
$string['tabstud'] = 'Ikasle-ikuspegia';
$string['teacher'] = 'Irakaslea';
$string['teacher_unchanged'] = '-- unchanged --';
$string['teachercomment_title'] = 'Irakasle-iruzkinak';
$string['teacherfeedback_title'] = 'Irakaslearen feedbacka';
$string['teacherid'] = 'Irakaslea';
$string['teacherid_help'] = 'Aukeratu hitzorduetarako irakaslea';
$string['teacherinvisible'] = 'Ezin da irakaslea ikusi';
$string['teachervisible'] = 'Irakaslea ikusgai';
$string['teachervisible_help'] = 'Aukeratu hau, ikasleek denbora-tarte honekin lotutako irakasleak ikusteko.';
$string['textsize'] = 'Testu-tamaina';
$string['th_actions'] = 'Ekintza';
$string['th_appdetails'] = 'Xehetasunak';
$string['th_attended'] = 'Erantsi.';
$string['th_comments'] = 'Iruzkinak';
$string['th_datetime'] = 'Data & ordua';
$string['th_datetimedeadline'] = 'Data & ordua';
$string['th_details'] = 'Egoera';
$string['th_duration'] = 'Iraupena';
$string['th_email'] = 'Helbide elektronikoa';
$string['th_evaluated'] = 'Ebaluazioa';
$string['th_feedback'] = 'Feedback';
$string['th_firstname'] = 'Izena';
$string['th_grade'] = 'Kalifikazioa';
$string['th_group'] = 'Taldea';
$string['th_groupname'] = 'Taldea';
$string['th_idnumber'] = 'ID zenbakia';
$string['th_lastname'] = 'Abizena';
$string['th_location'] = 'Kokapena';
$string['th_participant'] = 'Parte-hartzailea';
$string['th_participants'] = 'Parte-hartzaileak';
$string['th_status'] = 'Egoera';
$string['th_teacher'] = 'Irakaslea';
$string['timeshift'] = 'Erabateko epe-muga aldatzen';
$string['timetemplate'] = '%H:%M';
$string['title_add'] = 'Gehitu hitzordu-tarte berriak';
$string['title_comment'] = 'Editatu zure iruzkinak';
$string['title_delete'] = 'Ezabatu aukeratutako denbora-tarteak';
$string['title_edit'] = 'Editatu aukeratutako denbora-tarteak';
$string['title_eval'] = 'Ebaluatu aukeratutako denbora-tarteak';
$string['title_print'] = 'Inprimatu tarteak';
$string['totalslots'] = 'hemendik {$a->starttime} hona {$a->endtime}, {$a->duration} {$a->unit} each, {$a->totalslots} tartea(k) guztira';
$string['unavailableslot'] = 'Tarte hau erabilgarri dago hemendik aurrera';
$string['unknown'] = 'Ezezaguna';
$string['visibility'] = 'Kideen ikusgarritasuna - aurre-ezarpena';
$string['visibility_all'] = 'Ikusgarri';
$string['visibility_anonymous'] = 'Anonimoa';
$string['visibility_help'] = 'Definitu defektuzko ikusgarritasun-aukerak tarte berria sortzerakoan <br/><b>Anonimoa:<b/> Ezin dira ikusi tarte-kideak.<br/><b>IKusgarria:</b> Guztiok ikus dizateke tarte-kideak.<br/><b>Tarte-kideentzat ikusgarri soilik:</b> Bakarrik tarte-kideek ikus ditzakete besteak.';
$string['visibility_slot'] = 'Soilik tarte-kideentzat ikusgarri';
$string['warning_groupingid'] = 'Talde-modua indarrean. Baliozko talde-multzoren bat aukeratu behar duzu.';
$string['warninggroupmode'] = 'Talde-modua aukeratu beharko zenuke, eta talde-multzoren bat aukeratu talde-antolatzailea sortzeko.';
$string['warningtext1'] = 'Aukeratutako tarteek balore ezberdinak dituzte eremu honetarako!';
$string['warningtext2'] = 'ERNE! Aldatu egin da eremu honetako edukia!';
