<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'uk', version '5.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Дія';
$string['addedandupdatedpp'] = 'Додані {$a->%new} нові H5P бібліотекі та оновлено {$a->%old} існуючих.';
$string['addedandupdatedps'] = 'Додані {$a->%new} нові H5P бібліотекі та оновлена {$a->%old} існуюча.';
$string['addedandupdatedsp'] = 'Додана {$a->%new} нова H5P бібліотека та оновлено {$a->%old} існуючих.';
$string['addedandupdatedss'] = 'Додана {$a->%new} нова H5P бібліотека та оновлена {$a->%old} існуюча.';
$string['addednewlibraries'] = 'Додані {$a->%new} нових H5P бібліотек.';
$string['addednewlibrary'] = 'Додана {$a->%new} нова H5P бібліотека.';
$string['additionalinfo'] = 'Додаткова інформація';
$string['additionallicenseinfo'] = 'Будь-яка додаткова інформація про ліцензію';
$string['addlibraries'] = 'Додати бібліотекі';
$string['ajaxfailed'] = 'Не вдалося завантажити дані.';
$string['anunexpectedsave'] = 'Сталося щось несподіване. Нам не вдалося зберегти цей контент.';
$string['attribution'] = 'Ліцензія із зазначенням авторства 4.0';
$string['attributionnc'] = 'Ліцензія із зазначенням авторства-Некомерційна 4.0';
$string['attributionncnd'] = 'Ліцензія із зазначенням авторства-Некомерційна-Без похідних 4.0';
$string['attributionncsa'] = 'Ліцензія із зазначенням авторства-Некомерційна-Із збереженням умов 4.0';
$string['attributionnd'] = 'Ліцензія із зазначенням авторства-Без похідних 4.0';
$string['attributionsa'] = 'Ліцензія із зазначенням авторства-Із збереженням умов 4.0';
$string['author'] = 'Автор';
$string['authorcomments'] = 'Коментарі автора';
$string['authorcommentsdescription'] = 'Коментарі для редактора контенту (Цей текст не буде опублікований як частина інформації про авторські права)';
$string['authorname'] = 'Ім\'я автора';
$string['authorrole'] = 'Роль автора';
$string['by'] = 'від';
$string['cancellabel'] = 'Закінчити';
$string['ccattribution'] = 'Ліцензія із зазначенням авторства (CC BY)';
$string['ccattributionnc'] = 'Ліцензія із зазначенням авторства - Некомерційна (CC BY-NC)';
$string['ccattributionncnd'] = 'Ліцензія із зазначенням авторства - Без похідних (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Ліцензія із зазначенням авторства - Некомерційна - Із збереженням умов (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Ліцензія із зазначенням авторства - Без похідних (CC BY-ND)';
$string['ccattributionsa'] = 'Ліцензія із зазначенням авторства - Із збереженням умов (CC BY-SA)';
$string['ccpdd'] = 'Публічна ліцензія (CC0)';
$string['ccpdm'] = 'Суспільне надбання (PDM)';
$string['changedby'] = 'Змінено';
$string['changedescription'] = 'Опис змін';
$string['changelog'] = 'Перелік змін';
$string['changeplaceholder'] = 'Фото обрізане, текст змінено тощо';
$string['close'] = 'Закрити';
$string['completionpass'] = 'Прохідний бал, який потрібно набрати';
$string['completionpass_help'] = 'Якщо ввімкнено, ця вправа вважається завершеною, коли студент отримує прохідний бал (як зазначено в розділі «Бал» налаштувань активності H5P) або вище.';
$string['completionpassdesc'] = 'Студент повинен отримати прохідний бал, щоб виконати цю вправу';
$string['confirmdialogbody'] = 'Підтвердьте, що хочете продовжити. Ця дія не може бути відмінена.';
$string['confirmdialogheader'] = 'Підтвердити дію';
$string['confirmlabel'] = 'Підтвердити';
$string['connectionlost'] = 'З’єднання втрачено. Результати будуть збережені та надіслані після відновлення зв’язку.';
$string['connectionreestablished'] = 'З’єднання відновлено.';
$string['contentchanged'] = 'Цей контент змінився з моменту останнього використання.';
$string['contentcopied'] = 'Контент скопійовано в буфер обміну';
$string['contentstatefrequency'] = 'Періодичність збереження стану контенту';
$string['contentstatefrequency_help'] = 'В секундах, як часто ви хочете, щоб користувач автоматично зберігав свій прогрес. Збільште це число, якщо у вас виникли проблеми з кількістю запитів ajax';
$string['contenttype'] = 'Тип контенту';
$string['contenttypecacheheader'] = 'Кеш типу контенту';
$string['copyright'] = 'Права на використання';
$string['copyrightinfo'] = 'Інформація про авторські права';
$string['copyrightstring'] = 'Авторське право';
$string['copyrighttitle'] = 'Переглянути інформацію про авторські права на цей контент.';
$string['couldnotcopy'] = 'Не вдалося скопіювати файл.';
$string['couldnotparsejsonfromzip'] = 'Неможливо проаналізувати JSON із пакету: %fileName';
$string['couldnotparsepostdata'] = 'Не вдалося проаналізувати дані публікації.';
$string['couldnotreadfilefromzip'] = 'Не вдається прочитати файл із пакету: %fileName';
$string['couldnotsave'] = 'Не вдалося зберегти файл.';
$string['create'] = 'Створити';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Оновити кеш типу контенту';
$string['ctcacheconnectionfailed'] = 'Не вдалося зв’язатися з H5P Hub. Будь-ласка спробуйте пізніше.';
$string['ctcachedescription'] = 'Переконайтесь, що кеш типу контенту оновлений. Таким чином ви зможете переглядати, завантажувати та використовувати найновіші бібліотеки. Ця дія відрізняється від оновлення самих бібліотек.';
$string['ctcachelastupdatelabel'] = 'Останнє оновлення';
$string['ctcacheneverupdated'] = 'Ніколи';
$string['ctcachenolibraries'] = 'Типи контенту не отримані від H5P Hub. Будь-ласка спробуйте пізніше.';
$string['ctcachesuccess'] = 'Кеш бібліотеки успішно оновлений!';
$string['ctcachetaskname'] = 'Оновлення кеша типу контенту';
$string['currentpage'] = 'Сторінка $current із $total';
$string['dataviewreportlabel'] = 'Переглянути відповіді';
$string['date'] = 'Дата';
$string['disablefileextensioncheck'] = 'Відключити перевірку розширення файлу';
$string['disablefileextensioncheckwarning'] = 'Увага! Відключення перевірки розширення файлу може мати наслідки для безпеки, оскільки це дозволяє завантажувати php-файли. Це, в свою чергу, може дати можливість зловмисникам виконувати шкідливий код на вашому сайті. Переконайтесь, що ви точно знаєте, що завантажуєте.';
$string['disablefullscreen'] = 'Вимкнути повноекранний режим';
$string['disablehubconfirmationmsg'] = 'Ви все ще хочете ввімкнути HUB?';
$string['disablehubdescription'] = 'Настійно рекомендуємо залишити цю опцію увімкненою. H5P Hub забезпечує простий інтерфейс для отримання нових типів контенту та постійного оновлення існуючих типів контенту. У майбутньому це також полегшить спільний доступ та повторне використання контенту. Якщо цю опцію вимкнено, вам доведеться встановлювати та оновлювати типи контенту за допомогою форм для завантаження файлів.';
$string['displayoptionalwaysshow'] = 'Показувати завжди';
$string['displayoptionauthoroff'] = 'Контролюється автором, за замовчуванням вимкнено';
$string['displayoptionauthoron'] = 'Контролюється автором, за замовчуванням ввімкнено';
$string['displayoptiondownloadalways'] = 'Завжди';
$string['displayoptiondownloadnever'] = 'Ніколи';
$string['displayoptiondownloadpermission'] = 'Тільки якщо користувач має права для експорту Н5Р';
$string['displayoptionnevershow'] = 'Ніколи не показувати';
$string['displayoptionpermissions'] = 'Показувати тільки якщо користувач має права для експорту Н5Р';
$string['displayoptionpermissionsembed'] = 'Показувати тільки якщо користувач має права для вбудовування Н5Р';
$string['displayoptions'] = 'Параметри відображення';
$string['download'] = 'Завантажити';
$string['downloadfailed'] = 'Не вдалося завантажити запитану бібліотеку.';
$string['downloadtitle'] = 'Завантажте цей контент як файл H5P.';
$string['editor'] = 'Редактор';
$string['emailconfirmbody'] = 'Привіт, {$a->username},

Дякуємо вам за надання відповідей на \'{$a->hvpname}\' в курсі \'{$a->coursename}\'.

Це повідомлення підтверджує збереження ваших відповідей.

Ви можете отримати доступ до цього H5P за посиланням {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Дякуємо, що надіслали свої відповіді на \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Підтвердження подання: {$a->hvpname}';
$string['emailnotifybody'] = 'Привіт, {$a->username},

{$a->studentname} завершив (-ла) \'{$a->hvpname}\' ({$a->hvpurl}) із курсу \'{$a->coursename}\'.

Ви можете переглянути результати спроби за посиланням {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} завершив (-ла) {$a->hvpname}. Дивись {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} завершив (-ла) {$a->hvpname}';
$string['embed'] = 'Вбудувати';
$string['embedloginfailed'] = 'Ви не маєте доступу до цього контенту. Спробуйте увійти.';
$string['embedtitle'] = 'Переглянути вбудований код цього контенту.';
$string['empty'] = 'Результати відсутні';
$string['enableabout'] = 'Про кнопку H5P';
$string['enablecopyright'] = 'Кнопка авторських прав';
$string['enabledlrscontenttypes'] = 'Увімкнути залежні від LRS типи контенту';
$string['enabledlrscontenttypes_help'] = 'Дає можливість використовування та функціонування типів контенту, залежних від LRS (сховище навчальних записів), таких як тип контенту Questionnaire';
$string['enabledownload'] = 'Дозволити завантаження';
$string['enableembed'] = 'Кнопка вбудовування';
$string['enableframe'] = 'Відображати панелі дій та кадру';
$string['enablehublabel'] = 'Використовувати H5P Hub';
$string['enablejavascript'] = 'Будь ласка, дозвольте використання JavaScript.';
$string['enablesavecontentstate'] = 'Зберегти стан контенту';
$string['enablesavecontentstate_help'] = 'Автоматично зберігати поточний стан інтерактивного контенту для кожного користувача. Це означає, що користувач може продовжити з того міста, де зупинився.';
$string['failedtodownloadh5p'] = 'Не вдалося завантажити запитаний H5P.';
$string['fileexceedsmaxsize'] = 'Один із файлів всередині пакету перевищує максимально дозволений розмір файлу. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Файл не знайдений на сервері. Перевірте налаштування завантаження файлів.';
$string['filenotimage'] = 'Файл не є зображенням.';
$string['filetypenotallowed'] = 'Цей тип файлу заборонено.';
$string['finished'] = 'Завершено';
$string['fullscreen'] = 'Повноекранний режим';
$string['gpl'] = 'General Public License v3';
$string['gradetopassmustbeset'] = 'Оцінка для проходження не може бути нульовою, оскільки для цього завдання H5P метод завершення встановлений таким, що вимагає проходний бал. Будь ласка, встановіть ненульове значення.';
$string['gradetopassnotset'] = 'Це завдання Н5Р ще не має визначеного прохідного балу. Він може бути встановлений в розділі "Оцінка" налаштувань завдання Н5Р';
$string['h5pfile'] = 'Файл Н5Р';
$string['h5ptitle'] = 'Завітайте на H5P.org, щоб перевірити ще цікавий контент.';
$string['hide'] = 'Приховати';
$string['hideadvanced'] = 'Приховати розширений';
$string['hubcommunicationdisabled'] = 'Зв\'язок з  H5P Hub вимкнено, оскільки не вдалося виконати одну або кілька вимог H5P.';
$string['hubisdisabled'] = 'H5P Hub відключений. Ви можете знову включити його в налаштуваннях H5P.';
$string['hubisdisableduploadlibraries'] = 'H5P Hub був вимкнений, доки ця проблема не буде вирішина. Ви все ще можете завантажувати бібліотеки через сторінку "Бібліотеки H5P".';
$string['hubsettingsheader'] = 'Типи контенту';
$string['hvp:addinstance'] = 'Створити нове завдання Н5Р';
$string['hvp:emailconfirmsubmission'] = 'Отримувати повідомлення про підтвердження під час надсилання';
$string['hvp:emailnotifysubmission'] = 'Отримувати повідомлення, що спроба надіслана';
$string['hvp:getcachedassets'] = 'Необхідно для перегляду завдань H5P';
$string['hvp:getembedcode'] = 'Переглядати вбудований код H5P, якщо встановлено параметр "контролюється дозволом"';
$string['hvp:getexport'] = 'Завантажувати файл .h5p, якщо встановлено параметр "контролюється дозволом"';
$string['hvp:installrecommendedh5plibraries'] = 'Встановлювати нові безпечні типи контенту H5P, рекомендовані H5P.org';
$string['hvp:manage'] = 'Редагувати існуючі завдання H5P';
$string['hvp:restrictlibraries'] = 'Обмежити доступ до певних типів контенту H5P';
$string['hvp:savecontentuserdata'] = 'Зберегти прогрес користувача для завдань H5P';
$string['hvp:saveresults'] = 'Зберегти результати завершених завдань H5P';
$string['hvp:updatelibraries'] = 'Встановлювати нові типи контенту H5P або оновлювати існуючі';
$string['hvp:userestrictedlibraries'] = 'Використовувати обмежені типи контенту H5P';
$string['hvp:view'] = 'Переглядати та взаємодіяти з завданнями H5P';
$string['hvp:viewallresults'] = 'Переглянути всі результати для завершених завдань H5P';
$string['hvp:viewresults'] = 'Переглянути власні результати для завершених завдань H5P';
$string['installdenied'] = 'Ви не маєте дозволу встановлювати типи контенту. Зверніться до адміністратора вашого сайту.';
$string['installedlibraries'] = 'Встановлені бібліотеки';
$string['intro'] = 'Введення';
$string['invalidaudioformat'] = 'Неприпустимий формат аудіофайлу. Використовуйте mp3 або wav.';
$string['invalidcontentfolder'] = 'Невірна папка контенту';
$string['invalidcontenttype'] = 'Обраний тип контенту є неприпустимим.';
$string['invalidfieldtype'] = 'Неприпустимий тип поля.';
$string['invalidfile'] = 'Файл "{$a->%filename}" заборонено. Допускаються лише файли з такими розширеннями: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Не вдалося отримати надісланий H5P.';
$string['invalidimageformat'] = 'Неприпустимий формат файлу зображення. Використовуйте jpg, png або gif.';
$string['invalidlanguagefile'] = 'Неприпустимий мовний файл {$a->%file} у бібліотеці {$a->%library}';
$string['invalidlanguagefile2'] = 'Неипустимий мовний файл {$a->%languageFile} включено до бібліотеки {$a->%name}';
$string['invalidlibrary'] = 'Неприпустима бібліотека';
$string['invalidlibrarydata'] = 'Неприпустимі дані для {$a->%property} у {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Неприпустимі дані для {$a->%property} у {$a->%library}. Очікується булеве значення.';
$string['invalidlibraryname'] = 'Неприпустима назва бібліотеки: {$a->%name}';
$string['invalidlibrarynamed'] = 'Бібліотека H5P {$a->%library}, що використовується у контенті, недійсна';
$string['invalidlibraryoption'] = 'Неприпустимий параметр {$a->%option} у {$a->%library}';
$string['invalidlibraryproperty'] = 'Не вдається прочитати властивість {$a->%property} у {$a->%library}';
$string['invalidmainjson'] = 'Відсутній дійсний основний файл h5p.json';
$string['invalidmultiselectoption'] = 'Неприпустимий вибраний параметр у режимі мультивибору.';
$string['invalidparameters'] = 'Неприпустимі Параметри';
$string['invalidselectoption'] = 'Неприпустимий параметр у виборі';
$string['invalidsemanticsjson'] = 'Неприпустимий файл semantics.json був включений до бібліотеки {$a->%name}';
$string['invalidsemanticstype'] = 'Внутрішня помилка H5P: невідомий тип контенту "{$a->@type}" у семантиці. Видалення контенту!';
$string['invalidstring'] = 'Наданий рядок не є дійсним відповідно до регулярного виразу в семантиці. (значення: \\"{$a->%value}\\", регулярний вираз: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Недійсний токен.';
$string['invalidvideoformat'] = 'Неприпустимий формат відеофайлу. Використовуйте mp4 або webm.';
$string['invalidxapiresult'] = 'Не знайдено результатів xAPI для даного поєднання контенту та ідентифікатора користувача';
$string['javascriptloading'] = 'Чекаємо на JavaScript...';
$string['libraries'] = 'Н5Р Библіотеки';
$string['librarydirectoryerror'] = 'Ім\'я каталогу бібліотеки повинно збігатися з machineName або machineName-majorVersion.minorVersion (з library.json). (Каталог: {$a->%directoryName}, ім\'я машини: {$a->%machineName}, majorVersion: {$a ->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Дії';
$string['librarylistinstancedependencies'] = 'Залежності екземпляра';
$string['librarylistinstances'] = 'Екземпляри';
$string['librarylistlibrarydependencies'] = 'Залежності бібліотеки';
$string['librarylistrestricted'] = 'Обмежений';
$string['librarylisttitle'] = 'Заголовок';
$string['librarynotselected'] = 'Ви повинні вибрати тип контенту.';
$string['license'] = 'Ліцензія';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'Загальна Публічна Ліцензія';
$string['licenseV1'] = 'Версія 1';
$string['licenseV2'] = 'Версія 2';
$string['licenseV3'] = 'Версія 3';
$string['licensee'] = 'Ліцензіат';
$string['licenseextras'] = 'Додаткові ліцензії';
$string['licenseversion'] = 'Версія ліцензії';
$string['loadingdata'] = 'Завантаження даних.';
$string['lookforupdates'] = 'Шукати оновлення H5P';
$string['maximumgrade'] = 'Максимальний бал';
$string['maximumgradeerror'] = 'Введіть дійсне додатне ціле число як максимальну кількість балів для цього завдання';
$string['maxpostsizetoosmall'] = 'Максимальний розмір PHP Post досить малий. За вашої поточної установки ви не можете завантажувати файли, розмір яких перевищує {$a->%number} МБ. Це може бути проблемою при спробі завантажити H5P-контент, зображення та відео. Будь ласка, подумайте про збільшення його до більш ніж 5 МБ';
$string['maxscore'] = 'Максимальний бал';
$string['maxuploadsizetoosmall'] = 'Максимальний розмір PHP Upload досить малий. За вашої поточної установки ви не можете завантажувати файли, розмір яких перевищує {$a->%number} МБ. Це може бути проблемою при спробі завантажити H5P-контент, зображення та відео. Будь ласка, подумайте про збільшення його до більш ніж 5 МБ';
$string['messageprovider:confirmation'] = 'Підтвердження власних заявок Н5Р';
$string['messageprovider:submission'] = 'Сповіщення про заявки Н5Р';
$string['missingcontentfolder'] = 'Відсутня припустима папка контенту';
$string['missingcontentuserdata'] = 'Помилка: Не вдалося знайти дані користувача контенту';
$string['missingcoreversion'] = 'Системі не вдалось встановити <em>{$a->%component}</em> компонент з пакета, для цього потрібна нова версія плагіна H5P. На цьому веб-сайті наразі встановлена версія {$a->%current}, тоді як обов’язкова версія - {$a->%required} або вище. Вам слід подумати про оновлення та спробувати ще раз.';
$string['missingdependency'] = 'Відсутня залежність {$a->@dep}, яку вимагає {$a->@lib}.';
$string['missinglibrary'] = 'Відсутня необхідна бібліотека  {$a->@library}';
$string['missinglibraryfile'] = 'У бібліотеці: "{$a->%name}" відсутній  файл "{$a->%file}"';
$string['missinglibraryjson'] = 'Не вдалося знайти файл library.json з припустимим форматом json для бібліотеки {$a->%name}';
$string['missinglibraryproperty'] = 'Потрібний параметр {$a->%property} відсутній в {$a->%library}';
$string['missingmbstring'] = 'Розширення PHP mbstring не завантажено. Це розширення потрібно для нормальної роботи Н5Р';
$string['missingparameters'] = 'Відсутні параметри';
$string['missinguploadpermissions'] = 'Зверніть увагу, що бібліотеки можуть існувати у завантаженому вами файлі, але вам не дозволено завантажувати нові бібліотеки. Зверніться з цього питання до адміністратора сайту.';
$string['modulename'] = 'Інтерактивний контент';
$string['modulename_help'] = '<p>Діяльність <b>Інтерактивний контент</b> - це вбудований конструктор H5P для інтерактивних елементів, що використовуються в складі курсів, таких як: інтерактивні відео, набори запитань, перетягування запитань, запитання з декількома варіантами вибору, презентації та багато іншого.</p>
<p>Цей конструктор дозволяє створювати всередині курсу ігрові ефектні мультимедійні інтерактиви без необхідності купувати та встановлювати додаткове програмне забезпечення.</p>
<p>Окрім того, що H5P є інструментом створення багатофункціонального вмісту, він дозволяє імпортувати та експортувати файли H5P для повторного та спільного використання контенту.</p>
<p>Взаємодія з користувачами та оцінки відстежуються за допомогою xAPI і доступні через журнал оцінок.</p>';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Інтерактивний контент';
$string['nextpage'] = 'Наступна сторінка';
$string['noanswersubmitted'] = 'Цей користувач ще не надіслав відповідь на завдання H5P';
$string['nocontent'] = 'Не вдалося знайти або проаналізувати файл content.json';
$string['nocontenttype'] = 'Не вказано тип контенту.';
$string['nocopyright'] = 'Інформація про авторські права на цей контент відсутня.';
$string['nodata'] = 'Немає доступних даних, які відповідають вашим критеріям.';
$string['noextension'] = 'Завантажений вами файл не є дійсним пакетом HTML5 (він не має розширення .h5p)';
$string['noh5ps'] = 'Інтерактивний контент для цього курсу відсутній.';
$string['nojson'] = 'Основний файл h5p.json недійсний';
$string['nombstringexteension'] = 'Розширення PHP mbstring  не завантажено. Це розширення потрібно для нормальної роботи Н5Р';
$string['noparameters'] = 'Немає параметрів';
$string['noparse'] = 'Не вдалося проаналізувати основний файл h5p.json';
$string['nopermissiontogettranslations'] = 'Ви не маєте дозволу на отримання перекладів';
$string['nopermissiontorestrict'] = 'Ви не маєте дозволу на встановлення обмеження для бібліотек.';
$string['nopermissiontosavecontentuserdata'] = 'Ви не маєте дозволу на збереження даних користувача контенту.';
$string['nopermissiontosaveresult'] = 'Ви не маєте дозволу на збереження результату для цього контенту.';
$string['nopermissiontoupgrade'] = 'Ви не маєте дозволу на оновлення бібліотек.';
$string['nopermissiontouploadcontent'] = 'Ви не маєте дозволу на завантаження контенту в це місце';
$string['nopermissiontouploadfiles'] = 'Ви не маєте дозволу на завантаження файлів в це місце';
$string['nopermissiontoviewcontenttypes'] = 'Ви не маєте дозволу на перегляд типів контенту';
$string['nopermissiontoviewresult'] = 'Ви не маєте дозволу на перегляд результатів для цього контенту';
$string['nosuchlibrary'] = 'Немає такої бібліотеки';
$string['notapplicable'] = 'не застосовується';
$string['nounzip'] = 'Завантажений вами файл не є дійсним пакетом HTML5 (ми не можемо його розпакувати)';
$string['noversionattribution'] = 'Ліцензія із зазначенням авторства';
$string['noversionattributionnc'] = 'Ліцензія із зазначенням авторства - Некомерційна';
$string['noversionattributionncnd'] = 'Ліцензія із зазначенням авторства - Некомерційна - Без похідних';
$string['noversionattributionncsa'] = 'Ліцензія із зазначенням авторства - Некомерційна - Із збереженням умов';
$string['noversionattributionnd'] = 'Ліцензія із зазначенням авторства - Без похідних';
$string['noversionattributionsa'] = 'Ліцензія із зазначенням авторства - Із збереженням умов';
$string['nowriteaccess'] = 'Виявлено проблему з доступом до сервера для запису. Переконайтесь, що ваш сервер може писати у вашу папку даних.';
$string['noziparchive'] = 'Ваша версія PHP не підтримує ZipArchive.';
$string['offlinedialogbody'] = 'Нам не вдалося надіслати інформацію про те, як ви виконали це завдання. Перевірте підключення до Інтернету.';
$string['offlinedialogheader'] = 'Ваше з’єднання з сервером було втрачено';
$string['offlinedialogretrybuttonlabel'] = 'Повторити спробу';
$string['offlinedialogretrymessage'] = 'Повторна спроба :num....';
$string['offlinesuccessfulsubmit'] = 'Результати успішно надіслані.';
$string['oldphpversion'] = 'Ваша версія PHP застаріла. Для нормальної роботи H5P потрібна версія 5.2. Рекомендується версія 5.6 або пізніша.';
$string['olduploadoldcontent'] = 'Ви намагаєтесь завантажити контент старої версії H5P. Будь ласка, оновіть контент на сервері, з якого він походить, і спробуйте завантажити контент знову або увімкніть H5P Hub, щоб цей сервер оновив його автоматично.';
$string['onlyupdate'] = 'Оновити лише наявні бібліотеки';
$string['options'] = 'Параметри';
$string['originator'] = 'Ініціатор';
$string['pd'] = 'Публічна ліцензія';
$string['pddl'] = 'Публічна ліцензія та передача в суспільне надбання';
$string['pdm'] = 'Суспільне надбання (PDM)';
$string['pluginadministration'] = 'Н5Р';
$string['pluginname'] = 'Н5Р';
$string['postmessagerequired'] = 'Щоб отримати доступ до даної кінцевої точки, потрібне повідомлення на електрону пошту';
$string['previouspage'] = 'Попередня сторінка';
$string['privacy:metadata:core_files'] = 'Завдання H5P зберігає файли, завантажені як частина вмісту H5P.';
$string['privacy:metadata:core_grades'] = 'Завдання H5P зберігає бали користувачів, які відповіли на вміст H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Описує поточний стан контенту для користувача. Використовується для відновлення контенту до попереднього стану.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Дані користувача, які були збережені.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Ідентифікатор типу даних.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Позначте, чи слід видаляти дані при зміні контенту.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'Ідентифікатор контенту H5P, якому належать дані.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'Ідентифікатор взаємозв\'язку даних користувача контенту.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Позначте, чи слід попередньо завантажувати дані у контент.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Субконтент H5P, 0, якщо це не субконтент.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'Ідентифікатор користувача, якому належать дані.';
$string['privacy:metadata:hvp_events'] = 'Відстежує зареєстровані події H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'Ідентифікатор контенту, над яким була виконана дія, 0, якщо новий контент або немає контенту.';
$string['privacy:metadata:hvp_events:content_title'] = 'Назва контенту.';
$string['privacy:metadata:hvp_events:created_at'] = 'Час створення події.';
$string['privacy:metadata:hvp_events:id'] = 'Унікальний ідентифікатор події.';
$string['privacy:metadata:hvp_events:library_name'] = 'Бібліотека, на яку вплинула подія.';
$string['privacy:metadata:hvp_events:library_version'] = 'Версія бібліотеки, на яку вплинула подія.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Підтип події або дії події.';
$string['privacy:metadata:hvp_events:type'] = 'Тип події.';
$string['privacy:metadata:hvp_events:user_id'] = 'Ідентифікатор користувача, який виконав дію.';
$string['privacy:metadata:hvp_xapi_results'] = 'Зберігає події xAPI у контенті H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Додаткова інформація, яку H5P може надіслати.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Ідентифікатор контенту, з яким виконувалась дія.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Правильний шаблон відповіді.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Опис, завдання чи питання контенту, з яким виконувалась дія.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Унікальний ідентифікатор події xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Тип взаємодії.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Максимально досяжний бал за подію.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'Ідентифікатор Parent-контенту, з яким була проведена дія. Нуль, якщо немає Parent-контенту.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Досягнутий бал за подію.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Відповідь, яку надіслав користувач.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'Ідентифікатор користувача, який виконав дію.';
$string['question'] = 'Питання';
$string['removeoldlogentries'] = 'Видалити застарілі записи логів H5P';
$string['removeoldmobileauthentries'] = 'Видалити застарілі записи мобільного авторизації H5P';
$string['removetmpfiles'] = 'Видалити застарілі тимчасові файли H5P';
$string['reportingquestionsremaininglabel'] = 'питання, що залишилися до оцінки';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Оцінка в журналі:';
$string['reportingscoredelimiter'] = 'із';
$string['reportingscorelabel'] = 'Оцінка';
$string['reportnotsupported'] = 'Не підтримується';
$string['reportsubmitgradelabel'] = 'Надіслати оцінку';
$string['resizescript'] = 'Включіть цей скрипт на своєму веб-сайті, якщо ви хочете динамічно змінювати розмір вбудованого вмісту:';
$string['resubmitscores'] = 'Спроба передати збережені результати.';
$string['reuse'] = 'Повторне використання';
$string['reusecontent'] = 'Повторне використання контенту';
$string['reusedescription'] = 'Повторно використати цей контент';
$string['reveal'] = 'Розкрити';
$string['reviseserversetupandretry'] = 'Коли ви переглянули налаштування сервера, ви можете знову ввімкнути зв\'язок з H5P Hub у налаштуваннях H5P.';
$string['score'] = 'Оцінка';
$string['search'] = 'Пошук';
$string['sendusagestatistics'] = 'Надати статистику використання';
$string['sendusagestatistics_help'] = 'Статистика використання буде автоматично передаватись розробникам, щоб допомогти краще зрозуміти, як використовується H5P, та визначити потенційні напрямки вдосконалення. Докладніше про те, які <a {$a}> дані збираються на h5p.org </a>.';
$string['settings'] = 'Налаштування Н5Р';
$string['showadvanced'] = 'Показати розширені';
$string['showless'] = 'Показувати менше';
$string['showmore'] = 'Показувати більше';
$string['sitecouldnotberegistered'] = 'Не вдалося зареєструвати сайт на Н5Р Hub. Зверніться до адміністратора вашого сайту.';
$string['sitekey'] = 'Ключ сайту';
$string['sitekeydescription'] = 'Ключ сайту - це секретний ключ, який однозначно ідентифікує цей сайт на H5P Hub.';
$string['sitekeyregistered'] = 'Вам надали унікальний ключ, який ідентифікує вас на H5P Hub під час отримання нових оновлень. Ключ доступний для перегляду на сторінці "Налаштування H5P".';
$string['size'] = 'Розмір';
$string['source'] = 'Джерело';
$string['sslnotenabled'] = 'На вашому сервері не ввімкнено SSL. SSL слід увімкнути, щоб забезпечити безпечне з\'єднання з H5P Hub.';
$string['startingover'] = 'Ви почнете спочатку.';
$string['sublevel'] = 'Підрівень';
$string['successfullyregisteredwithhub'] = 'Ваш сайт було успішно зареєстровано в H5P Hub.';
$string['thumbnail'] = 'Ескіз';
$string['title'] = 'Заголовок';
$string['unabletocreatedir'] = 'Неможливо створити каталог.';
$string['unabletogetfieldtype'] = 'Не вдається отримати тип поля.';
$string['undisclosed'] = 'Не розголошується';
$string['unpackedfilesexceedsmaxsize'] = 'Загальний розмір розпакованих файлів перевищує максимально дозволений розмір. (%used > %max)';
$string['updatedlibraries'] = 'Оновлені {$a->%old} H5P бібліотеки.';
$string['updatedlibrary'] = 'Оновлена {$a->%old} H5P бібліотека.';
$string['updatelibraries'] = 'Оновити всі бібліотеки';
$string['upgrade'] = 'Оновити H5P';
$string['upgradebuttonlabel'] = 'Оновити';
$string['upgradedone'] = 'Ви успішно оновили {$a} екземпляри контенту.';
$string['upgradeerror'] = 'Під час обробки параметрів сталася помилка:';
$string['upgradeerrorcontent'] = 'Не вдалося оновити контент %id:';
$string['upgradeerrordata'] = 'Не вдалося завантажити дані для бібліотеки %lib.';
$string['upgradeerrormissinglibrary'] = 'Відсутня необхідна бібліотека %lib.';
$string['upgradeerrornotsupported'] = 'Параметри містять %used, що не підтримується.';
$string['upgradeerrorparamsbroken'] = 'Параметри порушені.';
$string['upgradeerrorscript'] = 'Не вдалося завантажити сценарій оновлення для %lib.';
$string['upgradeerrortoohighversion'] = 'Параметри містять  %used, тоді як підтримуються тільки %supported або раніші .';
$string['upgradeheading'] = 'Оновити {$a} контент';
$string['upgradeinprogress'] = 'Оновлення до %ver...';
$string['upgradeinvalidtoken'] = 'Помилка: недійсний токен!';
$string['upgradelibrarycontent'] = 'Оновити вміст бібліотеки';
$string['upgradelibrarymissing'] = 'Помилка: Ваша бібліотека відсутня!';
$string['upgrademessage'] = 'Ви збираєтесь оновити {$a} екземпляр(и) контенту. Виберіть версію оновлення.';
$string['upgradenoavailableupgrades'] = 'Для цієї бібліотеки немає доступних оновлень.';
$string['upgradenothingtodo'] = 'Немає екземплярів контенту для оновлення.';
$string['upgradereturn'] = 'Повернутися';
$string['upload'] = 'Завантажити';
$string['uploadlibraries'] = 'Завантажити Бібліотеки';
$string['uploadsizelargerthanpostsize'] = 'Максимальний розмір завантаження для PHP перевищує максимальний розмір post-пакету РНР. Відомо, що це спричиняє проблеми у деяких установках.';
$string['user'] = 'Користувач';
$string['validatingh5pfailed'] = 'Не вдалося перевірити пакет h5p.';
$string['validationfailed'] = 'Запитаний H5P був неприпустимим';
$string['viewreportlabel'] = 'Повідомити';
$string['welcomecommunity'] = 'Ми сподіваємось, вам сподобається H5P та ви долучитесь до нашого зростаючого співтовариства на наших  <a {$a->forums}>форумах</a>.';
$string['welcomecontactus'] = 'Якщо у вас є відгуки, не вагайтесь <a {$a}> зв’язатися з нами </a>. Ми сприймаємо відгуки дуже серйозно і прагнемо покращувати H5P щодня!';
$string['welcomegettingstarted'] = 'Щоб розпочати роботу з H5P та Moodle, перегляньте наш <a {$a->moodle_tutorial}> підручник </a> і перегляньте <a {$a->example_content}> приклад вмісту </a> на H5P.org для натхнення.';
$string['welcomeheader'] = 'Ласкаво просимо у світ H5P!';
$string['wrongversion'] = 'Версія бібліотеки H5P {$a->%machineName}, використана в цьому контенті, недійсна. Контент містить {$a->%contentLibrary}, але це має бути {$a->%semanticsLibrary}.';
$string['year'] = 'Рік';
$string['years'] = 'Рік (роки)';
$string['yearsfrom'] = 'Років (із)';
$string['yearsto'] = 'Років (до)';
