<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'ar', version '5.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'يمكنك معاينة هذا الاختبار ، ولكن إذا كانت هذه محاولة حقيقية ، سوف يتم حظرك للأسباب التالية:';
$string['action'] = 'الإجراء';
$string['activityoverview'] = 'لديك اختبارات تم حلول موعدها';
$string['adaptive'] = 'الوضع التكيفي';
$string['adaptive_help'] = 'في حالة التمكين، سيُسمح بإجابات متعددة على السؤال ضمن نفس المحاولة في هذا الاختبار. فعلى سبيل المثال إذا تم وضع علامة على سؤال أنه غير صحيح،  فسُيسمح للطالب بمحاولته مرة أخرى على الفور. ومع ذلك، سيُعتمد على إعدادات "تطبيق الغرامات" في حساب غرامة كل محاولة خاطئة.';
$string['add'] = 'أضف';
$string['addaquestion'] = 'سؤال جديد';
$string['addarandomquestion'] = 'سؤال عشوائي';
$string['addarandomquestion_help'] = 'عند إضافة سؤال عشوائي، فإنه يؤدي إلى اختيار سؤال عشوائي من التصنيف لإدراجه في هذا الاختبار. وهذا يعني أن الطلاب المختلفين من المرجح أن يحصلوا على مجموعة مختلفة من الأسئلة، وكذلك عندما يسمح الإختبار بمحاولات متعددة فكل محاولة من المرجح أن تحتوي على مجموعة جديدة من الأسئلة.';
$string['addarandomquestion_success'] = 'تمت إضافة أسئلة عشوائية';
$string['addarandomselectedquestion'] = 'إضافة سؤال تم اختياره عشوائيا ...';
$string['addasection'] = 'عنوان قسم جديد';
$string['adddescriptionlabel'] = 'أضف عنصر وصف';
$string['addingquestion'] = 'أضف سؤال';
$string['addingquestions'] = '<p>من خلال جانب الصّفحة هذا تتمكّن من إدارة قاعدتك بيانات للأسئلة.
الاسئلة مخزنة في أصناف وذلك لمساعدتك في تنظيمها، ويمكن استعمالها مع أي اختبار في مقررك أو حتى المقررات الدراسية الأخرى إذا اخترت نشرهما.</p>
<p>بعد اختيارك أو إنشائك لصنف أسئلة، ستتمكن من إنشاء الأسئلة أو تحريرها. يمكن تحديد أيّ من هذه الأسئلة لإضافتها إلى الاختبار من الجانب الآخر لهذه الصّفحة.</p>';
$string['addmoreoverallfeedbacks'] = 'أضف {no} حقول إفادة إضافية';
$string['addnewgroupoverride'] = 'أضف تجاوز مجموعة';
$string['addnewpagesafterselected'] = 'إضافة صفحات جديدة بعد الأسئلة المختارة';
$string['addnewquestionsqbank'] = 'أضف أسئلة إلى الصنف {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'أضف تجاوز مستخدم';
$string['addpagebreak'] = 'إضافة فاصل صفحات';
$string['addpagehere'] = 'إضافة صفحة هنا';
$string['addquestion'] = 'أضف سؤال';
$string['addquestionfrombankatend'] = 'أضف من بنك الأسئلة في النهاية';
$string['addquestionfrombanktopage'] = 'أضف من بنك الأسئلة إلى الصفحة {$a}';
$string['addquestions'] = 'أضف أسئلة';
$string['addquestionstoquiz'] = 'أضف أسئلة إلى الاختبار الحالي';
$string['addrandom'] = 'أضف {$a} أسئلة عشوائية';
$string['addrandom1'] = 'أضف';
$string['addrandom2'] = 'أسئلة عشوائية';
$string['addrandomfromcategory'] = ':إضافة أسئلة عشوائية من تصنيف';
$string['addrandomquestion'] = 'أضف سؤال عشوائي';
$string['addrandomquestionatend'] = 'أضف سؤال عشوائي في النهاية';
$string['addrandomquestiontopage'] = 'أضف سؤال عشوائي إلى الصفحة {$a}';
$string['addrandomquestiontoquiz'] = 'أضف سؤال عشوائي إلى الإختبار {$a}';
$string['addselectedquestionstoquiz'] = 'أضف الأسئلة المختارة إلى الإختبار';
$string['addselectedtoquiz'] = 'أضف ما تم اختياره إلى الإختبار';
$string['addtoquiz'] = 'أضف إلى اختبار';
$string['affectedstudents'] = 'متأثر {$a}';
$string['aftereachquestion'] = 'بعد إضافة كل سؤال';
$string['afternquestions'] = 'بعد إضافة {$a} سؤال/أسئلة';
$string['age'] = 'العمر';
$string['allattempts'] = 'كل المحاولات';
$string['allinone'] = 'غير محدد';
$string['allowreview'] = 'السماح بالمراجعة';
$string['alreadysubmitted'] = 'يبدو أنك قد قدمت هذه المحاولة بالفعل';
$string['alternativeunits'] = 'وحدات القياس البديلة';
$string['alwaysavailable'] = 'متاح دائما';
$string['alwayslatest'] = 'الأخير دائمًا';
$string['analysisoptions'] = 'خيارات التحليل';
$string['analysistitle'] = 'جدول تحليل الفقرات';
$string['answer'] = 'إجابة';
$string['answered'] = 'تم الاجابة';
$string['answerhowmany'] = 'إجابة واحدة أم عدة إجابات؟';
$string['answers'] = 'الإجابات';
$string['answersingleno'] = 'يُسمح بتعدد الإجابات';
$string['answersingleyes'] = 'إجابة واحدة فقط';
$string['answertoolong'] = 'الجواب طويل جداً بعد السطر {$a} (الحد الاقصى 255 حرف)';
$string['anytags'] = 'أية وسوم';
$string['aon'] = 'تنسيق AON';
$string['areyousureremoveselected'] = 'هل أنت متأكد أنك تريد حذف جميع الأسئلة المختارة؟';
$string['asshownoneditscreen'] = 'كما هو مبين على شاشة التحرير';
$string['attempt'] = 'محاولة {$a}';
$string['attemptalreadyclosed'] = 'هذه المحاولة تم إكمالها بالفعل';
$string['attemptclosed'] = 'لم يتم اغلاق المحاولة بعد';
$string['attemptduration'] = 'الفترة';
$string['attemptedon'] = 'تمت المحاولة في';
$string['attempterror'] = 'أنت غير مسموح لك بمحاولة هذا الاختبار حالياً بسبب: {$a}';
$string['attempterrorcontentchange'] = 'لم يعد استعراض هذا الاختبار موجوداً. (عند تحرير الاختبار، يتم حذف كل الاستعراضات الجارية تلقائياً).';
$string['attempterrorcontentchangeforuser'] = 'هذه المحاولة للاختبار لم تعد موجودة.';
$string['attempterrorinvalid'] = 'مُعرَّف محاولة الاختبار غير صحيح';
$string['attemptfirst'] = 'المحاولة الأولى';
$string['attemptgradeddelay'] = 'فترة التأخير قبل إرسال إشعارات تقييم المحاولات';
$string['attemptgradeddelay_desc'] = 'يجري عمدًا تأخير إرسال إشعارات تقييم المحاولة للسماح للمعلم بتحرير التقديرات في مهلة مناسبة.';
$string['attemptincomplete'] = 'المحاولة التي تمت (بواسطة {$a})  لم تكتمل بعد';
$string['attemptlast'] = 'المحاولة الأخيرة';
$string['attemptnumber'] = 'محاولة';
$string['attemptquiz'] = 'محاولة الاختبار';
$string['attemptquiznow'] = 'محاولة أداء الاختبار الآن';
$string['attemptreviewtitle'] = '{$a}: مراجعة المحاولة';
$string['attemptreviewtitlepaged'] = '{$a->name}: مراجعة المحاولة (صفحة {$a->currentpage} من {$a->totalpages})';
$string['attempts'] = 'محاولات';
$string['attempts_help'] = 'إجمالي عدد المحاولات المسموح بها (ليس عدد المحاولات الإضافية).';
$string['attemptsallowed'] = 'المحاولات المسموح بها';
$string['attemptsdeleted'] = 'تم حذف محاولات الاختبار';
$string['attemptselection'] = 'إختر المحاولات المطلوب تحليلها لكل مستخدم';
$string['attemptsexist'] = 'لا يمكنك إضافة أو إزالة أسئلة من هذا الاختبار';
$string['attemptsnum'] = 'المحاولات: {$a}';
$string['attemptsnumthisgroup'] = 'المحاولات: {$a->total} ({$a->group} من هذه المجموعة)';
$string['attemptsnumyourgroups'] = 'المحاولات: {$a->total} ({$a->group} من مجموعاتك)';
$string['attemptsonly'] = 'أظهر الطلاب الذين لديهم محاولات فقط';
$string['attemptstate'] = 'الحالة';
$string['attemptstillinprogress'] = 'لا تزال المحاولة قيد التفيذ';
$string['attemptsummarytitle'] = '{$a}: ملخص المحاولة';
$string['attemptsunlimited'] = 'محاولات غير محدودة';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (صفحة {$a->currentpage} من {$a->totalpages})';
$string['autosaveperiod'] = 'مهلة تأخير الحفظ التلقائي';
$string['autosaveperiod_desc'] = 'يمكن حفظ الاستجابات تلقائياً في أثناء محاولات الاختبار. يتم حفظ الاستجابات كلما تغيرت، ثم بعد مهلة التأخير هذه. هناك موازنة ما بين الاثنين: مهلة تأخير أقصر ستزيد الحمل على المخدم ولكنها ستقلل من احتمالية فقد الطالب لعمله. إذا أردت جعل هذا التأخير أقل بكثير، عليك تغيير قيمته تدريجياً مع مراقبتك لتأثير الحمل على أداء المخدم. إذا صار الحمل عالياً جداً، غيره إلى قيمة أعلى. جعل هذا التأخير 0 معناه تعطيل الحفظ التلقائي.';
$string['back'] = 'عودة إلى معاينة السؤال';
$string['backtocourse'] = 'عودة إلى المساق';
$string['backtoquestionlist'] = 'عودة إلى قائمة الأسئلة';
$string['backtoquiz'] = 'عودة إلى تحرير الاختبار';
$string['banknotfound'] = 'بنك الأسئلة غير موجود، يرجى البحث مجددًا';
$string['bestgrade'] = 'أفضل درجة';
$string['bothattempts'] = 'أظهر الطلاب سواء لديهم محاولات أم لا';
$string['browsersecurity'] = 'أمان المستعرض';
$string['browsersecurity_help'] = 'إذا تم اختيار "ملء الشاشة المنبثقة مع بعض أمان JavaScript"،

* سيبدأ الاختبار فقط إذا كان لدى الطالب متصفح إنترنت تم فيه تمكين JavaScript
* سيظهر الاختبار في نافذة منبثقة على ملء الشاشة بحيث تغطي كل النوافذ الأخرى وليس فيها عناصر التحكم بالتنقل
* سيتم منع الطلاب، بقدر ما هو ممكن، من استعمال بعض التسهيلات مثل النسخ واللصق';
$string['cachedef_overrides'] = 'معلومات تجاوز المستخدمين والمجموعات';
$string['calculated'] = 'تم الحساب';
$string['calculatedquestion'] = 'السؤال الحسابي غير مدعوم في السطر {$a}. سيتم تجاهل هذا السؤال.';
$string['cannotcreatepath'] = 'تعذر إنشاء المسار ({$a})';
$string['cannoteditafterattempts'] = 'لا يمكنك إضافة أسئلة أو إزالتها لأن هذا الاختبار قد صارت له محاولات. ({$a})';
$string['cannotfindprevattempt'] = 'لا يمكن العثور على محاولة سابقة للبناء عليها.';
$string['cannotfindquestionregard'] = '!فشل في الحصول على أسئلة لإعادة التصحيح';
$string['cannotinsert'] = 'لا يمكن إدراج سؤال';
$string['cannotinsertrandomquestion'] = '!لا يمكن إدراج سؤال عشوائي جديد';
$string['cannotloadquestion'] = 'لا يمكن تحميل خيارات السؤال';
$string['cannotloadtypeinfo'] = 'تعذر تحميل معلومات نوع السؤال';
$string['cannotopen'] = 'تعذر فتح ملف التصدير ({$a})';
$string['cannotremoveallsectionslots'] = 'لقد اخترت كل الأسئلة تحت رأس القسم \'{$a}\'. ليس مسموحاً به إزالة كل الأسئلة تحت رأس القسم.';
$string['cannotremoveslots'] = 'تعذرت إزالة الأسئلة';
$string['cannotrestore'] = 'تعذر استرجاع جلسات الأسئلة';
$string['cannotreviewopen'] = 'لا يمكنك مراجعة هذه المحاولة، إنها لا تزال جارية.';
$string['cannotsavelayout'] = 'تعذر حفظ تخطيط الصفحة';
$string['cannotsavenumberofquestion'] = 'تعذر حفظ عدد الأسئلة لكل صفحة';
$string['cannotsavequestion'] = 'تعذر حفظ قائمة الأسئلة';
$string['cannotsetgrade'] = 'تعذر وضع علامة عظمى جديدة للاختبار';
$string['cannotsetsumgrades'] = 'فشل تعيين مجموع الدرجات';
$string['cannotstartgradesmismatch'] = 'تعذر البدء بمحاولة لهذا الاختبار. لقد تم ضبط الاختبار ليكون من {$a->grade} درجة، ولكن ليس هناك درجة لأي من الأسئلة فيه. يمكن إصلاح ذلك في صحفة \'تحرير الاختبار\'.';
$string['cannotstartmissingquestion'] = 'تعذر البدء بمحاولة لهذا الاختبار. تعريف الاختبار يتضمن سؤالاً ليس له وجود.';
$string['cannotstartnoquestions'] = 'تعذر البدء بمحاولة لهذا الاختبار. لم تتم تهيئته بعد. لم تتم إضافة الأسئلة إليه بعد.';
$string['cannotwrite'] = 'تعذرت الكتابة على ملف التصدير ({$a})';
$string['canredoquestions'] = 'إسمح بالإعادة ضمن المحاولة';
$string['canredoquestions_desc'] = 'عند تمكينه، بعد إكمال محاولة السؤال، سيتم عرض زر \'حاول سؤالاً آخر مماثل له\'. هذا يسمح بمحاولة سؤال آخر (منتخب عشوائياً) أو السؤال نفسه مرة أخرى، دون الحاجة إلى تسليم الاختبار بأكمله والشروع بمحاولة أخرى. هذا الخيار مفيد في الاختبارات التدريبية.

هذا الإعداد يؤثر فقط على الأسئلة وسلوكها (مثل الإفادة الفورية أو التفاعلي مع محاولات متعددة) حيثما كان بالإمكان إنهاء السؤال قبل تسليم المحاولة.';
$string['canredoquestions_help'] = 'عند تمكينه، بعد إكمال محاولة السؤال، سيتم عرض زر \'حاول سؤالاً آخر مماثل له\'. هذا يسمح بمحاولة سؤال آخر (منتخب عشوائياً) أو السؤال نفسه مرة أخرى، دون الحاجة إلى تسليم الاختبار بأكمله والشروع بمحاولة أخرى. هذا الخيار مفيد في الاختبارات التدريبية.

هذا الإعداد يؤثر فقط على الأسئلة وسلوكها (مثل الإفادة الفورية أو التفاعلي مع محاولات متعددة) حيثما كان بالإمكان إنهاء السؤال قبل تسليم المحاولة.';
$string['canredoquestionsyes'] = 'نعم، أعطِ خيار محاولة سؤال آخر';
$string['caseno'] = 'لا، حالة الأحرف ليست مهمة';
$string['casesensitive'] = 'مطابقة حالة الأحرف';
$string['caseyes'] = 'نعم، لابد من مطابقة حالة الأحرف';
$string['categoryadded'] = 'تمت إضافة الصنف \'{$a}\'';
$string['categorydeleted'] = 'لقم تم حذف  التصنيف {$a}';
$string['categorynoedit'] = 'لا تملك صلاحية التحرير في هذه الفئة \'{$a}\'.';
$string['categoryupdated'] = 'تم تحديث الصنف بنجاح';
$string['close'] = 'أغلق النافذة';
$string['closebeforeopen'] = 'تاريخ الإغلاق ينبغي أن يكون بعد تاريخ الفتح.';
$string['closed'] = 'مغلق';
$string['closepreview'] = 'أغلاق  المعاينة';
$string['closereview'] = 'أغلاق  المراجعة';
$string['comment'] = 'تعليق';
$string['commentorgrade'] = 'أعطِ تعليقاً أو تجاوز العلامة';
$string['comments'] = 'التعليقات';
$string['completedon'] = 'إكتمل';
$string['completionattemptsexhausted'] = 'تم إحراز درجة النجاح أو إكمال كل المحاولات المتاحة';
$string['completionattemptsexhausted_help'] = 'قم بتأشير الاختبار على أنه مكتمل عند استفاد الطالب للعدد الأقصى من المحاولات المتاحة له.';
$string['completiondetail:minattempts'] = 'إجراء المحاولات: {$a}';
$string['completiondetail:passorexhaust'] = 'تلقي علامة النجاح أو إكمال كل المحاولات المتاحة';
$string['completionminattempts'] = 'أدنى عدد من المحاولات';
$string['completionminattemptsdesc'] = 'أدنى عدد مطلوب من المحاولات: {$a}';
$string['completionminattemptserror'] = 'أدنى عدد من المحاولات ينبغي أن يكون أقل أو مساوياً للعدد المسموح منها.';
$string['completionpassorattemptsexhausteddesc'] = 'ينبغي على الطالب إحراز علامة النجاح أو استنفاد كل المحاولات المتاحة لإكمال هذا النشاط';
$string['configadaptive'] = 'إذا اخترتَ نعم لهذا الخيار، فعندها سيكون مسموحاً للطالب بتقديم استجابات متعددة للسؤال حتى ضمن نفس المحاولة من الاختبار.';
$string['configattemptsallowed'] = 'تقييد لعدد المحاولات المسموح بها للطالب في الاختبار.';
$string['configdecimaldigits'] = 'عدد المراتب التي ينبغي إظهارها بعد الفارزة العشرية عند عرض الدرجات.';
$string['configdecimalplaces'] = 'عدد المراتب التي ينبغي إظهارها بعد الفارزة العشرية عند عرض درجات الاختبار.';
$string['configdecimalplacesquestion'] = 'عدد المراتب التي ينبغي إظهارها بعد الفارزة العشرية عند عرض درجة الأسئلة منفردة.';
$string['configdelay1'] = 'إذا حددت مهلة تأخير، فعلى الطالب عندها انتظار انقضاء هذه المهلة قبل أن يتمكن من إعادة محاولة الاختبار بعد محاولته الأولى.';
$string['configdelay1st2nd'] = 'إذا حددت مهلة تأخير هنا، فلن يتمكن الطالب من بدء محاولته الثانية حتى تنقضي هذه المهلة بعد إنهاء محاولته الأولى.';
$string['configdelay2'] = 'إذا حددت مهلة تأخير هنا، فعلى الطالب عندها انتظار انقضاء هذه المهلة قبل أن يتمكن من إعادة محاولة الاختبار للمرة الثالثة وما بعدها من المحاولات.';
$string['configdelaylater'] = 'إذا حددت مهلة تأخير هنا، فلن يتمكن الطالب من بدء محاولته الثالثة، الرابعة،... حتى تنقضي هذه المهلة بعد إنهاء محاولته السابقة.';
$string['configeachattemptbuildsonthelast'] = 'إذا كان مسموحاً بمحاولات متعددة، فعندها ستكون كل محاولة جديدة محتوية على نتائج المحاولة السابقة لها.';
$string['configgrademethod'] = 'عندما يكون مسموحاً بمحاولات متعددة، فأي طريقة ينبغي استعمالها لاحتساب الدرجة النهائية للطالب في الاختبار.';
$string['configintro'] = 'القيم التي تضعها هنا ستمثل القيم الافتراضية المستعملة في نموذج الإعدادات عند إنشائك لاختبار جديد. يمكنك أيضاً تحديد الإعدادات التي سيتم اعتبارها متقدمة.';
$string['configintroglobal'] = 'هذه الإعدادات تتحكم بسلوك النظام لنشاط الاختبار';
$string['configmaximumgrade'] = 'الدرجة الافتراضية التي ستتم مقايسة درجة الاختبار على أساسها.';
$string['confignavmethod'] = 'في التنقل الحر، يمكن إجابة الأسئلة بأي ترتيب باستعمال التنقل. في التنقل المتتابع، ينبغي إجابة الأسئلة وفقاً لتسلسل صارم.';
$string['confignewpageevery'] = 'عند إضافة الأسئلة إلى الاختبار، سيتم وضع فواصل الصفحات بينها تلقائياً وفقاً للإعداد الذي تحدده هنا.';
$string['configoutcomesadvanced'] = 'عند تشغيل هذا الخيار، ستكون النتائج في نموذج تحرير الاختبار إعدادات متقدمة.';
$string['configpenaltyscheme'] = 'الغرامة المستقطعة لكل إجابة خاطئة في النمط التفاعلي.';
$string['configpopup'] = 'فرض فتح المحاولة في نافذة جديدة واستعمل خدع لغة JavaScript لمحاولة تقييد استعمالات النسخ واللصق... إلخ. خلال محاولات الاختبار.';
$string['configrequirepassword'] = 'على الطلبة إدخال كلمة المرور هذه قبل أن يتمكنوا من محاولة الاختبار.';
$string['configrequiresubnet'] = 'يمكن للطلبة محاولة الاختبار من هذه الحاسبات حصراً.';
$string['configreviewoptions'] = 'هذه الخيارات تسيطر على المعلومات التي يمكن للمستخدمين مشاهدتها عند مراجعتهم لمحاولة الاختبار أو النظر في تقاريره.';
$string['configshowblocks'] = 'أظهر الكتل خلال محاولات الاختبار.';
$string['configshowuserpicture'] = 'أظهر صورة المستخدم على الشاشة خلال المحاولات.';
$string['configshufflewithin'] = 'عند تمكين هذا الخيار، فالأجزاء التي تتكون منها الأسئلة المنفردة سيتم خلطها كل مرة يشرع فيها الطالب بمحاولة جديدة للاختبار، على فرض أن هذا الخيار مُمَكَّن أيضاً في إعدادات السؤال.';
$string['configtimelimit'] = 'حد الوقت الافتراضي للاختبارات بالدقائق. 0 معناه بلا تحديد للوقت.';
$string['configtimelimitsec'] = 'حد الوقت الافتراضي للاختبارات بالثواني. 0 معناه بلا تحديد للوقت.';
$string['configurerandomquestion'] = 'تهيئة السؤال';
$string['confirmclose'] = 'بمجرد قيامك بتسليم إجاباتك، لن يعود بإمكانك تغييرها.';
$string['confirmremovequestion'] = 'هل أنت متأكد من رغبتك في إزالة سؤال {$a} هذا؟';
$string['confirmremovesectionheading'] = 'هل أنت متأكد من رغبتك في إزالة رأس القسم \'{$a}\'؟';
$string['confirmserverdelete'] = 'هل أنت متأكد من إبعاد الخادم <b>{$a}</b> من القائمة؟';
$string['connectionerror'] = 'فُقد الاتصال بالشبكة. (الحفظ التلقائي فشل).

أكتب ملاحظة عن أي إجابات قد تكون أدخلتها في هذه الصفحة خلال الدقائق القليلة الماضية، ثم حاول معاودة الاتصال.

بمجرد إعادة تأسيس الاتصال، ينبغي أن تكون إجاباتك قد تم حفظها وهذه الرسالة ستختفي.';
$string['connectionok'] = 'تمت استعادة الاتصال بالشبكة. بإمكانك المتابعة بأمان.';
$string['containercategorycreated'] = 'لقد تم إنشاء هذا التصنيف لحفظ كل التصنيفات الأصلية المنقولة إلى مستوى الموقع للأسباب المبينة أدناه.';
$string['continueattemptquiz'] = 'إستمر في محاولتك';
$string['continuepreview'] = 'استمر بالمعاينة الأخيرة';
$string['copyingfrom'] = 'إنشاء نسخة من السؤال  \'{$a}\'';
$string['copyingquestion'] = 'نسخ سؤال';
$string['correct'] = 'صحيح';
$string['correctanswer'] = 'الإجابة الصحيحة';
$string['correctanswerformula'] = 'معادلة الإجابة الصحيحة';
$string['correctansweris'] = 'الإجابة الصحيحة {$a}';
$string['correctanswerlength'] = 'الأرقام ذات القيمة';
$string['correctanswers'] = 'الإجابات الصحيحة';
$string['correctanswershows'] = 'الإجابة الصحيحة تظهر';
$string['corrresp'] = 'الجواب الصحيح';
$string['countdown'] = 'العد التنازلي';
$string['countdownfinished'] = 'سيتم إغلاق الاختبار، يجب عليك تسليم إجاباتك الآن.';
$string['countdowntenminutes'] = 'سيتم إغلاق الاختبار بعد عشر دقائق';
$string['coursetestmanager'] = 'مدير تنسيق اختبار المنهج الدراسي';
$string['createcategoryandaddrandomquestion'] = 'أنشئ تصنيفاً وأضف سؤالاً عشوائياً';
$string['createfirst'] = 'يجب عليك إنشاء بعض أسئلة الأجابات القصير أولا.';
$string['createmultiple'] = 'انشئ اسئلة متعددة الاختيارات';
$string['createnewquestion'] = 'انشئ سؤال جديد';
$string['createquestionandadd'] = 'أنشئ سؤالاً جديداً وأضفه إلى الاختبار.';
$string['currentbank'] = 'البنك الحالي: {$a}';
$string['custom'] = 'تنسيق مخصص';
$string['dataitemneed'] = 'عليك إضافة مجموعة واحدة على الأقل من البيانات للحصول على سؤال صحيح';
$string['datasetdefinitions'] = 'تعاريف مجموعة بيانات قابلة لإعادة الاستعمال للتصنيف {$a}';
$string['datasetnumber'] = 'رقم';
$string['daysavailable'] = 'الأيام المتاحة';
$string['decimaldigits'] = 'المراتب العشرية في الدرجات';
$string['decimalplaces'] = 'المنازل العشرية في الدرجات';
$string['decimalplaces_help'] = 'هذا الإعداد يحدد عدد المراتب الظاهرة بعد الفارزة العشرية عند عرض الدرجات. هذا يتعلق فقط بعرض الدرجات، وليس القيمة الفعلية لها المخزونة في قاعدة البيانات ولا الحسابات الداخلية لها والتي تجري بأقصى دقة ممكنة.';
$string['decimalplacesquestion'] = 'المنازل العشرية في درجات الأسئلة';
$string['decimalplacesquestion_help'] = 'عدد المراتب الظاهرة بعد الفارزة العشرية عند عرض الدرجات للأسئلة منفردة.';
$string['decimalpoints'] = 'المراتب العشرية';
$string['default'] = 'افتراضي';
$string['defaultgrade'] = 'درجة السؤال الافتراضية';
$string['defaultinfo'] = 'الصنف الافتراضي للأسئلة';
$string['defaultsettings'] = 'إعدادات الاختبار الافتراضية';
$string['delay1'] = 'مهلة التأخير ما بين المحاولتين الأولى والثانية';
$string['delay1st2nd'] = 'التأخير المفروض ما بين المحاولتين الأولى والثانية';
$string['delay1st2nd_help'] = 'عند تمكينه، على الطالب انتظار انقضاء هذه الفترة من الوقت قبل أن يتمكن من محاولة الاختبار للمرة الثانية.';
$string['delay2'] = 'مهلة التأخير بين المحاولات اللاحقة';
$string['delaylater'] = 'التأخير المفروض ما بين المحاولات اللاحقة';
$string['delaylater_help'] = 'عند تمكينه، على الطالب انتظار انقضاء هذه الفترة من الوقت قبل أن يتمكن من محاولة الاختبار للمرة الثالثة أو أي محاولات أخرى لاحقة.';
$string['deleteattemptcheck'] = 'هل انت متأكد تماما من القيام بالحذف الكامل لهذه المحاولات.';
$string['deleteselected'] = 'أحذ المختار';
$string['deletingquestionattempts'] = 'حذف محاولات السؤال';
$string['description'] = 'الوصف';
$string['disabled'] = 'معطل';
$string['displayoptions'] = 'أعرض الخيارات';
$string['donotuseautosave'] = 'لا تستعمل الحفظ التلقائي';
$string['download'] = 'أنقر لتنزيل ملف الصنف المُصدَّر';
$string['downloadextra'] = '(الملف يُخزن أيضاً في ملفات المساق في المجلد /backupdata/quiz)';
$string['dragtoafter'] = 'بعد {$a}';
$string['dragtostart'] = 'إلى البداية';
$string['duplicateresponse'] = 'لقد تم تجاهل هذا التسليم لأنك أعطيت إجابة مكافئة في وقت سابق.';
$string['eachattemptbuildsonthelast'] = 'كل محاولة تبنى على سابقتها';
$string['eachattemptbuildsonthelast_help'] = 'إذا تم تمكين المحاولات المتعددة وهذا الإعداد ممَكَّن، فكل محاولة جديدة للاختبار ستتضمن نتائج المحاولة السابقة له. هذا يسمح بإكمال الاختبار على امتداد عدة محاولات.';
$string['edit_slotdisplaynumber_hint'] = 'تحرير رقم السؤال (الأقصى 16 حرف)';
$string['edit_slotdisplaynumber_label'] = 'قيمة جديدة لـ{$a}';
$string['editcategories'] = 'تحرير اللأصناف';
$string['editcategory'] = 'تحرير الصنف';
$string['editcatquestions'] = 'حرر أسئلة التصنيفات';
$string['editingquestion'] = 'تحرير سؤال';
$string['editingquiz'] = 'تحرير الاختبار';
$string['editingquiz_help'] = 'عند إنشاء اختبار، فالمفاهيم الأساسية هي:

* الاختبار يحتوي أسئلة موزعة على صفحة واحدة أو أكثر
* بنك الأسئلة الذي يخزن نسخاً منها منظماً في أصناف
* الأسئلة العشوائية - يحصل الطالب على أسئلة مختلفة في كل محاولة جديدة للاختبار وطلبة مختلفون يحصلون على أسئلة مختلفة';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'يجري تحرير الاختبار: {$a}';
$string['editmaxmark'] = 'تحرير الدرجة العظمى';
$string['editoverride'] = 'تخطي التحرير';
$string['editqcats'] = 'حرر فئات الأسئلة';
$string['editquestion'] = 'تحرير السؤال';
$string['editquestions'] = 'تحرير الاسئله';
$string['editquiz'] = 'تحرير الاختبار';
$string['editquizquestions'] = 'حرر أسئلة الاختبار';
$string['emailconfirmautosubmitsmall'] = 'شكرًا لتقديم إجاباتك إلى  \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'مرحباً {$a->username}،

شكراً على تسليمك لإجاباتك عن \'{$a->quizname}\' في المساق \'{$a->coursename}\' عند {$a->submissiontime}.

هذه الرسائل تؤكد بأن إجاباتك قد تم حفظها.

يمكنك الوصول إلى هذا الاختبار عبر {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'مرحبًا {$a->username}،

مدة الاختبار \'{$a->quizname}\' في المساق \'{$a->coursename}\' قد انتهت. إجاباتك تم تسليمها تلقائيًا في {$a->submissiontime}.

هذه الرسالة تؤكد بأن إجاباتك قد تم حفظها.

يمكنك الوصول إلى هذا الاختبار من {$a->quizurl}.';
$string['emailconfirmsmall'] = 'شكراً على تسليمك لإجاباتك عن \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'تأكيد التسليم: {$a->quizname}';
$string['emailmanualgradedbody'] = 'مرحباً {$a->studentname}،

إجابتك في \'{$a->quizname}\' في المساق \'{$a->coursename}\' عند {$a->attempttimefinish} قد تم تقييمها.

ستتمكن من معاينة درجتك والإفادة بشأنها عبر زيارة \'{$a->quizurl}\' ومراجعة محاولتك.';
$string['emailmanualgradedsubject'] = 'محاولتك في {$a->quizname} قد تم تقييمها';
$string['emailnotifybody'] = 'مرحباً {$a->username}،

{$a->studentname} قد أكمل \'{$a->quizname}\' ({$a->quizurl}) في المساق \'{$a->coursename}\'.

يمكنك استعراض هذه المحاولة في {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} قد أكمل {$a->quizname}. أنظر {$a->quizreviewurl}.';
$string['emailnotifysubject'] = '{$a->studentname} قد أكمل {$a->quizname}';
$string['emailoverduebody'] = 'مرحباً {$a->studentname}،

لقد بدأت بمحاولة \'{$a->quizname}\' في المساق \'{$a->coursename}\'، ولكنك لم تسلمها. وينبغي تسليمها في {$a->attemptduedate}.

إن كنت لا تزال راغباً بتسليمها، إذهب لطفاً إلى {$a->attemptsummaryurl} وأنقر زر التسليم. عليك القيام بذلك قبل {$a->attemptgraceend}، بخلافه، محاولتك لن تحتسب.';
$string['emailoverduesmall'] = 'لم تقم بتسليم محاولتك في {$a->quizname}. لطفاً، إذهب إلى {$a->attemptsummaryurl} قبل {$a->attemptgraceend} إن كنت لا تزال راغباً بتسليمها.';
$string['emailoverduesubject'] = 'المحاولة الآن متأخرة: {$a->quizname}';
$string['empty'] = 'فارغ';
$string['enabled'] = 'مفعل';
$string['endtest'] = 'إنهاء المحاولة ...';
$string['erroraccessingreport'] = 'لا يمكنك الوصول إلى هذا التقرير';
$string['errorinquestion'] = 'خطأ في السؤال';
$string['errormissingquestion'] = 'خطأ: النظام ينقصه السؤال ذي المعرَّف {$a}';
$string['errornotnumbers'] = 'خطأ - الإجابات ينبغي أن تكون رقمية';
$string['errorunexpectedevent'] = 'تم العثور على نص برمجي غير متوقع للحدث {$a->event} في السؤال {$a->questionid} ضمن المحاولة {$a->attemptid}.';
$string['essay'] = 'مقالة';
$string['essayquestions'] = 'أسئلة مقالية';
$string['eventattemptautosaved'] = 'محاولة الاختبار تم حفظها تلقائيًا';
$string['eventattemptdeleted'] = 'محاولة اختبار تم حذفها';
$string['eventattemptmanualgradingcomplete'] = 'محاولة اختبار تم إكمال تقييمها اليدوي';
$string['eventattemptpreviewstarted'] = 'استعراض محاولة اختبار تم بدؤه';
$string['eventattemptquestionrestarted'] = 'سؤال محاولة الاختبار أُعيد بدؤه';
$string['eventattemptreviewed'] = 'محاولة اختبار تمت مراجعتها';
$string['eventattemptsummaryviewed'] = 'ملخص محاولة اختبار تمت معاينته';
$string['eventattemptupdated'] = 'محاولة الاختبار تم تحديثها';
$string['eventattemptviewed'] = 'محاولة اختبار تمت معاينتها';
$string['eventeditpageviewed'] = 'صفحة تحرير اختبار تمت معاينتها';
$string['eventoverridecreated'] = 'تجاوز اختبار تم إنشاؤه';
$string['eventoverridedeleted'] = 'تجاوز اختبار تم حذفه';
$string['eventoverrideupdated'] = 'تجاوز اختبار تم تحديثه';
$string['eventpagebreakcreated'] = 'فاصل صفحات تم إنشاؤه';
$string['eventpagebreakdeleted'] = 'فاصل صفحات تم حذفه';
$string['eventquestionmanuallygraded'] = 'تقديرات اختبار تم منحها يدوياً';
$string['eventquizattemptabandoned'] = 'محاولة اختبار تم التخلي عنها';
$string['eventquizattemptgraded'] = 'محاولة الاختبار تم تقييمها';
$string['eventquizattemptregraded'] = 'محاولة اختبار تمت إعادة تقييمها';
$string['eventquizattemptreopened'] = 'محاولة الاختبار أعيد فتحها';
$string['eventquizattemptstarted'] = 'محاولة اختبار تم بدؤها';
$string['eventquizattemptsubmitted'] = 'محاولة اختبار تم تسليمها';
$string['eventquizattempttimelimitexceeded'] = 'وقت محاولة اختبار تم تجاوزه';
$string['eventquizgradeitemcreated'] = 'فقرة تقييم من نوع اختبار تم إنشاؤها';
$string['eventquizgradeitemdeleted'] = 'فقرة تقييم من نوع اختبار تم حذفها';
$string['eventquizgradeitemorderchanged'] = 'فقرة تقييم من نوع اختبار تم تغيير ترتيبها';
$string['eventquizgradeitemupdated'] = 'فقرة تقييم من نوع اختبار تم تحديثها';
$string['eventquizgradeupdated'] = 'فاصل صفحات تم تحديثه';
$string['eventquizrepaginated'] = 'إختبار تمت إعادة تعيين صفحاته';
$string['eventreportviewed'] = 'تقرير اختبار تمت معاينته';
$string['eventsectionbreakcreated'] = 'فاصل مقاطع تم إنشاؤه';
$string['eventsectionbreakdeleted'] = 'فاصل مقاطع تم حذفه';
$string['eventsectionshuffleupdated'] = 'خلط المقاطع تم تحديثه';
$string['eventsectiontitleupdated'] = 'عنوان المقاطع تم تحديثه';
$string['eventslotcreated'] = 'فسحة تم إنشاؤها';
$string['eventslotdeleted'] = 'فسحة تم حذفها';
$string['eventslotdisplayedquestionnumberupdated'] = 'فسحة تعرض رقم السؤال تم تحديثها';
$string['eventslotgradeitemupdated'] = 'عنصر فتحة التقدير تم تحديثه';
$string['eventslotmarkupdated'] = 'علامة فسحة تم تحديثها';
$string['eventslotmoved'] = 'فسحة تم نقلها';
$string['eventslotrequirepreviousupdated'] = 'فسحة تتطلب الاستعراض تم تحديثها';
$string['eventslotversionupdated'] = 'نسخة الفسحة تم تحديثها';
$string['everynquestions'] = 'كل {$a} سؤال/أسئلة';
$string['everyquestion'] = 'كل سؤال';
$string['everythingon'] = 'كل شيء في';
$string['existingcategory'] = 'الصنف الموجود';
$string['exportcategory'] = 'تصدير الصنف';
$string['exporterror'] = 'وقع خطأ خلال معالجة التصدير';
$string['exportingquestions'] = 'يجري تصدير الأسئلة إلى ملف';
$string['exportname'] = 'اسم الملف';
$string['exportquestions'] = 'تصدير الأسئلة إلى ملف';
$string['extraattemptrestrictions'] = 'التقييدات الإضافية على المحاولات';
$string['false'] = 'خاطىء';
$string['feedback'] = 'الإفادة';
$string['feedbackerrorboundaryformat'] = 'حدود إفادة الدرجة ينبغي أن تكون إما نسبة مئوية أو رقماً. القيمة التي أدخلتها في الحد {$a} لم يتسنَّ التعرف عليها.';
$string['feedbackerrorboundaryoutofrange'] = 'حدود إفادة الدرجة ينبغي أن تتراوح ما بين 0% و 100%. القيمة التي أدخلتها في الحد {$a} تقع خارج هذا المدى.';
$string['feedbackerrorjunkinboundary'] = 'عليك إملاء حقول حدود إفادة الدرجة بدون ترك أي فراغات.';
$string['feedbackerrorjunkinfeedback'] = 'عليك إملاء حقول الإفادة بدون ترك أي فراغات.';
$string['feedbackerrororder'] = 'حقول حدود إفادة الدرجة ينبغي أن تكون مرتبة مع الأعلى أولاً. القيمة التي أدخلتها في الحد {$a} هي خارج هذا الترتيب.';
$string['file'] = 'الملف';
$string['fileformat'] = 'تنسيق الملف';
$string['fillcorrect'] = 'أمل بالإجابة الصحيحة';
$string['filloutnumericalanswer'] = 'عليك إعطاء إجابة ممكنة واحدة على الأقل مع التسامح. أول إجابة مطابقة سيتم استعمالها لتحديد الدرجة والإفادة. عند النهاية، إذا أعطيت إفادة معينة بدون إجابة، فسيتم إظهارها للطلبة الذين لا تطابق إجاباتهم أي إجابات أخرى.';
$string['filloutoneanswer'] = 'عليك إعطاء إجابة ممكنة واحدة على الأقل. الإجابات التي تترك فارغة لن تستعمل. \'*\' يمكن استعمالها بمثابة بديل لتقابل أي حرف. أول إجابة مطابقة سيتم استعمالها لتحديد الدرجة والإفادة.';
$string['filloutthreequestions'] = 'ينبغي إعطاء ثلاثة أسئلة على الأقل مع إجابات مقابلة. يمكنك وضع إجابات إضافية خاطئة عبر إعطاء الإجابة وترك السؤال فارغاً. المدخلات التي يكون فيها السؤال والجواب فارغين سيتم تجاهلها.';
$string['fillouttwochoices'] = 'يجب تعبيئة اختيارين على الأقل. الخيارات التي تترك فارغة لن تستخدم.';
$string['finishattemptdots'] = 'إنهاء المحاولة...';
$string['finishreview'] = 'إنهاء المراجعة';
$string['forceregeneration'] = 'أجبار التجديد';
$string['formatnotfound'] = 'تعذر العثور على صيغة الاستيراد/التصدير {$a}';
$string['formulaerror'] = 'أخطاء في المعادلة!';
$string['fractionsaddwrong'] = 'الدرجات الموجبة التي اخترتها لا تبلغ 100%<br />بل إنها تبلغ {$a}%<br />هل تريد الرجوع لتصويب هذا السؤال؟';
$string['fractionsnomax'] = 'لا بد أن يكون لأحد الإجابات 100%، حتى يكون<br />الحصول على الدرجة الكاملة لهذا السؤال ممكناً.<br />هل تريد الرجوع لتصويب هذا السؤال؟';
$string['fromfile'] = 'من ملف:';
$string['functiondisabledbysecuremode'] = 'هذه الوظيفة معطلة حالياً';
$string['generalfeedback'] = 'الإفادة العامة';
$string['generalfeedback_help'] = 'الإفادة العامة هي نص يتم إظهاره بعد محاولة السؤال. بخلاف الإفادة الخاصة بسؤال معين والتي تعتمد على الاستجابة المعطاة، نفس الإفادة العامة يتم إظهارها دائماً.';
$string['gobacktoquiz'] = 'عودة';
$string['graceperiod'] = 'فترة السماح للتسليم';
$string['graceperiod_desc'] = 'إن تم ضبط خيار ما ينبغي القيام به عند انتهاء وقت الاختبار على \'هناك فترة سماح...\'، فإذن هذا يمثل المهلة الافتراضية للوقت الإضافي المسموح به.';
$string['graceperiod_help'] = 'إن تم ضبط خيار ما ينبغي القيام به عند انتهاء وقت الاختبار على \'هناك فترة سماح...\'، فإذن هذا يمثل الوقت الإضافي المسموح به.';
$string['graceperiodmin'] = 'مهلة السماح عند آخر تسليم';
$string['graceperiodmin_desc'] = 'هناك مشكلة محتملة عند انتهاء الاختبار. من جهة، نحن نريد السماح للطلبة بمتابعة الإجابة حتى الثانية الأخيرة من الوقت المخصص لهم - بمساعدة عداد الوقت العكسي الذي يقوم تلقائياً بتسليم الاختبار عند استنفاد الوقت. من جهة أخرى، قد يكون المخدم عندها متعرضاً إلى حمل عالٍ وبحاجة إلى بعض الوقت لمعالجة الاستجابات. لهذا، سنتقبل الاستمرار حتى هذه المهلة بعد انتهاء الوقت الأصلي للاختبار لكي لا يتحمل الطلبة أي تبعات قد تنتج عن بطئ المخدم. مع ذلك، قد يلجأ الطالب إلى الغش ويستغل تلك الثواني لإجابة المزيد من أسئلة الاختبار. عليك إجراء موازنة مبنية على مقدار ثقتك بأداء المخدم خلال الاختبارات.';
$string['graceperiodtoosmall'] = 'مهلة السماح ينبغي أن تكون أكثر من {$a}.';
$string['gradeall'] = 'تقييم الكل';
$string['gradeaverage'] = 'متوسط الدرجة';
$string['gradeboundary'] = 'حد الدرجة';
$string['gradeessays'] = 'تقييم المقالات';
$string['gradehighest'] = 'أعلى درجة';
$string['gradeitemdefaultname'] = 'فقرة تقييم جديدة {$a}';
$string['gradeitemdelete'] = 'حذف فقرة التقييم {$a}';
$string['gradeitemedit'] = 'تعديل اسم فقرة التقييم {$a}';
$string['gradeitemmarkscheme'] = 'تعيين فقراة التقييم';
$string['gradeitemnewname'] = 'الاسم الجديد لفقرة التقييم {$a}';
$string['gradeitemnoneselected'] = '[لا أحد]';
$string['gradeitemnoslots'] = 'ليس لهذا الاختبار أسئلة بعد. يرجى إضافة الأسئلة أولاً، ثم ارجع هنا لتهيئة مفردات التقييم.';
$string['gradeitems'] = 'عناصر التقييم';
$string['gradeitemsautosetup'] = 'تهيئة الدرجة لكل قسم';
$string['gradeitemsetup'] = 'تهيئة مفردات التقييم';
$string['gradeitemsnoneyet'] = 'قم بإنشاء عناصر التقدير داخل الاختبار الخاص بك. قم بتخصيص أسئلة أو أقسام اختبار لعناصر التقدير هذه لتقسيم نتائج التقدير إلى مناطق مختلفة.';
$string['gradeitemsremoveall'] = 'إعادة تعيين التهيئة';
$string['gradeitemsremoveallconfirm'] = 'أتريد إعادة تعيين تهيئة مفردات التقييم؟';
$string['gradeitemsremoveallmessage'] = 'سيؤدي هذا إلى حذف كافة عناصر التقدير وإلغاء تعيين الأسئلة والأقسام منها.<br><br>لن يؤثر هذا الإجراء على الأسئلة والأقسام نفسها، ولا على المحاولات الموجودة داخل الاختبار.';
$string['gradeitemsremovealltitle'] = 'إعادة تعيين تهيئة مفردات التقييم';
$string['grademethod'] = 'طريقة التقييم';
$string['grademethod_help'] = 'عند السماح بمحاولات متعددة، تتوافر الطرق الآتية لاحتساب درجة الاختبار النهائية:

* أعلى درجة من جميع المحاولات
* متوسط (معدل) الدرجة من جميع المحاولات
* أول محاولة (كل المحاولات اللاحقة يتم تجاهلها)
* آخر محاولة (كل المحاولات السابقة يتم تجاهلها)';
$string['gradesdeleted'] = 'تم حذف درجات الاختبار';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'درجة النجاح لا يمكن أن تكون صفراً نظراً لأن هذا الاختبار يتضمن شرطاً لإكماله بالحصول على درجة النجاح. لطفاً، ضع قيمة لا صفرية.';
$string['gradetopassoutof'] = 'علامة النجاح: {$a->grade} من أصل {$a->maxgrade}';
$string['gradingdetails'] = 'علامات هذا التسليم: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'مع الغرامات السابقة، هذا يعطي <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'هذا التسليم يشتمل على غرامة مقدارها {$a}.';
$string['gradingdetailszeropenalty'] = 'لم يتم تغريمك لهذا التسليم.';
$string['gradingmethod'] = 'طريقة التقييم: {$a}';
$string['groupoverrides'] = 'تجاوزات المجموعة';
$string['groupoverridesdeleted'] = 'تم حذف تجاوزات المجموعة';
$string['groupsnone'] = 'لا مجموعات يمكنك الوصول إليها.';
$string['guestsno'] = 'معذرة! يتعذر على الضيوف أداء الاختبارات أو رؤيتها';
$string['hidebreaks'] = 'إخفاء فواصل الصفحات';
$string['hidereordertool'] = 'قم بإخفاء أداة إعادة الترتيب';
$string['history'] = 'ماضي الاستجابات:';
$string['howquestionsbehave_desc'] = 'الإعداد الافتراضي لسلوك الأسئلة في الاختبار.';
$string['imagedisplay'] = 'الصورة المراد عرضها';
$string['import_help'] = 'هذه الوظيفة تسمح لك باستيراد الأسئلة من ملفات نصية خارجية.

إذا كان ملفك محتوياً على حروف ليست بترميز ascii فعندها ينبغي أن تكون بترميز UTF-8. كن على حذر خاص من الملفات المنشأة باستعمال تطبيقات Microsoft Office، نظراً لكونها عادة ما تستعمل ترميزاً خاصاً لن يتم التعامل معه بشكل صحيح.

صيغ الاستيراد والتصدير هي موارد مضافة. قد تتوافر صيغ إختيارية أخرى في قاعدة بيانات الوحدات والإضافات.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'استيراد تصنيف';
$string['importerror'] = 'وقع خطأ خلال معالجة الاستيراد';
$string['importfilearea'] = 'الاستيراد من ملف موجود سلفاً ضمن ملفات المساق...';
$string['importfileupload'] = 'الاستيراد من رفع ملف...';
$string['importfromthisfile'] = 'الاستيراد من هذا الملف';
$string['importingquestions'] = 'يجري استيراد {$a} سؤال/أسئلة من الملف';
$string['importmax10error'] = 'هناك خطأ في السؤال. لا يمكن أن يكون للسؤال أكثر من عشر إجابات.';
$string['importmaxerror'] = 'هناك خطأ في السؤال. هناك إجابات كثيرة جداً.';
$string['importquestions'] = 'استيراد الاسئلة من ملف';
$string['inactiveoverridehelp'] = '* هذا التجاوز غير فعال بسبب تقييد وصول المستخدم إلى النشاط. هذا قد يُعزى إلى تعيين الدور أو المجموعة، تقييدات الوصول الأخرى، أو كون النشاط مخفي.';
$string['incorrect'] = 'خاطئ';
$string['indicator:cognitivedepth'] = 'الاختبار معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط الاختبار.';
$string['indicator:cognitivedepthdef'] = 'الاختبار معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات الاختبار خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم، معاينة الرد، التعليق على الرد، إعادة التقديم بعد معاينة الرد)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'الاختبار إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط الاختبار.';
$string['indicator:socialbreadthdef'] = 'الاختبار إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات الاختبار خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً، المشاركة مع الآخرين)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'إجابات الأفراد على كل فقرة';
$string['info'] = 'المعلومات';
$string['infoshort'] = 'م';
$string['initialnumfeedbacks'] = 'العدد الأولي لحقول الإفادة الشاملة';
$string['initialnumfeedbacks_desc'] = 'عند إنشاء اختبار جديد، أعطِ هذا العدد من خانات الإفادة الشاملة. بمجرد إنشاء الاختبار، سيظهر النموذج عدد الحقول المطلوب لوضع الإفادات الشاملة في الاختبار. هذا الإعداد يجب أن يكون 1 على الأقل.';
$string['inprogress'] = 'قيد التنفيذ';
$string['introduction'] = 'الوصف';
$string['invalidattemptid'] = 'لا توجد محاولة بهذا المُعرَّف';
$string['invalidcategory'] = 'مُعرَّف الصنف غير صحيح';
$string['invalidoverrideid'] = 'مُعرَّف تجاوز غير صحيح.';
$string['invalidquestionid'] = 'مُعرَّف سؤال غير صحيح';
$string['invalidquizid'] = 'مُعرَّف اختبار غير صحيح';
$string['invalidrandomslot'] = 'مُعرَّف خانة سؤال عشوائي غير صحيح.';
$string['invalidsource'] = 'لم يتم قبول المصدر كمصدر صحيح';
$string['invalidsourcetype'] = 'نوع المصدر غير صحيح';
$string['invalidstateid'] = 'مُعرَّف حالة غير صحيح';
$string['lastanswer'] = 'اجابتك السابقة كانت';
$string['lastautosave'] = 'آخر حفظ: {$a}';
$string['layout'] = 'تخطيط الصفحة';
$string['layoutasshown'] = 'تخطيط الصفحة كما تظهر به.';
$string['layoutasshownwithpages'] = 'تخطيط الصفحة كما تظهر به. <small>(صفحة جديدة تلقائياً لكل {$a} سؤال/أسئلة.)</small>';
$string['layoutshuffledandpaged'] = 'يتم خلط الأسئلة عشوائياً مع {$a} أسئلة/سؤال لكل صفحة.';
$string['layoutshuffledsinglepage'] = 'يتم خلط الأسئلة عشوائياً، كلها في صفحة واحدة.';
$string['link'] = 'رابط';
$string['listitems'] = 'قائمة بنود الاختبار';
$string['literal'] = 'حرفي';
$string['loadingquestionsfailed'] = 'فشل تحميل الأسئلة: {$a}';
$string['makecopy'] = 'احفظ كسؤال جديد';
$string['managetypes'] = 'إدارة أنوع الأسئلة ومخدماتها';
$string['manualgradequestion'] = 'إمنح الدرجة يدوياً للسؤال {$a->question} في {$a->quiz} للطالب {$a->user}';
$string['manualgrading'] = 'منح الدرجات';
$string['mark'] = 'تسليم';
$string['markall'] = 'صفحة التسليم';
$string['marks'] = 'العلامات';
$string['marks_help'] = 'الدرجة المكتسبة لكل لكل سؤال وإجنالي نتيجة المحاولة. بإمكانك اختيار الدرجات فقط إذا تم تحديد الدرجات القصوى.';
$string['match'] = 'مطابقة';
$string['matchanswer'] = 'الاجابة المطابقة';
$string['matchanswerno'] = 'الاجابة المطابقة {$a}';
$string['max'] = 'اقصى';
$string['maxmark'] = 'الدرجة العظمى';
$string['maxmarks'] = 'أعلى الدرجات';
$string['maxmarks_help'] = 'أعلى درجة متاحة لكل سؤال.';
$string['messageprovider:attempt_grading_complete'] = 'إشعار بأن محاولتك قد تم تقييمها';
$string['messageprovider:attempt_overdue'] = 'تحذير عندما تصير محاولتك للاختبار متأخرة';
$string['messageprovider:confirmation'] = 'تأكيدات التسليم للاختبارات الخاصة بك';
$string['messageprovider:quiz_open_soon'] = 'إقتراب موعد فتح الاختبار';
$string['messageprovider:submission'] = 'إشعارات تسليمات الطلاب للاختبار';
$string['min'] = 'ادنى';
$string['minutes'] = 'دقائق';
$string['missingcategory'] = 'صنف السؤال مفقود';
$string['missingcorrectanswer'] = 'يجب تحدي الاجابة الصحيحة';
$string['missingitemtypename'] = 'الاسم مفقود';
$string['missingquestion'] = 'هذا السؤال يبدو أنه لم يعد موجوداً';
$string['modulename'] = 'إختبار';
$string['modulename_help'] = 'يُمكن نشاط الاختبار المعلم من إنشاء إختبارات تضم أسئلة من مختلف الأنواع، بما فيها أسئلة الاختيار من متعدد، المطابقة، أجوبة قصيرة وأسئلة عددية.

يستطيع المعلم أن يسمح بعدة محاولات للاختبار، مع خلط الأسئلة أو اختيارها عشوائياً من بنك الأسئلة، كما يمكن تعيين مهلة زمنية.

يتم تلقائياً وضع علامة لكل محاولة، باستثناء الأسئلة المقالية، ويتم حفظ العلامة في سجل التقديرات.

يستطيع المعلم أن يختار متى، وفيما إذا كان سيتم إظهار أي تلميحات، إفادات، الأجوبة الصحيحة للطلاب.

يمكن استعمال الاختبارات:

* كامتحانات للمساق الدراسي
* كاختبارات قصيرة لواجبات القراءة أو اختبارات نهاية الموضوع
* كامتحان تدريبي باستعمال أسئلة من الامتحانات السابقة
* لإيصال إفادة تقويمية فورية حول الأداء
* للتقييم الذاتي';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'إختبارات';
$string['moveselectedonpage'] = 'أنقل الأسئلة المحددة إلى الصفحة: {$a}';
$string['multichoice'] = 'متعدد الخيارات';
$string['multipleanswers'] = 'إختر إجابة واحدة على الأقل.';
$string['mustbesubmittedby'] = 'لا بد من تسليم هذه المحاولة في {$a}.';
$string['name'] = 'اسم';
$string['navigatenext'] = 'الصفحة التالية';
$string['navigateprevious'] = 'الصفحة السابقة';
$string['navmethod'] = 'أسلوب التنقل';
$string['navmethod_free'] = 'حر';
$string['navmethod_help'] = 'عندما يتم تفعيل الانتقال التتابعي فإن الطالب يجب أن يتقدم في هذا الاختبار بشكل مرتب، ولن يتمكن من العودة للصفحات السابقة ولا تخطي أي صفحة.';
$string['navmethod_seq'] = 'تتابعي';
$string['navnojswarning'] = 'تحذير: هذه الروابط لن تحفظ إجاباتك. استعمل زر \'التالي" عند أسفل الصفحة.';
$string['neverallononepage'] = 'أبداً، كل الأسئلة في صفحة واحدة';
$string['newattemptfail'] = 'خطأ: تعذر البدء بمحاولة جديدة في الاختبار';
$string['newcategory'] = 'صنف جديد';
$string['newpage'] = 'صفحة جديدة';
$string['newpage_help'] = 'للاختبارات الطويلة، من المنطقي أن تمتد هذه الاختبارات على مدى عدة صفحات عن طريق الحد من عدد الأسئلة لكل صفحة. عند إضافة أسئلة إلى الاختبار، سيتم تلقائياً إدراج فواصل الصفحات وفقاً لهذا الإعداد. مع ذلك، فإن فواصل الصفحات يمكن نقلها يدوياً في صفحة التحرير.';
$string['newpageevery'] = 'إبدأ صفحة جديدة تلقائياً';
$string['newsectionheading'] = 'عنوان رأسي جديد';
$string['noanswers'] = 'لم يتم اختيار أي إجابات!';
$string['noattempts'] = 'لم تتم أي محاولات في هذا الاختبار';
$string['noattemptsfound'] = 'لا توجد محاولات.';
$string['noattemptstoshow'] = 'لا يوجد محاولات للقيام بعرضها';
$string['nocategory'] = 'لم يتم تحديد الصنف أو إن الصنف المحدد خاطئ';
$string['noclose'] = 'لا تاريخ إغلاق';
$string['nocommentsyet'] = 'لا توجد تعليقات بعد.';
$string['noconnection'] = 'لا يوجد حالياً اتصال بخدمة ويب يمكنها معالجة هذا السؤال. لطفاً، تواصل مع مشرفك.';
$string['nodataset'] = 'لا شيء - هذه ليست عبارة بديلة مطلقة';
$string['nodatasubmitted'] = 'لم يتم تقديم أي بيانات.';
$string['noessayquestionsfound'] = 'لم يتم العثور على أسئلة مقيمة يدوياً';
$string['nogradewarning'] = 'هذا الاختبار غير مقيم، لذلك لا يمكنك وضع إفادة شاملة تختلف حسب الدرجة.';
$string['nomoreattempts'] = 'غير مسموح بأي محاولات أخرى';
$string['none'] = 'لا شيء';
$string['noopen'] = 'لا تاريخ فتح';
$string['nooverridedata'] = 'عليك تجاوز واحداً من إعدادات الاختبار على الأقل.';
$string['nopossibledatasets'] = 'لا مجموعات بيانات ممكنة';
$string['noquestionintext'] = 'نص السؤال لا يتضمن أي أسئلة مُضمَّنة';
$string['noquestions'] = 'لم تتم إضافة أي أسئلة بعد';
$string['noquestionsfound'] = 'لم يتم العثور على اسئله';
$string['noquestionsinquiz'] = 'لا توجد أسئلة في هذا الاختبار.';
$string['noquestionsnotinuse'] = 'السؤال العشوائي هذا ليس مستعملاً نظراً لكون التصنيف العائد له فارغاً.';
$string['noquestionsonpage'] = 'صفحة فارغة';
$string['noresponse'] = 'لا توجد إجابة';
$string['noreview'] = 'لا تستطيع مراجعة هذا الاختبار';
$string['noreviewattempt'] = 'ليس مسموحاً لك بمراجعة هذه المحاولة.';
$string['noreviewshort'] = 'المراجعة غير مسموح بها';
$string['noreviewuntil'] = 'لا تستطيع مراجعة هذا الاختبار حتى {$a}';
$string['noreviewuntilshort'] = 'متاحة في {$a}';
$string['noscript'] = 'لا بد من تمكين JavaScript ليتسنى المواصلة!';
$string['notavailabletostudents'] = 'ملاحظة: هذا الاختبار ليس متاحاً حالياً لطلبتك.';
$string['notenoughrandomquestions'] = 'ليست هناك أسئلة كافية في الصنف {$a->category} لإنشاء السؤال {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'عدد الاسئلة الفرعية غير كافٍ!<br /> هل ترغب بالرجوع لتصويب هذا السؤال؟';
$string['notifyattemptsgradedtask'] = 'إرسال إشعارات تقييم محاولات الاختبار';
$string['notimedependentitems'] = 'العناصر المعتمدة على الوقت ليست مدعومة حالياً من قبل وحدة الاختبار. كإجراء بديل، قم بتحديد وقت الاختبار بأكمله. هل ترغب باختيار عنصر مختلف (أو استعمال العنصر الحالي بغض النظر)؟';
$string['notyetgraded'] = 'غير مُقيَّمة بعد';
$string['notyetviewed'] = 'غير معاين بعد';
$string['notyourattempt'] = 'هذه ليست محاولتك!';
$string['noview'] = 'المستخدم المسجل لدخوله غير مسموح له بمعاينة هذا الاختبار';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} قد قام بـ {$a->attemptnum} محاولات';
$string['numberabbr'] = '#';
$string['numerical'] = 'رقمي';
$string['numquestionsx'] = 'الأسئلة: {$a}';
$string['oneminute'] = 'دقيقة واحدة';
$string['onlyteachersexport'] = 'المعلمون فقط يمكنهم تصدير الأسئلة';
$string['onlyteachersimport'] = 'المعلمون ذوو حقوق التحرير فقط يمكنهم استيراد الأسئلة';
$string['onthispage'] = 'هذه الصفحة';
$string['open'] = 'غير مجاب عنه';
$string['openafterclose'] = 'تعذر تحديث الاختبار. لقد جعلت تاريخ الفتح بعد تاريخ الإغلاق.';
$string['openclosedatesupdated'] = 'تاريخي الفتح والإغلاق';
$string['optional'] = 'اختياري';
$string['orderandpaging'] = 'الترتيب وتنظيم الصفحات';
$string['orderandpaging_help'] = 'الأرقام 10، 20، 30، ... مقابل كل سؤال تشير إلى ترتيب الأسئلة. الزيادة في الأرقام هي 10 حتى تترك مجالاً لإدراج أسئلة إضافية. لإعادة ترتيب الأسئلة، قم بتغيير الأرقام ثم انقر زر "إعادة ترتيب الأسئلة".

لإضافة فواصل الصفحات بعد أسئلة معينة، قم بتأشير مربعات الاختيار بجوار الأسئلة ثم انقر زر "إضافة صفحات جديدة بعد الأسئلة المحددة".

لترتيب الأسئلة على عدد من الصفحات، أنقر زر "إعادة تعيين الصفحات" ثم حدد العدد المطلوب من الأسئلة لكل صفحة.';
$string['orderingquiz'] = 'الترتيب وتنظيم الصفحات';
$string['orderingquizx'] = 'الترتيب وتنظيم الصفحات: {$a}';
$string['outcomesadvanced'] = 'المخرجات هي إعدادات متقدمة';
$string['outof'] = '{$a->grade} من {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} من {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'الإفادة الشاملة';
$string['overallfeedback_help'] = 'الإفادة الشاملة هي النص الذي يظهر بعد الانتهاء من الاختبار. بتحديد حدود إضافية للدرجة (كنسبة مئوية أو كرقم)، فإن النص الذي يظهر يمكن أن يعتمد على الدرجة التي حصل عليها الطالب.';
$string['overdue'] = 'متأخر جدا';
$string['overduehandling'] = 'عند نفاد الوقت';
$string['overduehandling_desc'] = 'ما المفروض به أن يحدث إفتراضياً إذا لم يقم الطالب بتسليم الاختبار قبل نفاد الوقت.';
$string['overduehandling_help'] = 'هذا الإعداد يتحكم بما يحدث إذا فشل الطالب في تسليم الاختبار قبل نفاد الوقت. إذا كان الطالب منشغلاً تماماً بالاختبار في اللحظة التي يقوم فيها عداد الوقت العكسي بتسليم إجاباته نيابة عنه، ولكن الطالب كان قد سجل خروجه، فعندها هذا الإعداد يتحكم بما يحدث.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'ينبغي تسليم المحاولات قبل نفاد الوقت، أو لن يتم احتسابها';
$string['overduehandlingautosubmit'] = 'المحاولات الجارية يتم تسليمها تلقائياً';
$string['overduehandlinggraceperiod'] = 'هناك فترة سماح ليكون بالإمكان تسليم المحاولات الجارية، ولكن بدون إجابة المزيد من الأسئلة';
$string['overduemustbesubmittedby'] = 'هذه المحاولة متأخرة حالياً. كان ينبغي تسليمها مسبقاً. إذا كنت راغباً بالحصول على درجات من هذا الاختبار، فعليك تسليمه في {$a}. إذا لم تقم بتسليمه عندها، لن يتم احتساب أي درجات من هذه المحاولة.';
$string['override'] = 'تجاوز';
$string['overridecannotchange'] = 'لا يمكن تغيير المستخدم أو المجموعة بعد إنشاء التجاوز.';
$string['overridecannotsetbothgroupanduser'] = 'لا يمكن تعيين كل من المجموعة والمستخدم في نفس الوقت.';
$string['overridedeletegroupsure'] = 'هل أنت متأكد من رغبتك في حذف التجاوز للمجموعة {$a}؟';
$string['overridedeleteusersure'] = 'هل أنت متأكد من رغبتك في حذف التجاوز للمستخدم {$a}؟';
$string['overridegroup'] = 'تجاوز المجموعة';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'يجب أن تكون قيمة المحاولات أكبر من الصفر.';
$string['overrideinvalidexistingid'] = 'التجاوز الحالي غير موجود.';
$string['overrideinvalidgroup'] = 'المجموعة المقدمة غير موجودة.';
$string['overrideinvalidquiz'] = 'مجموعة معرفات الاختبار غير موجودة.';
$string['overrideinvalidtimelimit'] = 'يجب أن يكون الحد الزمني أكبر من الصفر.';
$string['overrideinvaliduser'] = 'المستخدم المحدد غير موجود.';
$string['overridemissingdelete'] = 'لا يمكن حذف معرفات التجاوز {$a} لأنها غير موجودة أو ليست جزءًا من الاختبار المحدد.';
$string['overridemultiplerecordsexist'] = 'لا يمكن إجراء تجاوزات متعددة لنفس المستخدم/المجموعة.';
$string['overridemustsetuserorgroup'] = 'يجب تعيين مستخدم أو مجموعة.';
$string['overrides'] = 'التجاوزات';
$string['overridesforquiz'] = 'تجاوزات الإعدادات: {$a}';
$string['overridesnoneforgroups'] = 'لم يتم إنشاء تجاوزات في إعدادات المجموعة لهذا الاختبار.';
$string['overridesnoneforusers'] = 'لم يتم إنشاء تجاوزات في إعدادات المستخدمين لهذا الاختبار.';
$string['overridessummary'] = 'توجد تجاوزات في الإعدادات ({$a})';
$string['overridessummarygroup'] = 'المجموعات: {$a}';
$string['overridessummarythisgroup'] = 'توجد تجاوزات في الإعدادات ({$a}) لهذه المجموعة';
$string['overridessummaryuser'] = 'المستخدمون: {$a}';
$string['overridessummaryyourgroups'] = 'توجد تجاوزات في الإعدادات ({$a}) لمجموعاتك';
$string['overrideuser'] = 'تجاوز المستخدم';
$string['overrideusereventname'] = 'تجاوز - {$a->quiz}';
$string['page-mod-quiz-attempt'] = 'صفحة محاولة الاختبار';
$string['page-mod-quiz-edit'] = 'صفحة تحرير الاختبار';
$string['page-mod-quiz-report'] = 'أي صفحة من تقرير الاختبار';
$string['page-mod-quiz-review'] = 'صفحة مراجعة محاولة الاختبار';
$string['page-mod-quiz-summary'] = 'صفحة ملخص محاولة الاختبار';
$string['page-mod-quiz-view'] = 'صفحة معلومات الاختبار';
$string['page-mod-quiz-x'] = 'أي صفحة لوحدة الاختبار';
$string['pageshort'] = 'ص';
$string['pagesize'] = 'حجم الصفحة';
$string['parent'] = 'الرتبة الأعلى';
$string['parentcategory'] = 'الصنف الأعلى';
$string['parsingquestions'] = 'يجري تحليل الأسئلة من ملف الاستيراد.';
$string['partiallycorrect'] = 'صحيح جزئياً';
$string['penalty'] = 'الغرامة';
$string['penaltyscheme'] = 'طبق العقوبات';
$string['penaltyscheme_help'] = 'عند تمكينه، يتم طرح الغرامة من الدرجة النهائية للسؤال على الإجابة الخاطئة. مقدار الغرامة محدد في إعدادات السؤال. هذا الإعداد يُطبق فقط عند تمكين النمط المتكيف.';
$string['percentcorrect'] = 'نسبة الصح';
$string['pleaseclose'] = 'لقد تمت معالجة طلبك. يمكنك الآن إغلاق هذه النافذة.';
$string['pluginadministration'] = 'إدارة الاختبار';
$string['pluginname'] = 'الاختبار';
$string['popup'] = 'أظهر الاختبار في نافذة \'مؤمنة\'';
$string['popupblockerwarning'] = 'هذا القسم من الاختبار يجري بنمط آمن، وهذا يعني أن عليك أخذ الاختبار عبر نافذة آمنة. لطفاً، أغلق مانع النوافذ المنبثقة في متصفحك. شكراً.';
$string['popupnotice'] = 'سيشاهد الطلبة هذا الاختبار في نافذة آمنة';
$string['precreateattempts'] = 'الإنشاء المسبق للمحاولات';
$string['precreateattempts_desc'] = 'عند تمكينه، سيتم إنشاء محاولات للاختبارات قبل موعد فتحها، بناءً على "فترة الإنشاء المسبق" التي ينبغي ضبطها أيضًا.

يمنع هذا طفرات تحميل المخدم عند بدء الطلاب لاختبارات معقدة أو متعددة دفعة واحدة.

لا تتأثر الاختبارات التي لا تحتوي على وقت فتح بذلك.

في حال قفل هذا الإعداد، يتم تفعيله أو إيقافه إجباريًا لكل الاختبارات.
في حال فتحه وضبط "فترة الإنشاء المسبق"، يمكن للاختبارات تمكين هذه الميزة. أما في حال عدم ضبط "فترة الإنشاء المسبق"، فلن يظهر هذا الإعداد في نموذج إعدادات الاختبار.';
$string['precreateattempts_help'] = 'الإنشاء المسبق للمحاولات يساعد في تحسين أداء الموقع. لا يمكن تعديل أسئلة الاختبار بمجرد وجود محاولات لها.';
$string['precreateoff'] = 'لا تقم بالإنشاء المسبق للمحاولات';
$string['precreateperiod'] = 'فترة الإنشاء المسبق';
$string['precreateperiod_desc'] = 'الفترة التي تسبق وقت فتح الاختبار، والتي سيتم فيها إنشاء المحاولات مسبقًا.

يتم إنشاء المحاولات بواسطة المهمة المجدولة (mod_quiz\\task\\precreate_attempts) تعمل كل ساعة افتراضيًا.

بما أنه لا يمكن تعديل الاختبارات بعد توفر المحاولات، فمن الأفضل جعل هذه الفترة قصيرة قدر الإمكان.

إذا كنت تميل إلى بدء اختبار واحد أو مجموعة اختبارات في وقت واحد، فمن الأفضل أن تكون هذه الفترة قصيرة، مثل ساعة واحدة.

إذا كان لديك عدة اختبارات تبدأ في أوقات مختلفة خلال اليوم، وترغب في أن تتم كل عمليات الإنشاء المسبق عندما يكون النظام هادئًا، مثلًا أثناء الليل، يمكنك ضبط هذه الفترة على فترة أطول، مثل ١٢ ساعة، وضبط المهمة المجدولة لتعمل خلال ساعات الهدوء.

يتم التحكم في هذا الإعداد على مستوى الموقع، ولا يمكن تجاوزه من خلال اختبارات فردية.';
$string['precreatetask'] = 'الإنشاء المسبق للمحاولات';
$string['precreateusedefault'] = 'استعمل الوضع الافتراضي للموقع ({$a})';
$string['precreateyes'] = 'نعم، {$a} من الساعات قبل وقت فتح الاختبار';
$string['preprocesserror'] = 'وقع خطأ في أثناء المعالجة القبلية!';
$string['preview'] = 'معاينة';
$string['previewquestion'] = 'معاينة السؤال';
$string['previewquiz'] = 'استعراض {$a}';
$string['previewquiznow'] = 'استعراض الاختبار الآن';
$string['previewquizstart'] = 'استعراض الاختبار';
$string['previous'] = 'الوضع السابق';
$string['privacy:metadata:core_question'] = 'نشاط الاختبار يحفظ معلومات استعمال الأسئلة في نظام الأسئلة المركزي';
$string['privacy:metadata:quiz'] = 'نشاط الاختبار يستعمل تقارير الاختبار';
$string['privacy:metadata:quiz_attempts'] = 'تفاصيل عن كل محاولة في الاختبار';
$string['privacy:metadata:quiz_attempts:attempt'] = 'رقم المحاولة';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'الصفحة الحالية التي يقف عندها المستخدم';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'الوقت التي تم فيه إشعار المستخدم باكتمال التقييم اليدوي لمحاولته';
$string['privacy:metadata:quiz_attempts:preview'] = 'فيما كان هذا استعراض للاختبار';
$string['privacy:metadata:quiz_attempts:state'] = 'الحالة الحالية للمحاولة';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'مجموع الدرجات في المحاولة';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'وقت التحقق من الحالة';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'وقت إكمال المحاولة';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'وقت تحديث المحاولة';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'وقت تحديث المحاولة عبر التحديث بدون اتصال';
$string['privacy:metadata:quiz_attempts:timestart'] = 'وقت بدء المحاولة';
$string['privacy:metadata:quiz_grades'] = 'تفاصيل عن العلامة الإجمالية لهذا الاختبار';
$string['privacy:metadata:quiz_grades:grade'] = 'الدرجة الإجمالية لهذا الاختبار';
$string['privacy:metadata:quiz_grades:quiz'] = 'الاختبار الذي تم تقييمه';
$string['privacy:metadata:quiz_grades:timemodified'] = 'وقت تحديث العلامة';
$string['privacy:metadata:quiz_grades:userid'] = 'المستخدم الذي تم تقييمه';
$string['privacy:metadata:quiz_overrides'] = 'تفاصيل عن تجاوزات هذا الاختبار';
$string['privacy:metadata:quiz_overrides:quiz'] = 'الاختبار مع معلومات التجاوز';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'وقت الإغلاق الجديد للاختبار';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'الوقت المحدد الجديد للاختبار';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'وقت الفتح الجديد للاختبار';
$string['privacy:metadata:quiz_overrides:userid'] = 'المستخدم ذي التجاوز';
$string['privacy:metadata:quizaccess'] = 'نشاط الاختبار يستعمل قواعد الوصول إلى الاختبار';
$string['publish'] = 'نشر';
$string['publishedit'] = 'ينبغي أن تكون لديك صلاحية في المساق المنشور لإضافة الأسئلة أو تحريرها في هذا الصنف';
$string['qbrief'] = 'س. {$a}';
$string['qname'] = 'الاسم';
$string['qti'] = 'تنسيق IMS QTI';
$string['qtypename'] = 'النوع، الاسم';
$string['question'] = 'سؤال';
$string['questionbank'] = 'من بنك الأسئلة';
$string['questionbankmanagement'] = 'إدارة بنك الأسئلة';
$string['questionbehaviour'] = 'سلوك السؤال';
$string['questioncats'] = 'أصناف الأسئلة';
$string['questiondeleted'] = 'لقد تم حذف هذا السؤال. لطفاً، تواصل مع معلمك.';
$string['questiondependencyadd'] = 'لا تقييد بشأن موعد محاولة السؤال {$a->thisq}. أنقر للتغيير.';
$string['questiondependencyfree'] = 'لا تقييد على هذا السؤال';
$string['questiondependencyremove'] = 'لا يمكن محاولة السؤال {$a->thisq} حتى إكمال السؤال السابق {$a->previousq}. أنقر للتغيير.';
$string['questiondependsonprevious'] = 'لا يمكن محاولة هذا السؤال حتى إكمال السؤال السابق.';
$string['questiondraftonly'] = 'السؤال {$a} هو في وضع المسودة، لاستعماله في الاختبار، قم بزيارة بنك الأسئلة واضبط الوضع إلى جاهز.';
$string['questiondraftwillnotwork'] = 'هذا السؤال هو في وضع المسودة. لاستعماله في الاختبار، قم بزيارة بنك الأسئلة واضبط الوضع إلى جاهز.';
$string['questioninuse'] = 'السؤال \'{$a->questionname}\' يتم حالياً استعماله في: <br />{$a->quiznames}<br />لن يتم حذف السؤال من تلك الاختبارات ولكن فقط من قائمة التصنيف.';
$string['questionmissing'] = 'سؤال هذه الجلسة مفقود';
$string['questionname'] = 'اسم السؤال';
$string['questionnonav'] = '<span class="accesshide">السؤال </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">المعلومات </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'لم يتم تحميل السؤال {$a} من قاعدة البيانات';
$string['questionorder'] = 'ترتيب السؤال';
$string['questionposition'] = 'موضع جديد للسؤال {$a}';
$string['questions'] = 'أسئلة';
$string['questionsetpreview'] = 'استعراض مجموعة الأسئلة';
$string['questionsinclhidden'] = 'الأسئلة (بضمنها المخفي)';
$string['questionsinthisquiz'] = 'الأسئلة في هذا الاختبار';
$string['questionsmatchingfilter'] = 'الأسئلة المطابقة لهذا المرشح: {$a}';
$string['questionsperpage'] = 'عدد الاسئلة لكل صفحة';
$string['questionsperpageselected'] = 'تم ضبط الأسئلة في الصفحة بحيث تكون ثابتة. نتيجة لذلك، تم تعطيل أدوات التحكم بالصفحات. يمكنك تغيير ذلك في {$a}.';
$string['questionsperpagex'] = 'الأسئلة لكل صفحة: {$a}';
$string['questiontext'] = 'نص السؤال';
$string['questiontextisempty'] = '[نص السؤال فارغ]';
$string['questiontype'] = 'نوع السؤال {$a}';
$string['questiontypesetupoptions'] = 'خيارات إعداد أنواع الأسئلة:';
$string['questionversion'] = 'إصدار{$a}';
$string['questionversionlatest'] = 'إصدار{$a} (الأخير)';
$string['quiz:addinstance'] = 'إضافة اختبار جديد';
$string['quiz:attempt'] = 'محاولة الاختبارات';
$string['quiz:deleteattempts'] = 'حذف محاولات الاختبار';
$string['quiz:emailconfirmsubmission'] = 'تلقي رسالة تأكيد لتسليمات الاختبارات الخاصة بك';
$string['quiz:emailnotifyattemptgraded'] = 'تلقي إشعار عند تقييم محاولتك';
$string['quiz:emailnotifysubmission'] = 'تلقي رسالة تأكيد لتسليمات الاختبارات الخاصة بطلابك';
$string['quiz:emailwarnoverdue'] = 'تلقي رسالة تأكيد عندما تصير محاولتك للاختبار متأخرة';
$string['quiz:grade'] = 'وضع درجات الاختبارات يدوياً';
$string['quiz:ignoretimelimits'] = 'تجاهل الوقت المحدد للاختبار';
$string['quiz:manage'] = 'إدارة الاختبارات';
$string['quiz:manageoverrides'] = 'إدارة تجاوزات إعدادات الاختبار';
$string['quiz:preview'] = 'معاينة الاختبارات';
$string['quiz:regrade'] = 'إعادة تقييم محاولات الاختبار';
$string['quiz:reopenattempts'] = 'إعادة الفتح لم تؤدي إلى تسليم محاولات الاختبار';
$string['quiz:reviewmyattempts'] = 'مراجعة محاولاته';
$string['quiz:view'] = 'معاينة معلومات الاختبار';
$string['quiz:viewoverrides'] = 'معاينة تجاوزات إعدادات الاختبار';
$string['quiz:viewreports'] = 'معاينة تقارير الاختبار';
$string['quizavailable'] = 'الاختبار متاح حتى : {$a}';
$string['quizclose'] = 'إغلاق الاختبار';
$string['quizclosed'] = 'تم غلق هذا الاختبار في {$a}';
$string['quizcloses'] = 'سيغلق الاختبار';
$string['quizcloseson'] = 'هذا الاختبار سيغلق في {$a}.';
$string['quizeventcloses'] = '{$a} يُغلق';
$string['quizeventopens'] = '{$a} يُفتح';
$string['quizinvalidquestions'] = 'هذا الاختبار يحتوي على أسئلة من أنواع غير صالحة. تنبغي إعادة تنصيب أنواع الأسئلة المفقودة أو سيُصار إلى إزالة تلك الأسئلة قبل أن يتسنى استعمال الاختبار.';
$string['quizisclosed'] = 'هذا الاختبار مغلق';
$string['quizisclosedwillopen'] = 'الاختبار مغلق (يُفتح {$a})';
$string['quizisopen'] = 'هذا الاختبار مفتوح';
$string['quizisopenwillclose'] = 'الاختبار مفتوح (يُغلق {$a})';
$string['quiznavigation'] = 'تنقل الاختبار';
$string['quizopen'] = 'إفتح الاختبار';
$string['quizopenclose'] = 'تاريخا الفتح والإغلاق';
$string['quizopenclose_help'] = 'يمكن للطلبة الشروع بمحاولاتهم فقط بعد وقت الفتح وعليهم إكمالها قبل وقت الإغلاق.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>مرحبًا {$a->firstname}،</p>
<p>إن الاختبار <strong>{$a->quizname}</strong> الذي في المساق {$a->coursename} سيُفتح قريبًا.
<p><strong>موعد الفتح: {$a->timeopen}</strong></p>
<p><strong>موعد الإغلاق: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">الذهاب إلى الاختبار</a></p>';
$string['quizopendatesoonsubject'] = 'يُفتح في {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'هذا الاختبار مفتوح.';
$string['quizopenedon'] = 'هذا الاختبار فُتح في {$a}';
$string['quizopens'] = 'يفتح الاختبار';
$string['quizopenwillclose'] = 'هذا الاختبار مفتوح، سيُغلق في {$a}';
$string['quizordernotrandom'] = 'ترتيب الاختبار غير عشوائي';
$string['quizorderrandom'] = '* ترتيب الاختبار عشوائي';
$string['quizreport'] = 'تقرير الاختبار';
$string['quizsettings'] = 'إعدادات الأمتحان';
$string['quizsetupnavigation'] = 'التنقل في إعداد الاختبار';
$string['quiztimer'] = 'عداد وقت الاختبار';
$string['quizwillopen'] = 'هذا الاختبار سيُفتتح {$a}';
$string['random'] = 'سؤال عشوائي';
$string['randomcatwithsubcat'] = '{$a} وأصنافه الفرعية';
$string['randomcoursecatwithsubcat'] = 'أي أصناف ضمن التصنيف {$a}';
$string['randomcoursewithsubcat'] = 'أي صنف في هذا المساق';
$string['randomcreate'] = 'إنشاء أسئلة عشوائية';
$string['randomediting'] = 'يجري تحرير سؤال عشوائي';
$string['randomfaultynosubcat'] = 'سؤال مغلوط';
$string['randomfromcategory'] = 'سؤال عشوائي من الصنف:';
$string['randomfromexistingcategory'] = 'سؤال عشوائي من صنف موجود';
$string['randomfromunavailabletag'] = '{$a} (غير متاح)';
$string['randommodulewithsubcat'] = 'أي صنف من هذا الاختبار';
$string['randomnosubcat'] = 'الأسئلة من هذا الصنف فقط، وليس من أصنافه الفرعية.';
$string['randomnumber'] = 'عدد الأسئلة العشوائية';
$string['randomqname'] = 'أسئلة عشوائية بالاستناد إلى شرط المُرشح';
$string['randomqnamecat'] = 'عشوائي ({$a->category}) مبني على شرط المرشح';
$string['randomqnamecattags'] = 'عشوائي ({$a->category}) مبني على شرط المرشح ذي الوسوم: {$a->tags}';
$string['randomqnametags'] = 'أسئلة عشوائية بالاستناد إلى شرط المُرشح ذات الوسوم: {$a}';
$string['randomquestion'] = 'سؤال عشوائي';
$string['randomquestion_help'] = 'السؤال العشوائي هو طريقة لإدراج سؤال منتخب عشوائياً من صنف معين أو بواسطة وسم معين في نشاط ما.';
$string['randomquestiontags'] = 'الوسوم';
$string['randomquestiontags_help'] = 'يمكنك تقييد معايير الانتخاب أكثر عبر تحديد بعض وسوم الأسئلة هنا.

السؤال "العشوائي" سيتم انتخابه من الأسئلة التي تحمل كل تلك الوسوم.';
$string['randomquestionusinganewcategory'] = 'سؤال عشوائي باستعمال صنف جديد';
$string['randomsystemwithsubcat'] = 'أي صنف أسئلة على مستوى النظام';
$string['randomwithsubcat'] = 'الأسئلة من هذا التصنيف وتفرعاته.';
$string['readytosend'] = 'أنت بصدد إرسال اختبارك بالكامل للتقييم. هل أنت متأكد وتريد الاستمرار؟';
$string['reattemptquiz'] = 'إعادة محاولة الاختبار';
$string['recentlyaddedquestion'] = 'سؤال أضيف حديثاً!';
$string['recurse'] = 'تضمين الأسئلة من التصنيفات الفرعية أيضاً';
$string['redoesofthisquestion'] = 'الأسئلة الأخرى التي تمت محاولتها هنا: {$a}';
$string['redoquestion'] = 'جرب سؤالاً آخر مثل هذا';
$string['regrade'] = 'إعادة تصنيف كل المحاولات';
$string['regradecomplete'] = 'تم إعادة تصنيف كل المحاولات';
$string['regradecount'] = '{$a->changed} من {$a->attempt} درجات تم تغييرها';
$string['regradedisplayexplanation'] = 'المحاولات التي تغيرت خلال إعادة التقييم يتم عرضها بشكل روابط إلى نافذة مراجعة السؤال';
$string['regradenotallowed'] = 'ليست لديك صلاحية إعادة تقييم هذا الاختبار';
$string['regradingquestion'] = 'تجري إعادة تقييم "{$a}".';
$string['regradingquiz'] = 'تجري إعادة تقييم الاختبار "{$a}".';
$string['remove'] = 'إزالة';
$string['removeallgroupoverrides'] = 'كل تجاوزات المجموعة';
$string['removeallquizattempts'] = 'كل محاولات الاختبار';
$string['removealluseroverrides'] = 'كل تجاوزات المستخدم';
$string['removeemptypage'] = 'أزل الصفحة الفارغة';
$string['removepagebreak'] = 'إزالة فاصل الصفحات';
$string['removeselected'] = 'إزل المحددة';
$string['rename'] = 'إعادة تسمية';
$string['renderingserverconnectfailed'] = 'فشل المخدم {$a} في معالجة طلب RQP. تحقق من صحة الرابط.';
$string['reopenattempt'] = 'إعادة الفتح';
$string['reopenattemptareyousuremessage'] = 'هذا سيعيد فتح ال {$a->attemptnumber} العائدة لـ {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'أتريد إعادة فتح المحاولة؟';
$string['reopenattemptwrongstate'] = 'المحاولة {$a->attemptid} هي في الوضعية الخطأ ({$a->state}) ليُصار إلى إعادة فتحها.';
$string['reopenedattemptwillbeinprogress'] = 'المحاولة ستبقى مفتوحة ويمكن الاستمرار بها.';
$string['reopenedattemptwillbeinprogressuntil'] = 'المحاولة ستبقى مفتوحة ويمكن الاستمرار بها حتى إغلاق الاختبار في {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'المحاولة ستُسلم فورًا لغرض التقييم.';
$string['reorderquestions'] = 'أعد ترتيب الأسئلة';
$string['reordertool'] = 'أظهر أداة إعادة الترتيب';
$string['repaginate'] = 'إعادة ترتيب الصفحات ليكون هناك {$a} من الأسئلة لكل صفحة';
$string['repaginatecommand'] = 'أعد تنظيم الصفحات';
$string['repaginatenow'] = 'أعد تنظيم الصفحات الآن';
$string['replace'] = 'استبدال';
$string['replacementoptions'] = 'خيارات الاستبدال';
$string['report'] = 'تقارير';
$string['reportanalysis'] = 'تحليل البنود';
$string['reportattemptsfrom'] = 'المحاولات من';
$string['reportattemptsthatare'] = 'المحاولات التي';
$string['reportdisplayoptions'] = 'خيارات العرض';
$string['reportfullstat'] = 'إحصائيات مفصلة';
$string['reportmulti_percent'] = 'متعدد النسب';
$string['reportmulti_q_x_student'] = 'خيارات لطلاب متعددين';
$string['reportmulti_resp'] = 'الإجابات الفردية';
$string['reportmustselectstate'] = 'عليك اختيار حالة واحدة على الأقل.';
$string['reportnotfound'] = 'التقرير غير معروف ({$a})';
$string['reportoverview'] = 'نظرة عامة';
$string['reportregrade'] = 'إعادة تصحيح المحاولات';
$string['reportresponses'] = 'إجابات مفصلة';
$string['reports'] = 'التقارير';
$string['reportshowonly'] = 'أظهر المحاولات فقط';
$string['reportshowonlyfinished'] = 'أظهر محاولة مكتملة واحدة على الأقل لكل مستخدم ({$a})';
$string['reportsimplestat'] = 'إحصائيات مبسطة';
$string['reportusersall'] = 'كل المستخدمين الذين لديهم محاولة للاختبار';
$string['reportuserswith'] = 'المستخدمون المنضمون الذين لديهم محاولة للاختبار';
$string['reportuserswithorwithout'] = 'المستخدمون المنضمون الذين لديهم، أو ليست لديهم محاولة للاختبار';
$string['reportuserswithout'] = 'المستخدمون المنضمون الذين ليست لديهم محاولة للاختبار';
$string['reportwhattoinclude'] = 'ما سيتضمنه التقرير';
$string['requirepassword'] = 'يتطلب كلمة مرور';
$string['requirepassword_help'] = 'إذا تم تحديد كلمة المرور، على الطالب إدخالها من أجل محاولة الاختبار.';
$string['requiresubnet'] = 'يتطلب عنوان شبكة';
$string['requiresubnet_help'] = 'يمكن تقييد الوصول إلى الاختبار حسب شبكة فرعية معينة ضمن الشبكة المحلية أو الإنترنت عبر تحديد قائمة مفصولة بفوارز لعناوين IP كاملة أو جزئية. قد يكون هذا الأمر مفيداً في الاختبار غير الخاضع للمراقبة لضمان كون الأشخاص المتواجدين فقط في موقع معين يمكنهم الوصول إلى الاختبار.';
$string['response'] = 'إجابة';
$string['responses'] = 'إجابات';
$string['results'] = 'نتائج';
$string['returnattempt'] = 'عودة إلى المحاولة';
$string['reuseifpossible'] = 'اعد استخدام المبعد سابقاً';
$string['reverttodefaults'] = 'الرجوع إلى افتراضات الاختبار';
$string['review'] = 'مراجعة';
$string['reviewafter'] = 'السماح بالمراجعة بعد الاختبار';
$string['reviewalways'] = 'السماح بالمراجعة في أي وقت';
$string['reviewattempt'] = 'مراجعة المحاولة';
$string['reviewbefore'] = 'السماح بالمراجعة اثناء الاختبار';
$string['reviewclosed'] = 'بعد إغلاق الاختبار';
$string['reviewduring'] = 'في أثناء المحاولة';
$string['reviewimmediately'] = 'مباشرة بعد المحاولة';
$string['reviewnever'] = 'لا تسمح بالمراجعة أبداً';
$string['reviewofquestion'] = 'مراجعة السؤال {$a->question} في {$a->quiz} من قبل {$a->user}';
$string['reviewopen'] = 'لاحقاً، بينما لا يزال الاختبار مفتوحاً';
$string['reviewoptions'] = 'الطلبة يمكنهم المراجعة';
$string['reviewoptionsheading'] = 'خيارات المراجعة';
$string['reviewoptionsheading_help'] = 'هذه الخيارات تتحكم بالمعلومات التي يمكن للطلبة مشاهدتها عند مراجعتهم لمحاولة الاختبار أو النظر في تقاريره.

إعدادات **في أثناء المحاولة** تقتصر على بعض سلوكيات الأسئلة، مثل \'تفاعلي مع محاولات متعددة\'، والتي قد تعرض الإفادة في أثناء المحاولة.

إعدادات  **مباشرة بعد المحاولة** تُطبق فقط عند أول دقيقتين بعد النقر على \'تسليم الكل والإنهاء\'.

إعدادات **لاحقاً، بينما لا يزال الاختبار مفتوحاً** تُطبق بعدها، وقبل تاريخ إغلاق الاختبار.

إعدادات **بعد إغلاق الاختبار** تُطبق بعد انقضاء تاريخ إغلاق الاختبار. إذا لم يكن للاختبار تاريخ إغلاق، لن يتم الوصول إلى هذه الحالة أبداً.';
$string['reviewoverallfeedback'] = 'الإفادة الشاملة';
$string['reviewoverallfeedback_help'] = 'الإفادة المعطاة عند انتهاء المحاولة، اعتماداً على الدرجة الإجمالية للطالب.';
$string['reviewresponse'] = 'مراجعة الاجابة';
$string['reviewresponsetoq'] = 'مراجعة الإجابة (السؤال {$a})';
$string['reviewthisattempt'] = 'راجع إجاباتك في هذه المحاولة';
$string['rqp'] = 'السؤال البعيد';
$string['rqps'] = 'الأسئلة البعيدة';
$string['sameasoverall'] = 'كما هو بالنسبة إلى الدرجات النهائية';
$string['save'] = 'حفظ';
$string['saveandedit'] = 'حفظ التغييرات وتحرير الأسئلة';
$string['saveattemptfailed'] = 'فشل حفظ المحاولة الحالية للاختبار.';
$string['savedfromdeletedcourse'] = 'محفوظ من مساق محذوف "{$a}"';
$string['savegrades'] = 'حفظ الدرجات';
$string['savemanualgradingfailed'] = 'لم يتم حفظ التعديلات. يرجى الاطلاع على الرسالة أدناه ثم المحاولة مرة أخرى.';
$string['savemyanswers'] = 'حفظ إجاباتي';
$string['savenosubmit'] = 'أحفظ بدون تسليم';
$string['saveoverrideandstay'] = 'إحفظ وأدخل تجاوزاً آخر';
$string['savequiz'] = 'حفظ هذا الاختبار كاملا';
$string['saving'] = 'يجري الحفظ';
$string['savingnewgradeforquestion'] = 'يجري حفظ درجة جديدة للسؤال ذي المُعرَّف {$a}.';
$string['savingnewmaximumgrade'] = 'يجري حفظ درجة عظمى جديدة.';
$string['score'] = 'النقاط المسجلة بدون تعديل';
$string['scores'] = 'الدرجات';
$string['search:activity'] = 'الاختبار - معلومات النشاط';
$string['searchbyname'] = 'البحث حسب الاسم...';
$string['sectionheadingedit'] = 'تحرير العنوان الرأسي \'{$a}\'';
$string['sectionheadingremove'] = 'إزالة العنوان الرأسي \'{$a}\'';
$string['sectionnoname'] = 'قسم بلا عنوان';
$string['seequestions'] = '(أنظر الأسئلة)';
$string['select'] = 'اختيار';
$string['selectall'] = 'إختر الكل';
$string['selectattempt'] = 'إختر المحاولة';
$string['selectcategory'] = 'إختر الصنف';
$string['selectedattempts'] = 'المحاولات المختارة';
$string['selectmultipleitems'] = 'إختر عناصر متعددة';
$string['selectmultipletoolbar'] = 'شريط أدوات الاختيار المتعدد';
$string['selectnone'] = 'إلغاء تحديد الكل';
$string['selectquestionbank'] = 'إختر بنك الأسئلة';
$string['selectquestionslot'] = 'إختر السؤال {$a}';
$string['selectquestiontype'] = '-- إختر نوع السؤال --';
$string['sendnotificationopendatesoon'] = 'إشعار المستخدم باقتراب تاريخ فتح الاختبار';
$string['serveradded'] = 'تم إضاف خادم';
$string['serveridentifier'] = 'مؤشر';
$string['serverinfo'] = 'معلومات المخدم';
$string['servers'] = 'خوادم';
$string['serverurl'] = 'عوان الخادم';
$string['shortanswer'] = 'إجابة قصيرة';
$string['show'] = 'عرض';
$string['showall'] = 'أظهر كل الأسئلة في صفحة واحدة';
$string['showblocks'] = 'أظهر الكتل خلال محاولات الاختبار';
$string['showblocks_help'] = 'إذا تم ضبطه على نعم، فعندها سيتم إظهار الكتل الاعتيادية في أثناء محاولات الاختبار';
$string['showbreaks'] = 'عَرض فواصل الصفحات';
$string['showcategorycontents'] = 'إظهار محتويات الصنف {$a->arrow}';
$string['showcorrectanswer'] = 'هل تعرض الإجابات الصحيحة في التعليق؟';
$string['showdetailedmarks'] = 'أظهر تفاصيل العلامة';
$string['showeachpage'] = 'أظهر صفحة واحدة كل مرة';
$string['showfeedback'] = 'عرض التعليق بعد الإجابة?';
$string['showinsecurepopup'] = 'استعمل نافذة منبثقة \'آمنة\' للمحاولات';
$string['showlargeimage'] = 'صورة كبيرة';
$string['shownoattempts'] = 'أعرض الطلاب الذين لم يقوموا بمحاولات';
$string['shownoattemptsonly'] = 'أظهر الطلبة الذين ليس لديهم محاولات فقط';
$string['shownoimage'] = 'بلا صورة';
$string['showreport'] = 'أظهر التقرير';
$string['showsmallimage'] = 'صورة صغيرة';
$string['showteacherattempts'] = 'أعرض محاولات المعلم';
$string['showuserpicture'] = 'أظهر صورة المستخدم';
$string['showuserpicture_help'] = 'عند تمكينه، سيتم إظهار اسم الطالب وصورته على الشاشة في أثناء المحاولة، وفي صفحة المراجعة مما يسمح بسهولة التحقق من كون الطالب قد دخل بنفسه في الاختبارات غير الخاضعة للمراقبة.';
$string['shuffle'] = 'الخلط';
$string['shuffleanswers'] = 'خلط الإجابات';
$string['shuffledrandomly'] = 'مخلوطة عشوائياً';
$string['shufflequestions'] = 'إخلط الأسئلة';
$string['shufflequestions_help'] = 'عند تمكينه، فعند كل محاولة للاختبار، سيتم تغيير ترتيب الأسئلة في هذا القسم إلى ترتيب عشوائي مختلف.

هذا من شأنه تصعيب قيام الطلبة بمشاركة الإجابات، ولكنه سيجعل الأمور أصعب أيضاً على الطلبة عند مناقشة سؤال معين مع المعلم.';
$string['shufflewithin'] = 'إخلط ما ضمن الأسئلة';
$string['shufflewithin_help'] = 'عند تمكينه، الأجزاء المكونة لكل سؤال سيتم خلطها عشوائياً عند كل محاولة يقوم بها الطالب للاختبار، على فرض تمكين هذا الخيار أيضاً في إعدادات السؤال. هذا الإعداد ينطبق فقط على الأسئلة التي تحتوي على أجزاء متعددة، مثل متعدد الخيارات أو أسئلة المطابقة.';
$string['singleanswer'] = 'إختر إجابة واحدة.';
$string['sortage'] = 'الفرز حسب العمر';
$string['sortalpha'] = 'الفرز حسب الاسم';
$string['sortquestionsbyx'] = 'إفرز الأسئلة حسب: {$a}';
$string['sortsubmit'] = 'رتب الأسئلة';
$string['sorttypealpha'] = 'الفرز حسب النوع، الاسم';
$string['specificapathnotonquestion'] = 'مسار الملف المحدد ليس في السؤال المحدد';
$string['specificquestionnotonquiz'] = 'السؤال المحدد ليس ضمن الاختبار المحدد';
$string['startagain'] = 'إبداء ثانياً';
$string['startattempt'] = 'إبدأ المحاولة';
$string['startedon'] = 'بدأ';
$string['startnewpreview'] = 'إبدأ مراجعة جديدة';
$string['stateabandoned'] = 'غير مسلمة أبداً';
$string['statefinished'] = 'منتهية';
$string['statefinisheddetails'] = 'مُسلَّم {$a}';
$string['stateinprogress'] = 'قيد التنفيذ';
$string['statenotloaded'] = 'حالة السؤال {$a} لم يتم تحميلها من قاعدة البيانات';
$string['statenotstarted'] = 'لم يبدأ';
$string['stateoptions'] = 'خيارات حالة البدء';
$string['stateoptions_help'] = '* لم يبدأ: تم إنشاء المحاولة تلقائيًا قبل فتح الاختبار. الطالب لم يبدأ المحاولة بعد.
* قيد الإنشاء: الطالب بدأ بالمحاولة. لا يزال لديه متسع من الوقت لتسليمها.
* متأخر: المحاولة مفتوحة لوقت أكثر مما هو مسموح لها. لا يزال بإمكان الطالب تسليمها ضمن فترة السماح.
* مُسلَّمة: أكمل الطالب المحاولة وسلَّم إجاباته. إنها مجدولة للمنح التلقائي للدرجات.
* منتهية: المحاولة مُسلَّمة وكل التقييم التلقائي قد اكتمل.
* غير مُسَلَّمة: بدأ الطالب بالمحاولة، ولكنه لم يسلمها ضمن الوقت المحددة أو فترة السماح.';
$string['stateoverdue'] = 'مُتأخرة';
$string['stateoverduedetails'] = 'ينبغي تسليمه في {$a}';
$string['statesubmitted'] = 'مُسلَّمة';
$string['status'] = 'الحالة';
$string['stoponerror'] = 'التوقف عند وجود خطأ';
$string['submission_confirmation'] = 'أتريد تسليم كل إجاباتك والانهاء؟';
$string['submission_confirmation_unanswered'] = 'الأسئلة التي ليست لها إجابات: {$a}';
$string['submitallandfinish'] = 'تسليم الكل وإنهاء الاختبار';
$string['subneterror'] = 'عذراً، تم تأمين هذا الاختبار بحيث لا يمكن الوصول إليه إلا من بعض المواقع المحدَّدة. حالياً جهاز الكمبيوتر الخاص بك ليس  أحد تلك الأجهزة المسموح لها  بالدخول لهذا الاختبار.';
$string['subnetnotice'] = 'عذراً، تم تأمين هذا الاختبار بحيث لا يمكن الوصول إليه إلا من بعض المواقع المحدَّدة. حالياً جهاز الكمبيوتر الخاص بك ليس  في الشبكة الفرعية المسموح لها للدخول لهذا الاختبار. كمُعلم يمكنك استعراضه بأية حال';
$string['subplugintype_quiz'] = 'التقرير';
$string['subplugintype_quiz_plural'] = 'التقارير';
$string['subplugintype_quizaccess'] = 'قاعدة الوصول';
$string['subplugintype_quizaccess_plural'] = 'قواعد الوصول';
$string['substitutedby'] = 'سيستبدل بــ';
$string['summaryofattempt'] = 'ملخص المحاولة';
$string['summaryofattempts'] = 'محاولاتك';
$string['summaryofattemptscaption'] = 'موجز المحاولة {$a}';
$string['temporaryblocked'] = 'أنت غير مسموح لك مؤقتاً بإعادة محاولة الاختبار.<br /> ستكون قادراً على محاولته مجدداً في:';
$string['theattempt'] = 'المحاولة';
$string['theattempt_help'] = 'إذا كان يمكن للطالب مراجعة المحاولة';
$string['time'] = 'الوقت';
$string['timecompleted'] = 'تم';
$string['timedelay'] = 'لا يسمح لك القيام بهذا الاختبار لأن الوقت المُحدد لك اللازم تجاوزه قبل القيام باختبار اخر لم يمر بعد';
$string['timeleft'] = 'الوقت المتبقي';
$string['timelimit'] = 'الوقت المحدد';
$string['timelimit_help'] = 'فى حالة تفعيله، سيتم توضيح المدة المحددة على الصفحة  الأساسية للإختبار ويتم عرض مؤقت للعد التنازلي في كتلة تنقل الإختبار';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = '!عذرا، انتهي الوقت المحدد للاختبار';
$string['timestr'] = '%H:%M:%S في %d/%m/%y';
$string['timesup'] = 'انتهى الوقت!';
$string['timing'] = 'التوقيتات';
$string['tofile'] = 'إلى ملف';
$string['tolerance'] = 'السماحية';
$string['toomanyrandom'] = 'عدد الاسئلة العشوائية اكثر من ما يستوعبة هذا الصنف! ({$a})';
$string['top'] = 'أعلى';
$string['totalmarks'] = 'إجمالي العلامات';
$string['totalmarksx'] = 'إجمالي الدرجات: {$a}';
$string['totalquestionsinrandomqcategory'] = 'ما مجمله {$a} سؤال/أسئلة في الصنف.';
$string['true'] = 'صواب';
$string['truefalse'] = 'صواب/خطأ';
$string['type'] = 'النوع';
$string['unfinished'] = 'مفتوح';
$string['ungraded'] = 'بلا درجات';
$string['unit'] = 'وحدة';
$string['unknowntype'] = 'نوعية السؤال غير مدعم في سطر {$a}. سيتم تجاهل السؤال.';
$string['updatefilterconditon'] = 'تحديث شروط المُرشح';
$string['updatefilterconditon_success'] = 'شروط المُرشح تم تحديثها بنجاح';
$string['updateoverdueattemptstask'] = 'تحديث محاولات الاختبار المتأخرة';
$string['updatequizslotswithrandomxofy'] = 'يجري تحديث عناصر الاختبار ببيانات سؤال "عشوائي" ({$a->done}/{$a->total})';
$string['updatesettings'] = 'حدِّث إعدادات الاختبار';
$string['updatingatttemptgrades'] = 'تحديث';
$string['updatingfinalgrades'] = 'تحديث الدرجات النهائية';
$string['updatingthegradebook'] = '.تحديث سجل الدرجات';
$string['upgradesure'] = '<div>على وجه الخصوص، ستنفذ وحدة الاختبار تغييراً واسعاً في جداول الاختبار وهذه الترقية لم يتم اختبارها بشكل كافٍ بعد. نحثك بشدة على إجراء الحفظ الاحتياطي لجداول قاعدة البيانات قبل المواصلة.</div>';
$string['upgradingquizattempts'] = 'تجري ترقية محاولات الاختبار: الاختبار {$a->done}/{$a->outof} (مُعرَّف الاختبار {$a->info})';
$string['upgradingveryoldquizattempts'] = 'تجري ترقية محاولات اختبار قديمة جداً: {$a->done}/{$a->outof}';
$string['url'] = 'رابط';
$string['usedcategorymoved'] = 'تم الحفاظ على هذا التصيف ونقله إلى مستوى الموقع لأنه تصنيف منشور لا زال قيد الاستعمال من قبل مساقات أخرى.';
$string['useroverrides'] = 'تجاوزات المستخدم';
$string['useroverridesdeleted'] = 'تم حذف تجاوزات المستخدم';
$string['usersnone'] = 'لا يمكن للطلاب الوصول لهذا الاختبار';
$string['validate'] = 'صادق';
$string['viewallanswers'] = 'معاينة {$a} محاولة للاختبار';
$string['viewallreports'] = 'معاينة  التقارير لـ  {$a}  المحاولات';
$string['viewed'] = 'تمت معاينته';
$string['warningmissingtype'] = '<b>هذا السؤال لم يتم تنصيبه في مودل الخاص بك حتى الآن.<br />يرجى تنبيه مشرف مودل الخاص بك.</b>';
$string['wheregrade'] = 'أين درجتي؟';
$string['wildcard'] = 'رمز بديل مطلق';
$string['windowclosing'] = 'هذه النافذة ستُغلق قريباً';
$string['withsummary'] = 'مع إحصائيات موجزة';
$string['wronguse'] = 'لا يمكنك استعمال هذه الصفحة بهذا الشكل';
$string['xhtml'] = '';
$string['youneedtoenrol'] = 'تحتاج إلى التسجيل في هذا المساق قبل أن تتمكن من حل هذا الاختبار';
$string['yourfinalgradeis'] = 'درجتك النهائية عن هذا الاختبار هي {$a}';
