<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sr_cr', version '5.0'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Специфицирани администраторски директоријум је нетачан';
$string['admindirname'] = 'Администраторски директоријум';
$string['admindirsetting'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример: <br /> <br /><b>moodleadmin</b><br /> <br />
Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['admindirsettinghead'] = 'Подешавање администраторског директоријума';
$string['admindirsettingsub'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример: <br /> <br /><b>moodleadmin</b><br /> <br />
Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['availablelangs'] = 'Доступни језички пакети';
$string['caution'] = 'Опрез';
$string['chooselanguage'] = 'Изабери језик';
$string['chooselanguagehead'] = 'Изаберите језик';
$string['chooselanguagesub'] = 'Изаберите језик који ће се користити током инсталације. Овај језик ће, такође, бити коришћен на нивоу сајта као подразумевани, иако то накнадно може да се промени.';
$string['cliadminemail'] = 'Е-адреса новог администратора';
$string['cliadminpassword'] = 'Нова лозинка за администратора';
$string['cliadminusername'] = 'Корисничко име администратора';
$string['clialreadyconfigured'] = 'Датотека config.php већ постоји. Молимо, користите admin/cli/install_database.php ако желите да инсталирате Moodle на овом серверу.';
$string['clialreadyinstalled'] = 'Датотека config.php већ постоји. Молимо користите admin/cli/upgrade.php ако желите да надоградите Moodle на овом серверу.';
$string['cliinstallfinished'] = 'Инсталација је успешно завршена';
$string['cliinstallheader'] = 'Moodle {$a} програм за инсталацију из командне линије';
$string['climustagreelicense'] = 'У неинтерактивном режиму морате прихватити лиценцу наводећи опцију --agree-license';
$string['cliskipdatabase'] = 'Прескаче се инсталација базе података.';
$string['clisupportemail'] = 'Адреса е-поште за подршку';
$string['clitablesexist'] = 'База података већ постоји. Није могуће наставити инсталацију из командне линије.';
$string['compatibilitysettings'] = 'Провера Ваших PHP подешавања...';
$string['compatibilitysettingshead'] = 'Провера Ваших PHP подешавања...';
$string['compatibilitysettingssub'] = 'Ваш сервер би требао проћи све ове тестове да би Moodle на њему успешно функционисао';
$string['configfilenotwritten'] = 'Инсталациони скрипт није могао да аутоматски креира датотеку config.php која садржи подешавања која сте изабрали, вероватно због тога што не постоји могућност уписивања у Moodle директоријум. Можете ручно да копирате следећи кôд у датотеку под називом config.php, која се налази у основном директоријуму Moodle инсталације.';
$string['configfilewritten'] = 'config.php је успешно креиран';
$string['configurationcomplete'] = 'Конфигурација је завршена';
$string['configurationcompletehead'] = 'Конфигурација је завршена';
$string['configurationcompletesub'] = 'Moodle је покушао да сачува Вашу конфигурацију у датотеци смештеној у коренском директоријуму Moodle инсталације.';
$string['database'] = 'База података';
$string['databasehead'] = 'Подешавања базе података';
$string['databasehost'] = 'Сервер базе података';
$string['databasename'] = 'Име базе података';
$string['databasepass'] = 'Лозинка за приступ бази података';
$string['databaseport'] = 'Пребацивање базе';
$string['databasesocket'] = 'Unix прикључак';
$string['databasetypehead'] = 'Изаберите драјвер базе података';
$string['databasetypesub'] = 'Moodle подржава неколико типова база података. Уколико не знате који тип да користите контактирајте администратора сервера.';
$string['databaseuser'] = 'Корисничко име за приступ бази података';
$string['dataroot'] = 'Директоријум података';
$string['datarooterror'] = '\'Директоријум података\' који сте навели не може бити пронађен или креиран. Унесите тачну путању или креирајте тај директоријум ручно.';
$string['datarootpermission'] = 'Овлашћења над директоријумом података';
$string['datarootpublicerror'] = '\'Директоријума података\' који сте подесили је директно доступан преко веба, морате користити други директоријум.';
$string['dbconnectionerror'] = 'Немогуће је успоставити везу са базом података коју сте навели. Молимо проверите подешавања базе података.';
$string['dbcreationerror'] = 'Грешка при креирању базе података. Није било могуће креирати базу наведеног имена уз задата подешавања';
$string['dbhost'] = 'Сервер домаћин';
$string['dbpass'] = 'Лозинка';
$string['dbport'] = 'Порт';
$string['dbprefix'] = 'Префикс табеле';
$string['dbtype'] = 'Тип';
$string['directorysettings'] = '<p>Молимо потврдите локације ове Moodle инсталације</p>

<p><b>Веб адреса:</b>
Наведите пуну веб адресу путем које ће се приступати Moodleu.
Ако се вашем веб сајту може приступити преко више URL адреса, изаберите ону коју ће ваши полазници највероватније користити. Немојте у адреси наводити крајњу косу црту.</p>

<p><b>Moodle директоријум:</b>
Наведите пуну путању до ове инсталације.
Водите рачуна о великим и малим словима.</p>

<p><b>Директоријум података:</b>
Морате одредити место на ком ће Moodle моћи да сачува постављене датотеке. Корисник веб сервера (обично \'nobody\' или \'apache\') треба да има могућност да чита податке из тог директоријума, као и да УПИСУЈЕ податке у њега, али директоријум података не сме бити доступан директно преко веба. Програм за инсталацију ће покушати да креира овај директоријум уколико он не постоји.</p>';
$string['directorysettingshead'] = 'Молимо потврдите локације ове Moodle инсталације';
$string['directorysettingssub'] = '<b>Веб адреса:</b>
Наведите пуну веб адресу путем које ће се приступати Moodleu.
Ако се вашем веб сајту може приступити преко више URL адреса, изаберите ону коју ће ваши полазници највероватније користити. Немојте у адреси наводити крајњу косу црту.
<br />
<br />
<b>Moodle директоријум:</b>
Наведите пуну путању до ове инсталације.
Водите рачуна о великим и малим словима.
<br />
<br />
<b>Директоријум података:</b>
Морате одредити место на ком ће Moodle моћи да сачува постављене датотеке. Корисник веб сервера (обично \'nobody\' или \'apache\') треба да има могућност да чита податке из тог директоријума, као и да УПИСУЈЕ податке у њега, али директоријум података не сме бити доступан директно преко веба. Програм за инсталацију ће покушати да креира овај директоријум уколико он не постоји.';
$string['dirroot'] = 'Moodle директоријум';
$string['dirrooterror'] = 'Изгледа да је подешавање \'Moodle директоријума погрешно - на наведеној адреси није могуће пронаћи Moodle инсталацију. Доња вредност је ресетована.';
$string['download'] = 'Преузети';
$string['downloadlanguagebutton'] = 'Преузми "{$a}" језички пакет';
$string['downloadlanguagehead'] = 'Преузми језички пакет';
$string['downloadlanguagenotneeded'] = 'Можете наставити процес инсталације коришћењем подразумеваног језичког пакета, "{$a}".';
$string['downloadlanguagesub'] = 'Сада имате могућност преузимања жељеног језичког пакета и наставка инсталационог процеса на том језику.<br /><br />Ако нисте у могућности да преузмете језички пакет, инсталациони процес ће се наставити на енглеском језику. (Када се инсталација заврши, имаћете могућност да преузмете и инсталирате додатне језичке пакете.)';
$string['doyouagree'] = 'Да ли се слажете? (да/не)';
$string['environmenthead'] = 'Проверавање Вашег окружења...';
$string['environmentsub'] = 'Проверава се да ли разне компоненте Вашег система задовољавају системске захтеве';
$string['environmentsub2'] = 'Свако издање Moodlea има минимум захтева по питању одговарајуће PHP верзије и неколико обавезних PHP екстензија.
Комплетна провера окружења се врши пре сваке инсталације и надоградње постојеће верзије. Уколико не знате како да инсталирате нову верзију или омогућите PHP екстензије контактирајте свог администратора сервера.';
$string['errorsinenvironment'] = 'Провера окружења није прошла!';
$string['fail'] = 'Није прошло';
$string['fileuploads'] = 'Постављање датотека';
$string['fileuploadserror'] = 'Ова опција би требала бити укључена';
$string['fileuploadshelp'] = '<p>Изгледа да је постављање датотека на вашем серверу онемогућено.</p>

<p>Moodle још увек може бити инсталиран, али без ове могућности, нећете моћи да поставите датотеке курса или нове слике за корисничке профиле.</p>

<p>Да бисте омогућили постављање датотека ви, или ваш систем администратор, ћете морати да уредите датотеку php.ini на свом систему и да промените подешавање за <b>file_uploads</b> на \'1\'.</p>';
$string['inputdatadirectory'] = 'Директоријум податка:';
$string['inputwebadress'] = 'Веб адреса :';
$string['inputwebdirectory'] = 'Moodle директоријум:';
$string['installation'] = 'Инсталација';
$string['invaliddbprefix'] = 'Неисправан префикс. Префикс може да се састоји само од малих слова и доње црте.';
$string['langdownloaderror'] = 'Нажалост, језик "{$a}" се не може преузети. Процес инсталације биће настављен на енглеском језику.';
$string['langdownloadok'] = 'Језик "{$a}" је успешно инсталиран. Инсталациони процес ће бити настављен на овом језику.';
$string['memorylimit'] = 'Ограничење меморије';
$string['memorylimiterror'] = 'PHP ограничење меморије је подешено на прилично низак ниво... касније може доћи до проблема.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP није правилно подешен за рад са MySQLi екстензијом да би могао да комуницира са MySQL. Молимо, проверите своју php.ini датотеку или поново компајлирајте PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>База података је место где се чува већина Moodle подешавања и података, и мора се овде конфигурисати.</p>
<p>Назив базе података, корисничко име и лозинка су обавезна поља; префикс табеле није обавезан.</p>
<p>Назив  базе података може користити само алфанумеричке знакове, знак долар ($) и доњу црту (_).</p>
<p>Ако база података тренутно не постоји, а корисник којег наведете има овлашћења, Moodle ће покушати да креира нову базу података са тачним овлашћењима и подешавањима.</p>
<p>Овај управљачки програм није компатибилан са застарелим MyISAM механизмом.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>База података је место где се чува већина Moodle подешавања и података, и мора се овде конфигурисати.</p>
<p>Назив базе података, корисничко име и лозинка су обавезна поља; префикс табеле није обавезан.</p>
<p>Назив  базе података може користити само алфанумеричке знакове, знак долар ($) и доњу црту (_).</p>
<p>Ако база података тренутно не постоји, а корисник којег наведете има овлашћења, Moodle ће покушати да креира нову базу података са тачним овлашћењима и подешавањима.</p>
<p>Овај управљачки програм није компатибилан са застарелим MyISAM механизмом.</p>';
$string['nativemysqli'] = 'Унапређен MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>База података је место где се смешта већина Moodle подешавања и података, и зато овде мора бити конфигурисана.</p>
</p>Назив базе података, корисничко име и лозинка су неопходна поља; префикс табеле није обавезан.</p>
<p>Назив базе података може садржати само алфанумеричке знакове, ознаку за долар ($) и доњу црту (_).</p>
<p>Ако база података тренутно не постоји а корисник кога сте навели има овлашћења, Moodle ће покушати да креира нову базу података са исправним овлашћењима и подешавањима.</p>';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>База података је место где се смешта већина Moodle подешавања и података, и зато овде мора бити конфигурисана.</p>
</p>Назив базе података, корисничко име, лозинка и префикс табеле су неопходна поља.</p>
<p>База података мора већ да постоји а корисник мора да има приступ како за читање тако и за уписивање у базу.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Сада је неопходно да конфигуришете базу податка где ће највећи део података из Moodlea бити смештен.
Ова база података, као и корисничко име и лозинка за приступ бази, морају бити претходно већ креирани.
Префикс табеле је обавезан.';
$string['nativesqlsrvnodriver'] = 'Microsoft драјвери за SQL сервер за PHP нису инсталирани или нису правилно конфигурисани.';
$string['pass'] = 'Прошло';
$string['paths'] = 'Путање';
$string['pathserrcreatedataroot'] = 'Инсталациона процедура не може да креира директоријум базе података ({$a->dataroot}).';
$string['pathshead'] = 'Потврди путање';
$string['pathsrodataroot'] = 'У директоријум за податке није могућ упис';
$string['pathsroparentdataroot'] = 'Није могућ упис у надређени директоријум ({$a->parent}).  Инсталациони програм не може да креира директоријум за податке ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Врло мали број веб сервера користи /admin као специјални URL за приступ разним подешавањима (контролни панел и сл.). Нажалост, то доводи до конфликта са стандардном локацијом за администраторске странице у Moodleu. Овај проблем можете решити тако што ћете променити име администраторског директоријума у вашој инсталацији, и овде уписати то ново име. На пример <em>moodleadmin</em>. Ово подешавање ће преправити администраторске линкове у Moodle систему.';
$string['pathssubdataroot'] = '<p>Директоријум где ће Moodle чувати датотеке и садржај који су поставили корисници. </p>
<p>Овај директоријум треба да буде подешен тако да корисник веб сервера (обично \'nobody\' или \'apache\') може да га чита и у њега уписује.</p>
<p>Директоријум не сме бити доступан директно преко веба. </p>
<p>Уколико овај директоријум не постоји процес инсталације ће покушати да га креира.</p>';
$string['pathssubdirroot'] = '<p>Пуна путања до директоријума који садржи кôд Moodlea.</p>';
$string['pathssubwwwroot'] = '<p>Пуна адреса путем које ће се приступати Moodleu, тј. адреса коју ће корисници унети у адресну траку својих веб читача како би приступили Moodleu.</p>
<p>Није могуће приступати Moodleu коришћењем више адреса. Ако се вашем сајту може приступити са више адреса, онда изаберите најлакшу, а за све остале адресе подесите перманентну редирекцију.</p>
<p>Ако се вашем сајту може приступити како са интернета, тако и из интерне мреже (која се понекад назив интранет), онда овде употребите јавну адресу.</p>
<p>Ако је текућа адреса нетачна, молимо вас, промените URL адресу у адресној траци свог веб читача и поново покрените инсталацију.</p>';
$string['pathsunsecuredataroot'] = 'Локација директоријума са подацима није безбедна';
$string['pathswrongadmindir'] = 'Админ директоријум не постоји';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP није правилно конфигурисан са  PGSQL екстензијом тако да може да комуницира са PostgreSQL-ом. Молимо вас да проверите своју php.ini датотеку или опет компајлирате PHP.';
$string['phpextension'] = '{$a} PHP екстензија';
$string['phpversion'] = 'PHP верзија';
$string['releasenoteslink'] = 'За више информацији о овој верзији Moodlea, погледајте напомене уз издање на {$a}';
$string['safemode'] = 'Безбедни режим';
$string['safemodeerror'] = 'Moodle може имати проблема са укљученим безбедним модом рада';
$string['safemodehelp'] = '<p>Moodle може имати различите проблеме ако је укључен безбедни режим рада. Један од битнијих је тај што му вероватно неће бити дозвољено да креира нове датотеке.</p>

<p>Безбедни режим рада је обично омогућен једино на параноидним јавним веб серверима, тако да ћете можда морати да за свој Moodle сајт нађете нови веб сервер код неке друге компаније.</p>

<p>Можете покушати да наставите са инсталацијом, ако желите, али очекујте неколико проблема касније.</p>';
$string['sessionautostart'] = 'Аутоматски почетак сесије';
$string['sessionautostarterror'] = 'Ова опција би требала бити искључена';
$string['sessionautostarthelp'] = '<p>Moodle захтева подршку за сесије и неће фунционисати без ње.</p>

<p>Рад са сесијама се може омогућити у php.ini датотеци... потражите session.auto_start параметар.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP није правилно подешен са екстензијом SQLite. Молимо проверите Вашу датотеку php.ini или поново компајлирајте PHP.';
$string['upgradingqtypeplugin'] = 'Надоградња додатка за питања/типове';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Ову страницу видите зато што сте успешно инсталирали и покренули <strong>{$a->packname} {$a->packversion}</strong> пакет на свом серверу. Честитамо!';
$string['welcomep30'] = 'Ово издање <strong>{$a->installername}</strong> укључује апликације за креирање окружења у којем ће <strong>Moodle</strong> успешно функционисати, конкретно:';
$string['welcomep40'] = 'Овај пакет обухвата и <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Коришћење свих апликација овог пакета је уређено њиховим лиценцама. Комплетан<strong>{$a->installername}</strong> пакет је <a href="https://www.opensource.org/docs/definition_plain.html">отвореног кода</a> и дистрибуира се под <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a> лиценцом.';
$string['welcomep60'] = 'Наредне странице ће вас провести кроз неколико једноставних корака током којих ћете конфигурисати и подесити <strong>Moodle</strong> на свом рачунару. Можете прихватити подразумевана подешавања или их, опционо, прилагодити сопственим потребама.';
$string['welcomep70'] = 'Кликните на дугме за наставак да бисте даље подешавали <strong>Moodle</strong>.';
$string['wwwroot'] = 'Веб адреса';
$string['wwwrooterror'] = 'Наведена \'веб адреса\' се чини невалидном - ова Moodle инсталација изгледа није на њој. Вредност наведена испод је ресетована.';
