<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_mailtest', language 'sr_cr', version '5.0'.
 *
 * @package     local_mailtest
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalinfo'] = 'Додатне информације:';
$string['alwaysshowlog'] = 'Увек прикажи запис о комуникацији са сервером за е-пошту, чак и ако нема грешака.';
$string['bimidmarcfailure'] = 'BIMI провера идентитета није успела због једне или више DMARC зависних грешака.';
$string['bimiinvalidlogo'] = 'Недостаје BIMI лого: {$a}.';
$string['biminorecordfound'] = 'BIMI запис недостаје.';
$string['bimipctinvalid'] = 'DMARC PCT вредност мора бити подешена на 100 за BIMI.';
$string['bimirecordfound'] = 'Пронађен је BIMI запис.';
$string['bimitagsfound'] = 'BIMI ознаке су исправне.';
$string['checkingdomain'] = 'DNS безбедносна провера за {$a}:';
$string['commoncommissues'] = '<li>Ваш Moodle сајт може бити блокиран заштитним зидом, који спречава комуникацију са вашим сервером за е-пошту.</li>
<li>Можда ћете морати да додате IP адресу свог веб сајта на списак дозвољених IP адреса у конфигурацији сервера за е-пошту.</li>
<li>Проверите да ли је ваш SMTP сервер покренут и да ли ради.</li>';
$string['commondeliveryissues'] = '<p>Ако е-порука није испоручена у року од 15-30 минута, проверите следеће:</p>
<ul>
<li>Проверите да ли је е-адреса унета у поље TO тачна.</li>
<li>Проверите са примаоцима да послата порука, можда, није завршила међу нежељеном поштом (у тзв. spam/junk фолдеру).</li>
<li>Проверите са примациома да им, можда, поштанско сандуче није препуњено.</li>
<li>Проверите поштанско сандуче ваше \'no-reply\' е-адресе, како бисте видели да није случајно порука коју сте послали одбијена (остала неиспоручена), из било ког разлога.</a></li>
<li>Проверите да ниједан филтер на вашем или серверу за е-пошту примаоца, није, случајно, означио садржај ваше е-поруке као непожељан (spam/junk).</a></li>
<li>Проверите да провајдери е-поште нису, случајно, ставили IP адресу вашег сервера за е-пошту на тзв. црну листу.</a></li>
{$a}
</ul>';
$string['connectionlog'] = 'Запис комуникације са сервером за е-пошту';
$string['credit'] = 'Michael Milette - <a href="http://www.tngconsulting.ca/">TNG Consulting Inc.</a>';
$string['divertallemails'] = 'Преусмери све е-поруке';
$string['divertedto'] = 'Преусмерено на {$a}';
$string['dkiminvalidrecord'] = 'DKIM запис мора да садржи исправне ознаке v, k и p.';
$string['dkimmissingselector'] = 'Подешавање DKIM селектора није конфигурисано.';
$string['dkimnorecordfound'] = 'DKIM запис недостаје.';
$string['dkimrecordfound'] = 'Пронађен је DKIM запис.';
$string['dkimselectorconfigured'] = 'Подешавање DKIM селектора је конфигурисано.';
$string['dkimspffailed'] = 'DMARC захтева да се конфигуришу SPF или DKIM записи.';
$string['dkimvalidrecord'] = 'Формат DKIM записа је исправан.';
$string['dmarcnorecordfound'] = 'DMARC запис недостаје.';
$string['dmarcpctinvalid'] = 'DMARC pct вредност није у опсегу.';
$string['dmarcrecordfound'] = 'Пронађен је DMARC запис.';
$string['dmarcruainvalid'] = 'DMARC rua вредност вредност није правилно форматирана.';
$string['dmarcrufinvalid'] = 'DMARC ruf вредност вредност није правилно форматирана.';
$string['dmarctagsfound'] = 'Пронађене су DMARC потребне ознаке.';
$string['emailfail'] = 'Слање поруке е-поште није успело';
$string['errorcommunications'] = 'Moodle није могао да се повеже са вашим сервером за е-пошту.</p><p><strong>Препорука:</strong></p><p>Почните тако што ћете проверити <a href="{$a}" target="_blank">подешавања SMTP сервера за е-пошту</a>унутар вашег Moodlea.</p><p>Ако та подешавања изгледају исправно, проверите подешавања вашег SMTP сервера и/или подешавања заштитног зида (firewall сервера) како бисте били сигурни да су конфигурисани тако да прихватају SMTP конекције са вашег Moodle веб сервера и ваше \'no-reply\' е-адресе. За додатну помоћ, погледајте у документацији одељак \'Често постављена питања\' (FAQ).';
$string['errorsend'] = 'Пробна порука е-поште није могла бити испоручена серверу за е-пошту.</p><p><strong>Препорука:</strong></p><p>Проверите <a href="{$a}" target="blank">Подешавања е-поште</a> унутар вашег Moodlea. За додатну помоћ, погледајте у документацији одељак \'Често постављена питања\' (FAQ).';
$string['errorunknown'] = '<p>Дошло је до грешке која не може да се дијагностикује.</p><p><strong>Препорука:</strong></p><p>Погледајте у наставку запис о комуникацији. Можда ће вам бити корисно да погледате списак SMTP кôдова на страницама <a href="https://www.rfc-editor.org/rfc/rfc5321.html#section-4.2.3" target="_blank">RFC 5321</a> и <a href="https://datatracker.ietf.org/doc/html/rfc4954#section-6" target="_blank">RFC 4954</a>.</p>';
$string['failaccessdenied'] = '<li>Повезивање са сервером за е-пошту није успело, па је конекција затворена.</li>';
$string['failclosedport'] = 'Порт сервера {$a} је затворен. Да ли сте навели тачан :port number?';
$string['failcredentials'] = '<li>Акредитиви за проверу идентитета су можда неисправни или недостају. Проверите да ли сте унели тачне податке за пријаву.</li>';
$string['faildnslookup'] = 'DNS претрага није успела. Проверите да ли \'<strong>{$a}</strong>\' успева да одреди адресу сервера за е-пошту.';
$string['failmissingport'] = 'Можда ћете морати да наведете :port number за везе типа "{$a}".';
$string['failmissingprotocol'] = 'Можда ћете морати да наведете тип безбедног протокола (SSL/TLS) са портом \'{$a}\'.';
$string['failoutboundsmtpblocked'] = 'Нешто блокира повезивање одлазних SMTP конекција. Да ли постоји заштитни зид (firewall) који блокира вашу везу са сервером за е-пошту?';
$string['failphpmailer'] = 'Можда постоје проблеми са инсталацијом Moodle LMS-а. Један од могућих разлога су неисправна овлашћења власника/групе над датотекама апликације.';
$string['failphpmailerconfig'] = 'Сервис e-поште на вашем Moodle веб серверу можда не ради или је погрешно конфигурисан.';
$string['failprotocolmismatch'] = 'Можда постоји неусклађеност између протокола \'{$a->protocol}\' и порта \'{$a->port}\'.';
$string['failunknownmailbox'] = '<li>Поштанско сандуче FROM није пронађено, није доступно или је одбијено због дефинисаних правила на сајту. Проверите да ли су обе е-адресе - TO и FROM исправне и да ли постоје, као и да је \'no-reply\' адреса стварно поштанско сандуче које постоји на вашем серверу за е-пошту.</li>';
$string['from'] = '{$a->type}: <strong>{$a->email}</strong> (<a href="{$a->url}">{$a->label}</a>)';
$string['fromemail'] = 'Са е-адресе';
$string['heading'] = 'Тест конфигурације е-поште';
$string['iconlabel'] = 'Безбедносна провера за {$a}';
$string['message'] = '<p>Ово је пробна порука. Занемарите је.</p>
<p>Ако сте примили ову поруку е-поште, то значи да сте успешно конфигурисали подешавања е-поште на свом Moodle сајту.</p>
<hr><p><strong>Додатне информације о кориснику</strong></p>
<ul>
<li><strong>Статус регистрације :</strong> {$a->regstatus}</li>
<li><strong>Преферирани језик :</strong> {$a->lang}</li>
<li><strong>Веб читач корисника :</strong> {$a->browser}</li>
<li><strong>Порука послао/ла :</strong> {$a->referer}</li>
<li><strong>Moodle верзија :</strong> {$a->release}</li>
<li><strong>IP адреса корисника :</strong> {$a->ip}</li>
</ul>';
$string['noemailever'] = '<p>Е-пошта на овом сајту је онемогућена због подешавања у конфигурационој датотеци - <strong>$CFG-&gt;noemailever = true;</strong>.</p>';
$string['nologavailable'] = '<p>Записивање није доступно када се користи PHP mail() функција. Међутим, могуће је пронаћи записе на вашем серверу. Најчешћа места на Linux оперативном систему укључују:</p>
<ul>
<li>/var/log/maillog</li>
<li>/var/log/mail.log</li>
<li>/var/adm/maillog</li>
<li>/var/adm/syslog/mail.log</li>
</ul>
<p>Алтернативно, место где ће се записи чувати може бити наведено коришћењем mail.log подешавања у датотеци php.ini.</p>';
$string['notregistered'] = 'Нисте регистровани или нисте пријављени.';
$string['phpmethod'] = 'PHP подразумевани метод';
$string['pluginname'] = 'Тест еПоште';
$string['pluginname_help'] = 'Тест еПоште ће проверити подешавања е-поште за овај Moodle сајт слањем пробне поруке е-поште на адресу коју наведете. Само за администраторе сајта.';
$string['primaryadminemail'] = 'Примарна адреса е-поште администратора';
$string['privacy:metadata'] = 'Додатак \'Тест еПоште\' не чува никакве личне податке о било ком кориснику.';
$string['recipientisrequired'] = 'Морате навести адресу е-поште примаоца.';
$string['registered'] = 'Регистровани корисник ({$a}).';
$string['sendmethod'] = 'Начин слања е-поште';
$string['sendtest'] = 'Пошаљите пробну поруку';
$string['sentmail'] = 'Moodle је успешно испоручио пробну поруку SMTP серверу за е-пошту.';
$string['sentmailphp'] = 'PHP Mail је успешно прихватио Moodle пробну поруку.';
$string['server'] = 'Сервер: {$a}';
$string['smtpmethod'] = 'SMTP сервери: {$a}';
$string['spfinvalidrecord'] = 'SPF запис мора да садржи најмање један механизам.';
$string['spfnorecordfound'] = 'SPF запис недостаје.';
$string['spfrecordfound'] = 'Пронађен је SPF запис.';
$string['spfvalidrecord'] = 'Формат SPF записа је исправан.';
$string['testing'] = 'Тестирање конфигурације е-поште';
$string['toemail'] = 'На адресу е-поште';
$string['winsyslog'] = 'Дневник догађаја на Windowsu';
$string['youremail'] = 'Ваша е-адреса';
