<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'mn', version '5.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Үйл ажиллагааг устгаж байна...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" нь насны хувьд хүчинтэй утга биш байна.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" нь нэгээс их эсвэл цөөн таслал тусгаарлагчтай байна.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" нь улсын хувьд хүчинтэй утга биш байна.';
$string['agedigitalconsentmapinvaliddefault'] = 'Өгөгдмөл (*) утга байхгүй байна.';
$string['agelocationverificationdisabled'] = 'Нас болон байршлын баталгаажуулалтыг идэвхжүүлээгүй';
$string['alreadyloggedin'] = 'Та {$a} нэрээр нэвтэрсэн байгаа тул өөр хэрэглэгчээр нэвтрэхийн тулд системээс гарах шаардлагатай.';
$string['authnotexisting'] = 'Эрх олгох нэмэлт хэрэгсэл байхгүй байна';
$string['backupcontainexternal'] = 'Энэ нөөц файл нь дотоод; тохируулаагүй гадаад Moodle сүлжээний хостыг агуулдаг';
$string['backuptablefail'] = 'Нөөцлөлтийн хүснэгтийг амжилттай тохируулж чадсангүй!';
$string['blockcannotconfig'] = 'Энэ блок нь ерөнхий тохиргоог дэмждэггүй';
$string['blockcannotinistantiate'] = 'Блок объектыг үүсгэхэд асуудал гарлаа';
$string['blockcannotread'] = 'blockid= {$a} блокын өгөгдлийг уншиж чадсангүй';
$string['blockdoesnotexist'] = 'Энэ блок байхгүй байна';
$string['blockdoesnotexistonpage'] = 'Энэ хуудсанд ({$a->url}) уг блок (is={$a->instance id}) байхгүй байна.';
$string['blocknameconflict'] = 'Нэршлийн зөрүү: {$a->name} блок нь одоо байгаа блоктой ижил гарчигтай байна: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Энэ сэтгэгдлийн хувьд сэтгэгдэл буцаах дуудлагыг цуцалсан.';
$string['cannotaddcoursemodule'] = 'Хичээлийн шинэ модулийг нэмж чадсангүй';
$string['cannotaddcoursemoduletosection'] = 'Энэ хэсэгт хичээлийн шинэ модулийг нэмж чадсангүй';
$string['cannotaddmodule'] = 'Модулийн жагсаалтад {$a} модулийг нэмж чадсангүй!';
$string['cannotaddnewmodule'] = '{$a} хичээлийн шинэ модулийг нэмж чадсангүй';
$string['cannotaddrss'] = 'Танд rss мэдэгдэл нэмэх зөвшөөрөл байхгүй байна';
$string['cannotaddthisblocktype'] = 'Та энэ хуудсанд {$a} блокыг нэмэх боломжгүй.';
$string['cannotassignrole'] = 'Хичээлд эрх хуваарилах боломжгүй';
$string['cannotassignrolehere'] = 'Таныг энэ сэдэвт ({$a->context}) уг эрхийг (id = {$a->roleid}) оноохыг зөвшөөрөхгүй.';
$string['cannotassignselfasparent'] = 'Өөрийгөө эцэг эх байдлаар оноох боломжгүй!';
$string['cannotcallscript'] = 'Уг скриптийг ийм байдлаар дуудаж болохгүй';
$string['cannotcallusgetselecteduser'] = 'Олон сонголттой тохиолдолд user_selector::get_selected_user гэж дуудах боломжгүй.';
$string['cannotcreatebackupdir'] = 'Нөөцлөлтийн өгөгдлийн хавтсыг үүсгэж чадсангүй. Сайтын администратор нь файлын зөвшөөрлийг өөрчлөх шаардлагатай';
$string['cannotcreatecategory'] = 'Ангиллыг оруулаагүй байна';
$string['cannotcreatedboninstall'] = '<p>Өгөгдлийн санг үүсгэх боломжгүй.</p>
<p>Тодорхойлсон өгөгдлийн сан байхгүй, тухайн хэрэглэгч өгөгдлийн сан үүсгэх зөвшөөрөлгүй байна.</p>
<p>Сайтын администратор нь өгөгдлийн сангийн тохиргоог шалгах шаардлагатай.</p>';
$string['cannotcreategroup'] = 'Бүлэг үүсгэхэд алдаа гарлаа';
$string['cannotcreatelangbase'] = 'Алдаа: Хэлний үндсэн лавлахыг үүсгэж чадсангүй';
$string['cannotcreatelangdir'] = 'Хэлний лавлахыг үүсгэх боломжгүй';
$string['cannotcreateorfindstructs'] = 'Энэ хичээлийн хэсгийн бүтцийг хайх эсвэл үүсгэхэд алдаа гарлаа';
$string['cannotcreatepopupwin'] = 'Тодорхойгүй элемент - нээгдэх цонхыг үүсгэх боломжгүй';
$string['cannotcreatesitedir'] = 'Сайтын хавтас үүсгэх боломжгүй. Сайтын администратор нь файлын зөвшөөрлийг өөрчлөх шаардлагатай.';
$string['cannotcreatetempdir'] = 'Завсрын лавлахыг үүсгэх боломжгүй';
$string['cannotcreateuploaddir'] = 'Байршуулах хавтсыг үүсгэх боломжгүй. Сайтын администратор нь файлын зөвшөөрлийг өөрчлөх шаардлагатай.';
$string['cannotcustomisefiltersblockuser'] = 'Та хэрэглэгчийн эсвэл блокын сэдвийн шүүлтүүрийн тохиргоог өөрчлөх боломжгүй.';
$string['cannotdeletebackupids'] = 'Өмнөх нөөцлөлтийн ID дугаарыг устгаж чадсангүй';
$string['cannotdeletecategorycourse'] = '\'{$a}\' хичээлийг устгаж чадсангүй.';
$string['cannotdeletecategoryquestions'] = '\'{$a}\' ангиллын асуултыг устгах боломжгүй';
$string['cannotdeletecourse'] = 'Танд энэ хичээлийг устгах зөвшөөрөл байхгүй';
$string['cannotdeletecustomfield'] = 'Тусгай талбарын өгөгдлийг устгахад алдаа гарлаа';
$string['cannotdeletedir'] = 'Устгах боломжгүй ({$a})';
$string['cannotdeletefile'] = 'Энэ файлыг устгах боломжгүй';
$string['cannotdeleterole'] = 'Үүнийг устгах боломжгүй, учир нь {$a}';
$string['cannotdeleterolewithid'] = '{$a} ID дугаартай үүргийг устгаж чадсангүй';
$string['cannotdeletethisrole'] = 'Систем энэ үүргийг ашигладаг эсвэл администраторын боломж бүхиий сүүлийн үүрэг тул энэ үүргийг устгах боломжгүй.';
$string['cannotdisableformat'] = 'Өгөгдмөл форматыг идэвхгүй болгох боломжгүй.';
$string['cannotdownloadcomponents'] = 'Бүрэлдэхүүн хэсгийг татаж авах боломжгүй';
$string['cannotdownloadlanguageupdatelist'] = 'download.moodle.org сайтаас хэлний шинэчлэлтийн жагсаалтыг татаж авах боломжгүй';
$string['cannotdownloadzipfile'] = 'ZIP файлыг татаж авах боломжгүй байна';
$string['cannoteditcomment'] = 'Энэ таны сэтгэгдэл биш тул засах боломжгүй!';
$string['cannoteditcommentexpired'] = 'Та үүнийг засварлах боломжгүй. Хугацаа дууссан байна!';
$string['cannoteditpostorblog'] = 'Та блог нийтлэх эсвэл засварлах боломжгүй';
$string['cannoteditsiteform'] = 'Та уг маягтыг ашиглан сайтын хичээлийг засварлах боломжгүй';
$string['cannotedituserpreferences'] = 'Энэ хэрэглэгчийн тохиргоог засварлах боломжгүй';
$string['cannotedityourprofile'] = 'Уучлаарай, та өөрийн профайлыг засварлах боломжгүй';
$string['cannotexecduringupgrade'] = 'Шинэчлэлтийн үед хийх боломжгүй';
$string['cannotfindcategory'] = 'Өгөгдлийн сангаас {$a} ID дугаараар ангиллын бичлэгийг олж чадсангүй';
$string['cannotfindcomponent'] = 'Бүрэлдэхүүн хэсгийг олж чадсангүй';
$string['cannotfindcontext'] = 'Сэдвийг олж чадсангүй';
$string['cannotfindcourse'] = 'Хичээлийг олж чадсангүй';
$string['cannotfinddocs'] = '"{$a}" хэлний баримт бичгийн файлыг олж чадсангүй';
$string['cannotfindgradeitem'] = 'grade_item олж чадсангүй';
$string['cannotfindgroup'] = 'Бүлгийг хайх боломжгүй';
$string['cannotfindhelp'] = '"{$a}" хэлний тусламжийн файл олдсонгүй';
$string['cannotfindinfo'] = 'Мэдээллийг олж чадсангүй: "{$a}"';
$string['cannotfindlang'] = '"{$a}" хэлний багц олдсонгүй!';
$string['cannotfindteacher'] = 'Багш олдсонгүй';
$string['cannotfinduser'] = '"{$a}" нэртэй хэрэглэгч олдсонгүй';
$string['cannotgeoplugin'] = 'https://www.geoplugin.com сайтын geoPlugin серверт холбогдох боломжгүй байна. Прокси тохиргоогоо шалгах буюу MaxMind GeoLite City өгөгдлийн файлыг суулгана уу.';
$string['cannotgetblock'] = 'Өгөгдлийн сангаас блокыг татаж авч чадсангүй';
$string['cannotgetcats'] = 'Ангиллын бичлэгийг авах боломжгүй';
$string['cannotgetdata'] = 'Өгөгдлийг авах боломжгүй';
$string['cannotgradeuser'] = 'Энэ хэрэглэгчийг үнэлэх боломжгүй';
$string['cannothaveparentcate'] = 'Хичээлийн ангилал нь үндсэн ангилалгүй байна!';
$string['cannotimport'] = 'Импортлох алдаа';
$string['cannotimportformat'] = 'Уучлаарай, энэ форматыг одоогоор импортлох боломжгүй!';
$string['cannotimportgrade'] = 'Үнэлгээг импортлох алдаа';
$string['cannotinsertgrade'] = 'Хичээлийн id дугааргүйгээр үнэлгээг оруулах боломжгүй!';
$string['cannotinsertrate'] = 'Шинэ үнэлгээ оруулж чадсангүй ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Шинэ бичлэгийн ID {$a} дугаарыг оруулж чадсангүй';
$string['cannotmailconfirm'] = 'Нууц үг солих баталгаажуулалтын цахим шууданг илгээхэд алдаа гарлаа';
$string['cannotmanualctrack'] = 'Үйл ажиллагаа нь гүйцэтгэлийг гараар хянах боломжийг олгодоггүй';
$string['cannotmapfield'] = 'Буулгалтын алдаа илэрлээ - хоёр талбарыг ижил үнэлгээний {$a} нэгжид буулгасан';
$string['cannotmigratedatacomments'] = 'Өгөгдлийн модулийн тайлбарыг шилжүүлэх боломжгүй';
$string['cannotmodulename'] = 'Загварын удирдлага дахь модулийн нэрийг авч чадахгүй байна';
$string['cannotmoduletype'] = 'Загварын удирдлага дахь модулийн төрлийг авч чадахгүй байна';
$string['cannotmovecategory'] = 'Ангиллыг шилжүүлэх боломжгүй';
$string['cannotmovecourses'] = 'Хичээлийг өөр ангилалд шилжүүлэх боломжгүй.';
$string['cannotmoverolewithid'] = '{$a} ID дугаартай эрхийг шилжүүлэх боломжгүй';
$string['cannotopencsv'] = 'CSV файлыг нээх боломжгүй';
$string['cannotopenfile'] = 'Файлыг нээх боломжгүй ({$a})';
$string['cannotopenforwrit'] = 'Бичилт хийхээр нээх боломжгүй: {$a}';
$string['cannotopentemplate'] = 'Загвар файлыг нээх боломжгүй ({$a})';
$string['cannotopenzip'] = '64 битийн үйлдлийн систем дэх zip өргөтгөлийн алдаанаас үүдэн архивласан файлыг нээх боломжгүй байна.';
$string['cannotoverridebaserole'] = 'Үндсэн үүргийн боломжийг хүчингүй болгох боломжгүй';
$string['cannotoverriderolehere'] = 'Та энэ хүрээнд ({$a->context}) энэ үүргийг (id = {$a->roleid}) хүчингүй болгох боломжгүй';
$string['cannotreadfile'] = 'Файлыг унших боломжгүй ({$a})';
$string['cannotreadtmpfile'] = 'Завсрын файлыг уншихад алдаа гарлаа';
$string['cannotreaduploadfile'] = 'Байршуулсан файлыг уншиж чадсангүй';
$string['cannotremovefrommeta'] = 'Мета хичээлээс сонгосон хичээлийг хасаж чадсангүй!';
$string['cannotreprocessgrades'] = 'Энэ үйл ажиллагааны үнэлгээг дахин боловсруулж чадсангүй {$a}';
$string['cannotresetguestpwd'] = 'Та зочны нууц үгийг дахин тохируулах боломжгүй';
$string['cannotresetmail'] = 'Нууц үгийг сэргээж, цахим шуудангаар илгээхэд алдаа гарлаа';
$string['cannotresetthisrole'] = 'Энэ үүргийг дахин тохируулах боломжгүй';
$string['cannotrestore'] = 'Алдаа гарсан тул сэргээх ажиллагааг дуусгаж чадсангүй!';
$string['cannotrestoreadminorcreator'] = 'Та шинэ хичээл болгон сэргээхийн тулд хичээл үүсгэгч эсвэл админ хэрэглэгч байх шаардлагатай!';
$string['cannotrestoreadminoredit'] = 'Сонгосон хичээлд сэргээхийн тулд та засварлах эрхтэй багш эсвэл админ хэрэглэгч байх шаардлагатай!';
$string['cannotsaveagreement'] = 'Таны гэрээг хадгалж чадсангүй';
$string['cannotsaveblock'] = 'Блокын тохиргоог хадгалахад алдаа гарлаа';
$string['cannotsavecomment'] = 'Сэтгэгдлийг хадгалах боломжгүй';
$string['cannotsavedata'] = 'Өгөгдлийг хадгалах боломжгүй';
$string['cannotsavefile'] = '"{$a}" файлыг хадгалах боломжгүй байна!';
$string['cannotsavemd5file'] = 'md5 файлыг хадгалах боломжгүй';
$string['cannotsavezipfile'] = 'ZIP файлыг хадгалах боломжгүй';
$string['cannotservefile'] = 'Серверийн тохиргооны асуудлаас үүдэн файлыг ажиллуулах боломжгүй байна.';
$string['cannotsetparentforcatoritem'] = 'Ангилал эсвэл хичээлийн нэгжид үндсэн хэсгийг тохируулах боломжгүй байна!';
$string['cannotsetpassword'] = 'Хэрэглэгчийн нууц үгийг тохируулж чадсангүй!';
$string['cannotsetprefgrade'] = 'Энэ үнэлгээний ангилалд aggregationview тохиргоог {$a} болгох боломжгүй байна';
$string['cannotsettheme'] = 'Загварыг тохируулж чадсангүй!';
$string['cannotsetupblock'] = 'Блокын хүснэгтийг амжилттай тохируулах боломжгүй байна!';
$string['cannotsetupcapformod'] = '{$a}-н боломжийг тохируулж чадсангүй';
$string['cannotsetupcapforplugin'] = '{$a}-н боломжийг тохируулж чадсангүй';
$string['cannotshowhidecoursesincategory'] = '{$a} ангиллын хичээлийг харуулах/нуух боломжгүй.';
$string['cannotsignup'] = 'Та {$a} хэрэглэгчээр нэвтэрсэн байгаа тул шинээр бүртгэл үүсгэх боломжгүй.';
$string['cannotunassigncap'] = '{$a->role} үүргээс хүчингүй болсон {$a->cap} боломжийг хасах боломжгүй';
$string['cannotunassignrolefrom'] = 'Энэ хэрэглэгчийг үүргийн id дугаараас хасах боломжгүй: {$a}';
$string['cannotunzipfile'] = 'Файлын архивыг задлах боломжгүй';
$string['cannotupdatemod'] = '{$a}-г шинэчилж чадсангүй';
$string['cannotupdatepasswordonextauth'] = 'Гадаад баталгаажуулалтын нууц үгийг шинэчилж чадсангүй: {$a}. Дэлгэрэнгүй мэдээллийг серверийн лог бүртгэлээс харна уу.';
$string['cannotupdateprofile'] = 'Хэрэглэгчийн бүртгэлийг шинэчлэхэд алдаа гарлаа';
$string['cannotupdaterecord'] = '{$a} бичлэгийн ID дугаарыг шинэчилж чадсангүй';
$string['cannotupdaterss'] = 'RSS мэдэгдлийг шинэчлэх боломжгүй';
$string['cannotupdatesubcourse'] = 'Дэд хичээлийг шинэчилж чадсангүй!';
$string['cannotupdateusermsgpref'] = 'Хэрэглэгчийн зурвасын тохиргоог шинэчлэх боломжгүй';
$string['cannotupdateuseronexauth'] = 'Гадаад баталгаажуулалтын хэрэглэгчийн өгөгдлийг шинэчилж чадсангүй: {$a}. Дэлгэрэнгүй мэдээллийг серверийн лог бүртгэлээс харна уу.';
$string['cannotuploadfile'] = 'Байршуулах файлыг боловсруулахад алдаа гарлаа';
$string['cannotuseadmin'] = 'Та энэ хуудсыг ашиглахын тулд админ хэрэглэгч байх шаардлагатай';
$string['cannotuseadminadminorteacher'] = 'Та энэ хуудсыг ашиглахын тулд багш эсвэл админ хэрэглэгч байх шаардлагатай';
$string['cannotusepage'] = 'Зөвхөн багш, администратор энэ хуудсыг ашиглах боломжтой';
$string['cannotusepage2'] = 'Уучлаарай, та энэ хуудсыг ашиглах шаардлагагүй';
$string['cannotviewcategory'] = 'Танд энэ хичээлийн жагсаалтыг үзэх зөвшөөрөл байхгүй.';
$string['cannotviewprofile'] = 'Та энэ хэрэглэгчийн профайлыг харах боломжгүй';
$string['cannotviewreport'] = 'Та энэ тайланг харах боломжгүй';
$string['cannotwritefile'] = 'Файлд бичих боломжгүй ({$a})';
$string['categoryerror'] = 'Ангиллын алдаа';
$string['categoryidnumbertaken'] = 'ID дугаарыг өөр ангилалд хэдийнэ ашигласан байна';
$string['categorynamerequired'] = 'Ангиллын нэрийг оруулах шаардлагатай';
$string['categorytoolong'] = 'Ангиллын нэр хэт урт байна';
$string['commentmisconf'] = 'Сэтгэгдлийн ID дугаарыг буруу тохируулсан байна';
$string['componentisuptodate'] = 'Бүрэлдэхүүн хэсгийг шинэчилсэн';
$string['confirmationnotenabled'] = 'Энэ сайтад хэрэглэгчийн баталгаажуулалтыг идэвхжүүлээгүй байна';
$string['confirmsesskeybad'] = 'Уучлаарай, энэ үйлдлийг гүйцэтгэхэд шаардлагатай таны сейшн түлхүүрийг баталгаажуулж чадсангүй. Энэхүү хамгаалалтын функц нь таны нэр дээрх чухал функцыг санамсаргүй эсвэл зүй бусаар ажиллуулахаас сэргийлдэг. Та уг функцыг ажиллуулахдаа итгэлтэй байна уу.';
$string['contenttypenotfound'] = '\'{$a}\' агуулгын сангийн төрөл байхгүй эсвэл танигдахгүй байна.';
$string['contentvisibilitynotfound'] = '\'{$a}\' утгатай агуулгын харагдац байхгүй эсвэл танигдахгүй байна.';
$string['couldnotassignrole'] = 'Танд үүрэг хуваарилах үед ноцтой боловч тодорхойгүй алдаа гарлаа';
$string['couldnotupdatenoexistinguser'] = 'Хэрэглэгчийг шинэчлэх боломжгүй - хэрэглэгч байхгүй байна';
$string['couldnotverifyagedigitalconsent'] = 'Дижитал зөвшөөрлийн насыг баталгаажуулах явцад алдаа гарлаа.<br />Администратортой холбогдоно уу.';
$string['countriesphpempty'] = 'Алдаа: {$a} хэлний багц дахь country.php файл хоосон эсвэл байхгүй байна.';
$string['coursedoesnotbelongtocategory'] = 'Хичээл нь энэ ангилалд хамаарахгүй';
$string['courseformatnotfound'] = '\'{$a}\' хичээлийн формат байхгүй эсвэл танигдахгүй байна.';
$string['coursegroupunknown'] = '{$a} бүлэгт тохирох хичээлийг тодорхойлоогүй байна';
$string['courseidnotfound'] = 'Хичээлийн ID дугаар байхгүй.';
$string['courseidnumbertaken'] = 'ID дугаарыг өөр хичээлд ашигласан байна ({$a})';
$string['coursemisconf'] = 'Хичээлийг буруу тохируулсан байна';
$string['courserequestdisabled'] = 'Уучлаарай, администратор хичээлийн хүсэлтийг идэвхгүй болгосон байна.';
$string['csvcolumnduplicates'] = 'Давхардсан багануудтай байна';
$string['csvemptyfile'] = 'CSV файл хоосон байна';
$string['csvfewcolumns'] = 'Багана дутуу, тусгаарлагчийн тохиргоог шалгана уу';
$string['csvfileerror'] = 'CSV файлын формат алдаатай. Гарчиг болон баганын тоо таарч байгаа эсэх, тусгаарлагч болон файлын кодчилол зөв эсэхийг шалгана уу. {$a}';
$string['csvinvalidcols'] = '<b>CSV файл алдаатай байна:</b> Эхний мөрөнд "Толгой талбар" байх ёстой ба файлын төрөл нь <br />"Өргөтгөсөн талбар/таслалаар тусгаарлагдсан"<br />эсвэл<br /> "CAVV үр дүн/таслалаар тусгаарлагдсан өргөтгөсөн талбар" байх ёстой.';
$string['csvinvalidcolsnum'] = 'CSV файл алдаатай - мөр тус бүр 49 эсвэл 70 талбартай байх ёстой';
$string['csvloaderror'] = 'CSV файлыг ачаалах явцад алдаа гарлаа: {$a}';
$string['csvnodata'] = 'CSV файл алдаатай - CSV файлд толгой хэсэг байгаа боловч ямар ч өгөгдөл агуулаагүй байна.';
$string['csvweirdcolumns'] = 'CSV файлын формат буруу - баганын тоо тогтмол биш байна!';
$string['dbconnectionfailed'] = '<p>Алдаа: Өгөгдлийн сангийн холболт амжилтгүй боллоо</p>
<p>Өгөгдлийн сан хэт ачаалалтай эсвэл зөв ажиллахгүй байж болзошгүй.</p>
<p>Сайтын администратор нь config.php- файлд өгөгдлийн сангийн дэлгэрэнгүй мэдээллийг зөв заасан эсэхийг шалгах ёстой</p>';
$string['dbdriverproblem'] = '<p>Алдаа: өгөгдлийн сангийн драйверын асуудал илэрсэн</p>
<p>Сайтын администратор серверийн тохиргоог шалгах ёстой</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Өгөгдлийн сангийн сейшны ноцтой асуудал илэрсэн.<br /><br />Серверийн администраторт мэдэгдэнэ үү.';
$string['dbsessionhandlerproblem'] = 'Өгөгдлийн сангийн сейшнг тохируулж чадсангүй. Серверийн администраторт мэдэгдэнэ үү.';
$string['dbsessionmysqlpacketsize'] = 'Сейшны ноцтой алдаа илэрлээ. Сайтын администраторт мэдэгдэнэ үү. Асуудал нь max_allowed_packet MySQL тохиргооны бага утгаас үүдэлтэй байх магадлалтай.';
$string['dbupdatefailed'] = 'Өгөгдлийн сангийн шинэчлэлт амжилтгүй боллоо';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" нэрийг өөрчлөх боломжгүй. {$a->offendingtype} "{$a->offendingname}" бүхий хамаарал олдсон';
$string['ddlexecuteerror'] = 'DDL sql гүйцэтгэлийн алдаа';
$string['ddlfieldalreadyexists'] = '"{$a}" талбар байна';
$string['ddlfieldnotexist'] = '"{$a->tablename}" хүснэгтэд "{$a->fieldname}" талбар байхгүй байна';
$string['ddltablealreadyexists'] = '"{$a}" хүснэгт байна';
$string['ddltablenotexist'] = '"{$a}" хүснэгт байхгүй';
$string['ddlunknownerror'] = 'Үл мэдэгдэх DDL сангийн алдаа';
$string['ddlxmlfileerror'] = 'XML өгөгдлийн сангийн файлын алдаа илэрлээ';
$string['ddsequenceerror'] = '"{$a}" хүснэгтийн тодорхойлолт буруу; үүнд зөвхөн түлхүүр гэж тодорхойлсон нэг багана байх ёстой.';
$string['destinationcmnotexit'] = 'Хүлээн авах хичээлийн модуль байхгүй';
$string['detectedbrokenplugin'] = '{$a} нэмэлт хэрэгсэл эвдрэлтэй эсвэл хуучирсан; уучлаарай, та үргэлжлүүлэх боломжгүй.';
$string['dmlexceptiononinstall'] = '<p>Өгөгдлийн сангийн алдаа гарлаа [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'SQL асуулгыг задлан шинжлэхэд алдаа гарлаа';
$string['dmlreadexception'] = 'Өгөгдлийн сангаас уншихад алдаа гарлаа';
$string['dmltransactionexception'] = 'Өгөгдлийн сангийн үйл ажиллагааны алдаа';
$string['dmlwriteexception'] = 'Өгөгдлийн санд бичилт хийхэд алдаа гарлаа';
$string['dndmaxbytes'] = 'Файл хэт том байна. Зөвшөөрөгдсөн дээд хэмжээ нь {$a->size}.';
$string['dndread'] = 'Файлыг уншихад алдаа гарлаа';
$string['dndunkownfile'] = 'Файлын энэ төрлийг дэмждэггүй';
$string['dndupload'] = 'Файлыг байршуулах явцад тодорхойгүй алдаа гарлаа';
$string['downgradedcore'] = 'АЛДАА!!! Таны ашиглаж буй код нь эдгээр өгөгдлийн санг үүсгэсэн хувилбараас ХУУЧИН байна!';
$string['downloadedfilecheckfailed'] = 'Татаж авсан файлыг шалгаж чадсангүй';
$string['duplicatefieldname'] = '"{$a}" талбарын давхардсан нэр илэрсэн';
$string['duplicatenosupport'] = '{$a->modtype} модуль нь нөөцлөлт, сэргээлтийг дэмждэггүй тул \'{$a->modname}\' үйл ажиллагааг хуулбарлах боломжгүй.';
$string['duplicateparaminsql'] = 'АЛДАА: асуулгад параметрийн нэр давхардсан';
$string['duplicaterolename'] = 'Энэ нэртэй үүрэг байна!';
$string['duplicateroleshortname'] = 'Ийм товч нэртэй үүрэг байна!';
$string['duplicateusername'] = 'Хэрэглэгчийн нэр давхардсан - бичлэгийг алгасах';
$string['editedpagenotfound'] = 'Систем таны байгаа хуудсыг тодорхойлж чадсангүй. Хуудсыг сэргээгээд дахин оролдоно уу.';
$string['emailfail'] = 'Цахим шууданг илгээхэд алдаа гарлаа';
$string['encryption_decryptfailed'] = 'Шифрлэлтийг тайлж чадсангүй';
$string['encryption_encryptfailed'] = 'Шифрлэлт амжилтгүй боллоо';
$string['encryption_invalidkey'] = 'Хүчингүй түлхүүр';
$string['encryption_keyalreadyexists'] = 'Түлхүүр байна';
$string['encryption_nokey'] = 'Түлхүүр олдсонгүй';
$string['encryption_wrongmethod'] = 'Өгөгдөл нь дэмждэг шифрлэлтийн аргатай зохицохгүй байна';
$string['enddatebeforestartdate'] = 'Хичээл дуусах огноо нь эхлэх өдрөөс хойш байх ёстой.';
$string['error'] = 'Алдаа гарлаа';
$string['error_question_answers_missing_in_db'] = '"{$a->answer}" хариулттай тохирох хариултыг асуулт_хариултын өгөгдлийн сангийн хүснэгтээс олж чадсангүй. Энэ нь өгөгдлийн санд байгаа {$a->dbquestionid} id дугаартай асуултад харгалзах нөөц файлын {$a->filequestionid} id дугаартай асуултыг сэргээх явцад гарсан болно.';
$string['errorcleaningdirectory'] = '"{$a}" лавлахыг цэвэрлэхэд алдаа гарлаа';
$string['errorcopyingfiles'] = 'Файл хуулахад алдаа гарлаа';
$string['errorcreatingdirectory'] = '"{$a}" лавлахыг үүсгэхэд алдаа гарлаа';
$string['errorcreatingfile'] = '"{$a}" файлыг үүсгэхэд алдаа гарлаа';
$string['errorcreatingrole'] = 'Үүрэг үүсгэхэд алдаа гарлаа';
$string['errorfetchingrssfeed'] = 'RSS мэдэгдлийг татахад алдаа гарлаа.';
$string['erroronline'] = '"{$a}" мөрөнд алдаа гарлаа';
$string['erroroutput'] = 'Гаралтын алдаа гарсан тул автомат дахин чиглүүлэлтийг идэвхгүй болгосон.';
$string['errorparsingxml'] = 'XML задлан шинжлэхэд алдаа гарлаа: {$a->errorline} мөрөнд {$a->errorstring}, {$a->errorchar}} тэмдэгт';
$string['errorprocessingarchive'] = 'Архивласан файлыг боловсруулахад алдаа гарлаа';
$string['errorreadingfile'] = '"{$a}" файлыг уншихад алдаа гарлаа';
$string['errorsavingrequest'] = 'Таны хүсэлтийг хадгалах үед алдаа гарлаа.';
$string['errorsettinguserpref'] = 'Хэрэглэгчийн тохиргоонд алдаа гарлаа';
$string['errorunzippingfiles'] = 'Файлыг архиваас задлахад алдаа гарлаа';
$string['expiredkey'] = 'Хугацаа нь дууссан түлхүүр';
$string['externalauthpassworderror'] = 'Гадаад нэвтрэлт танилтад зориулсан нууц үг';
$string['externalfilenolocation'] = 'Гадаад файл нь байршлын замгүй';
$string['failtoloadblocks'] = 'Өгөгдлийн санд нэг эсвэл олон блок бүртгэгдсэн ч бүгдийг ачаалах боломжгүй!';
$string['fieldrequired'] = '"{$a}" нь заавал байх ёстой талбар юм';
$string['fileexists'] = 'Файл байна';
$string['filemismatch'] = 'Үндсэн бус файлын нэр таарахгүй байна. "{$a->current}" файл нь {$a->file} байх ёстой';
$string['filenotfound'] = 'Уучлаарай, хүссэн файл олдсонгүй';
$string['filenotreadable'] = 'Файлыг унших боломжгүй';
$string['filterdoesnothavelocalconfig'] = '{$a} шүүлтүүр нь дотоод тохиргоо хийхийг зөвшөөрөхгүй.';
$string['filternotactive'] = '{$a} шүүлтүүр одоогоор идэвхгүй байна';
$string['filternotenabled'] = 'Шүүлтүүрийг идэвхжүүлээгүй!';
$string['filternotinstalled'] = '{$a} шүүлтүүрийг одоогоор суулгаагүй';
$string['forumblockingtoomanyposts'] = 'Та энэ хэлэлцүүлэгт нийтлэх босго шалгуурыг хангасан байна';
$string['functionalityremoved'] = 'Та устгасан функцэд хандаж байна.';
$string['generalexceptionmessage'] = 'Тайлбар - {$a}';
$string['gradecantregrade'] = 'Үнэлгээг тооцоолох явцад алдаа гарлаа: {$a}';
$string['gradepubdisable'] = 'Үнэлгээг харуулахыг идэвхгүй болгосон';
$string['gradesneedregrading'] = 'Хичээлийн үнэлгээг дахин тооцоолох шаардлагатай';
$string['groupalready'] = 'Хэрэглэгч хэдийнэ {$a} бүлэгт харьяалагдаж байна';
$string['groupexistforcourse'] = 'Энэ хичээлд "{$a}" бүлэг байна';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Энэ хичээлд "{$a->idnumber}" id дугаартай "{$a->name}" бүлэг байна';
$string['grouphasidnumber'] = '"{$a}" бүлэг нь id дугаартай бөгөөд гадаад системээр автоматаар үүсгэгдсэн байж болзошгүй. Танд энэ бүлгийг устгах зөвшөөрөл байхгүй.';
$string['groupinghasidnumber'] = '"{$a}" бүлэглэл нь id дугаартай, гадаад системээр автоматаар үүсгэгдсэн байж болзошгүй. Танд үүнийг устгах зөвшөөрөл байхгүй.';
$string['groupingnotaddederror'] = '"{$a}" бүлэглэлийг нэмээгүй';
$string['groupnotaddederror'] = '"{$a}" бүлгийг нэмээгүй';
$string['groupnotaddedtogroupingerror'] = '"{$a->groupname}" бүлгийг "{$a->groupingname}" бүлэглэлд нэмээгүй';
$string['groupunknown'] = '{$a} бүлэг нь тодорхой хичээлтэй холбогдоогүй';
$string['groupusernotmember'] = 'Хэрэглэгч нь энэ бүлгийн гишүүн биш байна.';
$string['guestcantaccessprofiles'] = 'Зочин нь хэрэглэгчийн профайлд хандах боломжгүй. Үргэлжлүүлэхийн тулд хэрэглэгчийн бүрэн бүртгэлээр нэвтэрнэ үү.';
$string['guestnocomment'] = 'Зочин нь сэтгэгдэл бичих боломжгүй!';
$string['guestnoeditprofile'] = 'Зочин хэрэглэгч өөрийн профайлыг засварлах боломжгүй';
$string['guestnoeditprofileother'] = 'Зочин хэрэглэгчийн профайлыг засварлах боломжгүй';
$string['guestnorate'] = 'Зочин нь бичлэгийг үнэлэх боломжгүй';
$string['guestsarenotallowed'] = 'Зочин хэрэглэгч үүнийг хийх эрхгүй';
$string['hackdetected'] = 'Хакерын халдлага илэрсэн!';
$string['hashpoolproblem'] = 'Нэгдсэн файлын агуулга буруу {$a}.';
$string['headersent'] = 'Гарчгийг хэдийнэ илгээсэн';
$string['idnumbertaken'] = 'Энэ ID дугаар ашиглалтад байна';
$string['idnumbertoolong'] = 'ID дугаар хэт урт байна';
$string['importformatnotimplement'] = 'Уучлаарай, энэ форматыг импортлох боломжгүй!';
$string['incorrectext'] = 'Файл нь буруу өргөтгөлтэй байна';
$string['inplaceeditableerror'] = 'Шинэчлэх процессорыг дуудахад алдаа гарлаа';
$string['installproblem'] = 'Суулгах явцад гарсан алдааг гол төлөв сэргээх боломжгүй байдаг. Дахин суулгах тохиолдолд шинэ өгөгдлийн санг үүсгэх эсвэл өөр өгөгдлийн сангийн угтварыг ашиглах шаардлага гарч магадгүй.';
$string['internalauthpassworderror'] = 'Нууц үг дутуу эсвэл дотоод баталгаажуулалтын нууц үгийн бодлого буруу байна';
$string['invalidaccess'] = 'Энэ хуудсанд зөв хандаагүй байна';
$string['invalidaccessparameter'] = 'Хүчингүй хандалтын параметр';
$string['invalidaction'] = 'Хүчингүй үйлдлийн параметр';
$string['invalidactivityid'] = 'Хүчингүй үйл ажиллагааны ID дугаар';
$string['invalidadminsettingname'] = 'Хүчингүй админы тохиргоо ({$a})';
$string['invalidargorconf'] = 'Хүчинтэй аргумент байхгүй эсвэл серверийн тохиргоо буруу';
$string['invalidarguments'] = 'Хүчинтэй аргумент байхгүй';
$string['invalidblockinstance'] = 'Хүчингүй блокын жишээ: {$a}';
$string['invalidbulkenrolop'] = 'Хүчингүй багц бүртгэлийн ажиллагааны хүсэлт гаргасан.';
$string['invalidcategory'] = 'Ангилал буруу!';
$string['invalidcategoryid'] = 'Ангиллын ID дугаар буруу!';
$string['invalidcomment'] = 'Сэтгэгдэл буруу байна';
$string['invalidcommentarea'] = 'Хүчингүй сэтгэгдлийн талбар';
$string['invalidcommentid'] = 'Хүчингүй сэтгэгдлийн ID дугаар';
$string['invalidcommentitemid'] = 'Хүчингүй сэтгэгдлийн зүйлийн ID дугаар';
$string['invalidcommentparam'] = 'Хүчингүй сэтгэгдлийн параметр';
$string['invalidcomponent'] = 'Хүчингүй бүрэлдэхүүн хэсгийн нэр';
$string['invalidconfirmdata'] = 'Хүчингүй баталгаажуулах өгөгдөл';
$string['invalidcontentid'] = 'Хүчингүй агуулгын ID дугаар';
$string['invalidcontext'] = 'Хүчингүй хамрах хүрээ';
$string['invalidcountrycode'] = 'Хүчингүй улсын код: {$a}';
$string['invalidcourse'] = 'Хүчингүй хичээл';
$string['invalidcourseformat'] = 'Хүчингүй хичээлийн формат';
$string['invalidcourseid'] = 'Та хүчингүй хичээлийн ID дугаарыг ашиглахыг оролдож байна';
$string['invalidcourselevel'] = 'Хамрах хүрээний түвшин буруу байна';
$string['invalidcoursemodule'] = 'Хүчингүй хичээлийн модулийн ID дугаар';
$string['invalidcoursemoduleid'] = 'Хүчингүй хичээлийн модулийн ID дугаар: {$a}';
$string['invalidcoursenameshort'] = 'Хүчингүй хичээлийн товч нэр';
$string['invaliddata'] = 'Оруулсан өгөгдөл хүчингүй';
$string['invaliddatarootpermissions'] = 'Лавлахыг үүсгэх үед хүчингүй зөвшөөрөл илэрсэн. Дэлгэрэнгүй мэдээлэл авахын тулд алдаа засварлахыг идэвхжүүлнэ үү.';
$string['invaliddevicetype'] = 'Хүчингүй төхөөрөмжийн төрөл';
$string['invalidelementid'] = 'Элементийн ID дугаар буруу!';
$string['invalidentry'] = 'Энэ бичлэг хүчингүй байна!';
$string['invalidevent'] = 'Хүчингүй арга хэмжээ';
$string['invalidfieldname'] = '"{$a}" нь хүчингүй талбарын нэр байна';
$string['invalidfiletype'] = '"{$a}" нь хүчингүй файлын төрөл байна';
$string['invalidformatpara'] = 'Параметрийг сонгох формат буруу байна';
$string['invalidformdata'] = 'Маягтын өгөгдөл буруу байна';
$string['invalidfunction'] = 'Функц буруу байна';
$string['invalidgradeitemid'] = 'Үнэлгээний нэгжийн ID дугаар буруу байна';
$string['invalidgroupid'] = 'Тодорхойлсон бүлгийн ID дугаар буруу байна';
$string['invalidipformat'] = 'Хүчингүй IP хаягийн формат';
$string['invaliditemid'] = 'Нэгжийн ID дугаар буруу';
$string['invalidkey'] = 'Түлхүүр буруу байна';
$string['invalidlanguagecode'] = 'Хүчингүй хэлний код: {$a}';
$string['invalidlegacy'] = '{$a} төрлийн хуучин үүргийн тодорхойлолт буруу байна';
$string['invalidmd5'] = 'Шалгах хувьсагч буруу байсан - дахин оролдоно уу';
$string['invalidmode'] = 'Хүчингүй горим ({$a})';
$string['invalidmodule'] = 'Модуль буруу байна';
$string['invalidmoduleid'] = 'Модулийн ID дугаар буруу байна: {$a}';
$string['invalidmodulename'] = 'Модулийн нэр буруу байна: {$a}';
$string['invalidnum'] = 'Тоон утга буруу байна';
$string['invalidnumkey'] = '$conditions массив нь тоон түлхүүр агуулаагүй байж болно. Кодоо засна уу!';
$string['invalidoutcome'] = 'Үр дүнгийн ID дугаар буруу байна';
$string['invalidpagesize'] = 'Хүчингүй хуудасны хэмжээ';
$string['invalidpasswordpolicy'] = 'Хүчингүй нууц үгийн бодлого';
$string['invalidpaymentmethod'] = 'Хүчингүй төлбөрийн арга: {$a}';
$string['invalidpersistenterror'] = 'Алдаа: {$a}';
$string['invalidqueryparam'] = 'АЛДАА: Асуулгын параметрийн тоо буруу байна. Хүлээгдэж буй {$a->expected}, хүлээн авсан {$a->actual}.';
$string['invalidratingarea'] = 'Хүчингүй үнэлгээний талбар';
$string['invalidrecord'] = 'Өгөгдлийн сангийн {$a} хүснэгтээс өгөгдлийн бичлэгийг олж чадсангүй.';
$string['invalidrecordunknown'] = 'Өгөгдлийн сангаас өгөгдлийн бичлэгийг олж чадсангүй.';
$string['invalidrequest'] = 'Хүчингүй хүсэлт';
$string['invalidrole'] = 'Хүчингүй үүрэг';
$string['invalidroleid'] = 'Хүчингүй үүргийн ID дугаар';
$string['invalidscaleid'] = 'Хэмжээсийн ID дугаар буруу байна';
$string['invalidsection'] = 'Хичээлийн модулийн бичлэгт хүчингүй хэсэг байна';
$string['invalidsesskey'] = 'Таны сейшны хугацаа хэтэрсэн байна. Дахин нэвтэрнэ үү.';
$string['invalidshortname'] = 'Хүчингүй хичээлийн товч нэр';
$string['invalidsourcefield'] = 'Ноорог файлын эх сурвалжийн талбар хүчингүй байна';
$string['invalidstatedetected'] = 'Алдаа гарлаа: {$a}. Ийм алдаа ердийн нөхцөлд гарах ёсгүй.';
$string['invalidurl'] = 'Хүчингүй URL хаяг';
$string['invaliduser'] = 'Хүчингүй хэрэглэгч';
$string['invaliduserdata'] = 'Хүчингүй хэрэглэгчийн өгөгдөл: {$a}';
$string['invaliduserfield'] = 'Хүчингүй хэрэглэгчийн талбар: {$a}';
$string['invaliduserid'] = 'Хүчингүй хэрэглэгчийн ID дугаар';
$string['invalidusername'] = 'Өгөгдсөн хэрэглэгчийн нэрэнд хүчингүй тэмдэгт байна';
$string['invalidusernameblank'] = 'Хэрэглэгчийн нэр хоосон байж болохгүй';
$string['invalidxmlfile'] = '"{$a}" нь хүчинтэй XML файл биш байна';
$string['iplookupfailed'] = 'Энэ {$a} IP хаягийн газарзүйн мэдээллийг олж чадсангүй';
$string['iplookupprivate'] = 'Хувийн IP хаягийн хайлтыг харуулах боломжгүй';
$string['ipmismatch'] = 'Үйлчлүүлэгчийн IP хаяг таарахгүй байна';
$string['listcantmovedown'] = 'Тухайн зүйл нь хамгийн сүүлийнх тул доош шилжүүлэх боломжгүй.';
$string['listcantmoveleft'] = 'Тухайн зүйл нь харьяалах үндсэн зүйлгүй тул зүүн тийш шилжүүлэх боломжгүй';
$string['listcantmoveright'] = 'Тухайн зүйлийг салбар зүйл болгох ижил түвшний зүйл байхгүй тул баруун тийш шилжүүлэх боломжгүй. Уг зүйлийг өөр ижил түвшний зүйлийн доор шилжүүлсний дараа  баруун тийш шилжүүлж болно.';
$string['listcantmoveup'] = 'Тухайн зүйл нь хамгийн эхнийх тул дээш шилжүүлэх боломжгүй.';
$string['listnochildren'] = 'Тухайн зүйлийн салбар зүйл олдсонгүй';
$string['listnoitem'] = 'Зүйл олдсонгүй';
$string['listnopeers'] = 'Тухайн зүйлтэй ижил түвшний зүйл олдсонгүй';
$string['listupdatefail'] = 'Шаталсан жагсаалтын засварлах үед өгөгдлийн сангийн ажиллагаа амжилтгүй боллоо';
$string['logfilenotavailable'] = 'Лог бүртгэл байхгүй байна';
$string['loginasnoenrol'] = 'Та "Нэвтрэх" сейшны үед бүртгүүлэх эсвэл бүртгэлээ цуцлах боломжгүй';
$string['loginasonecourse'] = 'Та энэ хичээлд орох боломжгүй.<br /> Та дурын бусад хичээлд орохын өмнө "Нэвтрэх" сейшнг дуусгах ёстой.';
$string['maxareabytes'] = 'Файлын хэмжээ нь энэ хэсэгт үлдсэн зайнаас том байна.';
$string['maxbytesfile'] = '{$a->file} файлын хэмжээ хэт том байна. Таны байршуулж болох хамгийн дээд хэмжээ нь {$a->size} болно.';
$string['maxdraftitemids'] = 'Таныг их хэмжээний файл байршуулсны дараа таны файл байршуулалтыг түр хугацаагаар хязгаарлах болно. Түр хүлээгээд дахин оролдоно уу.';
$string['messageundeliveredbynotificationsettings'] = 'Сайтын администратор нь хэрэглэгчийн хоорондох хувийн зурвасыг (Мэдэгдлийн тохиргоонд) идэвхгүй болгосон тул зурвас илгээх боломжгүй.';
$string['messagingdisable'] = 'Энэ сайтад зурвас бичихийг идэвхгүй болгосон';
$string['mimetexisnotexist'] = 'Таны системд mimeTeX ажиллуулах тохиргоо хийгдээгүй байна. Та <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> сайтаас C эх сурвалжийг авч, компайл хийгээд өөрийн moodle/filter/tex/ лавлахад гүйцэтгэх файлыг оруулах шаардлагатай.';
$string['mimetexnotexecutable'] = 'Тохируулсан mimetex нь ажиллах боломжгүй байна!';
$string['missing_moodle_backup_xml_file'] = 'XML файлын нөөцлөлт байхгүй байна: {$a}';
$string['missingcategoryrole'] = 'Хэрэглэгчид үүрэг хуваарилж чадсангүй: ангиллын үүрэг байхгүй байна.';
$string['missingfield'] = '"{$a}" талбар байхгүй байна';
$string['missingkeyinsql'] = 'АЛДАА: асуулгад "{$a}" параметр байхгүй байна';
$string['missingparam'] = 'Шаардлагатай параметр ({$a}) байхгүй байсан';
$string['missingparameter'] = 'Параметр байхгүй байна';
$string['missingrequiredfield'] = 'Зарим шаардлагатай талбар байхгүй байна';
$string['missinguseranditemid'] = 'userid болон itemid байхгүй байна';
$string['missingvarname'] = 'Шаардлагатай хувьсагчийн нэр байхгүй байна!';
$string['mixedtypesqlparam'] = 'АЛДАА: sql query параметрүүд нь холимог төрөлтэй байна!!';
$string['mnetdisable'] = 'MNET идэвхгүй байна';
$string['mnetlocal'] = 'Алсын MNET хэрэглэгч дотоодод нэвтрэх боломжгүй байна';
$string['moduledisable'] = 'Энэ модулийг ({$a}) тодорхой хичээлд идэвхгүй болгосон';
$string['moduledoesnotexist'] = 'Энэ модуль байхгүй байна';
$string['moduleinstancedoesnotexist'] = 'Энэ модулийн жишээ байхгүй байна';
$string['modulemissingcode'] = 'Moдульд {$a} энэ үйлдлийг биелүүлэхэд шаардлагатай код байхгүй байна.';
$string['moodlenet:invalidshareformat'] = 'MoodleNet хуваалцах формат буруу байна';
$string['moodlenet:usernotconfigured'] = 'Танд MoodleNet рүү агуулга хуваалцах зөвшөөрөл байхгүй эсвэл таны бүртгэл буруу тохируулагдсан байна.';
$string['movecatcontentstoroot'] = 'Ангиллын агуулгыг үндсэн хэсэгт шилжүүлэхийг зөвшөөрөхгүй. Та агуулгыг одоо байгаа ангилалд шилжүүлэх шаардлагатай!';
$string['movecatcontentstoselected'] = 'Зарим ангиллын агуулгыг сонгосон ангилалд шилжүүлэх боломжгүй.';
$string['movecategorynotpossible'] = 'Та \'{$a}\' ангиллыг сонгосон ангилалд шилжүүлэх боломжгүй.';
$string['movecategoryownparent'] = 'Та \'{$a}\' ангиллыг үндсэн ангилал болгох боломжгүй.';
$string['movecategoryparentconflict'] = 'Та \'{$a}\' ангиллыг түүний дэд ангиллын аль нэгнийх нь дэд ангилал болгох боломжгүй.';
$string['mssqlrcsmodemissing'] = 'Өгөгдлийн сан нь хүлээгдэж буй READ_COMMITTED_SNAPSHOT горимыг ашиглахгүй байгаа нь ялангуяа зэрэгцсэн сценари их үед буруу үр дүнд хүргэж болзошгүй. Зөв ажиллуулахын тулд үүнийг идэвхжүүлнэ үү. Дэлгэрэнгүй мэдээллийг <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">PHP-д зориулсан MSSQL суулгах тухай</a> баримт бичгээс авна уу.';
$string['multiplerecordsfound'] = 'Олон бичлэг олдсон, зөвхөн нэг бичлэг хүлээгдэж байна.';
$string['multiplerestorenotallow'] = 'Олон дахин сэргээх үйлдлийг зөвшөөрөхгүй!';
$string['mustbeloggedin'] = 'Үүнийг хийхийн тулд та нэвтэрсэн байх шаардлагатай';
$string['mustbeteacher'] = 'Та энэ хуудсыг харахын тулд багш байх шаардлагатай';
$string['myisamproblem'] = 'Өгөгдлийн сангийн хүснэгт нь MyISAM өгөгдлийн сангийн системийг ашигладаг тул InnoDB зэргийг бүрэн дэмждэг ACID системд нийцтэй системийг ашиглахыг зөвлөж байна.';
$string['needcopy'] = 'Та эхлээд ямар нэг зүйлийг хуулбарлах хэрэгтэй!';
$string['needcoursecategroyid'] = 'Хичээлийн id эсвэл ангиллыг тодорхойлсон байх шаардлагатай';
$string['needphpext'] = 'Та PHP суулгацад {$a} дэмжлэгийг нэмэх шаардлагатай';
$string['noadmins'] = 'Администратор байхгүй байна!';
$string['noblocks'] = 'Блок олдсонгүй!';
$string['nocapabilitytousethisservice'] = 'Хэрэглэгч энэ сервисийг ашиглахад шаардлагатай чадваргүй байна';
$string['nocategorydelete'] = '\'{$a}\' ангиллыг устгах боломжгүй!';
$string['nocontext'] = 'Уучлаарай, энэ хичээл нь хүчинтэй сэдэв биш байна';
$string['nodata'] = 'Өгөгдөл байхгүй';
$string['noexistingcategory'] = 'Үүсгэсэн ангилал байхгүй';
$string['nofile'] = 'Файлыг заагаагүй байна';
$string['nofiltersenabled'] = 'Шүүлтүүрийг идэвхжүүлээгүй байна.';
$string['nofolder'] = 'Хүссэн лавлах байхгүй байна';
$string['noformdesc'] = 'Энэ үйл ажиллагаанд formslib маягтын тайлбар файл олдсонгүй.';
$string['noguest'] = 'Энд зочин байхгүй!';
$string['noinstances'] = 'Энэ хичээлд {$a}-ийн жишээ байхгүй байна!';
$string['nologinas'] = 'Та энэ хэрэглэгчийн бүртгэлээр нэвтрэх эрхгүй';
$string['nonmeaningfulcontent'] = 'Ач холбогдолгүй агуулга';
$string['noparticipants'] = 'Энэ хичээлд суралцагч олдсонгүй';
$string['noparticipatorycms'] = 'Уучлаарай, танд тайлагнах хамрагдсан хичээлийн модуль байхгүй байна.';
$string['nopermissions'] = 'Уучлаарай, танд одоогоор үүнийг ({$a}) гүйцэтгэх зөвшөөрөл байхгүй байна.';
$string['nopermissiontoaccesspage'] = 'Танд энэ хуудсанд хандах зөвшөөрөл байхгүй.';
$string['nopermissiontocomment'] = 'Та сэтгэгдэл нэмэх боломжгүй';
$string['nopermissiontodelentry'] = 'Та энэ сэтгэгдлийг устгах боломжгүй!';
$string['nopermissiontoeditcomment'] = 'Та бусад хүмүүсийн сэтгэгдлийг засах боломжгүй!';
$string['nopermissiontohide'] = 'Нуух зөвшөөрөл байхгүй!';
$string['nopermissiontoimportact'] = 'Танд энэ хичээлд үйл ажиллагааг импортлоход шаардлагатай зөвшөөрөл байхгүй байна';
$string['nopermissiontolock'] = 'Түгжих зөвшөөрөл байхгүй!';
$string['nopermissiontomanagegroup'] = 'Танд бүлэг удирдахад шаардлагатай зөвшөөрөл байхгүй байна';
$string['nopermissiontorate'] = 'Зүйлийн үнэлгээг зөвшөөрөхгүй!';
$string['nopermissiontoshow'] = 'Үүнийг харах зөвшөөрөл байхгүй байна!';
$string['nopermissiontounlock'] = 'Түгжих зөвшөөрөл байхгүй байна!';
$string['nopermissiontoupdatecalendar'] = 'Уучлаарай, танд хуанлийн арга хэмжээг шинэчлэх зөвшөөрөл байхгүй байна.';
$string['nopermissiontoviewcalendar'] = 'Уучлаарай, танд хуанлийн арга хэмжээг харах зөвшөөрөл байхгүй байна.';
$string['nopermissiontoviewgrades'] = 'Үнэлгээг харах боломжгүй.';
$string['nopermissiontoviewletergrade'] = 'Үнэлгээний дүнг харах зөвшөөрөл байхгүй байна';
$string['nopermissiontoviewpage'] = 'Танд энэ хуудсыг харах зөвшөөрөл байхгүй байна';
$string['nosite'] = 'Дээд түвшний хичээл олдсонгүй!';
$string['nositeid'] = 'Сайтын ID дугаар байхгүй';
$string['nostartdatenoenddate'] = 'Хичээлийн дуусах огноог зөвхөн эхлэх огноог тохируулсан тохиолдолд л тохируулах боломжтой.';
$string['nostatstodisplay'] = 'Уучлаарай, харуулах боломжтой өгөгдөл байхгүй байна';
$string['notallowedtoupdateprefremotely'] = 'Танд энэ хэрэглэгчийн тохиргоог алсаас шинэчлэх зөвшөөрөл байхгүй байна';
$string['notavailable'] = 'Энэ нь одоогоор боломжгүй байна.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Та энэ хичээлийн бүлгийн гишүүн биш байна';
$string['notownerofkey'] = 'Та энэ түлхүүрийн эзэмшигч биш байна';
$string['nousers'] = 'Ийм хэрэглэгч байхгүй!';
$string['oauth1accesstoken'] = 'OAuth 1.0 алдаа: Бид хандалтын токенг аваагүй.';
$string['oauth1requesttoken'] = 'OAuth 1.0 алдаа: Бид хүсэлтийн токенг аваагүй - үйлчилгээ үзүүлэгч түр хугацаанд ажиллаагүй байж болзошгүй.';
$string['oauth2refreshtokenerror'] = 'OAuth 2 токеныг сэргээж чадсангүй. Алсын төгсгөлийн цэгийн HTTP төлөв: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Нэг эсвэл олон токен гаргагчийн OAuth 2 токенг сэргээж чадсангүй. Дэлгэрэнгүй мэдээллийг ажлын гаралтаас харна уу.';
$string['oauth2upgradetokenerror'] = 'OAuth 2 токенг шинэчлэх боломжгүй. Алсын төгсгөлийн цэгийн HTTP төлөв: {$a}';
$string['onlyadmins'] = 'Үүнийг зөвхөн администратор хийх боломжтой';
$string['onlyeditingteachers'] = 'Үүнийг зөвхөн засварлах эрхтэй багш хийх боломжтой';
$string['onlyeditown'] = 'Та зөвхөн өөрийн мэдээллийг засварлах боломжтой';
$string['opensslsealerror'] = 'OpenSSL өгөгдлийг битүүмжлэх боломжгүй байна';
$string['opensslsignerror'] = 'OpenSSL өгөгдөлд гарын үсэг зурах боломжгүй байна';
$string['orderidnotfound'] = '{$a} захиалгын ID олдсонгүй';
$string['pagenotexist'] = '<p>Байхгүй хуудсыг харах үед онцгой алдаа гарлаа:</p>{$a}';
$string['pagenotexisttitle'] = 'Алдаа 404: Файл олдсонгүй';
$string['pathdoesnotstartslash'] = 'Хүчинтэй аргумент өгөгдөөгүй, зам нь налуу зураасаар эхлэхгүй!';
$string['pleasereport'] = 'Хэрэв та боломжтой бол алдаа гарсан үед ямар үйлдэл хийх байснаа бидэнд мэдэгдэнэ үү.';
$string['pluginrequirementsnotmet'] = '"{$a->pluginname}" ({$a->pluginversion}) нэмэлт хэрэгслийг суулгах боломжгүй. Энэ нь Moodle системийн шинэ хувилбарыг (та {$a->currentmoodle} хувилбарыг ашиглаж байгаа ба танд {$a->requiremoodle} шаардлагатай) шаарддаг.';
$string['pluginunsupported'] = '"{$a->pluginname}" {$a->pluginversion} нэмэлт хэрэгсэл нь Moodle системийн {$a->moodleversion} энэ хувилбарыг дэмждэггүй. Дэмждэг хувилбарыг олохын тулд нэмэлт хэрэгслийн мэдээллийг хайх хэрэгтэй.';
$string['prefixcannotbeempty'] = '<p>Алдаа: өгөгдлийн сангийн хүснэгтийн угтвар хоосон байж болохгүй ({$a})</p>
<p>Сайтын администратор энэ асуудлыг шийдэх шаардлагатай.</p>';
$string['privatefilesupload'] = 'Хэрэглэгчийн хувийн файлын талбарт шууд байршуулахыг дэмжихээ больсон. Ноорог хэсэгт байршуулж, дараа нь core_user::add_user_private_files бүхий файлыг зөөнө.';
$string['processingstops'] = 'Боловсруулалтыг энд зогсооно. Бусад бичлэгийг хадгалахгүй.';
$string['protected_cc_not_supported'] = 'Хамгаалагдсан хэсгийг дэмжихгүй.';
$string['querystringcannotbeempty'] = 'Асуулгын тэмдэгт мөр нь хоосон байж болохгүй.';
$string['redirecterrordetected'] = 'Дэмжигдээгүй дахин чиглүүлэлт илэрсэн, скриптын гүйцэтгэл тасалдсан';
$string['refoundto'] = '{$a} руу буцаан олгох боломжтой';
$string['refoundtoorigi'] = 'Анхны дүнгээр буцаан олгосон: {$a}';
$string['registrationdisabled'] = 'Энэ сайтын бүртгэлийг идэвхгүй болгосон';
$string['remotedownloaderror'] = '<p>Серверт бүрэлдэхүүн хэсгийг татаж авч чадсангүй. Прокси тохиргоог шалгана уу; PHP cURL өргөтгөлийг ашиглахыг зөвлөж байна.</p>
<p>Та <a href="{$a->url}">{$a->url}</a> файлыг гараар татан авч серверийнхээ "{$a->dest}" руу хуулж, задлах шаардлагатай.</p>';
$string['remotedownloadnotallowed'] = 'Серверт бүрэлдэхүүн хэсгийг татаж авахыг зөвшөөрөхгүй (allow_url_fopen идэвхгүй байна).<br /><br />Та <a href="{$a->url}">{$a->url}</a> файлыг гараар татан авч серверийнхээ "{$a->dest}" руу хуулж, задлах шаардлагатай.';
$string['reportnotavailable'] = 'Энэ төрлийн тайланг зөвхөн сайтын хичээлд ашиглах боломжтой';
$string['requirecorrectaccess'] = 'URL хаяг эсвэл порт хүчингүй байна.';
$string['requireloginerror'] = 'Хичээл эсвэл үйл ажиллагаанд хандах боломжгүй.';
$string['restore_path_element_missingmethod'] = 'Сэргээх арга {$a} бахйгүй байна. Үүнийг хөгжүүлэгч тодорхойлсон байх ёстой.';
$string['restore_path_element_noobject'] = 'Сэргээх {$a} объект нь объект биш байна.';
$string['restorechecksumfailed'] = 'Таны сейшнд хадгалагдсан мэдээллийг сэргээхэд асуудал гарлаа. PHP санах ой/DB багцын хэмжээний хязгаарыг шалгана уу. Сэргээх ажиллагаа зогссон болно.';
$string['restrictedcontextexception'] = 'Уучлаарай, гадаад функцийн гүйцэтгэл нь хамрах хүрээний хязгаарлалтыг зөрчиж байна.';
$string['restricteduser'] = 'Уучлаарай, үүнийг таны одоогийн "{$a}" бүртгэлээр хийх боломжгүй';
$string['reverseproxyabused'] = 'Урвуу проксийг идэвхжүүлсэн тул серверт шууд хандах боломжгүй.<br />Серверийн администратортой холбогдоно уу.';
$string['rpcerror'] = 'Таны MNET холболт амжилтгүй боллоо! Энд администраторт дамжуулах алдааны зурвас байна: {$a}';
$string['scheduledbackupsdisabled'] = 'Серверийн админ нь төлөвлөгөөт нөөцлөлтийг идэвхгүй болгосон';
$string['secretalreadyused'] = 'Нууц үг солихыг баталгаажуулах холбоосыг ашигласан байна, нууц үг өөрчлөгдөөгүй';
$string['sectionnotexist'] = 'Энэ хэсэг байхгүй байна';
$string['sendmessage'] = 'Зурвас илгээх';
$string['sendmessagesent'] = '<br>{$a} талаар санал хүсэлт илгээсэнд баярлалаа';
$string['serverconnection'] = 'Сервертэй холбогдоход алдаа гарлаа';
$string['servicedonotexist'] = 'Сервис байхгүй байна';
$string['sessioncannotobtainlock'] = '<p>{$a->acquiretimeout} дотор {$a->id} сейшны түгжээг авах боломжгүй.</p>
<p>Өөр хөтөч дээр өөр хуудас ({$a->whohaslock}) ажиллаж байгаа эсвэл алдааны улмаас түгжээг тайлаагүй байх магадлалтай.</p>
<p>Та сейшн түгжих хугацааг дуусах хүртэл хүлээх боломжтой ({$a->lockexpire}) эсвэл хөтчийн сейшныг дахин эхлүүлж болно. Энэ алдаа гарсаар байвал серверийн администраторт мэдэгдэнэ үү.</p>';
$string['sessioncookiesdisable'] = 'require_key_login() буруу ашигласан - сейшн күүкийг идэвхгүй болгох ёстой!';
$string['sessiondiskfull'] = 'Сейшны хуваарилалт дүүрсэн. Одоогоор нэвтрэх боломжгүй. Серверийн администраторт мэдэгдэнэ үү.';
$string['sessionerroruser'] = 'Таны сейшны хугацаа дууссан. Дахин нэвтэрнэ үү.';
$string['sessionerroruser2'] = 'Таны нэвтрэх сейшнд нөлөөлөх серверийн алдаа илэрсэн. Дахин нэвтрэх буюу хөтчөө дахин ачаална уу.';
$string['sessionexpired'] = 'Сейшн дууссан';
$string['sessionhandlerproblem'] = 'Сейшн зохицуулагчийг буруу тохируулсан байна';
$string['sessionipnomatch'] = 'Уучлаарай, таны IP дугаар анх нэвтэрснээс хойш өөрчлөгдсөн байна. Энэхүү хамгаалалтын функц нь сайтад нэвтэрсэн үед таны хувийн мэдээллийг алдагдахаас сэргийлдэг. Энгийн хэрэглэгчид энэ зурвасыг харуулах шаардлагагүй. Тусламж шаардлагатай бол сайтын администраторт хандана уу.';
$string['sessionipnomatch2'] = '<p>Уучлаарай, таны IP дугаар анх нэвтэрснээс хойш өөрчлөгдсөн бололтой. Энэхүү хамгаалалтын функц нь энэ сайтад нэвтэрсэн үед таны хувийн мэдээллийг хулгайлагдахаас сэргийлнэ. Утасгүй сүлжээ ашиглах эсвэл төрөл бүрийн сүлжээ хооронд роуминг хийх үед энэ алдаа гарч болзошгүй. Нэмэлт тусламжийг сайтын администраторт хандан авна уу.</p>
<p>Үргэлжлүүлэхийг хүсвэл F5 товчийг дарж энэ хуудсыг сэргээнэ үү.</p>';
$string['sessionwaiterr'] = 'Сейшн түгжихийг хүлээх үед хугацаа хэтэрсэн.<br />Хийгдэж буй хүсэлт дуусахыг хүлээгээд дараа дахин оролдоно уу.';
$string['shortnametaken'] = 'Товч нэрийг өөр хичээлд ашигласан байна ({$a})';
$string['sitepolicynotagreed'] = 'Сайтын бодлогыг зөвшөөрөөгүй: <a href="{$a}">Сайтын бодлогыг нээхийн тулд энд дарна уу.</a>';
$string['socksnotsupported'] = 'SOCKS5 проксиг PHP4 дээр дэмждэггүй';
$string['spellcheckernotconf'] = 'Үгийн алдаа шалгагчийг тохируулаагүй байна';
$string['sslonlyaccess'] = 'Аюулгүй байдлын үүднээс зөвхөн https холболтыг зөвшөөрдөг, уучлаарай.';
$string['statscatchupmode'] = 'Одоогоор статистик нь барих горимд байна. Одоогийн байдлаар {$a->daysdone} өдрийг боловсруулж, {$a->dayspending} өдөр хүлээгдэж байна. Эргэн шалгана уу!';
$string['statsdisable'] = 'Статистикийг идэвхжүүлээгүй байна.';
$string['statsnodata'] = 'Тухайн хичээл болон хугацааны хослолын талаарх мэдээлэл байхгүй байна';
$string['storedfilecannotcreatefile'] = 'Дотоод файлын сангийн файлыг үүсгэх боломжгүй. Өгөгдлийн суурь хэсэгт хандах болон боломжит дискийн зайг шалгана уу.';
$string['storedfilecannotcreatefiledirs'] = 'Дотоод файлын сангийн лавлахыг үүсгэх боломжгүй. Өгөгдлийн суурь хэсэгт хандах зөвшөөрлийг баталгаажуулна уу.';
$string['storedfilecannotread'] = 'Файлыг уншиж чадахгүй байна. Файл байхгүй эсвэл зөвшөөрөлтэй холбоотой асуудал байна.';
$string['storedfilecannotreadfile'] = '\'{$a}\' файлыг уншиж чадахгүй байна. Файл байхгүй эсвэл зөвшөөрөлтэй холбоотой асуудал байна.';
$string['storedfilenotcreated'] = '{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename} файлыг үүсгэж чадахгүй байна';
$string['storedfileproblem'] = 'Дотоод файлтай холбоотой тодорхойгүй тайлбар ({$a})';
$string['tagdisabled'] = 'Тагийг идэвхгүй болгосон!';
$string['tagnotfound'] = 'Тодорхойлсон таг нь өгөгдлийн сангаас олдсонгүй';
$string['targetdatabasenotempty'] = 'Хэрэгцээт өгөгдлийн сан хоосон биш байна. Аюулгүй байдлын үүднээс үйл ажиллагааг зогсоосон.';
$string['textconditionsnotallowed'] = 'Бичвэрийн баганын нөхцөлийг харьцуулахыг зөвшөөрөхгүй. Асуулгад sql_compare_text() ашиглана уу.';
$string['themenotinstall'] = 'Энэ загварыг суулгаагүй байна!';
$string['tokengenerationfailed'] = 'Шинэ токен үүсгэх боломжгүй.';
$string['transactionvoid'] = 'Өмнө нь хүчингүй болгосон тул уг үйлдлийг хүчингүй болгох боломжгүй';
$string['unenrolerror'] = 'Тухайн хүнийг бүртгэлээс хасах үед алдаа гарлаа';
$string['unicodeupgradeerror'] = 'Уучлаарай, таны өгөгдлийн сан Юникодод ороогүй, Moodle системийн энэ хувилбар нь таны өгөгдлийн санг Юникодод шилжүүлэх боломжгүй байна. Эхлээд Moodle 1.7.x хувилбараар шинэчилж, админ хуудаснаас Юникод шилжүүлэлтийг хийнэ үү. Үүний  дараа та Moodle {$a} руу шилжих боломжтой болно.';
$string['unknowaction'] = 'Үл мэдэгдэх үйлдэл!';
$string['unknowcategory'] = 'Ангилал тодорхойгүй байна!';
$string['unknowcontext'] = 'Энэ нь get_child_contexts доторх үл мэдэгдэх сэдэв ({$a}) байна!';
$string['unknowformat'] = 'Формат тодорхойгүй байна ({$a})';
$string['unknownbackupexporterror'] = 'Импортлох мэдээллийг бэлтгэхэд үл мэдэгдэх алдаа гарлаа';
$string['unknownblockregion'] = '\'{$a}\' блок бүсийг энэ хуудсанд танихгүй байна.';
$string['unknowncategory'] = 'Ангиллын "{$a}" ID дугаар бүхий үл мэдэгдэх ангилал';
$string['unknowncontext'] = 'Энэ нь үл мэдэгдэх сэдэв байна.';
$string['unknowncourse'] = '"{$a}" нэртэй үл мэдэгдэх хичээл';
$string['unknowncourseidnumber'] = '"{$a}" тодорхойгүй хичээлийн ID дугаар';
$string['unknowncourserequest'] = 'Тодорхойгүй хичээлийн хүсэлт';
$string['unknowncoursesection'] = '"{$a}" хичээлийн тодорхойгүй хичээлийн хэсэг';
$string['unknownevent'] = 'Тодорхойгүй арга хэмжээ';
$string['unknownfiletype'] = 'Тодорхойгүй шүүлтүүрийн төрлийн алдаа';
$string['unknowngroup'] = '"{$a}" тодорхойгүй бүлэг';
$string['unknownjsinrequirejs'] = '{$a} Жаваскриптын санг олж чадсангүй.';
$string['unknownmodulename'] = 'Маягтын үл мэдэгдэх модулийн нэр';
$string['unknownrole'] = '"{$a}" тодорхойгүй үүрэг';
$string['unknownsortcolumn'] = '{$a} тодорхойгүй эрэмбэлэх багана';
$string['unknownuseraction'] = 'Уучлаарай, би энэ хэрэглэгчийн үйлдлийг ойлгохгүй байна.';
$string['unknownuserselector'] = 'Тодорхойгүй хэрэглэгчийн сонгогч';
$string['unknoworder'] = 'Тодорхойгүй эрэмбэлэлт';
$string['unknowparamtype'] = 'Тодорхойгүй параметрийн төрөл: {$a}';
$string['unknowquestiontype'] = '{$a} дэмжигдээгүй асуултын төрөл';
$string['unknowuploadaction'] = 'Алдаа: Тодорхойгүй байршуулах үйлдэл ({$a})';
$string['unspecifycourseid'] = 'Хичээлийн ID дугаар, товч нэр эсвэл ID дугаарыг зааж өгөх ёстой';
$string['unsupportedevent'] = 'Дэмжигдээгүй арга хэмжээний төрөл';
$string['unsupportedstate'] = 'Дэмжигдээгүй гүйцэтгэлийн төлөв';
$string['unsupportedwebserver'] = 'Вэб серверийн программ хангамжийг ({$a}) дэмждэггүй, уучлаарай.';
$string['upgraderequires19'] = 'Алдаа: Серверт Moodle системийн шинэ хувилбарыг суулгасан. Харамсалтай нь өмнөх хувилбарыг шинэчлэх боломжгүй байна.<br />Эхлээд хамгийн сүүлийн үеийн 1.9.x хувилбараар шинэчилнэ үү. Эх файлуудыг дахин суулгаснаар өмнөх хувилбарт буцах боломжтой.';
$string['upgraderunning'] = 'Сайт шинэчлэгдэж байна, дараа дахин хандана уу.';
$string['urlnotdefinerss'] = 'RSS мэдэгдлийн URL хаягийг тодорхойлоогүй байна';
$string['useradmineditadmin'] = 'Зөвхөн администратор нь бусад администраторын бүртгэлийг өөрчлөх эрхтэй';
$string['useradminodelete'] = 'Администраторын бүртгэлийг устгах боломжгүй.';
$string['userautherror'] = 'Тодорхойгүй баталгаажилтын нэмэлт хэрэгсэл';
$string['userauthunsupported'] = 'Энд баталгаажилтын нэмэлт хэрэгслийг дэмждэггүй';
$string['useremailduplicate'] = 'Давхардсан хаяг';
$string['userisfilteredout'] = 'Энэ хэрэглэгч нь шүүлтүүр болон хүснэгтийн тохиргоонд тохирохгүй байна!';
$string['usermustbemnet'] = 'MNET хандалтын хяналтын жагсаалтад байгаа хэрэглэгч нь MNET алсын хэрэглэгч байх ёстой';
$string['usernamelowercase'] = 'Хэрэглэгчийн нэрийг жижиг үсгээр бичсэн байх ёстой';
$string['usernotaddederror'] = 'Хэрэглэгч нэмэгдсэнгүй - алдаа';
$string['usernotaddedregistered'] = 'Хэрэглэгч нэмэгдсэнгүй - бүртгэгдсэн байна';
$string['usernotavailable'] = 'Танд энэ хэрэглэгчийн дэлгэрэнгүй мэдээлэл байхгүй байна';
$string['usernotdeletedadmin'] = 'Администраторын бүртгэлээр устгаагүй хэрэглэгчийг устгах боломжгүй.';
$string['usernotdeleteddeleted'] = 'Энэ хэрэглэгчийг хэдийнэ устгасан байна.';
$string['usernotdeletederror'] = 'Хэрэглэгч устгагдсангүй - алдаа';
$string['usernotdeletedmissing'] = 'Хэрэглэгч устгагдсангүй - хэрэглэгчийн нэр олдохгүй байна';
$string['usernotdeletedoff'] = 'Хэрэглэгч устгагдсангүй - устгах боломжгүй';
$string['usernotfullysetup'] = 'Хэрэглэгчийг бүрэн тохируулаагүй байна';
$string['usernotincourse'] = 'Энэ хэрэглэгч уг хичээлд хамрагдаагүй байна!';
$string['usernotrenamedadmin'] = 'Админ бүртгэлийн нэрийг өөрчлөх боломжгүй';
$string['usernotrenamedexists'] = 'Хэрэглэгчийн нэр өөрчлөгдсөнгүй - шинэ хэрэглэгчийн нэр ашиглагдаж байна';
$string['usernotrenamedmissing'] = 'Хэрэглэгчийн нэр өөрчлөгдсөнгүй - хэрэглэгчийн хуучин нэр олдохгүй байна';
$string['usernotrenamedoff'] = 'Хэрэглэгчийн нэр өөрчлөгдсөнгүй - нэрийг өөрчлөх боломжгүй';
$string['usernotupdatedadmin'] = 'Админ бүртгэлийг шинэчлэх боломжгүй';
$string['usernotupdatederror'] = 'Хэрэглэгч шинэчлэгдсэнгүй - алдаа';
$string['usernotupdatednotexists'] = 'Хэрэглэгч шинэчлэгдсэнгүй - байхгүй байна';
$string['userquotalimit'] = 'Та өөрийн файлын тогтоосон хязгаарт хүрсэн байна.';
$string['userselectortoomany'] = 'Олон сонголтот нь худал байсан ч user_selector нь нэгээс олон сонгосон хэрэглэгчтэй болсон.';
$string['verifyagedigitalconsentnotpossible'] = 'Уучлаарай, одоогоор дижитал насны зөвшөөрлийг баталгаажуулах боломжгүй.';
$string['wrongcall'] = 'Энэ скриптыг буруу дуудсан байна';
$string['wrongcontextid'] = 'Сэдвийн ID дугаар буруу байна (олж чадсангүй)';
$string['wrongdestpath'] = 'Зам буруу байна';
$string['wrongroleid'] = 'Үүргийн ID дугаар буруу!';
$string['wrongsourcebase'] = 'Эх сурвалжийн URL хаягийн суурь буруу байна';
$string['wrongusernamepassword'] = 'Хэрэглэгч/нууц үг буруу байна';
$string['wrongzipfilename'] = 'ZIP файлын нэр буруу байна';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Хичээл үүсгэж чадсангүй - Зөвшөөрөл байхгүй';
$string['wwwrootmismatch'] = 'Буруу хандалт илэрсэн тул энэ серверт зөвхөн "{$a}" хаягаар хандах боломжтой. Уучлаарай.<br />Серверийн администраторт мэдэгдэнэ үү.';
$string['wwwrootslash'] = 'config.php файлд алдаатай $CFG->wwwroot илэрсэн. Энэ нь арын налуу зураастай байх ёсгүй.<br />Серверийн администраторт мэдэгдэнэ үү.';
$string['xmldberror'] = 'XMLDB алдаа!';
$string['youcannotdeletecategory'] = 'Та  агуулгыг устгах, өөр газарт зөөх боломжгүй тул \'{$a}\' ангиллыг устгах боломжгүй.';
