<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'mn', version '5.0'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Асуулт нэмэх';
$string['add_pagebreak'] = 'Хуудас тусгаарлагч нэмэх';
$string['adjustment'] = 'Тохируулга';
$string['after_submit'] = 'Илгээсний дараа';
$string['allowfullanonymous'] = 'Бүтэн нэргүй байхыг зөвшөөрөх';
$string['analysis'] = 'Шинжлэх';
$string['anonymous'] = 'Нэргүй';
$string['anonymous_edit'] = 'Хэрэглэгчийн нэрсийн бүртгэл';
$string['anonymous_entries'] = 'Нэргүй бичлэгүүд ({$a})';
$string['anonymous_user'] = 'Нэргүй хэрэглэгч';
$string['answerquestions'] = 'Асуултад хариулах';
$string['append_new_items'] = 'Шинэ зүйл нэмэх';
$string['autonumbering'] = 'Асуултуудыг автоматаар дугаарлах';
$string['autonumbering_help'] = 'Асуултыг автоматаар дугаарлахыг идэвхжүүлэх эсвэл идэвхгүй болгох';
$string['average'] = 'Дундаж';
$string['bold'] = 'Тод';
$string['calendarend'] = 'Хаах: {$a}';
$string['calendarstart'] = 'Нээх: {$a}';
$string['cannotaccess'] = 'Та хичээлээс зөвхөн энэ хариунд хандах эрхтэй байна.';
$string['cannotsavetempl'] = 'Загварыг хадгалахыг зөвшөөрөөгүй байна';
$string['captcha'] = 'Хүн ба тооцоолуурыг ялгах бүрэн автомат нээлттэй Түүрингийн шалгалт';
$string['captchanotset'] = 'Хүн ба тооцоолуурыг ялгах бүрэн автомат нээлттэй Түүрингийн шалгалтыг тохируулаагүй байна.';
$string['check'] = 'Олон сонголттой - олон хариулттай';
$string['check_values'] = 'Байж болох хариултууд';
$string['checkbox'] = 'Олон сонголттой - олон хариулттай байхыг зөвшөөрнө (дөрвөлжнийг чагтлах)';
$string['choosefile'] = 'Файл сонгох';
$string['chosen_feedback_response'] = 'Сонгосон санал хүсэлтийн хариулт';
$string['closebeforeopen'] = 'Та дуусах хугацааг эхлэх хугацааны өмнө тодорхойлсон байна.';
$string['complete_the_form'] = 'Асуултад хариулах';
$string['completed'] = 'Дууссан';
$string['completed_feedbacks'] = 'Илгээсэн хариултууд';
$string['completedon'] = '{$a}-д дуусна';
$string['completiondetail:submit'] = 'Хариу илгээх';
$string['completionsubmit'] = 'Хэрэв хариуг илгээсэн бол дууссан гэж харагдана.';
$string['configallowfullanonymous'] = 'Хэрэв \'тийм\' гэж тохируулсан бол, хэрэглэгч нэвтрэх шаардлагагүйгээр нүүр хуудас дээр хариу өгөх үйлдлийг дуусгах боломжтой.';
$string['confirmdeleteentry'] = 'Та энэ бичлэгийг устгахдаа итгэлтэй байна уу?';
$string['confirmdeleteitem'] = 'Та энэ элементийг устгахдаа итгэлтэй байна уу?';
$string['confirmdeletetemplate'] = 'Та энэ загварыг устгахдаа итгэлтэй байна уу?';
$string['confirmusetemplate'] = 'Та энэ загварыг ашиглахдаа итгэлтэй байна уу?';
$string['continue_the_form'] = 'Асуултуудад үргэлжлүүлэн хариулах';
$string['count_of_nums'] = 'Дугааруудыг тоолох';
$string['courseid'] = 'Хичээлийн ID';
$string['creating_templates'] = 'Эдгээр асуултуудыг шинэ загвар болгож хадгалах';
$string['delete_entry'] = 'устгах';
$string['delete_item'] = 'Асуултыг устгах';
$string['delete_old_items'] = 'Хуучин зүйлсийг устгах';
$string['delete_pagebreak'] = 'Хуудас тусгаарлагчийг устгах';
$string['delete_template'] = 'Загварыг устгах';
$string['delete_templates'] = 'Загварыг устгах ...';
$string['depending'] = 'Хамаарлууд';
$string['depending_help'] = 'Зүйлийн утгаас хамааралтай зүйлийг харуулах боломжтой.<br/>
<strong>Жишээ нь:</strong><br />
<ul>
<li>Эхлээд, бусад зүйлийг хамааруулах зүйл үүсгэнэ.</li>
<li>Дараа нь, хуудас тусгаарлагч нэмнэ.</li>
<li>Үүний дараа өмнө үүсгэсэн зүйлийн утгаас хамаарах зүйлүүдийг нэмнэ. "Хамаарах зүйл" гэсэн жагсаалтаас зүйлээ сонгож, "Хамаарах утга" гэсэн бичвэр талбарт шаардлагатай утгыг бичнэ.</li>
</ul>
<strong>Уг зүйлийн бүтэц дараах байдалтай харагдах ёстой:</strong>
<ol>
<li>Зүйл Q: Та машинтай юу? A: тийм/үгүй</li>
<li>Хуудас тусгаарлагч</li>
<li>Зүйл Q: Таны машин ямар өнгөтэй вэ?<br />
(энэ зүйл нь өмнөх зүйл 1-ийн тийм гэсэн утгаас хамааралтай байна)</li>
<li>Зүйл Q: Та яагаад машингүй юм бэ?<br />
(энэ зүйл нь өмнөх зүйл 1-ийн үгүй гэсэн утгаас хамааралтай байна)</li>
<li> ... бусад зүйл</li>
</ol>';
$string['dependitem'] = 'Хамаарах зүйл';
$string['dependvalue'] = 'Хамаарах утга';
$string['description'] = 'Тайлбар';
$string['do_not_analyse_empty_submits'] = 'Хоосон илгээсэн бол шинжилгээ хийхгүй';
$string['downloadresponseas'] = 'Бүх хариултыг дараах нэрээр татаж авах:';
$string['drop_feedback'] = 'Энэ хичээлээс хасах';
$string['dropdown'] = 'Олон сонголттой - нэг хариултыг зөвшөөрнө (доош буудаг жагсаалт)';
$string['dropdown_values'] = 'Хариунууд';
$string['dropdownlist'] = 'Олон сонголттой - нэг хариулттай (нээгдэх цэс)';
$string['dropdownrated'] = 'Нээгдэх цэс (тааруулах)';
$string['edit_item'] = 'Асуултыг засварлах';
$string['edit_items'] = 'Асуултуудыг засварлах';
$string['email_notification'] = 'Мэдүүлэг илгээхэд мэдэгдлийг идэвхжүүлэх';
$string['email_notification_help'] = 'Идэвхжүүлбэл багш нар хариу ирсэн талаар мэдэгдэл хүлээн авна.';
$string['emailteachermail'] = '{$a->username} хариуг илгээж дууслаа: \'{$a->feedback}\'

Та үүнийг эндээс үзэж болно:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} хариуг илгээж дууслаа:
<i>\'{$a->feedback}\'</i>.</p>
<p>Энэ нь <a href="{$a->url}">хуудас дээр бий</a>.</p>';
$string['entries_saved'] = 'Таны хариултыг хадгалсан. Баярлалаа.';
$string['eventresponsedeleted'] = 'Хариулт устгагдсан';
$string['eventresponsesubmitted'] = 'Хариулт илгээгдсэн';
$string['export_questions'] = 'Асуултуудыг экспортлох';
$string['export_to_excel'] = 'Excel форматаар экспортлох';
$string['feedback:addinstance'] = 'Хариу шинээр нэмэх';
$string['feedback:complete'] = 'Хариуг дуусгах';
$string['feedback:createprivatetemplate'] = 'Хувийн загвар үүсгэх';
$string['feedback:createpublictemplate'] = 'Нийтийн загвар үүсгэх';
$string['feedback:deletesubmissions'] = 'Илгээж дуусгасан мэдүүлгийг устгах';
$string['feedback:deletetemplate'] = 'Загварыг устгах';
$string['feedback:edititems'] = 'Зүйлүүдийг засварлах';
$string['feedback:mapcourse'] = 'Хичээлүүдийг гадаад хариу руу харгалзуулах';
$string['feedback:receivemail'] = 'Цахим шуудангаар мэдэгдэл хүлээн авах';
$string['feedback:view'] = 'Хариуг үзэх';
$string['feedback:viewanalysepage'] = 'Илгээсний дараа шинжилгээ хийх хуудсыг үзэх';
$string['feedback:viewreports'] = 'Тайлангуудыг үзэх';
$string['feedback_is_not_for_anonymous'] = 'Хариу нь нэргүй хэрэглэгчдэд зориулагдаагүй';
$string['feedback_is_not_open'] = 'Энэ хариу нээлттэй биш байна';
$string['feedbackclose'] = 'Хариултуудыг зөвшөөрөх:';
$string['feedbackcompleted'] = '{$a->username} хэрэглэгч {$a->feedbackname}-г дуусгасан';
$string['feedbackopen'] = 'Хариулахыг зөвшөөрөх:';
$string['feedbackupdated'] = 'Хариу шинэчлэгдсэн.';
$string['file'] = 'Файл';
$string['filter_by_course'] = 'Хичээлээр шүүх';
$string['handling_error'] = 'Хариуны модулийн үйлдлийг боловсруулахад алдаа гарлаа';
$string['hide_no_select_option'] = '"Сонгогдоогүй" гэсэн сонголтыг нуух';
$string['horizontal'] = 'Хөндлөн';
$string['import_questions'] = 'Асуултуудыг импортлох';
$string['import_successfully'] = 'Импорт амжилттай боллоо';
$string['importfromthisfile'] = 'Энэ файлаас импортлох';
$string['includeuserinrecipientslist'] = 'Хүлээн авагчдын жагсаалтад {$a}-г оруулах';
$string['indicator:cognitivedepth'] = 'Хариуны танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн хариуны үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд суурилдаг.';
$string['indicator:cognitivedepthdef'] = 'Хариуны танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд хариуны үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Харагдахгүй, Харах, Илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Хариуны нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн хариуны үйл ажиллагаанд хүрсэн нийгмийн хүрээнд суурилдаг.';
$string['indicator:socialbreadthdef'] = 'Хариуны нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд хариуны үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Оролцоогүй, Ганцаар оролцсон, Бусадтай хамт оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Мэдээлэл';
$string['infotype'] = 'Мэдээллийн төрөл';
$string['insufficient_responses'] = 'хангалтгүй хариултууд';
$string['insufficient_responses_for_this_group'] = 'Энэ бүлэгт хангалтгүй хариултууд байна';
$string['insufficient_responses_help'] = 'Хариуг нэргүй байлгахын тулд, хамгийн багадаа 2 хариулт байх ёстой.';
$string['item_label'] = 'Шошго';
$string['item_name'] = 'Асуулт';
$string['label'] = 'Шошго';
$string['labelcontents'] = 'Агуулга';
$string['mapcourse'] = 'Хариуг хичээлүүдэд харгалзуулах';
$string['mapcourse_help'] = 'Таны нүүр хуудас дээр үүсгэгдсэн хариуны маягтуудыг өгөгдмөлөөр сайт-даяар үзүүлэх ба хариуны блок ашиглаж бүх хичээл дээр гарч ирнэ. Та хариуны маягтыг наалддаг блок болгосноор бүх хуудсанд гарч ирэхийг албадах эсвэл хариуны маягтыг тодорхой хичээлүүдэд харгалзуулах замаар гарч ирэх хичээлүүдийг хязгаарлаж болно.';
$string['mapcourseinfo'] = 'Энэ бол хариуны блок ашиглаж бүх хичээлүүдэд гарч ирдэг сайт-даяар харагдах хариу. Гэхдээ та тэдгээрийн харагдах хичээлүүдийг харгалзуулан зааж өгөн хязгаарлах боломжтой. Хичээлийг хайж, энэ хариунд харгалзуулна.';
$string['mapcoursenone'] = 'Харгалзуулсан хичээл байхгүй байна. Бүх хичээлүүдэд хариуг харуулах боломжтой.';
$string['mapcourses'] = 'Хичээлүүдэд хариуг харгалзуулах';
$string['mappedcourses'] = 'Харгалзуулсан хичээлүүд';
$string['mappingchanged'] = 'Хичээлүүдийн харгалзааг өөрчилсөн';
$string['maximal'] = 'Хамгийн их';
$string['messageprovider:message'] = 'Хариуны сануулга';
$string['messageprovider:submission'] = 'Хариуны мэдэгдэлүүд';
$string['minimal'] = 'Хамгийн бага';
$string['mode'] = 'Горим';
$string['modulename'] = 'Хариу';
$string['modulename_help'] = 'Санал хүсэлтийн үйл ажиллагаа нь багшид олон сонголттой, тийм/үгүй эсвэл бичвэр оруулах зэрэг төрөл бүрийн асуултын төрлүүдийг ашиглан оролцогчдоос санал хүсэлт цуглуулах судалгаа үүсгэх боломжийг олгодог.

Хэрэв хүсвэл санал хүсэлтийн хариултууд нь нэргүй байж болох бөгөөд үр дүнг бүх оролцогчдод харуулах эсвэл зөвхөн багш нарт үзүүлэх боломжтой. Вебийн нүүр хуудас дээрх санал хүсэлтэд системд нэвтрээгүй хэрэглэгчид мөн хариулах боломжтой.

Санал хүсэлтийн үйл ажиллагааг дараах  зорилгоор ашиглаж болно

* Дараагийн оролцогчдод зориулж хичээлийн агуулгыг сайжруулах зорилгоор хичээлийг үнэлэхэд
* Оролцогчид хичээлийн модулиуд, арга хэмжээ зэрэгт бүртгүүлэх
* Хичээл сонголт, сургуулийн бодлого гэх мэт зочдын судалгаанд зориулагдсан.
* Суралцагчид бусдыг доромжилсон, бүдүүлэг харьцааны талаар нэрээ нууцлан мэдэгдэх, дээрэлхэх харилцааг арилгах судалгаа хийхэд';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Санал хүсэлт';
$string['move_item'] = 'Энэ асуултыг шилжүүлэх';
$string['multichoice'] = 'Олон сонголттой';
$string['multichoice_values'] = 'Олон сонголттой утгууд';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Олон сонголттой (үнэлгээтэй)';
$string['multichoicetype'] = 'Олон сонголттой төрөл';
$string['multiplesubmit'] = 'Олон хариу илгээхийг зөвшөөрөх';
$string['multiplesubmit_help'] = 'Нэргүй судалгааг идэвхжүүлсэн тохиолдолд хэрэглэгч хязгааргүй тоогоор санал хүсэлт илгээж болно';
$string['name'] = 'Нэр';
$string['name_required'] = 'Нэр шаардлагатай';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Дараагийн хуудас';
$string['no_handler'] = 'Үйлдэл зохицуулагч  байхгүй байна:';
$string['no_itemlabel'] = 'Шошго байхгүй';
$string['no_itemname'] = 'itemname байхгүй';
$string['no_items_available_yet'] = 'Одоогоо асуулт тавиагүй байна';
$string['no_templates_available_yet'] = 'Одоогоор бэлэн загвар байхгүй';
$string['non_anonymous'] = 'Хэрэглэгчийн нэрийг бүртгэж хариултын хамт харуулах';
$string['non_anonymous_entries'] = 'Нэргүй бичлэгүүд ({$a})';
$string['non_respondents_students'] = 'Хамрагдаагүй суралцагчид ({$a})';
$string['not_completed_yet'] = 'Хараахан дуусгаагүй байна';
$string['not_selected'] = 'Сонгогдоогүй';
$string['not_started'] = 'Эхлээгүй';
$string['numberoutofrange'] = 'Тоо хязгаараас гарсан';
$string['numeric'] = 'Тоон хариулт';
$string['numeric_range_from'] = 'Эхлэх хязгаар:';
$string['numeric_range_to'] = 'Дуусах хязгаар:';
$string['of'] = '-ийн';
$string['oldvaluespreserved'] = 'Бүх хуучин асуултууд болон өгөгдсөн утгуудыг хадгалах';
$string['oldvalueswillbedeleted'] = 'Одоо байгаа асуултууд болон бүх хариулт устах болно.';
$string['only_one_captcha_allowed'] = 'Санал хүсэлтэнд зөвхөн нэг Хүн ба тооцоолуурыг ялгах бүрэн автомат нээлттэй Түүрингийн шалгалт зөвшөөрөгдөнө';
$string['openafterclose'] = 'Та эхлэх огноог хаах огнооноос хойно тохируулсан байна';
$string['overview'] = 'Тойм';
$string['page'] = 'Хуудас';
$string['page-mod-feedback-x'] = 'Санал хүсэлтийн модулын дурын хуудас';
$string['page_after_submit'] = 'Дууссан тухай зурвас';
$string['pagebreak'] = 'Хуудас тусгаарлагч';
$string['pluginadministration'] = 'Санал хүсэлтийн удирдлага';
$string['pluginname'] = 'Санал хүсэлт';
$string['position'] = 'Байрлал';
$string['previewquestions'] = 'Өмнөх асуултууд';
$string['previous_page'] = 'Өмнөх хуудас';
$string['privacy:metadata:completed'] = 'Санал хүсэлтэд ирүүлсэн хариуны бүртгэл';
$string['privacy:metadata:completed:anonymousresponse'] = 'Хариулахдаа нэрээ нууцлах эсэх.';
$string['privacy:metadata:completed:timemodified'] = 'Хариултыг хамгийн сүүлд өөрчилсөн цаг.';
$string['privacy:metadata:completed:userid'] = 'Санал хүсэлтийн үйл ажиллагааг дуусгасан хэрэглэгчийн ID.';
$string['privacy:metadata:completedtmp'] = 'Одоо боловсруулж буй мэдүүлгийн бүртгэл.';
$string['privacy:metadata:value'] = 'Асуултын хариултын бүртгэл.';
$string['privacy:metadata:value:value'] = 'Сонгогдсон хариулт.';
$string['privacy:metadata:valuetmp'] = 'Илгээж буй асуултын хариултын бүртгэл.';
$string['public'] = 'Нийтийн';
$string['question'] = 'Асуулт';
$string['questionandsubmission'] = 'Асуултын болон илгээх тохиргоо';
$string['questions'] = 'Асуултууд';
$string['questionslimited'] = 'Зөвхөн эхний  {$a} асуултыг харуулж байна. Бүх хариултыг харах эсвэл хүснэгтийн өгөгдлийг татаж авах боломжтой.';
$string['radio'] = 'Олон сонголт - нэг хариулт';
$string['radio_values'] = 'Хариултууд';
$string['ready_feedbacks'] = 'Бэлэн санал хүсэлтүүд';
$string['required'] = 'Шаардлагатай';
$string['resetting_data'] = 'Санал хүсэлтийн хариултыг дахин тохируулах';
$string['resetting_feedbacks'] = 'Санал хүсэлтүүдийг дахин тохируулж байна';
$string['response_nr'] = 'Хариултын дугаар';
$string['responses'] = 'Хариултууд';
$string['responsetime'] = 'Хариу өгөх хугацаа';
$string['save_as_new_item'] = 'Шинэ асуулт болгож хадгалах';
$string['save_as_new_template'] = 'Шинэ загвар болгож хадгалах';
$string['save_entries'] = 'Хариултуудаа илгээх';
$string['save_item'] = 'Асуултыг хадгалах';
$string['saving_failed'] = 'Хадгалж чадсангүй';
$string['search:activity'] = 'Санал хүсэлт - үйл ажиллагааны мэдээлэл';
$string['search_course'] = 'Хичээл хайх';
$string['searchcourses'] = 'Хичээл хайх';
$string['searchcourses_help'] = 'Энэ санал хүсэлттэй холбохыг хүсэж буй хичээл(үү)-ийн код эсвэл нэрийг хайна уу.';
$string['selected_dump'] = '$SESSION хувьсагчийн сонгосон индексүүдийг доор буулгав:';
$string['send'] = 'Илгээх';
$string['send_message'] = 'Мэдэгдэл илгээх';
$string['show_all'] = 'Бүгдийг харуулах';
$string['show_analysepage_after_submit'] = 'Шинжлэх хуудсыг харуулах';
$string['show_entries'] = 'Хариултуудыг харуулах';
$string['show_entry'] = 'Хариулт харуулах';
$string['show_nonrespondents'] = 'Хариулаагүй хүмүүсийг харуулах';
$string['site_after_submit'] = 'Илгээсний дараах хуудас';
$string['sort_by_course'] = 'Хичээлээр эрэмбэлэх';
$string['started'] = 'Эхэлсэн';
$string['startedon'] = '{$a}-д эхэлсэн';
$string['subject'] = 'Гарчиг';
$string['switch_item_to_not_required'] = 'Шаардлагагүй гэж тохируулах';
$string['switch_item_to_required'] = 'Шаардлагатай гэж тохируулах';
$string['template'] = 'Загвар';
$string['template_deleted'] = 'Загварыг устгасан';
$string['template_saved'] = 'Загварыг хадгалсан';
$string['templates'] = 'Загварууд';
$string['textarea'] = 'Урт бичвэрээр хариулах';
$string['textarea_height'] = 'Мөрийн тоо';
$string['textarea_width'] = 'Өргөн';
$string['textfield'] = 'Богино бичвэрээр хариулах';
$string['textfield_maxlength'] = 'Зөвшөөрөгдөх тэмдэгтийн хамгийн их тоо';
$string['textfield_size'] = 'Бичвэр талбарын өргөн';
$string['there_are_no_settings_for_recaptcha'] = 'Хүн ба тооцоолуурыг ялгах бүрэн автомат нээлттэй Түүрингийн шалгалтанд зориулсан тохиргоо байхгүй байна';
$string['this_feedback_is_already_submitted'] = 'Та энэ үйл ажиллагааг аль хэдийн дуусгасан байна.';
$string['typemissing'] = 'Дутуу утгын "төрөл"';
$string['update_item'] = 'Асуултад оруулсан өөрчлөлтүүдийг хадгалах';
$string['url_for_continue'] = 'Дараагийн үйл ажиллагаа руу холбох';
$string['url_for_continue_help'] = 'Санал хүсэлтийг илгээсний дараа, хичээлийн хуудас руу холбох үргэлжлүүлэх гэсэн товчийг харуулна. Санал хүсэлтийг илгээсний дараа хичээлийн хуудас руу холбох үргэлжлүүлэх гэсэн товчийг харуулна. Эсвэл дараагийн үйл ажиллагааны URL хаягийг энд оруулбал тухайн үйл ажиллагаатай холбогдох болно.';
$string['use_one_line_for_each_value'] = 'Хариулт бүрийг нэг мөрөнд бичнэ!';
$string['use_this_template'] = 'Энэ загварыг ашиглах';
$string['using_templates'] = 'Загвар ашиглах';
$string['vertical'] = 'Босоо';
$string['whatfor'] = 'Та юу хийхийг хүсч байна вэ?';
