<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'mn', version '5.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Хандалтын удирдлага';
$string['actionaftercorrectanswer'] = 'Зөв хариултын дараа хийх үйлдэл';
$string['actionaftercorrectanswer_help'] = 'Асуултад зөв хариулсны дараах хуудасны 3 сонголт байна.

* Хэвийн - Хичээлийн замыг дагах
* Хараагүй хуудсыг харуулах - Хуудаснуудыг 2 удаа харуулахгүй байхаар санамсаргүй дарааллаар харуулах
* Хариулаагүй хуудсыг харуулах - Хариулаагүй асуулт бүхий хуудаснуудыг санамсаргүй дарааллаар харуулах';
$string['actions'] = 'Үйлдлүүд';
$string['activitylink'] = 'Дараагийн үйл ажиллагааа руу холбох';
$string['activitylink_help'] = 'Хичээл дуусахад тухайн хичээлийн өөр үйл ажиллагаатай холбохын тулд нээгдэх цэсээс үйл ажиллагааг сонгоно уу.';
$string['activitylinkname'] = '{$a} үйл ажиллагаа руу очих';
$string['activityoverview'] = 'Танд товлосон хичээлүүд байна';
$string['addabranchtable'] = 'Агуулгын хуудас нэмэх';
$string['addanendofbranch'] = 'Салбарын төгсгөл нэмэх';
$string['addanewpage'] = 'Шинэ хуудас нэмэх';
$string['addaquestionpage'] = 'Асуултын хуудас нэмэх';
$string['addaquestionpagehere'] = 'Энд асуултын хуудас нэмэх';
$string['addbranchtable'] = 'Агуулгын хуудас нэмэх';
$string['addcluster'] = 'Бүлэг нэмэх';
$string['addedabranchtable'] = 'Агуулгын хуудас нэмсэн';
$string['addedanendofbranch'] = 'Салбарын төгсгөл нэмсэн';
$string['addedaquestionpage'] = 'Асуултын хуудас нэмсэн';
$string['addedcluster'] = 'Бүлэг нэмсэн';
$string['addedendofcluster'] = 'Бүлгийн төгсгөл нэмсэн';
$string['addendofbranch'] = 'Салбарын төгсгөл нэмэх';
$string['addendofcluster'] = 'Бүлгийн төгсгөлд нэмэх';
$string['addessay'] = 'Эсээ асуултын хуудас үүсгэх';
$string['addmatching'] = 'Тохируулах асуултын хуудас үүсгэх';
$string['addmultichoice'] = 'Олон сонголттой асуултын хуудас үүсгэх';
$string['addnewgroupoverride'] = 'Бүлгийн дахин тодорхойлолт нэмэх';
$string['addnewuseroverride'] = 'Хэрэглэгчийн дахин тодорхойлолт нэмэх';
$string['addnumerical'] = 'Тоон асуултын хуудас үүсгэх';
$string['addpage'] = 'Хуудас нэмэх';
$string['addshortanswer'] = 'Богино хариулттай асуултын хуудас үүсгэх';
$string['addtruefalse'] = 'Үнэх/худал гэсэн хариулттай асуултын хуудас үүсгэх';
$string['allotheranswers'] = 'Бусад бүх хариулт';
$string['allotheranswersjump'] = 'Бусад бүх хариултын үсрэлт';
$string['allotheranswersscore'] = 'Бусад бүх хариултын оноо';
$string['allowofflineattempts'] = 'Хичээлийг мобайл программ ашиглан оффлайнаар хийхийг зөвшөөрөх';
$string['allowofflineattempts_help'] = 'Идэвхжүүлсэн тохиолдолд мобайл программын хэрэглэгч хичээлийг татан авч, оффлайнаар хийх боломжтой.
Бүх боломжит хариултууд болон зөв хариултыг мөн адил татах болно.
Жич: Хичээл нь цагийн хязгаартай бол оффлайнаар хийх боломжгүй.';
$string['anchortitle'] = 'Үндсэн агуулгын эхлэл';
$string['and'] = 'БА';
$string['answer'] = 'Хариулт';
$string['answeredcorrectly'] = 'зөв хариулсан.';
$string['answersfornumerical'] = 'Тоон асуултын хариултууд нь хамгийн бага ба хамгийн их утгын хостой тохирох ёстой';
$string['arrangebuttonshorizontally'] = 'Агуулгын товчнуудыг хэвтээ байдлаар байрлуулах уу?';
$string['attempt'] = 'Оролдлого: {$a}';
$string['attemptheader'] = 'Оролдлого';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Оролдлогууд';
$string['attemptsdeleted'] = 'Устгасан оролдлогууд';
$string['attemptsremaining'] = 'Танд {$a} оролдлого үлдсэн байна';
$string['available'] = 'Эхлэх хугацаа:';
$string['averagescore'] = 'Дундаж оноо';
$string['averagetime'] = 'Дундаж цаг';
$string['branch'] = 'Агуулга';
$string['branchtable'] = 'Агуулга';
$string['cachedef_overrides'] = 'Хэрэглэгч болон бүлгийн дахин тодорхойлолтын мэдээлэл';
$string['cancel'] = 'Цуцлах';
$string['cannotfindanswer'] = 'Алдаа: хариулт олдсонгүй';
$string['cannotfindattempt'] = 'Алдаа: оролдлого олдсонгүй';
$string['cannotfindessay'] = 'Алдаа: эсээ олдсонгүй';
$string['cannotfindfirstgrade'] = 'Алдаа: дүн олдсонгүй';
$string['cannotfindfirstpage'] = 'Эхний хуудас олдсонгүй';
$string['cannotfindgrade'] = 'Алдаа: дүн олдсонгүй';
$string['cannotfindnewestgrade'] = 'Алдаа: Шинэ дүн олдсонгүй';
$string['cannotfindnextpage'] = 'Хичээлийн нөөц: Дараагийн хуудас олдсонгүй!';
$string['cannotfindpagerecord'] = 'Салбарын төгсгөл нэмэх: хуудасны бичлэг олдсонгүй';
$string['cannotfindpages'] = 'Хичээлийн хуудас олдсонгүй';
$string['cannotfindpagetitle'] = 'Устгахыг баталгаажуулах: хуудасны гарчиг олдсонгүй';
$string['cannotfindpreattempt'] = 'Өмнөх оролдлогын бичлэг олдсонгүй!';
$string['cannotfindrecords'] = 'Алдаа: хичээлийн бичлэг олдсонгүй';
$string['cannotfindtimer'] = 'Алдаа: lesson_timer бичлэг олдсонгүй';
$string['cannotfinduser'] = 'Алдаа: хэрэглэгчид олдсонгүй';
$string['canretake'] = 'Та дахин {$a} удаа өгч болно';
$string['casesensitive'] = 'Тогтмол хэллэг ашиглах';
$string['casesensitive_help'] = 'Хариултыг шинжлэхдээ тогтмол хэллэг ашиглах бол чагтан нүдийг чагтална уу.';
$string['checkbranchtable'] = 'Агуулгын хуудсыг шалгах';
$string['checkedthisone'] = 'Үүнийг шалгасан.';
$string['checknavigation'] = 'Удирдлагын мөрийг шалгах';
$string['checkquestion'] = 'Асуултыг шалгах';
$string['classstats'] = 'Ангийн статистик';
$string['clicktodownload'] = 'Дараах холбоос дээр дарж файлыг татаж авна уу.';
$string['closebeforeopen'] = 'Хичээлийг шинэчилж чадсангүй. Та хаах огноог нээх огнооноос өмнө зааж өгсөн байна.';
$string['cluster'] = 'Бүлэг';
$string['clusterjump'] = 'Бүлэг дэх хараагүй асуултууд';
$string['clustertitle'] = 'Бүлэг';
$string['collapsed'] = 'Хураангуй';
$string['comments'] = 'Таны тайлбар';
$string['completed'] = 'Дуусгасан';
$string['completederror'] = 'Хичээл дуусгах';
$string['completethefollowingconditions'] = 'Та үргэлжлүүлэхийн өмнө <b>{$a}</b> хичээл дээр дараах нөхцөлүүдийг биелүүлэх ёстой.';
$string['completiondetail:reachend'] = 'Үйл ажиллагааг төгсгөл хүртэл явуулах';
$string['completiondetail:timespent'] = 'Энэ үйл ажиллагаанд хамгийн багадаа {$a} зарцуулах';
$string['completionendreached'] = 'Шаардлагатай төгсгөлд хүрсэн';
$string['completionendreached_desc'] = 'Суралцагч энэ үйл ажиллагааг дуусгахын тулд хичээлийн төгсгөлд хүрэх ёстой';
$string['completiontimespentdesc'] = 'Суралцагч энэ үйл ажиллагааг хамгийн багадаа {$a} хийх ёстой';
$string['completiontimespentgroup'] = 'Хугацаа зарцуулахыг шаардах';
$string['conditionsfordependency'] = 'Хамааралтай байх нөхцөл(үүд)';
$string['configintro'] = 'Энд тохируулсан утгууд нь шинэ хичээлийн үйл ажиллагаа үүсгэх үед тохиргооны маягтад хэрэглэх өгөгдмөл утгуудыг тодорхойлдог. "Илүүг харуулах..." холбоос дээр дарахад нарийвчилсан тохиргоо харагдана.';
$string['configmaxanswers'] = 'Нэг хуудсанд харуулах хариултын өгөгдмөл хамгийн их тоо';
$string['configmediaclose'] = 'Холбогдсон медиа файлд зориулан үүсгэсэн нэмэлт цонхны нэг хэсэг болгон хаах товчийг харуулна';
$string['configmediaheight'] = 'Холбосон медиа файлд зориулсан нэмэлт цонхны өндрийг тохируулах';
$string['configmediawidth'] = 'Холбосон медиа файлд зориулсан нэмэлт цонхны өргөнийг тохируулах';
$string['configpassword_desc'] = 'Хичээлд хандахад нууц үг шаардах эсэх.';
$string['configslideshowbgcolor'] = 'Идэвхжүүлсэн бол слайдыг тоглуулах дэвсгэр өнгө';
$string['configslideshowheight'] = 'Идэвхжүүлсэн бол слайдыг тоглуулах өндрийг тохируулах';
$string['configslideshowwidth'] = 'Идэвхжүүлсэн бол слайдыг тоглуулах өргөнийг тохируулах';
$string['configtimelimit_desc'] = 'Хэрэв цагийн хязгаар тогтоосон бол хичээлийн эхэнд анхааруулга гарч ирэх ба цаг тоологч байна. Хэрэв хугацааг хязгаарлахгүй бол тэг гэж онооно.';
$string['confirmdelete'] = 'Хуудсыг устгах';
$string['confirmdeletionofthispage'] = 'Энэ хуудсыг устгах уу';
$string['congratulations'] = 'Баяр хүргэе! Та хичээлийг хийж дуусгалаа.';
$string['continue'] = 'Үргэлжлүүлэх';
$string['continuetoanswer'] = 'Хариултуудыг өөрчлөхийг үргэлжлүүлэх.';
$string['continuetonextpage'] = 'Дараагийн хуудас уруу очих.';
$string['correctanswerjump'] = 'Зөв хариултын үсрэлт';
$string['correctanswerscore'] = 'Зөв хариултын оноо';
$string['correctresponse'] = 'Зөв хариу';
$string['createaquestionpage'] = 'Асуултын хуудас үүсгэх';
$string['credit'] = 'Кредит';
$string['customscoring'] = 'Өөрсдөө оноо өгөх';
$string['customscoring_help'] = 'Хэрэв идэвхжүүлсэн бол хариулт бүрд тоон оноог (эерэг эсвэл сөрөг) өгч болно.';
$string['deadline'] = 'Дуусах хугацаа';
$string['defaultessayresponse'] = 'Таны эсээг хичээлийн багш дүгнэнэ.';
$string['deleteallattempts'] = 'Бүх хичээлийн оролдлогыг устгах';
$string['deletedefaults'] = 'Устгагдсан {$a} x хичээлийн өгөгдмөл утга';
$string['deletedpage'] = 'Устгасан хуудас';
$string['deletepagenamed'] = 'Хуудас устгах: {$a}';
$string['deleting'] = 'Устгаж байна';
$string['deletingpage'] = '{$a} хуудсыг устгаж байна';
$string['dependencyon'] = 'Хамаарна:';
$string['dependencyon_help'] = 'Энэ тохиргоо нь тухайн оюутны нэг багц дахь өөр хичээлийн гүйцэтгэлээс хамаарч энэ хичээлд хандах боломжийг олгодог. Цаг зарцуулсан, дуусгасан эсвэл "илүү сайн дүн" гэсэн дурын хослолыг хэрэглэж болно.';
$string['description'] = 'Тайлбар';
$string['deselectallattempts'] = 'Бүх оролдлогын сонголтыг цуцлах';
$string['detailedstats'] = 'Дэлгэрэнгүй статистик';
$string['didnotanswerquestion'] = 'Энэ асуултад хариулаагүй байна.';
$string['didnotreceivecredit'] = 'Кредит авахгүй';
$string['disabled'] = 'Идэвхгүй болгосон';
$string['displaydefaultfeedback'] = 'Өгөгдмөл санал хүсэлтийг ашиглах';
$string['displaydefaultfeedback_help'] = 'Идэвхжүүлсэн тохиолдолд тодорхой асуултын хариулт олдохгүй бол "Энэ бол зөв хариулт" эсвэл "Энэ буруу хариулт" гэсэн өгөгдмөл хариулт гарч ирнэ.';
$string['displayinleftmenu'] = 'Цэсэд харуулах уу?';
$string['displayleftif'] = 'Хамгийн бага оноог цэсэд харуулах';
$string['displayleftif_help'] = 'Энэ тохиргоо нь суралцагч хичээлийн цэсийг үзэхийн өмнө тодорхой үнэлгээ авах ёстой эсэхийг тодорхойлдог. Энэ нь сурагчийг эхний оролдлогоороо хичээлийг бүхэлд нь үзэхийг шаарддаг бөгөөд дараа нь шаардлагатай дүнг авсны дараа хянахын тулд тэд цэсийг ашиглах боломжтой.';
$string['displayleftmenu'] = 'Цэсийг харуулах';
$string['displayleftmenu_help'] = 'Идэвхжүүлбэл хэрэглэгчдэд хуудасны жагсаалтаар шилжих боломжтой цэс гарч ирнэ.';
$string['displayofgrade'] = 'Дүнг харуулах (зөвхөн суралцагчид)';
$string['displayreview'] = 'Асуултыг дахин оролдох сонголт оруулах';
$string['displayreview_help'] = 'Идэвхжүүлбэл асуултад буруу хариулсан тохиолдолд суралцагч оноо авахгүйгээр дахин оролдох эсвэл хичээлээ үргэлжлүүлэх сонголтыг өгнө. Хэрэв суралцагч өөр асуулт руу шилжихээр дарвал сонгосон (буруу) хариултын үсрэлтийг дагах болно. Өгөгдмөл байдлаар буруу хариултын үсрэлтийг "энэ хуудас" гэж тохируулсан бөгөөд оноо нь 0 байна, тиймээс та суралцагчийг төөрөгдүүлэхгүйн тулд буруу хариултыг өөр хуудас руу үсэргэхийг зөвлөж байна.';
$string['displayscorewithessays'] = '<p>Та автоматаар дүгнэгдэх асуултуудад авах ёстой {$a->tempmaxgrade} онооноос {$a->score} оноо авлаа.</p><p>Таны {$a->essayquestions} эсээний асуулт(ууд)-ыг дүгнэсний дараа таны эцсийн дүн нэмэгдэх болно.</p> <p>Эсээний оноог тооцохгүйгээр таны одоогийн оноо {$a->grade} авах ёстойгоос {$a->score} байна.</p>';
$string['displayscorewithoutessays'] = 'Таны оноо {$a->score} байна ({$a->grade} оноо авах ёстой).';
$string['duplicatepagenamed'] = 'Хуудсыг хувилах: {$a}';
$string['edit'] = 'Засварлах';
$string['editbranchtable'] = 'Агуулгын хуудсыг засварлаж байна';
$string['editcluster'] = 'Бүлгийг засварлаж байна';
$string['editendofbranch'] = 'Салбарын хуудасны төгсгөлийг засаж байна';
$string['editendofcluster'] = 'Бүлгийн хуудасны төгсгөлийг засаж байна';
$string['editessay'] = 'Эсээ асуултын хуудсыг засварлаж байна';
$string['editinglesson'] = 'Хичээлийг засварлаж байна';
$string['editingquestionpage'] = '{$a} асуултын хуудсыг засварлаж байна';
$string['editlesson'] = 'Хичээлийг засварлах';
$string['editlessonsettings'] = 'Хичээлийн тохиргоог засварлах';
$string['editmatching'] = 'Тохируулах асуултын хуудсыг засварлаж байна';
$string['editmultichoice'] = 'Олон сонголттой асуултын хуудсыг засварлаж байна';
$string['editnumerical'] = 'Тоон асуулын хуудсыг засварлаж байна';
$string['editoverride'] = 'Дахин тодорхойлолтыг засварлах';
$string['editpage'] = 'Агуулгын хуудсыг засварлах';
$string['editpagecontent'] = 'Хуудасны агуулгыг засварлах';
$string['editquestion'] = 'Асуултын хуудсыг засварлаж байна';
$string['editshortanswer'] = 'Богино хариулттай асуултын хуудсыг засварлаж байна';
$string['edittruefalse'] = 'Үнэн/худал гэсэн хариулттай асуултын хуудсыг засварлаж байна';
$string['email'] = 'Цахим шуудан';
$string['emailallgradedessays'] = 'Эсээг дүгнэсэн мэдэгдлийг илгээх';
$string['emailgradedessays'] = 'Эсээг дүгнэсэн мэдэгдлийг илгээх';
$string['emailsuccess'] = 'Мэдэгдэл амжилттай илгээгдлээ';
$string['emptypassword'] = 'Нууц үг хоосон байж болохгүй';
$string['enabled'] = 'Идэвхтэй';
$string['endofbranch'] = 'Салбарын төгсгөл';
$string['endofcluster'] = 'Бүлгийн төгсгөл';
$string['endofclustertitle'] = 'Бүлгийн төгсгөл';
$string['endoflesson'] = 'Хичээлийн төгсгөл';
$string['enteredthis'] = 'үүнийг оруулсан.';
$string['enterpassword'] = 'Нууц үгээ оруулна уу:';
$string['eolstudentoutoftime'] = 'Анхаар: Энэ хичээлийн цаг дууслаа. Хугацаа дууссаны дараа хариулсан бол таны сүүлчийн хариултыг тооцохгүй байж магадгүй.';
$string['eolstudentoutoftimenoanswers'] = 'Та асуултад хариулаагүй байна. Та энэ хичээлд 0 авлаа.';
$string['essay'] = 'Эсээ';
$string['essayemailmessage2'] = '<p>Эсээний сануулга: {$a->question}</p><p>Таны хариу: <em>{$a->response}</em></p><p>Дүгнэгчийн тайлбар: <em>{$a->comment}</em></p><p>Таны эсээ нийт {$a->outof} онооноос {$a->earned} авсан.</p><p>Таны {$a->lesson} хичээлийн дүн {$a->newgrade}% болж өөрчлөгдлөө.</p>';
$string['essayemailmessagesmall'] = '<p>Таны эсээ нийт {$a->outof} онооноос {$a->earned} авсан.</p><p>Таны {$a->lesson} хичээлийн дүн {$a->newgrade}% болж өөрчлөгдлөө.</p>';
$string['essayemailsubject'] = 'Хичээлийн асуултад үнэлгээ өгөх боломжтой';
$string['essaynotgradedyet'] = 'Энэ эсээ хараахан дүгнэгдээгүй байна';
$string['essayresponses'] = 'Эсээний хариултууд';
$string['essays'] = 'Эсээнүүд';
$string['essayscore'] = 'Эсээний оноо';
$string['eventcontentpageviewed'] = 'Агуулгын хуудсыг харсан';
$string['eventessayassessed'] = 'Эсээг үнэлсэн';
$string['eventessayattemptviewed'] = 'Эсээний оролдлогыг харсан';
$string['eventhighscoreadded'] = 'Хичээлийн өндөр оноог нэмсэн';
$string['eventhighscoresviewed'] = 'Хичээлийн өндөр оноог харсан';
$string['eventlessonended'] = 'Хичээл дууссан';
$string['eventlessonrestarted'] = 'Хичээлийг дахин эхлүүлсэн';
$string['eventlessonresumed'] = 'Хичээл үргэлжилсэн';
$string['eventlessonstarted'] = 'Хичээл эхэлсэн';
$string['eventoverridecreated'] = 'Хичээлийн дахин тодорхойлолтыг үүсгэсэн';
$string['eventoverridedeleted'] = 'Хичээлийн дахин тодорхойлолт устсан';
$string['eventoverrideupdated'] = 'Хичээлийн дахин тодорхойлолтыг шинэчилсэн';
$string['eventpagecreated'] = 'Хуудсыг үүсгэсэн';
$string['eventpagedeleted'] = 'Хуудсыг устгасан';
$string['eventpagemoved'] = 'Хуудсыг зөөсөн';
$string['eventpageupdated'] = 'Хуудсыг шинэчилсэн';
$string['eventquestionanswered'] = 'Хариулсан асуулт';
$string['eventquestionviewed'] = 'Үзсэн асуултууд';
$string['false'] = 'Худал';
$string['fileformat'] = 'Файлын формат';
$string['finalwrong'] = 'Бүрэн бус.';
$string['finish'] = 'Дуусгах';
$string['firstanswershould'] = 'Эхний хариулт нь "Зөв" хуудас руу шилжих ёстой';
$string['firstwrong'] = 'Та буруу хариулсан байна. Та дахин оролдмоор байна уу? (Та одоо асуултад зөв хариулсан ч таны эцсийн оноонд тооцохгүй.)';
$string['flowcontrol'] = 'Явцын хяналт';
$string['fractionsaddwrong'] = 'Таны сонгосон эерэг дүн 100% хүрээгүй байна<br />Харин {$a}% хүрсэн<br />Та буцаж очоод энэ асуултыг засмаар байна уу?';
$string['fractionsnomax'] = 'Хариултуудын аль нэг нь 100% байх ёстой бөгөөд ингэснээр<br />энэ асуултад бүрэн үнэлгээ авах боломжтой.<br />Та буцаж очоод энэ асуултыг засмаар байна уу?';
$string['full'] = 'Дэлгэрэнгүй';
$string['general'] = 'Ерөнхий';
$string['gotoendoflesson'] = 'Хичээлийн төгсгөлд очих';
$string['gradebetterthan'] = 'Дүн нь дараахаас илүү (%)';
$string['gradebetterthanerror'] = '{$a} хувиас илүү дүн авах';
$string['graded'] = 'Дүгнэсэн';
$string['gradeessay'] = 'Эсээний асуултын дүн ({$a->notgradedcount} дүгнээгүй {$a->notsentcount} илгээгээгүй)';
$string['gradeis'] = 'Дүн нь {$a}';
$string['gradeoptions'] = 'Дүнгийн тохиргоо';
$string['groupoverrides'] = 'Бүлгийн дахин тодорхойлолт';
$string['groupoverridesdeleted'] = 'Бүлгийн дахин тодорхойлолтыг устгасан';
$string['groupsnone'] = 'Танд хандах боломжтой бүлэг байхгүй байна.';
$string['handlingofretakes'] = 'Дахин шалгалт өгөгчдийг удирдах';
$string['handlingofretakes_help'] = 'Дахин оролдохыг зөвшөөрвөл энэ тохиргоо нь хичээлийн дүнг бүх оролдлогын дундаж эсвэл хамгийн ихээр тодорхойлох эсэхийг тодорхойлдог.';
$string['havenotgradedyet'] = 'Хараахан дүгнээгүй байна.';
$string['here'] = 'энд';
$string['highscore'] = 'Дээд оноо';
$string['hightime'] = 'Дээд цаг';
$string['importcount'] = '{$a} асуултуудыг импортолж байна';
$string['importquestions'] = 'Асуулт импортлох';
$string['importquestions_help'] = 'Энэ функц нь янз бүрийн форматтай асуултуудыг бичвэр файлаар импортлох боломжийг олгодог.';
$string['inactiveoverridehelp'] = '* Хэрэглэгчийн үйл ажиллагаанд хандах эрхийг хязгаарласан тул энэ дахин тодорхойлолт идэвхгүй байна. Энэ нь бүлэг эсвэл үүргийн хуваарилалт, бусад хандалтын хязгаарлалт эсвэл нуусан үйл ажиллагаатай холбоотой байж болно.';
$string['indicator:cognitivedepth'] = 'Хичээлийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн Хичээлийн үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд суурилдаг.';
$string['indicator:cognitivedepthdef'] = 'Хичээлийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэ дүн шинжилгээний интервалын хугацаанд Хичээлийн үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Харагдахгүй, Харах, Илгээх, Хариу харах, Хариунд сэтгэгдэл бичих, Хариуг харсны дараа дахин илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Хичээлийн нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь Хичээлийн үйл ажиллагаанд суралцагчийн хүрсэн нийгмийн хүрээнд суурилдаг.';
$string['indicator:socialbreadthdef'] = 'Хичээлийн нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэхүү дүн шинжилгээний интервалын хугацаанд Хичээлийн үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Оролцоогүй, Ганцаар оролцсон, Бусадтай хамт оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Оруулсан хуудас';
$string['invalidfile'] = 'Хүчингүй файл';
$string['invalidid'] = 'Хичээлийн модулийн ID эсвэл хичээлийн ID-г дамжуулаагүй';
$string['invalidlessonid'] = 'Хичээлийн ID буруу байна';
$string['invalidoverrideid'] = 'Хүчингүй дахин тодорхойлсон id';
$string['invalidpageid'] = 'Хүчингүй хуудасны дугаар';
$string['jump'] = 'Үсрэлт';
$string['jumps'] = 'Үсрэлт';
$string['jumps_help'] = 'Хариулт бүр (асуултын хувьд) эсвэл тайлбар (агуулгын хуудасны хувьд) харгалзах үсрэлттэй байна. Үсрэлтийг нь энэ хуудас эсвэл дараагийн хуудас гэх мэт харьцангуйгаар эсвэл хичээлийн аль нэг хуудсыг заасан үнэмлэхүйгээр зааж өгч болно.';
$string['jumpsto'] = '<em>{$a}</em> рүү үсрэх';
$string['leftduringtimed'] = 'Та хуваарьт хичээлийн үеэр орхиж гарсан байна.<br /> Үргэлжлүүлэх товчлуур дарж хичээлийг дахин эхлүүлнэ үү.';
$string['leftduringtimednoretake'] = 'Та хуваарьт хичээлийн үеэр орхиж гарлаа<br /> таныг дахин оролдох эсвэл үргэлжлүүлэхийг зөвшөөрөөгүй байна.';
$string['leftduringtimedsession'] = 'Та хуваарьт хичээлийн үеэр орхиж гарсан байна.';
$string['lesson:addinstance'] = 'Шинэ хичээл нэмэх';
$string['lesson:edit'] = 'Хичээлийн үйл ажиллагааг засварлах';
$string['lesson:grade'] = 'Хичээлийн эсээ асуултын дүн';
$string['lesson:manage'] = 'Хичээлийн үйл ажиллагааг удирдах';
$string['lesson:manageoverrides'] = 'Хичээлийн дахин тодорхойлолтыг удирдах';
$string['lesson:view'] = 'Хичээлийн үйл ажиллагааг харах';
$string['lesson:viewreports'] = 'Хичээлийн тайланг харах';
$string['lessonbeingpreviewed'] = 'Хичээлийг яг одоо урьдчилан харж байна.';
$string['lessonclosed'] = 'Энэ хичээл {$a} хаагдана.';
$string['lessoncloses'] = 'Хичээл хаах';
$string['lessoneventcloses'] = '{$a} хаах';
$string['lessoneventopens'] = '{$a} нээх';
$string['lessonformating'] = 'Хичээлийг хэлбэржүүлэх';
$string['lessonmenu'] = 'Хичээл цэс';
$string['lessonnotready'] = 'Энэ хичээл авахад бэлэн болоогүй байна. Таны {$a} руу хандана уу.';
$string['lessonnotready2'] = 'Энэ хичээл авахад бэлэн болоогүй байна.';
$string['lessonopen'] = '{$a}-д хичээл нээгдэнэ.';
$string['lessonopens'] = 'Хичээл нээгдэх';
$string['lessonpagelinkingbroken'] = 'Эхний хуудас олдсонгүй. Хичээлийн хуудсын холбоос эвдэрсэн бололтой. Админд хандана уу.';
$string['lessonstats'] = 'Хичээлийн статистик';
$string['linkedmedia'] = 'Холбогдсон медиа';
$string['loginfail'] = 'Нэвтэрч чадсангүй, дахин оролдоно уу...';
$string['lowscore'] = 'Доод оноо';
$string['lowtime'] = 'Бага цаг';
$string['manualgrading'] = 'Эсээг дүгнэх';
$string['matchesanswer'] = 'Хариулттай тохирч байна';
$string['matching'] = 'Тохируулах';
$string['matchingpair'] = 'Тохируулах хос {$a}';
$string['maxgrade'] = 'Хамгийн их дүн';
$string['maxgrade_help'] = 'Энэ тохиргоо нь хичээлийн хамгийн их дүнг зааж өгдөг. Хэрэв 0 гэж тохируулсан бол хичээл дүнгийн хуудсанд харагдахгүй.';
$string['maximumnumberofanswersbranches'] = 'Хариултын хамгийн их тоо';
$string['maximumnumberofanswersbranches_help'] = 'Энэ тохиргоо нь хичээлд ашиглаж болох хариултын дээд хэмжээг зааж өгдөг. Зөвхөн үнэн/худал асуултуудыг ашиглавал 2 болгож тохируулж болно. Энэ нь өгөгдөлд бус зөвхөн багшийн харж буй зүйлд нөлөөлдөг тул тохиргоог хүссэн үедээ өөрчилж болно.';
$string['maximumnumberofattempts'] = 'Нэг асуултад хариулах оролдлогын хамгийн их тоо';
$string['maximumnumberofattempts_help'] = 'Энэхүү тохиргоо нь асуулт бүрт хамгийн ихдээ хэдэн удаа хариулт өгөх оролдлого хийх боломжийг заана. Хэрэв тохироонд заасан тоон удаа дахин дахин буруу хариулбал хичээлийн дараагийн хуудсыг харуулна.';
$string['maximumnumberofattemptsreached'] = 'Хамгийн их оролдлого хийсэн тоо - Дараагийн хуудас руу шилжих';
$string['mediaclose'] = 'Хаах товчийг харуулах';
$string['mediafile'] = 'Холбогдсон медиа';
$string['mediafile_help'] = 'Хичээлд ашиглахын тулд медиа файлыг байршуулж болно. Хичээлийн хуудас бүр дээр \'Холбогдсон медиа\' нэртэй блок дээр \'Энд дарж үзэх\' холбоос гарч ирнэ.';
$string['mediafilepopup'] = 'Энд дарж үзэх';
$string['mediaheight'] = 'Нэмэлт цонхны өндөр';
$string['mediawidth'] = 'Нэмэлт цонхны өргөн';
$string['messageprovider:graded_essay'] = 'Хичээлийн эсээг дүгнэсэн мэдэгдэл';
$string['minimumnumberofquestions'] = 'Асуултын хамгийн бага тоо';
$string['minimumnumberofquestions_help'] = 'Энэ тохиргоо нь үйл ажиллагааны үнэлгээг тооцоолоход хэрэглэгдэх асуултуудын хамгийн бага тоог тодорхойлдог.';
$string['missingname'] = 'Хэрэглэгчийн нэрээ оруулна уу';
$string['modattempts'] = 'Суралцагчид хянахыг зөвшөөрөх';
$string['modattempts_help'] = 'Идэвхжүүлсэн бол суралцагч хичээлийг эхнээс нь дахин үзэх боломжтой.';
$string['modattemptsnoteacher'] = 'Суралцагчийн хяналт нь зөвхөн суралцагчид зориулагдсан.';
$string['modulename'] = 'Хичээл';
$string['modulename_help'] = 'Хичээлийн үйл ажиллагааны модуль нь багшид агуулга болон/эсвэл дадлага хийх үйл ажиллагааг сонирхолтой, уян хатан байдлаар хүргэх боломжийг олгодог. Багш хичээлийг ашиглан суралцагчдад янз бүрийн арга зам, сонголтуудыг санал болгодог шугаман агуулгын хуудас эсвэл сургалтын үйл ажиллагааг бий болгох боломжтой. Аль ч тохиолдолд багш нар олон сонголттой, тохируулах, богино хариулттай гэх мэт төрөл бүрийн асуултуудыг оруулах замаар оролцоог нэмэгдүүлж, ойлголтыг баталгаажуулж болно. Суралцагчийн хариултын сонголт болон багш хичээлээ хэрхэн хөгжүүлж байгаагаас хамааран суралцагч дараагийн хуудас руу шилжих, өмнөх хуудас руу буцах эсвэл бүхэлд нь өөр замаар чиглүүлэх боломжтой.

Хичээлийг дүгнэж,  журналд тэмдэглэж болно.

Хичээлийг дараахад ашиглаж болно

* Шинэ сэдвийг бие даан сурахад зориулж
* Зохиол бичих эсвэл загварчлал/шийдвэр гаргах дасгалуудад зориулж
* Анхны асуултуудад өгсөн хариултаас хамааран өөр өөр хянан шалгах асуултуудын багцыг ялган засварлахад зориулж';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Хичээлүүд';
$string['move'] = 'Хуудсыг зөөх';
$string['movedpage'] = 'Хуудсыг зөөсөн';
$string['movepagehere'] = 'Хуудсыг энд авч ирэх';
$string['movepagenamed'] = 'Хуудсыг зөөх: {$a}';
$string['moving'] = 'Хуудсыг зөөж байна: {$a}';
$string['multianswer'] = 'Олон хариулттай';
$string['multianswer_help'] = 'Нэгээс олон зөв хариулттай бол чагтан нүдийг чагтална уу.';
$string['multichoice'] = 'Олон сонголттой';
$string['multipleanswer'] = 'Олон хариулттай';
$string['nameapproved'] = 'Нэрийг зөвшөөрсөн';
$string['namereject'] = 'Уучлаарай, таны нэрийг шүүлтүүр хүлээн авсангүй. <br /> Өөр нэрээр дахин оролдоно уу.';
$string['new'] = 'шинэ';
$string['nextpage'] = 'Дараагийн хуудас';
$string['noanswer'] = 'Нэг эсвэл хэд хэдэн асуултад хариулаагүй байна. Буцаад хариултаа илгээнэ үү.';
$string['noattemptrecordsfound'] = 'Оролдлого бүртгэл олдсонгүй: үнэлгээ өгөхгүй';
$string['nobranchtablefound'] = 'Агуулгын хуудас олдсонгүй';
$string['noclose'] = 'Дуусах огноо байхгүй';
$string['nocommentyet'] = 'Одоохондоо сэтгэгдэлгүй байна.';
$string['nocoursemods'] = 'Үйл ажиллагаа олдсонгүй';
$string['nocredit'] = 'Кредитгүй';
$string['nodeadline'] = 'Товлосон хугацаагүй';
$string['noessayquestionsfound'] = 'Энэ хичээлд эсээ асуулт байхгүй байна.';
$string['nohighscores'] = 'Өндөр оноо алга';
$string['nolessonattempts'] = 'Энэ хичээлд хийсэн оролдлого алга байна.';
$string['nolessonattemptsgroup'] = '{$a} бүлгийн гишүүд энэ хичээл дээр оролдлого хийгээгүй байна.';
$string['none'] = 'Хоосон';
$string['nooneansweredcorrectly'] = 'Зөв хариулсан хүн алга.';
$string['nooneansweredthisquestion'] = 'Энэ асуултад хариулсан хүн алга.';
$string['noonecheckedthis'] = 'Үүнийг хэн ч тэмдэглээгүй байна';
$string['nooneenteredthis'] = 'Үүнийг хэн ч оруулаагүй байна';
$string['noonehasanswered'] = 'Эсээ асуултад хариулсан хүн алга.';
$string['noonehasansweredgroup'] = 'Одоогоор {$a} дахь хэн ч эсээ асуултад хариулаагүй байна.';
$string['noopen'] = 'Нээх огноо байхгүй';
$string['nooverridecreated'] = 'Ямар ч дахин тодорхойлолт үүсээгүй байна.';
$string['nooverridedata'] = 'Та хичээлийн тохиргооноос дор хаяж нэгийг дахин тодорхойлох ёстой.';
$string['noretake'] = 'Танд энэ хичээлийг дахин хийхийг зөвшөөрөөгүй байна.';
$string['normal'] = 'Хэвийн - хичээлийн замыг дагна уу';
$string['notcompleted'] = 'Дуусаагүй';
$string['notcompletedwithdate'] = 'Дуусаагүй ({$a})';
$string['notdefined'] = 'Тодорхойлогдоогүй';
$string['notenoughsubquestions'] = 'Хангалттай дэд асуултууд тодорхойлогдоогүй байна!';
$string['notenoughtimespent'] = 'Та энэ хичээлийг {$a->timespend}-д дуусгасан бөгөөд энэ нь шаардлагатай {$a->timerequired} хугацаанаас бага байна. Та хичээлээ дахин оролдох хэрэгтэй байж магадгүй.';
$string['notgraded'] = 'Дүгнээгүй';
$string['notitle'] = 'Гарчиггүй';
$string['notyetcompleted'] = 'Хичээл эхэлсэн бөгөөд хараахан дуусаагүй байна';
$string['numberofcorrectanswers'] = 'Зөв хариултын тоо: {$a}';
$string['numberofcorrectanswersheader'] = 'Зөв хариултын тоо';
$string['numberofcorrectmatches'] = 'Зөв тохируулгын тоо: {$a}';
$string['numberofpagestoshow'] = 'Харуулах хуудасны тоо';
$string['numberofpagestoshow_help'] = 'Энэ тохиргоо нь хичээлд харуулах хуудасны тоог зааж өгдөг. Энэ нь зөвхөн санамсаргүй дарааллаар харуулсан хуудастай хичээлүүдэд хамаарна ("Зөв хариултын дараах үйлдэл"-ийг "Хараагүй хуудсыг харуулах" эсвэл "Хариулаагүй хуудсыг харуулах" гэж тохируулсан үед). Хэрэв тэг гэж тохируулсан бол бүх хуудсыг харуулна.';
$string['numberofpagesviewed'] = 'Хариулсан асуултын тоо: {$a}';
$string['numberofpagesviewedheader'] = 'Хариулсан асуултын тоо:';
$string['numberofpagesviewednotice'] = 'Хариулсан асуултын тоо: {$a->nquestions} (Та хамгийн багадаа {$a->minquestions} асуултад хариулсан байх ёстой)';
$string['numerical'] = 'Тоон';
$string['numericanswer'] = 'Тоон хариулт';
$string['numericanswer_help'] = 'Та нэг тоог эсвэл тодорхойлох цэгийг ашиглан тооны мужийг зааж өгч болно. Жишээ нь 2:5 гэдэг нь 2 ба 5-ыг оруулаад 2-оос 5-ын хоорондох дурын хариулт зөв гэсэн үг.';
$string['offlinedatamessage'] = 'Та мобайл төхөөрөмж ашиглан энэ оролдлого дээр ажилласан. Энэ сайтад өгөгдлийг хамгийн сүүлд {$a} өмнө хадгалсан. Танд хадгалагдаагүй ажил байхгүй эсэхийг шалгана уу.';
$string['ongoing'] = 'Явцын оноог үзүүлэх';
$string['ongoing_help'] = 'Идэвхжүүлсэн тохиолдолд хуудас бүр нь суралцагчийн нийт онооноос одоогийн байдлаар цуглуулсан оноог харуулах болно.';
$string['ongoingcustom'] = 'Та одоогоор {$a->currenthigh} онооноос {$a->score} оноо цуглуулсан байна.';
$string['ongoingnormal'] = 'Та {$a->viewed} асуултаас {$a->correct} зөв хариуллаа.';
$string['onpostperpage'] = 'Дүн бүрд нэг нийтлэл байна';
$string['openafterclose'] = 'Та нээх огноог хаах огнооноос сүүлд тодорхойлсон байна';
$string['options'] = 'Сонголтууд';
$string['or'] = 'ЭСВЭЛ';
$string['ordered'] = 'Дараалал';
$string['other'] = 'Бусад';
$string['outof'] = '{$a} - аас';
$string['override'] = 'Дахин тодорхойлолт';
$string['overridedeletegroupsure'] = 'Та {$a} бүлгийн дахин тодорхойлолтыг устгахдаа итгэлтэй байна уу?';
$string['overridedeleteusersure'] = 'Та {$a} хэрэглэгчийн дахин тодорхойлолтыг устгахдаа итгэлтэй байна уу?';
$string['overridegroup'] = 'Бүлгийг дахин тодорхойлох';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Дахин тодорхойлолт';
$string['overrideuser'] = 'Хэрэглэгчийн дахин тодорхойлох';
$string['overrideusereventname'] = '{$a->lesson} - Дахин тодорхойлолт';
$string['overview'] = 'Тойм';
$string['overview_help'] = 'Хичээл нь хэд хэдэн хуудас, сонголтоор агуулгын хуудаснаас бүрдэнэ. Хуудас нь зарим агуулгыг агуулсан бөгөөд ихэвчлэн асуултаар төгсдөг. Асуултын хариулт бүр нь үсрэлттэй холбоотой. Үсрэлт нь энэ хуудас эсвэл дараагийн хуудас гэх мэт харьцангуй эсвэл хичээлийн аль нэг хуудсыг зааж өгөх үнэмлэхүй байж болно. Агуулгын хуудас нь хичээлийн бусад хуудаснуудын холбоосыг агуулсан хуудас байна. Жишээ нь Агуулгын хүснэгт.';
$string['page'] = 'Хуудас: {$a}';
$string['page-mod-lesson-edit'] = 'Хичээлийн хуудсыг засварлах';
$string['page-mod-lesson-view'] = 'Хичээлийн хуудсыг харах эсвэл урьдчилан харах';
$string['page-mod-lesson-x'] = 'Хичээлийн дурын хуудас';
$string['pageanswers'] = 'Хуудасны хариултууд';
$string['pagecontents'] = 'Хуудасны агуулга';
$string['pageresponses'] = 'Хуудасны хариу';
$string['pages'] = 'Хуудас';
$string['pagetitle'] = 'Хуудасны гарчиг';
$string['password'] = 'Нууц үг';
$string['passwordprotectedlesson'] = '{$a} бол нууц үгээр хамгаалагдсан хичээл.';
$string['pleasecheckoneanswer'] = 'Нэг хариулт сонгоно уу';
$string['pleasecheckoneormoreanswers'] = 'Нэг буюу түүнээс дээш хариулт сонгоно уу';
$string['pleaseenteryouranswerinthebox'] = 'Та хариултаа оруулна уу';
$string['pleasematchtheabovepairs'] = 'Дээрх хосуудыг тохируулна уу';
$string['pluginadministration'] = 'Хичээлийн удирдлага';
$string['pluginname'] = 'Хичээл';
$string['pointsearned'] = 'Цуглуулсан оноо';
$string['postprocesserror'] = 'Дараах боловсруулалтын явцад алдаа гарлаа!';
$string['postsuccess'] = 'Нийтлэл амжилттай боллоо';
$string['practice'] = 'Дадлага хийх хичээл';
$string['practice_help'] = 'Дадлага хийх хичээл журналд харагдахгүй байна.';
$string['preprocesserror'] = 'Урьдчилсан боловсруулалтын явцад алдаа гарлаа!';
$string['prerequisiteisobsolete'] = 'Урьдчилсан нөхцөлт хичээлийн сонголтыг хасах гэж байна. Үүний оронд хандалтын хязгаарлалтыг ашиглана уу.';
$string['prerequisitelesson'] = 'Урьдчилсан нөхцөлт хичээл';
$string['preview'] = 'Урьдчилан харах';
$string['previewlesson'] = '{$a} урьдчилан харах';
$string['previewpagenamed'] = 'Урьдчилан харах: {$a}';
$string['previouspage'] = 'Өмнөх хуудас';
$string['privacy:metadata:attempts'] = 'Хуудасны оролдлогын бүртгэл';
$string['privacy:metadata:attempts:answerid'] = 'Хариултын ID';
$string['privacy:metadata:attempts:correct'] = 'Энэ оролдлого зөв байсан уу';
$string['privacy:metadata:attempts:pageid'] = 'Хуудасны ID';
$string['privacy:metadata:attempts:retry'] = 'Оролдлогын тоо';
$string['privacy:metadata:attempts:timeseen'] = 'Оролдлого хийсэн цаг';
$string['privacy:metadata:attempts:useranswer'] = 'Хэрэглэгчийн хариултын талаар дэлгэрэнгүй';
$string['privacy:metadata:attempts:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:metadata:branch'] = 'Үзсэн хуудсуудын бүртгэл';
$string['privacy:metadata:branch:flag'] = 'Дараагийн хуудсыг санамсаргүйгээр тооцоолсон эсэх';
$string['privacy:metadata:branch:nextpageid'] = 'Дараагийн хуудасны ID';
$string['privacy:metadata:branch:pageid'] = 'Хуудасны ID';
$string['privacy:metadata:branch:retry'] = 'Оролдлогын дугаар';
$string['privacy:metadata:branch:timeseen'] = 'Хуудсыг харсан цаг';
$string['privacy:metadata:branch:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:metadata:grades'] = 'Хичээл тус бүрийн дүнгийн бүртгэл';
$string['privacy:metadata:grades:completed'] = 'Дүгнэсэн огноо';
$string['privacy:metadata:grades:grade'] = 'Өгсөн дүн';
$string['privacy:metadata:grades:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:metadata:overrides'] = 'Хичээл бүрийн дахин тодорхойлолтын бүртгэл';
$string['privacy:metadata:overrides:available'] = 'Хичээлийг хийж болох цаг';
$string['privacy:metadata:overrides:deadline'] = 'Хичээлийг дуусгах товлосон хугацааа';
$string['privacy:metadata:overrides:maxattempts'] = 'Оролдлогын хамгийн их тоо';
$string['privacy:metadata:overrides:password'] = 'Хичээлд хандах нууц үг';
$string['privacy:metadata:overrides:retake'] = 'Дахин хийхийг зөвшөөрөх эсэх';
$string['privacy:metadata:overrides:review'] = 'Асуултыг дахин оролдохыг зөвшөөрөх эсэх';
$string['privacy:metadata:overrides:timelimit'] = 'Хичээлийг дуусгах хугацааны хязгаар (секундээр).';
$string['privacy:metadata:overrides:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:metadata:timer'] = 'Хичээлийн оролдлогын бүртгэл';
$string['privacy:metadata:timer:completed'] = 'Оролдлого дууссан эсэх';
$string['privacy:metadata:timer:lessontime'] = 'Үйл ажиллагаа бүртгэгдсэн сүүлчийн мөч';
$string['privacy:metadata:timer:starttime'] = 'Оролдлого эхэлсэн огноо';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Мобайл программаас үйл ажиллагаа бүртгэгдсэн сүүлчийн мөч';
$string['privacy:metadata:timer:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:metadata:userpref:lessonview'] = 'Хичээл засварлах үед илүүд үздэг дэлгэцийн горим';
$string['privacy:path:essayanswers'] = 'Эсээний хариулт';
$string['privacy:path:essayresponses'] = 'Эсээний хариу';
$string['privacy:path:pages'] = 'Хуудас';
$string['processerror'] = 'Боловсруулалтын явцад алдаа гарлаа!';
$string['progressbar'] = 'Явцын мөр';
$string['progressbar_help'] = 'Идэвхжүүлсэн тохиолдолд хичээлийн хуудасны доод хэсэгт хэдэн хувь нь дууссан болохыг ойролцоогоор харуулсан мөр гарч ирнэ.';
$string['progressbarteacherwarning'] = '{$a} -н хувьд явцын мөрийг харуулахгүй';
$string['progressbarteacherwarning2'] = 'Та энэ хичээлийг засварлах боломжтой учир явцын мөрийг харахгүй.';
$string['progresscompleted'] = 'Та хичээлийн {$a}%-ийг гүйцэтгэсэн байна.';
$string['qtype'] = 'Хуудасны төрөл';
$string['question'] = 'Асуулт';
$string['questionoption'] = 'Асуулт';
$string['questiontype'] = 'Асуултын төрөл';
$string['randombranch'] = 'Санамсаргүй агуулгын хуудас';
$string['randompageinbranch'] = 'Агуулгын хуудас дахь санамсаргүй асуулт';
$string['rank'] = 'Чансаа';
$string['rawgrade'] = 'Боловсруулаагүй дүн';
$string['receivedcredit'] = 'Авсан кредит';
$string['redisplaypage'] = 'Хуудсыг дахин харуулах';
$string['removeallgroupoverrides'] = 'Бүх бүлгийн дахин тодорхойлолтыг устгах';
$string['removealluseroverrides'] = 'Бүх хэрэглэгчийн дахин тодорхойлолтыг устгах';
$string['report'] = 'Тайлан';
$string['reports'] = 'Тайлангууд';
$string['response'] = 'Хариу';
$string['retakesallowed'] = 'Дахин хийхийг зөвшөөрсөн';
$string['retakesallowed_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагч хичээлийг нэгээс олон удаа оролдох боломжтой болно';
$string['returnto'] = '{$a} руу буцах';
$string['returntocourse'] = 'Хичээл рүү буцах';
$string['reverttodefaults'] = 'Хичээлийг өгөгдмөл хэлбэрт буцаах';
$string['review'] = 'Тойм';
$string['reviewlesson'] = 'Хичээлийн тойм';
$string['reviewquestionback'] = 'Тийм, би дахин оролдож үзмээр байна';
$string['reviewquestioncontinue'] = 'Үгүй, би дараагийн асуулт руу очмоор байна';
$string['sanitycheckfailed'] = 'Шалгалт бүтэлгүйтлээ: Энэ оролдлого устсан байна';
$string['save'] = 'Хадгалах';
$string['savechanges'] = 'Өөрчлөлтийг хадгалах';
$string['savechangesandeol'] = 'Бүх өөрчлөлтийг хадгалаад хичээлийн төгсгөл рүү очих.';
$string['saveoverrideandstay'] = 'Хадгалаад өөр дахин тодорхойлолт оруулах';
$string['savepage'] = 'Хуудсыг хадгалах';
$string['score'] = 'Оноо';
$string['score_help'] = 'Оноо нь зөвхөн өөрсдөө оноо өгөхийг идэвхжүүлсэн үед ашиглагдана. Хариулт бүрд тоон утга (эерэг эсвэл сөрөг) өгч болно.';
$string['scores'] = 'Оноо';
$string['search:activity'] = 'Хичээл - Үйл ажиллагааны мэдээлэл';
$string['secondpluswrong'] = 'Бүрэн бус байна. Дахин оролдох уу?';
$string['selectallattempts'] = 'Бүх оролдлогыг сонгох';
$string['selectaqtype'] = 'Асуултын төрлийг сонгох';
$string['sent'] = 'Илгээх';
$string['shortanswer'] = 'Богино хариулт';
$string['showanunansweredpage'] = 'Хариулаагүй хуудсыг үзүүлэх';
$string['showanunseenpage'] = 'Хараагүй хуудсыг үзүүлэх';
$string['singleanswer'] = 'Нэг хариулт';
$string['skip'] = 'Удирдлагыг алгасах';
$string['slideshow'] = 'Слайд тоглуулах';
$string['slideshow_help'] = 'Идэвхжүүлсэн тохиолдолд хичээл нь тогтмол өргөн, өндөртэй слайд тоглуулах хэлбэрээр харагдана.';
$string['slideshowbgcolor'] = 'Слайдаар тоглуулах дэвсгэр өнгө';
$string['slideshowheight'] = 'Слайдаар тоглуулах өндөр';
$string['slideshowwidth'] = 'Слайдаар тоглуулах өргөн';
$string['startlesson'] = 'Хичээл эхлэх';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} -ын оролдлогын тоо {$a->attempt}';
$string['studentname'] = '{$a} Нэр';
$string['studentoneminwarning'] = 'Анхааруулга: Хичээлээ дуусгахад 1 минутаас бага хугацаа байна.';
$string['studentoutoftimeforreview'] = 'Анхаар: Та энэ хичээлийг хянах цаг дууссан';
$string['studentresponse'] = '{$a} -ын хариу';
$string['submit'] = 'Илгээх';
$string['submitname'] = 'Нэр илгээх';
$string['teacherjumpwarning'] = 'Энэ хичээлд {$a->cluster} үсрэлт эсвэл {$a->unseen} үсрэлтийг ашиглаж байна. Оронд нь дараагийн хуудас үсрэлтийг ашиглана. Эдгээр үсрэлтийг шалгахын тулд суралцагчийн эрхээр нэвтэрнэ үү.';
$string['teacherongoingwarning'] = 'Явцын оноо зөвхөн суралцагчид харагдана. Суралцагчийн эрхээр нэвтэрч явцын оноог шалгана уу.';
$string['teachertimerwarning'] = 'Цаг тоологч нь зөвхөн суралцагчдад л хамаатай. суралцагчаар нэвтэрч цаг тоологчийг шалгана уу.';
$string['thatsthecorrectanswer'] = 'Энэ бол зөв хариулт';
$string['thatsthewronganswer'] = 'Энэ бол буруу хариулт';
$string['thefollowingpagesjumptothispage'] = 'Дараах хуудаснууд энэ хуудас руу үсрэнэ';
$string['thispage'] = 'Энэ хуудас';
$string['timeisup'] = 'Цаг дууссан';
$string['timelimit'] = 'Цагийн хязгаар';
$string['timelimit_help'] = 'Идэвхжүүлсэн тохиолдолд хичээлийн эхэнд цагийн хязгаарын тухай анхааруулга болон цаг тоологч гарч ирнэ. Хугацаа дууссанаас хойш өгсөн хариултыг дүгнэхгүй.';
$string['timelimitwarning'] = 'Танд хичээлээ дуусгахад {$a} байна.';
$string['timeremaining'] = 'Үлдсэн хугацаа';
$string['timespenterror'] = 'Дор хаяж {$a} минут хичээлд зарцуулна уу';
$string['timespentminutes'] = 'Зарцуулсан хугацаа (минутаар)';
$string['timetaken'] = 'Зарцуулсан хугацаа';
$string['totalpagesviewedheader'] = 'Харсан хуудасны тоо';
$string['true'] = 'Yнэн';
$string['truefalse'] = 'Үнэх/худал';
$string['unabledtosavefile'] = 'Таны байршуулсан файлыг хадгалж чадсангүй';
$string['unknownqtypesnotimported'] = 'Асуултын төрлийг нь дэмжихгүй {$a} асуултыг импортлоогүй';
$string['unseenpageinbranch'] = 'Агуулгын хуудсанд хараагүй асуулт';
$string['unsupportedqtype'] = 'Дэмжихгүй асуултын төрөл байна ({$a})!';
$string['updatedpage'] = 'Хуудас шинэчлэх';
$string['updatefailed'] = 'Шинэчлэлт амжилтгүй боллоо';
$string['updatepagenamed'] = 'Хуудсыг шинэчлэх: {$a}';
$string['usemaximum'] = 'Хамгийн ихийг хэрэглэх';
$string['usemean'] = 'Дундаж хэмжээ хэрэглэх';
$string['usepassword'] = 'Нууц үгээр хамгаалагдсан хичээл';
$string['usepassword_help'] = 'Идэвхжүүлсэн тохиолдолд тус хичээлд хандахад нууц үг шаардана.';
$string['useroverrides'] = 'Хэрэглэгчийн дахин тодорхойлолт';
$string['useroverridesdeleted'] = 'Хэрэглэгчийн дахин тодорхойлолтыг устгасан';
$string['usersnone'] = 'Энэ хичээлд хандсан суралцагч байхгүй байна';
$string['viewessayanswers'] = 'Эсээ хариултыг харах';
$string['viewgrades'] = 'Дүн харах';
$string['viewreports'] = '{$a->student} дууссан {$a->attempts} оролдлогуудыг харах';
$string['viewreports2'] = '{$a} дууссан оролдлогуудыг харах';
$string['warning'] = 'Анхааруулга';
$string['welldone'] = 'Сайн байна!';
$string['whatdofirst'] = 'Та эхлээд юу хийхийг хүсч байна вэ?';
$string['withselectedattempts'] = 'Сонгосон оролдлогуудаар...';
$string['wronganswerjump'] = 'Буруу хариултын үсрэлт';
$string['wronganswerscore'] = 'Буруу хариултын оноо';
$string['wrongresponse'] = 'Буруу хариу';
$string['youhaveseen'] = 'Та энэ хичээлийн нэгээс олон хуудсыг үзсэн байна.<br />Та хамгийн сүүлд үзсэн хуудаснаасаа эхлэх үү?';
$string['youranswer'] = 'Таны хариулт';
$string['yourcurrentgradeis'] = 'Таны одоогийн дүн {$a}';
$string['yourcurrentgradeisoutof'] = 'Таны одоогийн дүн {$a->total} байхаас {$a->grade} байна.';
$string['youshouldview'] = 'Та хамгийн багадаа {$a} хариулсан байх ёстой';
