<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'da', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API-endepunkt.';
$string['action:explain_text:model'] = 'AI-model.';
$string['action:explain_text:model_help'] = 'Modellen, der bruges til at forklare den angivne tekst.';
$string['action:explain_text:systeminstruction'] = 'Systeminstruktion';
$string['action:explain_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales kun, hvis det er absolut nødvendigt.';
$string['action:generate_image:endpoint'] = 'API endpoint';
$string['action:generate_image:model'] = 'AI model';
$string['action:generate_image:model_desc'] = 'Modellen brugt til at generere billeder fra brugerens prompts.';
$string['action:generate_image:model_help'] = 'Modellen brugt til at generere billeder fra brugerinput.';
$string['action:generate_text:endpoint'] = 'API endpoint';
$string['action:generate_text:model'] = 'AI model';
$string['action:generate_text:model_desc'] = 'Modellen brugt til at generere tekstsvaret.';
$string['action:generate_text:model_help'] = 'Modellen brugt til at generere tekstsvaret.';
$string['action:generate_text:systeminstruction'] = 'System instruktion';
$string['action:generate_text:systeminstruction_desc'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. At redigere denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['action:generate_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['action:summarise_text:endpoint'] = 'API endpoint';
$string['action:summarise_text:model'] = 'AI model';
$string['action:summarise_text:model_desc'] = 'Modellen brugt til at opsummere den angivne tekst.';
$string['action:summarise_text:model_help'] = 'Modellen brugt til at opsummere den angivne tekst.';
$string['action:summarise_text:systeminstruction'] = 'Systeminstruktion';
$string['action:summarise_text:systeminstruction_desc'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. At redigere denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['action:summarise_text:systeminstruction_help'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. Redigering af denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['apikey'] = 'OpenAI API nøgle';
$string['apikey_desc'] = 'Få en nøgle fra dine <a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI API nøgler</a>.';
$string['apikey_help'] = 'Få en nøgle fra dine <a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI API nøgler</a>.';
$string['custom_model_name'] = 'Brugerdefineret modelnavn';
$string['enableglobalratelimit'] = 'Indstil sidevid grænse for forespørgsler';
$string['enableglobalratelimit_desc'] = 'Begræns antallet af forespørgsler, som OpenAI API-udbyderen kan modtage på hele siden hver time.';
$string['enableuserratelimit'] = 'Indstil brugergrænse for forespørgsler';
$string['enableuserratelimit_desc'] = 'Begræns antallet af forespørgsler, som hver bruger kan foretage til OpenAI API-udbyderen hver time.';
$string['extraparams'] = 'Ekstra parametre';
$string['extraparams_help'] = 'Ekstra parametre kan konfigureres her. Vi understøtter JSON-format. For eksempel:
<pre>
{
"temperature": 0.5,
"max_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Maksimalt antal sidewide forespørgsler';
$string['globalratelimit_desc'] = 'Antallet af sidewide forespørgsler tilladt pr. time.';
$string['invalidjson'] = 'Ugyldig JSON-streng';
$string['orgid'] = 'OpenAI organisations ID';
$string['orgid_desc'] = 'Få dit OpenAI organisations ID fra dine <a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI kontoindstillinger</a>.';
$string['orgid_help'] = 'Få din OpenAI organisation ID fra din <a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI konto</a>.';
$string['pluginname'] = 'OpenAI API udbyder';
$string['privacy:metadata'] = 'OpenAI API udbyder plugin gemmer ikke nogen personlige data.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Denne information sendes til OpenAI API for at generere et svar. Dine OpenAI kontoindstillinger kan ændre, hvordan OpenAI gemmer og beholder disse data. Ingen brugerdata sendes eksplicit til OpenAI eller gemmes i Moodle LMS af dette plugin.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Modellen brugt til at generere svaret.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Antallet af billeder brugt i svaret. Ved generering af billeder.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Den brugerindtastede tekstprompt brugt til at generere svaret.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Svarets format. Ved generering af billeder.';
$string['settings'] = 'Indstillinger';
$string['settings_frequency_penalty'] = 'frekvens_straf';
$string['settings_frequency_penalty_help'] = 'Frekvensstraffen justerer, hvor ofte ord gentages. Jo højere straffen er, desto færre gentagelser i den genererede tekst.';
$string['settings_help'] = 'Juster indstillingerne nedenfor for at tilpasse, hvordan anmodninger sendes til OpenAI.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Det maksimale antal tokens, der skal genereres i svaret.';
$string['settings_presence_penalty'] = 'tilstedeværelses_straf.';
$string['settings_presence_penalty_help'] = 'Tilstedeværelsesstraffen tilskynder modellen til at bruge nye ord ved at øge sandsynligheden for at vælge ord, den ikke har brugt før. En højere værdi gør den genererede tekst mere varieret, mens en lavere værdi tillader mere gentagelse.';
$string['settings_top_p'] = 'Top_p';
$string['settings_top_p_help'] = 'top_p (kerneudvælgelse) bestemmer, hvor mange mulige ord der skal overvejes. En høj værdi (f.eks. 0,9) betyder, at modellen ser på flere ord, hvilket gør den genererede tekst mere varieret.';
$string['userratelimit'] = 'Maksimalt antal forespørgsler pr. bruger';
$string['userratelimit_desc'] = 'Antallet af forespørgsler tilladt pr. time, pr. bruger.';
