<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'analytics', language 'da', version '5.0'.
 *
 * @package     analytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['analysablenotused'] = 'Analyserbar {$a->analysableid} ikke brugt: {$a->errors}';
$string['analysablenotvalidfortarget'] = 'Analyserbar {$a->analysableid} er ikke gyldig for dette mål: {$a->result}';
$string['analysisinprogress'] = 'Stadig under analyse fra en tidligere udførelse';
$string['analytics'] = 'Analyse';
$string['analyticsdisabled'] = 'Analyse er deaktiveret. Du kan aktivere det under "Sideadministration > Avancerede funktioner".';
$string['analyticslogstore'] = 'Loglager brugt til analyse';
$string['analyticslogstore_help'] = 'Loglageret, der vil blive brugt af analyse-API\'en til at læse brugernes aktivitet.';
$string['analyticssettings'] = 'Analyseindstillinger';
$string['analyticssiteinfo'] = 'Sideinformation';
$string['calclifetime'] = 'Behold analyseberegninger i';
$string['configlcalclifetime'] = 'Dette angiver, hvor lang tid du vil beholde beregningsdata - dette vil ikke slette forudsigelser, men sletter de data, der blev brugt til at generere forudsigelserne. At bruge standardindstillingen her er bedst, da det holder dit diskforbrug under kontrol, men hvis du bruger beregningstabeller til andre formål, kan du ønske at øge denne værdi.';
$string['defaultpredictionsprocessor'] = 'Standard forudsigelsesprocessor';
$string['defaultpredictoroption'] = 'Standard processor ({$a})';
$string['defaulttimesplittingmethods'] = 'Standardanalyseintervaller for modellens evaluering';
$string['defaulttimesplittingmethods_help'] = 'Analyseintervallet definerer, hvornår systemet vil beregne forudsigelserne og den del af aktivitetsloggene, der vil blive betragtet for disse forudsigelser. Modelvurderingsprocessen vil iterere gennem disse analyseintervaller, medmindre et specifikt analyseinterval er angivet.';
$string['disabledmodel'] = 'Deaktiveret model';
$string['erroralreadypredict'] = 'Filen {$a} er allerede blevet brugt til at generere forudsigelser.';
$string['errorcannotreaddataset'] = 'Datasætfilen {$a} kan ikke læses.';
$string['errorcannotusetimesplitting'] = 'Det angivne analyseinterval kan ikke bruges på denne model.';
$string['errorcannotwritedataset'] = 'Datasætfilen {$a} kan ikke skrives.';
$string['errorexportmodelresult'] = 'Maskinlæringsmodellen kan ikke eksporteres.';
$string['errorimport'] = 'Fejl ved import af den angivne JSON-fil.';
$string['errorimportmissingclasses'] = 'Følgende analysekomponenter er ikke tilgængelige på dette websted: {$a->missingclasses}.';
$string['errorimportmissingcomponents'] = 'Den angivne model kræver, at følgende plugins er installeret: {$a}. Bemærk, at versionerne ikke nødvendigvis behøver at matche de versioner, der er installeret på dit websted. Installation af den samme eller en nyere version af pluginet burde være fint i de fleste tilfælde.';
$string['errorimportversionmismatches'] = 'Versionen af følgende komponenter afviger fra versionen installeret på dette websted: {$a}. Du kan bruge muligheden \'Ignorer versionsforskelle\' til at ignorere disse forskelle.';
$string['errorinvalidcontexts'] = 'Nogle af de valgte kontekster kan ikke bruges i dette mål.';
$string['errorinvalidindicator'] = 'Ugyldig {$a} indikator';
$string['errorinvalidtarget'] = 'Ugyldigt {$a} mål';
$string['errorinvalidtimesplitting'] = 'Ugyldigt analyseinterval; sørg for, at du tilføjer den fuldt kvalificerede klassenavn.';
$string['errornocontextrestrictions'] = 'Det valgte mål understøtter ikke kontekstbegrænsninger';
$string['errornoexportconfig'] = 'Der opstod et problem med at eksportere modelkonfigurationen.';
$string['errornoexportconfigrequirements'] = 'Kun ikke-statiske modeller med et analyseinterval kan eksporteres.';
$string['errornoindicators'] = 'Denne model har ingen indikatorer.';
$string['errornopredictresults'] = 'Ingen resultater returneret fra forudsigelsesprocessoren. Kontrollér outputmappeindholdet for mere information.';
$string['errornoroles'] = 'Student- eller læringsroller er ikke defineret. Definér dem på analyseindstillingssiden.';
$string['errornotarget'] = 'Denne model har ingen mål.';
$string['errornotimesplittings'] = 'Denne model har intet analyseinterval.';
$string['errorpredictioncontextnotavailable'] = 'Denne forudsigelseskontekst er ikke længere tilgængelig.';
$string['errorpredictionformat'] = 'Forkert format for forudsigelsesberegninger';
$string['errorpredictionnotfound'] = 'Forudsigelse ikke fundet';
$string['errorpredictionsprocessor'] = 'Forudsigelsesprocessorfejl: {$a}';
$string['errorpredictwrongformat'] = 'Returneringen fra forudsigelsesprocessoren kan ikke dekodes: "{$a}"';
$string['errorprocessornotready'] = 'Den valgte forudsigelsesprocessor er ikke klar: {$a}';
$string['errorsamplenotavailable'] = 'Den forudsagte prøve er ikke længere tilgængelig.';
$string['errorunexistingmodel'] = 'Ikke-eksisterende model {$a}';
$string['errorunexistingtimesplitting'] = 'Det valgte analyseinterval er ikke tilgængeligt.';
$string['errorunknownaction'] = 'Ukendt handling';
$string['eventinsightsviewed'] = 'Indblik vist';
$string['eventpredictionactionstarted'] = 'Forudsigelsesprocessen startet';
$string['fixedack'] = 'Accepter';
$string['incorrectlyflagged'] = 'Forkert markeret';
$string['insightinfomessageaction'] = '{$a->text}: {$a->url}';
$string['insightinfomessagehtml'] = 'Systemet har genereret en indsigt til dig.';
$string['insightinfomessageplain'] = 'Systemet har genereret en indsigt til dig: {$a}';
$string['insightmessagesubject'] = 'Ny indsigt for "{$a}"';
$string['invalidanalysablefortimesplitting'] = 'Det kan ikke analyseres ved hjælp af {$a} analyseinterval.';
$string['invalidtimesplitting'] = 'Model med ID {$a} har brug for et analyseinterval, før den kan bruges til træning.';
$string['levelinstitution'] = 'Uddannelsesniveau';
$string['levelinstitutionisced0'] = 'Førskoleundervisning (\'mindre end primært\' for uddannelsesresultater)';
$string['levelinstitutionisced1'] = 'Primær uddannelse';
$string['levelinstitutionisced2'] = 'Ungdomsuddannelse';
$string['levelinstitutionisced3'] = 'Videregående ungdomsuddannelse';
$string['levelinstitutionisced4'] = 'Eftersekundær ikke-tertiær uddannelse (kan omfatte virksomhedstræning eller træning fra fællesskaber/NGOer)';
$string['levelinstitutionisced5'] = 'Kort-cyklus tertiær uddannelse (kan omfatte virksomhedstræning eller træning fra fællesskaber/NGOer)';
$string['levelinstitutionisced6'] = 'Bachelor- eller tilsvarende niveau';
$string['levelinstitutionisced7'] = 'Master- eller tilsvarende niveau';
$string['levelinstitutionisced8'] = 'Doktor- eller tilsvarende niveau';
$string['modeinstruction'] = 'Undervisningsformer';
$string['modeinstructionblendedhybrid'] = 'Blended eller hybrid';
$string['modeinstructionfacetoface'] = 'Ansigt til ansigt';
$string['modeinstructionfullyonline'] = 'Fuldstændigt online';
$string['modeloutputdir'] = 'Modeloutputbibliotek';
$string['modeloutputdirwithdefaultinfo'] = 'Bibliotek hvor forudsigelsesprocessorerne gemmer alle evalueringer info. Nyttig til fejlretning og forskning. Hvis tomt, så bruges {$a} som standard.';
$string['modeltimelimit'] = 'Analysens tidsgrænse pr. model';
$string['modeltimelimitinfo'] = 'Denne indstilling begrænser den tid, hver model bruger på at analysere sidelayout.';
$string['neutral'] = 'Neutral';
$string['neverdelete'] = 'Slet aldrig beregninger';
$string['nocourses'] = 'Ingen kurser at analysere';
$string['nodata'] = 'Ingen data at analysere';
$string['noevaluationbasedassumptions'] = 'Modeller baseret på antagelser kan ikke evalueres.';
$string['noinsights'] = 'Ingen indsigter rapporteret';
$string['noinsightsmodel'] = 'Denne model genererer ikke indsigter';
$string['nonewdata'] = 'Ingen nye data tilgængelige. Modellen vil blive analyseret efter det næste analyseinterval.';
$string['nonewranges'] = 'Ingen nye forudsigelser endnu. Modellen vil blive analyseret efter det næste analyseinterval.';
$string['nopredictionsyet'] = 'Ingen forudsigelser tilgængelige endnu';
$string['noranges'] = 'Ingen forudsigelser endnu';
$string['notapplicable'] = 'Ikke anvendelig';
$string['notrainingbasedassumptions'] = 'Modeller baseret på antagelser behøver ikke træning';
$string['notuseful'] = 'Ikke nyttig';
$string['novaliddata'] = 'Ingen gyldige data tilgængelige';
$string['novalidsamples'] = 'Ingen gyldige prøver tilgængelige';
$string['onlycli'] = 'Kun kommandolinje';
$string['onlycliinfo'] = 'Analyseprocesser som evaluering af modeller, træning af maskinlæringsalgoritmer eller opnåelse af forudsigelser kan tage nogen tid. De kører som kronjobs eller kan tvinges via kommandolinje. Hvis deaktiveret, kan analyseprocesser køres manuelt via webinterface.';
$string['percentonline'] = 'Procentdel online';
$string['percentonline_help'] = 'Hvis din organisation tilbyder blended eller hybrid kurser, hvilken procentdel af elevarbejdet udføres online i Moodle? Indtast et tal mellem 0 og 100.';
$string['predictionsprocessor'] = 'Forudsigelsesprocessor';
$string['predictionsprocessor_help'] = 'En forudsigelsesprocessor er maskinlærings-backend, der behandler datasæt genereret ved at beregne modellens indikatorer og mål. Hver model kan bruge en forskellig processor. Den, der er specificeret her, vil være standarden.';
$string['privacy:metadata:analytics:analyticsmodels'] = 'Analysemodeller';
$string['privacy:metadata:analytics:analyticsmodels:usermodified'] = 'Brugeren, der modificerede modellen';
$string['privacy:metadata:analytics:analyticsmodelslog'] = 'Log brugt til analysemodeller';
$string['privacy:metadata:analytics:analyticsmodelslog:usermodified'] = 'Brugeren, der modificerede loggen';
$string['privacy:metadata:analytics:indicatorcalc'] = 'Indikatorberegninger';
$string['privacy:metadata:analytics:indicatorcalc:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:indicatorcalc:endtime'] = 'Beregning sluttidspunkt';
$string['privacy:metadata:analytics:indicatorcalc:indicator'] = 'Indikatorberegner klasse';
$string['privacy:metadata:analytics:indicatorcalc:sampleid'] = 'Prøve-ID';
$string['privacy:metadata:analytics:indicatorcalc:sampleorigin'] = 'Prøvens oprindelsestabel';
$string['privacy:metadata:analytics:indicatorcalc:starttime'] = 'Beregning starttidspunkt';
$string['privacy:metadata:analytics:indicatorcalc:timecreated'] = 'Hvornår forudsigelsen blev foretaget';
$string['privacy:metadata:analytics:indicatorcalc:value'] = 'Den beregnede værdi';
$string['privacy:metadata:analytics:predictionactions'] = 'Forudsigelseshandlinger';
$string['privacy:metadata:analytics:predictionactions:actionname'] = 'Handlingens navn';
$string['privacy:metadata:analytics:predictionactions:predictionid'] = 'Forudsigelses-ID';
$string['privacy:metadata:analytics:predictionactions:timecreated'] = 'Hvornår forudsigelseshandlingen blev udført';
$string['privacy:metadata:analytics:predictionactions:userid'] = 'Brugeren, der foretog handlingen';
$string['privacy:metadata:analytics:predictions'] = 'Forudsigelser';
$string['privacy:metadata:analytics:predictions:calculations'] = 'Indikatorberegninger';
$string['privacy:metadata:analytics:predictions:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:predictions:modelid'] = 'Model-ID';
$string['privacy:metadata:analytics:predictions:prediction'] = 'Forudsigelsen';
$string['privacy:metadata:analytics:predictions:predictionscore'] = 'Forudsigelsesscore';
$string['privacy:metadata:analytics:predictions:rangeindex'] = 'Indeks for analyseintervallet';
$string['privacy:metadata:analytics:predictions:sampleid'] = 'Prøve-ID';
$string['privacy:metadata:analytics:predictions:timecreated'] = 'Hvornår forudsigelsen blev foretaget';
$string['privacy:metadata:analytics:predictions:timeend'] = 'Beregning sluttidspunkt';
$string['privacy:metadata:analytics:predictions:timestart'] = 'Beregning starttidspunkt';
$string['processingsitecontents'] = 'Behandler sideindhold';
$string['successfullyanalysed'] = 'Succesfuldt analyseret';
$string['timesplittingmethod'] = 'Analyseinterval';
$string['timesplittingmethod_help'] = 'Analyseintervallet definerer, hvornår systemet vil beregne forudsigelserne og den del af aktivitetsloggene, der vil blive betragtet for disse forudsigelser. For eksempel kan kursets varighed opdeles i dele, med en forudsigelse genereret i slutningen af hver del.';
$string['timesplittingmethod_link'] = 'Time_splitting_methods';
$string['typeinstitution'] = 'Type af institution';
$string['typeinstitutionacademic'] = 'Akademisk';
$string['typeinstitutionngo'] = 'Ikke-statslig organisation (NGO)';
$string['typeinstitutiontraining'] = 'Virksomhedstræning';
$string['useful'] = 'Nyttig';
$string['viewdetails'] = 'Vis detaljer';
$string['viewinsight'] = 'Vis indsigt';
$string['viewinsightdetails'] = 'Vis indsigt detaljer';
$string['viewprediction'] = 'Vis forudsigelsesdetaljer';
$string['washelpful'] = 'Var dette nyttigt?';
