<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'da', version '5.0'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktiviteter';
$string['addcategory'] = 'Tilføj kategori';
$string['addcategoryerror'] = 'Kan ikke tilføje kategori';
$string['addexceptionerror'] = 'Der opstod en fejl i forbindelse med en tilføjelse af en undtagelse for userid:gradeitem';
$string['addfeedback'] = 'Tilføj feedback';
$string['addgradeletter'] = 'Tilføj et karakterbogstav';
$string['addidnumbers'] = 'Tilføj id-numre';
$string['additem'] = 'Tilføj karakterelement';
$string['additionalfeedback'] = 'Yderligere feedback';
$string['addoutcome'] = 'Tilføj et slutresultat';
$string['addoutcomeitem'] = 'Tilføj slutresultatelement';
$string['addscale'] = 'Tilføj en skala';
$string['adjustedweight'] = 'Vægtning justeret';
$string['aggregateextracreditmean'] = 'Karaktergennemsnit (med ekstra point)';
$string['aggregatemax'] = 'Højeste karakter';
$string['aggregatemean'] = 'Karaktergennemsnit';
$string['aggregatemedian'] = 'Karaktermedian';
$string['aggregatemin'] = 'Laveste karakter';
$string['aggregatemode'] = 'Hyppigste karakterer';
$string['aggregatenotonlygraded'] = 'Medtag tomme karakterer';
$string['aggregateonlygraded'] = 'Udeluk tomme karakterer';
$string['aggregateonlygraded_help'] = 'En tom karakter er en karakter, som ikke findes i karakterbogen. Det kan være fra en opgaveaflevering som endnu ikke er bedømt, eller fra en quiz som ikke er besvaret osv.

Indstillingen styrer om tomme karakterer skal tages med i sammentællingen eller tælles som minimumskarakterer, f.eks. 0 for en opgave med karakterer mellem 0 og 100.';
$string['aggregateoutcomes'] = 'Tag slutresultater med i sammentællingen';
$string['aggregateoutcomes_help'] = 'Er indstillingen aktiveret, tages slutresultater med i sammentællingen. Dette kan betyde en uventet total for katagori.';
$string['aggregatesonly'] = 'Vis kun totaler';
$string['aggregatesubcatsupgradedgrades'] = 'Bemærk: Indstillingen "Sammentælling med underkategorier" er blevet fjernet ved en opdatering af installationen. Da "Sammentælling med underkategorier" tidligere har været brugt på dette kursus, anbefales det at du gennemgår denne ændring i karakterbogen.';
$string['aggregatesum'] = 'Naturlig';
$string['aggregateweightedmean'] = 'Vægtet karaktergennemsnit';
$string['aggregateweightedmean2'] = 'Simpelt vægtet karaktergennemsnit';
$string['aggregation'] = 'Sammentælling';
$string['aggregation_help'] = 'Sammentællingen afgør hvordan karakterer i kategorien kombineres, som f.eks.

* Karaktergennemsnit - Summen af alle karakterer divideret med det samlede antal karakterer
* Karaktermedianen - Den mellemste karakter, når karaktererne stilles op i størrelsesorden
* Laveste karakter
* Højeste karakter
* Typeværdi - Den karakter, der forekommer hyppigst
* Naturlig - Summen af alle karakterværdier skaleret efter vægtning';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Sammentællingskoefficient';
$string['aggregationcoefextra'] = 'Ekstra point';
$string['aggregationcoefextra_help'] = 'Hvis sammentællingen er "Naturlig" eller "Simpelt vægtet gennemsnit", og feltet ekstra point er valgt, vil karakterelementets højeste karakter ikke blive tilføjet kategoriens højeste karakter. Dette fører til, at man kan opnå højeste karakter i kategorien, uden at man har fået højeste karakter i alle karakterelementer. Hvis administratoren har gjort det muligt at give mere end den højeste karakter, kan der være karakterer der er højere.

Hvis sammentællingen er "Gennemsnit af karakterer (med ekstra point), og de ekstra point er sat til over nul, er de ekstra point den faktor karakteren ganges med, før man lægger dem til det samlede tal efter beregningen af gennemsnittet.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Ekstra point';
$string['aggregationcoefextrasum_help'] = 'Hvis feltet ekstra point er markeret, bliver karakterelementets højeste karakter ikke lagt til kategoriens højeste karakter, hvilket resulterer i muligheden for at opnå den højeste karakter i kategorien (eller karakterer over maksimum, hvis administratoren har aktiveret det), uden at have opnået den højeste karakter i alle karakterelementer.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Vægtning af ekstra point';
$string['aggregationcoefextraweight_help'] = 'Hvis vægtningen af ekstra point er sat til at være større end nul, fungerer karakteren som ekstra point i sammentællingen. Tallet er den faktor karakteren ganges med, før man lægger den til det samlede tal for beregningen af gennemsnittet.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Vægtning af element';
$string['aggregationcoefweight_help'] = 'Vægtning af elementet bruges i kategorisammentællingen til at påvirke vigtigheden af elementet sammenlignet med andre karakterlementer i samme kategori.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Udeladt)';
$string['aggregationhintexcluded'] = '(Udelukket)';
$string['aggregationhintextra'] = '(Ekstra point)';
$string['aggregationhintnovalue'] = '(Tom)';
$string['aggregationofa'] = 'Sammentælling af {$a}';
$string['aggregationposition'] = 'Sammentællingsposition';
$string['aggregationposition_help'] = 'Indstillingen afgør, om kolonnerne med det samlede resultat for kategori og kursus vises først eller sidst i karakterbøgerne.';
$string['aggregationsvisible'] = 'Tilgængelige sammentællingsmetoder';
$string['aggregationsvisiblehelp'] = 'Vælg de sammentællingsmetoder, der skal være tilgængelige. Hold Ctrl-tasten nede hvis du vil vælge mere end en.';
$string['allgrades'] = 'Alle karakterer efter kategori';
$string['allstudents'] = 'Alle studerende';
$string['allusers'] = 'Alle brugere';
$string['autosort'] = 'Sorter automatisk';
$string['availableidnumbers'] = 'Tilgængelige id-numre';
$string['average'] = 'Gennemsnit';
$string['averagesdecimalpoints'] = 'Decimaler i kolonnen gennemsnit';
$string['averagesdecimalpoints_help'] = 'Indstillingen styrer antal decimaler der vises for hvert gennemsnit, eller om de generelle antal decimaler for kategorien eller karakteren bruges (nedarvet).';
$string['averagesdisplaytype'] = 'Visningstype for kolonnegennemsnit';
$string['averagesdisplaytype_help'] = 'Indstillingen styrer om gennemsnittet (middelværdien) vises som faktiske karakterer, procentdele eller bogstaver, eller om visningen for kategorien eller karakterer bruges (nedarvet).';
$string['backupwithoutgradebook'] = 'Backup indeholder ikke karakterbogskonfiguration';
$string['badgrade'] = 'Karakteren er ugyldig';
$string['badlyformattedscale'] = 'Skriv en kommasepareret liste med (mindst to) værdier.';
$string['baduser'] = 'Brugeren er ugyldig';
$string['bonuspoints'] = 'Bonuspoint';
$string['bulkcheckboxes'] = 'Saml afkrydsningsfelter';
$string['calculatedgrade'] = 'Beregnet karakter';
$string['calculation'] = 'Beregning';
$string['calculation_help'] = 'En karakterberegning er en formel til bestemmelse af karakterer. Formlen skal starte med et lighedstegn (=) og kan bruge almindelige matematiske operatorer såsom max, min og sum. Om ønsket kan andre karakterer tages med i beregningen ved at skrive id-numre i dobbelte firkantede parenteser.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Tilføj beregning';
$string['calculationedit'] = 'Rediger beregning';
$string['calculationsaved'] = 'Beregning gemt';
$string['calculationview'] = 'Vis beregning';
$string['calculationwarning'] = 'Denne kategori anvender en karakterberegning for kategoriens total i stedet for en aggregering.';
$string['cannotaccessgroup'] = 'Kan ikke tilgå karakterer for den valgte gruppe, beklager.';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categoryedit'] = 'Rediger kategori';
$string['categoryname'] = 'Navn på kategori';
$string['categorytotal'] = 'Kategoritotal';
$string['categorytotalfull'] = '{$a->category} total';
$string['categorytotalname'] = 'Navn på kategoritotal';
$string['changedefaults'] = 'Skift standarder';
$string['changereportdefaults'] = 'Skift rapportstandarder';
$string['chooseaction'] = 'Vælg handling...';
$string['choosecategory'] = 'Vælg kategori';
$string['collapsecriterion'] = 'Sammenklap kriterier';
$string['compact'] = 'Kompakt';
$string['componentcontrolsvisibility'] = 'Aktivitetsindstillingerne styrer, om karakterelementet er skjult.';
$string['contract'] = 'Begræns kategori';
$string['contributiontocoursetotal'] = 'Bidrag til kursets total';
$string['courseavg'] = 'Kursusgennemsnit';
$string['coursegradecategory'] = 'Kursets karakterkategori';
$string['coursegradedisplaytype'] = 'Kursets karaktervisning';
$string['coursegradedisplayupdated'] = 'Kursets karaktervisning er opdateret.';
$string['coursegradesettings'] = 'Karakterindstillinger på kurset';
$string['coursename'] = 'Kursusnavn';
$string['coursescales'] = 'Kursusskalaer';
$string['coursesettings'] = 'Kursusindstillinger';
$string['coursesettingsexplanation'] = 'Indstillingerne for kursuskarakterer styrer hvordan karakterbogen fremtræder for alle deltagerne på kurset.';
$string['coursesiamtaking'] = 'Kurser jeg deltager i';
$string['coursesiamteaching'] = 'Kurser jeg underviser i';
$string['coursetotal'] = 'Kursets total';
$string['createcategory'] = 'Opret kategori';
$string['createcategoryerror'] = 'Kunne ikke oprette ny kategori';
$string['creatinggradebooksettings'] = 'Opretter karakterbogsindstillinger';
$string['csv'] = 'CSV';
$string['currentgrade'] = 'Aktuel karakter';
$string['currentparentaggregation'] = 'Aktuel overordnet sammentælling';
$string['curveto'] = 'Kurve til';
$string['decimalpoints'] = 'Antal decimaler';
$string['decimalpoints_help'] = 'Indstillingen styrer antal decimaler i karakterer. Indstillingen har ingen betydning for beregningerne, de udføres med 5 decimalers præcision.';
$string['default'] = 'Standard';
$string['defaultprev'] = 'Standard ({$a})';
$string['deletecategory'] = 'Slet kategori';
$string['deletescale'] = 'Slet skala';
$string['disablegradehistory'] = 'Deaktiver karakterhistorik';
$string['disablegradehistory_help'] = 'Deaktiver logning af ændringshistorik i karakterrelaterede tabeller. Dette kan gøre serveren lidt hurtigere og spare plads i databasen.';
$string['displaylettergrade'] = 'Vis bogstavskarakterer';
$string['displaypercent'] = 'Vis procenter';
$string['displaypoints'] = 'Vis point';
$string['displayweighted'] = 'Vis vægtede karakterer';
$string['droplow'] = 'Drop den laveste';
$string['droplow_help'] = 'Denne indstilling aktiverer et specificeret antal af de laveste karakterer, som skal ekskluderes fra sammentællingen.';
$string['droplowestvalue'] = 'Sæt drop laveste karakterværdi';
$string['droplowestvalues'] = 'Drop {$a} laveste værdier';
$string['dropped'] = 'Droppet';
$string['dropxlowest'] = 'Drop X laveste';
$string['dropxlowestwarning'] = 'Bemærk: Hvis du bruger Drop X laveste forudsætter det at alle elementer i kategorien har den samme pointværdi. Hvis pointværdien er forskellig, vil resultatet blive uforudsigeligt.';
$string['duplicatedgradeitem'] = '{$a} (copy)';
$string['duplicatescale'] = 'Dubler skala';
$string['edit'] = 'Rediger';
$string['editcalculation'] = 'Rediger beregning';
$string['editcalculationverbose'] = 'Rediger beregning af {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Rediger feedback';
$string['editgrade'] = 'Rediger karakter';
$string['editgradeletters'] = 'Rediger karaktererbogstaver';
$string['editoutcome'] = 'Rediger slutresultat';
$string['editoutcomes'] = 'Rediger slutresultater';
$string['editscale'] = 'Rediger skala';
$string['edittree'] = 'Opsætning';
$string['editverbose'] = 'Rediger {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableoutcomes'] = 'Aktiver slutresultater';
$string['enableoutcomes_help'] = 'Er indstillingen aktiveret, kan karakterelementer vurderes ved brug af en eller flere skalaer beregnet til opgørelse af slutresultat.';
$string['encoding'] = 'Kodning';
$string['encoding_help'] = 'Vælg den tegnkodning der bruges til data. (Standard er UTF-8). Kommer du til at vælge forkert kodning, vil det være tydeligt under forhåndsvisning af data til import.';
$string['errorcalculationbroken'] = 'Fejl i beregningen af karakteren {$a}.';
$string['errorcalculationnoequal'] = 'Formler skal starte med et lighedstegn (=1+2)';
$string['errorcalculationunknown'] = 'Ugyldig formel';
$string['errorgradevaluenonnumeric'] = 'Fandt et ikke-numerisk tegn for lav eller høj karakter for';
$string['errornegativepenalty'] = 'Modtog negativ værdi under strafaggregationen for karakter ID {$a}';
$string['errornocalculationallowed'] = 'Beregninger er ikke tilladt her';
$string['errornocategorisedid'] = 'Kunne ikke finde et ukategoriseret id!';
$string['errornocourse'] = 'Kan ikke finde kursusinformation';
$string['erroroverweight'] = 'Vægtningens total overstiger 100%.';
$string['errorreprintheadersnonnumeric'] = 'Modtog en ikke-numerisk værdi for reprint-headers';
$string['errorsavegrade'] = 'Kunne ikke gemme karakteren, beklager.';
$string['errorsettinggrade'] = 'Fejl ved lagring af "{$a->itemname}"-karakter for bruger-id {$a->userid}';
$string['errorunderweight'] = 'Vægtningens total er under 100%.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Fejl ved opdatering af indstillingen "Sammentæl kun ikke-tomme karakterer" af karakterkategori-id {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Fejl ved opdatering af indstillingen "Inkluder resultater i sammentælling" af karakterkategori-id {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Fejl i opdatering af sammentællingen af typeværdikategori-id {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Fejl i opdatering af sammentællingskoefficienten (vægtning eller ekstra point) for karakterelement-id {$a->id}';
$string['eventgradedeleted'] = 'Karakter slettet';
$string['eventgradeexported'] = 'Karakter eksporteret';
$string['eventgradeitemcreated'] = 'Karakterelement oprettet';
$string['eventgradeitemdeleted'] = 'Karakterelement slettet';
$string['eventgradeitemupdated'] = 'Karakterelement opdateret';
$string['eventgradelettercreated'] = 'Karakterbogstav oprettet';
$string['eventgradeletterdeleted'] = 'Karakterbogstav slettet';
$string['eventgradeletterupdated'] = 'Karakterbogstav opdateret';
$string['eventgradeviewed'] = 'Karaktererne er set i karakterbogen';
$string['eventscalecreated'] = 'Skala oprettet';
$string['eventscaledeleted'] = 'Skala slettet';
$string['eventscaleupdated'] = 'Skala opdateret';
$string['eventusergraded'] = 'Bruger bedømt';
$string['excluded'] = 'Ekskluderet';
$string['excluded_help'] = 'Hvis markeret, vil karakteren ikke tages med i sammentællinger.';
$string['expand'] = 'Udvid kategorien';
$string['expandcriterion'] = 'Udvid kriterier';
$string['export'] = 'Eksporter';
$string['exportalloutcomes'] = 'Eksporter alle slutresultater';
$string['exportas'] = 'Eksporter som';
$string['exportfeedback'] = 'Inkluder feedback i eksporten.';
$string['exportfeedback_desc'] = 'Indstillingen kan overskrives under eksport.';
$string['exportformatoptions'] = 'Eksporter valgmuligheder for format';
$string['exportonlyactive'] = 'Ekskluder suspenderede brugere';
$string['exportonlyactive_help'] = 'Inkluder kun studerende i denne eksport, hvis tilmelding er aktiv og ikke har været suspenderet';
$string['exportplugins'] = 'Eksport-plugins';
$string['exportsettings'] = 'Eksporter indstillingerne';
$string['exportto'] = 'Eksporter til';
$string['externalurl'] = 'Ekstern URL';
$string['externalurl_desc'] = 'Hvis der bruges en ekstern karakterbog, skal URL\'en specificeres her.';
$string['extracreditvalue'] = 'Ekstra point for {$a}';
$string['extracreditwarning'] = 'Bemærk: Sættes alle elementer for en kategori til ekstra point vil de i praksis fjernes fra karakterberegningen, da der ikke vil være nogen point at beregne på.';
$string['fail'] = 'Fejl';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Denne boks muliggør tilføjelse af kommentarer til karakteren.';
$string['feedbackadd'] = 'Tilføj feedback';
$string['feedbackedit'] = 'Rediger feedback';
$string['feedbackfiles'] = 'Feedback-filer';
$string['feedbackforgradeitems'] = 'Feedback til {$a}';
$string['feedbackhistoryfiles'] = 'Feedback-historikfiler';
$string['feedbackprovided'] = 'Feedback givet';
$string['feedbacks'] = 'Feedback';
$string['feedbacksaved'] = 'Feedback gemt';
$string['feedbackview'] = 'Vis feedback';
$string['filterbothactive'] = 'Først ({$a->first}) Sidst ({$a->last})';
$string['filterbyname'] = 'Filtrér efter navn';
$string['filterfirstactive'] = 'Først ({$a->first})';
$string['filterlastactive'] = 'Sidst ({$a->last})';
$string['finalgrade'] = 'Endelig karakter';
$string['finalgrade_help'] = 'Hvis overskrivningsfeltet er markeret, kan en karakter tilføjes eller ændres.';
$string['fixedstudents'] = 'Fast kolonne med studerende';
$string['fixedstudents_help'] = 'Tillader at scrolle vandret i karakterer uden at tabe kolonnen med studerende af syne, ved at gøre den fast.';
$string['forceimport'] = 'Gennemtving import';
$string['forceimport_help'] = 'Gennemtving import af karakterer, selv om de er blevet opdateret efter at importfilen blev eksporteret';
$string['forceoff'] = 'Gennemtvingning: Fra';
$string['forceon'] = 'Gennemtvingning: Til';
$string['forelementtypes'] = 'for de valgte {$a}';
$string['forstudents'] = 'For studerende';
$string['full'] = 'Fuld';
$string['fullmode'] = 'Vis karakterer og totaler';
$string['generalsettings'] = 'Generelle indstillinger';
$string['grade_help'] = 'Karakter hvor den studerende belønnes for sit arbejde';
$string['gradeadministration'] = 'Administration af karakterer';
$string['gradealreadyupdated'] = '{$a} karakterer er ikke importeret, fordi karaktererne i importfilen er ældre end i karakterbogen. Fortsæt med at importere karaktererne alligevel ved at bruge valgmuligheden \'gennemtving import\'.';
$string['gradeanalysis'] = 'Karakteranalyse';
$string['gradebook'] = 'Karakterbog';
$string['gradebookcalculationsfixbutton'] = 'Godkend karakterændringer og ret beregningsfejl';
$string['gradebookcalculationsuptodate'] = 'Beregningerne i karakterbogen er opdateret. Du skal muligvis genindlæse denne side for at se ændringerne';
$string['gradebookcalculationswarning'] = 'Bemærk: Der er fundet fejl i beregningen af karaktererne i karakterbogen. Hvis dit undervisningsforløb endnu ikke er begyndt eller hvis det er i gang, anbefales det at fejlene rettes ved at trykke på knappen nedenunder, selvom det betyder at nogle af karaktererne ændres. Hvis dit undervisningsforløb er slut og karaktererne er givet, ønsker du nok ikke at rette noget.

Den nyere version er {$a->currentversion}, du bruger karakterbog version {$a->gradebookversion}. Listen med ændringer kan ses i <a href="{$a->url}">Beregningsændringer i karakterbog</a>';
$string['gradebookhiddenerror'] = 'Denne karakterbog er i øjeblikket sat til at skjule alt for studerende.';
$string['gradebookhistories'] = 'Karakterhistorikker';
$string['gradebooknavigationmenu'] = 'Karakterbogs navigationsmenu';
$string['gradebooksetup'] = 'Karakterbogsopsætning';
$string['gradeboundary'] = 'Grænse for bogstavkarakter';
$string['gradeboundary_help'] = 'Indstillingen styrer den mindste procentdel over hvilken karakterer tilknyttes et karakterbogstav.';
$string['gradecategories'] = 'Karakterkategorier';
$string['gradecategory'] = 'Karakterkategori';
$string['gradecategoryonmodform'] = 'Karakterkategori';
$string['gradecategoryonmodform_help'] = 'Denne indstilling styrer den kategori, hvor aktivitetens karakterer er placeret i karakterbogen.';
$string['gradecategorysettings'] = 'Indstillinger for karakterkategori';
$string['gradedisplay'] = 'Karaktervisning';
$string['gradedisplaytype'] = 'Format til visning af karakterer';
$string['gradedisplaytype_help'] = 'Indstillingen styrer hvordan karakterer vises i karakter- og brugerrapporter.

* Bogstav - Bogstaver eller ord kan repræsentere et karakterinterval som defineret i "Bogstaver" i karkterbogsopsætningen
* Procentdel - Relativt til maksimum- og minimumkarakterer
* Faktisk - Aktuelle karakterer eller skalaværdier';
$string['gradedon'] = 'Bedømt: {$a}';
$string['gradeexport'] = 'Eksport af karakterer';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Profilfelter i karaktereksport';
$string['gradeexportcustomprofilefields_desc'] = 'Inkluder disse brugerdefinerede kommaseparerede profilfelter i karaktereksporten.';
$string['gradeexportdecimalpoints'] = 'Decimaler i karaktereksport';
$string['gradeexportdecimalpoints_desc'] = 'Antal decimaler til visning i eksport. Antallet kan ændres under den enkelte eksport.';
$string['gradeexportdisplaytype'] = 'Type visning af karakterer ved eksport';
$string['gradeexportdisplaytype_desc'] = 'Karakterer kan vises som faktiske karakterer, som procentsatser (i forhold til minimum- og maksimumskarakterer) eller som bogstaver (A, B, C...) ved eksport. Dette kan ændres ad hoc.';
$string['gradeexportdisplaytypes'] = 'Typer visning af karakterer ved eksport';
$string['gradeexportuserprofilefields'] = 'Brugerprofil-felter ved karaktereksport';
$string['gradeexportuserprofilefields_desc'] = 'Inkluder disse brugerprofil-felter i karaktereksporten, adskilt af kommaer.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Oprindelig laveste og højeste karakterer';
$string['gradehelp'] = 'Hjælp til karakterer';
$string['gradehistorylifetime'] = 'Karakterhistorikkens levetid';
$string['gradehistorylifetime_help'] = 'Dette angiver, hvor lang tid du ønsker at bevare historikken med ændringer i karakterrelaterede tabeller. Det anbefales at bevare den så længe som muligt. Hvis du oplever problemer med ydeevnen eller har begrænset databaseplads, kan du prøve at fastsætte lavere værdi.';
$string['gradeimport'] = 'Import af karakterer';
$string['gradeimportfailed'] = 'Karakterimport fejlede. Detaljer:';
$string['gradeitem'] = 'Karakterelement';
$string['gradeitemaddusers'] = 'Undtag fra karaktergivning';
$string['gradeitemislocked'] = 'Denne aktivitet er låst i karakterbogen. Ændringer af karakterer i denne aktivitet kopieres ikke til karakterbogen før den er låst op.';
$string['gradeitemlocked'] = 'Karaktergivning er låst';
$string['gradeitemmembersselected'] = 'Undtaget fra karaktergivning';
$string['gradeitemminmax'] = 'Laveste og højeste karakterer er specificeret i indstillinger for karakterer';
$string['gradeitemnonmembers'] = 'Inkluderet i karaktergivning';
$string['gradeitemremovemembers'] = 'Inkluder i karaktergivning';
$string['gradeitems'] = 'Karakterelementer';
$string['gradeitemsettings'] = 'Indstillinger for karakterelementer';
$string['gradeitemsinc'] = 'Karakterelementer, der skal inkluderes';
$string['gradeletter'] = 'Karakterbogstav';
$string['gradeletter_help'] = 'Bogstavkarakterer er bogstaver, A, B, C... eller ord, for eksempel Udmærket, Bestået..., brugt som repræsentation for et interval af karakterer.';
$string['gradeletternote'] = 'For at slette et karakterbogstav skal du bare slette ét af de tre tekstfelter for det bogstav og klikke på gem.';
$string['gradeletteroverridden'] = 'Standard-karakterbogstaverne er pt. ignoreret.';
$string['gradeletters'] = 'Bogstavkarakterer';
$string['gradelocked'] = 'Karakteren er låst';
$string['gradelong'] = '{$a->grade}/{$a->max}';
$string['grademax'] = 'Højeste karakter';
$string['grademax_help'] = 'Indstillingen styrer den højeste karakter når man bruger karaktertypen værdi. Den højeste karakter for et aktivitetsbaseret karakterelement sættes på siden med aktivitetsindstillinger.';
$string['grademin'] = 'Laveste karakter';
$string['grademin_help'] = 'Indstilling for den laveste karakter når man bruger karaktertypen værdi.';
$string['gradenotificationmessage'] = 'Du har fået ny feedback på dit arbejde for "{$a}"';
$string['gradenotificationsubject'] = 'Du har fået karakter(er)';
$string['gradeoutcomeitem'] = 'Bedøm slutresultat';
$string['gradeoutcomes'] = 'Resultater';
$string['gradeoutcomescourses'] = 'Kursusresultater';
$string['gradepass'] = 'Karakter for bestået';
$string['gradepass_help'] = 'Indstillingen styrer minimumskarakteren for bestået. Værdien bruges i aktivitets- og kursusgennemførelse samt i karakterbogen, hvor karakterer for bestået fremhæves med grøn og ikke bestået med rød.';
$string['gradepassgreaterthangrade'] = 'Bedømmelsen til bestået kan ikke være højere end den højest mulige karakter {$a}';
$string['gradepenalty'] = 'Karakterstraffe';
$string['gradepenalty_enabledmodules'] = 'Aktiverede aktiviteter';
$string['gradepenalty_enabledmodules_help'] = 'Aktivér karakterstraffe for de valgte aktiviteter.';
$string['gradepenalty_indicator_info'] = 'Sen straf anvendt -{$a} point';
$string['gradepenalty_supportedplugins'] = 'Administrer understøttede aktiviteter';
$string['gradepointdefault'] = 'Standard karakterpoint';
$string['gradepointdefault_help'] = 'Indstillingen styrer standardværdien for den karakterværdi, der kan opnås i et karakterelement.';
$string['gradepointdefault_validateerror'] = 'Denne indstilling skal være et helt tal mellem 1 og den højeste karakter.';
$string['gradepointmax'] = 'Højeste karakter';
$string['gradepointmax_help'] = 'Indstillingen styrer hvor høj en karakter, der kan opnås i en aktivitet.';
$string['gradepointmax_validateerror'] = 'Denne indstilling skal være et helt tal mellem 1 og 10.000.';
$string['gradepreferences'] = 'Karakterindstillinger';
$string['gradepreferenceshelp'] = 'Hjælp til karakterindstillinger';
$string['gradepublishing'] = 'Aktiver publicering';
$string['gradepublishing_help'] = '';
$string['gradepublishinglink'] = 'Download: {$a}';
$string['gradereport'] = 'Karakterrapport';
$string['graderreport'] = 'Bedømmerrapport';
$string['grades'] = 'Karakterer';
$string['gradesforuser'] = '{$a->user}s karakterer';
$string['gradesmoduledeletionpendingwarning'] = 'Advarsel: Sletning af aktivitet i gang! Nogle karakterer er ved at blive fjernet.';
$string['gradesmoduledeletionprefix'] = '[Sletning i gang]';
$string['gradesonly'] = 'Vis kun karakterer';
$string['gradessettings'] = 'Karakterindstillinger';
$string['gradetype'] = 'Karaktertype';
$string['gradetype_help'] = 'Der er 4 typer af bedømmelse:

* Ingen - Ingen bedømmelse mulig
* Værdi - En numerisk værdi med maksimum og minimum
* Skala - Et element på en liste
* Tekst - Kun tekstfeedback.

Kun karaktertyperne værdi og skala kan lægges sammen. Karaktertypen for et aktivitetsbaseret karakterelement angives på aktivitetens indstillingsside.';
$string['gradevaluetoobig'] = 'En af karakterværdierne er større end den tilladte højeste karakter på {$a}';
$string['gradevaluetoosmall'] = 'En af karakterværdierne er mindre end den tilladte minimumskarakter på {$a}';
$string['gradeview'] = 'Vis karakter';
$string['gradewasmodifiedduringediting'] = 'Den indtastede karakter for {$a->itemname} til {$a->username} blev ignoreret, fordi den for nylig er blevet opdateret af en anden.';
$string['gradeweighthelp'] = 'Hjælp til karaktervægtning';
$string['gradingmodulename'] = 'Bedømmelse ({$a})';
$string['groupavg'] = 'Gruppegennemsnit';
$string['hidden'] = 'Skjult';
$string['hidden_help'] = 'Hvis feltet er markeret, skjules karakterer for de studerende. Der kan specificeres en dato for frigivelse af karakterer efter at karaktergivningen er fuldført.';
$string['hiddenasdate'] = 'Vis afleveringsdato for skjulte karakterer';
$string['hiddenasdate_help'] = 'Får en bruger ikke vist skjulte karakterer, vis da afleveringsdatoen i stedet for \'-\'.';
$string['hiddenuntil'] = 'Skjult indtil';
$string['hiddenuntildate'] = 'Skjult indtil: {$a}';
$string['hideadvanced'] = 'Skjul avancerede funktioner';
$string['hideaverages'] = 'Skjul gennemsnit';
$string['hidecalculations'] = 'Skjul beregning';
$string['hidecategory'] = 'Skjult';
$string['hideeyecons'] = 'Skjul vis/skjul-ikoner';
$string['hidefeedback'] = 'Skjul feedback';
$string['hideforcedsettings'] = 'Skjul tvungne indstillinger';
$string['hideforcedsettings_help'] = 'Vis ikke tvungne indstillinger i karakter-brugergrænsefladen.';
$string['hidegroups'] = 'Skjul grupper';
$string['hidelocks'] = 'Skjul låse';
$string['hidenooutcomes'] = 'Vis resultater';
$string['hidequickfeedback'] = 'Skjul hurtig feedback';
$string['hideranges'] = 'Skjul intervaller';
$string['hidetotalifhiddenitems'] = 'Skjul totaler hvis de indeholder skjulte elementer.';
$string['hidetotalifhiddenitems_help'] = 'Denne indstilling specificerer, hvorvidt totaler der indeholder skjulte karakterelementer, bliver vist til studerende eller erstattes af en bindestreg (-). Hvis totalen vises, kan den beregnes med eller uden skjulte elementer.

Hvis skjulte elementer ikke regnes med, vil totalen være forskellig fra den total læreren ser i bedømmerrapporten, eftersom læreren altid ser totaler der indeholder både skjulte og ikke skjulte elementer. Hvis skjulte elementer regnes med, kan studerende beregne de skjulte elementer.';
$string['hidetotalshowexhiddenitems'] = 'Vis totaler uden skjulte elementer.';
$string['hidetotalshowinchiddenitems'] = 'Vis totaler inklusiv skjulte elementer.';
$string['hideverbose'] = 'Skjul {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sorter efter højeste karakter stigende';
$string['highgradedescending'] = 'Sorter efter højeste karakter faldene';
$string['highgradeletter'] = 'Højt';
$string['identifier'] = 'Identificer bruger ved';
$string['idnumbers'] = 'Id-numre';
$string['ignore'] = 'Ignorer';
$string['import'] = 'Importer';
$string['importas'] = 'Importer som';
$string['importcsv'] = 'Importer CSV';
$string['importcsv_help'] = 'Karakterer kan importeres via en CSV-fil med følgende format:

* Hver linje i filen indeholder en post
* Hver post er en serie data adskilt af den valgte separator
* Den første linje indeholder en liste med feltnavne der definerer formatet for resten af filen
* Et feltnavn indeholdende brugeridentitetsdata er obligatorisk - enten brugernavn, ID-nummer eller e-mailadresse.

En fil i det korrekte format kan ses ved først at eksportere udvalgte karakterer. Denne fil kan herefter redigeres og gemmes som en CSV-fil.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importer som almindelige læringsmål (kun på dette kursus)';
$string['importdata'] = 'Data';
$string['importdata_help'] = 'Karakterer kan indsættes direkte fra et OpenDocument- eller Excel-regneark med følgende format:

* Mindst én kolonne skal indeholde oplysninger om brugerens identitet - brugernavn, e-mailadresse eller ID-nummer.
* De øvrige kolonner skal have overskrifter som for eksisterende aktiviteter eller karakterer.

Et korrekt formateret regneark kan fås ved først at eksportere nogle karakterer. Regnearket kan derefter redigeres for at tilføje flere karakterer og gemmes.

Vælg og kopier de kolonner, du ønsker at importere fra regnearket, og indsæt dem derefter i dette felt.';
$string['importerror'] = 'Der opstod en fejl. Skriptet blev ikke kaldt med de rigtige parametre.';
$string['importfailed'] = 'Importen mislykkedes. Der blev ikke hentet nogen data.';
$string['importfeedback'] = 'Importer feedback';
$string['importfile'] = 'Importer fil';
$string['importfilemissing'] = 'Der blev ikke modtaget en fil. Gå tilbage til formularen og sørg for at uploade en gyldig fil.';
$string['importfrom'] = 'Importer fra';
$string['importoutcomenofile'] = 'Den uploadede fil er tom eller skadet. Tjek om det er en gyldig fil. Problemet opstod på linje {$a}, dette udløses af at datalinjen ikke har så mange kolonner som den første linje (overskriften), eller hvis den importerede fil mangler de forventede overskrifter. I den eksporterede fil kan du se et eksempel på en fil med gyldig overskrift.';
$string['importoutcomes'] = 'Importer resultater';
$string['importoutcomes_help'] = 'Resultater kan importeres via en csv-fil med format som i den eksporterede csv-resultatfil.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importeret resultat "{$a->name}" med id #{$a->id}';
$string['importplugins'] = 'Importer plugins';
$string['importpreview'] = 'Forhåndsvisning af import';
$string['importsettings'] = 'Importer indstillinger';
$string['importskippednomanagescale'] = 'Du har ikke tilladelse til at tilføje en ny skala, så resultatet "{$a}" blev sprunget over, da det krævede at der blev oprettet en ny skala';
$string['importskippedoutcome'] = 'Et resultat med det korte navn "{$a}" findes allerede i denne kontekst, så det i den importerede fil blev sprunget over.';
$string['importstandard'] = 'Importer som standardresultater';
$string['importsuccess'] = 'Karakterimport lykkedes';
$string['importxml'] = 'Importer xml';
$string['includescalesinaggregation'] = 'Tag skalaer med i sammentællingen';
$string['includescalesinaggregation_help'] = 'Du kan ændre om skalaer skal inkluderes som tal i alle sammentalte karakterer i alle karakterbøger på alle kurser. ADVARSEL: Ændring af denne indstilling vil kræve, at alle sammentalte karakterer skal beregnes igen.';
$string['incorrectcourseid'] = 'Kursus-id var forkert';
$string['incorrectcustomscale'] = '(Ugyldig skræddersyet skala, den skal rettes.)';
$string['incorrectminmax'] = 'Minimum skal være mindre end maksimum ;-)';
$string['inherit'] = 'Nedarvet';
$string['intersectioninfo'] = 'Studerende/karakterinfo';
$string['invalidgradeexporteddate'] = 'Eksportdatoen er ugyldig fordi den er mere end et år gammel, ligger ude i fremtiden eller fordi formatet er ugyldigt.';
$string['item'] = 'Punkt';
$string['iteminfo'] = 'Info om element';
$string['iteminfo_help'] = 'Denne indstilling giver plads til at skrive information om elementet. Informationen vises ikke andre steder.';
$string['itemname'] = 'Elementnavn';
$string['itemnamehelp'] = 'Navn på dette element fra modulet.';
$string['items'] = 'Punkter';
$string['itemsedit'] = 'Rediger karakterelement';
$string['keephigh'] = 'Behold den højeste';
$string['keephigh_help'] = 'Er indstillingen specificeret, vil muligheden kun beholde de X højeste karakterer, hvor X er den valgte værdi til denne mulighed.';
$string['keephighestvalues'] = 'Behold de {$a} højeste værdier';
$string['keymanager'] = 'Nøgleadministrator';
$string['lessthanmin'] = 'Den valgte karakter for {$a->itemname} for {$a->username} er mindre end det tilladte minimum';
$string['letter'] = 'Bogstav';
$string['lettergrade'] = 'Bogstavkarakter';
$string['lettergradenonnumber'] = 'Lav og/eller høj karakter var ikke-numerisk for';
$string['letterpercentage'] = 'Bogstav (procentdel)';
$string['letterreal'] = 'Bogstav (faktisk)';
$string['letters'] = 'Bogstaver';
$string['linkedactivity'] = 'Linket aktivitet';
$string['linkedactivity_help'] = 'Indstillingen styrer en aktivitet hvortil resultatelement er forbundet. Dette kan bruges til at måle de studerendes præstation på kriterier, som ikke er vurderet af aktivitetens karakter.';
$string['linktoactivity'] = '{$a->name} aktivitet {$a->title}';
$string['lock'] = 'Lås';
$string['locked'] = 'Låst';
$string['locked_help'] = 'Er feltet markeret, kan karakterer ikke længere opdateres automatisk af den relaterede aktivitet.';
$string['locktime'] = 'Lås efter';
$string['locktimedate'] = 'Låst efter: {$a}';
$string['lockverbose'] = 'Lås {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Laveste';
$string['lowgradeletter'] = 'Lav';
$string['manageoutcomes'] = 'Administrer resultater';
$string['managepenaltyplugins'] = 'Administrer straf-plugins';
$string['manualitem'] = 'Manuelt element';
$string['mapfrom'] = 'Tilknyt fra';
$string['mapfrom_help'] = 'Angiv hvilken kolonne i regnearket der identificerer brugeren med data såsom brugernavn, bruger-id eller e-mailadresse';
$string['mappings'] = 'Karakterelementtilknytninger';
$string['mappings_help'] = 'Vælg for hver kolonne i regnearket hvilket korresponderende karakterelement karaktererne skal importeres til.';
$string['mapto'] = 'Knyt til';
$string['mapto_help'] = 'Vælg samme identifikationsdata som valgt i "Tilknyt fra".';
$string['max'] = 'Højeste';
$string['maxgrade'] = 'Højeste karakter';
$string['meanall'] = 'Alle karakterer';
$string['meangraded'] = 'Ikke-tomme karakterer';
$string['meanselection'] = 'Karakterer valgt til kolonnegennemsnit';
$string['meanselection_help'] = 'Indstillingen styrer, om celler uden karakterer skal inkluderes når man beregner gennemsnittet (middelværdi) for hver kategori eller karakterelement.';
$string['median'] = 'Median';
$string['min'] = 'Laveste';
$string['minimum_show'] = 'Vis mindste karakter';
$string['minimum_show_help'] = 'Mindste karakter bruges til at beregne karakterer og vægtninger. Hvis den ikke vises, vil den mindste karakter som standard være nul og kan ikke redigeres.';
$string['minmaxtouse'] = 'Laveste og højeste karakterer brugt i beregningen';
$string['minmaxtouse_desc'] = 'Indstillingen styrer hvorvidt man skal bruge den oprindelige laveste eller højeste karakter fra da karakteren blev givet, eller den laveste og højeste karakter som angivet i indstillingerne for karakter, når man beregner karakteren som vises i karakterbogen. Det anbefales at ændringen af indstillingerne foretages udenfor perioder med spidsbelastning, da alle karakter genberegnes og det kan resultere i en høj serverbelastning.';
$string['minmaxtouse_help'] = 'Indstillingen styrer hvorvidt man skal bruge den oprindelige laveste eller højeste karakter fra da karakteren blev givet, eller den laveste og højeste karakter som angivet i indstillingerne for karakter, når man beregner karakteren som vises i karakterbogen.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Bemærk: Nogle karakterer er blevet ændret for at løse en uregelmæssighed i karakterbogen, som er opstået ved ændring i laveste og højeste karakterer der bruges ved beregning af den viste karakter. Det anbefales at ændringerne gennemgås og godkendes.';
$string['minmaxupgradefixbutton'] = 'Løs uregelmæssigheder';
$string['minmaxupgradewarning'] = 'Bemærk: Der er fundet uregelmæssigheder ved nogle karakterer grundet en ændring i laveste og højeste karakterer, som bruges ved beregning af karakteren i den viste karakterbog. Det anbefales at uregelmæssigheden bliver rettet ved at trykke på knappen nedenunder, selvom det betyder, at nogle af karaktererne bliver ændret.';
$string['missingitemtypeoreid'] = 'Der mangler en område-nøgle (itemtype eller eid)';
$string['missingscale'] = 'Der skal vælges en skala';
$string['mode'] = 'Tilstand';
$string['modgrade'] = 'Karakter';
$string['modgrade_help'] = 'Vælg hvilken type bedømmelse der skal bruges til denne aktivitet. Vælges "skala", kan du vælge den fra rullemenuen. Hvis du bruger "point", kan du indsætte den højset mulige karakter for denne aktivitet.';
$string['modgradecantchangegradetype'] = 'Du kan ikke ændre typen eftersom karakterer allerede eksisterer for dette emne.';
$string['modgradecantchangegradetypemsg'] = 'Nogle karakterer er allerede tildelt, så karaktertypen kan ikke ændres. Hvis du ønsker at ændre maksimumkarakteren, må du først vælge om du ønsker at reskalere eksisterende karakterer.';
$string['modgradecantchangegradetyporscalemsg'] = 'Nogle karakterer er allerede tildelt, så karaktertype og -skala kan ikke ændres.';
$string['modgradecantchangeratingmaxgrade'] = 'Du kan ikke ændre maksimumkarakter når der allerede eksisterer karakterer for en aktivitet med bedømmelser.';
$string['modgradecantchangescale'] = 'Du kan ikke ændre skalaen da der allerede er givet karakterer med den.';
$string['modgradecategorycantchangegradetypemsg'] = 'Denne kategori har tilknyttet karakterelementer som er blevet overskrevet. Derfor er der allerede tildelt nogle karakterer, og karaktertypen kan ikke ændres. Ønsker at du at ændre maksimumkarakteren skal du først vælge om du ønsker at reskalere eksisterende karakterer.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Denne kategori har tilknyttet karakterelementer som er blevet overskrevet. Derfor er der allerede tildelt nogle karakterer og karaktertype og skala kan ikke ændres.';
$string['modgradecategoryrescalegrades'] = 'Reskaler overskrevne karakterer';
$string['modgradecategoryrescalegrades_help'] = 'Når du ændrer de højeste karakterer for et karakterbogselement, skal du angive hvorvidt det skal medføre at de procentuelle karakterer også ændres.

Vælger du  "Ja", vil enhver eksisterende overskrevet karakter blive reskaleret så den procentuelle karakter forbliver den samme. Hvis for eksempel denne mulighed er angivet til "Ja", vil en ændring af maksimumkarakteren for et element fra 10 til 20 medføre, at en karakter på 6/10 (60%) blive reskaleret til 12/20 (60%).

Vælges "Nej", vil karakteren forblive uændret, og manuel regulering af karaktererne er påkrævet for at sikre korrekte karakterer.';
$string['modgradedonotmodify'] = 'Ændr ikke eksisterende karakterer.';
$string['modgradeerrorbadpoint'] = 'Ugyldig karakterværdi. Den skal være et helt tal mellem 1 og {$a}';
$string['modgradeerrorbadscale'] = 'Ugyldig skala valgt. Sørg for at vælge en skala fra listen nedenfor.';
$string['modgrademaxgrade'] = 'Højeste karakter';
$string['modgraderecalculatepenalty'] = 'Genberegn straf';
$string['modgraderecalculatepenalty_help'] = 'Straffen vil blive genberegnet for alle brugere.';
$string['modgraderescalegrades'] = 'Reskaler eksisterende karakterer.';
$string['modgraderescalegrades_help'] = 'Når du ændrer de maksimale karakterer for et karakterbogselement, skal du angive hvorvidt det skal medføre at de procentuelle karakterer også ændres.

Vælger du "Ja", vil enhver eksisterende overskrevet karakterer blive reskaleret så den procentuelle karakter forbliver den samme.

Hvis for eksempel denne mulighed er angivet til "Ja" vil en ændring af maksimumkarakteren for et element fra 10 til 20 medføre, at en karakter på 6/10 (60%) bliver reskaleret til 12/20 (60%). Vælger du "Nej", vil karakteren forblive uændret, og manuel regulering af karaktererne er påkrævet for at sikre korrekte karakterer.';
$string['modgradetype'] = 'Type';
$string['modgradetypenone'] = 'Ingen';
$string['modgradetypepoint'] = 'Point';
$string['modgradetypescale'] = 'Skala';
$string['morethanmax'] = 'Den karakter, der er indtastet for {$a->itemname} for {$a->username} er højere end det højest tilladte';
$string['moveselectedto'] = 'Flyt valgte emner til:';
$string['movesitems'] = 'Flyt elementer';
$string['movingelement'] = 'Flytter {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = 'Multiplikatoren er den faktor alle karakterer for dette karakterelement bliver ganget med med en maksimumværdi som højeste karakter. Hvis for eksempel multiplikatoren er 2 og den højeste karakter er 100, så vil alle karakterer under 50 blive ganget med 2, og alle karakterer på 50 og derover blive ændret til 100.';
$string['multfactorvalue'] = 'Multiplikatorværdi for {$a}';
$string['mustchooserescaleyesorno'] = 'Du skal vælge om eksisterende karakterer skal reskaleres.';
$string['mygrades'] = 'Brugermenu, link til karakterer';
$string['mygrades_desc'] = 'Denne indstilling gør det muligt at linke til en ekstern karkakterbog fra brugermenuen.';
$string['mypreferences'] = 'Mine indstillinger';
$string['myreportpreferences'] = 'Mine rapportindstillinger';
$string['myself'] = 'Mig selv';
$string['neverdeletehistory'] = 'Slet aldrig historikken';
$string['newcategory'] = 'Ny kategori';
$string['newitem'] = 'Nyt karakterelement';
$string['newoutcomeitem'] = 'Nyt resultatelement';
$string['no'] = 'Nej';
$string['nocategories'] = 'Karakterkategorier kunne ikke tilføjes eller findes på dette kursus';
$string['nocategoryname'] = 'Der blev ikke givet noget kategorinavn.';
$string['nocategoryview'] = 'Ingen kategori at vise efter';
$string['nocourses'] = 'Der er endnu ingen kurser';
$string['noexistingoutcomes'] = 'Der er ingen eksisterende resultater.';
$string['noexistingscales'] = 'Der er ingen eksisterende skalaer.';
$string['noforce'] = 'Gennemtving ikke';
$string['nogradeletters'] = 'Ingen karakterbogstaver sat';
$string['nogradesreturned'] = 'Ingen karakterer returneret';
$string['noidnumber'] = 'Intet id-nummer';
$string['nolettergrade'] = 'Ingen bogstavkarakterer for';
$string['nomode'] = 'N/A';
$string['nonnumericweight'] = 'Modtog en ikke-numerisk værdi for';
$string['nonunhideableverbose'] = 'For at vise denne karakter skal du åbne {$a->itemname}.';
$string['nonunlockableverbose'] = 'Denne karakter kan ikke låses op før {$a->itemname} låses op.';
$string['nonweightedpct'] = 'Ikke vægtet %';
$string['nooutcome'] = 'Intet slutresultat';
$string['nooutcomes'] = 'Resultatelementer skal relateres til slutresultatet på et kursus, men der er ingen slutresultater på dette kursus. Vil du tilføje et?';
$string['nopermissiontoresetweights'] = 'Ingen tilladelse til at nulstille vægtningerne';
$string['nopublish'] = 'Publicer ikke';
$string['noreports'] = 'Du er ikke tilmeldt eller underviser i nogen kurser på dette site.';
$string['norolesdefined'] = 'Ingen roller defineret i Administration > Karakterer > Generelle indstillinger > Bedømte roller';
$string['noscales'] = 'Slutresultater skal relateres til en kursusskala eller en global skala, men der er ingen. Vil du tilføje en?';
$string['noselectedcategories'] = 'ingen kategorier blev valgt.';
$string['noselecteditems'] = 'ingen elementer blev valgt.';
$string['notenrolled'] = 'For øjeblikket er du ikke tilmeldt nogen kurser.';
$string['notteachererror'] = 'Du skal være lærer for at benytte denne funktion.';
$string['nousersloaded'] = 'Ingen brugere indlæst';
$string['nouserstograde'] = 'Ingen brugere at give karakter';
$string['numberofgrades'] = 'Antal karakterer';
$string['onascaleof'] = 'på en skala fra {$a->grademin} til {$a->grademax}';
$string['operations'] = 'Operationer';
$string['options'] = 'Valgmuligheder';
$string['originalgrade'] = 'Oprindelig karakter';
$string['others'] = 'Andre';
$string['otheruser'] = 'Bruger';
$string['outcome'] = 'Resultat';
$string['outcome_help'] = 'Denne indstilling styrer det slutresultat hvis karakterelement vil blive vist i karakterbogen.';
$string['outcomeassigntocourse'] = 'Tildel kurset et nyt resultat';
$string['outcomecategory'] = 'Opret slutresultater i kategori';
$string['outcomecategorynew'] = 'Ny kategori';
$string['outcomeconfirmdelete'] = 'Er du sikker på, du vil slette slutresultatet "{$a}"?';
$string['outcomecreate'] = 'Tilføj et nyt resultat';
$string['outcomedelete'] = 'Slet resultatet';
$string['outcomefullname'] = 'Fulde navn';
$string['outcomeitem'] = 'Resultatelement';
$string['outcomeitemsedit'] = 'Rediger resultatelement';
$string['outcomereport'] = 'Resultatrapport';
$string['outcomes'] = 'Resultater';
$string['outcomescourse'] = 'Resultater brugt på kurset';
$string['outcomescoursecustom'] = 'Anvendt søgning (ingen fjernelse)';
$string['outcomescoursenotused'] = 'Standard ikke brugt';
$string['outcomescourseused'] = 'Standard brugt (ingen fjernelse)';
$string['outcomescustom'] = 'Brugerdefinerede resultater';
$string['outcomesdisabled'] = 'Resultater er ikke aktiverede';
$string['outcomeshortname'] = 'Kort navn';
$string['outcomesstandard'] = 'Standard-resultater';
$string['outcomesstandardavailable'] = 'Tilgængelige standard-resultater';
$string['outcomestandard'] = 'Standard-resultat';
$string['outcomestandard_help'] = 'Et standard-resultat er tilgængeligt på hele sitet for alle kurser.';
$string['overallaverage'] = 'Samlet gennemsnit';
$string['overridden'] = 'Tilsidesat';
$string['overridden_help'] = 'Er feltet markeret, kan karakteren ikke længere ændres i den relaterede aktivitet. Når en karakter redigeres i bedømmerrapporten, bliver tjekboksen "tilsidesat" automatisk markeret. Markeringen kan dog fjernes for at tillade at karakteren kan ændres via den relaterede aktivitet.';
$string['overriddennotice'] = 'Din endelige karakter fra denne aktivitet blev justeret manuelt.';
$string['overridecat'] = 'Tillad at kategorikarakterer tilsidesættes manuelt';
$string['overridecat_help'] = 'Deaktiveres indstillingen, bliver det umuligt for brugere at tilpasse kategorikarakterer.';
$string['overridesitedefaultgradedisplaytype'] = 'Opret undtagelse(r) til standardindstillinger for sitet';
$string['overridesitedefaultgradedisplaytype_help'] = 'Markeres feltet, kan bogstavkarakterer og grænser for kurset specificeres i stedet for at bruge sitets standardindstillinger.';
$string['overrideweightofa'] = 'Vægtningundtagelse af {$a}';
$string['parentcategory'] = 'Overordnet kategori';
$string['pass'] = 'Bestå';
$string['pctoftotalgrade'] = '% af total karakter';
$string['percent'] = 'Procent';
$string['percentage'] = 'Procentdel';
$string['percentageletter'] = 'Procentdel (bogstav)';
$string['percentagereal'] = 'Procentdel (faktisk)';
$string['percentascending'] = 'Sorter stigende efter procenter';
$string['percentdescending'] = 'Sorter faldene efter procenter';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Modregning';
$string['plusfactor_help'] = 'Modregningen er et tal, som lægges til hver karakter for dette karakterelement, efter at multiplikatoren er anvendt.';
$string['plusfactorvalue'] = 'Modregningsværdi for {$a}';
$string['points'] = 'point';
$string['pointsascending'] = 'Sorter stigende efter point';
$string['pointsdescending'] = 'Sorter faldene efter point';
$string['positionfirst'] = 'Først';
$string['positionlast'] = 'Sidst';
$string['preferences'] = 'Indstillinger';
$string['prefgeneral'] = 'Generel';
$string['prefletters'] = 'Karakterbogstaver og grænser';
$string['prefrows'] = 'Specielle rækker';
$string['prefshow'] = 'Vis/gem-knapper';
$string['previewrows'] = 'Forhåndsvis rækker';
$string['privacy:metadata:categorieshistory'] = 'En registrering af tidligere versioner af karakterkategorier';
$string['privacy:metadata:filepurpose'] = 'Feedbackfiler opbevaret i karakterbogen for en bruger.';
$string['privacy:metadata:grade_import_newitem'] = 'Midlertidig tabel til opbevaring af nye grade_item-navne fra karakterimport';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'En unik batchkode til at identificere en batch af importer';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Bruger, der importerer dataene';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nyt navn på karakterelement';
$string['privacy:metadata:grade_import_values'] = 'Midlertidig tabel til import af karakterer';
$string['privacy:metadata:grade_import_values:feedback'] = 'Karakter tilbagemelding';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Rå karakterværdi';
$string['privacy:metadata:grade_import_values:importcode'] = 'En unik batchkode til identificering af en enkelt importbatch';
$string['privacy:metadata:grade_import_values:importer'] = 'Bruger, der importerer dataene';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Flag, hvis kun feedback blev importeret';
$string['privacy:metadata:grade_import_values:userid'] = 'Bruger hvis karakterer blev importeret';
$string['privacy:metadata:grades'] = 'En registrering af karakterer';
$string['privacy:metadata:grades:aggregationstatus'] = 'Aggregeringsstatus';
$string['privacy:metadata:grades:aggregationweight'] = 'Vægten i aggregeringen';
$string['privacy:metadata:grades:feedback'] = 'Tilbagemeldingen';
$string['privacy:metadata:grades:finalgrade'] = 'Karakteren';
$string['privacy:metadata:grades:information'] = 'Yderligere information om karakteren';
$string['privacy:metadata:grades:timemodified'] = 'Tidspunktet for seneste ændring af karakteren';
$string['privacy:metadata:grades:userid'] = 'Bruger-ID for den, hvis karakter det er';
$string['privacy:metadata:grades:usermodified'] = 'Bruger-ID for den, der sidst ændrede posten';
$string['privacy:metadata:gradeshistory'] = 'En registrering af de tidligere karakterer';
$string['privacy:metadata:history:loggeduser'] = 'Bruger-ID for den, der var logget ind, da versioneringen skete';
$string['privacy:metadata:history:timemodified'] = 'Tidspunktet for, hvornår karakterversioneringen skete';
$string['privacy:metadata:itemshistory'] = 'En registrering af tidligere versioner af karakterelementer';
$string['privacy:metadata:outcomes'] = 'En registrering af resultater';
$string['privacy:metadata:outcomes:timemodified'] = 'Tidspunktet for, hvornår posten blev ændret';
$string['privacy:metadata:outcomes:usermodified'] = 'Brugeren, der sidst ændrede posten';
$string['privacy:metadata:outcomeshistory'] = 'En registrering af tidligere versioner af resultater';
$string['privacy:metadata:scale'] = 'En registrering af skalaer';
$string['privacy:metadata:scale:timemodified'] = 'Tidspunktet for sidste ændring af optegnelsen';
$string['privacy:metadata:scale:userid'] = 'Brugeren, der sidst ændrede optegnelsen';
$string['privacy:metadata:scalehistory'] = 'En optegnelse over tidligere versioner af skalaer';
$string['privacy:path:relatedtome'] = 'Relateret til mig';
$string['privacy:request:historyactiondelete'] = 'Slet';
$string['privacy:request:historyactioninsert'] = 'Indsæt';
$string['privacy:request:historyactionupdate'] = 'Opdater';
$string['privacy:request:unknowndeletedgradeitem'] = 'Ukendt (karakterelementet blev slettet)';
$string['profilereport'] = 'Brugerprofilrapport';
$string['profilereport_help'] = 'Karakterrapport brugt på brugerprofilside';
$string['publishing'] = 'Publicerer';
$string['publishingoptions'] = 'Indstillinger for udgivelse af karakterer';
$string['quickfeedback'] = 'Hurtig feedback';
$string['quickgrading'] = 'Hurtig bedømmelse';
$string['quickgrading_help'] = 'Hvis dette er aktiveret og redigering er slået til, vises en inputboks til hver karakter, som gør det muligt at redigere mange karakterer samtidig. Ændringer gemmes og fremhæves når der klikkes på \'opdater\'.

Bemærk, at når en karakter redigeres i karakterrapporten, vises et overskrivningsflag, hvilket betyder, at karakteren ikke længere kan ændres inde fra den relaterede aktivitet.';
$string['range'] = 'Interval';
$string['rangedecimals'] = 'Antal decimaler i skalaen';
$string['rangedecimals_help'] = 'Antallet af decimaler der skal vises.';
$string['rangesdecimalpoints'] = 'Decimaler vist i intervaller';
$string['rangesdecimalpoints_help'] = 'Indstillingen styrer antal decimaler der skal vises for hvert interval, eller om den generelle indstilling af decimaler for kategorien eller karakterelementet skal bruges (nedarves).';
$string['rangesdisplaytype'] = 'Interval-displaytype';
$string['rangesdisplaytype_help'] = 'Indstillingen styrer om intervallet vises som faktiske karakterer, procenter eller bogstaver, eller om displaytype for kategorien eller karakterelementet bruges (nedarves).';
$string['rank'] = 'Opstil';
$string['rawpct'] = 'Råt %';
$string['real'] = 'Faktisk';
$string['realletter'] = 'Faktisk (bogstav)';
$string['realpercentage'] = 'Faktisk (procentdel)';
$string['recalculatepenalty'] = 'Genberegn straffe';
$string['recalculatepenaltyconfirm'] = 'Dette vil genberegne og anvende straffe for alle afleveringer i denne kontekst. Er du sikker på, at du vil fortsætte?';
$string['recalculatepenaltysuccess'] = 'Gennemførelse af strafgenberegning er startet. Der kan være en forsinkelse, før karaktererne opdateres.';
$string['recalculatinggrades'] = 'Genberegner karakterer';
$string['recalculatinggradesadhoc'] = 'Rapporten vil blive opdateret automatisk. Du behøver ikke gøre noget.';
$string['recovergradesdefault'] = 'Gendan karakterstandard';
$string['recovergradesdefault_help'] = 'Gendan som standard gamle karakterer når en bruger gentilmeldes et kursus.';
$string['refreshpreview'] = 'Genindlæs visning';
$string['regradeanyway'] = 'Bedøm igen under alle omstændigheder';
$string['removeallcoursegrades'] = 'Alle karakterer';
$string['removeallcoursegrades_help'] = 'Er feltet markeret, slettes alle karakterelementer og karakterer, der blev tilføjet manuelt til karakterbogen, samt data om tilsidesatte, udeladte, skjulte og låste karakterer. Kun karakterelementer og karakterer, der er knyttet til aktiviteter, forbliver tilbage.';
$string['removeallcourseitems'] = 'Alle elementer og kategorier';
$string['removeallcourseitems_help'] = 'Er feltet markeret, vil alle kategorier og karakterelementer som er føjet til karakterbogen manuelt, blive slettet sammen med karakterer og data om tilsidesatte, udelukkede, skjulte og låste karakterer. Kun karakterelementer der er knyttet til aktiviteter, vil bevares.';
$string['report'] = 'Rapport';
$string['reportdefault'] = 'Rapport standard ({$a})';
$string['reportplugins'] = 'Rapport-plugins';
$string['reportsettings'] = 'Rapportindstillinger';
$string['reprintheaders'] = 'Genskriv overskrifter';
$string['resetweights'] = 'Nulstil vægtning af {$a->itemname}';
$string['resetweightsshort'] = 'Nulstil vægtning';
$string['respectingcurrentdata'] = 'nuværende konfiguration ændres ikke';
$string['rowpreviewnum'] = 'Forhåndsvis rækker';
$string['rowpreviewnum_help'] = 'Data til import kan gennemses før importen bekræftes. Denne indstilling angiver hvor mange rækker der skal vises i forhåndsvisningen.';
$string['savechanges'] = 'Gem ændringer';
$string['savepreferences'] = 'Gem indstillinger';
$string['scaleconfirmdelete'] = 'Er du sikker på, du vil slette skalaen "{$a}"?';
$string['scaledpct'] = 'Skaleret  %';
$string['searchcollapsedcolumns'] = 'Søg sammenklappede kolonner';
$string['seeallcoursegrades'] = 'Se alle bedømmelser på kurset';
$string['select'] = 'Vælg {$a}';
$string['selectalloroneuser'] = 'Vælg alle eller en bruger';
$string['selectauser'] = 'Vælg en bruger';
$string['selectdestination'] = 'Vælg destination af {$a}';
$string['selectgrouplink'] = 'Vælg en gruppe';
$string['selectuserlink'] = 'Vælg en bruger';
$string['separator'] = 'Separator';
$string['separator_help'] = 'Vælg hvilken separator der bruges i csv-filen. (Som regel et komma).';
$string['sepcolon'] = 'Kolon';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Faneblad';
$string['setcategories'] = 'Sæt kategorier';
$string['setcategorieserror'] = 'Du skal først sætte kategorier for dit kursus før du kan give dem en vægtning.';
$string['setgradeletters'] = 'Sæt karakterbogstaver';
$string['setpreferences'] = 'Sæt indstillinger';
$string['setting'] = 'Indstilling';
$string['settings'] = 'Indstillinger';
$string['setup'] = 'Opsætning';
$string['setweights'] = 'Sæt vægtning';
$string['showallgrades'] = 'Vis alle karakterer';
$string['showallhidden'] = 'Vis skjulte';
$string['showallstudents'] = 'Vis alle studerende';
$string['showaverage'] = 'Vis gennemsnit';
$string['showaverage_help'] = 'Hvorvidt en kolonne med gennemsnit skal vises. Bemærk at deltagerne vil kunne anslå andres karakterer, hvis gennemsnittet beregnes fra et lille antal karakterer. Af ydelsesmæssige hensyn er gennemsnittet omtrentligt hvis det afhænger af skjulte elementer.';
$string['showaverages'] = 'Vis gennemsnit for kolonner';
$string['showaverages_help'] = 'Hvis dette er aktiveret, vil bedømmerrapporten indeholde en ekstra række, som viser gennemsnittet (middelværdi) for hver kategori og karakterelement.';
$string['showcontributiontocoursetotal'] = 'Vis bidrag til kursustotal';
$string['showcontributiontocoursetotal_help'] = 'Hvorvidt der vises en kolonne med procenter der angiver hvor meget hvert karakterelement bidrager til brugerens totale procentdel på kurset (efter at vægtning er anvendt).';
$string['showfeedback'] = 'Vis feedback';
$string['showfeedback_help'] = 'Hvorvidt en kolonne med feedback vises.';
$string['showgrade'] = 'Vis karakterer';
$string['showgrade_help'] = 'Hvorvidt en kolonne med karakterer vises.';
$string['showgroups'] = 'Vis grupper';
$string['showhiddenitems'] = 'Vis skjulte elementer';
$string['showhiddenitems_help'] = 'Hvorvidt skjulte karakterelementer er helt skjulte, eller om navnene på skjulte karakterelementer er synlige for studerende.

* Vis skjulte - navne på skjulte karakterelementer vises, men de studerendes karakterer er skjult
* Kun skjult indtil - Karakterelementer, der har en "skjult indtil"-dato, bliver skjult helt indtil den angivne dato, hvorefter hele elementet vises
* Vis ikke - Skjulte karakterelementer skjules helt';
$string['showhiddenuntilonly'] = 'Kun skjult indtil';
$string['showingaggregatesonly'] = 'Viser kun totaler';
$string['showingfullmode'] = 'Viser karakterer og totaler';
$string['showinggradesonly'] = 'Viser kun karakterer';
$string['showlettergrade'] = 'Vis bogstavkarakterer';
$string['showlettergrade_help'] = 'Hvorvidt en kolonne med bogstavkarakterer vises.';
$string['shownohidden'] = 'Vis ikke';
$string['shownooutcomes'] = 'Skjul resultater';
$string['shownumberofgrades'] = 'Vis antallet af karakterer i gennemsnit';
$string['shownumberofgrades_help'] = 'Er indstillingen aktiveret, vil det antal karakterer der bruges når gennemsnittet (middelværdien) beregnes, blive vist i en parentes efter hvert gennemsnit.';
$string['showonlyactiveenrol'] = 'Vis kun aktive deltagere';
$string['showonlyactiveenrol_help'] = 'Indstillingen styrer, om kun aktive deltagere er synlige i karakterbogsrapporten. Er indstillingen aktiveret, vil suspenderede brugere ikke blive vist i karakterbogen.';
$string['showpercentage'] = 'Vis procentdel';
$string['showpercentage_help'] = 'Hvorvidt procentværdien af hvert karakterelement vises.';
$string['showrange'] = 'Vis intervaller';
$string['showrange_help'] = 'Hvorvidt en kolonne med intervallet vises.';
$string['showranges'] = 'Vis intervaller';
$string['showranges_help'] = 'Hvis dette er aktiveret, vil karakterrapporten indeholde en ekstra række, der viser intervallet for hver kategori og karakterelement.';
$string['showrank'] = 'Vis rang';
$string['showrank_help'] = 'Hvorvidt den studerendes placering i forhold til resten af klassen vises for hvert karakterelement.';
$string['showuserimage'] = 'Vis brugernes profilbilleder';
$string['showuserimage_help'] = 'Hvorvidt brugerens profilbillede skal vises ved siden af navnet i karakterrapporten.';
$string['showverbose'] = 'Vis {$a->category}$a->itemmodule {$a->itemname}';
$string['showweight'] = 'Vis vægtninger';
$string['showweight_help'] = 'Hvorvidt en kolonne med karaktervægtning vises.';
$string['simpleview'] = 'Enkeltvisning';
$string['sitewide'] = 'På hele sitet';
$string['sort'] = 'sorter';
$string['sortasc'] = 'Vis i stigende rækkefølge';
$string['sortbyfirstname'] = 'Sorter efter fornavn';
$string['sortbylastname'] = 'Sorter efter efternavn';
$string['sortdesc'] = 'Vis i faldende rækkefølge';
$string['standarddeviation'] = 'Standardafvigelse';
$string['stats'] = 'Statistik';
$string['statslink'] = 'Statistik';
$string['student'] = 'Studerende';
$string['studentsperpagereduced'] = 'Reduceret maks. studerende pr. side fra {$a->originalstudentsperpage} til {$a->studentsperpage}. Overvej at forhøje php-indstillingen  max_input_vars fra {$a->maxinputvars}.';
$string['subcategory'] = 'Normal kategori';
$string['submissions'] = 'Afleveringer';
$string['submittedon'] = 'Afleveret: {$a}';
$string['sumofgradesupgradedgrades'] = 'Bemærk: Sammentællingsmetoden "Summen af karakterer" er blevet ændret til "Naturlig" som led i en opdatering af sitet. Da "Summen af karakterer" tidligere blev brugt på dette kursus, anbefales det at du gennemgår denne ændring i karakterbogen.';
$string['switchtofullview'] = 'Skift til fuld visning';
$string['switchtosimpleview'] = 'Skift til enkeltvisning';
$string['topcategory'] = 'Overkategori';
$string['total'] = 'Totalt';
$string['totalweight100'] = 'Den totale vægt svarer til 100';
$string['totalweightnot100'] = 'Den totale vægt svarer ikke til 100';
$string['turnfeedbackoff'] = 'Slå feedback\'en fra';
$string['turnfeedbackon'] = 'Slå feedback\'en til';
$string['typenone'] = 'Ingen';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Indstillingen styrer hvilken skala der bliver brugt når man bruger skala-karaktertypen. Skalaen for et aktivitetsbaseret karakterelement sættes på aktivitetens indstillingsside.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Værdi';
$string['uncategorised'] = 'Ukategoriseret';
$string['unchangedgrade'] = 'Karakter uændret';
$string['unenrolledusersinimport'] = 'Denne import inkluderede følgende karakterer for brugere, som ikke p.t. er tilmeldt kurset {$a}';
$string['unlimitedgrades'] = 'Ubegrænsede karakterer';
$string['unlimitedgrades_help'] = 'Som standard afgrænses karakter af højeste og laveste værdi for et karakterelement. Aktiveres denne indstilling, fjernes afgrænsningen og karakterer over 100% kan indsættes direkte i karakterbogen.';
$string['unlock'] = 'Lås op';
$string['unlockverbose'] = 'Lås {$a->category} {$a->itemmodule} {$a->itemname} op';
$string['unused'] = 'Ikke brugt';
$string['updatedgradesonly'] = 'Eksporter kun nye eller opdaterede karakterer';
$string['upgradedgradeshidemessage'] = 'Afvis notits';
$string['upgradedminmaxrevertmessage'] = 'Vend tilbage til ændringerne';
$string['uploadgrades'] = 'Upload karakterer';
$string['useadvanced'] = 'Brug avancerede funktioner';
$string['usedcourses'] = 'Anvendte kurser';
$string['usedgradeitem'] = 'Brugt karakterelement';
$string['usenooutcome'] = 'Brug intet resultat';
$string['usenoscale'] = 'Brug ingen skala';
$string['usepercent'] = 'Brug procenter';
$string['user'] = 'Bruger';
$string['userenrolmentsuspended'] = 'Tilmelding af brugere suspenderet';
$string['userfields_show'] = 'Vis bruger-felter';
$string['userfields_show_help'] = 'Vis yderligere bruger-felter såsom e-mailadresse på karakterrapporten. De felter der vises, styres af site-indstillingen "vis brugeridentitet"';
$string['usergrade'] = 'Bruger {$a->fullname} ({$a->useridnumber}) på element {$a->gradeidnumber}';
$string['userid'] = 'Bruger-id';
$string['useridnumberwarning'] = 'Brugere uden id-nummer udelukkes fra eksporten, da de ikke kan importeres';
$string['usermappingerror'] = 'Fejl på brugertilknytning: Kunne ikke finde en bruger med værdien "{$a->value}" på {$a->field}.';
$string['usermappingerrorcurrentgroup'] = 'Brugeren er ikke medlem af denne gruppe.';
$string['usermappingerrormultipleusersfound'] = 'Brugermappingsfejl: Flere brugere fundet med {$a->field} værdien "{$a->value}". Brug venligst et mere unikt mappingsfelt.';
$string['usermappingerrorusernotfound'] = 'Fejl på brugertilknytning. Fandt ikke brugeren.';
$string['userpreferences'] = 'Brugerens foretrukne';
$string['useweighted'] = 'Brug vægtet';
$string['verbosescales'] = 'Beskrivende skala';
$string['verbosescales_help'] = 'En beskrivende skala bruger ord fremfor tal. Angiv som "Ja" hvis du ønsker at både numeriske og beskrivende skalaer skal importeres. Vælg "Nej" hvis kun numeriske skalaer skal importeres.';
$string['viewas'] = 'Vis rapport som';
$string['viewbygroup'] = 'Gruppe';
$string['viewfeedback'] = 'Vis tilbagemelding';
$string['viewgrades'] = 'Vis karakterer';
$string['weight'] = 'Vægt';
$string['weight_help'] = 'En værdi, der bruges til at bestemme den relative værdi af flere karakterelementer i en kategori eller på et kursus.';
$string['weightcourse'] = 'Brug vægtede karakterer på kurset';
$string['weightedascending'] = 'Sorter vægtede procenter stigende';
$string['weighteddescending'] = 'Sorter vægtede procenter faldene';
$string['weightedpct'] = 'vægtet %';
$string['weightedpctcontribution'] = 'vægtet % bidrag';
$string['weightofa'] = 'Vægt af {$a}';
$string['weightorextracredit'] = 'Vægt eller ekstra point';
$string['weightoverride'] = 'vægt-justering';
$string['weightoverride_help'] = 'Fjern markering for at nulstille et karakterelement til dets automatisk beregnede værdi. Markering her forhindrer at vægtningen automatisk justeres.';
$string['weights'] = 'Vægtninger';
$string['weightsadjusted'] = 'Dine vægtninger er blevet justeret til 100';
$string['weightsedit'] = 'Rediger vægtning og ekstra point';
$string['weightuc'] = 'Beregnet vægtning';
$string['writinggradebookinfo'] = 'Skriver karakterbogsindstillinger';
$string['xml'] = 'xml';
$string['yes'] = 'Ja';
$string['yourgrade'] = 'Din karakter';
