<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'da', version '5.0'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Accepter';
$string['accept_grades'] = 'Accepter karakterer fra værktøjet';
$string['accept_grades_admin'] = 'Accepter karakterer fra værktøjet';
$string['accept_grades_admin_help'] = 'Specify whether the tool provider can add, update, read, and delete grades associated with instances of this tool.

Some tool providers support reporting grades back to Moodle based on actions taken within the tool, creating a more integrated
experience.';
$string['accept_grades_from_tool'] = 'Tillad {$a} at tilføje karakterer i karakterbogen';
$string['accept_grades_help'] = 'Specify whether the tool provider can add, update, read, and delete grades associated only with this external tool instance.

Some tool providers support reporting grades back to Moodle based on actions taken within the tool, creating a more integrated experience.

Note that this setting may be overridden in the tool configuration.';
$string['accepted'] = 'Accepteret';
$string['action'] = 'Handling';
$string['activate'] = 'Aktiver';
$string['activatetoadddescription'] = 'Du skal aktivere dette værktøj, før du kan tilføje en beskrivelse.';
$string['active'] = 'Aktiv';
$string['activity'] = 'Aktivitet';
$string['add_ltiadv'] = 'Tilføj LTI Advantage';
$string['add_ltilegacy'] = 'Tilføj Legacy LTI';
$string['addnewapp'] = 'Aktiver ekstern applikation';
$string['addserver'] = 'Tilføj ny betroet server';
$string['addtool'] = 'Tilføj værktøj';
$string['addtype'] = 'Tilføj forudkonfigureret værktøj';
$string['allow'] = 'Tillad';
$string['allowsetting'] = 'Tillad værktøjet at gemme 8K indstillinger i Moodle';
$string['always'] = 'Altid';
$string['autoaddtype'] = 'Tilføj værktøj';
$string['automatic'] = 'Automatisk, baseret på værktøjets URL';
$string['baseurl'] = 'Basis-URL/værktøjsregistreringsnavn';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth basisstreng';
$string['basiclti_endpoint'] = 'LTI launch endpoint';
$string['basiclti_in_new_window'] = 'Din aktivitet er åbnet i et nyt vindue';
$string['basiclti_in_new_window_open'] = 'Åbn i nyt vindue';
$string['basiclti_parameters'] = 'LTI launch parametre';
$string['basicltiactivities'] = 'LTI aktiviteter';
$string['basicltifieldset'] = 'Brugerdefineret eksempel feltgruppe';
$string['basicltiintro'] = 'Aktivitetsbeskrivelse';
$string['basicltiname'] = 'Aktivitetsnavn';
$string['basicltisettings'] = 'Grundlæggende indstillinger for Learning Tool Interoperability (LTI)';
$string['cachedef_keyset'] = 'Cache keyset-informationen for værktøjer';
$string['cancel'] = 'Annuller';
$string['cancelled'] = 'Aflyst';
$string['capabilities'] = 'Funktioner';
$string['capabilities_help'] = 'Vælg de funktioner, som du ønsker at tilbyde til værktøjsudbyderen. Mere end én funktion kan vælges.';
$string['capabilitiesrequired'] = 'Dette værktøj kræver adgang til følgende data for at blive aktiveret:';
$string['cleanaccesstokens'] = 'Fjernelse af udløbne adgangstokens fra eksterne værktøjer';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Klik for at fortsætte</a>';
$string['clientidadmin'] = 'Klient ID';
$string['clientidadmin_help'] = 'Klient-ID er en unik værdi, der bruges til at identificere et værktøj. Den oprettes automatisk for hvert værktøj, der bruger JWT-sikkerhedsprofilen, der blev introduceret i LTI 1.3, og bør være en del af de oplysninger, der sendes til værktøjsudbyderen, så de kan konfigurere forbindelsen på deres side.';
$string['comment'] = 'Kommentar';
$string['configpassword'] = 'Standard adgangskode til det eksterne værktøj';
$string['configpreferheight'] = 'Standard foretrukken højde';
$string['configpreferwidget'] = 'Indstil widget som standardstart';
$string['configpreferwidth'] = 'Standard foretrukken bredde';
$string['configresourceurl'] = 'Standard ressource URL';
$string['configtoolurl'] = 'Standard URL for eksternt værktøj';
$string['configtypes'] = 'Aktiver LTI-applikationer';
$string['configured'] = 'Konfigureret';
$string['confirmtoolactivation'] = 'Er du sikker på, at du gerne vil aktivere dette værktøj?';
$string['contentitem_deeplinking'] = 'Understøtter Deep Linking (Indholdselementbesked)';
$string['contentitem_deeplinking_help'] = 'Hvis den er markeret, vil muligheden \'Vælg indhold\' være tilgængelig, når der tilføjes et eksternt værktøj.';
$string['contentitem_multiple_description'] = 'Følgende elementer vil blive tilføjet til dit kursus:';
$string['contentitem_multiple_graded'] = 'Vurderet aktivitet (Maksimal karakter: {$a})';
$string['contentselected'] = 'Indhold valgt';
$string['courseactivitiesorresources'] = 'Kursusaktiviteter eller ressourcer';
$string['courseexternaltooladd'] = 'Tilføj nyt LTI eksternt værktøj';
$string['courseexternaltooladdsuccess'] = '{$a} tilføjet.';
$string['courseexternaltooledit'] = 'Rediger {$a}';
$string['courseexternaltooleditsuccess'] = 'Ændringer gemt.';
$string['courseexternaltooliconalt'] = 'Ikon for {$a}';
$string['courseexternaltools'] = 'LTI eksterne værktøjer';
$string['courseexternaltoolsinfo'] = 'LTI eksterne værktøjer er tillægsapps, som du kan integrere i dit kursus, såsom interaktivt indhold eller vurderinger. Dine studerende kan få adgang til og bruge dem uden at forlade dit kursus.';
$string['courseexternaltoolsnoeditpermissions'] = 'Du har ikke tilladelse til at redigere dette værktøj';
$string['courseexternaltoolsnoviewpermissions'] = 'Vis kursus eksterne værktøjer';
$string['courseid'] = 'Kursus ID nummer';
$string['courseinformation'] = 'Kursusinformation';
$string['courselink'] = 'Gå til kursus';
$string['coursemisconf'] = 'Kurset er forkert konfigureret';
$string['coursetooldeleted'] = '{$a} slettet';
$string['createdon'] = 'Oprettet den';
$string['curllibrarymissing'] = 'PHP cURL-udvidelsen er påkrævet for det eksterne værktøj.';
$string['custom'] = 'Brugerdefinerede parametre';
$string['custom_help'] = 'Custom parameters are settings used by the tool provider. For example, a custom parameter may be used to display
a specific resource from the provider.  Each parameter should be entered on a separate line using a format of "name=value"; for example, "chapter=3".

It is safe to leave this field unchanged unless directed by the tool provider.';
$string['custominstr'] = 'Brugerdefinerede parametre';
$string['debuglaunch'] = 'Debug mulighed';
$string['debuglaunchoff'] = 'Normal lancering';
$string['debuglaunchon'] = 'Debug lancering';
$string['default'] = 'Standard';
$string['default_launch_container'] = 'Standard startcontainer';
$string['default_launch_container_help'] = 'The launch container affects the display of the tool when launched from the course. Some launch containers provide more screen
real estate to the tool, and others provide a more integrated feel with the Moodle environment.

* **Default** - Use the launch container specified by the tool configuration.
* **Embed** - The tool is displayed within the existing Moodle window, in a manner similar to most other Activity types.
* **Embed, without blocks** - The tool is displayed within the existing Moodle window, with just the navigation controls
        at the top of the page.
* **New window** - The tool opens in a new window, occupying all the available space.
        Depending on the browser, it will open in a new tab or a popup window.
        It is possible that browsers will prevent the new window from opening.';
$string['delegate'] = 'Delegér til lærer';
$string['delegate_tool'] = 'Som angivet i definitionen af Deep Linking eller Delegér til underviseren';
$string['delete'] = 'Slet';
$string['delete_confirmation'] = 'Er du sikker på, at du vil slette dette forudkonfigurerede værktøj?';
$string['deletecoursetool'] = 'Slet {$a}';
$string['deletecoursetoolconfirm'] = 'Dette vil slette {$a} fra de tilgængelige LTI-værktøjer i dit kursus.';
$string['deletecoursetoolwithusageconfirm'] = '{$a} anvendes i øjeblikket i mindst én aktivitet i dit kursus. Hvis du sletter dette værktøj, vil de aktiviteter, der bruger det, ikke længere fungere.<br><br>Er du sikker på, at du vil slette {$a}?';
$string['display_description'] = 'Vis aktivitetsbeskrivelsen når studerende tilgår værktøjet';
$string['display_description_help'] = 'Indhold fra dette værktøj vises indlejret på en side i kurset. Denne indstilling bestemmer, om aktivitetsbeskrivelsen vises på den side.';
$string['display_name'] = 'Vis aktivitetsnavn, når studerende får adgang til værktøjet';
$string['display_name_help'] = 'Indholdet fra dette værktøj vises indlejret på en side i kurset. Denne indstilling bestemmer, om aktivitetsnavnet vises på den side.';
$string['donot'] = 'Send ikke';
$string['donotaccept'] = 'Accepter ikke';
$string['donotallow'] = 'Tillad ikke';
$string['dontshowinactivitychooser'] = 'Vis ikke i aktivitetsvælgeren';
$string['duplicateregurl'] = 'Denne registrerings-URL er allerede i brug';
$string['dynreg_update_btn_new'] = 'Registrer som et nyt eksternt værktøj';
$string['dynreg_update_btn_update'] = 'Opdatering';
$string['dynreg_update_name'] = 'Værktøjets navn';
$string['dynreg_update_notools'] = 'Ingen værktøjer i konteksten.';
$string['dynreg_update_text'] = 'There are existing tools attached to the registration\'s domain. Do you want to update an already installed
external tool or create a new external tool?';
$string['dynreg_update_url'] = 'Basis-URL';
$string['dynreg_update_version'] = 'LTI version';
$string['dynreg_update_warn_dupdomain'] = 'Det anbefales ikke at have flere eksterne værktøjer under det samme domæne.';
$string['editdescription'] = 'Klik her for at give dette værktøj en beskrivelse';
$string['editmanualinstancedeprecationwarning'] = 'Manually configured External tool activities are no longer supported. Don\'t worry, this activity will still work as it is, but you can\'t make changes to the tool configuration here anymore.
<br><br>
To make any changes to the tool, or to create new activities with it, the tool needs to be added to your course in Course > More > LTI External tools. Then, you will be able to create new activities, selecting the tool directly in the Activity chooser.
<br><br>
You can read more about adding LTI External tools in the documentation <a href="{$a}" target="_blank">External tool</a>.';
$string['embed'] = 'Indsæt';
$string['embed_no_blocks'] = 'Indsæt, uden blokke';
$string['enableemailnotification'] = 'Send notifikations-e-mails';
$string['enableemailnotification_help'] = 'Hvis det er aktiveret, vil studerende modtage e-mail-notifikation, når deres værktøjsindsendelser er bedømt.';
$string['enterkeyandsecret'] = 'Indtast din forbruger nøgle og delte hemmelighed';
$string['enterkeyandsecret_help'] = 'Hvis du har fået en forbruger nøgle og/eller delt hemmelighed, indtast dem her';
$string['entitycourseexternaltools'] = 'LTI eksterne værktøjer';
$string['errorbadurl'] = 'URL er ikke en gyldig værktøjs-URL eller cartridge.';
$string['errorincorrectconsumerkey'] = 'Forbruger-nøglen er forkert.';
$string['errorinvaliddata'] = 'Ugyldige data: {$a}';
$string['errorinvalidmediatype'] = 'Ugyldig medietype: {$a}';
$string['errorinvalidresponseformat'] = 'Ugyldigt format for Content-Item svar.';
$string['errormisconfig'] = 'Forkert konfigureret værktøj. Venligst bed din Moodle-administrator om at rette konfigurationen af værktøjet.';
$string['errortooltypenotfound'] = 'LTI værktøjetype blev ikke fundet.';
$string['existing_window'] = 'Eksisterende vindue';
$string['extensions'] = 'LTI udvidelsestjenester';
$string['external_tool_type'] = 'Forudkonfigureret værktøj';
$string['external_tool_type_help'] = '* **Automatic, based on tool URL** - The best tool configuration is selected automatically. If the tool URL is not recognised, the tool configuration details may need to be entered manually.
* **A specific preconfigured tool** - The tool configuration for the specified tool will be used when communicating with the external tool provider. If the tool URL does not appear to belong to the tool provider, a warning will be shown. It is not always necessary to enter a tool URL.
* **Custom configuration** - A consumer key and shared secret may need to be entered manually. The consumer key and shared secret may be obtained from the tool provider. However, not all tools require a consumer key and shared secret, in which case the fields may be left blank.

### Preconfigured tool editing

Three icons are available after the preconfigured tool drop-down menu:

* **Add** - Create a course level tool configuration. All External tool instances in this course may use the tool configuration.
* **Edit** - Select a course level tool from the drop-down menu, then click this icon. The details of the tool configuration may be edited.
* **Delete** - Remove the selected course level tool.';
$string['external_tool_types'] = 'Forudkonfigurerede værktøjer';
$string['failedtoconnect'] = 'Moodle kunne ikke kommunikere med "{$a}" systemet';
$string['failedtocreatetooltype'] = 'Det lykkedes ikke at oprette et nyt værktøj. Venligst tjek URL\'en og prøv igen.';
$string['failedtodeletetoolproxy'] = 'Det lykkedes ikke at slette værktøjsregistreringen. Du skal muligvis besøge "Administrer registreringer af eksterne værktøjer" og slette den manuelt.';
$string['filter_basiclti_configlink'] = 'Konfigurer dine foretrukne sider og deres adgangskoder';
$string['filter_basiclti_password'] = 'Adgangskode er obligatorisk';
$string['filterconfig'] = 'LTI administration';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Brug en eksisterende konfiguration for den fejlkonfigurerede instans';
$string['fixnew'] = 'Ny konfiguration';
$string['fixnewconf'] = 'Definer en ny konfiguration for den fejlagtigt konfigurerede instans';
$string['fixold'] = 'Brug eksisterende';
$string['force_ssl'] = 'Tving SSL';
$string['force_ssl_help'] = 'Selecting this option forces all launches to this tool provider to use SSL.

In addition, all web service requests from the tool provider will use SSL.

If using this option, confirm that this Moodle site and the tool provider support SSL.';
$string['generaltool'] = 'Generelt værktøj';
$string['grading'] = 'Karakterruting';
$string['icon_url'] = 'Ikon URL';
$string['icon_url_help'] = 'The icon URL allows the icon that shows up in the course listing for this activity to be modified. Instead of using the default
LTI icon, an icon which conveys the type of activity may be specified.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven har nået i en LTI-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'LTI kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af LTI-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen visning, Visning, Indsend, Vis feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Læringsanalyseindikatorer#Kognitiv_dybde';
$string['indicator:socialbreadth'] = 'LTI social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som studenten har opnået i en LTI aktivitet.';
$string['indicator:socialbreadthdef'] = 'LTI social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af den sociale engagement, der tilbydes af LTI-aktiviteterne i denne analyseperiode (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre)';
$string['indicator:socialbreadthdef_link'] = 'Læringsanalyseindikatorer#Social_bredde';
$string['initiatelogin'] = 'Initier login-URL';
$string['initiatelogin_help'] = 'Den værktøjs-URL, som anmodninger om at starte en login skal sendes til. Denne URL er nødvendig, før en besked kan sendes til værktøjet med succes.';
$string['invalidid'] = 'LTI ID var forkert';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Offentlig nøgletype';
$string['keytype_help'] = 'Den godkendelsesmetode, der anvendes til at validere værktøjet.';
$string['keytype_keyset'] = 'Keyset URL';
$string['keytype_rsa'] = 'RSA nøgle';
$string['launch_in_moodle'] = 'Start værktøjet i Moodle';
$string['launch_in_popup'] = 'Start værktøjet i et pop-up vindue';
$string['launch_url'] = 'Værktøjs-URL';
$string['launch_url_help'] = 'The tool URL indicates the web address of the External Tool, and may contain additional information, such as the resource to show.
If you are unsure what to enter for the tool URL, please check with the tool provider for more information.

You can enter a cartridge URL if you have one, and the rest of the form details will fill automatically.

If you have selected a preconfigured tool, you may not need to enter a tool URL. If the tool link is used to just launch
into the tool provider\'s system, and not go to a specific resource, this will likely be the case.';
$string['launchinpopup'] = 'Start container';
$string['launchinpopup_help'] = 'The launch container affects the display of the tool when launched from the course. Some launch containers provide more screen
real estate to the tool, and others provide a more integrated feel with the Moodle environment.

* **Default** - Use the launch container specified by the tool configuration.
* **Embed** - The tool is displayed within the existing Moodle window, in a manner similar to most other Activity types.
* **Embed, without blocks** - The tool is displayed within the existing Moodle window, with just the navigation controls
        at the top of the page.
* **New window** - The tool opens in a new window, occupying all the available space.
        Depending on the browser, it will open in a new tab or a popup window.
        It is possible that browsers will prevent the new window from opening.';
$string['launchoptions'] = 'Startmuligheder';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Tilføj kursusspecifikke værktøjskonfigurationer';
$string['lti:addinstance'] = 'Tilføj et nyt eksternt værktøj';
$string['lti:addmanualinstanceprohibitederror'] = 'Den manuelle oprettelse af værktøjer uden en kursusværktøjsdefinition understøttes ikke længere. Venligst opret et kursusværktøj først og brug derefter det til at oprette aktivitetsinstanser.';
$string['lti:addpreconfiguredinstance'] = 'Tilføj et forudkonfigureret værktøj';
$string['lti:admin'] = 'Vær administrator, når værktøjet lanceres';
$string['lti:grade'] = 'Se karakterer returneret af det eksterne værktøj';
$string['lti:manage'] = 'Vær en underviser når værktøjet lanceres';
$string['lti:requesttooladd'] = 'Anmodning om et værktøj er konfigureret på tværs af hele siden';
$string['lti:view'] = 'Start aktiviteter med eksterne værktøjer';
$string['lti_administration'] = 'Rediger forudkonfigureret værktøj';
$string['lti_errormsg'] = 'Værktøjet returnerede følgende fejlsmeddelelse: "{$a}"';
$string['lti_launch_error'] = 'Der opstod en fejl ved lanceringen af det eksterne værktøj:';
$string['lti_launch_error_tool_request'] = '<p>
To submit a request for an administrator to complete the tool configuration, click <a href="{$a->admin_request_url}" target="_top">here</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>This error may be a result of a missing consumer key and shared secret for the tool provider.</p>
<p>If you have a consumer key and shared secret, you may enter it when editing the external tool instance (make sure advanced options are visible).</p>
<p>Alternatively, you may <a href="{$a->course_tool_editor}">create a course level tool provider configuration</a>.</p>';
$string['lti_tool_request_added'] = 'Anmodning om værktøjskonfiguration er blevet indsendt med succes. Du kan have brug for at kontakte en administrator for at fuldføre værktøjskonfigurationen.';
$string['lti_tool_request_existing'] = 'En værktøjskonfiguration for værktøjsdomænet er allerede blevet indsendt.';
$string['ltisettings'] = 'LTI-indstillinger';
$string['ltiunknownserviceapicall'] = 'LTI ukendt service API kald.';
$string['ltiversion'] = 'LTI version';
$string['ltiversion_help'] = 'Den version af LTI, der anvendes til at signere beskeder og serviceanmodninger: LTI 1.0/1.1 og LTI 2.0 bruger OAuth 1.0A sikkerhedsprofilen; LTI 1.3.0 bruger JWTs.';
$string['main_admin'] = 'Generel hjælp';
$string['main_admin_help'] = 'External tools allow Moodle users to interact with learning resources hosted remotely. Through a special launch protocol, the remote tool has access to general information about the launching user. For example, the institution name, course ID, user ID, and other information such as the user\'s name or email address.

Tools listed on this page are separated into three categories:

* **Active** - These tool providers have been approved and configured by an administrator. They can be used from within any course on this site. If a consumer key and shared secret are entered, a trust relationship is established between this site and the remote tool, providing a secure communication channel.
* **Pending** - These tool providers came in through a package import, but have not been configured by an administrator. Teachers may still use tools from these providers if they have a consumer key and shared secret, or if none is required.
* **Rejected** - These tools providers are flagged as ones which an administrator has no intention of making available on the site. Teachers may still use tools from these providers if they have a consumer key and shared secret, or if none is required.';
$string['manage_external_tools'] = 'Administrer værktøjer';
$string['manage_tool_proxies'] = 'Administrer registreringer af eksterne værktøjer';
$string['manage_tools'] = 'Administrer forudkonfigurerede værktøjer';
$string['manuallyaddtype'] = 'Alternativt kan du <a href="{$a}">konfigurere et værktøj manuelt</a>.';
$string['miscellaneous'] = 'Diverse';
$string['misconfiguredtools'] = 'Forkert konfigurerede værktøjsinstanser blev opdaget';
$string['missingparameterserror'] = 'Siden er forkert konfigureret: "{$a}"';
$string['module_class_type'] = 'Moodle modultype';
$string['modulename'] = 'Eksternt værktøj';
$string['modulename_help'] = 'The external tool activity module enables students to interact with learning resources and activities on other web sites. For example, an external tool could provide access to a new activity type or learning materials from a publisher.

To create an external tool activity, a tool provider which supports LTI (Learning Tools Interoperability) is required. A teacher can create an external tool activity or make use of a tool configured by the site administrator.

External tool activities differ from URL resources in a few ways:

* External tools are context aware i.e. they have access to information about the user who launched the tool, such as institution, course and name
* External tools support reading, updating, and deleting grades associated with the activity instance
* External tool configurations create a trust relationship between your site and the tool provider, allowing secure communication between them';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Eksterne værktøjer';
$string['modulenamepluralformatted'] = 'Eksterne værktøjer';
$string['name'] = 'Navn';
$string['never'] = 'Aldrig';
$string['new_window'] = 'Nyt vindue';
$string['no_lti_configured'] = 'Der er ingen aktive eksterne værktøjer konfigureret.';
$string['no_lti_pending'] = 'Der er ingen ventende eksterne værktøjer.';
$string['no_lti_rejected'] = 'Der er ingen afviste eksterne værktøjer.';
$string['no_lti_tools'] = 'Der er ingen eksterne værktøjer konfigureret.';
$string['no_tp_accepted'] = 'Der er ingen accepterede registreringer af eksterne værktøjer.';
$string['no_tp_cancelled'] = 'Der er ingen annullerede registreringer af eksterne værktøjer.';
$string['no_tp_configured'] = 'Der er ingen uregistrerede registreringer af eksterne værktøjer konfigureret.';
$string['no_tp_pending'] = 'Der er ingen ventende registreringer af eksterne værktøjer.';
$string['no_tp_rejected'] = 'Der er ingen afviste registreringer af eksterne værktøjer.';
$string['noattempts'] = 'Der er ikke gjort nogen forsøg på denne værktøjsinstans';
$string['nocourseexternaltoolsnotice'] = 'Der er endnu ingen LTI eksterne værktøjer.';
$string['noltis'] = 'Der er ingen eksterne værktøjsinstanser';
$string['noprofileservice'] = 'Profilservice ikke fundet';
$string['noservers'] = 'Ingen servere fundet';
$string['notypes'] = 'Der er i øjeblikket ingen LTI-værktøjer opsat i Moodle. Klik på Installér-linket ovenfor for at tilføje nogle.';
$string['noviewusers'] = 'Der blev ikke fundet nogen brugere med tilladelser til at bruge dette værktøj';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 kræver, at en gyldig openssl.cnf er konfigureret og tilgængelig for din webserver. Venligst kontakt webstedets administrator for at konfigurere og aktivere openssl for dette websted.';
$string['optionalsettings'] = 'Valgfri indstillinger';
$string['organization'] = 'Organisationsoplysninger';
$string['organizationdescr'] = 'Organisationsbeskrivelse';
$string['organizationid_default'] = 'Standard organisations-ID';
$string['organizationid_default_help'] = 'Standardværdien der skal bruges til Organisations-ID. Site-ID identificerer denne installation af Moodle.';
$string['organizationidguid'] = 'Organisation ID';
$string['organizationidguid_help'] = 'A unique identifier for this Moodle instance passed to the tool as the Platform Instance GUID.

If this field is left blank, the default value will be used.';
$string['organizationurl'] = 'Organisations-URL';
$string['organizationurl_help'] = 'The base URL of this Moodle instance.

If this field is left blank, a default value will be used based on the site configuration.';
$string['pagesize'] = 'Indsendelser vist pr. side';
$string['parameter'] = 'Værktøjsparametre';
$string['parameter_help'] = 'Værktøjsparametre er indstillinger, der anmodes om at blive sendt af værktøjsudbyderen i den accepterede værktøjsproxy.';
$string['password'] = 'Delte hemmelighed';
$string['password_admin'] = 'Delte hemmelighed';
$string['password_admin_help'] = 'The shared secret can be thought of as a password used to authenticate access to the tool. It should be provided
along with the consumer key from the tool provider.

Tools which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a shared secret.';
$string['password_help'] = 'For pre-configured tools, it is not necessary to enter a shared secret here, as the shared secret will be
provided as part of the configuration process.

This field should be entered if creating a link to a tool provider which is not already configured.
If the tool provider is to be used more than once in this course, adding a course tool configuration is a good idea.

The shared secret can be thought of as a password used to authenticate access to the tool. It should be provided
along with the consumer key from the tool provider.

Tools which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a shared secret.';
$string['pending'] = 'Afventer';
$string['pluginadministration'] = 'Administration af eksterne værktøjer';
$string['pluginname'] = 'Eksternt værktøj';
$string['preferheight'] = 'Foretrukken højde';
$string['preferwidget'] = 'Foretræk widget lancering';
$string['preferwidth'] = 'Foretrukken bredde';
$string['press_to_submit'] = 'Tryk for at starte denne aktivitet';
$string['privacy'] = 'Privatliv';
$string['privacy:metadata:coursefullname'] = 'Det fulde navn på det kursus, som brugeren tilgår LTI-forbrugeren fra';
$string['privacy:metadata:courseid'] = 'ID\'et på det kursus, som brugeren tilgår LTI-forbrugeren fra';
$string['privacy:metadata:courseidnumber'] = 'ID-nummeret på det kursus, som brugeren tilgår LTI-forbrugeren fra';
$string['privacy:metadata:courseshortname'] = 'Det korte navn på det kursus, som brugeren tilgår LTI-forbrugeren fra';
$string['privacy:metadata:createdby'] = 'Brugeren der oprettede posten';
$string['privacy:metadata:email'] = 'E-mailadressen på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:externalpurpose'] = 'LTI-forbrugeren leverer brugerinformation og kontekst til LTI-værktøjsudbyderen.';
$string['privacy:metadata:firstname'] = 'Fornavnet på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:fullname'] = 'Det fulde navn på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:lastname'] = 'Efternavnet på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:lti_submission'] = 'LTI indsendelse';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Tidsstemplet der angiver hvornår indsendelsen blev foretaget';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Tidsstemplet der angiver hvornår indsendelsen blev ændret';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Karakteren for brugeren som en procentdel';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Den oprindelige karakter for brugeren';
$string['privacy:metadata:lti_submission:userid'] = 'ID\'et på den bruger, der har indsendt til LTI-aktiviteten';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxies';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proxy navn';
$string['privacy:metadata:lti_types'] = 'LTI typer';
$string['privacy:metadata:lti_types:name'] = 'LTI type navn';
$string['privacy:metadata:role'] = 'Rollen i kurset for brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:timecreated'] = 'Tidspunktet hvor posten blev oprettet';
$string['privacy:metadata:timemodified'] = 'Tidspunktet hvor posten blev ændret';
$string['privacy:metadata:userid'] = 'ID\'et på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:useridnumber'] = 'ID-nummeret på brugeren, der tilgår LTI-forbrugeren';
$string['privacy:metadata:username'] = 'Brugernavnet på den bruger, der tilgår LTI-forbrugeren';
$string['publickey'] = 'Offentlig nøgle';
$string['publickey_help'] = 'Den offentlige nøgle (i PEM-format) leveret af værktøjet for at muliggøre verifikation af signaturer af indkommende beskeder og serviceanmodninger.';
$string['publickeyset'] = 'Offentligt nøglesæt';
$string['publickeyset_help'] = 'Offentlig nøglesæt, hvorfra denne side vil hente værktøjets offentlige nøgle for at tillade verifikation af signaturer på indkommende beskeder og serviceanmodninger.';
$string['quickgrade'] = 'Tillad hurtig bedømmelse';
$string['quickgrade_help'] = 'Hvis det er aktiveret, kan flere værktøjer vurderes på én side. Tilføj karakterer og kommentarer, og klik derefter på knappen "Gem al min feedback" for at gemme alle ændringer for den pågældende side.';
$string['redirect'] = 'Du vil blive omdirigeret om få sekunder. Hvis du ikke bliver det, skal du trykke på knappen.';
$string['redirectionuris'] = 'Omdirigering URI\'er';
$string['redirectionuris_help'] = 'En liste over URIs (én pr. linje), som værktøjet bruger, når der foretages autorisationsanmodninger. Mindst én skal være registreret, før en besked kan sendes til værktøjet med succes.';
$string['register'] = 'Registrer';
$string['register_warning'] = 'Registreringssiden ser ud til at tage lidt tid at åbne. Hvis den ikke vises, skal du kontrollere, at du har indtastet den korrekte URL i konfigurationsindstillingerne. Hvis Moodle bruger https, skal du sikre dig, at det værktøj, du konfigurerer, understøtter https, og at du bruger https i URLen.';
$string['registertype'] = 'Konfigurer en ny registrering af et eksternt værktøj';
$string['registration_options'] = 'Registreringsmuligheder';
$string['registrationname'] = 'Navn på værktøjsudbyder';
$string['registrationname_help'] = 'Indtast navnet på værktøjsudbyderen, der registreres.';
$string['registrationurl'] = 'Registrerings-URL';
$string['registrationurl_help'] = 'Registrerings-URLen bør være tilgængelig fra værktøjsudbyderen som den placering, hvortil registreringsanmodninger bør sendes.';
$string['reject'] = 'Afvis';
$string['rejected'] = 'Afvist';
$string['resource'] = 'Ressource';
$string['resourcekey'] = 'Forbruger nøgle';
$string['resourcekey_admin'] = 'Forbruger nøgle';
$string['resourcekey_admin_help'] = 'The consumer key can be thought of as a username used to authenticate access to the tool.
It can be used by the tool provider to uniquely identify the Moodle site from which users launch into the tool.

The consumer key must be provided by the tool provider. The method of obtaining a consumer key varies between
tool providers. It may be an automated process, or it may require a dialogue with the tool provider.

Tools which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a resource key.';
$string['resourcekey_help'] = 'For pre-configured tools, it is not necessary to enter a resource key here, as the consumer key will be
provided as part of the configuration process.

This field should be entered if creating a link to a tool provider which is not already configured.
If the tool provider is to be used more than once in this course, adding a course tool configuration is a good idea.

The consumer key can be thought of as a username used to authenticate access to the tool.
It can be used by the tool provider to uniquely identify the Moodle site from which users launch into the tool.

The consumer key must be provided by the tool provider. The method of obtaining a consumer key varies between
tool providers. It may be an automated process, or it may require a dialogue with the tool provider.

Tools which do not require secure communication from Moodle and do not provide additional services (such as grade reporting)
may not require a resource key.';
$string['resourceurl'] = 'Ressource URL';
$string['restricttocategory'] = 'Begræns til kategori';
$string['restricttocategory_help'] = 'For at begrænse brugen af dette værktøj til kurser inden for en kategori, vælg den eller de kategorier fra listen.';
$string['return_to_course'] = 'Klik <a href="{$a->link}" target="_top">her</a> for at vende tilbage til kurset.';
$string['saveallfeedback'] = 'Gem al min feedback';
$string['search:activity'] = 'Eksternt værktøj - aktivitetsinformation';
$string['secure_icon_url'] = 'Sikker ikon URL';
$string['secure_icon_url_help'] = 'Ligner ikon-URLen, men bruges når siden tilgås sikkert gennem SSL. Dette felt er for at forhindre browseren i at vise en advarsel om et usikkert billede.';
$string['secure_launch_url'] = 'Sikker værktøjs-URL';
$string['secure_launch_url_help'] = 'Similar to the tool URL, but used instead of the tool URL if high security is required. Moodle will use the secure tool URL instead of the tool URL if the Moodle site is accessed through SSL, or if the tool configuration is set to always launch through SSL.

The tool URL may also be set to an https address to force launching through SSL, and this field may be left blank.';
$string['selectcontent'] = 'Vælg indhold';
$string['selectcontentvalidationerror'] = 'Du skal vælge indhold til denne aktivitet.';
$string['send'] = 'Send';
$string['services'] = 'Tjenester';
$string['services_help'] = 'Vælg de tjenester, som du ønsker at tilbyde til værktøjsudbyderen. Mere end én tjeneste kan vælges.';
$string['setupoptions'] = 'Opsætningsmuligheder';
$string['share_email'] = 'Del launcherens email med værktøjet';
$string['share_email_admin'] = 'Del launcherens email med værktøjet';
$string['share_email_admin_help'] = 'Specify whether the e-mail address of the user launching the tool will be shared with the tool provider.
The tool provider may need launcher\'s e-mail addresses to distinguish users with the same name in the UI, or send e-mails
to users based on actions within the tool.';
$string['share_email_help'] = 'Specify whether the e-mail address of the user launching the tool will be shared with the tool provider.

The tool provider may need launcher\'s email addresses to distinguish users with the same name, or send emails to users based on actions within the tool.

Note that this setting may be overridden in the tool configuration.';
$string['share_name'] = 'Del launcherens navn med værktøjet';
$string['share_name_admin'] = 'Del launcherens navn med værktøjet';
$string['share_name_admin_help'] = 'Specify whether the full name of the user launching the tool should be shared with the tool provider.
The tool provider may need launchers\' names to show meaningful information within the tool.';
$string['share_name_help'] = 'Specify whether the full name of the user launching the tool should be shared with the tool provider.

The tool provider may need launchers\' names to show meaningful information within the tool.

Note that this setting may be overridden in the tool configuration.';
$string['share_roster'] = 'Tillad værktøjet at få adgang til denne kursus\' deltagerliste';
$string['share_roster_admin'] = 'Værktøjet kan få adgang til kursuslisten';
$string['share_roster_admin_help'] = 'Angiv om værktøjet kan få adgang til listen over brugere, der er tilmeldt de kurser, hvorfra dette værktøj lanceres.';
$string['share_roster_help'] = 'Specify whether the tool can access the list of users enrolled in this course.

Note that this setting may be overridden in the tool configuration.';
$string['show_in_course_activity_chooser'] = 'Vis i aktivitetsvælgeren og som et forudkonfigureret værktøj';
$string['show_in_course_lti1'] = 'Brug af værktøjskonfiguration';
$string['show_in_course_lti1_help'] = 'Dette værktøj kan vises i aktivitetsvælgeren, så en lærer kan vælge det til at tilføje til et kursus. Alternativt kan det vises i den forudkonfigurerede værktøjsrulleliste, når der tilføjes et eksternt værktøj til et kursus. En yderligere mulighed er, at værktøjskonfigurationen kun anvendes, hvis den præcise værktøjs-URL indtastes, når der tilføjes et eksternt værktøj til et kursus.';
$string['show_in_course_lti2'] = 'Brug af værktøjskonfiguration';
$string['show_in_course_lti2_help'] = 'Dette værktøj kan vises i aktivitetsvælgeren, så en lærer kan vælge det til at tilføje til et kursus, eller i den forudkonfigurerede værktøjsrulleliste, når der tilføjes et eksternt værktøj til et kursus.';
$string['show_in_course_no'] = 'Vis ikke; brug kun når en matchende værktøjs-URL er indtastet';
$string['show_in_course_preconfigured'] = 'Vis som forudkonfigureret værktøj, når der tilføjes et eksternt værktøj';
$string['showinactivitychooser'] = 'Vis i aktivitetsvælgeren';
$string['sitehost'] = 'Webstedets værtsnavn';
$string['siteid'] = 'Site ID';
$string['size'] = 'Størrelsesparametre';
$string['submission'] = 'Indsendelse';
$string['submissions'] = 'Indsendelser';
$string['submissionsfor'] = 'Indsendelser for {$a}';
$string['subplugintype_ltiresource'] = 'LTI service ressource';
$string['subplugintype_ltiresource_plural'] = 'LTI service ressourcer';
$string['subplugintype_ltiservice'] = 'LTI service';
$string['subplugintype_ltiservice_plural'] = 'LTI-tjenester';
$string['subplugintype_ltisource'] = 'LTI kilde';
$string['subplugintype_ltisource_plural'] = 'LTI kilder';
$string['successfullycreatedtooltype'] = 'Værktøjet blev oprettet med succes!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Værktøjskonfigurationen blev succesfuldt hentet fra det valgte indhold.';
$string['toggle_debug_data'] = 'Skift debug-data';
$string['tool_settings'] = 'Værktøjsindstillinger';
$string['tooldescription'] = 'Værktøjsbeskrivelse';
$string['tooldescription_help'] = 'The description of the tool that will be displayed to teachers in the activity list.

This should describe what the tool is for and what it does and any additional information the teacher may need to know.';
$string['tooldetailsaccesstokenurl'] = 'Adgangstoken URL';
$string['tooldetailsauthrequesturl'] = 'URL til autentificeringsanmodning';
$string['tooldetailsclientid'] = 'Klient ID';
$string['tooldetailsdeploymentid'] = 'Deployment ID';
$string['tooldetailsmailtosubject'] = 'LTI værktøjskonfiguration';
$string['tooldetailsmodalemail'] = 'Email';
$string['tooldetailsmodallink'] = 'Se konfigurationsdetaljer';
$string['tooldetailsmodaltitle'] = 'Detaljer om værktøjskonfiguration';
$string['tooldetailsplatformid'] = 'Platform ID';
$string['tooldetailspublickeyseturl'] = 'Offentlig nøglesæt URL';
$string['toolisbeingused'] = 'Dette værktøj bliver brugt {$a} gange';
$string['toolisnotbeingused'] = 'Dette værktøj er endnu ikke blevet brugt';
$string['toolproxy'] = 'Registreringer af eksterne værktøjer';
$string['toolproxy_help'] = 'External tool registrations allow Moodle site administrators to configure external tools from a tool proxy obtained from a tool provider supporting LTI 2.0. A registration URL provided by the tool provider is all that is required to initiate the process. The capabilities and services offered to the tool provider are selected when configuring a new registration.

Tool registrations listed on this page are separated into four categories:

* **Configured** - These tool registrations have been set up but the registration process has not yet been started.
* **Pending** - The registration process for these tool registrations has been started but has not completed. Open and save the settings to move it
back to the \'Configured\' category.
* **Accepted** - These tool registrations have been approved; the resources specified in the tool proxy will appear on the preconfigured tools page
with an initial status of \'Pending\'.
* **Rejected** - These tool registrations are ones which were rejected during the registration process. Open and save the settings to move it
back to the \'Configured\' category so the registration process can be restarted.';
$string['toolproxyregistration'] = 'Registrering af eksternt værktøj';
$string['toolregistration'] = 'Registrering af eksternt værktøj';
$string['toolsetup'] = 'Konfiguration af eksternt værktøj';
$string['tooltypenotfounderror'] = 'The LTI tool used in this activity has been deleted. If you need help, contact your teacher or site administrator.';
$string['tooltypes'] = 'Værktøjer';
$string['toolurl'] = 'Værktøjs-URL';
$string['toolurl_contentitemselectionrequest'] = 'URL til indholdsvalg';
$string['toolurl_contentitemselectionrequest_help'] = 'URLen til indholdsvalg vil blive brugt til at starte indholdsvalgsiden fra værktøjsudbyderen. Hvis den er tom, vil værktøjs-URLen blive brugt';
$string['toolurl_help'] = 'The tool URL is used to match tool URLs to the correct tool configuration. Prefixing the URL with http(s) is optional.

Additionally, the base URL is used as the tool URL if a tool URL is not specified in the external tool instance.

For example, a base URL of *tool.com* would match the following:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

A base URL of *www.tool.com/quizzes* would match the following:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

A base URL of *quiz.tool.com* would match the following:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

If two different tool configurations are for the same domain, the most specific match will be used.

You can also insert a cartridge URL if you have one and the details for the tool will be automatically filled.';
$string['toolurlplaceholder'] = 'Værktøjs-URL...';
$string['typename'] = 'Værktøjets navn';
$string['typename_help'] = 'Værktøjets navn bruges til at identificere værktøjsudbyderen inden for Moodle. Det indtastede navn vil være synligt for undervisere, når de tilføjer eksterne værktøjer i kurser.';
$string['types'] = 'Typer';
$string['unabletocreatetooltype'] = 'Det er ikke muligt at oprette værktøj';
$string['unabletofindtooltype'] = 'Det er ikke muligt at finde værktøj til {$a->id}';
$string['unknownstate'] = 'Ukendt tilstand';
$string['update'] = 'Opdatering';
$string['usage'] = 'Brugsantal';
$string['useraccountinformation'] = 'Bruger konto information';
$string['userpersonalinformation'] = 'Brugerens personlige oplysninger';
$string['validurl'] = 'En gyldig URL skal starte med http(s)://';
$string['viewsubmissions'] = 'Vis indsendelser og bedømmelses skærm';
