<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_download_certificates', language 'fr', version '5.0'.
 *
 * @package     block_download_certificates
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['cannotcreatezipfile'] = 'Impossible de créer le fichier ZIP.';
$string['cannotdownloadcertificate'] = 'Impossible de télécharger le certificat. Veuillez réessayer plus tard ou contacter un administrateur.';
$string['cannotdownloadusercertificates'] = 'Impossible de télécharger les certificats de l\'utilisateur.';
$string['certificate'] = 'Certificat';
$string['certificate_management'] = 'Gestion des certificats';
$string['certificate_summary'] = 'Résumé des certificats';
$string['certificateerror'] = 'Erreur lors de la génération du certificat';
$string['certificategenerated'] = 'Certificat généré avec succès';
$string['certificatenotfound'] = 'Certificat non trouvé.';
$string['certificates'] = 'certificats';
$string['choose_cohort'] = 'Choisir une cohorte...';
$string['choose_course'] = '-- Choisir un cours --';
$string['choose_user'] = 'Choisir un utilisateur...';
$string['code'] = 'Code';
$string['cohort_download_help'] = 'Sélectionner une cohorte pour télécharger tous les certificats de ses membres.';
$string['cohortnotselected'] = 'Aucune cohorte sélectionnée.';
$string['confirm_download_all'] = 'Voulez-vous vraiment télécharger tous les certificats ? Cela peut prendre du temps.';
$string['course_download_help'] = 'Sélectionner un cours pour télécharger tous les certificats émis pour ce cours.';
$string['coursenotfound'] = 'Cours non trouvé.';
$string['coursenotselected'] = 'Veuillez sélectionner un cours.';
$string['courses'] = 'Cours';
$string['customcert_certificate'] = 'Certificat personnalisé';
$string['customcert_not_available'] = 'Plugin Certificat personnalisé non disponible.';
$string['date_created'] = 'Date de création';
$string['date_range_help'] = 'Sélectionner une plage de dates pour télécharger tous les certificats émis dans cette période.';
$string['default_template'] = '<div style="text-align: center; font-family: Arial;">
<h1>Certificat de réussite</h1>
<p>Ceci certifie que</p>
<h2>{fullname}</h2>
<p>a terminé avec succès le cours</p>
<h3>{course}</h3>
<p>le {date}</p>
<p>Note : {grade}</p>
</div>';
$string['download_all_certificates'] = 'Télécharger tous les certificats';
$string['download_all_quick'] = 'Tout télécharger';
$string['download_by_cohort'] = 'Télécharger par cohorte';
$string['download_by_course'] = 'Télécharger par cours';
$string['download_by_date_range'] = 'Télécharger par plage de dates';
$string['download_by_user'] = 'Télécharger par utilisateur';
$string['download_certificate'] = 'Télécharger le certificat';
$string['download_certificates:addinstance'] = 'Ajouter un nouveau bloc de téléchargement de certificat';
$string['download_certificates:manage'] = 'Gérer le téléchargement de certificat';
$string['download_certificates:myaddinstance'] = 'Ajouter un nouveau bloc de téléchargement de certificat au Tableau de bord';
$string['download_certificates:view'] = 'Voir le bloc de téléchargement de certificat';
$string['download_cohort_certificates'] = 'Télécharger les certificats de la cohorte';
$string['download_course_certificates'] = 'Télécharger les certificats du cours';
$string['download_my_certificates'] = 'Télécharger mes certificats';
$string['download_precise'] = 'Téléchargement précis';
$string['download_range'] = 'Télécharger la plage';
$string['download_selected'] = 'Télécharger la sélection';
$string['download_user_certificates'] = 'Télécharger les certificats';
$string['downloadcertificate'] = 'Télécharger le certificat';
$string['downloadinprogress'] = 'Téléchargement en cours...';
$string['enable'] = 'Activer le plugin';
$string['enable_desc'] = 'Activer ou désactiver la fonctionnalité de téléchargement de certificat.';
$string['end_date'] = 'Date de fin';
$string['error_loading_block'] = 'Erreur lors du chargement des données de certificat';
$string['filename_format'] = 'Format du nom de fichier';
$string['filename_format_desc'] = 'Format pour les noms de fichiers de certificat. Variables disponibles : {fullname}, {course}, {date}, {userid}.';
$string['filenotfound'] = 'Fichier non trouvé.';
$string['invalidaterange'] = 'Plage de dates invalide sélectionnée. Veuillez vous assurer que la date de début est antérieure à la date de fin.';
$string['manage_certificates'] = 'Gérer les certificats';
$string['managecertificates'] = 'Gérer les certificats';
$string['max_certificates_display'] = 'Nombre maximum de certificats à afficher';
$string['max_certificates_display_desc'] = 'Nombre maximum de certificats à afficher dans le résumé du bloc.';
$string['members'] = 'membres';
$string['my_certificates'] = 'Mes certificats';
$string['my_certificates_count'] = 'Mes certificats';
$string['no_certificates_description'] = 'Il n\'y a aucun certificat disponible pour téléchargement en ce moment.';
$string['no_certificates_found'] = 'Aucun certificat trouvé';
$string['no_certificates_user'] = 'Vous n\'avez pas encore de certificats.';
$string['no_cohorts_with_certificates'] = 'Aucune cohorte trouvée avec des certificats.';
$string['no_courses_with_certificates'] = 'Aucun cours trouvé avec des certificats.';
$string['no_users_with_certificates'] = 'Aucun utilisateur avec des certificats trouvé.';
$string['nocertificate'] = 'Aucun certificat disponible';
$string['nocertificates'] = 'Aucun certificat trouvé à télécharger.';
$string['nocertificatescohort'] = 'Aucun certificat trouvé pour les membres de cette cohorte.';
$string['nocertificatesforcourse'] = 'Aucun certificat trouvé pour ce cours.';
$string['nocertificatesselected'] = 'Aucun certificat sélectionné.';
$string['nocertificatesuser'] = 'Aucun certificat trouvé pour cet utilisateur.';
$string['nocohortmembers'] = 'Aucun membre trouvé dans cette cohorte.';
$string['novalidcertificates'] = 'Aucun certificat valide n\'a pu être téléchargé.';
$string['novalidcertificatescohort'] = 'Aucun certificat valide n\'a pu être téléchargé pour cette cohorte.';
$string['novalidcertificatesforcourse'] = 'Aucun certificat valide n\'a pu être téléchargé pour ce cours.';
$string['novalidcertificatesinrange'] = 'Aucun certificat valide trouvé dans la plage de dates spécifiée.';
$string['novalidcertificatesselected'] = 'Aucun certificat valide n\'a pu être téléchargé depuis la sélection.';
$string['novalidcertificatesuser'] = 'Aucun certificat valide trouvé pour cet utilisateur.';
$string['pluginname'] = 'Télécharger le certificat';
$string['precise_download_help'] = 'Télécharger des certificats spécifiques en sélectionnant des éléments individuels.';
$string['privacy:metadata'] = 'Le plugin Télécharger le certificat n\'enregistre aucune donnée personnelle';
$string['recent_7days'] = '7 derniers jours';
$string['select_certificates'] = 'Sélectionner les certificats';
$string['select_cohort'] = 'Sélectionner une cohorte';
$string['select_course'] = 'Sélectionner un cours';
$string['select_user'] = 'Sélectionner un utilisateur';
$string['start_date'] = 'Date de début';
$string['template'] = 'Modèle de certificat';
$string['template_desc'] = 'Modèle HTML pour le certificat. Variables disponibles : {fullname}, {course}, {date}, {grade}.';
$string['total'] = 'Total';
$string['total_certificates'] = 'Total des certificats';
$string['unknown'] = 'Inconnu';
$string['user_download_help'] = 'Sélectionner un utilisateur pour télécharger tous ses certificats sous forme de fichier ZIP.';
