<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'sr_cr', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Имате предстојеће BigBlueButton сесије';
$string['bbbduetimeoverstartingtime'] = 'Време завршетка ове активност мора бити након времена њеног почетка.';
$string['bbbdurationwarning'] = 'Максимално трајање овe сесијe је %duration% минута.';
$string['bbbrecordallfromstartwarning'] = 'Ова сесија се снима од почетка.';
$string['bbbrecordwarning'] = 'Ова сесија може да се сними.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Додавање нове BigBlueButton собе';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Креирање инстанце сесије уживо';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Креирање инстанце са снимцима';
$string['bigbluebuttonbn:deleterecordings'] = 'Брисање снимака';
$string['bigbluebuttonbn:importrecordings'] = 'Увоз снимака';
$string['bigbluebuttonbn:join'] = 'Приступање BigBlueButton соби';
$string['bigbluebuttonbn:managerecordings'] = 'Управљање снимцима';
$string['bigbluebuttonbn:protectrecordings'] = 'Заштита снимака';
$string['bigbluebuttonbn:publishrecordings'] = 'Објављивање снимака';
$string['bigbluebuttonbn:seepresentation'] = 'Увек погледајте датотеку презентације на страници активности';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Уклањање заштите снимака';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Опозив објављених снимака';
$string['bigbluebuttonbn:view'] = 'Приказ BigBlueButton собе';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Приказ свих формата снимања';
$string['cachedef_currentfetch'] = 'Подаци за списак свих снимака недавно преузетих.';
$string['cachedef_recordings'] = 'Метаподаци о снимку';
$string['cachedef_serverinfo'] = 'Информације о удаљеном серверу';
$string['cachedef_subplugins'] = 'Кеш који користе рутине поддодатка како би убрзале процес откривања додатака, када је то потребно.';
$string['cachedef_validatedurls'] = 'Кеш провера потврђених URL адреса';
$string['calendarstarts'] = '{$a} заказан је за';
$string['cannotperformaction'] = 'Није могуће извршити акцију {$a} на овом снимку';
$string['completionattendance'] = 'Захтевај присуство (минути)';
$string['completionattendance_desc'] = 'Студент мора да уђе у конференцијску собу и остане на сесији најмање {$a} минута.';
$string['completionattendance_event_desc'] = 'Студент је ушао у конференцијску собу и остао на сесији најмање {$a} минута';
$string['completionattendancegroup'] = 'Захтевај присуство (минути)';
$string['completionengagement_desc'] = 'Полазник се мора укључити у активности током састанка.';
$string['completionengagementchats'] = 'Разговори';
$string['completionengagementchats_desc'] = 'Студент мора учестовати у најмање {$a} разговора како би завршио активност.';
$string['completionengagementchats_event_desc'] = 'Учестовао у разговору {$a} пут(а)';
$string['completionengagementemojis'] = 'Емотикони';
$string['completionengagementemojis_desc'] = 'Полазник мора да промени емоџи {$а} пут(а).';
$string['completionengagementemojis_event_desc'] = 'Променио/ла свој емоџи {$a} пут(а)';
$string['completionengagementgroup'] = 'Захтевај учешће';
$string['completionengagementpollvotes'] = 'Гласови у анкети/Одговори на питања';
$string['completionengagementpollvotes_desc'] = 'Студент мора да пошаље глас/одговор најмање {$a} пут(а) како би завршио активност.';
$string['completionengagementpollvotes_event_desc'] = 'Гласао/одговорио {$a} пут(а)';
$string['completionengagementraisehand'] = 'Захтевај подизање руке';
$string['completionengagementraisehand_desc'] = 'Полазник мора да подигне руку барем {$a} пут(а) како би завршио активност.';
$string['completionengagementraisehand_event_desc'] = 'Подигао руку {$a} пут(а)';
$string['completionengagementtalks'] = 'Укључити се у сесију гласом';
$string['completionengagementtalks_desc'] = 'Полазник мора да се укључи у сесију гласом барем {$a} пут(а) како би завршио активност.';
$string['completionengagementtalks_event_desc'] = 'Укључио се у сесији гласом {$a} пут(а)';
$string['completionupdatestate'] = 'Статус ажурирања завршетка';
$string['completionvalidatestate'] = 'Провера завршетка';
$string['completionvalidatestatetriggered'] = 'Провера завршетка је покренута';
$string['completionview_event_desc'] = 'Погледао/ла  је конференцијску собу.';
$string['config_checksum_algorithm'] = 'Алгоритам контролоног збира BigBlueButton сервера';
$string['config_checksum_algorithm_description'] = 'Алгоритам контролоног збира вашег BigBlueButton сервера. SHA256 и SHA512 су много безбеднији. SHA512 је компатибилан са FIPS 140-2.';
$string['config_default_messages'] = 'Подразумеване поруке';
$string['config_default_messages_description'] = 'Подесите подразумеване поруке за активности';
$string['config_disablecam_default'] = 'Опција \'Онемогући веб камеру\' је стандардно омогућена';
$string['config_disablecam_default_description'] = 'Ако је ова опција омогућена, веб камере ће бити онемогућене.';
$string['config_disablecam_editable'] = 'Опција \'Онемогући веб камеру\' може да се уређује';
$string['config_disablecam_editable_description'] = 'Опција \'Онемогући веб камеру\', која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disablemic_default'] = 'Опција \'Онемогући микрофон\' је стандардно омогућена';
$string['config_disablemic_default_description'] = 'Ако је ова опција омогућена, микрофони ће бити онемогућени.';
$string['config_disablemic_editable'] = 'Опција \'Онемогући микрофон\' може да се уређује';
$string['config_disablemic_editable_description'] = 'Опција \'Онемогући микрофон\', која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disablenote_default'] = 'Опција \'Онемогући дељене белешке\' је стандардно омогућена';
$string['config_disablenote_default_description'] = 'Ако је ова опција омогућена, дељене белешке ће бити онемогућене.';
$string['config_disablenote_editable'] = 'Опција \'Онемогући дељене белешке\' може да се уређује';
$string['config_disablenote_editable_description'] = 'Опција \'Онемогући дељене белешке\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disableprivatechat_default'] = 'Опција \'Онемогући приватни разговор\' је стандардно омогућена';
$string['config_disableprivatechat_default_description'] = 'Ако је ова опција омогућена, јавни разговор ће бити онемогућен.';
$string['config_disableprivatechat_editable'] = 'Опција \'Онемогући приватни разговор\' може да се уређује';
$string['config_disableprivatechat_editable_description'] = 'Опција \'Онемогући приватни разговор\'која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disablepublicchat_default'] = 'Опција \'Онемогући јавни разговор\' је стандардно омогућена';
$string['config_disablepublicchat_default_description'] = 'Ако је ова опција омогућена, приватни разговор ће бити онемогућен.';
$string['config_disablepublicchat_editable'] = 'Опција \'Онемогући јавни разговор\' може да се уређује';
$string['config_disablepublicchat_editable_description'] = 'Опција \'Онемогући јавни разговор\', која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_experimental_features'] = 'Експерименталне функције';
$string['config_experimental_features_description'] = 'Конфигурација за експерименталне функције.';
$string['config_extended_capabilities'] = 'Проширене могућности';
$string['config_extended_capabilities_description'] = 'Конфигурација за проширене могућности када их нуди BigBlueButton сервер.';
$string['config_general'] = 'Општа подешавања';
$string['config_general_description'] = 'Да бисте подесили BigBlueButton, можете или да користите сопствени BigBlueButton сервер и акредитиве, или да добијете акредитиве на <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">порталу за регистрацију Blindside Networksa (отвара се у новом прозору)</a>.';
$string['config_guestaccess_enabled'] = 'Приступ за спољне госте';
$string['config_guestaccess_enabled_description'] = 'Дозволите корисницима који немају налог на вашем сајту да приступе конференцијској соби.';
$string['config_hideuserlist_default'] = 'Опција \'Сакриј списак корисника\' је стандардно омогућена';
$string['config_hideuserlist_default_description'] = 'Ако је ова опција омогућена, списак корисника сесије ће бити сакривен.';
$string['config_hideuserlist_editable'] = 'Опција \'Сакриј списак корисника\' може да се уређује';
$string['config_hideuserlist_editable_description'] = 'Опција \'Сакриј списак корисника\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_importrecordings'] = 'Увоз снимака';
$string['config_importrecordings_description'] = 'Ова подешавања су специфична за ову функцију.';
$string['config_importrecordings_enabled'] = 'Увоз снимака је омогућен';
$string['config_importrecordings_enabled_description'] = 'Када су ово и функција снимања омогућене, могуће је увести снимке са различитих курсева у активност.';
$string['config_importrecordings_from_deleted_enabled'] = 'Увоз снимака из обрисаних снимака је омогућен';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Када су ово и функција увоза снимака омогућене, могуће је увести снимке из активности које више не постоје на курсу.';
$string['config_locksettings'] = 'Конфигурација за закључавање подешавања';
$string['config_locksettings_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу за закључавања подешавања, а такође дефинишу подразумеване вредности за ове опције.';
$string['config_meetingevents_enabled'] = 'Региструјте сесије уживо';
$string['config_meetingevents_enabled_description'] = 'Ако је ова опција омогућена, сесије уживо ће бити обрађена након што се заврши. Ова функција је потребна за Завршетак активности и радиће само ако је BigBlueButton сервер способан да обрађује post_events скрипте.';
$string['config_muteonstart'] = 'Искључите звук на почетку';
$string['config_muteonstart_default'] = 'Опција \'Искључите звук на почетку\' је стандардно омогућена';
$string['config_muteonstart_default_description'] = 'Ако је ова опција омогућена, звук ће бити искључена на почетку сесије.';
$string['config_muteonstart_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_muteonstart_editable'] = 'Опција \'Искључите звук на почетку\' може да се уређује';
$string['config_muteonstart_editable_description'] = 'Опција \'Искључите звук на почетку\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_participant'] = 'Учесници';
$string['config_participant_description'] = 'Ова подешавања дефинишу подразумеване улоге за учеснике.';
$string['config_participant_moderator_default'] = 'Модератор';
$string['config_participant_moderator_default_description'] = 'Ово правило се стандардно користи када се додаје нова конференцијска соба.';
$string['config_poll_interval'] = 'Интервал анкетирања (у секундама) за освежавање статуса собе';
$string['config_poll_interval_description'] = 'Интервал анкетирања мора бити подешен на најмање 2 секунде. Уколико је потребно можете смањити оптерећење сервера продужавајући овај интервал.';
$string['config_presentation_default'] = 'Подразумевана презентација';
$string['config_presentation_default_description'] = 'Може се поставити датотека која ће се користити у свим конференцијским собама.';
$string['config_preuploadpresentation'] = 'Датотека презентације';
$string['config_preuploadpresentation_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције. Ово функционише само ако је Moodle сервер доступан BigBlueButtonu.';
$string['config_preuploadpresentation_editable'] = 'Датотека презентације на страници активности';
$string['config_preuploadpresentation_editable_description'] = 'Опција у подешавањима активности за постављање датотеке презентације која се приказује на страници активности.';
$string['config_profile_picture_enabled'] = 'Прикажи слике профила';
$string['config_profile_picture_enabled_description'] = 'Да ли профилне слике учесника треба да буду приказане у BigBlueButton сесијама?';
$string['config_recording'] = 'Снимање';
$string['config_recording_all_from_start_default'] = 'Започните снимање од почетка';
$string['config_recording_all_from_start_default_description'] = 'Да ли подешавање \'Започните снимање од почетка\' треба да буде стандардно омогућено када се додаје нова BigBlueButton соба?';
$string['config_recording_all_from_start_editable'] = 'Опција \'Започните снимање од почетка\' може да уређује';
$string['config_recording_all_from_start_editable_description'] = 'Да ли опција \'Започните снимање од почетка\' може да се уређује на страници за подешавање BigBlueButton активности?';
$string['config_recording_default'] = 'Снимање је стандардно омогућено';
$string['config_recording_default_description'] = 'Да ли подешавање \'Сесија може бити снимљена\' треба да буде стандардно омогућена када се додаје нова BigBlueButton соба?';
$string['config_recording_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_recording_editable'] = 'Опција \'Сесија се може снимити\' може да уређује';
$string['config_recording_editable_description'] = 'Да ли опција \'Сесија се може снимити\' може да се уређује на страници за подешавање BigBlueButton активности?';
$string['config_recording_hide_button_default'] = 'Сакриј дугме за снимање';
$string['config_recording_hide_button_default_description'] = 'Ако је означено, дугме за снимање биће сакривено';
$string['config_recording_hide_button_editable'] = 'Опција \'Сакриј дугме за снимање\' може да се уређује';
$string['config_recording_hide_button_editable_description'] = 'Да ли опција \'Сакриј дугме за снимање\' може да се уређује на страници за подешавање BigBlueButton активности?';
$string['config_recording_protect_editable'] = 'Статус заштићености снимака се може да се уређује';
$string['config_recording_protect_editable_description'] = 'Ако је ово означено, у корисничком интерфејсу ће се видети опција за постављање/уклањање заштите снимака.';
$string['config_recording_refresh_period'] = 'Период освежавања снимања (у секундама)';
$string['config_recording_refresh_period_description'] = 'Колико често треба тражити од BigBlueButton сервера да освежи удаљене информације за снимак?';
$string['config_recording_safe_formats'] = 'Формати снимања које могу да виде сви';
$string['config_recording_safe_formats_description'] = 'Изаберите формате које могу да виде сви.
Све остале формате могу да виде само предавачи и други корисници са способностима mod/bigbluebuttonbn:viewallrecordingformats и  mod/bigbluebuttonbn:managerecordings';
$string['config_recordingready_enabled'] = 'Пошаљите доступно обавештење о снимку';
$string['config_recordingready_enabled_description'] = 'Ако је ова опциjа омогућена, биће послато обавештење када линк снимка буде доступан. Ова функција захтева да скрипта post_publish_recording_ready_callback буде омогућена на BigBlueButton серверу.';
$string['config_recordings'] = 'Приказ снимака';
$string['config_recordings_asc_sort'] = 'Поређајте снимке хронолошким редоследом.';
$string['config_recordings_asc_sort_description'] = 'Снимци су поређани по датуму, било хронолошким или обрнутим хронолошким редоследом (прво последњи снимак).';
$string['config_recordings_deleted_default'] = 'Опција \'Укључи снимке из обрисаних активности\' је стандардно омогућена';
$string['config_recordings_deleted_default_description'] = 'Ако је ова опција омогућена, табела са снимцима ће садржати снимке свих активности које су у међувремену обрисане.';
$string['config_recordings_deleted_editable'] = 'Опција \'Укључи снимке из обрисаних активности\' може да се уређује';
$string['config_recordings_deleted_editable_description'] = 'Опција \'Укључи снимке из обрисаних активности\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_recordings_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_recordings_general'] = 'Прикажи подешавања за снимање';
$string['config_recordings_general_description'] = 'Ова подешавања се користе само приликом приказивања снимака';
$string['config_recordings_imported_default'] = 'Опција \'Прикажи само увезене линкове\' је стандардно омогућена';
$string['config_recordings_imported_default_description'] = 'Ако је ова опција омогућена табела са снимцима ће садржати само линкове ка снимцима.';
$string['config_recordings_imported_editable'] = 'Опција \'Прикажи само увезене линкове\' може да се мења';
$string['config_recordings_imported_editable_description'] = 'Опција \'Прикажи само увезене линкове\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_recordings_preview_default'] = 'Опција \'Преглед\' је стандардно омогућена';
$string['config_recordings_preview_default_description'] = 'Ако је ова опција омогућена табела са снимцима ће садржати преглед презентације.';
$string['config_recordings_preview_editable'] = 'Опција \'Преглед\' може да се уређује';
$string['config_recordings_preview_editable_description'] = 'Опција \'Преглед\' може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_scheduled'] = 'Планиране сесије';
$string['config_scheduled_description'] = 'Ова подешавања дефинишу стандардна понашања за планиране сесије.';
$string['config_scheduled_pre_opening'] = 'Сесија доступна пре отварања';
$string['config_scheduled_pre_opening_description'] = 'Временски период у минутима, током којег ће моћи да се приступи конференцијској соби и пре планираног времена њеног отварања.';
$string['config_server_url'] = 'URL адреса BigBlueButton сервера';
$string['config_server_url_description'] = 'URL адреса вашег BigBlueButton сервера.';
$string['config_shared_secret'] = 'BigBlueButton дељени тајни кључ';
$string['config_shared_secret_description'] = 'Безбедносни тајни кључ вашег BigBlueButton сервера.';
$string['config_showpresentation_default'] = 'Прикажи датотеку презентације на страници активности';
$string['config_showpresentation_default_description'] = 'Да ли полазници треба да имају приступ датотеци презентације пре сесије? Ово подешавање нема утицаја на кориснике који имају могућност \'Увек види датотеку презентације на страници активности\'.';
$string['config_showpresentation_editable'] = 'Опција \'Прикажи датотеку презентације на страници активности\'';
$string['config_showpresentation_editable_description'] = 'Опција у подешавањима активности за предаваче која им пружа могућност да изаберу да ли да приказују датотеку презентације полазницима.';
$string['config_uidelegation_enabled'] = 'Прослеђивање корисничког интерфејса је омогућено';
$string['config_uidelegation_enabled_description'] = 'Ова подешавања омогућавају или онемогућавају прослеђивање корисничког интерфејса BigBlueButton серверу.';
$string['config_userlimit'] = 'Ограничење броја корисника';
$string['config_userlimit_default'] = 'Опција \'Ограничење броја корисника\' је стандардно омогућена';
$string['config_userlimit_default_description'] = 'Број корисника који је стандардно дозвољен на сесији када се дода нова конференцијска соба. Подесите на 0 како бисте дозволили неограничен број корисника.';
$string['config_userlimit_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_userlimit_editable'] = 'Опција \'Ограничење броја корисника\' може да се уређује';
$string['config_userlimit_editable_description'] = 'Опција \'Ограничење броја корисника\' која је стандардно омогућена може да се уређује када се додаје или ажурира конференцијска соба.';
$string['config_voicebridge'] = 'Гласовни мост';
$string['config_voicebridge_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_voicebridge_editable'] = 'Конференцијски гласовни мост се може да се уређује';
$string['config_voicebridge_editable_description'] = 'Број конференцијског гласовног моста може се трајно доделити соби. Када је додељен, број се не може користити ни за једну другу собу.';
$string['config_waitformoderator'] = 'Сачекајте модератора';
$string['config_waitformoderator_cache_ttl'] = 'Сачекајте модератора - TTL кеш (секунде)';
$string['config_waitformoderator_cache_ttl_description'] = 'Како би подржао велики број клијената, овај додатак користи кеш меморију. Овај параметар дефинише колико дуго ће се кеш чувати пре него што се пошаље следећи захтев BigBlueButton серверу.';
$string['config_waitformoderator_default'] = 'Опција \'Сачекајте модератора\' је стандардно омогућено';
$string['config_waitformoderator_default_description'] = 'Да ли опција \'Сачекајте модератора\' треба да буде стандардно омогућена када се додаје нова BigBlueButton соба?';
$string['config_waitformoderator_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_waitformoderator_editable'] = 'Опција \'Сачекајте модератора\' може да се уређује';
$string['config_waitformoderator_editable_description'] = 'Да ли опција \'Сачекајте модератора\' може да се уређује на страници за подешавање BigBlueButton активности?';
$string['config_waitformoderator_ping_interval'] = 'Сачекајте модератора - пинг сигнал (секунде)';
$string['config_waitformoderator_ping_interval_description'] = 'Колико често треба слати серверу пинг сигнал да би се проверило да ли је модератор ушао у конференцијску собу?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton користи config.php датотеку са глобалном променљивом која је застарела. Конвертујте датотеку јер неће бити подржана у будућим верзијама.';
$string['config_warning_curl_not_installed'] = 'Ова функционалност захтева да php екстензија CURL буде инсталирана и омогућена. Подешавања ће бити доступна само ако је испуњен овај услов.';
$string['config_welcome_default'] = 'Подразумевана порука добродошлице';
$string['config_welcome_default_description'] = 'Порука добродошлице се приказује када учесници уђу у собу. Ако је поље остављено празно, користи се језички стинг подешен у  \'mod_form_field_welcome_default\'.';
$string['config_welcome_editable'] = 'Опцију \'Подразумевана порука добродошлице\' могу да уређују предавачи';
$string['config_welcome_editable_description'] = 'Порука добродошлице може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['credentials_warning'] = 'Коришћење подразумеваних серверских акредитива ће ускоро истећи (погледајте напомену изнад како бисте добили нове акредитиве).';
$string['end_session_confirm'] = 'Да ли сте сигурни да желите да завршите сесију?';
$string['end_session_confirm_title'] = 'Стварно желите да завршите сесију?';
$string['end_session_notification'] = 'Сесија је завршена.';
$string['ends_at'] = 'Завршава се';
$string['event_activity_created'] = 'Aktivnost kreirana';
$string['event_activity_deleted'] = 'Aktivnost obrisana';
$string['event_activity_updated'] = 'Активност ажурирана';
$string['event_live_session'] = 'Сесија уживо';
$string['event_meeting_created'] = 'Sastanak kreiran';
$string['event_meeting_ended'] = 'Sastanak prisilno završen';
$string['event_meeting_joined'] = 'Sastanku pristupljeno';
$string['event_meeting_left'] = 'Sastanak napušten';
$string['event_recording_deleted'] = 'Снимак обрисан';
$string['event_recording_edited'] = 'Снимак уређиван';
$string['event_recording_imported'] = 'Снимак увезен';
$string['event_recording_protected'] = 'Снимак заштићен';
$string['event_recording_published'] = 'Снимак објављен';
$string['event_recording_unprotected'] = 'Заштита са снимка уклоњена';
$string['event_recording_unpublished'] = 'Објављивање снимка опозвано';
$string['event_recording_viewed'] = 'Снимак приказан';
$string['event_unknown'] = 'Непознати догађај';
$string['general_error_cannot_create_meeting'] = 'Није могуће креирати сесију.';
$string['general_error_cannot_get_recordings'] = 'Није могуће прибавити снимке.';
$string['general_error_no_answer'] = 'Празан одговор. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер покренут.';
$string['general_error_not_allowed_to_create_instances'] = 'Кориснику није дозвољено да креира било коју врсту инстанце.';
$string['general_error_not_found'] = 'Није могуће пронаћи BigBlueButton активност са идентификатором {$a}.';
$string['general_error_unable_connect'] = 'Није могуће повезати се са сервером. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер покренут.
Више информација : {$a}';
$string['guest_invitation_full_message'] = 'Поштовани,
<p>Позвани сте на BigBlueButton сесију <strong>{$a->name}</strong> на курсу {$a->course_fullname}.</p>
<p>Линк: {$a->guestjoinurl}<br/>
<p>Лозинка: {$a->guestpassword}</p>
<p>Ако вам је потребна помоћ, обратите се {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Поштовани/а,

Позвани сте на BigBlueButton сесију {$a->name} на курсу {$a->course_fullname}.

Линк: {$a->guestjoinurl}
Лозинка: {$a->guestpassword}

Ако вам је потребна помоћ, обратите се {$a->sender}.';
$string['guest_invitation_subject'] = 'Позивница: {$a->name} сесија на курсу {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Активност није пронађена.';
$string['guestaccess_add'] = 'Додајте госте';
$string['guestaccess_add_no_id'] = 'Није наведена ID ознака BigBlueButton инстанце.';
$string['guestaccess_copy_link'] = 'Копирај линк';
$string['guestaccess_copy_password'] = 'Копирај лозинку';
$string['guestaccess_emails'] = 'Адресе е-поште гостију';
$string['guestaccess_emails_help'] = 'Списак е-адреса, раздвојених зарезима';
$string['guestaccess_emails_invalidemail'] = 'Неисправна адреса е-поште: {$a}';
$string['guestaccess_feature_disabled'] = 'Приступ гостима је онемогућен.';
$string['guestaccess_invite_failure'] = 'Грешка {$a->errors} приликом слања позива на {$a->emails}.';
$string['guestaccess_invite_success'] = 'Позив ће бити послат на {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Приступи сесији';
$string['guestaccess_meeting_invalid_password'] = 'Погрешна лозинка.';
$string['guestaccess_meeting_link'] = 'Линк за састанак';
$string['guestaccess_meeting_not_started'] = 'Састанак још није почео. Молим дођите мало касније.';
$string['guestaccess_meeting_password'] = 'Лозинка за састанак';
$string['guestaccess_password'] = 'Лозинка';
$string['guestaccess_title'] = 'Додај госте овом састанку';
$string['guestaccess_username'] = 'Корисничко име за госте';
$string['index_confirm_end'] = 'Да ли желите да завршите сесију?';
$string['index_disabled'] = 'онемогућено';
$string['index_enabled'] = 'омогућено';
$string['index_ending'] = 'Сесија се завршава... молимо сачекајте';
$string['index_error_bbtn'] = 'BigBlueButton ID ознака {$a} је неисправна';
$string['index_error_checksum'] = 'Дошло је до грешке контролног збира. Проверите да ли сте унели исправан тајни кључ.';
$string['index_error_forciblyended'] = 'Није могуће приступити овој сесији зато што је ручно завршена.';
$string['index_error_noinstances'] = 'Не постоје инстанце BigBlueButton соба';
$string['index_error_unable_display'] = 'Није могуће приказати сесије. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер покренут.';
$string['index_heading'] = 'BigBlueButton собе';
$string['index_heading_actions'] = 'Акције';
$string['index_heading_group'] = 'Група';
$string['index_heading_moderator'] = 'Модератори';
$string['index_heading_name'] = 'Конференцијска соба';
$string['index_heading_recording'] = 'Снимак';
$string['index_heading_users'] = 'Корисници';
$string['index_heading_viewer'] = 'Посматрачи';
$string['indicator:cognitivedepth'] = 'BigBlueButton - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'BigBlueButton\'.';
$string['indicator:socialbreadth'] = 'BigBlueButton - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'BigBlueButton\'.';
$string['instance_type_default'] = 'Конференцијска соба са снимцима';
$string['instance_type_recording_only'] = 'Само снимци';
$string['instance_type_room_only'] = 'Само конференцијска соба';
$string['instanceprofilewithoutrecordings'] = 'Овај профил инстанце не може да прикаже снимке';
$string['managebbbextplugins'] = 'Управљање додацима за проширење BigBlueButtona';
$string['messageprovider:instance_updated'] = 'BigBlueButton сесија ажурирана';
$string['messageprovider:recording_ready'] = 'BigBlueButton снимак је доступан';
$string['minute'] = 'минут';
$string['minutes'] = 'минути';
$string['mod_form_block_general'] = 'Општа подешавања';
$string['mod_form_block_guestaccess'] = 'Приступ за госте';
$string['mod_form_block_participants'] = 'Улога додељена током сесије уживо';
$string['mod_form_block_presentation'] = 'Садржај презентације';
$string['mod_form_block_presentation_default'] = 'Подразумевани садржај презентације';
$string['mod_form_block_record'] = 'Подешавања снимања';
$string['mod_form_block_recordings'] = 'Приказ снимака';
$string['mod_form_block_room'] = 'Подешавања конференцијске собе';
$string['mod_form_block_schedule'] = 'Време сесије';
$string['mod_form_field_closingtime'] = 'Приступ сесији се затвара';
$string['mod_form_field_conference_name'] = 'Назив сесије';
$string['mod_form_field_disablecam'] = 'Онемогући веб камере';
$string['mod_form_field_disablemic'] = 'Онемогући микрофоне';
$string['mod_form_field_disablenote'] = 'Онемогући дељене белешке';
$string['mod_form_field_disableprivatechat'] = 'Онемогући приватни разговор';
$string['mod_form_field_disablepublicchat'] = 'Онемогући јавни разговор';
$string['mod_form_field_duration'] = 'Трајање';
$string['mod_form_field_duration_help'] = 'Подешавање трајања састанка ће утврдити максимално време састанка, како би он потрајао док се снимање не заврши.';
$string['mod_form_field_guestallowed'] = 'Дозволите приступ гостима';
$string['mod_form_field_hideuserlist'] = 'Сакриј списак корисника';
$string['mod_form_field_instanceprofiles'] = 'Тип инстанце';
$string['mod_form_field_instanceprofiles_help'] = 'Ако сесија треба да се снима, изаберите \'Конференцијска соба са снимцима\', у супротном \'Само конференцијска соба\'. Након што се сесија сними, ако више неће бити сесија, изаберите \'Само снимци\'.';
$string['mod_form_field_intro'] = 'Опис';
$string['mod_form_field_intro_help'] = 'Кратак опис конференцијске собе.';
$string['mod_form_field_mustapproveuser'] = 'Модератор мора да одобри гостима приступ сесији';
$string['mod_form_field_muteonstart'] = 'Искључите звук на почетку';
$string['mod_form_field_name'] = 'Назив конференцијске собе';
$string['mod_form_field_nosettings'] = 'Ниједно подешавање се не може мењати';
$string['mod_form_field_openingtime'] = 'Приступ сесији се отвара';
$string['mod_form_field_participant_add'] = 'Додај учесника';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Модератор';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Посматрач';
$string['mod_form_field_participant_list'] = 'Списак учесника';
$string['mod_form_field_participant_list_action_add'] = 'Додај';
$string['mod_form_field_participant_list_action_remove'] = 'Уклони';
$string['mod_form_field_participant_list_text_as'] = 'приступа сесији као';
$string['mod_form_field_participant_list_type_all'] = 'Сви уписани корисници';
$string['mod_form_field_participant_list_type_owner'] = 'Власник';
$string['mod_form_field_participant_list_type_role'] = 'Улога';
$string['mod_form_field_participant_list_type_user'] = 'Корисник';
$string['mod_form_field_record'] = 'Сесија може бити снимљена';
$string['mod_form_field_recordallfromstart'] = 'Сними све од почетка';
$string['mod_form_field_recordhidebutton'] = 'Сакриј дугме за снимање';
$string['mod_form_field_recordings_deleted'] = 'Укључи снимке из обрисаних активности';
$string['mod_form_field_recordings_html'] = 'Прикажи табелу у обичном HTML формату';
$string['mod_form_field_recordings_imported'] = 'Прикажи само увезене линкове';
$string['mod_form_field_recordings_preview'] = 'Прикажи преглед снимка';
$string['mod_form_field_room_name'] = 'Назив конференцијске собе';
$string['mod_form_field_showpresentation'] = 'Прикажи датотеку презентације на страници активности';
$string['mod_form_field_userlimit'] = 'Ограничење броја корисника';
$string['mod_form_field_userlimit_help'] = 'Максималан број корисника којима је дозвољено да присуствују сесији. Ако је лимит подешен на 0 онда је број корисника неограничен.';
$string['mod_form_field_voicebridge'] = 'Гласовни мост [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Грешка у формату. Потребно је да унесете број између 1 и 9999.';
$string['mod_form_field_voicebridge_help'] = 'Број између 1 и 9999 који корисници уносе за приступ гласовној сесији путем телефона. Ако је вредност 0 онда ће број статичког гласовног моста бити игнорисан, а BigBlueButton ће генерисати насумични број. Број 7 ће претходити унетом четвороцифреном броју.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Није јединствена вредност. Овај број већ користе друга конференцијска соба.';
$string['mod_form_field_wait'] = 'Сачекајте модератора';
$string['mod_form_field_wait_help'] = 'Да ли учесници морају да сачекају модератора пре него што уђу у конференцијску собу?';
$string['mod_form_field_welcome'] = 'Порука добродошлице';
$string['mod_form_field_welcome_default'] = 'Добро дошли на %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Порука добродошлице се приказује када учесници уђу у собу. Ако је поље остављено празно, онда се приказује подразумевана порука подешена у администрацији сајта.';
$string['mod_form_locksettings'] = 'Подешавања закључавања';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton је веб-конференцијски систем отвореног кôда, за онлајн учење, који подржава дељење у реалном времену аудио и видео клипова, слајдова, дељење екрана, вишекорисничку таблу, одвојене собе, анкетирање и емотиконе.

Користећи BigBlueButton можете да креирате конференцијску собу за сесије као што су онлајн часови уживо, онлајн консултаије или групни колаборативни рад са удаљеним полазницима. Сесија се може снимити за каснију репродукцију.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton активност';
$string['nosuchinstance'] = 'Нема такве инстанце {$a->entity} са ID ознаком {$a->id}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton соба је креирана.';
$string['notification_instance_created_small'] = 'Нова BigBlueButton соба под називом {$a->name} је креирана';
$string['notification_instance_created_subject'] = 'Нова BigBlueButton соба је креирана';
$string['notification_instance_description'] = 'Опис';
$string['notification_instance_end_date'] = 'Датум завршетка';
$string['notification_instance_name'] = 'Назив';
$string['notification_instance_start_date'] = 'Датум почетка';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton соба је ажурирана.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton сесија је ажурирана';
$string['notification_instance_updated_subject'] = 'Ваша BigBlueButton соба је ажурирана';
$string['notification_recording_ready_html'] = 'Снимак је сада доступан за сесију у BigBlueButton соби <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Снимак је сада доступан за сесију у BigBlueButton соби {$a->name}. Идите на {$a->link} како бисте приступили линку снимка';
$string['notification_recording_ready_small'] = 'Доступан је снимак за BigBlueButton собу {$a->name}.';
$string['notification_recording_ready_subject'] = 'Снимак доступан';
$string['pluginadministration'] = 'Администрација BigBlueButtona';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Да бисте креирали и приступили BigBlueButton сесији, кориснички подаци морају да се размене са сервером.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Пуно име корисника који приступа BigBlueButton серверу.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID ознака корисника који приступа BigBlueButton серверу.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Конфигурација BigBlueButton сесије';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Списак правила која дефинишу улогу коју ће корисници имати у BigBlueButton сесији. ID ознака корисника може бити сачуван јер се дозволе могу доделити према улози односно према кориснику.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Чува догађаје покренуте приликом коришћења додатка.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Тип догађаја који је покренуо корисник.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID ознака сесије којој је корисник имао приступ.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Додатне информације везане за сесију или снимак.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Време када је запис креиран.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID ознака корисника који је покренуо догађај.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Чува метаподатке о снимцима.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID ознака корисника који је последњи променио снимак.';
$string['progress_createbigbluebuttonbn'] = 'Креирање BigBlueButton активности ({$a})';
$string['recordingnotfound'] = 'Снимак није пронађен.';
$string['recordings_from_deleted_activities'] = 'Снимци из обрисаних активности';
$string['recordingurlnotfound'] = 'URL адреса снимка је неисправна.';
$string['removedevents'] = 'Обрисани догађаји';
$string['removedlogs'] = 'Обрисани прилагођени записи';
$string['removedrecordings'] = 'Обрисани снимци';
$string['removedtags'] = 'Обрисане ознаке';
$string['report_join_info'] = 'број састанака: {$a}';
$string['report_play_recording_info'] = 'број пуштених снимака: {$a}';
$string['report_room_view'] = 'приказана';
$string['resetevents'] = 'Oбриши догађаје';
$string['resetlogs'] = 'Обриши прилагођене записе';
$string['resetlogs_help'] = 'Брисање записа ће за последицу имати губитак референци на снимке.';
$string['resetrecordings'] = 'Обриши снимке';
$string['resetrecordings_help'] = 'Брисање снимака учиниће их недоступним са било ког места. Ова акција се не може опозвати!';
$string['resettags'] = 'Обриши ознаке';
$string['search:activity'] = 'BigBlueButton - информације о активности';
$string['search:tags'] = 'BigBlueButton - информације о ознакама';
$string['sendnotification'] = 'Пошаљи обавештење';
$string['settings'] = 'Подешавања BigBlueButtona';
$string['settings_credential_warning'] = 'Акредитиви за BigBlueButton сервер ускоро ће истећи. За више информација погледајте <a href="{$a->settingslink}" target="_blank"> општа подешавања BigBlueButtona (отварају се у новом прозору)</a>.';
$string['settings_credential_warning_no_capability'] = 'Акредитиви за BigBlueButton сервер ускоро ће истећи. Обратите се администратору вашег сајта.';
$string['started_at'] = 'Почело';
$string['starts_at'] = 'Почиње';
$string['subplugintype_bbbext'] = 'Проширење BigBlueButton активности';
$string['subplugintype_bbbext_plural'] = 'Проширења BigBlueButton активности';
$string['taskname:check_dismissed_recordings'] = 'Провера снимака који још нису пронађени';
$string['taskname:check_pending_recordings'] = 'Преузимање снимака на чекању';
$string['userlimitreached'] = 'Достигнут је број дозвољених корисника у сесији.';
$string['view_conference_action_end'] = 'Заврши сесију';
$string['view_conference_action_join'] = 'Приступи сесији';
$string['view_error_action_not_completed'] = 'Акција није могла да се заврши';
$string['view_error_bigbluebutton'] = 'BigBlueButton је послао поруку о грешци. {$a}';
$string['view_error_create'] = 'BigBlueButton север је одговорио са поруком о грешци. Није било могуће креирати конференцијску собу.';
$string['view_error_current_state_not_found'] = 'Тренутни статус није пронађен. Снимак је можда избрисан или BigBlueButton сервер није компатибилан са извршеном акцијом.';
$string['view_error_import_no_courses'] = 'Не постоје курсеви за претрагу снимака.';
$string['view_error_import_no_recordings'] = 'На овом курсу нема снимака за увоз.';
$string['view_error_invalid_session'] = 'Сесија је истекла. Вратите се на страницу активности.';
$string['view_error_max_concurrent'] = 'Достигнут је дозвољени број истовремених сесија.';
$string['view_error_meeting_not_running'] = 'Нешто није било у реду; сесија није покренута.';
$string['view_error_no_group'] = 'Не постоје групе. Морате да их креирате пре него што покушате да приступите сесији.';
$string['view_error_no_group_student'] = 'Нисте додати у групу. Молимо, контактирајте свог предавача.';
$string['view_error_no_group_teacher'] = 'Не постоје групе. Морате да их креирате.';
$string['view_error_unable_join'] = 'Није могуће приступити конференцијској соби. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер ради.';
$string['view_error_unable_join_student'] = 'Није могуће успоставити везу са BigBlueButton сервером.';
$string['view_error_unable_join_teacher'] = 'Није могуће успоставити везу са BigBlueButton сервером. Молимо, контактирајте администратора.';
$string['view_error_url_missing_parameters'] = 'Постоје параметри који недостају у овој URL адреси';
$string['view_error_userlimit_reached'] = 'Достигнуто је ограничење броја дозвољених корисника у сесији.';
$string['view_groups_nogroups_warning'] = 'Конференцијска соба је конфигурисана за коришћење група, али на нивоу курса нема дефинисаних групе.';
$string['view_groups_notenrolled_warning'] = 'Конференцијска соба је конфигурисана за коришћење група, али ви нисте члан ниједне групе.';
$string['view_groups_selection'] = 'Изаберите групу којој желите да приступите и потврдите акцију';
$string['view_groups_selection_join'] = 'Приступите';
$string['view_groups_selection_warning'] = 'Постоји конференцијска соба за сваку групу. Ако имате приступ већем броју соба будите сигурни да сте изабрали праву.';
$string['view_login_moderator'] = 'Пријављивање као модератор...';
$string['view_login_viewer'] = 'Пријављивање као посматрач...';
$string['view_message_and'] = 'и';
$string['view_message_conference_has_ended'] = 'Сесија је завршена.';
$string['view_message_conference_in_progress'] = 'Ова сесија је у току.';
$string['view_message_conference_not_started'] = 'Сесија још није почела.';
$string['view_message_conference_room_ready'] = 'Ова конференцијска соба је спремна. Сада можете да приступите сесији.';
$string['view_message_conference_user_limit_reached'] = 'Достигнуто је ограничење броја дозвољених корисника у сесији.';
$string['view_message_conference_wait_for_moderator'] = 'Сачекајте да модератор приступи.';
$string['view_message_cron_disabled'] = 'Списак снимака можда није ажуриран. Молимо контактирајте администратора сајта са следећим информацијама: {$a}';
$string['view_message_finished'] = 'Ова активност је завршена.';
$string['view_message_has_joined'] = 'приступио/ла је';
$string['view_message_have_joined'] = 'приступили су';
$string['view_message_hour'] = 'сат';
$string['view_message_hours'] = 'сати';
$string['view_message_importrecordings_disabled'] = 'Увоз линкова снимака је онемогућен на серверу.';
$string['view_message_minute'] = 'минут';
$string['view_message_minutes'] = 'минути';
$string['view_message_moderator'] = 'Модератор';
$string['view_message_moderators'] = 'Модератори';
$string['view_message_norecordings'] = 'Нема доступних снимака.';
$string['view_message_notavailableyet'] = 'Ова сесија још није доступна.';
$string['view_message_recordings_disabled'] = 'Снимци су онемогућени на серверу. BigBlueButton активности типа \'Само снимци\' се не могу користити';
$string['view_message_room_closed'] = 'Ова конференцијска соба је затворена.';
$string['view_message_room_open'] = 'Ова конференцијска соба је отворена.';
$string['view_message_room_ready'] = 'Ова конференцијска соба је спремна.';
$string['view_message_session_for'] = 'сесија за';
$string['view_message_session_has_user'] = 'Постоји';
$string['view_message_session_has_users'] = 'Постоје';
$string['view_message_session_no_users'] = 'Нема корисника у овој сесији';
$string['view_message_session_running_for'] = 'Ова сесија траје већ';
$string['view_message_session_started_at'] = 'Сесија је почела у';
$string['view_message_tab_close'] = 'Ова картица/прозор мора ручно да се затвори';
$string['view_message_times'] = 'пута';
$string['view_message_user'] = 'Корисник';
$string['view_message_users'] = 'Корисници';
$string['view_message_viewer'] = 'Посматрач';
$string['view_message_viewers'] = 'Посматрачи';
$string['view_mobile_message_groups_not_supported'] = 'Ова инстанца је омогућена за рад са групама, али је мобилна апликација још увек не подржава. Молимо вас, користите веб верзију.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Провели сте више од 45 секунди на овој страници. Освежите страницу да бисте се придружили сесији.';
$string['view_noguests'] = 'BigBlueButton соба није отворена за госте.';
$string['view_nojoin'] = 'Немате улогу којој дозвољено да приступи овој сесији.';
$string['view_recording'] = 'снимак';
$string['view_recording_actionbar'] = 'Трака са алаткама';
$string['view_recording_activity'] = 'Активност';
$string['view_recording_button_import'] = 'Увези линкове снимака';
$string['view_recording_button_return'] = 'Врати се';
$string['view_recording_course'] = 'Курс';
$string['view_recording_date'] = 'Датум';
$string['view_recording_delete_confirmation'] = 'Да ли сте сигурни да желите да обришете {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Овај снимак има {$a} повезана/их линк(ов)а који су били увезени у друге курсеве или активности. Ако се снимак обрише, ови линкови ће такође бити уклоњени.';
$string['view_recording_delete_confirmation_warning_s'] = 'Овај снимак има {$a} повезани линк који је увезен у други курс или активност. Ако се снимак обрише, овај линк ће такође бити уклоњен.';
$string['view_recording_description'] = 'Опис';
$string['view_recording_description_edithint'] = 'Може се додати опис који ће помоћи у идентификацији снимка.';
$string['view_recording_description_editlabel'] = 'Уреди опис';
$string['view_recording_duration'] = 'Трајање';
$string['view_recording_duration_min'] = 'мин';
$string['view_recording_format_errror_unreachable'] = 'URL адреса за овај формат снимка је недоступан.';
$string['view_recording_format_notes'] = 'Белешке';
$string['view_recording_format_podcast'] = 'Поткаст';
$string['view_recording_format_presentation'] = 'Презентација';
$string['view_recording_format_screenshare'] = 'Дељење екрана';
$string['view_recording_format_statistics'] = 'Статистика';
$string['view_recording_format_video'] = 'Видео';
$string['view_recording_import_confirmation'] = 'Да ли сте сигурни да желите да увезете овај снимак?';
$string['view_recording_length'] = 'Дужина';
$string['view_recording_link'] = 'увезен линк';
$string['view_recording_link_warning'] = 'Ово је линк који показује на снимак који је креиран унутар другог курса или активности';
$string['view_recording_list_action_delete'] = 'Брисање';
$string['view_recording_list_action_edit'] = 'Ажурирање';
$string['view_recording_list_action_play'] = 'Репродукуј снимак';
$string['view_recording_list_action_process'] = 'Обрада';
$string['view_recording_list_action_protect'] = 'Заштита';
$string['view_recording_list_action_publish'] = 'Објављивање';
$string['view_recording_list_action_unprotect'] = 'Уклањање заштите';
$string['view_recording_list_action_unpublish'] = 'Опозив објављивања';
$string['view_recording_list_action_update'] = 'Ажурирање';
$string['view_recording_list_actionbar'] = 'Трака са алаткама';
$string['view_recording_list_actionbar_delete'] = 'Обриши';
$string['view_recording_list_actionbar_edit'] = 'Уреди';
$string['view_recording_list_actionbar_hide'] = 'Сакриј';
$string['view_recording_list_actionbar_import'] = 'Увоз';
$string['view_recording_list_actionbar_protect'] = 'Учини снимак приватним';
$string['view_recording_list_actionbar_publish'] = 'Објави';
$string['view_recording_list_actionbar_show'] = 'Прикажи';
$string['view_recording_list_actionbar_unprotect'] = 'Учини снимак јавним';
$string['view_recording_list_actionbar_unpublish'] = 'Опозови објављени снимак';
$string['view_recording_list_activity'] = 'Активност';
$string['view_recording_list_course'] = 'Курс';
$string['view_recording_list_date'] = 'Датум';
$string['view_recording_list_description'] = 'Опис';
$string['view_recording_list_duration'] = 'Трајање';
$string['view_recording_list_recording'] = 'Снимак';
$string['view_recording_meeting'] = 'Састанак';
$string['view_recording_modal_button'] = 'Примени';
$string['view_recording_modal_title'] = 'Подесите вредности за снимање';
$string['view_recording_name'] = 'Назив';
$string['view_recording_name_edithint'] = 'Може се додати назив како би се лакше идентификовао снимак.';
$string['view_recording_name_editlabel'] = 'Уреди назив';
$string['view_recording_playback'] = 'Репродукција';
$string['view_recording_preview'] = 'Преглед';
$string['view_recording_preview_help'] = 'Пређите курсором преко слике како бисте је видели у пуној величини';
$string['view_recording_protect_confirmation'] = 'Да ли сте сигурни да желите да заштитите овај снимак {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Овај снимак има {$а} повезане/их везе/а које су импортоване у друге курсеве или активности. Ако је снимак заштићен, то ће утицати и на импортоване везе.';
$string['view_recording_protect_confirmation_warning_s'] = 'Овај снимак има {$а} повезану везу која је импортована у други курс или активност. Ако је снимак заштићен, то ће утицати и на импортоване везе.';
$string['view_recording_publish_confirmation'] = 'Да ли сте сигурни да желите да објавите овај снимак {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Овај снимак има {$а} повезане/их везе/а које су импортоване у друге курсеве или активности. Ако је снимак објављен, биће објављени и ови линкови.';
$string['view_recording_publish_confirmation_warning_s'] = 'Овај снимак има {$а} повезану везу која је импортована у други курс или активност. Ако је снимак објављен, биће објављен и овај линк.';
$string['view_recording_publish_link_deleted'] = 'Овај линк не може бити поново објављен јер оригинални снимак не постоји на BigBlueButton серверу. Линк треба уклонити.';
$string['view_recording_publish_link_not_published'] = 'Овај линк не може бити поново објављен јер оригинални снимак није објављен (тј. дозвола за његово објављивање је опозвана).';
$string['view_recording_recording'] = 'Снимак';
$string['view_recording_select_course'] = 'Прво изаберите курс у падајућем менију';
$string['view_recording_tags'] = 'Ознаке';
$string['view_recording_unprotect_confirmation'] = 'Да ли сте сигурни да желите да скинете заштиту са овог снимка {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Овај снимак има {$a} повезана/их линк(ов)а које су импортовани у друге курсеве или активности. Ако снимак није заштићен, то ће утицати и на импортоване линкове.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Овај снимак има {$a} повезани линк које je импортован у други курс или активност. Ако снимак није заштићен, то ће утицати и на импортоване линкове.';
$string['view_recording_unprotect_link_deleted'] = 'Са овог линка (снимка) заштита не може да се уклони јер оригинални снимак не постоји на BigBlueButton серверу. Линк треба уклонити.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Са овог линка (снимка) заштита не може да се уклони јер је оригинални снимак заштићен.';
$string['view_recording_unpublish_confirmation'] = 'Да ли сте сигурни да желите да опозовете објаву овог снимка {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Овај снимак има {$a} придружена/их линк(ов)а који су били увезени у друге курсеве или активности. Ако се опозове објава снимка онда ће и ти линкови бити опозвани.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Овај снимак има {$a} придружени линк који је био увезен у други курс или активност. Ако се опозове објава снимка онда ће и тај линк бити опозван.';
$string['view_recording_yui_first'] = 'Прва';
$string['view_recording_yui_go'] = 'Иди';
$string['view_recording_yui_last'] = 'Последња';
$string['view_recording_yui_next'] = 'Следећа';
$string['view_recording_yui_page'] = 'Страница';
$string['view_recording_yui_prev'] = 'Претходна';
$string['view_recording_yui_rows'] = 'Редови';
$string['view_recording_yui_show_all'] = 'Прикажи све';
$string['view_room'] = 'Прикажи конференцијску собу';
$string['view_section_title_presentation'] = 'Датотека презентације';
$string['view_section_title_recordings'] = 'Снимци';
$string['waitformoderator'] = 'Чека се да се модератор придружи.';
