<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sk', version '5.0'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Akcie pre rozhranie hodnotiteľa';
$string['actionsforpost'] = 'Akcie pre príspevok';
$string['activitydate:due'] = 'Termín:';
$string['activityoverview'] = 'Máte nové príspevky vo fóre';
$string['addanewdiscussion'] = 'Pridať novú diskusnú tému';
$string['addanewquestion'] = 'Pridať novú otázku';
$string['addanewtopic'] = 'Pridať novú tému';
$string['addreply'] = 'Pridať odpoveď';
$string['addtofavourites'] = 'Označiť túto diskusiu hviezdičkou';
$string['advancedsearch'] = 'Rozšírené vyhľadávanie';
$string['alldiscussions'] = 'Všetky diskusie';
$string['allforums'] = 'Všetky fóra';
$string['allowdiscussions'] = 'Môže {$a} prispievať do tohto fóra?';
$string['allowsallsubscribe'] = 'V tomto fóre si môže každý zvoliť, či bude odoberať príspevky alebo nie.';
$string['allowsdiscussions'] = 'Toto fórum povoľuje každému začať jednu diskusnú tému.';
$string['allsubscribe'] = 'Odoberať príspevky e-mailom zo všetkých fór';
$string['allunsubscribe'] = 'Zrušiť odoberanie príspevkov e-mailom zo všetkých fór';
$string['allusers'] = 'Všetci používatelia';
$string['alreadyfirstpost'] = 'Toto je už prvý príspevok v tomto fóre';
$string['anyfile'] = 'Akýkoľvek súbor';
$string['areaattachment'] = 'Prílohy';
$string['areapost'] = 'Správy';
$string['attachment'] = 'Príloha';
$string['attachment_help'] = 'Máte možnosť pridať jeden alebo viacero súborov do príspevku fóra. Ak pridáte obrázok, zobrazí sa priamo v príspevku.';
$string['attachmentname'] = 'Príloha {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Nemôžete exportovať prílohy bez ID čísla';
$string['attachments'] = 'Prílohy';
$string['attachmentswordcount'] = 'Prílohy a počet slov';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} odpovedajúci súkromne {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} odpoveď  {$a->author}';
$string['availability'] = 'Dostupnosť';
$string['blockafter'] = 'Blokovať po dosiahnutí počtu príspevkov';
$string['blockafter_help'] = 'Toto nastavenie určuje maximálny počet príspevkov, ktoré môže používateľ vložiť počas určeného časového intervalu. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Blokačné obdobie';
$string['blockperiod_help'] = 'Je možné zablokovať študentov predtým, aby vkladali viac ako maximálny počet príspevkov počas určeného časového intervalu. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['blockperioddisabled'] = 'Neblokovať';
$string['blogforum'] = 'Fórum sa zobrazuje v štandardnom formáte blogu';
$string['bynameondate'] = 'autor {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Stav sledovania fóra pre používateľa';
$string['calendardue'] = '{$a} má termín';
$string['cancelreply'] = 'Zrušiť odpoveď';
$string['cannotadd'] = 'Nie je možné pridať diskusiu do tohto fóra';
$string['cannotadddiscussion'] = 'Aby ste mohli pridávať diskusie do tohto fóra, musíte byť členmi skupiny.';
$string['cannotadddiscussionall'] = 'Nemáte oprávnenia pridať novú tému diskusie pre všetkých účastníkov.';
$string['cannotadddiscussiongroup'] = 'Nemôžete vytvoriť diskusiu, pretože nie ste členom žiadnej skupiny.';
$string['cannotaddsubscriber'] = 'Nie je možné pridať do fóra účastníkov s ID číslom {$a}!';
$string['cannotaddteacherforumto'] = 'Nebolo možné vložiť skonvertované učiteľské fórum do nultej sekcie v kurze.';
$string['cannotcreatediscussion'] = 'Nie je možné pridať novú diskusiu';
$string['cannotcreateinstanceforteacher'] = 'Nebolo možné vytvoriť nové učiteľské fórum.';
$string['cannotdeletepost'] = 'Nemôžete vymazať tento príspevok!';
$string['cannoteditposts'] = 'Nemáte oprávnenie upraviť príspevky iných účastníkov!';
$string['cannotexportforum'] = 'Toto fórum nie je možné exportovať';
$string['cannotfavourite'] = 'Ľutujeme, ale nemáte oprávnenie k označeniu diskusie hviezdičkou.';
$string['cannotfinddiscussion'] = 'Diskusia nebola nájdená v tomto fóre';
$string['cannotfindfirstpost'] = 'V tomto fóre nebol nájdený prvý príspevok';
$string['cannotfindorcreateforum'] = 'Nebolo možné nájsť alebo vytvoriť hlavné oznamovacie fórum pre portál.';
$string['cannotfindparentpost'] = 'Nebolo možné nájsť nadradený príspevok pre príspevok {$a}';
$string['cannotmovefromsingleforum'] = 'Nie je možné presunúť diskusiu z typu jednoduché diskusné fórum';
$string['cannotmovenotvisible'] = 'Fórum nie je viditeľné';
$string['cannotmovetonotexist'] = 'Nemôžete sa presunúť na toto fórum, pretože neexistuje.';
$string['cannotmovetonotfound'] = 'Cieľové fórum nebolo v tomto kurze nájdené.';
$string['cannotmovetosingleforum'] = 'Nie je možné presunúť diskusiu na jednoduché samostatné diskusné fórum';
$string['cannotpindiscussions'] = 'Ľutujeme, ale nemáte oprávnenie k pripichnutiu diskusie.';
$string['cannotpurgecachedrss'] = 'Nepodarilo sa vyčistiť uložené RSS zdroje pre zdrojové a/alebo cieľové diskusné fóra - skontrolujte súbor permissionsforums.';
$string['cannotremovesubscriber'] = 'Z  tohto fóra nie je možné odstrániť používateľa s ID číslom {$a}';
$string['cannotreply'] = 'Nemôžete odpovedať na tento príspevok';
$string['cannotsplit'] = 'Diskusia z tohto fóra nemôže byť rozdelená ';
$string['cannotsubscribe'] = 'Prepáčte, ak sa chcete prihlásiť, musíte byť členom skupiny.';
$string['cannottrack'] = 'Nie je možné zastaviť sledovanie tohto fóra';
$string['cannotunsubscribe'] = 'Nie je možné vás odhlásiť z tohto fóra';
$string['cannotupdatepost'] = 'Nemôžete aktualizovať tento príspevok';
$string['cannotviewpostyet'] = 'Nemôžete si prezrieť otázky iných študentov, pretože ste ešte nevložili svoj príspevok.';
$string['cannotviewusersposts'] = 'Nemáte prístup k príspevkom tohto používateľa';
$string['cleanreadtime'] = 'Čas kedy označiť staré príspevky ako prečítané.';
$string['clicktofavourite'] = 'Túto diskusiu ste neoznačili, kliknite pre označenie hviezdičkou.';
$string['clicktolockdiscussion'] = 'Kliknutím túto diskusiu zamknete';
$string['clicktosubscribe'] = 'Nie ste zaradený do tejto diskusie. Kliknite na tlačidlo Odoberať.';
$string['clicktounfavourite'] = 'Túto diskusiu ste označili hviezdičkou. Kliknutím odznačíte.';
$string['clicktounlockdiscussion'] = 'Kliknutím túto diskusiu odomknete';
$string['clicktounsubscribe'] = 'Ste zaradený do tejto diskusie. Kliknite na tlačidlo Odhlásiť odoberanie.';
$string['close'] = 'Zavrieť';
$string['closegrader'] = 'Zavrieť hodnotenie';
$string['completiondetail:discussions'] = 'Začať diskusiu: {$a}';
$string['completiondetail:posts'] = 'Vytvoriť príspevky vo fóre: {$a}';
$string['completiondetail:replies'] = 'Odpovede na príspevky: {$a}';
$string['completiondiscussions'] = 'Počet diskusii, ktoré študent musí pridať:';
$string['completiondiscussionsdesc'] = 'Študent musí vytvoriť aspoň {$a} diskusií';
$string['completionposts'] = 'Počet odpovedí alebo diskusii, ktoré študent musí pridať:';
$string['completionpostsdesc'] = 'Študent musí zverejniť aspoň {$a} diskusií alebo odpovedí';
$string['completionpostshelp'] = 'Pre ukončenie sa vyžadujú sa diskusie alebo odpovede';
$string['completionreplies'] = 'Počet odpovedí, ktoré študent musí pridať:';
$string['completionrepliesdesc'] = 'Študent musí odoslať minimálne {$a} odpoveď/odpovedí';
$string['configcleanreadtime'] = 'Hodina, kedy sa budú staré príspevky odstraňovať z tabuľky prečítaných príspevkov.';
$string['configdigestmailtime'] = 'Ľuďom, ktorí sa rozhodnú pre zasielanie emailov v štruktúrovanej forme, bude každý deň prichádzať email stručne informujúci o najnovších udalostiach v kurze. Toto nastavenie určuje tú časť dňa, kedy bude tento email zasielaný používateľom (odošle ho nasledujúci cron po ukončení tejto hodiny).';
$string['configdisplaymode'] = 'Predvolený režim zobrazenia diskusie, ak nebol nastavený inak.';
$string['configenablerssfeeds'] = 'Týmto povolíte funkciu RSS kanálov pre všetky diskusné fóra. Budete ešte musieť zapnúť RSS kanály v nastaveniach jednotlivých fór.';
$string['configenabletimedposts'] = 'Nastavte \'áno\' ak chcete povoliť zobrazenie rozsahu času, kedy sa dá vkladať príspevok do fóra.';
$string['configlongpost'] = 'Akýkoľvek príspevok presahujúci túto dĺžku (v znakoch bez HTML) sa považuje za dlhý. Príspevky zobrazené na domovskej stránke lokality, na stránkach kurzov sociálneho formátu alebo v používateľských profiloch sú skrátené na prirodzenú hodnotu niekde medzi hodnotami forum_shortpost a forum_longpost.';
$string['configmanydiscussions'] = 'Maximálny počet diskusií vo fóre zobrazených na jednej stránke';
$string['configmaxattachments'] = 'Predvolené maximum počtu príloh pre každý príspevok';
$string['configmaxbytes'] = 'Východzia maximálna veľkosť prílohy vo všetkých fórach na týchto stránkach (môže byť upravená nastaveniami kurzu a ďalšími lokálnymi premennými)';
$string['configoldpostdays'] = 'Počet dní, po ktorých sa staré príspevky považujú za prečítané.';
$string['configreplytouser'] = 'Ak je príspevok odosielaný odberateľom, má email v položke Od: obsahovať adresu autora príspevku? Príjemca tak môže odpovedať priamo autorovi emailom a nie cez diskusné fórum. Aj keď je tu zvolená hodnota \'Áno\', používatelia si môžu vo svojich profiloch nastaviť skrývanie svojej emailovej adresy.';
$string['configrssarticlesdefault'] = 'Ak sú aktivované RSS kanály, nastaví štandardný počet článkov (buď diskusií, alebo príspevkov).';
$string['configrsstypedefault'] = 'Ak sú aktivované RSS kanály, nastaví štandardný typ aktivity.';
$string['configshortpost'] = 'Každý vložený príspevok pod túto veľkosť (v znakoch, HTML kód sa nepočíta) je považovaný za krátky (pozri nižšie).';
$string['configsubscriptiontype'] = 'Východzie nastavenie pre režim odberu.';
$string['configtrackingtype'] = 'Štandardné nastavenie pre sledovanie čítania.';
$string['configtrackreadposts'] = 'Nastavte na \'Áno\', ak chcete označiť príspevky ako prečítané/neprečítané pre každého používateľa.';
$string['configusermarksread'] = 'Ak je nastavenie \'Áno\', používateľ musí ručne označiť príspevok ako prečítaný. Ak \'Nie\', príspevok bude automaticky označený ako prečítaný, ak bude prezretý.';
$string['confirmsubscribe'] = 'Naozaj chcete odoberať príspevky z fóra \'{$a}\' mailom?';
$string['confirmsubscribediscussion'] = 'Skutočne si želáte prihlásiť sa na odoberanie diskusie \'{$a->discussion}\' vo fóre \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Naozaj chcete zrušiť odoberanie príspevkov z fóra \'{$a}\' mailom?';
$string['confirmunsubscribediscussion'] = 'Skutočne si želáte odhlásiť sa z odoberania diskusie \'{$a->discussion}\' vo fóre \'{$a->forum}\'?';
$string['couldnotadd'] = 'Kvôli neznámej chybe nie je možné pridať Váš príspevok';
$string['couldnotdeletereplies'] = 'Prepáčte, tento príspevok nemôže byť odstránený, pretože ľudia naň už reagovali';
$string['couldnotupdate'] = 'Kvôli neznámej chybe nie je možné aktualizovať Váš príspevok';
$string['created'] = 'Vytvorené';
$string['crontask'] = 'Zasielanie správ do fóra a jeho údržba';
$string['cutoffdate'] = 'Dátum ukončenia';
$string['cutoffdate_help'] = 'Ak je nastavené, fórum po tomto dátume neprijme príspevky.';
$string['cutoffdatereached'] = 'Toto fórum je už uzavrené, takže doň už nemôžete prispievať.';
$string['cutoffdatevalidation'] = 'Dátum ukončenia nemôže byť skôr ako dátum odovzdania.';
$string['delete'] = 'Odstrániť';
$string['deleteddiscussion'] = 'Diskusná téma bola odstránená';
$string['deletedpost'] = 'Príspevok bol odstránený';
$string['deletedposts'] = 'Tieto príspevky boli odstránené';
$string['deleteduser'] = 'Odstránený používateľ';
$string['deletesure'] = 'Naozaj chcete odstrániť tento príspevok?';
$string['deletesureplural'] = 'Naozaj chcete odstrániť tento príspevok a všetky odpovede naň? ({$a} príspevkov )';
$string['digestmailheader'] = 'Toto je Váš denný súhrn nových príspevkov v diskusiách na stránkach {$a->sitename}. Ak chcete zmeniť nastavenia týchto odberov, choďte na {$a->userprefs}.';
$string['digestmailpost'] = 'Zmeňte vaše preferencie prehľadov vo fóre';
$string['digestmailpostlink'] = 'Zmeniť nastavenia volieb diskusného fóra: {$a}';
$string['digestmailprefs'] = 'váš používateľský profil';
$string['digestmailsubject'] = '{$a}: súhrn nových príspevkov';
$string['digestmailtime'] = 'Hodina odosielania súhrnných emailov';
$string['digestsentusers'] = 'Súhrnné emaily nových príspevkov úspešne zaslané {$a} používateľom.';
$string['disallowsubscribe'] = 'Odoberanie e-mailom nie je povolené.';
$string['disallowsubscribeteacher'] = 'Odoberanie e-mailom nie je povolené (s výnimkou učiteľov).';
$string['disallowsubscription'] = 'Odoberanie';
$string['disallowsubscription_help'] = 'Toto fórum bolo konfigurované tak, že sa nemôžete prihlásiť na odoberanie diskusií.';
$string['discussion'] = 'Diskusia';
$string['discussionlistsortbycreatedasc'] = 'Triediť podľa dátumu vytvorenia vo vzostupnom poradí';
$string['discussionlistsortbycreateddesc'] = 'Triediť podľa dátumu vytvorenia v zostupnom poradí';
$string['discussionlistsortbydiscussionasc'] = 'Triediť podľa názvu diskusie vo vzostupnom poradí';
$string['discussionlistsortbydiscussiondesc'] = 'Triediť podľa názvu diskusie v zostupnom poradí';
$string['discussionlistsortbygroupasc'] = 'Triediť podľa skupiny vo vzostupnom poradí';
$string['discussionlistsortbygroupdesc'] = 'Triediť podľa skupiny v zostupnom poradí';
$string['discussionlistsortbylastpostasc'] = 'Triediť podľa dátumu vytvorenia posledného príspevku vo vzostupnom poradí';
$string['discussionlistsortbylastpostdesc'] = 'Triediť podľa dátumu vytvorenia posledného príspevku v zostupnom poradí';
$string['discussionlistsortbyrepliesasc'] = 'Triediť podľa počtu odpovedí vo vzostupnom poradí';
$string['discussionlistsortbyrepliesdesc'] = 'Triediť podľa počtu odpovedí v zostupnom poradí';
$string['discussionlistsortbystarterasc'] = 'Triediť podľa mena iniciátora vo vzostupnom poradí';
$string['discussionlistsortbystarterdesc'] = 'Triediť podľa mena iniciátora v zostupnom poradí';
$string['discussionlocked'] = 'Táto diskusia bola uzavrená, takže už nemôžete odpovedať.';
$string['discussionlockingdisabled'] = 'Nezatvárajte diskusie';
$string['discussionlockingheader'] = 'Zatvorenie diskusie';
$string['discussionmoved'] = 'Táto diskusia sa presunula do \'{$a}\'.';
$string['discussionmovedpost'] = 'Táto diskusia bola presunutá <a href="{$a->discusshref}">sem</a> do fóra <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Názov diskusie';
$string['discussionnownotsubscribed'] = '{$a->name} NEBUDE dostávať notifikácie o nových príspevkoch v \'{$a->discussion}\' z \'{$a->forum}';
$string['discussionnowsubscribed'] = '{$a->name} bude dostávať notifikácie o nových príspevkoch v \'{$a->discussion}\' z \'{$a->forum}';
$string['discussionpin'] = 'Vždy navrchu';
$string['discussionpinned'] = 'Pripnuté navrch';
$string['discussionpinned_help'] = 'Diskusia sa objaví pripnutá v hornej časti fóra.';
$string['discussions'] = 'Diskusie';
$string['discussionsplit'] = 'Diskusia bola rozdelená';
$string['discussionsstartedby'] = 'Diskusiu začal(a) {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusiu naposledy začal(a) {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusie zahájené používateľom {$a->fullname} v kurze {$a->coursename}';
$string['discussionsstartedincourse'] = 'Diskusie sa začali o {$a}';
$string['discussionstartedby'] = 'Diskusia bola zahájená {$a}';
$string['discussionsubscribed'] = 'Odteraz ste prihlásení k odberu tejto diskusie.';
$string['discussionsubscribestart'] = 'Pošlite mi notifikácie o nových príspevkoch v tejto diskusii';
$string['discussionsubscribestop'] = 'Nechcem dostávať notifikácie o nových príspevkoch v tejto diskusii';
$string['discussionsubscription'] = 'Odoberanie diskusie';
$string['discussionsubscription_help'] = 'Odoberanie diskusie znamená, že budete dostávať notifikácie o nových príspevkoch do tejto diskusie.';
$string['discussionunpin'] = 'Odopnúť';
$string['discussionunsubscribed'] = 'Odteraz ste odhlásení z odberu tejto diskusie.';
$string['discussthistopic'] = 'Diskutovať na túto tému';
$string['discusstopicname'] = 'Diskusia na tému: {$a}';
$string['displayend'] = 'Koniec';
$string['displayend_help'] = '<p>Môžete si zvoliť, či sa váš príspevok bude zobrazovať od určitého dátumu,
alebo do určitého dátumu, alebo bude zobrazený iba určitý čas.</p>

<p>Odškrtnutím poľa "Deaktivovať" aktivujete dátum pre začiatok a/alebo koniec
zobrazenia.</p>

<p>Poznámka: používatelia, ktorí majú práva administrátora, uvidia príspevky v ľubovoľnom čase bez ohraničení.</p>';
$string['displayenddate'] = 'Zobraziť začiatok: {$a}.';
$string['displaymode'] = 'Mód zobrazenia';
$string['displayperiod'] = 'Čas zobrazovania príspevku';
$string['displaystart'] = 'Začiatok';
$string['displaystart_help'] = '<p>Môžete si zvoliť, či sa váš príspevok bude zobrazovať od určitého dátumu,
alebo do určitého dátumu, alebo bude zobrazený iba určitý čas.</p>

<p>Odškrtnutím poľa "Deaktivovať" aktivujete dátum pre začiatok a/alebo koniec
zobrazenia.</p>

<p>Poznámka: používatelia, ktorí majú práva administrátora, uvidia príspevky v ľubovoľnom čase bez ohraničení.</p>';
$string['displaystartdate'] = 'Zobraziť koniec: {$a}.';
$string['displaywordcount'] = 'Zobrazovať počet slov';
$string['displaywordcount_help'] = 'Toto nastavenie špecifikuje, či by mal byť v každom príspevku zobrazený počet slov alebo nie.';
$string['duedate'] = 'Termín odovzdania';
$string['duedate_help'] = 'Toto je, keď fórum má termín ukončenia. Aj keď je tento dátum v kalendári zobrazený ako dátum ukončenia fóra, prispievanie do fóra bude po tomto dátume stále povolené. Ak chcete zabrániť odoslaniu do fóra po určitom dátume - nastavte dátum uzatvorenia fóra.';
$string['duedatetodisplayincalendar'] = 'Dátum ukončenia pre zobrazenie v kalendári';
$string['eachuserforum'] = 'Každý môže začať len jednu tému diskusie';
$string['edit'] = 'Upraviť';
$string['editdiscussion'] = 'Upraviť diskusiu';
$string['editdiscussiontopic'] = 'Upraviť tému diskusie';
$string['editedby'] = 'Upravené: {$a->name} - {$a->date}';
$string['editedpostupdated'] = 'Príspevok používateľa {$a} bol aktualizovaný';
$string['editing'] = 'Úprava';
$string['emaildigestcompleteshort'] = 'Dokončiť príspevky';
$string['emaildigestdefault'] = 'Štandardný ({$a})';
$string['emaildigestoffshort'] = 'Žiadny prehľad';
$string['emaildigestsubjectsshort'] = 'Iba predmety';
$string['emaildigesttype'] = 'Možnosti e-mailového prehľadu';
$string['emaildigesttype_help'] = 'Typ notifikácie, ktorú budete dostávať z každého fóra.

* Štandardná - zachová nastavenie prehľadu, ktoré sa nachádza vo vašom používateľskom profile. Ak svoj používateľský profil aktualizujete, táto zmena sa odrazí aj tu;
* Žiadny prehľad - dostanete jeden e-mail ku každému príspevku do fóra;
* Prehľad - kompletné príspevky - dostanete jeden e-mail denne s prehľadom a s kompletným obsahom každého príspevku do fóra;
* Prehľad - iba predmety - dostanete jeden e-mail denne iba s predmetmi každého príspevku do fóra.';
$string['emptymessage'] = 'Vo Vašom príspevku sa vyskytla chyba. Možno ste  nevyplnili niektoré povinné údaje, alebo bola Vaša príloha príliš veľká. Vaše zmeny NEBOLI uložené.';
$string['errorcannotlock'] = 'Nemáte oprávnenie pre zamykanie diskusií.';
$string['errordiscussionnotfound'] = 'Diskusia nebola nájdená';
$string['erroremptymessage'] = 'Diskusný príspevok ktorý chcete pridať, nemôže byť prázdny.';
$string['erroremptysubject'] = 'Predmet príspevku nemôže byť prázdny.';
$string['errorenrolmentrequired'] = 'Pre prístup k danému obsahu musíte byť v tomto kurze prihlásení';
$string['errorforumnotfound'] = 'Fórum, do ktorého patrí táto diskusia, nebolo nájdené';
$string['errorwhiledelete'] = 'Vyskytla sa chyba počas vymazávania záznamu.';
$string['eventassessableuploaded'] = 'Bol zverejnený nový obsah.';
$string['eventcoursesearched'] = 'Kurz hľadaný';
$string['eventdiscussioncreated'] = 'Diskusia vytvorená';
$string['eventdiscussiondeleted'] = 'Diskusia odstránená';
$string['eventdiscussionmoved'] = 'Diskusia presunutá';
$string['eventdiscussionpinned'] = 'Diskusia bola pripnutá';
$string['eventdiscussionsubscriptioncreated'] = 'Odoberanie diskusie vytvorené';
$string['eventdiscussionsubscriptiondeleted'] = 'Odoberanie diskusie odstránené';
$string['eventdiscussionunpinned'] = 'Diskusia bola odopnutá';
$string['eventdiscussionupdated'] = 'Diskusia aktualizovaná';
$string['eventdiscussionviewed'] = 'Diskusia prezeraná';
$string['eventpostcreated'] = 'Príspevok vytvorený';
$string['eventpostdeleted'] = 'Príspevok odstránený';
$string['eventpostupdated'] = 'Príspevok aktualizovaný';
$string['eventreadtrackingdisabled'] = 'Sledovanie čítania deaktivované';
$string['eventreadtrackingenabled'] = 'Sledovanie čítania aktivované';
$string['eventsubscribersviewed'] = 'Odberatelia prezeraní';
$string['eventsubscriptioncreated'] = 'Odber vytvorený';
$string['eventsubscriptiondeleted'] = 'Odber odstránený';
$string['eventuserreportviewed'] = 'Štatistika používateľov prezeraná';
$string['everyonecanchoose'] = 'Ktokoľvek si môže vybrať odoberanie príspevkov emailom';
$string['everyonecannowchoose'] = 'Odoberanie príspevkov emailom je voliteľné';
$string['everyoneisnowsubscribed'] = 'Teraz každý odoberá nové príspevky emailom';
$string['everyoneissubscribed'] = 'Každý odoberá nové príspevky emailom';
$string['existingsubscribers'] = 'Existujúci odberatelia';
$string['export'] = 'Export';
$string['exportattachmentname'] = 'Exportovať prílohu {$a} do portfólia';
$string['exportdiscussion'] = 'Exportovať celú diskusiu do portfólia';
$string['exporthumandates'] = 'Ľudsky čitateľné údaje';
$string['exporthumandates_help'] = 'Či sa údaje majú exportovať vo formáte čitateľnom človekom alebo ako časové razítko (sled čísiel).';
$string['exportoptions'] = 'Možnosti exportu';
$string['exportstriphtml'] = 'Odstrániť HTML';
$string['exportstriphtml_help'] = 'Z HTML príspevku na fóre by mali byť odstránené HTML tagy ako p a br.';
$string['favourites'] = 'Označené hviezdičkou ako obľúbené';
$string['favouriteupdated'] = 'Vaša voľba hviezdičky bola aktualizovaná.';
$string['firstpost'] = 'Prvý príspevok';
$string['forcedreadtracking'] = 'Povoliť vynútené sledovanie čítania';
$string['forcedreadtracking_desc'] = 'Umožní nastaviť fóra na vynútené sledovanie. Jeho dôsledkom bude znížený výkon pre niektorých používateľov, hlavne v kurzoch s mnohými fórami a príspevkami. Keď je táto možnosť vypnutá, akékoľvek fóra predtým nastavené na Vynútené sa budú považovať za nepovinné.';
$string['forcesubscribed'] = 'Toto fórum vnucuje odber príspevkov';
$string['forcesubscribed_help'] = 'Toto fórum bolo konfigurované tak, že sa z odoberania jeho diskusií nemôžete odhlásiť.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Pridať nové fórum';
$string['forum:addnews'] = 'Pridať oznámenia';
$string['forum:addquestion'] = 'Pridať otázku';
$string['forum:allowforcesubscribe'] = 'Povoliť vynútený odber';
$string['forum:canoverridecutoff'] = 'Príspevok do fór po ich uverejnení';
$string['forum:canoverridediscussionlock'] = 'Odpovedať na uzavreté diskusie';
$string['forum:canposttomygroups'] = 'Poslať do všetkých skupín, do ktorých máte prístup';
$string['forum:cantogglefavourite'] = 'Diskusia označená hviezdičkou';
$string['forum:createattachment'] = 'Vytvoriť prílohy';
$string['forum:deleteanypost'] = 'Vymazať (kedykoľvek) ľubovoľný príspevok';
$string['forum:deleteownpost'] = 'Vymazať vlastné príspevky (v rámci časového limitu)';
$string['forum:editanypost'] = 'Upraviť ľubovoľný príspevok';
$string['forum:exportdiscussion'] = 'Exportovať celú diskusiu';
$string['forum:exportforum'] = 'Export fóra';
$string['forum:exportownpost'] = 'Exportovať vlastné príspevky';
$string['forum:exportpost'] = 'Exportovať príspevky';
$string['forum:grade'] = 'Známkovať fórum';
$string['forum:managesubscriptions'] = 'Administrovať odberateľov príspevkov';
$string['forum:movediscussions'] = 'Presúvať diskusie';
$string['forum:pindiscussions'] = 'Diskusia vždy navrchu';
$string['forum:postprivatereply'] = 'Odpovedať na príspevky súkromne';
$string['forum:postwithoutthrottling'] = 'Oslobodenie od maximálneho počtu príspevkov';
$string['forum:rate'] = 'Hodnotiť príspevky';
$string['forum:readprivatereplies'] = 'Zobraziť súkromné odpovede';
$string['forum:replynews'] = 'Odpovedať na oznámenia';
$string['forum:replypost'] = 'Odpovedať na príspevky';
$string['forum:splitdiscussions'] = 'Rozdeľovať diskusiu';
$string['forum:startdiscussion'] = 'Začínať novú diskusiu';
$string['forum:viewallratings'] = 'Zobraziť všetky hodnotenia zadané jednotlivcami';
$string['forum:viewanyrating'] = 'Zobraziť celkový výsledok hodnotenia ľubovolného používateľa';
$string['forum:viewdiscussion'] = 'Vidieť diskusie';
$string['forum:viewhiddentimedposts'] = 'Vidieť časovo obmedzené príspevky';
$string['forum:viewqandawithoutposting'] = 'Vždy vidieť otázky (Q) a odpovede (A)';
$string['forum:viewrating'] = 'Vidieť vaše hodnotenia';
$string['forum:viewsubscribers'] = 'Vidieť odberateľov';
$string['forumauthorhidden'] = 'Autor (nezverejnený)';
$string['forumblockingalmosttoomanyposts'] = 'Blížite sa k maximu počtu vložených príspevkov. Za posledných {$a->blockperiod} ste do fóra vložili {$a->numposts} príspevkov, limit je {$a->blockafter}.';
$string['forumbodydeleted'] = 'Obsah tohto príspevku vo fóre bol odstránený a už nemôže byť sprístupnený.';
$string['forumbodyhidden'] = 'Tento príspevok si nemôžete prezrieť - asi ste do diskusie ešte nevložili žiadny príspevok alebo ešte neuplynul čas pre úpravu príspevku, alebo diskusia ešte nezačala, prípadne bola ukončená jej platnosť.';
$string['forumgrader'] = 'Hodnotiteľ fóra';
$string['forumgradingnavigation'] = 'Navigácia hodnotenia fóra';
$string['forumgradingpanel'] = 'Panel hodnotenia fóra';
$string['forumintro'] = 'Opis';
$string['forumname'] = 'Názov fóra';
$string['forumposts'] = 'Príspevky vo fórach';
$string['forums'] = 'Fóra';
$string['forumsubjectdeleted'] = 'Tento príspevok vo fóre bol odstránený';
$string['forumsubjecthidden'] = 'Predmet  (nezverejnený)';
$string['forumtracked'] = 'Neprečítané prípsevky sú sledované';
$string['forumtrackednot'] = 'Neprečítané príspevky nie sú sledované';
$string['forumtype'] = 'Typ fóra';
$string['forumtype_help'] = 'Existuje 5 rôznych typov fór:

* Jediná jednoduchá diskusia - je to len jedna téma, každý na ňu môže odpovedať
* Každý môže poslať len jeden príspevok do diskusie  -   každý študent môže začal diskusiu a každý môže odpovedať.
* Otázka a odpoveď - študenti musia najprv vložiť svoj názor a až potom môžu vidieť ostatné odpovede
* Štandardné fórum zobrazené v blogovom formáte - jedná sa o otvorené fórum, kde hocikto a hocikedy môže začať novú tému. Diskusné príspevky sú znázornené na jednej strane s odkazmi "Diskutovať túto tému"
* Štandardné fórum na všeobecné použitie - jedná sa o otvorené fórum, kde hocikto a hocikedy môže začať novú tému.';
$string['generalforum'] = 'Štandardné fórum pre bežné použitie';
$string['generalforums'] = 'Bežné fóra';
$string['grade_forum_header'] = 'Hodnotenie celého fóra';
$string['grade_forum_name'] = 'Celé fórum';
$string['grade_forum_title'] = 'Známka';
$string['grade_rating_name'] = 'Hodnotenie';
$string['graded'] = 'Hodnotené';
$string['gradedby'] = 'Hodnotené';
$string['gradeforrating'] = 'Hodnotenie: {$a-> str_long_grade}';
$string['gradeforratinghidden'] = 'Známka hodnotenia skrytá';
$string['gradeforwholeforum'] = 'Hodnotenie pre fórum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Hodnotenie pre fórum je skryté';
$string['gradeitem:forum'] = 'Fórum';
$string['gradeitemnameforrating'] = 'Hodnotenie {$a->name}';
$string['gradeitemnameforwholeforum'] = '{$a->name} celé fórum';
$string['grades:gradesavedfor'] = 'Známka pre  {$a->fullname} bola uložená';
$string['grades:gradesavefailed'] = 'Nepodarilo sa uložiť známku pre {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Známkovanie používateľov';
$string['grading'] = 'Známkovanie';
$string['gradingstatus'] = 'Stav známky:';
$string['hiddenforumpost'] = 'Skrytý príspevok do fóra';
$string['hidegraderpanel'] = 'Skryť panel hodnotenia';
$string['hidepreviousrepliescount'] = 'Skryť predošlé odpovede ({$a})';
$string['hideusersearch'] = 'Skryť vyhľadávanie používateľov';
$string['indexoutoftotal'] = '{$a->index} z {$a->total}';
$string['indicator:cognitivedepth'] = 'Kognitívne Fórum';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite Fórum.';
$string['indicator:cognitivedepthdef'] = 'Kognitívne Fórum';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej aktivitami Fórum (Úrovne = Bez zobrazenia, Zobrazenie, Príspevok, Zobrazenie spätnej väzby, Komentár ku spätnej väzbe, Nový príspevok po zobrazení spätnej väzby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálne Fórum';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite Fórum.';
$string['indicator:socialbreadthdef'] = 'Sociálne Fórum';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitou Fórum (Úrovne = Bez účasti, Účastník sám, Účastník s ostatnými)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'v {$a}';
$string['inreplyto'] = 'V odpovedi na {$a}';
$string['introblog'] = 'Príspevky v tomto fóre boli sem skopírované automaticky z blogov používateľov v tomto kurze, pretože položky blogov už nie sú ďalej podporované.';
$string['intronews'] = 'Všeobecné správy a oznámenia';
$string['introsocial'] = 'Otvorené fórum pre rozhovory na ľubovoľnú tému';
$string['introteacher'] = 'Uzavreté fórum vyhradené len pre diskusiu učiteľov';
$string['invalidaccess'] = 'Táto stránka nebola otvorená správne';
$string['invaliddigestsetting'] = 'Na nastavenie prehľadu príspevkov bol poskytnutý neplatný e-mail';
$string['invaliddiscussionid'] = 'Nesprávne alebo neexistujúce ID číslo diskusie';
$string['invalidforcesubscribe'] = 'Neplatný mód povinného odoberania fór';
$string['invalidforumid'] = 'Nesprávne ID číslo fóra';
$string['invalidparentpostid'] = 'Nadradený identifikátor príspevku bol nesprávny';
$string['invalidpostid'] = 'Neplatný identifikátor príspevku - {$a}';
$string['lastpost'] = 'Posledný príspevok';
$string['learningforums'] = 'Vzdelávacie fóra';
$string['lockdiscussion'] = 'Zamknúť túto diskusiu';
$string['lockdiscussionafter'] = 'Uzavrieť diskusie po čase nečinnosti';
$string['lockdiscussionafter_help'] = 'Diskusie môžu byť automaticky zamknuté po uplynutí nastavenej doby od poslednej odpovede.

Používatelia, ktorí majú práva odpovedať na zamknuté diskusie ich môžu odomknúť tak, že na ne odpovedia.';
$string['locked'] = 'Zamknuté';
$string['lockupdated'] = 'Možnosť zámku bola aktualizovaná.';
$string['longpost'] = 'Dlhý príspevok';
$string['mailnow'] = 'Odoslať okamžite emailom bez oneskorenia pre úpravu príspevku.';
$string['managesubscriptionsoff'] = 'Dokončenie správy odberov';
$string['managesubscriptionson'] = 'Spravovať odberateľov príspevkov';
$string['manydiscussions'] = 'Počet diskusií na stranu';
$string['markalldread'] = 'Označiť všetky príspevky v tejto diskusii ako prečítané.';
$string['markallread'] = 'Označiť  všetky príspevky v tomto fóre ako prečítané.';
$string['markasread'] = 'Označiť ako prečítané';
$string['markasreadonnotification'] = 'Označiť pri odosielaní príspevku';
$string['markasreadonnotification_help'] = 'Keď budete upozornení na príspevky fóra, môžete si vybrať, či to označí príspevok ako čítanie pre účely sledovania fóra.';
$string['markasreadonnotificationno'] = 'Neoznačiť príspevok ako prečítaný';
$string['markasreadonnotificationyes'] = 'Označiť príspevok ako prečítaný';
$string['markread'] = 'Označiť ako prečítané';
$string['markreadbutton'] = 'Označiť ako<br />prečítané';
$string['markunread'] = 'Označiť ako neprečítané';
$string['markunreadbutton'] = 'Označiť ako<br />neprečítané';
$string['maxattachments'] = 'Maximálny počet príloh';
$string['maxattachments_help'] = 'Toto nastavenie určuje maximálny počet príloh pre každý príspevok fóra';
$string['maxattachmentsize'] = 'Maximálna veľkosť prílohy';
$string['maxattachmentsize_help'] = '<p>Pri zakladaní fóra môžete určiť, aká bude maximálna veľkosť prílohy,
ktorú možno pripojiť k jednotlivým príspevkom.</p>

<p>Niekedy sa zdanlivo podarí priložiť súbor, ktorý je väčší, než je stanovené
maximum. Tento súbor však nebude uložený na server; používateľ o tom bude
informovaný chybovým hlásením.</p>';
$string['maxtimehaspassed'] = 'Prepáčte, ale povolený čas na úpravu tohto príspevku ({$a})vypršal!';
$string['message'] = 'Správa';
$string['messageinboundattachmentdisallowed'] = 'Vašu odpoveď nie je možné uložiť ako príspevok, pretože obsahuje prílohu a fórum nepovoľuje prílohy.';
$string['messageinboundfilecountexceeded'] = 'Vašu odpoveď nie je možné uložiť ako príspevok, pretože obsahuje viac príloh, ako je maximálny počet povolený pre toto fórum ({$a->forum->maxattachments}).
UnstageUpraviť';
$string['messageinboundfilesizeexceeded'] = 'Vašu odpoveď nie je možné uložiť ako príspevok, pretože celková veľkosť prílohy ({$a->filesize}) je väčšia, ako je maximálna veľkosť, povolená pre toto fórum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Vašu odpoveď nie je možné uložiť ako príspevok, pretože fórum je momentálne nedostupné.';
$string['messageinboundnopostforum'] = 'Vašu odpoveď nie je možné uložiť ako príspevok, pretože nemáte oprávnenia prispievať do fóra  {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Vašu odpoveď nie je možné uložiť ako príspevok. Prekročili ste prah počtu príspevkov nastavený pre toto fórum';
$string['messageprovider:digests'] = 'Odoberanie zhrnutia z fóra';
$string['messageprovider:posts'] = 'Odoberanie príspevkov z fóra';
$string['missingsearchterms'] = 'Nasledujúce vyhľadávané výrazy sa v tejto správe vyskytujú iba v značkách jazyka HTML:';
$string['modeflatnewestfirst'] = 'Znázorniť odpovede za sebou (prvá správa je najnovšia)';
$string['modeflatoldestfirst'] = 'Znázorniť odpovede za sebou (prvá správa je najstaršia)';
$string['modenested'] = 'Znázorniť hierarchiu odpovedí (vrátane textu)';
$string['modenestedv2'] = 'Zobraziť odpovede v experimentálnej vnorenej podobe';
$string['modethreaded'] = 'Znázorniť hierarchiu odpovedí (iba osnovu)';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'Modul Fórum umožňuje účastníkom viesť asynchrónne diskusie, tj. diskusie, ktoré prebiehajú počas dlhšieho obdobia.

K dispozícii je niekoľko typov fór: bežné fórum, kde môže každý začínať nové diskusie a zapojiť sa do existujúcich fór, v ktorom môže každý študent začať najviac jednu diskusiu; alebo fórum, v ktorom musí študent najskôr sám za seba odpovedať na položené otázky pred tým, než vidí odpovede ostatných. K príspevkom je možné prikladať súbory ako prílohy.

Účastníci kurzu sa môžu prihlásiť k odberu nových príspevkov vo fórach. Toto upozorňovanie na nové príspevky je možné vnútiť aj zakázať podľa potreby. Ak to vyžadujú  okolnosti, môže byť nastavený limit pre počet príspevkov za daný čas (slúži ako obrana pred nežiadúcou aktivitou jednotlivcov, ktorí by inak svojimi príspevkami zahltili dané fórum).

Príspevky vo fóre je možné hodnotiť, a to aj ostatnými študentmi (vzájomné hodnotenie). Hodnotenie sa prepočítava na výslednú známku, ktorá môže byť súčasťou klasifikácie v kurze.

Fórum je možné použiť napr.

* ako priestor pre predstavenie s ostatnými účastníkmi v kurzu
* ako nástenka pre zverejňovanie noviniek a oznámení (s možností vnúteného upozorňovania na nové príspevky)
* pre diskusiu o obsahu kurzu alebo zdrojov
* ako priestor, v ktorom pokračuje výklad a diskusia po ukončení prezenčnej časti kurzu
* ako priestor diskusie iba pre učiteľa daného kurzu k diskusiám a výmene materiálov (pomocou skrytého fóra)
* ako nástroj podpory používateľom vášho serveru
* pre oblasť podpory pre súkromnú komunikáciu študentov a učiteľov (pomocou fóra so samostatnými skupinami a s jedným študentom za skupinu)
* pre rozširujúce sa aktivity, napríklad „hlavolamy“, aby študenti přemýšľali a navrhovali riešenia.
* jako otevřený prostor pro neformální diskuse o tématech mimo rámec kurzu';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Fóra';
$string['more'] = 'viac';
$string['movedmarker'] = '(Presunuté)';
$string['movethisdiscussionlabel'] = 'Presunúť aktuálnu diskusiu na určené fórum';
$string['movethisdiscussionto'] = 'Presunúť túto diskusiu do ...';
$string['mustprovidediscussionorpost'] = 'Pre export musíte zadať alebo identifikátor diskusie alebo príspevku';
$string['myprofileotherdis'] = 'Diskusie fóra';
$string['myprofileowndis'] = 'Moje diskusie vo fóre';
$string['myprofileownpost'] = 'Moje príspevky do fóra';
$string['namenews'] = 'Oznámenia';
$string['namenews_help'] = 'Fórum Oznámenia je špeciálne fórum, určené pre vkladanie všeobecných oznámení.
Fórum sa vytvára automaticky pri vytvorení kurzu. Každý kurz môže obsahovať iba jedno fórum Oznámenia. Prispievať doň môžu iba učitelia a administrátori. Najnovšie príspevku sú tiež zobrazené v bloku "Posledné oznámenia".';
$string['namesocial'] = 'Spoločenské fórum';
$string['nameteacher'] = 'Učiteľské fórum';
$string['newforumposts'] = 'Nové príspevky do fóra';
$string['nextdiscussiona'] = 'Ďalšia diskusia: {$a}';
$string['nextuser'] = 'Uložiť zmeny a prejsť k ďalšiemu používateľovi';
$string['noattachments'] = 'Tento príspevok neobsahuje žiadne prílohy';
$string['nodiscussions'] = 'V tomto fóre ešte nie sú žiadne diskusné témy';
$string['nodiscussionsstartedby'] = 'Používateľ {$a} ešte nezačal žiadne diskusie';
$string['nodiscussionsstartedbyyou'] = 'Nezačali ste ešte žiadne diskusie';
$string['noguestpost'] = 'Prepáčte, ale hostia nemôžu prispievať do diskusie.';
$string['noguestsubscribe'] = 'Ľutujeme, ale hostia nie sú oprávnení prispievať do diskusie.';
$string['noguesttracking'] = 'Prepáčte, ale hostia si nemôžu nastaviť označovanie neprečítaných príspevkov.';
$string['nomorepostscontaining'] = 'Neboli nájdené žiadne ďalšie príspevky obsahujúce \'{$a}\'';
$string['nonews'] = 'Zatiaľ neboli vložené žiadne oznámenia';
$string['noonecansubscribenow'] = 'Odoberanie je v súčasnosti zakázané';
$string['nopermissiontosubscribe'] = 'Nemáte oprávnenie vidieť zoznam prispievateľov do fóra';
$string['nopermissiontoview'] = 'Nemáte oprávnenie vidieť tento príspevok';
$string['nopostforum'] = 'V tomto fóre nemôžete prispievať';
$string['noposts'] = 'Bez príspevkov';
$string['nopostsmadebyuser'] = 'Používateľ {$a} nevložil žiadny príspevok';
$string['nopostsmadebyyou'] = 'Nevložili ste žiadny príspevok';
$string['noquestions'] = 'Do tohto fóra zatiaľ nebola vložená žiadna otázka.';
$string['nosubscribers'] = 'V tomto fóre zatiaľ nikto neodoberá nové príspevky emailom';
$string['notexists'] = 'Diskusia už neexistuje';
$string['notgraded'] = 'Nehodnotené';
$string['nothingnew'] = 'Žiadne nové správy';
$string['notingroup'] = 'Prepáčte, ale na prehliadanie tohto fóra musíte byť členom skupiny.';
$string['notinstalled'] = 'Fórum nie je nainštalované';
$string['notlocked'] = 'Zamknúť';
$string['notpartofdiscussion'] = 'Tento príspevok nie je súčasťou diskusie!';
$string['notrackforum'] = 'Neoznačovať neprečítané správy';
$string['notsubscribed'] = 'Odoberať';
$string['nousersmatch'] = 'Pre zadané kritériá nebol nájdený žiadny používateľ';
$string['noviewdiscussionspermission'] = 'Nemáte oprávnenie prezerať diskusie v tomto fóre';
$string['nowallsubscribed'] = 'Teraz ste prihlásení k odberu všetkých fór v {$a}.';
$string['nowallunsubscribed'] = 'Teraz ste odhlásení z odberu všetkých fór v {$a}.';
$string['nowgradinguser'] = 'Hodnotenie {$a}';
$string['nownotsubscribed'] = '{$a->name}: odoberanie príspevkov z fóra "{$a->forum}" VYPNUTÉ.';
$string['nownottracking'] = '{$a->name} nemá zapnutú voľbu: Označovať neprečítané príspevky v  \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name}: odoberanie príspevkov z fóra "{$a->forum}" ZAPNUTÉ.';
$string['nowtracking'] = '{$a->name} má zapnutú voľbu: Označovať neprečítané príspevky v  \'{$a->forum}\'.';
$string['numberofreplies'] = 'Počet odpovedí: {$a}';
$string['numposts'] = '{$a} príspevkov';
$string['olderdiscussions'] = 'Staršie diskusie';
$string['oldertopics'] = 'Staršie témy';
$string['oldpostdays'] = 'Prečítané po dňoch';
$string['page-mod-forum-discuss'] = 'Stránka diskusného vlánka';
$string['page-mod-forum-view'] = 'Hlavná stránka modulu fórum';
$string['page-mod-forum-x'] = 'Ľubovoľná stránka modulu fórum';
$string['parent'] = 'Ukázať predošlý príspevok';
$string['parentofthispost'] = 'Predchodca tohto príspevku';
$string['permalink'] = 'Trvalý odkaz';
$string['permanentlinktoparentpost'] = 'Trvalý odkaz na predchodcu tohto príspevku';
$string['permanentlinktopost'] = 'Trvalý odkaz na tento príspevok';
$string['pindiscussion'] = 'Pripichnúť túto diskusiu hore';
$string['pinupdated'] = 'Voľba pripináčiku bola aktualizovaná.';
$string['pluginadministration'] = 'Správa fóra';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>Váš príspevok bol úspešne pridaný.</p><p>Máte {$a} na úpravu, ak chcete urobiť nejaké zmeny.</p>';
$string['postaddedsuccess'] = 'Váš diskusný príspevok bol úspešne pridaný.';
$string['postaddedtimeleft'] = 'Máte {$a} k úprave ak chcete urobiť zmeny.';
$string['postbymailsuccess'] = 'Váš diskusný príspevok s predmetom "{$a->subject}" bol úspešne pridaný: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Váš diskusný príspevok <a href="{$a->discussionurl}">{$a->subject}</a> bol úspešne zverejnený.';
$string['postbyuser'] = '{$a->post} od {$a->user}';
$string['postincontext'] = 'Ukázať tento príspevok v kontexte';
$string['postisprivatereply'] = 'Toto je súkromná odpoveď. Vidíte ho iba vy a ktokoľvek, kto má možnosť zobraziť súkromné odpovede, ako sú učitelia alebo manažéri.';
$string['postmailinfo'] = 'Toto je kópia správy publikovanej na {$a} stránke.';
$string['postmailnow'] = '<p>Tento príspevok bude hneď po vložení poslaný e-mailom všetkým, ktorí majú zapnuté odoberanie príspevkov z tohto fóra.</p>';
$string['postmailreply'] = 'Ak chcete odpovedať, kliknite na tento odkaz: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Príspevky';
$string['postsfrom'] = 'Príspevky od';
$string['postsmadebyuser'] = 'Príspevky používateľa {$a}';
$string['postsmadebyuserincourse'] = 'Príspevky používateľa {$a->fullname} v kurze {$a->coursename}';
$string['postsmadeincourse'] = 'Príspevky vytvorené v {$a}';
$string['poststo'] = 'Príspevky do';
$string['posttoforum'] = 'Poslať do fóra';
$string['posttomygroups'] = 'Poslať kópiu do všetkých skupín';
$string['posttomygroups_help'] = 'Pošle kópiu tejto správy do všetkých skupín, do ktorých máte prístup. Účastníci v skupinách, do ktorých prístup nemáte, tento príspevok neuvidia';
$string['postupdated'] = 'Váš príspevok bol aktualizovaný';
$string['potentialsubscribers'] = 'Potenciálni odberatelia príspevkov';
$string['prevdiscussiona'] = 'Predchádzajúca diskusia: {$a}';
$string['previoususer'] = 'Uložiť zmeny a prejsť k predchádzajúcemu používateľovi';
$string['privacy:digesttypenone'] = 'Neudržujeme žiadne údaje týkajúce sa preferovaného typu výberu pre toto fórum.';
$string['privacy:digesttypepreference'] = 'Vybrali ste si dostávať nasledujúci formát zhrnutia: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Vybrali ste si nasledujúcu diskusnú predvoľbu pre toto fórum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Fórum využíva hodnotiaci subsystém k podpore známkovania príspevkov.';
$string['privacy:metadata:core_tag'] = 'Fórum využíva pre podporu označovanie príspevkov subsystém štítkov.';
$string['privacy:metadata:forum_digests'] = 'Informácia o preferenciách výberu pre každé fórum.';
$string['privacy:metadata:forum_digests:forum'] = 'Fórum  prihlásené k odberu.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Výber predvolieb';
$string['privacy:metadata:forum_digests:userid'] = 'ID používateľa s výberom predvolieb.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informácia o odberoch jednotlivých diskusných fór';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID odoberanej diskusie.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Čas zahájenia odberu.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID používateľa s odberom diskusie.';
$string['privacy:metadata:forum_discussions'] = 'Informácia o diskusiách jednotlivých fór, ktoré používateľ vytvoril';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - čo toto pole uchováva';
$string['privacy:metadata:forum_discussions:name'] = 'Názov diskusie ako zvolený autorom';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Čas poslednej úpravy diskusie.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID používateľa, ktorý vytvoril diskusiu';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID používateľa, ktorý nejakým spôsobom zmenil diskusiu.';
$string['privacy:metadata:forum_grades'] = 'Hodnotiť údaje fóra';
$string['privacy:metadata:forum_grades:forum'] = 'Fórum, ktoré bolo hodnotené';
$string['privacy:metadata:forum_grades:grade'] = 'Získaná známka';
$string['privacy:metadata:forum_grades:userid'] = 'Používateľ, ktorý bol hodnotený';
$string['privacy:metadata:forum_posts'] = 'Informácie o preferenciách výberu pre každé fórum.';
$string['privacy:metadata:forum_posts:created'] = 'Čas vytvorenia príspevku.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskusie, ktoré boli odoslané.';
$string['privacy:metadata:forum_posts:message'] = 'Správa fóra';
$string['privacy:metadata:forum_posts:modified'] = 'Čas poslednej úpravy príspevku.';
$string['privacy:metadata:forum_posts:parent'] = 'Predchádzajúci príspevok, na ktorý bolo odpovedané.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID používateľa, na ktorého bola táto odpoveď odoslaná.';
$string['privacy:metadata:forum_posts:subject'] = 'Predmet príspevku fóra.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Správa príspevku fóra.';
$string['privacy:metadata:forum_posts:userid'] = 'ID používateľa, ktorý vytvoril príspevok vo fóre.';
$string['privacy:metadata:forum_queue'] = 'Dočasný protokol o príspevkoch, ktoré budú posielané sumárnou formou';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID diskusie vo fóre';
$string['privacy:metadata:forum_queue:postid'] = 'ID príspevku vo fóre';
$string['privacy:metadata:forum_queue:timemodified'] = 'Upravený čas pôvodného príspevku';
$string['privacy:metadata:forum_queue:userid'] = 'Používateľ, ktorý má byť o príspevku upozornený';
$string['privacy:metadata:forum_read'] = 'Informácia o príspevkoch, ktoré používateľ prečítal.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskusia, v ktorej je príspevok.';
$string['privacy:metadata:forum_read:firstread'] = 'Čas prvého prečítania príspevku.';
$string['privacy:metadata:forum_read:lastread'] = 'Čas posledného prečítania príspevku.';
$string['privacy:metadata:forum_read:postid'] = 'Prečítaný príspevok.';
$string['privacy:metadata:forum_read:userid'] = 'ID používateľa, ku ktorému sa tento záznam vzťahuje.';
$string['privacy:metadata:forum_subscriptions'] = 'Informácia o tom, ku ktorým fóram sa používateľ prihlásil k odberu.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Fórum, ku ktorému bol prihlásený odber.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID používateľa, ku ktorému sa vzťahuje tento odber fóra.';
$string['privacy:metadata:forum_track_prefs'] = 'Informácia o tom, ktoré fóra používateľ zvolil pre sledovanie príspevkov.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Fórum, ktoré má zapnuté sledovanie čítania.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID používateľa, ku ktorému sa táto predvoľba pre sledovanie fóra vzťahuje.';
$string['privacy:metadata:preference:autosubscribe'] = 'Či sa pri odpovedi na príspevky prihlási k diskusiám.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Preferované poradie triedenia zoznamu diskusií';
$string['privacy:metadata:preference:maildigest'] = 'Predvoľba výberu sumárnej pošty na portíli';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Či budú príspevky vo fóre pri ich prijímaní označené ako prečítané.';
$string['privacy:metadata:preference:trackforums'] = 'Či povoliť sledovanie prečítania.';
$string['privacy:postwasread'] = 'Tento príspevok bol prvý raz prečítaný {$a->firstread} a naposledy  {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Rozhodli ste sa, že nebudete sledovať príspevky, ktoré ste si v tomto fóru prečítali.';
$string['privacy:request:delete:discussion:name'] = 'Odstrániť na žiadosť autora';
$string['privacy:request:delete:post:message'] = 'Obsah tohto príspevku bol na žiadosť autora odstránený.';
$string['privacy:request:delete:post:subject'] = 'Odstrániť na žiadosť autora';
$string['privacy:subscribedtoforum'] = 'Ste prihlásení pre odber tohto fóra.';
$string['privatereply'] = 'Odpovedať súkromne';
$string['privatereply_help'] = 'Súkromnú odpoveď môže zobraziť iba autor príspevku, na ktorý už bolo odpovedané, a všetkým používateľom, ktorí sú schopní zobraziť súkromné odpovede.';
$string['processingdigest'] = 'Spracováva sa súhrnný email pre používateľa {$a}';
$string['processingpost'] = 'Spracovávanie príspevku {$a}';
$string['prune'] = 'Oddeliť';
$string['prunediscussion'] = 'Rozdeliť diskusiu';
$string['prunedpost'] = 'Z príspevku bola vytvorená nová diskusia';
$string['pruneheading'] = 'Oddeliť a presunúť tento príspevok do novej diskusie';
$string['qandaforum'] = 'Otázky a odpovede';
$string['qandanotify'] = 'Toto je fórum typu \'otázky a odpovede\'. Ak si chcete prezrieť ostatné odpovede na vložené otázky, musíte najskôr vložiť svoju odpoveď.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Čítať zostatok tejto témy';
$string['removeallforumtags'] = 'Odstrániť všetky štítky fóra';
$string['removefromfavourites'] = 'Odstrániť hviezdičku z tejto diskusie';
$string['replies'] = 'Odpovede';
$string['repliesmany'] = '{$a} odpovedí zatiaľ';
$string['repliesone'] = '{$a} odpoveď zatiaľ';
$string['reply'] = 'Odpovedať';
$string['reply_handler'] = 'Odpovedať na príspevky fóra e-mailom';
$string['reply_handler_name'] = 'Odpovedať na príspevky fóra';
$string['replyauthorself'] = '{$a} (vy)';
$string['replyforum'] = 'Odpovedať do fóra';
$string['replyingtoauthor'] = 'Odpoveď  {$a}...';
$string['replyplaceholder'] = 'Napíšte svoju odpoveď ...';
$string['replypostdiscussion'] = 'Odpovedať v diskusii';
$string['replytopostbyemail'] = 'Na tento príspevok môžete odpovedať cez e-mail.';
$string['replytouser'] = 'Použiť mailovú adresu v odpovedi';
$string['resetdigests'] = 'Odstrániť všetky preferencie nastavenia prehľadov u jednotlivých používateľov fóra';
$string['resetforums'] = 'Odstrániť všetky príspevky z';
$string['resetforumsall'] = 'Vymazať všetky príspevky';
$string['resetsubscriptions'] = 'Odstrániť všetky prihlásenia k odberu príspevkov';
$string['resettrackprefs'] = 'Vymazať všetky preferencie sledovania fóra.';
$string['rssarticles'] = 'Počet súčasných RSS článkov';
$string['rssarticles_help'] = '<p>Táto voľba umožňuje nastaviť počet článkov, ktoré majú byť zahrnuté v RSS
kanále.</p>

<p>Pre väčšinu fór je vhodný počet medzi 5 a 20 článkami. Ak je fórum veľmi
frekventované, môžete počet zvýšiť.</p>';
$string['rsssubscriberssdiscussions'] = 'Zobraziť RSS kanál diskusií';
$string['rsssubscriberssposts'] = 'RSS kanál príspevkov';
$string['rsstype'] = 'RSS kanál pre túto aktivitu';
$string['rsstype_help'] = 'Pre zapnutie RSS kanálu pre túto aktivitu vyberte alebo diskusie ako príspevky, ktoré majú byť zahrnuté v kanále.';
$string['rsstypedefault'] = 'Typ RSS kanálu';
$string['search'] = 'Hľadať';
$string['search:activity'] = 'Fórum - informácia';
$string['search:post'] = 'Príspevky vo fóre';
$string['searchdatefrom'] = 'Príspevky musia byť novšie ako';
$string['searchdateto'] = 'Príspevky musia byť staršie ako';
$string['searchforumintro'] = 'Prosím vložte vyhľadávané termíny do jedného alebo viacerých polí:';
$string['searchforums'] = 'Hľadať vo fórach';
$string['searchfullwords'] = 'Tieto slová by sa mali vyskytovať ako celé slová';
$string['searchnotwords'] = 'Tieto slová by v príspevku NEMALI byť';
$string['searcholderposts'] = 'Prehľadávať staršie príspevky ...';
$string['searchphrase'] = 'Presne táto fráza sa musí vyskytovať v príspevku';
$string['searchresults'] = 'Výsledky hľadania';
$string['searchsubject'] = 'Tieto slová by mali byť v predmete príspevku';
$string['searchtags'] = 'Je štítkované s';
$string['searchuser'] = 'Toto meno by sa malo zhodovať s menom autora';
$string['searchuserid'] = 'Moodle ID autora';
$string['searchusers'] = 'Hľadať používateľa';
$string['searchwhichforums'] = 'Vyber si fóra, ktoré sa majú  prehľadávať';
$string['searchwords'] = 'Tieto slová sa môžu vyskytnúť hocikde v príspevku';
$string['seeallposts'] = 'Zobraziť všetky príspevky od tohto používateľa';
$string['sendstudentnotificationsdefault'] = 'Východzie nastavenie pre „Upozorniť študentov“';
$string['sendstudentnotificationsdefault_help'] = 'Vo formulári pre hodnotenie nastavte východziu hodnotu zaškrtávacieho políčka „Upozorniť študentov“.';
$string['sendstudentnotificationsno'] = 'Nie';
$string['sendstudentnotificationsyes'] = 'Áno, poslať oznámenie študentovi';
$string['settings'] = 'Nastavenia';
$string['shortpost'] = 'Krátky príspevok';
$string['showgraderpanel'] = 'Zobraziť panel hodnotenia';
$string['showingcountoftotaldiscussions'] = 'Zoznam diskusií. Zobrazené {$a->count} diskusií z {$a->total}';
$string['showmoreusers'] = 'Zobraziť viac používateľov';
$string['showpreviousrepliescount'] = 'Zobraziť predchádzajúce odpovede ({$a})';
$string['showsubscribers'] = 'Zobraziť/Upraviť  odberateľov príspevkov';
$string['showusersearch'] = 'Zobraziť vyhľadávanie používateľov';
$string['singleforum'] = 'Jednoduchá diskusia';
$string['smallmessage'] = '{$a->user} diskutoval vo fóre {$a->forumname}';
$string['smallmessagedigest'] = 'Prehľad fóra obsahuje {$a} správ';
$string['starredonly'] = 'Prehľadávať iba diskusie označené ako obľúbené';
$string['startedby'] = 'Diskusiu začal(a)';
$string['subject'] = 'Predmet';
$string['subscribe'] = 'Odoberať nové príspevky emailom';
$string['subscribeall'] = 'Nastaviť všetkým odoberanie príspevkov z tohto fóra';
$string['subscribed'] = 'Príspevky odoberané emailom';
$string['subscribediscussion'] = 'Prihláste sa na odoberanie príspevkov z tejto diskusie';
$string['subscribeenrolledonly'] = 'Ľutujeme, ale upozorniť o nových príspevkov je možné iba pre účastníkov tohto kurzu.';
$string['subscribenone'] = 'Zrušiť všetkým odoberanie príspevkov z tohto fóra';
$string['subscribers'] = 'Odberatelia';
$string['subscriberstowithcount'] = 'Odberatelia fóra "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Poslať mi emailom notifikácie o nových príspevkov v tomto fóre';
$string['subscribestop'] = 'Vypnúť posielanie emailom upozornení na nové príspevky v tomto fóre';
$string['subscription'] = 'Odoberanie príspevkov';
$string['subscription_help'] = 'Ak ste prihlásení k odberu príspevkov z určitého fóra, budú vám posielané upozornenia na nové príspevky. Odoberanie je väčšinou voliteľné, v niektorých prípadoch však môže byť vnútené tak, že upozornenia sú automaticky posielané všetkým.';
$string['subscriptionandtracking'] = 'Odber a  sledovanie';
$string['subscriptionauto'] = 'Počiatočné odoberanie';
$string['subscriptiondisabled'] = 'Odoberanie nie je umožnené';
$string['subscriptionforced'] = 'Povinné odoberanie';
$string['subscriptionmode'] = 'Mód odoberania';
$string['subscriptionmode_help'] = 'Ak je niekto prihlásený k odoberaniu príspevkov z určitého fóra, bude mu e-mailom poslaná kópia každého príspevku vloženého do tohto fóra.

Existujú 4 možné spôsoby:

* Voliteľné odoberanie - každý si obvykle môže zvoliť, či chce alebo nechce odoberať príspevky
* Vnútené odoberanie - každý bude prihlásený k odoberaniu automaticky a nemôže sa odhlásiť
* Automatické odoberanie - každý je na začiatku prihlásený a môže sa kedykoľvek odhlásiť
* Zakázané odoberanie - odoberanie príspevkov je zakázané';
$string['subscriptionmodeconfirm'] = 'Naozaj chcete zmeniť režim odberu na {$a}?';
$string['subscriptionoptional'] = 'Voliteľné odoberanie';
$string['subscriptions'] = 'Odoberanie príspevkov';
$string['tagarea_forum_posts'] = 'Príspevky vo fóre';
$string['tagsdeleted'] = 'Štítky fóra boli odstránené';
$string['thisforumhasduedate'] = 'Termín pre odoslanie do tohto fóra je {$a}.';
$string['thisforumisdue'] = 'Termín pre odoslanie do tohto fóra bol {$a}.';
$string['thisforumisthrottled'] = 'Do tohto fóra môžete v určenom časovom období vložiť iba obmedzený počet príspevkov. Súčasné nastavenie je {$a->blockafter} príspevkov za {$a->blockperiod}.';
$string['timed'] = 'Načasované';
$string['timeddiscussion'] = 'Načasovaná diskusia';
$string['timedhidden'] = 'Časový status: Skryté študentom';
$string['timedposts'] = 'Časovo ohraničené príspevky';
$string['timedvisible'] = 'Časový status: Viditeľné všetkým účastníkom';
$string['timestartenderror'] = 'Dátum pre koniec zobrazovania príspevku nemôže predchádzať dátum pre začiatok zobrazovania.';
$string['togglediscussionmenu'] = 'Prepnúť ponuku diskusií';
$string['togglefullscreen'] = 'Prepnúť na celú obrazovku';
$string['togglesettingsdrawer'] = 'Prepnúť záložku nastavenia';
$string['trackforum'] = 'Označovať neprečítané príspevky';
$string['tracking'] = 'Označovanie';
$string['trackingoff'] = 'Vypnuté';
$string['trackingon'] = 'Vynútené';
$string['trackingoptional'] = 'Voliteľné';
$string['trackingtype'] = 'Označovanie neprečítaných príspevkov';
$string['trackingtype_help'] = 'Sledovanie čítania umožňuje účastníkom jednoducho skontrolovať, ktoré príspevky ešte nevideli, zvýraznením nových príspevkov.

Ak je nastavené ako voliteľné, účastníci si môžu vybrať, či zapnú alebo vypnú sledovanie prostredníctvom odkazu v ponuke akcií alebo bloku správy, v závislosti od témy. (Používatelia musia tiež povoliť sledovanie fóra vo svojich preferenciách fóra.)

Ak je v administrácii stránky povolené „Povoliť vynútené sledovanie čítania“, potom je k dispozícii ďalšia možnosť – vynútené. To znamená, že sledovanie je vždy zapnuté, bez ohľadu na preferencie používateľov fóra.';
$string['trackreadposts_header'] = 'Sledovanie fóra';
$string['unlockdiscussion'] = 'Odomknúť túto diskusiu';
$string['unpindiscussion'] = 'Odopnúť túto diskusiu';
$string['unread'] = 'Neprečítaných';
$string['unreadpost'] = 'Neprečítaný príspevok';
$string['unreadposts'] = 'Neprečítaných príspevkov';
$string['unreadpostsnumber'] = '{$a} neprečítaných príspevkov';
$string['unreadpostsone'] = '1 neprečítaný príspevok';
$string['unsubscribe'] = 'Odhlásiť ma z odoberania príspevkov z tohto fóra';
$string['unsubscribeall'] = 'Odhlásiť ma z odoberania príspevkov zo všetkých fór';
$string['unsubscribeallconfirm'] = 'V súčasnosti odoberáte príspevky z {$a->forums} diskusných fór a {$a->discussions} diskusií. Naozaj sa chcete odhlásiť z odoberania príspevkov v nich a zrušiť automatické prihlasovanie do nich?';
$string['unsubscribeallconfirmdiscussions'] = 'Momentálne odoberáte príspevky z {$a->discussions} diskusií. Skutočne si želáte zrušiť odoberania zo všetkých týchto diskusií a deaktivovať automatické nastavenie odoberania diskusií?';
$string['unsubscribeallconfirmforums'] = 'Momentálne odoberáte príspevky z {$a->forums} diskusných fór. Skutočne si želáte zrušiť odoberania zo všetkých týchto diskusných fór a deaktivovať automatické nastavenie odoberania diskusií?';
$string['unsubscribealldone'] = 'Odoberanie príspevkov zo všetkých diskusných fór bolo zrušené. Je možné, že Vám budú stále zasielané príspevky z fór s núteným zápisom. Ak chcete spravovať upozornenia fóra, prejdite do časti Správy v časti Nastavenia môjho profilu.';
$string['unsubscribeallempty'] = 'Ľutujem, ale nie ste prihlásení do žiadneho diskusného fóra. Ak chcete vypnúť všetky upozornenia z tohto servera, prejdite do časti Správy v časti Nastavenia môjho profilu.';
$string['unsubscribed'] = 'Odhlásený z odoberania príspevkov';
$string['unsubscribediscussion'] = 'Zrušiť odoberanie príspevkov z tejto diskusie';
$string['unsubscribediscussionlink'] = 'Odhlásiť sa z diskusie: {$a}';
$string['unsubscribelink'] = 'Odhlásiť sa z fóra: {$a}';
$string['unsubscribeshort'] = 'Odhlásiť z odoberania príspevkov';
$string['useexperimentalui'] = 'Použite experimentálne vnorené diskusné zobrazenie';
$string['usermarksread'] = 'Manuálne označovanie prečítaných správ';
$string['usernavigation'] = 'Používateľská navigácia';
$string['usersforumposts'] = 'Príspevky používateľa fóra';
$string['viewalldiscussions'] = 'Zobraziť všetky diskusie';
$string['viewconversation'] = 'Zobraziť diskusiu';
$string['viewgrades'] = 'Zobraziť známky';
$string['viewparentpost'] = 'Zobraziť rodičovský príspevok';
$string['viewthediscussion'] = 'Zobraziť diskusiu';
$string['warnafter'] = 'Upozorniť po prekročení počtu príspevkov';
$string['warnafter_help'] = 'Je možné upozorniť študentov predtým, ako vložia maximálny počet príspevkov počas určeného časového intervalu. Toto nastavenie určuje, po koľkých príspevkoch sú upozornení. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['warnformorepost'] = 'UPOZORNENIE: V tomto fóre je viac ako jedna diskusia - používa sa najnovšia';
$string['yournewquestion'] = 'Nová otázka';
$string['yournewtopic'] = 'Vaša nová diskusná téma';
$string['yourreply'] = 'Vaša odpoveď';
