<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'sk', version '5.0'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptrisk'] = 'Rozumiem, že zakázanie overovania e-mailu môže predstavovať bezpečnostný problém.';
$string['acceptrisk_help'] = 'Zakázanie overenia e-mailu môže potenciálne umožniť používateľovi overiť sa ako iný používateľ.';
$string['authconfirm'] = 'Táto akcia udelí prístup k Moodle pre overený účet. To je určené pre použitie systémového účtu pre správu súborov vlastnených spoločnosťou Moodle.';
$string['authconnected'] = 'Systémový účet je teraz pripojený pre off-line prístup';
$string['authnotconnected'] = 'Systémový účet nebol pripojený pre off-line prístup';
$string['configured'] = 'Konfigurované';
$string['configuredstatus'] = 'Konfigurované';
$string['connectsystemaccount'] = 'Pripojenie k systémovému účtu';
$string['createfromtemplate'] = 'Vytvorenie služby OAuth 2 zo šablóny';
$string['createfromtemplatedesc'] = 'Vyberte jednu z nižšie uvedených šablón služieb OAuth 2 a vytvorte službu OAuth s platnou konfiguráciou pre jeden z typov služieb. Tým vytvoríte službu OAuth 2 so všetkými správnymi koncovými bodmi a parametrami požadovanými pre overenie, ale ešte pred tým, ako ich použijete, musíte zadať ID klienta a kľúč novej služby.';
$string['createnewendpoint'] = 'Vytvoriť nový koncový bod poskytovateľa "{$a}"';
$string['createnewservice'] = 'Vytvoriť novú službu:';
$string['createnewuserfieldmapping'] = 'Vytvoriť nové mapovanie používateľského poľa poskytovateľa "{$a}"';
$string['custom_service'] = 'Vlastné';
$string['deleteconfirm'] = 'Naozaj chcete odstrániť poskytovateľa identity "{$a}"?  Ľuvovoľný zásuvný modul, ktorý na ňom závisí, prestane fungovať.';
$string['deleteendpointconfirm'] = 'Naozaj chcete zmazať koncový bod "{$a->endpoint}" pre poskytovateľa "{$a->emitent}"? Všetky moduly závislé na tomto koncovom bode prestanú fungovať.';
$string['deleteuserfieldmappingconfirm'] = 'Naozaj chcete odstrániť mapovanie používateľského poľa poskytovateľa "{$a}"?';
$string['discovered'] = 'Zisťovanie služby bolo úspešné';
$string['discovered_help'] = 'Zisťovanie znamená, že koncové body OAuth2 môžu byť automaticky určené z adresy URL pre službu OAuth. Nie všetky služby vyžadujú, aby boli "objavené", ale ak nie sú, je potrebné zadať koncové body a informácie o mapovaní používateľov ručne.';
$string['discoverystatus'] = 'Zisťovanie služby';
$string['editendpoint'] = 'Upraviť koncový bod: {$a->endpoint}  poskytovateľa {$a->issuer}';
$string['editendpoints'] = 'Konfigurovať koncové body';
$string['editissuer'] = 'Upraviť poskytovateľa identity: {$a}';
$string['edituserfieldmapping'] = 'Upraviť mapovanie používateľského poľa poskytovateľa {$a}';
$string['edituserfieldmappings'] = 'Konfigurovať mapovanie používateľského poľa';
$string['endpointdeleted'] = 'Koncový bod bol odstránený';
$string['endpointname'] = 'Názov';
$string['endpointname_help'] = 'Kľúč slúži k vyhľadávaniu tohto koncového bodu. Musí skončiť s "_endpoint".';
$string['endpointsforissuer'] = 'Koncový bod poskytovateľa: {$a}';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'Adresa URL tohto koncového bodu. Musí používať protokol https://.';
$string['facebook_service'] = 'Facebook';
$string['google_service'] = 'Google';
$string['issueralloweddomains'] = 'Prihlásenie na domény';
$string['issueralloweddomains_help'] = 'Ak je nastavené, je toto nastavení zoznamu domén, oddelených čiarkami, ktoré budú obmedzené pri prihlasovaní k tomuto poskytovateľovi.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Servisná základná URL';
$string['issuerbaseurl_help'] = 'Servisná základná URL sa používa pre prístup k službe';
$string['issuerclientid'] = 'Id klienta';
$string['issuerclientid_help'] = 'Id klienta OAuth pre tohto poskytovateľa.';
$string['issuerclientsecret'] = 'Heslo klienta';
$string['issuerclientsecret_help'] = 'Heslo klienta OAuth pre tohto poskytovateľa.';
$string['issuerdeleted'] = 'Poskytovateľ identity bol odstránený';
$string['issuerdisabled'] = 'Poskytovateľ identity bol zakázaný';
$string['issuerenabled'] = 'Poskytovateľ identity bol povolený';
$string['issuerimage'] = 'URL loga';
$string['issuerimage_help'] = 'Adresa URL obrázku, ktorý sa používa pre zobrazenie tohto poskytovateľa. Môže sa zobraziť na prihlasovacej stránke.';
$string['issuerloginpagename'] = 'Názov zobrazený na prihlasovacej stránke';
$string['issuerloginpagename_help'] = 'Aj je zadaný, použije sa tento názov na prihlasovacej stránke namiesto názvu služby.';
$string['issuerloginparams'] = 'Ďalšie parametre zahrnuté v požiadavke prihlásenia';
$string['issuerloginparams_help'] = 'Niektoré systémy vyžadujú ďalšie parametre pre prihlásenie, aby si mohli prečítať základný profil používateľov.';
$string['issuerloginparamsoffline'] = 'Ďalšie parametre zahrnuté v požiadavke prihlásenia pre prístup offline.';
$string['issuerloginparamsoffline_help'] = 'Každý OAuth systém definuje iný spôsob, ako požiadať o prístup v režime offline. Napr. Google vyžaduje dodatočné parametrye "access_type=offline&prompt=consent".  Tieto parametre by mali byť vo formáte url dotazu.';
$string['issuerloginscopes'] = 'Rozsahy zahrnuté v požadavke prihlásenia.';
$string['issuerloginscopes_help'] = 'Niektoré systémy vyžadujú ďalšie požiadavky pre prihlásenie, aby si mohli prečítať základný profil používateľov. Štandardné rozsahy systémov kompatibilných s OpenID Connect sú "e-mail s otvoreným profilom".';
$string['issuerloginscopesoffline'] = 'Rozsahy zahrnuté v požiadavke prihlásenia pre prístup offline.';
$string['issuerloginscopesoffline_help'] = 'Každý OAuth systém definuje iný spôsob, ako požiadať o prístup v režime offline. Napr. Microsoft vyžaduje ďalší priestor "offline_access".';
$string['issuername'] = 'Názov';
$string['issuername_help'] = 'Názov poskytovateľa identity. Môže sa zobraziť na prihlasovacej stránke.';
$string['issuerrequireconfirmation'] = 'Požadovať overenie e-mailom';
$string['issuerrequireconfirmation_help'] = 'Požiadajte, aby si všetci používatelia overili svoju e-mailovú adresu, kým sa budú hlásiť pomocou služby OAuth. To sa týka novo vytvorených účtov v rámci prihlasovacieho procesu alebo keď je existujúci účet Moodle pripojený k prihlasovaniu OAuth prostredníctvom odpovedajúcich e-mailových adries.';
$string['issuers'] = 'Poskytovatelia';
$string['issuersetup'] = 'Podrobné pokyny pre konfiguráciu bežných služieb OAuth 2';
$string['issuersetuptype'] = 'Podrobné informácie o nastavení protokolu OAuth 2 poskytovateľa {$a}';
$string['issuershowonloginpage'] = 'Zobraziť na prihlasovacej stránke';
$string['issuershowonloginpage_help'] = 'Ak je povolený modul OAuth 2, bude tento poskytovateľ zobrazený na prihlasovacej stránke, aby používatelia mohli prihlásiť sa k účtom od tohto poskytovateľa.';
$string['issuersservicesallow'] = 'Povoliť služby';
$string['issuersservicesnotallow'] = 'Nepovoliť služby';
$string['issuerusedforinternal'] = 'Interné služby';
$string['issuerusedforlogin'] = 'Prihlásenie';
$string['issuerusein'] = 'Táto služba bude využívaná';
$string['issuerusein_help'] = 'Služby OAuth 2 možno v prípade potreby použiť pre interné služby, na prihlasovacej stránke alebo pre obe.';
$string['issueruseineverywhere'] = 'Prihlasovacia stránka a interné služby';
$string['issueruseininternalonly'] = 'Iba interné služby';
$string['issueruseinloginonly'] = 'Iba prihlasovacia stránka';
$string['linkedin_service'] = 'LinkedIn';
$string['logindisplay'] = 'Zobraziť na prihlasovacej stránke ako';
$string['loginissuer'] = 'Povoliť prihlasovanie';
$string['microsoft_service'] = 'Microsoft';
$string['nextcloud_service'] = 'Nextcloud';
$string['notconfigured'] = 'Nie je nakonfigurované';
$string['notdiscovered'] = 'Zistenie služby nebolo úspešné';
$string['notloginissuer'] = 'Zakázať prihlásenie';
$string['pluginname'] = 'Služby OAuth 2';
$string['privacy:metadata'] = 'Zásuvný modul Služby OAuth 2 neukladá žiadne osobné údaje';
$string['savechanges'] = 'Uložiť zmeny';
$string['serviceshelp'] = 'Pokyny k nastaveniu služieb poskytovateľa.';
$string['systemaccountconnected'] = 'Pripojený systémový účet';
$string['systemaccountconnected_help'] = 'Systémové účty sa používajú v moduloch z poskytnutiu pokročilých funkcií. Nie sú požadované iba pre funkcie prihlásenia, ale iné moduly používajúce službu OAuth môžu ponúkať obmedzenú sadu funkcií, ak nebol pripojený systémový účet. Napríklad úložiská nemôžu bez systémového účtu spracovať "riadené odkazy" pre vykonanie operácií so súbormi.';
$string['systemaccountnotconnected'] = 'Systémový účet nie je pripojený';
$string['systemauthstatus'] = 'Pripojený systémový účet';
$string['usebasicauth'] = 'Autentizácia tokenu vyžaduje hlavičky HTTP';
$string['usebasicauth_help'] = 'Pri odosielaní ID klienta a hesla pomocou požiadavky na obnovenie tokenu použite schému overovania HTTP Basic. Je odporúčaný štandardom OAuth 2, ale u niektorých emitentov nemusí byť k dispozícii.';
$string['userfieldexternalfield'] = 'Názov externého poľa';
$string['userfieldexternalfield_error'] = 'Toto pole nemôže obsahovať kód HTML.';
$string['userfieldexternalfield_help'] = 'Názov príslušného poľa externého OAuth systému.';
$string['userfieldinternalfield'] = 'Názov interného poľa';
$string['userfieldinternalfield_help'] = 'Názov používateľského poľa Moodle, ktorý by mal byť mapovaný z externého poľa.';
$string['userfieldmappingdeleted'] = 'Mapovanie používateľského poľa bolo odstránené';
$string['userfieldmappingsforissuer'] = 'Mapovanie používateľského poľa poskytovateľa: {$a}';
