<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'jazzquiz', language 'pl', version '5.0'.
 *
 * @package     jazzquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_out_of_b_responded'] = '{$a->a} / {$a->b} użytkowników odpowiedziało';
$string['a_out_of_b_voted'] = '{$a->a} / {$a->b} użytkowników zagłosowało';
$string['a_responses'] = '{$a} odpowiedzi';
$string['a_students_answered'] = '<b>{$a}</b> studentów odpowiedziało na co najmniej jedno pytanie.';
$string['a_students_joined_quiz'] = '<b>{$a}</b> Studentów dołączyło do quizu.';
$string['add'] = 'Dodaj do quizu';
$string['add_question'] = 'Dodaj pytanie';
$string['add_to_quiz'] = 'Dodaj do quizu';
$string['allow_guests'] = 'Wpuść gości';
$string['anonymous'] = 'Anonimowa';
$string['anonymous_answers'] = 'Anonimowe odpowiedzi. Umożliwia weryfikację frekwencji';
$string['anonymous_answers_info'] = 'Odpowiedzi na pytania są anonimowe, jednakże Twoja obecność w quizie jest rejestrowana';
$string['answer'] = 'Poprawna odpowiedź';
$string['ask_teacher'] = 'Jeśli masz wątpliwości, zapytaj nauczyciela.';
$string['attempt_started'] = 'Już rozpocząłeś podejście, naciśnij przycisk poniżej aby dołączyć do trwającego podejścia.';
$string['attempts'] = 'Podejścia';
$string['attendance'] = 'Frekwencja';
$string['attendance_list'] = 'Lista obecności';
$string['click_to_show_original_results'] = 'Pokaż oryginalne wyniki';
$string['click_to_show_vote_results'] = 'Pokaż wyniki głosowania';
$string['closing_session'] = 'Zamykanie podejścia...';
$string['create_new_question'] = 'Stwórz nowe pytanie';
$string['default_question_time'] = 'Domyślny czas na pytanie';
$string['default_question_time_help'] = 'Domyślny czas na każde pytanie<br>Tę regułę można nadpisać przypisyjąc czas bezpośrednio do pytania';
$string['delete_question'] = 'Usuń pytanie {$a}';
$string['delete_report'] = 'Usuń raport';
$string['download_attendance_list'] = 'Pobierz listę obecności';
$string['download_report'] = 'Pobierz raport';
$string['download_responses'] = 'Pobierz odpowiedzi';
$string['edit'] = 'Edytuj';
$string['edit_page_open_session_error'] = 'Nie możesz edytować pytań podczas aktywnego podejścia do quizu.';
$string['edit_question'] = 'Edytuj pytanie';
$string['end'] = 'Zakończ pytanie';
$string['error_getting_current_results'] = 'Nie można pobrać wyników';
$string['error_getting_vote_results'] = 'Nie można pobrać wyników głosowania';
$string['error_saving_vote'] = 'Nie można oddać głosu';
$string['error_starting_vote'] = 'Nie można rozpocząć głosowania';
$string['error_with_request'] = 'Błąd żądania';
$string['event_attempt_started'] = 'Podejście w toku';
$string['event_question_answered'] = 'Udzielono już odpowiedzi na to pytanie';
$string['exit'] = 'Wyjdź';
$string['failed_to_end_question'] = 'Nie można zamknąć pytania';
$string['fullscreen'] = 'Pełny ekran';
$string['fully_anonymous'] = 'W pełni anonimowe';
$string['fully_anonymous_info'] = 'Podejście jest w pełni anonimowe';
$string['goto_session'] = 'Dołącz do trwającego podejścia';
$string['guest_login'] = 'Nie jesteś zapisany na kurs i w tej chwili nie ma otwartej sesji quizu dla gości.';
$string['improvise'] = 'Improwizuj pytanie';
$string['instructions_for_instructor'] = '<h3>Upewnij się że przeczytałeś instrukcje</h3>
    <p>Dostępne są skróty klawiszowe, dostępne gdy nie jest zaznaczone żadne pole</p>
    <table class="table table-hover table-bordered">
        <tr>
               <th>Przycisk</th>
               <th>Skróty klawiszowe</th>
               <th>Opis</th>
        </tr>
        <tr>
            <td>
                <i class="fa fa-repeat"></i> Cofnij pytanie
            </td>
            <td>r</td>
            <td>
                Pozwala na zresetowanie pytania. Wszystkie odpowiedzi są unieważniane i studenci muszą odpowiedzieć jeszcze raz.</br>
                Działanie daje taki sam efekt jak skorzystanie z <i class="fa fa-bars"></i> Listy pytań.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bar-chart"></i> Głosowanie
            </td>
            <td>v</td>
            <td>
                 Pozwól studentom głosować na swoje odpowiedzi</br>
                 Nauczyciel może zaznaczyć odpowiedź w celu wykluczenia lub dodania odpowiedzi do puli, na którą będzie można głosować</br>
                 Klikając na pasek odpowiedzi, możesz połączyć ją z innymi pytaniami poprzez wybranie ich paska.</br>
                 Zauważ, że ten pasek ukryje pasek, na który klikniesz w następnej kolejności.</br>
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-edit"></i> Improwizacja
            </td>
            <td>i</td>
            <td>
                Pokazuje listę pytań do improwizacji. Podyktuj studentom zadanie i poproś studentów o odpowiedzenie na pytania z listy pytań do improwizacji
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bars"></i> Pokaż pytania
            </td>
            <td>j</td>
            <td>
                Pokazuje listę wszystkich pytań zaplanowanych do quizu.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-forward"></i> Następne
            </td>
            <td>n</td>
            <td>
                Przejdź do następnego pytania na liście zaplanowanych pytań.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-random"></i> Losuj
            </td>
            <td>m</td>
            <td>
                Rozpoczyna losowe pytanie z listy zaplanowanych pytań.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-close"></i> Zamknij pytanie
            </td>
            <td>e</td>
            <td>
                Zamyka aktualne pytanie
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-expand"></i> Pełny ekran
            </td>
            <td>f</td>
            <td>
                Pokaż wyniki na pełnym ekranie. Odpowiedzi do pytania nie pojawią się przed jego zamknięciem, więc możesz robić to przez całą sesje.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i> / <i class="fa fa-check-square-o"></i> Pokaż poprawną odpowiedź
            </td>
            <td>a</td>
            <td>
                Pokazuje poprawną odpowiedź po zakończeniu pytania
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i> / <i class="fa fa-check-square-o"></i> Pokaż/Ukryj wszystkie odpowiedzi
            </td>
            <td>t</td>
            <td>
                Pokazuje lub chowa wszystkie odpowiedzi na dane pytanie
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-window-close"></i> Zamknij podejście
            </td>
            <td>Brak</td>
            <td>
                Kończy aktualne podejście
            </td>
        </tr>
    </table>';
$string['instructions_for_student'] = '<p>Oczekiwanie na rozpoczęcie quizu.</p>';
$string['instructor_sessions_going'] = 'Podejście już trwa, naciśnij przycisk poniżej aby do niego dołączyć.';
$string['invalid_question_time'] = 'Czas testu musi być liczbą całkowitą, większą od 0';
$string['jazzquiz:addinstance'] = 'Dodaj Jazzquiz';
$string['jazzquiz:attempt'] = 'Podejdź do Quizu';
$string['jazzquiz:control'] = 'Kontroluj przebieg Quizu';
$string['jazzquiz:editquestions'] = 'Edytuj pytania';
$string['jazzquiz:seeresponses'] = 'Oceń wszystkie odpowiedzi';
$string['jazzquizsettings'] = 'Ustawienia JazzQuiz';
$string['join_quiz'] = 'Dołącz do quizu';
$string['join_quiz_instructions'] = 'Naciśnij przycisk poniżej, aby dołączyć do quizu.';
$string['jump'] = 'Przejdź do pytania';
$string['loading'] = 'Ładowanie...';
$string['modulename'] = 'JazzQuiz';
$string['modulename_help'] = '<p>
    JazzQuiz umożliwia tworzenie quizów i przeprowadzania ich w czasie rzeczywistym. Wszystkie podstawowe pytania dostępne w quizach, można utworzyć w JazzQuiz-ie.
</p>
<p>
    Podczas podejścia nauczyciel może dowolnie przechodzić między pytaniami.
    Odpowiedzi dostępne są w postaci grafu działającego w czasie rzeczywistym. Widok jest zoptymalizowany do wyświetlania na pełnym ekranie oraz przy pomocy rzutnika.
    Czas odpowiedzi na pytanie może być ustawiony automatycznie lub prowadzący może decydować o przejściu do następnego pytania
</p>';
$string['modulenameplural'] = 'JazzQuiz-y';
$string['multichoice_options'] = 'Wielokrotny wybór';
$string['next'] = 'Następne pytanie';
$string['no_attempts_found'] = 'Brak podejść do quizu';
$string['no_guests'] = 'Możliwe, że nauczyciel nie rozpoczął jeszcze sesji quizu i możesz spróbować ponownie później. Może się również zdarzyć, że będziesz musiał zalogować się jako student i zapisać się na kurs, aby móc wziąć w nim udział.';
$string['no_session'] = 'Brak trwających podejść';
$string['no_sessions_exist'] = 'Nie znaleziono żadnego podejścia.';
$string['no_students_have_joined'] = 'Żaden student nie dołączył';
$string['no_time_limit'] = 'Brak limitu czasowego';
$string['no_time_limit_help'] = 'Nie nakładaj ograniczenia czasowego na udzielenie odpowiedzi na to pytanie<p>Aby zakończyć możliwość udzielnia odpowiedzi, prowadzący będzie musiał ręcznie zamknać pytanie</p>';
$string['nonanonymous_session'] = 'Podejście jawne';
$string['nonanonymous_session_info'] = 'Podejście jest jawne, zarówno Twoja obecność jak i odpowiedzi będą widoczne.';
$string['one_student_has_joined'] = 'Dołączył jeden student';
$string['pluginadministration'] = 'Administracja JazzQuiz';
$string['pluginname'] = 'JazzQuiz';
$string['privacy:metadata:core_question'] = 'JazzQuiz przechowuje informacje o pytaniach w podsystemie core_question';
$string['privacy:metadata:jazzquiz_attempts'] = 'Szczegółowe informacje o podejściu użytkownika';
$string['privacy:metadata:jazzquiz_attempts:responded'] = 'Czy udzielono odpowiedzi na ostatnie pytanie';
$string['privacy:metadata:jazzquiz_attempts:timefinish'] = 'Czas odpowiedzenia na ostatnie pytanie';
$string['privacy:metadata:jazzquiz_attempts:timemodified'] = 'Czas ostatniej zmiany odpowiedzi na ostatnie pytanie.';
$string['privacy:metadata:jazzquiz_attempts:timestart'] = 'Czas rozpoczęcia ostatniego pytania';
$string['privacy:metadata:jazzquiz_attempts:userid'] = 'Podejście użytkownika';
$string['question'] = 'Pytanie';
$string['question_move_down'] = 'Przesuń pytanie {$a} niżej';
$string['question_move_up'] = 'Przesuń pytanie {$a} wyżej';
$string['question_time'] = 'Czas na pytanie';
$string['question_time_help'] = 'Czas na pytanie (W sekundach).';
$string['question_will_end_in_x_seconds'] = 'Pytanie zamknie się za {$a} s.';
$string['question_will_start_in_x_seconds'] = 'Za chwilę zobaczysz pytanie {$a} s.';
$string['question_will_start_now'] = 'Za chwilę zobaczysz pytanie.';
$string['questions'] = 'Pytania';
$string['quit'] = 'Zakończ podejście';
$string['quiz_not_running'] = '<p>Oczekiwanie na rozpoczęcie quizu.</p><p>Aby ponownie sprawdzić czy quiz już sie rozpoczął odśwież stronę.</p>';
$string['random'] = 'Losuj';
$string['repoll'] = 'Ponów pytanie';
$string['reports'] = 'Archiwum';
$string['responses'] = 'Wszystkie odpowiedzi';
$string['review'] = 'Przejrzyj';
$string['save_question'] = 'Zapisz pytanie';
$string['select_session'] = 'Wybierz podejście';
$string['session'] = 'Podejście';
$string['session_closed'] = 'Podejście zostało zamknięte.';
$string['session_name'] = 'Nazwa podejścia';
$string['session_name_required'] = 'Musisz podać nazwę podejścia';
$string['short_answer'] = 'Krótka odpowiedź';
$string['short_math_answer'] = 'Wynik';
$string['showing_original_results'] = 'Oryginalne wyniki';
$string['showing_vote_results'] = 'Wyniki głosowania';
$string['start_session'] = 'Rozpocznij podejście';
$string['startquiz'] = 'Rozpocznij quiz';
$string['student'] = 'Student';
$string['teacher_start_instructions'] = '<p>Rozpocznij quiz, aby umożliwić podejście studentom.</p><p><b>Szczegółowa nazwa podejścia</b> może pomóc w późniejszym odnalezieniu go w archiwum.</p>';
$string['unable_to_create_session'] = 'Nie można utworzyć testu';
$string['view'] = 'Podejście';
$string['vote'] = 'Głosuj';
$string['wait_for_instructor'] = 'Oczekiwanie na decyzję prowadzącego o rozpoczęciu następnego pytania.';
$string['wait_for_question_time'] = 'Czas oczekiwania na kolejne pytanie';
$string['wait_for_question_time_help'] = 'Czas jaki student będzie czekał na możliwość odpowiedzi na kolejne pytanie';
$string['wait_for_students'] = 'Oczekiwanie na połączenie studentów.';
$string['x_seconds_left'] = 'Pozostało {$a} s';
$string['x_students_have_joined'] = '{$a} studentów dołączyło';
$string['you_already_voted'] = 'Już zagłosowałeś';
