<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pt', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acesso negado';
$string['accountlocked'] = 'A sua conta está bloqueada. Foi enviada via e-mail uma hiperligação para desbloquear.';
$string['accounts'] = 'Contas';
$string['accountunlocked'] = 'A sua conta está desbloqueada. Pode autenticar-se.';
$string['addcategory'] = 'Adicionar categoria';
$string['additionalhtml'] = 'HTML adicional';
$string['additionalhtml_desc'] = 'Estas configurações permitem indicar código HTML que será incluído em todas as páginas do site. É possível especificar código HTML que será adicionado dentro da secção HEAD da página, no início da secção BODY ou no final da secção BODY.<br />Desta forma é possível adicionar cabeçalhos e rodapés personalizados em qualquer página, bem como configurar aplicações como o Google Analytics de forma fácil, independente do tema que estiver em utilização.';
$string['additionalhtml_heading'] = 'HTML adicional que será incluído em todas as páginas';
$string['additionalhtmlfooter'] = 'Antes da secção BODY ser fechada';
$string['additionalhtmlfooter_desc'] = 'Este conteúdo será adicionado no final da secção BODY de todas as páginas.';
$string['additionalhtmlhead'] = 'Antes da secção HEAD ser fechada';
$string['additionalhtmlhead_desc'] = 'Este conteúdo será adicionado no final da secção HEAD de todas as páginas.';
$string['additionalhtmltopofbody'] = 'Quando a secção BODY é aberta';
$string['additionalhtmltopofbody_desc'] = 'Este conteúdo será adicionado no início da secção BODY de todas as páginas.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Administradores veem todos os eventos';
$string['adminseesallevents'] = 'Administradores veem todos os eventos';
$string['adminseesownevents'] = 'Administradores são como os outros utilizadores';
$string['advancedfeatures'] = 'Funcionalidades avançadas';
$string['agedigitalconsentverification'] = 'Verificar idade mínima de consentimento';
$string['agedigitalconsentverification_desc'] = 'Permite a verificação da idade mínima de consentimento antes de mostrar aos utilizadores a página de autorregisto na plataforma. Isto protege o seu site de autoregisto de menores sem o consentimento dos pais/responsáveis. <a target="_blank" href="{$a}">Contacte o suporte</a> para mais detalhes e ajuda.';
$string['ageofdigitalconsentmap'] = 'Idade mínima de consentimento';
$string['ageofdigitalconsentmap_desc'] = 'Valor predefinido da idade mínima de consentimento e a idade em que esta difere do padrão em determinado país, pode ser especificada aqui. Digite cada idade numa nova linha no formato: código do país, idade (separada por uma vírgula). A idade padrão é indicada com * no lugar do código do país. Os códigos dos países são os especificados na ISO 3166-2.';
$string['allcountrycodes'] = 'Códigos de todos os países';
$string['allowattachments'] = 'Permitir anexos';
$string['allowbeforeblock'] = 'Processar primeiro a lista de permissões';
$string['allowbeforeblockdesc'] = 'Por predefinição, os endereços na lista de IPs bloqueados são os primeiros a serem verificados. Se ativar esta opção, os endereços na lista de IPs permitidos serão verificados antes dos IPs bloqueados.';
$string['allowcategorythemes'] = 'Permitir definir temas para categorias';
$string['allowcohortthemes'] = 'Permitir definir temas para Grupos globais';
$string['allowcoursethemes'] = 'Permitir definir temas para disciplinas';
$string['allowedemaildomains'] = 'Domínios de e-mail permitidos';
$string['allowediplist'] = 'Lista de IPs permitidos';
$string['allowemailaddresses'] = 'Domínios de e-mail permitidos';
$string['allowemojipicker'] = 'Escolher emoji';
$string['allowframembedding'] = 'Permitir incorporar em frame';
$string['allowframembedding_help'] = 'Se ativar esta opção, é permitida a incorporação deste site em frames de sistemas externos, tal como recomendado ao usar "Publicar como ferramenta LTI". Por motivos de segurança, não é recomendado ativar esta opção. Tenha em atenção que, para a Aplicação móvel Moodle, esta configuração é ignorada e a incorporação em frames é sempre permitida.';
$string['allowguestmymoodle'] = 'Permitir o acesso de visitante ao Painel do utilizador';
$string['allowindexing'] = 'Permitir indexação pelos motores de busca';
$string['allowindexing_desc'] = 'Esta opção determina se os motores de busca podem, ou não, indexar o seu site. "Todo o site" permitirá que os motores de busca pesquisem em todas as páginas, incluindo a de entrada e a de registo, o que significa que os sites com a opção "Forçar autenticação" ativada são igualmente indexados. Para evitar o risco de spam envolvido com o facto da página de entrada ser pesquisável, selecione "Todo o site, exceto autenticação". "Não indexar" indicará aos motores de busca que não indexem nenhuma página. Tenha em atenção que esta é apenas uma tag no cabeçalho do site. Cabe ao motor de busca respeitar, ou não, a tag.';
$string['allowindexingeverywhere'] = 'Em todas as páginas';
$string['allowindexingexceptlogin'] = 'Em todas as páginas exceto páginas de entrada e autenticação';
$string['allowindexingnowhere'] = 'Em nenhuma página';
$string['allowobjectembed'] = 'Permitir <i>tags</i> EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Permitir mudança de tema através de URL';
$string['allowuserblockhiding'] = 'Permitir aos utilizadores ocultar blocos';
$string['allowusermailcharset'] = 'Permitir que o utilizador selecione o conjunto de caracteres';
$string['allowuserswitchrolestheycantassign'] = 'Permitir que os utilizadores sem permissão para atribuir papéis possam assumir outros papéis';
$string['allowuserthemes'] = 'Permitir ao utilizador escolher o seu tema';
$string['alternativefullnameformat'] = 'Formato alternativo do nome completo';
$string['alternativefullnameformat_desc'] = 'Isto define como os nomes são exibidos para utilizadores com a permissão \'viewfullnames\' (por predefinição, os utilizadores com o papel de gestor, professor ou professor não-editor). Os espaços reservados que podem ser usados são idênticos aos da configuração de "Formato de nome completo".';
$string['always'] = 'Sempre';
$string['appearance'] = 'Aparência';
$string['aspellpath'] = 'Caminho para o programa <strong>aspell</strong>';
$string['asyncbackupdisabled'] = 'O seu site está atualmente configurado para efetuar cópias de segurança síncronas. As cópias de segurança assíncronas proporcionam uma melhor experiência para o utilizador, permitindo que os utilizadores realizem outras operações enquanto uma cópia de segurança ou um restauro está em andamento. As cópias de segurança assíncronas serão ativadas para todos os sites a partir do Moodle LMS 4.5 LTS. As cópias de segurança síncronas serão removidas do Moodle LMS nas versões posteriores à 4.5 LTS.';
$string['authentication'] = 'Autenticação';
$string['authpreventaccountcreation'] = 'Impedir a criação de contas na autenticação';
$string['authpreventaccountcreation_help'] = 'Quando um utilizador que ainda não tem conta no site se autentica com sucesso, é criada automaticamente a sua conta. Se for usada uma base de dados externa para a autenticação, como o LDAP, mas pretende limitar o acesso ao site apenas aos utilizadores que já têm uma conta existente, então deve ativar esta opção. As novas contas terão de ser criadas manualmente ou através do carregamento de ficheiro de utilizadores. Tenha em atenção que esta configuração não se aplica à autenticação MNet.';
$string['authsettings'] = 'Gerir autenticação';
$string['autolang'] = 'Deteção automática';
$string['autolangusercreation'] = 'Definir o idioma do navegador do utilizador como o seu idioma preferido';
$string['autologinguests'] = 'Autenticar automaticamente os visitantes';
$string['availableto'] = 'Disponível para ';
$string['availabletoanyone'] = 'Disponível para os visitantes do site';
$string['availabletoauthenticated'] = 'Apenas para utilizadores autenticados';
$string['backgroundcolour'] = 'Cor transparente';
$string['backup_shortname'] = 'Usar nome da disciplina no nome do ficheiro da cópia de segurança';
$string['backup_shortnamehelp'] = 'Usar nome da disciplina como parte do nome do ficheiro da cópia de segurança.';
$string['backups'] = 'Cópias de segurança';
$string['badwordsconfig'] = 'Nesta configuração devem ser indicadas as palavras a censurar, separadas por vírgulas.';
$string['badwordsdefault'] = 'Se a lista personalizada estiver vazia, será utilizada uma lista predefinida do pacote de idiomas.';
$string['badwordslist'] = 'Lista de palavras a censurar';
$string['blockediplist'] = 'Lista de IPs bloqueados';
$string['blockinstances'] = 'Instâncias';
$string['blockmultiple'] = 'Múltiplo';
$string['blockprotect'] = 'Proteger instâncias';
$string['blockprotect_help'] = 'Se bloquear um tipo de bloco em particular, ninguém poderá adicionar ou apagar as suas instâncias. (Pode, evidentemente, desbloquear novamente se tiver de editar alguma instância.)

Esta opção é usada principalmente para proteger blocos como os blocos Navegação e Configurações que são muito difíceis de recuperar caso sejam acidentalmente apagados.';
$string['blockprotectblock'] = 'Proteger instâncias de \'{$a}\'';
$string['blockprotected'] = 'As instâncias do bloco \'{$a}\' estão protegidas';
$string['blocksettings'] = 'Gerir blocos';
$string['blockunprotectblock'] = 'Desproteger instâncias de \'{$a}\'';
$string['blockunprotected'] = 'As instâncias do bloco \'{$a}\' estão desprotegidas';
$string['bloglevel'] = 'Visibilidade dos blogues';
$string['bookmarkadded'] = 'Marcador criado.';
$string['bookmarkalreadyexists'] = 'Já criou um marcador para esta página';
$string['bookmarkdeleted'] = 'Marcador apagado';
$string['bookmarkthispage'] = 'Criar marcador para esta página';
$string['cacheapplication'] = 'Cache da aplicação';
$string['cacheapplicationhelp'] = 'Os itens da cache são partilhados entre todos os utilizadores e expiram após um determinado TTL (Time To Live).';
$string['cachejs'] = 'Cache do JavaScript';
$string['cachejs_help'] = 'A realização de cache e compressão do código JavaScript diminui significativamente o tempo que as páginas levam a carregar. É recomendado para sites em produção. Os programadores necessitarão provavelmente de desativar esta configuração.';
$string['cacherequest'] = 'Solicitar cache';
$string['cacherequesthelp'] = 'Cache específica do utilizador que expira quando o pedido é concluído. Concebida para substituir áreas onde são utilizadas unidades de armazenamento estáticas.';
$string['cachesession'] = 'Cache da sessão';
$string['cachesessionhelp'] = 'Cache específica do utilizador que expira quando a sessão do utilizador termina. Concebido para aliviar a sobrecarga/esforço da sessão.';
$string['cachesettings'] = 'Configurações da cache';
$string['cachetemplates'] = 'Armazenar modelos em cache';
$string['cachetemplates_help'] = 'O armazenamento dos modelos em cache melhorará o desempenho do carregamento da página e é altamente recomendado para sites de produção. Os programadores provavelmente desejam desativar esta funcionalidade.';
$string['caching'] = 'Cache';
$string['calendar_weekend'] = 'Dias do fim de semana';
$string['calendarexportsalt'] = 'Salt de exportação do calendário';
$string['calendarsettings'] = 'Calendário';
$string['calendartype'] = 'Tipo de calendário';
$string['calendartype_desc'] = 'Selecione o tipo de calendário predefinido para todo o site. Esta configuração pode ser redefinida nas configurações da disciplina ou pelos utilizadores no seu perfil pessoal.';
$string['campaign'] = 'Campanha';
$string['cannotdeletemodfilter'] = 'O filtro \'{$a->filter}\' não pode ser desinstalado porque faz parte do módulo \'{$a->module}\' .';
$string['cannotuninstall'] = '{$a} não pode ser desinstalado.';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = 'A variável \'$CFG->wwwroot\' está mal definida no seu ficheiro config.php. Foi incluída uma barra \'/\' no fim que tem de ser retirada.';
$string['cfgwwwrootwarning'] = 'A variável \'$CFG->wwwroot\' está mal definida no seu ficheiro config.php. Tem de coincidir com o URL que está a usar para aceder a esta página.';
$string['change'] = 'alterar';
$string['checkboxno'] = 'Não';
$string['checkboxyes'] = 'Sim';
$string['checkupgradepending'] = 'Atualizar';
$string['choosefiletoedit'] = 'Selecione o ficheiro a editar';
$string['cleanup'] = 'Limpeza';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliexitgraceful'] = 'A sair normalmente. Por favor, aguarde...';
$string['cliexitnow'] = 'A sair AGORA';
$string['cliincorrectvalueerror'] = 'Erro: o valor "{$a->value}" não é permitido para a opção "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorreto, por favor, tente novamente';
$string['clistatusdisabled'] = 'Estado: desativado';
$string['clistatusenabled'] = 'Estado: ativado';
$string['clistatusenabledlater'] = 'Estado: modo de manutenção CLI ficará ativo em {$a}';
$string['clitypevalue'] = 'insira valor';
$string['clitypevaluedefault'] = 'insira valor, pressione a tecla \'Enter\' para usar o valor predefinido ({$a})';
$string['cliunknowoption'] = 'Opções desconhecidas: {$a}. Por favor, use a opção --help';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Para limpar as restantes caches após a transição do tráfego dos utilizadores para o novo código:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Têm de ser realizados de forma isolada, com um intervalo entre os comandos, para reduzir picos de carga no servidor web.';
$string['cliupgradedefault'] = 'Nova configuração: {$a}';
$string['cliupgradedefaultheading'] = 'Novos valores predefinidos da configuração';
$string['cliupgradedefaultverbose'] = 'Nova configuração: {$a->name}, Valor predefinido: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'A atualização da versão {$a->oldversion} para {$a->newversion}, através da linha de comandos, foi realizada com sucesso.';
$string['cliupgrademaintenancenotrequired'] = 'Esta atualização NÃO resultará em modo de manutenção para os utilizadores.';
$string['cliupgrademaintenancerequired'] = 'Esta atualização RESULTARÁ em modo de manutenção para os utilizadores.';
$string['cliupgradenoneed'] = 'Não é necessária qualquer atualização para a versão {$a}.';
$string['cliupgradepending'] = 'Está pendente uma atualização';
$string['cliupgradesetlock'] = 'A atualização foi bloqueada apenas para a execução na CLI.';
$string['cliupgradeunsetlock'] = 'O bloqueio existente de atualização apenas por execução na CLI foi removido.';
$string['cliyesnoprompt'] = 'digite s (para sim) ou n (para não)';
$string['close'] = 'Fechar';
$string['cohort_customfield'] = 'Campos personalizados do Grupo global';
$string['commentsperpage'] = 'Comentários por página';
$string['commonactivitysettings'] = 'Configurações comuns';
$string['commonfiltersettings'] = 'Configurações comuns dos filtros';
$string['commonsettings'] = 'Configurações comuns';
$string['componentinstalled'] = 'A informação foi atualizada';
$string['computedfromlogs'] = 'Calculado a partir dos registos de atividade desde {$a}.';
$string['condifmodeditdefaults'] = 'Os valores predefinidos são usados no formulário de configurações ao criar uma nova atividade ou recurso.';
$string['confeditorhidebuttons'] = 'Selecione os botões do editor HTML que devem estar ocultos.';
$string['configallcountrycodes'] = 'Lista dos países que podem ser selecionados em vários locais, como por exemplo, no perfil do utilizador. Se não for indicado qualquer valor, será usada a lista definida no pacote linguístico do inglês. É a lista da norma ISO 3166-1. Se pretender, pode indicar uma lista de códigos separados por vírgulas (Ex: \'GB,FR,ES\'). Se adicionar novos códigos que não existam na norma, estes terão que ser também adicionados no ficheiro \'countries.php\' do pacote linguístico usado no site.';
$string['configallowassign'] = 'Para cada papel na coluna da esquerda, selecione quais os papéis que podem atribuir a outras pessoas.';
$string['configallowattachments'] = 'Se ativar esta opção, os e-mails enviados a partir do site podem ter anexos, tais como medalhas.';
$string['configallowcategorythemes'] = 'Se ativar esta opção, será possível escolher um tema para uma categoria. Este tema será usado em todas as disciplinas da categoria e das respetivas subcategorias, a menos que tenham definido o seu próprio tema. <strong>Atenção</strong>: O uso de temas para as categorias pode prejudicar o desempenho.';
$string['configallowcohortthemes'] = 'Se ativar esta opção, os temas poderão ser definidos para cada Grupo global. Afetará todos os utilizadores que pertençam a um ou mais Grupos globais, mas com o mesmo tema.';
$string['configallowcoursethemes'] = 'Se ativar esta opção, será possível definir o tema de uma disciplina. O tema da disciplina prevalece sobre outras definições do tema (tema do site, do utilizador, da categoria, do Grupo global ou temas definidos por URL).';
$string['configallowedemaildomains'] = 'Liste os domínios de e-mail que podem ser divulgados na secção "De" do e-mail enviado. O valor predefinido de "Em branco" usará o endereço de \'Não responder\' (no-reply) para todos os e-mails enviados. É permitido o uso de caracteres especiais, por exemplo, *.example.com permitirá os e-mails enviados de qualquer subdomínio de example.com, mas não de example.com propriamente dito. Para este último será necessária uma entrada em separado.';
$string['configallowemailaddresses'] = 'Se pretender restringir os novos endereços de e-mail a domínios específicos, insira-os aqui, separados por espaços. Todos os outros domínios serão rejeitados. Para permitir subdomínios, adicione o domínio precedido de um ponto. Para permitir um domínio raiz juntamente com os seus subdomínios, adicione o domínio duas vezes - uma vez com um ponto antes do nome e uma vez sem ponto, por exemplo, .nossaescola.edu.pt nossaescola.edu.pt.';
$string['configallowemojipicker'] = 'O seletor de emojis permite aos utilizadores selecionarem emojis, como por exemplo, smilies, para adicionar a mensagens e a outras áreas de texto através de um botão de seleção de emojis na barra de ferramentas do Atto.';
$string['configallowemojipickerincompatible'] = 'A configuração atual da sua base de dados não oferece suporte adequado a emojis. Para ativar o seletor de emojis, é necessário atualizar a sua base de dados para obter <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">suporte unicode completo</a>.';
$string['configallowguestmymoodle'] = 'Se ativar esta opção, os visitantes podem aceder ao Painel do utilizador, caso contrário, os visitantes serão redirecionados para a Página inicial do site.';
$string['configallowobjectembed'] = 'Como medida de segurança, os utilizadores com o papel de aluno não têm permissão para incorporar objetos multimédia em textos utilizando as tags EMBED e OBJECT no HTML,  embora os objetos multimédia possam continuar a ser exibidos usando o filtro de módulos de multimédia. Caso pretenda permitir estas tags, ative esta opção.';
$string['configallowoverride'] = 'Permitir que os utilizadores com os papéis à esquerda possam redefinir alguns dos papéis das colunas.';
$string['configallowoverride2'] = 'Para cada papel na coluna da esquerda, selecione quais os papéis que podem ser redefinidos para eles.<br />Os utilizadores têm de ter a permissão \'moodle/role:override\' ou a permissão \'moodle/role:safeoverride\'.';
$string['configallowswitch'] = 'Para cada papel na coluna da esquerda, selecione quais os papéis que podem assumir. Os utilizadores têm de ter a permissão \'moodle/role:switchroles\'.';
$string['configallowthemechangeonurl'] = 'Se ativar esta opção, o tema pode ser mudado adicionando o elemento \'theme={themename}\' a qualquer URL.';
$string['configallowuserblockhiding'] = 'Pretende permitir aos utilizadores ocultar/mostrar os blocos laterais em todo o site? Esta funcionalidade usa JavaScript e cookies para memorizar o estado de cada bloco, e apenas afeta o modo de visualização do utilizador.';
$string['configallowusermailcharset'] = 'Se ativar esta opção, os utilizadores podem selecionar nas configurações do seu perfil um conjunto de caracteres para usar no e-mail.';
$string['configallowuserswitchrolestheycantassign'] = 'Por predefinição, é necessário ter a permissão \'moodle/role:assign\' para os utilizadores poderem assumir outros papéis. Ativar esta opção, remove essa restrição, fazendo com que os papéis disponíveis na lista pendente "Assumir o papel de..." sejam determinados pelas configurações no separador "Permitir atribuição de papéis". Recomenda-se que as definições em "Permitir atribuição de papéis" não permitam aos utilizadores assumir um papel com mais permissões do que o seu papel atual.';
$string['configallowuserthemes'] = 'Se ativar esta opção, os utilizadores poderão escolher os seus próprios temas. Os temas do utilizador prevalecem sobre os temas definidos para o site (mas não sobre os temas da disciplina).';
$string['configallowview'] = 'Para cada papel na coluna da esquerda, selecione quais os papéis que podem ver, procurar e filtrar por.';
$string['configallusersaresitestudents'] = 'Todos os utilizadores devem ser considerados alunos nas atividades da página principal? Se a resposta for "Sim", então qualquer utilizador autenticado poderá participar como aluno nessas atividades. Se a resposta for "Não", então apenas os utilizadores já inscritos em pelo menos uma disciplina poderão tomar parte nestas atividades. Apenas os administradores e professores designados explicitamente poderão participar nestas atividades como professores.';
$string['configauthenticationplugins'] = 'Escolha os módulos de autenticação que pretende usar e ordene-os pela ordem que estes serão usados até encontrar um que autentique o utilizador com sucesso.';
$string['configautolang'] = 'Deteção automática do idioma com base na configuração do navegador. Se esta opção estiver desativada será usado o idioma predefinido do site.';
$string['configautolangusercreation'] = 'Se ativar esta opção, quando for criada automaticamente a conta de um utilizador no primeiro acesso/autenticação (por exemplo, usando a autenticação LDAP ou OAuth 2), o idioma do navegador do utilizador é utilizado para definir o seu idioma preferido. Caso contrário, o idioma predefinido do site será o escolhido como sendo o idioma preferido do utilizador.';
$string['configautologinguests'] = 'Se ativar esta opção, os utilizadores não autenticados que acedam a disciplinas que permitem acesso a visitantes serão automaticamente autenticados como tal.';
$string['configbloglevel'] = 'Esta opção permite restringir o âmbito no qual os blogues dos utilizadores poderão ser visualizados neste site. Tenha em atenção que está a especificar o contexto máximo do VISUALIZADOR, não quem publicou, ou o tipo de publicação no blogue. Os blogues também poderão ser desativados completamente se não os quiser de todo.';
$string['configcalendarcustomexport'] = 'Ativar personalização do intervalo de datas de exportação do calendário';
$string['configcalendarexportsalt'] = 'Este texto aleatório é utilizado para a melhoria da segurança na exportação do calendário. Tenha em atenção que todos os tokens atuais serão invalidados se alterar este salt.';
$string['configcookiesecure'] = 'Se o servidor apenas usa ligações HTTPS, recomenda-se a utilização de cookies seguros. Ao ativar, verifique que o servidor não está a aceitar pedidos http:// ou configure o redirecionamento permanente para endereços https:// e de preferência envie cabeçalhos HSTS. Quando o endereço <em>wwwroot</em> não começa por https:// esta configuração é ignorada.';
$string['configcountry'] = 'Se selecionar um país, este será predefinido na criação de novas contas de utilizador. Para forçar os utilizadores a selecionar o país, deixe este campo em branco.';
$string['configcoursegraceperiodafter'] = 'Classificar as disciplinas do \'Histórico\' como \'A decorrer\' durante este número de dias após a data de fim da disciplina.';
$string['configcoursegraceperiodbefore'] = 'Classificar as disciplinas \'Por iniciar\' como \'A decorrer\' durante este número de dias antes da data de início da disciplina.';
$string['configcourseoverviewfilesext'] = 'Lista das extensões permitidas, separadas por vírgulas, para os ficheiros de imagem da disciplina.';
$string['configcourseoverviewfileslimit'] = 'Número máximo de ficheiros que podem ser mostrados junto da descrição da disciplina, na página da lista de disciplinas. O primeiro ficheiro de imagem adicionado é usado como a imagem da disciplina no bloco \'Minhas disciplinas\' no Painel do utilizador. Quaisquer ficheiros adicionais serão mostrados apenas na página da lista de disciplinas.';
$string['configcourserequestnotify'] = 'Escreva o nome de utilizador do utilizador que deve ser notificado quando uma nova disciplina for pedida.';
$string['configcourserequestnotify2'] = 'Utilizadores que são notificados aquando de um pedido de disciplina. Apenas aparecem nesta lista os utilizadores que podem aprovar a criação de disciplinas.';
$string['configcoursesperpage'] = 'Insira o número de disciplinas a mostrar por página na listagem de disciplinas.';
$string['configcourseswithsummarieslimit'] = 'Número máximo de disciplinas numa lista de disciplinas com inclusão da respetiva descrição. A partir deste número será exibida uma lista simples, sem descrições.';
$string['configcronclionly'] = 'Executar o cron através do navegador web pode expor informação importante a utilizadores anónimos. Por isso, recomenda-se a execução do cron apenas a partir da linha de comandos ou a definição de uma senha do cron para acesso remoto.';
$string['configcronremotepassword'] = 'Isto significa que o script cron.php só pode ser executado a partir de um navegador web se for indicada a senha usando a seguinte forma <pre>https://site.example.com/admin/cron.php?password=opensesame</pre>Nota: Se este campo ficar em branco não é necessário indicar a senha.';
$string['configcurlcache'] = 'Time-to-live da cache do cURL (em segundos).';
$string['configcustommenuitems'] = 'Pode configurar um menu personalizado aqui. Cada linha consiste num texto de menu, numa hiperligação de URL (opcional), num título de ajuda (opcional) e num código linguístico ou lista de códigos separados por vírgula (opcional, para exibir a linha apenas aos utilizadores do idioma especificado), separados pelo caráter \'|\'. As linhas que começam com um hífen vão aparecer como itens de menu no menu de nível superior anterior e ### resultará como um separador. Exemplo:
<pre>
Disciplinas
-Todas as disciplinas|/course/
-Pesquisar disciplina|/course/search.php
-###
-FAQ|https://example.org/faq
-Perguntas mais frequentes|https://example.org/pmf||pt
Mobile app|https://example.org/app|Descarregar a aplicação
</pre>';
$string['configcustomusermenuitems'] = 'Pode configurar os conteúdos do menu do utilizador (exceto a hiperligação de terminar sessão, que é automaticamente adicionada). Cada linha consiste em 1) um identificador de string no formato "langstringname, componentname" ou em texto simples, 2) um URL. Os elementos de cada linha são separados pelo caráter \'|\'. Podem ser usados separadores adicionando uma linha com um ou mais caracteres # onde desejado.';
$string['configdbsessions'] = 'Se ativar esta opção, a base de dados será usada para guardar a informação sobre as sessões abertas. Tenha em atenção que alterando esta definição irá encerrar todas as sessões de todos os utilizadores (incluindo a sua). Se estiver a utilizar MySQL, certifique-se de que o parâmetro "max_allowed_packet" em my.cnf (ou my.ini) é 4M ou maior. Outros parâmetros podem ser configurados diretamente em config.php. Consulte \'config-dist.php\' para mais informações. Esta opção não estará disponível se especificar "session driver" no ficheiro config.php.';
$string['configdebug'] = 'Se ativar esta opção, o nível de \'error_reporting\' do PHP é aumentado, fazendo com que mais avisos sejam apresentados. Apenas tem utilidade para programadores.';
$string['configdebugdisplay'] = 'Se ativar esta opção, as mensagens de erro serão mostradas no HTML. Isto é prático, mas quebra os "HTTP Headers", "JavaScript", "cookies" e "XHTML". Se desativar esta opção, as mensagens de erro serão registadas nos logs do servidor, permitindo uma melhor análise dos erros. A variável "error_log" do PHP controla para que log vai esta informação.';
$string['configdebugpageinfo'] = 'Se ativar esta opção, será mostrada informação da página no rodapé.';
$string['configdebugvalidators'] = 'Ative esta configuração se pretender incluir hiperligações para servidores externos de validação no rodapé da página. Pode ser necessário criar uma nova conta de utilizador com o nome de utilizador <strong>w3cvalidator</strong> e disponibilizar o acesso a visitantes. Estas configurações podem permitir acessos não autorizados ao servidor, pelo que não deve ser ativada em sites em produção!';
$string['configdefaulthomepage'] = 'Para qual página os utilizadores devem ser redirecionados após autenticação no site? A configuração também determina a primeira hiperligação na navegação para utilizadores de temas baseados no tema Clássico.';
$string['configdefaultrequestcategory'] = 'As disciplinas pedidas pelos utilizadores com permissão para fazerem pedidos de novas disciplinas no contexto do sistema serão colocadas nesta categoria a menos que os utilizadores possam selecionar uma categoria diferente.';
$string['configdefaultrequestedcategory'] = 'Categoria por predefinição para colocar as disciplinas pedidas, se forem aprovadas.';
$string['configdefaultuserroleid'] = 'Todos os utilizadores autenticados terão as permissões do papel aqui indicado no contexto do site, para além de quaisquer outros papéis que estejam atribuidos a esse utilizador. O valor predefinido desta opção é "Utilizador autenticado". Tenha em atenção que este papel não colide com outros papéis que os utilizadores tenham, simplesmente garante que todos os utilizadores têm permissões que não são atribuíveis ao nível da disciplina (por exemplo, inserir entradas no blogue, gerir o próprio calendário, etc.).';
$string['configdeleteincompleteusers'] = 'Depois deste período, qualquer conta sem o Nome, Apelido ou campo de e-mail preenchido é apagada.';
$string['configdeleteunconfirmed'] = 'Para alguns métodos de autenticação, tal como o autorregisto com autenticação por e-mail, os utilizadores devem confirmar a sua conta dentro de um determinado intervalo de tempo. Depois deste período, as contas antigas não confirmadas serão apagadas automaticamente.';
$string['configdenyemailaddresses'] = 'Para recusar endereços de e-mail de determinados domínios, indique aqui a lista dos mesmos, separados por espaços. Exemplo: <strong>hotmail.com yahoo.co.uk</strong>. Todos os outros domínios serão aceites. Para recusar subdomínios, indique o domínio precedido de um ponto, por exemplo, <strong>.live.com</strong>.';
$string['configdisableuserimages'] = 'Se ativar esta opção, os utilizadores não poderão alterar a sua foto no perfil do utilizador.';
$string['configdisplayloginfailures'] = 'Se ativar esta opção, será exibida informação aos utilizadores sobre as tentativas de autenticação falhadas anteriormente.';
$string['configdndallowtextandlinks'] = 'Se ativar esta opção, será permitido arrastar e largar texto e hiperligações, em simultâneo com a possibilidade de arrastar e largar ficheiros, para uma página de disciplina. Tenha em atenção que arrastar texto para o Firefox, ou entre diferentes navegadores, não é fiável, podendo acontecer que nenhuma informação seja carregada ou o texto carregado fique corrompido.';
$string['configdoclang'] = 'Idioma que será usado nas hiperligações para as páginas de documentação.';
$string['configdocroot'] = 'Define o caminho para a documentação do Moodle com informação específica do contexto através da hiperligação "Documentação para esta página" no rodapé de cada página. Se o campo ficar em branco, as hiperligações não serão exibidas.';
$string['configdoctonewwindow'] = 'Se ativar esta opção, as hiperligações para a documentação do Moodle serão mostradas numa nova janela.';
$string['configduration_high'] = 'Este valor é muito alto. O valor máximo é {$a}.';
$string['configduration_low'] = 'Este valor é muito baixo. O valor mínimo é {$a}.';
$string['configeditordictionary'] = 'Esta opção será usada se o aspell não tiver dicionário para a linguagem do utilizador.';
$string['configeditorfontlist'] = 'Selecione os tipos de letra que deverão aparecer na lista de tipos de letra do editor.';
$string['configemailchangeconfirmation'] = 'Se ativar esta opção, os utilizadores receberão um e-mail para confirmação quando alterarem o seu e-mail no perfil.';
$string['configemaildkimselector'] = 'O seletor DKIM é arbitrário e os seus registos DNS devem corresponder a ele.';
$string['configemailfromvia'] = 'Adicionar informações na secção "De" do envio de e-mails. Informa o destinatário da origem do e-mail e ajuda também a evitar que os destinatários respondam acidentalmente a endereços de e-mail \'Não responder\' (no-reply).';
$string['configemailheaders'] = 'Cabeçalhos de e-mail não formatados a serem adicionados literalmente a todos os e-mails a serem enviados.';
$string['configemailsubjectprefix'] = 'Texto a ser usado como prefixo do assunto de todos os e-mails a serem enviados.';
$string['configenableanalytics'] = 'Modelos de análise, tais como, \'Alunos em risco de desistir\' ou \'Atividades a terminar brevemente\', podem gerar previsões, enviar notificações de perceções e outras ações adicionais, como por exemplo, enviar mensagens aos utilizadores.';
$string['configenableblogs'] = 'Se ativar esta opção, será disponibilizado a todos os utilizadores do site o seu próprio blogue.';
$string['configenablecalendarexport'] = 'Ativa a possibilidade de exportação ou subscrição de calendários.';
$string['configenablecomments'] = 'Se ativar esta opção, os comentários estarão ativados.';
$string['configenablecourserequests'] = 'Se ativar esta opção, os utilizadores com permissão para fazerem pedidos de novas disciplina (moodle/course:request) terão a opção de solicitar uma disciplina. Esta permissão não é permitida para qualquer um dos papéis predefinidos. Pode ser usada no contexto do sistema ou da categoria.';
$string['configenablemobilewebservice'] = 'Os web services para dispositivos móveis são necessários para a aplicação Moodle. Se o seu website utilizar HTTPS, os web services para dispositivos móveis estão ativados por defeito. Para mais informações, consulte {$a}.';
$string['configenablerssfeeds'] = 'Se ativar esta opção, as listas RSS serão geradas a partir de várias funcionalidades do site (tais como blogues, fóruns, bases de dados e glossários). Tenha em atenção que deverá ativar as listas RSS nas configurações das respetivas atividades.';
$string['configenablerssfeedsdisabled'] = 'Não está disponível porque as listas RSS estão desativadas ao nível do site. Podem ser ativadas em Administração do Site / Funcionalidades avançadas / Ativar listas RSS.';
$string['configenablerssfeedsdisabled2'] = 'As listas RSS estão desativadas ao nível do site. Podem ser ativadas em Administração do Site / Funcionalidades avançadas / Ativar listas RSS.';
$string['configenablestats'] = 'Se ativar esta opção, o script \'cron.php\' do Moodle irá processar os registos de atividade e calcular algumas estatísticas. Dependendo do volume de tráfego do site, esta operação pode demorar muito tempo. Se ativada, poderá ver alguns gráficos e estatísticas em cada disciplina e para todo o site.';
$string['configenabletrusttext'] = 'O Moodle efetua normalmente uma limpeza minuciosa dos conteúdos enviados pelos utilizadores para eliminar scripts maliciosos, spam, etc. que possam colocar o site em risco. A ativação desta configuração permite a alguns utilizadores de confiança incluir este tipo de conteúdo sem restrições. Para ativar esta funcionalidade, depois de ativar esta opção é necessário ativar a permissão "Conteúdo fiável" num papel específico do Moodle. O texto criado ou enviado por esses utilizadores será identificado como fiável e não será submetido ao processo de limpeza.';
$string['configenablewebservices'] = 'Os web services permitem que outros sistemas, como por exemplo, a aplicação móvel Moodle, possam autenticar-se no site e realizar operações. Para uma segurança extra, esta configuração deve ser desativada se não estiver a usar a aplicação ou uma ferramenta/serviço externo que exija integração por meio de web services.';
$string['configenablewsdocumentation'] = 'Ativar a geração automática de documentação dos web services. Um utilizador pode aceder à documentação na sua página de chaves de segurança ({$a}). Apenas é mostrada a documentação para os protocolos que estiverem ativos.';
$string['configerrorlevel'] = 'Escolha a quantidade de avisos PHP que pretende que sejam mostrados. Normal é geralmente a melhor escolha.';
$string['configexportlookahead'] = 'Dias subsequentes a incluir na exportação';
$string['configexportlookback'] = 'Número de dias antecedentes a abranger durante a exportação';
$string['configextendedusernamechars'] = 'Se ativar esta opção, os utilizadores poderão utilizar quaisquer caracteres nos seus nomes de utilizador exceto letras maiúsculas. Caso contrário, apenas serão permitidos caracteres alfanuméricos em minúsculas, underscore (_), hífen (-), ponto (.) e o símbolo arroba (@).';
$string['configextramemorylimit'] = 'Alguns scripts como pesquisas, cópias de segurança, restauro ou a tarefa cron requerem mais memória. Defina valores mais elevados para grandes sites.';
$string['configfilterall'] = 'Se ativar esta opção, todos os textos serão filtrados, incluindo cabeçalhos, títulos, barra de navegação e outros. É muito útil quando se utiliza o filtro multilingue, caso contrário apenas criará carga extra no seu site com vantagens pouco significativas.';
$string['configfiltermatchoneperpage'] = 'Se ativar esta opção, os filtros geradores de hiperligações automáticas apenas gerarão uma hiperligação na primeira ocorrência de um texto encontrado na página. Todas as restantes ocorrências na mesma página serão ignoradas.';
$string['configfiltermatchonepertext'] = 'Se ativar esta opção, os filtros geradores de hiperligações automáticas apenas gerarão uma hiperligação na primeira ocorrência de um texto encontrado em cada item de texto na página. Todas as restantes ocorrências do mesmo item serão ignoradas. Esta opção não tem efeito se \'<strong>Filtrar um por página</strong>\' está ativada.';
$string['configfilternavigationwithsystemcontext'] = 'O uso normal do filtro está vinculado ao contexto em que é usado (por exemplo, contexto da disciplina), mas para a navegação no site, filtrar explicitamente tudo com o contexto do site pode gerar melhorias de desempenho ao usar o filtro para "conteúdo e cabeçalhos".';
$string['configfilteruploadedfiles'] = 'Indique se pretende que o conteúdo dos ficheiros HTML e de texto, apenas dos ficheiros HTML ou de nenhum ficheiro objeto de carregamento, sejam objeto de processamento pelos filtros.';
$string['configforcelogin'] = 'Normalmente a página principal e a lista de disciplinas (não as disciplinas em si) podem ser vistas por utilizadores não autenticados. A ativação desta configuração obriga todos os utilizadores a iniciarem uma sessão antes de poderem consultar qualquer informação no site.';
$string['configforceloginforprofiles'] = 'Se ativar esta configuração apenas os utilizadores autenticados poderão consultar os perfis de outros utilizadores. Caso desative esta configuração, poderá encontrar mensagens de spam ou outro conteúdo impróprio publicado por alguns utilizadores nos seus perfis, que estará visível para todos os utilizadores.';
$string['configfrontpage'] = 'Os itens selecionados acima serão exibidos na página principal do site.';
$string['configfrontpagecourselimit'] = 'Número máximo de disciplinas';
$string['configfrontpagecourselimithelp'] = 'Número máximo de disciplinas a serem exibidas nas listas de disciplinas na página principal.';
$string['configfrontpageloggedin'] = 'Os itens selecionados acima serão exibidos na página principal do site quando o utilizador está autenticado.';
$string['configfullnamedisplay'] = 'Define como são mostrados os nomes completos, que na generalidade dos sites o formato mais comum é "nome + apelido". No entanto, é possível ocultar, ou mostrar, o apelido de acordo com o critério definido no pacote linguístico do idioma que estiver a ser usado (alguns idiomas têm convenções diferentes).

Para a maioria dos sites com apenas um idioma instalado, a configuração mais eficiente é "firstname lastname" ("nome apelido"), mas pode optar por ocultar completamente os apelidos.

Podem ser usados os seguintes espaços reservados: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename e alternatename.';
$string['configgeoipfile'] = 'Localização do ficheiro binário de dados do GeoLite2 City. Este ficheiro não faz parte da distribuição do Moodle e deverá ser obtido separadamente em <a href="https://www.maxmind.com/">MaxMind</a>. Pode comprar uma versão comercial ou utilizar a versão gratuita. Tem de se registar para descarregar o ficheiro da base de dados a partir de <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Depois de registar-se e descarregar o ficheiro, extraia-o para a pasta "{$a}" do seu servidor.';
$string['configgetremoteaddrconf'] = 'Se o acesso ao Moodle for feito através de um <em>Reverse Proxy</em> é possível especificar neste campo que cabeçalhos HTTP são mais fiávies para obter o endereço IP externo. Os cabeçalhos são lidos por ordem sendo usado o primeiro que se encontrar disponível.';
$string['configgradebookroles'] = 'Esta opção permite controlar quem aparece na pauta. Só constarão na pauta duma disciplina os utilizadores com pelo menos um destes papéis nessa disciplina.';
$string['configgradeexport'] = 'Selecione os formatos principais que usa para exportar as notas da pauta. Os módulos selecionados configurarão e usarão o campo "Última exportação" associado a cada nota. Por exemplo, isto poderá fazer com que os registos exportados sejam identificados como "novos" ou "atualizados". Se não tiver a certeza sobre como configurar esta opção, não selecione qualquer formato.';
$string['configgradeexportdefault'] = 'Selecione qual o seu formato predefinido para exportar as notas.';
$string['confighiddenuserfields'] = 'Selecione os campos de informação do utilizador que pretende ocultar dos outros utilizadores, que não os professores e administradores. Isto aumentará a privacidade dos alunos. No Windows, mantenha a tecla Ctrl pressionada para selecionar vários campos.';
$string['configidnumber'] = 'Esta opção especifica se: (a) não é pedido aos utilizadores um número de identificação (ID), (b) é pedido um número de identificação (ID) aos utilizadores mas este pode ser deixado em branco, ou (c) é pedido um número de identificação (ID) aos utilizadores e este não pode ficar em branco. Se for fornecido, o número de identificação (ID) do utilizador será mostrado no seu perfil.';
$string['configintro'] = 'Nesta página pode configurar as variáveis relacionadas com o correto funcionamento do Moodle no seu servidor. Não se preocupe muito com esta página - em geral, os valores por predefinição funcionam bem e poderá sempre voltar a esta página e mudar as configurações.';
$string['configintroadmin'] = 'Nesta página deve configurar a sua conta de Administrador principal a qual terá um controlo absoluto de todo o site. Não se esqueça de indicar um nome de utilizador e senha seguros, bem como um endereço e-mail válido. Posteriormente poderá criar mais contas de Administrador.';
$string['configintrosite'] = 'Nesta página pode configurar a página principal e o nome do seu site. Poderá voltar a esta página e alterar as configurações através do menu da Administração do Site.';
$string['configiplookup'] = 'Quando clica num endereço IP (por exemplo, 34.12.222.93), designadamente na página de registos de atividade, é apresentado um mapa com a localização mais provável desse IP. Pode selecionar entre diferentes módulos para este efeito, cada um com as suas vantagens e desvantagens.';
$string['configkeeptagnamecase'] = 'Se ativar esta opção, as palavras-chave do site manterão a mesma combinação de maiúsculas e minúsculas com que foram inseridas pelos utilizadores que as criaram.';
$string['configlang'] = 'Selecione o idioma predefinido a utilizar em todo o site. Os utilizadores poderão redefinir esta configuração selecionando outro idioma no menu de idiomas ou no seu perfil do utilizador.';
$string['configlanglist'] = 'Se deixar em branco, serão mostrados no menu de idiomas todos os pacotes linguísticos instalados no site e os utilizadores poderão selecionar qualquer um dos idiomas instalados. Contudo, é possível reduzir o número de idiomas no menu se for indicada uma lista de códigos dos idiomas a apresentar, separados por vírgulas. Exemplo: pt,pt_br,en,es,fr,it. Se pretender, pode especificar um nome do idioma diferente do nome do pacote linguístico, usando o formato: código do idioma|nome do idioma, por exemplo, en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Esta opção permite definir se o menu de idiomas será exibido, ou não, na página principal, página de autenticação, etc. Os utilizadores continuarão a poder definir nos seus perfis qual o idioma que pretendem utilizar.';
$string['configlangstringcache'] = 'Se ativar esta opção, serão guardadas em cache todas as traduções a utilizar no Moodle (em ficheiros compilados, na pasta dos dados), melhorando o desempenho do sistema. Esta opção deve ser desativada durante processos de alteração das traduções, para que estas se tornem visíveis de forma imediata.';
$string['configlatinexcelexport'] = 'Codificação a utilizar nas exportações para formato Excel.';
$string['configlocale'] = 'Esta configuração define o "locale" do site. Esta configuração afeta o formato e a tradução das datas mostradas para qualquer idioma (os nomes dos dias no calendário não são afetados). O "locale" inserido tem que estar previamente instalado no sistema operativo (por exemplo, en_US.UTF-8 ou es_ES.UTF-8 para Linux). Normalmente esta opção não deve ser preenchida.';
$string['configlockrequestcategory'] = 'Se ativar esta opção, os utilizadores com permissão para fazerem pedidos de novas disciplinas no contexto do sistema não poderão selecionar uma categoria no formulário do pedido de nova disciplina. Uma alternativa para restringir os utilizadores de solicitarem uma nova disciplina em apenas uma categoria é aplicar a permissão de solicitar novas disciplinas no contexto da categoria.';
$string['configloglifetime'] = 'Período de tempo durante o qual devem ser mantidos os registos de atividade dos utilizadores. Os registos de atividade mais velhos do que este intervalo de tempo são automaticamente apagados. É útil manter os registos de atividade o maior tempo possível, caso necessite destes, mas se tem um servidor muito solicitado e estão a ocorrer problemas de performance, talvez deva reduzir o tempo de manutenção dos registos de atividade. Não se recomendam valores inferiores a 30 dias uma vez que podem comprometer o funcionamento correto das estatísticas.';
$string['configlookahead'] = 'Número de dias futuros a considerar';
$string['configmailnewline'] = 'Caracteres usados para iniciar uma nova linha nas mensagens de e-mail. De acordo com a norma RFC 822bis deve ser usado o CRLF. Alguns servidores de e-mail fazem automaticamente a conversão de LF para CRLF, mas outros fazem a conversão incorreta de CRLF para CRCRLF, e outros rejeitam os e-mails apenas com LF (por exemplo, qmail). Tente alterar esta configuração se estiver com problemas na recepção dos e-mails pelos utilizadores ou mudanças duplas de linha.';
$string['configmaxbytes'] = 'Tamanho máximo para o carregamento de ficheiros no site. O valor indicado nesta configuração está limitado externamente pelos valores dos parâmetros <strong>post_max_size</strong> e <strong>upload_max_filesize</strong> do PHP, bem como pela definição <strong>LimitRequestBody</strong> do Apache. Esta opção limita o intervalo de tamanhos que poderão ser selecionados ao nível das disciplinas e dos módulos. Se selecionar o valor "Limite de carregamento no contexto Site" será considerado o tamanho máximo permitido pelo servidor.';
$string['configmaxconsecutiveidentchars'] = 'As senhas não podem conter mais do que este número de caracteres iguais consecutivos. Defina o valor \'0\' (zero) para desativar esta verificação.';
$string['configmaxeditingtime'] = 'Intervalo de tempo que os utilizadores têm para editar as mensagens que inserem nos fóruns, comentários dos glossários, etc. depois da sua submissão.';
$string['configmaxevents'] = 'Eventos futuros a mostrar';
$string['configmaxusersperpage'] = 'Número máximo de utilizadores a serem mostrados no seletor de utilizadores no âmbito da disciplina, grupo, Grupo global, web service, etc.';
$string['configmessaging'] = 'Se ativar esta opção, os utilizadores podem enviar mensagens para outros utilizadores no site.';
$string['configmessagingallowemailoverride'] = 'Se ativar esta opção, será permitido que os utilizadores possam especificar um e-mail diferente do definido nos seus perfis para efeitos de envio das notificações por e-mail.';
$string['configmessagingallusers'] = 'Se ativar esta opção, ao selecionar o destinatário da mensagem, os utilizadores podem visualizar a lista de todos os utilizadores no site, se as suas preferências de mensagem incluírem a opção de aceitar mensagens de qualquer utilizador do site. Se desativar a opção, os utilizadores só poderão visualizar a lista de utilizadores das suas disciplinas, e eles terão apenas duas opções nas preferências de mensagem - para aceitar mensagens apenas dos  seus contactos ou dos seus contactos e de qualquer utilizador que esteja inscrito nas suas disciplinas.';
$string['configmessagingdefaultpressenter'] = 'Se ativar esta opção, \'Enter para enviar\' estará ativado por predefinição nas configurações das mensagens dos utilizadores.';
$string['configmessagingdeleteallnotificationsdelay'] = 'As notificações lidas e não lidas podem ser apagadas para libertar espaço. Depois de ser criada, após quanto tempo é que uma notificação pode ser apagada?';
$string['configmessagingdeletereadnotificationsdelay'] = 'As notificações lidas podem ser apagadas para poupar espaço. Após a leitura, quanto tempo depois é que as notificações podem ser apagadas?';
$string['configminpassworddigits'] = 'As senhas devem ter pelo menos este número de caracteres numéricos.';
$string['configminpasswordlength'] = 'As senhas devem ter pelo menos este número de caracteres.';
$string['configminpasswordlower'] = 'As senhas devem ter pelo menos este número de letras minúsculas.';
$string['configminpasswordnonalphanum'] = 'As senhas têm de ter pelo menos este número de caracteres não alfanuméricos.';
$string['configminpasswordupper'] = 'As senhas deverão ter pelo menos este número de letras maiúsculas.';
$string['configmypagelocked'] = 'Esta configuração impede que a página predefinida seja modificada por utilizadores que não sejam administradores';
$string['confignavcourselimit'] = 'Limita o número de disciplinas mostradas ao utilizador na navegação.';
$string['confignavshowallcourses'] = 'Esta configuração determina se os utilizadores que estão inscritos em disciplinas podem, ou não, ver a opção "Disciplinas" na navegação (lista de todas as disciplinas) para além da opção "As minhas disciplinas" (lista das disciplinas em que estão inscritos).';
$string['confignavshowcategories'] = 'Se ativar esta opção, as categorias das disciplinas serão mostradas na barra e blocos de navegação. Esta configuração não tem efeito nas disciplinas em que o utilizador está atualmente inscrito. Neste caso, as disciplinas continuarão a ser mostradas nas disciplinas do utilizador, sem categorias.';
$string['confignoreplyaddress'] = 'Por vezes, os e-mails são enviados em nome de um utilizador (por exemplo, as mensagens do fórum). O e-mail que inserir aqui será usado como o endereço do remetente nos casos em que os destinatários não devem responder diretamente ao utilizador (por exemplo, quando um utilizador opta por manter o seu endereço privado).';
$string['confignotifyloginfailures'] = 'Enviar mensagens de notificação de tentativas de autenticação falhadas para estes utilizadores selecionados. Requer que seja ativada uma logstore interna (por exemplo, Logstore padrão).';
$string['confignotifyloginthreshold'] = 'Se as notificações de tentativas de autenticação falhadas estiverem ativas, quantas tentativas sem sucesso por utilizador ou endereço IP deverão ocorrer para que seja enviada uma notificação?';
$string['confignotloggedinroleid'] = 'Os utilizadores não autenticados no site serão tratados como tendo as permissões deste papel, no contexto do site. Em geral deverá selecionar Visitante, mas em alguns casos poderá querer criar papéis mais ou menos restritivos. Algumas tarefas, como por exemplo, inserir mensagens em fóruns, continuam a necessitar que o utilizador se autentique no site.';
$string['configopentowebcrawlers'] = 'Se ativar esta opção, o motor de busca Google terá acesso às páginas do site como um utilizador com o papel "Visitante". Adicionalmente, qualquer pessoa que entre no seu site através de uma pesquisa Google entrará também como visitante. Tenha em atenção que a ativação desta configuração apenas disponibiliza o acesso a disciplinas que permitam o acesso a visitantes.';
$string['configoverride'] = 'Definido em config.php';
$string['configpasswordpolicy'] = 'Se ativar esta opção, as senhas dos utilizadores terão de cumprir a política de senhas especificada nas configurações abaixo. A ativação da política de senhas não afetará os utilizadores já existentes até que decidam ou precisem de alterar a senha ou a configuração \'Verificar senha ao autenticar\' está ativada.';
$string['configpasswordpolicycheckonlogin'] = 'Se ativar esta opção, as senhas dos utilizadores serão verificadas em relação à política de senha sempre que os utilizadores se autenticarem no site. Se a verificação falhar, o utilizador terá que alterar a sua senha antes de continuar.
É útil ativar esta configuração depois de atualizar a política de senha.';
$string['configpasswordresettime'] = 'Esta configuração especifica quanto tempo o utilizador tem para validar um pedido de reposição de senha antes que este expire. Normalmente, 30 minutos é um intervalo adequado.';
$string['configpathtodu'] = 'Caminho para o programa <strong>du</strong>. Provavelmente algo como \'/usr/bin/du\'. Se indicar um valor, as páginas que exibem conteúdos de pastas com muitos ficheiros irão ser processadas com maior rapidez.';
$string['configpathtophp'] = 'Caminho para a CLI do PHP. Provavelmente algo como \'/usr/bin/php\'. Se for indicado, os scripts cron podem ser executados a partir da interface web de administração.';
$string['configperfdebug'] = 'Se ativar esta opção, será mostrada informação sobre desempenho no rodapé do tema standard do Moodle.';
$string['configprofileroles'] = 'Lista de papéis que são mostrados na página de perfil do utilizador e na página dos participantes.';
$string['configprofilesforenrolledusersonly'] = 'Para impedir o uso indevido por spammers, as descrições dos perfis dos utilizadores que ainda não estão inscritos em nenhuma disciplina estão ocultas. Os novos utilizadores têm de inscrever-se em pelo menos uma disciplina, antes de poderem inserir uma descrição no perfil.';
$string['configprotectusernames'] = 'Se ativar esta opção, a página de recuperação da senha não mostrará qualquer pista que possibilite saber se o nome de utilizador ou o endereço de e-mail existem no site.';
$string['configproxybypass'] = 'Lista de nomes (parciais) de servidores ou IPs que devem contornar o proxy. Separe os itens por vírgulas, sem espaços. Por exemplo: 192.168.0.0/16,*.meudominio.com.';
$string['configproxyfixunsafe_help'] = 'Tenta corrigir as chamadas internas que não passam pelo proxy adicionando o MoodleBot User Agent e usando o proxy.';
$string['configproxyhost'] = 'Se este <strong>servidor</strong> precisar de usar um proxy (por exemplo, uma firewall) para aceder à Internet, coloque aqui o hostname do proxy. Caso contrário deixe em branco.';
$string['configproxylogunsafe_help'] = 'Tenta registar as chamadas internas que não passam pelo proxy mas que o deviam fazer.';
$string['configproxypassword'] = 'Senha necessária para aceder à Internet através do proxy, se necessária. Deixe em branco se não for necessária (requer a extensão cURL do PHP).';
$string['configproxyport'] = 'Se este servidor precisar de usar um proxy, escreva aqui a porta do proxy.';
$string['configproxytype'] = 'Tipo de web proxy (requer o PHP5 e a extensão cURL para suportar SOCKS5)';
$string['configproxyuser'] = 'Nome de utilizador necessário para aceder à Internet através do proxy, se necessário. Deixe em branco se não for necessário (requer a extensão cURL do PHP).';
$string['configrecaptchaprivatekey'] = 'Sequência de caracteres (Chave privada) utilizada na comunicação entre o servidor Moodle e o servidor reCAPTCHA. As chaves reCAPTCHA podem ser obtidas em <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Sequência de caracteres (Chave pública) utilizada para exibir o elemento reCAPTCHA no formulário de registo no formulário de suporte do site. As chaves reCAPTCHA podem ser obtidas em <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Designação do Aluno, a usar nas disciplinas pedidas';
$string['configrequestedstudentsname'] = 'Designação dos Alunos, a usar nas disciplinas pedidas';
$string['configrequestedteachername'] = 'Designação do Professor, a usar nas disciplinas pedidas';
$string['configrequestedteachersname'] = 'Designação dos Professores, a usar nas disciplinas pedidas';
$string['configreverseproxyignore'] = 'Se o servidor estiver atrás de diversos reverse proxies que anexam ao cabeçalho X-Forwarded-For, especifique uma lista separada por vírgulas dos endereços IP ou sub-redes dos reverse proxies a serem ignorados para encontrar o endereço IP correto dos utilizadores.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'E-mail';
$string['configsectionmaintenance'] = 'Manutenção';
$string['configsectionmisc'] = 'Diversos';
$string['configsectionoperatingsystem'] = 'Sistema operativo';
$string['configsectionpermissions'] = 'Permissões';
$string['configsectionrequestedcourse'] = 'Pedidos de disciplinas';
$string['configsectionsecurity'] = 'Segurança';
$string['configsectionstats'] = 'Estatísticas';
$string['configsectionuser'] = 'Utilizadores';
$string['configsecureforms'] = 'O Moodle pode utilizar um nível adicional de segurança no processamento de dados provenientes de formulários web. Se ativar esta opção, então a variável HTTP_REFERER do navegador é verificada se contém o endereço do formulário corrente. Por vezes esta opção pode causar problemas, por exemplo, se o utilizador usar uma firewall (Ex: Zonealarm) configurada para omitir o HTTP_REFERER do seu web. Os sintomas são ficar preso num formulário. Assim, se os seus utilizadores estiverem com problemas na página de autenticação, por exemplo, então poderá ter de desativar esta opção, embora o seu site fique mais permeável a ataques. Em caso de dúvida deixe esta opção ativa.';
$string['configservicespage'] = 'Indique o URL da página de \'Serviços e suporte\' ou deixe em branco para que os utilizadores sejam redirecionados para os serviços Moodle em moodle.com. A hiperligação é exibida apenas aos administradores do site.';
$string['configsessioncookie'] = 'Esta opção define o nome do cookie utilizado para registar sessões Moodle. É opcional e apenas é útil para evitar que se confundam os cookies quando está a correr mais do que uma cópia do Moodle no mesmo site.';
$string['configsessioncookiedomain'] = 'Esta configuração permite definir o domínio em que os cookies do Moodle estão disponíveis. Esta funcionalidade é útil em personalizações do Moodle (autenticação, inscrição por módulos, etc.)  em que é necessário partilhar informação da sessão Moodle com uma aplicação web noutro subdomínio. <strong> Atenção: Normalmente este campo deve ficar em branco. Um valor incorreto irá bloquear o acesso ao Moodle</strong>.';
$string['configsessioncookiepath'] = 'Se precisar de alterar o local para onde os navegadores enviam os cookies do Moodle, pode alterar esta configuração para especificar uma subpasta do seu site. Caso contrário, utilize o caminho predefinido \'/\'.';
$string['configsessiontimeout'] = 'Se um utilizador autenticado estiver sem atividade durante um longo tempo (sem abrir páginas), a sessão será terminada automaticamente após o intervalo de tempo aqui definido.';
$string['configsessiontimeoutwarning'] = 'Se os utilizadores autenticados neste site ficarem inativos por muito tempo (sem carregar páginas), serão avisados de que a sua sessão está prestes a terminar. Esta variável especifica o intervalo de tempo após o qual serão avisados.';
$string['configsessiontimeoutwarningcheck'] = 'O aviso de fim de sessão tem de ser menor que o tempo limite de sessão';
$string['configshowcommentscount'] = 'Exibe o número de comentários na hiperligação para visualizar os comentários. Tem como desvantagem a necessidade de uma consulta adicional à base de dados.';
$string['configshowicalsource'] = 'Exibir a origem da informação para os eventos do iCal';
$string['configshowsiteparticipantslist'] = 'Todos os alunos e professores do site serão listados na lista de participantes do site. Quem tem permissões para ver esta lista de participantes?';
$string['configsitedefaultlicense'] = 'Tipo de licença';
$string['configsitedefaultlicensehelp'] = 'Tipo de licença a aplicar aos conteúdos colocados no site.';
$string['configsitemailcharset'] = 'Esta configuração especifica o conjunto de caracteres predefinido para todos os e-mails enviados a partir do site.';
$string['configsitemaxcategorydepth'] = 'N.º de níveis de categorias a exibir';
$string['configsitemaxcategorydepthhelp'] = 'Esta configuração especifica o nível máximo das categorias que surgirão expandidas ao exibir a lista de categorias/disciplinas. As categorias de nível mais baixo serão exibidas como hiperligações, podendo o utilizador expandi-las, o que resultará num pedido AJAX.';
$string['configslasharguments'] = 'A utilização dos "slash arguments" (que utilizam <em>PATH_INFO</em>) é necessária para a correta visualização de pacotes SCORM e recursos com múltiplos ficheiros. Caso o seu navegador não suporte "slash arguments" e não consiga configurá-lo, poderá desativar este parâmetro mas pode causar falhas no funcionamento de algumas opções.<br />Nota: A utilização de "slash arguments" será necessária em futuras versões do Moodle.';
$string['configsmtpauthtype'] = 'Define o tipo de autenticação a utilizar no servidor SMTP.';
$string['configsmtphosts'] = 'Indique o nome completo de um ou mais servidores SMTP locais que o Moodle deve usar para enviar e-mails (ex: \'mail.a.com\' ou \'mail.a.com;mail.b.com\'). Para especificar uma porta não predefinida (isto é, outra além da porta 25), pode usar a sintaxe [server]:[port] (ex \'mail.a.com:587\'). Para ligações seguras, a porta 465 é normalmente usada com SSL e a porta 587 é usada com TLS. Se pretender, especifique abaixo um protocolo de segurança. Se este campo ficar em branco, o Moodle usará o método PHP padrão de envio de e-mail.';
$string['configsmtpmaxbulk'] = 'Número máximo de mensagens enviadas por sessão SMTP. Agrupar mensagens pode acelerar o envio de e-mails. Valores inferiores a 2 forçam a criação de uma nova sessão SMTP para cada e-mail.';
$string['configsmtpoauthservice'] = 'Selecione o serviço OAuth 2 que está configurado para comunicar com o servidor SMTP. Se o serviço ainda não existir, é necessário criá-lo. Tenha em atenção que é necessário configurar o tipo de autenticação SMTP para XOAUTH2.';
$string['configsmtpsecure'] = 'Se o servidor SMTP requerer uma ligação segura, especifique o tipo de protocolo correto.';
$string['configsmtpuser'] = 'Se acima especificou um servidor SMTP e o servidor requer autenticação, digite o nome de utilizador e a senha.';
$string['configstartwday'] = 'Primeiro dia da semana';
$string['configstatsfirstrun'] = 'Esta opção especifica qual a antiguidade dos registos de atividade que serão processados <strong>na primeira vez</strong> que o cron processar as estatísticas. Se tiver muito tráfego e usar um servidor partilhado, não é aconselhado o processamento de registos muito antigos, pois poderá demorar muito tempo e consome muitos recursos do servidor. (Tenha em atenção que para esta definição, 1 mês = 28 Dias. Nos gráficos e relatórios gerados, 1 mês = 1 mês do calendário)';
$string['configstatsmaxruntime'] = 'O processamento das estatísticas pode ser muito intensivo, por isso use uma combinação desta opção com a seguinte para especificar quando irá ter lugar e durante quanto tempo.';
$string['configstatsmaxruntime2'] = 'O processamento das estatísticas pode ser muito intensivo. Defina o tempo máximo permitido para o processamento das estatísticas de um dia. O número máximo de dias processados por cada execução do cron é de 31.';
$string['configstatsmaxruntime3'] = 'Tempo máximo permitido para calcular as estatísticas de um dia, tendo em conta que o processamento das estatísticas pode sobrecarregar o servidor. O número máximo de dias processados, em cada execução do cron, pode ser especificado abaixo.';
$string['configstatsruntimedays'] = 'Número máximo de dias processados em cada execução das estatísticas. Assim que as estatísticas estão atualizadas, apenas um dia será processado (ajuste este valor em função da capacidade do seu servidor, reduzindo-o se for necessário encurtar o tempo de execução do cron).';
$string['configstatsruntimestart'] = 'A que horas deverá iniciar o cronjob que executa o processamento das estatísticas? Especifique horas diferentes se existirem diversos sites Moodle alojados no mesmo servidor.';
$string['configstatsuserthreshold'] = 'Número mínimo de utilizadores inscritos que uma disciplina deve ter para seja incluída nas estatísticas.';
$string['configstrictformsrequired'] = 'Se ativar esta opção, os utilizadores são impedidos de inserir apenas um espaço ou quebra de linha nos campos obrigatórios dos formulários.';
$string['configstripalltitletags'] = 'Se desativar esta configuração as <em>tags</em> HTML existentes nos nomes das atividades e recursos das disciplinas deixarão de ser removidas.';
$string['configsupportavailability'] = 'Determina quem pode contactar o suporte do site a partir do rodapé.';
$string['configsupportemail'] = 'Se o SMTP estiver configurado neste site e não estiver configurada uma página de suporte, este endereço de e-mail receberá pedidos de ajuda enviados através do formulário de suporte. Se não for possível o envio, este endereço de e-mail será mostrado aos utilizadores autenticados.';
$string['configsupportname'] = 'Nome da pessoa ou outra entidade que oferece suporte através do formulário de suporte ou da página de suporte.';
$string['configsupportpage'] = 'Indique o URL da página de \'Serviços e suporte\' ou deixe em branco para que os utilizadores sejam redirecionados para o formulário de contacto. A hiperligação é exibida no rodapé do site.';
$string['configtempdatafoldercleanup'] = 'Apagar da pasta dos dados os ficheiros de dados temporários mais antigos que o intervalo de tempo selecionado.';
$string['configthemedesignermode'] = 'Normalmente as imagens e estilos dos temas são guardados em cache pelos navegadores e nos servidores durante um longo período por questões de desempenho. Se estiver a criar temas ou a desenvolver código provavelmente vai querer ativar esta configuração para evitar o armazenamento desta informação em cache. Aviso: Esta alteração tornará o site mais lento para todos os utilizadores! Em alternativa, pode esvaziar manualmente as caches de tema na página de seleção de temas.';
$string['configthemelist'] = 'Deixe em branco para permitir que qualquer tema válido seja utilizado. Se pretender encurtar o menu dos temas disponíveis, especifique aqui uma lista de nomes de temas separados por vírgulas (Não use espaços!). Exemplo: standard,orangewhite.';
$string['configtimezone'] = 'Fuso horário predefinido usado para mostrar datas - cada utilizador poderá alterar o seu fuso horário na configuração do seu perfil. As tarefas do cron e outras configurações do servidor são especificadas neste fuso horário. Caso surja a informação "Fuso horário inválido" deverá alterar a configuração';
$string['configuseblogassociations'] = 'Devem os utilizadores ter a possibilidade de organizar o seu blogue associando mensagens a disciplinas e módulos?';
$string['configusesitenameforsitepages'] = 'Se ativar esta opção, o nome curto do site será apresentado na barra de navegação com hiperligação para as Páginas do site, em vez do texto \'Páginas do site\'';
$string['configusetags'] = 'Se ativar esta opção, a funcionalidade palavras-chave estará ativa em todo o site.';
$string['configvariables'] = 'Variáveis';
$string['configverifychangedemail'] = 'Se ativar esta opção, será efetuada a verificação de endereços de e-mail quando os mesmos são alterados, tendo em conta as configurações dos domínios permitidos. Se desativada, as configurações dos domínios permitidos são consideradas apenas durante a criação de novos utilizadores.';
$string['configvisiblecourses'] = 'Mostrar normalmente as disciplinas de categorias ocultas.';
$string['configwarning'] = 'Tenha cuidado ao alterar estas configurações - valores estranhos poderão causar problemas.';
$string['configyuicomboloading'] = 'Estas opções permitem ativar a optimização do carregamento combinado de ficheiros das bibliotecas YUI. Esta configuração deve estar ativa em sites em produção, por questões de desempenho.';
$string['confirmation'] = 'Confirmação';
$string['confirmationpending'] = 'Confirmação pendente';
$string['confirmcontextlock'] = 'De momento "{$a->contextname}" está desbloqueado. O bloqueio fará com que passe a ser só de leitura e impedirá que os utilizadores façam alterações. Tem a certeza de que pretende continuar?';
$string['confirmcontextunlock'] = 'De momento "{$a->contextname}" está bloqueado. O desbloqueio permitirá aos utilizadores fazerem alterações. Tem a certeza de que pretende continuar?';
$string['confirmdeletecomments'] = 'Tem a certeza de que pretende apagar os comentários selecionados?';
$string['confirmed'] = 'Confirmado';
$string['contactsitesupport'] = 'Contactar suporte do site';
$string['contenttypeuninstalling'] = 'Existem {$a->count} conteúdos suportados por {$a->type}. Todos serão apagados. Tem a certeza de que pretende continuar?';
$string['contextlockappliestoadmin'] = 'Bloqueio de contextos aplica-se a administradores';
$string['contextlockappliestoadmin_desc'] = 'Se desativar esta opção, os administradores permanecem com acesso de escrita a qualquer contexto bloqueado.';
$string['contextlocking'] = 'Bloqueio de contextos';
$string['contextlocking_desc'] = 'Se ativar esta opção, será possível atribuir acesso "só de leitura" a categorias, disciplinas, atividades ou blocos selecionados.';
$string['cookiesecure'] = 'Utilizar apenas cookies seguros';
$string['country'] = 'País predefinido';
$string['course_customfield'] = 'Campos personalizados da disciplina';
$string['coursecolor'] = 'Cor {$a}';
$string['coursecolorheading_desc'] = 'Todas as disciplinas sem uma imagem de disciplina definida nas configurações da disciplina são exibidas na página Minhas disciplinas com um cartão de disciplina predefinido. As cores usadas nas predefinições podem ser especificadas abaixo.';
$string['coursecolorsettings'] = 'Cores do cartão das disciplinas';
$string['coursecontact'] = 'Titulares das disciplinas';
$string['coursecontact_desc'] = 'Esta configuração define quem aparece junto da descrição das disciplinas. Os utilizadores que tenham pelo menos um destes papéis nas disciplinas aparecerão junto das descrições das mesmas.';
$string['coursecontactduplicates'] = 'Mostrar todos os papéis de contacto da disciplina';
$string['coursecontactduplicates_desc'] = 'Se ativar esta opção, os utilizadores com mais do que um dos papéis de contacto da disciplina selecionada serão mostrados na descrição da disciplina com cada um dos seus papéis. Caso contrário, serão mostrados com apenas um papel (o que estiver listado mais alto em Administração do Site / Utilizadores / Permissões / Definir papéis).';
$string['coursecreationguide'] = 'URL do guia de criação de disciplinas Moodle';
$string['coursecreationguide_help'] = 'Define o caminho para o guia rápido com vídeos curtos e dicas gerais para criar disciplinas. Será mostrada uma hiperligação para o guia na página Minhas disciplinas quando não existirem disciplinas para mostrar. A hiperligação apenas estará visível para os utilizadores com a permissão para criar disciplinas.';
$string['coursegraceperiodafter'] = 'Tempo extra para disciplinas já terminadas';
$string['coursegraceperiodbefore'] = 'Tempo extra para disciplinas a iniciar';
$string['courselistshortnames'] = 'Mostrar nomes extensos das disciplinas';
$string['courselistshortnames_desc'] = 'Se ativar esta opção, o nome curto das disciplinas será exibido junto do nome completo na lista de disciplinas. Se necessário, estes nomes extensos das disciplinas podem ser personalizados através da edição da string \'courseextendednamedisplay\' utilizando a funcionalidade de personalização do pacote linguístico.';
$string['coursemgmt'] = 'Gerir disciplinas e categorias';
$string['courseoverview'] = 'Visão global da disciplina';
$string['courserequestnotify'] = 'Notificação de pedido de disciplina';
$string['courserequestnotifyemail'] = '{$a->user} pediu uma nova disciplina em <a href="{$a->link}">{$a->link}</a>.';
$string['courserequests'] = 'Disciplinas pedidas';
$string['courserequestspending'] = 'Disciplinas pedidas pendentes';
$string['courses'] = 'Disciplinas';
$string['coursesperpage'] = 'N.º de disciplinas mostradas por página';
$string['courseswithsummarieslimit'] = 'Número máximo de disciplinas com descrição';
$string['creatornewroleid'] = 'Papel a atribuir ao criador de disciplinas nas novas disciplinas';
$string['creatornewroleid_help'] = 'Se o utilizador ainda não tem permissão para gerir a nova disciplina, é-lhe atribuído automaticamente este papel.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Ativar o cron';
$string['cron_enabled_desc'] = 'Se ativar esta opção, o cron estará ativo, como normalmente deve estar. No entanto, esta configuração permite que seja temporariamente desativado, por exemplo, antes de reiniciar o servidor. Se desativar esta opção, o sistema é impedido de iniciar novas tarefas em segundo plano. Tenha em atenção que o cron não deve estar desativado por muito tempo, uma vez que impedirá o normal funcionamento de funcionalidades importantes.';
$string['cron_help'] = 'O script de manutenção \'cron.php\' realiza periodicamente um conjunto de tarefas necessárias, tais como o envio por e-mail de novas mensagens submetidas nos fóruns. Este script deve ser executado com regularidade - idealmente a cada minuto.';
$string['cron_keepalive'] = 'Manter ativo';
$string['cron_keepalive_desc'] = 'O intervalo de tempo para manter o carregamento de tarefas adicionais. Esta configuração é útil para garantir que o cron está sempre em execução. Se usar executores de tarefas dedicados, deve definir este valor como 0, caso contrário, defina um valor similar ao limite de simultaneidade de tarefas ad hoc . Valores mais longos devem ser evitados e o valor máximo é de 15 minutos.';
$string['cron_link'] = 'Link para executar o script cron';
$string['cronclionly'] = 'Limitar execução do cron à linha de comandos';
$string['cronerrorclionly'] = 'O acesso via Internet a esta página foi desativado pelo administrador.';
$string['cronerrorpassword'] = 'Não indicou uma senha válida para aceder a esta página';
$string['croninfrequent'] = 'Decorreram {$a->actual} entre as duas últimas execuções do script de manutenção \'cron.php\' e deve ser executado a cada {$a->expected}. Recomenda-se que altere as configurações de modo a que seja executado com maior frequência.';
$string['cronremotepassword'] = 'Senha do cron para acesso remoto';
$string['cronwarning'] = 'O script \'<a href="{$a->url}">admin/cron.php</a>\' não é executado há pelo menos {$a->actual} e deve ser executado a cada {$a->expected}.';
$string['cronwarningcli'] = 'O script \'<code>admin/cli/cron.php</code>\' não é executado há pelo menos {$a->actual} e deve ser executado a cada {$a->expected}.';
$string['cronwarningnever'] = 'O script \'<code>admin/cli/cron.php</code>\' nunca foi executado e deve ser executado a cada {$a->expected}.';
$string['cronwarningneverweb'] = 'O script \'<a href="{$a->url}">admin/cron.php</a>\' nunca foi executado e deve ser executado a cada {$a->expected}.';
$string['ctyperequired'] = 'A extensão ctype PHP é requerida pelo Moodle, a fim de melhorar o desempenho do site e para oferecer compatibilidade multilingue.';
$string['curlcache'] = 'TTL da cache do cURL';
$string['curlrequired'] = 'A instalação da extensão cURL do PHP é obrigatória para permitir ao Moodle comunicar com os repositórios.';
$string['curlsecurityallowedport'] = 'Lista de portas permitidas do cURL';
$string['curlsecurityallowedportsyntax'] = 'Lista dos números das portas que o cURL pode ligar-se. Apenas números inteiros são entradas válidas. Digite cada entrada numa nova linha. Se deixar em branco, todas as portas são permitidas. Se for definido, na maioria dos casos, tanto a porta 443 como a porta 80 devem ser especificadas para que o cURL ligue através das portas padrão de HTTP e HTTPS.';
$string['curlsecurityblockedhosts'] = 'Lista de servidores bloqueados do cURL';
$string['curlsecurityblockedhostssyntax'] = 'Digite cada entrada numa nova linha. As entradas válidas são endereços completos IPv4 ou IPv6 (tal como, 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) que correspondem a um único servidor, a um registo CIDR (tal como, 231.54.211.0/20 ou fe80::/64), a um intervalo de endereços IP (tal como, 231.3.56.10-20 ou fe80::1111-bbbb) em que o intervalo se aplica ao último grupo do endereço, a nomes de domínio (tal como, localhost ou exemplo.com) ou nomes de domínio com caracteres universais (tal como, *.exemplo.com ou *.sub.exemplo.com). Não são permitidas linhas em branco.';
$string['curlsecurityurlblocked'] = 'O URL está bloqueado.';
$string['curltimeoutkbitrate'] = 'Bitrate que deve ser usado no cálculo de timetouts do cURL (Kbps).';
$string['curltimeoutkbitrate_help'] = 'Esta configuração é usada para calcular um valor apropriado de timeout em pedidos cURL de grande dimensão. Neste cálculo é realizado um pedido HTTP HEAD para determinar a dimensão do conteúdo. Se definir o valor 0 (zero) nesta configuração este pedido HTTP HEAD não é realizado.';
$string['currenttheme'] = 'Tema atual';
$string['customcheck'] = 'Outras verificações';
$string['custommenu'] = 'Menu personalizado';
$string['custommenuitems'] = 'Elementos de menu personalizados';
$string['customusermenuitems'] = 'Itens do menu do utilizador';
$string['datarootsecurityerror'] = '<p><strong>AVISO DE SEGURANÇA!</strong></p><p>A sua pasta raiz de dados está numa localização errada e está exposta à web. Isto significa que todos os seus ficheiros privados estão disponíveis para qualquer pessoa e alguns deles podem ser usados por um hacker para obter acesso de administrador não autorizado ao seu site!</p><p><strong>Deve</strong> mover a pasta raiz de dados ({$a}) para um novo local que não esteja dentro da sua pasta pública da web e atualizar em conformidade a configuração <code>$CFG->dataroot</code> no ficheiro config.php.</p>';
$string['datarootsecuritywarning'] = 'A configuração do seu site pode não ser segura. <br />Certifique-se de que a pasta <br /><strong>{$a}</strong><br /> não é acessível através da Internet.';
$string['dbprefixtoolong'] = 'O prefixo da base de dados do seu site ($CFG->prefix) é muito longo ({$a->current} characters). O número máximo de caracteres permitido é {$a->maximum}.';
$string['dbsessions'] = 'Guardar a informação sobre sessões na base de dados';
$string['debug'] = 'Mensagens de erro';
$string['debugall'] = 'TODAS: Mostrar todas as mensagens de erro razoáveis do PHP';
$string['debugdeveloper'] = 'PROGRAMADOR: Mensagens de erro adicionais, para programadores';
$string['debugdisplay'] = 'Mostrar mensagens de erro';
$string['debugging'] = 'Erros';
$string['debugminimal'] = 'MÍNIMO: Mostrar apenas erros graves';
$string['debugnone'] = 'NADA: Não mostrar quaisquer erros ou advertências';
$string['debugnormal'] = 'NORMAL: Mostrar erros, advertências e avisos';
$string['debugpageinfo'] = 'Mostrar informação da página';
$string['debugsqltrace'] = 'Mostrar origem das chamadas SQL';
$string['debugsqltrace1'] = 'Mostrar apenas uma única linha de chamada';
$string['debugsqltrace100'] = 'Mostrar monitorização completa da pilha';
$string['debugsqltrace2'] = 'Mostrar 2 linhas da monitorização de pilha';
$string['debugsqltrace_desc'] = 'Se ativar esta opção, o stack trace parcial ou completo do PHP é adicionado ao SQL como um comentário.';
$string['debugstringids'] = 'Mostrar localização das traduções';
$string['debugstringids_desc'] = 'Se ativar esta opção, será mostrada a componente e identificador de cada string exibida se adicionar \'?strings=1\' ou \'&strings=1\' ao URL.';
$string['debugtemplateinfo'] = 'Mostrar informação do modelo';
$string['debugtemplateinfo_desc'] = 'Se ativar esta opção, os modelos usados para renderização são mostrados como comentários no HTML da página. Após alterar a configuração, tem de limpar as caches. Use apenas para depuração temporária, uma vez que produz erros de validação de HTML e pode quebrar alguns scripts da página.';
$string['debugvalidators'] = 'Mostrar hiperligações de validação';
$string['defaultcity'] = 'Cidade predefinida';
$string['defaultcity_help'] = 'A cidade aqui indicada será a cidade predefinida para as novas contas de utilizador que forem criadas.';
$string['defaultformatnotset'] = 'Erro ao determinar o formato predefinido da disciplina. Por favor, verifique as configurações do site.';
$string['defaulthomepage'] = 'Página inicial para os utilizadores';
$string['defaultrequestcategory'] = 'Categoria predefinida a atribuir às disciplinas pedidas';
$string['defaultsettinginfo'] = 'Valor predefinido: {$a}';
$string['defaultuserroleid'] = 'Papel predefinido de todos os utilizadores';
$string['deletedplugintypesdetected'] = 'Foi detetado um módulo apagado, \'{$a}\'. Deveria ter sido migrado/desinstalado durante o período de descontinuação. Neste momento é um tipo de módulo não suportado e a instalação/atualização não pode continuar até que este módulo seja desinstalado.';
$string['deleteduserx'] = 'Utilizador \'{$a}\' apagado';
$string['deleteincompleteusers'] = 'Apagar utilizadores incompletos após';
$string['deleteunconfirmed'] = 'Apagar utilizadores não confirmados após';
$string['deleteuser'] = 'Apagar utilizador';
$string['density'] = 'Densidade';
$string['denyemailaddresses'] = 'Domínios de e-mail rejeitados';
$string['development'] = 'Desenvolvimento';
$string['devicetype'] = 'Tipo de dispositivo';
$string['devlibdirpresent'] = 'As diretorias com bibliotecas de desenvolvimento, especialmente <em>/vendor</em> e <em>/node_modules</em>, não devem estar presentes em sites públicos. Consulte o <a href="{$a->moreinfourl}"> relatório da vista global de segurança</a> para mais detalhes.';
$string['disabled'] = 'Desativado';
$string['disableplugin'] = 'Desativar \'{$a}\'';
$string['disableuserimages'] = 'Desativar foto do perfil do utilizador';
$string['displayerrorswarning'] = 'Por questões de segurança a configuração <em>display_errors</em> do PHP (ficheiro php.ini) não deve estar ativa, pois pode ser revelada alguma informação sensível do servidor através das mensagens de erro.';
$string['displayloginfailures'] = 'Mostrar tentativas de autenticação falhadas';
$string['divertallemails'] = 'Desvio de e-mail';
$string['divertallemailsdetail'] = 'Usado como proteção em ambientes de desenvolvimento ao testar e-mails e não deve ser usado em sites em produção.';
$string['divertallemailsexcept'] = 'Exceções do desvio de e-mail';
$string['divertallemailsexcept_desc'] = 'Lista de regras de exceção de e-mail separadas por vírgulas ou em novas linhas. Cada regra é interpretada como uma expressão regular. Por exemplo, <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Desviar todos os e-mails';
$string['divertallemailsto_desc'] = 'Se configurado, todos os e-mails serão desviados para este único endereço de e-mail.';
$string['dndallowtextandlinks'] = 'Ativar arrastar e largar para carregar textos/hiperligações';
$string['doclang'] = 'Idioma a usar nas páginas de documentação';
$string['docroot'] = 'URL da documentação do Moodle';
$string['doctonewwindow'] = 'Abrir numa nova janela';
$string['doesnotfit'] = 'Configurações de privacidade do e-mail';
$string['doesnotfitdetail'] = 'Mostrar definições para os e-mails enviados pelo Moodle';
$string['download'] = 'Exportar para ficheiro';
$string['downloadcoursecontentallowed'] = 'Descarregamento do conteúdo da disciplina';
$string['downloadcoursecontentallowed_desc'] = 'Se ativar esta opção, a funcionalidade de descarregamento do conteúdo da disciplina estará disponível. Quando disponível, o descarregamento do conteúdo da disciplina pode ser ativado/desativado através da configuração "Ativar descarregamento do conteúdo da disciplina" no menu de edição da disciplina (o valor predefinido pode ser definido na <a href={$a} target="_blank">Configuração predefinida das disciplinas</a>).';
$string['durationunits'] = 'Unidades de duração';
$string['edithelpdocs'] = 'Editar documentos de ajuda';
$string['editlang'] = '<strong>Editar</strong>';
$string['editorbackgroundcolor'] = 'Cor de fundo';
$string['editordictionary'] = 'Dicionário do editor';
$string['editorfontfamily'] = 'Tipo de letra';
$string['editorfontlist'] = 'Lista de tipos de letra';
$string['editorfontsize'] = 'Tamanho do tipo de letra';
$string['editorhidebuttons'] = 'Botões ocultos';
$string['editorkillword'] = 'Ativar filtro do formato Word';
$string['editorspelling'] = 'Dicionário do Editor';
$string['editorspellinghelp'] = 'Ativa a correção automática. Para funcionar, o <strong>aspell</strong> deve estar instalado no servidor.';
$string['editstrings'] = 'Editar frases';
$string['emailchangeconfirmation'] = 'Ativar confirmação de mudança de e-mail';
$string['emaildkim'] = 'Assinatura DKIM (DomainKeys Identified Mail) de e-mail';
$string['emaildkiminfo'] = 'Se o seletor DKIM estiver definido e se for encontrado um ficheiro de certificado privado que corresponda ao domínio do endereço "De" dos e-mails em $CFG->dataroot/dkim/[domain]/[selector].private, o e-mail será assinado. Na maioria dos casos (por exemplo, se \'allowedemaildomains\' estiver em branco), apenas um único certificado é necessário em <pre>{$a->path}</pre>. Para mais detalhes de configuração, consulte a documentação da <a href="{$a->docs}">configuração do E-mail</a>.';
$string['emaildkimselector'] = 'Seletor DKIM';
$string['emailfromvia'] = 'Informações via e-mail';
$string['emailheaders'] = 'Cabeçalhos de e-mail';
$string['emailsubjectprefix'] = 'Texto do prefixo do assunto do e-mail';
$string['emoticonalt'] = 'Informação alternativa';
$string['emoticoncomponent'] = 'Componente';
$string['emoticonimagename'] = 'Nome da imagem';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Este formulário define os emoticons (smileys) usados no site. <br />Para voltar aos valores definidos originalmente pelo Moodle clique na hiperligação acima.<br />Para remover uma linha da tabela guarde o formulário com um valor em branco em qualquer dos campos obrigatórios da linha que pretende remover. <br />Para registar um novo emoticon preencha os campos na última linha em branco, de acordo com as seguintes regras: <br /><strong>Texto (obrigatório)</strong> - Este texto vai ser substituído com a imagem do emoticon. Tem de ter pelo menos dois caracteres.<br /><strong>Nome da imagem (obrigatório)</strong> - Nome do ficheiro da imagem do emoticon, sem extensão do ficheiro, relativamente à pasta dos componentes pix.<br /><strong>Componente (obrigatório)</strong> - Componente de imagem que fornece o ícone.<br /><strong>Texto alternativo (opcional)</strong> - Identificador do texto e componente do texto alternativo do emoticon.';
$string['emoticonsreset'] = 'Repor configurações predefinidas dos emoticons';
$string['emoticontext'] = 'Texto';
$string['emptysettingvalue'] = 'Em branco';
$string['enableanalytics'] = 'Analítica';
$string['enableblogs'] = 'Ativar blogues';
$string['enablecalendarexport'] = 'Ativar exportação do calendário';
$string['enablecomments'] = 'Ativar comentários';
$string['enablecommunicationsubsystem'] = 'Ativar fornecedores de comunicação';
$string['enablecommunicationsubsystem_desc'] = 'Permite a integração com fornecedores de comunicação como o Matrix para que professores e alunos possam comunicar com maior facilidade. Pode gerir estas integrações em <a href="settings.php?section=managecommunicationproviders">Módulos</a>.';
$string['enablecourserelativedates'] = 'Ativar datas relativas na disciplina';
$string['enablecourserelativedates_desc'] = 'Se ativar esta opção, será permitido que as disciplinas sejam configuradas para mostrar as datas relativas à data de início do utilizador na disciplina.';
$string['enablecourserequests'] = 'Ativar pedido de disciplinas';
$string['enabled'] = 'Ativado';
$string['enabledashboard'] = 'Ativar Painel do utilizador';
$string['enabledashboard_help'] = 'O Painel do utilizador mostra o cronograma, o calendário e os itens acedidos recentemente, por predefinição. Pode definir um diferente Painel do utilizador predefinido para todos e permitir que os utilizadores personalizem o seu próprio painel. Se desativado, tem de definir a \'Página inicial para os utilizadores\' com um valor diferente do Painel do utilizador.';
$string['enableglobalsearch'] = 'Ativar pesquisa global';
$string['enableglobalsearch_desc'] = 'Se ativar esta opção, os dados serão indexados e sincronizados por uma tarefa agendada.';
$string['enablegravatar'] = 'Ativar Gravatar';
$string['enablegravatar_help'] = 'Se ativar esta opção, o Moodle tentará obter uma imagem para o perfil do utilizador a partir da base de dados Gravatar (http://gravatar.com), caso o utilizador não tenha carregado nenhuma imagem.';
$string['enablemobilewebservice'] = 'Ativar web services para dispositivos móveis';
$string['enablepdfexportfont'] = 'Ativar tipos de letra dos PDF';
$string['enablepdfexportfont_desc'] = 'Se o seu site tiver disciplinas em diferentes idiomas que precisam de outros tipos de letra nos ficheiros PDF gerados, pode fornecer a opção de definir o tipo de letra nas configurações da disciplina. É necessário especificar os tipos de letra disponíveis em $CFG->pdfexportfont no ficheiro config.php.';
$string['enableplugin'] = 'Ativar \'{$a}\'';
$string['enablerecordcache'] = 'Ativar cache de registos';
$string['enablerssfeeds'] = 'Ativar listas RSS';
$string['enablesearchareas'] = 'Permitir áreas de pesquisa';
$string['enablesharingtomoodlenet'] = 'Ativar partilha no MoodleNet (saída)';
$string['enablesharingtomoodlenet_desc'] = 'Permitir que os utilizadores partilhem o conteúdo da disciplina numa instância configurada do MoodleNet, se tiverem permissão.';
$string['enablestats'] = 'Ativar estatísticas';
$string['enabletrusttext'] = 'Ativar Conteúdo fiável';
$string['enableuserfeedback'] = 'Ativar feedback acerca deste software';
$string['enableuserfeedback_desc'] = 'Se ativar esta opção, uma hiperligação \'Dar feedback acerca deste software\' é mostrada no rodapé para que os utilizadores possam  enviar comentários sobre o Moodle LMS para o Moodle HQ. Se a opção \'Lembrete de feedback\' estiver definida, o utilizador também receberá um lembrete no Painel do utilizador no intervalo especificado. Definir \'Lembrete de feedback\' como \'Nunca\' desativa o lembrete do Painel do utilizador mas a hiperligação \'Dar feedback acerca deste software\' permanece no rodapé.';
$string['enablewebservices'] = 'Ativar web services';
$string['enablewsdocumentation'] = 'Documentação dos web services';
$string['encryptedpassword_edit'] = 'Insira um novo valor';
$string['encryptedpassword_set'] = '(Definida e encriptada)';
$string['enroladminnewcourse'] = 'Inscrever automaticamente o administrador em novas disciplinas';
$string['enroladminnewcourse_help'] = 'Quando um administrador adiciona uma nova disciplina, deve ser automaticamente inscrito e atribuir-lhe o papel de criador em novas disciplinas?';
$string['enrolinstancedefaults'] = 'Valores predefinidos das utilizações de módulos de inscrição';
$string['enrolinstancedefaults_desc'] = 'Valores predefinidos das configurações de inscrições em novas disciplinas.';
$string['enrolmultipleusers'] = 'Inscrever os utilizadores';
$string['ensureauroraversion'] = 'O seu site está a ser executado com o motor de base de dados Amazon Aurora. A versão do MySQL no Amazon Aurora tem de ser compatível com a versão do Moodle que está a instalar ou a atualizar. Verifique a compatibilidade em <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html" target="_blank">Atualizações do motor de base de dados para o Amazon Aurora MySQL versão 3</a>.';
$string['entitytasklog'] = 'Registos das tarefas';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Tem de resolver todos os problemas de ambiente (erros) indicados acima antes de instalar esta versão do Moodle!';
$string['environmenterrorupgrade'] = 'Advertência: deve resolver todos os problemas de ambiente (erros) detetados, antes de atualizar para esta versão do Moodle! Continuar a atualização sem resolver estes problemas, poderá ter consequências, como por exemplo, a perda de dados. Tem a certeza de que pretende continuar com a atualização?';
$string['environmentmariadbwrongdbtype'] = '$CFG->dbtype incorreto. Tem de alterá-lo no ficheiro config.php de \'mysql\' para \'mariadb\'.';
$string['environmentmustfixsetting'] = 'A configuração do PHP tem de ser alterada.';
$string['environmentok'] = 'O seu servidor cumpre todos os requisitos mínimos.';
$string['environmentrecommendcustomcheck'] = 'se este teste falhar pode existir um problema';
$string['environmentrecommendinstall'] = 'deve estar instalada e ativa para melhores resultados';
$string['environmentrecommendversion'] = 'é recomendada a versão {$a->needed} e atualmente está a correr a versão {$a->current}';
$string['environmentrequirecustomcheck'] = 'Este teste tem de passar';
$string['environmentrequireinstall'] = 'tem de estar instalada e ativa';
$string['environmentrequireversion'] = 'é requerida a versão {$a->needed} e está a usar a versão {$a->current}';
$string['environmentsettingok'] = 'foi detetada uma configuração recomendada';
$string['environmentshouldfixcustomcheck'] = 'deve estar ativa para melhores resultados';
$string['environmentshouldfixsetting'] = 'A configuração do PHP deve ser alterada.';
$string['environmentxmlerror'] = 'Erros ao ler dados do ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Ocorreu um erro ao apagar os registos de configuração do módulo  \'{$a}\' .';
$string['errorsetting'] = 'Não foi possível guardar as configurações:';
$string['errorwithsettings'] = 'Algumas configurações não foram modificadas devido a um erro:';
$string['eventshandlersinuse'] = 'Os seguintes módulos no seu sistema utilizam manipuladores obsoletos da API Events 1: \'{$a}\'. Por favor, atualize-os para utilizar API Events 2. Consulte a página https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Todos com permissão \'{$a}\'';
$string['exceptions'] = 'exceções';
$string['execpathnotallowed'] = 'Definição de caminhos executáveis e locais desativada em config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Configurações experimentais';
$string['extendedusernamechars'] = 'Permitir caracteres especiais no nome de utilizador';
$string['extramemorylimit'] = 'Limite extra de memória PHP';
$string['fatalsessionautostart'] = '<p>Foi detetado um erro grave de configuração. Por favor, informe o administrador do site.</p><p> Para funcionar corretamente é necessário que o administrador altere as configurações do PHP.</p><p><code>session.auto_start</code> deve estar definido como <code>off</code>.</p><p>Esta configuração é alterada no ficheiro <code>php.ini</code>, no ficheiro de configuração do Apache/IIS <br /> ou no ficheiro <code>.htaccess</code> no servidor.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Ficheiro favicon a ser exibido como ícone do site
O favicon é exibido ao lado do título da página no separador do navegador. Será exibido um favicon do Moodle se não for fornecido um favicon personalizado.';
$string['feedbacksettings'] = 'Configurações do feedback';
$string['fileconversioncleanuptask'] = 'Limpeza dos registos temporários das conversões de ficheiros';
$string['filecreated'] = 'Criado um novo ficheiro';
$string['filescleanupperiod'] = 'Limpar repositório de ficheiros de lixo';
$string['filescleanupperiod_help'] = 'Define a frequência de limpeza do repositório de ficheiros de lixo. Este repositório contém os ficheiros associados a um contexto que deixou de existir, como por exemplo, de uma disciplina apagada. Nota: esta configuração pode resultar na falta de ficheiros numa disciplina que foi objeto de cópia de segurança, foi apagada e depois restaurada, se estiver desativada a configuração \'Incluir ficheiros\' (backup_auto_files) em \'Configurações das cópias de segurança automáticas\'.';
$string['filesizeunits'] = 'unidades do tamanho do ficheiro';
$string['filestoredin'] = 'Guardar ficheiro na pasta:';
$string['filestoredinhelp'] = 'Onde o ficheiro será guardado';
$string['filterall'] = 'Filtrar todos os textos';
$string['filtermatchoneperpage'] = 'Filtrar um por página';
$string['filtermatchonepertext'] = 'Filtrar um por texto';
$string['filternavigationwithsystemcontext'] = 'Filtrar a navegação com o contexto do sistema';
$string['filters'] = 'Filtros';
$string['filtersettings'] = 'Gerir filtros';
$string['filtersettingsgeneral'] = 'Configurações gerais dos filtros';
$string['filteruploadedfiles'] = 'Filtrar envios de ficheiros';
$string['forceclean'] = 'Limpeza geral de conteúdos';
$string['forceclean_desc'] = 'O conteúdo adicionado ao site é normalmente limpo antes de ser mostrado, para remover tudo o que possa ser uma ameaça à segurança. No entanto, o conteúdo não é limpo em determinados locais, tais como, descrições das atividades, páginas ou blocos HTML, para permitir que sejam adicionados scripts, ficheiros multimédia, molduras incorporadas, etc. Se ativar esta configuração, TODO o conteúdo será limpo. Isto pode resultar que o conteúdo existente não seja mostrado corretamente.';
$string['forcelogin'] = 'Forçar autenticação dos utilizadores';
$string['forceloginforprofileimage'] = 'Forçar os utilizadores a autenticarem-se para visualizarem as fotos dos utilizadores';
$string['forceloginforprofileimage_help'] = 'Se ativar esta opção, os utilizadores têm de se autenticar para poderem ver as fotos de perfil e a imagem de utilizador predefinida será usada em todos os e-mails de notificação.';
$string['forceloginforprofiles'] = 'Forçar os utilizadores a autenticarem-se para visualizarem os perfis';
$string['forcetimezone'] = 'Forçar fuso horário';
$string['formatuninstallwithcourses'] = 'Existe(m) {$a->count} disciplina(s) a utilizar o \'{$a->format}\'. O formato das disciplinas será alterado para \'{$a->defaultformat}\' (formato predefinido do site). Poderão perder-se alguns dados específicos deste formato. Tem a certeza de que pretende continuar?';
$string['frontpage'] = 'Página principal';
$string['frontpagebackup'] = 'Cópia de segurança da página principal';
$string['frontpagedefaultrole'] = 'Papel a atribuir automaticamente na página principal';
$string['frontpagefilters'] = 'Filtros da página principal';
$string['frontpageloggedin'] = 'Página principal, quando autenticado';
$string['frontpageoverrides'] = 'Redefinições das permissões da página principal';
$string['frontpagequestions'] = 'Perguntas da página principal';
$string['frontpagerestore'] = 'Restauro da página principal';
$string['frontpageroles'] = 'Atribuir papéis na página principal';
$string['frontpagesettings'] = 'Configurar página principal';
$string['fullnamedisplay'] = 'Formato do nome completo';
$string['fullnamedisplayprivate'] = 'Formato do nome completo - privado';
$string['gdrequired'] = 'A extensão GD é agora exigida pelo Moodle para conversão de imagens.';
$string['generalsettings'] = 'Configurações gerais';
$string['geoipdbedition'] = 'Edição da base de dados GeoIP';
$string['geoipdbedition_desc'] = 'Selecione a edição da base de dados GeoIP para descarregar. Tenha em atenção de que usar a base de dados GeoIP2-City requer uma licença paga válida.';
$string['geoipfile'] = 'Base de dados GeoIP City';
$string['geoipmaxmindaccid'] = 'ID da conta MaxMind';
$string['geoipmaxmindaccid_desc'] = 'O ID da conta criada no serviço MaxMind API.';
$string['geoipmaxmindlicensekey'] = 'Chave da licença MaxMind';
$string['geoipmaxmindlicensekey_desc'] = 'A chave da licença da conta criada no serviço MaxMind API.';
$string['getremoteaddrconf'] = 'Origem do endereço IP';
$string['globalsearch'] = 'Pesquisa global';
$string['globalsearchmanage'] = 'Gerir pesquisa global';
$string['googlemapkey3'] = 'Chave da API V3 do Google Maps';
$string['googlemapkey3_help'] = 'É necessária uma chave especial para usar o Google Maps de modo a poder visualizar a localização de endereços IP. Essa chave pode ser obtida gratuitamente na página <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Ir para primeira frase em falta';
$string['gradebook'] = 'Pauta';
$string['gradebookroles'] = 'Papéis mostrados na pauta';
$string['gradeexport'] = 'Métodos primários de exportação de notas';
$string['gradeexportdefault'] = 'Método predefinido de esportação das notas';
$string['gravatardefaulturl'] = 'URL da imagem predefinida do Gravatar';
$string['gravatardefaulturl_help'] = 'É necessário especificar uma imagem predefinida para o caso do Gravatar não encontrar uma imagem para um determinado utilizador. Indique um URL completo de uma imagem. Os códigos para gerar imagens padrão estão disponíveis em <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar para programadores - Pedidos de Avatar</a>.

Se deixar em branco, o Moodle tentará usar a imagem predefinida mais adequada para a página que está a ver. O Gravatar tem um conjunto de códigos que pode usar para <a href="https://en.gravatar.com/site/implement/images/#default-image">gerar imagens predefinidas</a>.';
$string['group_customfield'] = 'Campos personalizados de grupo';
$string['groupenrolmentkeypolicy'] = 'Política para a senha de inscrição nos grupos';
$string['groupenrolmentkeypolicy_desc'] = 'Se ativar esta opção, as senhas de inscrição nos grupos terão de cumprir a política de senhas especificada nas configurações acima.';
$string['grouping_customfield'] = 'Campos personalizados de agrupamento';
$string['guestroleid'] = 'Papel a atribuir aos visitantes';
$string['guestroleid_help'] = 'Este papel é atribuído automaticamente ao utilizador "Visitante". É também atribuído temporariamente a utilizadores não inscritos na disciplina que acedem através do módulo de inscrição Visitante.';
$string['h5pgetcontenttypestask'] = 'Descarregamento de tipos de conteúdo H5P disponíveis em h5p.org';
$string['helpadminseesall'] = 'No calendário do site, os administradores veem e filtram eventos de todos os calendários de disciplinas ou apenas das disciplinas em que estão inscritos? Independentemente da opção escolhida, os administradores poderão sempre gerir eventos do calendário de cada disciplina se acederem à disciplina e depois diretamente ao calendário.';
$string['helpcalendarcustomexport'] = 'Ativar a opção de exportação de intervalo de datas personalizado nas exportações do calendário. Tenha em atenção que as exportações do calendário devem ser ativadas antes de ativar esta opção.';
$string['helpexportlookahead'] = 'Número de dias futuros a considerar na pesquisa de eventos no calendário.';
$string['helpexportlookback'] = 'Ao longo de quantos dias antecedentes deve o calendário pesquisar eventos durante a exportação para a opção de exportação personalizada?';
$string['helpforcetimezone'] = 'Esta configuração permite definir se os utilizadores podem escolher individualmente o seu fuso horário ou se este é definido ao nível do sistema para todos os utilizadores.';
$string['helpshowicalsource'] = 'Se ativar esta opção, o nome da subscrição, e a respetiva hiperligação, será exibido nos eventos iCal importados.';
$string['helpsitemaintenance'] = 'Para atualizações e outras tarefas.';
$string['helpstartofweek'] = 'Em que dia começa a semana no calendário?';
$string['helpupcominglookahead'] = 'Por predefinição, quantos dias futuros devem ser considerados para detetar os eventos que vão ocorrer?';
$string['helpupcomingmaxevents'] = 'Por predefinição, qual o número máximo de eventos futuros que podem ser mostrados aos utilizadores?';
$string['helpweekenddays'] = 'Quais os dias da semana que são considerados como "Fim de Semana" e apresentados com uma cor diferente?';
$string['hiddenuserfields'] = 'Campos de utilizador a ocultar';
$string['hidefromall'] = 'Ocultar a todos os utilizadores';
$string['hidefromnone'] = 'Não ocultar a ninguém';
$string['hidefromstudents'] = 'Ocultar aos alunos';
$string['hookcallbacknotcallable'] = 'Este callback não pode ser chamado. Pode ocorrer porque a classe ou método não existe ou porque o método não é público.';
$string['hookcallbacks'] = 'Callbacks';
$string['hookcallbacks_help'] = 'A lista de callbacks que serão chamados quando o hook for despachado.

A ordem mostrada é a ordem na qual os callback são chamados.

Um callback com prioridade mais alta será chamado antes de outro com prioridade mais baixa.';
$string['hookclassmissing'] = 'Classe Hook não encontrada';
$string['hookclassmissing_desc'] = 'O agente de descoberta do hook retornou uma classe que não existe.';
$string['hookconfigoverride'] = 'Substituída';
$string['hookconfigoverride_help'] = 'A definição deste callback foi substituída no ficheiro de configuração do site, config.php';
$string['hookdeprecates'] = 'Callbacks obsoletos';
$string['hookdescription'] = 'Descrição';
$string['hookdescriptionmissing'] = 'Hook não tem uma descrição do método';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Visão global do Hooks';
$string['hookunknown'] = 'Hook não encontrado';
$string['hookunknown_desc'] = 'O objeto que este callback atende não está disponível. Pode ter sido removido ou renomeado, ou pode não estar disponível nesta versão do Moodle.';
$string['hostname'] = 'Nome do servidor';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Configurações do editor de HTML';
$string['htmlsettings'] = 'Configurações HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Segurança HTTP';
$string['iconvrequired'] = 'É obrigatória a instalação da extensão ICONV.';
$string['igbinary322buggyversion'] = 'A extensão igbinary do PHP instalada no site pode originar problemas ao executar com PHP 7.2. Recomenda-se que atualize a extensão igbinary para a versão 3.2.5 ou posterior ou, alternativamente, atualize para o PHP 7.3 ou posterior.';
$string['ignore'] = 'Ignorar';
$string['importantupdates_content'] = '<p>No Moodle 5.0, as atividades Chat e Inquérito foram removidas do core do Moodle. Estão disponíveis como módulos na <a href="https://moodle.org/plugins/">diretoria de módulos do Moodle</a>.</p>
<p>Se pretende continuar a usar o Chat ou o Inquérito no seu site, poderá instalá-los como módulos ao atualizar para o Moodle 5.0.</p>';
$string['importantupdates_title'] = 'Atualização importante sobre as atividades Chat e Inquérito';
$string['includemoduleuserdata'] = 'Incluir dados de utilizador dos módulos';
$string['incompatibleblocks'] = 'Blocos incompatíveis';
$string['incompleteunicodesupport'] = 'A configuração atual do MySQL ou MariaDB utiliza \'utf8\'. Esta definição de caracteres não suporta caracteres de quatro byte que incluem alguns emoji. Se tentar usar estes caracteres resultará em erro ao atualizar um registo e qualquer informação que esteja a ser enviada para a base de dados será perdida. Considere alterar as suas configurações para \'utf8mb4\'. Consulte a documentação para obter mais detalhes.';
$string['indexdata'] = 'Dados do índice';
$string['indexinginfo'] = 'A forma recomendada para indexar os conteúdos do seu site é utilizar a tarefa agendada "Indexação da pesquisa global".';
$string['installhijacked'] = 'A instalação tem de ser concluída a partir do endereço IP inicial.';
$string['installsessionerror'] = 'Não foi possível iniciar a sessão PHP. Por favor, verifique se o seu navegador aceita cookies.';
$string['intlrecommended'] = 'A extensão Intl do PHP é usada para melhorar as funcionalidades de internacionalização do Moodle e a ordenação de acordo com o local.';
$string['intlrequired'] = 'A extensão Intl é necessária para melhorar o suporte à internacionalização, tais como a classificação local e os nomes de domínios internacionais.';
$string['invalidagedigitalconsent'] = 'A idade mínima de consentimento não é válida: {$a}';
$string['invalidforgottenpasswordurl'] = 'O URL da recuperação da senha não é um URL válido.';
$string['invalidsection'] = 'Secção inválida';
$string['invalidthemepreset'] = 'O ficheiro predefinido escolhido não é compatível com este tema. O erro de compilação do SCSS foi: "{$a}"';
$string['invaliduserchangeme'] = 'O nome de utilizador "changeme" está reservado -- não pode criar uma conta com este nome.';
$string['ipblocked'] = 'Atualmente este site não está disponível.';
$string['ipblocker'] = 'Restringir IPs';
$string['ipblockersyntax'] = 'Coloque cada elemento numa linha separada. As entradas válidas são endereços de IP completos (tal como <b>192.168.10.1</b>) que correspondem a um único servidor ou endereços parciais (tal como <b>192.168</b>) que correspondem a qualquer endereço que comece com aqueles números, a um registo CIDR (tal como <b>231.54.211.0/20</b>) ou um intervalo de endereços IP (tal como <b>231.3.56.10-20</b>) em que o intervalo se aplica à última parte do endereço. Nomes de domínio de texto (tal como \'exemplo.com\') não são suportados. Linhas em branco e texto após o caráter "#" são ignorados.';
$string['iplookup'] = 'Localização de endereço IP';
$string['iplookupgeoplugin'] = '<a href="https://www.geoplugin.com">geoPlugin</a> é usado para pesquisar informação geográfica. Para obter resultados mais precisos recomenda-se a instalação de uma cópia local da base de dados MaxMind GeoIP City.';
$string['iplookupinfo'] = 'O servidor online gratuito NetGeo é usado para procurar localizações de endereços IP. A base de dados já não é mantida e pode retornar dados incorretos. Recomenda-se a instalação de uma cópia local da base de dados gratuita GeoIP da MaxMind.<br />
Se for fornecida uma chave Google Maps API V3, a localização do endereço IP será exibida usando o Google Maps. É necessária uma conta Google e obter uma chave API do Google Maps. Se não for fornecida uma chave Google Maps API V3, a localização do endereço IP será exibida usando o OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Este produto inclui dados do GeoIP City, criado pela MaxMind, disponível em <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Foi detetado que o seu site está a usar uma diretoria de administração personalizada. Esta funcionalidade já não é suportada e será removida após o Moodle 4.2.';
$string['ishttpswarning'] = 'Foi detetado que o seu site não utiliza o protocolo de segurança HTTPS. É fortemente recomendado que migre o seu site para o protocolo HTTPS de modo a incrementar a segurança e melhorar a integração com outros sistemas.';
$string['keeptagnamecase'] = 'Manter maiúsculas/minúsculas nas palavras-chave';
$string['lang'] = 'Idioma predefinido';
$string['langcache'] = 'Cache do menu de idiomas';
$string['langcache_desc'] = 'Guardar em cache o menu de idiomas. Se ativar esta opção, a lista de idiomas disponíveis fica guardada em memória cache. Esta memória de acesso rápido é atualizada de forma automática quando um pacote linguístico é instalado ou removido através da interface do Moodle. Se instalar ou remover um novo idioma manualmente (colocando ou removendo um pacote linguístico diretamente no servidor) terá que usar a funcionalidade <b>Limpar todas as caches</b> para atualizar o menu de idiomas.';
$string['langlist'] = 'Idiomas a mostrar no menu de idiomas';
$string['langmenu'] = 'Mostrar menu de idiomas';
$string['langmenuinsecurelayout'] = 'Exibir menu de idiomas numa estrutura segura';
$string['langmenuinsecurelayout_desc'] = 'Se ativar esta opção, o utilizador poderá alterar o idioma ao tentar responder a um teste ou outra atividade usando uma estrutura segura.';
$string['langpackwillbeupdated'] = 'Nota: Durante a atualização, o Moodle tentará atualizar os pacotes linguísticos instalados.';
$string['langstringcache'] = 'Cache de todas as palavras do idioma';
$string['languagesettings'] = 'Configurar idioma';
$string['latinexcelexport'] = 'Codificação Excel';
$string['legacyfilesaddallowed'] = 'Permitir adicionar ficheiros de retrocompatibilidade da disciplina';
$string['legacyfilesaddallowed_help'] = 'Se uma disciplina tiver ficheiros de retrocompatibilidade da disciplina, permitir que novos ficheiros e pastas lhe sejam adicionados.';
$string['legacyfilesinnewcourses'] = 'Antigos \'Ficheiros da disciplina\' (Moodle 1.9) nas novas disciplinas (Moodle 2.0)';
$string['legacyfilesinnewcourses_help'] = 'Por predefinição, os ficheiros de retrocompatibilidade da disciplina (Moodle 1.9) apenas estão disponíveis nas disciplinas que tenham sido atualizadas a partir de versões anteriores à 2.0. Nestes casos, algumas funcionalidades, tal como realizar e restaurar uma cópia de segurança, não estão disponíveis.';
$string['libcurlwarning'] = 'Foi detetado que o libcurl não tem suporte para o CURLOPT_PROTOCOL. Recomenda-se a instalação atualizada do libcurl por razões de segurança.';
$string['licensesettings'] = 'Configurações da licença';
$string['linkadmincategories'] = 'Hiperligações para as categorias de administração';
$string['linkadmincategories_help'] = 'Se ativar esta opção, as categorias de configurações da Administração do Site serão mostradas como hiperligações na Navegação apontando para as páginas de configurações da categoria.';
$string['loading'] = 'A carregar';
$string['localetext'] = 'Locale do site';
$string['localstringcustomization'] = 'Personalização local do idioma';
$string['location'] = 'Localização';
$string['locationsettings'] = 'Configurar localização';
$string['locked'] = 'Bloqueado';
$string['lockoutduration'] = 'Duração do bloqueio de conta';
$string['lockoutduration_desc'] = 'O bloqueio de conta será automaticamente desbloqueado depois desta duração.';
$string['lockoutemailbody'] = 'Caro(a) {$a->firstname},

A sua conta com o nome de utilizador \'{$a->username}\' no servidor \'{$a->sitename}\' foi bloqueada após múltiplas tentativas de autenticação inválidas.

Para desbloquear imediatamente a conta, aceda ao seguinte endereço:

{$a->link}

Na maioria dos casos, deve aparecer como uma hiperligação azul no qual pode simplesmente clicar. Se não funcionar, copie e cole na linha de endereço no topo da janela do seu navegador web.

Se precisar de ajuda, por favor, contacte o administrador do site,
{$a->admin}.';
$string['lockoutemailsubject'] = 'A sua conta em \'{$a}\' foi bloqueada.';
$string['lockouterrorunlock'] = 'A informação fornecida para desbloqueio de conta é inválida.';
$string['lockoutthreshold'] = 'Limite de bloqueio da conta';
$string['lockoutthreshold_desc'] = 'Selecione o número de tentativas de autenticação falhadas que geram o bloqueio da conta. Esta funcionalidade poderá ser usada em ataques de negação de serviço.';
$string['lockoutwindow'] = 'Tempo do limite de bloqueio da conta';
$string['lockoutwindow_desc'] = 'Intervalo de tempo para verificação do limite de bloqueio da conta. O contador de tentativas falhadas será reiniciado após este intervalo de tempo, caso não hajam tentativas de autenticação falhadas.';
$string['lockrequestcategory'] = 'Impedir a seleção de categoria';
$string['log'] = 'Registos de atividade';
$string['logguests'] = 'Registar acessos dos utilizadores com o papel de Visitante';
$string['logguests_help'] = 'Se ativar esta opção, será feito o registo das ações das contas de visitantes e utilizadores não autenticados. Em sites com muita atividade pode ser desejável desativar este parâmetro para melhorar o desempenho. A ativação deste parâmetro é recomendada em sites de produção.';
$string['logininfoinsecurelayout'] = 'Exibir utilizador autenticado numa estrutura segura';
$string['logininfoinsecurelayout_desc'] = 'Se ativar esta opção, o nome completo do utilizador autenticado será mostrado na barra de navegação ao tentar responder a um teste ou outra atividade usando uma estrutura segura.';
$string['loginpageautofocus'] = 'Autofocus do formulário da página de autenticação';
$string['loginpageautofocus_help'] = 'Se ativar esta opção, será melhorada a usabilidade da página de autenticação, mas o foco automático de campos de formulário pode ser considerado desfavorável em termos de acessibilidade.';
$string['loglifetime'] = 'Manter registos de atividade durante';
$string['logo'] = 'Logótipo';
$string['logo_desc'] = 'Um logótipo completo para ser utilizado como decoração por alguns temas (tal como temas predefinidos). Esta imagem poderá ser de elevada resolução porque será reduzida para utilização (e armazenada em cache para melhorar o desempenho). Os logótipos com uma largura superior à altura costumam resultar melhor.';
$string['logocompact'] = 'Logótipo compacto';
$string['logocompact_desc'] = 'Versão compacta do logótipo acima, tal como um emblema, escudo ou ícone. A imagem deve ser nítida, mesmo em tamanhos reduzidos.';
$string['logossettings'] = 'Logótipos';
$string['logstorenotrequired'] = 'Não é necessária a unidade de armazenamento de registos de atividade';
$string['logstoressupported'] = 'Unidades de armazenamento de registos de atividade que suportam este relatório';
$string['longtimewarning'] = '<strong>Tenha em atenção que este processo pode demorar muito tempo. </strong>';
$string['mailnewline'] = 'Caracteres de nova linha na mensagem';
$string['maintenancemode'] = 'Em modo de manutenção';
$string['maintenancemodeisscheduled'] = 'O site entrará em modo de manutenção dentro de {$a->min} minutos e {$a->sec} segundos';
$string['maintenancemodeisscheduledlong'] = 'Este site irá entrar em modo de manutenção em {$a->hour} horas, {$a->min} minutos e {$a->sec} segundos';
$string['maintfileopenerror'] = 'Erro ao abrir ficheiros de manutenção!';
$string['maintinprogress'] = 'Manutenção a decorrer...';
$string['managecontextlock'] = 'Bloquear este contexto';
$string['managecontextlocklocked'] = '\'{$a->contextname}\' e todos os contextos inferiores estão bloqueados.';
$string['managecontextlockunlocked'] = '\'{$a->contextname}\' e todos os contextos inferiores estão desbloqueados.';
$string['managecontextunlock'] = 'Desbloquear este contexto';
$string['managecustomfields'] = 'Gerir tipos de campo personalizados';
$string['manageformats'] = 'Gerir formatos da disciplina';
$string['manageformatsgotosettings'] = 'O formato predefinido pode ser alterado em {$a}';
$string['managelang'] = 'Gerir';
$string['manageqbanks'] = 'Gerir módulos de base de dados de perguntas';
$string['manageqbehaviours'] = 'Gerir comportamentos das perguntas';
$string['manageqtypes'] = 'Gerir tipos de perguntas';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Versão candidata';
$string['maturity200'] = 'Versão estável';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Dica: Poderá querer executar este programa com a opção --allow-unstable';
$string['maturitycoreinfo'] = 'O seu site contém código de desenvolvimento instável: "{$a}"';
$string['maturitycorewarning'] = 'A versão do Moodle que pretende instalar, ou atualizar para, contém código de desenvolvimento instável "{$a}" que não deve ser usado em ambientes de produção. Se não for isto que pretende, confirme que está a fazer uma atualização a partir de uma versão estável do Moodle. Para mais informações, consulte a documentação do Moodle.';
$string['maxbytes'] = 'Tamanho máximo dos ficheiros enviados';
$string['maxcharacter'] = 'máximo de {$a} caracteres';
$string['maxconsecutiveidentchars'] = 'Caracteres iguais consecutivos';
$string['maxeditingtime'] = 'Intervalo para edição de mensagens nos fóruns';
$string['maxsizeperdownloadcoursefile'] = 'Tamanho máximo por ficheiro';
$string['maxsizeperdownloadcoursefile_desc'] = 'O tamanho máximo de cada ficheiro quando descarrega o conteúdo da disciplina. Ficheiros que excedam este tamanho serão omitidos do conteúdo a descarregar.';
$string['maxtimelimit'] = 'Tempo limite máximo';
$string['maxtimelimit_desc'] = 'Para restringir o tempo máximo de execução PHP que o Moodle permitirá, sem que qualquer resultado seja exibido, digite um valor em segundos aqui. "0" significa que as restrições predefinidas do Moodle estão a ser usadas. Se tem um servidor de front-end com o seu próprio limite de tempo, defina este valor para um número mais baixo para receber os erros de PHP nos registos de atividade. Não se aplica aos scripts CLI.';
$string['maxusersperpage'] = 'Número máximo de utilizadores por página';
$string['mbstringrecommended'] = 'É recomendada a instalação da extensão MBSTRING do PHP para um melhor desempenho do site, principalmente se o site utiliza idiomas não-latinos.';
$string['mbstringrequired'] = 'É necessário instalar a biblioteca MBSTRING para melhorar o desempenho do site, principalmente se o seu site oferecer suporte a idiomas não latinos.';
$string['mediapluginavi'] = 'Ativar filtro .avi';
$string['mediapluginflv'] = 'Ativar filtro .flv';
$string['mediapluginimg'] = 'Ativar incorporação automática de imagens com hiperligações.';
$string['mediapluginmov'] = 'Ativar filtro .mov';
$string['mediapluginmp3'] = 'Ativar filtro .mp3';
$string['mediapluginmpg'] = 'Ativar filtro .mpg';
$string['mediapluginogg'] = 'Ativar filtro .ogg';
$string['mediapluginogv'] = 'Ativar filtro .ogv';
$string['mediapluginram'] = 'Ativar filtro .ram';
$string['mediapluginrm'] = 'Ativar filtro .rm';
$string['mediapluginrpm'] = 'Ativar filtro .rpm';
$string['mediapluginwmv'] = 'Ativar filtro .wmv';
$string['mediapluginyoutube'] = 'Ativar filtro de hiperligações do YouTube';
$string['messaging'] = 'Ativar sistema de envio de mensagens';
$string['messagingallowemailoverride'] = 'Alterar e-mail de notificação';
$string['messagingallusers'] = 'Permitir mensagens entre todos os utilizadores';
$string['messagingcategory'] = 'Mensagens';
$string['messagingdefaultpressenter'] = '\'Enter para enviar\' por predefinição';
$string['messagingdeleteallnotificationsdelay'] = 'Apagar todas as notificações';
$string['messagingdeletereadnotificationsdelay'] = 'Apagar notificações já lidas';
$string['messagingssettings'] = 'Configurações das mensagens';
$string['minpassworddigits'] = 'Caracteres numéricos';
$string['minpasswordlength'] = 'Tamanho da senha';
$string['minpasswordlower'] = 'Letras minúsculas';
$string['minpasswordnonalphanum'] = 'Caracteres não alfanuméricos';
$string['minpasswordupper'] = 'Letras maiúsculas';
$string['misc'] = 'Diversos';
$string['mlbackendsettings'] = 'Configurações da estrutura Python de suporte à aprendizagem';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Esta cópia de segurança contém contas remotas de utilizadores da Rede Moodle que serão restauradas como parte do processo.';
$string['mnetrestore_extusers_admin'] = '<strong>Aviso:</strong> Este ficheiro da cópia de segurança parece provir de uma instalação Moodle diferente e contêm contas de utilizador remotas de Rede Moodle. O processo de restauro irá tentar identificar a Rede de anfitriões Moodle para todos os utilizadores criados. Aqueles que não coincidirem serão automaticamente registados com autenticação interna (em vez do mnet). O registo do restauro conterá informação detalhada sobre estas ocorrências.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Esta cópia de segurança aparentemente tem origem numa instalação diferente do Moodle e contém contas de utilizadores remotos da Rede Moodle que podem não ser restauradas com sucesso. Esta operação não é suportada. Se tem a certeza de que foi criada nesta instalação do Moodle, ou se garantir que todos os servidores da Rede Moodle necessários estão configurados, pode querer tentar restaurar.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Aviso:</strong> Este ficheiro da cópia de segurança parece provir de uma instalação Moodle diferente e contém contas de utilizador remotas de Rede Moodle. Não tem permissão a executar este tipo de restauro. Contacte o administrador do site, ou alternativa, restaure a disciplina sem informação dos utilizadores (módulos, ficheiros, ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'O utilizador remoto da Rede Moodle {$a->username} (originário de {$a->mnethosturl}) mudou para utilizador local com autenticação {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'A Aplicação móvel Moodle não está ativa.';
$string['modassignmentinuse'] = 'O seu site ainda está a usar o módulo Trabalho 2.2. Antes de atualizar tem de: 1) fazer cópia de segurança das suas atividades Trabalho 2.2 que pretende manter e restaurá-las como novas atividades Trabalho e 2) apagar na base de dados todos os dados das tabelas Trabalho 2.2.';
$string['modassignmentsubpluginsexist'] = 'Podem existir submódulos de Trabalho 2.2. A pasta \'mod/assignment\' e todos os seus sub-módulos têm de ser removidos antes da atualização.';
$string['modeditdefaults'] = 'Valores predefinidos das configurações das atividades';
$string['modsettings'] = 'Gerir atividades';
$string['modulesecurity'] = 'Segurança dos módulos';
$string['moodlebrandedapp'] = 'Aplicação móvel Moodle Personalizada';
$string['moodlebrandedappreference'] = 'Como alternativa, obtenha uma <a href="https://moodle.com/branded-app/">Aplicação móvel Moodle Personalizada</a> com a identidade da sua organização.';
$string['mustenablestats'] = 'As estatísticas ainda não foram ativadas neste site.';
$string['mycourses'] = 'Minhas disciplinas';
$string['mydashboard'] = 'Painel predefinido de controlo do sistema';
$string['mymoodle'] = 'Painel do utilizador';
$string['mypage'] = 'Painel do utilizador predefinido';
$string['mypagelocked'] = 'Página predefinida de bloqueio';
$string['myprofile'] = 'Página de perfil predefinida';
$string['navadduserpostslinks'] = 'Adicionar hiperligações para ver mensagens dos utilizadores';
$string['navadduserpostslinks_help'] = 'Se ativar esta opção, serão adicionadas duas hiperligações a cada utilizador na navegação para ver os tópicos que o utilizador iniciou e as mensagens que submeteu em fóruns de todo o site ou em disciplinas específicas.';
$string['navcourselimit'] = 'Número máximo de disciplinas';
$string['navfilter'] = 'Menu personalizado de filtro';
$string['navfilter_desc'] = 'Processar o menu personalizado através dos filtros do Moodle que estão configurados para serem aplicados a <strong>Conteúdo e cabeçalhos</strong>. Útil para ativar itens dinâmicos de menu personalizados.';
$string['navigationupgrade'] = 'Esta atualização cria dois novos blocos de navegação que substituem os seguintes: Administração, Disciplinas, Atividades e Participantes. Se tiverem sido definidas permissões específicas nestes blocos, deve ser verificado se o comportamento pretendido se mantém.';
$string['navshowallcourses'] = 'Mostrar todas as disciplinas';
$string['navshowcategories'] = 'Mostrar categorias de disciplinas';
$string['navshowfrontpagemods'] = 'Mostrar atividades da página principal na navegação';
$string['navshowfrontpagemods_help'] = 'Se ativar esta opção, a atividade da página principal será exibida na navegação das páginas do site. Esta configuração apenas se aplica em temas baseados no tema Clássico.';
$string['navshowfullcoursenames'] = 'Mostrar nome completo das disciplinas';
$string['navshowfullcoursenames_help'] = 'Se ativar esta opção, o nome completo das disciplinas será usado, na navegação, em vez do nome curto.';
$string['navshowmycoursecategories'] = 'Mostrar as minhas categorias';
$string['navshowmycoursecategories_help'] = 'Se ativar esta opção, as Minhas disciplinas são exibidas em categorias no bloco de navegação (apenas em temas baseados no tema Clássico).';
$string['navsortmycourseshiddenlast'] = 'Ordenar as minhas disciplinas ocultas no fim';
$string['navsortmycourseshiddenlast_help'] = 'Se ativar esta opção, todas as disciplinas ocultas serão listadas após as disciplinas visíveis (para utilizadores que podem ver as disciplinas ocultas). Caso contrário, todas as disciplinas, independentemente de estarem visíveis ou ocultas, serão listadas de acordo com a configuração \'Ordenar as minhas disciplinas\'.';
$string['navsortmycoursessort'] = 'Ordem das disciplinas no bloco navegação';
$string['navsortmycoursessort_help'] = 'A listagem das disciplinas deve ser apresentada como definido em Administração do Site > Disciplinas > Gerir disciplinas e categorias ou por ordem alfabética? Esta configuração só se aplica em temas baseados no Classic.';
$string['never'] = 'Nunca';
$string['neverdeleteruns'] = 'Nunca apagar <i>runs</i>';
$string['newestdocindexed'] = 'Data/hora do documento indexado mais recente';
$string['nobookmarksforuser'] = 'Não tem nenhum marcador.';
$string['nodatabase'] = 'Não existe base de dados';
$string['noemaileverwarning'] = '<strong>Nota:</strong> Todos os envios de e-mail foram desativados';
$string['nohttpsformobilewarning'] = 'É recomendado que ative a utilização do protocolo HTTPS com um certificado válido. A Aplicação móvel Moodle tentará sempre usar a ligação segura em primeiro lugar.';
$string['nomissingstrings'] = 'Não existem frases em falta';
$string['none'] = 'Nenhum';
$string['nonewsettings'] = 'Durante esta atualização não foram adicionadas configurações adicionais.';
$string['nonexistentbookmark'] = 'O marcador solicitado não existe.';
$string['noreplyaddress'] = 'Endereço \'Não responder\'';
$string['noreplydomain'] = 'Domínio e endereço \'Não responder\'';
$string['noreplydomaindetail'] = 'Configurações do endereço \'Não responder\' e dos domínios permitidos';
$string['noresults'] = 'Não foram encontrados resultados.';
$string['noroles'] = 'Não existem papéis';
$string['nosupportedlogstore'] = '';
$string['noteunneededblocks'] = 'Nota: Os blocos definidos para serem exibidos não serão listados no menu \'Adicionar bloco\' na disciplina se forem especificados na configuração \'Blocos não necessários\' do tema.';
$string['notifications'] = 'Notificações';
$string['notifyloginfailures'] = 'Enviar tentativas de autenticação falhadas para';
$string['notifyloginthreshold'] = 'Limite para envio de notificações por e-mail';
$string['notloggedinroleid'] = 'Papel a atribuir aos utilizadores não autenticados';
$string['numberofmissingstrings'] = 'Numero de frases em falta: {$a}';
$string['numberofstrings'] = 'Número total de frases: {$a->strings}<br />Em falta: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'O token de atualização para um serviço OAuth {$a->issuer} no seu site {$a->siteurl} expirou. Isto limitará a funcionalidade de qualquer módulo que use este serviço. Para corrigir este problema, visite a página de configuração dos Serviços OAuth 2 e clique no ícone "Ligar a uma conta do sistema" na linha da tabela correspondente a este serviço. Certifique-se de que inicia sessão utilizando sempre a mesma conta de serviço para o sistema OAuth 2.';
$string['oauthrefreshtokenexpiredshort'] = 'O token de atualização do OAuth {$a->issuer} no seu site {$a->siteurl} expirou.';
$string['onlynoreply'] = 'Apenas a partir do endereço \'Não responder\'';
$string['opcacherecommended'] = 'A cache de opcodes do PHP melhora o desempenho e reduz os requisitos de memória. A extensão OPcache é recomendada e totalmente suportada.';
$string['opensslrecommended'] = 'É altamente recomendada a instalação da opcional OpenSSL library -- permite a funcionalidade Rede Moodle.';
$string['opensslrequired'] = 'A extensão OpenSSL do PHP é agora obrigatória pelo Moodle para os melhores serviços criptográficos.';
$string['opentowebcrawlers'] = 'Permitir acesso aos motores de busca';
$string['optionalmaintenancemessage'] = 'Mensagem de manutenção (opcional)';
$string['order1'] = 'Primeiro';
$string['order2'] = 'Segundo';
$string['order3'] = 'Terceiro';
$string['order4'] = 'Quarto';
$string['outgoingmailconfig'] = 'Configuração do envio de e-mails';
$string['overridetossl'] = 'Já é obsoleto usar HTTPS para autenticação. Esta instância agora é obrigada a usar SSL. Para contornar este aviso, altere no ficheiro wwwroot para  para https: //';
$string['pageinfodebugsummary'] = 'Esta página é: {$a}';
$string['passwordchangelogout'] = 'Terminar sessões após alteração da senha';
$string['passwordchangelogout_desc'] = 'Se ativar esta opção, quando a senha for alterada, todas as sessões do navegador são terminadas, à exceção daquela em que a nova senha foi definida. (Esta configuração não afeta as alterações de senha feitas através do processamento em massa.)';
$string['passwordchangetokendeletion'] = 'Apagar tokens de acesso ao web service após alteração da senha';
$string['passwordchangetokendeletion_desc'] = 'Se ativar esta opção, sempre que uma senha é alterada, todos os tokens de acesso ao web service do utilizador são apagados.';
$string['passwordpolicy'] = 'Ativar regras para as senhas';
$string['passwordpolicycheckonlogin'] = 'Verificar senha ao autenticar';
$string['passwordresettime'] = 'Tempo máximo para validar o pedido de reposição da senha';
$string['passwordreuselimit'] = 'Limite de reutilização da senha';
$string['passwordreuselimit_desc'] = 'Número de vezes que um utilizador tem de alterar a senha antes de ser permitida a sua reutilização. As hashes das senhas utilizadas anteriormente são armazenadas numa base de dados local. Esta opção poderá não ser compatível com alguns módulos externos de autenticação.';
$string['pathtodot'] = 'Caminho para o programa <strong>dot</strong>';
$string['pathtodot_help'] = 'Caminho para o programa <strong>dot</strong>. Em Linux é algo como \'/usr/bin/dot\'. Em Windows é algo como \'C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe\'. Em Mac é algo como \'/opt/local/bin/dot\'. Para ser possível gerar gráficos a partir de ficheiros DOT é necessário que este programa esteja instalado no servidor e o caminho do respetivo ficheiro executável do programa deve ser indicado aqui.';
$string['pathtodu'] = 'Caminho para o programa <strong>du</strong>';
$string['pathtogs'] = 'Caminho para o Ghostscript';
$string['pathtogs_help'] = 'Na maioria das instalações Linux, isto pode ficar definido como  \'/usr/bin/gs\'. Em Windows será algo como \'c:\\gs\\bin\\gswin32c.exe\' (certifique-se de que não existem espaços no caminho - se necessário, copie os ficheiros \'gswin32c.exe\' e \'gsdll32.dll\' para uma nova pasta sem espaços no caminho).';
$string['pathtopdftoppm'] = 'Caminho para pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> é uma biblioteca de renderização de PDF que inclui a ferramenta \'pdftoppm\' para converter ficheiros PDF em PNG. O desempenho é geralmente melhor do que ao usar o Ghostscript, especialmente para ficheiros grandes. Se disponível, o \'pdftoppm\' será usado em preferência ao Ghostscript. Na maioria das instalações do Linux, o caminho pode ser deixado como \'/usr/bin/pdftoppm\'. Caso contrário, tem de instalar o pacote \'poppler-utils\' ou \'poppler\', dependendo da sua distribuição Linux. No Windows, é fornecido pelas instalações do Cygwin.';
$string['pathtopgdump'] = 'Caminho para o programa <strong>pg_dump</strong>';
$string['pathtopgdumpdesc'] = 'Apenas necessário digitar se tiver mais que um programa <strong>pg_dump</strong> no seu sistema (por exemplo, se tiver mais que uma versão do PostgreSQL instalada)';
$string['pathtopgdumpinvalid'] = 'O caminho indicado para <strong>pg_dump</strong> é inválido ou não foi possível executar o ficheiro';
$string['pathtophp'] = 'Caminho para a CLI do PHP';
$string['pathtopsql'] = 'Caminho para o programa <strong>psql</strong>';
$string['pathtopsqldesc'] = 'Apenas necessário se tiver mais de um programa <strong>psql</strong> no seu sistema (por exemplo, se tiver mais que uma versão do PostgreSQL instalada)';
$string['pathtopsqlinvalid'] = 'O caminho indicado para <strong>psql</strong> é inválido ou não foi possível executar o ficheiro';
$string['pathtopython'] = 'Caminho para Python';
$string['pathtopythondesc'] = 'Caminho para o binário Python executável (Python 2 e Python 3 são aceites).';
$string['pathtosassc'] = 'Caminho para SassC';
$string['pathtosassc_help'] = 'Se especificar a localização do binário SassC mudará o compilador SASS da implementação PHP do Moodle para SassC. Para mais informações, visite: https://github.com/sass/sassc .';
$string['pcreunicodewarning'] = 'É extremamente recomendado usar a extensão PCRE PHP que é compatível como os caracteres Unicode.';
$string['perfdebug'] = 'Informação de desempenho';
$string['perfdebugdeferred'] = 'A aguardar o fim da execução do script para mostrar a depuração de desempenho...';
$string['performance'] = 'Desempenho';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Versão/parâmetro cluster PostgreSQL para operações através da linha de comandos. Se tiver apenas um PostgreSQL no seu sistema, ou não tiver a certeza do que é isto, deixe vazio.';
$string['phpfloatproblem'] = 'Detetado um problema inesperado na manipulação de PHP números float PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'O seu site está registado. Última atualização do registo: {$a}.<br />A tarefa agendada "Registo do site" mantém o registo atualizado. A qualquer momento pode atualizar manualmente o registo.';
$string['pleaserefreshregistrationnewdata'] = 'As informações do registo foram alteradas. Clique no botão \'Atualizar o registo\' para confirmar as alterações.';
$string['pleaserefreshregistrationunknown'] = 'O seu site foi registado, mas a data de registo é desconhecida.
Por favor, atualize o seu registo através do botão \'Atualizar o registo\' ou assegure-se que a tarefa agendada "Registo do site" encontra-se ativa para que o registo seja atualizado automaticamente.';
$string['plugin'] = 'Módulo';
$string['plugin_disabled'] = '\'{$a}\' desativado.';
$string['plugin_enabled'] = '\'{$a}\' ativado.';
$string['plugins'] = 'Módulos';
$string['pluginscheck'] = 'Conferir dependências dos módulos';
$string['pluginscheckfailed'] = 'A verificação de dependências falhou para {$a->pluginslist}';
$string['pluginschecktodo'] = 'Tem de resolver todos os requisitos do módulo antes de prosseguir com a instalação desta versão do Moodle!';
$string['pluginsoverview'] = 'Lista de módulos instalados';
$string['pluginsoverviewsee'] = 'Consulte a página \'<a href="{$a->url}">Lista de módulos instalados</a>\' para mais detalhes.';
$string['policysettings'] = 'Configurações da política';
$string['privacy:metadata'] = 'O módulo Administração não armazena quaisquer dados pessoais';
$string['privacyandpolicies'] = 'Privacidade e políticas';
$string['privacysettings'] = 'Configurações da privacidade';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome da categoria (tem de ser único)';
$string['profilecategorynamenotunique'] = 'Este nome de categoria já existe';
$string['profilecommonsettings'] = 'Configurações comuns';
$string['profileconfirmcategorydeletion'] = 'Há {$a} campo(s) nesta categoria que serão movidos para a categoria acima (ou abaixo, se for a primeira).<br />Pretende apagar esta categoria?';
$string['profileconfirmfielddeletion'] = 'Existe(m) {$a} utilizador(es) com este campo.<br />Tem a certeza de que pretende apagar este campo?';
$string['profilecreatecategory'] = 'Criar nova categoria de campos de perfil';
$string['profilecreatefield'] = 'Criar um novo campo de perfil';
$string['profilecreatenewcategory'] = 'Criar uma nova categoria';
$string['profilecreatenewfield'] = 'Criar um novo campo do tipo \'{$a}\' no perfil do utilizador';
$string['profiledefaultcategory'] = 'Outros campos';
$string['profiledefaultchecked'] = 'Ativo por predefinição';
$string['profiledefaultdata'] = 'Valor predefinido';
$string['profiledeletecategory'] = 'Apagar uma categoria';
$string['profiledeletefield'] = 'Apagar o campo \'{$a}\'';
$string['profiledescription'] = 'Descrição do campo';
$string['profiledscript'] = 'Este script foi classificado';
$string['profiledscriptview'] = 'Ver a informação deste script';
$string['profileeditcategory'] = 'Editar categoria: {$a}';
$string['profileeditfield'] = 'Editar campo de perfil: {$a}';
$string['profilefield'] = 'Campo de perfil';
$string['profilefieldcolumns'] = 'Colunas';
$string['profilefieldispassword'] = 'Trata-se de um campo de senha?';
$string['profilefieldlink'] = 'Hiperligação';
$string['profilefieldlink_help'] = 'Para transformar o texto numa hiperligação, insira um URL contendo $$, em que $$ será substituído pelo texto. Por exemplo, para transformar um identificação Twitter numa hiperligação, inserir https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Página de destino da hiperligação';
$string['profilefieldmaxlength'] = 'Limite de caracteres';
$string['profilefieldmaxlength_help'] = 'Para usar este campo na configuração \'Mostrar identidade do utilizador\', o limite deve ser de 255 caracteres ou menos.';
$string['profilefieldrows'] = 'Linhas';
$string['profilefields'] = 'Campos de perfil';
$string['profilefieldsize'] = 'Tamanho de exibição';
$string['profileforceunique'] = 'A informação deve ser única?';
$string['profileinvaliddata'] = 'Valor inválido';
$string['profilelocked'] = 'Este campo está bloqueado?';
$string['profilemenudefaultnotinoptions'] = 'O valor predefinido não é uma das opções acima indicadas';
$string['profilemenunooptions'] = 'Não indicou nenhuma opção do menu';
$string['profilemenuoptions'] = 'Opções do menu (uma por linha)';
$string['profilemenutoofewoptions'] = 'Tem de indicar pelo menos 2 opções';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Nenhum campo foi definido';
$string['profilerequired'] = 'O campo é obrigatório?';
$string['profileroles'] = 'Papéis visíveis no perfil';
$string['profilesforenrolledusersonly'] = 'Só os alunos inscritos podem alterar o perfil';
$string['profileshortname'] = 'Nome curto (tem de ser único)';
$string['profileshortnameinvalid'] = 'Este nome curto só pode conter caracteres alfanuméricos (letras e números) ou underscore (_).';
$string['profileshortnamenotunique'] = 'Nome curto já em uso';
$string['profilesignup'] = 'Mostrar na página de registo?';
$string['profilespecificsettings'] = 'Opções de configuração';
$string['profilevisible'] = 'Quem pode ver este campo?';
$string['profilevisible_help'] = '* Oculto - Informação privada visível apenas pelos administradores e gestores
* Visível para o utilizador - Informação privada visível apenas pelo utilizador e pelos administradores
* Visível para o utilizador, professores e administradores - Informação privada visível apenas pelo utilizador, administradores e professores (no perfil da disciplina)
* Visível para todos';
$string['profilevisibleall'] = 'Visível para todos';
$string['profilevisiblenone'] = 'Oculto';
$string['profilevisibleprivate'] = 'Visível para o utilizador';
$string['profilevisibleteachers'] = 'Visível para o utilizador, professores e administradores';
$string['profiling'] = 'Classificação';
$string['profilingallowall'] = 'Classificação contínua';
$string['profilingallowall_help'] = 'Se ativar esta opção, então, a qualquer momento, pode usar o parâmetro PROFILEALL (PGC) para ativar a classificação de todos os scripts executados durante a duração da sessão Moodle. Pelo contrário, pode usar o parâmetro PROFILEALLSTOP para interromper este processo.';
$string['profilingallowme'] = 'Classificação seletiva';
$string['profilingallowme_help'] = 'Se ativar esta opção, pode, de forma seletiva, usar o parâmetro PROFILEME (PGC) para classificar um determinado script se ele for executado. Pelo contrário, pode usar o parâmetro  DONTPROFILEME para impedir a classificação do script.';
$string['profilingautofrec'] = 'Classificação automática';
$string['profilingautofrec_help'] = 'Ao configurar este parâmetro, alguns pedidos (definidos aleatoriamente com base na frequência especificada - 1 de N) serão selecionados e classificados automaticamente, sendo os resultados armazenados para análise posterior. Tenha em atenção que esta forma de classificação respeita as configurações de inclusão e exclusão definidas. Defina o valor "0" (zero) para desativar a classificação automática.';
$string['profilingenabled'] = 'Ativar classificação';
$string['profilingenabled_help'] = 'Se ativar esta opção, então a classificação vai estar disponível no site e vai poder definir o seu comportamento através da configuração das seguintes opções.';
$string['profilingexcluded'] = 'Excluir da classificação';
$string['profilingexcluded_help'] = 'Lista de URLs (separados por vírgulas ou nova linha, ignorando wwwroot, chamável) que serão excluídos da classificação dos definidos na configuração \'Classificar estes\' .';
$string['profilingimportprefix'] = 'Prefixo de importação de perfis';
$string['profilingimportprefix_desc'] = 'Para facilitar a deteção, o prefixo de todas as operações de importação de perfis será igual ao valor especificado aqui.';
$string['profilingincluded'] = 'Classificar estes';
$string['profilingincluded_help'] = 'Lista de URLs (separados por vírgulas ou nova linha, ignorando wwwroot, chamável) que serão automaticamente classificados. Exemplos: /index.php, /course/view.php. Aceita também o \'*\' como caráter universal em qualquer posição. Exemplos: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Manter <i>runs</i> de classificação';
$string['profilinglifetime_help'] = 'Defina o tempo durante o qual pretende manter a informação acerca de <i>runs</i> de classificação antigos. Os mais antigos serão apagados periodicamente. De notar que isto exclui todos os <i>runs</i> de classificação definidos como \'run de referência\'.';
$string['profilingslow'] = 'Página de perfil lentas';
$string['profilingslow_help'] = 'Ao definir um tempo mínimo, em segundos, todas as páginas mais lentas serão analisadas. Apenas serão mantidos os perfis mais lentos que um perfil existente para o mesmo script. Defina como 0 para desativar. Tenha em atenção que isto obedece às configurações de exclusão.';
$string['protectusernames'] = 'Proteger nomes de utilizador';
$string['proxybypass'] = 'Servidores a contornar o proxy';
$string['proxyfixunsafe'] = 'Corrigir chamadas sem proxy';
$string['proxyhost'] = 'Servidor Proxy';
$string['proxylogunsafe'] = 'Registar chamadas sem proxy';
$string['proxypassword'] = 'Senha (password) do proxy';
$string['proxyport'] = 'Porta do Proxy';
$string['proxytype'] = 'Tipo de proxy';
$string['proxyuser'] = 'Nome de utilizador do proxy';
$string['purgecaches'] = 'Limpar todas as caches';
$string['purgecachesconfirm'] = 'O Moodle pode armazenar, em cache, temas, código Javascript, traduções, texto filtrado, listas RSS e muitas outras informações. Esvaziar as caches irá apagar essa informação do servidor e forçar os navegadores a obter esses dados novamente, para que tenha a certeza de que está a ver os valores mais atualizados produzidos pelo código atual. Não existe nenhum risco em esvaziar as caches, mas o site pode parecer momentaneamente mais lento até que o servidor e os clientes obtenham a informação e a armazenem em cache.';
$string['purgecachesfinished'] = 'Todas as caches foram esvaziadas.';
$string['purgecachesnoneselected'] = 'Selecione uma ou mais caches para limpar';
$string['purgecachespage'] = 'Limpar caches';
$string['purgecoursecache'] = 'Disciplinas';
$string['purgefiltercache'] = 'Filtros de texto';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Strings de idioma';
$string['purgemuc'] = 'Todas as caches MUC';
$string['purgeothercaches'] = 'Todos os ficheiros e caches diversas';
$string['purgeselectedcaches'] = 'Limpar caches específicas';
$string['purgeselectedcachesfinished'] = 'As caches selecionadas foram esvaziadas.';
$string['purgetemplates'] = 'Modelos';
$string['purgethemecache'] = 'Temas';
$string['query'] = 'Pesquisa';
$string['question'] = 'Pergunta';
$string['questionbehaviours'] = 'Comportamentos das perguntas';
$string['questioncwqpfscheck'] = 'Uma ou mais perguntas \'aleatórias\' num teste foram configuradas para selecionar perguntas de uma mistura de categorias partilhadas e não partilhadas. Consulte o <a href="{$a->reporturl}">relatório das perguntas aleatórias</a> e a respetiva <a href="{$a->docsurl}">documentação</a>.';
$string['questioncwqpfsok'] = 'Não existem nos seus testes perguntas aleatórias configuradas para selecionar perguntas de uma mistura de categorias partilhadas e não partilhadas.';
$string['questiontype'] = 'Tipo de pergunta';
$string['questiontypes'] = 'Tipos de perguntas';
$string['quizattemptsupgradedmessage'] = 'No Moodle 2.1 houve uma grande atualização para as perguntas do teste. Foi possível atrasar partes da atualização da base de dados a serem executadas mais tarde. Deve concluir essa atualização antes de atualizar para o Moodle 2.7';
$string['recaptchaprivatekey'] = 'Chave secreta do reCAPTCHA';
$string['recaptchapublickey'] = 'Chave de site do reCAPTCHA';
$string['referrernone'] = 'Predefinição do navegador';
$string['referrerpolicy'] = 'Política de referência';
$string['referrerpolicydesc'] = 'Defina o cabeçalho da política de referência a ser incluído nas respostas do seu site.';
$string['register'] = 'Registe o seu site';
$string['registration'] = 'Registo';
$string['registration_help'] = 'Ao registar o seu site:

* Receberá alertas de segurança
* Pode ativar o envio de notificações móveis a partir do seu site
* Está a contribuir para as nossas estatísticas Moodle da comunidade mundial';
$string['registrationwarning'] = 'Não perca atualizações importantes e alertas de segurança.';
$string['registrationwarningcontactadmin'] = 'Este site ainda não está registado. Peça ao seu administrador para registar o site para que não perca atualizações importantes.';
$string['releasenoteslink'] = 'Para mais informações sobre esta versão do Moodle, consulte as <a target="_blank" href="{$a}">Notas de Lançamento</a>';
$string['rememberuserlicensepref'] = 'Lembrar a preferência de licença do utilizador';
$string['rememberuserlicensepref_help'] = 'Se ativar esta opção, a última licença selecionada pelo utilizador é pré-selecionada ao carregar um ficheiro no seletor de ficheiros. Caso contrário, a licença predefinida do site será pré-selecionada.';
$string['rememberusername'] = 'Lembrar nome de utilizador';
$string['rememberusername_desc'] = 'Permite que sejam guardados cookies permanentes com os nomes de utilizador durante a autenticação do utilizador. Os cookies permanentes podem ser considerados abusivos em termos de privacidade se usados sem consentimento.';
$string['replacefrontsearch'] = 'Usado para pesquisa de disciplinas na página inicial';
$string['reportsmanage'] = 'Gerir relatórios';
$string['required'] = 'Obrigatório';
$string['requiredentrieschanged'] = 'IMPORTANTE: Após a atualização, a configuração \'Registos obrigatórios antes de ser permitida a visualização\' é obrigatória nas seguintes atividades da base de dados:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Forçar descrição da atividade';
$string['requiremodintro_desc'] = 'Se ativar esta opção, os utilizadores serão obrigados a indicar uma descrição na configuração de cada atividade.';
$string['requires'] = 'Requer';
$string['resetindentation'] = 'Repor indentação para todo o site';
$string['resetindentation_help'] = 'Irá remover qualquer indentação anteriormente definida para todas as disciplina do site em {$a->format}.';
$string['resetindentation_title'] = 'Repor indentação para todo o site?';
$string['resetindentationsuccess'] = 'Indentação reposta.';
$string['restorecourse'] = 'Restaurar disciplina';
$string['restorernewroleid'] = 'Papel a atribuir ao restaurador na disciplina';
$string['restorernewroleid_help'] = 'Se o utilizador não tiver permissão para gerir a disciplina que acabou de restaurar, este papel é automaticamente atribuído ao utilizador e é inscrito na disciplina, se necessário. Selecione "Nenhum" se não pretender que os restauradores possam gerir as disciplinas restauradas.';
$string['resultfilter'] = 'Filtrar por resultado';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignorar reverse proxies';
$string['riskconfig'] = 'Os utilizadores poderiam alterar a configuração e comportamento do site';
$string['riskconfigshort'] = 'Risco de configuração';
$string['riskdataloss'] = 'Os utilizadores podem apagar grandes quantidades de informação e conteúdos';
$string['riskdatalossshort'] = 'Risco de perda de informação';
$string['riskmanagetrust'] = 'Os utilizadores poderiam alterar as definições de conteúdo fiável de outros utilizadores';
$string['riskmanagetrustshort'] = 'Gerir fiáveis';
$string['riskpersonal'] = 'Os utilizadores poderiam ter acesso a informação privada de outros utilizadores';
$string['riskpersonalshort'] = 'Risco de privacidade';
$string['riskspam'] = 'Os utilizadores poderiam enviar spam a outros utilizadores do site ou outros';
$string['riskspamshort'] = 'Risco de Spam';
$string['riskxss'] = 'Os utilizadores poderiam adicionar ficheiros e textos que permitam "cross-site scripting" (XSS)';
$string['riskxssshort'] = 'Risco XSS';
$string['roleswithexceptions'] = '{$a->roles} com {$a->exceptions}';
$string['rssglobaldisabled'] = 'Desativado ao nível do site';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar alterações';
$string['scssinvalid'] = 'O código SCSS não é válido, falha: {$a}';
$string['search'] = 'Pesquisar';
$string['searchablecourses'] = 'Disciplinas pesquisáveis';
$string['searchallavailablecourses'] = 'Disciplinas pesquisáveis';
$string['searchallavailablecourses_desc'] = 'Em algumas situações, o mecanismo de busca pode não funcionar corretamente ao pesquisar num grande número de disciplinas. Defina para pesquisar apenas as disciplinas inscritas, se precisar de restringir o número de disciplinas a pesquisar.';
$string['searchallavailablecourses_off'] = 'Pesquisar apenas nas disciplinas inscritas';
$string['searchallavailablecourses_on'] = 'Pesquisar em todas as disciplinas que o utilizador pode aceder';
$string['searchallavailablecoursesdesc'] = 'Se definido para pesquisar apenas em disciplinas inscritas, as informações da disciplina (nome e descrição) e o conteúdo da disciplina serão pesquisadas apenas nas disciplinas em que o utilizador está inscrito. Caso contrário, as informações da disciplina e o conteúdo da disciplina serão pesquisadas em todos as disciplinas que o utilizador pode aceder, como por exemplo, disciplinas com acesso de visitante ativo.';
$string['searchalldeleted'] = 'Todos os conteúdos indexados foram apagados';
$string['searchalternatesettings'] = 'Configurações alternativas da pesquisa apenas para consultas';
$string['searchalternatesettings_desc'] = 'Se concluir estas configurações, poderá selecionar \'configurações alternativas\' para este mecanismo de pesquisa na opção de mecanismo de pesquisa apenas para consultas na página \'Gerir pesquisa global\'. Apenas é útil se alternar entre dois motores de busca do mesmo tipo.';
$string['searchareadisabled'] = 'Área de pesquisa desativada';
$string['searchareaenabled'] = 'Área de pesquisa ativada';
$string['searchareas'] = 'Áreas de pesquisa';
$string['searchbanner'] = 'Informações da pesquisa';
$string['searchbannerenable'] = 'Exibir informações da pesquisa';
$string['searchbannerenable_desc'] = 'Se ativar esta opção, o texto abaixo será exibido no topo do ecrã da pesquisa para todos os utilizadores. Pode ser usado para informar os utilizadores quando está a ser realizada a manutenção no sistema de pesquisa.';
$string['searchdefaultcategory'] = 'Categoria de pesquisa predefinida';
$string['searchdefaultcategory_desc'] = 'Os resultados da categoria da área de pesquisa selecionada serão mostrados por predefinição.';
$string['searchdeleteindex'] = 'Apagar todos os conteúdos indexados';
$string['searchdisplay'] = 'Opções da exibição dos resultados da pesquisa';
$string['searchenablecategories'] = 'Mostrar resultados em categorias separadas';
$string['searchenablecategories_desc'] = 'Se ativar esta opção, os resultados da pesquisa serão mostrados em categorias separadas.';
$string['searchengine'] = 'Motor de busca';
$string['searchenginealternatesettings'] = '{$a} (configurações alternativas)';
$string['searchenginequeryonly'] = 'Motor de pesquisa apenas para consultas';
$string['searchenginequeryonly_desc'] = 'Este mecanismo de pesquisa será usado apenas para fazer consultas, não para indexar. Ao usar esta funcionalidade, pode reindexar num mecanismo de pesquisa diferente, enquanto as consultas do utilizador continuam a funcionar a partir deste.';
$string['searchenginequeryonly_none'] = 'Nenhum (usar o mecanismo de pesquisa principal para as consultas)';
$string['searchenginequeryonlysame'] = 'O mecanismo de pesquisa apenas para consultas e o mecanismo de pesquisa principal não podem ser definidos com o mesmo valor.';
$string['searchhideallcategory'] = 'Ocultar categoria \'Todos os resultados\'';
$string['searchhideallcategory_desc'] = 'Se ativada, a categoria com todos os resultados estará oculta na janela dos resultados da pesquisa.';
$string['searchincludeallcourses'] = 'Incluir todas as disciplinas visíveis';
$string['searchincludeallcourses_desc'] = 'Se ativar esta opção, os resultados da pesquisa incluirão informações das disciplinas (nome e descrição) visíveis para o utilizador, mesmo que não tenha acesso ao conteúdo da disciplina.';
$string['searchindexactions'] = 'Ações no índice';
$string['searchindexdeleted'] = 'Índice apagado';
$string['searchindextime'] = 'Limite de tempo de indexação';
$string['searchindextime_desc'] = 'Ao indexar grandes quantidades de novos conteúdos, a tarefa agendada irá parar depois de atingido este limite de tempo. Continuará na próxima vez que a tarefa for executada.';
$string['searchindexupdated'] = 'Os conteúdos do motor de busca foram atualizados';
$string['searchindexwhendisabled'] = 'Indexar quando desativada';
$string['searchindexwhendisabled_desc'] = 'Permite que a tarefa agendada crie o índice de pesquisa mesmo quando a pesquisa está desativada. É útil se pretende criar o índice antes que a funcionalidade de pesquisa seja mostrada aos alunos.';
$string['searchinsettings'] = 'Pesquisar nas configurações';
$string['searchlastrun'] = 'Última execução (tempo, # documentos, # registos, # ignorados)';
$string['searchmanagement'] = 'Gestão da pesquisa';
$string['searchmanagement_desc'] = 'Estas opções são úteis quando se pretende fazer alterações em sites com índices de pesquisa muito grandes que levam muito tempo para reconstruir.';
$string['searchmaxtopresults'] = 'Máximo de melhores resultados';
$string['searchmaxtopresults_desc'] = 'O número máximo de melhores resultados a serem exibidos acima dos resultados da pesquisa do conteúdo da disciplina, disciplinas e utilizadores.';
$string['searchnotavailable'] = 'A pesquisa não está disponível';
$string['searchoptions'] = 'Opções de pesquisa';
$string['searchpartial'] = '(ainda não totalmente indexado)';
$string['searchreindexed'] = 'Todos os conteúdos do site foram novamente indexados.';
$string['searchreindexindex'] = 'Reindexar todos os conteúdos do site';
$string['searchresults'] = 'Resultados da pesquisa';
$string['searchsetupinfo'] = 'Configurações da pesquisa';
$string['searchteacherroles'] = 'Papéis do professor';
$string['searchteacherroles_desc'] = 'Selecione todos os papéis que tornam os utilizadores com papel superior nos resultados da pesquisa.';
$string['searchtopresults'] = 'Melhores resultados';
$string['searchupdateindex'] = 'Atualizar conteúdos indexados';
$string['sectionerror'] = 'Erro na secção!';
$string['secureforms'] = 'Usar segurança adicional de formulários';
$string['security'] = 'Segurança';
$string['selectsearchengine'] = 'Selecionar motor de busca';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Verificações do servidor';
$string['serverlimit'] = 'Limite de servidor';
$string['servicespage'] = 'Hiperligação para serviços e suporte';
$string['sessionautostartwarning'] = '<p>Foi detetado um erro de configuração grave. Por favor, contacte o administrador do servidor.</p><p> Para funcionar corretamente, o Moodle requer que o administrador modifique as configurações do PHP.</p><p><code>session.auto_start</code> tem de ser configurado como <code>off</code>.</p><p>Esta configuração é modificada editando o ficheiro <code>php.ini</code> ou o ficheiro <code>.htaccess</code> no servidor.</p>';
$string['sessioncookie'] = 'Sufixo dos cookies';
$string['sessioncookiedomain'] = 'Domínio dos cookies';
$string['sessioncookiepath'] = 'Caminho para os cookies';
$string['sessionhandling'] = 'Sessões';
$string['sessiontimeout'] = 'Tempo limite da sessão';
$string['sessiontimeoutwarning'] = 'Aviso de fim de sessão';
$string['settingdependenton'] = 'Esta configuração pode estar oculta, com base no valor da permissão <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'O carregamento de ficheiros é obrigatório para um funcionamento normal. Por favor, ative-o na configuração do PHP.';
$string['settingmaxinputvars'] = 'É recomendado que a configuração de max_input_vars do PHP seja de pelo menos 5000.';
$string['settingmaxinputvarsrequired'] = 'A configuração max_input_vars do PHP tem de ser pelo menos 5000.';
$string['settingmemorylimit'] = 'A memória detetada é insuficiente. Por favor, aumente o valor deste limite na configuração do PHP.';
$string['settingsafemode'] = 'O Moodle não é completamente compatível com o PHP em <strong>Safe mode</strong>. Por favor, peça ao administrador do servidor para o desativar. Não é possível usar o Moodle com o PHP em <strong>Safe mode</strong>. Vários problemas podem ocorrer se o fizer.';
$string['settingzendexceptionignoreargs'] = 'É altamente recomendado que a configuração PHP zend.exception_ignore_args seja ativada como precaução de segurança.';
$string['setupsearchengine'] = 'Configurar motor de busca';
$string['showcommentscount'] = 'Mostrar número total de comentários';
$string['showdetails'] = 'Mostrar detalhes';
$string['showuseridentity'] = 'Mostrar identidade do utilizador';
$string['showuseridentity_desc'] = 'Quando seleciona ou procura utilizadores (quando é mostrada a lista de utilizadores), estes campos podem ser exibidos juntamente com o nome completo. Estes campos apenas são exibidos aos utilizadores que têm a permissão \'moodle/site:viewuseridentity\'. Por predefinição, apenas os professores e gestores têm esta permissão. (Esta opção é útil para especificar um ou mais campos que são obrigatórios na sua instituição.)

Os campos assinalados com * são campos de perfil do utilizador personalizados. Pode selecionar estes campos mas atualmente eles não aparecerão em alguns ecrãs.';
$string['simplexmlrequired'] = 'A extensão SimpleXML do PHP é necessária para o funcionamento do Moodle.';
$string['sitemailcharset'] = 'Conjunto de caracteres';
$string['sitemaintenance'] = 'O site está em manutenção e não está disponível de momento';
$string['sitemaintenancemode'] = 'Modo de manutenção';
$string['sitemaintenanceoff'] = 'O modo de manutenção foi desativado e o site está novamente operacional';
$string['sitemaintenanceon'] = 'De momento, o site está em manutenção (apenas os administradores poderão se autenticar e utilizar o site)';
$string['sitemaintenanceoncli'] = 'O seu site está atualmente em modo de manutenção CLI. Não é permitido qualquer acesso via web.';
$string['sitemaintenancetitle'] = '{$a} está em manutenção';
$string['sitemaintenancewarning'] = 'De momento, o seu site está em modo de manutenção (apenas os administradores podem-se autenticar). Para que o site volte a estar operacional, <a href="maintenance.php">desative o modo de manutenção</a>.';
$string['sitemaintenancewarning2'] = 'O site está atualmente em modo de manutenção (apenas os administradores têm acesso). Para colocar o site em modo normal de funcionamento clique em <a href="{$a}">Desativar modo de manutenção</a>.';
$string['sitemenubar'] = 'Navegação do Site';
$string['sitenameintitle'] = 'Incluir nome do site no título da página';
$string['sitenameintitle_help'] = 'O nome do site será acrescentado no final do título da página. É recomendado incluir o nome do site no título da página, pois assim melhorará a acessibilidade do site, permitindo que os utilizadores identifiquem rapidamente a página onde estão atualmente.';
$string['sitepolicies'] = 'Configurações de segurança do site';
$string['sitepolicy'] = 'URL da política do site';
$string['sitepolicy_help'] = 'URL da política do site que todos os utilizadores registados têm de consultar e concordar antes de acederem ao site. Tenha em atenção que esta configuração apenas terá efeito se o \'Controlador de políticas do site\' estiver definido como \'Predefinido (core)\'';
$string['sitepolicyguest'] = 'URL da política do site para visitantes';
$string['sitepolicyguest_help'] = 'O URL da política do site que todos os visitantes têm de consultar e concordar antes de acederem ao site. Tenha em atenção que esta configuração apenas terá efeito se o \'Controlador de políticas do site\' estiver definido como \'Predefinido (core)\'';
$string['sitepolicyhandler'] = 'Controlador de políticas do site';
$string['sitepolicyhandler_desc'] = 'Esta opção determina como são geridas as políticas do site e consentimentos do utilizador. O controlador de políticas Predefinido (core) permite definir um URL para a política do site e um URL para a política do site para visitantes. O controlador de políticas permite que sejam definidas políticas para o site, para a privacidade e outras políticas. Também permite que os consentimentos dos utilizadores sejam visualizados e, se necessário, que seja dado consentimento em nome de menores.';
$string['sitepolicyhandlercore'] = 'Predefinido (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Mostra uma secção na parte superior da página onde pode adicionar conteúdo personalizado.';
$string['sixtyfourbitsrequired'] = 'Foi detetado que o seu site não está a usar uma versão PHP de 64 bits. É obrigatória a atualização do seu sistema (sistema operactivo, PHP...) antes de instalar esta versão do Moodle.';
$string['sixtyfourbitswarning'] = 'Foi detetado que seu site não está a usar uma versão do PHP de 64 bits. Recomenda-se que atualize o seu site para garantir compatibilidade futura.';
$string['slasharguments'] = 'Usar slash arguments';
$string['slashargumentswarning'] = 'É recomendado que ative o uso dos \'slash arguments\'. No futuro será obrigatório. Para mais detalhes, consulte a documentação <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smallscreensonly'] = 'Apenas ecrãs pequenos';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Tipo de autenticação SMTP';
$string['smtpdetail'] = 'Configurações SMTP (Simple Mail Transfer Protocol) para enviar e-mails';
$string['smtphosts'] = 'Servidores SMTP';
$string['smtpmaxbulk'] = 'Limite de sessão SMTP';
$string['smtppass'] = 'Senha SMTP';
$string['smtpsecure'] = 'Segurança SMTP';
$string['smtpuser'] = 'Nome de utilizador SMTP';
$string['soaprecommended'] = 'A instalação da extensão opcional SOAP é útil para web services e para alguns módulos.';
$string['sort_fullname'] = 'Nome completo da disciplina';
$string['sort_idnumber'] = 'ID da disciplina';
$string['sort_shortname'] = 'Nome curto da disciplina';
$string['sort_sortorder'] = 'Ordenação predefinida';
$string['spellengine'] = 'Motor de verificação ortográfica';
$string['spelllanguagelist'] = 'Formar lista de linguas';
$string['splrequired'] = 'A extensão SPL do PHP é obrigatória para o funcionamento do Moodle.';
$string['stats'] = 'Estatísticas';
$string['statsfirstrun'] = 'Intervalo máximo de processamento';
$string['statsmaxruntime'] = 'Tempo máximo de execução';
$string['statsmoodleorg'] = 'estatísticas';
$string['statsruntimedays'] = 'Dias para processamento';
$string['statsruntimestart'] = 'Horário de execução';
$string['statsuserthreshold'] = 'Limite de utilizadores';
$string['stickyblocks'] = 'Blocos Persistentes';
$string['stickyblockscourseview'] = 'Página da Disciplina';
$string['stickyblocksduplicatenotice'] = 'Se adicionar aqui um bloco que já está presente nalguma página em particular, irá resultar numa duplicação. <br />Apenas o bloco fixado não será editável. O duplicado continuará a ser editável.';
$string['stickyblocksmymoodle'] = 'Minha página principal';
$string['stickyblockspagetype'] = 'Tipo de página a configurar';
$string['storedprogressbarcleanuptask'] = 'Tarefa de limpeza da barra de progresso armazenada';
$string['strictformsrequired'] = 'Validação estrita de campos obrigatórios';
$string['stripalltitletags'] = 'Apagar as tags HTML do nome das atividades e recursos';
$string['supportandservices'] = 'Suporte e serviços';
$string['supportavailability'] = 'Disponibilidade do suporte';
$string['supportcontact'] = 'Contacto para pedidos de ajuda';
$string['supportemail'] = 'E-mail do responsável pelo apoio aos utilizadores';
$string['supportemailsubject'] = 'Pedido de suporte do site - {$a}';
$string['supportname'] = 'Nome do responsável pelo apoio aos utilizadores';
$string['supportpage'] = 'Hiperligação para contactar suporte do site';
$string['suspenduser'] = 'Suspender conta do utilizador';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = 'Alterar pasta do idioma';
$string['systempaths'] = 'Caminhos do sistema';
$string['tablenosave'] = 'As alterações feitas na tabela acima são guardadas automaticamente.';
$string['tablesnosave'] = 'Mudanças feitas nas tabelas acima são guardadas automaticamente.';
$string['tabselectedtofront'] = 'Em tabelas com separadores, devem as linhas com o separador selecionado ser colocadas à frente';
$string['tabselectedtofronttext'] = 'Trazer a linha de separador selecionada para a frente';
$string['task_adhoc_concurrency_limit'] = 'Tarefas ad hoc em simultâneo';
$string['task_adhoc_concurrency_limit_desc'] = 'O número máximo permitido de tarefas ad hoc com execução em simultâneo. Se o limite for alto, as tarefas agendadas poderão não ser executadas regularmente quando houver muitas tarefas ad hoc. Uma configuração de 0 desativará completamente o processamento de tarefas ad hoc.';
$string['task_adhoc_failed_retention'] = 'Período de retenção da tarefa ad hoc falhada';
$string['task_adhoc_failed_retention_desc'] = 'O período máximo em que as tarefas ad hoc falhadas devem permanecer na fila depois de atingirem o limite de novas tentativas.';
$string['task_adhoc_max_runtime'] = 'Validade da tarefa ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'Prazo para execução da tarefa ad hoc antes de ser dispensada. É recomendada uma durabilidade baixa, pois não há limite para o número de tarefas ad hoc em fila. Se este número for muito alto e tiver uma fila grande de tarefas ad hoc, as tarefas agendadas poderão não ser executadas regularmente.';
$string['task_dbreads'] = 'Leituras da base de dados';
$string['task_dbstats'] = 'Base de dados';
$string['task_dbwrites'] = 'Escritas na base de dados';
$string['task_duration'] = 'Duração';
$string['task_endtime'] = 'Data/hora de fim';
$string['task_logmode'] = 'Quando registar';
$string['task_logmode_all'] = 'Armazenar os registos de todos os trabalhos';
$string['task_logmode_desc'] = 'Pode escolher quando pretende que ocorra o registo da execução das tarefas. Por predefinição, são sempre registados. Pode desativar completamente o registo ou alterar para apenas registar as tarefas que falharam.';
$string['task_logmode_failonly'] = 'Armazenar apenas registos dos trabalhos que falharam';
$string['task_logmode_none'] = 'Não registar nada';
$string['task_logoutput'] = 'Resultado da tarefa';
$string['task_logretainruns'] = 'Execuções a reter';
$string['task_logretainruns_desc'] = 'O número de execuções de cada tarefa a ser retido. Esta configuração interage com a configuração "Período de retenção": será aplicado o primeiro a ser atingido.';
$string['task_logretention'] = 'Período de retenção';
$string['task_logretention_desc'] = 'O período máximo que os registos devem ser mantidos. Esta configuração interage com a configuração \'Execuções a reter\': será aplicado o primeiro a ser atingido.';
$string['task_logtostdout'] = 'Mostrar registo da execução';
$string['task_logtostdout_desc'] = 'Quando os trabalhos estão a ser executados e é efetuado o registo da execução, os registos efetuados devem ser mostrados, ou não, à medida que a tarefa é executada.';
$string['task_result'] = 'Resultado';
$string['task_result:failed'] = 'Falha na execução';
$string['task_scheduled_concurrency_limit'] = 'Limite de tarefas agendadas em simultâneo';
$string['task_scheduled_concurrency_limit_desc'] = 'O número de execuções de tarefas agendadas que podem ocorrer simultaneamente. Se o limite for alto, o servidor poderá sofrer uma sobrecarga, o que irá afetar o desempenho. Uma configuração de 0 desativará completamente o processamento de tarefas agendadas.';
$string['task_scheduled_max_runtime'] = 'Validade da tarefa agendada';
$string['task_scheduled_max_runtime_desc'] = 'Prazo para execução da tarefa agendada antes de ser dispensada.';
$string['task_starttime'] = 'Hora de início';
$string['task_stats:dbreads'] = '{$a} lidas';
$string['task_stats:dbwrites'] = '{$a} escritas';
$string['task_status'] = 'Estado da tarefa';
$string['task_status_desc'] = 'Estado da tarefa \'{$a->name}\': {$a->status}. Para mais detalhes, consulte {$a->class}{$a->extradescription} em <a href="{$a->gotourl}">Tarefas agendadas</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Agendada';
$string['taskadmintitle'] = 'Tarefas';
$string['taskanalyticscleanup'] = 'Limpeza da Analítica';
$string['taskautomatedbackup'] = 'Realização de cópias de segurança automáticas';
$string['taskautomatedbackup_report'] = 'Relatório de cópias de segurança automáticas';
$string['taskbackupcleanup'] = 'Limpeza de tabelas, ficheiros e registos de cópias de segurança';
$string['taskbadgesadhoc'] = 'Atribuir medalha';
$string['taskbadgescron'] = 'Adicionar tarefas ad hoc de atribuição de medalhas';
$string['taskbadgesmessagecron'] = 'Processamento em segundo plano do envio de notificações de medalhas';
$string['taskblogcron'] = 'Sincronização de blogues externos';
$string['taskcachecleanup'] = 'Remoção de entradas de cache expiradas';
$string['taskcachecron'] = 'Processamento das caches';
$string['taskcalendarcron'] = 'Envio de notificações de calendário';
$string['taskcheckforupdates'] = 'Verificação de atualizações';
$string['taskcompletiondaily'] = 'Sinalização da conclusão como iniciada';
$string['taskcompletionregular'] = 'Cálculo dos dados da conclusão regular';
$string['taskcontextcleanup'] = 'Limpeza de contextos';
$string['taskcreatecontexts'] = 'Criação de contextos em falta';
$string['taskdeleteincompleteusers'] = 'Eliminação de utilizadores incompletos';
$string['taskdeleteunconfirmedusers'] = 'Eliminação de utilizadores não confirmados';
$string['taskeventscron'] = 'A processar eventos...';
$string['taskfiletrashcleanup'] = 'Limpeza dos ficheiros enviados para o lixo';
$string['taskglobalsearchindex'] = 'Indexação da pesquisa global';
$string['taskglobalsearchoptimize'] = 'Otimização do índice da pesquisa global';
$string['taskgradecron'] = 'Processamento em segundo plano da pauta';
$string['taskgradehistorycleanup'] = 'Processamento em segundo plano da limpeza das tabelas do histórico das notas';
$string['taskh5pcleanup'] = 'Limpeza de ficheiros H5P não utilizados';
$string['tasklegacycron'] = 'Processamento do cron de retrocompatibilidade dos módulos';
$string['tasklockcleanuptask'] = 'Limpeza de metadados da tarefas ad hoc';
$string['tasklogcleanup'] = 'Limpeza dos registos das tarefas';
$string['tasklogging'] = 'Configuração do registo das tarefas';
$string['tasklogs'] = 'Registos das tarefas';
$string['taskmessagingcleanup'] = 'Processamento das mensagens';
$string['taskpasswordresetcleanup'] = 'Limpeza das tentativas de reposição de senha';
$string['taskplagiarismcron'] = 'Processamento em segundo plano de módulos de antiplágio';
$string['taskportfoliocron'] = 'Processamento dos módulos de portfólio';
$string['taskprocessing'] = 'Processamento de tarefas';
$string['taskquestioncron'] = 'Processamento em segundo plano da limpeza das pré-visualizações de perguntas';
$string['taskquestionstatscleanupcron'] = 'Limpeza em segundo plano da cache das estatísticas das perguntas';
$string['taskrefreshsystemtokens'] = 'Atualização de tokens OAuth para contas de serviço';
$string['taskregistrationcron'] = 'Registo do site';
$string['tasksendfailedloginnotifications'] = 'Envio de notificações de tentativas de autenticação falhadas';
$string['tasksendnewuserpasswords'] = 'Envio de senhas de novos utilizadores';
$string['tasksessioncleanup'] = 'Limpeza de sessões antigas';
$string['taskstatscron'] = 'Processamento das estatísticas';
$string['tasktagcron'] = 'Processamento das palavras-chave';
$string['tasktempfilecleanup'] = 'Eliminação de ficheiros temporários obsoletos';
$string['tasktype'] = 'Tipo';
$string['taskupdategeoip2file'] = 'Atualizar ficheiro GeoIP';
$string['tempdatafoldercleanup'] = 'Limpar ficheiros de dados temporários anteriores a';
$string['templates'] = 'Modelos';
$string['testoutgoingmailconf'] = 'Testar configuração do envio de e-mails';
$string['testoutgoingmailconf_errorcommunications'] = 'O seu site não conseguiu comunicar com o seu servidor de e-mail. Por favor, verifique a configuração do envio de e-mails.';
$string['testoutgoingmailconf_fromemail'] = 'De nome de utilizador ou endereço de e-mail';
$string['testoutgoingmailconf_fromemail_help'] = 'Este campo emula o envio da mensagem daquele utilizador, mas o cabeçalho De usado no e-mail real enviado dependerá de outras configurações, como \'allowedemaildomains\'';
$string['testoutgoingmailconf_fromemail_invalid'] = 'O campo \'De\' contém um nome de utilizador ou e-mail inválido. Tem de ser um formato de e-mail válido ou um nome de utilizador existente no Moodle.';
$string['testoutgoingmailconf_message'] = 'Esta mensagem é um teste para confirmar que configurou com sucesso o envio de e-mails a partir do seu site.
Enviada: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Enviar mensagem de teste';
$string['testoutgoingmailconf_sentmail'] = 'O site entregou com sucesso a mensagem de teste ao servidor de e-mail.<br />De: {$a->fromemail}<br />Para: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: mensagem de teste. {$a->additional} Enviada: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Assunto adicional';
$string['testoutgoingmailconf_toemail'] = 'E-mail do destinatário';
$string['testoutgoingmaildetail'] = 'Atenção: Antes de testar, por favor, guarde a sua configuração.<br />{$a}';
$string['testsiteupgradewarning'] = 'Atualmente está a usar o site de teste {$a}, para o atualizar corretamente use a ferramenta de interface de linha de comando';
$string['themedefinedinconfigphp'] = 'O tema não pode ser alterado porque está definido para {$a} no config.php.';
$string['themedesignermode'] = 'Modo de desenho do tema';
$string['themedesignermodewarning'] = 'O modo de desenho do tema está ativo. Não deve ser ativado em sites em produção porque pode reduzir significativamente o desempenho.';
$string['themeeditsettingsname'] = 'Alterar configurações do tema \'{$a}\'';
$string['themelist'] = 'Lista de temas';
$string['themeresetcaches'] = 'Esvaziar cache dos temas';
$string['themeselect'] = 'Selecionar tema';
$string['themeselector'] = 'Temas';
$string['themesettingsadvanced'] = 'Configurações avançadas do tema';
$string['themesettingscustom'] = 'Configurações personalizadas do tema';
$string['themesettingsname'] = 'Configurações do tema \'{$a}\'';
$string['themeusagereportname'] = 'Relatório da utilização do tema \'{$a}\'';
$string['therewereerrors'] = 'Foram encontrados erros nos seus dados';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Localização';
$string['thirdpartylibs'] = 'Bibliotecas externas';
$string['timezone'] = 'Fuso horário predefinido';
$string['timezoneforced'] = 'Forçado pelo administrador do site';
$string['timezoneinvalid'] = 'Fuso horário inválido "{$a}"';
$string['timezoneisforcedto'] = 'Forçar todos os utilizadores a usar';
$string['timezonenotforced'] = 'Os utilizadores podem definir o seu fuso horário';
$string['timezonephpdefault'] = 'Fuso horário PHP predefinido ({$a})';
$string['timezoneserver'] = 'Fuso horário do servidor ({$a})';
$string['tlswarning'] = 'Não foi detetada nenhuma extensão PHP/cURL com suporte para TLSv1.2. Alguns serviços poderão não funcionar. É altamente recomendada a atualização das suas bibliotecas TLS.';
$string['tokenduration'] = 'Duração do token criado pelo utilizador';
$string['tokenduration_desc'] = 'Intervalo de tempo durante o qual um token de web services criado por um utilizador (por exemplo, via Aplicação móvel Moodle) é válido.';
$string['tokenizerrecommended'] = 'Para melhorar a funcionalidade da Rede Moodle é recomendada a instalação da extensão Tokenizer do PHP.';
$string['tools'] = 'Ferramentas de administração';
$string['toolsmanage'] = 'Gerir ferramentas de administração';
$string['unattendedoperation'] = 'Execução não interativa';
$string['unbookmarkthispage'] = 'Apagar esta página dos marcadores';
$string['unicoderequired'] = 'Todos os dados devem ser armazenados na codificação Unicode (UTF-8). Para novas instalações, a base de dados tem de usar UTF-8 como conjunto de caracteres padrão. Se estiver a atualizar, deve realizar o processo de migração para UTF-8 .';
$string['uninstallplugin'] = 'Desinstalar';
$string['unlockaccount'] = 'Desbloquear conta';
$string['unoconvwarning'] = 'A versão do unoconv instalada não é suportada.';
$string['unsupported'] = 'Não suportado';
$string['unsupporteddbfileformat'] = 'A sua base de dados utiliza o formato de ficheiro Antelope. O suporte total ao UTF-8 no MySQL e MariaDB requer o formato de ficheiros Barracuda. Por favor, converta as tabelas para o formato de ficheiros Barracuda. Para mais detalhes, consulte a documentação sobre o <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">suporte total ao unicode no MySQL</a>.';
$string['unsupporteddbfilepertable'] = 'Para suporte total ao UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_file_per_table\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddblargeprefix'] = 'Para suporte total do UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_large_prefix\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddbstorageengine'] = 'O \'storage engine\' da base de dados usado deixou de ser suportado.';
$string['unsupporteddbtablerowformat'] = 'Na sua base de dados existem tabelas que usam o formato de ficheiro Antelope. É recomendado que converta as tabelas para o formato de ficheiro Barracuda. Para mais informações acerca de ferramentas de conversão de tabelas InnoDB para Barracuda, consulte a documentação sobre <a href="https://docs.moodle.org/en/cli">Administração via linha de comandos</a>.';
$string['unsupportedphpversion7'] = 'Versão 7 e superior do PHP não é suportada.';
$string['unsupportedphpversion71'] = 'Versão 7.1 e superior do PHP não é suportada.';
$string['unsupportedphpversion72'] = 'Versão 7.2 e superior do PHP não é suportada.';
$string['unsupportedphpversion73'] = 'Versão 7.3 e superior do PHP não é suportada.';
$string['unsupportedphpversion74'] = 'Versão 7.4 e superior do PHP não é suportada.';
$string['unsupportedphpversion80'] = 'Versão 8 e superior do PHP não é suportada.';
$string['unsupportedphpversion81'] = 'Versão 8.1 e superior do PHP não é suportada.';
$string['unsupportedphpversion82'] = 'Versão 8.2 e superiores do PHP não são suportadas.';
$string['unsupportedphpversion83'] = 'Versão 8.3 e superiores do PHP não são suportadas.';
$string['unsupportedphpversion84'] = 'As versões 8.4 e superiores do PHP não são suportadas.';
$string['unsuspenduser'] = 'Ativar contas de utilizadores';
$string['updateaccounts'] = 'Atualizar contas existentes';
$string['updateautocheck'] = 'Verificar atualizações automaticamente';
$string['updateautocheck_desc'] = 'Se ativar esta opção, o seu Moodle irá automaticamente pesquisar por atualizações para o código Moodle e para os módulos instalados. Se existirem atualizações disponíveis, será enviada uma notificação ao administrador do site.';
$string['updateavailable'] = 'Está disponível uma versão mais recente do Moodle!';
$string['updateavailable_moreinfo'] = 'Mais info…';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versão {$a}';
$string['updateavailabledetailslink'] = 'Visite {$a->url} para mais detalhes.';
$string['updateavailableforplugin'] = 'Está disponível uma versão mais recente de alguns módulos instalados!';
$string['updateavailableinstall'] = 'Instalar agora esta atualização';
$string['updateavailableinstallall'] = 'Instalar as atualizações disponíveis ({$a})';
$string['updateavailableinstallallhead'] = 'A instalar as atualizações disponíveis';
$string['updateavailablenot'] = 'O código do seu Moodle está atualizado!';
$string['updateavailablerecommendation'] = 'É altamente recomendado que atualize o seu site para a versão mais recente para resolver todas as falhas de segurança.';
$string['updatecomponent'] = 'Atualizar informação';
$string['updateminmaturity'] = 'Maturidade exigida do código';
$string['updateminmaturity_desc'] = 'Notificar a existência de atualizações disponíveis apenas se o código disponível tem, pelo menos, o nível de maturidade selecionado. As atualizações dos módulos que não especificam o seu nível de maturidade do código são sempre notificadas independentemente desta configuração.';
$string['updatenotificationfooter'] = 'O seu site Moodle \'{$a->siteurl}\' está configurado para verificar automaticamente se existem atualizações disponíveis. Está a receber esta mensagem por ser administrador do site. Pode desativar as verificações automáticas de atualizações disponíveis em "Administração do Site / Servidor / Notificação de atualizações" ou pode personalizar a entrega desta mensagem através da sua página de preferências.';
$string['updatenotifications'] = 'Notificação de atualizações';
$string['updatenotificationsubject'] = 'Existem atualizações disponíveis para o seu Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificar sobre novas \'builds\'';
$string['updatenotifybuilds_desc'] = 'Se ativar esta opção, a disponibilidade de novas \'builds\' para a versão atual do Moodle também será notificada. \'Builds\' são melhorias contínuas de uma versão do Moodle. Geralmente são lançadas com periodicidade semanal. Se desativar esta opção, será notificado apenas quando houver atualizações disponíveis para uma versão superior do Moodle. A verificação de atualizações para os módulos não é afetada por esta configuração.';
$string['upgradeerror'] = 'Ocorreu um erro ao atualizar o módulo \'{$a->plugin}\' para a nova versão {$a->version}. Não é possível continuar.';
$string['upgradeforumread'] = 'Foi adicionada uma nova funcionalidade ao Moodle 1.5 para assinalar as mensagens lidas/não lidas nos fóruns.<br />Para utilizar esta funcionalidade tem de <a href="{$a}">atualizar as suas tabelas</a>.';
$string['upgradeforumreadinfo'] = 'Foi adicionada uma nova funcionalidade ao Moodle 1.5 para assinalar as mensagens lidas/não lidas nos fóruns. Para utilizar esta funcionalidade tem de atualizar as suas tabelas com toda a informação de rastreio para mensagens existentes. Dependendo do tamanho do seu site, poderá levar muito tempo (horas) e poderá ser muito pesado para a Base de Dados, por isso é aconselhável fazê-lo num período calmo. Contudo, o seu site continuará a funcionar durante essa atualização e os utilizadores não serão afetados. Desde que comece este processo, é aconselhável que o deixe acabar (deixe a janela do navegador aberta). Contudo, se parar o processo fechando a janela, não se preocupe, pode sempre começar outra vez.<br /><br />Quer iniciar o processo de atualização agora?';
$string['upgradekeyreq'] = 'Necessária chave de atualização';
$string['upgradekeyset'] = 'Chave de atualização (deixe em branco caso não pretenda definir)';
$string['upgradelogs'] = 'Para funcionar em pleno, os seus registos de atividade antigos deverão ser atualizados. <a href="{$a}">Mais informação</a>';
$string['upgradelogsinfo'] = 'Foram efetuadas algumas alterações à forma como os registos de atividade são armazenados. Para conseguir consultar os suas antigos registos de atividade, estes deverão ser atualizados. Dependendo do seu site, esta operação pode demorar bastante (até algumas horas) e pode implicar um processamento pesado para a base de dados em sites de grande dimensão. Uma vez iniciado este processo deverá deixá-lo terminar (mantendo a janela do navegador aberta). Não se preocupe - o seu site continuará a trabalhar bem para outras pessoas enquanto as estatísticas são atualizadas.<br /><br />Quer atualizar as suas estatísticas agora?';
$string['upgradepluginsfirst'] = 'Recomenda-se que instale primeiro todas as atualizações disponíveis';
$string['upgradepluginsinfo'] = 'A atualizar módulos';
$string['upgradepluginsinfo_help'] = 'Existem atualizações disponíveis para alguns dos seus módulos. Deve instalá-las todas antes de atualizar a base de dados do Moodle. Se o seu site não suportar o desdobramento automático de atualizações, terá de descarregar as novas versões dos módulos e instalá-las manualmente.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Novas configurações';
$string['upgradesettingsintro'] = 'As configurações mostradas abaixo foram adicionadas durante a última atualização do Moodle. Modifique as que achar necessário e quando terminar clique no botão \'Guardar alterações\' no fim da página.';
$string['upgradestalefiles'] = 'Foram detetados ficheiros de instalação inválidos. A atualização não pode continuar.';
$string['upgradestalefilesinfo'] = 'O processo de atualização do Moodle foi interrompido porque foram detetados scripts PHP de, pelo menos, duas versões maiores do Moodle na pasta do Moodle.

Isto poderá causar problemas significativos mais tarde. Para prosseguir, deverá certificar-se que a pasta do Moodle contém apenas os ficheiros de uma única versão do Moodle.

Recomenda-se o seguinte procedimento para limpar a sua pasta do Moodle:

* Atribua um novo nome à pasta atual do Moodle (por exemplo, "moodle_antiga")
* Crie uma nova pasta do Moodle que contenha apenas os ficheiros extraídos de um pacote Moodle ou a partir do repositório Moodle Git
* Mova o ficheiro original \'config.php\' e todos os outros módulos não padrão da pasta "moodle_antiga" para a nova pasta do Moodle

Quando tiver uma pasta do Moodle limpa, recarregue esta página para retomar o processo de atualização do Moodle.

Este aviso é frequentemente causado quando um pacote do Moodle é extraído de uma pasta comprimida (zip ou tgz) na mesma pasta de uma versão anterior do Moodle. Apesar de ser aceitável para atualizações menores, é altamente desaconselhado em atualizações maiores do Moodle.

Este aviso também pode ser causado por uma verificação incompleta ou por uma operação de atualização a partir do repositório Git, que neste caso, terá de aguardar que a operação termine ou talvez executar o comando adequado de limpeza e repetir a operação.

Pode consultar mais informações sobre atualizações na documentação: <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Atualizar agora a base de dados do Moodle';
$string['upgradesure'] = '<p>Os ficheiros do seu Moodle foram alterados e está prestes a proceder à atualização do seu servidor para a nova versão:</p>
<p><strong>{$a}</strong></p>
<p>Depois de efetuar esta operação não será possível reverter a atualização. Tenha em atenção que este processo pode demorar algum tempo.</p>
<p>Tem a certeza de que pretende atualizar o seu servidor para a nova versão?</p>';
$string['upgradetimedout'] = 'Expirou o tempo para atualização. Por favor, reinicie o processo.';
$string['upgradingdata'] = 'A atualizar os dados';
$string['upgradinglogs'] = 'A atualizar os registos de atividade';
$string['upgradingversion'] = 'A atualizar para nova versão';
$string['upwards'] = 'ou superior';
$string['useblogassociations'] = 'Ativar associações';
$string['user'] = 'Utilizador';
$string['userbulk'] = 'Processar em massa';
$string['userbulkdownload'] = 'Exportar utilizadores para';
$string['userdefaultpreferences'] = 'Configuração predefinida dos utilizadores';
$string['userfeedbackafterupgrade'] = 'Após cada atualização maior';
$string['userfeedbackencouragement'] = '<p>O Moodle inclui uma funcionalidade que oferece aos utilizadores a opção de dar feedback sobre o software Moodle através de um site de inquérito externo alojado pelo Moodle HQ. Nenhuma informação de identificação do utilizador é encaminhada para o site do inquérito.</p>
<p>O Moodle HQ esforça-se para ser aberto e transparente sobre as suas práticas de recolha de dados. Assim, queremos ter a certeza de que está ciente e no controlo desta funcionalidade.</p>
<p>O feedback dos utilizadores ajuda o Moodle HQ a melhorar o software Moodle. Para ativar esta funcionalidade, visite a página das <a href="{$a}">Configurações do feedback</a>.</p>';
$string['userfeedbacknextreminder'] = 'Lembrete de feedback';
$string['userfeedbacknextreminder_desc'] = 'Quando deve ser pedido ao utilizador para dar feedback novamente?';
$string['userfeedbackperiodically'] = 'Periodicamente';
$string['userfeedbackremindafter'] = 'Mostrar lembrete após';
$string['userfeedbackremindafter_desc'] = 'Lembrar os utilizadores para darem feedback novamente após o número indicado de dias.';
$string['userfiltersdefault'] = 'Filtros predefinidos do utilizador';
$string['userfiltersdefault_desc'] = 'Selecione os filtros que devem ser mostrados na página \'Processar em massa\'. Mantenha pressionada a tecla Ctrl para selecionar vários itens. Quaisquer filtros não selecionados continuarão disponíveis através da hiperligação "Mostrar mais".';
$string['userimagesdisabled'] = 'As imagens de perfil do utilizador estão desativadas';
$string['userlist'] = 'Ver lista completa';
$string['usermanagement'] = 'Gestão do utilizador';
$string['userpolicies'] = 'Política de utilizadores';
$string['userpreference'] = 'Preferência do utilizador';
$string['userquota'] = 'Espaço dos ficheiros privados';
$string['userquota_desc'] = 'A quantidade máxima de dados que cada utilizador pode armazenar na sua área de ficheiros privados.';
$string['users'] = 'Utilizadores';
$string['usesitenameforsitepages'] = 'Usar nome do site nas páginas do site';
$string['usetags'] = 'Ativar palavras-chave';
$string['validateemptylineerror'] = 'As linhas vazias não são válidas';
$string['validateerror'] = 'Este valor não é válido';
$string['validateerrorlist'] = 'Estes registos são inválidos: {$a}';
$string['validateiperror'] = 'Estes endereços IP são inválidos: {$a}';
$string['verifychangedemail'] = 'Restringir domínios em alterações de e-mail';
$string['warningcurrentsetting'] = 'Valor atual inválido: {$a}';
$string['warningiconvbuggy'] = 'A sua versão da biblioteca iconv não suporta o modificador //IGNORE. Deverá instalar a extensão mbstring que pode ser usada como substituto para limpar texto com caracteres UTF-8 não válidos.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Preencha as opções seguintes se o servidor Moodle não tiver acesso direto à Internet. O acesso à Internet é necessário para descarregar os dados do ambiente, pacotes linguísticos, fusos horários, etc.<br /><strong>É recomendada a instalação da extensão cURL do PHP</strong>.';
$string['xmlrpcwebserviceenabled'] = 'Foi detetado que o protocolo XML-RPC dos Web Service está ativado no seu site. Esta funcionalidade depende da extensão PHP XML-RPC que já não é mantida pelo PHP.';
$string['yuicomboloading'] = 'Optimizar carregamento de bibliotecas YUI';
$string['ziprequired'] = 'É obrigatória a instalação da extensão Zip do PHP. Os ficheiros binários info-ZIP e as bibliotecas PclZip deixaram de ser utilizados pelo Moodle.';
