<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'uk', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'буде встановлено';
$string['accept'] = 'Прийняти';
$string['action'] = 'Дія';
$string['actionchoice'] = 'Що Ви хочете зробити з файлом \'{$a}\'?';
$string['actions'] = 'Дії';
$string['actionsfor'] = 'Дії для {$a}';
$string['actionsmenu'] = 'Меню дій';
$string['active'] = 'Активний';
$string['activeusers'] = 'Активні користувачі';
$string['activities'] = 'Види діяльності';
$string['activities_help'] = 'Діяльності, такі як форуми, тести та вікі, дозволяють додавати в курс інтерактивний контент.';
$string['activity'] = 'Активність';
$string['activityclipboard'] = 'Перенести діяльність: <b>{$a}</b>';
$string['activityheader'] = 'Меню активності';
$string['activityicon'] = 'значок {$a}';
$string['activityiscurrentlyhidden'] = 'Вибачте, наразі цей модуль є прихованим';
$string['activitymodule'] = 'Модуль';
$string['activitymodules'] = 'Модулі діяльності';
$string['activitynotready'] = 'Діяльність ще не готова';
$string['activityorresource'] = 'Діяльність або ресурс';
$string['activityreport'] = 'Звіт про діяльність';
$string['activityreports'] = 'Звіти про діяльність';
$string['activityselect'] = 'Обрати діяльність для перенесення';
$string['activitysince'] = 'Доступно з {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Діяльність кожного користувача';
$string['add'] = 'Додати';
$string['addactivity'] = 'Додати вид діяльності...';
$string['addactivitytosection'] = 'Додати діяльність до секції \'{$a}\'';
$string['addadmin'] = 'Додати адміністратора';
$string['addblock'] = 'Додати блок';
$string['addcomment'] = 'Додати коментар...';
$string['addcondition'] = 'Додати умову';
$string['addcontent'] = 'Додайте вміст';
$string['addcountertousername'] = 'Створити користувача додаванням номера до імені користувача';
$string['addcreator'] = 'Додати автора курсу';
$string['adddots'] = 'Додати...';
$string['added'] = 'Доданий {$a}';
$string['addedtogroup'] = 'Додано до групи "{$a}"';
$string['addedtogroupnot'] = 'Не додано до групи "{$a}"';
$string['addedtogroupnotenrolled'] = 'Не додано до групи "{$a}", бо не записано на курс';
$string['addfilehere'] = 'Перетягніть файли сюди, щоб додати їх у нижню частину цього розділу';
$string['addfilesdrop'] = 'Ви можете перетягнути файли тут, щоб завантажити або натиснути, щоб вибрати.';
$string['addinganew'] = 'Новий: {$a}';
$string['addingdatatoexisting'] = 'Додавання даних до тих, що вже існують';
$string['additionalcustomnav'] = 'Додаткова спеціальна навігація';
$string['additionalnames'] = 'Додаткові імена';
$string['addlinkhere'] = 'Додати посилання сюди';
$string['addnew'] = 'Додати новий {$a}';
$string['addnewcategory'] = 'Додати нову категорію';
$string['addnewcourse'] = 'Додати новий курс';
$string['addnewuser'] = 'Додати нового користувача';
$string['addnousersrecip'] = 'Додати користувачів, які не отримали доступ до {$a} списку отримувачів';
$string['addpagehere'] = 'Додайте сюди текст';
$string['addresource'] = 'Додати ресурс...';
$string['addresourceoractivity'] = 'Додати діяльність або ресурс';
$string['addresourcetosection'] = 'Додати ресурс до секції \'{$a}\'';
$string['address'] = 'Адреса';
$string['addsections'] = 'Додати секції';
$string['addstudent'] = 'Додати студента';
$string['addsubcategory'] = 'Додати підкатегорію';
$string['addteacher'] = 'Додати викладача';
$string['admin'] = 'Адміністратор';
$string['adminhelpaddnewuser'] = 'Створити новий обліковий запис користувача вручну';
$string['adminhelpassignadmins'] = 'Адміністратор може робити що завгодно та заходити куди завгодно на сайті';
$string['adminhelpassigncreators'] = 'Автори курсів можуть створювати нові курси';
$string['adminhelpassignsiteroles'] = 'Призначати на ролі сайту обраних користувачів';
$string['adminhelpassignstudents'] = 'Зайдіть до курсу та додайте студентів за допомогою меню адміністратора';
$string['adminhelpauthentication'] = 'Ви можете використовувати внутрішні облікові записи користувача або дані зовнішньої бази даних';
$string['adminhelpbackup'] = 'Налаштуйте автоматичні резервні копії та їхні часові розклади';
$string['adminhelpconfiguration'] = 'Встановіть змінні, що впливають на роботу сайту';
$string['adminhelpconfigvariables'] = 'Встановіть змінні, що визначають основні можливості сайту';
$string['adminhelpcourses'] = 'Визначте курси й категорії та їхніх користувачів';
$string['adminhelpeditorsettings'] = 'Визначити основні налаштування для редактора HTML';
$string['adminhelpedituser'] = 'Перегляньте облікові записи і, за необхідності, відредагуйте їх';
$string['adminhelpenvironment'] = 'Перевірте, як Ваш сервер задовольняє поточним та майбутнім інсталяційним вимогам';
$string['adminhelpfailurelogs'] = 'Перегляд системного журналу про невдалі спроби входу';
$string['adminhelplanguage'] = 'Для перевірки й редагування поточного мовного пакету';
$string['adminhelplogs'] = 'Огляд системних подій від усієї діяльності на сайті';
$string['adminhelpmanageblocks'] = 'Керування встановленими блоками та їхніми параметрами';
$string['adminhelpmanagedatabase'] = 'Прямий доступ до бази даних (будьте уважні!)';
$string['adminhelpmanagefilters'] = 'Оберіть текстові фільтри та відповідні параметри';
$string['adminhelpmanagemodules'] = 'Керування встановленими модулями та їхніми параметрами';
$string['adminhelpmanageroles'] = 'Створіть та визначіть ролі, які будуть призначатися користувачам';
$string['adminhelpmymoodle'] = 'Конфігурація блоків для користувачів';
$string['adminhelpreports'] = 'Звіти рівня сайту';
$string['adminhelpsitefiles'] = 'Для розміщення файлів або завантаження зовнішніх резервних копій';
$string['adminhelpsitesettings'] = 'Визначте, як виглядає головна сайту';
$string['adminhelpstickyblocks'] = 'Конкурувати стійкі блоки moodle';
$string['adminhelpthemes'] = 'Оберіть вигляд сайту (колір, шрифт, тощо)';
$string['adminhelpuploadusers'] = 'Додайте нових користувачів з текстового файлу';
$string['adminhelpusers'] = 'Означте користувачів та встановіть спосіб їх ідентифікації';
$string['adminhelpxmldbeditor'] = 'Інтерфейс для редагування XMLDB файлів. Тільки для розробників.';
$string['administration'] = 'Керування';
$string['administrationsite'] = 'Керування сайтом';
$string['administrator'] = 'Адміністратор';
$string['administratordescription'] = 'Зазвичай адміністратори можуть робити все на сайті, у всіх курсах.';
$string['administrators'] = 'Адміністратори';
$string['administratorsall'] = 'Всі Адміністратори';
$string['administratorsandteachers'] = 'Адміністратори та викладачі';
$string['advanced'] = 'Додаткові параметри';
$string['advancedfilter'] = 'Розширений пошук';
$string['advancedsettings'] = 'Розширені установки';
$string['afterresource'] = 'Після ресурсу "{$a}"';
$string['aftersection'] = 'Після секції "{$a}"';
$string['again'] = 'знову';
$string['agelocationverification'] = 'Перевірка віку та місцезнаходження';
$string['ajaxuse'] = 'AJAX та Javascript';
$string['all'] = 'Вибрати все';
$string['allactions'] = 'Всі дії';
$string['allactivities'] = 'Усі операції/завдання';
$string['allcategories'] = 'Всі категорії';
$string['allchanges'] = 'Всі зміни';
$string['alldays'] = 'Всі дні';
$string['allfiles'] = 'Всі файли';
$string['allgroups'] = 'Всі групи';
$string['alllogs'] = 'Усі події';
$string['allmods'] = 'Всі {$a}';
$string['allow'] = 'Дозволити';
$string['allowinternal'] = 'Дозволити також внутрішні методи';
$string['allownone'] = 'Не дозволяти нікому';
$string['allownot'] = 'Немає дозволу';
$string['allowstealthmodules'] = 'Дозволити стелс-активність';
$string['allowstealthmodules_help'] = 'Якщо ввімкнено, активності можуть бути доступними, але не будуть відображатися у видимих розділах сторінки курсу. Якщо так, посилання на стелс-активності повинні бути забезпечені з інших джерел, наприклад, з ресурсу сторінки. Стелс-активності також відображаються в журналі та інших звітах.';
$string['allparticipants'] = 'Усі учасники';
$string['allteachers'] = 'Всі викладачі';
$string['alphanumerical'] = 'Може містити лише літери та числа, дефіс (-) або крапку (.)';
$string['alreadyconfirmed'] = 'Реєстрацію вже підтверджено';
$string['alternatename'] = 'Альтернативна назва';
$string['always'] = 'Завжди';
$string['and'] = '{$a->one} та {$a->two}';
$string['answer'] = 'Відповідь';
$string['any'] = 'Будь-що';
$string['appearance'] = 'Вигляд';
$string['apply'] = 'Примінити';
$string['applyfilters'] = 'Застосувати фільтри';
$string['approve'] = 'Схвалити';
$string['areyousure'] = 'Ви впевнені?';
$string['areyousuretorestorethis'] = 'Ви впевнені, що хочете відновити його?';
$string['areyousuretorestorethisinfo'] = 'Пізніше ви зможете додати цю резервну копію у вже існуючий курс або створити новий курс.';
$string['asc'] = 'За зростанням';
$string['assessment'] = 'Оцінка';
$string['assignadmins'] = 'Призначити адміністраторів';
$string['assigncreators'] = 'Призначити авторів курсів';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Призначити ролі для всього сайту';
$string['authenticateduser'] = 'Аутентифікований користувач';
$string['authenticateduserdescription'] = 'Всі користувачі, що ввійшли.';
$string['authentication'] = 'Аутентифікація';
$string['authenticationplugins'] = 'Модулі аутентифікації';
$string['autosubscribe'] = 'Автопідписка на форум';
$string['autosubscribeno'] = 'Ні, не підписуйте мене автоматично на форуми';
$string['autosubscribeyes'] = 'Так, коли я відправляю повідомлення, я хочу, щоб мене автоматично підписували на форум';
$string['availability'] = 'Доступність';
$string['availablecourses'] = 'Доступні курси';
$string['back'] = 'Назад';
$string['backto'] = 'Назад до {$a}';
$string['backtocourselisting'] = 'Повернутися до списку курсу';
$string['backtohome'] = 'Повернутися на головну сторінку сайту';
$string['backtopageyouwereon'] = 'Повернутися до сторінки, де ви були';
$string['backup'] = 'Резервна копія';
$string['backupactivehelp'] = 'Виберіть, робити або ні автоматичні резервні копії.';
$string['backupadhocpending'] = 'Очікується спеціальне завдання резервного копіювання курсу';
$string['backupcancelled'] = 'Резервне копіювання скасовано';
$string['backupcoursefileshelp'] = 'Якщо дозволено, то файли курсу увійдуть до автоматичних резервних копій';
$string['backupdate'] = 'Дата резервної копії';
$string['backupdatenew'] = '&nbsp; {$a->TAG} зараз {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} був {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Деталі резервної копії';
$string['backuperrorinvaliddestination'] = 'Теки для резервного копіювання не існує або не доступна для запису.';
$string['backupexecuteathelp'] = 'Виберіть, в який час потрібно запускати резервне копіювання';
$string['backupfailed'] = 'Деякі з Ваших курсів не були збережені.';
$string['backupfilename'] = 'резервна копія';
$string['backupfinished'] = 'Створення резервної копії успішно завершено';
$string['backupfromthissite'] = 'Резервне копіювання було зроблено на цьому сайті?';
$string['backupgradebookhistoryhelp'] = 'Якщо дозволено, то історія журналу оцінок буде включатися в автоматичну резервну копію. Зауважимо, що історія оцінювання повинна бути дозволена в налаштуваннях сайту (відключити історію оцінювання), щоб це спрацювало.';
$string['backupincludemoduleshelp'] = 'Визначтеся, чи хочете Ви включити модулі курсів до автоматичних резервних копій, з чи без облікового запису користувача';
$string['backupincludemoduleuserdatahelp'] = 'Виберіть, чи хочете ви, щоб до автоматичного резервного копіювання включалися дані користувачів.';
$string['backupinfo'] = 'Зробіть копію цього курсу, включаючи весь вміст та активність на сьогоднішній день. Ви можете використовувати резервний файл для відновлення курсу.';
$string['backuplogdetailed'] = 'Детальний звіт виконання';
$string['backuploglaststatus'] = 'Останній звіт виконання';
$string['backupmissinguserinfoperms'] = 'Примітка: Ця резервна копія не містить даних про користувачів. Діяльності Семінар та Робочий зошит не будуть включені до резервної копії, оскільки вони не сумісні з цим типом резервної копії.';
$string['backupnext'] = 'Наступна резервна копія';
$string['backupnonisowarning'] = 'Попередження: ця резервна копія створена з версії Moodle, яка не містить Unicode (до 1.6). Якщо ця резервна копія містить будь-які тексти, відмінні від ISO-8859-1, вони можуть бути ПІСКУДАННІ, якщо ви спробуєте відновити їх до цієї версії Moodle Unicode. Перегляньте <a href="https://docs.moodle.org/en/Backup_FAQ">Поширені запитання про резервну копію</a>, щоб дізнатися більше про те, як правильно відновити цю резервну копію.';
$string['backupnotyetrun'] = 'Очікується автоматичне резервне копіювання';
$string['backuporiginalname'] = 'Назва резервної копії';
$string['backuproleassignments'] = 'Додати в резервну копію призначених користувачів для цих ролей';
$string['backupsavetohelp'] = 'Повний шлях до каталогу, де ви збираєтеся зберігати резервні файли';
$string['backupsitefileshelp'] = 'Якщо включено, тоді файли сайту, використані на курсі, будуть включатися в автоматичну резервну копію';
$string['backuptakealook'] = 'Будь ласка перегляньте системні журнали подій про резервне копіювання: {$a}';
$string['backupuserfileshelp'] = 'Виберіть, чи повинні файли користувачів (наприклад фотографії) бути включеними до автоматичного резервного копіювання';
$string['backupversion'] = 'Версія резервної копії';
$string['badges'] = 'Відзнаки';
$string['between'] = 'Між';
$string['block'] = 'Блок';
$string['blockconfiga'] = 'Конфігурація блоку {$a}';
$string['blockconfigbad'] = 'Цей блок не був правильно під\'єднаний, тому його конфігурація не може бути здійснена';
$string['blocks'] = 'Блоки';
$string['blocks_main'] = 'Основні блоки контенту';
$string['blocks_supplementary'] = 'Додаткові блоки';
$string['blocksaddedit'] = 'Додати/Редагувати блоки';
$string['blockseditoff'] = 'Завершити редагування блоків';
$string['blocksediton'] = 'Редагувати блоки';
$string['blocksetup'] = 'Налаштування таблиць блоку';
$string['blocksuccess'] = '{$a} таблиці налаштовані правильно';
$string['brief'] = 'Коротко';
$string['bulkactions'] = 'Масові дії';
$string['bulkactionselect'] = '{$a} вибір масової дії';
$string['bulkcancel'] = 'Закрити масові редагування';
$string['bulkmovecoursessuccess'] = 'Успішно переміщено {$a->courses} курси в {$a->category}';
$string['bulkselection'] = 'Вибрано {$a}';
$string['bycourseorder'] = 'За курсами';
$string['byname'] = 'за {$a}';
$string['bypassed'] = 'Ігноровано';
$string['cachecontrols'] = 'Управління кешем';
$string['calltofeedback'] = 'Творці цього програмного забезпечення хочуть ваших відгуків.';
$string['calltofeedback_give'] = 'Залиште відгук про це програмне забезпечення';
$string['calltofeedback_remind'] = 'Нагадай мені пізніше';
$string['cancel'] = 'Скасувати';
$string['cancelled'] = 'Скасовано';
$string['categories'] = 'Категорії курсів';
$string['categoriesandcourses'] = 'Категорії курсів та курси';
$string['category'] = 'Категорія';
$string['categoryadded'] = 'Категорію \'{$a}\' було додано';
$string['categorybulkaction'] = 'Масові дії над вибраними категоріями';
$string['categorycontents'] = 'Субкатегорії та курси';
$string['categorycurrentcontents'] = 'Зміст  {$a}';
$string['categorydeleted'] = 'Категорію \'{$a}\' було вилучено';
$string['categoryduplicate'] = 'Категорія з ім\'ям \'{$a}\' уже існує!';
$string['categoryheader'] = 'Меню категорій';
$string['categoryhidden'] = '(прихований)';
$string['categorymodifiedcancel'] = 'Категорія була змінена! Будь ласка, відмініть або спробуйте ще раз.';
$string['categoryname'] = 'Назва категорії';
$string['categorypath'] = 'Шлях категорії';
$string['categorysubcategoryof'] = '{$a->category} - підкатегорія для {$a->parentcategory}';
$string['categoryupdated'] = 'Категорія \'{$a}\' була поновлена';
$string['changedpassword'] = 'Зміна пароля';
$string['changepassword'] = 'Змінити пароль';
$string['changesmade'] = 'Зміни внесені';
$string['changesmadereallygoaway'] = 'Ви зробили зміни. Ви впевнені, що хочете піти і втратити зміни?';
$string['changessaved'] = 'Зміни збережені';
$string['check'] = 'Перевірка';
$string['checkactual'] = 'Фактичний';
$string['checkall'] = 'Перевірити все';
$string['checkerror'] = 'Помилка отримання результату перевірки "{$a}". Перевірте консоль браузера для отримання додаткової інформації.';
$string['checkexpected'] = 'Очікуваний';
$string['checkingbackup'] = 'Перевірка резервної копії';
$string['checkingcourse'] = 'Перевірка курсу';
$string['checkingforbbexport'] = 'Перевірка можливостей експорту в формат BlackBoard';
$string['checkinginstances'] = 'Перевірка зразків';
$string['checkingsections'] = 'Перевірка секцій';
$string['checklanguage'] = 'Перевірка мови';
$string['checkloading'] = 'Отримання результату перевірки "{$a}"';
$string['checknone'] = 'Не перевіряти';
$string['checks'] = 'Checks';
$string['checksok'] = 'Усі \'{$a}\' перевіряє ОК';
$string['childcoursenotfound'] = 'Дочірній курс не знайдено';
$string['childcourses'] = 'Дочірні курси';
$string['choose'] = 'Вибрати';
$string['choosecourse'] = 'Вибрати курс';
$string['choosedots'] = 'Вибрати...';
$string['chooselivelogs'] = 'Або дивитися поточну активність';
$string['chooselogs'] = 'Оберіть журнали подій, які хочете побачити';
$string['choosereportfilter'] = 'Виберіть фільтр для звіту';
$string['choosetheme'] = 'Вибрати тему';
$string['chooseuser'] = 'Вибрати користувача';
$string['city'] = 'Місто';
$string['cleaningtempdata'] = 'Видалення тимчасових файлів';
$string['clear'] = 'Очистити';
$string['clearall'] = 'Очистити все';
$string['clearfilterrow'] = 'Видаліть рядок фільтра';
$string['clearfilters'] = 'Скинути фільтри';
$string['clearsearch'] = 'Очистити пошуковий ввід';
$string['clickhelpiconformoreinfo'] = '... триває ... Натисніть на значок допомоги, щоб читати повний текст статті';
$string['clickhere'] = 'Клацніть тут...';
$string['clicktohideshow'] = 'Натисніть, щоб розгорнути або згорнути';
$string['closeblockdrawer'] = 'Закрийте ящик блоків';
$string['closebuttontitle'] = 'Закрити';
$string['closecourseindex'] = 'Закрити покажчик курсу';
$string['closedrawer'] = 'Закрити ящик';
$string['closewindow'] = 'Закрити вікно';
$string['collapse'] = 'Згорнути';
$string['collapseall'] = 'Згорнути все';
$string['collapsecategory'] = 'Згорнути {$a}';
$string['comebacklater'] = 'Будь ласка, поверніться пізніше.';
$string['commentincontext'] = 'Знайти цей коментар в контексті';
$string['comments'] = 'Коментарі';
$string['commentscount'] = 'Коментарі ({$a})';
$string['commentsnotenabled'] = 'Можливість коментування не включена';
$string['commentsrequirelogin'] = 'Вам потрібно увійти, щоб переглянути коментарі.';
$string['comparelanguage'] = 'Порівняти і редагувати поточну мову';
$string['complete'] = 'Завершено';
$string['completed'] = 'Завершено';
$string['completereport'] = 'Повний звіт';
$string['configuration'] = 'Налаштування';
$string['confirm'] = 'Підтвердження';
$string['confirmaccount'] = 'Підтвердити обліковий запис';
$string['confirmcheckfull'] = 'Ви абсолютно впевнені, що хочете підписати {$a} ?';
$string['confirmcoursemove'] = 'Ви впевнені, що хочете перемістити цей курс ({$a->course}) до цієї категорії ({$a->category})?';
$string['confirmdeletesection'] = 'Ви повністю впевнені, що хочете видалити "{$a}"  та всі діяльності, які містить?';
$string['confirmed'] = 'Реєстрацію підтверджено';
$string['confirmednot'] = 'Ваша реєстрація ще не підтверджена. Будь ласка, перевірте свою поштову скриньку на наявність електронного листа з підтвердженням.';
$string['considereddigitalminor'] = 'Ви занадто молоді, щоб створювати обліковий запис на цьому сайті.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Контент';
$string['contentbank'] = 'Сховище контенту';
$string['contentexport_aboutthiscourse'] = 'Підсумок курсу';
$string['contentexport_coursesummary'] = 'Цей файл є частиною вмісту, завантаженого з <a href="{$a->courselink} "> {$a->coursename} </a>.';
$string['contentexport_footersummary'] = 'Цей файл є частиною вмісту, завантаженого з <a href="{$a->courselink} "> {$a->coursename} </a> користувачем {$a->userfullname} {$a->date} .';
$string['contentexport_modulesummary'] = 'Ця сторінка є частиною вмісту, завантаженого з <a href="{$a->modulelink} "> {$a->modulename} </a> {$a->date}. Зверніть увагу, що певний вміст та будь-які файли, розмір яких перевищує {$a->maxfilesize}, не завантажуються.';
$string['contentexport_viewfilename'] = 'Переглянути файл {$a}';
$string['context'] = 'Контекст';
$string['contextlevel'] = 'Рівень контексту';
$string['contextname'] = 'Назва контексту';
$string['contextparent'] = 'Батько';
$string['contexturl'] = 'Контекст URL';
$string['continue'] = 'Продовжити';
$string['continuetocourse'] = 'Клацніть тут, щоб увійти до курсу';
$string['convertingwikitomarkdown'] = 'Конвертування формату Wiki в формат Markdown';
$string['cookiesenabled'] = '<b>Cookies</b> повинні бути дозволені у Вашому браузері';
$string['cookiesenabled_help'] = 'На цьому сайті використовуються два файли cookie:

Важливим є файл cookie сеансу, який зазвичай називають MoodleSession. Ви повинні дозволити цей файл cookie у вашому браузері, щоб забезпечити безперервність і залишатися в системі під час перегляду сайту. Коли ви виходите з системи або закриваєте браузер, цей файл cookie знищується (у вашому браузері та на сервері).

Інший файл cookie призначений виключно для зручності, зазвичай називається MOODLEID або схожий. Він просто запам\'ятовує ваше ім\'я користувача в браузері. Це означає, що коли ви повернетесь на цей сайт, поле імені користувача на сторінці входу вже заповнене для вас. Можна безпечно відмовитися від цього файлу cookie – вам потрібно буде просто вводити своє ім’я користувача щоразу, коли ви входите в систему.';
$string['cookiesenabled_help_html'] = 'На цьому сайті використовуються два файли cookie: <br/><br/>

Важливим є файл cookie сеансу, який зазвичай називають MoodleSession. Ви повинні дозволити цей файл cookie у вашому браузері, щоб забезпечити безперервність і залишатися в системі під час перегляду сайту. Коли ви виходите з системи або закриваєте браузер, цей файл cookie знищується (у вашому браузері та на сервері).

<br/><br/>Інший файл cookie призначений виключно для зручності, зазвичай називається MOODLEID або схожий. Він просто запам\'ятовує ваше ім\'я користувача в браузері. Це означає, що коли ви повернетесь на цей сайт, поле імені користувача на сторінці входу вже заповнене для вас. Можна безпечно відмовитися від цього файлу cookie – вам потрібно буде просто вводити своє ім’я користувача щоразу, коли ви входите в систему.';
$string['cookiesenabledonlysession'] = '<b>Cookies</b> повинні бути дозволені у Вашому браузері';
$string['cookiesenabledonlysession_help'] = 'Цей сайт використовує один сеансовий файл cookie, який зазвичай називається MoodleSession. Ви повинні дозволити цьому файлу cookie у вашому браузері забезпечувати безперервність і залишатися в системі під час перегляду веб-сайту. Коли ви виходите з системи або закриваєте браузер, цей файл cookie знищується (у вашому браузері та на сервері).';
$string['cookiesnotenabled'] = 'На жаль, куки не дозволені у вашому браузері';
$string['cookiesnotice'] = 'Повідомлення про файли cookie';
$string['copy'] = 'копіювати';
$string['copyasnoun'] = 'копіювання';
$string['copycourse'] = 'Копіювати курс';
$string['copyingcoursefiles'] = 'Копіювання файлів курсу';
$string['copyingsitefiles'] = 'Копіювання файлів сайту, які використовуються в курсі';
$string['copyinguserfiles'] = 'Копіювання файлів користувачів';
$string['copyingzipfile'] = 'Копіювання zip-файлу';
$string['copyrightnotice'] = 'Нотатка про авторське право';
$string['copytoclipboard'] = 'Копіювати в буфер обміну';
$string['coresystem'] = 'Ядро системи';
$string['cost'] = 'Вартість';
$string['costdefault'] = 'Типова вартість';
$string['count_of_total'] = '<strong>{$a->count}</strong> із {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Країна';
$string['course'] = 'Курс';
$string['courseadministration'] = 'Керування курсом';
$string['courseapprovedemail'] = 'Запитаний вами курс схвалено, <a href="{$a->url}">{$a->name}</a>, і ви є {$a->вчителем}.';
$string['courseapprovedemail2'] = 'Запитаний курс схвалено: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Помилка запису курсу як схваленого!';
$string['courseapprovedsubject'] = 'Ваш курс затверджений.';
$string['courseavailable'] = 'Курс доступний для студентів';
$string['courseavailablenot'] = 'Курс не доступний для студентів';
$string['coursebackup'] = 'Резервна копія курсу';
$string['coursebulkaction'] = 'Масові дії над вибраними курсами';
$string['coursecategories'] = 'Категорії курсів';
$string['coursecategory'] = 'Категорія курсу';
$string['coursecategory_help'] = 'Цей параметр визначає категорію, в яку зазвичай додаються курси.';
$string['coursecategorydeleted'] = 'Видалено курс категорії {$a}';
$string['coursecatmanagement'] = 'Керування курсами та категоріями';
$string['coursecompletion'] = 'Курс закінчено';
$string['coursecompletions'] = 'Курс закінчено';
$string['coursecreators'] = 'Автор курсу';
$string['coursecreatorsdescription'] = 'Автори курсів можуть створювати нові курси.';
$string['coursedeleted'] = 'Видалено курс {$a}';
$string['coursedetails'] = 'Деталі курсу';
$string['coursedisplay'] = 'Компонування курсу';
$string['coursedisplay_help'] = 'Розділи курсу можуть відображатися все на одній сторінці або розділити на кілька сторінок.';
$string['coursedisplay_multi'] = 'Показувати по одній секції на сторінці';
$string['coursedisplay_single'] = 'Показувати усі секції на одній сторінці';
$string['courseduration'] = 'Тривалість курсу';
$string['courseduration_desc'] = 'Тривалість курсу використовується для обчислення дати завершення курсу за замовчуванням. Дату закінчення курсу використовують для визначення того, чи слід включати курс до списку курсів користувачів. Її також можуть використовувати спеціальні звіти. Користувачі можуть входити в курс після дати закінчення.';
$string['courseenddateenabled'] = 'Дата завершення курсу включена за замовчуванням';
$string['courseenddateenabled_desc'] = 'Цей параметр визначає, чи буде дата завершення курсу включена за умовчанням для нових курсів і буде встановлена на дату, визначену за тривалістю курсу.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Попередні файли курсу';
$string['coursefilesedit'] = 'Редагувати файли курсу';
$string['coursefileswarning'] = 'Файли курсу застаріли';
$string['coursefileswarning_help'] = 'Файли курсу застаріли від версії Moodle 2.0, будь ласка, натомість використовуйте зовнішні репозиторії наскільки це можливо.';
$string['courseformatdata'] = 'Дані формату курсу';
$string['courseformatoptions'] = 'Опції форматування для {$a}';
$string['courseformats'] = 'Формати курсів';
$string['courseformatudpate'] = 'Оновити формат';
$string['coursegrades'] = 'Оцінки курсу';
$string['courseheader'] = 'Меню курсу';
$string['coursehelpcategory'] = 'Позиція курсу в списку курсів може полегшити студентам його пошук.';
$string['coursehelpforce'] = 'Примусовий режим групування в курсі буде обов’язковим для всіх діяльностей.';
$string['coursehelpformat'] = 'Головна сторінка курсу буде показана в цьому форматі.';
$string['coursehelphiddensections'] = 'Як приховані секції курсу будуть показуватися студентам.';
$string['coursehelpmaximumupload'] = 'Визначте максимальний розмір файлу, який може бути завантажений студентами в цьому курсі, не може бути більше ніж аналогічне обмеження для сайту.';
$string['coursehelpnewsitemsnumber'] = 'Кількість останніх повідомлень, які з’являються в блоці останніх оголошень на сторінці курсу. Якщо встановлено значення 0, форум оголошень не створюватиметься.';
$string['coursehelpnumberweeks'] = 'Число тижнів/тем для показу на головній сторінці курсу.';
$string['coursehelpshowgrades'] = 'Дозволити показ журналу оцінок. Це не відміняє оцінки в межах окремих діяльностей.';
$string['coursehidden'] = 'Зараз курс не доступний для студентів';
$string['courseinfo'] = 'Інформація про курс';
$string['courselegacyfiles'] = 'Файли курсу';
$string['courselegacyfiles_help'] = 'Область файлів курсу забезпечує деяку зворотну сумісність з Moodle 1.9 та меншими. Всі файли в цій області завжди доступні для всіх учасників курсу (робили ви посилання на них чи ні) і немає ніякого способу дізнатися, де будь-який з цих файлів використовується в Moodle.

Якщо використовувати цю область для зберігання файлів курсу, то ви піддаватимете себе небезпеці конфіденційності, що може виражатися у втраті  резервних копій, звичайному імпорті ваших файлів, відкриттю змісту ваших каталогів у будь-який час або повторному їх використанню. Тому рекомендується не використовувати цю область, або ж ви точно знаєте, що робите.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Файли курсу: {$a}';
$string['coursenotaccessible'] = 'Цей курс не має загального доступу';
$string['courseoverview'] = 'Огляд курсів';
$string['courseoverviewfiles'] = 'Зображення курсу';
$string['courseoverviewfiles_help'] = 'Зображення курсу відображається на моїх курсах та у списку доступних курсів на домашній сторінці. Адміністратори сайту можуть включити додаткові типи файлів та використання декількох файлів. Якщо ви використовуєте кілька файлів, всі вони будуть відображені у списку доступних курсів на домашній сторінці.';
$string['courseoverviewfilesext'] = 'Розширення файлів зображень курсу';
$string['courseoverviewfileslimit'] = 'Обмеження файлів зображень курсу';
$string['courseoverviewgraph'] = 'Графік переглядів курсу';
$string['courseprofiles'] = 'Зареєстрований на курсах';
$string['coursereasonforrejecting'] = 'Ваші причини для відхилення цього запиту';
$string['coursereasonforrejectingemail'] = 'Це буде відправлено у відповідь на запит';
$string['coursereject'] = 'Відмовлено у створенні курсу';
$string['courserejected'] = 'Замовлення на курс було відкинуте і замовник був сповіщений.';
$string['courserejectemail'] = 'Вибачте, але замовлений Вами курс було відхилено. Підґрунтя: {$a}';
$string['courserejectreason'] = 'Виділіть ваші причини для відхилення курсу<br />(вони будуть відіслані електронною поштою у відповідь на замовлення)';
$string['courserejectsubject'] = 'Ваше змовлення на курс було відхилено';
$string['coursereport'] = 'Звіт курсу';
$string['coursereports'] = 'Звіти курсу';
$string['courserequest'] = 'Замовлення курсу';
$string['courserequestdetails'] = 'Докладна інформація про курс, який ви замовляєте';
$string['courserequestfailed'] = 'З деяких причин, ваше замовлення курсу не було збережено';
$string['courserequestintro'] = 'Використовуйте дану форму для запиту створення вашого курсу.<br />Опишіть курс настільки,<br />щоб адміністратор зрозумів суть та причини.';
$string['courserequestreason'] = 'Причини, за якими вихочете створити цей курс';
$string['courserequestroleerror'] = 'Роль творців у конфігурації нових курсів недійсна. Перегляньте <a href="{$a}">політику користувача</a>.';
$string['courserequestsuccess'] = 'Запит на курс подано.';
$string['courserequestsupport'] = 'Додаткова інформація, яка дозволить адміністратору оцінити Ваш запит';
$string['courserequestwarning'] = 'Користувач, який запитує на створення курсу буде автоматично зарахований на роль {$a}.';
$string['courserestore'] = 'Відновлення курсу';
$string['coursereuse'] = 'Повторне використання курсу';
$string['coursereusenavigationmenu'] = 'Меню навігації з повторного використання курсу';
$string['courses'] = 'Курси';
$string['coursesectionsummaries'] = 'Розділ анотації курсу';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Масове редагування {$a->sectionname}: {$a->sectiontitle} | {$a->курс}';
$string['coursesectiontitleediting'] = 'Редагувати {$a->sectionname}: {$a->sectiontitle} | {$a->курс}';
$string['coursesettings'] = 'Типові налаштування курсу';
$string['coursesmovedout'] = 'Курси переміщено з {$a}';
$string['coursespending'] = 'Курси, які чекають на підтвердження';
$string['coursestart'] = 'Початок курсу';
$string['coursesummary'] = 'Анотація курсу';
$string['coursesummary_help'] = 'Короткий опис вашого курсу. Вміст, який ви додаєте тут, можна шукати.';
$string['coursetitle'] = 'Курс: {$a->course}';
$string['coursetitlebulkediting'] = 'Масове редагування курсу: {$a->course}';
$string['coursetitleediting'] = 'Редагувати курс: {$a->course}';
$string['courseupdates'] = 'Відновлення курсу';
$string['coursevisibility'] = 'Видимість курсу';
$string['coursevisibility_help'] = '* Показати: курс відображається у списку курсів, і студенти можуть отримати до нього доступ.
* Приховати: доступ обмежений викладачами та іншими користувачами з можливістю перегляду прихованих курсів.';
$string['create'] = 'Створити';
$string['createaccount'] = 'Створити запис';
$string['createcategory'] = 'Створити категорію';
$string['createfolder'] = 'Створити папку в {$a}';
$string['createnew'] = 'Створити новий';
$string['createnewcategory'] = 'Створити нову категорію';
$string['createnewcourse'] = 'Створити новий курс';
$string['createnewsubcategory'] = 'Створити нову підкатегорію';
$string['createsubcategoryof'] = 'Створити підкатегорію для {$a}';
$string['createuser'] = 'Створити користувача';
$string['createziparchive'] = 'Створити zip-архів';
$string['creatingblocks'] = 'Створення блоків';
$string['creatingblocksroles'] = 'Створення ролі рівня блоку - дозволи та заборона';
$string['creatingblogsinfo'] = 'Створення інформації блогів';
$string['creatingcategoriesandquestions'] = 'Створення категорій і курсів';
$string['creatingcoursemodules'] = 'Створення модулів курсу';
$string['creatingcourseroles'] = 'Створення ролі рівня курсу - призначення та уточнення';
$string['creatingevents'] = 'Створення подій';
$string['creatinggradebook'] = 'Створення журналу оцінок';
$string['creatinggroupings'] = 'Створення групування';
$string['creatinggroupingsgroups'] = 'Додати групи в групування';
$string['creatinggroups'] = 'Створення груп';
$string['creatinglogentries'] = 'Створення реєстраційних записів';
$string['creatingmessagesinfo'] = 'Створення інформаційних повідомлень';
$string['creatingmodroles'] = 'Створення ролі рівня модуля - призначення та уточнення';
$string['creatingnewcourse'] = 'Створення нового курсу';
$string['creatingrolesdefinitions'] = 'Створення визначень ролей';
$string['creatingscales'] = 'Створення шкали';
$string['creatingsections'] = 'Створення секцій';
$string['creatingtemporarystructures'] = 'Створення тимчасової структури';
$string['creatinguserroles'] = 'Створення ролі рівня користувача - призначення та уточнення';
$string['creatingusers'] = 'Створення користувачів';
$string['creatingxmlfile'] = 'Створення XML-файлу';
$string['currency'] = 'Валюта';
$string['currentcourse'] = 'Поточний курс';
$string['currentcourseadding'] = 'Поточний курс, додати нові дані';
$string['currentcoursedeleting'] = 'Поточний курс, видаліть спочатку це';
$string['currentlanguage'] = 'Обрана мова';
$string['currentlocaltime'] = 'час';
$string['currentpicture'] = 'Поточне фото';
$string['currentrelease'] = 'Інформація про поточну версію';
$string['currenttheme'] = 'Поточна тема';
$string['currentversion'] = 'Поточна версія';
$string['databasechecking'] = 'Оновлення бази даних системи з {$a->oldversion} до {$a->newversion}...';
$string['databaseperformance'] = 'Продуктивність бази даних';
$string['databasesetup'] = 'Налаштування бази даних';
$string['databasesuccess'] = 'База даних була успішно оновлена';
$string['databaseupgradebackups'] = 'Версія резервної копії {$a}';
$string['databaseupgradeblocks'] = 'Версія блоків {$a}';
$string['databaseupgradegroups'] = 'Версія груп {$a}';
$string['databaseupgradelocal'] = 'Локальна база даних відповідає версії {$a}';
$string['databaseupgrades'] = 'Оновлення бази даних';
$string['dataformats'] = 'Формати даних';
$string['date'] = 'Дата';
$string['datechanged'] = 'Дата змінена';
$string['datemostrecentfirst'] = 'Дати - нові на початку';
$string['datemostrecentlast'] = 'Дати - нові в кінці';
$string['datetimefilterafter'] = '{$a->title} після';
$string['datetimefilterbefore'] = '{$a->title} раніше';
$string['day'] = 'день';
$string['days'] = 'днів';
$string['decodinginternallinks'] = 'Декодування внутрішніх зв\'язків';
$string['default'] = 'Типово';
$string['defaultcategoryname'] = 'Категорія 1';
$string['defaultcompetencescale'] = 'Типова шкала компетенцій';
$string['defaultcompetencescaledesc'] = 'Двійкова шкала оцінки, яка дає інформацію лише про те, чи продемонстровано вміння чи ні.';
$string['defaultcompetencescalenotproficient'] = 'Компетенція ще не підтверджена';
$string['defaultcompetencescaleproficient'] = 'Компетенція';
$string['defaultcoursestudent'] = 'Студент';
$string['defaultcoursestudentdescription'] = 'Студент зазвичай має найменші права на курсі.';
$string['defaultcoursestudents'] = 'Студенти';
$string['defaultcoursesummary'] = 'Опис курсу (стислий опис, який пояснює, що це за курс)';
$string['defaultcourseteacher'] = 'Викладач';
$string['defaultcourseteacherdescription'] = 'Викладачі можуть робити на курсі все, включно зі зміною завдань та оцінюванням студентів.';
$string['defaultcourseteachers'] = 'Викладачі';
$string['defaulteditor'] = 'Типовий редактор';
$string['defaulthomepageuser'] = 'Домашня сторінка';
$string['defaulthomepageuser_help'] = 'На яку сторінку ви повинні бути перенаправлені після входу на сайт?';
$string['delete'] = 'Видалити';
$string['deleteablock'] = 'Видалити блок';
$string['deleteall'] = 'Видалити все';
$string['deleteallcannotundo'] = 'Видалити все - не може бути скасоване';
$string['deleteallcomments'] = 'Всі коментарі';
$string['deleteallratings'] = 'Всі рейтинги';
$string['deletecategory'] = 'Видалити категорію: {$a}';
$string['deletecategorycheck'] = 'Ви повністю впевнені, що хочете видалити категорію <b>\'{$a}\'</b>?<br /> Це призведе до того, що усі курси з цієї категорії будуть переміщені до категорії більш високого рівня, або до категорії "Різне".';
$string['deletecategorycheck2'] = 'Якщо ви видаляєте цю категорію, то потрібно вибрати, що робити з курсами та підкатегоріями, які в ній знаходяться.';
$string['deletecategoryempty'] = 'Ця категорія порожня.';
$string['deletecheck'] = 'Видалити {$a} ?';
$string['deletecheckfiles'] = 'Ви абсолютно впевнені, що хочете видалити ці файли?';
$string['deletecheckfull'] = 'Ви абсолютно впевнені, що хочете повністю видалити користувача {$a}, у тому числі зарахування, діяльності та інші дані користувача?';
$string['deletechecktype'] = 'Ви впевнені, що хочете видалити цей {$a->type}?';
$string['deletechecktypename'] = 'Ви впевнені, що хочете видалити {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Ви збираєтеся видалити ці файли';
$string['deletecommentbyon'] = 'Видалити коментар, опублікований  {$a->user} o {$a->time}';
$string['deletecompletely'] = 'Повне видалення';
$string['deletecourse'] = 'Видалити курс';
$string['deletecoursecheck'] = 'Ви підтверджуєте повне видалення курсу та всіх даних, які він містить?';
$string['deleted'] = 'Видалено';
$string['deletedactivity'] = 'Видалений {$a}';
$string['deletedcourse'] = '{$a} був повністю видалений';
$string['deletednot'] = 'Не вдалося видалити {$a}.';
$string['deletepicture'] = 'Видалити';
$string['deletesection'] = 'Видалити';
$string['deleteselected'] = 'Видалити виділене';
$string['deleteselectedkey'] = 'Видалити вибраний ключ';
$string['deletingcourse'] = 'Видалення {$a}';
$string['deletingexistingcoursedata'] = 'Видалення даних курсу';
$string['deletingolddata'] = 'Видалення застарілих даних';
$string['department'] = 'Відділ';
$string['deprecatedeventname'] = '{$a} (більше не використовуються)';
$string['desc'] = 'За спаданням';
$string['description'] = 'Опис';
$string['deselectall'] = 'Зняти виділення';
$string['deselectnos'] = 'Скасувати вибір усіх "Ні"';
$string['detailedless'] = 'Коротко';
$string['detailedmore'] = 'Детально';
$string['details'] = 'Деталі';
$string['digitalminor'] = 'Цифровий мінор';
$string['digitalminor_desc'] = 'Будь ласка, попросіть своїх батьків/опікуна зв’язатися:';
$string['directory'] = 'Директорія';
$string['disable'] = 'Відключити';
$string['disabledcomments'] = 'Коментарі відключені';
$string['dismissnotification'] = 'Відхилити це сповіщення';
$string['displayingfirst'] = 'Виведено тільки перші {$a->count} {$a->things}.';
$string['displayingrecords'] = 'Показ записів (всього {$a})';
$string['displayingusers'] = 'Користувачі з {$a->start} до {$a->end}';
$string['displayonpage'] = 'Показати на сторінці';
$string['dndcourse'] = 'Ви можете перетягнути цей курс, щоб змінити його розташування або перемістити його в іншу категорію.';
$string['dndenabled_inbox'] = 'Для додавання файлів ви можете просто перетягнути їх сюди.';
$string['dndnotsupported'] = 'Завантаження методом "drag and drop" не підтримується';
$string['dndnotsupported_help'] = 'Ваш браузер не підтримує завантаження перетягуванням. Ця функція доступна в усіх останніх версіях Chrome, Firefox і Safari, а також у Internet Explorer версії 10 і вище.';
$string['dndnotsupported_insentence'] = 'Метод "drag and drop" не підтримується';
$string['dnduploadwithoutcontent'] = 'Це завантаження не має ніякого вмісту';
$string['dndworkingfile'] = 'Перетягніть файли на розділи курсу, щоб завантажити їх';
$string['dndworkingfilelink'] = 'Для завантаження файлів або посилань перетягніть їх в розділи курсу';
$string['dndworkingfiletext'] = 'Для завантаження файлів або тексту перетягнете їх в розділи курсу';
$string['dndworkingfiletextlink'] = 'Для завантаження файлів, тексту або посилань перетягніть їх в розділи курсу';
$string['dndworkinglink'] = 'Для завантаження посилань перетягніть їх в розділи курсу';
$string['dndworkingtext'] = 'Для завантаження тексту перетягніть його в розділи курсу';
$string['dndworkingtextlink'] = 'Для завантаження тексту або посилань перетягніть їх в розділи курсу';
$string['documentation'] = 'Документація Moodle';
$string['dontsortcategories'] = 'Не сортувати категорії';
$string['dontsortcourses'] = 'Не сортувати курси';
$string['down'] = 'Донизу';
$string['download'] = 'Завантажити';
$string['downloadall'] = 'Завантажити все';
$string['downloadexcel'] = 'Завантажити у форматі Excel';
$string['downloadfile'] = 'Завантажити файл';
$string['downloadods'] = 'Завантажити у форматі ODS';
$string['downloadtext'] = 'Завантажити в текстовому форматі';
$string['doyouagree'] = 'Ви ознайомилися з умовами?';
$string['droptoupload'] = 'Відпустіть файли тут для завантаження';
$string['duplicate'] = 'Створити копію';
$string['duplicatedmodule'] = '{$a} (копія)';
$string['duplicatedsection'] = '{$a} (копія)';
$string['edhelpaspellpath'] = 'Для перевірки орфографії, ви повинні мати встановлений на сервері <strong>aspell 0.50</strong> або старше, та налаштувати до нього доступ. На Unix/Linux системах типовим шляхом до даної програми є <strong>/usr/bin/aspell</strong>, але у вас він може бути іншим.';
$string['edhelpbgcolor'] = 'Визначте тло робочої області редактора.<br />Вказуйте чіткі значення, наприклад: #FFFFFF або white (англійською мовою)';
$string['edhelpcleanword'] = 'Ця установка включає або виключає формат Word-фільтрації';
$string['edhelpenablespelling'] = 'Включити або виключити перевірку орфографії. Якщо включено, <strong>aspell</strong> повинен бути встановленим на сервері. Друге значення - це <strong>типовий словник</strong>. Це значення буде використовуватися, якщо користувачі не вибрали власного словника.';
$string['edhelpfontfamily'] = 'Сімейства шрифтів визначають список шрифтів для використання. Сімейства мають розділятися комами.';
$string['edhelpfontlist'] = 'Визначіть шрифти, для використання у випадаючих меню редактора';
$string['edhelpfontsize'] = 'Типові установки розміру шрифта.<br />Наприклад: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Редагувати ';
$string['edita'] = 'Редагувати {$a}';
$string['editcategorysettings'] = 'Редагувати установки категорії';
$string['editcategorythis'] = 'Редагувати цю категорію';
$string['editcoursesettings'] = 'Редагувати параметри курсу';
$string['editfiles'] = 'Редагувати файли';
$string['editgroupprofile'] = 'Редагувати опис групи';
$string['editingteachershort'] = 'Редактор';
$string['editlock'] = 'Це значення не редагується!';
$string['editmode'] = 'Режим редагування';
$string['editmyprofile'] = 'Редагувати інформацію';
$string['editorbgcolor'] = 'Колір тла';
$string['editorcleanonpaste'] = 'Очистити Word HTML при вставці';
$string['editorcommonsettings'] = 'Загальні установки';
$string['editordefaultfont'] = 'Типовий шрифт';
$string['editorenablespelling'] = 'Включити перевірку орфографії';
$string['editorfontlist'] = 'Список шрифтів';
$string['editorfontsize'] = 'Типовий розмір шрифта';
$string['editorpreferences'] = 'Параметри редактора';
$string['editorresettodefaults'] = 'Повернутися до типових значень';
$string['editorsettings'] = 'Установки редактора';
$string['editorshortcutkeys'] = 'Редактор ключових слів';
$string['editsection'] = 'Редагувати налаштування';
$string['editsectionname'] = 'Редагувати назву секції';
$string['editsectionsettings'] = 'Редагувати налаштування розділу';
$string['editsectiontitle'] = 'Редагувати розділ: {$a}';
$string['editsettings'] = 'Редагувати параметри';
$string['editthisactivity'] = 'Редагувати діяльність';
$string['editthiscategory'] = 'Редагувати категорію';
$string['edittitle'] = 'Редагувати заголовок';
$string['edittitleinstructions'] = 'Натисніть "Esc" для скасування або "Enter" для завершення';
$string['edituser'] = 'Редагувати записи користувачів';
$string['edulevel'] = 'Усі події';
$string['edulevel_help'] = '* Навчання - дії, що виконуються викладачем, наприклад, оновлення ресурсу
* Участь - дії, що виконуються студентом, наприклад, розміщення повідомлення у форумі
* Інші - дії, що виконуються користувачем з іншою роллю, відмінною від викладача або студента';
$string['edulevelother'] = 'Інше';
$string['edulevelparticipating'] = 'Участь';
$string['edulevelteacher'] = 'Навчання';
$string['email'] = 'Електронна пошта';
$string['emailactive'] = 'Електронну пошту активовано';
$string['emailagain'] = 'Електронна пошта (повторно)';
$string['emailalreadysent'] = 'Лист з оновленим паролем вам вже надіслано. Будь ласка, перевірте вашу поштову скриньку.';
$string['emailcharset'] = 'Кодування електронної пошти';
$string['emailconfirm'] = 'Підтвердити обліковий запис';
$string['emailconfirmation'] = 'Привіт, {$a->firstname},

На "{$a->sitename}" надійшов запит на створення нового облікового запису
використовуючи вашу електронну адресу.

Щоб підтвердити свій новий обліковий запис, перейдіть за цією веб-адресою:

{$a->link}

У більшості поштових програм це має відображатися як синє посилання
яку можна просто натиснути. Якщо це не спрацює,
потім виріжте та вставте адресу в адресу
у верхній частині вікна веб-переглядача.

Якщо вам потрібна допомога, зверніться до адміністратора сайту,
{$a->admin}';
$string['emailconfirmationresend'] = 'Повторне підтвердження електронною поштою';
$string['emailconfirmationsubject'] = '{$a}: підтвердження облікового запису';
$string['emailconfirmsent'] = 'На зазначену Вами адресу електронної пошти (<b>{$a}</b>) було відправлено листа з інструкціями із завершення реєстрації. Якщо у Вас з\'являться проблеми з реєстрацією, зв\'яжіться з адміністратором сайту.';
$string['emailconfirmsentfailure'] = 'Не вдалося надіслати електронний лист із підтвердженням';
$string['emailconfirmsentsuccess'] = 'Електронний лист із підтвердженням успішно надіслано';
$string['emaildigest'] = 'Тип огляду';
$string['emaildigest_help'] = 'Це типове налаштування форумів для відправки щоденних зведень адресатам.

* Окремі повідомлення - ви будете отримувати на пошту окремо кожне повідомлення форуму.

* Дайджест - збірка повідомлень - ви будете отримувати на пошту щоденно збірку повідомлень форуму за день.

* Дайджест - збірка тем - ви будете отримувати на пошту щоденно збірку з тем повідомлень форуму за день.

Ви можете також вказати різні налаштування для різних форумів.';
$string['emaildigestcomplete'] = 'Зведення (щоденна пошта з повним текстом всіх повідомлень)';
$string['emaildigestoff'] = 'Не прочитані (окремі листи на кожне повідомлення)';
$string['emaildigestsubjects'] = 'Теми (щоденна пошта тільки з темами повідомлень)';
$string['emaildisable'] = 'Ця електронна адреса відключена';
$string['emaildisableclick'] = 'Клацніть тут, щоб заблокувати всю пошту, яка буде надходити на дану адресу.';
$string['emaildisplay'] = 'Видимість електронної пошти';
$string['emaildisplay_help'] = '* Приховано – лише користувачі з відповідними дозволами, наприклад викладачі, можуть переглядати вашу електронну адресу.
* Видимо для всіх – усі користувачі сайту можуть переглядати вашу електронну адресу.
* Видимо учасникам курсу – лише учасники курсів, на які ви зараховані, можуть переглядати вашу електронну адресу.';
$string['emaildisplaycourse'] = 'Видно учасникам курсу';
$string['emaildisplaycoursemembersonly'] = '(Бачать інші учасники курсу)';
$string['emaildisplayeveryone'] = '(Видимо всім)';
$string['emaildisplayhide'] = '(Приховано від усіх, крім користувачів із відповідними дозволами)';
$string['emaildisplayno'] = 'Прихований';
$string['emaildisplayyes'] = 'Видно для всіх';
$string['emailenable'] = 'Ця електронна адреса включена';
$string['emailenableclick'] = 'Клацніть тут, щоб дозволити всю пошту, яка буде надходити на цю адресу.';
$string['emailexists'] = 'Ця електронна пошта вже зареєстрована.';
$string['emailexistshintlink'] = 'Відновлення забутого імені користувача або пароля';
$string['emailexistssignuphint'] = 'Можливо, ви створювали обліковий запис у минулому? {$a}';
$string['emailformat'] = 'Формат повідомлень ел.пошти';
$string['emailmustbereal'] = 'Адреса вашої електронної пошти повинна бути реальною. На цю адресу буде відправлений ваш пароль.';
$string['emailnotallowed'] = 'Електронні адреси в цьому домені не підтримуються ({$a})';
$string['emailnotfound'] = 'Електронну адресу в базі даних не знайдено';
$string['emailonlyallowed'] = 'Цей електронний лист не можна використовувати. Дозволені домени електронної пошти: {$a}.';
$string['emailpasswordchangeinfo'] = 'Привіт, {$a->firstname},

Хтось (можливо Ви) запросив новий пароль для Вашого облікового запису на \'{$a->sitename}\'.

Для зміни Вашого паролю перейдіть, будь ласка, за цим посиланням:

{$a->link}

У більшості поштових програм, клацання на посиланні автоматично відкриє встановлений браузер. Якщо це не працює, то скопіюйте вказане посилання в адресний рядок браузера.

УВАГА! Перейшовши за посиланням, Ви тільки підтверджуєте своє бажання змінити пароль. Змінений пароль буде надіслано Вам у новому листі.

Якщо Вам потрібна допомога, будь ласка, звертайтеся до адміністратора,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Доброго дня, {$a->firstname}.

Хтось (можливо Ви) запросили новий пароль на сайт \'{$a->sitename}\'.

На жаль Ваш доступ на сайт заблоковано, і тому пароль не може бути зміненим, будь ласка, зверніться до адміністратора,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Привіт, {$a->firstname}!

Хтось (ймовірно, ви) запитав новий пароль для вашого облікового запису на "{$a->sitename}".

На жаль, паролі не можна скинути на цьому сайті. Зверніться до адміністратора сайту {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: інформація зміни проля';
$string['emailpasswordconfirmation'] = 'Вітаємо {$a->firstname}.

Хтось (швидше за все, Ви) запросив новий пароль для Вашого облікового запису на сайті \'{$a->sitename}\'.

Для підтвердження зміни й одержання нового пароля електронною поштою, перейдіть за посиланням:

{$a->link}

У більшості поштових програм, посилання повинні бути виділені синіми кольорами й автоматично запускати веб-оглядач при натисканні на них. Якщо посилання не виділено кольором, скопіюйте його в адресне поле Вашого оглядача. УВАГА! Перейшовши за посиланням, Ви тільки підтверджуєте своє бажання змінити пароль. Змінений пароль буде надіслано Вам у новому листі.

Якщо у Вас виникли проблеми, зверніться до адміністратора сайту,
 {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: підтвердження зміни пароля';
$string['emailpasswordconfirmmaybesent'] = '<p>Якщо Ви вказали правильне ім’я користувача або унікальну адресу електронної пошти, вам буде надіслано електронний лист.</p> <p>В ньому є прості інструкції щодо підтвердження та завершення зміни пароля. Якщо проблеми не зникнуть, зверніться до адміністратора сайту.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Вказаний вами обліковий запис не має зазначеної електронної пошти.</p> <p>Будь ласка, зверніться до адміністратора.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Надана вами деталь користувача не ідентифікує обліковий запис.</p> <p>Будь ласка, перевірте введену вами інформацію та спробуйте ще раз. Якщо проблеми будуть продовжуватися, будь ласка, зв\'яжіться з адміністратором сайту.</p>';
$string['emailpasswordconfirmsent'] = 'На Вашу адресу (<b>{$a}</b>) було відправлено листа. <br />Він містить інструкції із завершення зміни пароля. Якщо у Вас з\'являться якісь труднощі, зв\'яжіться з адміністратором сайту.';
$string['emailresetconfirmation'] = 'Привіт, {$a->firstname},

Надійшов запит на скидання пароля для вашого облікового запису \'{$a->username}\' на {$a->sitename}.

Щоб підтвердити цей запит і встановити новий пароль для свого облікового запису, перейдіть за такою веб-адресою:
<a href="{$a->link}">{$a->link}</a>

(Це посилання дійсне протягом {$a->resetminutes} хвилин з моменту першого запиту на скидання.)

Якщо ви не запитували це скидання пароля, нічого робити не потрібно.

Якщо вам потрібна допомога, зверніться до адміністратора сайту, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Запит на відновлення пароля';
$string['emailresetconfirmsent'] = 'Повідомлення було відправлено на вашу адресу <b>{$a}</b>. <br />Воно містить прості інструкції для підтвердження запиту та закінчення зміни пароля. Якщо вам потрібна допомога, будь ласка, зв\'яжіться з адміністрацією сайту.';
$string['emailstop'] = 'Вимкнути сповіщення';
$string['emailtoprivatefiles'] = 'Ви також можете відправляти файли як вкладення по ел. пошті прямо до своїх персональних файлів. Просто прикріпіть файли до листа ел.пошти та відправте його на  {$a}';
$string['emailtoprivatefilesdenied'] = 'Адміністратор відключив можливість завантажувати свої власні файли через ел.пошту.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Діяльності';
$string['emojicategoryanimalsnature'] = 'Тварини та природа';
$string['emojicategoryflags'] = 'Прапори';
$string['emojicategoryfooddrink'] = 'Їжа та напої';
$string['emojicategoryobjects'] = 'Об\'єкти';
$string['emojicategorypeoplebody'] = 'Люди і тіло';
$string['emojicategoryrecent'] = 'Останні';
$string['emojicategorysmileysemotion'] = 'Смайли та емоції';
$string['emojicategorysymbols'] = 'Символи';
$string['emojicategorytravelplaces'] = 'Подорожі та місця';
$string['emptycmids'] = 'Порожні ідентифікатори модулів курсу';
$string['emptydragdropregion'] = 'порожня область';
$string['emptysectionids'] = 'Ідентифікатори порожніх розділів';
$string['enable'] = 'Включити';
$string['encryptedcode'] = 'Зашифрований код';
$string['enddate'] = 'Дата завершення курсу';
$string['enddate_help'] = 'Дата закінчення не обмежує доступ студентів до курсу. Він визначає, чи є курс у списку «Минулий» у «Моїх курсах».';
$string['enddatewithtaskenabled'] = 'Дата закінчення курсу';
$string['enddatewithtaskenabled_help'] = 'Дата, коли курс стає прихованим для студентів, і вони більше не можуть отримати до нього доступ.';
$string['english'] = 'Англійська';
$string['enrolmentmethods'] = 'Методи зарахування';
$string['entercourse'] = 'Натисніть для входу до курсу';
$string['enteremail'] = 'Введіть вашу ел.адресу';
$string['enteremailaddress'] = 'Вкажіть адресу Вашої ел.пошти, щоб зґенерувати новий пароль';
$string['enterusername'] = 'Введіть ваше ім’я користувача';
$string['entries'] = 'Записи';
$string['error'] = 'Помилка';
$string['errorcreatingactivity'] = 'Неможливо створити екземпляр діяльності \'{$a}\'';
$string['errorfiletoobig'] = 'Файл був більше, ніж обмежання {$a} байт';
$string['errornouploadrepo'] = 'Завантаження з репозиторія не дозволене на цьому сайті';
$string['errorwhenconfirming'] = 'Ви не підтверджені, бо виникла помилка. Якщо ви перейшли сюди за гіперпосиланням з електронного листа, впевніться, що ваша пошта не пошкоджена і ви зробили все правильно. Спробуйте скопіювати адресу посилання з листа у веб-оглядач.';
$string['eventcommentcreated'] = 'Створено коментар';
$string['eventcommentdeleted'] = 'Вилучено коментар';
$string['eventcommentsviewed'] = 'Переглянуто коментарі';
$string['eventconfiglogcreated'] = 'Лог конфігурації створено';
$string['eventcontentviewed'] = 'Переглянуто коментар';
$string['eventcoursebackupcreated'] = 'Резервна копія курсу створена';
$string['eventcoursecategorycreated'] = 'Створено категорію';
$string['eventcoursecategorydeleted'] = 'Вилучено категорію';
$string['eventcoursecategoryupdated'] = 'Оновлено категорію';
$string['eventcoursecategoryviewed'] = 'Перегляд категорії';
$string['eventcoursecontentdeleted'] = 'Вилучено контент курсу';
$string['eventcoursecreated'] = 'Створено курс';
$string['eventcoursedeleted'] = 'Вилучено курс';
$string['eventcourseended'] = 'Курс закінчився';
$string['eventcourseinformationviewed'] = 'Суммарний перегляд курсу';
$string['eventcoursemodulecreated'] = 'Створено модуль курсу';
$string['eventcoursemoduledeleted'] = 'Вилучено модуль курсу';
$string['eventcoursemoduleinstancelistviewed'] = 'Переглянуто список модулів курсу';
$string['eventcoursemoduleupdated'] = 'Оновлено модуль курсу';
$string['eventcoursemoduleviewed'] = 'Переглянуто модуль курсу';
$string['eventcourseoverviewviewed'] = 'Перегляд сторінки з огляду на курс';
$string['eventcourseresetended'] = 'Завершено очищення курсу';
$string['eventcourseresetstarted'] = 'Розпочато очищення курсу';
$string['eventcourserestored'] = 'Відновлено курс';
$string['eventcoursesectioncreated'] = 'Секція курсу створена';
$string['eventcoursesectiondeleted'] = 'Вилучено секцію курсу';
$string['eventcoursesectionupdated'] = 'Оновлено секцію курсу';
$string['eventcoursessearched'] = 'Пошук курсів';
$string['eventcoursestarted'] = 'Курс розпочато';
$string['eventcourseupdated'] = 'Оновлено курс';
$string['eventcourseuserreportviewed'] = 'Переглянуто звіт користувача курсу';
$string['eventcourseviewed'] = 'Переглянуто курс';
$string['eventdashboardreset'] = 'Скидання панелі інструментів';
$string['eventdashboardsreset'] = 'Скидання панелі інструментів';
$string['eventdashboardviewed'] = 'Перегляд панелі інструментів';
$string['eventdatabasetextfieldcontentreplaced'] = 'Глобальний пошук та заміна бази даних';
$string['eventemailfailed'] = 'Не вдалося відправити ел.лист';
$string['eventmycoursesviewed'] = 'Мої курси переглянуто';
$string['eventname'] = 'Назва події';
$string['eventrecentactivityviewed'] = 'Переглянуто останні дії';
$string['eventsearchindexed'] = 'Пошук індексованих даних';
$string['eventsearchresultsviewed'] = 'Перегляд результатів пошуку';
$string['eventsectionviewed'] = 'Переглянуто розділ';
$string['eventunknownlogged'] = 'Невідома подія';
$string['eventurlblocked'] = 'URL-адресу заблоковано';
$string['eventusercreated'] = 'Створено користувача';
$string['eventuserdeleted'] = 'Вилучено користувача';
$string['eventuserfeedbackgiven'] = 'Натисніть на посилання для зворотного зв\'язку';
$string['eventuserfeedbackremind'] = 'Нагадати мені пізніше натиснути посилання для зворотного зв\'язку';
$string['eventuserinfocategorycreated'] = 'Створено поле категорії  профілю користувача';
$string['eventuserinfocategorydeleted'] = 'Видалено поле  категорії  профілю користувача';
$string['eventuserinfocategoryupdated'] = 'Оновлено поле  категорії  профілю користувача';
$string['eventuserinfofieldcreated'] = 'Поле профілю користувача створено';
$string['eventuserinfofielddeleted'] = 'Поле профілю користувача видалено';
$string['eventuserinfofieldupdated'] = 'Поле профілю користувача оновлено';
$string['eventuserlistviewed'] = 'Переглянуто список користувачів';
$string['eventuserloggedout'] = 'Користувач вийшов';
$string['eventuserpasswordpolicyfailed'] = 'Не вдалося ввести пароль користувача';
$string['eventuserpasswordupdated'] = 'Оновлено пароль користувача';
$string['eventuserprofileviewed'] = 'Переглянуто профіль користувача';
$string['eventuserupdated'] = 'Оновлено користувача';
$string['everybody'] = 'Кожен';
$string['executeat'] = 'Виконайте в';
$string['existing'] = 'Існуючий';
$string['existingadmins'] = 'Існуючі Адміністратори';
$string['existingcourse'] = 'Існуючі Курси';
$string['existingcourseadding'] = 'Існуючий курс, додати дані';
$string['existingcoursedeleting'] = 'Існуючий курс, попередньо видалити';
$string['existingcreators'] = 'Існуючі автори курсу';
$string['existingstudents'] = 'Зареєстровані студенти';
$string['existingteachers'] = 'Існуючі Викладачі';
$string['expand'] = 'Розгорнути';
$string['expandall'] = 'Розгорнути всі';
$string['expandcategory'] = 'Розгорнути {$a}';
$string['explanation'] = 'Пояснення';
$string['explanationdigitalminor'] = 'Ця інформація необхідна для визначення, чи перевищив ваш вік цифровий вік згоди. Це вік, коли особа може дати згоду на обробку, а їхні дані зберігаються та обробляються на законних підставах.';
$string['extendperiod'] = 'Збільшити період';
$string['extendsession'] = 'Розширити сеанс';
$string['failedloginattempts'] = '{$a->attempts} невдалих спроб увійти після вашого останього входу';
$string['failedtaskbody'] = '<p>Вітаю, {$a->firstname},</p>
<p>Завдання <b>{$a->taskname}</b> кілька разів зазнало помилок і потребує уваги.</p>
<p><a href="{$a->link}">Переглянути завдання</a></p>';
$string['failedtaskcontexturlname'] = 'Звіт про стан';
$string['failedtasksubject'] = 'Помилка завдання: {$a}';
$string['favourites'] = 'Зірочка';
$string['feedback'] = 'Коментар';
$string['file'] = 'Файл';
$string['fileexists'] = 'Файл з назвою {$a} вже існує';
$string['filemissing'] = 'не вистачає {$a}';
$string['filereaderror'] = 'Не вдається прочитати файл \'{$a}\'. Переконайтесь, що це справді файл, а не папка.';
$string['files'] = 'Файли';
$string['filesanduploads'] = 'Файли і завантаження';
$string['filesfolders'] = 'Файли/Теки';
$string['fileuploadwithcontent'] = 'Завантажуваний файл не повинен містити параметр контенту';
$string['filloutallfields'] = 'Заповніть необхідні поля у формі';
$string['filter'] = 'Фільтр';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Фільтр {$a}';
$string['filters'] = 'Фільтри';
$string['filtersetmatchdescription'] = 'Як поєднувати кілька фільтрів';
$string['filtertype'] = 'Тип фільтра';
$string['findmorecourses'] = 'Знайти більше курсів...';
$string['first'] = 'Перший';
$string['firstaccess'] = 'Перший доступ';
$string['firstname'] = 'Ім\'я';
$string['firstnamephonetic'] = 'Ім\'я - фонетично';
$string['firstpage'] = 'Перша сторінка';
$string['firstsiteaccess'] = 'Перший вхід на сайт';
$string['firsttime'] = 'Ви вперше на нашому сайті?';
$string['folder'] = 'Тека';
$string['folderclosed'] = 'Закрита тека';
$string['folderopened'] = 'Відкрита тека';
$string['followingoptional'] = 'Наступні елементи є необов\'язковими';
$string['followingrequired'] = 'Наступні елементи є необхідними';
$string['for'] = 'Для';
$string['force'] = 'Примусово';
$string['forcelanguage'] = 'Примусова мова';
$string['forceno'] = 'Не примушувати';
$string['forcepasswordchange'] = 'Примусити змінити пароль';
$string['forcepasswordchange_help'] = 'Якщо ця галочка встановлена, користувачеві буде запропоновано змінити пароль при наступному входженні';
$string['forcepasswordchangecheckfull'] = 'Ви абсолютно впевнені, що хочете примусити змінити пароль {$a} ?';
$string['forcepasswordchangenot'] = 'Не можна примусити змінити пароль {$a}';
$string['forcepasswordchangenotice'] = 'Щоб продовжити, ви повинні змінити свій пароль.';
$string['forcepasswordresetfailurenotice'] = 'Ваш поточний пароль більше не відповідає встановленій політиці щодо паролів. Будь ласка, зверніться до свого адміністратора Moodle за допомогою.
   {$a}';
$string['forcepasswordresetnotice'] = 'Ваш поточний пароль більше не проходить політику встановленого пароля, вам потрібно скинути пароль для входу.
   {$a}';
$string['forcetheme'] = 'Примусова тема';
$string['forgotaccount'] = 'Забули пароль?';
$string['forgotten'] = 'Забули ім\'я або пароль?';
$string['forgottenduplicate'] = 'Адреса електронної пошти розподілена на кілька облікових записів, будь ласка, зайдіть через свій логін (ім’я користувача).';
$string['forgotteninvalidurl'] = 'Хибний URL для відновлення паролю';
$string['format'] = 'Формат';
$string['formathtml'] = 'HTML-формат';
$string['formatmarkdown'] = 'Markdown формат';
$string['formatplain'] = 'Текстовий формат';
$string['formattext'] = 'Авто-формат';
$string['forumpreferences'] = 'Параметри форума';
$string['framesetinfo'] = 'Цей головний документ вміщує:';
$string['fromdate'] = 'Від';
$string['fromsender'] = 'Від';
$string['frontpagecategorycombo'] = 'Список за категоріями';
$string['frontpagecategorynames'] = 'Список категорій';
$string['frontpagecourselist'] = 'Список курсів';
$string['frontpagecoursesearch'] = 'Пошук курсу';
$string['frontpagedescription'] = 'Опис головної сторінки сайту';
$string['frontpagedescriptionhelp'] = 'Цей опис можна відобразити на домашній сторінці сайту за допомогою блоку зведення курсу/сайту.';
$string['frontpageenrolledcourselist'] = 'Зареєстровані курси';
$string['frontpageformat'] = 'Вигляд головної сторінки сайту';
$string['frontpageformatloggedin'] = 'Формат головної сторінки після входу';
$string['frontpagenews'] = 'Оголошення';
$string['frontpagesettings'] = 'Налаштування головної сторінка';
$string['fulllistofcourses'] = 'Всі курси';
$string['fullname'] = 'Повна назва';
$string['fullnamecourse'] = 'Повна назва курсу';
$string['fullnamecourse_help'] = 'Назва, яка відображається в розділі «Мої курси» та в списку доступних курсів на головній сторінці.';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = 'Повне ім\'я користувача';
$string['fullprofile'] = 'Дані про користувача';
$string['fullsitename'] = 'Повна назва сайту';
$string['functiondisabled'] = 'Ця функція в даний момент відключена';
$string['general'] = 'Основне';
$string['geolocation'] = 'широта - довгота';
$string['gettheselogs'] = 'Отримати ці події';
$string['go'] = 'Застосувати';
$string['gobacktosite'] = 'Повернутися на сайт';
$string['gpl'] = 'Авторське право (C) 1999 і далі Martin Dougiamas (https://moodle.com)

Ця програма є безкоштовним; ви можете поширювати його та/або змінювати згідно з умовами GNU General Public License, опублікованої Free Software Foundation; версії 2 Ліцензії або (на ваш вибір) будь-якої пізнішої версії.

Ця програма розповсюджується в надії, що вона буде корисною, але БЕЗ ЖОДНИХ ГАРАНТІЙ; навіть без неявної гарантії ПРИДАТНОСТІ ДЛЯ ПРОДАЖУ чи ВІДПОВІДНОСТІ ДЛЯ КОНКРЕТНОЇ МЕТИ.

Перегляньте сторінку інформації про ліцензію Moodle, щоб отримати повну інформацію: https://moodledev.io/general/licens';
$string['gpl3'] = 'Авторське право (C) 1999 і далі Martin Dougiamas (https://moodle.com)

Ця програма є безкоштовним програмним забезпеченням: ви можете поширювати її та/або змінювати згідно з умовами GNU General Public License, опублікованої Free Software Foundation, версії 3 Ліцензії або (на ваш вибір) будь-якої пізнішої версії.

Ця програма розповсюджується в надії, що вона буде корисною, але БЕЗ ЖОДНИХ ГАРАНТІЙ; навіть без неявної гарантії ПРИДАТНОСТІ ДЛЯ ПРОДАЖУ чи ВІДПОВІДНОСТІ ДЛЯ КОНКРЕТНОЇ МЕТИ.

Перегляньте сторінку інформації про ліцензію Moodle, щоб отримати повну інформацію: https://moodledev.io/general/license';
$string['gpllicense'] = 'Ліцензія GPL';
$string['gradenoun'] = 'Оцінка';
$string['grades'] = 'Журнал оцінок';
$string['gradeverb'] = 'Оцінка';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> увімкнено для цього сайту. Якщо ви не завантажите зображення профілю, Moodle спробує завантажити для вас зображення профілю з Gravatar.';
$string['group'] = 'Група';
$string['groupadd'] = 'Додати нову групу';
$string['groupaddusers'] = 'Додати вибраних у групу';
$string['groupfor'] = 'для групи';
$string['groupinfo'] = 'Інформація про вибрану групу';
$string['groupinfoedit'] = 'Редагувати параметри групи';
$string['groupinfomembers'] = 'Інформація про вибраних користувачів';
$string['groupinfopeople'] = 'Інформація про вибраного користувача';
$string['groupmembers'] = 'Учасники групи';
$string['groupmemberssee'] = 'Переглянути учасників групи';
$string['groupmembersselected'] = 'Учасники вибраної групи';
$string['groupmode'] = 'Режим роботи з групами';
$string['groupmodeforce'] = 'Примусовий режим роботи з групами';
$string['groupmy'] = 'Моя група';
$string['groupnonmembers'] = 'Користувачі не в групі';
$string['groupnotamember'] = 'Вибачте, ви не є членом даної групи';
$string['grouprandomassign'] = 'Випадково призначити всіх по групах';
$string['groupremove'] = 'Видалити вибрану групу';
$string['groupremovemembers'] = 'Видалити вибраних користувачів';
$string['groups'] = 'Групи';
$string['groupsnone'] = 'Немає груп';
$string['groupsseparate'] = 'Окремі групи';
$string['groupsvisible'] = 'Доступні групи';
$string['guest'] = 'Гість';
$string['guestdescription'] = 'Гість має мінімальні привілеї і, зазвичай, не може додавати текстову інформацію ніде.';
$string['guestskey'] = 'Допускати гостя, що має ключ';
$string['guestsno'] = 'Не допускати гостя';
$string['guestsnotallowed'] = 'До курсу \'{$a}\' не передбачено гостьовий допуск';
$string['guestsyes'] = 'Допускати гостя без ключа';
$string['guestuser'] = 'Гість-користувач';
$string['guestuserinfo'] = 'Користувач, що має права тільки на читання';
$string['help'] = 'Допомога';
$string['helpprefix2'] = 'Допомогти з {$a}';
$string['helpwiththis'] = 'Допоможіть з цим';
$string['hiddenassign'] = 'Сховане призначення';
$string['hiddenfromstudents'] = 'Сховане від студентів';
$string['hiddenoncoursepage'] = 'Доступно, але не показано на сторінці курсу';
$string['hiddensections'] = 'Приховані секції';
$string['hiddensections_help'] = 'Приховані розділи можуть відображатися студентам як «недоступні» на сторінці курсу або залишатися повністю прихованими.';
$string['hiddensectionscollapsed'] = 'Приховані розділи відображаються як недоступні';
$string['hiddensectionsinvisible'] = 'Приховані розділи повністю невидимі';
$string['hiddenwithbrackets'] = '(приховано)';
$string['hide'] = 'Сховати';
$string['hideadvancedsettings'] = 'Сховати додаткові параметри';
$string['hidecategory'] = 'Сховати категорію?';
$string['hidecategorymany'] = 'Категорія {$a->category} містить {$a->coursecount} курсів.
<br/>Якщо ви приховаєте його, користувачі без дозволу на перегляд прихованих категорій більше не матимуть доступу до курсів.';
$string['hidecategoryone'] = 'Категорія {$a->category} містить 1 курс.
<br/>Якщо ви приховаєте його, користувачі без дозволу на перегляд прихованих категорій більше не матимуть доступу до курсу.';
$string['hidechartdata'] = 'Приховати дані графіку';
$string['hidefromstudents'] = 'Сховати на сторінці курсу';
$string['hideoncoursepage'] = 'Зробити доступним, але не показувати на сторінці курсу';
$string['hidepopoverwindow'] = 'Сховати спливаюче вікно';
$string['hidesection'] = 'Сховати секцію {$a}';
$string['hidesettings'] = 'Сховати налаштування';
$string['hideshowblocks'] = 'Показати або приховати блоки';
$string['highlight'] = 'Виділити';
$string['highlighted'] = 'Виділено';
$string['highlightoff'] = 'Зняти виділення';
$string['hits'] = 'Звернення';
$string['hitsoncourse'] = 'Звернення {$a->username} до курсу {$a->coursename}';
$string['hitsoncoursetoday'] = 'Сьогоднішні звернення {$a->username} до курсу {$a->coursename}';
$string['home'] = 'На головну';
$string['homeheader'] = 'Головне меню';
$string['hour'] = 'година';
$string['hours'] = 'години';
$string['howtomakethemes'] = 'Як створити новий дизайн';
$string['htmleditor'] = 'Використати HTML-редактор';
$string['htmleditoravailable'] = 'Редактор Richtext доступний для використання';
$string['htmleditordisabled'] = 'Ви скасували можливість використання Richtext-редактора при заповненні інформації про користувача';
$string['htmleditordisabledadmin'] = 'Адміністратор скасував можливість використання Richtext-редактора на цьому сайті';
$string['htmleditordisabledbrowser'] = 'HTML редактор недоступний, тому що ваш браузер не підтримується';
$string['htmlfilesonly'] = 'Тільки HTML файли';
$string['htmlformat'] = 'HTML-формат';
$string['icon'] = 'Значок';
$string['idnumber'] = 'Індивідуальний номер';
$string['idnumbercourse'] = 'Ідентифікатор курсу';
$string['idnumbercourse_help'] = 'Використовується лише для підключення курсу до зовнішніх систем. Залиште поле порожнім, якщо у вас немає офіційного ідентифікатора курсу.';
$string['idnumbercoursecategory'] = 'Код категорії';
$string['idnumbercoursecategory_help'] = 'Цей ідентифікаційний номер категорії курсів використовується тільки для зіставлення категорії із зовнішніми системами і більше ніде на сайті не відображається. Якщо у категорії є офіційна кодова назва, його можна ввести тут, в інших випадках можна просто залишити поле порожнім.';
$string['idnumbergroup'] = 'ID групи';
$string['idnumbergroup_help'] = 'Ідентифікаційний номер групи використовується тільки при узгодженні груп із зовнішніми системами і ніде не відображатиметься на сайті. ID може бути введений, якщо група має офіційно призначений код; інакше поле може бути порожнім.';
$string['idnumbergrouping'] = 'ID групування';
$string['idnumbergrouping_help'] = 'Ідентифікаційний номер потоку використовується тільки при узгодженні потоку із зовнішніми системами і ніде не відображатиметься на сайті. ID може бути введений, якщо потік має офіційно призначений код; інакше поле може бути порожнім.';
$string['idnumbermod'] = 'Ідентифікатор';
$string['idnumbermod_help'] = 'Встановлення ідентифікаційного номера надає спосіб ідентифікації діяльності або ресурсу для таких цілей, як обчислення оцінок або користувацькі звіти. Інакше поле може залишитися порожнім.

Для занять, які можна оцінювати, ідентифікаційний номер також можна встановити в книзі оцінок, хоча його можна редагувати лише на сторінці налаштувань діяльності.';
$string['idnumbertaken'] = 'Цей ідентифікатор вже зайнято';
$string['imagealt'] = 'Опис фотографії';
$string['import'] = 'Імпорт';
$string['importdata'] = 'Імпортувати дані курсу';
$string['importdataexported'] = 'Експортування даних "з" курсу закінчено.<br /> Продовжити імпорт "до" вашого курсу.';
$string['importdatafinished'] = 'Імпорт закінчено! Продовжити роботу з вашим курсом';
$string['importdatafrom'] = 'Знайдіть, звідки курс повинен імпортувати дані:';
$string['importinfo'] = 'Імпорт елементів з інших курсів, таких як дії, блоки або події календаря. Дані користувача не будуть імпортовані.';
$string['inactive'] = 'Не активний';
$string['include'] = 'Включити';
$string['includeallusers'] = 'Включаючи всіх користувачів';
$string['includecoursefiles'] = 'Включаючи файли курсу';
$string['includecourseusers'] = 'Включаючи користувачів курсу';
$string['included'] = 'Включені';
$string['includelogentries'] = 'Включаючи вміст логів';
$string['includemodules'] = 'Включаючи модулі';
$string['includemoduleuserdata'] = 'Включаючи модуль даних користувача';
$string['includeneededusers'] = 'Включаючи необхідних користувачів';
$string['includenoneusers'] = 'Не включати жодного користувача';
$string['includeroleassignments'] = 'Включаючи призначених на роль користувачів';
$string['includesitefiles'] = 'Включаючи файли сайту використані в цьому курсі';
$string['includesubcategories'] = 'Включно з підкатегоріями';
$string['includeuserfiles'] = 'Включаючи файли користувачів';
$string['increasesections'] = 'Збільшити кількість розділів';
$string['indicator:accessesafterend'] = 'Курс доступний після закінчення дати';
$string['indicator:accessesafterend_help'] = 'Цей показник відображає, чи студент скористався курсом після закінчення курсу.';
$string['indicator:accessesbeforestart'] = 'Курс доступний до дати початку';
$string['indicator:accessesbeforestart_help'] = 'Цей показник відображає, якщо студент відвідував курс до дати початку курсу.';
$string['indicator:activitiesdue'] = 'Належні заходи';
$string['indicator:activitiesdue_help'] = 'Користувач має належні дії.';
$string['indicator:anycourseaccess'] = 'Будь-який доступ до курсу';
$string['indicator:anycourseaccess_help'] = 'Цей показник відображає доступ до будь-якого курсу, до якого зареєстрований користувач.';
$string['indicator:anywrite'] = 'Будь-яка операція запису';
$string['indicator:anywrite_help'] = 'Цей показник представляє будь-яку дію написання (подання), яку зробив студент.';
$string['indicator:anywriteincourse'] = 'Будь-яка дія напису в курсі';
$string['indicator:anywriteincourse_help'] = 'Цей показник показує будь-яке написання (подання) дії, здійснені студентом у будь-якому курсі.';
$string['indicator:completeduserprofile'] = 'Профіль користувача заповнений';
$string['indicator:completeduserprofile_help'] = 'Цей показник показує, що студент заповнив свій профіль користувача.';
$string['indicator:completeduserprofiledef'] = 'Профіль користувача заповнений';
$string['indicator:completeduserprofiledef_help'] = 'Політика щодо сайту була погоджена, і користувач заповнив наступні поля: Установа, Департамент, Адреса, Місто, Країна, URL.';
$string['indicator:completionenabled'] = 'Відстеження заповнення включено';
$string['indicator:completionenabled_help'] = 'Цей показник показує, що для цього курсу було включено відстеження заповненності.';
$string['indicator:nostudent'] = 'Зарахування студентів';
$string['indicator:nostudent_help'] = 'Цей показник показує доступних студентів на курсі.';
$string['indicator:noteacher'] = 'Доступні викладачі';
$string['indicator:noteacher_help'] = 'Цей показник показує доступних викладачів на курсі.';
$string['indicator:potentialcognitive'] = 'Потенційна пізнавальна глибина курсу';
$string['indicator:potentialcognitive_help'] = 'Цей показник базується на потенційній глибині пізнання, яку може досягти студент, що бере участь у  заходах курсу.';
$string['indicator:potentialcognitivedef'] = 'Потенційний курс пізнавальної глибини';
$string['indicator:potentialcognitivedef_help'] = 'Ступінь, до якого курс пропонує "глибоке" когнітивне залучення, напр. подання роботи для зворотного зв’язку, можливість переглянути роботу інших та можливість переглянути та повторно подати роботу.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Потенційна соціальна ширина курсу';
$string['indicator:potentialsocial_help'] = 'Цей показник базується на потенційній соціальній широті, яку може досягти студент, що бере участь у заходах курсу.';
$string['indicator:potentialsocialdef'] = 'Потенційна соціальна широта курсу';
$string['indicator:potentialsocialdef_help'] = 'Ступінь, до якої курс пропонує «широке» соціальне залучення, взаємодію з іншими учасниками та спільнотою практики за межами класу.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Читайте обсяг дій';
$string['indicator:readactions_help'] = 'Цей показник відображає кількість прочитаних (переглянутих) дій студента.';
$string['indicator:userforumstracking'] = 'Користувач відстежує форуми';
$string['indicator:userforumstracking_help'] = 'Цей показник вказує на те, чи включений учень у відстеження на форумах.';
$string['info'] = 'Інформація';
$string['inprogress'] = 'В процесі';
$string['insertcontentbefore'] = 'Вставити вміст перед \'{$a->activityname}\'';
$string['insertresourceoractivitybefore'] = 'Вставте дію або ресурс перед \'{$a->activityname}\'';
$string['institution'] = 'Заклад';
$string['instudentview'] = 'в студентському перегляді';
$string['interests'] = 'Інтереси';
$string['interestslist'] = 'Список інтересів';
$string['interestslist_help'] = 'Введіть свої інтереси один за іншим, які потім відображатимуться на сторінці вашого профілю як теги.';
$string['invalidemail'] = 'Неправильний формат для ел.пошти';
$string['invalidlogin'] = 'Ви не пройшли ідентифікацію (неправильне ім’я користувача або пароль).
Спробуйте ще раз.';
$string['invalidtaskclassname'] = 'Недійсний клас завдання {$a}';
$string['invalidtaskid'] = 'Недійсний ідентифікатор завдання';
$string['invalidusername'] = 'Ім’я користувача може містити лише буквено-цифрові символи нижнього регістру (літери та цифри), підкреслення (_), дефіс (-), крапку (.) або символ (@).';
$string['invalidusernameupload'] = 'Неправильне ім’я користувача';
$string['ip_address'] = 'IP-адреса';
$string['jump'] = 'Перейти';
$string['jumpto'] = 'Перейти до...';
$string['keep'] = 'Утримувати';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Напрямок друкування символів - зліва направо';
$string['langrtl'] = 'Напрямок друкування символів - справа наліво';
$string['language'] = 'Мова інтерфейсу';
$string['languagegood'] = 'Цей мовний пакет оновлений.';
$string['languageselector'] = 'Селектор мови';
$string['last'] = 'Останній';
$string['lastaccess'] = 'Останній вхід на сайт';
$string['lastcourseaccess'] = 'Останній вхід на курс';
$string['lastedited'] = 'Останнє редагування';
$string['lastip'] = 'Остання ІР адреса';
$string['lastlogin'] = 'Останній вхід';
$string['lastmodified'] = 'Остання зміна';
$string['lastname'] = 'Прізвище';
$string['lastnamephonetic'] = 'Прізвище - фонетично';
$string['lastpage'] = 'Остання сторінка';
$string['lastsiteaccess'] = 'Останній вхід на сайт';
$string['lastyear'] = 'Останній рік';
$string['latestlanguagepack'] = 'Перевірити на moodle.org';
$string['layouttable'] = 'Шар таблиці';
$string['leavetokeep'] = 'Залишіть поле порожнім, щоб зберегти поточний пароль';
$string['legacylogginginuse'] = 'На цьому сайті наразі дозволено запис до застарілого журналу подій. Такий підхід скоро не буде підтримуватися. Рекомендуємо вести записи в підтримуваному журналі подій - стандартному або зовнішньому.';
$string['legacythemeinuse'] = 'Цей сайт відображається вам у режимі сумісності, тому що Ваш браузер застарів.';
$string['license'] = 'Ліцензія';
$string['licenses'] = 'Ліцензії';
$string['liketologin'] = 'Ви бажаєте увійти з повними правами користувача?';
$string['list'] = 'Список';
$string['listfiles'] = 'Список файлів в {$a}';
$string['listofallpeople'] = 'Список учасників';
$string['listofcourses'] = 'Збільшити кількість розділів';
$string['loading'] = 'Завантаження';
$string['loadinghelp'] = 'Завантаження...';
$string['local'] = 'Локально';
$string['localplugins'] = 'Локальний модуль';
$string['localpluginsmanage'] = 'Управляти локальними модулями';
$string['location'] = 'Розміщення';
$string['locktimeout'] = 'Для операції минув час очікування блокування.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Ви зайшли під ім\'ям {$a}';
$string['loggedinasguest'] = 'Наразі ви використовуєте гостьовий доступ';
$string['loggedinnot'] = 'Ви не пройшли ідентифікацію';
$string['login'] = 'Увійти';
$string['login_failure_logs'] = 'Записи подій про невдалі спроби входу';
$string['loginactivity'] = 'Діяльність входу';
$string['loginagain'] = 'Увійдіть знову';
$string['loginalready'] = 'Ви вже зайшли';
$string['loginas'] = 'Увійти як';
$string['loginaspasswordexplain'] = '<p>Ви повинні ввести спеціальний пароль для використання цієї особливості.<br />Якщо ви його не знаєте, звертайтесь до адміністратора сервера.</p>';
$string['loginguest'] = 'Доступ як гість';
$string['loginsite'] = 'Увійдіть на сайт';
$string['loginsteps'] = 'Для повноцінного доступу до цього сайту Вам потрібно створити обліковий запис.';
$string['loginstepsnone'] = '<p>Привіт!</p> <p>Для доступу до курсу вам необхідно зареєструватися</p><p>Все що вам потрібно зробити - це вказати ім’я користувача і пароль, які будуть використовуватись на цьому сайті.</p><p>Якщо хтось інший вже обрав таке ім’я користувача, вам необхідно його змінити.</p>';
$string['loginto'] = 'Увійти до  {$a}';
$string['logoof'] = 'Логотип {$a}';
$string['logout'] = 'Вийти';
$string['logoutconfirm'] = 'Ви дійсно бажаєте вийти з системи?';
$string['logs'] = 'Події';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">більше</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">більше</a> ]';
$string['lookback'] = 'Період';
$string['mailadmins'] = 'Інформувати адміністраторів';
$string['mailstudents'] = 'Інформувати студентів';
$string['mailteachers'] = 'Інформувати викладачів';
$string['maincoursepage'] = 'Головна сторінка курсу';
$string['makeafolder'] = 'Створити теку';
$string['makeavailable'] = 'Зробити доступним';
$string['makeeditable'] = 'Якщо Ви зробили \'{$a}\' - процесом, що дозволяє редагування за допомогою web-сервера (наприклад, apache) Ви можете редагувати цей файл безпосередньо з цієї сторінки';
$string['makethismyhome'] = 'Зробіть це моєю домашньою сторінкою';
$string['makeunavailable'] = 'Зробити недоступним';
$string['manageblocks'] = 'Блоки';
$string['managecategories'] = 'Керуйте категоріями курсів';
$string['managecategorythis'] = 'Керувати цією категорією';
$string['managecombined'] = 'Керуйте категоріями курсів і курсами';
$string['managecontentbanktypes'] = 'Керуйте типами вмісту';
$string['managecourses'] = 'Керувати курсами';
$string['managedatabase'] = 'База даних';
$string['managedataformats'] = 'Керування форматами даних';
$string['manageeditorfiles'] = 'Управляти файлами використовуючи редактор';
$string['managefilters'] = 'Фільтри';
$string['managemodules'] = 'Модулі';
$string['manageroles'] = 'Ролі та права';
$string['markallread'] = 'Позначити все як прочитане';
$string['match'] = 'Відповідність';
$string['matchingsearchandrole'] = 'Відповідність \'{$a->search}\' та {$a->role}';
$string['matchofthefollowing'] = 'з наступного:';
$string['maxareabytesreached'] = 'Файл (чи загальний розмір кількох файлів) більший ніж наявний простір в цьому місці';
$string['maxfilesize'] = 'Максимальний обсяг для нових файлів: {$a}';
$string['maxfilesreached'] = 'До цього елементу дозволено прикріплювати не більше {$a} файлу(ів)';
$string['maximumchars'] = 'Максимум {$a} символів';
$string['maximumgrade'] = 'Максимальна оцінка';
$string['maximumgradex'] = 'Максимальна оцінка: {$a}';
$string['maximumshort'] = 'Максимум';
$string['maximumupload'] = 'Максимальний обсяг файлу для завантаження';
$string['maximumupload_help'] = 'Максимальний розмір файлу, дозволений для завантаження студентів у курс. Крім того, ви можете додатково обмежити максимальний розмір завантаження для кожної дії.';
$string['maxnumberweeks'] = 'Максимальна кількість секцій';
$string['maxnumberweeks_desc'] = 'Максимальне значення у випадному меню кількості розділів (застосовується лише до певних форматів курсу).';
$string['maxnumcoursesincombo'] = 'Огляд <a href="{$a->link}">{$a->numberofcourses} курсів</a>.';
$string['maxsectionslimit'] = 'Неможливо створити новий розділ, оскільки він перевищить максимальну кількість розділів, дозволених для цього курсу ({$a}).';
$string['maxsize'] = 'Максимальний обсяг: {$a}';
$string['maxsizeandareasize'] = 'Максимальний розмір для нових файлів: {$a->size}, загальне обмеження: {$a->areasize}';
$string['maxsizeandattachments'] = 'Максимальний розмір файлу: {$a->size}, максимальна кількість файлів: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Максимальний розмір файлу: {$a->size}, максимальна кількість файлів: {$a->attachments}, максимальний загальний розмір: {$a->areasize}';
$string['memberincourse'] = 'Учасники курсу';
$string['menu'] = 'Меню';
$string['message'] = 'Повідомлення';
$string['messagebody'] = 'Тіло повідомлення';
$string['messagedselectedusers'] = 'Оберіть користувачів, яким були надіслані повідомлення і які відреагували на них.';
$string['messagedselectedusersfailed'] = 'Відбулася помилка при інформуванні вибраних користувачів. Деякі можливо отримали електронне повідомлення.';
$string['messageprovider:asyncbackupnotification'] = 'Асинхронні сповіщення про резервне копіювання/відновлення';
$string['messageprovider:availableupdate'] = 'Доступні повідомлення про оновлення';
$string['messageprovider:backup'] = 'Повідомлення резервного копіювання';
$string['messageprovider:badgecreatornotice'] = 'Повідомлення творця відзнаки';
$string['messageprovider:badgerecipientnotice'] = 'Повідомлення отримувача відзнаки';
$string['messageprovider:competencyplancomment'] = 'Опубліковано коментар до плану навчання';
$string['messageprovider:competencyusercompcomment'] = 'Опубліковано коментар до компетенції';
$string['messageprovider:coursecompleted'] = 'Курс завершено';
$string['messageprovider:coursecontentupdated'] = 'Зміни змісту курсу';
$string['messageprovider:courserequestapproved'] = 'Повідомлення про схвалення створення замовленого курсу';
$string['messageprovider:courserequested'] = 'Повідомлення про замовлення на створення курсу';
$string['messageprovider:courserequestrejected'] = 'Повідомлення про відмову створення замовленого курсу';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Вітальне повідомлення для записів на нові курси';
$string['messageprovider:errors'] = 'Важливі помилки з сайту';
$string['messageprovider:errors_help'] = 'Це важливі помилки, про які повинен знати адміністратор.';
$string['messageprovider:failedtaskmaxdelay'] = 'Завдання досягає максимальної затримки помилки';
$string['messageprovider:gradenotifications'] = 'Повідомлення про оцінку';
$string['messageprovider:infected'] = 'Повідомлення про збій антивіруса.';
$string['messageprovider:insights'] = 'Статистика, сформована моделями прогнозування';
$string['messageprovider:instantmessage'] = 'Персональні повідомлення між користувачами';
$string['messageprovider:instantmessage_help'] = 'У цьому розділі налаштовується, що відбувається з повідомленнями, які відправляються вам безпосередньо від інших користувачів на цьому сайті.';
$string['messageprovider:messagecontactrequests'] = 'Повідомлення про запити на контакт';
$string['messageprovider:newlogin'] = 'Нові сповіщення про вхід';
$string['messageprovider:notices'] = 'Повідомлення про незначні проблеми';
$string['messageprovider:notices_help'] = 'Це повідомлення, які можуть зацікавити адміністратора.';
$string['messageprovider:reportbuilderschedule'] = 'Спеціальні розклади конструктора звітів';
$string['messageselect'] = 'Вибрати цього користувача як отримувача пошти';
$string['messageselectadd'] = 'Надіслати повідомлення';
$string['middlename'] = 'По батькові';
$string['migratinggrades'] = 'Перенесення оцінок';
$string['min'] = 'хв';
$string['mins'] = 'хв';
$string['minute'] = 'хвилин';
$string['minutes'] = 'хвилин(а)';
$string['miscellaneous'] = 'Різне';
$string['missingcategory'] = 'Оберіть категорію';
$string['missingdescription'] = 'Не вказано опис';
$string['missingemail'] = 'Не вказано адресу електронної пошти';
$string['missingfirstname'] = 'Не вказано ім\'я';
$string['missingfromdisk'] = 'Не вказано диск';
$string['missingfullname'] = 'Не вказано повне ім\'я';
$string['missinglastname'] = 'Відсутнє прізвище';
$string['missingname'] = 'Не вказано ім\'я';
$string['missingnewpassword'] = 'Не вказано новий пароль';
$string['missingpassword'] = 'Не вказано пароль';
$string['missingrecaptchachallengefield'] = 'Не вдалося виконати випробування reCAPTCHA, спробуйте ще раз.';
$string['missingreqreason'] = 'Не вказано причину';
$string['missingshortname'] = 'Не вказано коротке ім\'я';
$string['missingshortsitename'] = 'Не вказана коротка назва сайту';
$string['missingsitedescription'] = 'Не вказано опис сайту';
$string['missingsitename'] = 'Не вказана назва сайту';
$string['missingstrings'] = 'Перевірка перекладу';
$string['missingstudent'] = 'Необхідно що-небудь вибрати';
$string['missingsummary'] = 'Не вказана анотація';
$string['missingteacher'] = 'Необхідно що-небудь вибрати';
$string['missingurl'] = 'Неправильний URL';
$string['missingusername'] = 'Бракує імені користувача';
$string['moddoesnotsupporttype'] = 'Модуль {$a ->modname} не підтримує завантаження типу {$a ->type}';
$string['modhide'] = 'Сховати';
$string['modified'] = 'Змінено';
$string['modshow'] = 'Показати';
$string['moduleintro'] = 'Опис';
$string['modulesetup'] = 'Налаштування таблиць модуля';
$string['modulesuccess'] = '{$a} таблиця успішно налаштована';
$string['modulesused'] = 'Модулі використовуються';
$string['modvisible'] = 'Доступність';
$string['modvisible_help'] = '* Показати на сторінці курсу: доступно для студентів (з урахуванням будь-яких обмежень доступу, які можуть бути встановлені).
* Сховати на сторінці курсу: недоступно для студентів.';
$string['modvisiblehiddensection'] = 'Доступність';
$string['modvisiblehiddensection_help'] = '* Сховати на сторінці курсу: недоступно для студентів.
* Зробити доступним, але не показувати на сторінці курсу: доступно для студентів, якщо ви надасте посилання. Діяльність усе одно відображатиметься в журналі оцінок та інших звітах.';
$string['modvisiblewithstealth'] = 'Доступність';
$string['modvisiblewithstealth_help'] = '* Показати на сторінці курсу: доступно для студентів (з урахуванням будь-яких обмежень доступу, які можуть бути встановлені).
* Сховати на сторінці курсу: недоступно для студентів.
* Зробити доступним, але не показувати на сторінці курсу: доступно для студентів, якщо ви надасте посилання. Діяльність усе одно відображатиметься в журналі оцінок та інших звітах.';
$string['month'] = 'Місяць';
$string['months'] = 'Місяці';
$string['moodledocs'] = 'Документація Moodle';
$string['moodledocslink'] = 'Документація для цієї сторінки';
$string['moodlelogo'] = 'Логотип Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Не вдається підключитися до сервера MoodleNet';
$string['moodlenet:columnname'] = 'Назва';
$string['moodlenet:columnsenddate'] = 'Дата надсилання';
$string['moodlenet:columnsendstatus'] = 'Відправити статус';
$string['moodlenet:columntype'] = 'Тип';
$string['moodlenet:configoauthservice'] = 'Виберіть службу MoodleNet OAuth 2, щоб увімкнути спільний доступ до цього сайту MoodleNet. Якщо служба ще не існує, її потрібно <a href="{$a}">створити</a>.';
$string['moodlenet:deletedactivity'] = 'Видалена діяльність';
$string['moodlenet:deletedcourse'] = 'Видалений курс';
$string['moodlenet:eventresourceexported'] = 'Ресурс експортований';
$string['moodlenet:gotomoodlenet'] = 'Перейдіть до чернеток MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Емітент MoodleNet не авторизований';
$string['moodlenet:issuerisnotenabled'] = 'Емітент MoodleNet не ввімкнено';
$string['moodlenet:issuerisnotset'] = 'Емітент MoodleNet не встановлений адміністрацією сайту';
$string['moodlenet:nosharedresources'] = 'Наразі немає спільних ресурсів для відображення.';
$string['moodlenet:outboundsettings'] = 'Вихідні налаштування MoodleNet';
$string['moodlenet:packagingandsending'] = 'Пакування вашого файлу та надсилання до MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Під час надання доступу до вашого вмісту в MoodleNet сталася помилка.<br>Спробуйте пізніше.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Під час надання доступу до вашого вмісту в MoodleNet сталася помилка.<br>Спробуйте пізніше або <a href="{$a}">зв’яжіться зі службою підтримки сайту</a>.';
$string['moodlenet:sharefailtitle'] = 'Щось пішло не так';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Розмір спільного ресурсу ({$a->file size} байт) перевищує обмеження в {$a->filesizelimitbytes.';
$string['moodlenet:sharenoticeactivity'] = 'Ця діяльність надається спільно з MoodleNet як ресурс.';
$string['moodlenet:sharenoticecourse'] = 'Цей курс надається як ресурс для MoodleNet.';
$string['moodlenet:sharenoticepartial'] = 'Вибрані дії надаються спільно з MoodleNet як ресурс.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'У курс буде включено {$a} заходів.';
$string['moodlenet:shareprogress'] = 'MoodleNet поділіться прогресом';
$string['moodlenet:shareprogressinfo'] = 'Список показує курси та заходи, якими ви поділилися в MoodleNet.<br>Натисніть назву ресурсу, щоб переглянути в MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Майже зроблено! Відвідайте свої чернетки в MoodleNet, щоб завершити обмін вмістом.';
$string['moodlenet:sharesuccesstitle'] = 'Збережено в чернетках MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Поділіться з MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Великі файли можуть зайняти деякий час.';
$string['moodlenet:sharingstatus'] = 'Спільний доступ до MoodleNet';
$string['moodlenet:sharingto'] = 'Спільний доступ до:';
$string['moodlerelease'] = 'Реліз Moodle';
$string['moodleservicesandsupport'] = 'Послуги та підтримка';
$string['moodleversion'] = 'Версія Moodle';
$string['more'] = 'більше';
$string['moreactions'] = 'Більше дій';
$string['morehelp'] = 'Ще допомога';
$string['morehelpaboutmodule'] = 'Додаткова довідка про активність {$a}';
$string['moreinfo'] = 'Додаткова інформація';
$string['moreinformation'] = 'Докладніше про цю помилку.';
$string['moremenu'] = 'Більше';
$string['morenavigationlinks'] = 'Докладніше...';
$string['moreprofileinfoneeded'] = 'Будь ласка, повідомте нам більше про себе';
$string['mostrecently'] = 'останній';
$string['move'] = 'Перемістити';
$string['movecategoriessuccess'] = 'Успішно перенесено {$a->count} категорі(й)ю до категорії \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Успішно перенесено {$a->count} категорі(й)ю до найвищого рівня';
$string['movecategorycontentto'] = 'Перемістити до';
$string['movecategorysuccess'] = 'Успішно перенесено категорію \'{$a->moved}\' до категорії \'{$a->to}\'';
$string['movecategoryto'] = 'Перемістити категорію в:';
$string['movecategorytotopsuccess'] = 'Успішно перенесено категорію \'{$a->moved}\' до найвищого рівня';
$string['movecontent'] = 'Перемістити {$a}';
$string['movecontentafter'] = 'Після "{$a}"';
$string['movecontentstoanothercategory'] = 'Перемістити контент в іншу категорію';
$string['movecontenttothetop'] = 'До початку списку';
$string['movecoursemodule'] = 'Перемістити активність';
$string['movecoursesection'] = 'Перемістити секцію';
$string['movecourseto'] = 'Перемістити курс в:';
$string['movedown'] = 'Перемістити вниз';
$string['movefilestohere'] = 'Перемістити файли сюди';
$string['movefull'] = 'Перемістити {$a} у цю позицію';
$string['movehere'] = 'Перемістити сюди';
$string['moveitemdown'] = 'Перемістіть {$a} вниз';
$string['moveitemup'] = 'Перемістити {$a} вгору';
$string['moveleft'] = 'Ліворуч';
$string['moveright'] = 'Праворуч';
$string['movesection'] = 'Перемістити секцію {$a}';
$string['moveselectedcategoriesto'] = 'Перемістити вибрані категорії до ...';
$string['moveselectedcoursesto'] = 'Перемістити обрані курси в...';
$string['movetoanotherfolder'] = 'Перемістити в іншу теку';
$string['moveup'] = 'Вище';
$string['mustchangepassword'] = 'Новий пароль повинен відрізнятися від поточного';
$string['mustconfirm'] = 'Вам потрібно підтвердити свій обліковий запис';
$string['mycourses'] = 'Мої курси';
$string['myfiles'] = 'Мої особисті файли';
$string['myfilesmanage'] = 'Управляти моїми файлами';
$string['myhome'] = 'Особистий кабінет';
$string['mymoodledashboard'] = 'Моя інформпанель';
$string['myprofile'] = 'Мій профіль';
$string['name'] = 'Назва';
$string['namedfiletoolarge'] = 'Файл \'{$a->filename}\' завеликий, тому не може бути завантажений';
$string['nameforlink'] = 'Як ви хочете назвати це посилання?';
$string['nameforpage'] = 'Назва';
$string['navigation'] = 'Навігація';
$string['needed'] = 'Необхідні';
$string['networkdropped'] = 'Ми виявили, що підключення до Інтернету ненадійне або було перервано. <br /> Пам\'ятайте, що зміни не можуть бути збережені належним чином, поки підключення не покращиться.';
$string['never'] = 'Ніколи';
$string['neverdeletelogs'] = 'Ніколи не видаляти записи подій';
$string['new'] = 'Новий';
$string['newaccount'] = 'Новий обліковий запис';
$string['newactivityname'] = 'Нова назва діяльності {$a}';
$string['newcourse'] = 'Новий курс';
$string['newloginnotificationbodyfull'] = '<p>Привіт {$a->userfullname},</p>
<p>Ваш {$a->sitename}  обліковий запис щойно ввійшла з нового пристрою
.</p>
<ul>
<li>Ваш обліковий запис : {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Пристрій: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p> Якщо це були ви, то вам не потрібно нічого робити
.</p>
<p> Якщо ви не впізнаєте цю діяльність, будь ласка
 <a href="{$a->changepasswordlink}">змініть пароль</a>.</p>';
$string['newloginnotificationbodysmall'] = 'У ваш обліковий запис {$a} щойно ввійшли з нового пристрою.';
$string['newloginnotificationtitle'] = 'Новий вхід у свій обліковий запис {$a}';
$string['newpassword'] = 'Новий пароль';
$string['newpassword_help'] = 'Вкажіть новий пароль або залиште порожнім для збереження поточного паролю.';
$string['newpasswordfromlost'] = '<strong>УВАГА:</strong> Ваш <strong>Поточний пароль</strong> буде відіслано вам через <strong>секунду</strong> двома листами, як частинами процесу поновлення паролю. Впевніться, що ви отримали пароль перед тим, як продовжити.';
$string['newpasswordtext'] = 'Вітаємо, {$a->firstname}.

Пароль вашого облікового запису на сайті \'{$a->sitename}\' був обнулений, і вам був наданий новий (тимчасовий) пароль.

Ваш поточний обліковий запис зараз:
  ім’я користувача: {$a->username}
  пароль: {$a->newpassword}

Ви можете перейти до цієї сторінки і змінити свій пароль: {$a->link}

У більшості поштових програм ви повинні побачити синє посилання, на якій просто потрібно клацнути мишкою. Якщо це не працює, скопіюйте адресу посилання і вставте його в адресний рядок вашого веб-оглядача.

Адміністратор сайту \'{$a->sitename}\', {$a->signoff}';
$string['newpicture'] = 'Новий малюнок';
$string['newpicture_help'] = 'Щоб додати новий малюнок (фото), перегляньте та виберіть зображення (в JPG або PNG форматі) і натисніть кнопку "Оновити профіль". Зображення буде обрізано до розміру 100х100 пікселів.';
$string['newpictureusernotsetup'] = 'Зображення профілю можна додавати лише після того, як буде збережено всі необхідні дані профілю.';
$string['newsectionname'] = 'Нова назва секції {$a}';
$string['newsitem'] = 'новина';
$string['newsitems'] = 'оголошення';
$string['newsitemsnumber'] = 'Кількість оголошень для показу';
$string['newsitemsnumber_help'] = 'Форум оголошень має примусову підписку за умовчанням. Розміщувати в ньому можуть лише вчителі та інші користувачі з відповідним дозволом.

Якщо вам не потрібен форум оголошень, встановіть для цього значення нуль.

Цей параметр також визначає кількість останніх повідомлень, які відображатимуться в блоці останніх повідомлень.';
$string['newuser'] = 'Новий користувач';
$string['newusernewpasswordsubj'] = 'Профіль нового користувача';
$string['newusernewpasswordtext'] = 'Привіт, {$a->firstname},

Для вас створено обліковий запис на \'{$a->sitename}\'.

 ім\'я користувача: {$a->ім\'я користувача}
 пароль: {$a->newpassword}

(Під час першого входу вам буде запропоновано змінити пароль.)

Щоб почати використовувати \'{$a->sitename}\', увійдіть за адресою
 {$a->link}

Якщо вам потрібна допомога, зверніться до адміністратора сайту,
{$a->signoff}';
$string['newusers'] = 'Нові користувачі';
$string['newwindow'] = 'Нове вікно';
$string['next'] = 'Далі';
$string['nextpage'] = 'Наступна сторінка';
$string['nextsection'] = 'Наступна секція';
$string['no'] = 'Ні';
$string['noblockstoaddhere'] = 'Немає блоків, які можна додати на цю сторінку.';
$string['nobody'] = 'Ніхто';
$string['nochange'] = 'Змін немає';
$string['nocomments'] = 'Немає коментарів';
$string['nocourses'] = 'Курсів немає';
$string['nocoursesfound'] = 'Курсів зі словами \'{$a}\' не було знайдено';
$string['nocoursestarttime'] = 'Курс не має дати початку.';
$string['nocoursesyet'] = 'У цій категорії немає курсів';
$string['nodstpresets'] = 'Адміністратор не здійснює цілодобову підтримку';
$string['nofilesselected'] = 'Жодного файлу не було обрано для відновлення';
$string['nofilesyet'] = 'У цей курс не було завантажено файлів';
$string['nofiltersapplied'] = 'Не застосовуються фільтри';
$string['nograde'] = 'Без оцінки';
$string['nohelpforactivityorresource'] = 'Нині немає довідки по цьому ресурсу або елементу';
$string['noimagesyet'] = 'Для вашого курсу не було завантажено малюнків';
$string['nologsfound'] = 'Записів про події не знайдено';
$string['nomatchingusers'] = 'Немає користувачів як \'{$a}\'';
$string['nomorecourses'] = 'Відповідних курсів більше не знайдено';
$string['nomoreidnumber'] = 'Не використовуйте idnumber для уникнення колізій';
$string['none'] = 'Не вибрано';
$string['noneditingteacher'] = 'Асистент';
$string['noneditingteacherdescription'] = 'Викладач без права редагування може викладати на курсі та оцінювати студентів, але не може змінювати ресурси курсу.';
$string['nonstandard'] = 'Не стандартне';
$string['nopendingcourses'] = 'Немає курсів, які чекають погодження';
$string['nopotentialadmins'] = 'Немає потенційних адміністраторів';
$string['nopotentialcreators'] = 'Немає потенційних авторів курсів';
$string['nopotentialstudents'] = 'Немає потенційних студентів';
$string['nopotentialteachers'] = 'Немає потенційних викладачів';
$string['norecentactivity'] = 'Немає діяльності';
$string['noreplybouncemessage'] = 'Ви відповіли на лист електронної пошти, на який не потрібно було відповідати. Якщо ви відповідали на пост форума, то використовуйте для відповіді {$a} форуми. Наступне є змістом Вашого e-mail:';
$string['noreplybouncesubject'] = '{$a} - зворотній email.';
$string['noreplyname'] = 'Не відповідайте на цей лист';
$string['noresetrecord'] = 'Немає запису на запит відновлення. Будь ласка, ініціюйте новий запит на відновлення пароля.';
$string['noresults'] = 'Без результатів';
$string['noresultsfor'] = 'Немає результатів для "{$a}"';
$string['normal'] = 'Звичайний';
$string['normalfilter'] = 'Нормальний пошук';
$string['nosite'] = 'Не можу знайти курс рівня сайту';
$string['nostudentsfound'] = '{$a} не знайдено';
$string['nostudentsingroup'] = 'В цій групі поки що немає студентів';
$string['nostudentsyet'] = 'На цьому курсі немає студентів.';
$string['nosuchemail'] = 'Такої ел.пошти не існує';
$string['notavailable'] = 'Недоступний';
$string['notavailablecourse'] = '{$a} недоступний';
$string['noteachersyet'] = 'Поки не залучено жодного викладача';
$string['noteachingupcomingcourses'] = 'На майбутніх курсах немає викладачів чи студентів';
$string['notenrolled'] = '{$a} не зареєстрований на цьому курсі';
$string['notenrolledprofile'] = 'Цей профіль недоступний, бо користувач не зареєстрований на цьому курсі.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Примітка:</strong> Можливість прокручування дат під час відновлення резервної копії було відключено через відсутність відповідних прав.';
$string['noteuserschangednonetocourse'] = 'Примітка: Користувачі курсу повинні бути відновлені при відновленні їхніх даних(в елементах курсів, файлах або повідомленнях). Цей параметр був змінений для вас.';
$string['nothingnew'] = 'Немає нещодавньої активності';
$string['nothingtodisplay'] = 'Нема чого показувати';
$string['notice'] = 'Помітити';
$string['noticenewerbackup'] = 'Ця резервна копія була створена за допомогою Moodle {$a->backuprelease} ({$a->backupversion}) і це новіша версія ніж та, що встановлена зараз {$a->serverrelease} ({$a->serverversion}). Це може визвати певні проблеми, бо обернену сумісність не гарантовано.';
$string['notifications'] = 'Повідомлення';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Користувач: {$a->info}, Користувач (повна інформація): {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Ви можете проглянути ці журнали за адресою {$a}';
$string['notifyloginfailuresmessagestart'] = 'Це список невдалих спроб входу в {$a} з моменту вашого останнього повідомлення';
$string['notifyloginfailuressubject'] = '{$a} :: Повідомлення про невдалі спроби входу';
$string['notincluded'] = 'Не включений';
$string['notingroup'] = 'Вибачте, але вам потрібно бути частиною групи, щоб побачити цю сторінку.';
$string['notpublic'] = 'Не для загалу!';
$string['nousersfound'] = 'Користувачів не знайдено';
$string['nousersmatching'] = 'Не знайдено користувачів, які відповідають \'{$a}';
$string['nousersyet'] = 'Поки немає жодного користувача';
$string['novalidcourses'] = 'Немає курсів для показу';
$string['now'] = 'зараз';
$string['numattempts'] = '{$a} невдалі(их) спроб входу';
$string['numberofcourses'] = 'Кількість курсів';
$string['numberweeks'] = 'Кількість секцій';
$string['numday'] = '{$a} день';
$string['numdays'] = '{$a} днів';
$string['numhours'] = '{$a} годин';
$string['numletters'] = '{$a} символів';
$string['numminutes'] = '{$a} хвилин';
$string['nummonth'] = '{$a} місяць';
$string['nummonths'] = '{$a} місяців';
$string['numseconds'] = '{$a} секунд';
$string['numviews'] = 'переглядів - {$a}';
$string['numweek'] = '{$a} тиждень';
$string['numweeks'] = '{$a} тижнів';
$string['numwords'] = 'всього слів: {$a}';
$string['numyear'] = 'рік';
$string['numyears'] = '{$a} років';
$string['ok'] = 'Добре';
$string['oldpassword'] = 'Поточний пароль';
$string['olduserdirectory'] = 'Це СТАРИЙ каталог користувачів і більше не потрібний. Ви можете його видалити. Файли, які тут є, були скопійовані в НОВИЙ каталог.';
$string['opendrawerblocks'] = 'Відкрити ящик блоків';
$string['opendrawerindex'] = 'Відкритий покажчик курсу';
$string['opensinnewwindow'] = 'Відкривати у новому вікні';
$string['operator_and'] = 'і';
$string['operator_andnot'] = 'і';
$string['operator_or'] = 'або';
$string['optional'] = 'не обов\'язково';
$string['options'] = 'опції';
$string['order'] = 'Порядок';
$string['originalpath'] = 'Оригінальний шлях';
$string['orphanedactivitiesinsectionno'] = 'Осиротілі діяльності (секція {$a})';
$string['other'] = 'Інші';
$string['outline'] = 'Структура';
$string['outlinereport'] = 'Структурований звіт';
$string['page'] = 'Сторінка';
$string['pagea'] = 'Сторінка {$a}';
$string['pagedcontentnavigation'] = 'Навігація по сторінки';
$string['pagedcontentnavigationactiveitem'] = 'Поточна сторінка, сторінка {$a}';
$string['pagedcontentnavigationitem'] = 'Перейти на сторінку {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Показувати {$a} елементів на сторінці';
$string['pageheaderconfigablock'] = 'Конфігурація блоку в {$a->fullname}';
$string['pagepath'] = 'Шлях сторінки';
$string['pageshouldredirect'] = 'Ця сторінка повинна автоматично перенаправляти. Якщо нічого не відбувається, будь ласка, скористайтеся наступним посиланням для продовження.';
$string['parentcategory'] = 'Входить у категорію';
$string['parentcoursenotfound'] = 'Батьківський курс не знайдено!';
$string['parentfolder'] = 'Папка верхнього рівня';
$string['participants'] = 'Учасники';
$string['participantslist'] = 'Список учасників';
$string['participationratio'] = 'Коефіцієнт участі';
$string['participationreport'] = 'Звіти про участь';
$string['password'] = 'Пароль';
$string['passwordchanged'] = 'Пароль успішно змінено';
$string['passwordextlink'] = 'Наступне посилання забезпечить поновлення втраченого пароля. Тимчасово ви вийдете з системи.';
$string['passwordforgotten'] = 'Забутий пароль';
$string['passwordforgotteninstructions'] = 'Ваші дані повинні бути знайдені в базі. Будь ласка введіть <strong>унікальне</strong> ім\'я користувача в системі (ваш логін) або зареєстровану адресу електронної пошти. Не має потреби вводити обидва.';
$string['passwordforgotteninstructions2'] = 'Щоб скинути пароль, введіть нижче ваше ім\'я користувача (логін) або вашу адресу електронної пошти. Якщо ви є у базі даних, на вашу електронну пошту буде надіслано лист з інструкціями, як відновити доступ до системи.';
$string['passwordpolicynomatch'] = 'Ваш поточний пароль більше не відповідає встановленій політиці паролів. {$a}';
$string['passwordsdiffer'] = 'Пароль не відповідає вимогам безпеки';
$string['passwordset'] = 'Ваш пароль встановлено.';
$string['path'] = 'Шлях';
$string['pathnotexists'] = 'Шлях не існує на вашому сервері!';
$string['pathslasherror'] = 'Шлях не повинен закінчуватися слешем!!';
$string['paymentinstant'] = 'Використовуйте кнопку нижче, щоб заплатити та бути зарахованим протягом декількох хвилин.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> очікується</small>)';
$string['paymentrequired'] = 'Цей курс вимагає оплати для вступу';
$string['payments'] = 'Платежі';
$string['paymentsorry'] = 'Дякуємо за вашу оплату. Коли він буде оброблений, ви зможете зайти на курс {$a->fullname}. Будь ласка, зачекайте, а потім повторіть спробу. Якщо проблеми залишаються, зверніться до {$a->teacher} або адміністратора сайту.';
$string['paymentthanks'] = 'Дякуємо за вашу оплату. Тепер ви зараховані на курс {$a}.';
$string['pendingrequests'] = 'Нерозглянуті запити курсів';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Закінчення періоду ({$a})';
$string['perpage'] = 'Результатів на сторінку';
$string['perpagea'] = 'Результатів на сторінку: {$a}';
$string['personal'] = 'Приватне';
$string['personalprofile'] = 'Особисті дані';
$string['phone'] = 'Телефон';
$string['phone1'] = 'Телефон';
$string['phone2'] = 'Мобільний телефон';
$string['phpinfo'] = 'інформація PHP';
$string['picture'] = 'Картина';
$string['pictureof'] = 'Фото {$a}';
$string['pictureofuser'] = 'Фото користувача';
$string['placeholdertypeorselect'] = 'Введіть або виберіть...';
$string['pleaseclose'] = 'Будь ласка, закрийте це вікно.';
$string['pleasesearchmore'] = 'Будь ласка, знайдіть ще';
$string['pleaseusesearch'] = 'Будь ласка, використовуйте пошук';
$string['plugin'] = 'Модуль';
$string['pluginarea'] = 'Площа';
$string['plugincheck'] = 'Перевірка компонентів';
$string['plugindeletefiles'] = 'Вся інформація модуля \'{$a->name}\' видалена з бази даних. Для запобігання повторного встановлення цього модуля, вам потрібно видалити його директорію з сервера: {$a->directory}';
$string['pluginitemid'] = 'Ідентифікатор';
$string['pluginmissingfromdisk'] = '{$a->name} (Відсутнє на диску)';
$string['pluginsetup'] = 'Установки розширень таблиць';
$string['policyaccept'] = 'Я розумію та погоджуюся';
$string['policyagree'] = 'Ви повинні погодитися з цими правилами для використання цього сайту. Ви згодні?';
$string['policyagreement'] = 'Угода Сайту';
$string['policyagreementclick'] = 'Угода про політику сайту';
$string['popup'] = 'спливаючий';
$string['popupwindow'] = 'Відкрити файл у новому вікні';
$string['popupwindowname'] = 'Спливаюче вікно';
$string['post'] = 'Повідомлення';
$string['posts'] = 'Повідомлення';
$string['potentialadmins'] = 'Потенційні адміністратори';
$string['potentialcreators'] = 'Потенційні автори курсів';
$string['potentialstudents'] = 'Потенційні студенти';
$string['potentialteachers'] = 'Потенційні викладачі';
$string['poweredbymoodle'] = 'На основі <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Уподобання';
$string['preferredlanguage'] = 'Мова, якій віддається перевага';
$string['preferredtheme'] = 'Тема, якій віддається перевага';
$string['preprocessingbackupfile'] = 'Процес створення резервної копії';
$string['prev'] = 'Попередня';
$string['preview'] = 'Попередній перегляд';
$string['previeworchoose'] = 'Перегляд або вибір теми';
$string['previewthemename'] = 'Попередній перегляд теми "{$a}"';
$string['previous'] = 'Назад';
$string['previouslyselectedusers'] = 'Попередньо вибрані користувачі не відповідають \'{$a}';
$string['previouspage'] = 'Попередня сторінка';
$string['previoussection'] = 'Попередня секція';
$string['primaryadminsetup'] = 'Установки Головного Адміна';
$string['privacy:metadata:config_log'] = 'Журнал змін конфігурації.';
$string['privacy:metadata:config_log:name'] = 'Назва параметру зміниться.';
$string['privacy:metadata:config_log:oldvalue'] = 'Попереднє значення для цього параметра.';
$string['privacy:metadata:config_log:plugin'] = 'Модифікований плагін.';
$string['privacy:metadata:config_log:timemodified'] = 'Час внесення змін.';
$string['privacy:metadata:config_log:userid'] = 'Користувач, який вніс зміни.';
$string['privacy:metadata:config_log:value'] = 'Нове значення для цього параметра.';
$string['privacy:metadata:events_queue'] = 'Черга подій користувача, які очікують на обробку.';
$string['privacy:metadata:events_queue:eventdata'] = 'Дані, що зберігаються в події.';
$string['privacy:metadata:events_queue:stackdump'] = 'Будь-яка трасування стека, пов’язана з цією подією.';
$string['privacy:metadata:events_queue:timecreated'] = 'Час створення цієї події.';
$string['privacy:metadata:events_queue:userid'] = 'Ідентифікатор користувача, пов’язаний з цією подією';
$string['privacy:metadata:log'] = 'Збірка минулих подій';
$string['privacy:metadata:log:action'] = 'Опис дії';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'курс';
$string['privacy:metadata:log:info'] = 'Додаткова інформація';
$string['privacy:metadata:log:ip'] = 'IP-адреса, яка використовується під час події';
$string['privacy:metadata:log:module'] = 'модуль';
$string['privacy:metadata:log:time'] = 'Час, коли відбувалася акція';
$string['privacy:metadata:log:url'] = 'URL-адреса, пов’язана з подією';
$string['privacy:metadata:log:userid'] = 'Ідентифікатор користувача, який виконав дію';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet ділиться подробицями прогресу';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'Ідентифікатор відповідного модуля курсу';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'Ідентифікатор пов’язаного курсу';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Повернена URL-адреса з MoodleNet після успішного обміну';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Результуючий статус частки';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Час виконання акції';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Тип спільного використання, яке було виконано';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Користувач, який виконав спільний доступ';
$string['privacy:metadata:oauth2_refresh_token'] = 'Маркер оновлення, що використовується в зв’язку OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Ідентифікатор емітента, якому відповідає токен';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Ідентифікатор користувача, якому відповідає токен';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Час створення токена';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Час останнього оновлення маркера';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Маркер оновлення для відповідних областей і користувача';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Ідентифікатор користувача, якому відповідає токен';
$string['privacy:metadata:task_adhoc'] = 'Статус спеціальних завдань.';
$string['privacy:metadata:task_adhoc:component'] = 'Компонент, що володіє завданням.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Найраніший час для виконання цього завдання.';
$string['privacy:metadata:task_adhoc:userid'] = 'Користувач, від імені якого запускається завдання.';
$string['privacy:metadata:task_log'] = 'Вихід журналу для журналу';
$string['privacy:metadata:task_log:component'] = 'Компонент, що володіє завданням.';
$string['privacy:metadata:task_log:userid'] = 'Користувач, якому належало завдання.';
$string['privacy:metadata:upgrade_log'] = 'Журнал оновлення.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Будь-яке зворотне відстеження, пов’язане з цим кроком оновлення.';
$string['privacy:metadata:upgrade_log:details'] = 'Додаткова інформація щодо оновлення.';
$string['privacy:metadata:upgrade_log:info'] = 'Основна інформація для цього кроку оновлення.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Плагін, який було оновлено.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Нова версія для оновлення.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Час, коли відбулося оновлення.';
$string['privacy:metadata:upgrade_log:type'] = 'Тип запису в журналі.';
$string['privacy:metadata:upgrade_log:userid'] = 'Користувач, який запустив оновлення.';
$string['privacy:metadata:upgrade_log:version'] = 'Стара версія плагіна.';
$string['private_files_handler'] = 'Зберігає вкладення листа ел.пошти в приватному сховищі файлів користувача на Moodle.';
$string['private_files_handler_name'] = 'Надіслати до приватних фалів';
$string['privatefiles'] = 'Особисті файли';
$string['privatefilesmanage'] = 'Керувати особистими файлами';
$string['proceed'] = 'Продовжуйте';
$string['profile'] = 'Профіль користувача';
$string['profilenotshown'] = 'Цей опис профіля не буде відображатися до тих пір, поки дана особа не буде записана хоча б на один курс.';
$string['progress'] = 'Прогрес';
$string['publicprofile'] = 'Загальнодоступний профіль';
$string['publicsitefileswarning'] = 'Примітка: Доступ до файлів, розташованих тут, є у всіх';
$string['publicsitefileswarning2'] = 'Примітка: Файли розташовані тут можуть бути доступними всім, хто знає до них шлях (URL). З міркувань безпеки рекомендується всі архівні файли видаляти відразу після їх відновлення.';
$string['publicsitefileswarning3'] = 'Примітка: файли, розміщені тут, можуть бути доступними будь-кому, хто знає (або може отримати) URL.<br> З міркувань безпеки файли резервних копій потрібно зберігати тільки в захищеному каталозі backupdata.';
$string['question'] = 'Питання';
$string['questionsinthequestionbank'] = 'Питання в банку питань';
$string['queued'] = 'У черзі';
$string['quotausage'] = 'Ви в даний час використовували {$a->used} вашого ліміту {$a->total}.';
$string['readinginfofrombackup'] = 'Читання інформації з файлу резервної копії';
$string['readme'] = 'README';
$string['recentactivity'] = 'Останні дії';
$string['recentactivityreport'] = 'Повний звіт щодо діяльності за останній час';
$string['recipientslist'] = 'Список отримувачів';
$string['recommended'] = 'Рекомендовано';
$string['recreatedcategory'] = 'Поновлена категорія {$a}';
$string['redirect'] = 'Перенаправити';
$string['reducesections'] = 'Зменшити кількість розділів';
$string['refresh'] = 'Оновити';
$string['refreshingevents'] = 'Оновлення подій';
$string['registration'] = 'Зареєструвати Moodle';
$string['registrationcontact'] = 'Зовнішній контакт';
$string['registrationcontactno'] = 'Ні, я не хочу, щоб зі мною контактували інші люди';
$string['registrationcontactyes'] = 'Так, надайте форму, щоб інші користувачі могли зв’язатися зі мною';
$string['registrationemail'] = 'Повідомлення ел.пошти';
$string['registrationinfo'] = '<p>На цій сторінці Ви можете зареєструвати Ваш сайт на moodle.org. Реєстрація безкоштовна. При цьому, на зазначений Вами e-mail будуть відправлятися важливі повідомлення, що стосуються знайдених порушень у безпеці Системи і нових релізів. </p><p>Типово, Ваша інформація буде конфіденційною, і ніколи не буде продаватися або передаватися кому-небудь. Причина для збору такої інформації - технічна підтримка та складання подання про користувачів Системи. </p><p>За бажанням, Ви можете дозволити додати назву Вашого сайту і посилання на нього в загальний список сайтів, зроблених з використанням MOODLE. </p><p>Всі нові реєстраційні записи перевіряються перед тим, як вони будуть додані до списку, але один раз зареєструвавшись на сайті Ви можете оновлювати Вашу реєстрацію (і Ваш запис у списку) у будь-який час, заново відправляючи цю форму.</p>';
$string['registrationinfotitle'] = 'Реєстраційна інформація';
$string['registrationsend'] = 'Відправити реєстраційну інформацію на www.moodle.org';
$string['registrationyes'] = 'Так, сповіщати мене про нові випуски Moodle, сповіщення системи безпеки та інші важливі новини';
$string['reject'] = 'Відхилити';
$string['rejectdots'] = 'Відхилити...';
$string['relativedatesmode'] = 'Режим відносних дат';
$string['relativedatesmode_help'] = 'Відображати дати курсу або активності відносно дати початку користувача в курсі. Дата початку курсу користувача буде датою початку його реєстрації, якщо він не зареєстрований до початку курсу, і в цьому випадку датою їх початку буде дата початку курсу. ПОПЕРЕДЖЕННЯ. Це експериментальна функція, і не всі види діяльності можуть її підтримувати. Після створення курсу це налаштування курсу більше не можна змінити.';
$string['relativedatesmode_warning'] = '<strong>Попередження</strong>: режим відносних дат не можна змінити після створення курсу.';
$string['reload'] = 'Оновити';
$string['remoteappuser'] = 'Віддалений користувач {$a}';
$string['remove'] = 'Видалити';
$string['removeadmin'] = 'Видалити адміністратора';
$string['removecreator'] = 'Видалити автора курсу';
$string['removestudent'] = 'Видалити студента';
$string['removeteacher'] = 'Видалити викладача';
$string['rename'] = 'Перейменувати';
$string['renamefileto'] = 'Перейменувати <b>{$a}</b> в';
$string['report'] = 'Звіт';
$string['reports'] = 'Звіти';
$string['reporttype'] = 'Тип звіту';
$string['repositories'] = 'Репозиторії';
$string['requestcourse'] = 'Запит на створення нового курсу';
$string['requestedby'] = 'Замовлено';
$string['requestedcourses'] = 'Замовлені курси';
$string['requestreason'] = 'Обґрунтування замовлення';
$string['requests'] = 'Запити';
$string['required'] = 'Необхідно заповнити';
$string['requirespayment'] = 'Для цього курсу потрібна оплата';
$string['resendemail'] = 'Повторно надіслати електронний лист із підтвердженням';
$string['reset'] = 'Очистити';
$string['resetcomponent'] = 'Компонент';
$string['resetcourse'] = 'Очищення курсу';
$string['resetcourseconfirm'] = 'Скинути курс?';
$string['resetcoursewarning'] = 'Ви впевнені, що бажаєте скинути курс "{$a}"?
<br/><br/>
Це призведе до видалення вибраних даних і повернення курсу до початкового стану. Ви не можете скасувати цю дію.';
$string['resetinfo'] = 'Ця функція дозволяє очистити всі дані користувача та повернути курс до початкового стану. Діяльність курсу та налаштування залишаються незмінними.';
$string['resetinfoselect'] = 'Виберіть дані, які потрібно видалити або скинути, з категорій нижче:';
$string['resetnotimplemented'] = 'Скидання не підтримується';
$string['resetnotimplementedinfo'] = 'Ці дії не можна скинути:';
$string['resetrecordexpired'] = 'Ви використали посилання на відновлення пароля пізніше ніж через {$a} хв., тож вона вже застаріла. Будь ласка, ініціалізуйте відновлення пароля ще раз.';
$string['resetstartdate'] = 'Скинути дату початку';
$string['resetstatus'] = 'Статус';
$string['resettable'] = 'Скинути таблицю вибору';
$string['resettask'] = 'Скинути';
$string['resettodefaults'] = 'Повернутися до типового';
$string['resortcourses'] = 'Сортувати курси';
$string['resortsubcategoriesby'] = 'Сортувати підкатегорії за зростанням {$a}';
$string['resortsubcategoriesbyreverse'] = 'Сортувати підкатегорії за спаданням {$a}';
$string['resource'] = 'Ресурс';
$string['resource_type'] = 'Тип ресурсу';
$string['resourcedisplayauto'] = 'Автоматично';
$string['resourcedisplaydownload'] = 'Примусове завантаження';
$string['resourcedisplayembed'] = 'Вбудувати';
$string['resourcedisplayframe'] = 'У фреймі';
$string['resourcedisplaynew'] = 'У новому вікні';
$string['resourcedisplayopen'] = 'Відкрити';
$string['resourcedisplaypopup'] = 'У виринаючому';
$string['resources'] = 'Ресурси';
$string['resources_help'] = 'Типи ресурсів дозволяють практично будь-який веб-контент для вставки в курсі.';
$string['restore'] = 'Відновлення';
$string['restorecancelled'] = 'Відновлення скасовано';
$string['restorecannotassignroles'] = 'Відновлення вимагає призначення ролей, але ви не маєте на це відповідних прав';
$string['restorecannotcreateorassignroles'] = 'Відновлення вимагає створення або призначення ролей, але ви не маєте на це відповідних прав';
$string['restorecannotcreateuser'] = 'Відновлення курсу вимагає створення користувача \'$a\', який є у файлі резервної копії, але ви не маєте для цього відповідних прав.';
$string['restorecannotoverrideperms'] = 'Відновлення вимагає зміни прав ролей курсу, але ви не маєте на це відповідних прав';
$string['restorecoursenow'] = 'Відновити цей курс!';
$string['restoredaccount'] = 'Відновлений обліковий запис';
$string['restoredaccountinfo'] = 'Цей обліковий запис було імпортовано з іншого серверу без пароля. Щоб встановити новий пароль по електронній пошті, будь ласка, натисніть "Продовжити"';
$string['restorefinished'] = 'Відновлення успішно завершене';
$string['restoreinfo'] = 'Використовуйте файл резервної копії, щоб відновити попередню версію курсу або створити новий курс.';
$string['restoremnethostidmismatch'] = 'MNet host id користувача \'{$a}\' не співпадаю MNet host ID.';
$string['restoreto'] = 'Відновити до';
$string['restoretositeadding'] = 'Попередження: Ви збираєтеся відновити домашню сторінку сайту, додавши на нього дані!';
$string['restoretositedeleting'] = 'Попередження: ви збираєтеся відновити домашню сторінку сайту, спочатку видаливши дані з нього!';
$string['restoreuserconflict'] = 'Спроба відновити користувача \'{$a}\' з резервної копії призводить до конфлікту';
$string['restoreuserinfofailed'] = 'Процес відновлення зупинено, оскільки ви не маєте відповідних прав для відновлення даних користувачів.';
$string['restoreusersprecheck'] = 'Перевірка даних користувача';
$string['restoreusersprecheckerror'] = 'Під час перевірки даних користувача виявлені деякі проблеми';
$string['restricted'] = 'Обмежений';
$string['resultsfound'] = 'Знайдено результатів: {$a}';
$string['retry'] = 'Повторіть спробу';
$string['returningtosite'] = 'Вхід на сайт';
$string['returntooriginaluser'] = 'Повернутися до {$a}';
$string['revert'] = 'Скасувати';
$string['role'] = 'Роль';
$string['roleassignments'] = 'Призначення ролей';
$string['rolemappings'] = 'Встановлення ролей';
$string['rolerenaming'] = 'Перейменування ролі';
$string['rolerenaming_help'] = 'Change the display names of roles in this course.';
$string['rolerenaming_success'] = 'Назви ролей курсів оновлено.';
$string['roles'] = 'Ролі';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Кількість останніх статей RSS';
$string['rsserror'] = 'Помилка читання RSS';
$string['rsserrorauth'] = 'Ваше RSS посилання не містить аутентифікації.';
$string['rsserrorguest'] = 'Цей канал використовує гостьовий доступ для доступу до даних, але гість не має права на читання даних. Відвідайте джерело каналу (URL) як дійсний користувач та візьміть там нове RSS посилання.';
$string['rsskeyshelp'] = '<p> Для забезпечення безпеки та конфіденційності URL-адреси RSS-каналів містять спеціальний маркер, який ідентифікує користувача, для якого вони призначені. Це перешкоджає іншим користувачам отримувати доступ до тих областей сайту, де їм заборонено. </p> <p>Маркер створюється автоматично під час першого доступу до області, яка створює RSS-канал. Якщо ви вважаєте, що ваш маркер каналу RSS зламано, ви можете подати запит на новий, натиснувши посилання скидання. Зауважте, що ваші поточні URL-адреси каналу RSS стануть недійсними.
</p>';
$string['rsstype'] = 'RSS забезпечення для цієї діяльності';
$string['save'] = 'Зберегти';
$string['saveandnext'] = 'Зберегти та показати наступне';
$string['savechanges'] = 'Зберегти зміни';
$string['savechangesanddisplay'] = 'Зберегти й показати';
$string['savechangesandreturn'] = 'Зберегти та повернутися';
$string['savechangesandreturntocourse'] = 'Зберегти й повернутися до курсу';
$string['savecomment'] = 'Зберегти коментар';
$string['savedat'] = 'Зберегти в:';
$string['savepreferences'] = 'Зберегти налаштування';
$string['saveto'] = 'Зберегти до';
$string['scale'] = 'Шкала';
$string['scale_help'] = 'Шкала надає спосіб оцінки або класифікації продуктивності в діяльності. Вона визначається упорядкованим списком значень розділених комами, починаючи з негативного до позитивний, наприклад, "незадовільно, не досить добре, середньо, добре, дуже добре, відмінно!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Шкали';
$string['scalescustom'] = 'Шкала користувача';
$string['scalescustomcreate'] = 'Додати нову шкалу';
$string['scalescustomno'] = 'Жодної шкали користувача створено не було';
$string['scalesstandard'] = 'Стандартні шкали';
$string['scalestandard'] = 'Стандартна шкала';
$string['scalestandard_help'] = 'Стандартна шкала доступна на веб-сайті для всіх курсів.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Для створення нових шкал використовуйте "Шкали" пункт в адміністративному меню курсу';
$string['scalestip2'] = 'Для ручного створення шкал, клацніть на посилання Журнал оцінок в головному меню адміністратора, потім виберіть Шкали, Додати нову шкалу.';
$string['schedule'] = 'Розклад';
$string['screenshot'] = 'Знімок екрану';
$string['search'] = 'Знайти';
$string['search_help'] = 'Для простого пошуку одного або кількох слів у тексті, просто надрукуйте їх, розділяючи пробілами. Всі слова довше двох символів використовуються при пошуку. Для розширеного пошуку, натисніть кнопку пошуку без написання чого-небудь у вікні пошуку, так ви попадете до форми розширеного пошуку.';
$string['searchactivities'] = 'Пошук діяльності за назвою або описом';
$string['searchagain'] = 'Відновити пошук';
$string['searchbyemail'] = 'Знайти за адресою ел.пошти';
$string['searchbyusername'] = 'Знайти за іменем користувача';
$string['searchcoursecategories'] = 'Пошук категорій';
$string['searchcourses'] = 'Пошук курсів';
$string['searchgroups'] = 'Пошук груп';
$string['searchitems'] = 'Пошук елементів';
$string['searchoptions'] = 'Параметри пошуку';
$string['searchresults'] = 'Результати пошуку';
$string['searchusers'] = 'Пошук користувачів';
$string['sec'] = 'сек';
$string['seconds'] = 'сек';
$string['secondsleft'] = '{$a} сек.';
$string['secondstotime172800'] = '2 дні';
$string['secondstotime259200'] = '3 дні';
$string['secondstotime345600'] = '4 дні';
$string['secondstotime432000'] = '5 днів';
$string['secondstotime518400'] = '6 днів';
$string['secondstotime604800'] = '1 тиждень';
$string['secondstotime86400'] = '1 день';
$string['secretalreadyused'] = 'Це посилання для зміни пароля вже використано раніше, пароль не змінено.';
$string['secs'] = 'сек';
$string['section'] = 'Секція';
$string['sectionactionnotsupported'] = 'Дія розділу "{$a}" тут не підтримується';
$string['sectionname'] = 'Назва секції';
$string['sectionoutline'] = 'Схема розділу';
$string['sections'] = 'Секції';
$string['seealsostats'] = 'Див.також: статистика';
$string['selctauser'] = 'Виберіть користувача';
$string['select'] = 'Вибрати';
$string['selectacategory'] = 'Виберіть категорію';
$string['selectacountry'] = 'Країна';
$string['selectacourse'] = 'Виберіть курс';
$string['selectacoursesite'] = 'Виберіть курс або сайт';
$string['selectagroup'] = 'Створити групу';
$string['selectall'] = 'Вибрати все';
$string['selectallusersonpage'] = 'Вибрати всіх користувачів на сторінці';
$string['selectalluserswithcount'] = 'Вибрати всіх користувачів - {$a}';
$string['selectamodule'] = 'Будь ласка, виберіть модуль';
$string['selectanaction'] = 'Вибрати дію';
$string['selectanoptions'] = 'Виберіть варіанти';
$string['selectaregion'] = 'Виберіть регіон';
$string['selectcategorysort'] = 'Які категорії ви б хотіли відсортувати?';
$string['selectcategorysortby'] = 'Виберіть, як ви хочете відсортувати категорії';
$string['selectcoursesortby'] = 'Виберіть, як ви хочете відсортувати курси';
$string['selectdates'] = 'Виберіть дати';
$string['selectdefault'] = 'Вибрати типове';
$string['selectedcategories'] = 'Вибрані категорії';
$string['selectedfile'] = 'Вибраний файл';
$string['selectednowmove'] = '{$a} файли, обрані для переміщення. Тепер перейдіть до цільової теки на натисніть на \'перемістити сюди\'';
$string['selectfiles'] = 'Вибрати файли';
$string['selectfiltertype'] = 'Вибрати';
$string['selectgroupsseparate'] = 'Виберіть окремі групи';
$string['selectgroupsvisible'] = 'Виберіть видимі групи';
$string['selectitem'] = 'Виберіть "{$a}"';
$string['selectmoduletoviewhelp'] = 'Виберіть модуль, щоб побачити довідку до нього.

Подвійне клацання на назві діяльності або ресурсу швидко додасть їх.';
$string['selectnos'] = 'Вибрати всі "Ні"';
$string['selectperiod'] = 'Вибрати період';
$string['selecttheme'] = 'Виберіть тему';
$string['selectthemename'] = 'Виберіть тему "{$a}"';
$string['senddetails'] = 'Надіслати мої дані по ел.пошті';
$string['sent'] = 'Надіслано';
$string['separate'] = 'Окремі';
$string['separateandconnected'] = 'Будьте неупередженими';
$string['separateandconnected1'] = 'Здебільшого не по темі';
$string['separateandconnected2'] = 'Дещо є';
$string['separateandconnected3'] = 'Те, що треба';
$string['separateandconnectedinfo'] = 'Шкала, заснована на теорії роздільного і зв\'язаного пізнання. Ця теорія описує два різні способи, якими ми можемо оцінити й дізнатися про те, що бачимо та чуємо.<ul><li><strong>Окремі знання</strong> залишаються максимально об’єктивними, не враховуючи почуття та емоції. У дискусії з іншими людьми вони люблять відстоювати власні ідеї, використовуючи логіку, щоб знайти діри в ідеях опонентів.</li><li><strong>Значі, які мають зв’язок</strong>, більш чутливі до інших людей. Вони вміють співпереживати і схильні слухати і задавати запитання, поки не відчують, що можуть зв’язатися і «розуміти речі зі своєї точки зору». Вони вчаться, намагаючись поділитися досвідом, який привів до знань, які вони знаходять у інших людей.</li></ul>';
$string['servererror'] = 'Сталася помилка під час зв\'язку з сервером';
$string['serverlocaltime'] = 'Час на сервері';
$string['sessionforceclean'] = 'З міркувань безпеки створені користувачами сценарії були вимкнені під час цього сеансу.';
$string['sessiontimeoutsoon'] = 'Ваш сеанс скоро закінчиться. Бажаєте продовжити поточну сесію?';
$string['setcategorytheme'] = 'Встановити тему категорії';
$string['setmode'] = 'Встановити режим';
$string['setpassword'] = 'Встановити пароль';
$string['setpasswordinstructions'] = 'Будь ласка, введіть свій новий пароль нижче, а потім збережіть зміни.';
$string['settings'] = 'Налаштування';
$string['share'] = 'Поділіться';
$string['shortname'] = 'Коротка назва';
$string['shortnamecollisionwarning'] = '[*] = Ця коротка назва вже використовується, виберіть іншу';
$string['shortnamecourse'] = 'Коротка назва курсу';
$string['shortnamecourse_help'] = 'Назва відображається в областях з обмеженим простором. Він повинен бути унікальним.';
$string['shortnametaken'] = 'Коротка назва вже використовується для іншого курсу ({$a})';
$string['shortnameuser'] = 'Коротке ім’я користувача';
$string['shortsitename'] = 'Коротка назва сайту (наприклад, одне слово)';
$string['show'] = 'Показати';
$string['showactions'] = 'Показати дії';
$string['showactivitydates'] = 'Показати дати активності';
$string['showactivitydates_help'] = 'Показувати дати заходів на сторінці курсу.';
$string['showadvancededitor'] = 'Додаткові параметри';
$string['showadvancedsettings'] = 'Показати додаткові параметри';
$string['showall'] = 'Показати всі {$a}';
$string['showallcourses'] = 'Показати курси';
$string['showblockcourse'] = 'Показати список курсів, які мають блок';
$string['showcategory'] = 'Показати {$a}';
$string['showchartdata'] = 'Показати дані графіку';
$string['showcomments'] = 'Показати/приховати коментарі';
$string['showcommentsnonjs'] = 'Показати коментарі';
$string['showdescription'] = 'Показувати опис на сторінці курсу';
$string['showdescription_help'] = 'При включенні цього параметра вказаний вище опис відображатиметься на сторінці курсу під посиланням на цей ресурс/діяльність курсу.';
$string['showgrades'] = 'Показувати студентам журнал оцінок';
$string['showgrades_help'] = 'Дозвольте студентам переглядати список усіх своїх оцінок за курс.';
$string['showingacourses'] = 'Показати всі {$a} курсів';
$string['showingxofycourses'] = 'Показано курсів з {$a->start} до {$a->end} з {$a->total}';
$string['showless'] = 'Показувати менше';
$string['showlistofcourses'] = 'Показати список курсів';
$string['showmodulecourse'] = 'Показати список курсів, які мають діяльності';
$string['showmore'] = 'Показати більше';
$string['showoncoursepage'] = 'Показати на сторінці курсу';
$string['showonly'] = 'Показати тільки';
$string['showperpage'] = 'Показати {$a} на сторінці';
$string['showpopoverwindow'] = 'Показати спливаюче вікно';
$string['showrecent'] = 'Показати останні новини';
$string['showreports'] = 'Показувати звіти про діяльність';
$string['showreports_help'] = 'Дозвольте студентам переглядати власні звіти про діяльність на сторінці свого профілю.';
$string['showsettings'] = 'Показати установки';
$string['showtheselogs'] = 'Показати записи подій';
$string['showthishelpinlanguage'] = 'Показати цю допомогу мовою: {$a}';
$string['sidepanel'] = 'Бокова панель';
$string['signoutofotherservices'] = 'Вийдіть із усіх веб-програм';
$string['signoutofotherservices_help'] = 'Вийдіть із усіх пристроїв і систем, які використовують веб-сервіси, наприклад мобільний додаток. Сеанси браузера залишаться активними.';
$string['since'] = 'З';
$string['sincelast'] = 'з останнього входу';
$string['site'] = 'Сайт';
$string['sitedefault'] = 'Типове сайту';
$string['sitedefaultspecified'] = 'Сайт за умовчанням ({$a})';
$string['siteerrors'] = 'Помилки сайту';
$string['sitefiles'] = 'Файли сайту';
$string['sitefilesused'] = 'Файли сайту використані в цьому курсі';
$string['sitehome'] = 'Домашня сторінка';
$string['sitelegacyfiles'] = 'Файли сайту';
$string['sitelogs'] = 'Записи подій сайту';
$string['sitenews'] = 'Оголошення сайту';
$string['sitepages'] = 'Сторінки сайту';
$string['sitepartlist'] = 'Ви не маєте відповідних прав для перегляду списку учасників';
$string['sitepartlist0'] = 'Щоб бачити список учасників, ви повинні бути викладачем на сайті';
$string['sitepartlist1'] = 'Щоб бачити список учасників, ви повинні бути викладачем';
$string['sites'] = 'Сайти';
$string['sitesection'] = 'Додайте спеціальний вміст';
$string['sitesettings'] = 'Конфігурація сайту';
$string['siteteachers'] = 'Викладачі сайту';
$string['size'] = 'Розмір';
$string['sizeb'] = 'байт';
$string['sizegb'] = 'Гб';
$string['sizekb'] = 'Кб';
$string['sizemb'] = 'Мб';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Пропущено';
$string['skiptocategorylisting'] = 'Перейти до списку категорій';
$string['skiptocoursedetails'] = 'Перейти до детальної інформації курсу';
$string['skiptocourselisting'] = 'Перейти до списку курсів';
$string['someallowguest'] = 'На деякі курси передбачено гостьовий доступ';
$string['someerrorswerefound'] = 'Частину інформації було загублено або подано неправильно. Детальніше нижче.';
$string['sort'] = 'Сортувати';
$string['sortby'] = 'Сортувати за';
$string['sortbyx'] = 'Сортувати {$a}  за зростанням';
$string['sortbyxreverse'] = 'Сортувати {$a}  за спаданням';
$string['sorting'] = 'Сортування';
$string['sourcerole'] = 'Початкова роль';
$string['specifyname'] = 'Ви повинні визначити ім\'я.';
$string['standard'] = 'Стандарт';
$string['starpending'] = '([*] = курс очікує погодження)';
$string['startdate'] = 'Дата початку навчання';
$string['startdate_help'] = 'Ця дата визначає початок першого тижня курсу в тижневому форматі. Це також дата початку для журналів діяльності курсу.

Якщо ви скинете курс і зміните цю дату, усі дати в курсі буде переміщено відносно нової дати початку.';
$string['startdatewithtaskenabled'] = 'Дата початку курсу';
$string['startdatewithtaskenabled_help'] = 'Дата, коли курс стане видимим для студентів. До цієї дати вони не зможуть отримати доступ до курсу. Ця дата також визначає початок першого тижня курсу в тижневому форматі та є датою початку для журналів діяльності курсу. якщо ви скинете курс і зміните цю дату, усі дати в курсі будуть перенесені відносно нової дати початку.';
$string['startingfrom'] = 'Почати з';
$string['startsignup'] = 'Створити новий обліковий запис';
$string['state'] = 'Область';
$string['statistics'] = 'Статистика';
$string['statisticsgraph'] = 'Статистичний граф.';
$string['stats'] = 'Статистика';
$string['statslogins'] = 'Входження';
$string['statsmodedetailed'] = 'Детальний перегляд';
$string['statsmodegeneral'] = 'Основний перегляд';
$string['statsnodata'] = 'Немає даних для даної комбінації курсу та часового періоду';
$string['statsnodatauser'] = 'Немає даних для даної комбінації курсу, користувача та часового періоду';
$string['statsoff'] = 'Статистика зараз не включена';
$string['statsreads'] = 'Перегляди';
$string['statsreport1'] = 'Входження';
$string['statsreport10'] = 'Дій користувача';
$string['statsreport11'] = 'Найактивніші курси';
$string['statsreport12'] = 'Найактивніші курси (зважений)';
$string['statsreport13'] = 'Курси з найбільшою кількістю учасників';
$string['statsreport14'] = 'Більшість курсів за участі (публікації/перегляди)';
$string['statsreport2'] = 'Перегляд (всі ролі)';
$string['statsreport3'] = 'Повідомлення (всі ролі)';
$string['statsreport4'] = 'Вся діяльність (всі ролі)';
$string['statsreport5'] = 'Вся діяльність (перегляди і повідомлення)';
$string['statsreport7'] = 'Діяльність користувачів (перегляди та повідомлення)';
$string['statsreport8'] = 'Вся діяльність користувачів';
$string['statsreport9'] = 'Входження (сайт)';
$string['statsreportactivity'] = 'Вся діяльність (всі ролі)';
$string['statsreportactivitybyrole'] = 'Вся діяльність (перегляди та повідомлення)';
$string['statsreportforuser'] = 'для';
$string['statsreportlogins'] = 'Входження';
$string['statsreportreads'] = 'Перегляди (всі ролі)';
$string['statsreporttype'] = 'Тип звіту';
$string['statsreportwrites'] = 'Повідомлення (всі ролі)';
$string['statsstudentactivity'] = 'Студентська діяльність';
$string['statsstudentreads'] = 'Студентські перегляди';
$string['statsstudentwrites'] = 'Повідомлення студентів';
$string['statsteacheractivity'] = 'Викладацька діяльність';
$string['statsteacherreads'] = 'Викладацькі перегляди';
$string['statsteacherwrites'] = 'Повідомлення викладачів';
$string['statstimeperiod'] = 'Термін - останній';
$string['statsuniquelogins'] = 'Унікальні входи';
$string['statsuseractivity'] = 'Вся діяльність';
$string['statsuserlogins'] = 'Входження';
$string['statsuserreads'] = 'Перегляди';
$string['statsuserwrites'] = 'Повідомлення';
$string['statswrites'] = 'Повідомлення';
$string['status'] = 'Статус';
$string['statuschecks'] = 'Перевірки стану';
$string['statuscritical'] = 'Критичний';
$string['statusdone'] = 'Готово';
$string['statuserror'] = 'Помилка';
$string['statusinfo'] = 'Інформація';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Невідомо';
$string['statuswarning'] = 'Застереження';
$string['stringsnotset'] = 'Наступні рядки не визначені в {$a}';
$string['studentnotallowed'] = 'На жаль, ви не можете увійти до даного курсу як \'{$a}\'';
$string['students'] = 'Студенти';
$string['studentsandteachers'] = 'Студенти та викладачі';
$string['subcategories'] = 'Підкатегорії';
$string['subcategory'] = 'Підкатегорія';
$string['subcategoryof'] = 'Підкатегорія для {$a}';
$string['subject'] = 'Тема';
$string['submit'] = 'Прийняти';
$string['subsectionmoveerror'] = 'Неможливо перемістити цей підрозділ в інший підрозділ';
$string['success'] = 'Успішно';
$string['successduration'] = 'Успішно ({$a} секунд)';
$string['summary'] = 'Резюме';
$string['suspended'] = 'Заблокований';
$string['suspendedusers'] = 'Заблоковані користувачі';
$string['switchdevicedefault'] = 'Перемикнути до стандартної теми';
$string['switchdevicerecommended'] = 'Перемикнути до рекомендованої теми для вашого пристрою';
$string['switchrolereturn'] = 'Повернутися до моєї ролі';
$string['switchroleto'] = 'Перемикнути на роль...';
$string['switchroleto_help'] = 'Виберіть роль, щоб отримати уявлення про те, як хтось із цієї ролі побачить цей курс.

Зверніть увагу, що ця точка зору може бути не повною  (<a href="https://docs.moodle.org/en/Switch_roles">Дивитись деталі або альтернативи</a>).';
$string['tag'] = 'Мітка';
$string['tagalready'] = 'Таку мітку вже створено';
$string['tagmanagement'] = 'Додати/видалити мітки...';
$string['tags'] = 'Мітки';
$string['targetrole'] = 'Цільова роль';
$string['teacheronly'] = 'Тільки для {$a}';
$string['teacherroles'] = '{$a} ролі';
$string['teachers'] = 'Викладачі';
$string['textcopiedtoclipboard'] = 'Текст скопійовано в буфер обміну';
$string['textediting'] = 'Редактор тексту';
$string['textediting_help'] = 'Якщо вибрано візуальний редактор Atto або TinyMCE, то текст вводиться в область, яка має панель інструментів для редагування .

Якщо вибрано ’простий тест’, то текст можна вводити у форматі HTML або Markdown.

Список можливих текстових редакторів визначається адміністратором сайту.';
$string['texteditor'] = 'Використовувати стандартні веб-форми';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Текстовий формат';
$string['thanks'] = 'Дякую';
$string['theme'] = 'Тема оформлення';
$string['themepreviewdescription'] = 'Опис теми {$a}';
$string['themepreviewimage'] = '{$a} зображення попереднього перегляду';
$string['themes'] = 'Теми';
$string['themesaved'] = 'Нову тему було збережено';
$string['therearecourses'] = '{$a} курсів';
$string['thereareno'] = 'Немає {$a} в цьому курсі';
$string['thiscategory'] = 'Ця категорія';
$string['thiscategorycontains'] = 'Ця категорія містить';
$string['time'] = 'Час';
$string['timecreated'] = 'Час створений';
$string['timecreatedcourse'] = 'Час створення курсу';
$string['timesplitting:deciles'] = 'Остання десята';
$string['timesplitting:deciles_help'] = 'Цей інтервал аналізу ділить курс на десяті (10 рівних частин), причому кожне передбачення базується на даних лише останньої попередньої десятої.';
$string['timesplitting:decilesaccum'] = 'Усі попередні десяті';
$string['timesplitting:decilesaccum_help'] = 'Цей інтервал аналізу ділить курс на десяті (10 рівних частин), причому кожен прогноз базується на накопичених даних усіх попередніх десятих.';
$string['timesplitting:nosplitting'] = 'Без обмежень у часі';
$string['timesplitting:nosplitting_help'] = 'Для цієї моделі не визначено інтервал аналізу.';
$string['timesplitting:onemonthafterstart'] = 'Через місяць після початку';
$string['timesplitting:onemonthafterstart_help'] = 'Цей інтервал аналізу генерує прогноз через 1 місяць після аналізованого початку.';
$string['timesplitting:oneweekafterstart'] = 'Через тиждень після початку';
$string['timesplitting:oneweekafterstart_help'] = 'Цей інтервал аналізу генерує прогноз через 1 тиждень після початку аналізу.';
$string['timesplitting:past3days'] = 'За останні 3 дні';
$string['timesplitting:past3days_help'] = 'Цей інтервал аналізу генерує прогнози кожні 3 дні. Розрахунок показників буде здійснюватися за останні 3 дні.';
$string['timesplitting:pastmonth'] = 'Минулий місяць';
$string['timesplitting:pastmonth_help'] = 'Цей інтервал аналізу генерує прогнози щомісяця. Розрахунок показників буде здійснюватися на основі минулого місяця.';
$string['timesplitting:pastweek'] = 'Минулого тижня';
$string['timesplitting:pastweek_help'] = 'Цей інтервал аналізу генерує прогнози щотижня. Розрахунок показників буде здійснюватися на основі минулого тижня.';
$string['timesplitting:quarters'] = 'Остання чверть';
$string['timesplitting:quarters_help'] = 'Цей інтервал аналізу ділить курс на квартали (4 рівні частини), причому кожен прогноз базується на даних лише останнього попереднього кварталу.';
$string['timesplitting:quartersaccum'] = 'Усі попередні квартали';
$string['timesplitting:quartersaccum_help'] = 'Цей інтервал аналізу ділить курс на квартали (4 рівні частини), причому кожен прогноз базується на накопичених даних усіх попередніх кварталів.';
$string['timesplitting:singlerange'] = 'Від початку до кінця';
$string['timesplitting:singlerange_help'] = 'Цей інтервал аналізу розглядає весь курс як один проміжок.';
$string['timesplitting:tenpercentafterstart'] = '10% після початку';
$string['timesplitting:tenpercentafterstart_help'] = 'Цей інтервал аналізу генерує прогноз після завершення 10% курсу.';
$string['timesplitting:upcoming3days'] = 'Найближчі 3 дні';
$string['timesplitting:upcoming3days_help'] = 'Цей інтервал аналізу генерує прогнози кожні 3 дні. Розрахунок показників буде здійснюватися на основі найближчих 3 днів.';
$string['timesplitting:upcomingfortnight'] = 'Майбутні два тижні';
$string['timesplitting:upcomingfortnight_help'] = 'Цей інтервал аналізу генерує прогнози кожні два тижні. Розрахунки показників будуть ґрунтуватися на найближчі два тижні.';
$string['timesplitting:upcomingweek'] = 'Майбутній тиждень';
$string['timesplitting:upcomingweek_help'] = 'Цей інтервал аналізу генерує прогнози щотижня. Розрахунок показників буде здійснюватися на основі наступного тижня.';
$string['timezone'] = 'Часовий пояс';
$string['tocontent'] = 'До елементу "{$a}"';
$string['tocreatenewaccount'] = 'Пропустити створення нового екаунту';
$string['todate'] = 'до';
$string['today'] = 'Сьогодні';
$string['todaylogs'] = 'Сьогоднішні події';
$string['toeveryone'] = 'для всіх';
$string['toggleemojipicker'] = 'Увімкнути вибір смайлів';
$string['togglesearch'] = 'Переключити введення пошуку';
$string['toomanybounces'] = 'Для даної адреси електронної пошти зафіксовано дуже багато повернень. Щоб продовжити, ви <b>повинні</b> її змінити.';
$string['toomanytags'] = 'Цей пошук містив забагато тегів; деякі з них будуть проігноровані.';
$string['toomanytoshow'] = 'Список користувачів занадто великий.';
$string['toomanyusersmatchsearch'] = 'Забагато користувачів ({$a->count}) за критерієм \'{$a->search}';
$string['toomanyuserstoshow'] = 'Забагато користувачів ({$a}) для показу';
$string['toonly'] = 'тільки для {$a}';
$string['top'] = 'Верхній рівень';
$string['topic'] = 'Тема';
$string['toplevelcategory'] = 'Категорія верхнього рівня';
$string['torecipient'] = 'до';
$string['total'] = 'Підсумок';
$string['totopofsection'] = 'До верхньої секції "{$a}"';
$string['trackforums'] = 'Стеження за форумами';
$string['trackforumsno'] = 'Ні: не інформувати про нові повідомлення';
$string['trackforumsyes'] = 'Так: інформувати про нові повідомлення';
$string['trysearching'] = 'Спробуйте знайти по-іншому';
$string['turneditingoff'] = 'Завершити редагування';
$string['turneditingon'] = 'Редагувати';
$string['unabletocopytoclipboard'] = 'Не вдається скопіювати текст у буфер обміну';
$string['unauthorisedlogin'] = 'Обліковий запис користувача "{$a}" не дійсний на цьому сайті';
$string['undecided'] = 'Невирішено';
$string['unexistingcmid'] = 'Ідентифікатор модуля курсу не знайдено';
$string['unexistingsectionid'] = 'Ідентифікатор розділу курсу не знайдено';
$string['unfinished'] = 'Не закінчено';
$string['unknowncategory'] = 'Невідома категорія';
$string['unknownerror'] = 'Невідома помилка';
$string['unknownuser'] = 'Невідомий користувач';
$string['unlimited'] = 'Не обмежено';
$string['unpacking'] = 'Розпакування {$a}';
$string['unsafepassword'] = 'Небезпечний пароль - спробуйте ще раз';
$string['untilcomplete'] = 'До виконання';
$string['unusedaccounts'] = 'Користувачі, які не з\'являються на курсі більше, ніж {$a} днів, автоматично відраховуються';
$string['unzip'] = 'Розпакувати zip-архів';
$string['unzippingbackup'] = 'Розпаковування резервної копії';
$string['up'] = 'Угору';
$string['update'] = 'Оновити';
$string['updated'] = 'Оновлений {$a}';
$string['updatemymoodleoff'] = 'Зупинити налаштування цієї сторінки';
$string['updatemymoodleon'] = 'Редагувати цю сторінку';
$string['updatemyprofile'] = 'Оновити профіль';
$string['updatesevery'] = 'Оновлюється через {$a} сек';
$string['updatethis'] = 'Оновити {$a}';
$string['updatethiscourse'] = 'Оновити цей курс';
$string['upload'] = 'Завантаження';
$string['uploadafile'] = 'Завантажити файл';
$string['uploadcantwrite'] = 'Помилка запису файлу на диск';
$string['uploadedfile'] = 'Файл завантажено';
$string['uploadedfileto'] = '{$a->file} завантажений в {$a->directory}';
$string['uploadedfiletoobig'] = 'Вибачте, але цей файл завеликий (обмеження в {$a} байтів)';
$string['uploadextension'] = 'Завантаження файлу зупинено розширенням PHP';
$string['uploadfailednotrecovering'] = 'Завантаження не відбулося через проблему у файлі {$a->name}.<br /> Перегляньте звіт про дану проблему:<br />{$a->problem}<br /> Відновити неможливо.';
$string['uploadfilelog'] = 'Звіт завантаження для файлу {$a}';
$string['uploadformlimit'] = 'Завантажений файл {$a} перевищує встановлений у формі ліміт';
$string['uploadlabel'] = 'Заголовок:';
$string['uploadlimitwithsize'] = '{$a->contextname} обмеження на завантаження ({$a->displaysize})';
$string['uploadnewfile'] = 'Завантажити новий файл';
$string['uploadnofilefound'] = 'Файл не знайдено. Переконайтеся, що Ви вибрали його правильно!';
$string['uploadnotallowed'] = 'Завантаження не дозволено';
$string['uploadnotempdir'] = 'Відсутня тимчасова тека';
$string['uploadoldfilesdeleted'] = 'Старі файл(и) в каталозі завантаження були видалені';
$string['uploadpartialfile'] = 'Файл був завантажений частково';
$string['uploadproblem'] = 'Невідома проблема виникла під час завантаження файлу \'{$a}\' (Можливо, він був занадто великим?)';
$string['uploadrenamedchars'] = 'Файл було переіменовано з {$a->oldname} до {$a->newname}, причиною стали недопустимі символи';
$string['uploadrenamedcollision'] = 'Файл було переіменовано з {$a->oldname} до {$a->newname}, причиною став конфлікт імен';
$string['uploadserverlimit'] = 'Завантажений файл більше ніж встановлений ліміт на сервері';
$string['uploadthisfile'] = 'Завантажити цей файл';
$string['url'] = 'URL';
$string['used'] = 'Використано';
$string['usedinnplaces'] = 'Використано у {$a} місцях';
$string['user'] = 'Користувач';
$string['useraccount'] = 'Обліковий запис користувача';
$string['useractivity'] = 'Завдання';
$string['userconfirmed'] = 'Підтверджено $a';
$string['userdata'] = 'Дані користувача';
$string['userdeleted'] = 'Реєстраційний запис користувача було вилучено';
$string['userdescription'] = 'Опис';
$string['userdescription_help'] = 'Це вікно дозволяє вводити деяку інформацію про себе, яка потім буде показана всім на сторінці вашого профілю.';
$string['userdetails'] = 'Детально';
$string['userfiles'] = 'Файли користувача';
$string['userlist'] = 'Список користувачів';
$string['usermatchedon'] = 'Цей користувач відповідає запиту в наступному полі';
$string['usermenu'] = 'Меню користувача';
$string['usermenugoback'] = 'Поверніться до меню користувача';
$string['username'] = 'Ім’я входу';
$string['usernameemail'] = 'Ім\'я користувача або адресу електронної пошти';
$string['usernameemailmatch'] = 'Ім’я користувача та адреса електронної пошти не належать тому самому користувачу';
$string['usernameexists'] = 'Дане ім\'я користувача вже існує. Оберіть інше';
$string['usernamelowercase'] = 'Дозволено тільки символи нижнього регістру';
$string['usernamenotfound'] = 'Ім’я користувача не знайдено в базі даних';
$string['usernameoremail'] = 'Введіть або ім\'я користувача, або адресу електронної пошти';
$string['usernotconfirmed'] = 'Не підтверджено {$a}';
$string['userpic'] = 'Фото користувача';
$string['userpreferences'] = 'Налаштування користувача';
$string['users'] = 'Користувачі';
$string['userselectorautoselectunique'] = 'Якщо тільки один користувач відповідає пошуковому запиту, то вибрати його автоматично';
$string['userselectorpreserveselected'] = 'Утримувати вибраних користувачів, навіть якщо вони вже не відповідають результатам пошуку';
$string['userselectorsearchanywhere'] = 'де завгодно';
$string['userselectorsearchexactmatchonly'] = 'лише точні збіги';
$string['userselectorsearchfromstart'] = 'від початку';
$string['userselectorsearchmatching'] = 'Відповідність:';
$string['usersnew'] = 'Нові користувачі';
$string['usersnoaccesssince'] = 'Показати користувачів, які були неактивними більше ніж';
$string['userswithfiles'] = 'Користувачі з файлами';
$string['useruploadtype'] = 'Користувацький тип завантаження: {$a}';
$string['userzones'] = 'Зони користувачів';
$string['usetheme'] = 'Використати тему';
$string['usingexistingcourse'] = 'Використати існуючий курс';
$string['validatehtml'] = 'Перевірте HTML';
$string['valuealreadyused'] = 'Це значення вже використовується.';
$string['version'] = 'Версія';
$string['view'] = 'Перегляд';
$string['viewallcourses'] = 'Переглядати всі курси';
$string['viewallcoursescategories'] = 'Переглядати всі курси та категорії';
$string['viewallresults'] = 'Переглянути всі результати ({$a})';
$string['viewallsubcategories'] = 'Переглянути всі підкатегорії';
$string['viewfileinpopup'] = 'Переглядати файл у виринаючому вікні';
$string['viewing'] = 'Перегляд:';
$string['viewmore'] = 'Показати ще';
$string['viewprofile'] = 'Переглянути профіль';
$string['views'] = 'Перегляди';
$string['viewsolution'] = 'подивитися рішення';
$string['visible'] = 'Доступність студентам';
$string['visible_help'] = 'Цей параметр визначає, чи буде курс з\'явиться в списку курсів. Всі користувачі, крім викладачів та адміністраторів, не зможуть увійти в курс.';
$string['visibletostudents'] = 'Доступне для {$a}';
$string['warning'] = 'Попередження';
$string['warningdeleteresource'] = 'Увага: $a відноситься до ресурсу. Ви хочете оновлювати ресурс?';
$string['wcagcheck'] = 'Перевірка Правил доступності веб-вмісту (WCAG).';
$string['webpage'] = 'Веб-сторінка';
$string['week'] = 'Тиждень';
$string['weeks'] = 'тижні';
$string['welcomeback'] = 'Ласкаво просимо, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Ласкаво просимо до {$a}';
$string['welcometocoursetext'] = 'Ласкаво просимо до {$a->coursename}!

Якщо ви ще цього не зробили, відредагуйте сторінку свого профілю, щоб ми могли дізнатися про вас більше:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Ласкаво просимо, {$a->firstname}! 👋';
$string['whatforlink'] = 'Що ви хочете зробити з зв\'язком?';
$string['whatforpage'] = 'Що ви хочете зробити з текстом?';
$string['whatisyourage'] = 'Скільки вам років?';
$string['whattocallzip'] = 'Як Ви хочете назвати zip-файл?';
$string['whattodo'] = 'Що робити';
$string['wheredoyoulive'] = 'В якій країні ви живете?';
$string['whyisthisrequired'] = 'Чому це потрібно?';
$string['windowclosing'] = 'Це вікно повинно закритися автоматично. Якщо цього не сталося закрийте його зараз.';
$string['withchosenfiles'] = 'З обраними файлами';
$string['withdisablednote'] = '{$a} (відключено)';
$string['withoutuserdata'] = 'без даних користувачів';
$string['withselectedusers'] = 'Відміченим користувачам...';
$string['withuserdata'] = 'з даними користувачів';
$string['wontrunfuturescheduledtask'] = 'Не виконуватиме завдання, яке не зазнало помилок і заплановано на виконання в майбутньому';
$string['wordforstudent'] = 'Звертання до Студента';
$string['wordforstudenteg'] = 'наприклад, Студент, Учасник...';
$string['wordforstudents'] = 'Звертання до Студентів';
$string['wordforstudentseg'] = 'наприклад, Студенти, Учасники...';
$string['wordforteacher'] = 'Звертання до Викладача';
$string['wordforteachereg'] = 'наприклад, Викладач, Інструктор, Тьютор...';
$string['wordforteachers'] = 'Звертання до Викладачів';
$string['wordforteacherseg'] = 'наприклад, Викладачі, Інструктори, Тьютори...';
$string['writingblogsinfo'] = 'Запис інформації блогів';
$string['writingcategoriesandquestions'] = 'Запис категорій і питань';
$string['writingcoursedata'] = 'Запис даних курсу';
$string['writingeventsinfo'] = 'Запис інформації про події';
$string['writinggeneralinfo'] = 'Запис загальної інформації';
$string['writinggradebookinfo'] = 'Запис інформації журналу оцінок';
$string['writinggroupingsgroupsinfo'] = 'Запис інформації з групування груп';
$string['writinggroupingsinfo'] = 'Запис інформації групування';
$string['writinggroupsinfo'] = 'Запис інформації груп';
$string['writingheader'] = 'Запис заголовка';
$string['writingloginfo'] = 'Запис інформації про події';
$string['writingmessagesinfo'] = 'Запис інформації повідомлень';
$string['writingmoduleinfo'] = 'Запис інформації з модулів';
$string['writingscalesinfo'] = 'Запис інформації про шкали';
$string['writinguserinfo'] = 'Запис даних про користувачів';
$string['wrongpassword'] = 'Неправильний пароль для користувача з таким ім\'ям';
$string['year'] = 'рік';
$string['years'] = 'роки';
$string['yes'] = 'Так';
$string['youareabouttocreatezip'] = 'Ви збираєтеся створити zip-файл, який містить';
$string['youaregoingtorestorefrom'] = 'Ви хочете відновити з:';
$string['youhaveupcomingactivitiesdue'] = 'На вас чекають майбутні заходи';
$string['youhaveupcomingactivitiesdueinfo'] = 'Привіт {$a},

<br/><br/>На вас чекають майбутні заходи:';
$string['youneedtoenrol'] = 'Щоб виконати цю дію вам потрібно зареєструватися на курсі.';
$string['yourlastlogin'] = 'Останній вхід';
$string['yourself'] = 'себе';
$string['yourteacher'] = 'ваш {$a}';
$string['yourwordforx'] = 'Звертання до ’{$a}’';
$string['zippingbackup'] = 'Zip-архівація резервної копії';
