<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'da', version '5.0'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Kan ikke oprette den nye konto i Active Directory. Du skal sikre dig at du opfylder alle krav (LDAPS forbindelse, bind-bruger med tilstrækkelige rettigheder osv.)';
$string['auth_ldap_attrcreators'] = 'Liste med grupper eller kontekster, hvis medlemmer må oprette attributter. Adskil flere grupper med ";". Som regel noget i retning af "cn=lærere, ou=personale, o=myorg"';
$string['auth_ldap_attrcreators_key'] = 'Attribut-forfattere';
$string['auth_ldap_auth_user_create_key'] = 'Opret brugere eksternt';
$string['auth_ldap_bind_dn'] = 'Hvis du bruger bind-user til søgning, skal det angives her. Noget  med \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Unikt navn';
$string['auth_ldap_bind_pw'] = 'Bind-brugers adgangskode';
$string['auth_ldap_bind_pw_key'] = 'Adgangskode';
$string['auth_ldap_bind_settings'] = 'Bind-indstilling';
$string['auth_ldap_changepasswordurl_key'] = 'URL til ændring af adgangskode';
$string['auth_ldap_contexts'] = 'Liste over sammenhænge, hvor brugerne befinder sig. Adskil forskellige kontekster med \';\'. For eksempel: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Kontekster';
$string['auth_ldap_create_context'] = 'Hvis du tillader brugeroprettelse med verificering via e-mail, angiv da i hvilken sammenhæng brugerne bliver oprettet. Denne kontekst bør af sikkerhedshensyn være anderledes end andre. Du behøver ikke at føje sammenhængen til variablen \'ldap_context\', Moodle vil automatisk søge efter brugere i denne kontekst.<br /><b>NB!</b> Du skal redigere metoden user_create() i filen auth/ldap/auth.php for at brugeroprettelsen kan fungere.';
$string['auth_ldap_create_context_key'] = 'Kontekst for nye brugere';
$string['auth_ldap_create_error'] = 'Fejl under oprettelse af bruger i LDAP.';
$string['auth_ldap_expiration_desc'] = 'Vælg "{$a->no}" for at deaktivere kontrol af udløb af adgangskode eller "{$a->ldapserver}" hvis kodens udløbstid skal læses direkte fra LDAP';
$string['auth_ldap_expiration_key'] = 'Udløb';
$string['auth_ldap_expiration_warning_desc'] = 'Antal dage i forvejen der advares om at en adgangskode udløber.';
$string['auth_ldap_expiration_warning_key'] = 'Advarsel om udløb';
$string['auth_ldap_expireattr_desc'] = 'Valgfrit: Overskriver LDAP-attribut der gemmer udløbstid for adgangskode';
$string['auth_ldap_expireattr_key'] = 'Udløbsdato-attribut';
$string['auth_ldap_graceattr_desc'] = 'Valgfrit: Overskriver gracelogin-attribut.';
$string['auth_ldap_gracelogin_key'] = 'Grace-loginattribut';
$string['auth_ldap_gracelogins_desc'] = 'Aktiver understøttelse af LDAP-gracelogin. Efter adgangskoden er udløbet, kan brugeren logge ind indtil gracelogin-tælleren er 0. Hvis denne indstilling er aktiveret, vil en gracelogin-besked blive vist hvis adgangskoden er udløbet.';
$string['auth_ldap_gracelogins_key'] = 'Grace-logins';
$string['auth_ldap_groupecreators'] = 'Liste med grupper eller kontekster, hvis medlemmer må oprette grupper. Adskil flere grupper med ";". Som regel noget i retning af "cn=lærere, ou=personale, o=myorg"';
$string['auth_ldap_groupecreators_key'] = 'Gruppeadministratorer';
$string['auth_ldap_host_url'] = 'Angiv LDAP-vært i URL-form f.eks. "ldap://ldap.minskole.dk/" eller "ldaps://ldap.minskole.dk/". Adskil flere servere med ";" (semikolon) for at få "failover support".';
$string['auth_ldap_host_url_key'] = 'Værts-URL';
$string['auth_ldap_ldap_encoding'] = 'Tegnkodning brugt af LDAP-serveren, sandsynligvis utf-8. Er LDAP v2 valgt, bruger Aktive Directory dens konfigurerede kodning såsom cp1252 eller cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP-kodning';
$string['auth_ldap_login_settings'] = 'Loginindstillinger';
$string['auth_ldap_memberattribute'] = 'Angiv bruger-attribut, når en bruger tilhører en gruppe. Normalt \'member\'';
$string['auth_ldap_memberattribute_isdn'] = 'Overskriver håndtering af værdi på medlemsattribut, enten 0 eller 1';
$string['auth_ldap_memberattribute_isdn_key'] = 'Medlemsattribut bruger dn';
$string['auth_ldap_memberattribute_key'] = 'Medlemsattribut';
$string['auth_ldap_no_mbstring'] = 'Du skal bruge mbstring-udvidelsen for at oprette brugere i Active Directory';
$string['auth_ldap_noconnect'] = 'LDAP-modulet kan ikke forbinde til serveren: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-modulet kan ikke oprette forbindelse til nogen servere: {$a}';
$string['auth_ldap_noextension'] = 'PHP LDAP-modulet lader ikke til at være til stede. Sørg for at det er installeret og aktiveret, hvis du ønsker at bruge dette godkendelses-plugin.';
$string['auth_ldap_objectclass'] = 'Valgfrit: Overskriver objectClass brugt til navn/søgning på brugere på ldap_user_type. Du behøver normalt ikke at ændre det.';
$string['auth_ldap_objectclass_key'] = 'Objekt-klasse';
$string['auth_ldap_opt_deref'] = 'Styrer hvordan aliaser behandles under søgning. Vælg en af de følgende værdier: "Nej" (LDAP_DEREF_NEVER) eller "Ja" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Dereference aliaser';
$string['auth_ldap_passtype'] = 'Angiv formatet på nye eller ændrede adgangskoder i LDAP-serveren.';
$string['auth_ldap_passtype_key'] = 'Adgangskodeformat';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP-adgangskodes udløbsindstilling';
$string['auth_ldap_preventpassindb'] = 'Vælg Ja for at forhindre at adgangskoder gemmes i Moodles database.';
$string['auth_ldap_preventpassindb_key'] = 'Brug ikke mellemlagring (cache) af adgangskoder.';
$string['auth_ldap_rolecontext'] = '{$a->localname} kontekst';
$string['auth_ldap_rolecontext_help'] = 'LDAP-kontekst til valg af <i>{$a->localname}</i>-tilknytning. Adskil flere grupper med ";". Som regel noget i retning af "cn={$a->shortname}, ou=second-ou-with-role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Søg brugere fra underliggende kontekster';
$string['auth_ldap_search_sub_key'] = 'Søg i underliggende kontekster';
$string['auth_ldap_server_settings'] = 'LDAP-serverindstilling';
$string['auth_ldap_suspended_attribute'] = 'Valgfri: Angives denne attribut, vil den blive brugt til at aktivere/suspendere den lokalt oprettede brugerkonto.';
$string['auth_ldap_suspended_attribute_key'] = 'Suspenderet attribut';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() understøtter ikke den valgte brugertype: {$a}';
$string['auth_ldap_update_userinfo'] = 'Opdater brugerinformation (fornavn, efternavn, adresse...) fra LDAP til Moodle. Specificer efter behov "Data mapping"-indstillingerne.';
$string['auth_ldap_user_attribute'] = 'Attributten til navngivning/søgning af brugere. Sædvanligvis \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Bruger-attribut';
$string['auth_ldap_user_exists'] = 'LDAP-brugernavnet er allerede oprettet.';
$string['auth_ldap_user_settings'] = 'Brugeropslagsindstilling';
$string['auth_ldap_user_type'] = 'Vælg hvordan brugere gemmes i LDAP. Indstillingen specificerer hvordan loginudløb, gracelogins og brugeroprettelse skal fungere.';
$string['auth_ldap_user_type_key'] = 'Brugertype';
$string['auth_ldap_usertypeundefined'] = 'config.user_type er ikke defineret eller funktionen ldap_expirationtime2unix understøtter ikke den valgte type!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type er ikke defineret eller funktionen ldap_unixi2expirationtime understøtter ikke den valgte type!';
$string['auth_ldap_version'] = 'Den versionen af LDAP-protokollen din server bruger.';
$string['auth_ldap_version_key'] = 'Version';
$string['auth_ldapdescription'] = 'Denne metode kræver godkendelse op mod en ekstern LDAP-server.
Hvis det/den givne brugernavn/adgangskode er gyldig, opretter Moodle en ny bruger i databasen. Dette modul kan læse brugerattributter fra LDAP og udfylde ønskede felter i Moodle. Ved efterfølgende logins tjekkes kun brugernavn og adgangskode.';
$string['auth_ldapextrafields'] = 'Disse felter er valgfrie. Du kan vælge at udfylde Moodlefelter på forhånd fra <b>LDAP-felterne</b> som du angiver her. </p><p>Hvis du ikke skriver noget her, vil intet overføres fra LDAP og Moodles standardværdier vil blive brugt i stedet.</p><p>I alle tilfælde vil brugeren være i stand ændre i felterne efter de er logget ind.</p>';
$string['auth_ldapnotinstalled'] = 'Kan ikke bruge LDAP-godkendelse. PHP\'s LDAP-modul er ikke installeret';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Vælg ja for at forsøge Single Sign On med NTLM-domænet. Bemærk at det kræver speciel opsætning på webserveren, se <a href="https://docs.moodle.org/en/NTLM_authentication">NTLM_authentication på docs.moodle.org</a>';
$string['auth_ntlmsso_enabled_key'] = 'Aktiver';
$string['auth_ntlmsso_ie_fastpath'] = 'Indstil til at aktivere NTLM SSO fast path (omgår visse trin, hvis klientens browser er MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Forsøg NTLM med alle browsere';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE fast path?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Ja, forsøg NTLM på andre browsere';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Ja, alle andre browsere bruger standardlogin-formularen';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Kan ikke udtrække brugernavnet fra REMOTE_USER header. Er det konfigurerede format korrekt?';
$string['auth_ntlmsso_missing_username'] = 'Du skal specificere mindst %username% i det eksterne format til brugernavn';
$string['auth_ntlmsso_remoteuserformat'] = 'Har du valgt \'NTLM\' i \'Godkendelsestype\', kan du specificere det eksterne format til brugernavn her. Lader du feltet stå tomt, vil standardformatet til DOMÆNE\\brugernavn blive brugt. Du kan bruge den valgfrie variabel <b>%domain%</b> til at angive hvor domænenavnet optræder, og den obligatoriske variabel <b>%username%</b> til hvor brugernavnet optræder. <br /><br />
Nogle almindeligt brugte formater e r<tt>%domain%\\%username%</tt> (MS Windows standard), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> og bare <tt>%username%</tt> (hvis ikke der er en domænedel)';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Format på eksternt brugernavn';
$string['auth_ntlmsso_subnet'] = 'Hvis angivet, vil den kun forsøge SSO med klienter i dette subnet. Format: xxx.xxx.xxx.xxx/bitmask. Separer flere subnet med \',\' (komma).';
$string['auth_ntlmsso_subnet_key'] = 'Subnet';
$string['auth_ntlmsso_type'] = 'Den godkendelsesmetode, der er konfigureret på webserveren til brugergodkendelse (vælg NTLM hvis du er i tvivl)';
$string['auth_ntlmsso_type_key'] = 'Godkendelsestype';
$string['cannotmaprole'] = 'Rollen "{$a->rolename}" kan ikke tilknyttes da dens korte navn "{$a->shortname}" er for langt og/eller indeholder bindestreger. Det korte navn skal derfor afkortes til højst {$a->charlimit} tegn og bindestreger fjernes. <a href="{$a->link}">Rediger rollen</a>';
$string['connectingldap'] = 'Forbinder til LDAP-server...';
$string['connectingldapsuccess'] = 'Forbundet til din LDAP-server';
$string['creatingtemptable'] = 'Opretter midlertidig tabel {$a}';
$string['diag_contextnotfound'] = 'Indholdet {$a} eksisterer ikke eller kan ikke læses af bind DN.';
$string['diag_emptycontext'] = 'Tomt indhold fundet.';
$string['diag_genericerror'] = 'LDAP-fejl {$a->code} ved læsning af {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Gruppen {$a->group} for rollen {$a->localname} eksisterer ikke eller kan ikke læses af bind DN';
$string['diag_toooldversion'] = 'Det er meget usandsynligt at en moderne LDAP-server bruger LDAPv2-protokollen. Forkerte indstillinger kan ødelæge værdier i brugerfelter. Tjek med din LDAP-administrator.';
$string['didntfindexpiretime'] = 'password_expire() kan ikke finde udløbstidspunktet.';
$string['didntgetusersfromldap'] = 'Fik ingen brugere fra LDAP - fejl? - forlader';
$string['gotcountrecordsfromldap'] = 'Fik {$a} poster fra LDAP';
$string['invalidusererrors'] = 'Advarsel: Oprettelse af {$a} brugerkonti blev sprunget over.';
$string['invaliduserexception'] = 'Fejl: Kan ikke oprette ny brugerkonto. Detaljer og årsag:
{$a}
Brugeren springes over.';
$string['ldapnotconfigured'] = 'LDAP-værtens url er p.t. ikke konfigureret';
$string['morethanoneuser'] = 'Mere end en brugerpost er fundet i LDAP. Bruger kun den første.';
$string['needbcmath'] = 'Du skal bruge BCMath-udvidelsen til tjek af udløb af adgangskoder med Active Directory.';
$string['needmbstring'] = 'Du skal bruge mbstring-udvidelsen for at ændre adgangskode i Active Directory';
$string['nodnforusername'] = 'Fejl i user_update_password(). Ingen DN for: {$a->username}';
$string['noemail'] = 'Forsøgte forgæves at sende en e-mail!';
$string['notcalledfromserver'] = 'Skal ikke kaldes fra webserveren!';
$string['noupdatestobedone'] = 'Der er ingen opdateringer';
$string['nouserentriestoremove'] = 'Ingen brugerposter at fjerne';
$string['nouserentriestorevive'] = 'Ingen brugerposter at genskabe';
$string['nouserstobeadded'] = 'Ingen brugerposter at tilføje';
$string['ntlmsso_attempting'] = 'Forsøg på Single Sign On via NTLM...';
$string['ntlmsso_failed'] = 'Auto-login mislykkedes, så prøv den normale loginside...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO er deaktiveret.';
$string['ntlmsso_unknowntype'] = 'Ukendt type ntlmsso!';
$string['pagedresultsnotsupp'] = 'Paginerede LDAP-resultater understøttes ikke (enter mangler din PHP-version understøttelse, du har konfigureret Moodle til at bruge LDAP-protokol version 2 eller Moodle kan ikke kontakte din LDAP-server for at se om paginering supporteres.)';
$string['pagesize'] = 'Sørg for, at denne værdi er mindre end din LDAP-servers resultatgrænse (det maksimale antal poster, der kan returneres i en enkelt forespørgsel)';
$string['pagesize_key'] = 'Sidestørrelse';
$string['pluginname'] = 'LDAP-server';
$string['pluginnotenabled'] = 'Plugin ikke aktiveret!';
$string['privacy:metadata'] = 'Godkendelsesplugin\'et LDAP-server gemmer ingen personlige data.';
$string['renamingnotallowed'] = 'Det er ikke tilladt at omdøbe brugere i LDAP';
$string['rootdseerror'] = 'Fejl ved forespørgsel af rootDSE for Active Directory';
$string['start_tls'] = 'Brug normal LDAP-service (port 389) med TLS-kryptering';
$string['start_tls_key'] = 'Brug TLS';
$string['sync_updateuserchunk'] = 'Sæt denne værdi til antallet af brugere, du ønsker opdateret pr. transaktion. Hvis du sætter den til 0, opdateres alle brugere i én transaktion';
$string['sync_updateuserchunk_key'] = 'Synkronisering af opdatering af brugeres chunk-størrelse';
$string['syncroles'] = 'Synkroniser systemroller fra LDAP';
$string['synctask'] = 'Synkroniseringsjob for LDAP-brugere';
$string['systemrolemapping'] = 'Tilknytning af systemrolle';
$string['updatepasserror'] = 'Fejl i user_update_password(). Fejlkode: {$a->errno}; Fejlmelding: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Fejl i user_update_password() under læsning af adgangskodeudløb. Fejlkode: {$a->errno}; Fejlmelding: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Fejl i user_update_password() ved ændring af udløbstid og/eller grace logins. Fejlkode: {$a->errno}; Fejlmelding: {$a->errstring}';
$string['updateremfail'] = 'Fejl under opdatering af LDAP-post. Fejlkode: {$a->errno}; Fejlmelding: {$a->errstring}<br/>Nøgle ({$a->key}) - gammel Moodleværdi: \'{$a->ouvalue}\' ny værdi: \'{$a->nuvalue}';
$string['updateremfailamb'] = 'Det mislykkedes at opdatere LDAP med tvetydigt felt {$a->key}; gammel Moodleværdi: "{$a->ouvalue}", ny værdi: "{$a->nuvalue}"';
$string['updateusernotfound'] = 'Kunne ikke finde bruger under opdatering eksternt. Detaljer: søg i basen: "{$a->userdn}"; søgefilter: "(objectClass=*)"; søgeattributter: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() understøtter ikke den valgte brugertype: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() understøtter ikke den valgte brugertype: {$a}';
$string['useracctctrlerror'] = 'Mislykkedes at hente userAccountControl for {$a}';
$string['userentriestoadd'] = 'Brugerposter der skal tilføjes: {$a}';
$string['userentriestoremove'] = 'Brugerposter der skal fjernes: {$a}';
$string['userentriestorevive'] = 'Brugerposter der skal gendannes: {$a}';
$string['userentriestoupdate'] = 'Brugerposter der skal opdateres: {$a}';
$string['usernotfound'] = 'Bruger ikke fundet i LDAP';
