<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'mn', version '5.0'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Шинэ үүрэг нэмж байна';
$string['addrole'] = 'Шинэ үүрэг нэмэх';
$string['advancedoverride'] = 'Нарийвчилсан үүргийг хүчингүй болгох';
$string['allow'] = 'Зөвшөөрөх';
$string['allowassign'] = 'Үүргийн хуваарилалтыг зөвшөөрөх';
$string['allowed'] = 'Зөвшөөрсөн';
$string['allowoverride'] = 'Үүргийг хүчингүй болгохыг зөвшөөрөх';
$string['allowroletoassign'] = '{$a->fromrole} үүрэг бүхий хэрэглэгчид {$a->targetrol} үүрэг хуваарилахыг зөвшөөрөх';
$string['allowroletooverride'] = '{$a->fromrole} үүрэг бүхий хэрэглэгчид {$a->targetrol} үүргийг хүчингүй болгохыг зөвшөөрөх';
$string['allowroletoswitch'] = '{$a->fromrole} үүрэг бүхий хэрэглэгчид {$a->targetrol} үүрэгт шилжихийг зөвшөөрөх';
$string['allowroletoview'] = '{$a->fromrole} үүрэг бүхий хэрэглэгчид {$a->targetrol} үүргийг харахыг зөвшөөрөх';
$string['allowswitch'] = 'Үүрэг шилжихийг зөвшөөрөх';
$string['allowview'] = 'Үүрэг харахыг зөвшөөрөх';
$string['allsiteusers'] = 'Сайтын бүх хэрэглэгч';
$string['analytics:listinsights'] = 'Ойлголтоо жагсаах';
$string['analytics:listowninsights'] = 'Өөрийн ойлголтоо жагсаах';
$string['analytics:managemodels'] = 'Загварыг удирдах';
$string['archetype'] = 'Үүргийн загвар';
$string['archetype_help'] = 'Үүргийн загвар нь үүргийг өгөгдмөл тохигоогоор дахин тохируулах үеийн зөвшөөрлийг тодорхойлдог. Энэ нь тухайн сайтыг шинэчлэх үед үүрэг гүйцэтгэх дурын шинэ зөвшөөрлийг тодорхойлдог.';
$string['archetypecoursecreator'] = 'ARCHETYPE: Хичээл үүсгэгч';
$string['archetypeeditingteacher'] = 'ARCHETYPE: Багш (засварлах)';
$string['archetypefrontpage'] = 'ARCHETYPE: Сайтын нүүр хуудас дээрх баталгаажсан хэрэглэгч';
$string['archetypeguest'] = 'ARCHETYPE: Зочин';
$string['archetypemanager'] = 'ARCHETYPE: Менежер';
$string['archetypestudent'] = 'ARCHETYPE: Суралцагч';
$string['archetypeteacher'] = 'ARCHETYPE: Багш (засварлахгүй)';
$string['archetypeuser'] = 'ARCHETYPE: Баталгаажсан хэрэглэгч';
$string['assignanotherrole'] = 'Өөр үүрэг хуваарилах';
$string['assignedroles'] = 'Үүрэг хуваарилах';
$string['assignerror'] = '{$a->user} хэрэглэгчид {$a->role} үүргийг хуваарилах үед алдаа гарлаа.';
$string['assignglobalroles'] = 'Системийн үүрэг хуваарилах';
$string['assignmentcontext'] = 'Хуваарилалтын хамрах хүрээ';
$string['assignmentoptions'] = 'Хуваарилалтын сонголтууд';
$string['assignrole'] = 'Үүрэг хуваарилах';
$string['assignrolenameincontext'] = '{$a->context} хамрах хүрээнд \'{$a->role}\' үүрэг хуваарилах';
$string['assignroles'] = 'Үүрэг хуваарилах';
$string['assignroles_help'] = 'Хамрах хүрээний хэрэглэгчид үүрэг хуваарилснаар түүнд тухайн үүрэгт хамаарах зөвшөөрлийг одоогийн нөхцөл болон бүх доод хамрах хүрээнд олгодог. Жишээлбэл, хэрэглэгчийг тухайн хичээлд суралцагчийн үүрэгтэйгээр хуваарилсан бол хичээлийн бүх үйл ажиллагаа, блокт суралцагчийн үүрэг гүйцэтгэх болно.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = '{$a}-д үүрэг хуваарилах';
$string['assignrolesrelativetothisuser'] = 'Энэ хэрэглэгчтэй холбоотой үүрэг хуваарилах';
$string['backtoallroles'] = 'Бүх үүргийн жагсаалт руу буцах';
$string['backup:anonymise'] = 'Нөөцлөлтөд хэрэглэгчийн өгөгдлийг нууцлах';
$string['backup:backupactivity'] = 'Үйл ажиллагааг нөөцлөх';
$string['backup:backupcourse'] = 'Хичээлийг нөөцлөх';
$string['backup:backupsection'] = 'Хэсгийг нөөцлөх';
$string['backup:backuptargetimport'] = 'Импортлоход нөөцлөх';
$string['backup:configure'] = 'Нөөцлөх сонголтыг тохируулах';
$string['backup:downloadfile'] = 'Нөөцлөх хэсгээс файл татаж авах';
$string['backup:userinfo'] = 'Хэрэглэгчийн өгөгдлийг нөөцлөх';
$string['badges:awardbadge'] = 'Хэрэглэгчид батламж тэмдэг олгох';
$string['badges:configurecriteria'] = 'Батламж тэмдэг авах шалгуурыг тохируулах/засах';
$string['badges:configuredetails'] = 'Батламж тэмдгийн дэлгэрэнгүйг тохируулах/засах';
$string['badges:configuremessages'] = 'Батламж тэмдгийн зурвасыг тохируулах';
$string['badges:createbadge'] = 'Батламж тэмдгийг үүсгэх/хувилах';
$string['badges:deletebadge'] = 'Батламж тэмдгийг устгах';
$string['badges:earnbadge'] = 'Батламж тэмдгийг авах';
$string['badges:manageglobalsettings'] = 'Батламж тэмдгийн нээлттэй тохиргоог удирдах';
$string['badges:manageownbadges'] = 'Өөрийн авсан батламж тэмдгийг харах, удирдах';
$string['badges:revokebadge'] = 'Хэрэглэгчийн батламж тэмдгийг хүчингүй болгох';
$string['badges:viewawarded'] = 'Батламж тэмдгийг олгох боломжгүйгээр тодорхой батламж тэмдэг авсан хэрэглэгчдийг харах';
$string['badges:viewbadges'] = 'Батламж тэмдгийг авахгүйгээр боломжит батламж тэмдгийг харах';
$string['badges:viewotherbadges'] = 'Бусад хэрэглэгчийн профайл дээрх нээлттэй батламж тэмдгийг харах';
$string['block:edit'] = 'Блокийн тохиргоог засах';
$string['block:view'] = 'Блокийг харах';
$string['blog:create'] = 'Шинэ блог бичлэг үүсгэх';
$string['blog:manageentries'] = 'Бичлэгийг засах, удирдах';
$string['blog:manageexternal'] = 'Гадаад блогийг засах, удирдах';
$string['blog:search'] = 'Блогийн бичлэгийг хайх';
$string['blog:view'] = 'Блогийн бичлэгийг харах';
$string['blog:viewdrafts'] = 'Блогийн бичлэгийн нооргийг харах';
$string['calendar:manageentries'] = 'Хуанлийн дурын бичлэгийг удирдах';
$string['calendar:managegroupentries'] = 'Хуанлийн бүлэг бичлэгийг удирдах';
$string['calendar:manageownentries'] = 'Өөрийн хуанлийн бичлэгийг удирдах';
$string['capabilities'] = 'Чадварууд';
$string['capability'] = 'Чадвар';
$string['category:create'] = 'Ангилал үүсгэх';
$string['category:delete'] = 'Ангиллыг устгах';
$string['category:manage'] = 'Ангиллыг удирдах';
$string['category:update'] = 'Ангиллыг шинэчлэх';
$string['category:viewcourselist'] = 'Хичээлийн ангилал, түүний хичээлийг харах';
$string['category:viewhiddencategories'] = 'Нуусан ангиллыг харах';
$string['category:visibility'] = 'Нуусан ангиллыг харах';
$string['checkglobalpermissions'] = 'Системийн зөвшөөрлийг шалгах';
$string['checkpermissions'] = 'Зөвшөөрлийг шалгах';
$string['checkpermissionsin'] = '{$a} дахь зөвшөөрлийг шалгах';
$string['checksystempermissionsfor'] = '{$a->fullname} хэрэглэгчийн системийн зөвшөөрлийг шалгах';
$string['checkuserspermissionshere'] = '{$a->fullname} хэрэглэгчийн {$a->contextlevel} дэх системийн зөвшөөрлийг шалгах';
$string['chooseroletoassign'] = 'Хуваарилах үүргийг сонгоно уу';
$string['cohort:assign'] = 'Кохортын гишүүнийг нэмэх, хасах';
$string['cohort:configurecustomfields'] = 'Кохортын тусгай талбарыг тохируулах';
$string['cohort:manage'] = 'Кохорт үүсгэх, устгах, зөөх';
$string['cohort:view'] = 'Сайт хэмжээнд кохортыг харах';
$string['comment:delete'] = 'Сэтгэгдлийг устгах';
$string['comment:post'] = 'Сэтгэгдэл бичих';
$string['comment:view'] = 'Сэтгэгдлийг унших';
$string['competency:competencygrade'] = 'Чадамжийн зэрэглэлийг тогтоох';
$string['competency:competencymanage'] = 'Чадамжийн хүрээг удирдах';
$string['competency:competencyview'] = 'Чадамжийн хүрээг харах';
$string['competency:coursecompetencyconfigure'] = 'Хичээлийн чадамжийн тохиргоог тохируулах';
$string['competency:coursecompetencygradable'] = 'Чадамжийн оноо авах';
$string['competency:coursecompetencymanage'] = 'Хичээлийн чадамжийг удирдах';
$string['competency:coursecompetencyview'] = 'Хичээлийн чадамжийн харах';
$string['competency:evidencedelete'] = 'Нотлох баримтыг устгах';
$string['competency:plancomment'] = 'Сургалтын төлөвлөгөөний талаар сэтгэгдэл бичих';
$string['competency:plancommentown'] = 'Сургалтын төлөвлөгөөний талаар өөрийн сэтгэгдлийг бичих';
$string['competency:planmanage'] = 'Сургалтын төлөвлөгөөг удирдах';
$string['competency:planmanagedraft'] = 'Сургалтын төлөвлөгөөний төслийг удирдах';
$string['competency:planmanageown'] = 'Өөрийн сургалтын төлөвлөгөөг удирдах';
$string['competency:planmanageowndraft'] = 'Өөрийн сургалтын төлөвлөгөөний төслийг удирдах';
$string['competency:planrequestreview'] = 'Сургалтын төлөвлөгөөг хянах хүсэлт гаргах';
$string['competency:planrequestreviewown'] = 'Өөрийн сургалтын төлөвлөгөөг хянах хүсэлт гаргах';
$string['competency:planreview'] = 'Сургалтын төлөвлөгөөг хянах';
$string['competency:planview'] = 'Бүх сургалтын төлөвлөгөөг харах';
$string['competency:planviewdraft'] = 'Сургалтын төлөвлөгөөний төслийг харах';
$string['competency:planviewown'] = 'Өөрийн сургалтын төлөвлөгөөг харах';
$string['competency:planviewowndraft'] = 'Өөрийн сургалтын төлөвлөгөөний төслийг харах';
$string['competency:templatemanage'] = 'Сургалтын төлөвлөгөөний загварыг удирдах';
$string['competency:templateview'] = 'Сургалтын төлөвлөгөөний загварыг харах';
$string['competency:usercompetencycomment'] = 'Хэрэглэгчийн чадамжийн талаар сэтгэгдэл бичих';
$string['competency:usercompetencycommentown'] = 'Өөрийн хэрэглэгчийн чадамжийн талаар сэтгэгдэл бичих';
$string['competency:usercompetencyrequestreview'] = 'Хэрэглэгчийн чадамжийг хянах хүсэлт гаргах';
$string['competency:usercompetencyrequestreviewown'] = 'Өөрийн хэрэглэгчийн чадамжийг хянах хүсэлт гаргах';
$string['competency:usercompetencyreview'] = 'Хэрэглэгчийн чадамжийг хянах';
$string['competency:usercompetencyview'] = 'Хэрэглэгчийн чадамжийг харах';
$string['competency:userevidencemanage'] = 'Сургалтаас өмнө нотлох баримтыг удирдах';
$string['competency:userevidencemanageown'] = 'Сургалтаас өмнө өөрийн нотлох баримтыг удирдах';
$string['competency:userevidenceview'] = 'Сургалтаас өмнө хэрэглэгчийн нотлох баримтыг харах';
$string['confirmaddadmins'] = 'Та дараах хэрэглэгчийг сайтын администраторын жагсаалтад нэмэхэд итгэлтэй байна уу?';
$string['confirmremoveadmins'] = 'Та дараах хэрэглэгчийг сайтын администраторын жагсаалтаас хасахад итгэлтэй байна уу?';
$string['confirmroleprevent'] = 'Та "{$a->context}" хамрах хүрээний "{$a->cap}" чадварын зөвшөөрсөн үүргийн жагсаалтаас <strong>"{$a->role}"</strong> үүргийг хасахыг хүсэж байна уу?';
$string['confirmroleunprohibit'] = 'Та "{$a->context}" хамрах хүрээний "{$a->cap}" чадварын хориглосон үүргийн жагсаалтаас <strong>"{$a->role}"</strong> үүргийг хасахыг хүсэж байна уу?';
$string['confirmunassign'] = 'Та энэ хэрэглэгчээс энэ үүргийг устгахдаа итгэлтэй байна уу?';
$string['confirmunassignno'] = 'Цуцлах';
$string['confirmunassigntitle'] = 'Үүргийн өөрчлөлтийг баталгаажуулах';
$string['confirmunassignyes'] = 'Устгах';
$string['contentbank:access'] = 'Агуулгын санд нэвтрэх';
$string['contentbank:deleteanycontent'] = 'Агуулгын сангаас дурын агуулгыг устгах';
$string['contentbank:deleteowncontent'] = 'Өөрийн агуулгын сангаас агуулгыг устгах';
$string['contentbank:downloadcontent'] = 'Агуулгын сангаас агуулгыг татан авах';
$string['contentbank:manageanycontent'] = 'Агуулгын сангаас дурын агуулгыг удирдах';
$string['contentbank:manageowncontent'] = 'Өөрийн агуулгын сангаас агуулгыг удирдах';
$string['contentbank:upload'] = 'Агуулгын санд шинэ агуулгыг байршуулах';
$string['contentbank:useeditor'] = 'Агуулгын төрлийн засварлагчийг ашиглан агуулга үүсгэх эсвэл засварлах';
$string['contentbank:viewunlistedcontent'] = 'Агуулгын сангаас жагсаагдаагүй агуулгыг харах';
$string['context'] = 'Агуулга';
$string['contextrolenotallowed'] = 'Энэ хүрээнд {$a} үүргийг зөвшөөрөхгүй.';
$string['course:activityvisibility'] = 'Үйл ажиллагааг нуух/харуулах';
$string['course:bulkmessaging'] = 'Олон хүнд зурвас илгээх';
$string['course:changecategory'] = 'Хичээлийн ангиллыг өөрчлөх';
$string['course:changefullname'] = 'Хичээлийн бүтэн нэрийг өөрчлөх';
$string['course:changeidnumber'] = 'Хичээлийн ID дугаарыг өөрчлөх';
$string['course:changelockedcustomfields'] = 'Түгжсэн тусгай талбарыг өөрчлөх';
$string['course:changeshortname'] = 'Хичээлийн товч нэрийг өөрчлөх';
$string['course:changesummary'] = 'Хичээлийн хураангуйг өөрчлөх';
$string['course:configurecustomfields'] = 'Тусгай талбарыг тохируулах';
$string['course:configuredownloadcontent'] = 'Татаж авах хичээлийн агуулгыг тохируулах';
$string['course:create'] = 'Хичээл үүсгэх';
$string['course:creategroupconversations'] = 'Бүлгийн харилцан яриа үүсгэх';
$string['course:delete'] = 'Хичээл устгах';
$string['course:downloadcoursecontent'] = 'Хичээлийн агуулгыг татаж авах';
$string['course:enrolconfig'] = 'Хичээлд бүртгүүлэх тохиолдлыг тохируулах';
$string['course:enrolreview'] = 'Хичээлийн бүртгэлийг хянах';
$string['course:ignoreavailabilityrestrictions'] = 'Боломжит хязгаарлалтыг алгасах';
$string['course:ignorefilesizelimits'] = 'Дурын файлын хэмжээний хязгаарлалтаас том хэмжээтэй файлыг ашиглах';
$string['course:isincompletionreports'] = 'Гүйцэтгэлийн тайланд харуулсан байх';
$string['course:manageactivities'] = 'Үйл ажиллагааг удирдах';
$string['course:managefiles'] = 'Файлыг удирдах';
$string['course:managegrades'] = 'Үнэлгээг удирдах';
$string['course:managegroups'] = 'Бүлгийг удирдах';
$string['course:managescales'] = 'Хэмжээсийг удирдах';
$string['course:markcomplete'] = 'Хэрэглэгчийг хичээлээ дуусгасан гэж тэмдэглэх';
$string['course:movesections'] = 'Хэсгийг зөөх';
$string['course:overridecompletion'] = 'Үйл ажиллагаа дууссан төлөвийг хүчингүй болгох';
$string['course:recommendactivity'] = 'Үйл ажиллагаа сонгогчид үйл ажиллагааг санал болгох';
$string['course:renameroles'] = 'Үүргийн нэрийг өөрчлөх';
$string['course:request'] = 'Шинэ хичээлийн хүсэлт гаргах';
$string['course:reset'] = 'Хичээлийг дахин тохируулах';
$string['course:reviewotherusers'] = 'Бусад хэрэглэгчийг хянах';
$string['course:sectionvisibility'] = 'Хэсгийн харагдах байдлыг хянах';
$string['course:setcurrentsection'] = 'Идэвхтэй хэсгийг тохируулах';
$string['course:setforcedlanguage'] = 'Хичээл эсвэл үйл ажиллагааны хэлийг хүчээр тохируулах';
$string['course:tag'] = 'Хичээлийн тагийг өөрчлөх';
$string['course:togglecompletion'] = 'Үйл ажиллагааг дууссаныг гараар тэмдэглэх';
$string['course:update'] = 'Хичээлийн тохиргоог шинэчлэх';
$string['course:useremail'] = 'Цахим шуудангийн хаягийг идэвхжүүлэх/идэвхгүй болгох';
$string['course:view'] = 'Хичээлийг оролцохгүйгээр үзэх';
$string['course:viewcoursegrades'] = 'Хичээлийн үнэлгээг харах';
$string['course:viewhiddenactivities'] = 'Нуусан үйл ажиллагааг харах';
$string['course:viewhiddencourses'] = 'Нуусан хичээлийг харах';
$string['course:viewhiddengroups'] = 'Нуусан бүлгийг харах';
$string['course:viewhiddensections'] = 'Нуусан хэсгийг харах';
$string['course:viewhiddenuserfields'] = 'Нуусан хэрэглэгчийн талбарыг харах';
$string['course:viewparticipants'] = 'Оролцогчийг харах';
$string['course:viewscales'] = 'Хэмжээсийг харах';
$string['course:viewsuspendedusers'] = 'Түдгэлзүүлсэн хэрэглэгчийг харах';
$string['course:visibility'] = 'Хичээлийг нуух/харуулах';
$string['createrolebycopying'] = '{$a}-г хуулж шинэ үүрэг үүсгэх';
$string['createthisrole'] = 'Энэ үүргийг үүсгэх';
$string['currentcontext'] = 'Ашиглаж буй агуулга';
$string['currentrole'] = 'Идэвхтэй үүрэг';
$string['customroledescription'] = 'Тусгай тодорхойлолт';
$string['customroledescription_help'] = 'Тусгай тайлбар хоосон байвал стандарт үүргийн тайлбарыг автоматаар нутагшуулна.';
$string['customrolename'] = 'Тусгай бүтэн нэр';
$string['customrolename_help'] = 'Тусгай нэр хоосон байвал стандарт үүргийн нэрийг автоматаар нутагшуулна. Бүх тусгай үүрэгт бүтэн нэр өгөх ёстой.';
$string['defaultrole'] = 'Өгөгдмөл үүрэг';
$string['defaultx'] = 'Өгөгдмөл: {$a}';
$string['defineroles'] = 'Үүргийг тодорхойлох';
$string['deletecourseoverrides'] = 'Хичээлийн бүх хүчингүй болсон зүйлсийг устгах';
$string['deletelocalroles'] = 'Бүх дотоод үүрийн хуваарилалтыг устгах';
$string['deleterolesure'] = '<p>Та "{$a->name} ({$a->shortname})" үүргийг устгахдаа итгэлтэй байна уу?</p><p>Одоогоор энэ үүргийг {$a->count} хэрэглэгчид хуваарилсан байна.</p>';
$string['deletexrole'] = '{$a} үүргийг устгах';
$string['duplicaterole'] = 'Үүргийг хуулбарлах';
$string['duplicaterolesure'] = '<p>Та "{$a->name} ({$a->shortname})" үүргийг хуулбарлахад итгэлтэй байна уу?</p>';
$string['editingrolex'] = '\'{$a}\' үүргийг засварлах';
$string['editrole'] = 'Үүргийг засварлах';
$string['editxrole'] = '{$a} үүргийг засварлах';
$string['errorbadrolename'] = 'Үүргийн нэр буруу';
$string['errorbadroleshortname'] = 'Үүргийн товч нэр буруу';
$string['errorexistsrolename'] = 'Үүргийн нэр хэдийнэ байна';
$string['errorexistsroleshortname'] = 'Үүргийн нэр хэдийнэ байна';
$string['errorroleshortnametoolong'] = 'Товч нэр нь 100 тэмдэгтээс хэтрэхгүй байх ёстой';
$string['eventcapabilityassigned'] = 'Чадварыг хуваарилсан';
$string['eventcapabilityunassigned'] = 'Чадварыг хуваарилаагүй';
$string['eventroleallowassignupdated'] = 'Үүргийн хуваарилалтыг зөвшөөрөх';
$string['eventroleallowoverrideupdated'] = 'Үүргийг хүчингүй болгохыг зөвшөөрөх';
$string['eventroleallowswitchupdated'] = 'Үүргийг шилжүүлэхийг зөвшөөрөх';
$string['eventroleallowviewupdated'] = 'Үүргийг харахыг зөвшөөрөх';
$string['eventroleassigned'] = 'Үүргийг хуваарилсан';
$string['eventrolecapabilitiesupdated'] = 'Үүргийн чадварыг шинэчилсэн';
$string['eventrolecreated'] = 'Үүргийг үүсгэсэн';
$string['eventroledeleted'] = 'Үүргийг устгасан';
$string['eventroleunassigned'] = 'Үүргийг хуваарилаагүй';
$string['eventroleupdated'] = 'Үүргийг шинэчилсэн';
$string['existingadmins'] = 'Тухайн сайтын администратор';
$string['existingusers'] = '{$a} одоо байгаа хэрэглэгч';
$string['explanation'] = 'Тайлбар';
$string['export'] = 'Экспорт';
$string['extusers'] = 'Одоо байгаа хэрэглэгч';
$string['extusersmatching'] = '\'{$a}\'-тай тохирох одоо байгаа хэрэглэгчид';
$string['filter:manage'] = 'Дотоод шүүлтүүрийн тохиргоог удирдах';
$string['frontpageuser'] = 'Сайтын нүүр хуудас дээрх баталгаажсан хэрэглэгч';
$string['frontpageuserdescription'] = 'Сайтын үндсэн сургалтад нэвтэрсэн бүх хэрэглэгч.';
$string['globalrole'] = 'Системийн үүрэг';
$string['globalroleswarning'] = 'Анхааруулга: Энэ хуудаснаас таны хуваарилах дурын үүрэг нь сайтын нүүр хуудас, бүх хичээлийг оролцуулан системийн бүх хэрэглэгчид хамаарна.';
$string['gotoassignroles'] = 'Энэ {$a->contextlevel} хүрээнд үүрэг хуваарилах хэсэгт очих';
$string['gotoassignsystemroles'] = 'Системийн үүрэг хуваарилах хэсэгт очих';
$string['grade:edit'] = 'Үнэлгээг засварлах';
$string['grade:export'] = 'Үнэлгээг импортлох';
$string['grade:hide'] = 'Үнэлгээ эсвэл зүйлийг нуух/харуулах';
$string['grade:import'] = 'Үнэлгээг импортлох';
$string['grade:lock'] = 'Үнэлгээ эсвэл зүйлийг түгжих';
$string['grade:manage'] = 'Үнэлгээний зүйлийг удирдах';
$string['grade:managegradingforms'] = 'Үнэлгээний нарийвчилсан аргыг удирдах';
$string['grade:manageletters'] = 'Үсгэн үнэлгээг удирдах';
$string['grade:manageoutcomes'] = 'Үнэлгээний үр дүнг удирдах';
$string['grade:managesharedforms'] = 'Нарийвчилсан үнэлгээний маягтын загварыг удирдах';
$string['grade:override'] = 'Үнэлгээг хүчингүй болгох';
$string['grade:sharegradingforms'] = 'Нарийвчилсан үнэлгээний маягтыг загвар болгон хуваалцах';
$string['grade:unlock'] = 'Үнэлгээ эсвэл зүйлийг түгжээг тайлах';
$string['grade:view'] = 'Өөрийн үнэлгээг харах';
$string['grade:viewall'] = 'Бусад хэрэглэгчийн үнэлгээг харах';
$string['grade:viewhidden'] = 'Эзэмшигчийн нуусан үнэлгээг харах';
$string['h5p:deploy'] = 'H5P агуулгыг байршуулах';
$string['h5p:setdisplayoptions'] = 'H5P харуулах сонголтыг тохируулах';
$string['h5p:updatelibraries'] = 'H5P агуулгын төрлийг удирдах';
$string['highlightedcellsshowdefault'] = 'Доорх хүснэгтэд тодруулсан зөвшөөрөл нь одоогоор сонгосон үүргийн загварын өгөгдмөл зөвшөөрөл болно.';
$string['highlightedcellsshowinherit'] = 'Доорх хүснэгтийн тодруулсан нүд нь удамших зөвшөөрлийг (хэрэв байгаа бол) харуулдаг. Зөвшөөрлийг өөрчлөхийг хүсэж байгаа боломжоос гадна бүх зүйлийг удамшихаар тохируулсан байх ёстой.';
$string['inactiveformorethan'] = '{$a->timeperiod}-аас дээш хугацаанд идэвхгүй';
$string['ingroup'] = '"{$a->group}" бүлэгт';
$string['inherit'] = 'Удамших';
$string['invalidpresetfile'] = 'Үүргийн тодорхойлолтын файл буруу байна';
$string['legacy:admin'] = 'ХУУЧИН ҮҮРЭГ: Администратор';
$string['legacy:coursecreator'] = 'ХУУЧИН ҮҮРЭГ: Хичээл үүсгэгч';
$string['legacy:editingteacher'] = 'ХУУЧИН ҮҮРЭГ: Багш (засварлах)';
$string['legacy:guest'] = 'ХУУЧИН ҮҮРЭГ: Зочин';
$string['legacy:student'] = 'ХУУЧИН ҮҮРЭГ: Суралцагч';
$string['legacy:teacher'] = 'ХУУЧИН ҮҮРЭГ: Багш (засварлахгүй)';
$string['legacy:user'] = 'ХУУЧИН ҮҮРЭГ: Баталгаажсан хэрэглэгч';
$string['legacytype'] = 'Хуучин үүргийн төрөл';
$string['listallroles'] = 'Бүх үүргийг жагсаах';
$string['localroles'] = 'Дотоодод хуваарилагдсан үүрэг';
$string['mainadmin'] = 'Үндсэн администратор';
$string['mainadminset'] = 'Үндсэн администраторыг тохируулах';
$string['manageadmins'] = 'Сайтын администраторыг удирдах';
$string['manager'] = 'Менежер';
$string['managerdescription'] = 'Менежер хичээлд нэвтэрч, өөрчлөх боломжтой ч үүнд ихэвчлэн оролцдоггүй.';
$string['manageroles'] = 'Үүргийг удирдах';
$string['maybeassignedin'] = 'Энэ үүргийг хуваарилж болох хамрах хүрээний төрлүүд';
$string['moodlenet:shareactivity'] = 'MoodleNet рүү үйл ажиллагааг хуваалцах';
$string['morethan'] = '{$a}-с их';
$string['multipleroles'] = 'Олон үүрэг';
$string['my:configsyspages'] = 'Удирдах самбарын хуудасны системийн загварыг тохируулах';
$string['my:manageblocks'] = 'Удирдах самбарын хуудасны блокийг удирдах';
$string['neededroles'] = 'Зөвшөөрөл бүхий үүрэг';
$string['nocapabilitiesincontext'] = 'Энэ хүрээнд ямар ч чадамж байхгүй байна';
$string['noneinthisx'] = 'Энэ {$a}-д байхгүй';
$string['noneinthisxmatching'] = 'Энэ {$a->contexttype} төрөлд \'{$a->search}\' хайлтаар тохирох хэрэглэгч байхгүй байна';
$string['norole'] = 'Үүрэг байхгүй';
$string['noroleassignments'] = 'Энэ хэрэглэгчид энэ сайтын хаана ч хуваарилсан үүрэг байхгүй байна.';
$string['noroles'] = 'Үүрэг байхгүй';
$string['notabletoassignroleshere'] = 'Энэ хүрээнд үүрэг оноохыг администратор идэвхжүүлээгүй байна.';
$string['notabletooverrideroleshere'] = 'Та энд ямар ч үүргийн зөвшөөрлийг хүчингүй болгох боломжгүй';
$string['notes:manage'] = 'Тэмдэглэлийг удирдах';
$string['notes:view'] = 'Тэмдэглэлийг харах';
$string['notset'] = 'Тохируулаагүй';
$string['novisibleroles'] = 'Үүрэггүй';
$string['overrideanotherrole'] = 'Өөр үүргийг хүчингүй болгох';
$string['overridecontext'] = 'Хамрах хүрээг хүчингүй болгох';
$string['overridepermissions'] = 'Зөвшөөрлийг хүчингүй болгох';
$string['overridepermissions_help'] = 'Зөвшөөрлийг хүчингүй болгосноор сонгосон чадамжийг тодорхой хүрээнд зөвшөөрөх эсвэл хориглох боломжийг олгодог.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = '{$a->context} хүрээнд \'{$a->role}\' үүргийн зөвшөөрлийг хүчингүй болгох';
$string['overridepermissionsin'] = '{$a} дахь зөвшөөрлийг хүчингүй болгох';
$string['overrideroles'] = 'Үүргийг хүчингүй болгох';
$string['overriderolesin'] = '{$a} дахь үүргийг хүчингүй болгох';
$string['overrides'] = 'Хүчингүй болсон';
$string['overridesbycontext'] = 'Хүчингүй болсон (хамрах хүрээгээр)';
$string['payment:manageaccounts'] = 'Бүртгэлийг удирдах';
$string['payment:viewpayments'] = 'Төлбөрийг харах';
$string['permission'] = 'Зөвшөөрөл';
$string['permission_help'] = 'Зөвшөөрөл нь чадварын тохиргоо юм. Дараах 4 сонголттой. Үүнд:

* Тохируулаагүй
* Зөвшөөрөх - Чадварт зөвшөөрөл олгосон
* Урьдчилан сэргийлэх - Илүү өндөр хүрээнд зөвшөөрөгдсөн ч боломжийн зөвшөөрлийг устгасан
* Хориглох - Зөвшөөрлийг бүрэн татгалзсан, ямар ч доод (илүү тодорхой) хүрээнд хүчингүй болгож болохгүй';
$string['permissions'] = 'Зөвшөөрөл';
$string['permissionsforuser'] = '{$a} хэрэглэгчийн зөвшөөрөл';
$string['permissionsincontext'] = '{$a} дахь зөвшөөрөл';
$string['portfolio:export'] = 'Багц руу экспортлох';
$string['potentialusers'] = '{$a} боломжит хэрэглэгчид';
$string['potusers'] = 'Боломжит хэрэглэгчид';
$string['potusersmatching'] = '\'{$a}\'-тай тохирох боломжит хэрэглэгчид';
$string['prevent'] = 'Урьдчилан сэргийлэх';
$string['privacy:metadata:preference:showadvanced'] = 'Нарийвчилсан горимыг асаах/унтраах товчийг дарах';
$string['privacy:metadata:role_assignments'] = 'Үүргийн хуваарилалт';
$string['privacy:metadata:role_assignments:component'] = 'Үүргийн хуваарилалтыг хариуцдаг нэмэлт хэрэгсэл нь гараар хуваарилсан үед хоосон байна.';
$string['privacy:metadata:role_assignments:itemid'] = 'Энэ үүргийн хуваарилалтыг хариуцах бүртгэл/баталгаажуулалтыг тохиолдлын ID дугаар';
$string['privacy:metadata:role_assignments:modifierid'] = 'Үүргийн хуваарилалтыг үүсгэсэн эсвэл өөрчилсөн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:role_assignments:roleid'] = 'Үүргийн ID дугаар';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Энэ хүснэгт нь хамрах хүрээ бүрээрх хуваарилагдсан үүргийг хадгалдаг.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Үүргийн хуваарилалтыг үүсгэсэн эсвэл өөрчилсөн огноо.';
$string['privacy:metadata:role_assignments:userid'] = 'Хэрэглэгчийн ID дугаар';
$string['privacy:metadata:role_capabilities'] = 'Үүргийн чадвар';
$string['privacy:metadata:role_capabilities:capability'] = 'Чадварын нэр.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Энэ чадварыг үүсгэсэн эсвэл өөрчилсөн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:role_capabilities:permission'] = 'Чадварын зөвшөөрөл: удамших, зөвшөөрөх, урьдчилан сэргийлэх, хориглох.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Үүргийн ID дугаар';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Тодорхой хүрээнд тодорхой үүрэг гүйцэтгэх чадвар, чадварыг хүчингүй болгох';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Чадварыг үүсгэсэн эсвэл өөрчилсөн огноо.';
$string['privacy:metadata:role_cohortroles'] = 'Кохортын үүрэг';
$string['prohibit'] = 'Хориглох';
$string['prohibitedroles'] = 'Хориглосон';
$string['question:add'] = 'Шинэ асуулт нэмэх';
$string['question:commentall'] = 'Бүх асуултад сэтгэгдэл бичих';
$string['question:commentmine'] = 'Өөрийн асуултад сэтгэгдэл бичих';
$string['question:config'] = 'Асуултын төрлийг тохируулах';
$string['question:editall'] = 'Бүх асуултыг засварлах';
$string['question:editmine'] = 'Өөрийн асуултыг засварлах';
$string['question:flag'] = 'Асуултыг засварлах явцад тэмдэглэх';
$string['question:managecategory'] = 'Асуултын ангиллыг засварлах';
$string['question:moveall'] = 'Бүх асуултыг зөөх';
$string['question:movemine'] = 'Өөрийн бүх асуултыг зөөх';
$string['question:tagall'] = 'Бүх асуултыг таг хийх';
$string['question:tagmine'] = 'Өөрийн асуултыг таг хийх';
$string['question:useall'] = 'Бүх асуултыг ашиглах';
$string['question:usemine'] = 'Өөрийн асуултыг ашиглах';
$string['question:viewall'] = 'Бүх асуултыг харах';
$string['question:viewmine'] = 'Өөрийн асуултыг харах';
$string['rating:rate'] = 'Зүйлд үнэлгээ нэмэх';
$string['rating:view'] = 'Өөрийн авсан нийт үнэлгээг харах';
$string['rating:viewall'] = 'Хувь хүний өгсөн боловсруулаагүй бүх үнэлгээг харах';
$string['rating:viewany'] = 'Дурын хүний авсан нийт үнэлгээг харах';
$string['reportbuilder:edit'] = 'Өөрийнхөө тусгай тайланг засварлах';
$string['reportbuilder:editall'] = 'Бүх тусгай тайланг засварлах';
$string['reportbuilder:scheduleviewas'] = 'Бусад хэрэглэгч үзэх байдлаар тайланг төлөвлөх';
$string['reportbuilder:view'] = 'Тусгай тайланг харах';
$string['resetrole'] = 'Дахинх тохируулах';
$string['resettingrole'] = '\'{$a}\' үүргийг дахин тохируулж байна';
$string['restore:configure'] = 'Сэргээх сонголтыг тохируулах';
$string['restore:createuser'] = 'Сэргээх үед хэрэглэгчийг үүсгэх';
$string['restore:restoreactivity'] = 'Үйл ажиллагааг сэргээх';
$string['restore:restorecourse'] = 'Хичээлийг сэргээх';
$string['restore:restoresection'] = 'Хэсгийг сэргээх';
$string['restore:restoretargetimport'] = 'Импортлох файлуудаас сэргээх';
$string['restore:rolldates'] = 'Сэргээх явцад үйл ажиллагааны тохиргооны огноог өөрчлөхийг зөвшөөрсөн';
$string['restore:uploadfile'] = 'Файлыг нөөцлөх хэсэгт байршуулах';
$string['restore:userinfo'] = 'Хэрэглэгчийн өгөгдлийг сэргээх';
$string['restore:viewautomatedfilearea'] = 'Автомат нөөцлөлтөөс хичээлийг сэргээх';
$string['risks'] = 'Эрсдэл';
$string['role:assign'] = 'Хэрэглэгчид үүрэг хуваарилах';
$string['role:manage'] = 'Үүрэг үүсгэх, удирдах';
$string['role:override'] = 'Бусдын зөвшөөрлийг хүчингүй болгох';
$string['role:review'] = 'Бусдын зөвшөөрлийг хянах';
$string['role:safeoverride'] = 'Бусдын аюулгүйн зөвшөөрлийг хүчингүй болгох';
$string['role:switchroles'] = 'Бусдын зөвшөөрөлд шилжих';
$string['roleallowheader'] = 'Үүргийг зөвшөөрөх:';
$string['roleallowinfo'] = '"{$a->cap}" чадвар, "{$a->context}" хүрээнд зөвшөөрөгдсөн үүргийн жагсаалтад нэмэх үүргийг сонгоно уу:';
$string['roleassignments'] = 'Үүргийн хуваарилалт';
$string['roledefinitions'] = 'Үүргийн тодорхойлолт';
$string['rolefullname'] = 'Үүргийн нэр';
$string['roleincontext'] = '{$a->context} дахь {$a->role}';
$string['roleprohibitheader'] = 'Үүргийг хориглох';
$string['roleprohibitinfo'] = '"{$a->cap}" чадвар, "{$a->context}" хүрээнд хориглосон үүргийн  жагсаалтад нэмэх үүргийг сонгоно уу:';
$string['rolerepreset'] = 'Тохируулсан үүргийг ашиглах';
$string['roleresetdefaults'] = 'Өгөгдмөл';
$string['roleresetrole'] = 'Үүрэг эсвэл загварыг ашиглах';
$string['rolerisks'] = 'Үүргийн эрсдэл';
$string['roles'] = 'Үүргүүд';
$string['roles_help'] = 'Үүрэг гэдэг нь тодорхой хүрээнд тодорхой хэрэглэгчид хуваарилах боломжтой системд бүхэлд нь тодорхойлсон зөвшөөрлийн цуглуулга юм.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Үүргийг сонгох';
$string['rolesforuser'] = '{$a} хэрэглэгчийн үүрэг';
$string['roleshortname'] = 'Товч нэр';
$string['roleshortname_help'] = 'Үүргийн товч нэр нь зөвхөн ASCII үсэг, тоон тэмдэгтийг зөвшөөрдөг доод түвшний үүрэг тодорхойлогч юм.';
$string['roletoassign'] = 'Хуваарилах үүрэг';
$string['roletooverride'] = 'Хүчингүй болгох үүрэг';
$string['safeoverridenotice'] = 'Тайлбар: Танд зөвхөн аюулгүй чадварыг хүчингүй болгох зөвшөөрөлтэй тул эрсдэл өндөртэй чадварыг түгжсэн байдаг.';
$string['search:query'] = 'Сайтын хэмжээнд хайлт хийх';
$string['selectanotheruser'] = 'Өөр хэрэглэгчийг сонгох';
$string['selectauser'] = 'Хэрэглэгчийг сонгох';
$string['selectrole'] = 'Үүргийг сонгох';
$string['showallroles'] = 'Бүх үүргийг сонгох';
$string['showthisuserspermissions'] = 'Энэ хэрэглэгчийн зөвшөөрлийг харуулах';
$string['site:accessallgroups'] = 'Бүх бүлэгт хандах';
$string['site:approvecourse'] = 'Хичээл үүсгэхийг зөвшөөрөх';
$string['site:backup'] = 'Хичээлийг нөөцлөх';
$string['site:config'] = 'Сайтын тохиргоог өөрчлөх';
$string['site:configview'] = 'Сайтын удирдлагын модыг харах (гэхдээ бүх хуудсыг биш)';
$string['site:deleteanymessage'] = 'Сайт дурын зурвасыг устгах';
$string['site:deleteownmessage'] = 'Хэрэглэгчийн илгээсэн болон хэрэглэгчид илгээсэн зурвасыг устгах';
$string['site:doanything'] = 'Бүх зүйлийг хийхийг зөвшөөрөх';
$string['site:doclinks'] = 'Сайтаас гадуурх баримт бичгийн холбоосыг харуулах';
$string['site:forcelanguage'] = 'Хичээлийн хэлийг хүчингүй болгох';
$string['site:import'] = 'Хичээлд бусад хичээлийг импортлох';
$string['site:maintenanceaccess'] = 'Сайтад засвар үйлчилгээний горимын явцад нэвтрэх';
$string['site:manageallmessaging'] = 'Дурын хэрэглэгчийн харилцах хаягийг нэмэх, устгах, блоклох, блокоос гаргах';
$string['site:manageblocks'] = 'Хуудас дээрх блокийг удирдах';
$string['site:managecontextlocks'] = 'Агуулгыг хөдөлгөөнгүй бэхлэхийг удирдах';
$string['site:messageanyuser'] = 'Дурын хэрэглэгчтэй зурвас солилцохдоо хэрэглэгчийн нууцлалын тохиргоог алгасах';
$string['site:mnetloginfromremote'] = 'MNet ашиглан алсын программаас нэвтрэх';
$string['site:mnetlogintoremote'] = 'MNet ашиглан алсын программаас роуминг хийх';
$string['site:readallmessages'] = 'Сайт дээрх бүх зурвасыг унших';
$string['site:restore'] = 'Хичээлийг сэргээх';
$string['site:senderrormessage'] = 'Алдааны хуудаснаас дэмжих хэрэглэгчид зурвас илгээх';
$string['site:sendmessage'] = 'Дурын хэрэглэгчид зурвас илгээх';
$string['site:trustcontent'] = 'Илгээсэн агуулгад итгэх';
$string['site:uploadusers'] = 'Файлаас шинэ хэрэглэгчийг байршуулах';
$string['site:viewanonymousevents'] = 'Тайлан дахь тодорхойгүй арга хэмжээг харах';
$string['site:viewfullnames'] = 'Хэрэглэгчийн бүтэн нэрийг үргэлж харах';
$string['site:viewparticipants'] = 'Оролцогчдыг харах';
$string['site:viewreports'] = 'Тайланг харах';
$string['site:viewuseridentity'] = 'Жагсаалтаас хэрэглэгчийн бүрэн мэдээллийг харах';
$string['siteadministrators'] = 'Сайтын администратор';
$string['tag:edit'] = 'Байгаа тагийг засварлах';
$string['tag:editblocks'] = 'Таг хуудасны блокийг засварлах';
$string['tag:flag'] = 'Тагийг тохиромжгүй гэж тэмдэглэх';
$string['tag:manage'] = 'Бүх тагийг удирдах';
$string['thisnewrole'] = 'Энэ шинэ үүрэг';
$string['thisusersroles'] = 'Энэ хэрэглэгчийн үүргийн хуваарилалт';
$string['unassignarole'] = '{$a} үүргийг болиулах';
$string['unassignconfirm'] = 'Та "{$a->user}" хэрэглэгчийн "{$a->role}" үүргийг цуцлахыг хүсэж байна уу?';
$string['unassignerror'] = '{$a->user} хэрэглэгчийн {$a->role} үүргийг цуцлах явцад алдаа гарлаа.';
$string['user:changeownpassword'] = 'Өөрийнхөө нууц үгийг өөрчлөх';
$string['user:create'] = 'Хэрэглэгч үүсгэх';
$string['user:delete'] = 'Хэрэглэгчийг устгах';
$string['user:editmessageprofile'] = 'Хэрэглэгчийн зурвасын профайлыг засах';
$string['user:editownmessageprofile'] = 'Өөрийн хэрэглэгчийн зурвасын профайлыг засах';
$string['user:editownprofile'] = 'Өөрийн хэрэглэгчийн профайлыг засах';
$string['user:editprofile'] = 'Хэрэглэгчийн профайлыг засах';
$string['user:ignoreuserquota'] = 'Хэрэглэгчийн квотын хязгаарыг алгасах';
$string['user:loginas'] = 'Бусад хэрэглэгч байдлаар нэвтрэх';
$string['user:manageblocks'] = 'Бусад хэрэглэгчийн хэрэглэгчийн профайл дээрх блокийг удирдах';
$string['user:manageownblocks'] = 'Өөрийн нээлттэй хэрэглэгчийн профайл дээрх блокийг удирдах';
$string['user:manageownfiles'] = 'Өөрийн хувийн файлын талбар дээрх файлыг удирдах';
$string['user:managesyspages'] = 'Нээлттэй хэрэглэгчийн профайлын өгөгдмөл хуудасны загварыг тохируулах';
$string['user:readuserblogs'] = 'Бүх хэрэглэгчийн блогийг үзэх';
$string['user:readuserposts'] = 'Хэрэглэгчийн форумын бүх нийтлэлийг үзэх';
$string['user:update'] = 'Хэрэглэгчийн профайлыг шинэчлэх';
$string['user:viewalldetails'] = 'Хэрэглэгчийн бүрэн мэдээллийг харах';
$string['user:viewdetails'] = 'Хэрэглэгчийн профайлыг харах';
$string['user:viewhiddendetails'] = 'Хэрэглэгчийн далд мэдээллийг харах';
$string['user:viewlastip'] = 'Хэрэглэгчийн сүүлийн IP хаягийг харах';
$string['user:viewuseractivitiesreport'] = 'Хэрэглэгчийн үйл ажиллагааны тайланг харах';
$string['user:viewusergrades'] = 'Хэрэглэгчийн үнэлгээг харах';
$string['usersfrom'] = '{$a}-н хэрэглэгчид';
$string['usersfrommatching'] = '\'{$a->search}\' хайлтад тохирох {$a->contextname}-н хэрэглэгчид';
$string['usersinthisx'] = 'Энэ {$a} дахь хэрэглэгчид';
$string['usersinthisxmatching'] = '\'{$a->search}\' хайлтад тохирох энэ {$a->contextname} дахь хэрэглэгчид';
$string['userswithrole'] = 'Үүрэг бүхий бүх хэрэглэгч';
$string['userswiththisrole'] = 'Үүрэг бүхий хэрэглэгчид';
$string['useshowadvancedtochange'] = 'Өөрчлөхийн тулд \'Нарийвчлан харуулах\' сонголтыг ашиглах';
$string['viewingdefinitionofrolex'] = '\'{$a}\' үүргийн тодорхойлолтыг харж байна';
$string['viewrole'] = 'Үүргийн дэлгэрэнгүйг харах';
$string['webservice:createmobiletoken'] = 'Гар утасны хандалтад зориулсан веб сервисийн токенг үүсгэх';
$string['webservice:createtoken'] = 'Веб сервисийн токенг үүсгэх';
$string['webservice:managealltokens'] = 'Бүх хэрэглэгчийн веб сервисийн токенг удирдах';
$string['whydoesuserhavecap'] = 'Яагаад {$a->fullname} нь {$a->context} хүрээний {$a->capability} чадвартай байна вэ?';
$string['whydoesusernothavecap'] = 'Яагаад {$a->fullname} нь {$a->context} хүрээний {$a->capability} чадваргүй байна вэ?';
$string['xroleassignments'] = '{$a}-н үүргийн хуваарилалт';
$string['xuserswiththerole'] = '"{$a->role}" үүрэг бүхий хэрэглэгчид';
