<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'jitsi', language 'sr_cr', version '5.0'.
 *
 * @package     jitsi
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access'] = 'Приступите';
$string['accessto'] = 'Приступите {$a}. Унесите назив које ће бити приказан.';
$string['accesstotitle'] = 'Приступите {$a}.';
$string['accesstowithlogin'] = 'Приступите {$a}.';
$string['account'] = 'Налог';
$string['accountconnected'] = 'Налог је успешно повезан и стављен <b>у употребу</b>.';
$string['accountinsufficientprivileges'] = 'Подешени налог за стриминг нема довољне привилегије. Молимо обратите се свом администратору.';
$string['accounts'] = 'Налози за стримовање/снимање';
$string['action'] = 'Акција';
$string['activatetooltip'] = 'Кликните како бисте ставили у употребу';
$string['addaccount'] = 'Додај налог';
$string['addedtoqueue'] = 'Додато на листу чекања';
$string['addtoqueue'] = 'Додај на листу чекања';
$string['adminaccountex'] = 'Потребан је најмање један налог како бисте стримовали/снимали сесије помоћу метода за стримовање "Jitsi интегрисан са Moodleom".
</br>Само један налог може бити "<b>у употреби</b>" и користиће се за стримовање/снимање следећег снимка који захтева један предавач.
 </br>Приликом додавања нових налога препоручује се <b>да их назовемо правим именима налога</b> зато што би у будућности од вас могло бити затражено да се поново пријавите како би се поново проверио идентитет налога.
 </br>Овде се могу уклонити само налози без снимака који се односе на Jitsi активности предавача, као и налози без снимака који чекају да буду обрисани са сервера за стримовање помоћу иконице за отпатке.
 </br>Овде би се могли појавити нови налози без овлашћења када се резервне копије Jitsi активности са другог сервера рестаурирају на овом серверу са налозима који овде нису били присутни.
</br></br>НОВО од верзије 3.3.3: нова колона под називом "У реду за чекање" омогућава коришћење свих ваших рикордера. Можете додати рикордере у ред за чекања кликом на "<b>+</b>", односно уклонити их из реда кликом на "<b>-</b>". Када је рикордер коришћен зато што је био "<b>у употреби</b>" (или следећи који ће се користити), индикатор (заставица) "у употреби" биће постављена на следећи рикордер у реду за чекања. Ова функција вам омогућава да користите много рикордера како бисте избегли ограничења YouTube квоте као што је број стримова уживо дозвољених по дану.';
$string['alertacceswithlogin'] = 'Приступате преко екстерног линка и пријављени сте. Молимо вас да  приступите са курса.';
$string['alias'] = 'Алијас';
$string['allow'] = 'Почетак видео конференције';
$string['allowbreakoutrooms'] = 'Дозволи одвојене собе';
$string['allowbreakoutroomsex'] = 'Дозволите креирање одвојених соба. Сервер треба да буде конфигурисан тако да дозвољава одвојене собе.';
$string['apikeyid8x8'] = 'Api Key ID ознака';
$string['apikeyid8x8ex'] = 'ID ознака Api Кључа који се користи са 8x8 сервером. Можете га добити од администрације 8x8 сервера. (https://www.8x8.com/)';
$string['appaccessinfo'] = 'Ако желите да се придружите састанку помоћу мобилног уређаја, биће вам потребна мобилна апликација Jitsi Meet.';
$string['appid'] = 'App_ID';
$string['appidex'] = 'ID ознака апликације за конфигурацију токена';
$string['appinstalledtext'] = 'Ако већ имате апликацију:';
$string['appnotinstalledtext'] = 'Ако још немате апликацију:';
$string['attendeesreport'] = 'Извештај о присутнима на сесији';
$string['authq'] = 'Пријавите се са овим налогом како бисте добили овлашћење и ставили "у употребу"?';
$string['avg_recordings_per_day'] = 'Просечан број снимака по дану';
$string['avg_recordings_per_week'] = 'Просечан број снимака недељно';
$string['blurbutton'] = 'Прикажи опције за позадину';
$string['blurbuttonex'] = 'Прикажите опцију "Изабери позадину" свим корисницима. Ова функција је одлична, али захтева моћне рачунаре. Можда би требало да је онемогућите.';
$string['buttondownloadapp'] = 'Преузмите апликацију';
$string['buttonopeninbrowser'] = 'Отвори у веб читачу';
$string['buttonopenwithapp'] = 'Придружите се овом састанку помоћу апликације';
$string['calendarstart'] = 'Почиње видео конференција \'{$a}\'';
$string['click'] = 'Клик';
$string['close'] = 'Завршетак видео конференције';
$string['closebeforeopen'] = 'Није могуће ажурирати сесију. Навели сте датум затварања пре датума отварања.';
$string['completiondetail:minutes'] = 'Провести на сесији {$a} минут/а';
$string['completionminutes'] = 'Полазник мора присуствовати';
$string['completionminutes_help'] = 'Број минута, колико полазник мора да присуствује сесији како би се ова активност сматрала завршеном';
$string['completionminutesex'] = 'Минута присуства сесији';
$string['config'] = 'Конфигурација';
$string['confignewexpirationtime'] = 'Конфигуришите ново време истека у подешавањима';
$string['confirmdeleterecordinactivity'] = 'Потврдите да желите да обришете овај снимак. Ова операција се не може опозвати.';
$string['connectedattendeesnow'] = 'Тренутно конектовани учесници';
$string['copied'] = 'Копирано у клипборд';
$string['crontaskdelete'] = 'Обришите снимке';
$string['deeplink'] = 'Линк ка Jitsi апликацији';
$string['deeplinkex'] = 'Када је укључена Moodle апликација дозвољава се пренос Jitsi сесија у Jitsi апликацију.';
$string['deleteq'] = 'Да ли желите да обришете и прекинете везу са овим налогом?';
$string['deleterecord'] = 'Обришите снимак';
$string['deletesourceq'] = 'Да ли сте сигурни? Снимак ће бити трајно обрисан са видео сервера и неће моћи да се поврати';
$string['deletesources'] = 'Снимци доступни за брисање';
$string['deletetooltip'] = 'Обриши';
$string['deprecated'] = 'Застарело';
$string['deprecatedex'] = 'Застарели параметри који вероватно неће радити јер је Jitsi Meet променио своју имплементацију';
$string['desktopaccessinfo'] = 'Ако желите да се придружите састанку, кликните на дугме испод како бисте отворили Jitsi у свом веб читачу.';
$string['domain'] = 'Домен';
$string['domainex'] = 'Домен Jitsi сервера који се користи. Подразумевани сервер (<b>meet.jit.si</b>) има временско ограничење од 5 минута по конференцији.
На Googleu можете потражити алтернативне јавне Jitsi сервере који би могли да буду најближи вашим корисницима и са мањим кашњењем.
Ако имате свој приватни Jitsi сервер, унесите овде његову адресу без префикса "https://".
8x8 професионални сервер на адреси (<b>8x8.vc</b>) захтева да конфигуришете своја овлашћења у оквиру секције ”Конфигурација токена” у наставку.';
$string['editrecordname'] = 'Уреди назив снимка';
$string['entersession'] = 'Уђите на сесију';
$string['error'] = 'Грешка';
$string['errordeleting'] = 'Грешка приликом брисања';
$string['experimental'] = 'Експериментално';
$string['experimentalex'] = 'Ово су опције са којима експериментишемо и које могу нестати у будућим верзијама.';
$string['externalinvitations'] = 'Екстерне позивнице';
$string['externaltoken'] = 'Екстерни токени';
$string['externaltoken_help'] = 'Користите овај линк за госте који немају Moodle кориснички налог за приступ.';
$string['finish'] = 'Сесија је завршена.';
$string['finishandreturn'] = 'Заврши и врати се';
$string['finishandreturnex'] = 'Вратите се на курс када завршите сесију. Користећи јавни Jitsi корисници се враћају на курс када затворе оглас.';
$string['finishinvitation'] = 'Линк позовнице ће истећи';
$string['forkids'] = 'За децу';
$string['forkidsex'] = 'Сматраће се да су снимци направљени за децу.';
$string['from'] = 'Од';
$string['guestform'] = 'Уђите на образац за госте';
$string['hasentered'] = 'је ушао/ла на вашу приватну Jitsi сесију';
$string['help'] = 'Помоћ';
$string['helpex'] = 'Овај текст помоћи прилагођава садржај картице помоћи у Jitsi активностима. То је добро место за правила интернет бонтона или упутства за помоћ корисницима.';
$string['here'] = 'овде';
$string['identification'] = 'ID ознака корисника';
$string['identificationex'] = 'ID ознака која се приказује на сесији';
$string['inqueue'] = 'У реду за чекање';
$string['instruction'] = 'Кликните на дугме за приступ';
$string['integrated'] = 'Интегрисанo са Moodleom';
$string['internalerror'] = 'Унутрашња грешка. Контактирајте администратора.';
$string['inuse'] = '<b>(у употреби)</b>';
$string['invitations'] = 'Позивнице';
$string['invitationsnotactivated'] = 'Позивнице нису активиране';
$string['invitebutton'] = 'Опције позива';
$string['invitebuttonex'] = 'Дозволите корисницима са могућношћу mod/jitsi:createlink (предавачим) да креирају позивне линкове за кориснике који нису уписани на курс.';
$string['iscalling'] = 'те зове да уђеш на његов приватни Jitsi';
$string['jitsi'] = 'Jitsi';
$string['jitsi:addinstance'] = 'Додавање нове Jitsi инстанце';
$string['jitsi:createlink'] = 'Приказ и копирање линкова за позивнице за гостујуће кориснике';
$string['jitsi:deleterecord'] = 'Брисање снимка';
$string['jitsi:editrecordname'] = 'Уређивање назива снимка';
$string['jitsi:hide'] = 'Сакривање снимака';
$string['jitsi:moderation'] = 'Модерисање Jitsi сесије';
$string['jitsi:record'] = 'Снимање сесије';
$string['jitsi:sharedesktop'] = 'Дељење радне површине';
$string['jitsi:view'] = 'Приказ Jitsija';
$string['jitsi:viewexternallink'] = 'Приказ екстерног линка';
$string['jitsi:viewrecords'] = 'Приказ снимака';
$string['jitsi:viewusersonsession'] = 'Приступ извештајима о присуству учесника';
$string['jitsi_recording_statistics'] = 'Статистика Jitsi снимака';
$string['jitsiinterface'] = 'Jitsi интерфејс';
$string['jitsiname'] = 'Назив сесије';
$string['joinmeeting'] = 'Придружите се састанку';
$string['latency'] = 'Кашњење';
$string['latencyex'] = 'Изаберите ниво кашњења за стримовање.';
$string['link'] = 'линк';
$string['linkexpiredon'] = 'Овај линк је истекао {$a}';
$string['livesessionsnow'] = 'Снимање у току';
$string['loadattendees'] = 'Учитајте учеснике';
$string['loadingvideo'] = 'Учитава се видео... Молимо сачекајте';
$string['loginq'] = 'Да ли желите да користите овај налог?';
$string['logintooltip'] = 'Корисничко име и лозинка су потребни за овај налог';
$string['messageprovider:callprivatesession'] = 'Позови на Jitsi приватну сесију';
$string['messageprovider:onprivatesession'] = 'Корисник на приватној сесији';
$string['minpretime'] = 'Минути за приступ пре почетка сесије';
$string['minpretime_help'] = 'Корисници са овлашћењем за модерисање моћи да приступе оволико минута раније, пре почетка сесије';
$string['minutesconnected'] = 'Повезани сте {$a} минут/а';
$string['minutestoday'] = 'Минута данас';
$string['modulename'] = 'Jitsi';
$string['modulename_help'] = 'Користите Jitsi модул за видео конференцију. Ове видео конференције користиће ваше Moodle корисничко име тако што ће на видео конференцијама приказати ваше корисничко име и аватар.

Jitsi-meet је решење за видео конференције отвореног кода које вам омогућава да лако изградите и примените безбедна решења за видео конференције.';
$string['modulenameplural'] = 'Jitsi модули';
$string['myprivatesession'] = 'Моја приватна сесија';
$string['nameandsurname'] = 'Име + Презиме';
$string['news'] = 'Вести';
$string['news1'] = 'Ако сте недавно надоградили, препоручује се да проверите <a href="../mod/jitsi/CHANGES.md">CHANGES.md</a> за ажурирања и подесите свој језик на енглески како бисте били сигурни да су упутства које тренутно читате на овој страници за конфигутацију ажурирана.
 </br></br><b>ВАЖНО ОБАВЕШТЕЊЕ</b>
 </br>Недавно су јавни сервери meet.jit.si увели рестрикције за ”режим уграђивања” који трајање сесије ограничава на 5 минута
 (<a href="https://github.com/udima-university/moodle-mod_jitsi#important-announcement-from-meetjitsi-team">прочитајте више овде</a>).
 </br>Ако желите да ангажујете професионалне хостинг услуге за  Jitsi, препоручујемо <a href="https://jaas.8x8.vc/">https://jaas.8x8.vc/</a>.
 Воде га Jitsi програмери, који имају <b>веома конкурентне цене</b>. На овај начин помажете да Jitsi пројекат отвореног кôда буде одржив.
 </br></br><b>ОДРИЦАЊЕ ОД ОДГОВОРНОСТИ</b></br>Овај додатак одржава UDIMA University (<a href="https://www.udima.es">www.udima.es</a>) који није у било каквом партнерском односу са 8x8 Inc нити са "Jitsi as a Service" (jaas).';
$string['newvaluefor'] = 'Нова вредност за';
$string['noinviteaccess'] = 'Приступ гостима тренутно није дозвољен.';
$string['nojitsis'] = 'Нису пронађене Jitsi активности';
$string['norecording'] = 'Нема снимака. Видео ће се појавити аутоматски';
$string['norecords'] = 'Нема доступних снимака';
$string['nostart'] = 'Сесија није почела. Можете приступити {$a}';
$string['notloggedin'] = 'Потребна су овлашћења за налог';
$string['noviewpermission'] = 'Немате овлашћења за гледање ове Jitsi сесије';
$string['number_of_recordings'] = 'Број снимака';
$string['numbervideosdeleted'] = 'Број видео снимака за брисање';
$string['numbervideosdeletedex'] = 'Број видео снимака за брисање приликом сваког извршавања крон задатка';
$string['oauthid'] = 'OAuth2 ID ознака';
$string['oauthidex'] = 'OAuth2 ID ознака Google налога са омогућеним YouTube Data API v3 и овом овлашћеном URL адресом за редирекцију <b>\'{$a}\'</b> на Google API конзоли.';
$string['oauthsecret'] = 'OAuth2 тајни кључ';
$string['oauthsecretex'] = 'OAuth2 тајни кључ за Google налог';
$string['participantspane'] = 'Панел учесника';
$string['participantspaneex'] = 'Прикажите панел са учесницима свим корисницима. Када ова опција није изабрана само корисници који имају способност за модерисање Jitsi сесија (mod/jitsi:moderation), обично предавачи, могу да виде панел са учесницима.';
$string['participatingsession'] = 'Учествовање у сесији';
$string['password'] = 'Лозинка';
$string['passwordex'] = 'Лозинка за заштиту ваших сесија. Препоручује се ако користите јавни сервер';
$string['pluginadministration'] = 'Jitsi администрација';
$string['pluginname'] = 'Jitsi';
$string['preparing'] = 'Припрема. Молимо, сачекајте...';
$string['presscambutton'] = 'Притисните дугме за камеру';
$string['pressdesktopbutton'] = 'Притисните дугме за радну површину';
$string['pressendbutton'] = 'Притисните дугме за крај';
$string['pressmicrophonebutton'] = 'Притисните дугме за микрофон';
$string['pressrecordbutton'] = 'Притисните дугме за снимање';
$string['privacy:metadata:jitsi'] = 'Како би се интегрисали са Jitsi сесијом, кориснички подаци морају бити размењени са тим сервисом.';
$string['privacy:metadata:jitsi:avatar'] = 'Moodle је послао аватар како би га видели остали учесници Jitsi сесије';
$string['privacy:metadata:jitsi:username'] = 'Moodle је послао корисничко име како би га видели остали учесници Jitsi сесије';
$string['privatekey'] = 'Приватни кључ';
$string['privatekeyex'] = 'Приватни кључ за коришћење токена на 8x8 серверу. Можете га добити од администрације 8x8 сервера. (https://www.8x8.com/).
Преузмите датотеку приватног кључа и копирајте садржај овде.
</br><b>ВАЖНО</b>: немојте заборавите да ажурирате подешавање "Домен" и унесете URL адресу, нешто попут<b>8x8.vc</b>';
$string['privatesession'] = '{$a} приватна сесија';
$string['privatesessiondisabled'] = 'Приватне сесије су онемогућене';
$string['privatesessions'] = 'Приватне сесије';
$string['privatesessionsex'] = 'Dodajte privatne sesije u korisničke profile';
$string['raisehand'] = 'Дугме за подизање руке';
$string['raisehandex'] = 'Прикажи дугме за подизање руке свим корисницима. Када корисници подигну руке, могу приступити панелу учесника. Ако сакријете панеле учесника, можда би требало да сакријете ово дугме.';
$string['reactions'] = 'Реакције';
$string['reactionsex'] = 'Приказује звучне емотиконе за аплауз, изненађење, итд... Неопходно је да "Дугме за подизање руке" буде омогућено';
$string['record'] = 'Сними';
$string['recorders'] = 'Рикордери';
$string['recordex'] = 'Омогућите изворну Jitsi опцију снимања (заправо dropbox) корисницима са укљученом способношћу mod/jitsi:record (предавачи). Уколико опцију ”Конфигурација стримовања” подесите на метод "Интегрисано са Moodleom" вероватно ћете желети да ово искључите.';
$string['recordingbloquedby'] = 'Снимање је блокирао/ла';
$string['recordingwasbloquedby'] = 'Корисник који је започео снимање више не учествује у сесији. Да ли желите да зауставите ово снимање? Снимање је започео/ла';
$string['records'] = 'Снимци';
$string['recordsonair'] = 'Постојећи снимци';
$string['recordtitle'] = 'Снимање';
$string['removedfromqueue'] = 'Уклоњено из реда за чекање';
$string['removefromqueue'] = 'Уклоните из реда за чекање';
$string['search'] = 'Претражи';
$string['searchrecords'] = 'Претражите снимке';
$string['secret'] = 'Тајни кључ';
$string['secretex'] = 'Тајни кључ за конфигурацију токена';
$string['securitybutton'] = 'Сигурносно дугме';
$string['securitybuttonex'] = 'Омогућава изворне Jitsi "Безбедносне опције" и "Лоби режим". Вероватно би требало да онемогућите ову опцију ако сте претходно подесили лозинку, јер ће она бити приказана корисницима. Са конфигурацијом токена можете експериментисати са овом опцијом';
$string['selectdate'] = 'Изаберите датум';
$string['separator'] = 'Знак за раздвајање';
$string['separatorex'] = 'Дефинишите знак за раздвајање поља за назив сесије';
$string['sessiondeleted'] = 'Дељена сесија је обрисана';
$string['sessionisbeingrecorded'] = 'Сесија се снима';
$string['sessionisbeingrecordingby'] = 'Сесију снима {$a}';
$string['sessionnamefields'] = 'Поља за назив сесије';
$string['sessionnamefieldsex'] = 'Поља која дефинишу назив сесије';
$string['sessionshared'] = 'Сесија се дели са курсом \'{$a}\'';
$string['sharedsessionwithtoken'] = 'Сесија подељена уз помоћ токена. Изаберите ово како бисте унели токен другог курса';
$string['sharestream'] = 'Делите стрим са корисницима ван Moodlea (експериментална функција)';
$string['sharestreamex'] = 'Омогућите ово подешавање како бисте понудили могућност дељења преноса сесије уживо са корисницима изван Moodlea.';
$string['sharetoinvite'] = 'Поделите овај линк како бисте упутили позив за сесију';
$string['showavatars'] = 'Прикажи аватаре у Jitsiju';
$string['showavatarsex'] = 'Прикажите аватаре корисника у Jitsiju. Ако корисник нема слику профила, ово ће учитати подразумевану слику профила са Moodlea уместо иницијала које Jitsi приказује када није постављена слика.';
$string['simultaneouscameras'] = 'Симултане камере';
$string['simultaneouscamerasex'] = 'Максималан број симултано укључених камера које корисници могу да виде. Ваш Jitsi сервер би то могао да заобиђе са нижом вредношћу. Превише дозвољених камера може преоптеретити веб читаче ваших клијената.';
$string['startwithaudiomuted'] = 'Започните са искљученим звуком';
$string['startwithaudiomutedex'] = 'Када се корисник повеже на сесију, звук ће бити искључен';
$string['startwithvideomuted'] = 'Започните са искљученим видеом';
$string['startwithvideomutedex'] = 'Када се корисник повеже на сесију, видео ће бити искључен';
$string['staticinvitationlink'] = 'Опција за позивнице';
$string['staticinvitationlinkcapabilityex'] = 'Користите ову опцију за госте који немају Moodle кориснички налог за приступ сесији. Само ако имате способноост mod/jitsi:createlin можете да креирате или мењате позивни линк.';
$string['staticinvitationlinkex'] = 'Користите ову опцију за госте који немају Moodle кориснички налог за приступ сесији. Можете видети и копирати линк унутар картице са позивницама.';
$string['staticinvitationlinkexview'] = 'Поделите овај линк за госте који немају Moodle кориснички налог за приступ сесији.';
$string['streamingandrecording'] = 'Стримуј & Снимај';
$string['streamingbutton'] = 'Пренос уживо';
$string['streamingbuttonex'] = 'Омогућите функције стриминга уживо корисницима са укљученом способношћу mod/jitsi:record (предавачи). Ако је ово омогућено вероватно ћете пожелети да горњу опцију за снимање онемогућите.';
$string['streamingconfig'] = 'Конфигурација стримовања';
$string['streamingconfigex'] = 'Подразумевана конфигурација стримoвања функционише „неконвенционално“ и корисници могу да стримују/снимају своје сесије са сопственим налозима на сервисима за стриминг (Youtube, Peertube...) али предавач је одговоран да објави своје линкове за гледање полазницима на курсу. </br></br>За боље искуство можете омогућити метод "Интегрисано са Moodleom" како бисте снимали са корпоративним налогом за стримовање (тренутно је доступан само YouTube) а снимци ће аутоматски бити доступни полазницима.';
$string['streamingisstarting'] = 'Стримовање почиње. Молимо, сачекајте...';
$string['streamingoption'] = 'Метод \'Пренос уживо\'';
$string['streamingoptionex'] = '<b>Jitsi интерфејс</b> омогућите "Започни стриминг уживо" у Jitsi интерфејсу и корисници могу да користе сопствене налоге за стриминг. </br><b>Интегрисано са Moodleom</b> је најлакша опција за кориснике. Предавачи могу одмах да покрену "Сними & Стримуј" и неће им бити потребан никакав налог са акредитивима. Стримови/Снимци се чувају на корпоративном налогу и биће одмах доступни полазницима. Морате подесити OAuth2 овлашћења као и налог за стримовање у наставку.';
$string['tablelistjitsis'] = 'Наведите све видео снимке на вашим налозима за стримовање/снимање који су доступни за брисање, јер више нису повезани са Jitsi активностима у овој инстанци Moodlea. Можете их безбедно oбрисати како бисте ослободили простор на серверу за стриминг. Списак би могао да садржи видео записе који се тренутно налазе у \'Корпи за отпатке\' на неком од курсева. Препоручује се да обришете само старе снимке за које знате да вам неће бити потребни. </br></br> <b>¡¡¡ УПОЗОРЕЊЕ!!! </b> Ако имате инстанце резервних копија Moodle курсева НЕ би требало да уклањате ове видео снимке уколико су линковани у другим инстанцама.';
$string['timeopen'] = 'Време сесије се отвара';
$string['to'] = 'До';
$string['token'] = 'Поделите овај токен на другом курсу';
$string['tokenconfiguration8x8ex'] = 'Уколико користите 8x8 сервере, потребно је да конфигуришете следеће параметре.';
$string['tokenconfigurationex'] = 'Ако користите Jitsi сервер конфигурисан у "токен режиму", на пример ваш сопствени сервер или 8x8 сервер, попуните следеће параметре у зависности од типа сервера који користите. Неопходно за промовисање ваших корисника, који имају укључену могућност (mod/jitsi:moderation), у изворне Jitsi модераторе.';
$string['tokeninterno'] = 'Токен главне сесије';
$string['tokeninternocompartir'] = 'Токен за дељење';
$string['tokeninternocompartir_help'] = 'Користите овај токен како бисте поделили сесију са другим курсевима. Унесите овај токен у ову секцију другог курса.';
$string['tokeninvitacion'] = 'Овде унесите токен сесије којој желите да се прикључите';
$string['tokeninvitacion_help'] = 'Овде унесите токен сесије којој желите да се прикључите. Узми овај токен на другом курсу.';
$string['tokeninvitadovalidation'] = 'Токен није исправан';
$string['tokeninvitationnotvalid'] = 'Позивница не може да истекне пре садашњег тренутка';
$string['tokeninvitationvalidation'] = 'Токен није исправан. Не постоји сесија са овим токеном';
$string['tokennconfig'] = 'Конфигурација токена';
$string['tokennconfig8x8'] = 'Конфигурација 8x8 сервера';
$string['top_10_teachers'] = 'Топ 10 предавача';
$string['toplimit'] = 'Горња граница';
$string['total_participants'] = 'Укупно учесника';
$string['total_recordings'] = 'Укупно снимака';
$string['totalminutes'] = 'Укупно минута';
$string['updated'] = 'Ажурирано';
$string['urlerror'] = 'URL адреса није исправна';
$string['urlinvitacion'] = 'URL адреса позива';
$string['urlinvitacionrecord'] = 'Позини линк - URL адреса стрима';
$string['usercall'] = '{$a} те позива на приватну Jitsi сесију';
$string['userenter'] = '{$a} је у вашој приватној Jitsi соби';
$string['username'] = 'Корисничко име';
$string['validitytimevalidation'] = 'Позив не може да истекне пре датума почетка сесије или после датума завршетка сесије.';
$string['videoexpiry'] = 'Период задржавања';
$string['videoexpiryex'] = 'Временски период у ком ће обрисани видео снимци бити доступни на серверу за стримовање. Након овог времена видео снимци ће бити обрисани са сервера за стримовање.';
$string['warningprivate'] = 'Ако приступите сесији, {$a} ће добити обавештење';
$string['watermarklink'] = 'Линк воденог жига';
$string['watermarklinkex'] = 'Линк воденог жига';
$string['whiteboard'] = 'Вишекорисничка табла';
$string['whiteboardex'] = 'Прикажите дугме за вишекорисничку таблу свим корисницима. У ствари, ова табла није доступан на Jaas серверима.';
$string['youtubebutton'] = 'Youtube опција за дељење';
$string['youtubebuttonex'] = 'Прикажите Youtube опцију за дељење видео снимака';
