<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'es_mx', version '5.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Acerca de mi';
$string['actingasrole'] = 'Actualmente Usted está actuando como un rol diferente';
$string['activatetemplateoverride'] = 'Activar anulación de plantilla para \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Cuando se active, entonces el valor en la configuración de\'{$a->setting}\' será usado como la plantilla \'{$a->template}\' si contuviera texto.';
$string['activebreadcrumb'] = 'Color de fondo de la ruta de navegación activa';
$string['activebreadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación activa, y recordatorio de la barra de la ruta de navegación';
$string['activitiesheading'] = 'Actividades';
$string['alertaccess'] = 'Visibilidad de la Alerta';
$string['alertaccessadmins'] = 'Visible para administradores';
$string['alertaccessdesc'] = 'Configurar tipo de restricción para visibilidad de la Alerta. Nota: Si se usa "Añadir restricción por campo personalizado" necesitará añadir valores para campos de perfil debajo.';
$string['alertaccessglobal'] = 'Visible para todos';
$string['alertaccessprofile'] = 'Añadir restricción por campo personalizado del perfil';
$string['alertaccessusers'] = 'Visible para usuarios ingresados';
$string['alertannounce'] = 'Anuncio';
$string['alertannouncedesc'] = 'Mostrar un Anuncio en la Alerta.';
$string['alertbackgroundcolorinfo'] = 'Color del Fondo de Información';
$string['alertbackgroundcolorinfodesc'] = 'Color del Fondo de las alertas de tipo de Información.';
$string['alertbackgroundcolorsuccess'] = 'Color del Fondo de Anuncio';
$string['alertbackgroundcolorsuccessdesc'] = 'Color del Fondo de las alertas de tipo de Anuncio.';
$string['alertbackgroundcolorwarning'] = 'Color del Fondo de Advertencia';
$string['alertbackgroundcolorwarningdesc'] = 'Color del Fondo de las alertas de tipo de Advertencia.';
$string['alertbordercolorinfo'] = 'Color del Borde de Información';
$string['alertbordercolorinfodesc'] = 'Color del Borde de las alertas de tipo Información.';
$string['alertbordercolorsuccess'] = 'Color del Borde de Anuncio';
$string['alertbordercolorsuccessdesc'] = 'Color del Borde de las alertas de tipo Anuncio.';
$string['alertbordercolorwarning'] = 'Color del Borde de Advertencia';
$string['alertbordercolorwarningdesc'] = 'Color del Borde de las alertas de tipo Advertencia.';
$string['alertcolorinfo'] = 'Color de Información';
$string['alertcolorinfodesc'] = 'Color del Ícono de las alertas de tipo Información.';
$string['alertcolorsheading'] = 'Íconos y colores de alertas';
$string['alertcolorsuccess'] = 'Color de Anuncio';
$string['alertcolorsuccessdesc'] = 'Color del ícono de las alertas de tipo Anuncio.';
$string['alertcolorwarning'] = 'Color de Advertencia';
$string['alertcolorwarningdesc'] = 'Color del ícono de las alertas de tipo Advertencia.';
$string['alertcount'] = 'Número de Alertas';
$string['alertcountdesc'] = 'Número de alertas a crear a continuación.';
$string['alertdesc'] = 'Introduce y personaliza un texto para ser mostrado en la parte superior del sitio como alerta. Es posible crear más de una para mostrarse a diferentes tipos de usuarios.';
$string['alertdisabled'] = 'Deshabilitada';
$string['alertdisabledesc'] = 'Deshabilitar esta alerta.';
$string['alerthiddencourse'] = 'Alertas de curso oculto';
$string['alerthiddencoursedesc'] = 'Advertir a profesores que hay cursos ocultos.';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'hacer clic aquí para actualizar configuraciones';
$string['alerthiddencoursetext-start'] = 'Este curso está oculto y no puede ser accesado por estudiantes.';
$string['alerticoninfo'] = 'Ícono de Información';
$string['alerticoninfodesc'] = 'Configure los  \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\' a ser usados en las cajas de alerta de tipo Información. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alerticonsuccess'] = 'Ícono de Anuncio';
$string['alerticonsuccessdesc'] = 'Configure los  \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\'  a ser usados en las cajas de alerta de tipo Anuncio. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alerticonwarning'] = 'Ícono de Advertencia';
$string['alerticonwarningdesc'] = 'Configure los  \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\'  a ser usados en las alertas de tipo Advertencia. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alertinfo'] = 'Información';
$string['alertinfodesc'] = 'Mostrar información en la Alerta.';
$string['alertkeyvalue'] = 'Clave de Alerta';
$string['alertkeyvalue_details'] = 'La clave que identifica esta alerta. Usted solamente necesita cambiar esto si quiere usar nuevamente la misma alerta; por ejemplo si el contenido no h cambiado o ha sido usado antes. Nota: Los cambios de formateo no cuentan como un cambio del contenido.';
$string['alertprofilefield'] = 'Campo personalizado  del usuario Nombre=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Añade regla de acceso usando un campo personalizado del perfil. Ejemplo: "usertype=student".';
$string['alertsettings'] = 'Alerta {$a}';
$string['alertsettingscourse'] = 'Configuraciones de Alerta de Curso';
$string['alertsettingsgeneral'] = 'Configuración Alertas Generales';
$string['alertsettingsheading'] = 'Alertas';
$string['alerttext'] = 'Texto de la Alerta';
$string['alerttextdesc'] = 'Introducir el texto a mostrar en la alerta.';
$string['alerttype'] = 'Tipo Alerta';
$string['alerttypedesc'] = 'Selecciona el tipo de alerta: info (azul), advertencia (amarillo) o anuncio (verde).';
$string['alertwarning'] = 'Advertencia';
$string['alertwarningdesc'] = 'Mostrar una advertencia en la Alerta.';
$string['analyticscount'] = 'Conteo de análisis';
$string['analyticscountdesc'] = 'Número de campos personalizados a introducir en el área inferior.';
$string['analyticsprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['analyticsprofilefielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: usertype=student.';
$string['analyticssettings'] = 'Analítica Web';
$string['analyticssettingsdesc'] = 'Usted puede configurar múltiples códigos para Google Analytics y enlazarlos con diversos campos personalizados del perfil . O Usted puede usar Matomo, el analizador de código abierto.';
$string['analyticssettingsheading'] = 'Configurar Google Analytics (Análisis de Google), Matomo, o ambos';
$string['analyticstext'] = 'ID de Google Analytics';
$string['analyticstextdesc'] = 'Introducir ID de Google Analytics.';
$string['anonymizega'] = 'Anonimizar la IP del usuario';
$string['anonymizegadesc'] = 'Anonimizar la IP del usuario enviada a a Google Analytics.';
$string['bcustyle'] = 'Estilo BCU';
$string['blockbackgroundcolor'] = 'Color de fondo de los bloques';
$string['blockbackgroundcolordesc'] = 'Establece el color de fondo de los bloques.';
$string['blockbordercolor'] = 'Color del borde de los bloques';
$string['blockbordercolordesc'] = 'Establece el color del borde de los bloques.';
$string['blockheaderbackgroundcolor'] = 'Color del texto de los encabezados de los bloques';
$string['blockheaderbackgroundcolordesc'] = 'Establece el color del texto de los encabezados de los bloques.';
$string['blockheaderborderbottom'] = 'Grueso del borde inferior de los bloques';
$string['blockheaderborderbottomdesc'] = 'Establece el grosor del borde inferior de los encabezados de bloques.';
$string['blockheaderborderleft'] = 'Grueso del borde izquierdo de los bloques';
$string['blockheaderborderleftdesc'] = 'Establece el grosor del borde izquierdo de los encabezados de bloques.';
$string['blockheaderborderright'] = 'Grueso del borde derecho de los bloques';
$string['blockheaderborderrightdesc'] = 'Establece el grosor del borde derecho de los encabezados de bloques.';
$string['blockheaderbordertop'] = 'Grueso del borde superior de los bloques';
$string['blockheaderbordertopdesc'] = 'Establece el grosor del borde superior de los encabezados de bloques.';
$string['blockheaderbordertopstyle'] = 'Estilo del borde de los bloques';
$string['blockheaderbordertopstyledesc'] = 'Establece el estilo del borde de los encabezados de bloques laterales.';
$string['blockheaderbottomradius'] = 'Radio de las esquinas inferiores de los bloques laterales';
$string['blockheaderbottomradiusdesc'] = 'Establecer el Radio de los bloques de encabezados para lograr un efecto redondeado / curvado.';
$string['blockheadercolor'] = 'Color de fondo de la cabecera de los bloques';
$string['blockheadercolordesc'] = 'Establece el color de fondo de la cabecera de los bloques.';
$string['blockheadertopradius'] = 'Radio de las esquinas superiores de los bloques laterales';
$string['blockheadertopradiusdesc'] = 'Configurar el radio del bloque superior del encabezado para lograr un efecto de curvo /redondeado.';
$string['blockicons'] = 'Iconos en los bloques';
$string['blockiconsdesc'] = 'Mostrar / Ocultar un icono relacionado con el tipo de bloque al lado del encabezamiento.';
$string['blockiconsheadersize'] = 'Tamaño del ícono del encabezado de bloques';
$string['blockiconsheadersizedesc'] = 'Configurar el tamaño del ícono del font usado en el encabezado de los bloques de Moodle. Seleccionar un valor de la lista.';
$string['blocklayoutbuilder'] = 'Regiones de Bloques de la Portada';
$string['blocklayoutbuilderdesc'] = 'A continuación, puede crear su propio diseño para las regiones de bloques en la página principal.<br/>Para agregar contenido a estas regiones, deberá <strong>activar la edición en la página principal de Moodle</strong>.<br/>¡Luego puede comenzar a arrastrar y soltar bloques en las regiones que cree!';
$string['blocklayoutlayoutcheck'] = 'Revise su diseño';
$string['blocklayoutlayoutcheckdesc'] = 'Use la herramienta inferior para revisar el númeo de bloques que Usted haya usado y ver una representación de su nuevo diseño.';
$string['blocklayoutlayoutcount1'] = 'Usted puede configurar un máximo de';
$string['blocklayoutlayoutcount2'] = 'Regiones de bloque. Actualmente Usted está usando:';
$string['blocklayoutlayoutrow'] = 'Hilera de Región de Bloque';
$string['blocklayoutlayoutrowdesc'] = 'Añadir/configurar diseño para hilera de región de bloque en la Portada.';
$string['blockmainborderbottom'] = 'Grueso del borde inferior del bloque central';
$string['blockmainborderbottomdesc'] = 'Configurar el grosor del borde inferior del área del bloque principal.';
$string['blockmainborderleft'] = 'Grueso del borde izquierdo del bloque central';
$string['blockmainborderleftdesc'] = 'Configurar el grosor del borde izquierdo del área del bloque principal.';
$string['blockmainborderright'] = 'Grueso del borde derecho del bloque central';
$string['blockmainborderrightdesc'] = 'Configurar el grosor del borde derecho del área del bloque principal.';
$string['blockmainbordertop'] = 'Grueso del borde superior del bloque central';
$string['blockmainbordertopdesc'] = 'Configurar el grosor del borde superior del área del bloque principal.';
$string['blockmainbordertopstyle'] = 'Estilo del borde del Bloque Principal';
$string['blockmainbordertopstyledesc'] = 'Configurar el estilo del borde del área de contenido de bloques';
$string['blockmainbottomradius'] = 'Radio de las esquinas inferiores de los bloques centrales';
$string['blockmainbottomradiusdesc'] = 'Configurar el radio inferior del área del bloque principal para lograr un efecto de curvado / redondeado.';
$string['blockmaintopradius'] = 'Radio de las esquinas superiores de los bloques centrales';
$string['blockmaintopradiusdesc'] = 'Configurar el radio superior del área del bloque principal para lograr un efecto de curvado / redondeado.';
$string['blockregionbackground'] = 'Color del Fondo de Región de Bloque';
$string['blockregionbackgrounddesc'] = 'Color del fondo del contenedor que tiene los diseños personalizados de bloque en la Portada.';
$string['blockregioneditingtitleshown'] = 'Mostrar título de región de bloque al editar';
$string['blockregioneditingtitleshowndesc'] = 'Usted puede mostrar / ocultar el título de región de bloque al editar.';
$string['blockshowhide'] = 'Mostrar / ocultar el bloque';
$string['blockside'] = 'Posición de los bloques';
$string['blocksidedesc'] = 'Controlar si los bloques aparecen a la izquierda la derecha de la página.';
$string['breadcrumb'] = 'Ruta de navegación';
$string['breadcrumbbackgroundcolor'] = 'Color del fondo de la ruta de navegación';
$string['breadcrumbbackgroundcolordesc'] = 'Configurar el color de la ruta de navegación';
$string['breadcrumbdisplay'] = 'Mostrar la ruta de navegación';
$string['breadcrumbdisplaydesc'] = 'Configurar la visualización de lo que debería ser el área de la ruta de navegación.';
$string['breadcrumbhome'] = 'Hogar de ruta de navegación';
$string['breadcrumbhomedesc'] = 'Mostrar hogar de ruta de navegación como un ícono o como un texto.';
$string['breadcrumbhomeicon'] = 'Ícono';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de ruta de navegación';
$string['breadcrumbseparatordesc'] = 'Configurar los < \'<a href="{$a}" target="_blank">Íconos de Font Awesome </a>\' para usarlos como separador de elementos en la ruta de navegación. Escriba el nombre del ícono sin el prefijo fa- .';
$string['breadcrumbtextcolor'] = 'Color del texto de la ruta de navegación';
$string['breadcrumbtextcolordesc'] = 'Establece el color del texto de la ruta de navegación.';
$string['breadcrumbtitle'] = 'Nombre del curso en la ruta de navegación';
$string['breadcrumbtitledesc'] = 'Establece el modo de visualización del título del curso en la ruta de navegación.';
$string['bs4all'] = 'Extra Pequeño - Extra Grande';
$string['bs4extralarge'] = 'Solamente Extra Grande';
$string['bs4large'] = 'Grande - Extra Grande';
$string['bs4medium'] = 'Mediano - Extra Grande';
$string['bs4none'] = 'Ninguno';
$string['bs4small'] = 'Pequeño - Extra Grande';
$string['buttoncolor'] = 'Colores de los botones';
$string['buttoncolorcancel'] = 'Color de Botón Cancelar';
$string['buttoncolordesc'] = 'El color de los botones principales.';
$string['buttoncolordesccancel'] = 'Color del fondo para botón cancelar.<br />Escriba transparent en la caja para Transparencia.';
$string['buttoncolordescscnd'] = 'El color de los botones secundarios usados en todo el sitio.';
$string['buttoncolorscnd'] = 'Color de Botón Secundario';
$string['buttondesc'] = 'Personaliza la forma y colores de los botones utilizados en la plantilla.';
$string['buttondropshadow'] = 'Decoración de Sombreado en el fondo del botón';
$string['buttondropshadowdesc'] = 'Mostrar una decoración de Sombreado en el fondo del botón.';
$string['buttonfocuscolour'] = 'Color del fondo del foco del botón';
$string['buttonfocuscolourdesc'] = 'El color que el botón usa cuando se enfoca el botón.';
$string['buttonhovercolor'] = 'Color del fondo del botón al pasarle el ratón encima';
$string['buttonhovercolorcancel'] = 'Color de Botón para Cancelar (al pasarle el ratón encima)';
$string['buttonhovercolordesc'] = 'El color al que cambia el fondo del botón al pasar el cursor por encima del botón.';
$string['buttonhovercolordesccancel'] = 'El color al cual cambia el botón para cancelar cuando le pasa el ratón encima.<br />Escriba transparent en la caja para Transparencia.';
$string['buttonhovercolordescscnd'] = 'El color al cual cambia el botón secundario cuando le pasa el ratón encima.';
$string['buttonhovercolorscnd'] = 'Color de Botón Secundario (al pasarle el ratón encima)';
$string['buttonlogincolor'] = 'Color del botón para Ingresar';
$string['buttonlogincolordesc'] = 'El color del botón para Ingresar';
$string['buttonloginheight'] = 'Configurar la Altura del botón para Ingresar';
$string['buttonloginheightdesc'] = 'Solamente efectivo si se utiliza el formato para ingresar en la cabecera superior.';
$string['buttonloginhovercolor'] = 'Color al pasarle el cursor encima al botón para Ingresar';
$string['buttonloginhovercolordesc'] = 'Color del botón para Ingresar al pasarle el cursor encima';
$string['buttonloginmargintop'] = 'Configurar el Margen superior del botón para ingresar';
$string['buttonloginmargintopdesc'] = 'Permite que sea alterado la posición / espaciado del botón para ingresar.';
$string['buttonloginpadding'] = 'Configurar el espaciado/separación del texto del botón para Ingresar';
$string['buttonloginpaddingdesc'] = 'Número más alto = Botón más grande.';
$string['buttonlogintextcolor'] = 'Color del texto del botón para Ingresar';
$string['buttonlogintextcolordesc'] = 'Color del texto del botón para Ingresar.';
$string['buttonradius'] = 'Configurar el Radio del botón';
$string['buttonradiusdesc'] = 'Radio mayor = botones redondeados, radio menor = botones cuadrados';
$string['buttonsettings'] = 'Botones';
$string['buttonsettingsheading'] = 'Personalizar los botones.';
$string['buttontextcolor'] = 'Color del texto de los botones';
$string['buttontextcolorcancel'] = 'Color del texto del Botón para Cancelar';
$string['buttontextcolordesc'] = 'El color del texto usado en botones.';
$string['buttontextcolordesccancel'] = 'El color del texto usado en los botones para cancelar.';
$string['buttontextcolordescscnd'] = 'El color del texto usado en botones secundarios.';
$string['buttontextcolorscnd'] = 'Color del texto del Botón Secundario';
$string['buttontextfocuscolour'] = 'Color del texto del foco del botón';
$string['buttontextfocuscolourdesc'] = 'El color del texto que el botón usa cuando se enfoca el botón.';
$string['buttontexthovercolor'] = 'Color del texto del botón al pasar el ratón encima';
$string['buttontexthovercolordesc'] = 'El color al cual cambia el texto del botón cuando el ratón pasa encima del botón.';
$string['cachedef_adaptablefontawesomeiconmapping'] = 'Cachear íconos de font Awesome';
$string['categoryhavecustomheader'] = 'Encabezado personalizado de categoría';
$string['categoryhavecustomheaderdesc'] = 'Seleccionar las categorías de nivel superior que tendrán un encabezado personalizado. Para seleccionar más de una o des-seleccionar una categoría, use la tecla \'Ctrl\'. Guarde y refresque la página para actualizarla. Nota: Sub-categorías de la seleccionada heredarán los valores configurados.';
$string['categoryheaderbgimage'] = 'Imagen del fondo de categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Configurar una imagen de fondo para categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' en el encabezado.  El tamaño mínimo es 1600x180px (1900x180px recomendado).  La imagen cubrirá  todo el encabezado.';
$string['categoryheaderbgimagedescchildren'] = 'Configurar una imagen de fondo para categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus hijos \'{$a->children}\' en el encabezado.  El tamaño mínimo es 1600x180px (1900x180px recomendado).  La imagen cubrirá  todo el encabezado.';
$string['categoryheaderbgimagetextcolour'] = 'Color del texto de la imagen del fondo de categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderbgimagetextcolourdesc'] = 'Configurar un color del texto de la imagen del fondo para la categoría de nivel superior  \'{$a->name}\' con id \'{$a->id}\' en el encabezado.';
$string['categoryheaderbgimagetextcolourdescchildren'] = 'Configurar un color del texto de la imagen del fondo para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus hijos \'{$a->children}\' en el encabezado.';
$string['categoryheadercustomcss'] = 'SCSS personalizado de categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Establezca un SCSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'. Esto generará un SCSS para el selector de temas con el prefijo \'.category-{$a->id}\'. Si no parece que se haya aplicado el SCSS, utilice las herramientas de desarrollo del navegador para investigar y verificar el archivo de registro de PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Establezca un SCSS personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus elementos secundarios \'{$a->children}\'. Esto generará un SCSS para el selector de tema con el prefijo \'.category-{$a->id}\' y para todos los id de elementos secundarios. Si no parece que se haya aplicado el SCSS, utilice las herramientas de desarrollo del navegador para investigar y verificar el archivo de registro de PHP.';
$string['categoryheadercustomtitle'] = 'Título personalizado de categoría \'{$a->name}\' conid \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Configurar el título personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' en el encabezado.  Si estuviera vacío entonces Usted será presentado con lo que haya sido configurado por las configuraciones \'sitetitle\' y \'sitetitletext\' en páginas que no sean de curso o en páginas donde  \'enableheading\' sea \'off\'.  Cuando esté poblado en páginas enlazadas de categoría que no sean de curso, entonces esto remplazará al título del sitio. Cuando esté poblado en páginas de curso,  entonces
 aparecerá arriba del título como está establecido en la configuración \'enableheading\' .  Pero en dispositivos móviles cualquier \'title\' solamente aparecerá dependiendo de la configuración \'hidecoursetitlemobile\'.';
$string['categoryheadercustomtitledescchildren'] = 'Configurar el título personalizado para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus hijos \'{$a->children}\' en el encabezado.  Si estuviera vacío entonces Usted será presentado con lo que haya sido configurado por las configuraciones \'sitetitle\' y \'sitetitletext\' en páginas que no sean de curso o en páginas donde  \'enableheading\' sea \'off\'.  Cuando esté poblado en páginas enlazadas de categorías que no sean de curso, entonces esto reemplazará al título del sitio. Cuando esté poblado en páginas de curso entonces aparecerá arriba del título como está establecido en la configuración \'enableheading\' .  Pero en dispositivos móviles cualquier \'title\' solamente aparecerá dependiendo de la configuración \'hidecoursetitlemobile\'.';
$string['categoryheaderheader'] = 'Configuraciones para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Seleccionar las configuraciones para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Seleccionar las configuraciones para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus hijos \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Logo de categoría \'{$a->name}\' con id \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Configurar un logo para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' en el encabezado.  El tamaño recomendado es 200px por 80px.';
$string['categoryheaderlogodescchildren'] = 'Configurar un logo para la categoría de nivel superior \'{$a->name}\' con id \'{$a->id}\' y sus hijos \'{$a->children}\' en el encabezado.  El tamaño recomendado es 200px por 80px.';
$string['categoryheaderssettings'] = 'Encabezados de categoría';
$string['categoryheaderssettingsdesc'] = 'Configurar configuraciones para los encabezados dentro de una categoría';
$string['categoryheaderssettingsheading'] = 'Cambiar el encabezado para una o más categorías de nivel superior e inferiores.';
$string['cdefaulticon'] = 'Ícono predeterminado para Mis cursos';
$string['cdefaulticondesc'] = 'Se usará el ícono del Font Awesome sin el prefijo \'fa-\' para cursos cuando estos aún no tengan un ícono.  Si estuviera vacío se usará el predeterminado.';
$string['cfrozenicon'] = 'Ícono congelado para Mis cursos';
$string['cfrozenicondesc'] = 'Se usará el ícono del Font Awesome sin el prefijo \'fa-\' para cursos congelados.  Si estuviera vacío se usará el predeterminado.';
$string['chiddenicon'] = 'Ícono oculto para Mis cursos';
$string['chiddenicondesc'] = 'Se usará el ícono del Font Awesome sin el prefijo \'fa-\' para cursos ocultos.  Si estuviera vacío se usará el predeterminado.';
$string['choosereadme'] = '<div class="clearfix">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
<h3>Acerca de</h3>
<p>Adaptable es un tema adaptable y altamente personalizable basado en el popular tema BCU. Boost es el tema principal, que a su vez utiliza el marco Bootstrap.</p>
<p>El tema tiene licencia GPL (licencia pública general de GNU) versión 3. Puede encontrar los detalles completos \'<a href="https://www.gnu.org/licenses/gpl-3.0.html" target="_blank">aquí</a>\'.</p>
<br>
<h3>Créditos</h3>
<p>Esta versión del tema ha sido desarrollada por:<br>
G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).
</p>
<p>Este tema ha sido desarrollado previamente por:<ul>
<li>Jeremy Hopkins (Universidad de Coventry).</li>
<li>Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>).</li>
<li>Manoj Solanki (Universidad de Coventry).</li>
</ul></p>
<h3>Otros créditos</h3>
<p>Colaboradores de la versión 2:<ul>
<li>G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).</li>
<li>Stuart Lamour.</li>
<li>Alistair Spark (University College London).</li>
</ul><p>entre Muchos otros desarrolladores, evaluadores, traductores y voluntarios (consulte el archivo <a href="adaptable/Readme.md" target="_blank">Readme.md</a>).</p>
<br>
<h3>Informar errores</h3>
<p>Puede informar errores y mejoras que desee financiar en nuestro \'<a href="https://gitlab.com/jezhops/moodle-theme_adaptable/-/issues" target="_blank">repositorio</a>\'.</p>
<br>
<h3>Soporte técnico</h3>
<p>Puede hacer sus preguntas en el foro de Moodle:</p>
<ul>
<li>Inglés: <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank">Foro de temas</a>.</li>
</ul>
</div>';
$string['cneveraccessedicon'] = 'Ícono de nunca accedido para Mis cursos';
$string['cneveraccessedicondesc'] = 'Se usará el ícono del Font Awesome sin el prefijo \'fa-\' para cursos en los cuales está inscrito el usuario, pero no los ha accesado.  Si estuviera vacío se usará el predeterminado.';
$string['collapsedtopicscoloursenabled'] = 'Alternar configuraciones de colores de frente y fondo en Tópicos Colapsados';
$string['collapsedtopicscoloursenableddesc'] = 'Usar configuraciones de color de frente y fondo de Tópicos Colapsados en lugar de las configuraciones \'sectionheadingcolor\' y \'coursesectionheaderbg\' de Adaptable.';
$string['colordesc'] = 'Puede seleccionar los colores que desea utilizar en todo el tema. Utilice el sistema hexadecimal o cualquier otra notación estándar. Como opción alternativa, puede utilizar transparente y heredado como valor.';
$string['colorsettings'] = 'Colores';
$string['colorsettingsheading'] = 'Modifica los principales colores utilizados en la plantilla.';
$string['configtabtitle'] = 'Configuraciones';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Curso';
$string['courseactivitynavigationenabled'] = 'Navegación de actividad';
$string['courseactivitynavigationenableddesc'] = 'Navegación de actividad habilitada.';
$string['courseindexenabled'] = 'Habilitado';
$string['courseindexenableddesc'] = 'Habilitar o deshabilitar el \'Índice del Curso\'.';
$string['courseindexitemcolor'] = 'Color del elemento';
$string['courseindexitemcolordesc'] = 'El color del elemento en el \'Índice del curso\' en un curso.';
$string['courseindexitemhovercolor'] = 'Color del elemento al pasar el ratón encima';
$string['courseindexitemhovercolordesc'] = 'El color del elemento al pasarle el ratón encima en el \'ïndice del curso\' en un curso.';
$string['courseindexpageitembgcolor'] = 'Color del fondo del elemento de página';
$string['courseindexpageitembgcolordesc'] = 'El color del fondo del elemento de página en el \'Índice del curso\' en un curso.';
$string['courseindexpageitemcolor'] = 'Color del elemento de página';
$string['courseindexpageitemcolordesc'] = 'el color del elemento de la página en el \'Índice del curso\' en un curso.';
$string['courseindexsettings'] = 'Índice del curso';
$string['courseindexsettingsdesc'] = 'Personalizar el Índice del Curso.';
$string['courseindexsettingsheading'] = 'Configuraciones del índice del curso';
$string['coursepageactivitybottomblockregionheading'] = 'Región del bloque del fondo de actividad de curso personalizada';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Una región de bloque personalizada que aparece después del final de las actividades.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar región del bloque del fondo de actividad del curso en página del curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageblocklayoutbuilder'] = 'Regiones de Bloque de Página de Curso';
$string['coursepageblocklayoutbuilderdesc'] = 'A continuación, puede crear su propio diseño para las regiones de bloques en la página del curso.<br/>Para agregar contenido a estas regiones, deberá <strong>activar la edición en la página del curso de Moodle</strong>.<br/>¡Luego puede comenzar a arrastrar y soltar bloques en las regiones que cree!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Fila de Región Inferior de Bloque de página de curso';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Añadir / configurar diseño para fila de región de bloque en la Página de Curso.';
$string['coursepageblocklayoutlayouttoprow'] = 'Fila de región Superior de Bloque de página de Curso';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Añadir / configurar diseño para fila de región de bloque en Página de Curso.';
$string['coursepageblockregionsettings'] = 'Constructor de Región de Bloque de página de Curso';
$string['coursepageblocksenabled'] = 'Habilitar regiones de bloque personalizadas en página de Curso';
$string['coursepageblocksenableddesc'] = 'Usted puede habilitar / deshabilitar regiones de bloques personalizadas  (superior e inferior) en la página del Curso. Usted puede entonces arrastrar y soltar bloques a las regiones que Usted creó';
$string['coursepageblocksliderenabled'] = 'Habilitar región de bloque deslizador personalizado en Página de curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar título del sitio en páginas de curso';
$string['coursepageheaderhidesitetitledesc'] = 'DEPRECADO, use \'coursepageheaderhidetitle\' en su lugar.';
$string['coursepageheaderhidetitle'] = 'Ocultar título del encabezado en páginas de curso';
$string['coursepageheaderhidetitledesc'] = 'Ocultar título del encabezado, logo y barra de búsqueda en páginas de curso. Use esto junto con configuraciones de altura del encabezado de página para mostrar un encabezado más pequeño en páginas relacionadas con el curso.';
$string['coursepagenewssliderblockregionheading'] = 'Región del bloque deslizador de noticias personalizado';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Una región de bloque personalizada diseñada para usarse con el control deslizante de noticias que forma parte de Adaptable UI. Esta región aparece sobre las actividades del curso en una página del curso. Para agregar un bloque de control deslizante de noticias, primero instale el <strong><a href="{$a}" target="_blank">control deslizante de noticias de Adaptable UI</a></strong> y configúrelo para que aparezca en la región "región del control deslizante de la página del curso" en todas las páginas del curso.';
$string['coursepagesidebarinfooterenabled'] = 'Mover barra lateral al pie de página en Página de curso';
$string['coursepagesidebarinfooterenableddesc'] = 'Diseño de página ancha de curso al mover barra lateral al pie de página.';
$string['coursepagesidebarinfooterenabledsection'] = 'Configuraciones comunes';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Configuraciones comunes para la mayoría de los formatos de curso.';
$string['courses'] = 'Cursos';
$string['coursesearch'] = 'Búsqueda de curso';
$string['coursesectionactivityassignbgcolor'] = 'Color del fondo de actividad tarea';
$string['coursesectionactivityassignbgcolordesc'] = 'Configurar el color del fondo de actividad Tarea. Escriba <strong>transparent</strong> en la caja para transparencia.';
$string['coursesectionactivityassignleftbordercolor'] = 'Color para mostrar borde izquierdo de actividad Tarea';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionactivitybordercolor'] = 'Color del Borde del Botón de Actividad en Sección de Curso';
$string['coursesectionactivitybordercolordesc'] = 'Configurar el color del borde del botón de actividad se seción de curso.';
$string['coursesectionactivityborderstyle'] = 'Estilo del Borde de Botón de Actividad de Sección de Curso';
$string['coursesectionactivityborderstyledesc'] = 'Configurar el estilo del borde del botón de actividad en sección de curso.';
$string['coursesectionactivityborderwidth'] = 'Ancho del Borde Inferior de Actividad en Sección de Curso';
$string['coursesectionactivityborderwidthdesc'] = 'Configurar el ancho del borde que aparece al fondo de una actividad de sección de curso';
$string['coursesectionactivitycolors'] = 'Opciones de Actividad en Sección de Curso';
$string['coursesectionactivityforumbgcolor'] = 'Color del fondo de actividad Foro';
$string['coursesectionactivityforumbgcolordesc'] = 'Configurar el color del fondo de la actividad Foro. Escriba <strong>transparent</strong> en la caja para transparencia.';
$string['coursesectionactivityforumleftbordercolor'] = 'Color para mostrar borde izquierdo de actividad Foro';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionactivityheadingcolour'] = 'Color del Encabezado de Actividad de Sección del Curso';
$string['coursesectionactivityheadingcolourdesc'] = 'El color para las actividades elegibles mostradas en la página inicial del curso.';
$string['coursesectionactivityiconsize'] = 'Tamaño del Ícono de Actividad en Sección de Curso';
$string['coursesectionactivityiconsizedesc'] = 'Configurar el tamaño del ícono para actividades / recursos (por ejemplo, un valor de "16px" los configurará a 16 pixeles por 16 pixeles).';
$string['coursesectionactivityleftborderwidth'] = 'Ancho del Borde Izquierdo de Actividad en Sección de Curso';
$string['coursesectionactivityleftborderwidthdesc'] = 'Configurar el ancho del borde que aparece en la izquierda de una actividad de sección de curso.';
$string['coursesectionactivitymarginbottom'] = 'Espaciado de actividad margen del botón.';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaciado entre actividades del margen del botón';
$string['coursesectionactivitymargintop'] = 'Espaciado de actividad margen superior';
$string['coursesectionactivitymargintopdesc'] = 'Espaciado entre actividades del margen superior';
$string['coursesectionactivityquizbgcolor'] = 'Color del fondo de actividad Examen';
$string['coursesectionactivityquizbgcolordesc'] = 'Configurar el color del fondo de actividad Examen. Escriba <strong>transparent</strong> en la caja para transparencia.';
$string['coursesectionactivityquizleftbordercolor'] = 'Color a mostrar borde izquierdo de actividad examen';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionbgcolor'] = 'Fondo de Sección del Curso';
$string['coursesectionbgcolordesc'] = 'Configurar el color del fondo de la sección del curso.';
$string['coursesectionbordercolor'] = 'Color del Borde de Sección de Curso';
$string['coursesectionbordercolordesc'] = 'Configurar el color del Borde de Secciones de Curso.';
$string['coursesectionborderradius'] = 'Radio del Borde de Sección del Curso';
$string['coursesectionborderradiusdesc'] = 'Configurar el Radio del Borde de Sección del Curso (esquinas redondeadas).';
$string['coursesectionborderstyle'] = 'Estilo del borde de sección del curso';
$string['coursesectionborderstyledesc'] = 'Configurar el estilo del borde de sección del curso.';
$string['coursesectionborderwidth'] = 'Ancho del Borde de Sección del Curso';
$string['coursesectionborderwidthdesc'] = 'Configurar el ancho del Borde de Sección del Curso.';
$string['coursesectionheaderbg'] = 'Fondo del Encabezado de Sección del curso';
$string['coursesectionheaderbgdesc'] = 'Configurar el color del fondo de los Encabezados de Sección del curso.';
$string['coursesectionheaderbordercolor'] = 'Color del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderbordercolordesc'] = 'Configurar el color del borde del encabezado de sección del curso (solamente se usa el borde inferior porque el contenedor externo también tiene un borde).';
$string['coursesectionheaderborderradiusbottom'] = 'Botón del Radio del Borde de Sección de Encabezado del curso';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Configurar el Botón del Radio de los Bordes de Sección de Encabezado del curso (esquinas redondeadas).';
$string['coursesectionheaderborderradiustop'] = 'Radio superior del Borde de Sección de Encabezado de Curso';
$string['coursesectionheaderborderradiustopdesc'] = 'Configurar el Radio superior del Borde de Sección de Encabezado de Curso (esquinas redondeadas).';
$string['coursesectionheaderborderstyle'] = 'Estilo del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderborderstyledesc'] = 'Configurar el estilo del Borde del Encabezado de Sección del Curso (solamente se usa el borde inferior porque el contenedor externo también tiene un borde).';
$string['coursesectionheaderborderwidth'] = 'Ancho del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderborderwidthdesc'] = 'Configurar el Ancho del Borde del Encabezado de Sección del Curso (solamente se usa el borde inferior porque el contenedor externo también tiene un borde).';
$string['coursesections'] = 'Secciones del curso';
$string['coursesettings'] = 'Cursos';
$string['coursesettingsdesc'] = 'Personalizar los cursos.';
$string['coursesettingsheading'] = 'Configuraciones del Curso';
$string['coursetitlefullname'] = 'Nombre Completo del Curso';
$string['coursetitlemaxwidth'] = 'Longitud Máxima del Título del Curso';
$string['coursetitlemaxwidthdesc'] = 'Establece el número máximo de caracteres del área del título del curso';
$string['coursetitleshortname'] = 'Código / Nombre Corto del Curso';
$string['covbkcolor'] = 'Color de fondo en los bloques estilo Coventry';
$string['covbkcolordesc'] = 'Establece el color de superposición de los bloques cuando se ha seleccionado el estilo Coventry.';
$string['coventrystyle'] = 'Estilo Coventry';
$string['covfontcolor'] = 'Color del texto en los bloques estilo Coventry';
$string['covfontcolordesc'] = 'Establece el color del texto en los bloques estilo Coventry.';
$string['covhidebutton'] = 'Mostrar el botón del curso en los bloques estilo Coventry';
$string['covhidebuttondesc'] = 'Mostrar / ocultar el botón del curso cuando se utiliza el estilo Coventry se encuentra activo.';
$string['currentcolor'] = 'Color de realce de la sección actual del curso';
$string['currentcolordesc'] = 'Establece el color de realce de la sección actual del curso.';
$string['customcoursesubtitle'] = 'Sub-Título personalizado del curso';
$string['customcoursesubtitledesc'] = 'Nombre del campo personalizado del perfil del usuario para el sub-título del curso.';
$string['customcoursetitle'] = 'Título personalizado del curso';
$string['customcoursetitledesc'] = 'Nombre del campo personalizado del perfil del usuario para el título del curso.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Introduce las reglas CSS.';
$string['customcssjssettingsheading'] = 'Aplicar sus modificaciones propias';
$string['customcsssettings'] = 'CSS personalizado';
$string['customcsssettingsdescription'] = 'Aquí usted puede encontrar varias configuraciones para añadir su propio CSS al tema.';
$string['customjs'] = 'JavaScript Personalizado';
$string['customjsdesc'] = 'Añadir JavaScript  al sitio.';
$string['customjsfiles'] = 'Archivos personalizados JavaScript';
$string['customjsfilesdesc'] = 'Añadir archivos JavaScript al sitio.';
$string['customjsrestricted'] = 'JavaScript  condicional';
$string['customjsrestricteddesc'] = 'Añadir JavaScript  al sitio basado condicionalmente en un campo de perfil personalizado. Este JavaScript solamente aparecerá si esta condición es cumplida.';
$string['customjssettings'] = 'JS personalizado';
$string['customjssettingsdescription'] = 'Aquí puede usted encontrar varias configuraciones para añadir su propio JavaScript al tema. Nota: Las tags de Script son añadidas automáticamente, no las añada usted.';
$string['custommenu'] = 'Personalizado';
$string['custommenuitemscoredesc'] = 'Se puede configurar un menú personalizado en la configuración principal. Ingrese cada elemento del menú en una nueva línea. Las líneas que comienzan con un guion aparecerán como elementos del menú en el menú de nivel superior anterior y ### hace de divisor.';
$string['custommenutitle'] = 'Título de menú personalizado';
$string['custommenutitledesc'] = 'Configurar el título del menú personalizable que contendrá todos los menúes personalizables en la Barra de Navegación. Si está vacío entonces cada entrada del nivel superior creará un nuevo menú en la Barra de navegación.';
$string['customusermenuitemscoredesc'] = 'Usted puede configurar los contenidos del menú del usuario (con la excepción del enlace para salir del sitio, que es añadido automáticamente).  Cada línea está separada por caracteres de barra vertical | y consiste de 1) una cadena de caracteres en el formato de  "nombredelangstring, nombredelcomponente" o como texto simple, 2) una URL, y 3) un nombre de ícono de Font Awesome o clases CSS (opcional).  Los divisores pueden ser usados al añadir una línea de uno o más caracteres  # donde lo desee.  Para encontrar las clases de FontAwesome(Free) para el ícono que desea usar, vaya a  <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> y busque el ícono.  Usted puede usar el nombre en idioma inglés, como por ejemplo \'graduation-cap\' o la lista completa de clases \'fa-solid fa-graduation-cap\'.  Por ejemplo:
<pre>
messages,message|/message/index.php|fa-regular fa-comment
privatefiles,moodle|/user/files.php|folder-tree
</pre>
Nota: El valor predeterminado pude contener duplicados; por favor ajuste como lo quiera.';
$string['dangericoncolor'] = 'Color del ícono de advertencia';
$string['dangericoncolordesc'] = 'Configurar el color del ícono de advertencia/peligro principalmente usado en campos obligatorios.';
$string['dashblocklayoutbuilder'] = 'Regiones de Bloque del Tablero';
$string['dashblocklayoutbuilderdesc'] = 'A continuación, puede crear su propio diseño para las regiones de bloques en la página del panel de control.<br/>Para agregar contenido a estas regiones, deberá <strong>activar la edición en la página del panel de control de Moodle</strong>.<br/>¡Luego puede comenzar a arrastrar y soltar bloques en las regiones que cree!';
$string['dashblocklayoutlayoutrow'] = 'Fila de región de Bloque del Tablero';
$string['dashblocklayoutlayoutrowdesc'] = 'Añadir / configurar el diseño para la fila de región de bloques en la página del Tablero.';
$string['dashblocksabovecontent'] = 'Mostrar contenido principal arriba';
$string['dashblocksbelowcontent'] = 'Mostrar contenido principal debajo';
$string['dashblocksenabled'] = 'Habilitar Región de Bloque Personalizado en página del Tablero';
$string['dashblocksenableddesc'] = 'Usted puede habilitar / deshabilitar las regiones de bloque personalizadas en la página del Tablero. Usted puede entonces arrastrar y soltar bloques a las regiones que Usted creó.';
$string['dashblocksposition'] = 'Posición de región de bloque personalizado';
$string['dashblockspositiondesc'] = 'Cuando están habilitadas las regiones de bloque personalizadas para la página del Tablero, elija la posición.';
$string['dashboardblockregionsettings'] = 'Constructor de región de Bloque del Tablero';
$string['dashed'] = 'A rayas discontinuas';
$string['defaultzoom'] = 'Zoom predeterminado';
$string['defaultzoomdesc'] = 'Tamaño predeterminado de pantalla cuando está deshabilitado el zoom o el usuario no haya hecho una  preferencia. Elegir entre pantalla completa y ancho fijo.';
$string['dimmedtextcolor'] = 'Color del texto atenuado';
$string['dimmedtextcolordesc'] = 'La clase CSS del texto atenuado (dimmed_text) es usado por Moodle para indicar cuando algo está deshabilitado / no visible. Para configurar ese color en el tema use código hexadecimal HTML.';
$string['disablecustommenu'] = 'Desactivar el menú personalizado de Moodle';
$string['disablecustommenudesc'] = 'Desactiva  los menúes personalizados de Moodle en la barra de navegación (seguirá funcionando en otros temas que usted hubiera instalado).';
$string['disabled'] = 'Deshabilitado';
$string['disablemenuscoursepages'] = 'Desactivar menús en las páginas de los cursos';
$string['disablemenuscoursepagesdesc'] = 'Al activar esta opción, se limitará la visualización de los menús superiores a las páginas del sitio, la página de inicio y el panel de control ("Mi página de inicio"), etc., y no se mostrarán en ninguna página del curso.';
$string['discardbuttontext'] = 'Cancelar';
$string['displayeditingbuttontext'] = 'Texto del botón Editando';
$string['displayeditingbuttontextdesc'] = 'Mostrar u ocultar el texto en el botón editando. Nota: Solamente aplica al botón para edición del curso.';
$string['displaygrades'] = 'Mostrar Calificaciones';
$string['displaygradesdesc'] = 'Mostrar los ítems de Calificaciones en el menú.';
$string['displaylogin'] = 'Mostrar ingreso';
$string['displayloginbox'] = 'Caja para Ingresar';
$string['displayloginbutton'] = 'Botón';
$string['displaylogindesc'] = 'Seleccionar como mostrar la caja para ingreso en el encabezado.';
$string['displayloginno'] = 'Sin Caja para Ingreso';
$string['displayparticipants'] = 'Mostrar Participantes';
$string['displayparticipantsdesc'] = 'Mostrar el ítem de los Participantes en el menú.';
$string['dividingline'] = 'Color de la línea divisoria de la cabecera';
$string['dividingline2'] = 'Color de la línea divisoria del pie de página';
$string['dividingline2desc'] = 'El color de la línea divisoria del pie de página.';
$string['dividinglinedesc'] = 'El color de la línea divisoria encontrada de la cabecera.';
$string['dotted'] = 'Punteada';
$string['double'] = 'Doble';
$string['editcognocourseupdate'] = 'Mostrar rueda del engrane a usuarios que no tienen permiso de actualizar';
$string['editcognocourseupdatedesc'] = 'Mostrar rueda del engrane a usuarios que no tienen permiso \'moodle/course:update\'  como por ejemplo los profesores sin derecho de edición.';
$string['editfont'] = 'Editar y Personalizar este color del font del botón de página';
$string['editfontdesc'] = 'Configurar la edición y personalizar el color del font del botón de esta página';
$string['edithorizontalpadding'] = 'Configurar separación horizontal de los botones de edición';
$string['editoffbk'] = 'Edición y personalización del fondo del botón \'Desactivado\' de esta página';
$string['editoffbkdesc'] = 'Establezca el color de fondo para la edición y personalice este botón de página en el estado "Desactivado".';
$string['editonbk'] = 'Editar y personalizar el fondo del botón de esta página';
$string['editonbkdesc'] = 'Establece el color de fondo para el botón de de edición y personalización de esta página.';
$string['editsettingsbutton'] = 'Editar configuraciones y visualización del Botón';
$string['editsettingsbuttondesc'] = 'Configurar aquí lo que debe aparecer en la Barra de Navegación para las configuraciones de edición. Tenga en cuenta que estas opciones no aplican para páginas que no sean configuraciones relacionadas, como por ejemplo la página del Tablero.';
$string['editsettingsbuttonshowbutton'] = 'Mostrar solamente el botón de edición. Por ejemplo, Activar la edición", en la página del curso.';
$string['editsettingsbuttonshowcog'] = 'Mostrar solamente el ícono de edición (ícono del engrane).';
$string['editsettingsbuttonshowcogandbutton'] = 'Mostrar el ícono de configuraciones y el engrane. Tenga en cuenta que esto ocupa más espacio en la navegación.';
$string['emoticonsize'] = 'Tamaño de emoticones';
$string['emoticonsizedesc'] = 'Configurar el alto y ancho de los emoticones de Moodle.';
$string['enableaccesstool'] = 'Herramienta de Accesibilidad';
$string['enableaccesstooldesc'] = 'Mostrar un enlace a la página de preferencias de la "Herramienta de accesibilidad" de los usuarios - Nota: Esto requiere el \'<a href="{$a}" target="_blank">Plugin de herramienta de accesibilidad</a>\'.';
$string['enablealert'] = 'Activar alerta{$a}';
$string['enablealertdesc'] = 'Activar alerta {$a}.';
$string['enablealerts'] = 'Habilitar / deshabilitar alertas';
$string['enablealertsdesc'] = 'Habilitar / deshabilitar Alertas en su sitio, pero no en el curso, vea la configuración \'alerthiddencourse\'.';
$string['enablealertstriptags'] = 'Automáticamente eliminar marcas HTML del texto de alertas';
$string['enablealertstriptagsdesc'] = 'Habilitarlo limpiará automáticamente los mensajes de alerta y deshabilitarlo para permitirle usar HTML / enlaces en mensajes pero Usted tendrá que limpiar manualmente en la vista en HTML.';
$string['enableanalytics'] = 'Activar Google Analytics';
$string['enableanalyticsdesc'] = 'Activar Google Analytics en el sitio.';
$string['enableavailablecourses'] = 'Mostrar "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el texto "Cursos Disponibles" en la Portada';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar un enlace de las insignias del usuario.';
$string['enableblog'] = 'Habilitar Mis Blogs';
$string['enableblogdesc'] = 'Mostrar un enlace a la página de blogs del usuario.';
$string['enablecalendar'] = 'Calendario del usuario';
$string['enablecalendardesc'] = 'Mostrar un enlace al calendario del usuario.';
$string['enablecompetencieslink'] = 'Enlace a competencias';
$string['enablecompetencieslinkdesc'] = 'Mostrar enlace a competencias en el menú de \'Este curso\'. Tenga en cuenta que \'core_competency|enabled\' necesita estar activada.';
$string['enablecoursesectionsdesc'] = 'Mostrar un sub-menú en el menú para \'Este curso\', que contiene enlaces hacia cada sección mostrada.';
$string['enablecoursetitle'] = 'Título del curso';
$string['enablecoursetitledesc'] = 'Configurar el modo para mostrar el título del curso.';
$string['enabledtabbedprofileeditprofilelink'] = 'Habilitar enlace hacia editar perfil';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Habilitar el enlace hacia editar perfil en pestañas. Nota: Cuando se habilita solamente se mostrará si el usuario que observa tiene permiso para editar el perfil.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Habilitar enlace hacia preferencias';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Habilitar el enlace de preferencias del usuario para perfil en pestañas.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar un enlace para editar el perfil del usuario.';
$string['enableeventsdesc'] = 'Mostrar un enlace al calendario.';
$string['enablefeed'] = 'Mi retroalimentación';
$string['enablefeeddesc'] = 'Mostrar el enlace a la página "Opiniones" - Nota: esta opción requiere el  \'<a href="{$a}" target="_blank">My Feedback Plugin</a>\'.';
$string['enablegrades'] = 'Calificaciones';
$string['enablegradesdesc'] = 'Mostrar un enlace a las calificaciones del usuario.';
$string['enableheading'] = 'Nombre del curso';
$string['enableheadingdesc'] = 'DEPRECADO, use \'enablecoursetitle\' en su lugar.';
$string['enablehelp'] = 'Enlace de ayuda \'{$a->number}\'';
$string['enablehelpdesc'] = 'Añade un enlace de ayuda \'{$a->number}\' en la barra de navegación.';
$string['enablehomedesc'] = 'Mostrar enlace a Inicio';
$string['enablehomeredirect'] = 'Activar redirect=0 home';
$string['enablehomeredirectdesc'] = 'Habilitar redirect=0 en la página de inicio. Esta opción se utiliza en sitios donde Mi página de inicio es la página de inicio predeterminada. Evita que los usuarios que hagan clic en el enlace de Inicio sean redirigidos a "Mi página de inicio" o "Tablero".';
$string['enablemenus'] = 'Habilitar menúes';
$string['enablemenusdesc'] = 'Por motivos de rendimiendo, se recomienda no activarlo si no se utilizan los menús.';
$string['enablemy'] = 'Tablero';
$string['enablemydesc'] = 'Mostrar un enlace hacia la página del Tablero.';
$string['enablemysitesdesc'] = 'Mostrar los cursos del usuario';
$string['enablemysitesrestriction'] = 'Restringir desplegable de cursos del usuario a un campo personalizado del perfil';
$string['enablemysitesrestrictiondesc'] = 'Restringir el menú desplegable con los cursos de un usuario mediante un campo de perfil personalizado. Por ejemplo, usertype=staff.';
$string['enablenavbarwhenloggedout'] = 'Habilitar Barra de Navegación cuando salió del sitio';
$string['enablenavbarwhenloggedoutdesc'] = 'Muestra la barra de navegación incluso cuando se cierra la sesión. Se limita únicamente al menú de ayuda y herramientas.';
$string['enablenote'] = 'Mis notificaciones';
$string['enablenotedesc'] = 'Mostrar un enlace a la página de notificaciones del usuario.';
$string['enableposts'] = 'Mis publicaciones';
$string['enablepostsdesc'] = 'Mostrar un enlace a la página de mis publicaciones.';
$string['enablepref'] = 'Mis preferencias';
$string['enableprefdesc'] = 'Mostrar un enlace a la página de las preferencias del usuario.';
$string['enableprivatefiles'] = 'Archivos privados';
$string['enableprivatefilesdesc'] = 'Mostrar un enlace a los archivos privados del usuario.';
$string['enableprofile'] = 'Perfil del usuario';
$string['enableprofiledesc'] = 'Mostrar un enlace al perfil de usuario.';
$string['enablesavecanceloverlay'] = 'Habilitar sobrepuesto de Guardar / Cancelar en páginas de configuraciones';
$string['enablesavecanceloverlaydesc'] = 'Muestra un botón superpuesto para guardar/cancelar en la parte superior de una página de configuración para que sea más fácil guardar la configuración.';
$string['enablesavecanceloverlayresetconfirm'] = 'Esto reinicia cualquier cambio hecho desde que se cargó esta página. ¿Está usted seguro?';
$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar bloques';
$string['enableshowhideblocksdesc'] = 'Permite a los usuarios mostrar / ocultar los bloques laterales.';
$string['enableshowhideblockstext'] = 'Mostrar texto para Mostrar / Ocultar Bloques';
$string['enableshowhideblockstextdesc'] = 'Mostrar el texto debajo del botón.';
$string['enabletabbedprofile'] = 'Habilitar perfil con  pestañas';
$string['enabletabbedprofiledesc'] = 'Habilitar la funcionalidad de perfil con  pestañas';
$string['enablethiscoursedesc'] = 'Mostrar un menú desplegable con las actividades del curso actual.';
$string['enableticker'] = 'Activar los anuncios en la página de inicio';
$string['enabletickerc'] = 'Activar los anuncios en las páginas internas';
$string['enabletickercdesc'] = 'Marcar para activar los anuncios en las páginas internas.';
$string['enabletickerdesc'] = 'Marcar para activar los anuncios en la página de inicio.';
$string['enabletickermy'] = '¿Habilitar el Tablero de Avisos?';
$string['enabletickermydesc'] = 'Marque para habilitar el ticker en las páginas \'Mi hogar\' / \'Tablero\'.';
$string['enabletoolsmenus'] = 'Habilitar menúes de herramientas';
$string['enabletoolsmenusdesc'] = 'Se recomienda dejar esto fuera de los menús que no estén en uso por razones de rendimiento.';
$string['enableuserfavmenu'] = 'Habilitar el menú de favoritos del usuario';
$string['enableuserfavmenudesc'] = 'Se recomienda dejar esta opción desactivada si el menú no se utiliza por razones de rendimiento.';
$string['enableusermysitessortoverride'] = 'Habilitar la clasificación personalizada de mis cursos por parte del usuario';
$string['enableusermysitessortoverridedesc'] = 'Permitir que el usuario establezca su propio valor para \'Orden personalizado de mis cursos\', incluido el valor predeterminado de configuración del tema establecido por \'mysitessortoverride\'.';
$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permitirle a los usuarios alternar entre pantalla completa y ancho fijo.';
$string['enablezoomshowtext'] = 'Mostrar texto para Habilitar Zoom';
$string['enablezoomshowtextdesc'] = 'Mostrar el texto junto al botón.';
$string['events'] = 'Eventos';
$string['expandable'] = 'Expandible';
$string['fa6name'] = 'Versión gratuita de tema FontAwesome 6';
$string['faiv'] = 'Cuñas de FontAwesome Gratuito 4';
$string['faivdesc'] = 'Cuando se usa FontAwesome 6 Gratuito por los íconos añadir soporte para los nombres de clase de íconos de la versión 4.';
$string['fav'] = 'FontAwesome 6 Gratuito';
$string['favdesc'] = 'Usar la versión de temas de FontAwesome 6 Gratuito para íconos. Nota: Por favor vea la licencia en la carpeta de los fonts del tema.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Subir un favicon para usar en su sitio usando la configuración del núcleo \'core_admin | favicon\' debajo de \'Administración del sitio\' -> \'Apariencia\' -> \'Logos\'.';
$string['favoff'] = 'Versión básica de FontAwesome 6 Gratuito';
$string['flexibleblocksoverflow'] = 'Desbordamiento';
$string['fontawesomesettingdesc'] = 'El formato de cada línea es \'texto|url|titulo|idiomas|fontawesome classes|capacidad a comprobar\'.  Escriba solamente lo que usted necesita. Si no necesita algo, pero más adelante necesitará otra cosa déjelo vacío pero use el delimitador de la barra vertical  \'|\' . Por ejemplo: \'texto|url|||fontawesome classes\'.  Para encontrar las clases libres gratuitas de FontAwesome(Free) para el ícono que quiere usar, vaya a  <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> y busque el ícono.  Usted puede usar el nombre en idioma inglés, como por ejemplo \'graduation-cap\' o la lista completa de clases  \'fa-solid fa-graduation-cap\'.  Por ejemplo:<pre>
Cursos
-Todos los cursos|/curso/
-Búsqueda de curso|/curso/search.php
-###
-FAQ|https://ejemplo.org/faq
-Reloj del examen|https://mysite.localhost|Exam Clock|en|clock
-Cloc arholiad|https://mysite.localhost|Cloc arholiad|cy|clock
Educadores|https://mysite.localhost|Educadores solamente|en|graduation-cap|moodle/course:manageactivities
</pre>';
$string['fontblockheadercolor'] = 'Color del tipo de letra de encabezado de bloques';
$string['fontblockheadercolordesc'] = 'Configura el color del tipo de letra del encabezado de los bloques de Moodle; use código hexadecimal HTML. Tenga en cuenta que esto también afecta el color del ícono.';
$string['fontblockheadersize'] = 'Tamaño del tipo de letra del encabezado de bloques';
$string['fontblockheadersizedesc'] = 'Configurar el tamaño del tipo de letra en el encabezado de bloques de Moodle. Seleccione un valor de la lista.';
$string['fontblockheaderweight'] = 'Peso del tipo de letra del encabezado del bloque';
$string['fontblockheaderweightdesc'] = 'Establezca el grosor de fuente que se utilizará en el encabezado de los bloques de Moodle. Seleccione un valor entre 100 y 900 según la fuente seleccionada.';
$string['fontcolor'] = 'Color del tipo de letra principal';
$string['fontcolordesc'] = 'Establece el color del tipo de letra principal, usar código hexadecimal HTML.';
$string['fontdefault'] = 'Predeterminado';
$string['fontdesc'] = 'Usted puede seleccionar los fonts que le gustaría usar en el tema.';
$string['fontheadercolor'] = 'Color del tipo de letra de los encabezados';
$string['fontheadercolordesc'] = 'Establece el color del tipo de  letra de los encabezados utilizados en la plantilla.';
$string['fontheadername'] = 'Tipo de letra de encabezados';
$string['fontheadernamedesc'] = 'Seleccionar el tipo de letra  usado en los encabezados de bloque y texto.';
$string['fontheaderweight'] = 'Grueso del tipo de letra de encabezados';
$string['fontheaderweightdesc'] = 'Grosor de la fuente de los encabezados que se utiliza en el sitio. Seleccione un valor entre 100 y 900 según la fuente seleccionada.';
$string['fontname'] = 'Tipo de letra principal';
$string['fontnamedesc'] = 'Seleccionar el font principal para el sitio.';
$string['fontsettings'] = 'Tipos de letras (fonts)';
$string['fontsettingsheading'] = 'Establece los tipos de letras utilizados por la plantilla.';
$string['fontsize'] = 'Tamaño del tipo de letra principal';
$string['fontsizedesc'] = 'Selecciona el tamaño por defecto del tipo de letra (en porcentaje) usado en todo el sitio.';
$string['fontsubset'] = 'Juego de caracteres de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccione un subconjunto de caracteres distintos del latino para aplicarlo a todas las fuentes. El subconjunto latino ya está incluido de manera predeterminada.';
$string['fonttitlecolor'] = 'Color del tipo de letra del título del Sitio / Curso';
$string['fonttitlecolorcourse'] = 'Color del tipo de letra del título del curso';
$string['fonttitlecolorcoursedesc'] = 'Establecer el color del tipo de letra (font) del título del curso en el tema; use código HEXADECIMAL.';
$string['fonttitlecolordesc'] = 'Establece el color del tipo de letra del título del sitio y título del curso en el tema; use código hexadecimal HTML.';
$string['fonttitlename'] = 'Tipo de letra del título del Sitio / Curso';
$string['fonttitlenamedesc'] = 'Seleccionar el tipo de letra usado en los títulos del curso y del sitio.';
$string['fonttitlesize'] = 'Tamaño del tipo de letra del título del Sitio / Curso';
$string['fonttitlesizedesc'] = 'Tamaño de fuente del título del sitio y del título del curso utilizado en el sitio. Seleccione un valor de la lista.';
$string['fonttitleweight'] = 'Grueso del tipo de letra del título del Sitio / Curso';
$string['fonttitleweightdesc'] = 'Establezca el grosor de fuente que se utilizará en el título del sitio y en los títulos de los cursos. Seleccione un valor entre 100 y 900 según la fuente seleccionada.';
$string['fontweight'] = 'Grueso del tipo de letra principal';
$string['fontweightdesc'] = 'Grosor de la fuente utilizada en el sitio. Seleccione un valor entre 100 y 900 según la fuente seleccionada.';
$string['footerbkcolor'] = 'Color del fondo del pie de página superior';
$string['footerbkcolordesc'] = 'Establece el color de fondo usado por el pie de página superior.';
$string['footerblocksplacement'] = 'Posición de los bloques del pie de página';
$string['footerblocksplacement1'] = 'Sitewide (Todo_el_sitio)';
$string['footerblocksplacement2'] = 'Solamente Página inicial';
$string['footerblocksplacement3'] = 'Never (Nunca)';
$string['footerblocksplacementdesc'] = 'Controla en donde se muestran los bloques de pie de página superiores. Sitewide (todo_el_sitio) es la opción por defecto.';
$string['footerbuilderdesc'] = 'Use la herramienta debajo para configurar sus bloques del pie de página. Una vez definids, los bloques seguirán el diseño cuando se desactive la edición y el ancho de la ventana sea mayor de 575 pixeles. El rebosamiento siempre será de cuatro bloques por fila.';
$string['footerbuilderheading'] = 'Constructor del diseño del bloque del pie de página';
$string['footercontent'] = 'Sección con Contenido del Pie de página';
$string['footercontentdesc'] = 'Añadirle contenido a sección del pie de página';
$string['footerdesc'] = 'Añadir un título para la sección del pie de página';
$string['footerheader'] = 'Sección del título del pie de página';
$string['footerlayoutrow'] = 'Constructor de Diseño de Pie de Página';
$string['footerlayoutrowdesc'] = 'Fabrique su diseño para las regiones de bloque del pie de página';
$string['footerlinkcolor'] = 'Color de los enlaces del pie de página';
$string['footerlinkcolordesc'] = 'Establece el color de los enlaces del pie de página.';
$string['footersettings'] = 'Pie de Página';
$string['footersettingsheading'] = 'Configurar el contenido de lo que debe de aparecer en el pie de página.';
$string['footertextcolor'] = 'Color de texto del pie de página superior';
$string['footertextcolor2'] = 'Color del texto del pie de página inferior';
$string['footertextcolor2desc'] = 'Establece el color usado por el texto en el pie de página inferior.';
$string['footertextcolordesc'] = 'Establece el color usado por el texto en el pie de página superior.';
$string['footnote'] = 'Copyright / Nota al pie';
$string['footnotedesc'] = 'Añadir un texto de copyright / nota al pie en el pie de página.';
$string['forumbodybackgroundcolor'] = 'Fondo del cuerpo de publicación en foro';
$string['forumbodybackgroundcolordesc'] = 'Color del fondo para una publicación en foro';
$string['forumheaderbackgroundcolor'] = 'Fondo del encabezado de publicación en foro';
$string['forumheaderbackgroundcolordesc'] = 'Color del Fondo para una publicación en foro';
$string['frnt-footer'] = 'Los bloques en esta área serán visibles solamente para los usuarios administradores.';
$string['frontpageblocksenabled'] = 'Habilitar región de bloque personalizada en la Portada';
$string['frontpageblocksenableddesc'] = 'Puede habilitar o deshabilitar regiones de bloques personalizados en la página principal. Luego, puede arrastrar y soltar bloques en las regiones que creó.';
$string['frontpageblocksettings'] = 'Bloques promocionales';
$string['frontpagecoursesettings'] = 'Lista de Cursos en Portada';
$string['frontpagedesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagemarketenabled'] = 'Habilitar bloques de marketing: obsoleto, realice la transición al uso de la región del bloque de información';
$string['frontpagemarketenableddesc'] = 'Activar los bloques promocionales en la pagina de inicio.';
$string['frontpagemarketoption'] = 'Elegir estilo para los Bloques Promocionales';
$string['frontpagemarketoptiondesc'] = 'Usted puede aplicar diferentes estilos a los bloques promocionales. Tenga en cuenta que el estilo BCU está diseñado para trabajar con imágenes en la zona de arriba de los bloques.';
$string['frontpagenumbertiles'] = 'Número de mosaicos de curso por fila';
$string['frontpagenumbertilesdesc'] = 'Número de mosaicos de curso a mostrar por fila en la lista de cursos de la Portada.';
$string['frontpagerenderer'] = 'Cajas de cursos en Portada';
$string['frontpagerendererdefaultimage'] = 'Imagen por defecto para los cursos';
$string['frontpagerendererdefaultimagedesc'] = 'La imagen predeterminada que se utilizará cuando no se encuentre ninguna imagen del curso (solo se aplica a mosaicos con superposición).';
$string['frontpagerendererdesc'] = 'Controla la forma en que se representan los cuadros del curso en la página principal.';
$string['frontpagerendereroption1'] = 'Mosaicos';
$string['frontpagerendereroption2'] = 'Mosaicos sin sobreposición';
$string['frontpagerendereroption3'] = 'Por defecto';
$string['frontpagerendereroption4'] = 'Mosaicos Coventry';
$string['frontpagesettingsheading'] = 'Página Inicial';
$string['frontpageslidersettings'] = 'Deslizador de la Portada';
$string['frontpagetiles1'] = 'Un mosaico';
$string['frontpagetiles2'] = 'Dos mosaicos';
$string['frontpagetiles3'] = 'Tres mosaicos';
$string['frontpagetiles4'] = 'Cuatro mosaicos';
$string['frontpagetiles6'] = 'Seis  mosaicos';
$string['frontpageuserblocksenabled'] = 'Habilitar bloque en región costado-post en la Portada para usuarios';
$string['frontpageuserblocksenableddesc'] = 'Usted puede habilitar / deshabilitar la región del bloque costado-post en la Portada para los usuarios. Nota: \'Usuarios\' aquí significa invitados y usuarios autenticados; Administradores siempre verán la región.';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenwidth'] = 'Ancho de pantalla completa';
$string['fullscreenwidthdesc'] = 'Establece el ancho máximo de la pantalla en modo pantalla completa / zoom.';
$string['future'] = 'Futuro';
$string['gdprbutton'] = 'Botón del Resumen de Retención de Datos';
$string['gdprbuttondesc'] = 'Mostrar el Botón del Resumen de Retención de Datos en el pie de página.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Usted puede configurar códigos múltiples para Google Analytics y dirigirlos a campos de perfil del usuario.';
$string['googleanalyticssettingsheading'] = 'Configurar Google Analytics para su sitio';
$string['googlefonts'] = 'Google fonts';
$string['googlefontsdesc'] = 'Habilite <a href="{$a}" target="_blank">Google Fonts</a> para los nombres de fuente que estipule, excepto "Predeterminado". Cuando esté "deshabilitado", tendrá la oportunidad de servir las fuentes usted mismo a través de la modificación de CSS/tema o tenerlas ya instaladas en los dispositivos de los usuarios. Cuando esté "habilitado", seleccione el subconjunto necesario (siempre se incluye el latino) e ingrese el peso de fuente correcto o la fuente no se mostrará. <b>NOTA: Adaptable tiene licencia GPLv3 y puede contener errores. Verifique usted mismo que cuando esté deshabilitado, no se estén utilizando las fuentes de Google.</b>';
$string['headerbgimage'] = 'Imágen de Fondo';
$string['headerbgimagedesc'] = 'Establezca una imagen de fondo en el encabezado. El tamaño mínimo es de 1600 x 180 px (se recomienda 1900 x 180 px). La imagen cubre todo el encabezado. Puede agregar un color en "Color de fondo del encabezado superior" o usar <i>transparente</i> para mostrar la imagen de fondo. En ese caso, modifique el color del texto para que se muestre correctamente sobre la imagen.';
$string['headerbgimagetextcolour'] = 'Color del texto de imagen del fondo';
$string['headerbgimagetextcolourdesc'] = 'Si usted tiene una imagen de fondo, entonces use esta configuración para configurar el color del texto que se coloca sobre ella.';
$string['headerbkcolor'] = 'Color de fondo de la parte superior de la cabecera';
$string['headerbkcolor2'] = 'Color de fondo de la parte inferior de la cabecera';
$string['headerbkcolor2desc'] = 'Establezca el color de fondo del encabezado inferior. Tenga en cuenta que esto también establece el color del fondo en el estilo de encabezado 2.';
$string['headerbkcolordesc'] = 'Establece el color de fondo de la parte superior de la cabecera.';
$string['headerdesc'] = 'Suba su logotipo, configurar el formulario de inicio de sesión en el encabezado, ajustar los títulos en el encabezado.<br />Puede configurar el tamaño de fuente y los estilos de los títulos en la página de configuración de \'<a href="./../admin/settings.php?section=theme_adaptable_font">fuentes</a>\'.';
$string['headernavbarcustommenucoreempty'] = 'Setting \'<small>{$a}</small>\' is empty.';
$string['headernavbarcustommenucoreheading'] = 'Configuraciones del núcleo';
$string['headernavbarcustommenucoreheadingdesc'] = 'Se muestra para mayor comodidad. Vaya a "Configuración avanzada del tema" en "Apariencia".';
$string['headernavbarcustommenucorenotempty'] = 'La configuración \'<small>{$a}</small>\' es:<br><br>';
$string['headernavbarcustommenuheading'] = 'Menú personalizado';
$string['headernavbarcustommenuheadingdesc'] = 'El Menú personalizado como está configurado por la configuración \'custommenuitems\', dupliacado debajo.';
$string['headernavbarhelpheading'] = 'Enlaces de ayuda y opciones';
$string['headernavbarhelpheadingdesc'] = 'Opciones para enlaces del menú para ayuda.';
$string['headernavbarmycoursesheading'] = 'Menú de Mis Cursos';
$string['headernavbarmycoursesheadingdesc'] = 'Todas las opciones para la opción del menú de \'Mis Cursos\' (\'Mis Sitios\') que muestra la lista de los cursos actuales del usuario.';
$string['headernavbarthiscourseheading'] = 'Menú de Este Curso';
$string['headernavbarthiscourseheadingdesc'] = 'En este menú el estudiante puede acceder directamente a todas las actividades del curso y la lista de los participantes y sus calificaciones.';
$string['headersearchandsocial'] = 'Encabezado búsqueda y social';
$string['headersearchandsocialdesc'] = 'Configurar la posición de la caja de búsqueda y los íconos sociales en el encabezado para el estilo uno de encabezado.<br />
Usted puede configurar los íconos sociales bajo  la página de configuraciones de  <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Header social</a>  .</strong>.';
$string['headersearchandsocialnone'] = 'Ninguno';
$string['headersearchandsocialsearchheader'] = 'Buscar en encabezado';
$string['headersearchandsocialsearchmobilenav'] = 'Buscar en encabezado y barra de navegación en móviles';
$string['headersearchandsocialsearchnavbar'] = 'Buscar en barra de navegación';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Buscar en barra de navegación, social en encabezado';
$string['headersearchandsocialsocialheader'] = 'Social en encabezado';
$string['headersettings'] = 'Cabecera';
$string['headersettingsheading'] = 'Personalice el encabezado de este tema.';
$string['headerstyle'] = 'Estilo del encabezado';
$string['headerstyle1'] = 'Encabezado uno (encabezado original de 3 filas)';
$string['headerstyle2'] = 'Encabezado dos (encabezado de 2 filas)';
$string['headerstyledesc'] = 'Elegir el estilo del encabezado. Encabezado uno se refiere al encabezado original Adaptable de tres filas. Encabezado dos es un encabezado mínimo de 2 filas con una caja para búsqueda.';
$string['headerstyleheading'] = 'Configuraciones de Estilo del Encabezado';
$string['headerstyleheadingdesc'] = 'Adaptable admite dos estilos de encabezado: el encabezado original de tres filas y un encabezado simplificado más nuevo de dos filas.<br/>Tenga en cuenta que si cambia al encabezado más nuevo de dos filas, <strong>NO</strong> podrá:<br /><ol><li>Mostrar íconos sociales en el encabezado.</li><li>Mostrar el logotipo del sitio en dispositivos móviles.</li></ol>';
$string['headertextcolor'] = 'Color de texto y enlaces de la cabecera';
$string['headertextcolor2'] = 'Color del texto del encabezado inferior';
$string['headertextcolor2desc'] = 'Establezca el color del texto del encabezado inferior.';
$string['headertextcolordesc'] = 'Establece el color de texto y enlaces de la cabecera.';
$string['help'] = 'Ayuda';
$string['helplinkscount'] = 'Número de enlaces de ayuda';
$string['helplinkscountdesc'] = 'Configurar el número de enlaces de ayuda que desea añadir a la barra de navegación del menú principal.';
$string['helplinktitle'] = 'Título de enlace de Ayuda \'{$a->number}\'';
$string['helplinktitledesc'] = 'El título para enlace de ayuda \'{$a->number}\' en la barra de navegación.  Si estuviera vacío se usará \'Ayuda {$a->number}\'.';
$string['helpprofilefield'] = 'Campo personalizado del perfil \'{$a->number}\' para la ayuda (opcional)';
$string['helpprofilefielddesc'] = 'Añade una regla de acceso de enlace de ayuda  \'{$a->number}\' usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['helptarget'] = 'Nueva ventana de ayuda';
$string['helptargetdesc'] = 'Abrir la ayuda en la misma ventana o en una nueva.';
$string['helptitle'] = 'Ayuda {$a->number}';
$string['hiddencourses'] = 'Cursos ocultos';
$string['hiddenfromview'] = 'Oculto de la vista';
$string['hide'] = 'Ocultar';
$string['hidefootersocial'] = 'Mostrar íconos sociales';
$string['hidefootersocialdesc'] = 'Mostrar íconos sociales en el pie de página debajo de los bloques.';
$string['hideinforum'] = 'Ocultar ayuda, favoritos de usuario y herramientas en foros';
$string['hideinforumdesc'] = 'Al utilizar un ancho fijo y todas las opciones de menú, el cuadro de búsqueda del foro se desborda hacia la línea de abajo. Al activar esta opción, se ocultarán los elementos del menú de ayuda, favoritos del usuario y herramientas en los foros, lo que permitirá que se muestren correctamente.';
$string['home'] = 'Inicio';
$string['homebk'] = 'Imagen de fondo de la Portada';
$string['homebkdesc'] = 'Subir una imagen que será una imagen de fondo en la página inicial.';
$string['hvpcustomcss'] = 'CSS Personalizado de HP5';
$string['hvpcustomcssdesc'] = 'CSS personalizado para el módulo H5P';
$string['infobox'] = 'Cuadro informativo de Portada';
$string['infobox2'] = 'Cuadro informativo secundario de Portada';
$string['infobox2desc'] = 'Cuadro de información secundaria de la página principal. Consulte la sección "Léame" en la pestaña de configuración "Información" para obtener información adicional.<br><strong>Nota: </strong><i>Este elemento solo se utiliza para compatibilidad con BCU y se eliminará en las próximas versiones.</i>';
$string['infoboxdesc'] = 'Bloque de información HTML de la página de inicio. Consulte la sección "Léame" en la pestaña de configuración "Información" para obtener información adicional.<br><strong>Nota: </strong><i>Este elemento solo se utiliza para compatibilidad con BCU y se eliminará en las próximas versiones.</i>';
$string['infoboxfullscreen'] = 'Cuadros informativos a pantalla completa';
$string['infoboxfullscreendesc'] = 'Marcar está opción para mostrar los cuadros informativos a ancho completo.';
$string['infoiconcolor'] = 'Color del ícono de ayuda';
$string['infoiconcolordesc'] = 'Configurar el color del ícono de info/ayuda usado por herramientitas de ayuda.';
$string['informationblocksbuilderdesc'] = 'Utilice la herramienta que se encuentra a continuación para configurar los bloques de información. Una vez definidos, los bloques seguirán el diseño cuando la edición esté desactivada y el ancho de la ventana sea mayor a 575 px. El desbordamiento siempre será de cuatro bloques por fila.';
$string['informationblocksbuilderheading'] = 'Constructor del diseño del bloque de Información';
$string['informationblocksenabled'] = 'Habilitar bloques de Información';
$string['informationblocksenableddesc'] = 'Configurar los bloques de información en la Portada.';
$string['informationblocksettings'] = 'Bloques de información';
$string['informationblockslayoutrow'] = 'Fila de bloques de información';
$string['informationblockslayoutrowdesc'] = 'Añadir / configurar el diseño para la fila de este bloque de información en la Portada.';
$string['informationblocksvisible'] = 'Mostrar los bloques de información cuando';
$string['informationblocksvisibledesc'] = 'Mostrar los bloques de información cuando \'Salido del sitio\', \'Ingresado al sitio\' o \'Ingresado o salido del sitio\'.';
$string['informationblocksvisibleloggedin'] = 'Ingresado al sitio';
$string['informationblocksvisibleloggedinout'] = 'Ingresado o salido del sitio';
$string['informationblocksvisibleloggedout'] = 'Salido del sitio';
$string['informationsettingsdesc'] = 'Hay un generador de diseño que le permite decidir cuántos bloques necesita y definir su propio diseño.<br>Consulte la sección "Léame" en la pestaña de configuración "Información" para obtener información adicional.';
$string['informationsettingsheading'] = 'Personalizar la región del bloque de información que aparece en la Portada.';
$string['inprogress'] = 'En progreso';
$string['inputbuttonfocuscolour'] = 'Color del foco del botón de entrada';
$string['inputbuttonfocuscolourdesc'] = 'El color que el botón usa cuando se enfoca en el botón de entrada.';
$string['inputbuttonfocuscolouropacity'] = 'Opacidad del color del foco del botón de entrada';
$string['inputbuttonfocuscolouropacitydesc'] = 'La opacidad  que el botón usa para el color cuando se enfoca el botón de entrada.';
$string['introboxbackgroundcolor'] = 'Color del fondo de Caja de Introducción';
$string['introboxbackgroundcolordesc'] = 'Color del fondo para la caja de introducción (resalta descripción de actividad) usado en foros y otras actividades.';
$string['invalidcategorygeneratedscss'] = 'CSS inválido de categoría generado: \'{$a->scss}\'.';
$string['invalidcategoryscss'] = 'SCSS de categoría personalizada inválido para categoría \'{$a->topcatname}\' con id \'{$a->topcatid}\': \'{$a->scss}\'.';
$string['jssection'] = 'Sección de Javascript';
$string['jssectiondesc'] = 'DEPRECADO, use \'customjs\' en su lugar.';
$string['jssectionrestricted'] = 'Sección de JavaScript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir JavaScript solamente en la página del Tablero';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar el JavaScript solamente en la página del Tablero. En caso contrario, se muestra en todo el sitio.';
$string['jssectionrestricteddesc'] = 'DEPRECADO, use \'customjsrestricted\' en sustitución.';
$string['jssectionrestrictedprofilefield'] = 'Campo personalizado del perfil de Sección JavaScript';
$string['jssectionrestrictedprofilefielddesc'] = 'Mostrar el JavaScript de arriba SOLAMENTE cuando el usuario coincide con el valor de este campo personalizado del perfil ; por ejemplo:  faculty=fbl';
$string['jumpto'] = 'Saltar a ...';
$string['landscape'] = 'Apaisado';
$string['layoutaddcontent'] = '¿Está feliz con su diseño? Ahora Añada Contenido a Sus Bloques';
$string['layoutaddcontentdesc1'] = 'Usted ha configurado';
$string['layoutaddcontentdesc2'] = 'Bloques. Si está conforme con este diseño, agregue contenido a los bloques que aparecen a continuación. Si no está conforme, utilice el generador de diseños que se encuentra arriba para realizar cambios.';
$string['layoutcheck'] = 'Revise su diseño';
$string['layoutcheckdesc'] = 'Uase la herramienta inferior para revisar el número de bloques que Usted haya usado y ver una representación de su nuevo diseño.';
$string['layoutcount1'] = 'Usted puede configurar un máximo de';
$string['layoutcount2'] = 'Regiones de bloque. Actualmente Usted está usando:';
$string['layoutdesc'] = 'Configuración de la disposición por defecto.';
$string['layoutsettings'] = 'Diseño de pantalla';
$string['layoutsettingsheading'] = 'Controlar las diferentes disposiciones de la plantilla.';
$string['leftblocks'] = 'Lado izquierdo';
$string['linkcolor'] = 'Color del enlace';
$string['linkcolordesc'] = 'Establece el color de los enlaces.';
$string['linkhover'] = 'Color del enlace al pasar el ratón encima';
$string['linkhoverdesc'] = 'Establece el color cuando pasa el cursor sobre los enlaces.';
$string['linksmenu'] = 'Menú de enlaces';
$string['loadingcolor'] = 'Color de carga de la página';
$string['loadingcolordesc'] = 'El color de la barra de carga.';
$string['loginbgimage'] = 'Imagen del fondo';
$string['loginbgimagedesc'] = 'Añadir una imagen del fondo a la página a tamaño completo.';
$string['loginbgopacity'] = 'Opacidad del fondo del pie de página, caja de ingreso, barra de navegación y encabezado de página para ingreso, cuando hay una imagen de fondo';
$string['loginbgopacitydesc'] = 'Opacidad del fondo para ingreso para el encabezado, barra de navegación, caja de ingreso y pie de página cuando hay una imagen de fondo.';
$string['loginbgstyle'] = 'Estilo del fondo para ingreso';
$string['loginbgstyledesc'] = 'Seleccionar el estilo para la imagen subida.';
$string['logindesc'] = 'Personalizar la página para ingresar al sitio al añadirle un fondeo de imagen y textos arriba y abajo de la caja para ingreso.';
$string['loginfooter'] = 'Pie de página de página para ingresar';
$string['loginfooterdesc'] = 'Mostrar el pie de página de página para ingresar.';
$string['loginheader'] = 'encabezado de página para ingreso';
$string['loginheaderdesc'] = 'Mostrar el encabezado de página para ingresar.';
$string['loginplaceholder'] = 'Nombre_de_usuario';
$string['loginsettings'] = 'Página para ingresar al sitio';
$string['loginsettingsheading'] = 'Personalizar la página para ingresar al sitio';
$string['logintextboxbottom'] = 'Caja de texto del fondo';
$string['logintextboxbottomdesc'] = 'Añadir una caja con texto personalizado debajo de la caja para ingresar al sitio.';
$string['logintextboxtop'] = 'Caja de texto superior';
$string['logintextboxtopdesc'] = 'Añadir una caja con texto personalizado arriba de la caja para ingresar al sitio.';
$string['logintextbutton'] = 'Ingresar';
$string['logintextbuttonwhenoidc'] = 'Ingreso Invitado/Manual';
$string['logintextmanualbutton'] = 'Ingreso a cuenta de prueba';
$string['logo'] = 'Logo';
$string['logoalt'] = 'Descripción del logo';
$string['logoaltdesc'] = 'Proporcionar una descripción del logo para accesibilidad. Compatible con multi-idioma.';
$string['logodesc'] = 'Subir un logo para usarlo en su sitio. El tamaño recomendado es 200 pixeles por 80 pixeles.';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Establecer el color principal.';
$string['maincoursepage'] = 'Página principal del curso';
$string['market'] = 'Bloque promocional';
$string['marketblockbordercolor'] = 'Color del borde de los bloques promocionales';
$string['marketblockbordercolordesc'] = 'Establecer el color de la línea del borde del bloque promocional.';
$string['marketblocksbackgroundcolor'] = 'Color de fondo de la región de los bloques promocionales.';
$string['marketblocksbackgroundcolordesc'] = 'Establece el color de fondo de la región de los bloques promocionales.';
$string['marketdesc'] = 'Agregue código HTML para el bloque de marketing. Consulte la sección "Léame" en la pestaña de configuración "Información" para obtener información adicional.';
$string['marketingbuilderdesc'] = 'Use la herramienta inferior para configurar sus bloques promocionales. Una vez que lo haya definido aparecerán las configuraciones del bloque más abajo en la página.';
$string['marketingbuilderheading'] = 'Generador de diseño de bloque de marketing: obsoleto, realice la transición para usar la región del bloque de información';
$string['marketingdeprecated'] = 'Los bloques promocionales están deprecados; por favor migre a usar la región de bloques de información.';
$string['marketingdesc'] = 'Hay dos cuadros de información de ancho completo con diferentes estilos que puedes usar.<br>Además de esto, hay un generador de diseño que te permite decidir cuántos bloques necesitas y definir tu propio diseño.<br>Consulta la sección "Léame" en la pestaña de configuración "Información" para obtener información adicional.';
$string['marketingsettings'] = 'Bloques promocionales';
$string['marketingsettingsheading'] = 'Personalizar los bloques promocionales que aparecen en la Portada.';
$string['marketingvisible'] = 'Mostrar los bloques de anuncios cuando';
$string['marketingvisibledesc'] = 'Mostrar los bloques de anuncios cuando \'Salió del sitio\', Ingresado\' o \'Ingresado o Salió\'.';
$string['marketingvisibleloggedin'] = 'Ingresado';
$string['marketingvisibleloggedinout'] = 'Ingresado o Salió';
$string['marketingvisibleloggedout'] = 'Salió del sitio';
$string['marketlayoutrow'] = 'Fila de Bloque Promocional';
$string['marketlayoutrowdesc'] = 'Añadir / configurar diseño para la fila de bloques promocionales en la Portada';
$string['menubkcolor'] = 'Color de fondo del menú principal';
$string['menubkcolordesc'] = 'Establecer el color de fondo del menú principal.';
$string['menubkhovercolor'] = 'Color al pasar ratón encima del fondo del menú principal';
$string['menubkhovercolordesc'] = 'Configurar un color al pasar ratón encima del fondo del menú principal';
$string['menubordercolor'] = 'Color del borde del fondo del menú principal';
$string['menubordercolordesc'] = 'Establece el color del borde del fondo del menú principal.';
$string['menufontcolor'] = 'Color de texto del menú principal';
$string['menufontcolordesc'] = 'Establecer el color del texto del menú principal.';
$string['menufonthovercolor'] = 'Color al pasar ratón encima del menú principal';
$string['menufonthovercolordesc'] = 'Configurar el color al pasar ratón encima del menú principal';
$string['menufontpadding'] = 'Separación para elementos de navegación';
$string['menufontpaddingdesc'] = 'Configurar la separación o de los ítems en la Barra de Navegación principal.';
$string['menufontsize'] = 'Tamaño de fuente de la barra de navegación';
$string['menufontsizedesc'] = 'Establece el tamaño de fuente de la barra de navegación.';
$string['menuoverrideprofilefield'] = 'Nombre del campo personalizado del perfil';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'El nombre del campo de perfil personalizado "list" usado por la anulacion por usuario.';
$string['menusdesc'] = '';
$string['menusession'] = 'Almacenar los detalles de acceso en la sesión';
$string['menusessiondesc'] = 'Por razones de rendimiento, se recomienda habilitar esta opción. Es posible que desees deshabilitarla durante las pruebas.';
$string['menusessionttl'] = 'Tiempo (minutos) de almacenamiento del acceso a los menús por sesión';
$string['menusessionttldesc'] = 'Número de minutos antes de reiniciar la sesión.';
$string['menusettings'] = 'Menús de cabecera';
$string['menusettingsheading'] = 'Personaliza los menús de la cabecera superior.';
$string['menusheading'] = 'Configurar Navegación para los menús de enlace en el encabezado superior..';
$string['menusheadingvisibility'] = 'Configuraciones generales para la visibilidad del menú superior';
$string['menusheadingvisibilitydesc'] = 'Las siguientes configuraciones le permiten controlar dónde aparecen los menús y, opcionalmente, permiten a los usuarios personalizar sus configuraciones.';
$string['menuslinkicon'] = 'Ícono del menú de enlaces';
$string['menuslinkicondesc'] = 'Elegir un ícono del font Awesome.';
$string['menuslinkright'] = 'Mostrar enlace a menús en parte superior derecha';
$string['menuslinkrightdesc'] = 'Si se activa, mostrar el enlace hacia los menús en la parte superior derecha junto al menú de mensajes.';
$string['menustitledesc'] = 'Los Menús superiores pueden estar restringidos basados en campos personalizados del perfil (opcional). Para añadir una restricción, escriba el nombre del campo del perfil y el valor esperado.';
$string['menuuseroverride'] = 'Permitir la anulación por usuario';
$string['menuuseroverridedesc'] = 'Estas configuraciones se pueden usar para dar a los usuarios control sobre dónde aparecen los menús a través de un campo de perfil personalizado. Para usar esta opción, deberá crear un campo de perfil personalizado en formato de "lista" con valores en el orden correspondiente:<br/><pre>1. En todo el sitio (el primer elemento de la lista será para la visibilidad del menú en todo el sitio)
2. Solo páginas de inicio (el segundo elemento de la lista establecerá la visibilidad solo para el sitio/páginas de inicio)
3. Oculto (el tercer valor de la lista ocultará los menús por completo)</pre>
NO debe usar la opción "Deshabilitar menús en páginas de cursos" junto con las configuraciones del campo de perfil, en su lugar, establezca el valor predeterminado en su entrada "Solo páginas de inicio" al configurar su lista de campos de perfil.

Nota: Los usuarios deberán cerrar sesión en Moodle y volver a iniciarla para que este cambio surta efecto; es posible que desee agregar una nota que explique esto en el campo de perfil personalizado.';
$string['messagepopupbackground'] = 'Color del fondo de mensajes emergentes';
$string['messagepopupbackgrounddesc'] = 'Configurar el color del fondo de encabezado de mensajes emergentes.';
$string['messagepopupcolor'] = 'Color del texto de mensaje emergente';
$string['messagepopupcolordesc'] = 'Seleccionar el color del encabezado del mensaje emergente.';
$string['messagingbackgroundcolor'] = 'Color del fondo de ventana principal de mensajes';
$string['messagingbackgroundcolordesc'] = 'Configurar el color del fondo de ventana principal de mensajes';
$string['mobilemenubkcolor'] = 'Color de fondo del menú para móvil';
$string['mobilemenubkcolordesc'] = 'Establece el color de fondo del menú principal en dispositivos móviles (colapsado).';
$string['mobileprimarynav'] = 'Navegación móvil primaria';
$string['mobileprimarynavdesc'] = 'Habilitar o deshabilitar. Nota: Este es el menú controlado por el ícono de la hamburguesa';
$string['moodledocs'] = 'Enlace a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar enlace a Moodle Docs en el pie de página.';
$string['more'] = 'Más';
$string['myblogs'] = 'Mis blogs';
$string['mycoursesmenulimit'] = 'Límite de Menú de Mis Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajustar el número máximo de cursos que aparecen en el menú desplegable de Mis Cursos. 0 mostrará todos los cursos.';
$string['mysites'] = 'Mis cursos';
$string['mysitesdisabled'] = 'Deshabilitar';
$string['mysitesexclude'] = 'Habilitar excluir cursos ocultos';
$string['mysitesinclude'] = 'Habilitar incluir cursos ocultos';
$string['mysitesmaxlength'] = 'Longitud Máxima de Mis Cursos';
$string['mysitesmaxlengthdesc'] = 'Ajuste la longitud máxima de coursenames (nombres_de_los_cursos) en el desplegable de Mis Cursos para optimizar su tipo de letra (font).';
$string['mysitesmenudisplay'] = 'Mostrar Menú de Mis Cursos';
$string['mysitesmenudisplaydesc'] = 'Elegir cual texto a mostrar para un ítem del menú y al pasarle el ratón encima.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar título completo del curso y título completo al pasar el ratón encima.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar título completo del curso y sin texto al pasar el ratón encima.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código corto y nombre completo del curso al pasar el ratón encima.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar código corto y sin texto al pasar el ratón encima.';
$string['mysitessortoverride'] = 'Ordenación personalizada de mis cursos';
$string['mysitessortoverridedesc'] = 'Utilice campos de perfil personalizados o cadenas genéricas (año, etc.) para contraer cursos anteriores en el submenú.';
$string['mysitessortoverridefield'] = 'Campo(s) Personalizado del Perfil o Cadenas de Caracteres de Mis Cursos';
$string['mysitessortoverridefielddesc'] = 'Lista delimitada por comas de campos de perfil o cadenas para verificar en los códigos cortos del curso.';
$string['mysitessortoverridelast'] = 'Hora de último acceso o la hora de inicio de inscripción si nunca fue accesado';
$string['mysitessortoverridemyoverview'] = 'Usar lista de mi Vista general';
$string['mysitessortoverrideoff'] = 'Mostrar todos los cursos inscritos en lista plana única';
$string['mysitessortoverrideprofilefields'] = 'Mostrar cursos encontrados en campos de perfil en la lista primeramente, los demás en sub-menú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Mostrar cursos encontrados en campos de perfil + cohortes enlista primeramente, los demás en sub-menú';
$string['mysitessortoverridestrings'] = 'Mostrar inscritos que contengan cadenas de caracteres primeramente en lista, otros en sub-menú';
$string['navbarcachetime'] = 'Tiempo de Caché de Barra-de-Navegación';
$string['navbarcachetimedesc'] = 'El número de minutos que es cacheada la Barra-de-navegación';
$string['navbardesc'] = 'Controlar los diferentes elementos a mostrar en la barra de navegación.';
$string['navbardisplayicons'] = 'Mostrar íconos';
$string['navbardisplayiconsdesc'] = 'Muestra un icono junto al título del menú. Nota: Esto se ignora cuando no se configura "custommenutitle" para el menú personalizado.';
$string['navbardisplaymenuarrow'] = 'Flecha del menú de visualización';
$string['navbardisplaymenuarrowdesc'] = 'Muestra la flecha del menú (hacia abajo) para el título del menú.';
$string['navbardisplaytitles'] = 'Mostrar títulos';
$string['navbardisplaytitlesdesc'] = 'Muestra el título del menú. Notas: Se ignora cuando no se configura "navbardisplayicons" y también se ignora cuando no se configura "custommenutitle" para el menú personalizado.';
$string['navbardropdownborderradius'] = 'Radio del borde del menú desplegable';
$string['navbardropdownborderradiusdesc'] = 'Controla el radio del borde para los menúes desplegables (por ejemplo las esquinas redondeadas).';
$string['navbardropdownhovercolor'] = 'Color del fondo del menú desplegable al pasar el ratón encima';
$string['navbardropdownhovercolordesc'] = 'Color del fondo del menú desplegable al pasar el ratón encima sobre de ítems del menú.';
$string['navbardropdowntextcolor'] = 'Color del texto del menú desplegable';
$string['navbardropdowntextcolordesc'] = 'Color del texto de ítem del menú desplegable';
$string['navbardropdowntexthovercolor'] = 'Color al pasar el ratón encima para texto del menú desplegable';
$string['navbardropdowntexthovercolordesc'] = 'Color del texto del menú desplegable al pasar el ratón encima de ítems del menú.';
$string['navbardropdowntransitiontime'] = 'Tiempo de transición de Barra de Navegación';
$string['navbardropdowntransitiontimedesc'] = 'Tiempo de efecto de transiciónde Barra de Navegación. Proporciona un efecto de animación de desvanecimiento al pasar el ratón encima sobre un menú que tenga sub-menúes.';
$string['navbarlinksettingsdesc'] = 'Le permite controlar los enlaces que aparecen en la barra de navegación.';
$string['navbarlinksettingsheading'] = 'Personalizar los enlaces en la barra de navegación';
$string['navbarlinkssettings'] = 'Enlaces de Barra de Navegación';
$string['navbarmycourses'] = 'Barra de Navegación de mis cursos.';
$string['navbarsettings'] = 'Barra de Navegación';
$string['navbarsettingsheading'] = 'Personalizar la barra de navegación';
$string['navbarstyles'] = 'Estilos de Barra de Navegación';
$string['navbarstylesdesc'] = 'Le permite controlar los estilos de los elementos que aparecen en la barra de navegación.';
$string['navbarstylesheading'] = 'Personalizar los estilos de la barra de navegación';
$string['navbaruserfavtoolsmenus'] = 'Menús de herramientas y favoritos del usuario de la barra de navegación';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenudesc'] = 'Configurar los enlaces mostrados bajo el menú de la cabecera superior.';
$string['newmenufield'] = 'Campo Personalizado  del Perfil Nombre=Valor (opcional)';
$string['newmenufielddesc'] = 'Añade una regla de acceso para campo personalizado del perfil. Ejemplo: usertype=student';
$string['newmenuheading'] = 'Menú superior';
$string['newmenurequirelogin'] = 'Requiere Ingresar';
$string['newmenurequirelogindesc'] = 'Si está activado este menú solamente será visible a los usuarios ingresados al sitio';
$string['newmenutitle'] = 'Título menú superior';
$string['newmenutitledefault'] = 'Menú';
$string['newmenutitledesc'] = 'El título de la lista del menú aparecerá en el encabezado de su sitio.';
$string['newstickercount'] = 'Número de secciones en el tablón de avisos';
$string['newstickercountdesc'] = 'Define múltiples secciones del tablón de avisos con reglas de acceso para dirigirse a diferentes audiencias.';
$string['newstickersettings'] = 'Tablón de avisos';
$string['nextactivity'] = 'Actividad siguiente';
$string['nextsection'] = 'Sección siguiente';
$string['noenrolments'] = 'No se encontraron inscripciones';
$string['none'] = 'Ninguno';
$string['normal'] = 'Ancho fijo';
$string['nostyle'] = 'Sin estilo';
$string['notbadgebackgroundcolour'] = 'Color del fondo de insignia de notificaciones';
$string['notbadgebackgroundcolourdesc'] = 'Configurar el color del fondo para insignia de notificaciones / burbuja en el encabezado (muestra el número de notificaciones sin leer)';
$string['notbadgecolour'] = 'Color de insignia de notificaciones';
$string['notbadgecolourdesc'] = 'Configurar el color de insignia de notificaciones / burbuja en el encabezado (muestra el número de notificaciones sin leer)';
$string['onetopicactivetabbackgroundcolor'] = 'Color del fondo de pestaña activa';
$string['onetopicactivetabbackgroundcolordesc'] = 'El Color del fondo de la pestaña activa en un curso de \'Un Tópico\'.';
$string['onetopicactivetabtextcolor'] = 'Color del texto de pestaña activa';
$string['onetopicactivetabtextcolordesc'] = 'El Color del texto de la pestaña activa en un curso de \'Un Tópico\'.';
$string['onetopicdesc'] = 'Personalice la apariencia del \'<a href="{$a}" target="_blank">Formato de curso de un tema</a>\' (si se usa en su sitio).';
$string['onetopicheading'] = 'Un Tópico';
$string['originaltemplatepreview'] = 'Previsualización del archivo del tema Original / anulado';
$string['originaltemplatesource'] = 'Origen del archivo del tema Original / anulado';
$string['orphanedblock'] = '<em>BLOQUE HUÉRFANO- Originalmente se muestra en: <strong>{$a}</strong></em>';
$string['overriddentemplate'] = 'Plantilla anulada: {$a}';
$string['overriddentemplatedesc'] = 'Si se activa, entonces el texto de aquí será usado como la plantilla \'{$a}\'.  Para asegurar que la previsualización funcione, necesita estar el contexto del ejemplo estándar en formato JSON.';
$string['overriddentemplatenopreview'] = 'No hay vista previa porque falta ejemplo JSON';
$string['overriddentemplatepreview'] = 'Configurando previsualización anulada';
$string['overridetemplate'] = 'Anular plantilla: {$a}';
$string['pageheaderalternative'] = 'Alternativo';
$string['pageheaderheight'] = 'Altura del encabezado de página';
$string['pageheaderheightdesc'] = 'Establezca la altura del área del encabezado principal (que contiene el logotipo y los títulos).';
$string['pageheaderlayout'] = 'Encabezado uno, diseño del encabezado de página';
$string['pageheaderlayoutdesc'] = 'El diseño del encabezado de página para el estilo uno de encabezado.';
$string['pageheaderlayouttwo'] = 'Encabezado dos, diseño de encabezado de página';
$string['pageheaderlayouttwodesc'] = 'El diseño de encabezado de página para el estilo dos de encabezado.';
$string['pageheadernosearch'] = 'Sin búsqueda';
$string['pageheaderoriginal'] = 'Original';
$string['pageloadingprogress'] = 'Progreso de carga de la página';
$string['pageloadingprogressdesc'] = 'Mostrar el pogreso de carga de la página.';
$string['pageloadingprogresstheme'] = 'Tema de carga de página';
$string['pageloadingprogressthemebarbershop'] = 'Peluquería';
$string['pageloadingprogressthemebigcounter'] = 'Gran mostrador';
$string['pageloadingprogressthemebounce'] = 'Rebote';
$string['pageloadingprogressthemecenteratom'] = 'Átomo central';
$string['pageloadingprogressthemecentercircle'] = 'Círculo central';
$string['pageloadingprogressthemecenterradar'] = 'Radar central';
$string['pageloadingprogressthemecentersimple'] = 'Simple central';
$string['pageloadingprogressthemecornerindicator'] = 'Indicador de esquina';
$string['pageloadingprogressthemedesc'] = 'Configurar el tema de carga de la página.';
$string['pageloadingprogressthemefillleft'] = 'LLenar izquierda';
$string['pageloadingprogressthemeflash'] = 'Destello';
$string['pageloadingprogressthemeflattop'] = 'Parte superior plana';
$string['pageloadingprogressthemeloadingbar'] = 'Barra de carga';
$string['pageloadingprogressthememacosx'] = 'Mac OSX';
$string['pageloadingprogressthememinimal'] = 'Mínima';
$string['passwordplaceholder'] = 'Contraseña';
$string['past'] = 'Pasado';
$string['pastcourses'] = 'Cursos anteriores';
$string['people'] = 'Participantes';
$string['piwikenabled'] = 'Habilitado';
$string['piwikenableddesc'] = 'Habilitar monitoreo Matomo para Moodle';
$string['piwikimagetrack'] = 'Monitoreo de imagen';
$string['piwikimagetrackdesc'] = 'Habilitar Monitoreo de Imagen para Moodle para los navegadores con JavaScript deshabilitado.';
$string['piwiksettings'] = 'Análisis Matomo (anteriormente Piwik)';
$string['piwiksettingsdesc'] = 'Generar URL limpia para monitoreo avanzado.';
$string['piwiksettingsheading'] = 'Configurar Matomo';
$string['piwiksiteid'] = 'ID del sitio';
$string['piwiksiteiddesc'] = 'Ingrese su ID del sitio';
$string['piwiksiteurl'] = 'URL de Matomo';
$string['piwiksiteurldesc'] = 'Ingrese su URL de Matomo Analytics sin  http(s) ni la diagonal final.';
$string['piwiktrackadmin'] = 'Monitoreando admins';
$string['piwiktrackadmindesc'] = 'Habilitar monitoreo de usuarios admins (no recomendado)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Retrato';
$string['previousactivity'] = 'Actividad anterior';
$string['previoussection'] = 'Sección anterior';
$string['primarycolour'] = 'Color primario';
$string['primarycolourdesc'] = 'Configurar el color primario. este es el color \'primario\' de Bootstrap que es usado dentro del SCSS.';
$string['printbodyfontsize'] = 'Tamaño del tipo de letra (font) del cuerpo (body)';
$string['printbodyfontsizedesc'] = 'Configurar el tamaño del ipo de letra (font) del cuerpo (body).';
$string['printlineheight'] = 'Altura de línea';
$string['printlineheightdesc'] = 'Configurar la altura de la línea';
$string['printmargin'] = 'Márgen';
$string['printmargindesc'] = 'Configurar el márgen';
$string['printpageorientation'] = 'Orientación de la página';
$string['printpageorientationdesc'] = 'Configurar la orientación de la página a \'Retrato\' o \'Paisaje\'.';
$string['printsettings'] = 'Imprimir';
$string['printsettingsdesc'] = 'Configurar las configuraciones para imprimir.';
$string['printsettingsheading'] = 'Configuraciones para imprimir';
$string['privacy:closed'] = 'Cerrado';
$string['privacy:fullin'] = 'Lleno en';
$string['privacy:metadata:preference:collapseblock'] = 'El estado del índice de los bloques en una página.';
$string['privacy:metadata:preference:draweropenblock'] = 'El estado del índice del cajón de navegación.';
$string['privacy:metadata:preference:draweropenindex'] = 'El estado del índice del curso.';
$string['privacy:metadata:preference:themeadaptablealertkey'] = 'La alerta dada.';
$string['privacy:metadata:preference:themeadaptablefull'] = 'El estado de la pantalla completa.';
$string['privacy:metadata:preference:themeadaptablezoom'] = 'El estado del zoom.';
$string['privacy:nofull'] = 'No lleno';
$string['privacy:note'] = 'Nota: El tema Adaptable tiene ajustes que tiene que ver con su configuración. Las configuraciones específicas para el usuario descritas en el \'Registro de privacidad del plugin\' y cuando es instalado, también serán para el plugin local Adaptable. Para las otras configuraciones, es responsabilidad de usted asegurarse de que ningún  dato del usuario sea introducido dentro de los campos para texto libre. Al configurar una configuración resultará en que esa acción se registre dentro del sistema de las bitácoras de Moodle contra el usuario que hizo el cambio, lo cual está fuera del control de los temas; por favor vea el sistema central de bitácoras para cumplir con la privacidad al respecto. Al subir imágenes, usted debería evitar subir imágenes con datos de ubicación incluidos (EXIF GPS) o cualquier otro dato personal de las imágenes. Sería posible extraer datos personales y d elocalización desde las imágenes. Por favor examine el código cuidadosamente para asegurarse de que cumple con su interpretación de sus leyes de privacidad. Yo no soy abogado y mi análisis está basado en mi interpretación. Si tiene cualquier duda, quite el tema.';
$string['privacy:open'] = 'Abierto';
$string['privacy:request:preference:collapseblock'] = 'La preferencia del usuario "{$a->name}" for block id "{$a->blockid}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del bloque.';
$string['privacy:request:preference:draweropenblock'] = 'La preferencia del usuario "{$a->name}" for block id "{$a->blockid}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del cajón del bloque.';
$string['privacy:request:preference:draweropenindex'] = 'La preferencia del usuario "{$a->name}" for block id "{$a->blockid}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del índice del curso.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'La preferencia del usuario "{$a->name}" para alerta con ID "{$a->alertid}" tiene el valor "{$a->value}" para la alerta dada, \'no descartable\' o cualquier otra clave de alerta (\'alertkey\') representando que la alerta existió para el usuario.';
$string['privacy:request:preference:themeadaptablefull'] = 'La preferencia del usuario "{$a->name}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del zoom.';
$string['privacy:request:preference:themeadaptablezoom'] = 'La preferencia del usuario "{$a->name}" tiene el valor "{$a->value}" que representa "{$a->decoded}" para el estado del zoom.';
$string['properties'] = 'Configuraciones para Importar / Exportar';
$string['propertiesdesc'] = 'En esta sección Usted puede importar las configuraciones (propiedades) actuales del tema Adaptable  en formato JSON. También puede Usted ver todas las configuraciones actuales en esta intalación Moodle.';
$string['propertiesexport'] = 'Exportar propiedades sin archivos<br>como una cadena de caracteres JSON';
$string['propertiesexportfilestoo'] = 'Exportar propiedades con archivos<br>como una cadena de caracteres  JSON';
$string['propertiesexportfilestoofile'] = 'Exportar propiedades con archivos<br>como una cadena de caracteres  JSON';
$string['propertiesexportfilestoofilefail'] = 'Propiedades máximas con archivos como un archivo JSON alcanzadas. Por favor elimine una o más.';
$string['propertiesexportfilestoofilehelp'] = 'Después de exportar, descargue el archivo JSON generado con la fecha y hora actuales desde la configuración \'propertyfiles\' y cárguelo en la configuración \'fileputprops\' en la instalación de destino y haga clic en \'Guardar cambios\'. Luego se generará un informe y se colocará en la configuración \'putprops\'.';
$string['propertiesexportfilestoofilesuccess'] = 'Propiedades con archivos como un archivo JSON exportado como {$a}.';
$string['propertiesexportfilestoohelp'] = 'Después de exportar, copie el JSON de la pantalla y péguelo en la configuración \'putprops\' (después de borrarla) en la instalación de destino y haga clic en \'Guardar cambios\'. Luego se generará un informe y se colocará en la configuración \'putprops\'.';
$string['propertiesexporthelp'] = 'Después de exportar, copie el JSON de la pantalla y péguelo en la configuración \'putprops\' (después de borrarlo) en la instalación de destino y haga clic en \'Guardar cambios\'. Luego se generará un informe y se colocará en la configuración \'putprops\'. Enumerará todas las configuraciones de archivo que necesitan que sus archivos se transfieran manualmente.';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Retornar';
$string['propertiessub'] = 'Configuraciones actuales del tema';
$string['propertiesvalue'] = 'Valor';
$string['propertyfileadded'] = 'Archivo \'{$a->filename}\' añadido a configuración \'{$a->settingname}\'.';
$string['propertyfileremoved'] = 'Archivo \'{$a->filename}\' quitado de configuración \'{$a->settingname}\'.';
$string['propertyfiles'] = 'Archivos de propiedad';
$string['propertyfilesdesc'] = 'Cuando el máximo es alcanzado no se añadirán más hasta que uno o más sean eliminados.';
$string['putpropertiesadded'] = 'Añadido:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegar la cadena de caracteres JSON y \'Guardar cambios\'. Advertencia: No valida los valores de configuraciones y realiza un proceso de \'Purgar todas las cachés\'.';
$string['putpropertiesfiledesc'] = 'Arrastre y suelte o cargue el archivo JSON y seleccione \'Guardar cambios\'. ¡Atención! No valida los valores de configuración y realiza una \'Purga de todos los cachés\'. El informe estará en \'putprops\'.';
$string['putpropertiesfilename'] = 'Importar propiedades desde un archivo';
$string['putpropertiesfrom'] = 'desde';
$string['putpropertiesheading'] = 'Importar configuraciones del tema';
$string['putpropertiesignorecti'] = 'Ignorando todas las configuraciones de imagen del título del curso.';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Importar propiedades';
$string['putpropertiesreportfiles'] = 'Recuerde subir los siguientes archivos a sus configuraciones:';
$string['putpropertiesreportfileschanged'] = 'Archivos cambiados:';
$string['putpropertiessettingsreport'] = 'Reporte de configuraciones:';
$string['putpropertiesunchanged'] = 'Sin-cambios:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestra(s)';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'Reporte:';
$string['putpropertyversion'] = 'versión:';
$string['region-content'] = 'Contenido';
$string['region-course-bottom-a'] = 'Botón de página de curso región 5';
$string['region-course-bottom-b'] = 'Botón de página de curso región 6';
$string['region-course-bottom-c'] = 'Botón de página de curso región 7';
$string['region-course-bottom-d'] = 'Botón de página de curso región 8';
$string['region-course-section-a'] = 'Región del fondo de fin de actividad de página del curso';
$string['region-course-tab-one-a'] = 'Región 1 de pestaña de página de curso';
$string['region-course-tab-two-a'] = 'Región 2 de pestaña de página de curso';
$string['region-course-top-a'] = 'Región superior de página de curso 1';
$string['region-course-top-b'] = 'Región superior de página de curso 2';
$string['region-course-top-c'] = 'Región superior de página de curso 3';
$string['region-course-top-d'] = 'Región superior de página de curso 4';
$string['region-frnt-footer'] = 'Pie';
$string['region-frnt-market-a'] = 'Región de página uno';
$string['region-frnt-market-b'] = 'Región de página dos';
$string['region-frnt-market-c'] = 'Región de página tres';
$string['region-frnt-market-d'] = 'Región de página cuatro';
$string['region-frnt-market-e'] = 'Región de página cinco';
$string['region-frnt-market-f'] = 'Región de página seis';
$string['region-frnt-market-g'] = 'Región de página siete';
$string['region-frnt-market-h'] = 'Región de página ocho';
$string['region-frnt-market-i'] = 'Región de página nueve';
$string['region-frnt-market-j'] = 'Región de página diez';
$string['region-frnt-market-k'] = 'Región de página once';
$string['region-frnt-market-l'] = 'Región de página doce';
$string['region-frnt-market-m'] = 'Región de página trece';
$string['region-frnt-market-n'] = 'Región de página catorce';
$string['region-frnt-market-o'] = 'Región de página quince';
$string['region-frnt-market-p'] = 'Región de página dieciseis';
$string['region-frnt-market-q'] = 'Región de página diecisiete';
$string['region-frnt-market-r'] = 'Región de página dieciocho';
$string['region-frnt-market-s'] = 'Región de página diecinueve';
$string['region-frnt-market-t'] = 'Región de página viente';
$string['region-information'] = 'Información';
$string['region-my-tab-one-a'] = 'Región uno de pestaña de página de Tablero';
$string['region-my-tab-two-a'] = 'Región dos de pestaña de página de Tablero';
$string['region-news-slider-a'] = 'Región del delizador de página de curso';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['regionmaincolor'] = 'Color de región principal';
$string['regionmaincolordesc'] = 'Configurar el color de fondo para el área principal de contenido';
$string['regionmaintextcolor'] = 'Color del texto de región principal';
$string['regionmaintextcolordesc'] = 'Configurar el color del texto para el área de contenido principal.';
$string['rendereroverlaycolor'] = 'Color superpuesto';
$string['rendereroverlaycolordesc'] = 'El color superpuesto sobre el bloque de curso cuando "Mosaicos Superpuestos" está seleccionado.';
$string['rendereroverlayfontcolor'] = 'Color de texto en la superposición';
$string['rendereroverlayfontcolordesc'] = 'El color de la fuente cuando pasa el cursor por encima del bloque del curso y "Mosaicos Superpuestos" está activado.';
$string['responsivebreadcrumb'] = 'Navegación con pista de migas';
$string['responsivebreadcrumbdesc'] = '¿En cual tamaño de pantallas ter gustaría que se mostrara la Navegación de la ruta de navegación?';
$string['responsivecoursetitle'] = 'Título del curso / sitio';
$string['responsivecoursetitledesc'] = 'DEPRECADO, use \'responsivesitetitle\' en su lugar.';
$string['responsiveheader'] = 'Encabezado principal';
$string['responsiveheaderdesc'] = '¿En qué tamaño de pantalla le gustaría que se muestre el encabezado principal?<br/>Si elimina el encabezado por completo, también se eliminarán los elementos que contiene:<br/><ul><li>Íconos sociales</li><li>Logotipo</li><li>Título del sitio/curso</li></ul>';
$string['responsiveheadertitle'] = 'Título del encabezado';
$string['responsiveheadertitledesc'] = '¿En cuáles tamaños de pantallas le gustaría que se mostrara el título del encabezado?';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = '¿En cuales tamaños de pantallas quiere Usted que se muestre el logo?';
$string['responsivepagefooter'] = 'Pie de Página';
$string['responsivepagefooterdesc'] = '¿En cuales tamaños de pantallas quiere Usted que se muestre el Pie de página?';
$string['responsivesectionnav'] = 'Navegación de Actividad / Sección';
$string['responsivesectionnavdesc'] = 'Mostrar u ocultar el <strong>texto</strong> de la navegación de la sección o actividad "anterior" o "siguiente" en pantallas pequeñas. De manera predeterminada, ocultamos este texto en pantallas más pequeñas, de modo que solo se muestran los íconos de los enlaces <anterior> y <siguiente> y no el nombre completo de la sección o actividad.';
$string['responsivesettings'] = 'Diseño responsivo';
$string['responsivesettingsdesc'] = 'Aquí puede controlar el comportamiento responsivo de su sitio (qué elementos aparecen en pantallas de diferentes tamaños). De forma predeterminada, la mayoría de los elementos no esenciales están ocultos en los dispositivos móviles y se configuran para que aparezcan solo en pantallas más grandes. Puede hacer que los elementos aparezcan en pantallas más pequeñas eligiendo mostrarlos en pantallas "Extra pequeñas" o "Pequeñas". Para comprender mejor cómo funcionan estas configuraciones, consulte la documentación de la propiedad de visualización de Bootstrap.';
$string['responsivesettingsheading'] = 'Controlar como se porta su sitio en diferentes tamaños de pantalla';
$string['responsivesitetitle'] = 'Título del sitio';
$string['responsivesitetitledesc'] = 'DEPRECADO, use \'responsiveheadertitle\' en su lugar.';
$string['responsiveslider'] = 'Deslizador de Portada';
$string['responsivesliderdesc'] = '¿De qué tamaño quiere que se muestre el Deslizador de Portada?';
$string['responsivesocial'] = 'Íconos sociales';
$string['responsivesocialdesc'] = '¿De qué tamaño quiere que se muestren los íconos sociales?';
$string['responsivesocialsize'] = 'Configurar tamaño del font de los íconos sociales en Mobile';
$string['responsivesocialsizedesc'] = 'Para una mejor vista, el tamaño necesita ser 5 pixeles mayor que el tamaño actual deseado.';
$string['responsiveticker'] = 'Mostrador de Noticias';
$string['responsivetickerdesc'] = '¿De qué tamaño quiere que sean las pantallas donde se muestra el Mostrador de Noticias?';
$string['rightblocks'] = 'Lado derecho';
$string['savebuttontext'] = 'Guardar cambios';
$string['searchboxpadding'] = 'Relleno del cuadro de búsqueda del encabezado';
$string['searchboxpaddingdesc'] = 'Establezca el relleno para el cuadro de búsqueda cuando esté en el encabezado (si se usa en lugar de íconos sociales) <br />Por ejemplo, 5px 10px 5px 10px (arriba, derecha, abajo, izquierda).<br> Puede configurar íconos sociales en la página de configuración <a href="./../admin/settings.php?section=theme_adaptable_social">Encabezado Social</a></strong>.';
$string['secondarycolour'] = 'Color secundario';
$string['secondarycolourdesc'] = 'Configurar el color secundario. Este es el color \'secundario\' de Bootstrap que es usado dentro del SCSS.';
$string['sectionheadingcolor'] = 'Color de texto del encabezado de sección';
$string['sectionheadingcolordesc'] = 'Establece el color de texto del encabezado de sección.';
$string['sections'] = 'Secciones';
$string['selectionbackground'] = 'Color de fondo de selección';
$string['selectionbackgrounddesc'] = 'Configurar el color del fondo cuando es seleccionado un texto en la pantalla.';
$string['selectiontext'] = 'Color de texto de selección';
$string['selectiontextdesc'] = 'Configurar el color del texto cuando es seleccionado un texto en la pantalla.';
$string['settingsalertbox'] = 'Caja de alerta';
$string['settingsanalytics'] = 'Análisis';
$string['settingsblockicons'] = 'Íconos';
$string['settingsblocksconfiguration'] = 'Configuración';
$string['settingsborders'] = 'Bordes';
$string['settingsbreadcrumbcolors'] = 'Colores de la Ruta de Navegación';
$string['settingscolors'] = 'Colores';
$string['settingscourses'] = 'Cursos';
$string['settingsfonts'] = 'Tipos de letras (fonts)';
$string['settingsfootercolors'] = 'Colores del pie de página';
$string['settingsforumheading'] = 'Foro';
$string['settingsheadercolors'] = 'Colores de cabecera';
$string['settingsinfoboxcolors'] = 'Colores de caja informativa';
$string['settingsinformation'] = 'Información';
$string['settingsmaincolors'] = 'Colores principales';
$string['settingsmarketingcolors'] = 'Colores del bloque publicitario';
$string['settingsmessagescolors'] = 'Colores de mensajes emergentes';
$string['settingsmobilecolors'] = 'Colores Mobile';
$string['settingsnavbarcolors'] = 'Colores de la Barra de Navegación (navbar)';
$string['settingsoverlaycolors'] = 'Colores de mosaicos sobepuestos';
$string['settingspagealertsettings'] = 'Alertas';
$string['settingspageblocksettings'] = 'Bloque';
$string['settingspagefrontpageblockregionsettings'] = 'Generador de regiones de bloques de la página de inicio';
$string['settingspagegeneralsettings'] = 'General';
$string['settingssecondinfoboxcolors'] = 'Colores de caja informativa secundaria';
$string['settingstopicsweeks'] = 'Tópicos / semanas';
$string['show'] = 'Mostrar';
$string['showfooterblocks'] = 'Mostrar bloques en el pie de página';
$string['showfooterblocksdesc'] = 'Mostrar / ocultar los bloques de pie de página configurables.';
$string['shownavigationblockoncoursepage'] = 'Mostrar Bloque de Navegación en página del curso';
$string['shownavigationblockoncoursepagedesc'] = 'Activar esto para mostrar el bloque de navegación en la página del curso.';
$string['showusername'] = 'Mostrar nombre_de_usuario';
$string['showusernamedesc'] = 'Mostrar el nombre_de_usuario en el menú del usuario en la barra de navegación.';
$string['side-post1'] = 'Barra lateral en pie de página';
$string['sidebaricon'] = 'Mostrar / ocultar la barra lateral';
$string['sitelinkslabel'] = 'Enlaces del sitio';
$string['sitetitle'] = 'Mostrar título del sitio';
$string['sitetitlecoursesdisabled'] = 'Deshabilitado - mostrar solamente títulos de curso en páginas de cursos';
$string['sitetitlecoursesenabled'] = 'Habilitado -  mostrar título del sitio y títulos de cursos en páginas de curso';
$string['sitetitlecustom'] = 'Usar título personalizado del sitio (escribir en el campo inferior \'sitetitletext\')';
$string['sitetitledefault'] = 'Usar el título del sitio Moodle (nombre del sitio)';
$string['sitetitledesc'] = 'Mostrar el título del sitio Moodle por defecto desde  <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Configuraciones de Página de Portada</a> o ingresar un título personalizado del sitio en la caja de texto inferior.';
$string['sitetitleoff'] = 'Deshabiliar el título del sitio';
$string['sitetitletext'] = 'Título del sitio';
$string['sitetitletextdesc'] = 'El título del sitio mostrado en la cabecera. Usted puede usar cualquier tag (marca) HTML y aplicar estilos en-línea. Se recomienda que añada una marca HTML h1 alrededor del título, en lugar de la marca p que es añadida por defecto cuando Usted escribe algo en este campo.';
$string['skipblock'] = 'Saltar bloque {$a}';
$string['slider2h3bgcolor'] = 'Color del fondo del deslizador dos H3';
$string['slider2h3bgcolordesc'] = 'Elegir el color del fondo que desee para la marca del deslizador dos H3.';
$string['slider2h3color'] = 'Color del texto del deslizador dos H3';
$string['slider2h3colordesc'] = 'Elija el color del texto que desee para la marca del deslizador dos H3.';
$string['slider2h4bgcolor'] = 'Color del Fondo Deslizador dos H4';
$string['slider2h4bgcolordesc'] = 'Elija el color del fondo que desee para la marca del deslizador dos H4.';
$string['slider2h4color'] = 'Color del Texto Deslizador dos H4';
$string['slider2h4colordesc'] = 'Elija el color del texto que desee para la marca del deslizador dos H4.';
$string['slidercaption'] = 'Subtítulo del deslizador';
$string['slidercaptiondesc'] = 'Añada un subttítulo para su diapositiva';
$string['slidercount'] = 'Número de deslizadores';
$string['slidercountdesc'] = 'Seleccione cuántas diapositivas desea agregar y luego haga clic en GUARDAR para cargar los campos de entrada.';
$string['sliderenabled'] = 'Habilitar deslizador';
$string['sliderenableddesc'] = 'Habilitar un deslizador en la parte superior de su página inicial';
$string['sliderfullscreen'] = 'Presentación de diapositivas en ancho completo';
$string['sliderfullscreendesc'] = 'Active esta casilla para hacer el deslizador de pantalla completa (100% ancho)';
$string['sliderh3color'] = 'Color de H3 del deslizador uno';
$string['sliderh3colordesc'] = 'Elegir el color que desea para la marca H3 del deslizador uno.';
$string['sliderh4color'] = 'Color del Deslizador uno H4';
$string['sliderh4colordesc'] = 'Elegir el color que desea para la marca del deslizador uno H4.';
$string['sliderimage'] = 'Imagen del deslizador';
$string['sliderimagedesc'] = 'Añadir una imagen a su diapositiva. El tamaño recomendado es 1600 pixeles x 400 pixeles o mayor.';
$string['slidermarginbottom'] = 'Margen inferior de la presentación de diapositivas';
$string['slidermarginbottomdesc'] = 'Establece el margen inferior de la presentación de diapositivas.';
$string['slidermargintop'] = 'Margen superior de la presentación de diapositivas';
$string['slidermargintopdesc'] = 'Establece el margen superior de la presentación de diapositivas.';
$string['slideroption2'] = 'Elegir Tipo de Deslizador';
$string['slideroption2a'] = 'Color de fondo de las flechas de la opción de estilo del deslizador dos';
$string['slideroption2adesc'] = 'Establezca la opción de estilo del control deslizante con dos flechas de color de fondo';
$string['slideroption2color'] = 'Fondo del envío del deslizador dos';
$string['slideroption2colordesc'] = 'Establezca un color de fondo para el texto de envío en la opción de estilo del control deslizante.';
$string['slideroption2desc'] = 'Seleccione el tipo de control deslizante <strong>y luego haga clic en GUARDAR</strong> para ver la configuración de color del control deslizante elegido.';
$string['slideroption2submitcolor'] = 'Enviar texto Deslizador 2';
$string['slideroption2submitcolordesc'] = 'Establezca un color de fondo para el texto de envío en la opción de estilo del control deslizante de dos colores.';
$string['sliderstyle1'] = 'Deslizador estilo uno';
$string['sliderstyle2'] = 'Deslizador estilo dos';
$string['slidersubmitbgcolor'] = 'Fondo de Envío de Deslizador uno';
$string['slidersubmitbgcolordesc'] = 'Elija el color de fondo del botón Enviar del control deslizante.';
$string['slidersubmitcolor'] = 'Texto para Envío de Deslizador uno';
$string['slidersubmitcolordesc'] = 'Elegir el color del texto del botón para envío del Deslizador uno.';
$string['sliderurl'] = 'URL de enlace de Diapositiva';
$string['sliderurldesc'] = 'Añada una URL a la cual enlazará su diapositiva cuando le haga clic.';
$string['slidervisible'] = 'Mostrar el deslizado cuando';
$string['slidervisibledesc'] = 'Mostrar el deslizado cuando \'Salido\', \'Ingresado\' o \'Ingresado o Salido\'.';
$string['slidervisibleloggedin'] = 'Ingresado';
$string['slidervisibleloggedinout'] = 'Ingresado o Salido';
$string['slidervisibleloggedout'] = 'Salido';
$string['slideshowdesc'] = 'Sube imagenes, añade enlaces y descripciones en las dispositivas de la presentación de la página de inicio.';
$string['slideshowsettings'] = 'Presentación de diapositivas';
$string['slideshowsettingsheading'] = 'Personaliza el carrusel de imágenes en la portada.>';
$string['slight'] = 'Leve';
$string['socialheading'] = 'Configuración de los iconos de redes sociales';
$string['socialicondesc'] = 'Configurar ícono de Font Awesome como por ejemplo: fa-facebook.';
$string['socialiconlist'] = 'Lista de íconos sociales';
$string['socialiconlistdesc'] = 'Introducir una lista delimitada para configurar los enlaces / iconos de redes sociales que necesites usando el formato:

url|titulo|ícono

Por ejemplo:
<pre>
https://ejemplo.com/course/search.php|Buscar en Moodle|search
https://facebook.com/|Facebook|fa-brands fa-facebook-f
https://X.com/|X|fa-brands fa-x-twitter
https://twitter.com/|Twitter|fa-brands fa-twitter
https://instagram.com|Instagram|fa-brands fa-instagram
https://ejemplo.com|Mi Web|globe
</pre>
En donde el ícono del Font Awesome puede ser su nombre o classes CSS. Para referencia usted puede encontrar la lista completa de íconos de Font Awesome al ver  \'<a href="{$a}" target="_blank">aquí</a>\'.';
$string['socialpaddingside'] = 'Ajustar relleno para el costado del ícono social';
$string['socialpaddingsidedesc'] = 'Esto será espacio entre el ícono y otro elemento o el hueco entre dos íconos. Por ejemplo, el relleno en el ícono será este valor dividido entre dos. El valor predeterminado sigue las guías de marcado personalizado de Instagram.';
$string['socialpaddingtop'] = 'Ajustar la separación debajo los iconos sociales (altera la posición vertical)';
$string['socialpaddingtopdesc'] = 'Esto será el mínimo de 15 pixeles (configurado usando el margen) más este valor.';
$string['socialsearchicon'] = 'Buscar en Moodle';
$string['socialsearchicondesc'] = 'Habilitar la opción de colocar un enlace de búsqueda junto a los íconos sociales (ya que el uso de redes sociales deshabilita el cuadro de búsqueda en todo el sitio).';
$string['socialsettings'] = 'Redes sociales';
$string['socialsize'] = 'Configurar tamaño de los íconos sociales';
$string['socialsizedesc'] = 'Para una mejor visualización, el tamaño necesita ser 5 pixeles mayor que el tamaño deseado actual.';
$string['socialtarget'] = 'Abrir destino enlaces sociales';
$string['socialtargetdesc'] = '¿Cómo le gustaría que se abrieran los enlaces a redes sociales?: misma ventana (\'\'Same Window\'\') o en una nueva ventana (\'\'New Window\'\').';
$string['socialtitledesc'] = 'Usted puede desactivar la caja para búsqueda en todo el sitio y activar los íconos / enlaces de redes sociales en su lugar.
Para configurar los iconos, introduzca una lista delimitada en el campo inferior  "Lista de íconos sociales".';
$string['solid'] = 'Sólido';
$string['standard'] = 'Estándar';
$string['standardscreenwidth'] = 'Ancho estándar de pantalla.';
$string['standardscreenwidthdesc'] = 'Configurar el ancho de la pantalla cuando está en vista "estándar" (vea también las configuraciones relacionadas enablezoom y defaultzoom).';
$string['standardview'] = 'Vista estándar';
$string['static'] = 'Estático';
$string['stickynavbar'] = 'Barra de Navegación pegajosa en la parte superior';
$string['stickynavbardesc'] = 'Pegar la Barra-de-Navegación  a la parte superior de la pantalla al deslizarse hacia abajo.';
$string['stylecover'] = 'Cubierta';
$string['stylestretch'] = 'Estirada';
$string['tabbedlayoutcoursepage'] = 'Diseño de Pestañas de página de curso';
$string['tabbedlayoutcoursepagedesc'] = 'Usar un diseño de Pestañas para la página de curso. Esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite a Usted personalizar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutcoursepagelink'] = 'Enlace de página de curso en Diseño con Pestañas';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Hacer que una pestaña enlace de regreso a la página del curso en las pestañas del curso.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Color de pestaña para página de curso';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Elegir el color para la pestaña actualmente seleccionada.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Color de pestaña no-seleccionada para página de curso';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Elegir el color para cualquier otra pestaña';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Tiempo de persistencia de Pestaña del curso';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'La pestaña del curso permanece en la pestaña seleccionada al actualizarse durante un período de inactividad. Establezca el período de inactividad aquí. Por ejemplo, configúrelo en 30 para que la primera pestaña se seleccione después de 30 minutos de inactividad.';
$string['tabbedlayoutdashboard'] = 'Diseño en Pestañas de página del Tablero';
$string['tabbedlayoutdashboarddesc'] = 'Usar un diseño en pestañas para la página del Tablero. esto muestra todo el contenido en pestañas, con el contenido del curso en una pestaña y le permite configurar el contenido en otras pestañas. Use esta configuración para configurar el orden de las pestañas.';
$string['tabbedlayoutdashboardtab1condition'] = 'Pestaña 1 Restricción de Campo Personalizado del Perfil (opcional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Añadir regla de acceso para mostrar Pestaña 1 usando Campo Personalizado del Perfil (por ejemplo: mostrarpestaña1=true)';
$string['tabbedlayoutdashboardtab2condition'] = 'Pestaña dos Restricción de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Agregar regla de acceso para mostrar la pestaña 2 usando un campo de perfil personalizado, por ejemplo: showtab2=true.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Color de pestaña seleccionada para el Tablero';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Elegir el color para la pestaña seleccionada actualmente';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Color de pestaña no seleccionado para Tablero';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Elegir el color  para cualquier otra pestaña';
$string['tabbedlayoutheading'] = 'Diseño en Pestañas de Adaptable';
$string['tabbedlayouttablabelcourse'] = 'Contenido del Curso';
$string['tabbedlayouttablabelcourse1'] = 'Pestaña uno';
$string['tabbedlayouttablabelcourse2'] = 'Pestaña dos';
$string['tabbedlayouttablabeldashboard'] = 'Contenido del Tablero';
$string['tabbedlayouttablabeldashboard1'] = 'Pestaña uno';
$string['tabbedlayouttablabeldashboard2'] = 'Pestaña dos';
$string['targetnewwindow'] = 'Nueva ventana';
$string['targetsamewindow'] = 'Misma ventana';
$string['templatesheading'] = 'Configuraciones de plantillas';
$string['templatesheadingdesc'] = 'Anular plantillas.';
$string['templatessel'] = 'Plantillas a ser anuladas';
$string['templatesseldesc'] = 'Seleccione las plantillas  a anular; después cada una será mostrada en su propia página. Si no se seleccionan aquí, entonces las plantillas no serán anuladas aunque estuviera esto habilitado. Para seleccionar a ninguna, use la tecla \'Ctrl\'.';
$string['templatessettings'] = 'Plantillas';
$string['themechanges'] = 'Cambios';
$string['themereadme'] = 'Léame';
$string['themesupportsponsorship'] = 'Soporte y patrocinio';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Anuncios';
$string['tickerconstainerbackgroundcolour'] = 'Color de fondo del contenedor del ticker de noticias';
$string['tickerconstainerbackgroundcolourdesc'] = 'Establezca el color de fondo del contenedor del ticker.';
$string['tickerconstainertextcolour'] = 'Color del texto del contenedor del ticker de noticias';
$string['tickerconstainertextcolourdesc'] = 'Establezca el color del texto del contenedor del ticker.';
$string['tickerdefault'] = 'No hay anuncios para mostrar';
$string['tickerdesc'] = 'Aquí puede configurar un ticker de noticias para que se ejecute en todo su sitio Moodle.
Está pensado como una alternativa menos intrusiva al control deslizante que ocupa muy poco espacio.
Para configurar su ticker, simplemente ingrese una lista de párrafos e incluya los hipervínculos que necesite en ese texto.
<strong>Nota:</strong> Si su ticker no se carga correctamente, cambie a la vista HTML y asegúrese de tener solo etiquetas p:
<pre>
&lt;p&gt;Noticia uno.....&lt;/p&gt;
&lt;p&gt;Noticia dos.....&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Ancho de pantalla completa';
$string['tickerheaderbackgroundcolour'] = 'Color de fondo del encabezado del ticker de noticias';
$string['tickerheaderbackgroundcolourdesc'] = 'Establezca el color de fondo del encabezado del ticker.';
$string['tickerheadertextcolour'] = 'Color del texto del encabezado del ticker de noticias';
$string['tickerheadertextcolourdesc'] = 'Establezca el color del texto del encabezado del ticker.';
$string['tickersettings'] = 'Tablón de anuncios';
$string['tickersettingsheading'] = 'Configurar el Tablón de anuncios';
$string['tickertext'] = 'Texto del Tablón de Anuncios';
$string['tickertextdesc'] = 'Agregue texto de noticias en formato de lista. Consulte el archivo Léame para obtener más información.';
$string['tickertextprofilefield'] = 'Nombre del campo personalizado del perfíl=Valor (opcional)';
$string['tickertextprofilefielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['tickerwidth'] = 'Ancho Fijo';
$string['tickerwidthdesc'] = 'Usted puede usar esta configuración para arreglar el ancho de anuncios al máximo de 100%.';
$string['tilesbordercolor'] = 'Color del borde de los bloques de cursos';
$string['tilesbordercolordesc'] = 'Establece un color para el borde de los mosaicos de las cajas de cursos.';
$string['tilescontactstitle'] = 'Mostrar el rol de los contactos del curso';
$string['tilescontactstitledesc'] = 'Muestra / Oculta el rol de un contacto del curso. Si no se muestra, se mostrará una imagen antes de cada contacto.';
$string['tilesshowallcontacts'] = 'Mostrar todos los contactos del curso';
$string['tilesshowallcontactsdesc'] = 'Mostrar todos los contactos del curso o solamente uno.';
$string['tilesshowcontacts'] = 'Mostrar los contactos del curso';
$string['tilesshowcontactsdesc'] = 'Muestra / Oculta los contactos del curso.';
$string['togglenavigation'] = 'Alternar navegación';
$string['toolsmenu'] = 'Menú de herramientas';
$string['toolsmenudesc'] = 'Añade los enlaces aquí';
$string['toolsmenufield'] = 'Nombre del campo personalizado del perfíl=Valor (opcional)';
$string['toolsmenufielddesc'] = 'Añadir regla de acceso usando un campo personalizado del perfil . Ejemplo: usertype=student.';
$string['toolsmenuheading'] = 'Menús herramientas';
$string['toolsmenuheadingdesc'] = 'Añade un menú desplegable a la barra de navegación principal. Puede configurar enlaces para que se muestren debajo de un menú de herramientas (en la barra de navegación principal). En el formato \'texto|url|título|idiomas|clases fontawesome|capacidad para comprobar\'. Introduzca solo lo que necesite. Si no necesita algo pero necesitasalgo más adelante, déjalo en blanco pero siga usando el delimitador \'|\'. Por ejemplo: \'texto|url|||clases fontawesome\'. Para encontrar las clases FontAwesome(Free) para el icono que desea usar, vaya a <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> y busque el icono. Puede usar el nombre, como \'graduation-cap\' o la lista completa de clases \'fa-solid fa-graduation-cap\'. Por ejemplo:<pre>
Grabar pantalla|https://mysite.localhost|Grabar pantalla||video
Fotos|https://mysite.localhost|Fotos||fa-solid fa-image
Reloj de examen|https://mysite.localhost|Reloj de examen|en|clock
Cloc arholiad|https://mysite.localhost|Cloc arholiad|cy|clock
</pre>';
$string['toolsmenuheadingindex'] = 'Menú de herramientas {$a}';
$string['toolsmenuscount'] = 'Número de menús de herramientas';
$string['toolsmenuscountdesc'] = 'Establece el número de menús de herramientas que quiere añadir  a la barra principal de navegación.';
$string['toolsmenutitle'] = 'Título menú de herramientas';
$string['toolsmenutitledefault'] = 'Herramientas';
$string['toolsmenutitledesc'] = 'Añadir el título del menú que le gustaría mostrar en la barra de navegación principal.';
$string['topicsweeks'] = 'Formato de curso Tópicos/Semanas';
$string['topicsweeksdesc'] = 'Configurar estilos para el formato de curso de \'Tópicos\' / \'Semanas\'.';
$string['topmenufontsize'] = 'Tamaño del tipo de letra del menú superior';
$string['topmenufontsizedesc'] = 'Ajustar el tamaño del tipo de letra de los menús superiores.';
$string['topmenuscount'] = 'Número de menús superiores';
$string['topmenuscountdesc'] = 'Establece el número de menúes superiores que quiere añadir en el encabezado del tema.';
$string['turngradereditingoff'] = 'Desactivar edición del calificador';
$string['turngradereditingon'] = 'Activar edición del calificador';
$string['userfavmenu'] = 'Menú de favoritos del usuario';
$string['userfavmenudesc'] = 'El usuario podrá crear su propio menú de favoritos guardado como preferencia de usuario. El formato de cada línea es \'texto|url|título|langs|fontawesome classes\'. Solo ingrese lo que necesite. Si no necesita algo pero necesita algo más adelante, déjelo en blanco pero use el delimitador \'|\'. Por ejemplo: \'texto|url|||fontawesome classes\'. Para encontrar las clases FontAwesome(Free) para el ícono que desea usar, vaya a <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> y busque el ícono. Puede usar el nombre, como \'graduation-cap\' o la lista completa de clases \'fa-solid fa-graduation-cap\'. Por ejemplo:<pre>
Cursos
-Todos los cursos|/curso/|||gorro-de-graduacion
-Búsqueda de cursos|/curso/search.php
-###
-Preguntas frecuentes|https://example.org/faq
-Reloj de exámenes|https://mysite.localhost|Reloj de exámenes||reloj
</pre>';
$string['usermenu'] = 'Menú del usuario';
$string['usernameposition'] = 'Posición del nombre del usuario';
$string['usernamepositiondesc'] = 'Configurar la posición del nombre del usuario. \'Izquierda\' o \'Derecha\'.';
$string['usernav'] = 'Usuario en encabezado';
$string['usernavdesc'] = 'Permite personalizar todos los elementos que aparecen en el menú desplegable de navegación del usuario.';
$string['usernavheading'] = 'Personaliza el menú desplegable del perfíl de usuario.';
$string['usernodescription'] = 'Usuario aún no ha actualizado su descripción.';
$string['usernointerests'] = 'Usuario aún no ha actualizado sus intereses.';
$string['usersettings'] = 'Perfil del Usuario';
$string['usersettingsdesc'] = 'Ajustar configuraciones para el perfil del usuario.';
$string['usersettingsheading'] = 'Controlar aspectos del perfil del usuario';
$string['versionalpha'] = 'Versión alfa - Casi seguramente contiene errores. ¡ Esta es una versión en desarrollo \'solamente\' para desarrolladores ! ¡ Ni siquiera se le vaya a ocurrir instalarla en un servidor en producción !';
$string['versionbeta'] = 'Versión beta - Probablemente contiene errores. Está lista para probarse por administradores solamente en un servidor de pruebas.';
$string['versioninfo'] = 'Liberación {$a->release}, versión {$a->version} en Moodle {$a->moodle}';
$string['versionrc'] = 'Versión de candidato a liberación . Podría contener errores. Comprobarla completamente en un servidor de prueba antes de considerarla para un servidor en producción.';
$string['versionstable'] = 'Versión estable: podría contener errores, ya que no queda suficiente tiempo en el universo para encontrarlos todos. ¡Verifique en un servidor de prueba antes de instalarlo en su servidor de producción, en serio! No se arrepentirá y podrá personalizar hasta que esté satisfecho, luego use la función "Importar/exportar configuraciones" para transferir los valores de configuración.';
$string['wide'] = 'Pantalla Completa';
