<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_usertours', language 'pt', version '5.0'.
 *
 * @package     tool_usertours
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Acima';
$string['actions'] = 'Ações';
$string['appliesto'] = 'Aplica-se a';
$string['backdrop'] = 'Mostrar com plano de fundo';
$string['backdrop_help'] = 'Pode usar um plano de fundo para realçar a parte da página para onde está a apontar.

<b>Atenção</b>: Os planos de fundo não são compatíveis com algumas partes da página, por exemplo, a barra de navegação.';
$string['below'] = 'Abaixo';
$string['block'] = 'Bloco';
$string['block_named'] = 'Bloco \'{$a}\'';
$string['cachedef_stepdata'] = 'Lista das etapas da demonstração ao utilizador';
$string['cachedef_tourdata'] = 'Lista de informações das demonstrações ao utilizador ativadas que é procurada em todas as páginas';
$string['confirmstepremovalquestion'] = 'Tem a certeza de que pretende remover esta etapa?';
$string['confirmstepremovaltitle'] = 'Confirmar a eliminação da etapa';
$string['confirmtourremovalquestion'] = 'Tem a certeza de que pretende remover esta demonstração?';
$string['confirmtourremovaltitle'] = 'Confirmar a eliminação da demonstração';
$string['content'] = 'Conteúdo';
$string['content_heading'] = 'Conteúdo';
$string['content_help'] = 'O conteúdo que descreve a etapa pode ser adicionado como texto simples, incluído em palavras-chave multilingue (para uso com o filtro de conteúdo em vários idiomas), se for necessário.';
$string['content_type'] = 'Tipo de conteúdo';
$string['content_type_help'] = '* Manual - usar um editor para inserir o conteúdo
* ID de string do idioma - no formato identifier,component (sem espaço após a vírgula)';
$string['content_type_langstring'] = 'ID de string do idioma';
$string['content_type_manual'] = 'Manual';
$string['cssselector'] = 'Seletor CSS';
$string['defaultvalue'] = 'Valor predefinido ({$a})';
$string['delay'] = 'Atraso antes de mostrar a etapa';
$string['delay_help'] = 'Opcionalmente, pode optar por adicionar um atraso antes que a etapa seja exibida.

Este atraso é em milissegundos.';
$string['description'] = 'Descrição';
$string['description_help'] = 'A descrição de uma demonstração ao utilizador pode ser inserida como texto simples, e se necessário, entre tags multilingue (para uso com o filtro Conteúdos multilingue para vários idiomas).

Alternativamente, um ID de string de idioma pode ser inserido no formato identifier,component (sem parênteses ou espaço após a vírgula).';
$string['displaystepnumbers'] = 'Mostrar número das etapas';
$string['displaystepnumbers_help'] = 'Se deve, ou não, exibir a contagem do número de etapas, por exemplo, 1/4, 2/4, etc. para indicar o tamanho da demonstração ao utilizador.';
$string['done'] = 'Concluído';
$string['duplicatetour'] = 'Duplicar a demonstração ao utilizador';
$string['duplicatetour_name'] = '{$a} (cópia)';
$string['editstep'] = 'Edição de "{$a}"';
$string['enabled'] = 'Ativado';
$string['endonesteptour'] = 'Entendido';
$string['endtour'] = 'Fim da demonstração';
$string['endtourlabel'] = 'Texto do botão de \'Fim da demonstração\'';
$string['endtourlabel_help'] = 'Pode opcionalmente especificar um texto personalizado para o botão de fim da demonstração ao utilizador. O texto predefinido é \'Entendido\' para demonstrações de uma única etapa e "Fim da demonstração" para demonstrações de várias etapas.

Em alternativa, um ID de string do idioma pode ser inserido no formato identifier,component (sem parênteses ou espaço após a vírgula).';
$string['event_step_shown'] = 'Etapa visualizada';
$string['event_tour_ended'] = 'Demonstração terminada';
$string['event_tour_reset'] = 'Reiniciar demonstração';
$string['event_tour_started'] = 'Demonstração iniciada';
$string['exporttour'] = 'Exportar demonstração';
$string['filter_accessdate'] = 'Data de acesso';
$string['filter_accessdate_enabled'] = 'Ativar filtro de data de acesso';
$string['filter_accessdate_enabled_help'] = 'Mostrar a demonstração apenas aos novos utilizadores ou aos que acederam o site recentemente.';
$string['filter_category'] = 'Categoria';
$string['filter_category_help'] = 'Mostrar esta demonstração numa página que está associada com a categoria selecionada.';
$string['filter_course'] = 'Disciplinas selecionadas';
$string['filter_course_error_course_selection'] = 'Tem de selecionar pelo menos uma disciplina';
$string['filter_course_help'] = 'Dependendo do valor do filtro Disciplinas:

* **Apenas disciplinas selecionadas**: Mostrar esta demonstração nas páginas associadas às disciplinas selecionadas.
* **Todas as disciplinas, exceto as selecionadas**: Não mostrar esta demonstração nas páginas associadas às disciplinas selecionadas.';
$string['filter_course_operator'] = 'Disciplinas';
$string['filter_course_operator_all'] = 'Todas as disciplinas';
$string['filter_course_operator_except'] = 'Todas as disciplinas, exceto as selecionadas';
$string['filter_course_operator_help'] = 'A demonstração pode ser configurada para aparecer apenas em determinadas disciplinas.

* **Todas as disciplinas**: Mostrar esta demonstração independentemente da disciplina.
* **Apenas as disciplinas selecionadas**: Mostrar esta demonstração apenas nas páginas associadas à(s) disciplina(s) selecionada(s) abaixo.
* **Todas as disciplinas, exceto as selecionadas**: Não mostrar esta demonstração nas páginas associadas à(s) disciplina(s) selecionada(s) abaixo.';
$string['filter_course_operator_select'] = 'Apenas as disciplinas selecionadas';
$string['filter_courseformat'] = 'Formato de disciplina';
$string['filter_courseformat_help'] = 'Mostrar a demonstração numa página que está associada à disciplina selecionada usando o formato da disciplina selecionada.';
$string['filter_cssselector'] = 'Seletor CSS';
$string['filter_cssselector_help'] = 'Mostrar a demonstração ao utilizador apenas quando o seletor CSS especificado for encontrado na página.';
$string['filter_date_account_creation'] = 'Data de criação da conta do utilizador há';
$string['filter_date_first_login'] = 'Data do primeiro acesso do utilizador há';
$string['filter_date_last_login'] = 'Data do último acesso do utilizador há';
$string['filter_exclude_category'] = 'Excluir categorias';
$string['filter_exclude_category_help'] = 'Não mostrar esta demonstração nas páginas associadas às categorias das disciplinas selecionadas.

Se selecionar uma categoria ascendente, as subcategorias relacionadas serão automaticamente selecionadas e não poderão ser selecionadas individualmente.

Desmarque a categoria ascendente para voltar a selecionar subcategorias.';
$string['filter_header'] = 'Filtros da demonstração';
$string['filter_help'] = 'Selecione as condições que devem existir para que a demonstração seja mostrada. Só quando forem respeitados todos os filtros é que a demonstração é mostrada a um utilizador.';
$string['filter_role'] = 'Papel';
$string['filter_role_help'] = 'Uma demonstração pode ser exclusiva para utilizadores com papel selecionado no contexto em que a demonstração é mostrada. Por exemplo, restringir uma demonstração de Painel do utilizador aos utilizadores com o papel de aluno não funcionará se os utilizadores tiverem o papel de aluno numa disciplina (como geralmente é o caso). Uma demonstração de Painel do utilizador só pode ser restrita a utilizadores com um papel de sistema.';
$string['filter_theme'] = 'Tema';
$string['filter_theme_help'] = 'Mostrar a demonstração quando o utilizador estiver a usar um dos temas selecionados.';
$string['importtour'] = 'Importar demonstração';
$string['invalid_lang_id'] = 'ID de string do idioma inválido';
$string['left'] = 'Esquerda';
$string['modifyshippedtourwarning'] = 'Esta demonstração ao utilizador faz parte do código base do Moodle. Quaisquer modificações poderão ser substituídas na próxima atualização do site.';
$string['moodle_language_identifier'] = 'ID de string do idioma';
$string['movestepdown'] = 'Ir para etapa anterior';
$string['movestepup'] = 'Ir para etapa seguinte';
$string['movetourdown'] = 'Mover demonstração para baixo';
$string['movetourup'] = 'Mover demonstração para cima';
$string['name'] = 'Nome';
$string['name_help'] = 'O nome de uma demonstração ao utilizador pode ser inserido como texto simples, e se necessário, entre tags multilingue (para uso com o filtro Conteúdos multilingue para vários idiomas).

Alternativamente, um ID de string de idioma pode ser inserido no formato identifier,component (sem parênteses ou espaço após a vírgula).';
$string['newstep'] = 'Nova etapa';
$string['newtour'] = 'Criar nova demonstração';
$string['next'] = 'Seguinte';
$string['nextstep'] = 'Seguinte';
$string['nextstep_sequence'] = 'Próxima ({$a->position}/{$a->total})';
$string['options_heading'] = 'Opções';
$string['orphan'] = 'Mostrar se o destino não for encontrado';
$string['orphan_help'] = 'Mostrar a etapa se o destino não for encontrado na página.';
$string['pathmatch'] = 'Aplicar à correspondência do URL';
$string['pathmatch_help'] = 'As demonstrações serão mostradas em qualquer página cujo URL corresponda a este valor.

Pode usar % como caráter universal para dar significado a qualquer coisa.
Alguns exemplos de valores:

* /my/% - para corresponder ao Painel do utilizador
* /course/view.php?id=2 - para corresponder à disciplina com ID=2
* /mod/forum/view.php% - para corresponder à lista de discussão do fórum
* /user/profile.php% - para corresponder à página de perfil do utilizador

Se pretender mostrar uma demonstração na Página inicial do site, pode usar o valor: "FRONTPAGE".';
$string['pausetour'] = 'Pausa';
$string['placement'] = 'Posicionamento';
$string['placement_help'] = 'Uma etapa pode ser colocada acima, abaixo, à esquerda ou à direita do destino. É recomendado acima ou abaixo, uma vez que se ajustam melhor em dispositivos móveis.

Se não for possível ajustar a etapa no local especificado de uma determinada página, ela será automaticamente colocada noutro lugar.';
$string['pluginname'] = 'Demonstrações ao utilizador';
$string['privacy:metadata:preference:completed'] = 'A data e hora em que um utilizador completou pela última vez uma demonstração ao utilizador.';
$string['privacy:metadata:preference:requested'] = 'A data e hora em que um utilizador solicitou pela última vez uma demonstração ao utilizador.';
$string['privacy:request:preference:completed'] = 'A última vez que marcou como concluída a demonstração ao utilizador "{$a->name}" foi em {$a->time}';
$string['privacy:request:preference:requested'] = 'Solicitou a demonstração ao utilizador "{$a->name}" pela última vez em {$a->time}';
$string['reflex'] = 'Clique para avançar';
$string['reflex_help'] = 'Ir para a próxima etapa quando clicar no destino.';
$string['resettouronpage'] = 'Repetir a demonstração ao utilizador desta página';
$string['resumetour'] = 'Retomar';
$string['right'] = 'Direita';
$string['select_block'] = 'Selecione um bloco';
$string['selector_defaulttitle'] = 'Digite um título descritivo';
$string['selectordisplayname'] = 'Um seletor CSS correspondente a \'{$a}\'';
$string['selecttype'] = 'Selecione o tipo de etapa';
$string['sharedtourslink'] = 'Repositório de demonstrações';
$string['showtoureachtime'] = 'cada vez que um filtro corresponde';
$string['showtouruntilcomplete'] = 'até que tenha seja fechada';
$string['showtourwhen'] = 'Mostrar demonstração ao utilizador';
$string['skip'] = 'Saltar';
$string['skip_tour'] = 'Ignorar a demonstração';
$string['target'] = 'Destino';
$string['target_block'] = 'Bloco';
$string['target_heading'] = 'Destino da etapa';
$string['target_selector'] = 'Seletor';
$string['target_selector_targetvalue'] = 'Seletores CSS';
$string['target_selector_targetvalue_help'] = 'Um seletor CSS serve para poder usar como destino quase todos os elementos da página. O seletor apropriado pode ser facilmente encontrado através das ferramentas de desenvolvimento para o seu navegador web.';
$string['target_unattached'] = 'Mostrar no meio da página';
$string['targettype'] = 'Tipo de destino';
$string['targettype_help'] = 'Cada etapa é associada a uma parte da página - o destino. Os tipos de destino são:

* Bloco - para mostrar uma etapa ao lado de um bloco específico
* Seletor CSS - para definir com precisão a área de destino usando CSS
* Mostrar no meio da página - para uma etapa que não precisa de ser associada a uma parte específica da página';
$string['title'] = 'Título';
$string['title_help'] = 'O título de uma etapa pode ser inserido como texto simples, e se necessário, entre tags multilingue (para uso com o filtro Conteúdos multilingue para vários idiomas).

Alternativamente, um ID de string de idioma pode ser inserido no formato identifier,component (sem parênteses ou espaço após a vírgula).';
$string['tour1_content_addingblocks'] = 'Na verdade, pense cuidadosamente sobre incluir quaisquer blocos nas suas páginas. Os blocos não são mostrados na Aplicação móvel Moodle, por isso, e como regra geral, é muito melhor certificar-se de que o seu site funciona bem sem quaisquer blocos.';
$string['tour1_content_blockregion'] = 'Existe ainda uma área com blocos. Recomenda-se a remoção completa dos blocos Navegação e Administração, uma vez que toda a funcionalidade destes está noutro lugar no tema Boost.';
$string['tour1_content_customisation'] = 'Para personalizar a aparência do seu site e da página inicial, use o menu de configurações no canto deste cabeçalho. Clique em \'Ativar o modo de edição\'.';
$string['tour1_content_end'] = 'Esta foi uma demonstração ao utilizador. Não será mostrada novamente a menos que a reinicie através da hiperligação existente no rodapé. Como administrador, também pode criar as suas demonstrações!';
$string['tour1_content_navigation'] = 'A maioria da navegação é agora feita através deste menu de navegação. As opções mostradas dependem de onde está no site. Use o botão na parte superior para ocultar ou mostrar o menu.';
$string['tour1_content_welcome'] = 'Bem-vindo ao tema Boost. Se o seu site foi atualizado a partir de uma versão anterior, irá notar que as coisas estão um pouco diferentes com este tema.';
$string['tour1_title_addingblocks'] = 'A adicionar blocos';
$string['tour1_title_blockregion'] = 'Região do bloco';
$string['tour1_title_customisation'] = 'Personalização';
$string['tour1_title_end'] = 'Fim da demonstração';
$string['tour1_title_navigation'] = 'Navegação';
$string['tour1_title_welcome'] = 'Bem-vindo';
$string['tour2_content_addblock'] = 'Se ativar o modo de edição, poderá adicionar blocos através do menu de navegação. No entanto, pense cuidadosamente sobre incluir quaisquer blocos nas suas páginas. Os blocos não são mostrados na Aplicação móvel Moodle, por isso, para uma melhor experiência do utilizador, é melhor certificar-se de que a disciplina funciona bem sem quaisquer blocos.';
$string['tour2_content_addingblocks'] = 'Pode adicionar blocos a esta página através deste botão. No entanto, pense cuidadosamente sobre incluir quaisquer blocos nas suas páginas. Os blocos não são mostrados na Aplicação móvel Moodle, por isso, e para uma melhor experiência do utilizador, certifique-se de que a disciplina funciona bem sem quaisquer blocos.';
$string['tour2_content_customisation'] = 'Para alterar as configurações da disciplina, use o menu de configurações no canto deste cabeçalho. Também encontrará um menu de configurações semelhante na página inicial de todas as atividades. Clique em Ativar o modo de edição.';
$string['tour2_content_end'] = 'Esta foi uma demonstração ao utilizador. Não será mostrada novamente a menos que a reinicie usando a hiperligação existente no rodapé. Se necessário, o administrador do site também pode criar outras demonstrações para este site.';
$string['tour2_content_navigation'] = 'A navegação é agora feita através deste menu de navegação. Use o botão na parte superior para ocultá-lo ou mostrá-lo. Verá que existem hiperligações para as secções principais da sua disciplina.';
$string['tour2_content_opendrawer'] = 'Tente abrir agora o menu de navegação.';
$string['tour2_content_participants'] = 'Ver os participantes aqui. Também é onde pode adicionar ou remover alunos.';
$string['tour2_content_welcome'] = 'Bem-vindo ao tema Boost. Se o seu site foi atualizado a partir de uma versão anterior, irá notar que as coisas estão um pouco diferentes aqui na página da disciplina.';
$string['tour2_title_addblock'] = 'Adicionar um bloco';
$string['tour2_title_addingblocks'] = 'A adicionar blocos';
$string['tour2_title_customisation'] = 'Personalização';
$string['tour2_title_end'] = 'Fim da demonstração';
$string['tour2_title_navigation'] = 'Navegação';
$string['tour2_title_opendrawer'] = 'Abrir o menu de navegação';
$string['tour2_title_participants'] = 'Participantes da disciplina';
$string['tour2_title_welcome'] = 'Bem-vindo';
$string['tour3_content_dashboard'] = 'O novo Painel do utilizador tem muitas funcionalidades para facilitar o fácil acesso às informações mais importantes.';
$string['tour3_content_displayoptions'] = 'As disciplinas podem ser ordenadas por nome da disciplina, nome curto ou pela data do último acesso.

Também pode optar por mostrar as disciplinas numa lista, com descrição, ou a exibição predefinida de \'cartões\'.';
$string['tour3_content_overview'] = 'O bloco \'Minhas disciplinas\' mostra todas as disciplinas em que está inscrito.

Pode optar por mostrar as disciplinas atualmente em progresso, as já terminadas, as a iniciar ou as disciplinas que marcou com estrela.';
$string['tour3_content_recentcourses'] = 'O bloco Disciplinas acedidas recentemente mostra as últimas disciplinas que visitou, o que permite uma navegação rápida para as disciplinas visitadas.';
$string['tour3_content_starring'] = 'Pode optar por marcar uma disciplina com uma estrela para a destacar ou ocultar uma disciplina que já não é importante.

Estas ações afetam apenas a sua visualização.

Também pode optar por mostrar as disciplinas numa lista, com descrição, ou a exibição predefinida de \'cartões\'.';
$string['tour3_content_timeline'] = 'O bloco Cronograma mostra os seus próximos eventos importantes.

Pode optar por mostrar atividades da próxima semana, mês ou no futuro.

Também pode mostrar itens que já terminaram.';
$string['tour3_title_dashboard'] = 'Painel do utilizador';
$string['tour3_title_displayoptions'] = 'Opções de visualização';
$string['tour3_title_overview'] = 'Visão global da disciplina';
$string['tour3_title_recentcourses'] = 'Disciplinas acedidas recentemente';
$string['tour3_title_starring'] = 'Marcar com estrela e ocultar disciplinas';
$string['tour3_title_timeline'] = 'Bloco Cronograma';
$string['tour4_content_groupconvo'] = 'Se é membro de um grupo com mensagens de grupo ativadas, verá aqui as conversações do grupo.

As conversas de grupo das disciplinas permitem que interaja com as outras pessoas do seu grupo num local privado e conveniente.';
$string['tour4_content_icon'] = 'Pode aceder às suas mensagens a partir de qualquer página ao clicar neste ícone.

Se tiver alguma mensagem não lida, o número de mensagens não lidas será também mostrado aqui.

Clique no ícone para abrir a caixa de mensagens e continuar a demonstração.';
$string['tour4_content_messaging'] = 'Novas funcionalidades do envio de mensagens, que inclui, a capacidade de enviar mensagens para um grupo dentro de uma disciplina, assim como, um melhor controlo sobre quem pode enviar mensagens para si.';
$string['tour4_content_settings'] = 'Pode aceder às suas configurações de mensagens através do ícone de engrenagem. Uma nova configuração de privacidade permite restringir quem pode enviar mensagens si.';
$string['tour4_content_starred'] = 'Pode optar por marcar conversas específicas com estrela para torná-las mais fáceis de encontrar.';
$string['tour4_title_groupconvo'] = 'Mensagens de grupo';
$string['tour4_title_icon'] = 'Enviar mensagens';
$string['tour4_title_messaging'] = 'Nova interface do envio de mensagens';
$string['tour4_title_settings'] = 'Configurações do envio de mensagens';
$string['tour4_title_starred'] = 'Com estrela';
$string['tour_activityinfo_activity_student_content'] = 'As datas e as condições de conclusão da atividade são mostrados na página da atividade.';
$string['tour_activityinfo_activity_student_title'] = 'Novo: Informação da atividade';
$string['tour_activityinfo_activity_teacher_content'] = 'As datas e as condições de conclusão da atividade são mostrada aos alunos em cada página da atividade (e opcionalmente na página da disciplina).

Para atividades que requerem que os alunos marquem manualmente a atividade como concluída, é mostrado na página da atividade o botão \'Marcar como concluída\'.';
$string['tour_activityinfo_activity_teacher_title'] = 'Novo: Informação da atividade';
$string['tour_activityinfo_course_student_content'] = 'As datas e/ou as condições de conclusão da atividade são mostrados na página da disciplina.';
$string['tour_activityinfo_course_student_title'] = 'Novo: Informação da atividade';
$string['tour_activityinfo_course_teacher_content'] = 'As novas configurações da disciplina \'Mostrar condições de conclusão da atividade\' e \'Mostrar datas das atividades\' permitem que escolha se as condições de conclusão da atividade (se definidas) e/ou as datas são, ou não, mostradas aos alunos na página da disciplina.';
$string['tour_activityinfo_course_teacher_title'] = 'Novo: Informação da atividade';
$string['tour_final_step_content'] = 'Chegou ao fim da demonstração ao utilizador. Não será mostrada novamente a menos que a reponha através da hiperligação existente no rodapé.';
$string['tour_final_step_title'] = 'Fim da demonstração';
$string['tour_gradebook_action_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_action_menu::tool_usertours@@</div>Ordene as colunas e escolha quais pretende mostrar. No modo Editar, use este atalho para aceder a tarefas frequentes relacionadas com a exibição e edição de Itens de avaliação.';
$string['tour_gradebook_action_title'] = 'Hiperligações para ações';
$string['tour_gradebook_filter_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_initials::tool_usertours@@</div>Filtre os alunos pelas iniciais dos nomes ou apelidos.';
$string['tour_gradebook_filter_title'] = 'Filtrar por nome';
$string['tour_gradebook_search_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_search::tool_usertours@@</div>Use a caixa de pesquisa para encontrar rapidamente alunos específicos.';
$string['tour_gradebook_search_title'] = 'Encontrar alunos facilmente';
$string['tour_gradebook_tour_description'] = 'Funcionalidades de pesquisa e navegação no relatório do avaliador';
$string['tour_gradebook_tour_name'] = 'Relatório do avaliador';
$string['tour_navigation_course_announcements_teacher_content'] = '@@PIXICON::tour/tour_course_admin_3::tool_usertours@@<br>Publique aqui as notícias importantes.';
$string['tour_navigation_course_announcements_teacher_title'] = 'Alguma informação para comunicar a todos?';
$string['tour_navigation_course_edit_teacher_content'] = '@@PIXICON::tour/tour_course_admin_1::tool_usertours@@<br>Adicionar novo conteúdo ou editar o conteúdo existente.';
$string['tour_navigation_course_edit_teacher_title'] = 'Ativar o modo de edição';
$string['tour_navigation_course_index_student_content'] = '@@PIXICON::tour/tour_course_student::tool_usertours@@<br>Explore as atividades e acompanhe o seu progresso.';
$string['tour_navigation_course_index_student_title'] = 'Encontre o seu caminho';
$string['tour_navigation_course_index_teacher_content'] = '@@PIXICON::tour/tour_course_admin_2::tool_usertours@@<br>Arraste e largue as atividades para reordenar o conteúdo da disciplina.';
$string['tour_navigation_course_index_teacher_title'] = 'Índice da disciplina';
$string['tour_navigation_course_student_tour_des'] = 'Onde explorar as atividades de uma disciplina';
$string['tour_navigation_course_student_tour_name'] = 'Índice da disciplina';
$string['tour_navigation_course_teacher_tour_des'] = 'Modo de edição, arrastar e largar atividades e publicar anúncios numa disciplina';
$string['tour_navigation_course_teacher_tour_name'] = 'Editar disciplina';
$string['tour_navigation_dashboard_content'] = '@@PIXICON::tour/tour_dashboard::tool_usertours@@<br>Este painel lateral pode conter mais funcionalidades.';
$string['tour_navigation_dashboard_title'] = 'Expandir para explorar';
$string['tour_navigation_dashboard_tour_des'] = 'Onde os blocos podem ser encontrados';
$string['tour_navigation_dashboard_tour_name'] = 'Painel dos blocos';
$string['tour_navigation_mycourses_content'] = '@@PIXICON::tour/tour_mycourses::tool_usertours@@<br>Adicione, copie, apague e oculte disciplinas através deste menu.';
$string['tour_navigation_mycourses_endtourlabel'] = 'Entendido';
$string['tour_navigation_mycourses_title'] = 'Disciplinas e categorias';
$string['tour_navigation_mycourses_tour_des'] = 'Opções da gestão da disciplina na página Minhas disciplinas';
$string['tour_navigation_mycourses_tour_name'] = 'Gestão da disciplina';
$string['tour_resetforall'] = 'O estado da demonstração foi redefinido. Será mostrada novamente a todos os utilizadores.';
$string['tourconfig'] = 'Ficheiro de configuração da demonstração a ser importado';
$string['tourisenabled'] = 'Demonstração ativada';
$string['tourlist_explanation'] = 'Pode criar as demonstrações que pretender e ativá-las para diferentes partes do Moodle. Apenas pode criar uma demonstração para cada página.';
$string['tours'] = 'Demonstrações';
$string['usertours'] = 'Demonstrações ao utilizador';
$string['usertours:managetours'] = 'Criar, editar e eliminar demonstrações';
$string['viewtour_edit'] = 'Pode <a href="{$a->editlink}">editar os valores predefinidos da demonstração</a> e <a href="{$a->resetlink}">forçar a demonstração a ser mostrada novamente</a> a todos os utilizadores.';
$string['viewtour_info'] = 'Esta é a demonstração \'<b>{$a->tourname}</b>\'. Aplica-se ao caminho \'{$a->path}\'.';
