<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'af', version '4.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Toegangsbeheer';
$string['actionaftercorrectanswer'] = 'Aksie ná korrekte antwoord';
$string['actionaftercorrectanswer_help'] = 'Nadat \'n vraag korrek beantwoord is, is daar 3 opsies vir die volgende blad:

* Normaal - Volg lesroete
* Wys \'n onbekende blad - Blaaie word in \'n lukrake volgorde gewys en geen blad word twee keer gewys nie
* Wys \'n onbeantwoorde blad - Blaaie word in \'n lukrake volgorde gewys, met blaaie wat onbeantwoorde bevat wat weer gewys word';
$string['actions'] = 'Aksies';
$string['activitylink'] = 'Skakel met volgende aktiwiteit';
$string['activitylink_help'] = 'Om \'n skakel na \'n ander aktiwiteit in die kursus aan die einde van die les te verskaf, kies die aktiwiteit vanuit die aftrekkieslys.';
$string['activitylinkname'] = 'Gaan na {$a}';
$string['activityoverview'] = 'Daar is lesse wat jou aandag vereis';
$string['addabranchtable'] = 'Voeg \'n inhoudblad by';
$string['addanendofbranch'] = 'Voeg \'n vertakkingseindpunt by';
$string['addanewpage'] = 'Voeg \'n nuwe blad by';
$string['addaquestionpage'] = 'Voeg \'n vraagblad by';
$string['addaquestionpagehere'] = 'Voeg \'n vraagblad hier by';
$string['addbranchtable'] = 'Voeg \'n inhoudblad by';
$string['addcluster'] = 'Voeg \'n kluster by';
$string['addedabranchtable'] = 'Inhoudblad bygevoeg';
$string['addedanendofbranch'] = 'Vertakkingseindpunt bygevoeg';
$string['addedaquestionpage'] = 'Vraagblad bygevoeg';
$string['addedcluster'] = 'Kluster bygevoeg';
$string['addedendofcluster'] = 'Klustereindpunt bygevoeg';
$string['addendofbranch'] = 'Voeg vertakkingseindpunt by';
$string['addendofcluster'] = 'Voeg \'n klustereindpunt by';
$string['addessay'] = 'Skep \'n "Opstelvraag"-blad';
$string['addmatching'] = 'Skep \'n "Bypassende antwoord"-blad';
$string['addmultichoice'] = 'Skep \'n blad met veelkeusevrae';
$string['addnewgroupoverride'] = 'Voeg groepoorheersing by';
$string['addnewuseroverride'] = 'Voeg gebruikeroorheersing by';
$string['addnumerical'] = 'Skep \'n "numeriese vraag"-blad';
$string['addpage'] = 'Voeg \'n blad by';
$string['addshortanswer'] = 'Skep \'n blad vir kortvrae';
$string['addtruefalse'] = 'Skep \'n blad vir waar/vals-vrae';
$string['allotheranswers'] = 'Alle ander antwoorde';
$string['allotheranswersjump'] = 'Alle ander antwoorde spring';
$string['allotheranswersscore'] = 'Alle ander antwoorde tel';
$string['allowofflineattempts'] = 'Laat toe dat les aflyn via die selfoonapp aangedurf kan word';
$string['allowofflineattempts_help'] = 'Indien geaktiveer, kan \'n gebruiker van \'n selfoonapp die les aflaai en aflyn aandurf.
Al die moontlike antwoorde en korrekte response sal ook afgelaai word.
Let wel: Dit is nie moontlik om \'n les aflyn aan te durf as \'n tydgrens daarvoor gestel is nie.';
$string['anchortitle'] = 'Begin van hoofinhoud';
$string['and'] = 'EN';
$string['answer'] = 'Antwoord';
$string['answeredcorrectly'] = 'korrek beantwoord.';
$string['answersfornumerical'] = 'Antwoorde vir numeriese vrae moet bypassende pare van minimum- en maksimumwaardes wees.';
$string['arrangebuttonshorizontally'] = 'Orden inhoudknoppies horisontaal?';
$string['attempt'] = 'Poging: {$a}';
$string['attemptheader'] = 'Poging';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Pogings';
$string['attemptsdeleted'] = 'Geskrapte pogings';
$string['attemptsremaining'] = 'Jy het nog {$a} poging(s) oor';
$string['available'] = 'Beskikbaar vanaf';
$string['averagescore'] = 'Gemiddelde punt';
$string['averagetime'] = 'Gemiddelde tyd';
$string['branch'] = 'Inhoud';
$string['branchtable'] = 'Inhoud';
$string['cachedef_overrides'] = 'Gebruiker en groep oorheers inligting';
$string['cancel'] = 'Kanselleer';
$string['cannotfindanswer'] = 'Fout: kon nie antwoord vind nie';
$string['cannotfindattempt'] = 'Fout: kon nie poging vind nie';
$string['cannotfindessay'] = 'Fout: kon nie opstel vind nie';
$string['cannotfindfirstgrade'] = 'Fout: kon nie punte vind nie';
$string['cannotfindfirstpage'] = 'Kon nie eerste blad vind nie';
$string['cannotfindgrade'] = 'Fout: kon nie punte vind nie';
$string['cannotfindnewestgrade'] = 'Fout: kon nie jongste punt vind nie';
$string['cannotfindnextpage'] = 'Lesrugsteun: Volgende blad nie gevind nie!';
$string['cannotfindpagerecord'] = 'Voeg vertakkingseindpunt by: bladrekord nie gevind nie';
$string['cannotfindpages'] = 'Kon nie lesblaaie vind nie';
$string['cannotfindpagetitle'] = 'Bevestig skrapping: bladsytitel nie gevind nie';
$string['cannotfindpreattempt'] = 'Rekord van vorige poging kon nie gevind word nie!';
$string['cannotfindrecords'] = 'Fout: kon nie lesrekords vind nie';
$string['cannotfindtimer'] = 'Fout: kon nie "lesson_timer"-rekords vind nie';
$string['cannotfinduser'] = 'Fout: kon nie gebruikers vind nie';
$string['canretake'] = '{$a} kan dit weer doen';
$string['casesensitive'] = 'Gebruik algemene uitdrukkings';
$string['casesensitive_help'] = 'Merk die merkblokkie om algemene uitdrukkings vir ontleding van response te gebruik.';
$string['checkbranchtable'] = 'Merk inhoudblad';
$string['checkedthisone'] = 'Hierdie een gemerk.';
$string['checknavigation'] = 'Merk navigasie';
$string['checkquestion'] = 'Merk vraag';
$string['classstats'] = 'Klasstatistiek';
$string['clicktodownload'] = 'Klik op die volgende skakel om die lêer af te laai.';
$string['closebeforeopen'] = 'Kon nie hierdie les bywerk nie. Jy het \'n sluitingsdatum vóór die openingsdatum gespesifiseer.';
$string['cluster'] = 'Kluster';
$string['clusterjump'] = 'Vraag nie binne kluster bekyk nie';
$string['clustertitle'] = 'Kluster';
$string['collapsed'] = 'Toegevou';
$string['comments'] = 'Jou kommentaar';
$string['completed'] = 'Voltooi';
$string['completederror'] = 'Voltooi die les';
$string['completethefollowingconditions'] = 'Jy moet die volgende voorwaarde(s) in les <b>{$a}</b> voltooi om te kan voortgaan.';
$string['completiondetail:reachend'] = 'Werk deur die aktiwiteit tot aan die einde';
$string['completiondetail:timespent'] = 'Bestee ten minste {$a} aan hierdie aktiwiteit';
$string['completionendreached'] = 'Verlang einde bereik';
$string['completionendreached_desc'] = 'Studente moet die einde van die lesblad bereik om hierdie aktiwiteit af te handel';
$string['completiontimespent'] = 'Student moet hierdie aktiwiteit vir ten minste {$a} doen';
$string['completiontimespentdesc'] = 'Student moet hierdie aktiwiteit vir ten minste {$a} doen';
$string['completiontimespentgroup'] = 'Vereiste tyd bestee';
$string['conditionsfordependency'] = 'Voorwaarde(s) vir die verwantskap';
$string['configintro'] = 'Die waardes wat hier gestel word, omskryf die verstekwaardes wat in die instellingsvorm gebruik word wanneer \'n nuwe lesaktiwiteit geskep word. Instellings wat as gevorderd gespesifiseer word, word slegs gewys wanneer op die "Wys meer..."-skakel geklik word.';
$string['configmaxanswers'] = 'Verstek maksimum aantal antwoorde per blad';
$string['configmediaclose'] = 'Wys \'n "maak toe"-knoppie as deel van die opwip wat vir \'n gekoppelde medialêer gegenereer word.';
$string['configmediaheight'] = 'Stel die hoogte van die opwip wat vir \'n gekoppelde medialêer gewys word';
$string['configmediawidth'] = 'Stel die breedte van die opwip wat vir \'n gekoppelde medialêer gewys word';
$string['configpassword_desc'] = 'Of \'n wagwoord benodig word om toegang tot die les te verkry';
$string['configslideshowbgcolor'] = 'Agtergrondkleur vir die skyfievertoning indien dit geaktiveer is';
$string['configslideshowheight'] = 'Stel die hoogte van die skyfievertoning indien dit geaktiveer is';
$string['configslideshowwidth'] = 'Stel die wydte van die skyfievertoning indien dit geaktiveer is';
$string['configtimelimit_desc'] = 'As \'n tydsgrens gestel is, sal \'n waarskuwing aan die begin van die les gewys word en daar sal \'n afteller wees. Indien op zero gestel, is daar geen tydsgrens nie.';
$string['confirmdelete'] = 'Skrap blad';
$string['confirmdeletionofthispage'] = 'Bevestig skrapping van hierdie blad';
$string['congratulations'] = 'Veels geluk - einde van les bereik';
$string['continue'] = 'Gaan voort';
$string['continuetoanswer'] = 'Gaan voort om antwoorde te verander.';
$string['continuetonextpage'] = 'Gaan voort na volgende blad';
$string['correctanswerjump'] = 'Sprong ná korrekte antwoord';
$string['correctanswerscore'] = 'Punt ná korrekte antwoord';
$string['correctresponse'] = 'Korrekte respons';
$string['createaquestionpage'] = 'Skep \'n vraagblad';
$string['credit'] = 'Krediet';
$string['customscoring'] = 'Verpersoonlik bepunting';
$string['customscoring_help'] = 'Indien geaktiveer, kan \'n numeriese puntwaarde (positief of negatief) aan elke vraag toegeken word.';
$string['deadline'] = 'Spertyd';
$string['defaultessayresponse'] = 'Jou opstel sal deur jou onderwyser bepunt word.';
$string['deleteallattempts'] = 'Skrap alle lespogings';
$string['deletedefaults'] = '{$a} x lesse by verstek geskrap';
$string['deletedpage'] = 'Blad geskrap';
$string['deletepagenamed'] = 'Skrap blad: {$a}';
$string['deleting'] = 'Skrap';
$string['deletingpage'] = 'Skrap blad: {$a}';
$string['dependencyon'] = 'Afhanklik van';
$string['dependencyon_help'] = 'Hierdie instelling bepaal of toegang tot hierdie les afhanklik gaan wees van \'n student se prestasie in ander lesse in dieselfde kursus. Enige kombinasie van tyd bestee, afgehandel of "punt beter as" kan gebruik word.';
$string['description'] = 'Beskrywing';
$string['deselectallattempts'] = 'Ontkies alle pogings';
$string['detailedstats'] = 'Gedetailleerde statistiek';
$string['didnotanswerquestion'] = 'Het nie hierdie vraag beantwoord nie';
$string['didnotreceivecredit'] = 'Het nie hierdie krediet ontvang nie';
$string['disabled'] = 'Gedeaktiveer';
$string['displaydefaultfeedback'] = 'Gebruik verstekterugvoer';
$string['displaydefaultfeedback_help'] = 'Indien geaktiveer, wanneer \'n respons op \'n spesifieke antwoord nie gevind word nie, sal die verstekantwoord "Dis die regte antwoord" of "Dis die verkeerde antwoord" gewys word.';
$string['displayinleftmenu'] = 'Wys in kieslys?';
$string['displayleftif'] = 'Minimum punt wat in kieslys gewys moet word';
$string['displayleftif_help'] = 'Hierdie instelling bepaal of \'n student \'n sekere  punt moet behaal voordat die leskieslys bekyk kan word. Dit forseer studente om met hul eerste poging deur die hele les te werk. Wanneer hulle die vereiste punt behaal het, kan hulle dan die kieslys oorsigtelik beskou.';
$string['displayleftmenu'] = 'Wys kieslys';
$string['displayleftmenu_help'] = 'Indien geaktiveer, word \'n kieslys gewys wat dit vir gebruikers moontlik maak om deur die lys blaaie te navigeer.';
$string['displayofgrade'] = 'Wys van punt (slegs vir studente)';
$string['displayreview'] = 'Bied opsie om \'n vraag weer te probeer';
$string['displayreview_help'] = 'Indien geaktiveer, wanneer \'n vraag verkeerd beantwoord word, word die student die opsie gegee om weer te probeer vir geen krediete nie, of om voort te gaan met die les. As die student klik om na \'n ander vraag aan te beweeg, sal die geselekteerde (verkeerde) antwoord gevolg word. By verstek word spronge vanaf verkeerde antwoorde op "hierdie blad" gestel en het \'n 0-punt. Daar word dus aanbeveel dat jy spronge vanaf verkeerde antwoorde na \'n ander blad stel om verwarring van jou studente te verhoed.';
$string['displayscorewithessays'] = '<p>Jy het {$a->score} uit {$a->tempmaxgrade} vir die outomatiesbepunte vrae behaal.</p>
<p>Jou {$a->essayquestions}-opstelvraag(-vrae) sal op \'n latere datum bepunt en by jou finale punt getel word.</p>
<p>Jou huidige punt sonder die opstelvraag(-vrae) is {$a->score} uit {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Jou punt is {$a->score} (uit {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplikaatblad: {$a}';
$string['edit'] = 'Redigeer';
$string['editbranchtable'] = 'Redigeer \'n inhoudblad';
$string['editcluster'] = 'Redigeer \'n kluster';
$string['editendofbranch'] = 'Redigering van \'n einde-van-vertakking-blad';
$string['editendofcluster'] = 'Redigering van \'n einde-van-kluster-blad';
$string['editessay'] = 'Redigering van \'n opstelvraagblad';
$string['editingquestionpage'] = 'Redigeer {$a}-vraagblad';
$string['editlessonsettings'] = 'Redigeer lesinstellings';
$string['editmatching'] = 'Redigering van \'n blad met bypassende vrae';
$string['editmultichoice'] = 'Redigering van \'n blad met veelkeusevrae';
$string['editnumerical'] = 'Redigering van \'n blad met numeriese vrae';
$string['editoverride'] = 'Oorheers redigering';
$string['editpage'] = 'Redigeer bladinhoud';
$string['editpagecontent'] = 'Redigeer bladinhoud';
$string['editquestion'] = 'Redigeer \'n vraagblad';
$string['editshortanswer'] = 'Redigeer \'n "Kort antwoord"-vraagblad';
$string['edittruefalse'] = 'Redigeer \'n "Waar/vals"-vraagblad';
$string['email'] = 'E-pos';
$string['emailallgradedessays'] = 'E-pos ALLE bepunte opstelle';
$string['emailgradedessays'] = 'E-pos bepunte opstelle';
$string['emailsuccess'] = 'E-pos suksesvol versend';
$string['emptypassword'] = 'Wagwoord kan nie leeg wees nie';
$string['enabled'] = 'Geaktiveer';
$string['endofbranch'] = 'Einde van vertakking';
$string['endofcluster'] = 'Einde van kluster';
$string['endofclustertitle'] = 'Einde van kluster';
$string['endoflesson'] = 'Einde van les';
$string['enteredthis'] = 'hierdie ingevoer.';
$string['enterpassword'] = 'Voer asseblief die wagwoord in:';
$string['eolstudentoutoftime'] = 'Neem kennis: Jou tyd vir hierdie les was om. Jou laaste antwoord tel dalk nie as dit beantwoord is nadat die tyd verstryk het.';
$string['eolstudentoutoftimenoanswers'] = 'Jy het nie enige vrae beantwoord nie. Jy het \'n 0 vir hierdie les gekry.';
$string['essay'] = 'Opstel';
$string['essayemailmessage2'] = '<p>Por vir opstelle: {$a->question}</p><p>Jou respons: <em>{$a->response}</em></p><p>Nasiener se kommentaar: <em>{$a->comment}</em></p><p>Jy het {$a->earned} uit {$a->outof} vir hierdie opstelvraag gekry.</p><p>Jou punt vir die {$a->lesson}-les is verander na {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Jy het {$a->earned} uit {$a->outof} vir hierdie opstelvraag gekry.</p><p>Jou punt vir die {$a->lesson}-les is verander na {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Punt beskikbaar vir lesvraag';
$string['essaynotgradedyet'] = 'Hierdie opstel is nog nie bepunt nie';
$string['essayresponses'] = 'Opstelresponse';
$string['essays'] = 'Opstelle';
$string['essayscore'] = 'Opstelpunt';
$string['eventcontentpageviewed'] = 'Inhoudblad bekyk';
$string['eventessayassessed'] = 'Opstel geassesseer';
$string['eventessayattemptviewed'] = 'Opstelpoging bekyk';
$string['eventlessonended'] = 'Les geëindig';
$string['eventlessonrestarted'] = 'Les herbegin';
$string['eventlessonresumed'] = 'Les hervat';
$string['eventlessonstarted'] = 'Les begin';
$string['eventoverridecreated'] = 'Lesoorheersing geskep';
$string['eventoverridedeleted'] = 'Lesoorheersing geskrap';
$string['eventoverrideupdated'] = 'Lesoorheersing bygewerk';
$string['eventpagecreated'] = 'Blad geskep';
$string['eventpagedeleted'] = 'Blad geskrap';
$string['eventpagemoved'] = 'Blad verskuif';
$string['eventpageupdated'] = 'Blad bygewerk';
$string['eventquestionanswered'] = 'Vraag beantwoord';
$string['eventquestionviewed'] = 'Vraag bekyk';
$string['false'] = 'Vals';
$string['fileformat'] = 'Lêerformaat';
$string['finalwrong'] = 'Nie heeltemal nie.';
$string['finish'] = 'Maak klaar';
$string['firstanswershould'] = 'Eerste antwoord moet spring na die "Korrek"-blad';
$string['firstwrong'] = 'Jy het verkeerd geantwoord. Wil jy die vraag weer probeer? (As jy die vraag nou korrek beantwoord, sal dit nie vir jou finale punt tel nie.)';
$string['flowcontrol'] = 'Vloeibeheer';
$string['fractionsaddwrong'] = 'Die positiewe punte wat jy gekies het, is nie gelyk aan 100% nie.<br />Om die waarheid te sê, hulle is gelyk aan {$a}%.<br />Wil jy teruggaan en hierdie vraag regstel?';
$string['fractionsnomax'] = 'Een van die antwoorde moet 100% wees sodat dit <br />moontlik is om die volle punt vir daardie vraag te kry.<br />Wil jy teruggaan en hierdie vraag regstel?';
$string['full'] = 'Uitgevou';
$string['general'] = 'Algemeen';
$string['gotoendoflesson'] = 'Gaan na die einde van die les';
$string['grade'] = 'Punt';
$string['gradebetterthan'] = 'Punt beter as (%)';
$string['gradebetterthanerror'] = 'Verdien \'n punt beter as {$a} persent';
$string['graded'] = 'Bepunt';
$string['gradeessay'] = 'Bepunt opstelvrae ({$a->notgradedcount} nie bepunt en {$a->notsentcount} nie gestuur nie)';
$string['gradeis'] = 'Punt is {$a}';
$string['gradeoptions'] = 'Puntopsies';
$string['groupoverrides'] = 'Groepoorheersings';
$string['groupoverridesdeleted'] = 'Groepoorheersings geskrap';
$string['groupsnone'] = 'Geen groepe waartoe jy toegang het nie.';
$string['handlingofretakes'] = 'Hantering van herhalings';
$string['handlingofretakes_help'] = 'Indien herhalings toegelaat word, spesifiseer hierdie instelling of die punt vir die les die gemiddeld of die maksimum van alle pogings is.';
$string['havenotgradedyet'] = 'Nog nie nagesien nie.';
$string['here'] = 'hier';
$string['highscore'] = 'Hoogste punt';
$string['hightime'] = 'Hoogste tyd';
$string['importcount'] = 'Invoer van {$a}-vrae';
$string['importquestions'] = 'Voer vrae in';
$string['importquestions_help'] = 'Hierdie kenmerk maak dit moontlik om vrae in \'n verskeidenheid formate via \'n tekslêer in te voer.';
$string['inactiveoverridehelp'] = '* Hierdie oorheersing is onaktief omdat die gebruiker se toegang tot die aktiwiteit beperk is. Dit kan wees weens groep- of roltoewysings, ander toegangsbeperkings of omdat die aktiwiteit verberg is.';
$string['indicator:cognitivedepth'] = 'Les kognitief';
$string['indicator:cognitivedepth_help'] = 'Hierdie aanwyser is gegrond op die kognitiewe diepte wat die student in \'n lesaktiwiteit behaal het.';
$string['indicator:cognitivedepthdef'] = 'Les kognitief';
$string['indicator:cognitivedepthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die kognitiewe betrokkenheid bereik wat deur die lesaktiwiteite aangebied word (Vlakke = Nie bekyk nie, Bekyk, Ingedien, Terugvoer bekyk. Kommentaar op terugvoer, Herindiening nadat terugvoer bekyk is)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Les sosiaal';
$string['indicator:socialbreadth_help'] = 'Hierdie aanwyser is gegrond op die sosiale omvang wat deur die student in \'n lesaktiwiteit bereik is.';
$string['indicator:socialbreadthdef'] = 'Les sosiaal';
$string['indicator:socialbreadthdef_help'] = 'Die deelnemer het tydens hierdie ontledingsinterval hierdie persentasie van die sosiale betrokkenheid bereik wat deur die lesaktiwiteite aangebied word (Vlakke = Geen deelname nie, Slegs deelnemer, Deelnemer saam met ander)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Ingevoegde blad';
$string['invalidfile'] = 'Ongeldige lêer';
$string['invalidid'] = 'Geen kursusmodule-ID of les-ID is geslaag nie';
$string['invalidlessonid'] = 'les-ID is verkeerd';
$string['invalidoverrideid'] = 'Ongeldige oorheers-ID';
$string['invalidpageid'] = 'Ongeldige blad-ID';
$string['jump'] = 'Sprong';
$string['jumps'] = 'Spronge';
$string['jumps_help'] = 'Elke antwoord (vir vrae) of beskrywing (vir inhoudsblaaie) het \'n ooreenstemmende sprong. Die sprong kan relatief wees, soos hierdie bladsy of volgende bladsy, of absoluut, wat daarop neerkom dat een of meer bladsye in die les gespesifiseer word.';
$string['jumpsto'] = 'Spring na <em>{$a}</em>';
$string['leftduringtimed'] = 'Jy het tydens \'n les met \'n tydsgrens vertrek.<br />Klik asseblief op Gaan voort om die les te herbegin.';
$string['leftduringtimednoretake'] = 'Jy het tydens \'n les met \'n tydsgrens vertrek en jy word<br />nie toegelaat om die les oor te doen of daarmee voort te gaan nie.';
$string['leftduringtimedsession'] = 'Jy het tydens \'n les met \'n tydsgrens vertrek.';
$string['lesson:addinstance'] = 'Voeg \'n nuwe les by';
$string['lesson:edit'] = 'Redigeer \'n lesaktiwiteit';
$string['lesson:grade'] = 'Bepunt lesse se opstelvrae';
$string['lesson:manage'] = 'Bestuur \'n lesaktiwiteit';
$string['lesson:manageoverrides'] = 'Bestuur lesoorheersings';
$string['lesson:view'] = 'Bekyk lesaktiwiteit';
$string['lesson:viewreports'] = 'Bekyk lesverslae';
$string['lessonclosed'] = 'Hierdie les het op {$a} gesluit.';
$string['lessoncloses'] = 'Les sluit';
$string['lessoneventcloses'] = '{$a} sluit';
$string['lessoneventopens'] = '{$a} open';
$string['lessonformating'] = 'Lesformatering';
$string['lessonmenu'] = 'Leskieslys';
$string['lessonnotready'] = 'Hierdie les kan nog nie geneem word nie. Kontak jou {$a} asseblief.';
$string['lessonnotready2'] = 'Hierdie les kan nog nie geneem word nie.';
$string['lessonopen'] = 'Hierdie les sal op {$a} open.';
$string['lessonopens'] = 'Les open';
$string['lessonpagelinkingbroken'] = 'Eerste bladsy nie gevind nie. Skakel met lesblaaie is waarskynlik verbreek. Kontak admin asseblief.';
$string['lessonstats'] = 'Lesstatistiek';
$string['linkedmedia'] = 'Gekoppelde media';
$string['loginfail'] = 'Kon nie aanmeld nie. Probeer asseblief weer...';
$string['lowscore'] = 'Lae punt';
$string['lowtime'] = 'Lae tyd';
$string['manualgrading'] = 'Bepunt opstelle';
$string['matchesanswer'] = 'Pas by antwoord';
$string['matching'] = 'Ooreenstemming';
$string['matchingpair'] = 'Ooreenstemmende paar {$a}';
$string['maxgrade'] = 'Maksimum punt';
$string['maxgrade_help'] = 'Hierdie instelling spesifiseer die maksimum punt vir die les. As dit op 0 gestel is, word die les nie in die punteblad gewys nie.';
$string['maximumnumberofanswersbranches'] = 'Maksimum aantal antwoorde';
$string['maximumnumberofanswersbranches_help'] = 'Hierdie instelling spesifiseer die maksimum aantal antwoorde wat in die les gebruik kan word. As slegs waar/vals-antwoorde gebruik word, kan dit op 2 gestel word. Die instelling kan op enige tydstip verander word aangesien dit slegs \'n impak het op wat vir die onderwyser sigbaar is, nie op die data nie.';
$string['maximumnumberofattempts'] = 'Maksimum aantal pogings per vraag';
$string['maximumnumberofattempts_help'] = 'Hierdie instelling bepaal die maksimum aantal pogings wat vir elke vraag toegelaat word. Indien die antwoord by herhaling verkeerd is, sal die volgende blad van die les gewys word wanneer die maksimum bereik is.';
$string['maximumnumberofattemptsreached'] = 'Maksimum aantal pogings bereik - Beweeg aan na volgende blad';
$string['mediaclose'] = 'Wys sluitknoppie';
$string['mediafile'] = 'Gekoppelde media';
$string['mediafile_help'] = '\'n Medialêer kan opgelaai word vir gebruik in die les. \'n "Klik hier om te bekyk"-skakel sal dan in \'n blokkie genaamd "Gekoppelde media" op elke blad van die les gewys word.';
$string['mediafilepopup'] = 'Klik hier om te bekyk';
$string['mediaheight'] = 'Hoogte van opwipvenster';
$string['mediawidth'] = 'Breedte van opwipvenster';
$string['messageprovider:graded_essay'] = 'Kennisgewing van bepunte lesopstel';
$string['minimumnumberofquestions'] = 'Minimum aantal vrae';
$string['minimumnumberofquestions_help'] = 'Hierdie instelling spesifiseer die minimum aantal vrae wat gebruik sal word om \'n punt vir die aktiwiteit te bereken.';
$string['missingname'] = 'Tik asseblief \'n alias in';
$string['modattempts'] = 'Laat studenthersiening toe';
$string['modattempts_help'] = 'Indien geaktiveer kan studente weer van vooraf deur die les navigeer.';
$string['modattemptsnoteacher'] = 'Studenthersiening slegs van toepassing op studente.';
$string['modulename'] = 'Les';
$string['modulename_help'] = 'Die module lesaktiwiteite stel \'n onderwyser in staat om inhoud en/of oefeninge op interessante en aanpasbare wyses te lewer. \'n Onderwyser kan die les gebruik om \'n lineêre stel inhoudblaaie of instruksionele aktiwiteite te skep wat \'n verskeidenheid weë of opsies vir die leerder bied. In beide gevalle kan die onderwyser kies om betrokkenheid te verhoog en begrip te verseker deur \'n verskeidenheid vrae soos veelkeuse-, bypassende en kortantwoorde in te sluit. Afhangende van die antwoord wat deur die student gekies word en hoe die onderwyser die les ontwikkel, kan studente na die volgende bladsy vorder, teruggeneem word na die vorige bladsy of herlei word na \'n heel ander weg.

\'n Les kan bepunt word en die punt sal in die punteboek aangeteken word.

Lesse kan gebruik word
* Vir self-gerigte leer van \'n nuwe onderwerp
* Vir scenario\'s of nabootsing-/besluitnemingsoefeninge
* Vir gedifferensieerde hersiening, met verskillende stelle hersieningsvrae na gelang van antwoorde wat op aanvanklike vrae verstrek is';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lesse';
$string['move'] = 'Verskuif blad';
$string['movedpage'] = 'Blad verskuif';
$string['movepagehere'] = 'Blad hierheen verskuif';
$string['movepagenamed'] = 'Verskuif blad: {$a}';
$string['moving'] = 'Verskuiwing van blad: {$a}';
$string['multianswer'] = 'Meervoudige antwoorde';
$string['multianswer_help'] = 'Merk hierdie blokkie as meer as een respons \'n korrekte antwoord is.';
$string['multichoice'] = 'Veelkeuse';
$string['multipleanswer'] = 'Meervoudige antwoord';
$string['nameapproved'] = 'Naam goedgekeur';
$string['namereject'] = 'Jammer, jou naam is deur die filter verwerp.<br />Probeer \'n ander naam.';
$string['new'] = 'nuut';
$string['nextpage'] = 'Volgende blad';
$string['noanswer'] = 'Geen antwoord is vir een of meer antwoord verstrek nie. Gaan asseblief terug en verstrek \'n antwoord.';
$string['noattemptrecordsfound'] = 'Geen rekord van pogings gevind nie: geen punt toegeken nie';
$string['nobranchtablefound'] = 'Geen inhoudblad gevind nie';
$string['noclose'] = 'Geen sluitingsdatum nie';
$string['nocommentyet'] = 'Nog geen kommentaar nie.';
$string['nocoursemods'] = 'Geen aktiwiteite gevind nie';
$string['nocredit'] = 'Geen krediet nie';
$string['nodeadline'] = 'Geen spertyd nie';
$string['noessayquestionsfound'] = 'Geen opstelvrae in hierdie les gevind nie';
$string['nohighscores'] = 'Geen hoogste punte nie';
$string['nolessonattempts'] = 'Geen pogings is in hierdie les aangewend nie';
$string['nolessonattemptsgroup'] = 'Geen pogings is deur {$a} groeplede in hierdie les aangewend nie';
$string['none'] = 'Geen';
$string['nooneansweredcorrectly'] = 'Niemand het korrek geantwoord nie.';
$string['nooneansweredthisquestion'] = 'Niemand het hierdie vraag beantwoord nie.';
$string['noonecheckedthis'] = 'Niemand het hierdie gemerk nie.';
$string['nooneenteredthis'] = 'Niemand het hierdie ingevoer nie.';
$string['noonehasanswered'] = 'Nog niemand het \'n opstelvraag beantwoord nie.';
$string['noonehasansweredgroup'] = 'Niemand in {$a} het nog \'n opstelvraag beantwoord nie.';
$string['noopen'] = 'Geen openingsdatum nie';
$string['nooverridedata'] = 'Jy moet ten minste een van die lesinstellings oorheers.';
$string['noretake'] = 'Jy word nie toegelaat om hierdie les weer te neem nie.';
$string['normal'] = 'Normaal - volg lesroete';
$string['notcompleted'] = 'Nie voltooi nie';
$string['notcompletedwithdate'] = 'Nie voltooi nie ({$a})';
$string['notdefined'] = 'Nie omskryf nie';
$string['notenoughsubquestions'] = 'Nie voldoende subvrae omskryf nie!';
$string['notenoughtimespent'] = 'Jy het hierdie les in {$a->timespent} voltooi, wat minder is as die verlangde tyd van {$a->timerequired}. Jy sal hierdie les dalk weer moet probeer.';
$string['notgraded'] = 'Nie bepunt nie';
$string['notitle'] = 'Geen titel nie';
$string['notyetcompleted'] = 'Les is begin, maar nog nie afgehandel nie';
$string['numberofcorrectanswers'] = 'Aantal korrekte antwoorde: {$a}';
$string['numberofcorrectanswersheader'] = 'Aantal korrekte antwoorde';
$string['numberofcorrectmatches'] = 'Getal korrekte passings: {$a}';
$string['numberofpagestoshow'] = 'Aantal blaaie wat gewys moet word';
$string['numberofpagestoshow_help'] = 'Hierdie instelling spesifiseer die aantal bladsye wat in \'n les gewys word. Dit het slegs betrekking op lesse waar bladsye in \'n lukrake volgorde gewys word (waar "Aksie ná korrekte antwoord" op "Wys \'n ongesiene blad" of "Wys \'n onbeantwoorde blad" gestel is). Indien op zero gestel, sal alle bladsye gewys word.';
$string['numberofpagesviewed'] = 'Aantal vrae beantwoord: {$a}';
$string['numberofpagesviewedheader'] = 'Aantal vrae beantwoord';
$string['numberofpagesviewednotice'] = 'Aantal vrae beantwoord: {$a->nquestions} (Jy moet ten minste {$a->minquestions} beantwoord)';
$string['numerical'] = 'Numeries';
$string['numericanswer'] = 'Numeriese antwoord';
$string['numericanswer_help'] = 'Jy kan \'n enkele nommer spesifiseer, of \'n reeks nommers deur \'n dubbelpunt te gebruik. Byvoorbeeld 2:5 beteken enige antwoord tuseen 2 en 5 met inbegrip van 2 en 5 is korrek.';
$string['offlinedatamessage'] = 'Jy het via \'n mobiele toestel aan hierdie poging gewerk. Data is {$a} laas op hierdie webwerf gestoor. Maak asseblief seker dat jy nie enige werk het wat nie gestoor is nie.';
$string['ongoing'] = 'Wys deurlopende punt';
$string['ongoing_help'] = 'Indien geaktiveer sal elke blad die huidige punt wys wat die student tot dusver uit die moontlike totaal verdien het.';
$string['ongoingcustom'] = 'Jy het tot dusver {$a->score} punt(e) uit {$a->currenthigh} punt(e) verdien.';
$string['ongoingnormal'] = 'Jy het {$a->correct} korrek uit {$a->viewed} pogings beantwoord.';
$string['onpostperpage'] = 'Slegs een plasing per punt';
$string['openafterclose'] = 'Jy het \'n openingsdatum ná die sluitingsdatum gespesifiseer.';
$string['options'] = 'Opsies';
$string['or'] = 'OF';
$string['ordered'] = 'Georden';
$string['other'] = 'Ander';
$string['outof'] = 'Uit {$a}';
$string['override'] = 'Oorheers';
$string['overridedeletegroupsure'] = 'Is jy seker jy wil die oorheersing vir groep {$a} skrap?';
$string['overridedeleteusersure'] = 'Is jy seker jy wil die oorheersing vir gebruiker {$a} skrap?';
$string['overridegroup'] = 'Oorheers groep';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Oorheersings';
$string['overrideuser'] = 'Oorheers gebruiker';
$string['overrideusereventname'] = '{$a->lesson} - Oorheersing';
$string['overview'] = 'Oorsig';
$string['overview_help'] = '\'n Les bestaan uit \'n aantal bladsye en, opsioneel, inhoudsbladsye. \'n Bladsy bevat een of ander inhoud en eindig gewoonlik met \'n vraag. Elke antwoord op die vraag word met \'n sprong geassosieer. Die sprong kan relatief wees, soos hierdie bladsy of volgende bladsy, of dit kan absoluut wees deurdat een van die bladsye in die les gespesifeer word. \'n Inhoudsblad is \'n bladsy wat \'n stel skakels na ander bladsye in die les bevat, byvoorbeeld \'n Inhoudsopgawe.';
$string['page'] = 'Bladsy: {$a}';
$string['page-mod-lesson-edit'] = 'Redigeer lesblad';
$string['page-mod-lesson-view'] = 'Bekyk of kry \'n voorskou van lesblad';
$string['page-mod-lesson-x'] = 'Enige lesblad';
$string['pageanswers'] = 'Bladantwoorde';
$string['pagecontents'] = 'Bladinhoud';
$string['pageresponses'] = 'Bladresponse';
$string['pages'] = 'Blaaie';
$string['pagetitle'] = 'Bladtitel';
$string['password'] = 'Wagwoord';
$string['passwordprotectedlesson'] = '{$a} is \'n wagwoordbeskermde les.';
$string['pleasecheckoneanswer'] = 'Gaan asseblief een antwoord na.';
$string['pleasecheckoneormoreanswers'] = 'Gaan asseblief een of meer antwoorde na.';
$string['pleaseenteryouranswerinthebox'] = 'Tik asseblief jou antwoord in die blokkie.';
$string['pleasematchtheabovepairs'] = 'Vind asseblief \'n passing tussen die pare hierbo';
$string['pluginadministration'] = 'Lesadministrasie';
$string['pluginname'] = 'Les';
$string['pointsearned'] = 'Punte verdien';
$string['postprocesserror'] = 'Fout tydens bewerking van plasing!';
$string['postsuccess'] = 'Plasing suksesvol';
$string['practice'] = 'Oefenles';
$string['practice_help'] = '\'n Oefenles word nie in die punteboek gewys nie.';
$string['preprocesserror'] = 'Iets het skeefgeloop tydens voorafbewerking!';
$string['prerequisiteisobsolete'] = 'Die opsie "Voorvereisteles" gaan binnekort verwyder word. Gebruik asseblief eerder toegangsbeperkings.';
$string['prerequisitelesson'] = 'Voorvereisteles';
$string['preview'] = 'Bekyk vooraf';
$string['previewlesson'] = 'Bekyk {$a} vooraf';
$string['previewpagenamed'] = 'Bekyk bladsy vooraf: {$a}';
$string['previouspage'] = 'Vorige bladsy';
$string['privacy:metadata:attempts'] = '\'n Rekord van bladsypogings';
$string['privacy:metadata:attempts:answerid'] = 'Die antwoord se ID';
$string['privacy:metadata:attempts:correct'] = 'Of die poging korrek was';
$string['privacy:metadata:attempts:pageid'] = 'Die bladsy se ID';
$string['privacy:metadata:attempts:retry'] = 'Die poging se nommer';
$string['privacy:metadata:attempts:timeseen'] = 'Die tyd toe die poging aangewend is';
$string['privacy:metadata:attempts:useranswer'] = 'Details van die gebruiker se antwoord';
$string['privacy:metadata:attempts:userid'] = 'Die gebruiker se ID';
$string['privacy:metadata:branch'] = '\'n Rekord van die bladsye wat bekyk is';
$string['privacy:metadata:branch:flag'] = 'Of die volgende bladsy lukraak bereken is';
$string['privacy:metadata:branch:nextpageid'] = 'Die volgende bladsy se ID';
$string['privacy:metadata:branch:pageid'] = 'Die bladsy se ID';
$string['privacy:metadata:branch:retry'] = 'Die nommer van die poging';
$string['privacy:metadata:branch:timeseen'] = 'Die tyd toe die bladsy bekyk is';
$string['privacy:metadata:branch:userid'] = 'Die gebruiker se ID';
$string['privacy:metadata:grades'] = '\'n Rekord van die punte vir elke les';
$string['privacy:metadata:grades:completed'] = 'Die datum toe die punt toegeken is';
$string['privacy:metadata:grades:grade'] = 'Die punt wat toegeken is';
$string['privacy:metadata:grades:userid'] = 'Die gebruiker se ID';
$string['privacy:metadata:overrides'] = '\'n Rekord van oorheersings per les';
$string['privacy:metadata:overrides:available'] = 'Die tyd wanneer die les aangedurf kan word';
$string['privacy:metadata:overrides:deadline'] = 'Die keertyd vir voltooiing van die les';
$string['privacy:metadata:overrides:maxattempts'] = 'Die maksimum aantal pogings';
$string['privacy:metadata:overrides:password'] = 'Die wagwoord vir toegang tot die les';
$string['privacy:metadata:overrides:retake'] = 'Of herhaling toegelaat word';
$string['privacy:metadata:overrides:review'] = 'Of \'n volgende probeerslag vir \'n vraag toegelaat word';
$string['privacy:metadata:overrides:timelimit'] = 'Tydsgrens vir voltooiing van die les, in sekondes';
$string['privacy:metadata:overrides:userid'] = 'Die gebruiker se ID';
$string['privacy:metadata:timer'] = '\'n Rekord van lespogings';
$string['privacy:metadata:timer:completed'] = 'Of die poging volledig is';
$string['privacy:metadata:timer:lessontime'] = 'Wanneer ons laas \'n aktiwiteit aangeteken het';
$string['privacy:metadata:timer:starttime'] = 'Die datum waarop die poging begin het';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Wanneer ons laas \'n aktiwiteit van die selfoontoepassing aangeteken het';
$string['privacy:metadata:timer:userid'] = 'Die gebruiker se ID';
$string['privacy:metadata:userpref:lessonview'] = 'Die aansigmodus wat verkies word wanneer lesse geredigeer word';
$string['privacy:path:essayanswers'] = 'Opstelantwoorde';
$string['privacy:path:essayresponses'] = 'Opstelresponse';
$string['privacy:path:pages'] = 'Bladsye';
$string['processerror'] = 'Iets het skeefgeloop tydens bewerking!';
$string['progressbar'] = 'Vorderingsbalk';
$string['progressbar_help'] = 'Indien geaktiveer word \'n balk onderaan lesblaaie gewys wat die beraamde persentasie van afhandeling aantoon.';
$string['progressbarteacherwarning'] = 'Vorderingsbalk word nie gewys vir {$a} nie';
$string['progressbarteacherwarning2'] = 'Jy sien nie die vorderingsbalk nie omdat jy nie hierdie les kan redigeer nie.';
$string['progresscompleted'] = 'Jy het {$a}% van die les voltooi';
$string['qtype'] = 'Tipe bladsy';
$string['question'] = 'Vraag';
$string['questionoption'] = 'Vraag';
$string['questiontype'] = 'Tipe vraag';
$string['randombranch'] = 'Lukrake inhoudblad';
$string['randompageinbranch'] = 'Lukrake vraag binne \'n inhoudblad';
$string['rank'] = 'Beoordeel';
$string['rawgrade'] = 'Onbewerkte punt';
$string['receivedcredit'] = 'Krediet toegeken';
$string['redisplaypage'] = 'Wys blad weer';
$string['removeallgroupoverrides'] = 'Skrap alle groepoorheersings';
$string['removealluseroverrides'] = 'Skrap alle gebruikeroorheersings';
$string['report'] = 'Verslag';
$string['reports'] = 'Verslae';
$string['response'] = 'Respons';
$string['retakesallowed'] = 'Herhalings toegelaat';
$string['retakesallowed_help'] = 'Indien geaktiveer, kan studente hierdie les meer as een keer aandurf.';
$string['returnto'] = 'Gaan terug na {$a}';
$string['returntocourse'] = 'Gaan terug na die kursus';
$string['reverttodefaults'] = 'Stel les se verstekinstellings terug';
$string['review'] = 'Hersien';
$string['reviewlesson'] = 'Hersien les';
$string['reviewquestionback'] = 'Ja, ek wil weer probeer.';
$string['reviewquestioncontinue'] = 'Nee, ek wil net voortgaan na die volgende vraag.';
$string['sanitycheckfailed'] = 'Normaliteitstoets het misluk: Hierdie poging is geskrap';
$string['save'] = 'Stoor';
$string['savechanges'] = 'Stoor wysigings';
$string['savechangesandeol'] = 'Stoor alle wysigings en gaan na die einde van die les';
$string['saveoverrideandstay'] = 'Stoor en voer \'n ander oorheersing in';
$string['savepage'] = 'Stoor bladsy';
$string['score'] = 'Bepunt';
$string['score_help'] = 'Bepunt word slegs gebruik wanneer pasgemaakte bepunting geaktiveer is. Dan kan \'n numeriese puntwaarde (positief of negatief) aan elke antwoord toegeken word.';
$string['scores'] = 'Punte';
$string['search:activity'] = 'Les - aktiwiteitinligting';
$string['secondpluswrong'] = 'Nie heeltemal nie. Wil jy weer probeer?';
$string['selectallattempts'] = 'Kies alle pogings';
$string['selectaqtype'] = 'Kies \'n tipe vraag';
$string['sent'] = 'Gestuur';
$string['shortanswer'] = 'Kortantwoord';
$string['showanunansweredpage'] = 'Kies \'n onbeantwoorde bladsy';
$string['showanunseenpage'] = 'Wys \'n bladsy wat nog nie bekyk is nie';
$string['singleanswer'] = 'Enkelantwoord';
$string['skip'] = 'Slaan navigasie oor';
$string['slideshow'] = 'Skyfievertoning';
$string['slideshow_help'] = 'Indien geaktiveer word die les as \'n skyfievertoning gewys, met \'n vasgestelde wydte en hoogte.';
$string['slideshowbgcolor'] = 'Skyfievertoning se agtergrondkleur';
$string['slideshowheight'] = 'Skyfievertoning se hoogte';
$string['slideshowwidth'] = 'Skyfievertoning se wydte';
$string['startlesson'] = 'Begin les';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} se pogingnommer {$a->attempt}';
$string['studentname'] = '{$a} Naam';
$string['studentoneminwarning'] = 'Waarskuwing: Jy het 1 minuut of minder om hierdie les af te handel.';
$string['studentoutoftimeforreview'] = 'Neem kennis: Die tyd vir hersiening van hierdie les is om.';
$string['studentresponse'] = '{$a} se respons';
$string['submit'] = 'Dien in';
$string['submitname'] = 'Dien naam in';
$string['teacherjumpwarning'] = '\'n {$a->cluster}-sprong of \'n {$a->unseen}-sprong word in hierdie les gebruik. In plaas daarvan sal "spring na volgende blad" gebruik word. Meld aan as \'n student om hierdie spronge te toets.';
$string['teacherongoingwarning'] = 'Die deurlopende punt word slegs vir die student gewys. Meld aan as \'n student om die deurlopende punt te toets.';
$string['teachertimerwarning'] = 'Tydreëlaar werk slegs vir studente. Toets die tydreëlaar deur as \'n student aan te meld.';
$string['thatsthecorrectanswer'] = 'Daardie is die korrekte antwoord';
$string['thatsthewronganswer'] = 'Daardie is die verkeerde antwoord';
$string['thefollowingpagesjumptothispage'] = 'Die volgende bladsye spring na hierdie bladsy';
$string['thispage'] = 'Hierdie bladsy';
$string['timeisup'] = 'Tyd is om';
$string['timelimit'] = 'Tydgrens';
$string['timelimit_help'] = 'Indien geaktiveer word \'n waarskuwing oor die tydgrens aan die begin van die les gewys en \'n afteltydreëlaar word gewys. Enige antwoorde wat verstrek word nadat die tyd verstryk het, word nie bepunt nie.';
$string['timelimitwarning'] = 'Jy het {$a} om hierdie les af te handel.';
$string['timeremaining'] = 'Oorblywende tyd';
$string['timespenterror'] = 'Bestee ten minste {$a} minute in die les';
$string['timespentminutes'] = 'Tyd bestee (minute)';
$string['timetaken'] = 'Tyd geneem';
$string['totalpagesviewedheader'] = 'Getal bladsye bekyk';
$string['true'] = 'Waar';
$string['truefalse'] = 'Waar/vals';
$string['unabledtosavefile'] = 'Die lêer wat jy opgelaai het, kon nie gestoor word nie.';
$string['unknownqtypesnotimported'] = '{$a} vrae met vraagtipes wat nie ondersteun word nie, is nie ingetrek nie.';
$string['unseenpageinbranch'] = 'Ongesiene vraag binne \'n inhoudsblad';
$string['unsupportedqtype'] = 'Nie-ondersteunde vraagtipe ({$a})!';
$string['updatedpage'] = 'Bygewerkte bladsy';
$string['updatefailed'] = 'Bywerking het misluk';
$string['updatepagenamed'] = 'Werk bladsy by: {$a}';
$string['usemaximum'] = 'Gebruik maksimum';
$string['usemean'] = 'Gebruik gemiddeld';
$string['usepassword'] = 'Wagwoordbeskermde les';
$string['usepassword_help'] = 'Indien geaktiveer word \'n wagwoord verlang om toegang tot die les te verkry.';
$string['useroverrides'] = 'Gebruikeroorheersings';
$string['useroverridesdeleted'] = 'Gebruikeroorheersings geskrap';
$string['usersnone'] = 'Geen studente het toegang tot hierdie les nie';
$string['viewessayanswers'] = 'Bekyk opstelantwoorde';
$string['viewgrades'] = 'Bekyk punte';
$string['viewreports'] = 'Bekyk {$a->attempts} voltooi {$a->student}-pogings';
$string['viewreports2'] = 'Bekyk {$a} voltooide pogings';
$string['warning'] = 'Waarskuwing';
$string['welldone'] = 'Welgedaan!';
$string['whatdofirst'] = 'Wat wil jy eerste doen?';
$string['withselectedattempts'] = 'Met geselekteerde pogings...';
$string['wronganswerjump'] = 'Verkeerde-antwoordsprong';
$string['wronganswerscore'] = 'Verkeerde-antwoordpunt';
$string['wrongresponse'] = 'Verkeerde respons';
$string['youhaveseen'] = 'Jy het reeds meer as een bladsy van hierdie les gesien.<br />Wil jy begin by die laaste bladsy wat jy gesien het?';
$string['youranswer'] = 'Jou antwoord';
$string['yourcurrentgradeis'] = 'Jou huidige punt is {$a}';
$string['yourcurrentgradeisoutof'] = 'Jou huidige punt is {$a->grade} uit {$a->total}';
$string['youshouldview'] = 'Jy moet ten minste {$a} beantwoord.';
