<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintooltwo', language 'eu', version '4.0'.
 *
 * @package     turnitintooltwo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activatemigration'] = 'Gaitu migrazio-tresnaren ezarpenak';
$string['activatemigrationnotice'] = 'Moodleko migrazio-tresnaren gaitzean, V1 migrazio-fitxa erakusten da Turnitin Zeregina 2-ren ezarpenetan.<br/>Fitxa aukeratu ezazu erreminta kudeatzeko (baita bere erabilera desgaitzeko eta migratutako V1 zereginak ezabatzeko ere).';
$string['addresubmissiontiidesc'] = 'Erabiltzailearen berbidalketa Turnitin-era bidalita';
$string['addsubmission'] = 'Gehitu bidalketa';
$string['addsubmissiondesc'] = 'Erabiltzaileak bidalketa gehitu du';
$string['addsubmissiontiidesc'] = 'Erabiltzailearen bidalketa Turnitin-era bidalita';
$string['allowlate'] = 'Baimendu bidalketak entregatze-dataren ondoren';
$string['allownonor'] = 'Baimendu edozein motatako bidalketak?';
$string['allownonor_help'] = 'Ezarpen honek edozein motatako fitxategiak bidaltzeko aukera ematen du. "Bai" aukeratuz gero, posible denean antzekotasuna konprobatuko da, bidalketak jaisteko eskuragarri egongo dira eta GradeMark erremintak eskuragarri izango dira posiblea denean. “Ez” aukeratuz gero soilik Turnitin-ek onartzen dituen fitxategi motak onartuko dira (doc, .docx, .ppt, .pptx, .pps, .ppsx, .pdf, .txt, .htm, .html, .hwp, .odt, .wpd, .ps eta .rtf)';
$string['allsubmissions'] = 'Bidalketen sarrera-ontzia';
$string['anon'] = 'Anonimoa';
$string['anonalert'] = 'Zure mezuaren data oraingoa baino lehenagokoa da, hau gordetzen baduzu zeregin honentzako kalifikazioa behin-betiko desgaituko da.';
$string['anonblindmarkingnote'] = 'Oharra: Turnitin-eko kalifikazio itsua ezabatua izan da. Turnitin-ek Moodleko kalifikazio itsuaren ezarpena erabiliko du kalifikazio itsua egiteko.';
$string['anonenabled'] = 'Kalifikazio itsua gaituta';
$string['anytype'] = 'Edozein bidalketa mota';
$string['assigngeterror'] = 'Ezin izan da turnitintooltwo-eko daturik eskuratu';
$string['assignmentid'] = 'V1 zereginaren IDa';
$string['assignments'] = 'zereginak';
$string['assignmenttitle'] = 'Zeregin berriaren izenburua';
$string['attachrubric'] = 'Erantsi errubrika zereginari';
$string['attachrubricnote'] = 'Oharra: Ikasleek erantsitako errubrika eta euren edukia bidalketak egin aurretik ikusi ahal izango dituzte.';
$string['autorefreshgrades'] = 'Automatikoki eguneratu kalifikazioak / puntuazioak';
$string['autorefreshgrades_help'] = 'Berez, Turnitin-era egiten den dei bakoitzaren ondoren Moodleko integrazio-plugina Turnitin-eko aldaketak Moodlera ekartzen saiatzen da. Ezarpen hau erabili dezakezu jokaera hori desgaitzeko, nahiz eta hori eginda bi sistemen arteko sinkronizazioa mantentzeko kalifikazioak eta antzekotasun-puntuazioak aldiro Moodlen eskuz eguneratu beharko liratekeen.';
$string['ced'] = 'Zereginaren amaiera-data';
$string['changerubricwarning'] = 'Errubrika bat aldatu edo kentzeak zereginean egindako bidalketen errubriken puntuazio guztiak ezabatuko ditu, baita lehendik kalifikatuak zeuden puntuazioak ere. Lehendik kalifikatutako bidalketen guztirako kalifikazioak mantenduko dira.';
$string['checkagainstnote'] = 'Oharra: Ez baduzu behintzat beheko "Konparatu" aukeretako batean "Bai" aukeratzen Antzekotasun Txostena EZ da sortuko.';
$string['checkingupgrade'] = 'Eguneraketarik eskuragarri dagoen egiaztatzen';
$string['checkupgrade'] = 'Egiaztatu eguneraketarik dagoen eskuragarri';
$string['classcreationerror'] = 'Turnitin-eko Klasea sortzeak huts egin du';
$string['classupdateerror'] = 'Ezin izan da Turnitin-eko Klasearen daturik eguneratu';
$string['close'] = 'Itxi';
$string['closebutton'] = 'Itxi';
$string['code'] = 'Kodea';
$string['compareinstitution'] = 'Konparatu bidalitako fitxategiak erakunde honetara bidalitako lanekin';
$string['complete'] = 'osatuta';
$string['config'] = 'Ezarpenak';
$string['configupdated'] = 'Ezarpenak eguneratu dira';
$string['configureerror'] = 'Modulu hau kudeatzaile gisa guztiz konfiguratu behar da ikastaro batean erabili ahal izan baino lehen. Jarri zaitez harremanetan mesedez zure Moodle guneko kudeatzailearekin.';
$string['confirmv1deletetext'] = 'Migratutako {$a} V1 zeregin aukeratu dituzu behin-betiko ezabatzeko.';
$string['confirmv1deletetitle'] = 'Ezabatu aukeratutako zereginak?';
$string['confirmv1deletewarning'] = 'Ekintza hau ezin da desegin.';
$string['connecttest'] = 'Probatu Turnitin konexioa';
$string['connecttestcommerror'] = 'Ezin izan da Turnitin-era konektatu. Berriz egiaztatu ezazu zure API URLaren ezarpena.';
$string['connecttesterror'] = 'Errore bat gertatu da Turnitin-era konektatzean eta hurrengo mezua itzuli du:<br />';
$string['connecttestsuccess'] = 'Moodle Turnitin-era ondo konektatuta dago.';
$string['copyassigndata'] = 'Kopiatu Turnitin zereginaren datuak';
$string['copyrightagreement'] = 'Laukitxo hau markatuta bidalketa hau nik egindako lana dela baieztatzen dut eta bidalketa honen ondorioz gertatu daitezkeen copyright urraketen gaineko ardura guztia onartzen dut.';
$string['copyrightagreementerror'] = 'Onespena onartzen duzula adierazteko, mesedez onartu aurretik markatu ezazu laukitxoa.';
$string['course'] = 'Ikastaroa';
$string['coursebrowserassignmentdesc'] = 'Azpiko taulan Moodleko Turnitin zereginaren baitako atal gisako gehienez 5 zeregin aukeratu ditzakezu.';
$string['coursebrowserdesc'] = 'Turnitin-en bilatu dezakezu Moodleko azpiko ikastarokoak bezalako klaseak birsortzeko';
$string['courseexistsmoodle'] = 'Klase hau une honetan Moodlen honela existitzen da:';
$string['coursegeterror'] = 'Ezin izan da daturik eskuratu';
$string['coursegettiierror'] = 'Ezin izan da Turnitin-etik daturik eskuratu';
$string['courseiderror'] = 'Ikastaroaren IDa ez da zuzena';
$string['coursemisconfigured'] = 'Ikastaroa gaizki konfiguratuta dago';
$string['coursemodidincorrect'] = 'Ikastaro-moduluaren IDa ez da zuzena';
$string['coursemodincorrect'] = 'Ikastaro-modulua ez da zuzena';
$string['coursestomigrate'] = 'Turnitin-etik berreskuratzeko {$a} klase dituzu eskuragarri';
$string['coursetitle'] = 'Ikastaroaren izenburua';
$string['coursetitleerror'] = 'Bilatu ahal izateko klasearen izenburua zehaztu behar duzu';
$string['createassignmenterror'] = 'Errorea gertatu da zeregina Turnitin-en sortzen saiatzerakoan';
$string['createcourse'] = 'Sortu Moodle ikastaro berria';
$string['created'] = 'Sortuta';
$string['createmoodleassignments'] = 'Birsortu aukeratutako klaseen zeregin guztiak Moodlen?';
$string['createmoodlecourses'] = 'Birsortu ikastaroak';
$string['createsubmissionerror'] = 'Errorea gertatu da bidalketa Turnitin-en sortzen saiatzerakoan';
$string['cronsubmittedsuccessfully'] = 'Bidalketa:  {$a->title} (TII IDa: {$a->submissionid}) {$a->coursename} ikastaroko {$a->assignmentname} zereginean Turnitin-era ondo bidali da.';
$string['crontaskmodeactive'] = 'Turnitintooltwo - Cron deia bertan behera utzi da martxan dagoen zereginaren modua dela eta';
$string['defaultassignmenttiititle'] = 'Turnitin-erako zeregina';
$string['defaultcoursetiititle'] = 'Turnitin-eko ikastaroa';
$string['defaultinserterror'] = 'Errorea gertatu da datu-basean ezarpenaren lehenetsitako balioa sartzen saiatzerakoan';
$string['defaults'] = 'Ezarpen lehenetsiak';
$string['defaults_desc'] = 'Hurrengoak Moodle Direct Turnitin zeregina 2 instantzia berrietan erabiliko diren lehenetsitako balioak dira';
$string['defaultsdesc'] = 'Hurrengoak jarduera-modulu batean Turnitin gaitzerakoan erabiliko diren lehenetsitako balioak dira';
$string['defaultupdated'] = 'Turnitin-eko lehenetsitako balioak eguneratu dira';
$string['defaultupdateerror'] = 'Errorea gertatu da datu-basean ezarpenaren lehenetsitako balioa eguneratzen saiatzerakoan';
$string['deletable'] = 'Ezabagarria';
$string['delete_selected'] = 'Ezabatu aukeratutakoak';
$string['deleteassignmenterror'] = 'Errorea gertatu da zeregina Turnitin-en ezabatzen saiatzerakoan';
$string['deleteconfirm'] = 'Ziur zaude bidalketa hau ezabatu bnnahi duzula?\\n\\nEkintza hau ez du atzera bueltarik.';
$string['deletepart'] = 'Ezabatu atala';
$string['deletesubmission'] = 'Ezabatu bidalketa';
$string['deletesubmissiondesc'] = 'Erabiltzaileak bidalketa ezabatu du';
$string['deletesubmissiontiidesc'] = 'Erabiltzaileak bidalketa Turnitin-etik ezabatu du';
$string['diagnosticoptions_0'] = 'Desgaituta';
$string['diagnosticoptions_1'] = 'Estandarra';
$string['diagnosticoptions_2'] = 'Arazketa';
$string['digital_receipt_message'] = 'Kaixo, {$a->firstname} {$a->lastname}:<br /><br /><strong>{$a->submission_date}</strong> datan <strong>{$a->submission_title}</strong> fitxategia ondo bidali da <strong>{$a->course_fullname}</strong> ikastaroko <strong>{$a->assignment_name}{$a->assignment_part}</strong> zereginera. Zure bidalketaren IDa <strong>{$a->submission_id}</strong> da. Zure jasotze-agiri digital osoa ikusi eta inprimatu dezakezu Dokumentu Erakusleko inprimatu/jaitsi botoiaren bitartez.<br /><br />Eskerrik asko Turnitin erabiltzeagatik,<br /><br />Turnitin Taldea';
$string['digital_receipt_subject'] = 'Hau da zure Turnitin Jasotze-agiri Digitala';
$string['digitalreceipt'] = 'Jasotze-agiri Digitala';
$string['disableanonconfirm'] = 'Hau eginez gero zeregin honentzako kalifikazioa behin-betiko desgaituko da. Ziur zaude?';
$string['displaygradesas'] = 'Kalifikazioa erakusteko modua';
$string['displaygradesas_help'] = 'Ezarpen honek kalifikazioa erakusteko modua zehazten du: ehuneko gisa edo zatiki gisa.';
$string['displaygradesasfraction'] = 'Erakutsi kalifikazioak zatiki gisa (89/100)';
$string['displaygradesaspercent'] = 'Erakutsi kalifikazioak ehuneko gisa (%89)';
$string['dontmigrateassignment'] = 'Jarraitu migratu gabe';
$string['download'] = 'Jaitsi';
$string['download_button_warning'] = 'Funtzio hau eskuragarri egoteko ikasle bat aukeratuta egon behar du.';
$string['downloadassignment'] = 'Jaitsi zeregina Moodlera';
$string['downloadexport'] = 'Esportatu';
$string['downloadgrademarkzip'] = 'Jaitsi aukeratutako GradeMark fitxategiak';
$string['downloadgradexls'] = 'Esportatu Kalifikazioa (XLS)';
$string['downloadorigfileszip'] = 'Jaitsi fitxategi orijinalak';
$string['downloadorigzip'] = 'ZIP fitxategia (Jatorrizko Formatua)';
$string['downloadpdfzip'] = 'ZIP fitxategia (PDF)';
$string['downloadsubmission'] = 'Jaitsi bidalketa';
$string['draftsubmit'] = 'Noiz bidali behar da fitxategia Turnitin-era?';
$string['dtdue'] = 'Entregatze-data';
$string['dtpost'] = 'Itxiera-data';
$string['dtstart'] = 'Baimendu bidalketak hemendik';
$string['duplicatesfound'] = 'Turnitin zereginaren bikoiztutako kopiak aurkitu dira, hau gertatzen da Moodle Direct zeregin bat edo gehiago Turnitin-eko APi bitartez Turnitin-eko zeregin berera konektatzen direnean. Honek arazoak sortzen ditu, nagusiki batean egindako bidalketen kopiak agertuko direla besteen bidalketen sarrera-ontzian. Arazo hau konpontzeko bikoiztutako zeregina ezabatu edo bikoiztutako zereginak dauden ikastaroa berrabiarazi beharko zenuke.<br /><br />Hauek dira aurkitu diren kopiak:';
$string['edit'] = 'Editatu';
$string['editassignmenterror'] = 'Errorea gertatu da zeregina Turnitin-en editatzen saiatzerakoan';
$string['emptycreatedfile'] = 'Bidaltzen saiatu zaren fitxategia hutsik edo kaltetuta dago';
$string['enablemigrationtool'] = 'Migrazio-ekintza zeregina abiaratzerakoan.';
$string['enablemigrationtool_help'] = 'Migrazio-tresna desgaituta, eskuzkoa edo automatikoa bezala konfiguratu daiteke. Eskuzkoak irakasleari aukera ematen dio zeregin bat migratzeko, eta automatikoak migrazioa egingo du irakaslea V1 zeregin batera sartzen den lehen aldian.';
$string['enablemigrationtoolfail'] = 'Ezin izan dugu zure Moodleko migrazio-tresnaren ezarpenak eguneratu. Mesedez saiatu berriro.';
$string['enablemigrationtoolsuccess'] = 'V1 migrazio-tresnaren ezarpena gorde da';
$string['enableperformancelogs'] = 'Gaitu sare-errendimenduaren erregistroa';
$string['enableperformancelogs_desc'] = 'Gaituz gero, Turnitin-eko zerbitzarira egindako eskaera bakoitza {tempdir}/turnitintooltwo/logs fitxategian erregistratuko da';
$string['enablepseudo'] = 'Gaitu ikasleen pribatutasuna';
$string['enablepseudo_desc'] = 'Aukera hau markatuz gero Turnitin-eko API deietan ikasleen helbide elektronikoak pseudo-ekibalentzia batekin ordezkatuko dira.<br /><i>(<b>Oharra:</b> Aukera hau ezin da aldatu dagoeneko Moodleko erabiltzaile-daturen bat Turnitin-ekin sinkronizatu bada)</i>';
$string['enrolling'] = 'Ikasleak Turnitin-en matrikulatzen';
$string['erater'] = 'Gaitu gramatikaren egiaztapena';
$string['erater_categories'] = 'Feedback Kategoriak';
$string['erater_dictionary'] = 'Hiztegia';
$string['erater_dictionary_en'] = 'AEB eta EBko Ingeles Hiztegiak';
$string['erater_dictionary_engb'] = 'EBko Ingeles Hiztegia';
$string['erater_dictionary_enus'] = 'AEBko Ingeles Hiztegia';
$string['erater_grammar'] = 'Gramatika';
$string['erater_handbook'] = 'Gramatikaren eskuliburua';
$string['erater_handbook_advanced'] = 'Aurreratua';
$string['erater_handbook_elementary'] = 'Lehen Hezkuntzako Eskola';
$string['erater_handbook_highschool'] = 'Institutua';
$string['erater_handbook_learners'] = 'Ingelesezko Ikasleak';
$string['erater_handbook_middleschool'] = 'Ikastetxea';
$string['erater_mechanics'] = 'Mekanika';
$string['erater_spelling'] = 'Ortografia';
$string['erater_style'] = 'Estiloa';
$string['erater_usage'] = 'Erabilera';
$string['errorenrollingall'] = 'Errorea gertatu da ikasle guztiak Turnitin-en matrikulatzean - Jarri harremanetan mesedez zure guneko kudeatzailearekin';
$string['errors'] = 'Erroreak';
$string['errorsdesc'] = 'Errorea gertatu da hurrengo fitxategiak Turnitin-era igotzen saiatzerakoan.';
$string['eventremoved'] = 'Ekitaldi hau cron-ilaratik kendu da eta ez da berriz prozesatuko.';
$string['excludebiblio'] = 'Utzi alde batera bibliografia';
$string['excludebiblio_help'] = 'Ezarpen honek irakasleari ikaslearen bidalketaren bibliografian eta aipatzen diren lanen testuak Antzekotasun Txostenak prozesatzean kontuan ez hartzeko aukera ematen dio. Aukera hau Antzekotasun Txosten zehatzetarako baliogabetu daiteke.';
$string['excludepercent'] = 'Ehunekoak';
$string['excludequoted'] = 'Utzi alde batera aipuetako edukia';
$string['excludequoted_help'] = 'Aukera honek irakasleari aipuetan agertzen diren testuak Antzekotasun Txostena prozesatzean kontuan ez hartzeko aukera ematen dio. Aukera hau Antzekotasun Txosten zehatzetarako baliogabetu daiteke.';
$string['excludevalue'] = 'Utzi alde batera bat etortze txikiak';
$string['excludevalue_help'] = 'Aukera honek irakasleari behar bezain luzeak (irakasleak zehaztuta) ez diren testu zatiak Antzekotasun Txostena prozesatzean kontuan ez hartzeko aukera ematen dio. Aukera hau Antzekotasun Txosten zehatzetarako baliogabetu daiteke.';
$string['excludewords'] = 'Hitzak';
$string['exportexcel'] = 'Esportatu Excel-era';
$string['exportoriginal'] = 'Esportatu jatorrizko formatuan';
$string['exportpdf'] = 'Esportatu PDF-ra';
$string['faultcode'] = 'Errore-kodea';
$string['filebrowser'] = 'Moodleko fitxategi-nabigatzaile zuzena';
$string['filedeleteconfirm'] = 'Ziur zaude fitxategi hau ezabatu nahi duzula? Ekintza hau ezin da desegin.';
$string['filedoesnotexist'] = 'Fitxategia ezabatu da';
$string['filename'] = 'Fitxategi-izena';
$string['files'] = 'Fitxategiak';
$string['filetosubmit'] = 'Bidaltzeko fitxategia';
$string['filetosubmit_help'] = 'Fitxategi bat zeregin-atal batera bidaltzeko, fitxategia zure ordenagailuan arakatu ezazu formulario hau erabilita.';
$string['fileupload'] = 'Fitxategi-igoera';
$string['genduedate'] = 'Sortu txostenak entregatze-datan (ikasleek entregatze-data iritsi arte berbidalketak egin ditzakete)';
$string['genimmediately1'] = 'Sortu txostenak berehala (ikasleek ezin dute berbidalketarik egin)';
$string['genimmediately2'] = 'Sortu txostenak berehala (ikasleek entregatze-data iritsi arte berbidalketak egin ditzakete): {$a->num_resubmissions} berbidalketa egin ondoren txostenak {$a->num_hours} orduren ostean sortuko dira';
$string['getassignmenterror'] = 'Ezin izan da migrazio-zereginik eskuratu Turnitin-etik';
$string['grademark'] = 'GradeMark';
$string['grademarkzip'] = 'Aukeratutako GradeMark fitxategiak';
$string['gradenosubmission'] = 'Erabiltzailearen kalifikazioa gaitu da erabiltzaile-ID horrentzako bidalketarik egon gabe';
$string['gradingtemplate'] = 'Ebaluazio-txantiloia';
$string['hasmigrated'] = 'Migratutakoa?';
$string['helpdesklink'] = 'Turnitin-ekin laguntza behar duzu?';
$string['hidepeermark'] = 'Ezkutatu PeerMark Zereginak';
$string['hidepeermarkinstructions'] = 'Ezkutatu PeerMark argibideak';
$string['hidesummary'] = 'Ezkutatu zereginaren laburpena';
$string['id'] = 'ID';
$string['inactive'] = 'Ez-aktiboa';
$string['institutionalcheck'] = 'Konparatu Biltegi Instituzionalarekin';
$string['institutionalchecksettings'] = 'Konparatu </br>Biltegi Instituzionalarekin';
$string['institutionalrepository'] = 'Biltegi Instituzionala (aplikagarria denean)';
$string['instructor'] = 'Irakaslea';
$string['instructorreceipt'] = 'Jakinarazi irakasleak bidalketen inguruan';
$string['instructorreceipt_desc'] = 'Aukeratu ezazu zeregin batean bidalketa bat egiten den bakoitzean irakasle bakoitzari jakinarazpen bat bidaliko zaion edo ez.';
$string['integration'] = 'Integrazioa';
$string['internetcheck'] = 'Konparatu Interneten';
$string['internetcheck_help'] = 'Konparatu Turnitin-ek interneten duen biltegiarekin bidalketen Antzekotasun Txostena prozesatzean. "Ez" aukeratuta antzekotasun indizearen ehunekoa jaitsi daiteke.';
$string['journalcheck'] = 'Konparatu aldizkari,<br/>egunkari eta argitalpenetan';
$string['journalcheck_help'] = 'Konparatu Turnitin-en aldizkari, egunkari eta argitalpenen biltegiarekin bidalketen Antzekotasun Txostena prozesatzean. "Ez" aukeratuta antzekotasun indizearen ehunekoa jaitsi daiteke.';
$string['launchgrademark'] = 'GradeMark';
$string['launchpeermarkmanager'] = 'Abiarazi Peermark Manager (berdinen arteko kalifikazioen kudeatzailea)';
$string['launchpeermarkreviews'] = 'Abiarazi Peermark Reviews (berdinen arteko berrikusketen kudeatzailea)';
$string['launchquickmarkmanager'] = 'Abiarazi Quickmark Manager (kalifikatze-azkarren kudeatzailea)';
$string['launchrubricmanager'] = 'Abiarazi Rubric Manager (errubrika-kudeatzailea)';
$string['launchrubricview'] = 'Ikusi kalifikatzeko erabilitako Errubrika';
$string['launchrubricviewshort'] = 'Ebaluazio-errubrika';
$string['layoutoptions_0'] = 'Zabalera osoa';
$string['layoutoptions_1'] = 'Moodlen lehenetsitakoa - nabigazioaren bitartez';
$string['line'] = 'Lerroa';
$string['linkcourse'] = 'Lotu ikastaroa existitzen den Moodle ikastaro batekin';
$string['listsubmissions'] = 'Bidalketen zerrenda';
$string['listsubmissionsdesc'] = 'Erabiltzaileak ikastaroko bidalketen zerrenda ikusi du';
$string['listsubmissionsdesc_student'] = 'Erabiltzaileak ikastaroko bidalketen sarrera-ontzia ikusi du';
$string['loadingdv'] = 'Turnitin Dokumentu Erakuslea kargatzen...';
$string['marksavailable'] = 'Gehieneko kalifikazioa';
$string['max_marks_warning'] = 'Kontuan izan mesedez eskuragarri dauden kalifikazioak ebaluazioa egin ondoren egiteak kalifikazio-liburuan eragin dezakeela';
$string['maxfilesize'] = 'Fitxategiaren gehieneko tamaina';
$string['maxfilesize_help'] = 'Ezarpen honek erabiltzaile bakoitzak zereginaren atal bakoitzean igoko dituen fitxategien gehieneko tamaina zehazten du. Gehieneko balioa ikastaroaren ezarpenen araberakoa izango da, eta horretaz aparte Turnitin-era igo daitezkeen fitxategien gehieneko tamaina 100Mb-koa da.';
$string['maxlength'] = '{$a->field}(e)rako gehieneko karaktere kopurua {$a->length} da';
$string['maxmarks'] = 'Gehieneko kalifikazioa';
$string['maxmarkserror'] = 'Gehieneko kalifikazioa 0 eta 100 artekoa izan behar da';
$string['membercheckerror'] = 'Errore bat gertatu da ikastaro honetan matrikulatutako erabiltzaileak egiaztatzerakoan';
$string['message'] = 'Mezua';
$string['messagenonsubmitters'] = 'Jakinarazi bidalketarik egin ez dituztenak';
$string['messageprovider:nonsubmitters'] = 'Turnitin zereginaren bidali gabekoen jakinarazpenak';
$string['messageprovider:notify_instructor_of_submission'] = 'Turnitin zereginaren Irakaslearen Jasotze-agiri Digitalaren jakinarazpenak';
$string['messageprovider:submission'] = 'Turnitin zereginaren Jasotze-agiri Digitalaren jakinarazpenak';
$string['messagesinbox'] = 'Turnitin Mezuen Sarrera-ontzia';
$string['migrateassignment'] = 'Migratu zeregina';
$string['migrated'] = 'Migratutakoa';
$string['migrating'] = 'Zeregin hau une honetan Moodle Direct V2 zereginera migratzen ari da.';
$string['migration:auto'] = 'Automatikoki abiaratzerakoan';
$string['migration:manual'] = 'Proposatu irakasleari abiaratzerakoan';
$string['migration:off'] = 'Desgaitu migrazioa';
$string['migration_event_desc'] = 'Turnitin zeregina V1 ikastaroa: {$a->v1_name} ({$a->v1_cm_id}) migratu da Turnitin V2-ra ({$a->v2_cm_id}).';
$string['migration_event_name'] = 'Migratu zeregina V1etik V2ra';
$string['migration_status'] = 'Migrazioaren egoera';
$string['migrationactivationfailure'] = 'Ezin izan da migrazio-tresna gaitu.';
$string['migrationactivationsuccess'] = 'Migrazio-tresna ondo gaitu da.';
$string['migrationassignmentcreated'] = 'Migrazio-zeregina sortu da - IDa: {$a}';
$string['migrationassignmentcreationerror'] = 'Ezin izan da migrazio-zeregina sortu - {$a} ikastaroa';
$string['migrationassignmenterror1'] = 'Ezin izan da modulu berri bat gehitu {$a} ikastarora';
$string['migrationassignmenterror2'] = 'Ezin izan da modulu berri bat gehitu atal horretan - {$a} ikastaroa';
$string['migrationassignmenterror3'] = 'Ezin izan da migratutako zereginerako ekitaldia sortu - {$a} ikastaroa';
$string['migrationassignmentgeterror'] = 'Ezin izan da eskuratu zereginik Turnitin-etik';
$string['migrationassignmentpartcreated'] = 'Migrazio-zereginaren atala sortu da - IDa: {$a}';
$string['migrationassignmenttitle'] = 'V1 zereginaren izenburua';
$string['migrationcoursecreated'] = 'Turnitin-eko klasea Moodlen birsortu da';
$string['migrationcoursecreatederror'] = '{$a} ikastaroa birsortu da baina errore bat gertatu da esteka gordetzean';
$string['migrationcoursecreateerror'] = '{$a} ikastaroa ezin izan da Moodlen sortu';
$string['migrationcoursegeterror'] = 'Ezin izan da eskuratu klaserik Turnitin-etik';
$string['migrationinprogress'] = 'Migrazioa martxan';
$string['migrationredirect'] = 'Moodle Direct V2 zereginera bidaliko zaizu amaitzerakoan.';
$string['migrationselectall'] = 'Aukeratu migratutako zeregin guztiak';
$string['migrationtool:gradebookerror'] = 'Zure zeregina Moodle Direct V1etik V2ra ondo migratu da. Halere, migrazioan zeharreko kalifikazio-liburuko kalifikazio batzuk eguneratzeak huts egin du. Jatorrizko V1 zeregina eskuragarri dago kalifikazio-arazoak egiaztatu ditzazun. Mesedez behin egiaztatzean V1 zeregina ezabatu ezazu.<br><br><strong>Oharra:</strong> Migratutako V1 zeregina ezabatzean huts egiteak kalifikazioak kalifikazio-liburuan bi aldiz zenbatzeak eragin dezake.';
$string['migrationtool:successful'] = 'Zure zeregina Moodle Direct V1etik V2ra ondo migratu da. Jatorrizko V1 zeregina ezabatua izan da.';
$string['migrationtool:successfulcron'] = 'Zure zeregina Moodle Direct V1etik V2ra ondo migratu da. Hau zeregin handia denez, utzi denbora bat kalifikazio-liburua eguneratzeko. Jatorrizko V1 zeregina automatikoki ezabatuko da behin eguneratzea amaituta.<br><br><strong>Oharra:</strong>V1 zeregina eskuz ezabtuz gero kalifikazio-liburua behar bezala ez eguneratzea eragin dezake.';
$string['migrationtoolaccounterror'] = 'Moodleko migrazio-tresna gaitzeko V1 eta V2 pluginetan Turnitin-eko kontuaren ID bera erabili behar duzu.';
$string['migrationtoolerror'] = 'Zeregin honen migrazioak huts egin du. Mesedez saiatu berriro.';
$string['migrationtoolinfo'] = 'Zure kudeatzaileak Moodle Direct V1 zereginen V2rako migrazioa baimendu du<br /><br />Moodle Direct V1 eta V2 modu berean funtzionatzen dute, V2-k zenbait funtzio gehigarri dituelarik. Zeregin hau migratzea aukeratuta, zure zereginaren ezarpenak automatikoki transferituko dira.';
$string['migrationtoolintro'] = 'Erabili erreminta hau zereginen Moodle Direct V1etik V2rako migrazioa konfiguratzeko.';
$string['migrationtoolprogress'] = 'Aukeratu ezabatu nahi dituzun migratutako V1 zereginak. Oraindik migratu gabeko V1 zereginak ezin dira ezabatu.';
$string['migrationtooltitle'] = 'Migratu zure Moodle Direct V1 zeregina V2ra?';
$string['migrationtoolv1list'] = 'Erabili azpiko zerrenda {$a} bertsio aurretik migratutako Moodle Direct V1 zereginak ezabatzeko; honek kalifikazio-liburuko zenbait zehaztasun-akats konponduko ditu. Oraindik V2ra migratu gabeko V1 zereginak aurkitu ditzakezu.<br/><br/>Informazio gehiagorako, ikusi bertsio-kaleratze oharrak hemen: <a href=https://help.turnitin.com/release-notes/turnitin-release-notes-home.htm>help.turnitin.com/release-notes</a>';
$string['module'] = 'Modulua';
$string['modulename'] = 'Turnitin Zeregina 2';
$string['modulename_help'] = 'Turnitin Moodle Direct zeregin bat sortzen du, Moodleko jarduera bat Turnitin-eko zeregin batekin lotzen duena. Behin lotura eginda, jarduerak irakasleari ikasleen idatzizko lanak Turnitin-eko Dokumentu Erakusle barruko erremintak erabiliz kalifikatzeko eta feedback-a emateko aukera ematen dio.';
$string['modulenameplural'] = 'Turnitin zereginak';
$string['modulenamewithv2plural'] = 'Turnitin zereginak (V2)';
$string['moduleversion'] = 'Bertsioa';
$string['moodlelinked'] = 'Moodlera estekatuta';
$string['mysubmissions'] = 'Nire bidalketak';
$string['newcourseenddate'] = 'Ikastaro berriaren amaiera-data';
$string['newenddatedesc'] = 'Aukeratu amaiera-data berri bat azpiko ikastaroarentzat, gero Turnitin-en eguneratu dadin.';
$string['no'] = 'Ez';
$string['nofinfolibrary'] = 'Plugin hau erabiltzeko zure zerbitzarian PHP-ko Fileinfo luzapena instalatuta egon behar da.';
$string['nogrades'] = 'Ez, nik eskuz eguneratuko ditut antzekotasun-puntuazioak eta kalifikazioak';
$string['noguests'] = 'Sentitzen dugu, gonbidatutako erabiltzaileek ez dute sarbiderik plugin honetara. Saioa hasi ezazu, mesedez.';
$string['nointegration'] = 'Integraziorik ez';
$string['nolimit'] = 'Mugarik gabe';
$string['nombstringlibrary'] = 'Plugin hau erabiltzeko zure zerbitzarian PHP-ko mbstring luzapena instalatuta egon behar da.';
$string['nonenrolledstudent'] = 'Matrikulatu gabeko ikaslea';
$string['nonmoodleuser'] = 'Moodlekoa ez den erabiltzailea';
$string['nonsubmitterserror'] = 'Idatzi ezazu mesedez email-erako gaia eta mezua';
$string['nonsubmittersformdesc'] = 'Idatzi ezazu mesedez zeregin honetan oraindik bidalketarik egin ez duten ikasleentzako mezua azpian.';
$string['nonsubmittersformsuccess'] = 'Bidalketarik egin ez dutentzako zure mezua bidali da.';
$string['nonsubmittersmessage'] = 'Mezua';
$string['nonsubmittersmessageerror'] = 'Idatzi ezazu mesedez email-erako mezua';
$string['nonsubmitterssendtoself'] = 'Bidali niri mezu honen kopia bat';
$string['nonsubmitterssubject'] = 'Gaia';
$string['nonsubmitterssubjecterror'] = 'Idatzi ezazu mesedez email-erako gaia';
$string['nonsubmitterssubmit'] = 'Bidali e-maila';
$string['noofreviewsrequired'] = 'Behar diren berrikuspen kopurua';
$string['noreason'] = 'Ez da arrazoirik zehaztu';
$string['norepository'] = 'Biltegirik ez';
$string['norubric'] = 'Errubrikarik ez';
$string['noscript'] = 'Turnitin-ek Javascript behar du baina zure nabigatzaileak ez dauka aukera hori gaituta. Turnitin-eko funtzionalitate osoa erabili ahal izateko mesedez zure nabigatzailean Javascript gaitu ezazu.';
$string['noscriptsummary'] = 'Turnitin-ek Javascript behar du baina zure nabigatzaileak ez dauka aukera hori gaituta. Hori gaitu gabe ezingo duzu Turnitin-era sartu.';
$string['noscriptula'] = '(Ez duzunez JavaScript gaituta Turnitin Erabiltzaile Onespena onartu ondoren orri hau eskuz freskatu beharko duzu bidalketa egin ahal izateko)';
$string['nosoaplibrary'] = 'Plugin hau erabiltzeko zure zerbitzarian PHP-ko SOAP luzapena instalatuta egon behar da.';
$string['nosubmissiondataavailable'] = 'Ez dago beste bidalketen daturik eskuragarri';
$string['nosubmissions'] = 'Ez da bidalketarik egin';
$string['notadmin'] = 'Eskatutako ekintzarako Moodleko kudeatzaile-baimenak behar dira.';
$string['notavailableyet'] = 'Ez eskuragarri';
$string['notorcapable'] = 'Ezin da fitxategi honentzako Antzekotasun Txostena sortu.';
$string['noturnitinassignemnts'] = 'Ez dago Turnitin zereginik';
$string['notutors'] = 'Ez dago irakaslerik matrikulatuta Turnitin-eko klase honetan';
$string['noxmlwriterlibrary'] = 'Plugin hau erabiltzeko zure zerbitzarian PHP-ko XMLWriter luzapena instalatuta egon behar da.';
$string['numberofparts'] = 'Atal-kopurua';
$string['numberofparts_help'] = 'Atal ezberdinez osatutako bidalketak baimentzen dira, erabiltzaile bakoitzak bidalketa bana egin dezake atal bakoitzean.';
$string['objectid'] = 'Turnitin Txostenaren IDa';
$string['offlinestatus'] = 'Turnitin desgaituta dago. ($CFG->tiioffline aldagaiaren balioa true izan behar da.)';
$string['or'] = 'Edo';
$string['origfileszip'] = 'Jatorrizko fitxategiak';
$string['otherrubric'] = 'Erabili beste irakasle baten errubrika';
$string['overallgrade'] = 'Kalifikazio orokorra';
$string['overallgrade_help'] = 'Kalifikazio orokorrak zeregin osoan guztira lortu daitekeen gehieneko kalifikazioa zehazten du. Atal bakoitzak gehieneko kalifikazio bat dauka kalifikazio orokorra kalkulatzean kalifikazioak proportzionalki banatzeko.';
$string['partdberror'] = 'Arazo bat egon da datu-basean {$a} atala sartzerakoan<br />';
$string['partdeleted'] = 'Zereginaren atala ezabatua izan da';
$string['partdeleteerror'] = 'Ezin izan da ezabatu zereginaren atalaren {$a} datuak';
$string['partdeletewarning'] = 'Ezabatzen saiatzen ari zaren zereginaren atalak bidalketak ditu. Zereginaren atal hau ezabatzen baduzu bidalketa horiek galduko dituzu.\\n\\nZiur zaude aurrera egin nahi duzula?';
$string['partdueerror'] = 'Hasiera-data entregatze-data baino lehenagokoa izan behar da.';
$string['partgeterror'] = 'Ezin izan dira eskuratu zeregin-atalaren datuak';
$string['partname'] = 'Zereginaren atala';
$string['partnameerror'] = 'Atalaren izena ezin da hutsik utzi.';
$string['partnametoolarge'] = 'Atalaren izena luzeegia da. Gehienez 40 karaktere erabili daitezke.';
$string['partposterror'] = 'Hasiera-data itxiera-data baino lehenagokoa izan behar da.';
$string['partupdateerror'] = 'Arazo bat egon da {$a} atala datu-basean eguneratzean<br />';
$string['peermark'] = 'Peermark';
$string['peermarkassignments'] = 'Peermark Zereginak';
$string['pending'] = 'Prozesatzearen zai';
$string['permissiondeniederror'] = 'Ez daukazu eskatutako ekintza burutzeko behar den baimena';
$string['pluginadministration'] = 'Turnitin Zeregina 2 Kudeaketa';
$string['pluginname'] = 'Turnitin Zeregina 2';
$string['portfolio'] = 'Portfolioa';
$string['postdate_warning'] = 'kontuan izan mesedez zereginaren datak aldatzeak ikasleen kalifikazioen ikusgarritasunean eta ikasleen identitateak irakasleen erakustean eragin dezakeela.';
$string['pp_classcreationerror'] = 'Klase hau ezin izan da Turnitin-en sortu, informazio gehiagorako egiaztatu itzazu mesedezzure APIaren erregistroak.';
$string['pp_createsubmissionerror'] = 'Errorea gertatu da plagioaren kontrolerako pluginean bidalketa sortzerakoan';
$string['pp_submission_error'] = 'Turnitin-ek errorea itzuli du zure bidalketarekin:';
$string['pp_updatesubmissionerror'] = 'Errorea gertatu da plagioaren kontrolerako pluginean bidalketa eguneratzerakoan';
$string['ppassignmentcreateerror'] = 'Modulu hau ezin izan da Turnitin-en sortu, informazio gehiagorako egiaztatu itzazu mesedezzure APIaren erregistroak.';
$string['ppassignmentediterror'] = '{$a->title} modulua (TII IDa: {$a->assignmentid}) ezin izan da Turnitin-en editatu, informazio gehiagorako egiaztatu itzazu mesedez zure APIaren erregistroak.';
$string['print'] = 'Inprimatu';
$string['privacy:metadata:core_files'] = 'Turnitin Zeregina 2 pluginak Turnitin bidalketa bat osatzeko Moodlera igotako fitxategiak gordetzen ditu.';
$string['privacy:metadata:turnitintooltwo_client'] = 'Bidalketa Turnitin-era ondo egiteko, erabiltzailearen datu zehatzak trukatu behar dira Moodle eta Turnitin-en artean. Moodleko pluginen eta GDPRaren inguruan informazio gehiagorako ikusi ezazu mesedez hurrengo helbidea: https://help.turnitin.com/feedback-studio/moodle/moodle-plugins-and-gdpr.htm';
$string['privacy:metadata:turnitintooltwo_client:email'] = 'Moodlek erabiltzailearen helbide elektronikoa partekatzen du Turnitin-eko kontua sortzea ahalbidetzeko.';
$string['privacy:metadata:turnitintooltwo_client:firstname'] = 'Erabiltzailearen izena Turnitin-era bidaltzen da erabiltzailea identifikatu ahal izateko.';
$string['privacy:metadata:turnitintooltwo_client:lastname'] = 'Erabiltzailearen abizena Turnitin-era bidaltzen da erabiltzailea identifikatu ahal izateko.';
$string['privacy:metadata:turnitintooltwo_client:submission_content'] = 'Kontuan izan mesedez fitxategia/bidalketaren edukia Turnitin-era bidaltzen dela prozesatua izan dadin.';
$string['privacy:metadata:turnitintooltwo_client:submission_filename'] = 'Bidalitako fitxategiaren izena Turnitin-era bidaltzen da identifikagarria izan dadin.';
$string['privacy:metadata:turnitintooltwo_client:submission_title'] = 'Bidalketaren izenburua Turnitin-era bidaltzen da identifikagarria izan dadin.';
$string['privacy:metadata:turnitintooltwo_submissions'] = 'Turnitin-era bidalitako bidalketaren inguruko informazioa.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_attempts'] = 'Erabiltzaileak bere bidalketaren feedbacka ikusi duen adierazten duen unea.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_filename'] = 'Turnitin-era bidalitako fitxategiaren izena.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_grade'] = 'Irakasleak bidalketari ezarritako kalifikazioa.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_hash'] = 'Erabiltzailearen IDa barne duen bidalketaren hash espezifikoa.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_modified'] = 'Erabiltzaileak azkenengoz bidalketa aldatu zuen unea.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_objectid'] = 'Bidalketaren erreferentziarako Turnitin-ek erabilitako IDa.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_orcapable'] = 'Bidalketarako Turnitin-ek antzekotasun-txostena sortzeko gai zian den edo ez adierazten du.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_score'] = 'Bidalketaren antzekotasun-puntuazioa.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_title'] = 'Bidalketaren izenburua.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_transmatch'] = 'Turnitin-ek antzekotasun-txostena sortzeko itzulpenaren bidezko konparaketa erabili duen edo ez adierazten du.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_unanon'] = 'Bidalketa baten anonimotasuna kendu dela adierazten du, egilearen identitatea irakaslearentzat eskuragarri jarrita.';
$string['privacy:metadata:turnitintooltwo_submissions:submission_unanonreason'] = 'Egilearen anonimotasuna kentzearen arrazoia, irakasleak emandakoa.';
$string['privacy:metadata:turnitintooltwo_submissions:userid'] = 'Bidalketa egin zuen erabiltzailearen IDa.';
$string['privacy:metadata:turnitintooltwo_users'] = 'Moodleko erabiltzaile bat Turnitin-eko erabiltzaile-kontu batekin lotzeko informazioa eta Turnitin-eko berezko hobespenak. Hauek artean zereginetako ezarpen lehenetsiak eta erabiltzailearen Turnitin-eko errubrikak daude.';
$string['privacy:metadata:turnitintooltwo_users:instructor_defaults'] = 'Irakaslearen zereginetako ezarpen lehenetsiak';
$string['privacy:metadata:turnitintooltwo_users:instructor_rubrics'] = 'Irakaslearenak diren Turnitin-eko errubrikaren emaitzak';
$string['privacy:metadata:turnitintooltwo_users:turnitin_uid'] = 'Erabiltzailearen Turnitin-eko kontuaren IDa.';
$string['privacy:metadata:turnitintooltwo_users:user_agreement_accepted'] = 'Erabiltzaile honek Turnitin-eko Erabiltzaile-lizentziaren Onespena (EULA) onartu duen edo ez adierazten du.';
$string['privacy:metadata:turnitintooltwo_users:userid'] = 'Turnitin-era lotutako erabiltzailearen IDa.';
$string['proxypassword'] = 'Proxy-aren pasahitza';
$string['proxypassword_desc'] = '<b>[Hautazkoa]</b><br /> Zure proxy-ak autentifikazioa eskatzen badu zehaztu ezazu pasahitza hemen.';
$string['proxyport'] = 'Proxy-aren ataka';
$string['proxyport_desc'] = '<b>[Hautazkoa]</b><br /> Zure zerbitzariak Internet-era konektatzeko proxy bat erabiltzen badu zehaztu ezazu ataka hemen.';
$string['proxyurl'] = 'Proxy-aren URLa';
$string['proxyurl_desc'] = '<b>[Hautazkoa]</b><br /> Zure zerbitzariak Internet-era konektatzeko proxy bat erabiltzen badu zehaztu ezazu proxy-aren helbidea hemen.';
$string['proxyuser'] = 'Proxy-aren erabiltzaile-izena';
$string['proxyuser_desc'] = '<b>[Hautazkoa]</b><br /> Zure proxy-ak autentifikazioa eskatzen badu zehaztu ezazu erabiltzaile-izena hemen.';
$string['pseudoemailaddress'] = 'Pseudo helbide elektronikoa';
$string['pseudoemaildomain'] = 'Posta elektronikoko pseudo-domeinua';
$string['pseudoemaildomain_desc'] = '<b>[Hautazkoa]</b><br />Hautazko posta elektronikoko pseudo-domeinua (hutsik utziz gero @tiimoodle.com erabiliko da)';
$string['pseudoemailsalt'] = 'Zifratze-eraldaketa';
$string['pseudoemailsalt_desc'] = '<b>[Hautazkoa]</b><br />Sortutako pseudo helbide elektronikoen konplexutasuna handitzeko erabilitako zifratze-eraldaketa.<br />(<b>Oharra:</b> Eraldaketa ez da aldatu behar pseudo helbide elektronikoak modu sendoan gordeta mantendu daitezen)';
$string['pseudofirstname'] = 'Ikasleen pseudo-izena';
$string['pseudofirstname_desc'] = '<b>[Hautazkoa]</b><br />Turnitin dokumentu-erakuslean erakusteko ikasleren izena';
$string['pseudolastname'] = 'Ikasleen pseudo-abizena';
$string['pseudolastname_desc'] = 'Turnitin dokumentu-ikuskatzailean erakusteko ikasleren abizena';
$string['pseudolastnamegen'] = 'Sortu abizenak automatikoki';
$string['pseudolastnamegen_desc'] = 'Bai aukeratuz gero eta pseudo-abizena erabiltzaile-profileko eremuan zehaztuta badago, eremua identifikatzaile bakar batekin beteko da automatikoki.';
$string['receipt_instructor_copy'] = '<strong>{$a->submission_title}</strong> izeneko bidalketa bat egin da <strong>{$a->course_fullname}</strong> ikastaroko <strong>{$a->assignment_name}{$a->assignment_part}</strong> zereginean.<br /><br />Bidalketarean ID: <strong>{$a->submission_id}</strong><br />Bidaltze.data: <strong>{$a->submission_date}</strong><br />';
$string['receipt_instructor_copy_subject'] = 'Zereginean bidalketa egin da';
$string['receiptassignmenttitle'] = 'Zereginaren Izena';
$string['receiptparagraph'] = 'Jasotze-agiri honek Turnitin-ek zure bidalketa jaso duela ziurtatzen du. Beherago zure bidalketarekin erlazionatutako jasotze-agiriaren informazioa aurkituko duzu.';
$string['recreatemulticlasses'] = 'Zuk aukeratutako klaseak birsortzen ari dira une honetan, aukeratutako kopuruaren arabera honek minutu batzuk beharko ditu';
$string['recreatemulticlassescomplete'] = 'Klaseen birsortzea osatu da dagoeneko. {$a->total}(e)tik {$a->completed} ondo sortu dira.';
$string['redirecttoeula'] = 'Zu Erabiltzaile-lizentziaren Onespenera bideratzen ari gatzaizkizu';
$string['refid'] = 'Erreferentzia-IDa';
$string['refreshallgrades'] = 'Freskatu kalifikazio guztiak Turnitin-etik';
$string['refreshingallgrades'] = 'Kalifikazio guztiak Turnitin-etik freskatzen';
$string['relinkusers'] = 'Berriz lotu erabiltzaileak';
$string['renew_assignment_dates'] = 'Erabili zereginarentzako data berriak';
$string['renew_assignment_dates_help'] = 'Aukera hau markatu ezazu ikastaroa berrabiaraztean zereginean data berriak erabiltzeko. Zereginaren hasiera-data ikastaroaren berrabiarazte-data izango da, eta entregatze-data eta itxiera-data 7 egun beranduago.<br/><br/>Ez baduzu datarik aldatu nahi, ez dago arazorik; Turnitin-ek jatorrizko zereginaren datak erabiliko ditu. Halere, kalifikazio itsurik ez da egingo itxiera-data igarota duten zereginetan.';
$string['replaceassigndata'] = 'Ordeztu Turnitin zereginaren datuak';
$string['reportgenspeed'] = 'Txostenaren sortze-abiadura';
$string['reportgenspeed_help'] = 'Zereginaren ezarpen honetan hiru aukera daude: \'Sortu txostenak berehala (berbidalketak ez daude baimenduta)\', \'Sortu txostenak berehala (berbidalketak entregatze-data arte baimenduta daude)\', eta \'Sortu txostenak entregatze-datan (berbidalketak entregatze-data arte baimenduta daude)\'.<br /><br />\'Sortu txostenak berehala (berbidalketak ez daude baimenduta)\' aukerak Antzekotasun Txostena berehala sortzen du ikasle batek bidalketa egiten duenean. Aukera honek ez du baimentzen ondoren ikasleek berriz bidalketak egitea.<br /><br />Bidalketak berriz egitea ahalbidetzeko, aukeratu \'Sortu txostenak berehala (berbidalketak entregatze-data arte baimenduta daude)\'. Honek entregatze-data heldu arte ikasleek bidalketak behin eta berriz egitea ahalbidetzen du. Bidalketa berriak prozesatzeak 24 ordura arte atzeratu daiteke.<br /><br />\'Sortu txostenak entregatze-datan (berbidalketak entregatze-data arte baimenduta daude)\' aukerak Antzekotasun Txostena soilik entregatze-data heltzean sortuko du. Aukera honen bitartez Antzekotasun Txostenak sortzean bidalketa guztiak elkarren artean konparatzea ahalbidetzen du.';
$string['reportgenspeed_resubmission'] = 'Zeregin honetan bidalketa bat egin zenuen dagoeneko eta bidalketa horrentzako antzekotasun-txostena sortu zen. Zure lana berriz bidaltzea erabakitzen baduzu, zure lehenagoko bidalketa ordezkatuko da eta txosten berri bat sortuko da. {$a->num_resubmissions} aldiz bidalketa berriztu ondoren {$a->num_hours} ordu itxaron beharko dituzu antzekotasun-txosten berria ikusteko.';
$string['repositoryoptions_0'] = 'Gaitu irakaslearen biltegiko aukera estandarrak';
$string['repositoryoptions_1'] = 'Gaitu irakaslearen biltegiko aukera aurreratuak';
$string['repositoryoptions_2'] = 'Bidali lan guztiak biltegi estandarrera';
$string['repositoryoptions_3'] = 'Ez bidali lanik inongo biltegira';
$string['repositoryoptions_4'] = 'Bidali lan guztiak biltegi instituzionalera';
$string['restorationheader'] = 'Turnitin-eko Klasearen berreskuratzea';
$string['resubmission'] = 'Berbidalketa';
$string['resubmissiongradewarn'] = 'Zeregin honetako berbidalketak entregatze-data heldu arte baimentzen dira. Dauden kalifikazio guztiak ezabatuko dira lana berriz bidaltzean. Jarraitzea nahi duzu?';
$string['resubmissiongradewarnaware'] = 'Kontuan izan mesedez berbidalketa egiten bada, lehendik dagoen edozein kalifikazio ezabatuko dela.';
$string['resubmit'] = 'Berbidali';
$string['resubmitselected'] = 'Berbidali aukeratutako fitxategiak';
$string['resubmitting'] = 'Berbidaltzen';
$string['resubmittoturnitin'] = 'Berbidali Turnitin-era';
$string['reveal'] = 'Ezagutarazi';
$string['revealdesc'] = 'Eman ezazu mesedez ikasleen identitatea ezagutarazteko arrazoi bat.';
$string['revealerror'] = 'Ikasleen identitatea ezagutarazteko arrazoi bat eman behar duzu.';
$string['revealreason'] = 'Ikasleen identitatea ezagutarazteko arrazoia';
$string['savecourseenddate'] = 'Gorde ikastaroaren amaiera-data berria';
$string['savecourseenddateerror'] = 'Errorea gertatu da ikastaroaren amaiera-data berria Turnitin-en gordetzen saiatzerakoan';
$string['saveusage'] = 'Gorde datu-iraulketa';
$string['searchcourses'] = 'Bilatu ikastaroak';
$string['selectcourse'] = 'Aukeratu Moodle ikastaroa';
$string['selectcoursecategory'] = 'Aukeratu Ikastaro Kategoria';
$string['selectoption'] = 'Hautatu aukera';
$string['semptytable'] = 'Ez da emaitzarik aurkitu';
$string['setinstructordefaults'] = 'Ezarri balio hauek zereginen berezko gisa';
$string['setinstructordefaults_help'] = 'Aukeratuz gero ezarpen hauek berezko baliotzat erabiliko dira aurrerago zuk sortzen dituzun Moodle Direct Turnitin zereginetan. Ezarpen hauek kudeatzaileak zehaztutakoak ordezkatuko ditu eta zuretzako bakarrik izango dira.';
$string['settings'] = 'Ezarpenak';
$string['settingsinserterror'] = 'Errorea gertatu da datu-basean ezarpen bat sartzen saiatzerakoan';
$string['settingsupdateerror'] = 'Errorea gertatu da datu-basean ezarpen bat eguneratzen saiatzerakoan';
$string['sharedrubric'] = 'Partekatutako errubrika';
$string['showpeermark'] = 'Erakutsi Peermark Zereginak';
$string['showpeermarkinstructions'] = 'Erakutsi Peermark Argibideak';
$string['showsummary'] = 'Erakutsi zereginaren laburpena';
$string['showusage'] = 'Erakutsi datu-iraulketa';
$string['similarity'] = 'Antzekotasuna';
$string['sinfo'] = '_START_ eta _END_ bitarteko sarrerak erakusten';
$string['slengthmenu'] = 'Erakutsi _MENU_ sarrera';
$string['slengthmigrationmenu'] = 'Erakutsi _MENU_ zeregin';
$string['snext'] = 'Hurrengoa';
$string['source'] = 'Jatorria';
$string['spapercheck'] = 'Konparatu gordetako ikasleen bidalketetan';
$string['spapercheck_help'] = 'Konparatu ikasleen bidalketen Turnitin biltegian daudenekin bidalketen Antzekotasun Txostena prozesatzean. "Ez" aukeratuta antzekotasun indizearen ehunekoa jaitsi daiteke.';
$string['sprevious'] = 'Aurrekoa';
$string['sprocessing'] = 'Datuak Turnitin-etik kargatzen...';
$string['ssearch'] = 'Bilatu:';
$string['standardrepository'] = 'Biltegi estandarra';
$string['startdatenotyearago'] = 'Hasiera-data ezin da orain dela urtebete baino lehenagokoa';
$string['student'] = 'Ikaslea';
$string['student_notread'] = 'Ikasleak ez du txostena ikusi';
$string['student_read'] = 'Ikasleak txostena ikusi du une honetan:';
$string['studentdataprivacy'] = 'Ikasleen datu-pribatutasun ezarpenak';
$string['studentdataprivacy_desc'] = 'Hurrengo ezarpenak ikasleen datu pertsonalak API bitartez Turnitin-era ez bidaltzeko erabili daitezke.';
$string['studentdisclosure'] = 'Ikasleen adierazpena';
$string['studentdisclosure_help'] = 'Testu hau fitxategiak igotzeko orrian ikasle guztiei erakutsiko zaie.';
$string['studentdisclosuredefault'] = 'Igotako fitxategi guztiak Turnitin.com plagioaren kontrolerako zerbitzura bidaliko dira';
$string['studentfirstname'] = 'Izena';
$string['studentlastname'] = 'Abizena';
$string['studentremoved'] = 'Ikaslea Turnitin-eko ikastarotik desmatrikulatu da.';
$string['studentremovingerror'] = 'Errorea gertatu da ikaslea Turnitin-eko ikastarotik desmatrikulatzean';
$string['studentreports'] = 'Erakutsi Antzekotasun Txostenak ikasleei';
$string['studentreports_help'] = 'Turnitin-eko antzekotasun txostenak ikasleei erakusteko aukera ematen du. "Bai" aukeratuz gero ikasleek Turnitin-ek sortutako antzekotasun txostena ikusgai izango dute.';
$string['studentstatus'] = 'Bidalita {$a->modified} (Txostenaren IDa: {$a->objectid})';
$string['submissionagreementerror'] = 'Onespena onartu behar duzu bidalketa honetarako';
$string['submissionauthor'] = 'Bidalketaren Egilea';
$string['submissiondate'] = 'Bidalketa-data';
$string['submissiondeleted'] = 'Bidalketa ezabatua';
$string['submissiondeleteerror'] = 'Ezin izan dira bidalketak ezabatu';
$string['submissionextract'] = 'Bidalketaren pasartea';
$string['submissionfileerror'] = 'Bidalketarako fitxategi bat gehitu behar duzu';
$string['submissionfiletypeerror'] = 'Fitxategi mota ez da onartzen. Onartutako motak ({$a}) dira';
$string['submissiongeterror'] = 'Ezin izan da bidalketaren daturik eskuratu';
$string['submissiongrade'] = 'Kalifikazioa';
$string['submissionorig'] = 'Antzekotasuna';
$string['submissionpart'] = 'Bidalketa-atala';
$string['submissionpart_help'] = 'Aukeratu Turnitin zereginaren zein atalean egin behar den bidalketa hau.';
$string['submissions'] = 'Bidalketak';
$string['submissiontexterror'] = 'Bidalketa honentzako testua gehitu behar duzu';
$string['submissiontitle'] = 'Bidalketaren Izenburua';
$string['submissiontitle_help'] = 'Sartu ezazu bidaltzen ari zaren lanaren izenburua';
$string['submissiontitleerror'] = 'Bidalketa honentzako izenburua zehaztu behar duzu';
$string['submissiontype'] = 'Bidalketa mota';
$string['submissiontype_help'] = '<p>Turnitin-era bidali daitezkeen fitxategi mota(k) zehazten d(it)u.</p>';
$string['submissionupdateerror'] = 'Ezin izan da bidalketaren daturik eguneratu';
$string['submissionuploadsuccess'] = 'Zure bidalketa Turnitin-era ondo igo da.';
$string['submitnothing'] = 'Gaitu ebaluazioa bidalketarik gabeko ikasle honentzat';
$string['submitnothingwarning'] = 'Bidalketarik egin ez duen ikaslearentzat boligrafo grisean klik eginez gero ebaluazio-txantiloia sortuko zaio, eta modu horretan ikasleari zereginerako GradeMark feedbacka eman ahalko diozu. Ebaluazio-txantiloiak bidalketaren lekua hartzen du eta ikasleak zereginera zerbait bidaltzea saihestuko du berbidalketa baimenduta ez badago. <br><br>Ziur zaude bidalketarik egon gabe ere ebaluatu nahi duzula?';
$string['submitondraft'] = 'Bidali fitxategia igotzen den lehen aldian';
$string['submitonfinal'] = 'Bidali fitxategia ikasleak kalifikatzeko bidaltzen duenean';
$string['submitpaper'] = 'Egin bidalketa';
$string['submitpapersto'] = 'Gorde Ikasleen bidalketak';
$string['submitpapersto_help'] = '<strong>Biltegirik ez: </strong><br />Turnitin-ek ez ditu bidalitako dokumentuak inongo biltegitan gordeko. Dokumentua antzekotasun-txostena lortzeko baino ez da prozesatuko.<br /><br /><strong>Biltegi Estandarra: </strong><br />Turnitin-ek dokumentuaren kopia bat Biltegi Estandarrean gordeko du. Aukera hau hautatuz gero, gordetako dokumentuak etorkizunean antzekotasun-egiaztapenak egiteko baino ez ditu erabiliko.<br /><br /><strong>Biltegi Instituzionala (aplikagarria denean): </strong><br />Aukera hau hautatuz gero Turnitin-ek bidalitako dokumentuak zure instituzioko biltegi pribatuan baino ez ditu gordeko. Soilik zure instituzioko beste irakasleek egin ahal izango dituzte bidalitako dokumentuekiko antzekotasun-egiaztapenak.';
$string['submitted'] = 'Bidalita';
$string['submittoturnitin'] = 'Bidali Turnitin-era';
$string['szerorecords'] = 'Ez dago erakusteko erregistrorik';
$string['task_name'] = 'Turnitintooltwo cron zeregina';
$string['testingconnection'] = 'Turnitin-erako konexioa probatzen';
$string['textsubmission'] = 'Testu-bidalketa';
$string['texttosubmit'] = 'Bidaltzeko testua';
$string['texttosubmit_help'] = 'Kopiatu eta itsatsi zure bidalketaren testua kutxa honetan.';
$string['tii2updateerror'] = 'Arazo bat egon da V2 zeregina datu-basean eguneratzean. Mesedez saiatu zaitez berriro.<br />';
$string['tii_submission_failure'] = 'Galdetu mesedez zure irakasleari edo Moodle kudeatzaileari xehetasun gehiagorako.';
$string['tiiaccountconfig'] = 'Turnitin kontuaren konfigurazioa';
$string['tiiaccountsettings'] = 'Turnitin kontuaren ezarpenak';
$string['tiiaccountsettings_desc'] = 'Ziurtatu mesedez ezarpen hauek zure Turnitin-eko kontuan daudenekin bat datozela, bestela zereginak sortzerakoan edo ikasleek bidalketak egiterakoan arazoak egon daitezke.';
$string['tiiassignmentgeterror'] = 'Errorea gertatu da Turnitin-etik zeregin bat eskuratzen saiatzerakoan';
$string['tiidebugginglogs'] = 'Arazketa eta Erregistroa';
$string['tiiexplain'] = 'Turnitin produktu komertzial bat da eta ordaindutako harpidetza bat izan behar duzu zerbitzu hau erabili ahal izateko, informazio gehiagorako ikusi <a href=http://docs.moodle.org/en/Turnitin_administration>http://docs.moodle.org/en/Turnitin_administration</a>';
$string['tiimiscsettings'] = 'Pluginaren bestelako ezarpenak';
$string['tiisubmissiongeterror'] = 'Errorea gertatu da Turnitin-etik bidalketa bat eskuratzen saiatzerakoan';
$string['tiisubmissionsgeterror'] = 'Errorea gertatu da Turnitin-etik zeregin honentzako bidalketak eskuratzen saiatzerakoan';
$string['tiiusergeterror'] = 'Errorea gertatu da Turnitin-etik erabiltzailearen xehetasunak eskuratzen saiatzerakoan';
$string['title'] = 'Izenburua';
$string['transmatch'] = 'Itzulpenaren bidezko bat etortzea';
$string['transmatch_desc'] = 'Zereginaren ezarpenetan Itzulpenaren bidezko bat etortzea gaitzeko ezarpena eskuragarri egongo den edo ez zehazten du.<br /><i>(Aukera hau soilik zure Turnitin kontuan Itzulpenaren bidezko bat etortzea gaituta badago gaitu ezazu)</i>';
$string['turnitin'] = 'Turnitin';
$string['turnitinaccountid'] = 'Turnitin kontuaren IDa';
$string['turnitinaccountid_desc'] = '<b>[Beharrezkoa]</b><br />Sartu ezazu zure Turnitin kontu nagusiaren IDa';
$string['turnitinanon'] = 'Kalifikazio itsua';
$string['turnitinanon_help'] = 'Zure Turnitin zereginak kalifikazio itsua erabili dezan hemen Bai aukeratu ezazu. Lehen bidalketa egin ondoren ezin da kalifikazio itsua desegin.';
$string['turnitinapiurl'] = 'Turnitin APIaren URLa';
$string['turnitinapiurl_desc'] = '<b>[Beharrezkoa]</b><br />Aukeratu Turnitin APIaren URLa';
$string['turnitinconfig'] = 'Turnitin plagio-pluginaren Ezarpenak';
$string['turnitindefaults'] = 'Turnitin plagio-gehigarriaren berezko ezarpenak';
$string['turnitindeleteconfirm'] = 'Lanak ezabatzeak zure bidalketen zerrendatik eta sarrera-ontzitik kentzen ditu baina ez ditu guztiz ezabatzen Turnitin-eko datu-basetik. Ziur zaude bidalketa hau ezabatu nahi duzula? Ekintza honek ez du atzera bueltarik.';
$string['turnitindeletionerror'] = 'Turnitin-eko bidalketaren ezabatzeak huts egin du. Moodleko kopia lokala ezabatu da baina ezin izan da Turnitin-eko bidalketa ezabatu.';
$string['turnitindiagnostic'] = 'Gaitu diagnostiko-modua';
$string['turnitindiagnostic_desc'] = '<b>[Kontuz]</b><br />Diagnostiko-modua soilik Turnitin-eko APIarekin arazoak arazteko gaitu ezazu.';
$string['turnitinenablepeermark'] = 'Gaitu Peermark Zereginak';
$string['turnitinenablepeermark_desc'] = 'Aukeratu Peermark Zereginak sortzea gaitu nahi duzun edo ez<br /><i>(Aukera hau soilik dago eskuragarri Turnitin kontuan Peermark Zereginak gaituta daukatenentzat)</i>';
$string['turnitinenrolstudents'] = 'Matrikulatu ikasle guztiak';
$string['turnitingmoptions'] = 'GradeMark-eko aukerak';
$string['turnitinhelpdesk'] = 'Turnitin-eko laguntza gunea';
$string['turnitinid'] = 'Turnitin IDa';
$string['turnitinloading'] = 'Datuak sinkronizatzen';
$string['turnitinoroptions'] = 'Antzekotasun Txostenaren aukerak';
$string['turnitinpaperid'] = 'Turnitin Txostenaren IDa';
$string['turnitinpart'] = '{$a}. atala';
$string['turnitinpluginsettings'] = 'Turnitin plagio-gehigarriaren ezarpenak';
$string['turnitinppulapost'] = 'Zure fitxategia ez da Turnitin-era bidali. Gure Erabiltzaile-lizentziaren Onespena (EULA) onartzeko egin klik hemen.';
$string['turnitinppulapre'] = 'Fitxategi bat Turnitin-era bidali ahal izateko aurretik gure Erabiltzaile-lizentziaren Onespena (EULA) onartu behar duzu. Onespena ematen ez baduzu zure fitxategia soilik Moodlera bidaliko da. Onespena emateko egin klik hemen.';
$string['turnitinrefreshingsubmissions'] = 'Bidalketak freskatzen';
$string['turnitinrefreshsubmissions'] = 'Freskatu Bidalketak';
$string['turnitinrepositoryoptions'] = 'Zereginetako lanen biltegia';
$string['turnitinrepositoryoptions_desc'] = 'Hautatu ezazu Turnitin zereginetarako biltegiaren aukerak<br /><i>(Biltegi instituzionala aukera hori gaituta duten kontuentzat soilik egongo da eskuragarri)</i>';
$string['turnitinrepositoryoptions_help'] = '<strong>Gaitu irakaslearen biltegi estandarreko aukerak: </strong><br />
Irakasleak aukeratu dezake Turnitin-ek dokumentuak biltegi estandarrean gehitzea edo biltegirik ez erabiltzea<br /><br />
<strong>Gaitu irakaslearen biltegiko aukera aurreratuak: </strong><br />
Aukera honen bitartez irakasleak ikasleen esku utzi dezake Turnitin-ek dokumentuak non gordetzea nahi duten erabakia. Ikasleek euren dokumentuak ikasleen biltegi estandarrean edo zure erakundeko biltegi pribatuan gordetzea erabaki dezakete.<br /><br />
<strong>Bidali lan guztiak biltegi estandarrera: </strong><br />
Dokumentu guztiak ikasleen biltegi estandarrera gehitu dira modu lehenetsian.<br /><br />
<strong>Ez bidali lanik inongo biltegira: </strong><br />
Dokumentuak soilik erabiliko dira Turnitin-eko hasierako egiaztapena egiteko eta irakasleen ebaluaketarako erakusteko.<br /><br />
<strong>Bidali lan guztiak biltegi instituzionalera: </strong><br />
Turnitin-ek lan guztiak biltegi instituzionalean gordeko ditu. Soilik zure erakundeko irakasleek egin ahalko dituzte bidalitako dokumentuen gaineko konparaketak.';
$string['turnitinsecretkey'] = 'Turnitin-eko gako partekatua';
$string['turnitinsecretkey_desc'] = '<b>[Beharrezkoa]</b><br />Sartu zure Turnitin-eko gako partekatuabr /><i>(zure Turnitin-eko kudeatzaileak zehaztuta)</i>';
$string['turnitinsettingshelpwizard'] = 'Gaitu Turnitin-eko laguntza gunea irakasleentzat';
$string['turnitinsettingshelpwizard_desc'] = 'Aukeratu irakasleek Moodletik Turnitin-eko laguntza guneko morroira sartzeko aukera izango duten.';
$string['turnitinstatus'] = 'Turnitin egoera';
$string['turnitinstudents'] = 'Turnitin Ikasleak';
$string['turnitinstudents_desc'] = 'Azpian aukeratutako erabiltzaileak Turnitin-eko Klase honetan matrikulatuta daude. Matrikulatutako ikasleek klase honetarako sarbidea eskuratu dezakete Turnitin-eko webgunean saioa hasita.';
$string['turnitinstudentsremove'] = 'Ziur zaude ikasle hau Turnitin-eko ikastaro honetatik desmatrikulatu nahi duzula?';
$string['turnitinsubmissionid'] = 'Turnitin bidalketaren IDa';
$string['turnitintoolofflineerror'] = 'Behin-behineko arazoak izaten ari gara. Mesedez saiatu zaitez berriro gutxi barru.';
$string['turnitintooltwo'] = 'Turnitin zeregina';
$string['turnitintooltwo:addinstance'] = 'Gehitu Turnitin zeregina';
$string['turnitintooltwo:admin'] = 'Kudeatu Turnitin zeregina';
$string['turnitintooltwo:grade'] = 'Kalifikatu Turnitin zereginak';
$string['turnitintooltwo:read'] = 'Irakurri Turnitin zereginak';
$string['turnitintooltwo:submit'] = 'Bidali Turnitin zereginak';
$string['turnitintooltwo:view'] = 'Ikusi Turnitin zereginak';
$string['turnitintooltwoadministration'] = 'Turnitin Zeregina 2 Kudeaketa';
$string['turnitintooltwoagreement'] = 'Erantzukizun-deskargua / Onespena';
$string['turnitintooltwoagreement_default'] = 'Bidalketa hau nik egindako lana dela baieztatzen dut eta bidalketa honen ondorioz gertatu daitezkeen copyright urraketen gaineko ardura guztia onartzen dut.';
$string['turnitintooltwoagreement_desc'] = '<b>[Hautazkoa]</b><br />Sartu ezazu onespena adierazteko berreste-adierazpena.<br />(<b>Note:</b>Hutsik utziz gero ez da berreste-sententziaren onespenik eskatuko ikasleek bidalketak egitean)';
$string['turnitintooltwodeleteerror'] = 'Ezin izan da turnitintooltwo-eko daturik ezabatu';
$string['turnitintooltwogeterror'] = 'Ezin izan da turnitintooltwo-eko daturik eskuratu';
$string['turnitintooltwointro'] = 'Laburpena';
$string['turnitintooltwoname'] = 'Turnitin zereginaren Izena';
$string['turnitintooltworesetdata0'] = 'Kopiatu Turnitin-eko zereginak <i>(Turnitin-eko Klase berria den kopia sortu)</i>';
$string['turnitintooltworesetdata1'] = 'Ordezkatu Turnitin-eko zereginak <i>(Turnitin-klasea berrerabiliz zeregin-atalak ordezkatu)</i>';
$string['turnitintooltworesetdata2'] = 'Utzi Turnitin zereginak ukitu gabe';
$string['turnitintooltworesetinfo'] = 'Hautatu azpiko aukeretako bat ikastaro honetako Turnitin zereginentzat:';
$string['turnitintooltwoupdateerror'] = 'Ezin izan dira turnitintooltwo-eko datuak eguneratu';
$string['turnitintutors'] = 'Turnitin tutoreak';
$string['turnitintutors_desc'] = 'Azpian aukeratutako irakasleak Turnitin-eko Klase honetan irakasle gisa matrikulatuta daude. Matrikulatutako irakasleek klase honetarako sarbidea eskuratu dezakete Turnitin-eko webgunean saioa hasita.';
$string['turnitintutorsadd'] = 'Gehitu Turnitin irakaslea';
$string['turnitintutorsallenrolled'] = 'Irakasle guztiak Turnitin-en matrikulatuta daude';
$string['turnitintutorsremove'] = 'Ziur zaude irakasle hau Turnitin-eko ikastaro honetatik kendu nahi duzula?';
$string['turnitinula'] = 'Turnitin-eko Erabiltzaile-lizentziaren Onespena onartu behar duzu bidalketa egin ahal izateko.';
$string['turnitinula_btn'] = 'Mesede egin klik hemen Onespena irakurri eta onartzeko.';
$string['turnitinuseanon'] = 'Erabili kalifikazio itsua';
$string['turnitinuseanon_desc'] = 'Aukeratu bidalketak kalifikatzerakoan kalifikazio itsua gaitu nahi duzun edo ez.<br /><i>(Aukera hau soilik dago eskuragarri euren Turnitin kontuan kalifikazio itsua gaituta dutenentzat)</i>';
$string['turnitinusegrademark'] = 'Erabili GradeMark';
$string['turnitinusegrademark_desc'] = 'Erabaki bidalketak kalifikatzeko GradeMark erabili nahi duzun edo ez<br /><i>(Aukera hau soilik dago eskuragarri euren Turnitin kontuan GradeMark aukera gaituta dutenentzat)</i>';
$string['turnitinusegrademark_help'] = 'Ezarpen honen bitartez bidalketak kalifikatzeko Turnitin-eko GradeMark edo Moodle erabili nahi duzun aukeratu dezakezu.';
$string['turnitinusegrammar'] = 'Gaitu gramatikaren feedbacka';
$string['turnitinusegrammar_desc'] = 'Aukeratu bidalitako fitxategiek gramatikaren egiaztapena jaso ahal duten ala ez.<br /><i>(Gramatikaren feedbacka zure Turnitin kontuan ere gaituta egon behar du)</i>';
$string['turnitinuserepository'] = 'Gaitu Biltegi Instituzionala';
$string['turnitinuserepository_desc'] = 'Aukeratu ezazu Turnitin zereginetan Biltegi Instituzional erabiltzea gaitzea edo ez.<br /><i>(Aukera hau soilik dago eskuragarri euren kontuan Biltegi Instituzionala gaituta dutenentzat)</i>';
$string['turnitinuserepository_help'] = 'Erabili ezarpen hau Turnitin zereginetan Biltegi Instituzional erabiltzea gaitzeko.<br /><i>(Aukera hau soilik dago eskuragarri euren kontuan Biltegi Instituzionala gaituta dutenentzat)</i>';
$string['tutoradded'] = 'Turnitin-en tutorea ikastaroan gehitu da';
$string['tutoraddingerror'] = 'Arazoa gertatu da irakaslea Turnitin-eko ikastaro honetan gehitzerakoan';
$string['tutorremoved'] = 'Turnitin-en tutorea ikastarotik kendu da';
$string['tutorremovingerror'] = 'Arazoa gertatu da irakaslea Turnitin-eko ikastaro honetatik kentzerakoan';
$string['tutorstatus'] = '{$a->total}(e)tik {$a->submitted} ikasle-bidalketa, ebaluatutako {$a->graded} bidalketa';
$string['type'] = 'Bidalketa mota';
$string['types'] = 'Bidalketa motak';
$string['types_help'] = 'Bidalketak bi modutan egin daitezke: fitxategi-bidalketa edo testu-bidalketa.';
$string['unanonymiseerror'] = 'Errorea gertatu da Turnitin-etik erabiltzailearen identitatea ezagurazten saiatzerakoan';
$string['uniquepartname'] = 'Atalaren izena bakarra izan behar da';
$string['unlinkedusers'] = 'Esteka kendutako erabiltzaileak';
$string['unlinkrelinkusers'] = 'Kendu esteka / Berriz estekatu Turnitin-eko erabiltzaileak';
$string['unlinkusers'] = 'Kendu esteka erabiltzaileei';
$string['updatepart'] = 'Eguneratu atala';
$string['updatesubmissionerror'] = 'Errore bat gertatu da zure bidalketa Turnitin-era berbidaltzen saiatzerakoan';
$string['upgradeavailable'] = 'Eguneraketa eskuragarri';
$string['upgradenotavailable'] = 'Ez dago eguneraketarik eskuragarri';
$string['uploadingsubtoturnitin'] = 'Zure bidalketa Turnitin-era igotzen';
$string['user'] = 'Erabiltzailea';
$string['usercreationerror'] = 'Turnitin erabiltzailea sortzeak huts egin du';
$string['userdeleteerror'] = 'Ezin izan dira erabiltzaile-datuak ezabatu';
$string['userfinderror'] = 'Errorea gertatu da Turnitin-eko erabiltzailea aurkitzen saiatzerakoan';
$string['usergeterror'] = 'Ezin izan dira erabiltzaile-datuak eskuratu';
$string['userjoinerror'] = 'Errorea gertatu da erabiltzailea Turnitin-eko ikastaro batean matrikulatzen saiatzerakoan';
$string['userremoveerror'] = 'Errorea gertatu da erabiltzailea Turnitin-eko ikastaro batetik desmatrikulatzen saiatzerakoan';
$string['userstounlink'] = 'Esteka kentzeko erabiltzaileak';
$string['usersunlinkrelink'] = 'Esteka kentzeko / berriz estekatzeko erabiltzaileak';
$string['userupdateerror'] = 'Ezin izan dira erabiltzaile-datuak eguneratu';
$string['useturnitin'] = 'Gaitu Turnitin';
$string['useturnitin_mod'] = 'Gaitu Turnitin {$a} jardueran';
$string['usinglatest'] = 'Azken bertsioa erabiltzen ari zara!';
$string['v1assignmentsdeleted'] = 'Zeregina(k) ondo ezabatu d(ir)a.';
$string['v1migrationsubtitle'] = 'Moodle Direct V1etik V2rako migrazio-tresna';
$string['v1migrationtitle'] = 'V1 migrazioa';
$string['viewdigitalreceipt'] = 'Ikusi Jasotze-agiri Digitala';
$string['viewreport'] = 'Ikusi Txostena';
$string['viewsubmission'] = 'Ikusi Bidalketa';
$string['viewsubmissiondesc'] = 'Erabiltzaileak bidalketa ikusi du';
$string['wrongaccountid'] = 'Errorea gertatu da zure Turnitin-eko Klasea estekatzerakoan. Zuk konfiguratutako kontua {$a->current} da, eta klase honen kontua {$a->backupid} da. Soilik zure Turnitin-eko kontu berean sortutako klaseak berreskuratu ditzakezu.';
$string['yes'] = 'Bai';
$string['yesgrades'] = 'Bai, automatikoki eguneratu antzekotasun-puntuazioak eta kalifikazioak';
