<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'no', version '4.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Handlinger';
$string['activate'] = 'Aktiver tilgang';
$string['activatesuccess'] = 'Tilgang til utmerkelser er aktivert.';
$string['addalignment'] = 'Legg til kompetanse eller standard';
$string['addbackpack'] = 'Legg til ryggsekk';
$string['addbadge'] = 'Legg til utmerkelser';
$string['addbadge_help'] = 'Velg alle utmerkelser som skal leges til i kravene for denne utmerkelsen. Hold inn ctrl for å velge flere elementer.';
$string['addbadgecriteria'] = 'Angi et kriterie for utmerkelsen';
$string['addcohort'] = 'Legg til kohort';
$string['addcohort_help'] = 'Velg alle kohorter som skal legges til dette utmerkelseskriteriet. Hold inne CTRL for å velge flere elementer.';
$string['addcompetency'] = 'Legg til kompetanse';
$string['addcompetency_help'] = 'Velg alle kompetanser som skal legges til utmerkelseskriteriene. Hold inne CTRL-knappen for å velge flere elementer.';
$string['addcourse'] = 'Legg til kurs';
$string['addcourse_help'] = 'Velg de kursene som skal legges til dette utmerkelseskravet. Hold CTRL-tasten nede for å velge mer enn ett kurs.';
$string['addcriteria'] = 'Legg til krav';
$string['addcriteriatext'] = 'Start med å velge en av opsjonene fra listemenyen når du skal legge til et utmerkelseskrav.';
$string['addedtobackpack'] = 'La til utmerkelser i ryggsekken';
$string['addrelated'] = 'Legg til relatert utmerkelse';
$string['addtobackpack'] = 'Legg til i ryggsekk';
$string['adminonly'] = 'Denne siden er kun for portaladministratorer.';
$string['after'] = 'etter tildelingsdatoen';
$string['aggregationmethod'] = 'Tildelingsmetode';
$string['alignment'] = 'Justering';
$string['all'] = 'Alle';
$string['allmethod'] = 'Alle valgte krav er oppfylt';
$string['allmethodactivity'] = 'Alle valgte aktiviteter er fullført';
$string['allmethodbadges'] = 'Alle valgte utmerkelser har blitt tildelt.';
$string['allmethodcohort'] = 'Medlemskap i alle valgte kohorter';
$string['allmethodcompetencies'] = 'Alle de valgte kompetansene må være fullført';
$string['allmethodcourseset'] = 'Alle valgte kurs er fullført';
$string['allmethodmanual'] = 'Alle valgte roller kan tildele utmerkelsen';
$string['allmethodprofile'] = 'Alle valgte profilfelter er fullført';
$string['allowcoursebadges'] = 'Aktiver kursutmerkelser';
$string['allowcoursebadges_desc'] = 'Tillat at utmerkelses opprettes og tildeles i  kurs.';
$string['allowexternalbackpack'] = 'Kobling til ekstern ryggsekk';
$string['allowexternalbackpack_desc'] = 'Hvis dette er aktivert, kan brukere koble seg til en ekstern ryggsekk og dele utmerkelsene sine fra denne portalen. Brukere kan også velge å vise alle offentlige merkesamlinger fra deres eksterne ryggsekk på profilsiden deres på denne portalen. Det anbefales å la dette alternativet være deaktivert hvis portalen ditt ikke er tilgjengelig fra Internett.';
$string['any'] = 'Et av';
$string['anymethod'] = 'Et av de valgte betingelsen er oppfylt';
$string['anymethodactivity'] = 'En av de valgte aktivitetene er fullført';
$string['anymethodbadges'] = 'En av de valgte utmerkelsene har blitt tildelt.';
$string['anymethodcohort'] = 'Medlemskap i en av de valgte kohortene';
$string['anymethodcompetencies'] = 'Ett av de valgte kompetansene må være fullført';
$string['anymethodcourseset'] = 'Et av de valgte kursene er fullført';
$string['anymethodmanual'] = 'En av de valgte rollene tildeler utmerkelsen';
$string['anymethodprofile'] = 'Et av de valgte profilfeltene er utfylt';
$string['apiversion'] = 'API-versjon støttet';
$string['archivebadge'] = 'Ønsker du å slette utmerkelsen \'{$a}\', men beholde eksisterende utmerkelser?';
$string['archiveconfirm'] = 'Slett og behold eksisterende utgitte utmerkelser';
$string['archivehelp'] = '<p>Dette valget gjør at en utmerkelse vil merkes som "utgått" og vil ikke lengre vises i listen over merker. Brukere kan ikke lengre få denne utmerkelsen, men brukere som allerede har utmerkelsen vil fortsatt kunne vise frem utmerkelsen på profilen sin og sende det til eksterne utmerkelsesryggsekker</p>
<p>Hvis du ønsker at brukerne fortsatt skal ha tilgang til opptjente utmerkelser er det viktig å velge dette alternativet istedet for å slette utmerkelsene fullstendig</p>';
$string['attachment'] = 'Legg til utmerkelsen i meldingen';
$string['attachment_help'] = 'Når aktivert, vil den tildelte utmerkelsen bli lagt ved e-posten til mottakeren slik at utmerkelsen kan lastes ned. Aktivering av e-postvedlegg må være gjort i portalinnstillingene for at dette valget skal kunne brukes. Dette gjøres ved å gå til Portalen > Server > Konfigurasjon av utgående epost.';
$string['award'] = 'Tildel utmerkelse';
$string['awardedto'] = 'Tildelt til {$a}';
$string['awardedtoyou'] = 'Tildelt meg';
$string['awardoncron'] = 'Tilgang til utmerkelsen er aktivert. Det er for mange brukere som kan få denne utmerkelsen samtidig, så det kan ta noe tid før tildelingen er ferdig prosessert.';
$string['awards'] = 'Mottakere';
$string['backpackapiurl'] = 'Ryggsekk-API URL';
$string['backpackavailability'] = 'Verifisering av ekstern utmerkelse';
$string['backpackavailability_help'] = 'Du må aktivisere koblingen til en ekstern utmerkelsegodkjenningstjeneste slik at de som mottar utmerkelser kan få bekreftet at de er ekte. Det ser ikke ut til at portalen din er tilgjengelig for slik kontroll, noe som betyr at de merkene du allerede har tildelt eller vil tildele i fremtiden ikke kan bekreftes.

**Hvorfor vises denne meldingen til meg?**

Det kan være at brannmuren forhindrer tilgang fra brukere utenfor det lokale nettverket, at portalen er passordbeskyttet eller at du kjører portalen på en server som ikke er tilgjengelig på det åpne internett. (F.eks. en lokal utviklingsserver)

**Er dette egentlig noe problem?**

Du bør fikse dette på alle produksjonsportaler hvor du planlegger å tildele merker, ellers vil ikke mottakerne kunne bevise ektheten. Dersom portalen din ikke er offentlig ennå kan du opprette testmerker - men bare hvis serveren er tilkoblet internett.

**Hva hvis jeg ikke kan gjøre portalen tilgjengelig på internett?**

Den eneste URL-en som kreves for verifisering er [din-web-adresse]/badges/assertion.php, så hvis du kan lage en unntaksregel i brannmuren til denne filen vil merkeverifiseringen fortsatt fungere.';
$string['backpackbadgessettings'] = 'Endre ryggsekkinnstillinger';
$string['backpackbadgessummary'] = 'Du har {$a->totalbadges} utmerkelse(r) fra {$a->totalcollections} samling(er).';
$string['backpackcannotsendverification'] = 'Kan ikke sende bekreftelsesepost';
$string['backpackconnected'] = 'Ryggsekk koblet til';
$string['backpackconnection'] = 'Ryggsekk-kobling';
$string['backpackconnection_help'] = 'Ved å koble til en ryggsekk kan du dele utmerkene dine fra dette nettstedet og vise offentlige utmerkelser fra ryggsekken på profilsiden din på dette nettstedet.';
$string['backpackconnectioncancelattempt'] = 'Koble til med en annen epostadresse';
$string['backpackconnectionconnect'] = 'Koble til ryggsekk';
$string['backpackconnectionnottested'] = 'Tilkobling kan ikke testes for denne ryggsekken fordi bare OBv2.0 ryggsekker støtter den.';
$string['backpackconnectionok'] = 'Ryggsekkforbindelse ble opprettet';
$string['backpackconnectionresendemail'] = 'Send bekreftelsesepost på nytt';
$string['backpackconnectionunexpectedmessage'] = 'Ryggsekken retunrerte feilen: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Det oppstod et problem med tilkoblingen til ryggsekken. Vennligst sjekk tilgangsinformasjonen og prøv igjen.';
$string['backpackdetails'] = 'Ryggsekkinnstillinger';
$string['backpackdisconnected'] = 'Ryggsekk koblet fra';
$string['backpackemail'] = 'E-postadresse';
$string['backpackemail_help'] = 'E-postadressen som er koblet mot dine eksterne samling av utmerkelser .

Dersom koblingen er etablert vil denne e-postadressen brukes i stedet for din interne e-postadresse for å overføre utmerkelses til dine eksterne samling av utmerkelser.';
$string['backpackemailverificationpending'] = 'Avventer bekreftelse';
$string['backpackemailverifyemailbody'] = 'Hei,

Det har kommet en forespørsel om en ny tilkobling til ryggsekken din for OpenBadges fra \'{$a->sitename}\' med din epostadresse.

For å bekrefte og aktivere denne tilkoblingen, vennligst klikk på lenken nedenfor.

{$a->link}

I de fleste epostlesere vil denne lenke være blå og klikkbar. Dersom det ikke fungerer kan du kopiere lenken og lime den inn i addressefeltet i nettleseren din.

Dersom du trenger hjelp, vennligst ta kontakt med portaladministratoren,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Epostbekreftelse for Badges-ryggsekk';
$string['backpackemailverifypending'] = 'En bekreftelsesepost har blitt sendt til <strong>{$a}</strong>. Klikk på bekreftelseslenken i eposten for å aktivere ryggsekktilkoblingen.';
$string['backpackemailverifysuccess'] = 'Takk for at du bekreftet epostadressen din. Du er nå koblet til ryggsekken din.';
$string['backpackemailverifytokenmismatch'] = 'Tokenet i linken du klikket på samsvarer ikke med lagret token. Vennligst sjekk at du brukte linken i den siste e-posten du mottok.';
$string['backpackexporterror'] = 'Kan ikke eksportere utmerkelsen til ryggsekk';
$string['backpackimport'] = 'Importinnstillinger for utmerkelser';
$string['backpackimport_help'] = 'Etter at merkegodkjenningstjenesten er tilkoblet og fungerer vil dine tildelte merker vises på din "Mine utmerkelser" side og på profilsiden din.

På dette området kan du velge hvilke utmerkelser du ønsker skal vises i profilen din.';
$string['backpackneedsupdate'] = 'Ryggsekken koblet til denne profilen stemmer ikke overens med ryggsekken for denne portalen. Du må koble fra ryggsekken og koble den til igjen';
$string['backpackprovider'] = 'Ryggsekk-tilbyder';
$string['backpacksettings'] = 'Ryggsekkinnstillinger';
$string['backpackweburl'] = 'RyggsekkURL';
$string['badgedetails'] = 'Utmerkelsesdetaljer';
$string['badgeimage'] = 'Bilde';
$string['badgeimage_help'] = 'Bildet bør ha en størrelse på minst 300 x 300 piksler. Det vil vises som 300 x 300 piksler på merkesiden og 100 x 100 piksler på brukerens profilside.';
$string['badgeprivacysetting'] = 'Hvem som skal få se utmerkelsene dine';
$string['badgeprivacysetting_help'] = 'Utmerkelser du er tildelt kan vises i brukerprofilen din. Denne innstillingen lar deg angi hvordan nylig tildelte utmerkelser skal vises.

Du kan fortsatt bestemme om hver enkelt utmerkelse skal vises for andre på siden "Mine utmerkelser".';
$string['badgeprivacysetting_str'] = 'Vis automatisk på profilsiden min alle utmerkelser jeg blir tildelt.';
$string['badges'] = 'Utmerkelser';
$string['badgesalt'] = 'Krypteringsfrase for mottakeres e-postadresse';
$string['badgesalt_desc'] = 'Bruk av krypteringsstrenger tillater at tjenester for godkjenning av utmerkelser bekrefter utmerker uten å vise mottakerens e-postadresse. Denne innstillingen bør bare bruke tall og bokstaver.

Merk: Du bør ikke endre disse innstillingene etter at tildeling av utmerkelser har startet. Det vil skape problemer for verifiseringen av utmerkelsene.';
$string['badgesdisabled'] = 'Utmerkelser er ikke aktivert på denne portalen.';
$string['badgesearned'] = 'Antall tildelte utmerkelser: {$a}';
$string['badgesettings'] = 'Utmerkelsesinnstillinger';
$string['badgestatus_0'] = 'Ikke tilgjengelig';
$string['badgestatus_1'] = 'Tilgjengelig';
$string['badgestatus_2'] = 'Ikke tilgjengelig (kriterie låst)';
$string['badgestatus_3'] = 'Tilgjengelig (kriterie låst)';
$string['badgestatus_4'] = 'Arkivert';
$string['badgestoearn'] = 'Antall tilgjengelige utmerkelser: {$a}';
$string['badgesview'] = 'Kursutmerkelser';
$string['badgeurl'] = 'Lenke til tildelt utmerkelse';
$string['balignment'] = 'Kompetanser ({$a}';
$string['bawards'] = 'Mottakere ({$a})';
$string['bcriteria'] = 'Kriterier';
$string['bdetails'] = 'Endre detaljer';
$string['bendorsement'] = 'Anbefaling';
$string['bmessage'] = 'Melding';
$string['boverview'] = 'Oversikt';
$string['brelated'] = 'Relaterte utmerkelser ({$a})';
$string['bydate'] = 'fullført innen';
$string['claim'] = 'Krev';
$string['claimcomment'] = 'Anbefaling';
$string['claimid'] = 'KravURL';
$string['clearsettings'] = 'Slett innstillinger';
$string['completioninfo'] = 'Denne utmerkelsen er tildelt for å ha fullført:';
$string['completionnotenabled'] = 'Kursfullføring er ikke aktivert for dette kurset, så det kan dessverre ikke tas med som noe kriterium for utmerkelser. Du kan aktivere kursfullføring under kursets innstillinger.';
$string['configenablebadges'] = 'Når aktivert, vil denne funksjonen la deg opprette utmerkelser og tildele dem til brukere på denne portalen.';
$string['configuremessage'] = 'Melding som skal gis ved utmerkelsestildeling';
$string['connect'] = 'Koble til';
$string['connected'] = 'Tilkoblet';
$string['connecting'] = 'Kobler til...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'En e-postadresse til den som tildeler utmerkelses';
$string['copyof'] = 'Kopi av {$a}';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Utmerkelser';
$string['coursebadgesdisabled'] = 'Utmerkelses er ikke aktivert på denne portalen.';
$string['coursebadgetitle'] = '{$a} kursutmerkelse';
$string['coursecompletion'] = 'Brukerne må fullføre dette kurset.';
$string['create'] = 'Ny utmerkelse';
$string['createbutton'] = 'Opprett utmerkelse';
$string['creatorbody'] = '<p>{$a->user} har bestått alle utmerkelseskravene og kan tildeles utmerkelsen. Du kan se utmerkelsen her:  {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' er belønnet!';
$string['criteria_0'] = 'Denne utmerkelsen tildeles når....';
$string['criteria_1'] = 'Aktivitetsfullføring';
$string['criteria_1_help'] = 'Tillat at en utmerkelse tildeles brukere når de fullfører et sett av aktiviteter i kurset.';
$string['criteria_2'] = 'Tildel manuelt via rolle';
$string['criteria_2_help'] = 'Tillat at en utmerkelse tildeles manuelt av brukere som har en bestemt rolle på portalen eller i kurset.';
$string['criteria_3'] = 'Sosial deltakelse';
$string['criteria_3_help'] = 'Sosial';
$string['criteria_4'] = 'Kursfullføring';
$string['criteria_4_help'] = 'Tillater at en utmerkelse tildeles brukere som har fullført kurset. Dette kriteriet har en tilleggsparameter, slik som minstekrav til karakter og dato for kursfullføring.';
$string['criteria_5'] = 'Fullfører et sett av kurs';
$string['criteria_5_help'] = 'Tillater at en utmerkelse blir tildelt brukere som har fullført et sett av kurs. Hvert kurs kan ha tilleggsparametre som minstekrav til karakter og dato for kursfullføringen.';
$string['criteria_6'] = 'Fullføring av egen profil';
$string['criteria_6_help'] = 'Tillater at en utmerkelse tildeles brukere for fullføring av bestemte felt i egen profil. Du kan velge fra standard og egendefinerte felt som er tilgjengelige for brukerne.';
$string['criteria_7'] = 'Tildelte utmerkelser';
$string['criteria_7_help'] = 'Tillater utdeling av en utmerkelse på bakgrunn av andre tildelte utmerkelser.';
$string['criteria_8'] = 'Kohortmeldemskap';
$string['criteria_8_help'] = 'Tillater at en utmerkelses deles ut på bakgrunn av kohortmedlemskap.';
$string['criteria_9'] = 'Kompetanser';
$string['criteria_9_help'] = 'Tillter at en utmerkelse deles ut til brukere basert på fullførte kompetanser.';
$string['criteria_descr'] = 'Studenter blir tildelt denne utmerkelsen når de fullfører følgende betingelser:';
$string['criteria_descr_0'] = 'Fullfør <strong> {$a} </strong> av kravene som er oppført.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> av følgende aktivitetskrav er fullført:';
$string['criteria_descr_2'] = 'Denne utmerkelsen tildeles av brukere med <strong>{$a}</strong> av følgende roller:';
$string['criteria_descr_4'] = 'Studenter må fullføre kurset';
$string['criteria_descr_5'] = '<strong>{$a}</strong> av følgende kurs må fullføres:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> av følgende brukerprofilfelt må fylles ut:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> av følgende utmerkelser må tildeles:';
$string['criteria_descr_8'] = 'Medlemskap i <strong>{$a}</strong> av følgende kohorter er påkrevd:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> av følgende kompetaner må fullføres::';
$string['criteria_descr_bydate'] = 'av <em>{$a}</em>';
$string['criteria_descr_grade'] = 'med minimum karakter <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short1'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short2'] = 'Tildelt av <strong>{$a}</strong> til:';
$string['criteria_descr_short4'] = 'Fullfør kurset';
$string['criteria_descr_short5'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short6'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short7'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_short8'] = 'Kohortmedlemskap i <strong>{$a}</strong>  av:';
$string['criteria_descr_short9'] = 'Fullfør <strong>{$a}</strong> av:';
$string['criteria_descr_single_1'] = 'Følgende aktiviteter må fullføres:';
$string['criteria_descr_single_2'] = 'Denne utmerkelsen må tildeles av en bruker med følgende rolle:';
$string['criteria_descr_single_4'] = 'Studenter må fullføre kurset';
$string['criteria_descr_single_5'] = 'Følgende kurs må fullføres:';
$string['criteria_descr_single_6'] = 'Følgende brukerprofilfelt må fylles ut:';
$string['criteria_descr_single_7'] = 'Følgende utmerkelse må tildeles:';
$string['criteria_descr_single_8'] = 'Det kreves medlemskap i følgende kohort:';
$string['criteria_descr_single_9'] = 'Følgende kompetanser må fullføres:';
$string['criteria_descr_single_short1'] = 'Fullfør:';
$string['criteria_descr_single_short2'] = 'Tildelt av:';
$string['criteria_descr_single_short4'] = 'Fullfør kurset';
$string['criteria_descr_single_short5'] = 'Fullfør:';
$string['criteria_descr_single_short6'] = 'Fullfør:';
$string['criteria_descr_single_short7'] = 'Fullført:';
$string['criteria_descr_single_short8'] = 'Meldem i:';
$string['criteria_descr_single_short9'] = 'Fullfør:';
$string['criteriacreated'] = 'Et utmerkelseskriterie har blitt opprettet';
$string['criteriadeleted'] = 'Et utmerkelseskriterie har blitt slettet';
$string['criteriasummary'] = 'Kriteriesammendrag';
$string['criteriaupdated'] = 'Et utmerkelseskriterie har blitt oppdatert';
$string['criterror'] = 'Gjeldende parameterfeil';
$string['criterror_help'] = 'Dette feltsettet viser alle parametre som fra starten av ble lagt til denne utmerkelsen, og som ikke lenger er tilgjengelige. Det anbefales av du fjerner slike parametre for å sikre at studentene kan få tildelt denne utmerkelsen i fremtiden.';
$string['currentimage'] = 'Gjeldende bilde:';
$string['currentstatus'] = 'Gjeldende status:';
$string['dateawarded'] = 'Dato tildelt';
$string['dateearned'] = 'Dato: {$a}';
$string['day'] = 'Dager';
$string['deactivate'] = 'Deaktiver tilgang';
$string['deactivatesuccess'] = 'Tilgangen til utmerkelsen er nå deaktivert.';
$string['defaultissuercontact'] = 'Tildeler av utmerkelsens epostadresse.';
$string['defaultissuercontact_desc'] = 'En e-postadresse tilhørende tildeleren av utmerkelsen.';
$string['defaultissuername'] = 'Navn på tildeler av utmerkelsen';
$string['defaultissuername_desc'] = 'Navn på tildeler/utgiver av utmerkelsen';
$string['defaultissuerpassword'] = 'Utmerkelseutgiver passord';
$string['defaultissuerpassword_help'] = 'Det kreves en konto på ryggsekkportalen. Denne kontoen må ha samme epostadresse som i portalinnstillingene for utmerkelser. Passordet for denne kontoen skal skrives inn her.';
$string['delbadge'] = 'Ønsker du å slette utmerkelsen \'{$a}\' og fjerne alle tildelte utmerkelser?';
$string['delconfirm'] = 'Slett og fjern tildelte utmerkelser';
$string['delcritconfirm'] = 'Er du sikker på at du vil slette dette kriteriet?';
$string['deletehelp'] = '<p>Fullstendig sletting av utmerkelser betyr at all informasjonen og kriteriene knyttet til den vil fjernes permanent. Brukere som har blitt tildelt denne utmerkelsen vil ikke lengre ha tilgang til den eller vise den frem på profilen sin</p>
<p>Merk: Brukere som har blitt tildelt denne utmerkelsen og allerede eksportert den til en ekstern utmerkelsesryggsekk, vil fortsatt ha utmerkelsen i ryggsekken sin. De vil imidleritdig ikke ha tilgang til fortjenestekriteriene og bevissiden som lenker tilbake til denne portalen.</p>';
$string['delexternalbackpack'] = 'Slett portalryggsekk';
$string['delexternalbackpackconfirm'] = 'Slett portalryggsekk \'{$a}\'?';
$string['delparamconfirm'] = 'Er du sikker på at du vil slette dette parameteret?';
$string['description'] = 'Beskrivelse';
$string['disconnect'] = 'Frakoble';
$string['donotaward'] = 'Denne utmerkelsen er ikke aktiv nå, så den kan ikke deles ut til brukere. Hvis du ønsker å dele ut utmerkelsen til noen, må du sette status til aktiv.';
$string['editsettings'] = 'Rediger innstillinger';
$string['enablebadges'] = 'Aktiver utmerkelser';
$string['endorsement'] = 'Anbefaling';
$string['error:backpackdatainvalid'] = 'Dataene som ble returnert fra den eksterne porteføljen var ugyldig.';
$string['error:backpackemailnotfound'] = 'Den oppgitte epostadressen \'{$a}\' er ikke tilknyttet noen ekstern portefølje. Du må <a href="http://backpack.openbadges.org"> opprette en portefølje </a> for den epostadressen, eller logge inn med en annen epostadresse.';
$string['error:backpacknotavailable'] = 'Kursportalen din er ikke tilgjengelig fra Internett, så de utmerkelsene du tildeler fra denne kursportalen vil derfor ikke kunne verifiseres fra en ekstern portefølje av utmerkelser.';
$string['error:backpackproblem'] = 'Det oppstod et problem ved tilkobling til din personlige samling av utmerkelser. Vennligst prøv igjen senere.';
$string['error:badgeawardnotfound'] = 'Kan ikke verifisere detnne utmerkelsen. Utmerkelsen kan ha blitt tilbakekalt.';
$string['error:badgenotfound'] = 'Fant ikke utmerkelse';
$string['error:cannotact'] = 'Kan ikke aktivere utmerkelsen';
$string['error:cannotawardbadge'] = 'Kan ikke dele ut utmerkelsen til bruker.';
$string['error:cannotdeletecriterion'] = 'Dette kriteriet kan ikke slettes';
$string['error:cannotrevokebadge'] = 'Kan ikke tilbakekalle utmerkelse.';
$string['error:clone'] = 'Kan ikke klone utmerkelsen.';
$string['error:connectionunknownreason'] = 'Tilkoblingen var mislykket og det ble ikke oppgitt noen årsak.';
$string['error:duplicatename'] = 'Det eksisterer allerede en utmerkelse med samme navn på dette systemet.';
$string['error:externalbadgedoesntexist'] = 'Finner ikke utmerkelse';
$string['error:guestuseraccess'] = 'Du er logget inn som gjest. Du må logge inn med brukerkontoen din for å se utmerkelser.';
$string['error:invalidcriteriatype'] = 'Ugyldig kriterietype';
$string['error:invalidexpiredate'] = 'Utløpsdato må være frem i tid.';
$string['error:invalidexpireperiod'] = 'Utløpsdato kan ikke være negativ eller -0-.';
$string['error:invalidparambadge'] = 'Utmerkelsen eksisterer ikke.';
$string['error:invalidparamcohort'] = 'Kohort eksisterer ikke.';
$string['error:noactivities'] = 'Det finnes ingen aktiviteter med aktivitetsfullføring i dette kurset.';
$string['error:nobadges'] = 'Det er for øyeblikket ingen utmerkelser med tilgang aktivert som kan legges til som kriterier. En portalutmerkelse kan bare ha andre portalutmerkelser som kriterier. En kursutmerkelse kan ha andre kursutmerkelser eller portalutmerkelser som kriterier.';
$string['error:nocohorts'] = 'Ingen kohorter';
$string['error:nocourses'] = 'Kursfullføring er ikke aktivert for noen av kursene på denne portalen, så det er ingenting å vise. Du kan aktivere kursfullføring i kursets innstillinger.';
$string['error:nogroupslink'] = '<p>Kun offentlige samlinger vises. <a href="{$a}" target="_blank" rel="nofollow">Gå til ryggsekken</a> for å opprette offentlige samlinger.</p>';
$string['error:nogroupssummary'] = '<p>Det er ingen tilgjengelige offentlige utmerkelsessamlinger i ryggsekken din. </p>';
$string['error:nopermissiontoview'] = 'Du har ikke tillatelser til å se mottakere av utmerkelsen';
$string['error:nosuchbadge'] = 'Utmerkelsen med ID {$a} eksisterer ikke.';
$string['error:nosuchcohort'] = 'Advarsel: Denne kohorten er ikke lengre tilgjengelig.';
$string['error:nosuchcourse'] = 'Advarsel: Dette kurset er ikke lenger tilgjengelig.';
$string['error:nosuchfield'] = 'Advarsel: Dette brukerprofilfeltet er ikke lenger tilgjengelig.';
$string['error:nosuchmod'] = 'Advarsel: Denne aktiviteten er ikke lenger tilgjengelig.';
$string['error:nosuchrole'] = 'Advarsel: Denne rollen er ikke lenger tilgjengelig.';
$string['error:nosuchuser'] = 'Bruker med denne e-postadressen har ikke noen konto hos gjeldende tilbyder av utmerkelsesportefølje.';
$string['error:notifycoursedate'] = 'Advarsel: Utmerkelser som krever fullført kurs og aktivitet, vil ikke bli utstedt før kurset starter.';
$string['error:parameter'] = 'Advarsel: Det må minst velges en parameter for å sikre at tildelingen av utmerkelsen går som tenkt.';
$string['error:relatedbadgedoesntexist'] = 'Det er ingen offentlige utmerkelser med denne identifikatoren';
$string['error:requesterror'] = 'Tilkoblingen mislyktes (feilkode {$a}).';
$string['error:requesttimeout'] = 'Tilkoblingen ble avbrutt fordi den brukte for lang tid';
$string['error:save'] = 'Kan ikke lagre utmerkelsen.';
$string['error:userdeleted'] = '{$a->user} (Denne brukeren eksisterer ikke lenger på {$a->site})';
$string['eventbadgearchived'] = 'Utmerkelse aktivert';
$string['eventbadgeawarded'] = 'Utmerkelse tildelt';
$string['eventbadgecreated'] = 'Utmerkelser opprettet';
$string['eventbadgecriteriacreated'] = 'Utmerkelseskriterie opprettet';
$string['eventbadgecriteriadeleted'] = 'Utmerkelseskriterie slettet';
$string['eventbadgecriteriaupdated'] = 'Utmerkelseskriterie oppdatert';
$string['eventbadgedeleted'] = 'Utmerkelse slettet';
$string['eventbadgedisabled'] = 'Utmerkelse deaktivert';
$string['eventbadgeduplicated'] = 'Utmerkelse duplisert';
$string['eventbadgeenabled'] = 'Utmerkelses aktivert';
$string['eventbadgelistingviewed'] = 'Utmerkelsesliste vist';
$string['eventbadgerevoked'] = 'Utmerkelse tilbakekalt';
$string['eventbadgeupdated'] = 'Utmerkelse oppdatert';
$string['eventbadgeviewed'] = 'Utmerkelse vist';
$string['evidence'] = 'Bevis';
$string['existingrecipients'] = 'Eksisterende mottakere av utmerkelsen';
$string['existsinbackpack'] = 'Utmerkelsen eksisterer allerede i ryggsekken';
$string['expired'] = 'Utløpt';
$string['expiredate'] = 'Utmerkelsen utløper {$a}.';
$string['expireddate'] = 'Utmerkelsen utløpte {$a}.';
$string['expiredin'] = 'Utløp {$a}';
$string['expireperiod'] = 'Utmerkelsen uløper {$a} dager etter å ha blitt tildelt.';
$string['expireperiodh'] = 'Utmerkelsen utløper {$a} timer etter å ha blitt tildelt.';
$string['expireperiodm'] = 'Utmerkelsen utløper {$a} minutter etter å ha blitt tildelt.';
$string['expireperiods'] = 'Utmerkelsen utløper {$a} sekunder etter å ha blitt tildelt.';
$string['expiresin'] = 'Utløper {$a}';
$string['expirydate'] = 'Utløpsdato';
$string['expirydate_help'] = 'Som opsjon kan utmerkelser ha en utløpsdato eller datoen kan beregnes automatisk ut fra når den ble tildelt brukeren.';
$string['externalbadges'] = 'Utmerkelser jeg har fra andre portaler';
$string['externalbadges_help'] = 'Dette området viser utmerkelser fra din eksterne samling av utmerkelser.';
$string['externalbadgesp'] = 'Utmerkelser fra andre portaler:';
$string['externalconnectto'] = 'Du må koble deg til <a href="{$a}">din eksterne samling av utmerkelser</a> for å kunne vise dem.';
$string['fixed'] = 'Fast dato';
$string['hidden'] = 'Skjult';
$string['hiddenbadge'] = 'Utgiveren av denne utmerkelsen har dessverre ikke lagt ved noen informasjon.';
$string['hostedurl'] = 'Ekstern URL';
$string['hostedurldescription'] = 'Ekstern URL der utmerkelsen kommer fra';
$string['imageauthoremail'] = 'Bildeforfatters epost';
$string['imageauthoremail_help'] = 'Hvis spesifisert vil bildeforfatterens epostadresse vises på utmerkelsessiden.';
$string['imageauthorname'] = 'Bildeforfatters navn';
$string['imageauthorname_help'] = 'Hvis spesifisert vil bildeforfatterens navn vises på utmerkelsessiden.';
$string['imageauthorurl'] = 'Bildeforfatterens hjemmeside';
$string['imageauthorurl_help'] = 'Hvis spesifisert vil en lenke til bildeforfatterens hjemmeside vises på utmerkelsesiden. URLen skal ha prefikset http:// eller https://.';
$string['imagecaption'] = 'Bildetekst';
$string['imagecaption_help'] = 'Hvis spesifisert vil bildeteksten vises på utmerkelsessiden.';
$string['includeauthdetails'] = 'Inkluder autentiseringsdetaljer med ryggsekken';
$string['invalidurl'] = 'Ugyldig URL';
$string['issuancedetails'] = 'Utløpsdato på utmerkelse';
$string['issuedbadge'] = 'Utstederinformasjon på utmerkelsen';
$string['issuedby'] = 'Tildelt av {$a}';
$string['issuedon'] = 'Tildelt {$a}';
$string['issuerdetails'] = 'Utstederdetaljer';
$string['issueremail'] = 'Epost';
$string['issueremail_help'] = 'En epostadresse til organisasjonen som har anbefalt utmerkelsen.';
$string['issuername'] = 'Navn på utsteder';
$string['issuername_endorsement'] = 'Anbefalers navn';
$string['issuername_endorsement_help'] = 'Navnet på anbefaleren';
$string['issuername_help'] = 'Navn på tildeler/utgiver av utmerkelsen.';
$string['issuerurl'] = 'Utsteders URL';
$string['issuerurl_help'] = 'Hjemmesiden til organisasjonen som har anbefalt utmerkelsen. URLen skal ha et av prefiksene http:// eller https://.';
$string['language'] = 'Språk';
$string['language_help'] = 'Språket på utmerkelsessiden.';
$string['listbackpacks'] = 'Liste med ryggsekker';
$string['localbadges'] = 'Mine utmerkelser fra {$a} nettside';
$string['localbadgesh'] = 'Mine utmerkelser fra denne nettsiden';
$string['localbadgesh_help'] = 'Alle utmerkelser du har fått for å fullføre kurs, kursaktiviteter eller andre krav på denne nettsiden.

Du kan administrere utmerkelsene dine her ved å gjøre dem offentlige eller private på din profilside.

Du kan laste ned alle utmerkelsene dine eller hver utmerkelse separat og lagre dem på datamaskinen din. Nedlastede utmerkelser kan legges til den eksterne porteføljetjenesten.';
$string['localbadgesp'] = 'Utmerkelser fra {$a}:';
$string['localconnectto'] = 'Du må koble deg til <a href="{$a}">din eksterne samling av utmerkelser</a> for å kunne vise dem utenfor denne portalen.';
$string['makeprivate'] = 'Gjør privat';
$string['makepublic'] = 'Gjør offentlig';
$string['managebackpacks'] = 'Administrer ryggsekker';
$string['managebadges'] = 'Administrer utmerkelser';
$string['message'] = 'Meldingsteksten';
$string['messagebody'] = '<p>Du er blitt tildelt utmerkelsen "%badgename%"!</p>
<p>Du finner mer informasjon om denne utmerkelsen på  %badgelink%.</p>
<p>Du kan administrere og laste ned utmerkelsen fra {$a}.</p>';
$string['messagesubject'] = 'Gratulerer! Du har fått en utmerkelse!';
$string['method'] = 'Dette kriteriet er fullført når...';
$string['mingrade'] = 'Minimumskarakter påkrevd';
$string['month'] = 'Måned(er)';
$string['moredetails'] = 'Mer informasjon';
$string['mybackpack'] = 'Innstillinger for min personlige samling av utmerkelser';
$string['mybadges'] = 'Mine utmerkelser';
$string['never'] = 'Aldri';
$string['newbackpack'] = 'Legg til ny ryggsekk';
$string['newbadge'] = 'Legg til en ny utmerkelse';
$string['newimage'] = 'Nytt bilde';
$string['noalignment'] = 'Utmerkelsen har ingen spesifiserte kompetanser.';
$string['noawards'] = 'Du har ikke fått denne utmerkelsen enda.';
$string['nobackpack'] = 'Det er ikke tilkoblet noen personlig samling av utmerkelser til denne kontoen. <br/>';
$string['nobackpackbadgessummary'] = 'Det er ingen utmerkelser i samlingene du har valgt.';
$string['nobackpackcollectionssummary'] = 'Ingen utmerkelsessamlinger valgt';
$string['nobackpacks'] = 'Ingen ryggsekker tilgjengelig';
$string['nobadges'] = 'Det er for øyeblikket ingen utmerkelser tilgjengelig for brukere å opptjene.';
$string['nocompetencies'] = 'Ingen kompetanser valgt.';
$string['nocriteria'] = 'Det er ikke satt opp noe kriterier for denne utmerkelsen enda.';
$string['noendorsement'] = 'Utmerkelsen har ingen anbefalinger';
$string['noexpiry'] = 'Denne utmerkelsen har ingen utløpsdato.';
$string['noparamstoadd'] = 'Det er ingen ekstra parametre tilgjengelig for dette utmerkelseskravet.';
$string['norelated'] = 'Utmerkelsen har ingen relaterte utmerkelser';
$string['notacceptedrole'] = 'Du er ikke tildelt en rolle med rett til å manuelt tildele denne utmerkelsen.<br />
Hvis du ønsker å se alle brukere som allerede er tildelt denne utmerkelsen, kan du gå til siden {$a}.';
$string['notconnected'] = 'Ikke tilkoblet';
$string['notealignment'] = 'Eksterne ferdigheter eller standarder som utmerkelsen dekker kan spesifiseres. Alle eksterne ferdigheter eller standarder vises på utmerkelsessiden.';
$string['noteendorsement'] = 'En anbefaling fra en tredjepart kan brukes for å øke utmerkelsens verdi og anseelse.';
$string['noterelated'] = 'Utmerkelser kan markeres som relaterte. For eksempel kan utmerkelses med de samme kriteriene, men med ulike språk markeres som relaterte. Alle relaterte utmerkelser vises på utmerkelsessiden.';
$string['nothingtoadd'] = 'Det er ingen ledige kriterier å legge til.';
$string['notification'] = 'Varsle den som har opprettet  utmerkelsen';
$string['notification_help'] = 'Denne innstillingen administrerer meldinger som sendes utstederen av utmerkelsen, slik at de får vite når utmerkelsen blir tildelt.

Følgende opsjoner er tilgjengelige:

* **ALDRI** – Ikke send meldinger.

* **HVER GANG** – Send en melding hver gang utmerkelsen blir tildelt noen.

* **DAGLIG** – Send en samlemelding hver dag.

* **UKENTLIG** – Send en samlemelding en gang i uka.

* **MÅNEDLIG** – Send en samlemelding en gang i måneden.';
$string['notifydaily'] = 'Daglig';
$string['notifyevery'] = 'Hver gang';
$string['notifymonthly'] = 'Månedlig';
$string['notifyweekly'] = 'Ukentlig';
$string['numawards'] = 'Denne utmerkelsen er tildelt <a href="{$a->link}">{$a->count}</a> brukere.';
$string['numawardstat'] = 'Denne utmerkelsen er tildelt {$a} brukere.';
$string['oauth2issuer'] = 'OAuth 2 tjenester';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Annen navigasjon…';
$string['overallcrit'] = 'av valgte kriterier er fullført.';
$string['potentialrecipients'] = 'Potensielle mottakere av utmerkelsen';
$string['preferences'] = 'Preferanser for utmerkelser';
$string['privacy:metadata:backpack'] = 'En oppføring med brukerens ryggsekker';
$string['privacy:metadata:backpack:backpackuid'] = 'Ryggsekkens unike identifikator';
$string['privacy:metadata:backpack:email'] = 'Epostadressen assosiert emd ryggsekken.';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Ryggsekkens ID';
$string['privacy:metadata:backpack:userid'] = 'Id\'en til brukeren som eier ryggsekken.';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 informasjon for brukers tilkobling til ekstern ryggsekk';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 tjenesteID';
$string['privacy:metadata:backpackoauth2:scope'] = 'List omfanget av ryggsekkekobling';
$string['privacy:metadata:backpackoauth2:token'] = 'Ryggsekktilkobling token';
$string['privacy:metadata:backpackoauth2:userid'] = 'IDen til brukeren som kobles til ryggsekk';
$string['privacy:metadata:backpackoauth2:usermodified'] = '35/5000
IDen til brukeren som endret tilkobling';
$string['privacy:metadata:badge'] = 'Utmerkelsessamling';
$string['privacy:metadata:badge:timecreated'] = 'Når utmerkelsen ble opprettet';
$string['privacy:metadata:badge:timemodified'] = 'Når utmerkelsen sist ble endret';
$string['privacy:metadata:badge:usercreated'] = 'ID\'en til brukeren som opprettet utmerkelsen';
$string['privacy:metadata:badge:usermodified'] = 'ID\'en til brukeren som endret utmerkelsen';
$string['privacy:metadata:criteriamet'] = 'En samling med oppnådde kriterier';
$string['privacy:metadata:criteriamet:datemet'] = 'Når et kriterie ble oppnådd';
$string['privacy:metadata:criteriamet:userid'] = 'ID\'en til brukeren som oppnådde kriteriet.';
$string['privacy:metadata:external:backpacks'] = 'Informasjon som deles når brukeren legger en utmerkelse i deres eksterne rygsekk';
$string['privacy:metadata:external:backpacks:badge'] = 'Navnet på utmerkelsen';
$string['privacy:metadata:external:backpacks:description'] = 'Beskrivelse av utmerkelsen';
$string['privacy:metadata:external:backpacks:image'] = 'Bilde på utmerkelsen';
$string['privacy:metadata:external:backpacks:issuer'] = 'Noe informasjon om utgiveren';
$string['privacy:metadata:external:backpacks:url'] = 'Moodles URL der informasjonen om den tildelte utmerkelsen kan ses';
$string['privacy:metadata:issued'] = 'Logger for tildelte utmerkelser';
$string['privacy:metadata:issued:dateexpire'] = 'Datoen utmerkelsen utløper';
$string['privacy:metadata:issued:dateissued'] = 'Dato for tildelingen';
$string['privacy:metadata:issued:userid'] = 'ID\'en til brukeren som ble tildelt en utmerkelse';
$string['privacy:metadata:manualaward'] = 'Logger for manuelle tildelinger';
$string['privacy:metadata:manualaward:datemet'] = 'Datoen for når brukeren ble tildelt utmerkelsen';
$string['privacy:metadata:manualaward:issuerid'] = 'ID\'en til brukeren som tildelte utmerkelsen';
$string['privacy:metadata:manualaward:issuerrole'] = 'Rollen tilbrukeren som tildelte en utmerkelse';
$string['privacy:metadata:manualaward:recipientid'] = 'ID\'en til brukeren som er manuelt tildelt en utmerkelse';
$string['recipientdetails'] = 'Mottakerdetaljer';
$string['recipientidentificationproblem'] = 'Kan ikke finne en mottager av denne utmerkelsen blant eksisterende brukere.';
$string['recipients'] = 'Mottakere av utmerkelsen';
$string['recipientvalidationproblem'] = 'Nåværende bruker kan ikke bli verifisert som mottaker av denne utmerkelsen';
$string['relatedbages'] = 'Relaterte anbefalinger';
$string['relative'] = 'Relativ dato';
$string['requiredbadge'] = 'Minst en utmerkelse må legges til i utmerkelseskriteriene.';
$string['requiredcohort'] = 'Minst en kohort må legges til i kohortkriteriet.';
$string['requiredcompetency'] = 'Minst en kompetanse må legges til kompetansekriteriet.';
$string['requiredcourse'] = 'Minst ett kurs må legges til som kurssett-kriterium.';
$string['reviewbadge'] = 'Se gjennom kriteriene for utmerkelsen';
$string['reviewconfirm'] = '<p>Denne handlingen vil gjøre utmerkelsen din synlig og tillate andre å få den tildelt.</p>
<p>Det er mulig at noen brukere allerede oppfyller kravene til utmerkelsen og disse blir tildelt utmerkelsen med en gang du gjør den aktiv.</p>
<p>Straks en utmerkelse er tildelt vil dette <strong>låse</strong> bestemte innstillinger, inkludert tildelingskriteriene og utløpsinnstillingene kan ikke lenger endres.</p>
<p>Er du sikker på at du vil aktivere tilgang til utmerkelsen \'{$a}\'?</p>';
$string['revoke'] = 'Tilbakekall utmerkelse';
$string['save'] = 'Lagre';
$string['searchname'] = 'Søk på navn';
$string['selectaward'] = 'Vennligst velg den rollen du ønsker skal kunne tildele denne utmerkelsen:';
$string['selectgroup_end'] = 'Bare offentlige samlinger vises, <a href="{$a}">gå til din privalte samling</a>for å opprette flere offentlige samlinger av utmerkelser.';
$string['selectgroup_start'] = 'Velg samlinger fra din private samling av utmerkelser, slik at disse kan vises på denne portalen:';
$string['selecting'] = 'Med valgte utmerkelser ...';
$string['setup'] = 'Sett opp tilkobling';
$string['sitebackpack'] = 'Aktiv ekstern ryggsekk';
$string['sitebackpack_help'] = 'Den eksterne ryggsekken som brukere kan koble til fra denne portalen. Merk at endring av denne innstillingen etter at brukere har koblet til ryggsekken sin må de gå til ryggsekkinnstillingene sine og koble fra og til igjen.';
$string['sitebackpackdeleted'] = 'Portalryggsekken er slettet';
$string['sitebackpacknotdeleted'] = 'Ryggsekken kunne ikke slettes siden det er standardryggsekken for denne portalen.';
$string['sitebackpackverify'] = 'Ryggsekktilkobling';
$string['sitebackpackwarning'] = 'Kunne ikke koble til ryggsekken. <br/><br/>Sjekk at innstillingen "Badge issuer email address" er den gyldige epostaddressen for kontoen på ryggsekkportalen. <br/><br/>Sjekk at "Badge issuer password" på  <a href="{$a->url}">site backpack settings page</a> er det korrekte passordet for kontoen på ryggsekkportalen. <br/><br/>Ryggsekken returnerte: "{$a->warning}"';
$string['sitebadges'] = 'Portalutmerkelser';
$string['sitebadges_help'] = 'Portalutmerkelser kan bare tildeles til brukere for portalbaserte aktiviteter. Dette inkluderer å fullføre et utvalg av kurs eller deler av brukerprofilen. Portalutmerkelser kan også tildeles manuelt.

Utmerkelser for kursrelaterte aktiviteter må opprettes på kursnivået. Kursutmerkelser finner du under Kursadministrasjon > Utmerkelser.';
$string['sitebadgetitle'] = '{$a} portalutmerkelse';
$string['status'] = 'Status for utmerkelse';
$string['status_help'] = 'Statusen for en utmerkelse bestemmer hvordan den oppfører seg på portalen:

* **TILGJENGELIG** – Betyr at denne utmerkelsen kan tildeles brukere. Når en utmerkelse er gjort tilgjengelig for brukerne, kan en ikke lenger endre tildelingskriteriene.

* **IKKE TILGJENGELIG** – Betyr at denne utmerkelsen ikke kan tildeles noen brukere – heller ikke manuelt. Dersom en ikke har tildelt denne utmerkelsen til noen, kan kriteriene for tildeling fortsatt endres.

Straks en utmerkelse er tildelt til minst EN bruker vil den låses. En låst utmerkelse kan fortsatt tildeles brukere, men kriteriene kan ikke lenger endres. Dersom du har behov for å endre på tildelingskriteriene, kan du i stedet duplisere utmerkelsen og gjøre de nødvendige endringene på denne i stedet.

*Hvorfor låser vi utmerkelsene?*

Vi ønsker å forsikre oss om at alle brukere oppfyller de samme kravene for å få tildelt utmerkelsen. Foreløpig er det ikke mulig å tilbakekalle utmerkelser. Hvis vi tillot at kravene kunne  endres hele tiden, ville vi mest sannsynlig ende opp med brukere som har samme utmerkelse selv om kravene har vært helt forskjellige.';
$string['statusmessage_0'] = 'Denne utmerkelsen er ikke tilgjengelig for brukere. Aktiver tilgang hvis du vil at brukerne skal få denne utmerkelsen.';
$string['statusmessage_1'] = 'Denne utmerkelsen er tilgjengelig for brukere. Deaktiver tilgang for å gjøre endringer.';
$string['statusmessage_2'] = 'Denne utmerkelsen er for tiden ikke tilgjengelig for brukere, og tildelingskriteriene er låst. Aktiver tilgang dersom du ønsker at brukere skal kunne bli tildelt denne utmerkelsen.';
$string['statusmessage_3'] = 'Denne utmerkelsen er for tiden tilgjengelig for brukerne, og tildelingskriteriene er låst.';
$string['statusmessage_4'] = 'Denne utmerkelsen er nå arkivert.';
$string['subject'] = 'Meldingsemne';
$string['targetcode'] = 'Kode';
$string['targetcode_help'] = 'En unik identifikatorstreng for referanse til æringsmålet i et rammeverk.';
$string['targetdescription'] = 'Beskrivelse';
$string['targetdescription_help'] = 'Kort beskrivelse av justeringsmålet';
$string['targetframework'] = 'Rammeverk';
$string['targetframework_help'] = 'Navnet på kompetansrammeverket.';
$string['targetname'] = 'Navn';
$string['targetname_help'] = 'Ferdigheten eller standarden utmerkelsen dekker.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'En lenke til en side som beskriver eksterne ferdigheten eller standarder. URLen skal ha prefikset http:// eller https://.';
$string['testbackpack'] = 'Test ryggsekken \'{$a}\'';
$string['testsettings'] = 'Test innstillinger';
$string['type'] = 'Type';
$string['variablesubstitution'] = 'Variabel substitusjon i meldinger';
$string['variablesubstitution_help'] = 'I en melding om utmerkelse kan det settes inn variabler i Emnefeltet eller i meldingens brødtekst. Variablene erstattes da med virkelige verdier når meldingen sendes. Variablene må benyttes akkurat som de vises under.
Følgende variabler kan benyttes:

%badgename%
:  Dette blir byttet ut med utmerkelsens fulle navn.

%username%
:   Dette blir byttet ut med mottakerens fulle navn.

%badgelink%
:   Dette blir byttet ut med en offentlig URL med informasjon om den tildelte utmerkelsen.';
$string['version'] = 'Versjon';
$string['version_help'] = 'Versjonsfeltet kan brukes til å holde orden på utviklingshistorikken til utmerkelsen. Hvis spesifisert vil versjonen vises på utmerkelsessiden.';
$string['viewbadge'] = 'Se gjennom utstedte utmerkelser';
$string['visible'] = 'Synlig';
$string['warnexpired'] = '(Denne utmerkelsen har gått ut på dato!)';
$string['year'] = 'År';
