<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'via', language 'el', version '4.0'.
 *
 * @package     via
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Qualitedebase'] = 'Χαμηλή ποιότητα';
$string['Qualitestandard'] = 'Τυπική ποιότητα';
$string['Qualitesuperieure'] = 'Υψηλή ποιότητα';
$string['STATUS_INVALID'] = 'Η σύνδεση ήταν αδύνατη, η κατάσταση δεν είναι έγκυρη.';
$string['absent'] = 'Απών';
$string['accessactivity'] = 'Πρόσβαση στην δραστηριότητά σας:';
$string['activity_deleted'] = 'Η δραστηριότητα Via διαγράφηκε απευθείας στο περιβάλλον Via από έναν χρήστη. Έτσι, η πρόσβαση είναι αδύνατη. Συνιστάται να διαγράψετε αυτή τη δραστηριότητα από το Moodle και δημιουργήσετε μία νέα.';
$string['activitydeletion'] = 'Περιορισμός διαγραφής δραστηριότητας';
$string['activitydeletiondesc'] = 'Εάν επιλεγεί, οι δραστηριότητες θα διαγραφούν από το Moodle, αλλά όχι από το Via.';
$string['activitydone'] = 'Η δραστηριότητα αυτή έχει τελειώσει.';
$string['activitytemplatebutton'] = 'Συγχρονισμός τιμών υποδείγματος δραστηριότητας';
$string['activitytemplatedesc'] = 'Οι προεπιλεγμένες τιμές (κατάσταση λειτουργίας εγγραφής ήχου/βίντεο, αίθουσα αναμονής, προφίλ πολυμέσων, κλπ.) που εφαρμόζονται για τη δημιουργία μιας νέας εικονικής τάξης είναι οι τιμές που έχουν οριστεί από προεπιλογή στην πύλη του Via. Πρέπει να συνδεθείτε στην πύλη και να αποκτήσετε πρόσβαση στην ενότητα Υπόδειγμα δραστηριότητας στην αριστερή πλευρά για να επικυρώσετε τις προεπιλεγμένες τιμές.';
$string['activitytemplateheader'] = 'Υπόδειγμα δραστηριότητας';
$string['activitytitle'] = 'Τίτλος δραστηριότητας';
$string['activitywaserased'] = 'Αδυναμία εύρεσης αυτής της δραστηριότητας στον εξυπηρετητή SVI. Φαίνεται πως έχει διαγραφεί.';
$string['add'] = 'Προσθήκη';
$string['adminid_nosuccess'] = 'Το κλειδί Mooodle που παρέχεται δεν είναι έγκυρο.';
$string['adminid_success'] = 'Το κλειδί του Moodle είναι έγκυρο';
$string['adminid_toolow'] = 'Τα δικαιώματα του χρήστη δεν επιτρέπουν τη δημιουργία δραστηριοτήτων. Παρακαλούμε, επικοινωνήστε με το διαχειριστή για να αυξήσει τα δικαιώματα.';
$string['adminnotrenrolled'] = 'Ως διαχειριστής μπορείτε να έχετε πρόσβαση στη δραστηριότητα παρά το γεγονός ότι δεν είστε εγγεγραμμένοι.';
$string['and'] = 'και';
$string['animator'] = 'Animator (Εμψυχωτής)';
$string['animators'] = 'Animators (Εμψυχωτές)';
$string['apiconfig'] = 'Ρυθμίσεις API - βήμα 1';
$string['apiid'] = 'Αναγνωριστικό API του Via (ApiID)';
$string['apiidsetting'] = 'Μοναδικό αναγνωριστικό του API για το Via';
$string['apiurl'] = 'Διεύθυνση URL του API';
$string['apiurlsetting'] = 'Βασική διεύθυνση URL του API';
$string['attending'] = 'Θα συμμετέχω';
$string['audiomodelabel'] = 'Τύπος ήχου για τη διάσκεψη';
$string['audiorecord'] = 'Ήχος (MP3)';
$string['audiorecordinfo'] = 'Μόνο ήχος';
$string['automatic'] = 'Αυτόματα';
$string['automaticenrol'] = 'Αυτόματη εγγραφή';
$string['availabledate'] = 'Διαθέσιμο από';
$string['awaitingauthorization'] = 'Σε αναμονή εξουσιοδότησης (χειροκίνητα)';
$string['backup'] = 'Συμπερίληψη πληροφοριών έρευνας στα αντίγραφα ασφαλείας μαθήματος';
$string['backup_options'] = 'Επιλογές δημιουργίας αντιγράφων ασφαλείας και διπλοτύπων δραστηριότητας';
$string['backupdesc'] = 'Εάν επιλεγεί, τότε οι πληροφορίες έρευνας από μια δραστηριότητα θα συμπεριλαμβάνονται στη νέα δραστηριότητα που παράγεται κατά τη διαδικασία δημιουργίας και αποκατάστασης αντιγράφου ασφαλείας ενός μαθήματος. Τα έγγραφα περιλαμβάνονται πάντα στη διαδικασία αυτή. Η συμπερίληψη πληροφοριών χρήστη είναι προαιρετική.';
$string['basedon'] = 'Η κατάσταση παρουσίας βασίζεται σε {$a} λεπτά.';
$string['by'] = 'από';
$string['cancel'] = 'Άκυρο';
$string['cat_check'] = 'Προσθήκη';
$string['cat_default'] = 'Ορισμός ως προεπιλογής';
$string['cat_intro'] = 'Επιλογή των κατηγοριών Via που επιθυμείτε να κάνετε διαθέσιμες στο Moodle.';
$string['cat_name'] = 'Ονόματα κατηγοριών';
$string['categoriesheader'] = 'Κατηγορίες';
$string['category'] = 'Επιλογή μιας κατηγορίας';
$string['cats_modified'] = 'Οι κατηγορίες τροποποιήθηκαν με επιτυχία!';
$string['choosecategories'] = 'Ρύθμιση των κατηγοριών';
$string['choosehost'] = 'Για επιλογή νέου κεντρικού Η/Υ, απλά προσθέστε έναν νέο χρήστη για να αντικαταστήσετε τον υπάρχοντα κεντρικό Η/Υ. Μπορεί να υπάρχει μόνο ένας κεντρικός ΗΥ.';
$string['cieid'] = 'Αναγνωριστικό Via (CieID)';
$string['cieidsetting'] = 'Αναγνωριστικό εταιρείας για το VIA';
$string['config'] = 'Ρυθμίσεις';
$string['configassist'] = 'Οδηγός εγκατάστασης';
$string['confirmation'] = 'Επιβεβαιώσεις συμμετεχόντων';
$string['confirmationstatus'] = 'Κατάσταση επιβεβαίωσης';
$string['confirmdelete'] = 'Σίγουρα θέλετε να διαγραφεί αυτή η εγγραφή ήχου/βίντεο μόνιμα;';
$string['confirmed'] = 'Η παρουσία επιβεβαιώθηκε';
$string['confirmneeded'] = 'Απαιτείται επιβεβαίωση παρουσίας';
$string['connectsuccess'] = 'Επιτυχία σύνδεσης με το API';
$string['conntest'] = 'Δοκιμή σύνδεσης';
$string['createdby'] = 'Αναφορά που δημιουργήθηκε από:';
$string['creationdate'] = 'Αναφορά που δημιουργήθηκε στις:';
$string['date'] = 'Ημερομηνία δραστηριότητας';
$string['delete'] = 'Διαγραφή';
$string['delete_activity'] = 'Διαγραφή αυτής της δραστηριότητας';
$string['deleteconfirm'] = 'Σίγουρα να διαγραφεί αυτή η δραστηριότητα;';
$string['desactivatedMessage'] = 'Αυτή η δραστηριότητα και οι συσχετισμένες εγγραφές ή έγγραφα της, έχουν διαγραφεί και δεν είναι πια προσβάσιμα. Παρακαλούμε διαγράψτε αυτή τη δραστηριότητα από το μάθημα.';
$string['description'] = 'Περιγραφή';
$string['df_button_manage'] = 'Διαχείριση του περιεχομένου';
$string['df_header_download'] = 'Λήψη';
$string['df_header_nbpages'] = 'Σελίδες';
$string['df_header_size'] = 'Μέγεθος';
$string['df_header_title'] = 'Τίτλος';
$string['df_header_type'] = 'Τύπος';
$string['df_nofiles'] = 'Δεν υπάρχει περιεχόμενο προς λήψη';
$string['df_type_0'] = 'Μη κατηγοριοποιημένο';
$string['df_type_1'] = 'Εικόνα JPG';
$string['df_type_10'] = 'Βίντεο AVI';
$string['df_type_11'] = 'Βίντεο MPG';
$string['df_type_12'] = 'Βίντεο WMV';
$string['df_type_13'] = 'Βίντεο MOV';
$string['df_type_14'] = 'Αρχείο ήχου MP3';
$string['df_type_15'] = 'Αρχείο ήχου WAV';
$string['df_type_16'] = 'Αρχείο ήχου WMA';
$string['df_type_17'] = 'Αρχείο ήχου OGG';
$string['df_type_18'] = 'Παρουσίαση Powerpoint';
$string['df_type_19'] = 'Διεύθυνση URL';
$string['df_type_2'] = 'Εικόνα BMP';
$string['df_type_20'] = 'Αρχείο MP4';
$string['df_type_21'] = 'Έγγραφο Word';
$string['df_type_22'] = 'Έγγραφο Excel';
$string['df_type_23'] = 'Αρχείο OD';
$string['df_type_24'] = 'Αρχείο SXW';
$string['df_type_25'] = 'Έγγραφο RTF';
$string['df_type_26'] = 'Αρχείο WPD';
$string['df_type_27'] = 'Αρχείο κειμένου';
$string['df_type_28'] = 'Αρχείο ODS';
$string['df_type_29'] = 'Αρχείο SXC';
$string['df_type_3'] = 'Εικόνα PNG';
$string['df_type_30'] = 'Αρχείο CSV';
$string['df_type_31'] = 'Αρχείο TSV';
$string['df_type_32'] = 'Αρχείο ODP';
$string['df_type_33'] = 'Αρχείο SXI';
$string['df_type_34'] = 'Αρχείο ODG';
$string['df_type_35'] = 'Σύνδεσμος HTML';
$string['df_type_36'] = 'Παρουσίαση Powerpoint';
$string['df_type_37'] = 'Έγγραφο Word';
$string['df_type_38'] = 'Παρουσίαση Powerpoint';
$string['df_type_39'] = 'Έγγραφο Excel';
$string['df_type_4'] = 'Εικόνα GIF';
$string['df_type_40'] = 'Παρουσίαση Powerpoint';
$string['df_type_41'] = 'Σύνδεσμος HTML';
$string['df_type_42'] = 'Παρουσίαση Powerpoint';
$string['df_type_43'] = 'Ασπροπίνακας';
$string['df_type_44'] = 'Έρευνα';
$string['df_type_45'] = 'Βίντεο M4V';
$string['df_type_46'] = 'Αρχείο ήχου M4A';
$string['df_type_47'] = 'Βίντεο MKV';
$string['df_type_48'] = 'Ακολουθία GIF';
$string['df_type_5'] = 'Εικόνα PICT';
$string['df_type_6'] = 'Έγγραφο PDF';
$string['df_type_7'] = 'Εικόνα TIFF';
$string['df_type_8'] = 'Αρχείο SWF';
$string['df_type_9'] = 'Βίντεο Flash';
$string['displayuserlist'] = 'Εμφάνιση λίστας συνδέονται χρήστες για όλους';
$string['displayuserlistdesc'] = 'Εάν επιλεγεί, όλοι οι χρήστες θα μπορούν να δουν τους άλλους συσχετιζόμενους με τη δραστηριότητα χρήστες και την κατάστασή τους επιβεβαίωσης, εάν ενεργοποιηθεί.';
$string['donousewaitingroom'] = 'Μην χρησιμοποιείτε (απενεργοποιημένο)';
$string['downloadablefiles'] = 'Περιεχόμενο με δυνατότητα λήψης';
$string['downloadplaybacks'] = 'Κατεβάστε ηχογραφήσεις';
$string['downloadplaybacksdesc'] = 'Εάν επιλεγεί, οι χρήστες με ρόλους επεξεργασίας θα επιτρέπεται να κατεβάζουν εγγραφές ήχου/βίντεο Via. Πριν την ενεργοποίηση αυτής της επιλογής, παρακαλούμε επικοινωνήστε με την SVIesolutions για να επικυρώσετε ότι ο εξυπηρετητής σας το επιτρέπει.';
$string['duplication'] = 'Συμπερίληψη πληροφοριών έρευνας στα διπλότυπα/αντίγραφα μαθήματος';
$string['duplicationdesc'] = 'Αν επιλεγεί, πληροφορίες έρευνας από μια δραστηριότητα θα συμπεριληφθούν στην νέα δραστηριότητα που παράγεται κατά τη δημιουργία διπλοτύπου. Πληροφορίες και έγγραφα χρήστη περιλαμβάνονται πάντοτε σε αυτήν την διαδικασία.';
$string['duration'] = 'Διάρκεια (λεπτά)';
$string['durationheader'] = 'Διάρκεια';
$string['edit'] = 'Τροποποίηση';
$string['editrecord'] = 'Επεξεργασία εγγραφής';
$string['email_personnalised_options'] = 'Προσωποποίηση των μηνυμάτων ηλε.ταχυδρομείου σας υπενθύμισης και πρόσκλησης του Via.';
$string['emailaccesslinkcolor'] = 'Χρώμα συνδέσμου πρόσβασης ηλε.ταχυδρομείου';
$string['emailaccesslinkcolor_desc'] = 'Αυτό θα εφαρμοστεί στον σύνδεσμο πρόσβασης της υπενθύμισης Via και στα μηνύματα πρόσκλησης μέσω ηλε.ταχυδρομείου. Σας προτείνουμε να χρησιμοποιήσετε διαφορετικό χρώμα από τους άλλους συνδέσμους, καθώς αυτός είναι πιο σημαντικός.';
$string['emailheaderbgcolor'] = 'Χρώμα υπόβαθρου τίτλου ηλε.ταχυδρομείου';
$string['emailheaderbgcolor_desc'] = 'Αυτό θα εφαρμοστεί στο υπόβαθρο του τίτλου και πίσω από την εικόνα στις υπενθυμίσεις Via και στα μηνύματα πρόσκλησης μέσω ηλε.ταχυδρομείου.';
$string['emailheadercolor'] = 'Χρώμα τίτλου ηλε.ταχυδρομείου';
$string['emailheadercolor_desc'] = 'Αυτό θα εφαρμοστεί στο υπόβαθρο του τίτλου και πίσω από την εικόνα στις υπενθυμίσεις Via και στα μηνύματα πρόσκλησης μέσω ηλε.ταχυδρομείου.';
$string['emailheaderimage'] = 'Εικόνα κεφαλίδας μηνυμάτων ηλε.ταχυδρομείου';
$string['emailheaderimage_desc'] = 'Έχει προστεθεί μια προεπιλεγμένη εικόνα, την οποία μπορείτε να παρακάμψετε ανά πάσα στιγμή. Οι προεπιλεγμένες διαστάσεις της εικόνας είναι 750 x 98 εικονοστοιχεία και η δεξιά πλευρά της εικόνας έχει το ίδιο χρώμα με το «emailheaderbgcolor» παρακάτω. ΣΗΜΑΝΤΙΚΟ: Τα μηνύματα ηλε.ταχυδρομείου δεν υποστηρίζουν διαφάνεια.';
$string['emaillinkcolor'] = 'Χρώμα συνδέσμου';
$string['emaillinkcolor_desc'] = 'Αυτό θα εφαρμοστεί στους συνδέσμους στα μηνύματα ηλε.ταχυδρομείου υπενθύμισης και πρόσκλησης του Via. Σας προτείνουμε να προσθέσετε τα ίδια χρώματα με το αισθητικό θέμα σας.';
$string['emails_alert_address'] = 'Διευθύνσεις ηλε.ταχυδρομείου για αποστολή επαγρυπνήσεων';
$string['emails_alert_addressdesc'] = 'Διευθύνσεις ηλε.ταχυδρομείου για επαγρυπνήσεις υπερχείλισης. Για περισσότερες από μία, χρησιμοποιήστε ως διαχωριστή το κόμμα.';
$string['emailtextcolor'] = 'Χρώμα κειμένου για τα μηνύματα ηλε.ταχυδρομείου';
$string['emailtextcolor_desc'] = 'Αυτό θα εφαρμοστεί στην υπενθύμιση και τα μηνύματα ηλε.ταχυδρομείου πρόσκλησης του Via εκτός από τους συνδέσμους και τον τίτλο.';
$string['enddate'] = 'Λήγει στις';
$string['enrolmentheader'] = 'Εγγραφές συμμετεχόντων';
$string['enrolmenttype'] = 'Τύπος εγγραφής';
$string['error:ACTIVITYID_EMPTY'] = 'ACTIVITYID_EMPTY - Η τιμή της ActivityID είναι κενή.';
$string['error:ACTIVITYID_INVALID'] = 'ACTIVITYID_INVALID - Η τιμή που διαβιβάστηκε στο ActivityID είναι μη έγκυρη.';
$string['error:ACTIVITY_EXCEED_MAX_USERS'] = 'Επιτεύχθηκε ο μέγιστος αριθμός χρηστών';
$string['error:deletefailed'] = 'Η κατάργηση όλων των δραστηριοτήτων απέτυχε.';
$string['error_user'] = 'Αδυναμία προσθήκης του χρήστη {$a} στη δραστηριότητα.';
$string['export'] = 'Προβολή/Εξαγωγή';
$string['finish'] = 'Ολοκληρώθηκε';
$string['fullvideo'] = 'Πλήρες βίντεο (MP4)';
$string['fullvideoinfo'] = 'Όπως εμφανίζεται στην εγγραφή βίντεο. Ανάλυση: 1024 x 768';
$string['gotoactivity'] = 'Πρόσβαση';
$string['gotorecording'] = 'Πρόσβαση στην εγγραφή ήχου/βίντεο';
$string['groupusers'] = 'Οι χρήστες της συσχετισμένης ομαδοποίησης: {$a} δεν μπορούν να καταργηθούν από τη δραστηριότητα, αλλά άλλοι μπορεί να προστεθούν.';
$string['hasconfirmed'] = 'Έχετε επιβεβαιώσει ότι θα συμμετέχετε σε αυτήν τη δραστηριότητα.';
$string['hasconfirmednot'] = 'Έχετε επιβεβαιώσει ότι δεν θα συμμετέχετε σε αυτήν τη δραστηριότητα.';
$string['headerduration'] = 'Διάρκεια';
$string['hidelist'] = 'Απόκρυψη';
$string['highquality'] = 'Υψηλή ποιότητα';
$string['host'] = 'Κεντρικός Η/Υ';
$string['host_replace'] = 'Αντικατάσταση κεντρικού Η/Υ';
$string['incomplete'] = 'Μη ολοκληρωμένο';
$string['inhostabsence'] = 'Σε περίπτωση απουσίας κεντρικού Η/Υ (αυτόματο)';
$string['inviteclicktoaccesshtml'] = 'Για να μεταβείτε στη δραστηριότητα, κάντε κλικ αυτό το σύνδεσμο παρακάτω:';
$string['inviteemailhtml'] = '<p>Γεια σας {$a->username},</p>
<p>Το Moodle σας προσκαλεί να συμμετέχετε στη δραστηριότητα «{$a->title}» που θα πραγματοποιηθεί στις <b>{$a->datebegin}</b> μεταξύ <b>{$a->hourbegin}</b> και <b>{$a->hourend}</b>.</p><p>{$a->invitemsg}</p>';
$string['inviteemailhtmlpermanent'] = '<p>Γεια σας {$a->username},</p>
<p>{$a->invitemsg}</p>';
$string['inviteemailsubject'] = 'ΠΡΌΣΚΛΗΣΗ: {$a->τίτλος}';
$string['invitepreparationhtml'] = 'Προετοιμασία δραστηριότητας';
$string['invitessend'] = 'Οι προσκλήσεις θα σταλούν σε λιγότερο από 15 λεπτά.';
$string['invitessent'] = 'Προσκλήσεις στάλθηκαν.';
$string['invitewebaccesshtml'] = 'Πρόσβαση στον ιστό';
$string['ish264'] = 'Ενεργοποίηση λειτουργίας βίντεο για κινητές συσκευές';
$string['list_activities'] = 'Λίστα με όλες τις δραστηριότητες Via σε αυτό το μάθημα';
$string['lowquality'] = 'Χαμηλή ποιότητα';
$string['manageparticipants'] = 'Διαχείριση χρηστών';
$string['manual'] = 'Χειροκίνητα';
$string['manualenrol'] = 'Χειροκίνητη εγγραφή';
$string['mask'] = 'Απόκρυψη';
$string['mediumquality'] = 'Μεσαία ποιότητα';
$string['mobilevideo'] = 'Κινητό (MP4)';
$string['mobilevideoinfo'] = 'Βελτιστοποίηση για κινητές συσκευές. Ανάλυση: 480 x 320';
$string['mode'] = 'Λειτουργία ήχου';
$string['modephone'] = 'Διάσκεψη μόνο τηλεφώνου';
$string['modevoiceweb'] = 'Φωνή μέσω του ιστού';
$string['modewebphone'] = 'Ιστός και φωνή μέσω τηλεφώνου';
$string['modulename'] = 'Via';
$string['modulenameplural'] = 'Via';
$string['moodle_adminid'] = 'Μοναδικό αναγνωριστικό του Moodle Admin (λογ/μός διαχειριστή)';
$string['moodle_config'] = 'Ρυθμίσεις API - Βήμα 2';
$string['moodleidsetting'] = 'Μοναδικός λογ/μός διαχειριστή (admin) για αυτό το Moodle';
$string['multimediaquality'] = 'Προφίλ πολυμέσων';
$string['multimediaquality_help'] = 'Επιλέξτε το προφίλ πολυμέσου προς χρήση στη δραστηριότητα για ανταλλαγή πολυμέσων (βιντεοκάμερα ιστού (webcam), μικρόφωνο και έγγραφα πολυμέσων). Αυτή η επιλογή μπορεί να έχει σημαντικές επιπτώσεις για τη ρευστότητα των ανταλλαγών και το εύρος ζώνης που απαιτείται για κάθε συμμετέχοντα. Σε γενικές γραμμές, για μια καλύτερη εμπειρία ή αν δεν είστε σίγουροι, είναι καλύτερο να χρησιμοποιήσετε μια χαμηλότερη ποιότητα για να διασφαλιστεί η ομαλή ρευστότητα. Είναι δυνατό να ρυθμίσετε άλλα προφίλ πολυμέσου ανάλογα με τις ανάγκες σας (π.χ. μεγάλες μικρογραφίες βίντεο εξαιρετικές για χρήση τοπικά). Επικοινωνήστε με έναν από τους ειδικούς μας στη Via για περισσότερες πληροφορίες σχετικά με αυτό.';
$string['multiple'] = 'Πολλαπλά';
$string['mustaccept'] = 'Τσεκάρετε το κουτάκι για πρόσβαση στη δραστηριότητα.';
$string['name'] = 'Όνομα';
$string['needconfirmation'] = 'Αίτηση επιβεβαίωσης της διαθεσιμότητας';
$string['needconfirmation_help'] = 'Αίτηση επιβεβαίωσης της διαθεσιμότητας';
$string['neverbegin'] = 'Δεν έγινε';
$string['no_categories'] = 'Δεν υπάρχουν κατηγορίες. Πρέπει να δημιουργηθούν στην ηλ. πύλη Via από ένα διαχειριστή.';
$string['no_default'] = 'Δεν υπάρχει προεπιλεγμένη κατηγορία.';
$string['noanimators'] = 'Δεν υπάρχουν ακόμη εμψυχωτές για τη δραστηριότητα αυτή.';
$string['nocategories'] = 'Δεν υπάρχουν κατηγορίες';
$string['noparticipants'] = 'Δεν υπάρχουν ακόμη εμψυχωτές για τη δραστηριότητα αυτή.';
$string['noparticipants_help'] = 'Αυτή η επιλογή είναι διαθέσιμη μόνο με την αυτόματη εγγραφή και εξασφαλίζει ότι οι χρήστες με την ιδιότητα του μαθητή προστίθενται όλοι ως εμψυχωτές στο Via.';
$string['noparticipantscheckbox'] = 'Προσθήκη όλων των μαθητών ως εμψυχωτών';
$string['norecall'] = 'Καμία ανάκληση';
$string['notactivated'] = 'Χωρίς εγγραφή';
$string['notactivatedfeminin'] = 'Μη ενεργοποιημένο';
$string['notattending'] = 'Δεν θα παρακολουθήσω/συμμετέχω';
$string['notenrolled'] = 'Δεν είστε εγγεγραμμένος/-η σε αυτήν την δραστηριότητα. Παρακαλούμε, επικοινωνήστε με τον διδάσκοντά σας αν πιστεύετε ότι θα έπρεπε να έχετε πρόσβαση.';
$string['noticeclicktoaccesshtml'] = 'Κάντε κλικ στον παρακάτω σύνδεσμο για άμεση πρόσβαση:';
$string['noticeemail'] = 'Γεια σας {$a-> username},

Αυτό είναι ένα αυτοματοποιημένο μήνυμα.

Η εξαγωγή που ζητήσατε, για την εγγραφή ήχου/βίντεο «{$a->playbacktitle}» σε μορφότυπο {$a->type} είναι έτοιμη από {$a->date}.
Μπορείτε να κατεβάσετε αυτή την εξαγωγή ή να την κάνετε διαθέσιμη στους συμμετέχοντες, επισκεπτόμενοι τη σελίδα λεπτομερειών της δραστηριότητάς σας «{$a->activitytitle}».

Πρόσβαση ιστού
---

Πατήστε στον παρακάτω σύνδεσμο για άμεση πρόσβαση: {$a->activitylink}

---------------------------------------------------------------------';
$string['noticeemailhtml'] = '<p>Γεια σας {$a->username},</p>
<p>Αυτό είναι ένα αυτοματοποιημένο μήνυμα.</p>
<p>Η εξαγωγή που ζητήσατε, για την εγγραφή ήχου/βίντεο «{$a->playbacktitle}» σε μορφότυπο {$a->type} ολοκληρώθηκε από {$a->date}.<br/>
Μπορείτε να κατεβάσετε αυτή την εξαγωγή ή να την κάνετε διαθέσιμη στους συμμετέχοντες, επισκεπτόμενοι τη σελίδα λεπτομερειών της δραστηριότητάς σας «{$a->activitytitle}».</p>';
$string['notificationemail'] = '<p>Γεια σας {$a->username},

Αυτό είναι ένα αυτοματοποιημένο μήνυμα.

Ο χρήστης {$a->userfrom} προσπαθεί να επικοινωνήσει μαζί σας μέσω σύνδεσης με τη δραστηριότητά σας: «{$a->activitytitle}».

Πρόσβαση ιστού
---------------------------------------------------------------------

Πατήστε στον παρακάτω σύνδεσμο για άμεση πρόσβαση: {$a->activitylink}

---------------------------------------------------------------------';
$string['notificationemailhtml'] = '<p>Γεια σας {$a->username},</p>
<p>Αυτό είναι ένα αυτοματοποιημένο μήνυμα.</p>
<p>Ο χρήστης {$a->userfrom} προσπαθεί να επικοινωνήσει μαζί σας μέσω σύνδεσης με τη δραστηριότητά σας: «{$a->activitytitle}».</p>';
$string['notificationemailsubject'] = 'ΕΠΑΓΡΥΠΝΗΣΗ: ειδοποίηση δραστηριότητας';
$string['notifysuccess_synch1'] = 'Όλοι οι χρήστες συγχρονίστηκαν με επιτυχία με το Via.';
$string['notifysuccess_synch2'] = 'Αδυναμία συγχρονισμού συγκεκριμένων χρηστών. Παρακαλούμε, επαληθεύστε τις πληροφορίες τους και προσπαθήστε ξανά.';
$string['notstarted'] = 'Αυτή δραστηριότητα δεν έχει ξεκινήσει ακόμα.';
$string['nousers'] = 'Προειδοποίηση - Δεν υπάρχουν καθόλου χρήστες συσχετισμένα με αυτή τη δραστηριότητα!';
$string['oldapiversion'] = 'Χρησιμοποιείτε μια έκδοση του API που είναι παλιότερη από $a';
$string['options'] = 'Ολοκλήρωση δραστηριότητας';
$string['overview'] = 'Αρχίζει στις {$a->start} και τελειώνει στις {$a->end}';
$string['participant'] = 'Συμμετέχων';
$string['participantmustconfirm'] = 'Οι συμμετέχοντες θα πρέπει να επιβεβαιώσουν τη συμμετοχή';
$string['participants'] = 'Συμμετέχοντες';
$string['participants_search'] = 'αναζήτηση συμμετεχόντων';
$string['participantsynchronization'] = 'Συγχρονισμός πληροφοριών των συμμετεχόντων';
$string['passdate'] = 'Η επιλεγμένη ημερομηνία έχει περάσει';
$string['permanent'] = 'Μόνιμη δραστηριότητα';
$string['permanentactivities'] = 'Μόνιμες δραστηριότητες';
$string['permanentactivitiesdesc'] = 'Εάν επιλεγεί, θα είναι δυνατή η δημιουργία μόνιμων δραστηριοτήτων.';
$string['personalinvitemsg'] = 'Προσωποποιημένο μήνυμα (προαιρετικό):';
$string['playbackSynchronize'] = 'Συγχρονισμός αναπαραγωγών';
$string['playback_downloaded'] = 'Έγινε λήψη της αναπαραγωγής';
$string['playback_viewed'] = 'Έγινε προβολή της αναπαραγωγής';
$string['playbackaccesstype0'] = 'Ορατό για όσους έχουν δικαιώματα επεξεργασίας';
$string['playbackaccesstype1'] = 'Ορατό για όσους σχετίζονται με την εικονική τάξη';
$string['playbackaccesstype2'] = 'Ορατό για όσους σχετίζονται με την εκχωρημένη δραστηριότητα';
$string['playbackaccesstypelbl'] = 'Δικαιώματα πρόσβασης για την ηχογράφηση';
$string['playbackheader'] = 'Έγινε προβολή της αναπαραγωγής (h:m:s)';
$string['pluginadministration'] = 'Διαχείριση Via';
$string['pluginname'] = 'Via - Εικονική τάξη';
$string['portalaccessdesc'] = 'Επιτρέπει στους χρήστες την πρόσβαση στην πύλη Via χωρίς σύνδεση.';
$string['potentialusers'] = 'Πιθανοί χρήστες';
$string['preparation'] = 'Προετοιμάστε τη δραστηριότητά σας';
$string['prepareactivity'] = 'Κάντε κλικ εδώ για να προετοιμάσετε τη δραστηριότητά σας';
$string['presence'] = 'Απαιτείται ελάχιστη παρακολούθηση';
$string['presenceheader'] = 'Διαδικτυακή παρουσία (h:m:s)';
$string['presenceheaderreport'] = 'Διαδικτυακή παρουσία';
$string['presencestatus'] = 'Εμφάνιση κατάστασης παρουσίας';
$string['presencetable'] = 'Κατάσταση παρουσίας:';
$string['present'] = 'Παρών';
$string['recalloneday'] = 'Μία ημέρα πριν';
$string['recallonehour'] = 'Μία ώρα πριν';
$string['recalloneweek'] = 'Μία εβδομάδα πριν';
$string['recalltwodays'] = 'Δύο ημέρες πριν';
$string['recalltwohours'] = 'Δύο ώρες πριν';
$string['recentrecordings'] = 'Πρόσφατες εγγραφές ήχου/βίντεο';
$string['recordaccept'] = 'Δέχομαι';
$string['recording'] = 'Εγγραφή ήχου/βίντεο';
$string['recordingisdownloadable'] = 'Μπορεί να γίνει λήψη της εγγραφής ήχου/βίντεο';
$string['recordingisdownloadableinfo'] = 'Σημείωση: πρέπει πρώτα να εξαγάγετε το βίντεο για να είναι διαθέσιμο για λήψη.';
$string['recordingmode'] = 'Κατάσταση εγγραφής ήχου/βίντεο';
$string['recordings'] = 'Διαθέσιμη/-ες εγγραφές:';
$string['recordingtitle'] = 'Τίτλος εγγραφής ήχου/βίντεο';
$string['recordmodebehavior'] = 'Εγγραφή ήχου/βίντεο';
$string['recordwarning'] = 'Αυτή η δραστηριότητα μπορεί να καταγραφεί. Όταν επιλέγετε το πλαίσιο, αποδέχεστε την εγγραφή.';
$string['refused'] = 'Δεν θα παραβρεθεί';
$string['reminderemailsubject'] = 'ΥΠΕΝΘΥΜΙΣΗ: {$a->title}';
$string['report'] = 'Αναφορά παρουσίας';
$string['resetdeletemodules'] = 'Διαγραφή όλων των δραστηριοτήτων';
$string['resetdisablereviews'] = 'Απενεργοποίηση εξέτασης για όλες τις δραστηριότητες';
$string['return'] = 'Επιστροφή';
$string['returnto'] = 'Επιστροφή στη δραστηριότητα';
$string['reviewacitvity'] = 'Κάντε όλες τις εγγραφές ήχου/βίντεο δημόσιες από προεπιλογή';
$string['reviewactivity_help'] = 'Επιλογή του ποιός μπορεί να δει τις εγγραφές ήχου/βίντεο.';
$string['role'] = 'Ρόλος';
$string['roomtype'] = 'Τύπος δραστηριότητας';
$string['roomversion'] = 'Επιλογή της έκδοσης Via για αυτήν τη δραστηριότητα';
$string['roomversion_help'] = 'Επιλογή της έκδοσης Via για αυτήν τη δραστηριότητα';
$string['save'] = 'Αποθήκευση';
$string['seminar'] = 'Σεμινάριο';
$string['sendinvitation'] = 'Πρόσκληση μέσω ηλε.ταχυδρομείου';
$string['sessionparameters'] = 'Παράμετροι συνόδου';
$string['show'] = 'Εμφανίζεται';
$string['showlist'] = 'Εμφάνιση';
$string['showparticipants'] = 'Λίστα συμμετεχόντων';
$string['showparticipants_help'] = 'Σας επιτρέπει να εμφανίζετε ή να αποκρύπτετε τη λίστα των συμμετεχόντων στο Via όταν βρίσκεστε σε λειτουργία ιστοσεμιναρίου.';
$string['standard'] = 'Τυπικό';
$string['startdate'] = 'Ξεκινά στις';
$string['submitinvite'] = 'Αποστολή προσκλήσεων';
$string['technicalassist'] = 'Τεχνική υποστήριξη';
$string['technicalassist_url'] = 'Χρήση μιας εξατομικευμένης σελίδας τεχνικής υποστήριξης.';
$string['testadminid'] = 'Δοκιμάστε το πλήκτρο moodle';
$string['testconnection'] = 'Δοκιμή σύνδεσης API';
$string['timeduration'] = 'Διάρκεια :';
$string['title_exists'] = 'Ο τίτλος υπάρχει ήδη, δοκιμάστε ξανά.';
$string['typepInscriptionCoordinator'] = 'Συντονιστής';
$string['typepInscriptioncollaborator'] = 'συνεργάτης';
$string['typepInscriptionmember'] = 'χρήστης';
$string['unplanned_text'] = 'Αυτή η δραστηριότητα δεν έχει προγραμματιστεί ακόμη.';
$string['users_search'] = 'Αναζήτηση πιθανών χρηστών';
$string['usersynchwarning'] = 'Παρακαλούμε περιμένετε, μπορεί να χρειαστεί αρκετή ώρα!';
$string['viausers'] = 'Χρήστες:';
$string['view'] = 'Προβολή';
$string['waitingconfirm'] = 'Αναμονή επιβεβαίωσης';
$string['waitingroomaccessmode'] = 'Αίθουσα αναμονής';
