<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_brick', language 'de', version '4.0'.
 *
 * @package     theme_brick
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2 style="padding-top:0.5em;">Brick</h2>
<img src="brick/pix/screenshot.png" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Brick</h2>
<p>Brick ist ein Zwei-Spalten-Design mit variabler Breite für Moodle 2.0. In den Designeinstellungen können Sie die Designfarben individuell anpassen.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Falls Sie das Design Brick über die angebotenen Einstellmöglichkeiten hinaus ändern möchten, empfehlen wir Ihnen ein neues Design anzulegen, in dem Brick, Base und Canvas als \'parents\' eingetragen werden. Damit wird sichergestellt, dass sich alle Anpassungen an diesen drei Designs sich auch auf Ihr neues Design auswirken. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde erstellt und wird weiter unterstützt von John Stabinger (NewSchool Learning). Kontaktaufnahme ist per E-Mail: contact@newschoollearning.com</p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Brick-Einstellungen';
$string['headingcolor'] = 'Überschriftenfarbe';
$string['headingcolordesc'] = 'Diese Farbe wird für große Überschriften (Website-Nachrichten, meine Kurse) und andere Überschriften benutzt.';
$string['linkcolor'] = 'Link';
$string['linkcolordesc'] = 'Diese Farbe wird für Links benutzt. Verwenden Sie HTML hex-Code.';
$string['linkhover'] = 'Link (on hover)';
$string['linkhoverdesc'] = 'Diese Farbe wird für Links (on hover) benutzt. Verwenden Sie HTML hex-Code.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Um das Logo zu ändern, geben Sie die URL zu einem neuen Logo an (z.B. http://www.meinedomain.de/logo.png). Das Standardlogo ist 265px breit und 60px hoch. Ein transparentes Logo im Format PNG funktioniert am besten.';
$string['maincolor'] = 'Kopfbereichsfarbe';
$string['maincolordesc'] = 'Diese Farbe wird für den Kopfbereich, das Dock und andere Bereiche benutzt. Am besten wirken dunkle oder deckende Farben. Verwenden Sie HTML hex-Code.';
$string['maincolorlink'] = 'Kopflinkfarbe';
$string['maincolorlinkdesc'] = 'Diese Farbe wird für Links in der Kopfmenüleiste und Blocktitel benutzt.';
$string['pluginname'] = 'Brick';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
