<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'ru', version '4.0'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconcoloradministrationsetting'] = 'Цвет для «Управление»';
$string['activityiconcoloradministrationsetting_desc'] = 'Цвет значка действия «Управление»';
$string['activityiconcolorassessmentsetting'] = 'Цвет для «Оценка»';
$string['activityiconcolorassessmentsetting_desc'] = 'Цвет значка действия «Оценка»';
$string['activityiconcolorcollaborationsetting'] = 'Цвет для «Сотрудничество»';
$string['activityiconcolorcollaborationsetting_desc'] = 'Цвет значка действия «Сотрудничество»';
$string['activityiconcolorcommunicationsetting'] = 'Цвет для «Коммуникация»';
$string['activityiconcolorcommunicationsetting_desc'] = 'Цвет значка действия «Коммуникация»';
$string['activityiconcolorcontentsetting'] = 'Цвет для «Контент»';
$string['activityiconcolorcontentsetting_desc'] = 'Цвет значка действия «Контент»';
$string['activityiconcolorinterfacesetting'] = 'Цвет для «Интерфейс»';
$string['activityiconcolorinterfacesetting_desc'] = 'Цвет значка действия «Интерфейс»';
$string['activityiconcolorsheading'] = 'Цвета значков для действий';
$string['activitynavigation'] = 'Навигация по действиям';
$string['activitynavigationsetting'] = 'Навигация по элементам курса';
$string['activitynavigationsetting_desc'] = 'При включении отображаются элементы для перехода к предыдущему и следующему элементу(ресурсу) курса, а также раскрывающееся меню для перехода к конкретному элементу или ресурсу. Подобные элементы пользовательского интерфейса уже существовали в Boost в ядре Moodle до версии 3.11, но были удалены в версии 4.0. С помощью Boost Union вы можете вернуть их.';
$string['additionalresourcesfileurlpersistent'] = 'URL (постоянный)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (обновляемый)';
$string['additionalresourcesheading'] = 'Дополнительные ресурсы';
$string['additionalresourceslistsetting'] = 'Список дополнительных ресурсов';
$string['additionalresourceslistsetting_desc'] = 'Это список файлов, которые вы загрузили в файловую область дополнительных ресурсов. Указанные URL-адреса можно использовать для ссылки на эти файлы в своем пользовательском CSS, из сноски или в любом другом месте, где вам нужно использовать загруженные файлы, но вы не можете загружать файлы на месте.';
$string['additionalresourcessetting'] = 'Дополнительные ресурсы';
$string['additionalresourcessetting_desc'] = 'С помощью этой настройки вы можете загружать в тему дополнительные ресурсы. Преимущество загрузки файлов в эту файловую область заключается в том, что эти файлы могут быть доставлены без проверки, вошел ли пользователь в систему. По этой же причине следует добавлять только те файлы, которые некритичны, к которым должен быть разрешен доступ всем и которые не нужно защищать действующим логином. Как только вы загрузите хотя бы один файл в эту область файлов и сохраните настройки, под ним появится список, в котором будет указан URL, который вы можете использовать для ссылки на конкретный файл.';
$string['backgroundimagesetting'] = 'Фоновый рисунок';
$string['backgroundimagesetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение для отображения в качестве фона сайта. Загруженное здесь фоновое изображение будет заменять фоновое изображение в файлах предустановок вашей темы.';
$string['backgroundimagesheading'] = 'Общие фоновые изображения';
$string['backtotop'] = 'Вернуться к началу';
$string['backtotopbuttonsetting'] = 'Кнопка возврата к началу';
$string['backtotopbuttonsetting_desc'] = 'При включенном параметре кнопка «Вернуться к началу» появится в правом нижнем углу страницы, как только пользователь прокрутит страницу вниз. Подобная кнопка уже существовала в Boost до версии Moodle 3.11, но была удалена в версии 4.0. С помощью Boost Union вы можете вернуть её обратно.';
$string['blockregionoutsidebottomwidth'] = 'Ширина блока для области «Внешняя (снизу)»';
$string['blockregionoutsidebottomwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (снизу)», который отображается под основным контентом. Вы можете выбрать между полной шириной, шириной содержимого курса и шириной блока.';
$string['blockregionoutsideleftwidth'] = 'Ширина блока для области «Внешняя (слева)»';
$string['blockregionoutsideleftwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (слева)», который отображается слева от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ширина блока для области «Внешняя (справа)»';
$string['blockregionoutsiderightwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (справа)», который отображается справа от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ширина блока для области «Внешняя (сверху)»';
$string['blockregionoutsidetopwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (сверху)», который отображается в самом верху страницы. Вы можете выбрать между полной шириной, шириной содержимого курса и шириной блока.';
$string['blockregionsforlayout'] = 'Дополнительные области для макета «{$a}»';
$string['blockregionsforlayout_desc'] = 'С помощью этого параметра можно включить дополнительные области для макета «{$a}».';
$string['blockregionsheading'] = 'Дополнительные области блоков';
$string['blockregionsheading_desc'] = '<p>Boost Union предоставляет большое количество дополнительных областей, которые можно использовать для добавления и отображения блоков на всей странице Moodle:</p>
<ul><li><em>Внешние области</em> размещаются на всех четырех сторонах страницы Moodle. Они могут быть использованы для показа блоков, которые сопровождают отображаемую страницу Moodle, но не относятся непосредственно к основному содержимому.</li>
<li><em>Область заголовка</em> расположена между внешней (верхней) областью и основным содержимым. Её можно использовать для отображения блока в качестве заголовка курса.</li>
<li><em>Область блоков контента</em> размещается непосредственно над и под основным содержимым в области основного контента. Их можно использовать для добавления блоков в текущие материалы курса.</li>
<li><em>Область колонтитула</em> размещаются в нижней части страницы между внешней (нижней) областью и подвалом. В вашем распоряжении три области колонтитулов, из которых при необходимости можно построить колонки.</li>
<li><em>Область вне страницы</em> является особенной, поскольку она нависает над всей страницей Moodle в виде выпадающей панели. Панель открывается значком с 9 точками в самом правом углу навигационной панели. В вашем распоряжении три области вне страницы, из которых при необходимости можно построить колонки.</li></ul>
<p>Обратите внимание:</p>
<ul><li>По умолчанию все дополнительные области блоков отключены. Включите те или иные области блоков на конкретных макетах страниц в соответствии с вашими потребностями. Старайтесь быть как можно более сфокусированными - слишком большое количество областей может ошеломить часть пользователей.</li>
<li>Как только дополнительная область блока включена, она становится видимой для всех аутентифицированных пользователей и может редактироваться преподавателями и управляющими (конечно, в зависимости от того, разрешено ли данному пользователю редактировать конкретную страницу Moodle). Но существуют также разрешения theme/boost_union:viewregion* и theme/boost_union:editregion*, которые позволяют вам тонко настроить использование каждой области в соответствии со своими потребностями.</li>
<li>Блоки областей «Внешняя (слева)», «Внешняя (справа)», «Содержимое (вверху)», «Содержимое (внизу» и «Заголовок» доступны не для всех макетов страниц.</li></ul>';
$string['blockregionsheading_experimental'] = 'Пожалуйста, обратите внимание: <em>блоки областей «Внешняя (слева)» и «Внешняя (справа)»</em> полностью работоспособны в текущем состоянии реализации, но должны рассматриваться как экспериментальные, поскольку они еще не отображаются должным образом на экранах средней ширины. На этом фоне, пожалуйста, используйте их с осторожностью. Эта проблема будет исправлена в одном из ближайших выпусков.';
$string['blocksgeneralheading'] = 'Основные блоки';
$string['blockstab'] = 'Блоки';
$string['boost_union:configure'] = 'Возможность настраивать тему не в роли администратора';
$string['boost_union:editregioncontentlower'] = 'Возможность редактировать область блоков Контент (снизу)';
$string['boost_union:editregioncontentupper'] = 'Возможность редактировать область блоков Контент (сверху)';
$string['boost_union:editregionfootercenter'] = 'Возможность редактировать область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:editregionfooterleft'] = 'Возможность редактировать область блоков «Нижний колонтитул (слева)»';
$string['boost_union:editregionfooterright'] = 'Возможность редактировать область блоков «Нижний колонтитул (справа)»';
$string['boost_union:editregionheader'] = 'Возможность редактировать область блоков «Заголовок»';
$string['boost_union:editregionoffcanvascenter'] = 'Возможность редактировать область блоков «Вне страницы (по центру)»';
$string['boost_union:editregionoffcanvasleft'] = 'Возможность редактировать область блоков «Вне страницы (слева)»';
$string['boost_union:editregionoffcanvasright'] = 'Возможность редактировать область блоков «Вне страницы (справа)»';
$string['boost_union:editregionoutsidebottom'] = 'Возможность редактировать область блоков «Внешняя (снизу)»';
$string['boost_union:editregionoutsideleft'] = 'Возможность редактировать область блоков «Внешняя (слева)»';
$string['boost_union:editregionoutsideright'] = 'Возможность редактировать область блоков «Внешняя (справа)»';
$string['boost_union:editregionoutsidetop'] = 'Возможность редактировать область блоков «Внешняя (сверху)»';
$string['boost_union:viewhintcourseselfenrol'] = 'Возможность видеть подсказку о разрешенной самостоятельной записи на видимый курс.';
$string['boost_union:viewhintinhiddencourse'] = 'Возможность видеть подсказку о скрытом курсе.';
$string['boost_union:viewregioncontentlower'] = 'Возможность видеть область блоков Контент (снизу)';
$string['boost_union:viewregioncontentupper'] = 'Возможность видеть область блоков Контент (сверху)';
$string['boost_union:viewregionfootercenter'] = 'Возможность видеть область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:viewregionfooterleft'] = 'Возможность видеть область блоков «Нижний колонтитул (слева)»';
$string['boost_union:viewregionfooterright'] = 'Возможность видеть область блоков «Нижний колонтитул (справа)»';
$string['boost_union:viewregionheader'] = 'Возможность видеть область блоков «Заголовок»';
$string['boost_union:viewregionoffcanvascenter'] = 'Возможность видеть область блоков «Вне страницы (по центру)»';
$string['boost_union:viewregionoffcanvasleft'] = 'Возможность видеть область блоков «Вне страницы (слева)»';
$string['boost_union:viewregionoffcanvasright'] = 'Возможность видеть область блоков «Вне страницы (справа)»';
$string['boost_union:viewregionoutsidebottom'] = 'Возможность видеть область блоков «Внешняя (снизу)»';
$string['boost_union:viewregionoutsideleft'] = 'Возможность видеть область блоков «Внешняя (слева)»';
$string['boost_union:viewregionoutsideright'] = 'Возможность видеть область блоков «Внешняя (справа)»';
$string['boost_union:viewregionoutsidetop'] = 'Возможность видеть область блоков «Внешняя (сверху)»';
$string['bootstrapcolordangersetting'] = 'Цвет «Опасности»';
$string['bootstrapcolordangersetting_desc'] = 'Цвет Bootstrap для «Опасности»';
$string['bootstrapcolorinfosetting'] = 'Цвет «Информации»';
$string['bootstrapcolorinfosetting_desc'] = 'Цвет Bootstrap для «Информации»';
$string['bootstrapcolorsheading'] = 'Цвета Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Цвет «Успеха»';
$string['bootstrapcolorsuccesssetting_desc'] = 'Цвет Bootstrap для «Успеха»';
$string['bootstrapcolorwarningsetting'] = 'Цвет «Предупреждения»';
$string['bootstrapcolorwarningsetting_desc'] = 'Цвет Bootstrap для «Предупреждения»';
$string['bootstrapdangercolor'] = 'Цвет опасности';
$string['bootstrapdarkcolor'] = 'Тёмный цвет';
$string['bootstrapinfocolor'] = 'Цвет информации';
$string['bootstraplightcolor'] = 'Светлый цвет';
$string['bootstrapnone'] = 'Без цвета Bootstrap';
$string['bootstrapprimarycolor'] = 'Основной цвет';
$string['bootstrapsecondarycolor'] = 'Вторичный цвет';
$string['bootstrapsuccesscolor'] = 'Цвет завершения';
$string['bootstrapwarningcolor'] = 'Цвет предупреждения';
$string['brandcolorsheading'] = 'Корпоративные цвета';
$string['breadcrumbsheading'] = 'Навигационная цепочка';
$string['cachedef_flavours'] = 'Стили, которые применяются к данному идентификатору категории страницы для текущего пользователя';
$string['cachedef_fontawesome'] = 'Файлы FontAwesome (которые загружаются в настройках Boost Union)';
$string['categorybreadcrumbs'] = 'Отображать категории в заголовке курса';
$string['categorybreadcrumbs_desc'] = 'По умолчанию категории курса не отображаются на страницах курса в шапке курса. С помощью этой настройки вы можете показывать категории курса в заголовке курса над его названием.<br/><br/>
Обратите внимание: опция "Ничего не менять" ничего не меняет в навигационной цепочке категорий курсов, они представлены как в ядре Moodle. В то время как опция "Нет" позаботится о том, чтобы навигационные цепочки категорий курса вообще не отображались. Это может давать разный эффект, поскольку Boost в ядре Moodle действительно может показывать навигационные цепочки категории курса, начинающиеся на более глубоких уровнях вложенных категорий курса (что, по мнению разработчиков Boost Union, является ошибкой).';
$string['choosereadme'] = '<p>Тема Boost Union - это усовершенствованная дочерняя тема Boost, которая призвана, с одной стороны, сделать Boost более настраиваемой, а с другой стороны, предоставить полезные дополнительные функции для ежедневной работы в Moodle администраторов, преподавателей и студентов.</p><p>Boost Union поддерживается<br />Moodle an Hochschulen e.V.,</p><p>в сотрудничестве с<br />lern.link GmbH</p><p>вместе с<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Закрыть панель «Вне страницы»';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Содержимое';
$string['configtitlefeel'] = 'Восприятие';
$string['configtitleflavours'] = 'Стили';
$string['configtitlefunctionality'] = 'Функциональные особенности';
$string['configtitlelook'] = 'Вид';
$string['contactcontentsetting'] = 'Содержимое страницы контактов';
$string['contactcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице контактов (это не то же самое, что встроенная страница Moodle «Контакты поддержки сайта»).';
$string['contactdisabled'] = 'Страница контактов отключена для этого сайта. Здесь не на что смотреть.';
$string['contactheading'] = 'Контакты';
$string['contactlinkpositionboth'] = 'Добавить ссылку на страницу контактов в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfooter'] = 'Добавить ссылку на страницу контактов на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfootnote'] = 'Добавить ссылку на страницу контактов в колонтитул';
$string['contactlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу контактов';
$string['contactlinkpositionsetting'] = 'Позиция ссылки на страницу контактов';
$string['contactlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу контактов автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['contactpagetitledefault'] = 'Контакты';
$string['contactpagetitlesetting'] = 'Заголовок страницы контактов';
$string['contactpagetitlesetting_desc'] = 'Этот параметр определяет заголовок страницы контактов. Этот текст будет использоваться в качестве текста ссылки на страницу контактов, если вы соответствующим образом настроите «Позиция ссылки на страницу контактов».';
$string['contentwidthheading'] = 'Ширина контента';
$string['coursecontentmaxwidthsetting'] = 'Максимальная ширина контента курса';
$string['coursecontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину контента курса без ручного изменения SCSS. Эта ширина используется в качестве ширины страниц курса и в некоторых видах элементов курса. По умолчанию Moodle использует максимальную ширину контента курса 830px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100%, или значение viewport-width, например 90vw.';
$string['courseheaderheading'] = 'Заголовок курса';
$string['courseheaderimageenabled'] = 'Отображать изображение курса в заголовке курса';
$string['courseheaderimageenabled_desc'] = 'Если эта функция включена, изображение курса (которое можно загрузить в настройках курса) отображается в заголовке курса. Изображения курсов отображаются там в дополнение к странице «Мои курсы», где они отображаются всегда.';
$string['courseheaderimagefallback'] = 'Резервное изображение заголовка курса';
$string['courseheaderimagefallback_desc'] = 'Загруженное в этом параметре изображение используется в качестве резервного и будет отображено в заголовке курса, если в настройках курса не загружено изображение. Если вы не загрузите изображение здесь, то изображение в заголовке курса будет отображаться в конкретном курсе только в том случае, если в настройках этого конкретного курса загружено изображение.';
$string['courseheaderimageheight'] = 'Высота изображения заголовка курса';
$string['courseheaderimageheight_desc'] = 'С помощью этого параметра вы управляете высотой  изображения, представленного в заголовке курса.';
$string['courseheaderimagelayout'] = 'Расположение изображения в заголовке курса';
$string['courseheaderimagelayout_desc'] = 'Этот параметр позволяет управлять взаимным расположением изображения и названия курса в его заголовке.';
$string['courseheaderimagelayoutheadingabove'] = 'Название курса над изображением курса';
$string['courseheaderimagelayoutstackeddark'] = 'Название курса накладывается на изображение курса (белый цвет шрифта для темных фоновых изображений)';
$string['courseheaderimagelayoutstackedlight'] = 'Название курса накладывается на изображение курса (черный цвет шрифта для светлых фоновых изображений)';
$string['courseheaderimageposition'] = 'Позиция изображения заголовка курса';
$string['courseheaderimageposition_desc'] = 'С помощью этого параметра вы управляете расположением изображения заголовка курса в контейнере изображения заголовка курса. Первое значение — горизонтальное положение, второе значение — вертикальное положение.';
$string['courserelatedhintsheading'] = 'Подсказки, связанные с курсом';
$string['coursestab'] = 'Курсы';
$string['coursetab'] = 'Курс';
$string['cssh5pheading'] = 'Сырой CSS для H5P';
$string['cssh5psetting'] = 'Сырой CSS для H5P';
$string['cssh5psetting_desc'] = 'Используйте это поле для указания кода CSS, который будет применяться к представлению содержимого H5P с помощью mod_h5p и mod_hvp. Пожалуйста, ознакомьтесь с типами содержимого H5P, чтобы найти необходимые селекторы CSS.';
$string['customfontsfileurlpersistent'] = 'URL (постоянный)';
$string['customfontsfileurlrevisioned'] = 'URL (обновляемый)';
$string['customfontsheading'] = 'Пользовательские шрифты';
$string['customfontslistsetting'] = 'Список пользовательских шрифтов';
$string['customfontslistsetting_desc'] = 'Это список шрифтов, которые вы загрузили в область файлов пользовательских шрифтов. Приведенные фрагменты CSS можно использовать для добавления этих шрифтов в ваш пользовательский SCSS. Обратите внимание, что вам придется самостоятельно позаботиться о значении формата шрифта, а также о свойствах font-family, font-style и font-weight CSS, поскольку Boost Union еще не умеет анализировать файлы шрифтов.';
$string['customfontssetting'] = 'Пользовательские шрифты';
$string['customfontssetting_desc'] = 'С помощью этой настройки вы можете загрузить в тему пользовательские шрифты. Преимущество загрузки шрифтов в эту область файлов заключается в том, что эти шрифты могут быть доставлены без проверки входа пользователя в систему, и могут быть использованы как локально установленные шрифты везде на сайте. Как только вы загрузите хотя бы один шрифт в эту область файлов и сохраните настройки, под ними появится список, в котором будут приведены фрагменты кода CSS, которые вы можете использовать в качестве шаблона для ссылок на определенные шрифты в своем пользовательском SCSS.';
$string['dontchange'] = 'Ничего не менять';
$string['emailbrandinghtmldemobody'] = '<p>Тело электронного письма начинается здесь.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Тело электронного письма заканчивается здесь.</p>';
$string['emailbrandinghtmlheading'] = 'Предварительный просмотр письма HTML';
$string['emailbrandinghtmlintro'] = 'Это предварительный просмотр электронного письма HTML, основанного на префиксах и суффиксах фирменного стиля, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandinghtmlnopreview'] = 'До сих пор электронная почта HTML не была настроена с учетом этой функции. Электронная почта будет составляться и рассылаться в обычном режиме.';
$string['emailbrandinginstruction'] = 'Как это сделать';
$string['emailbrandinginstruction0'] = 'С помощью этой функции Boost Union вы можете применить брендирование ко всем электронным письмам, которые рассылает Moodle.';
$string['emailbrandinginstructionli1'] = 'Перейдите на страницу <a href="{$a->url}" target="_blank">настроек языковых параметров</a>, чтобы открыть языковой пакет <em>{$a->lang}</em> для редактирования.';
$string['emailbrandinginstructionli2'] = 'Найдите и измените эти строки в пакете <code>theme_boost_union language</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli3'] = 'Сохраните изменения в языковом пакете.';
$string['emailbrandinginstructionli4'] = 'Вернитесь на эту страницу и ниже посмотрите предварительный текст электронного письма.';
$string['emailbrandingintroheading'] = 'Вводная часть';
$string['emailbrandingintronote'] = 'Обратите внимание: это расширенная функциональность, которая использует некоторые обходные пути для обеспечения возможностей фирменного стиля электронной почты. Пожалуйста, внимательно следуйте инструкциям.';
$string['emailbrandingpitfalls'] = 'Подводные камни';
$string['emailbrandingpitfalls0'] = 'При использовании этой функции есть некоторые подводные камни, о которых вы должны знать:';
$string['emailbrandingpitfallsli1'] = 'Обязательным условием является изменение строк языкового пакета <em>текущего языка по умолчанию</em> этого сайта. Даже если у вас установлено несколько языковых пакетов, эффект будет иметь только изменение языка по умолчанию.';
$string['emailbrandingpitfallsli2'] = 'Учесть язык получателя невозможно. Поэтому в фрагментах брендинга электронной почты следует использовать термины, не зависящие от языка.';
$string['emailbrandingpitfallsli3'] = 'Если в будущем вы измените язык сайта по умолчанию, вам придется перенести измененные строки языкового пакета в новый языковой пакет по умолчанию.';
$string['emailbrandingpitfallsli4'] = 'В обычной электронной почте после префикса и перед суффиксным фрагментом автоматически добавляется разрыв строки и пустая строка. Это делается для того, чтобы суффикс и префикс не приклеивались непосредственно к телу электронной почты.';
$string['emailbrandingpitfallsli5'] = 'В электронной почте HTML префикс и суффикс добавляются непосредственно перед и над телом электронной почты. Это делается для того, чтобы вы могли легко работать с HTML-тегами, однако вам придется самостоятельно обрабатывать все интервалы вокруг тела письма.';
$string['emailbrandingpitfallsli6'] = 'В HTML-почте вы можете без проблем открыть HTML-тег в префиксном фрагменте и закрыть его в суффиксном фрагменте. Только не забудьте создать правильный HTML в результирующем письме.';
$string['emailbrandingtab'] = 'Брендирование почты';
$string['emailbrandingtextdemobody'] = 'Тело электронного письма начинается здесь.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Тело электронного письма заканчивается здесь.';
$string['emailbrandingtextheading'] = 'Предварительный просмотр электронного письма с простым текстом';
$string['emailbrandingtextintro'] = 'Это предварительный просмотр электронной почты, основанной на префиксах и суффиксах брендинга, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandingtextnopreview'] = 'До сих пор обычные текстовые электронные письма не были настроены с учетом этой функции. Электронная почта будет составляться и отправляться в обычном режиме.';
$string['enablecontactsetting'] = 'Включить страницу контактов';
$string['enablehelpsetting'] = 'Включить страницу справки';
$string['enableimprintsetting'] = 'Включить выходные данные';
$string['enablemaintenancesetting'] = 'Включить страницу с информацией о техническом обслуживании';
$string['error:infobannerdismissnonotdismissible'] = 'Данный информационный баннер не может быть закрыт';
$string['error:infobannerdismissnonotvalid'] = 'Номер информационного баннера не действителен';
$string['faviconheading'] = 'Фавикон';
$string['faviconsetting'] = 'Фавикон';
$string['faviconsetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение (в формате .ico или .png), которое будет отображаться в браузере в качестве фавикон вашего сайта Moodle. Если пользовательский favicon не загружен, будет использоваться стандартный фавикон Moodle.';
$string['flavoursappliesto'] = 'Применить к';
$string['flavoursapplytocategories'] = 'Применить к категории курсов';
$string['flavoursapplytocategories_help'] = 'Здесь вы определяете, следует ли применять этот стиль к категориям курсов.';
$string['flavoursapplytocategories_ids'] = 'Категории курсов';
$string['flavoursapplytocategories_ids_help'] = 'Здесь вы определяете одну или несколько конкретных категорий курсов, к которым будет применяться данный стиль. Когда отображаемая страница Moodle будет находиться в одной из указанных категорий курса, стиль будет применен.';
$string['flavoursapplytocohorts'] = 'Применить к глобальной группе';
$string['flavoursapplytocohorts_help'] = 'Здесь вы определяете, следует ли применять этот стиль к глобальным группам.';
$string['flavoursapplytocohorts_ids'] = 'Глобальные группы';
$string['flavoursapplytocohorts_ids_help'] = 'Здесь вы определяете одну или несколько конкретных глобальных групп, к которым следует применить этот стиль. Как только пользователь становится членом одной из настроенных глобальных групп, стиль применяется.<br /><br />Обратите внимание, что если вы указываете более одной глобальной группы, пользователю не нужно быть членом всех их одновременно.<br /><br />Пожалуйста, обратите внимание, что на текущем этапе внедрения группы категорий обрабатываются так же, как если бы они были системными глобальными группами.';
$string['flavoursbackgroundimage'] = 'Фоновое изображение';
$string['flavoursbackgroundimage_help'] = 'С помощью этого параметра стиль будет переопределять фоновое изображение, которое задано в настройках внешнего вида Boost Union.';
$string['flavoursbacktooverview'] = 'Вернуться к списку стилей';
$string['flavourscreateflavour'] = 'Создать стиль';
$string['flavourscustomcss'] = 'Пользовательский CSS';
$string['flavourscustomcss_help'] = 'С помощью этого параметра вы можете написать собственный CSS для стиля. Он будет добавлен в стек кода CSS, который будет обработан браузером при применении стиля. Обратите внимание, что в текущем состоянии реализации этот параметр позволяет использовать только пользовательский CSS, но не SCSS.';
$string['flavoursdelete'] = 'Удалить';
$string['flavoursdeleteconfirmation'] = 'Вы действительно хотите удалить стиль <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Удалить стиль';
$string['flavoursdescription'] = 'Описание';
$string['flavoursdescription_help'] = 'Описание стиля используется только для того, чтобы вы могли узнать конкретный стиль в списке стилей.';
$string['flavoursedit'] = 'Редактировать';
$string['flavourseditflavour'] = 'Редактировать стиль';
$string['flavoursfavicon'] = 'Фавикон';
$string['flavoursfavicon_help'] = 'С помощью этой настройки стиль будет переопределять фавикон, который определен в настройках внешнего вида Boost Union.';
$string['flavoursflavours'] = 'Стили';
$string['flavoursgeneralsettings'] = 'Общее';
$string['flavoursincludesubcategories'] = 'Включить подкатегории';
$string['flavoursincludesubcategories_help'] = 'При включенном параметре стиль будет также применен к подкатегориям выбранных категорий.';
$string['flavourslogo'] = 'Логотип';
$string['flavourslogo_help'] = 'С помощью этой настройки стиль будет переопределять логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavourslogocompact'] = 'Компактный логотип';
$string['flavourslogocompact_help'] = 'С помощью этой настройки стиль будет переопределять компактный логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavoursnothingtodisplay'] = 'Еще не создано ни одного стиля. Пожалуйста, создайте свой первый стиль, чтобы начать работу.';
$string['flavoursnotificationcreated'] = 'Стиль создан';
$string['flavoursnotificationdeleted'] = 'Стиль удален';
$string['flavoursnotificationedited'] = 'Стиль изменен';
$string['flavoursoverview_desc'] = '<p>Стили Boost Union дают возможность переопределять определенные настройки внешнего вида и настроек Moodle в определенных контекстах. На этой странице вы можете создавать стили и управлять ими.</p><p>В рамках каждого стиля вы определяете, должен ли он применяться к определенным категориям курсов или определенным глобальным группам. Затем, во время отображения каждой страницы Moodle, Boost Union проверяет, применяется ли какой-либо стиль. Обратите внимание, что при каждом отображении страницы Moodle применяется только первый подходящий стиль в списке, а остальные стили игнорируются. Таким образом, порядок расположения стилей на этой странице является ключевым.</p><p>Обратите внимание, что после каждого изменения, которое вы вносите в набор стилей, кэш темы очищается. Это необходимо для того, чтобы убедиться, что все объекты поставляются в браузер правильно и в актуальном состоянии.</p>';
$string['flavourspreview'] = 'Предварительный просмотр';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Предварительный просмотр стиля';
$string['flavourstitle'] = 'Название';
$string['flavourstitle_help'] = 'Название стиля используется только для того, чтобы вы могли найти конкретный стиль в списке стилей.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'В новых версиях FontAwesome старые идентификаторы иконок меняются на более новые или даже удаляются некоторые иконки. Если вы видите сплошную иконку карты с левой стороны, это означает, что ваша версия FontAwesome 6 правильно отображает измененные значки из FontAwesome 4.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'Резервный FontAwesome 4';
$string['fontawesomecheck-fa6free-filter-description'] = 'Поскольку у вас установлен плагин фильтра FontAwesome, вы должны убедиться, что фильтр правильно обрабатывает новые иконки FontAwesome 6. Если вы видите значок пользователя с левой стороны, фильтр правильно работает с иконками версии FontAwesome 6.';
$string['fontawesomecheck-fa6free-filter-title'] = 'Фильтр FontAwesome';
$string['fontawesomecheck-fa6free-general-description'] = 'Если вы слева видите значок галочки, то FontAwesome, скорее всего, работает на вашем сайте.';
$string['fontawesomecheck-fa6free-general-title'] = 'Общие функции';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'Новые версии FontAwesome поставляются с дополнительными иконками по сравнению с набором иконок FontAwesome 4. Если вы видите значок вируса с левой стороны, значит, ваша версия FontAwesome 6 правильно отображает новые значки, которые появились в FontAwesome 6.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'Иконки FontAwesome 6';
$string['fontawesomecheckssetting'] = 'Проверка FontAwesome';
$string['fontawesomecheckssetting_desc'] = 'Здесь вы можете визуально проверить, правильно ли загружены и добавлены файлы FontAwesome на страницу Moodle. Если одна из проверок не прошла, пожалуйста, перепроверьте, правильно ли вы загрузили все обязательные файлы.';
$string['fontawesomefilessetting'] = 'Файлы FontAwesome';
$string['fontawesomefilessetting_desc'] = 'С помощью этой настройки вы можете загружать более новые файлы FontAwesome в Moodle. Вы должны сами загружать файлы FontAwesome в Moodle из-за лицензионных ограничений. Просто зайдите на <a href="https://fontawesome.com">fontawesome.com</a>, скачайте пакет FontAwesome и загрузите файлы сюда.';
$string['fontawesomefilesstructurenote'] = 'Обратите внимание, что файлы должны быть загружены с правильной структурой папок и с правильными именами файлов. Пожалуйста, начните с создания папок <em>css</em> и <em>webfonts</em> в файловом менеджере, загрузите файл <em>fa-solid-900.woff2</em> в папку <em>webfonts</em> и сохраните страницу настроек. Как только вы это сделаете, ниже появится список файлов, который поможет вам определить и загрузить нужные файлы в эти папки.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Это дополнительный файл CSS, который добавляет шрифт для иконок брендов FontAwesome на страницу Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Это основной файл CSS, который добавляет все доступные символы FontAwesome на страницу Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Это дополнительный файл CSS, который добавляет шрифт для обычных иконок FontAwesome на страницу Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Это дополнительный файл CSS, который добавляет шрифт для сплошных иконок FontAwesome на страницу Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Это файл CSS, который обеспечивает правильное отображение иконок FontAwesome 4 в Moodle.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Это файл шрифта для иконок брендов FontAwesome (в формате TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Это файл шрифта для иконок брендов FontAwesome (в формате WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Это файл шрифта для обычных иконок FontAwesome (в формате TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Это файл шрифта для обычных иконок FontAwesome (в формате WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Это файл шрифта для сплошных иконок FontAwesome (в формате TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Это файл шрифта для сплошных иконок FontAwesome (в формате WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Это файл шрифта для совместимости с FontAwesome v4 (в формате TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Это файл шрифта для совместимости с FontAwesome v4 (в формате WOFF2).';
$string['fontawesomelistmandatorymissing'] = 'Это обязательный файл для работы FontAwesome, но он был загружен неправильно. Пожалуйста, попробуйте загрузить его правильно.';
$string['fontawesomelistmandatoryuploaded'] = 'Это обязательный файл для работы FontAwesome, и он был загружен правильно.';
$string['fontawesomelistnote'] = 'Обратите внимание, что если вы загрузите только часть обязательных файлов, значки FontAwesome могут некорректно отображаться на странице Moodle. Это невозможно исправить, пока вы не загрузите все обязательные файлы или снова не удалите все файлы.';
$string['fontawesomelistoptionalmissing'] = 'Это дополнительный файл для расширения набора иконок FontAwesome, но он не был загружен. Это нормально, если он вам не нужен.';
$string['fontawesomelistoptionaluploaded'] = 'Это дополнительный файл для расширения набора иконок FontAwesome, и он был загружен правильно.';
$string['fontawesomelistsetting'] = 'Список файлов FontAwesome';
$string['fontawesomelistsetting_desc'] = 'Это список файлов FontAwesome, которые вы загрузили в вышеуказанную область файлов FontAwesome. Здесь перечислены все файлы FontAwesome, которые действительны для настроенной версии FontAwesome. Другие файлы, которые вы могли загрузить, но которые не являются действительными или необходимыми файлами FontAwesome, игнорируются. Файлы FontAwesome автоматически добавляются на страницы Moodle и начинают действовать сразу же после сохранения этой настройки.';
$string['fontawesomeversionfa6free'] = 'Обновление до FontAwesome 6 Free';
$string['fontawesomeversionnone'] = 'Сохранить FontAwesome 4 (как поставляется с ядром Moodle)';
$string['fontawesomeversionsetting'] = 'Версия FontAwesome';
$string['fontawesomeversionsetting_desc'] = 'Ядро Moodle поставляется с иконками FontAwesome 4, которые вполне подходят, но с тех пор FontAwesome изменился. Если вы хотите использовать более современные иконки FontAwesome, вы можете сделать это с помощью данной настройки. Как только вы выберете версию, отличную от FontAwesome 4, появятся дополнительные настройки, в которых вы сможете загрузить более свежие версии FontAwesome.';
$string['footertab'] = 'Колонтитул';
$string['footnoteheading'] = 'Колонтитул';
$string['footnotesetting'] = 'Колонтитул';
$string['footnotesetting_desc'] = 'Все, что вы добавите в эту текстовую область, будет отображаться в конце страницы, в нижнем колонтитуле (не в плавающем колонтитуле) на каждой странице, которая использует макеты "drawers", "columns2" или "login". Содержание в этой области может быть, например, авторским правом, условиями использования или названием вашей организации.<br/>Если вы захотите снова удалить текст колонтитула, просто очистите текстовую область.';
$string['h5pcontentmaxwidthsetting'] = 'Максимальная ширина банка контента H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину банка контента H5P в Moodle без ручной правки SCSS. Эта ширина используется для редактора H5P внутри банка контента. Она <em>не</em> используется для ширины элемента H5P. По умолчанию Moodle использует максимальную ширину банка контента H5P, равную 960px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100% или значение viewport-width, например 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Содержание страницы справки';
$string['helpcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице справки.';
$string['helpdisabled'] = 'Страница справки отключена для этого сайта. Здесь не на что смотреть.';
$string['helpheading'] = 'Справка';
$string['helplinkpositionboth'] = 'Добавить ссылку на страницу справки в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfooter'] = 'Добавить ссылку на страницу справки на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfootnote'] = 'Добавить ссылку на страницу справки в колонтитул';
$string['helplinkpositionnone'] = 'Не показывать автоматически ссылку на страницу справки';
$string['helplinkpositionsetting'] = 'Позиция ссылки на страницу справки';
$string['helplinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу справки автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['helppagetitledefault'] = 'Справка';
$string['helppagetitlesetting'] = 'Заголовок страницы справки';
$string['helppagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы справки. Этот текст также будет использоваться в качестве текста ссылки на страницу справки, если параметр «Позиция ссылки на страницу справки» настроен соответствующим образом.';
$string['hidenodesprimarynavigationsetting'] = 'Скрыть узлы в основной навигации';
$string['hidenodesprimarynavigationsetting_desc'] = 'С помощью этого параметра можно скрыть один или несколько узлов из основной навигации.';
$string['imprintcontentsetting'] = 'Выходные данные';
$string['imprintcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице выходных данных.';
$string['imprintdisabled'] = 'Страница выходных данных отключена на этом сайте. Здесь не на что смотреть.';
$string['imprintheading'] = 'Выходные данные';
$string['imprintlinkpositionboth'] = 'Добавьте ссылку на страницу выходных данных в колонтитул и на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfooter'] = 'Добавьте ссылку на страницу выходных данных на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfootnote'] = 'Добавить ссылку на страницу выходных данных в колонтитул';
$string['imprintlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу выходных данных';
$string['imprintlinkpositionsetting'] = 'Позиция ссылки на выходные данные';
$string['imprintlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу выходных данных автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['imprintpagetitledefault'] = 'Выходные данные';
$string['imprintpagetitlesetting'] = 'Заголовок страницы выходных данных';
$string['imprintpagetitlesetting_desc'] = 'В этом параметре вы можете определить название страницы выходных данных. Этот текст также будет использоваться в качестве текста ссылки на страницу выходных данных, если вы соответствующим образом настроите «Позиция ссылки на выходные данные».';
$string['infobannerbsclasssetting'] = 'Класс Bootstrap информационного баннера {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'С помощью этой настройки вы можете выбрать класс Bootstrap,который будет применен к информационному баннеру {$a->no}. Если вы выберете опцию «Без цвета Bootstrap», то информационный баннер будет выводиться без какого-либо определенного цвета Bootstrap, что даст вам свободу стилизовать баннер самостоятельно в текстовом редакторе.';
$string['infobannerclose'] = 'Закрыть';
$string['infobannercontentsetting'] = 'Содержимое информационного банера {$a->no}';
$string['infobannercontentsetting_desc'] = 'Здесь можно ввести информацию, которая должна отображаться в информационном баннере {$a->no}.';
$string['infobannerdismissconfirm'] = 'Вы действительно хотите сбросить видимость информационного баннера {$a->no} и снова показать его всем пользователям, которые его закрыли?';
$string['infobannerdismissfail'] = 'Сброс видимости информационного баннера {$a->no} не удался по крайней мере для одного пользователя';
$string['infobannerdismissiblesetting'] = 'Информационный баннер {$a->no} можно закрыть';
$string['infobannerdismissiblesetting_desc'] = 'С помощью этой настройки вы можете сделать информационный баннер {$a->no} неудаляемым. Если пользователь нажмет на кнопку Х в информационном баннере, то он будет скрыт для этого пользователя навсегда. Видимость не сбрасывается автоматически, даже если вы меняете содержимое информационного баннера. Если вы хотите сбросить видимость информационного баннера, нажмите ниже кнопку «Сбросить видимость».';
$string['infobannerdismissreset'] = 'Сделать видимым закрытый информационный баннер';
$string['infobannerdismissresetbutton'] = 'Сбросить видимость информационного баннера {$a->no}';
$string['infobannerdismisssuccess'] = 'Видимость информационного баннера {$a->no} была сброшена.';
$string['infobannerenabledsetting'] = 'Включить информационный банер {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Этот параметр включает информационный баннер {$a->no}.';
$string['infobannerendsetting'] = 'Время окончания показа информационного баннера {$a->no}';
$string['infobannerendsetting_desc'] = 'С помощью этого параметра вы можете определить, до какого момента должен отображаться информационный баннер {$a->no}. Настроенное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannerheading'] = 'Информационный баннер {$a->no}';
$string['infobannermodeperpetual'] = 'Постоянный';
$string['infobannermodesetting'] = 'Режим отображения информационного баннера {$a->no}';
$string['infobannermodesetting_desc'] = 'С помощью этого параметра вы можете определить, должен ли информационный баннер {$a->no} быть постоянным баннером (отображается всегда) или баннером, управляемым по времени (отображается только в течение заданного интервала времени).';
$string['infobannermodetimebased'] = 'Управление по времени';
$string['infobannerordersetting'] = 'Порядок размещения информационного баннера {$a->no}';
$string['infobannerordersetting_desc'] = 'С помощью этого параметра вы определяете порядковый номер информационного баннера {$a->no}. По умолчанию информационные баннеры упорядочены сверху вниз, как вы видите их на этой странице настроек. Однако с помощью этой настройки вы можете назначить другую позицию. Если вы назначите одну и ту же позицию двум или более информационным баннерам, они будут снова упорядочены в соответствии с порядком на этой странице.';
$string['infobannerpageloginpage'] = 'Страница авторизации';
$string['infobannerpagessetting'] = 'Макеты страниц для отображения информационного баннера {$a->no}';
$string['infobannerpagessetting_desc'] = 'Этот параметр позволяет выбрать макеты страниц, на которых должен отображаться информационный баннер {$a->no}.';
$string['infobannerstartsetting'] = 'Время начала показа информационного баннера {$a->no}';
$string['infobannerstartsetting_desc'] = 'С помощью этого параметра вы можете определить, с какого момента должен отображаться информационный баннер {$a->no}. Заданное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannertab'] = 'Информационный баннер';
$string['javascriptdisabledhint'] = 'Подсказка о выключенном JavaScript';
$string['javascriptdisabledhint_desc'] = 'С помощью этой настройки в верхней части страницы Moodle появится подсказка, если JavaScript не включен. Это особенно полезно, поскольку некоторые функции Moodle не работают без JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript отключен в вашем браузере.<br />Многие функции Moodle будут недоступны или будут выглядеть нерабочими.<br />Пожалуйста, включите JavaScript для полноценной работы с Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['loginbackgroundimage'] = 'Фоновые изображения страницы авторизации';
$string['loginbackgroundimage_desc'] = 'Изображения для отображения в качестве фона страницы входа в систему. Одно из этих изображений будет выбрано случайным образом и показано при посещении пользователем страницы входа в систему. Пожалуйста, убедитесь, что в имени файла не используются символы, отличные от ASCII, если вы хотите отобразить текст для фоновых изображений входа в систему.';
$string['loginbackgroundimagesheading'] = 'Фоновые изображения страницы авторизации';
$string['loginbackgroundimagetextsetting'] = 'Отображение текста для фоновых изображений страницы авторизации';
$string['loginbackgroundimagetextsetting_desc'] = 'С помощью этого необязательного параметра к загруженным фоновым изображениям можно добавить текст, например, уведомление об авторских правах. Этот текст появится в верхней части нижнего колонтитула на странице входа в систему. Однако из соображений экономии площади экрана он отображается только на экранах больших размеров.<br/>
Каждая строка состоит из идентификатора файла (имя файла), текста, который должен быть отображен, и цвета текста, разделенных символами вертикальной черты. Каждое описание должно быть записано с новой строки. <br/>
Например:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
В качестве цвета текста можно использовать значения "dark" или "light".<br />
Вы можете объявить тексты для произвольного количества загруженных фоновых изображений. Тексты будут добавлены только к тем изображениям, имя файла которых совпадает с идентификатором, объявленным в этом параметре.';
$string['loginformheading'] = 'Форма входа';
$string['loginformpositionsetting'] = 'Расположение формы входа';
$string['loginformpositionsetting_center'] = 'По центру';
$string['loginformpositionsetting_desc'] = 'С помощью этой настройки вы можете переместить форму входа в систему, чтобы она подходила к большему числу фоновых изображений. По умолчанию форма входа отображается по центру страницы входа. В качестве альтернативы вы можете переместить ее влево или вправо, чтобы другие части фонового изображения были видны. Конечно, вы также можете изменить этот параметр даже если фоновые изображения вообще не загружены.';
$string['loginformpositionsetting_left'] = 'Выравнивание по левому краю';
$string['loginformpositionsetting_right'] = 'Выравнивание по правому краю';
$string['loginformtransparencysetting'] = 'Прозрачность формы входа';
$string['loginformtransparencysetting_desc'] = 'С помощью этой настройки можно сделать форму входа в систему слегка прозрачной, чтобы лучше показать фоновое изображение.';
$string['loginpagetab'] = 'Страница авторизации';
$string['logocompactsetting'] = 'Компактный логотип';
$string['logocompactsetting_desc'] = 'Здесь вы можете загрузить компактную версию того же логотипа, что и выше, например, эмблему, щит или значок. Это изображение особенно часто используется в навигационной панели в верхней части каждой страницы Moodle. Изображение должно быть четким даже при небольших размерах.';
$string['logosetting'] = 'Логотип';
$string['logosetting_desc'] = 'Здесь вы можете загрузить полный логотип для использования в качестве украшения. Это изображение особенно часто используется на странице входа в систему. Это изображение должно быть с высоким разрешением, поскольку оно будет уменьшено при использовании.';
$string['logosheading'] = 'Логотипы';
$string['logosheading_desc'] = 'Обратите внимание: Boost Union имеет свою собственную загрузку логотипа и не использует логотип из <a href="{$a}">настроек логотипа ядра Moodle</a>.<br />Boost Union позволяет загружать больше форматов изображений, чем позволяет ядро Moodle, и позволяет переопределять загруженные логотипы с учетом своих стилей.';
$string['maintenancecontentsetting'] = 'Содержимое страницы с информацией о техническом обслуживании';
$string['maintenancecontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице информации о техническом обслуживании (отличается от встроенной в  Moodle страницы режима обслуживания).';
$string['maintenancedisabled'] = 'Страница  с информацией о техническом обслуживании отключена для этого сайта. Здесь не на что смотреть.';
$string['maintenanceheading'] = 'Обслуживание';
$string['maintenancelinkpositionboth'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании в сноску и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfooter'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfootnote'] = 'Добавьте ссылку на страницу с информацией о техническом обслуживании в колонтитул';
$string['maintenancelinkpositionnone'] = 'Не показывать автоматически ссылку на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting'] = 'Позиция ссылки на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу с информацией о техническом обслуживании автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['maintenancepagetitledefault'] = 'Информация о техническом обслуживании';
$string['maintenancepagetitlesetting'] = 'Заголовок страницы с информацией о техническом обслуживании';
$string['maintenancepagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы с информацией о техобслуживании. Этот текст также будет использоваться в качестве текста ссылки на такую страницу, если параметр «Позиция ссылки на страницу с информацией о техобслуживании» настроен соответствующим образом.';
$string['misctab'] = 'Разное';
$string['mobileappearanceheading'] = 'Мобильный вид';
$string['mobilecss'] = 'Дополнительный CSS для мобильного приложения';
$string['mobilecss_desc'] = 'С помощью этого параметра вы можете написать собственный код CSS для настройки интерфейса вашего мобильного приложения. Код CSS будет добавлен только к стилям этого экземпляра Moodle в мобильном приложении и не будет отображаться в версии для веб-браузера. Подробнее об этой функции читайте в <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Документации разработчика Moodle</a>.';
$string['mobilecss_donotchange'] = 'Этот шаг необходим для отправки кода CSS в мобильное приложение. Не изменяйте URL-адрес, если только вы действительно не хотите снова удалить CSS-код из мобильного приложения.';
$string['mobilecss_overwrite'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">основной параметр Moodle <em>mobilecssurl</em></a> будет автоматически перезаписан URL-адресом темы Boost Union. Текущее значение <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">параметр ядра Moodle <em>mobilecssurl</em></a> будет автоматически установлен в значение URL-адреса темы Boost Union.';
$string['mobiletab'] = 'Мобильное приложение';
$string['navbarcolorsetting'] = 'Цвет панели навигации';
$string['navbarcolorsetting_dark'] = 'Темная панель навигации со светлым цветом шрифта';
$string['navbarcolorsetting_desc'] = 'С помощью этого параметра можно изменить цвет навигационной панели со светлого по умолчанию на темный или корпоративный.';
$string['navbarcolorsetting_light'] = 'Светлая панель навигации с темным цветом шрифта (без изменений, как представлено в ядре Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Навигационная панель основного цвета со светлым цветом шрифта';
$string['navbarcolorsetting_primarylight'] = 'Навигационная панель основного цвета с темным цветом шрифта';
$string['navbarheading'] = 'Панель навигации';
$string['navigationheading'] = 'Навигация';
$string['navigationtab'] = 'Навигация';
$string['openoffcanvas'] = 'Открыть панель «Вне страницы»';
$string['outsideregionsheading'] = 'Внешние области';
$string['outsideregionsheading_desc'] = 'Внешние области можно не только включить с помощью указанных выше настроек макета, но и настроить их внешний вид.';
$string['outsideregionsplacement'] = 'Горизонтальное размещение внешних областей';
$string['outsideregionsplacement_desc'] = 'С помощью этой настройки вы можете контролировать, должны ли на больших экранах области «Внешняя (слева)» и «Внешняя (справа)» располагаться рядом с областью основного контента или ближе к краям окна.';
$string['outsideregionsplacementnearwindowedges'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» у краев окна';
$string['outsideregionsplacementnextmaincontent'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» рядом с областью основного контента';
$string['outsideregionswidthcoursecontentwidth'] = 'Ширина колонки контента курса';
$string['outsideregionswidthfullwidth'] = 'Полная ширина';
$string['outsideregionswidthherowidth'] = 'Ширина блока';
$string['pagetab'] = 'Страница';
$string['pagewidthheading'] = 'Ширина страницы';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Предустановки тем';
$string['primarynavigationheading'] = 'Основная навигация';
$string['privacy:metadata'] = 'Тема Boost Union не хранит никаких личных данных ни о каком пользователе.';
$string['region-content-lower'] = 'Контент (снизу)';
$string['region-content-upper'] = 'Контент (сверху)';
$string['region-footer-center'] = 'Нижний колонтитул (по центру)';
$string['region-footer-left'] = 'Нижний колонтитул (слева)';
$string['region-footer-right'] = 'Нижний колонтитул (справа)';
$string['region-header'] = 'Заголовок';
$string['region-none'] = 'Нет';
$string['region-offcanvas-center'] = 'Вне страницы (по центру)';
$string['region-offcanvas-left'] = 'Вне страницы (слева)';
$string['region-offcanvas-right'] = 'Вне страницы (справа)';
$string['region-outside-bottom'] = 'Внешняя (снизу)';
$string['region-outside-left'] = 'Внешняя (слева)';
$string['region-outside-right'] = 'Внешняя (справа)';
$string['region-outside-top'] = 'Внешняя (сверху)';
$string['resourcescachecontrolnote'] = 'Обратите внимание, что файлы отправляются в браузер с заголовком \'Cache-Control\', который указывает браузеру кэшировать файл. Если вы уверены, что не будете изменять файл в ближайшем будущем, вы можете использовать постоянный URL для ссылки на файл. Однако, если вы планируете изменять файл, но время от времени сохранять то же имя файла, вам лучше использовать обновляемый URL.  При этом каждый раз при обновлении файла заново ссылаться на файл там, где вы его использовали, чтобы браузеры не показывали кэшированные устаревшие версии файла.';
$string['resourcestab'] = 'Ресурсы';
$string['scrollspy'] = 'Отслеживание прокрутки';
$string['scrollspysetting'] = 'Отслеживание прокрутки';
$string['scrollspysetting_desc'] = 'С этой настройкой при включении и выключении режима редактирования сохраняется позиция прокрутки, в которой находился пользователь в момент переключения.';
$string['scssheading'] = 'Необработанный SCSS';
$string['scsstab'] = 'SCSS';
$string['showhintcourseguestaccessgeneral'] = 'В настоящее время вы просматриваете этот курс как <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Чтобы получить полный доступ к курсу, вы можете <a href="{$a->url}">самостоятельно записаться на этот курс</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'При включенном параметре в заголовке курса появляется подсказка, если пользователь получает доступ к курсу с помощью гостевого доступа. Если в курсе разрешена самостоятельная запись, пользователю также будет представлена ссылка на соответствующую страницу.';
$string['showhintcoursehiddengeneral'] = 'В настоящее время этот курс <strong>скрыт</strong>. Только зарегистрированные преподаватели могут получить доступ к этому курсу, когда он скрыт.';
$string['showhintcoursehiddensetting'] = 'Отображать подсказку о скрытых курсах';
$string['showhintcoursehiddensetting_desc'] = 'При включенном параметре в заголовке скрытого курса будет появляться подсказка. Это помогает определить состояние видимости курса с первого взгляда без необходимости просматривать настройки курса.';
$string['showhintcoursehiddensettingslink'] = 'Вы можете изменить видимость в <a href="{$a->url}">настройках курса</a>.';
$string['showhintcourseselfenrolfrom'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись после {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись с {$a->from} по {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Если вы не хотите, чтобы любой пользователь Moodle имел свободный доступ к этому курсу, ограничьте настройки самостоятельной записи.';
$string['showhintcourseselfenrolsetting'] = 'Отображать подсказку для самостоятельной записи без ключа';
$string['showhintcourseselfenrolsetting_desc'] = 'При включенном параметре в заголовке видимого курса появится подсказка о возможности записи без ключа.';
$string['showhintcourseselfenrolsince'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в текущий момент.';
$string['showhintcourseselfenrolsinceuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'В настоящее время этот курс доступен для всех и возможна <strong>самостоятельная запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'В настоящее время этот курс доступен для всех и планируется разрешить <strong>самостоятельную запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в любой момент.';
$string['showhintcourseselfenroluntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Отображать подсказку о гостевом входе';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при первом входе в систему';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые входят в систему в первый раз, и не переписывает состояние переключения для каждого отдельного пользователя.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при входе гостем';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые вошли в систему как гость.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Показывать правую боковую панель  при посещении домашней страницы сайта';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, не вошедшим в систему, и не перезаписывает состояние переключения для каждого отдельного пользователя.';
$string['showswitchedroleincoursesetting'] = 'Отображать подсказку о переключенной роли';
$string['showswitchedroleincoursesetting_desc'] = 'При включенном параметре в заголовке курса появится подсказка, если пользователь сменил роль в курсе. По умолчанию эта информация отображается только рядом с аватаром пользователя в меню пользователя. Включив эту опцию, вы сможете показывать эту информацию (вместе со ссылкой для переключения обратно) также и на странице курса.';
$string['sitebrandingtab'] = 'Фирменный стиль сайта';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Правая боковая панель на домашней странице сайта';
$string['staticpagestab'] = 'Статические страницы';
$string['switchedroleto'] = 'В настоящий момент вы просматриваете этот курс с ролью: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Расположение фонового рисунка рекламной плитки {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Этот параметр управляет позиционированием фонового изображения внутри контейнера рекламной плитки {$a->no}. Первое значение - положение по горизонтали, второе - по вертикали.';
$string['tilebackgroundimagesetting'] = 'Фоновое изображение рекламной плитки {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Здесь вы можете загрузить файл изображения, который будет использоваться в качестве фонового изображения за содержимым рекламной плитки {$a->no}. Проверьте, что содержимое читаемо на фоновом изображении. Это необязательная настройка, рекламная плитка будет работать, даже если вы не загрузите никакого фонового изображения.';
$string['tilecolumnssetting'] = 'Количество колонок рекламных плиток в ряду';
$string['tilecolumnssetting_desc'] = 'Здесь вы определяете количество колонок в ряду в представленной сетке рекламных плиток. Обратите внимание, что это количество столбцов относится к настольному компьютеру / большим экранам. На маленьких и мобильных экранах колонки рекламных плиток автоматически сворачиваются.';
$string['tilecontentsetting'] = 'Содержимое рекламной плитки {$a->no}';
$string['tilecontentsetting_desc'] = 'Здесь вы вводите содержимое, которое должно отображаться в рекламной плитке {$a->no}. Содержимое отображается в центре плитки. Это необязательный параметр, рекламная плитка будет отображаться, даже если вы не зададите никакого содержимого.';
$string['tileenabledsetting'] = 'Включить рекламную плитку {$a->no}';
$string['tileenabledsetting_desc'] = 'Эта настройка включает рекламную плитку {$a->no}';
$string['tilefrontpagepositionsetting'] = 'Размещение рекламных плиток на главной странице';
$string['tilefrontpagepositionsetting_after'] = 'После содержимого главной страницы';
$string['tilefrontpagepositionsetting_before'] = 'До содержимого главной страницы';
$string['tilefrontpagepositionsetting_desc'] = 'Рекламные плитки отображаются только на главной странице. Этот параметр определяет, будут ли рекламные плитки отображаться перед содержимым главной страницы сайта или после него. Если вы хотите показывать на главной странице сайта только рекламные плитки и ничего больше, всё остальное содержимое главной страницы сайта можно удалить, изменив <a href="{$a->url}">настройки главной страницы</a>.';
$string['tileheading'] = 'Рекламная плитка {$a->no}';
$string['tileheightsetting'] = 'Высота рекламной плитки';
$string['tileheightsetting_desc'] = 'С помощью этой настройки вы контролируете высоту рекламных плиток. Настроенная высота - это минимальная высота каждой плитки. Если содержимое плитки больше этой настроенной высоты, весь ряд плиток будет автоматически увеличен по мере необходимости.';
$string['tilelinksetting'] = 'URL ссылки рекламной плитки {$a->no}';
$string['tilelinksetting_desc'] = 'Здесь вы можете задать внутренний или внешний URL-адрес, который будет добавлен в качестве кнопки ссылки в конце рекламной плитки {$a->no}. Это необязательный параметр, рекламная плитка будет работать, даже если вы не зададите URL ссылки.';
$string['tilelinktargetsetting'] = 'Цель ссылки рекламной плитки {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Здесь вы можете задать цель ссылки, которая устанавливается для кнопки ссылки, как только вы зададите URL ссылки в рекламной плитке {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Новая вкладка';
$string['tilelinktargetsetting_samewindow'] = 'То же окно';
$string['tilelinktitlefallback'] = 'Ссылка';
$string['tilelinktitlesetting'] = 'Заголовок ссылки рекламной плитки {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Здесь вы можете задать заголовок ссылки, который будет использоваться в качестве текста кнопки ссылки, если вы зададите URL ссылки в рекламной плитке {$a->no}. Обратите внимание, что если вы зададите URL ссылки, но не зададите заголовок ссылки, то кнопка ссылки будет обозначена как «Ссылка».';
$string['tileordersetting'] = 'Порядок сортировки рекламной плитки {$a->no}';
$string['tileordersetting_desc'] = 'С помощью этой настройки вы определяете порядок расположения рекламной плитки {$a->no}. По умолчанию рекламные плитки упорядочены сверху вниз и слева направо, как вы видите на этой странице настроек. Однако вы можете назначить другую позицию с помощью этой настройки. Если вы назначите одинаковое положение для двух или более рекламных плиток, они будут упорядочены в соответствии с порядком, указанным на этой странице настроек.';
$string['tilesgeneralheading'] = 'Общие настройка рекламных плиток';
$string['tilestab'] = 'Рекламные плитки';
$string['tiletitlesetting'] = 'Заголовок рекламной плитки {$a->no}';
$string['tiletitlesetting_desc'] = 'Здесь вы вводите заголовок, который должен отображаться в рекламной плитке {$a->no}. Это необязательный параметр, рекламная плитка будет показана, даже если вы не зададите заголовок.';
$string['upgradenotice_2022080922'] = 'Начиная с этого выпуска, Boost Union имеет настройки своего логотипа (и компактного логотипа) и больше не использует эти файлы из ядра Moodle';
$string['upgradenotice_2022080922_copied'] = 'Во время этого обновления значение параметра <strong>{$a}</strong> из настроек ядра Moodle было скопировано в параметр {$a} Boost Union. Пожалуйста, перепроверьте результат.';
$string['upgradenotice_2022080922_logo'] = 'логотип';
$string['upgradenotice_2022080922_logocompact'] = 'компактный логотип';
$string['upgradenotice_2022080922_notcopied'] = 'Параметр <strong>{$a}</strong> в Boost Union сейчас пуст. Если вы хотите использовать {$a} в Boost Union, просто задайте {$a} в настройках Boost Union позже.';
