<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'es', version '4.0'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Abortar';
$string['add_comment'] = 'Añadir comentario';
$string['add_reply'] = 'Añadir respuesta';
$string['addprivatecomment'] = 'Añadir comentario privado (estos son solamente entre el estudiante y el tutor)';
$string['addprivatecomment_help'] = 'Estos comentarios son estrictamente entre el autor de la pregunta y la persona que administra la actividad. Este hilo es principalmente para que el administrador de la actividad le proporcione retroalimentación si y cuando el estudiante cambie el estado de la pregunta.';
$string['addpubliccomment'] = 'Añadir comentario público';
$string['after_answering_end_date'] = 'Este StudentQuiz se cerró para respuestas en {$a}.';
$string['after_submission_end_date'] = 'Este StudentQuiz se cerró para envío de preguntas en {$a}.';
$string['anonymous_user_name'] = 'Usuario anónimo #{$a}';
$string['answeringndbeforestart'] = 'La fecha límite para contestar no puede estar especificada anterior a la fecha para contestar';
$string['api_state_change_error_content'] = 'La pregunta no puede ser eliminada porque ya ha sido aprobada.';
$string['api_state_change_error_title'] = 'Error al eliminar pregunta';
$string['api_state_change_success_content'] = 'Estado/visibilidad de pregunta cambiado exitosamente';
$string['api_state_change_success_title'] = 'Éxito';
$string['approve'] = 'Aprobar';
$string['approve_toggle'] = 'Des/Aprobar';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Aprobado';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = '¿Está seguro de querer des/aprobar las preguntas siguientes?<br /><br />{$a}';
$string['average_column_name'] = 'Promedio';
$string['back_to_course_button'] = 'Regresar al curso';
$string['before_answering_end_date'] = 'Este StudentQuiz se cierra para respuestas en {$a}.';
$string['before_answering_start_date'] = 'Abierto para responder a partir de {$a}.';
$string['before_submission_end_date'] = 'Este StudentQuiz se cierra para envío de preguntas en {$a}.';
$string['before_submission_start_date'] = 'Abierto para envío de preguntas a partir de {$a}.';
$string['cachedef_permissionssync'] = 'Monitoreo de sincronización de permisos de StudentQuiz';
$string['cannotcapturecommenthistory'] = 'No se puede capturar registro de historia de comentarios';
$string['changecurrentstate'] = 'Cambiar estado de <b>{$a}</b> a:';
$string['changestateto'] = 'Cambiar estado(s) a:';
$string['collapseall'] = 'Colapsar todos los comentarios';
$string['collapsecomment'] = 'Colapsar comentario';
$string['comment'] = 'Comentario';
$string['comment_author'] = 'Autor';
$string['comment_cannot_update'] = 'No se puede actualizar comentario';
$string['comment_column_name'] = 'Comentarios';
$string['comment_error'] = 'Por favor comente';
$string['comment_error_unsaved'] = '¿Quiere guardar primeramente este comentario?';
$string['comment_help'] = 'Escribir un comentario';
$string['comment_help_help'] = 'Escribir un comentario a la pregunta';
$string['comment_veryshort'] = 'C';
$string['commentcolumnexplainprivate'] = 'Número de comentarios privados. Un fondo azul significa que usted tiene al menos un comentario sin leer.';
$string['commentcolumnexplainpublic'] = 'Número de comentarios públicos. Un fondo azul significa que usted tiene al menos un comentario sin leer.';
$string['commenthistory'] = 'Historia de comentarios';
$string['commentplural'] = 'Comentarios';
$string['confirmdeletecomment'] = '¿Está seguro de querer eliminar este comentario?';
$string['createnewquestion'] = 'Crear pregunta nueva';
$string['createnewquestionfirst'] = 'Crear primera pregunta';
$string['creator_anonym_fullname'] = 'Estudiante Anónimo';
$string['current_of_total'] = '{$a->current} de {$a->total}';
$string['current_state'] = 'Estado actual';
$string['daily'] = 'diariamente';
$string['delete'] = 'Eliminar';
$string['deletecomment'] = 'Eliminar comentario';
$string['deleted'] = 'Eliminada';
$string['deletedbyauthor'] = 'Esta publicación fue eliminada en {$a}.';
$string['deletedbyuser'] = 'Esta publicación fue eliminada por <a href="{$a->profileurl}" >{$a->fullname}</a> en {$a->date}.';
$string['deletedcomment'] = 'Publicación eliminada.';
$string['deleteorphanedquestions'] = 'Eliminar preguntas huérfanas';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">error</font>: no se pudo eliminar de la tabla mdl_question. La pregunta probablemente está en uso en algún otro lado.<br><font color="red">error</font>: la eliminación de las tablas mdl_studentquiz* ha sido saltada.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">error</font>: no se pudo eliminar de tablas mdl_studentquiz*.<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Preguntas que fueron desaprobadas/marcadas para eliminación:<ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>ninguna encontrada</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (TipoDePregunta: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'StudentQuiz: Trabajo para elimnar preguntas huérfanas se ha ejecutado';
$string['deleteorphanedquestionssubject'] = 'StudentQuiz';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">success</font>: eliminada de tabla mdl_question<br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">success</font>: eliminada de tablas mdl_studentquiz*.<br>';
$string['describe_already_deleted'] = 'Este comentario ya fue eliminado.';
$string['describe_not_creator'] = 'Este comentario no es suyo.';
$string['describe_out_of_time_delete'] = 'Este comentario está fuera del tiempo permitido para eliminarlo.';
$string['describe_out_of_time_edit'] = 'Este comentario ya no está en tiempo para editarlo';
$string['descriptioncofstate'] = 'Pregunta configurada a \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Pregunta guardada (\'Borrador\')';
$string['descriptionofvisibility'] = 'Visibilidad de pregunta configurada a \'{$a->visibility}\'';
$string['difficulty_all_column_name'] = 'Dificultad de Comunidad';
$string['difficulty_level_column_name'] = 'Dificultad';
$string['difficulty_title'] = 'Barra de dificultad';
$string['editcomment'] = 'Editar comentario';
$string['editedcomment_last_edit'] = 'Última edición:';
$string['editedcommenthistory'] = 'Editado por {$a->lastesteditedcommentauthorname} en {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'Historia';
$string['editedcommenthistorywithuserlink'] = 'Editada por el <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a> en {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Ingresar aquí su comentario ...';
$string['emailautomationnote'] = 'Por favor tenga en cuenta que este es un mensaje de sistema automatizado - esta dirección Email no es monitoreada.';
$string['emailcommentaddedbody'] = 'Estimado/a  {$a->recepientname},

Su pregunta \'{$a->questionname}\' en la actividad ExamenEstudiante (StudentQuiz) \'{$a->modulename}\' en el curso \'{$a->coursename}\' ha sido comentada por \'{$a->actorname}\' en \'{$a->timestamp}\'.

El comentario es: \'{$a->commenttext}\'

Puede revisar esta pregunta en: {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'Su pregunta \'{$a->questionname}\' ha sido comentada por  {$a->username}.';
$string['emailcommentaddedsubject'] = 'Pregunta ha sido comentada: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Estimado/a {$a->recepientname},

El comentario con fecha \'{$a->commenttime}\' a su pregunta \'{$a->questionname}\' en la actividad ExamenEstudiante (StudentQuiz) \'{$a->modulename}\' en el curso \'{$a->coursename}\' ha sido eliminado por \'{$a->actorname}\' en \'{$a->timestamp}\'.

El comentario era: \'{$a->commenttext}\'

Puede revisar esta pregunta en: {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'El comentario a su pregunta \'{$a->questionname}\' ha sido eliminado por {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Comentario ha sido eliminado a la pregunta: {$a->questionname}';
$string['emaildigestbody'] = 'Este es su resumen {$a->digesttype} de notificaciones para la actividad StudentQuiz  <b>{$a->modulename}</b> disponible aquí:';
$string['emaildigestbody_section_content'] = 'Su pregunta <b>{$a->questionname}</b> ha sido <b>{$a->actiontype}</b> por <b>{$a->actorname}</b>';
$string['emaildigestbody_section_title'] = 'Notificación {$a->seq}, {$a->timestamp}';
$string['emaildigestsubject'] = 'Notificación Resumida de StudentQuiz';
$string['emailminecommentdeletedbody'] = 'Estimado/a {$a->recepientname},

Su comentario con fecha \'{$a->commenttime}\' a la pregunta \'{$a->questionname}\' en la actividad ExamenEstudiante (StudentQuiz) \'{$a->modulename}\' en el curso \'{$a->coursename}\' ha sido eliminado por \'{$a->actorname}\' en \'{$a->timestamp}\'.

El comentario era: \'{$a->commenttext}\'

Puede revisar esta pregunta en: : {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'Su comentario a la pregunta  \'{$a->questionname}\' ha sido eliminado por  {$a->actorname}.';
$string['emailminecommentdeletedsubject'] = 'Comentario ha sido eliminado a la pregunta: {$a->questionname}';
$string['emailnoityfyreviewablequestion_section_content'] = 'La pregunta "<b>{$a->questionname}</b>" fue configurada a "<b>Revisable</b>" por <b>{$a->actorname}</b>';
$string['emailnoityfyreviewablequestionsinglebody'] = '<b>{$a->courseshortname}</b> Actividad StudentQuiz (<b>"{$a->modulename}"</b>): pregunta <b>"{$a->questionname}"</b> fue configurada a "<b>Revisable</b>" por <b>{$a->actorname}, {$a->timestamp}.</b>';
$string['emailsalutation'] = 'Estimado/a {$a},';
$string['emailsinglebody'] = 'Su pregunta <b>{$a->questionname}</b> en la actividad  StudentQuiz <b>{$a->modulename}</b> en el curso <b>{$a->coursename}</b> ha sido {$a->eventname} por <b>{$a->actorname}</b> en <b>{$a->timestamp}</b>.';
$string['emailsinglebody_reviewlink'] = 'Usted puede revisar esta pregunta en:';
$string['error_form_validation'] = '{$a}';
$string['error_permission'] = 'Lo sentimos, pero usted necesita ser parte de un grupo para ver esta página.';
$string['expandall'] = 'Expandir todos los comentarios';
$string['expandcomment'] = 'Expandir comentarios';
$string['filter'] = 'Filtro';
$string['filter_advanced_element'] = '{$a} (Elemento avanzado)';
$string['filter_comment_label_date'] = 'Fecha';
$string['filter_comment_label_forename'] = 'Nombre';
$string['filter_comment_label_sort_by'] = 'Ordenar por';
$string['filter_comment_label_sort_toggle'] = 'Ordenar por {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Apeliido(s)';
$string['filter_ishigher'] = 'Es superior';
$string['filter_islower'] = 'Es inferior';
$string['filter_label_approved'] = 'Preguntas aprobadas';
$string['filter_label_comment'] = 'Comentarios';
$string['filter_label_createdate'] = 'Creación';
$string['filter_label_difficulty_level'] = 'Dificultad';
$string['filter_label_fast_filters'] = 'Filtro rápido para preguntas';
$string['filter_label_myattempts'] = 'Mis intentos';
$string['filter_label_mydifficulty'] = 'Mi dificultad';
$string['filter_label_mylastattempt'] = 'Mí último intento';
$string['filter_label_myrate'] = 'Mi Valoración';
$string['filter_label_onlyapproved'] = 'Aprobadas';
$string['filter_label_onlyapproved_help'] = 'Preguntas aprobadas por su profesor';
$string['filter_label_onlydifficult'] = 'Dificultad para todos';
$string['filter_label_onlydifficult_help'] = 'Pregunta con una dificultad promedio de más de {$a}%';
$string['filter_label_onlydifficultforme'] = 'Dificultad para mí';
$string['filter_label_onlydifficultforme_help'] = 'Pregunta con mi dificultad de más de {$a}%';
$string['filter_label_onlygood'] = 'Bien';
$string['filter_label_onlygood_help'] = 'Pregunta con una valoración promedio de al menos {$a} estrellas';
$string['filter_label_onlymine'] = 'Mía';
$string['filter_label_onlymine_help'] = 'Preguntas que usted creó.';
$string['filter_label_onlynew'] = 'No contestada';
$string['filter_label_onlynew_help'] = 'Preguntas que usted nunca ha contestado antes';
$string['filter_label_question'] = 'Título de pregunta';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Contenido de pregunta';
$string['filter_label_rates'] = 'Valoración';
$string['filter_label_show_mine'] = 'Mis preguntas';
$string['filter_label_tags'] = 'Marca';
$string['finish_button'] = 'Terminar';
$string['hidden'] = 'Oculta';
$string['history'] = 'Historia';
$string['includingunread'] = '(incluyendo no leídos)';
$string['invalidcomment'] = 'comentarioinvalido';
$string['invalidemail'] = 'La dirección Email no es válida. Por favor ingrese una sola dirección Email.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Último intento correcto';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Último intento incorrecto';
$string['latest_column_name'] = 'Más reciente';
$string['manager_anonym_fullname'] = 'Mánager Anónimo';
$string['message'] = 'Mensaje';
$string['messageprovider:commentadded'] = 'Notificación de pregunta añadida';
$string['messageprovider:commentdeleted'] = 'Notificación de eliminación de comentario';
$string['messageprovider:deleteorphanedquestions'] = 'Notificación sobre pregunta eliminada';
$string['messageprovider:minecommentdeleted'] = 'Notificación de eliminación de mi comentario';
$string['messageprovider:questionchanged'] = 'Notificación de evento de pregunta';
$string['migrate_already_done'] = 'No se hizo nada porque esta actividad ya ha sido migrada !';
$string['migrate_studentquiz'] = 'Migrar preguntas de StudentQuiz anteriores a la versión 3,2,1 a la versión más rápida con valores agregados';
$string['migrate_studentquiz_short'] = 'Acelerar este conjunto de preguntas';
$string['migrated_successful'] = '¡Esta actividad ha sido migrada exitosamente!';
$string['mine_column_name'] = 'Mía';
$string['missingparam'] = 'Un parámetro falta o está equivocado';
$string['moderator'] = 'Moderador';
$string['modulename'] = 'ExamenEstudiante (StudentQuiz)';
$string['modulename_help'] = 'La actividad ExamenEstudiante (StudentQuiz) le permite a los estudiantes añadir preguntas para la multitud. En la vista general del ExamenEstudiante, los estudiantes pueden filtrar preguntas. También pueden usar las preguntas filtradas en la multitud para practicar. El profesor tiene la opción de anonimizar la columna de \'creado por\'.<br><br>La actividad de ExamenEstudiante le otorga a los estudiantes puntos para motivarlos a que añadan preguntas y a que practiquen. Los puntos están listados en una tabla de ranking.';
$string['modulename_link'] = 'mod/studentquiz/view';
$string['modulenameplural'] = 'ExámenesEstudiante (StudentQuizzes)';
$string['more'] = 'Más';
$string['myattempts_column_name'] = 'Mis Intentos';
$string['mydifficulty_column_name'] = 'Mi Dificultad';
$string['mylastattempt_column_name'] = 'Mi Último Intento';
$string['myrate_column_name'] = 'Mi Valoración';
$string['nav_export'] = 'Exportar';
$string['nav_import'] = 'Importar';
$string['nav_question_no'] = 'Pregunta {$a->current} de {$a->total}';
$string['needtoallowatleastoneqtype'] = 'Necesita permitir al menos un tipo de pregunta';
$string['next_button'] = 'Siguiente';
$string['no_comment'] = 'no disponible';
$string['no_comments'] = 'Sin comentarios';
$string['no_difficulty_level'] = 'no disponible';
$string['no_myattempts'] = 'no disponible';
$string['no_mylastattempt'] = 'no disponible';
$string['no_mylastattempt_label'] = 'La pregunta no está intentada';
$string['no_questions_add'] = 'No hay preguntas en este ExamenEstudiante (StudentQuiz). Siéntase con libertad de añadir algunas preguntas.';
$string['no_questions_filter'] = 'Ninguna de las preguntas coincidió con su criterio de filtro. Reinicie el filtro para ver todo.';
$string['no_questions_selected_message'] = 'Por favor seleccione al menos un tipo de pregunta para comenzar el examen.';
$string['no_rates'] = 'no disponible';
$string['no_tags'] = 'no disponible';
$string['nocommenthistoryexist'] = 'Aun no hay historia de comentarios para este comentario.';
$string['nofurtherprivatecomments'] = 'No se permiten más comentarios públicos una vez que la pregunta está \'Aprobada\'';
$string['noquestionsselectedtodoaction'] = 'Por favor seleccione una o más preguntas antes de seleccionar esta acción.';
$string['not_approved'] = '✗';
$string['notshowratingcomment'] = 'Valoración y comentario público no están disponibles para su propia pregunta en modo Previsualización.';
$string['num_questions'] = '{$a} preguntas';
$string['number_column_name'] = 'Número';
$string['numberreply'] = '{$a} Respuestas';
$string['onlyrootcommentcanreply'] = 'Solamente el primer nivel de comentario puede ser respuesta';
$string['pagesize'] = 'Tamaño de página:';
$string['pagesize_invalid_input'] = 'Error: el tamaño de una página especificada debe ser un valor numérico válido.';
$string['pin'] = 'Fijar pregunta';
$string['please_enrole_message'] = 'Por favor inscríbase en este curso para ver su progreso personal';
$string['pluginadministration'] = 'Administración de ExamenEstudiante (StudentQuiz)';
$string['pluginname'] = 'ExamenEstudiante (StudentQuiz)';
$string['previous_button'] = 'Anterior';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'Una preferencia del usuario para tipo de filtro de comentario.';
$string['privacy:metadata:mod_studentquiz_question_active_tab'] = 'Una preferencia del usuario para ventana activa actual en páginas de pregunta.';
$string['privacy:metadata:studentquiz_attempt'] = 'Representa un intento de usuario para contestar un conjunto de preguntas.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID de la categoría.';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID del uso de pregunta.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID del StudentQuiz.';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID del usuario.';
$string['privacy:metadata:studentquiz_comment'] = 'Almacena comentarios para preguntas.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Comentario de la pregunta.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Hora de creación del comentario.';
$string['privacy:metadata:studentquiz_comment:deleted'] = 'Comentario de hora de eliminación.';
$string['privacy:metadata:studentquiz_comment:deleteuserid'] = 'Comentario de ID del usuario eliminado';
$string['privacy:metadata:studentquiz_comment:edited'] = 'Hora de comentario editado.';
$string['privacy:metadata:studentquiz_comment:edituserid'] = 'ID del usuario que editó comentario.';
$string['privacy:metadata:studentquiz_comment:parentid'] = 'ID del comentario paterno. 0: comentario del nivel superior.';
$string['privacy:metadata:studentquiz_comment:status'] = 'Estado del comentario';
$string['privacy:metadata:studentquiz_comment:studentquizquestionid'] = 'ID del studentquizquestion.';
$string['privacy:metadata:studentquiz_comment:timemodified'] = 'Hora actual de modificación';
$string['privacy:metadata:studentquiz_comment:type'] = 'Tipo de comentario';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID del usuario.';
$string['privacy:metadata:studentquiz_comment:usermodified'] = 'ID de usuario que modificó comentario';
$string['privacy:metadata:studentquiz_comment_history'] = 'Almacenar historia de comentarios de  los comentarios';
$string['privacy:metadata:studentquiz_comment_history:action'] = 'Tipo de historia 0 - Crear | 1 - Editar | 2 - Eliminar';
$string['privacy:metadata:studentquiz_comment_history:commentid'] = 'ID del comentario';
$string['privacy:metadata:studentquiz_comment_history:content'] = 'Contenido de historia de comentarios';
$string['privacy:metadata:studentquiz_comment_history:timemodified'] = 'Hora de comentario modificado';
$string['privacy:metadata:studentquiz_comment_history:userid'] = 'ID del usuario que editó comentario';
$string['privacy:metadata:studentquiz_notification'] = 'Cola de notificaciones';
$string['privacy:metadata:studentquiz_notification:content'] = 'Contenido de la notificación';
$string['privacy:metadata:studentquiz_notification:recipientid'] = 'ID del destinatario';
$string['privacy:metadata:studentquiz_notification:status'] = 'Estado de la notificación';
$string['privacy:metadata:studentquiz_notification:studentquizid'] = 'ID del StudentQuiz';
$string['privacy:metadata:studentquiz_notification:timetosend'] = 'Hora para enviar la notificación';
$string['privacy:metadata:studentquiz_progress'] = 'Almacena información del progreso del estudiante con esta pregunta.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Número de intentos para contestar esta pregunta.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Número de respuestas correctas.';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: la última respuesta fue incorrecta o indefinida, 1: la última respuesta fue correcta.';
$string['privacy:metadata:studentquiz_progress:lastreadprivatecomment'] = 'Última vez que el usuario leyó los comentarios privados';
$string['privacy:metadata:studentquiz_progress:lastreadpubliccomment'] = 'Última vez que el usuario leyó los comentarios públicos';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID del StudentQuiz.';
$string['privacy:metadata:studentquiz_progress:studentquizquestionid'] = 'ID del studentquizquestion.';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID del usuario.';
$string['privacy:metadata:studentquiz_question'] = 'Almacenar propiedades relacionadas con la pregunta';
$string['privacy:metadata:studentquiz_question:groupid'] = 'ID del grupo al que pertenece esa pregunta';
$string['privacy:metadata:studentquiz_question:hidden'] = 'Propiedad si es que la pregunta está oculta o no';
$string['privacy:metadata:studentquiz_question:pinned'] = 'Propiedad si es que la pregunta está fijada o no';
$string['privacy:metadata:studentquiz_question:state'] = 'Propiedad si es que la pregunta está aprobada, desaprobada, nueva o cambiada';
$string['privacy:metadata:studentquiz_question:studentquizid'] = 'ID del StudentQuiz.';
$string['privacy:metadata:studentquiz_rate'] = 'Almacena valoraciones para preguntas.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Valoración para la pregunta.';
$string['privacy:metadata:studentquiz_rate:studentquizquestionid'] = 'ID del studentquizquestion.';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID del usuario.';
$string['privacy:metadata:studentquiz_state_history:state'] = 'Propiedad si es que la pregunta está aprobada, desaprobada, nueva o cambiada';
$string['privacy:metadata:studentquiz_state_history:studentquizquestionid'] = 'ID del studentquizquestion.';
$string['privacy:metadata:studentquiz_state_history:timecreated'] = 'Hora para crear acción';
$string['privacy:metadata:studentquiz_state_history:userid'] = 'ID del usuario.';
$string['private'] = 'Privado';
$string['privatecomments'] = 'Comentarios privados';
$string['progress_bar_caption'] = 'Su progreso en la actividad ExamenEstudiante (StudentQuiz)';
$string['public'] = 'Público';
$string['publiccomments'] = 'Comentarios públicos';
$string['questionchangedlowercase'] = 'cambiado';
$string['questionsinuse'] = '(* Las preguntas marcadas con un asterisco ya están en uso en algunos exámenes.)';
$string['ranking_block_title'] = 'Ranking';
$string['ranking_block_title_anonymised'] = 'Ranking (anonimizado)';
$string['rate_all_column_name'] = 'Valoración de Comunidad';
$string['rate_column_name'] = 'Valoración';
$string['rate_error'] = 'Por favor valore';
$string['rate_help'] = 'Valore esta pregunta';
$string['rate_help_help'] = 'Valore esta pregunta. \\n 1 estrella es muy mala y 5 estrellas es muy buena';
$string['rate_multi_stars_desc'] = '{$a} estrellas seleccionada';
$string['rate_one_star_desc'] = '1 estrella seleccionada';
$string['rate_points'] = 'Puntos';
$string['rate_title'] = 'Valorar';
$string['ratingbar_title'] = 'Barra de valoración';
$string['remove_comment'] = 'Quitar';
$string['remove_comment_label'] = 'Quitar comentario';
$string['replies'] = 'Respuestas';
$string['reply'] = 'Respuesta';
$string['replycomment'] = 'Respuesta';
$string['report_comment_condition1'] = 'Es abusivo';
$string['report_comment_condition2'] = 'Es acoso';
$string['report_comment_condition3'] = 'Contiene contenido obsceno, como  por ejemplo pornografía';
$string['report_comment_condition4'] = 'Es calumnioso o difamatorio';
$string['report_comment_condition5'] = 'Viola el derecho de autor (copyright)';
$string['report_comment_condition6'] = 'Está en contra de las reglas por alguna otra razón';
$string['report_comment_condition_more'] = 'Otra información (opcional)';
$string['report_comment_emailappendix'] = 'Usted está recibiendo este Email porque su dirección Email ha sido usada en el StudentQuiz para reportar un comentario inaceptable.';
$string['report_comment_emailsubject'] = 'Reportar comentario {$a->commentid}: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'Su reporte ha sido enviado exitosamente. Un miembro del personal investigará este asunto.';
$string['report_comment_info'] = 'La característica de \'Reporte\' puede enviar este comentario a un miembro del personal que lo investigará. <strong>Por favor solamente use esta característica si Usted piensa que el comentario infringe las reglas</strong>.';
$string['report_comment_invalid'] = 'Usted necesita especificar la razón para reportar este comentario.';
$string['report_comment_invalid_checkbox'] = 'Usted necesita seleccionar al menos una de las casillas.';
$string['report_comment_link_text'] = 'Previsualizar aquí';
$string['report_comment_not_available'] = 'La función para reportar comentario no está disponible.';
$string['report_comment_pagename'] = 'Reportar un comentario como inaceptable';
$string['report_comment_reasons'] = 'Razones para reportar el comentario :';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Detalles de quien reporta</strong>:';
$string['report_comment_submit'] = 'Enviar informe';
$string['reportcomment'] = 'Informe';
$string['reportcomment_title'] = 'Reportar comentario como inaceptable';
$string['reportquiz_admin_title'] = 'Estadísticas del estudiante';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Promedio de comunidad de últimas respuestas correctas';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Promedio de comunidad de últimas respuestas incorrectas';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Porcentaje de comunidad de respuestas correctas';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Suma de respuestas correctas / suma de todas las respuestas.';
$string['reportquiz_stats_all_progress'] = 'Promedio del Progreso de la Comunidad';
$string['reportquiz_stats_all_progress_help'] = 'Promedio del Progreso de la Comunidad basado en todos los miembros de la comunidad.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Promedio de la comunidad de respuestas correctas';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Promedio de la comunidad de respuestas incorrectas';
$string['reportquiz_stats_all_questions_answered'] = 'Promedio de la comunidad de todas las respuestas';
$string['reportquiz_stats_all_questions_answered_help'] = 'Número promedio de respuestas dadas por todos los miembros de la comunidad.';
$string['reportquiz_stats_all_questions_approved'] = 'Número de preguntas aprobadas';
$string['reportquiz_stats_all_questions_approved_help'] = 'Los profesores pueden aprobar las preguntas para verificar que sean correctas. Este es el número de todas las preguntas aprobadas dentro de este ExamenEstudiante (StudentQuiz).';
$string['reportquiz_stats_all_questions_created'] = 'Número de preguntas en este ExamenEstudiante (StudentQuiz)';
$string['reportquiz_stats_all_questions_created_help'] = 'Número de preguntas creadas por la comunidad';
$string['reportquiz_stats_all_rates_average'] = 'Valoración promedio de todas las preguntas';
$string['reportquiz_stats_all_rates_average_help'] = 'La valoración de cada pregunta es el promedio de estrellas que recibió de la comunidad. Ejemplo: La comunidad creó 4 preguntas. Si la pregunta A fue valorada con 3 estrellas por la comunidad, pregunta B = 4 estrellas, pregunta C = 2 estrellas y pregunta D = 5 estrellas, entonces la  valoración promedio de todas las preguntas es 3.5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Número de sus últimas respuestas correctas';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Número de sus últimas respuestas incorrectas';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Porcentaje de sus respuestas correctas';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Porcentaje de todas sus respuestas correctas del conjunto de todas sus respuestas dadas en este ExamenEstudiante (StudentQuiz). Las parcialmente correctas cuentan como respuestas incorrectas.';
$string['reportquiz_stats_own_progress'] = 'Progreso Personal';
$string['reportquiz_stats_own_progress_help'] = 'Porcentaje de sus últimas respuestas correctas del conjunto de todas sus preguntas dentro de este ExamenEstudiante (StudentQuiz). Las respuestas parcialmente correctas cuentan como respuestas incorrectas.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Total de sus respuestas correctas';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Total de sus respuestas incorrectas';
$string['reportquiz_stats_own_questions_answered'] = 'Total de todas sus respuestas';
$string['reportquiz_stats_own_questions_answered_help'] = 'Número de todas sus respuestas dadas dentro de este ExamenEstudiante (StudentQuiz).';
$string['reportquiz_stats_own_questions_approved'] = 'Número de sus preguntas aprobadas';
$string['reportquiz_stats_own_questions_approved_help'] = 'Los profesores pueden aprobar manualmente las preguntas para verificar que sean correctas. Este es el número de sus preguntas aprobadas dentro de este ExamenEstudiante (StudentQuiz).';
$string['reportquiz_stats_own_questions_created'] = 'Número de preguntas a las que ha contribuido';
$string['reportquiz_stats_own_questions_created_help'] = 'Número de preguntas a las que ha contribuido a este ExamenEstudiante (StudentQuiz).';
$string['reportquiz_stats_own_rates_average'] = 'Su promedio de valoración recibido';
$string['reportquiz_stats_own_rates_average_help'] = 'La valoración de cada pregunta es el promedio de estrellas que recibió de la comunidad. Ejemplo: Usted creó las preguntas A y B. Si su pregunta A fue valorada con 3 estrellas por la comunidad y su pregunta B fue valorada con 4 estrellas, entonces recibió una valoración promedio de 3.5.';
$string['reportquiz_stats_title'] = 'Estadísticas';
$string['reportquiz_total_attempt'] = 'Veces que los usuarios ejecutaron el examen';
$string['reportquiz_total_obtained_marks'] = 'Calificación Total';
$string['reportquiz_total_questions_answered'] = 'Total de respuestas';
$string['reportquiz_total_questions_right'] = 'Total de respuestas correctas';
$string['reportquiz_total_questions_wrong'] = 'Respuestas incorrectas';
$string['reportquiz_total_users'] = 'Número de participantes';
$string['reportrank_table_column_approvedquestions'] = 'Puntos por preguntas aprobadas';
$string['reportrank_table_column_communitystatus'] = 'Estadísticas de la Comunidad';
$string['reportrank_table_column_correctanswers'] = 'Respuestas correctas';
$string['reportrank_table_column_countquestions'] = 'Puntos por preguntas creadas';
$string['reportrank_table_column_description'] = 'Descripción';
$string['reportrank_table_column_factor'] = 'Factor';
$string['reportrank_table_column_fullname'] = 'Nombre completo';
$string['reportrank_table_column_incorrectanswers'] = 'Respuestas Incorrectas';
$string['reportrank_table_column_lastcorrectanswers'] = 'Puntos por últimos intentos correctos';
$string['reportrank_table_column_lastincorrectanswers'] = 'Puntos por últimos intentos incorrectos';
$string['reportrank_table_column_points'] = 'Puntos';
$string['reportrank_table_column_progress'] = 'Progreso personal';
$string['reportrank_table_column_quantifier_name'] = 'Nombre';
$string['reportrank_table_column_rank'] = 'Ranking';
$string['reportrank_table_column_summeanrates'] = 'Puntos por estrellas recibidas';
$string['reportrank_table_column_total_points'] = 'Puntos Totales';
$string['reportrank_table_column_value'] = 'Valor';
$string['reportrank_table_column_yourstatus'] = 'Estadísticas Personales';
$string['reportrank_table_quantifier_caption'] = 'Cómo se calculan sus puntos';
$string['reportrank_table_title'] = 'Ranking de estudiantes - 10 Primeros';
$string['reportrank_table_title_for_manager'] = 'Ranking de estudiantes';
$string['reportrank_title'] = 'Ranking';
$string['review_button'] = 'Revisar';
$string['savechanges'] = 'Guardar cambios';
$string['scheduled_task_send_digest_notification'] = 'Enviar notificación de resumen';
$string['setting_question_publishing'] = 'Publicación de pregunta';
$string['setting_question_publishing_automatic'] = 'Publicar automáticamente nuevas preguntas';
$string['setting_question_publishing_help'] = 'Las preguntas publicadas aparecen en el lote de preguntas para que otros estudiantes las tomen. Ya sea que Usted permita que todas las preguntas sean publicadas automáticamente, o requerir aprobación antes de que sean publicadas.<br> Tenga en cuenta que esta configuración solamente aplica para las preguntas recientemente creadas.';
$string['setting_question_publishing_require_approval'] = 'Requerir aprobación antes de publicarla';
$string['settings_allowallqtypes'] = 'Permitir todos los tipos de preguntas';
$string['settings_allowedqtypes'] = 'Tipos de preguntas permitidas';
$string['settings_allowedqtypes_help'] = 'Aquí especifica el tipo de preguntas que están permitidas';
$string['settings_allowedrolestoshow'] = 'Excluir roles que pueden ser cambiados en cada actividad';
$string['settings_anonymous'] = 'Anonimizador de estudiantes';
$string['settings_anonymous_help'] = 'Los estudiantes no pueden ver los nombres de otros.';
$string['settings_anonymous_label'] = 'Hacer anónimos a los estudiantes';
$string['settings_approvedquantifier'] = 'Factor de pregunta aprobada';
$string['settings_approvedquantifier_help'] = 'Puntos para cada pregunta aprobada';
$string['settings_approvedquantifier_label'] = 'Puntos para cada pregunta aprobada';
$string['settings_availability_close_answering_from'] = 'Cerrada para respuestas a partir de';
$string['settings_availability_close_submission_from'] = 'Cerrado para envío de preguntas a partir de';
$string['settings_availability_open_answering_from'] = 'Abierto para contestar desde';
$string['settings_availability_open_submission_from'] = 'Abierto para envío de preguntas desde';
$string['settings_comment_editor_toolbar'] = 'Configuración de barra de herramientas del editor del comentario';
$string['settings_comment_editor_toolbar_des'] = 'La lista de plugins y el orden en el que son mostrados pueden ser configurados aquí';
$string['settings_commentdeletionperiod'] = 'Período para eliminación/edición del comentario (minutos)';
$string['settings_commentdeletionperiod_help'] = 'Configurar el período de tiempo (en minutos) que el botón para Editar/Eliminar estará disponible para que los estudiantes puedan editar/eliminar sus propios comentarios (o sus respuestas a un comentario) una vez que sea publicado. Los valores entre 0 y 60 minutos están permitidos. Si el período de eliminación se configura a 0, los estudiantes no podrán editar/eliminar sus propios comentarios. Tenga en cuenta que los profesores y los administradores siempre podrán editar/eliminar comentarios de los estudiantes, y también podrán ver el contenido de los comentarios eliminados.';
$string['settings_email_digest_first_day'] = '¿Primer día de la semana?';
$string['settings_email_digest_first_day_help'] = 'Si Usted ha seleccionado un resumen semanal, esta opción le permite definir el primer día (comenzando a las 00h:00m:00s de ese día) del periodo de siete días. Esto es especialmente útil si la actividad inicia a media-semana, por ejemplo.';
$string['settings_email_digest_type'] = 'Tipo de resumen de Email';
$string['settings_email_digest_type_daily_digest'] = 'Resumen diario';
$string['settings_email_digest_type_help'] = 'StudentQuiz  tiene varias notificaciones que Usted puede habilitar, tal como informarle al estudiante autor de la pregunta acerca de un cambio de estado (por ejemplo, que un profesor ha aprobado una de sus preguntas). Usted puede usar esta configuración para especificar la frecuencia de estas notificaciones. Los Emails resumidos solamente serán enviados cuando haya al menos una notificación en el periodo configurado.';
$string['settings_email_digest_type_no_digest'] = 'Sin resumen (un Email por acción)';
$string['settings_email_digest_type_weekly_digest'] = 'Resumen semanal';
$string['settings_excluderoles'] = 'Roles predeterminados a excluir en rankings';
$string['settings_excluderoles_help'] = 'En cada StudentQuiz, el profesor puede controlar cuales roles están excluidos de los rankings. LA lista de roles configurados aquí es la predeterminada usada por cualquier nuevo StudentQuiz creado.';
$string['settings_excluderoles_label'] = 'roles en ranking a excluir';
$string['settings_forcecommenting'] = 'Imponer comentarios';
$string['settings_forcecommenting_help'] = 'Imponer comentarios en el intento de pregunta';
$string['settings_forcerating'] = 'Imponer valoración';
$string['settings_forcerating_help'] = 'Imponer valoraciones en el intento de pregunta';
$string['settings_lastcorrectanswerquantifier'] = 'Factor de última respuesta correcta';
$string['settings_lastcorrectanswerquantifier_help'] = 'Puntos por cada respuesta correcta en el último intento';
$string['settings_lastcorrectanswerquantifier_label'] = 'Puntos por últimas respuestas correctas';
$string['settings_lastincorrectanswerquantifier'] = 'Factor de última respuesta incorrecta';
$string['settings_lastincorrectanswerquantifier_help'] = 'Puntos para cada respuesta incorrecta o parcialmente incorrecta en el último intento';
$string['settings_lastincorrectanswerquantifier_label'] = 'Puntos para últimas respuestas incorrectas';
$string['settings_notification'] = 'Configuraciones de la notificación';
$string['settings_privatecomment'] = 'Explicación de comentario privado';
$string['settings_privatecomment_help'] = 'Usted puede complementar aquí el texto explicatorio, dependiendo de cómo su organización usa las discusiones entre un estudiante y s asesor/profesor/administrador de actividad.';
$string['settings_privatecommenting'] = 'Habilitar comentario privado';
$string['settings_questionquantifier'] = 'Factor de pregunta creada';
$string['settings_questionquantifier_help'] = 'Puntos para cada pregunta creada';
$string['settings_questionquantifier_label'] = 'Puntos para cada pregunta creada';
$string['settings_ratequantifier'] = 'Factor de valoración';
$string['settings_ratequantifier_help'] = 'Puntos por cada estrella recibida.';
$string['settings_ratequantifier_label'] = 'Multiplicador para el promedio de estrellas recibidas para una pregunta';
$string['settings_removeqbehavior'] = 'Quitar plugin de comportamiento de pregunta ExamenEstudiante (StudentQuiz)';
$string['settings_removeqbehavior_help'] = 'Esta información debería de aparecer solamente una vez durante la actualización. Nosotros le informamos de que hemos detectado que su plugin de comportamiento de pregunta ExamenEstudiante (StudentQuiz) está instalado. Este plugin ya no es necesario, por lo que trataremos de eliminarlo automáticamente. Si todavía ve esta configuración, por favor desinstale manualmente el plugin de comportamiento de pregunta ExamenEstudiante (StudentQuiz) <a href="{$a}">aquí</a>.';
$string['settings_removeqbehavior_label'] = 'Quitar plugin de comportamiento de pregunta ExamenEstudiante (StudentQuiz)';
$string['settings_reportingemail'] = 'Correo electrónico para reportar comentarios ofensivos';
$string['settings_section_description_default'] = 'Estos valores definen los valores predeterminados cuando se crea una nueva actividad Studentquiz.';
$string['settings_section_header_comment_rating'] = 'Configuraciones de comentarios y valoraciones';
$string['settings_section_header_commenting'] = 'Configuraciones de comentarios';
$string['settings_section_header_question'] = 'Configuraciones de pregunta';
$string['settings_section_header_ranking'] = 'Configuraciones de ranking';
$string['settings_showprivatecomment'] = 'Habilitar discusión de comentario privado';
$string['settings_showprivatecomment_help'] = 'Esta opción habilita discusión avanzada entre un estudiante y su tutor (los nombres pueden variar dependiendo de la organización) en la Previsualización de pregunta.';
$string['settingsdeleteorphaned'] = 'Eliminar preguntas huérfanas';
$string['settingsdeleteorphaned_help'] = 'Activa un trabajo agendado que se ejecutará cada día para eliminar todas las preguntas huérfanas/no aprobadas de la base de datos.';
$string['settingsdeleteorphanedtime1y'] = '1 año';
$string['settingsdeleteorphanedtime2y'] = '2 años';
$string['settingsdeleteorphanedtime3y'] = '3 años';
$string['settingsdeleteorphanedtime6m'] = '6 meses';
$string['settingsdeleteorphanedtimelimit'] = 'Umbral de tiempo de eliminación de preguntas huérfanas';
$string['settingsdeleteorphanedtimelimit_help'] = 'Configurar el umbral de tiempo para la eliminación de preguntas huérfanas/no aprobadas. Las preguntas que sean más antiguas serán eliminadas.';
$string['show_less'] = 'Mostrar menos';
$string['show_more'] = 'Mostrar más';
$string['slot_of_slot'] = 'Pregunta {$a->slot} de {$a->slots} en este lote';
$string['start_quiz_button'] = 'Iniciar Examen';
$string['state_approved'] = 'Aprobadas';
$string['state_approvedlowercase'] = 'aprobada';
$string['state_approvedplural'] = 'Aprobada';
$string['state_change_tooltip_approved'] = 'La pregunta está aprobada. Haga clic aquí para cambiar el estado de esta pregunta';
$string['state_change_tooltip_changed'] = 'La pregunta está cambiada. Haga clic aquí para cambiar el estado de esta pregunta';
$string['state_change_tooltip_disapproved'] = 'La pregunta está des-aprobada. Haga clic aquí para cambiar el estado de esta pregunta';
$string['state_change_tooltip_new'] = 'La pregunta es nueva. Haga clic aquí para cambiar el estado de esta pregunta';
$string['state_change_tooltip_reviewable'] = 'La pregunta se puede revisar. Haga clic aquí para cambiar el estado de esta pregunta.';
$string['state_changed'] = 'Cambiadas';
$string['state_changedlowercase'] = 'cambiada';
$string['state_changedplural'] = 'Cambiada';
$string['state_column_name'] = 'Estado';
$string['state_column_name_veryshort'] = 'E';
$string['state_deleted'] = 'Eliminada';
$string['state_deletedlowercase'] = 'eliminada';
$string['state_deletedplural'] = 'Eliminada';
$string['state_disapproved'] = 'Rechazadas';
$string['state_disapprovedlowercase'] = 'desaprobada';
$string['state_disapprovedplural'] = 'Desaprobada';
$string['state_hidden'] = 'Oculta';
$string['state_hiddenlowercase'] = 'oculta';
$string['state_hiddenplural'] = 'Oculta';
$string['state_new'] = 'Nuevas';
$string['state_newplural'] = 'Nueva';
$string['state_pinned'] = 'Fijada';
$string['state_pinnedplural'] = 'Fijada';
$string['state_reviewable'] = 'Revisable';
$string['state_reviewablelowercase'] = 'revisable';
$string['state_reviewableplural'] = 'Revisable';
$string['state_shown'] = 'Mostrada';
$string['state_shownlowercase'] = 'mostrada';
$string['state_shownplural'] = 'Mostrada';
$string['state_toggle'] = 'Cambiar estado';
$string['statehistory'] = 'Historia del Estado';
$string['statistic_block_approvals'] = 'Preguntas aprobadas';
$string['statistic_block_created'] = 'Preguntas creadas';
$string['statistic_block_disapprovals'] = 'Preguntas rechazadas';
$string['statistic_block_new_changed'] = 'Preguntas nuevas/cambiadas';
$string['statistic_block_progress_available'] = 'Preguntas disponibles';
$string['statistic_block_progress_last_attempt_correct'] = 'Correctas último intento';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Incorrectas último intento';
$string['statistic_block_progress_never'] = 'Preguntas nunca contestadas';
$string['statistic_block_title'] = 'Mi Progreso';
$string['studentquiz'] = 'examenestudiante (studentquiz)';
$string['studentquiz:addinstance'] = 'Añadir nueva instancia para ExamenEstudiante (StudentQuiz)';
$string['studentquiz:cancommentprivately'] = 'Comentar en privado en cualquier pregunta';
$string['studentquiz:canselfcommentprivately'] = 'Comentar en privado en preguntas propias';
$string['studentquiz:canselfratecomment'] = 'Valorar y comentar públicamente preguntas propias en previsualización';
$string['studentquiz:changestate'] = 'Configurar el estado de una  pregunta en StudentQuiz';
$string['studentquiz:emailnotifyapproved'] = 'Notificación de aprobación de pregunta';
$string['studentquiz:emailnotifychanged'] = 'Notificación de cambio de pregunta';
$string['studentquiz:emailnotifycommentadded'] = 'Notificación de adición de comentario';
$string['studentquiz:emailnotifycommentdeleted'] = 'Notificación de eliminación de comentario';
$string['studentquiz:emailnotifyquestion'] = 'Usuario recibe notificación por Email del cambio de estado de sus preguntas';
$string['studentquiz:emailnotifyreviewablequestion'] = 'El usuario recibe una notificación por Email cuando el estudiante cambia el estado de sus preguntas a revisable';
$string['studentquiz:manage'] = 'Moderar preguntas en ExamenEstudiante (StudentQuiz)';
$string['studentquiz:organize'] = 'Mover preguntas dentro de categorías en StudentQuiz';
$string['studentquiz:pinquestion'] = 'Fijar preguntas en StudentQuiz';
$string['studentquiz:preview'] = 'Previsualizar preguntas';
$string['studentquiz:previewothers'] = 'Previsualizar preguntas de otros en ExamenEstudiante (StudentQuiz)';
$string['studentquiz:submit'] = 'Enviar preguntas en ExamenEstudiante (StudentQuiz)';
$string['studentquiz:systemnotifytaskdeleteorphanedquestions'] = 'Notificación de preguntas huérfanas eliminadas';
$string['studentquiz:unhideanonymous'] = 'Puede ver nombres reales aun y cuando el anonimizador esté activo';
$string['studentquiz:view'] = 'Ver preguntas en ExamenEstudiante (StudentQuiz)';
$string['studentquizname'] = 'Nombre del ExamenEstudiante (StudentQuiz)';
$string['studentquizname_help'] = 'Nombre de este ExamenEstudiante (StudentQuiz)';
$string['submissionendbeforestart'] = 'La fecha límite para envíos no puede estar especificada anterior a la fecha  de apertura para envíos';
$string['tags'] = 'Marcas';
$string['unapprove'] = 'Desaprobar';
$string['unpin'] = 'Des-fijar pregunta';
$string['visiblegroupnotyetsupport'] = '\'Grupos visibles\' aun no está soportado. Por favor elija otro modo de grupo.';
$string['weekly'] = 'semanalmente';
